/* valaenum.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALA_VALAENUM_H__
#define __VALA_VALAENUM_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee/collection.h>
#include <vala/valadatatype.h>
#include <vala/valacodenode.h>

G_BEGIN_DECLS


#define VALA_TYPE_ENUM (vala_enum_get_type ())
#define VALA_ENUM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ENUM, ValaEnum))
#define VALA_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ENUM, ValaEnumClass))
#define VALA_IS_ENUM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ENUM))
#define VALA_IS_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ENUM))
#define VALA_ENUM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ENUM, ValaEnumClass))

typedef struct _ValaEnumPrivate ValaEnumPrivate;

/**
 * Represents an enum declaration in the source code.
 */
struct _ValaEnum {
	ValaDataType parent;
	ValaEnumPrivate * priv;
};
struct _ValaEnumClass {
	ValaDataTypeClass parent;
};

ValaEnum* vala_enum_new (const char* name, ValaSourceReference* source_reference);
void vala_enum_add_value (ValaEnum* self, ValaEnumValue* value);
void vala_enum_add_method (ValaEnum* self, ValaMethod* m);
GeeCollection* vala_enum_get_methods (ValaEnum* self);
char* vala_enum_get_cprefix (ValaEnum* self);
void vala_enum_set_cprefix (ValaEnum* self, const char* cprefix);
void vala_enum_process_attributes (ValaEnum* self);
gboolean vala_enum_get_error_domain (ValaEnum* self);
void vala_enum_set_error_domain (ValaEnum* self, gboolean value);
GType vala_enum_get_type (void);

G_END_DECLS

#endif
