/* valaobjectcreationexpression.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALA_VALAOBJECTCREATIONEXPRESSION_H__
#define __VALA_VALAOBJECTCREATIONEXPRESSION_H__

#include <glib.h>
#include <glib-object.h>
#include <gee/collection.h>
#include <vala/valaexpression.h>
#include <vala/valacodenode.h>

G_BEGIN_DECLS


#define VALA_TYPE_OBJECT_CREATION_EXPRESSION (vala_object_creation_expression_get_type ())
#define VALA_OBJECT_CREATION_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_OBJECT_CREATION_EXPRESSION, ValaObjectCreationExpression))
#define VALA_OBJECT_CREATION_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_OBJECT_CREATION_EXPRESSION, ValaObjectCreationExpressionClass))
#define VALA_IS_OBJECT_CREATION_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_OBJECT_CREATION_EXPRESSION))
#define VALA_IS_OBJECT_CREATION_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_OBJECT_CREATION_EXPRESSION))
#define VALA_OBJECT_CREATION_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_OBJECT_CREATION_EXPRESSION, ValaObjectCreationExpressionClass))

typedef struct _ValaObjectCreationExpressionPrivate ValaObjectCreationExpressionPrivate;

/**
 * Represents an object creation expression in the source code.
 */
struct _ValaObjectCreationExpression {
	ValaExpression parent;
	ValaObjectCreationExpressionPrivate * priv;
};
struct _ValaObjectCreationExpressionClass {
	ValaExpressionClass parent;
};

ValaObjectCreationExpression* vala_object_creation_expression_new (ValaMemberAccess* member_name, ValaSourceReference* source_reference);
void vala_object_creation_expression_add_argument (ValaObjectCreationExpression* self, ValaExpression* arg);
GeeCollection* vala_object_creation_expression_get_argument_list (ValaObjectCreationExpression* self);
void vala_object_creation_expression_add_member_initializer (ValaObjectCreationExpression* self, ValaMemberInitializer* init);
GeeCollection* vala_object_creation_expression_get_object_initializer (ValaObjectCreationExpression* self);
ValaTypeReference* vala_object_creation_expression_get_type_reference (ValaObjectCreationExpression* self);
void vala_object_creation_expression_set_type_reference (ValaObjectCreationExpression* self, ValaTypeReference* value);
ValaMethod* vala_object_creation_expression_get_constructor (ValaObjectCreationExpression* self);
void vala_object_creation_expression_set_constructor (ValaObjectCreationExpression* self, ValaMethod* value);
ValaMemberAccess* vala_object_creation_expression_get_member_name (ValaObjectCreationExpression* self);
void vala_object_creation_expression_set_member_name (ValaObjectCreationExpression* self, ValaMemberAccess* value);
GType vala_object_creation_expression_get_type (void);

G_END_DECLS

#endif
