/* valasizeofexpression.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

using GLib;

/**
 * Represents a sizeof expression in the source code.
 */
public class Vala.SizeofExpression : Expression {
	/**
	 * The type whose size to be retrieved.
	 */
	public TypeReference! type_reference { get; set construct; }

	/**
	 * Creates a new sizeof expression.
	 *
	 * @param type   a data type
	 * @param source reference to source code
	 * @return       newly created sizeof expression
	 */
	public SizeofExpression (TypeReference! type, SourceReference source) {
		type_reference = type;
		source_reference = source;
	}
	
	public override void accept (CodeVisitor! visitor) {
		type_reference.accept (visitor);
	
		visitor.visit_sizeof_expression (this);
	}
}
