/* libgnome-2.0.vapi generated by lt-vapigen, do not modify. */

[CCode (cprefix = "Gnome", lower_case_cprefix = "gnome_")]
namespace Gnome {
	[CCode (cprefix = "GNOME_FILE_DOMAIN_", cheader_filename = "libgnome/libgnome.h")]
	public enum FileDomain {
		UNKNOWN,
		LIBDIR,
		DATADIR,
		SOUND,
		PIXMAP,
		CONFIG,
		HELP,
		APP_LIBDIR,
		APP_DATADIR,
		APP_SOUND,
		APP_PIXMAP,
		APP_CONFIG,
		APP_HELP,
	}
	[CCode (cprefix = "GNOME_HELP_ERROR_", cheader_filename = "libgnome/libgnome.h")]
	public enum HelpError {
		INTERNAL,
		NOT_FOUND,
	}
	[CCode (cprefix = "GTRIG_", cheader_filename = "libgnome/libgnome.h")]
	public enum TriggerType {
		NONE,
		FUNCTION,
		COMMAND,
		MEDIAPLAY,
	}
	[CCode (cprefix = "GNOME_URL_ERROR_", cheader_filename = "libgnome/libgnome.h")]
	public enum URLError {
		PARSE,
		LAUNCH,
		URL,
		NO_DEFAULT,
		NOT_SUPPORTED,
		VFS,
		CANCELLED,
	}
	[CCode (cheader_filename = "libgnome/libgnome.h")]
	public class Program : GLib.Object {
		public static weak Gnome.Program get ();
		public weak string get_app_id ();
		public weak string get_app_version ();
		public weak string get_human_readable_name ();
		public static GLib.Type get_type ();
		[NoArrayLength]
		public static weak Gnome.Program init (string app_id, string app_version, Gnome.ModuleInfo module_info, int argc, string[] argv, ...);
		[NoArrayLength]
		public static weak Gnome.Program init_paramv (GLib.Type type, string app_id, string app_version, Gnome.ModuleInfo module_info, int argc, string[] argv, uint nparams, out GLib.Parameter params);
		[NoArrayLength]
		public static weak Gnome.Program initv (GLib.Type type, string app_id, string app_version, Gnome.ModuleInfo module_info, int argc, string[] argv, string first_property_name, pointer args);
		public static uint install_property (pointer pclass, GLib.ObjectGetPropertyFunc get_fn, GLib.ObjectSetPropertyFunc set_fn, GLib.ParamSpec pspec);
		public weak string locate_file (Gnome.FileDomain domain, string file_name, bool only_if_exists, GLib.SList ret_locations);
		public static weak Gnome.ModuleInfo module_load (string mod_name);
		public static void module_register (Gnome.ModuleInfo module_info);
		public static bool module_registered (Gnome.ModuleInfo module_info);
		[NoAccessorMethod]
		public weak pointer popt_table { construct; }
		[NoAccessorMethod]
		public weak int popt_flags { construct; }
		[NoAccessorMethod]
		public weak pointer popt_context { get; }
		[NoAccessorMethod]
		public weak pointer goption_context { get; construct; }
		[NoAccessorMethod]
		public weak string human_readable_name { get; construct; }
		[NoAccessorMethod]
		public weak string gnome_path { get; construct; }
		public weak string app_id { get; }
		public weak string app_version { get; }
		[NoAccessorMethod]
		public weak string gnome_prefix { get; construct; }
		[NoAccessorMethod]
		public weak string gnome_libdir { get; construct; }
		[NoAccessorMethod]
		public weak string gnome_datadir { get; construct; }
		[NoAccessorMethod]
		public weak string gnome_sysconfdir { get; construct; }
		[NoAccessorMethod]
		public weak string app_prefix { get; set; }
		[NoAccessorMethod]
		public weak string app_libdir { get; set; }
		[NoAccessorMethod]
		public weak string app_datadir { get; set; }
		[NoAccessorMethod]
		public weak string app_sysconfdir { get; set; }
		[NoAccessorMethod]
		public weak bool create_directories { get; construct; }
		[NoAccessorMethod]
		public weak bool enable_sound { get; set; }
		[NoAccessorMethod]
		public weak string espeaker { get; set; }
	}
	[CCode (cheader_filename = "libgnome/libgnome.h")]
	public class ModuleInfo : GLib.Boxed {
		public weak string name;
		public weak string version;
		public weak string description;
		public weak Gnome.ModuleRequirement requirements;
		public Gnome.ModuleHook instance_init;
		public Gnome.ModuleHook pre_args_parse;
		public Gnome.ModuleHook post_args_parse;
		public pointer _options;
		public Gnome.ModuleInitHook init_pass;
		public Gnome.ModuleClassInitHook class_init;
		public weak string opt_prefix;
		public Gnome.ModuleGetGOptionGroupFunc get_goption_group_func;
		public static GLib.Type get_type ();
	}
	[CCode (cheader_filename = "libgnome/libgnome.h")]
	public class ModuleRequirement {
		public weak string required_version;
		public weak Gnome.ModuleInfo module_info;
	}
	[CCode (cheader_filename = "libgnome/libgnome.h")]
	public class Trigger {
		public Gnome.TriggerType type;
		public Gnome.TriggerActionFunction function;
		public weak string level;
	}
	[CCode (cheader_filename = "libgnome/libgnome.h")]
	public class TriggerList {
		public weak string nodename;
		public weak Gnome.TriggerList subtrees;
		public weak Gnome.Trigger actions;
		public int numsubtrees;
		public int numactions;
	}
	[CCode (cheader_filename = "libgnome/libgnome.h")]
	public class Config {
	}
	[CCode (cheader_filename = "libgnome/libgnome.h")]
	public class Gconf {
		public static weak string get_app_settings_relative (Gnome.Program program, string subkey);
		public static weak string get_gnome_libs_settings_relative (string subkey);
	}
	[CCode (cheader_filename = "libgnome/libgnome.h")]
	public class Help {
		public static bool display (string file_name, string link_id) throws GLib.Error;
		public static bool display_desktop (Gnome.Program program, string doc_id, string file_name, string link_id) throws GLib.Error;
		public static bool display_desktop_with_env (Gnome.Program program, string doc_id, string file_name, string link_id, out string envp) throws GLib.Error;
		public static bool display_uri (string help_uri) throws GLib.Error;
		public static bool display_uri_with_env (string help_uri, out string envp) throws GLib.Error;
		public static bool display_with_doc_id (Gnome.Program program, string doc_id, string file_name, string link_id) throws GLib.Error;
		public static bool display_with_doc_id_and_env (Gnome.Program program, string doc_id, string file_name, string link_id, out string envp) throws GLib.Error;
		public static GLib.Quark error_quark ();
	}
	[CCode (cheader_filename = "libgnome/libgnome.h")]
	public class Score {
	}
	[CCode (cheader_filename = "libgnome/libgnome.h")]
	public class Sound {
		public static int connection_get ();
		public static void init (string hostname);
		public static void play (string filename);
		public static int sample_load (string sample_name, string filename);
		public static void shutdown ();
	}
	[CCode (cheader_filename = "libgnome/libgnome.h")]
	public class Triggers {
		public static void add_trigger (Gnome.Trigger nt);
		public static void @do (string msg, string level);
		[NoArrayLength]
		public static void vadd_trigger (Gnome.Trigger nt, string[] supinfo);
		[NoArrayLength]
		public static void vdo (string msg, string level, string[] supinfo);
	}
	[CCode (cheader_filename = "libgnome/libgnome.h")]
	public class Url {
		public static GLib.Quark error_quark ();
		public static bool show (string url) throws GLib.Error;
		public static bool show_with_env (string url, out string envp) throws GLib.Error;
	}
	[CCode (cheader_filename = "libgnome/libgnome.h")]
	public class User {
		public static weak string accels_dir_get ();
		public static weak string dir_get ();
		public static weak string private_dir_get ();
	}
	public static delegate void ModuleClassInitHook (pointer klass, Gnome.ModuleInfo mod_info);
	public static delegate weak GLib.OptionGroup ModuleGetGOptionGroupFunc ();
	public static delegate void ModuleHook (Gnome.Program program, Gnome.ModuleInfo mod_info);
	public static delegate void ModuleInitHook (Gnome.ModuleInfo mod_info);
	public static delegate void TriggerActionFunction (string msg, string level, string[] supinfo);
	public static weak Gnome.ModuleInfo bonobo_module_info_get ();
	[NoArrayLength]
	public static int execute_async (string dir, int argc, string[] argv);
	[NoArrayLength]
	public static int execute_async_fds (string dir, int argc, string[] argv, bool close_fds);
	[NoArrayLength]
	public static int execute_async_with_env (string dir, int argc, string[] argv, int envc, string[] envv);
	[NoArrayLength]
	public static int execute_async_with_env_fds (string dir, int argc, string[] argv, int envc, string[] envv, bool close_fds);
	public static int execute_shell (string dir, string commandline);
	public static int execute_shell_fds (string dir, string commandline, bool close_fds);
	public static int execute_terminal_shell (string dir, string commandline);
	public static int execute_terminal_shell_fds (string dir, string commandline, bool close_fds);
	public static void prepend_terminal_to_vector (int argc, out string argv);
	public static weak string util_user_shell ();
}
