/* valaccodedeclaration.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __CCODE_VALACCODEDECLARATION_H__
#define __CCODE_VALACCODEDECLARATION_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <ccode/valaccodestatement.h>
#include <ccode/valaccodemodifiers.h>
#include <ccode/valaccodedeclarator.h>
#include <ccode/valaccodewriter.h>

G_BEGIN_DECLS


#define VALA_TYPE_CCODE_DECLARATION (vala_ccode_declaration_get_type ())
#define VALA_CCODE_DECLARATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_DECLARATION, ValaCCodeDeclaration))
#define VALA_CCODE_DECLARATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_DECLARATION, ValaCCodeDeclarationClass))
#define VALA_IS_CCODE_DECLARATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_DECLARATION))
#define VALA_IS_CCODE_DECLARATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_DECLARATION))
#define VALA_CCODE_DECLARATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_DECLARATION, ValaCCodeDeclarationClass))

typedef struct _ValaCCodeDeclaration ValaCCodeDeclaration;
typedef struct _ValaCCodeDeclarationClass ValaCCodeDeclarationClass;
typedef struct _ValaCCodeDeclarationPrivate ValaCCodeDeclarationPrivate;

/**
 * Represents a local variable declaration in the C code.
 */
struct _ValaCCodeDeclaration {
	ValaCCodeStatement parent;
	ValaCCodeDeclarationPrivate * priv;
};
struct _ValaCCodeDeclarationClass {
	ValaCCodeStatementClass parent;
};

ValaCCodeDeclaration* vala_ccode_declaration_new (const char* type_name);
void vala_ccode_declaration_add_declarator (ValaCCodeDeclaration* self, ValaCCodeDeclarator* decl);
char* vala_ccode_declaration_get_type_name (ValaCCodeDeclaration* self);
void vala_ccode_declaration_set_type_name (ValaCCodeDeclaration* self, const char* value);
ValaCCodeModifiers vala_ccode_declaration_get_modifiers (ValaCCodeDeclaration* self);
void vala_ccode_declaration_set_modifiers (ValaCCodeDeclaration* self, ValaCCodeModifiers value);
GType vala_ccode_declaration_get_type (void);

G_END_DECLS

#endif
