/* valaarray.vala
 *
 * Copyright (C) 2006-2007  Raffaele Sandrini, Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Raffaele Sandrini <rasa@gmx.ch>
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valaarray.h>
#include <vala/valatypeparameter.h>
#include <vala/valaarraylengthfield.h>
#include <vala/valaarrayresizemethod.h>
#include <vala/valasourcereference.h>
#include <vala/valasourcefile.h>
#include <vala/valacodecontext.h>
#include <vala/valasymbol.h>
#include <vala/valascope.h>
#include <vala/valanamespace.h>
#include <vala/valafield.h>
#include <vala/valatypereference.h>
#include <vala/valamethod.h>
#include <vala/valaformalparameter.h>
#include <vala/valareport.h>

struct _ValaArrayPrivate {
	ValaDataType* _element_type;
	ValaTypeParameter* _element_type_parameter;
	gint _rank;
	char* cname;
	ValaArrayLengthField* length_field;
	ValaArrayResizeMethod* resize_method;
	ValaArrayMoveMethod* move_method;
};
#define VALA_ARRAY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_ARRAY, ValaArrayPrivate))
enum  {
	VALA_ARRAY_DUMMY_PROPERTY,
	VALA_ARRAY_ELEMENT_TYPE,
	VALA_ARRAY_ELEMENT_TYPE_PARAMETER,
	VALA_ARRAY_RANK
};
static char* vala_array_real_get_cname (ValaDataType* base, gboolean const_type);
static gboolean vala_array_real_is_reference_type (ValaDataType* base);
static char* vala_array_real_get_upper_case_cname (ValaDataType* base, const char* infix);
static char* vala_array_real_get_lower_case_cname (ValaSymbol* base, const char* infix);
static char* vala_array_real_get_free_function (ValaDataType* base);
static GeeCollection* vala_array_real_get_cheader_filenames (ValaSymbol* base);
static char* vala_array_real_get_marshaller_type_name (ValaDataType* base);
static char* vala_array_real_get_get_value_function (ValaDataType* base);
static char* vala_array_real_get_set_value_function (ValaDataType* base);
static char* vala_array_real_get_type_id (ValaDataType* base);
static GObject * vala_array_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer vala_array_parent_class = NULL;
static void vala_array_dispose (GObject * obj);


ValaArray* vala_array_new (ValaDataType* _element_type, gint _rank, ValaSourceReference* _source_reference) {
	GParameter * __params;
	GParameter * __params_it;
	ValaArray * self;
	g_return_val_if_fail (VALA_IS_DATA_TYPE (_element_type), NULL);
	g_return_val_if_fail (_source_reference == NULL || VALA_IS_SOURCE_REFERENCE (_source_reference), NULL);
	__params = g_new0 (GParameter, 2);
	__params_it = __params;
	(__params_it->name = "rank", g_value_init (&__params_it->value, G_TYPE_INT), g_value_set_int (&__params_it->value, _rank), __params_it++);
	(__params_it->name = "element-type", g_value_init (&__params_it->value, VALA_TYPE_DATA_TYPE), g_value_set_object (&__params_it->value, _element_type), __params_it++);
	self = g_object_newv (VALA_TYPE_ARRAY, __params_it - __params, __params);
	vala_code_node_set_source_reference (VALA_CODE_NODE (self), _source_reference);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


ValaArray* vala_array_new_with_type_parameter (ValaTypeParameter* _element_type_parameter, gint _rank, ValaSourceReference* _source_reference) {
	GParameter * __params;
	GParameter * __params_it;
	ValaArray * self;
	g_return_val_if_fail (VALA_IS_TYPE_PARAMETER (_element_type_parameter), NULL);
	g_return_val_if_fail (_source_reference == NULL || VALA_IS_SOURCE_REFERENCE (_source_reference), NULL);
	__params = g_new0 (GParameter, 2);
	__params_it = __params;
	(__params_it->name = "rank", g_value_init (&__params_it->value, G_TYPE_INT), g_value_set_int (&__params_it->value, _rank), __params_it++);
	(__params_it->name = "element-type-parameter", g_value_init (&__params_it->value, VALA_TYPE_TYPE_PARAMETER), g_value_set_object (&__params_it->value, _element_type_parameter), __params_it++);
	self = g_object_newv (VALA_TYPE_ARRAY, __params_it - __params, __params);
	vala_code_node_set_source_reference (VALA_CODE_NODE (self), _source_reference);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


static char* vala_array_real_get_cname (ValaDataType* base, gboolean const_type) {
	ValaArray * self;
	const char* _tmp4;
	self = VALA_ARRAY (base);
	if (self->priv->cname == NULL) {
		if (vala_array_get_element_type (self) != NULL) {
			if (vala_data_type_is_reference_type (vala_array_get_element_type (self))) {
				char* _tmp1;
				char* _tmp0;
				_tmp1 = NULL;
				_tmp0 = NULL;
				self->priv->cname = (_tmp1 = g_strdup_printf ("%s*", (_tmp0 = vala_data_type_get_cname (vala_array_get_element_type (self), FALSE))), (self->priv->cname = (g_free (self->priv->cname), NULL)), _tmp1);
				(_tmp0 = (g_free (_tmp0), NULL));
			} else {
				char* _tmp2;
				_tmp2 = NULL;
				self->priv->cname = (_tmp2 = vala_data_type_get_cname (vala_array_get_element_type (self), FALSE), (self->priv->cname = (g_free (self->priv->cname), NULL)), _tmp2);
			}
		} else {
			char* _tmp3;
			_tmp3 = NULL;
			self->priv->cname = (_tmp3 = g_strdup ("gpointer"), (self->priv->cname = (g_free (self->priv->cname), NULL)), _tmp3);
		}
	}
	_tmp4 = NULL;
	return (_tmp4 = self->priv->cname, (_tmp4 == NULL ? NULL : g_strdup (_tmp4)));
}


static gboolean vala_array_real_is_reference_type (ValaDataType* base) {
	ValaArray * self;
	self = VALA_ARRAY (base);
	return TRUE;
}


static char* vala_array_real_get_upper_case_cname (ValaDataType* base, const char* infix) {
	ValaArray * self;
	self = VALA_ARRAY (base);
	return NULL;
}


static char* vala_array_real_get_lower_case_cname (ValaSymbol* base, const char* infix) {
	ValaArray * self;
	self = VALA_ARRAY (base);
	return NULL;
}


static char* vala_array_real_get_free_function (ValaDataType* base) {
	ValaArray * self;
	self = VALA_ARRAY (base);
	return g_strdup ("g_free");
}


static GeeCollection* vala_array_real_get_cheader_filenames (ValaSymbol* base) {
	ValaArray * self;
	self = VALA_ARRAY (base);
	if (vala_array_get_element_type (self) != NULL) {
		return vala_symbol_get_cheader_filenames (VALA_SYMBOL (vala_array_get_element_type (self)));
	} else {
		return VALA_SYMBOL_CLASS (vala_array_parent_class)->get_cheader_filenames (VALA_SYMBOL (VALA_DATA_TYPE (self)));
	}
}


static char* vala_array_real_get_marshaller_type_name (ValaDataType* base) {
	ValaArray * self;
	self = VALA_ARRAY (base);
	return g_strdup ("POINTER");
}


static char* vala_array_real_get_get_value_function (ValaDataType* base) {
	ValaArray * self;
	self = VALA_ARRAY (base);
	return g_strdup ("g_value_get_pointer");
}


static char* vala_array_real_get_set_value_function (ValaDataType* base) {
	ValaArray * self;
	self = VALA_ARRAY (base);
	return g_strdup ("g_value_set_pointer");
}


static char* vala_array_real_get_type_id (ValaDataType* base) {
	ValaArray * self;
	ValaSymbol* _tmp0;
	gboolean _tmp1;
	self = VALA_ARRAY (base);
	_tmp0 = NULL;
	if ((_tmp1 = VALA_SYMBOL (vala_array_get_element_type (self)) == (_tmp0 = vala_scope_lookup (vala_symbol_get_scope (VALA_SYMBOL (vala_code_context_get_root (vala_source_file_get_context (vala_source_reference_get_file (vala_code_node_get_source_reference (VALA_CODE_NODE (self))))))), "string")), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1)) {
		return g_strdup ("G_TYPE_STRV");
	} else {
		return NULL;
	}
}


ValaArrayLengthField* vala_array_get_length_field (ValaArray* self) {
	ValaArrayLengthField* _tmp3;
	g_return_val_if_fail (VALA_IS_ARRAY (self), NULL);
	if (self->priv->length_field == NULL) {
		ValaArrayLengthField* _tmp0;
		ValaNamespace* root_symbol;
		ValaTypeReference* _tmp1;
		ValaDataType* _tmp2;
		_tmp0 = NULL;
		self->priv->length_field = (_tmp0 = vala_array_length_field_new (vala_code_node_get_source_reference (VALA_CODE_NODE (self))), (self->priv->length_field == NULL ? NULL : (self->priv->length_field = (g_object_unref (self->priv->length_field), NULL))), _tmp0);
		vala_symbol_set_access (VALA_SYMBOL (self->priv->length_field), VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		root_symbol = g_object_ref (vala_code_context_get_root (vala_source_file_get_context (vala_source_reference_get_file (vala_code_node_get_source_reference (VALA_CODE_NODE (self))))));
		_tmp1 = NULL;
		vala_field_set_type_reference (VALA_FIELD (self->priv->length_field), (_tmp1 = vala_type_reference_new ()));
		(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
		_tmp2 = NULL;
		vala_type_reference_set_data_type (vala_field_get_type_reference (VALA_FIELD (self->priv->length_field)), (_tmp2 = VALA_DATA_TYPE (vala_scope_lookup (vala_symbol_get_scope (VALA_SYMBOL (root_symbol)), "int"))));
		(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
		(root_symbol = (g_object_unref (root_symbol), NULL));
	}
	_tmp3 = NULL;
	return (_tmp3 = self->priv->length_field, (_tmp3 == NULL ? NULL : g_object_ref (_tmp3)));
}


ValaArrayResizeMethod* vala_array_get_resize_method (ValaArray* self) {
	ValaArrayResizeMethod* _tmp4;
	g_return_val_if_fail (VALA_IS_ARRAY (self), NULL);
	if (self->priv->resize_method == NULL) {
		ValaArrayResizeMethod* _tmp0;
		ValaTypeReference* _tmp1;
		ValaNamespace* root_symbol;
		ValaTypeReference* int_type;
		ValaDataType* _tmp2;
		ValaFormalParameter* _tmp3;
		_tmp0 = NULL;
		self->priv->resize_method = (_tmp0 = vala_array_resize_method_new (vala_code_node_get_source_reference (VALA_CODE_NODE (self))), (self->priv->resize_method == NULL ? NULL : (self->priv->resize_method = (g_object_unref (self->priv->resize_method), NULL))), _tmp0);
		_tmp1 = NULL;
		vala_method_set_return_type (VALA_METHOD (self->priv->resize_method), (_tmp1 = vala_type_reference_new ()));
		(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
		vala_symbol_set_access (VALA_SYMBOL (self->priv->resize_method), VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		vala_method_set_cname (VALA_METHOD (self->priv->resize_method), "g_renew");
		root_symbol = g_object_ref (vala_code_context_get_root (vala_source_file_get_context (vala_source_reference_get_file (vala_code_node_get_source_reference (VALA_CODE_NODE (self))))));
		int_type = vala_type_reference_new ();
		_tmp2 = NULL;
		vala_type_reference_set_data_type (int_type, (_tmp2 = VALA_DATA_TYPE (vala_scope_lookup (vala_symbol_get_scope (VALA_SYMBOL (root_symbol)), "int"))));
		(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
		_tmp3 = NULL;
		vala_method_add_parameter (VALA_METHOD (self->priv->resize_method), (_tmp3 = vala_formal_parameter_new ("length", int_type, NULL)));
		(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
		vala_method_set_returns_modified_pointer (VALA_METHOD (self->priv->resize_method), TRUE);
		(root_symbol = (g_object_unref (root_symbol), NULL));
		(int_type == NULL ? NULL : (int_type = (g_object_unref (int_type), NULL)));
	}
	_tmp4 = NULL;
	return (_tmp4 = self->priv->resize_method, (_tmp4 == NULL ? NULL : g_object_ref (_tmp4)));
}


ValaArrayMoveMethod* vala_array_get_move_method (ValaArray* self) {
	ValaArrayMoveMethod* _tmp6;
	g_return_val_if_fail (VALA_IS_ARRAY (self), NULL);
	if (self->priv->move_method == NULL) {
		ValaArrayMoveMethod* _tmp0;
		ValaTypeReference* _tmp1;
		ValaNamespace* root_symbol;
		ValaTypeReference* int_type;
		ValaDataType* _tmp2;
		ValaFormalParameter* _tmp3;
		ValaFormalParameter* _tmp4;
		ValaFormalParameter* _tmp5;
		_tmp0 = NULL;
		self->priv->move_method = (_tmp0 = vala_array_move_method_new (vala_code_node_get_source_reference (VALA_CODE_NODE (self))), (self->priv->move_method == NULL ? NULL : (self->priv->move_method = (g_object_unref (self->priv->move_method), NULL))), _tmp0);
		_tmp1 = NULL;
		vala_method_set_return_type (VALA_METHOD (self->priv->move_method), (_tmp1 = vala_type_reference_new ()));
		(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
		vala_symbol_set_access (VALA_SYMBOL (self->priv->move_method), VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		vala_method_set_cname (VALA_METHOD (self->priv->move_method), "_vala_array_move");
		root_symbol = g_object_ref (vala_code_context_get_root (vala_source_file_get_context (vala_source_reference_get_file (vala_code_node_get_source_reference (VALA_CODE_NODE (self))))));
		int_type = vala_type_reference_new ();
		_tmp2 = NULL;
		vala_type_reference_set_data_type (int_type, (_tmp2 = VALA_DATA_TYPE (vala_scope_lookup (vala_symbol_get_scope (VALA_SYMBOL (root_symbol)), "int"))));
		(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
		_tmp3 = NULL;
		vala_method_add_parameter (VALA_METHOD (self->priv->move_method), (_tmp3 = vala_formal_parameter_new ("src", int_type, NULL)));
		(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
		_tmp4 = NULL;
		vala_method_add_parameter (VALA_METHOD (self->priv->move_method), (_tmp4 = vala_formal_parameter_new ("dest", int_type, NULL)));
		(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
		_tmp5 = NULL;
		vala_method_add_parameter (VALA_METHOD (self->priv->move_method), (_tmp5 = vala_formal_parameter_new ("length", int_type, NULL)));
		(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
		(root_symbol = (g_object_unref (root_symbol), NULL));
		(int_type == NULL ? NULL : (int_type = (g_object_unref (int_type), NULL)));
	}
	_tmp6 = NULL;
	return (_tmp6 = self->priv->move_method, (_tmp6 == NULL ? NULL : g_object_ref (_tmp6)));
}


ValaDataType* vala_array_get_element_type (ValaArray* self) {
	g_return_val_if_fail (VALA_IS_ARRAY (self), NULL);
	return self->priv->_element_type;
}


void vala_array_set_element_type (ValaArray* self, ValaDataType* value) {
	g_return_if_fail (VALA_IS_ARRAY (self));
	self->priv->_element_type = value;
}


ValaTypeParameter* vala_array_get_element_type_parameter (ValaArray* self) {
	g_return_val_if_fail (VALA_IS_ARRAY (self), NULL);
	return self->priv->_element_type_parameter;
}


void vala_array_set_element_type_parameter (ValaArray* self, ValaTypeParameter* value) {
	g_return_if_fail (VALA_IS_ARRAY (self));
	self->priv->_element_type_parameter = value;
}


gint vala_array_get_rank (ValaArray* self) {
	g_return_val_if_fail (VALA_IS_ARRAY (self), 0);
	return self->priv->_rank;
}


void vala_array_set_rank (ValaArray* self, gint value) {
	g_return_if_fail (VALA_IS_ARRAY (self));
	self->priv->_rank = value;
}


static GObject * vala_array_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	ValaArrayClass * klass;
	GObjectClass * parent_class;
	ValaArray * self;
	klass = VALA_ARRAY_CLASS (g_type_class_peek (VALA_TYPE_ARRAY));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = VALA_ARRAY (obj);
	{
		gint i;
		char* _tmp3;
		/* FIXME: this implementation reveals compiler bugs 
		string commas = "";
		int i = rank - 1;
		
		while (i > 0) {
		string += ",";
		i--;
		}
		
		name = "%s[%s]".printf (element_type.name, commas); */
		if (vala_array_get_rank (self) < 1) {
			vala_report_error (NULL, "internal: attempt to create an array with rank smaller than 1");
		}
		i = vala_array_get_rank (self) - 1;
		if (vala_array_get_element_type (self) != NULL) {
			char* _tmp0;
			_tmp0 = NULL;
			vala_symbol_set_name (VALA_SYMBOL (self), (_tmp0 = g_strdup_printf ("%s[", vala_symbol_get_name (VALA_SYMBOL (vala_array_get_element_type (self))))));
			(_tmp0 = (g_free (_tmp0), NULL));
		} else {
			char* _tmp1;
			_tmp1 = NULL;
			vala_symbol_set_name (VALA_SYMBOL (self), (_tmp1 = g_strdup_printf ("%s[", vala_symbol_get_name (VALA_SYMBOL (vala_array_get_element_type_parameter (self))))));
			(_tmp1 = (g_free (_tmp1), NULL));
		}
		while (i > 0) {
			char* _tmp2;
			_tmp2 = NULL;
			vala_symbol_set_name (VALA_SYMBOL (self), (_tmp2 = g_strdup_printf ("%s,", vala_symbol_get_name (VALA_SYMBOL (self)))));
			(_tmp2 = (g_free (_tmp2), NULL));
			i--;
		}
		_tmp3 = NULL;
		vala_symbol_set_name (VALA_SYMBOL (self), (_tmp3 = g_strdup_printf ("%s]", vala_symbol_get_name (VALA_SYMBOL (self)))));
		(_tmp3 = (g_free (_tmp3), NULL));
	}
	return obj;
}


static void vala_array_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaArray * self;
	self = VALA_ARRAY (object);
	switch (property_id) {
		case VALA_ARRAY_ELEMENT_TYPE:
		g_value_set_object (value, vala_array_get_element_type (self));
		break;
		case VALA_ARRAY_ELEMENT_TYPE_PARAMETER:
		g_value_set_object (value, vala_array_get_element_type_parameter (self));
		break;
		case VALA_ARRAY_RANK:
		g_value_set_int (value, vala_array_get_rank (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_array_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaArray * self;
	self = VALA_ARRAY (object);
	switch (property_id) {
		case VALA_ARRAY_ELEMENT_TYPE:
		vala_array_set_element_type (self, g_value_get_object (value));
		break;
		case VALA_ARRAY_ELEMENT_TYPE_PARAMETER:
		vala_array_set_element_type_parameter (self, g_value_get_object (value));
		break;
		case VALA_ARRAY_RANK:
		vala_array_set_rank (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_array_class_init (ValaArrayClass * klass) {
	vala_array_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaArrayPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_array_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_array_set_property;
	G_OBJECT_CLASS (klass)->constructor = vala_array_constructor;
	G_OBJECT_CLASS (klass)->dispose = vala_array_dispose;
	VALA_DATA_TYPE_CLASS (klass)->get_cname = vala_array_real_get_cname;
	VALA_DATA_TYPE_CLASS (klass)->is_reference_type = vala_array_real_is_reference_type;
	VALA_DATA_TYPE_CLASS (klass)->get_upper_case_cname = vala_array_real_get_upper_case_cname;
	VALA_SYMBOL_CLASS (klass)->get_lower_case_cname = vala_array_real_get_lower_case_cname;
	VALA_DATA_TYPE_CLASS (klass)->get_free_function = vala_array_real_get_free_function;
	VALA_SYMBOL_CLASS (klass)->get_cheader_filenames = vala_array_real_get_cheader_filenames;
	VALA_DATA_TYPE_CLASS (klass)->get_marshaller_type_name = vala_array_real_get_marshaller_type_name;
	VALA_DATA_TYPE_CLASS (klass)->get_get_value_function = vala_array_real_get_get_value_function;
	VALA_DATA_TYPE_CLASS (klass)->get_set_value_function = vala_array_real_get_set_value_function;
	VALA_DATA_TYPE_CLASS (klass)->get_type_id = vala_array_real_get_type_id;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_ARRAY_ELEMENT_TYPE, g_param_spec_object ("element-type", "element-type", "element-type", VALA_TYPE_DATA_TYPE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_ARRAY_ELEMENT_TYPE_PARAMETER, g_param_spec_object ("element-type-parameter", "element-type-parameter", "element-type-parameter", VALA_TYPE_TYPE_PARAMETER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_ARRAY_RANK, g_param_spec_int ("rank", "rank", "rank", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void vala_array_init (ValaArray * self) {
	self->priv = VALA_ARRAY_GET_PRIVATE (self);
}


static void vala_array_dispose (GObject * obj) {
	ValaArray * self;
	self = VALA_ARRAY (obj);
	(self->priv->cname = (g_free (self->priv->cname), NULL));
	(self->priv->length_field == NULL ? NULL : (self->priv->length_field = (g_object_unref (self->priv->length_field), NULL)));
	(self->priv->resize_method == NULL ? NULL : (self->priv->resize_method = (g_object_unref (self->priv->resize_method), NULL)));
	(self->priv->move_method == NULL ? NULL : (self->priv->move_method = (g_object_unref (self->priv->move_method), NULL)));
	G_OBJECT_CLASS (vala_array_parent_class)->dispose (obj);
}


GType vala_array_get_type (void) {
	static GType vala_array_type_id = 0;
	if (G_UNLIKELY (vala_array_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaArrayClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_array_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaArray), 0, (GInstanceInitFunc) vala_array_init };
		vala_array_type_id = g_type_register_static (VALA_TYPE_DATA_TYPE, "ValaArray", &g_define_type_info, 0);
	}
	return vala_array_type_id;
}




