/* valainterfacewriter.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <rasa@gmx.ch>
 */

#ifndef __VALA_VALAINTERFACEWRITER_H__
#define __VALA_VALAINTERFACEWRITER_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valacodevisitor.h>
#include <vala/valacodecontext.h>
#include <vala/valanamespace.h>
#include <vala/valaclass.h>
#include <vala/valastruct.h>
#include <vala/valainterface.h>
#include <vala/valaenum.h>
#include <vala/valaenumvalue.h>
#include <vala/valaconstant.h>
#include <vala/valafield.h>
#include <vala/valacallback.h>
#include <vala/valamethod.h>
#include <vala/valacreationmethod.h>
#include <vala/valaproperty.h>
#include <vala/valasignal.h>

G_BEGIN_DECLS


#define VALA_TYPE_INTERFACE_WRITER (vala_interface_writer_get_type ())
#define VALA_INTERFACE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INTERFACE_WRITER, ValaInterfaceWriter))
#define VALA_INTERFACE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INTERFACE_WRITER, ValaInterfaceWriterClass))
#define VALA_IS_INTERFACE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INTERFACE_WRITER))
#define VALA_IS_INTERFACE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INTERFACE_WRITER))
#define VALA_INTERFACE_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INTERFACE_WRITER, ValaInterfaceWriterClass))

typedef struct _ValaInterfaceWriter ValaInterfaceWriter;
typedef struct _ValaInterfaceWriterClass ValaInterfaceWriterClass;
typedef struct _ValaInterfaceWriterPrivate ValaInterfaceWriterPrivate;

/**
 * Code visitor generating Vala API file for the public interface.
 */
struct _ValaInterfaceWriter {
	ValaCodeVisitor parent;
	ValaInterfaceWriterPrivate * priv;
};
struct _ValaInterfaceWriterClass {
	ValaCodeVisitorClass parent;
};

void vala_interface_writer_write_file (ValaInterfaceWriter* self, ValaCodeContext* context, const char* filename);
ValaInterfaceWriter* vala_interface_writer_new (void);
GType vala_interface_writer_get_type (void);

G_END_DECLS

#endif
