/* valalockstatement.vala
 *
 * Copyright (C) 2006-2007  Raffaele Sandrini, Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Raffaele Sandrini <rasa@gmx.ch>
 */

#include <vala/valalockstatement.h>
#include <vala/valaexpression.h>
#include <vala/valablock.h>
#include <vala/valasourcereference.h>
#include <vala/valacodevisitor.h>

struct _ValaLockStatementPrivate {
	ValaExpression* _resource;
	ValaBlock* _body;
};
#define VALA_LOCK_STATEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_LOCK_STATEMENT, ValaLockStatementPrivate))
enum  {
	VALA_LOCK_STATEMENT_DUMMY_PROPERTY,
	VALA_LOCK_STATEMENT_RESOURCE,
	VALA_LOCK_STATEMENT_BODY
};
static void vala_lock_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gpointer vala_lock_statement_parent_class = NULL;
static ValaStatementIface* vala_lock_statement_vala_statement_parent_iface = NULL;
static void vala_lock_statement_dispose (GObject * obj);


ValaLockStatement* vala_lock_statement_new (ValaExpression* resource, ValaBlock* body, ValaSourceReference* source_reference) {
	GParameter * __params;
	GParameter * __params_it;
	ValaLockStatement * self;
	g_return_val_if_fail (resource == NULL || VALA_IS_EXPRESSION (resource), NULL);
	g_return_val_if_fail (body == NULL || VALA_IS_BLOCK (body), NULL);
	g_return_val_if_fail (source_reference == NULL || VALA_IS_SOURCE_REFERENCE (source_reference), NULL);
	__params = g_new0 (GParameter, 2);
	__params_it = __params;
	(__params_it->name = "resource", g_value_init (&__params_it->value, VALA_TYPE_EXPRESSION), g_value_set_object (&__params_it->value, resource), __params_it++);
	(__params_it->name = "body", g_value_init (&__params_it->value, VALA_TYPE_BLOCK), g_value_set_object (&__params_it->value, body), __params_it++);
	self = g_object_newv (VALA_TYPE_LOCK_STATEMENT, __params_it - __params, __params);
	vala_code_node_set_source_reference (VALA_CODE_NODE (self), source_reference);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


static void vala_lock_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaLockStatement * self;
	self = VALA_LOCK_STATEMENT (base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	vala_code_node_accept (VALA_CODE_NODE (vala_lock_statement_get_resource (self)), visitor);
	vala_code_node_accept (VALA_CODE_NODE (vala_lock_statement_get_body (self)), visitor);
	vala_code_visitor_visit_lock_statement (visitor, self);
}


ValaExpression* vala_lock_statement_get_resource (ValaLockStatement* self) {
	g_return_val_if_fail (VALA_IS_LOCK_STATEMENT (self), NULL);
	return self->priv->_resource;
}


void vala_lock_statement_set_resource (ValaLockStatement* self, ValaExpression* value) {
	ValaExpression* _tmp1;
	g_return_if_fail (VALA_IS_LOCK_STATEMENT (self));
	_tmp1 = NULL;
	self->priv->_resource = (_tmp1 = g_object_ref (value), (self->priv->_resource == NULL ? NULL : (self->priv->_resource = (g_object_unref (self->priv->_resource), NULL))), _tmp1);
}


ValaBlock* vala_lock_statement_get_body (ValaLockStatement* self) {
	g_return_val_if_fail (VALA_IS_LOCK_STATEMENT (self), NULL);
	return self->priv->_body;
}


void vala_lock_statement_set_body (ValaLockStatement* self, ValaBlock* value) {
	ValaBlock* _tmp1;
	g_return_if_fail (VALA_IS_LOCK_STATEMENT (self));
	_tmp1 = NULL;
	self->priv->_body = (_tmp1 = g_object_ref (value), (self->priv->_body == NULL ? NULL : (self->priv->_body = (g_object_unref (self->priv->_body), NULL))), _tmp1);
}


static void vala_lock_statement_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaLockStatement * self;
	self = VALA_LOCK_STATEMENT (object);
	switch (property_id) {
		case VALA_LOCK_STATEMENT_RESOURCE:
		g_value_set_object (value, vala_lock_statement_get_resource (self));
		break;
		case VALA_LOCK_STATEMENT_BODY:
		g_value_set_object (value, vala_lock_statement_get_body (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_lock_statement_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaLockStatement * self;
	self = VALA_LOCK_STATEMENT (object);
	switch (property_id) {
		case VALA_LOCK_STATEMENT_RESOURCE:
		vala_lock_statement_set_resource (self, g_value_get_object (value));
		break;
		case VALA_LOCK_STATEMENT_BODY:
		vala_lock_statement_set_body (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_lock_statement_class_init (ValaLockStatementClass * klass) {
	vala_lock_statement_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaLockStatementPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_lock_statement_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_lock_statement_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_lock_statement_dispose;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_lock_statement_real_accept;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_LOCK_STATEMENT_RESOURCE, g_param_spec_object ("resource", "resource", "resource", VALA_TYPE_EXPRESSION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_LOCK_STATEMENT_BODY, g_param_spec_object ("body", "body", "body", VALA_TYPE_BLOCK, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void vala_lock_statement_vala_statement_interface_init (ValaStatementIface * iface) {
	vala_lock_statement_vala_statement_parent_iface = g_type_interface_peek_parent (iface);
}


static void vala_lock_statement_init (ValaLockStatement * self) {
	self->priv = VALA_LOCK_STATEMENT_GET_PRIVATE (self);
}


static void vala_lock_statement_dispose (GObject * obj) {
	ValaLockStatement * self;
	self = VALA_LOCK_STATEMENT (obj);
	(self->priv->_resource == NULL ? NULL : (self->priv->_resource = (g_object_unref (self->priv->_resource), NULL)));
	(self->priv->_body == NULL ? NULL : (self->priv->_body = (g_object_unref (self->priv->_body), NULL)));
	G_OBJECT_CLASS (vala_lock_statement_parent_class)->dispose (obj);
}


GType vala_lock_statement_get_type (void) {
	static GType vala_lock_statement_type_id = 0;
	if (G_UNLIKELY (vala_lock_statement_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaLockStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_lock_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaLockStatement), 0, (GInstanceInitFunc) vala_lock_statement_init };
		static const GInterfaceInfo vala_statement_info = { (GInterfaceInitFunc) vala_lock_statement_vala_statement_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		vala_lock_statement_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaLockStatement", &g_define_type_info, 0);
		g_type_add_interface_static (vala_lock_statement_type_id, VALA_TYPE_STATEMENT, &vala_statement_info);
	}
	return vala_lock_statement_type_id;
}




