/* valavariabledeclarator.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valavariabledeclarator.h>
#include <vala/valatypereference.h>
#include <vala/valaexpression.h>
#include <vala/valasourcereference.h>
#include <vala/valacodevisitor.h>
#include <vala/valacallback.h>

struct _ValaVariableDeclaratorPrivate {
	ValaTypeReference* _type_reference;
	ValaExpression* _initializer;
};
#define VALA_VARIABLE_DECLARATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_VARIABLE_DECLARATOR, ValaVariableDeclaratorPrivate))
enum  {
	VALA_VARIABLE_DECLARATOR_DUMMY_PROPERTY,
	VALA_VARIABLE_DECLARATOR_INITIALIZER,
	VALA_VARIABLE_DECLARATOR_TYPE_REFERENCE
};
static void vala_variable_declarator_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_variable_declarator_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static GeeCollection* vala_variable_declarator_real_get_parameters (ValaInvokable* base);
static ValaTypeReference* vala_variable_declarator_real_get_return_type (ValaInvokable* base);
static gboolean vala_variable_declarator_real_is_invokable (ValaInvokable* base);
static void vala_variable_declarator_real_replace (ValaCodeNode* base, ValaCodeNode* old_node, ValaCodeNode* new_node);
static gpointer vala_variable_declarator_parent_class = NULL;
static ValaInvokableIface* vala_variable_declarator_vala_invokable_parent_iface = NULL;
static void vala_variable_declarator_dispose (GObject * obj);


/**
 * Creates a new variable declarator.
 *
 * @param name   name of the variable
 * @param init   optional initializer expression
 * @param source reference to source code
 * @return       newly created variable declarator
 */
ValaVariableDeclarator* vala_variable_declarator_new (const char* name, ValaExpression* initializer, ValaSourceReference* source_reference) {
	ValaVariableDeclarator * self;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (initializer == NULL || VALA_IS_EXPRESSION (initializer), NULL);
	g_return_val_if_fail (source_reference == NULL || VALA_IS_SOURCE_REFERENCE (source_reference), NULL);
	self = g_object_newv (VALA_TYPE_VARIABLE_DECLARATOR, 0, NULL);
	vala_symbol_set_name (VALA_SYMBOL (self), name);
	vala_variable_declarator_set_initializer (self, initializer);
	vala_code_node_set_source_reference (VALA_CODE_NODE (self), source_reference);
	return self;
}


static void vala_variable_declarator_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaVariableDeclarator * self;
	self = VALA_VARIABLE_DECLARATOR (base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	vala_code_visitor_visit_variable_declarator (visitor, self);
}


static void vala_variable_declarator_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaVariableDeclarator * self;
	self = VALA_VARIABLE_DECLARATOR (base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	if (vala_variable_declarator_get_initializer (self) != NULL) {
		vala_code_node_accept (VALA_CODE_NODE (vala_variable_declarator_get_initializer (self)), visitor);
		vala_code_visitor_visit_end_full_expression (visitor, vala_variable_declarator_get_initializer (self));
	}
	if (vala_variable_declarator_get_type_reference (self) != NULL) {
		vala_code_node_accept (VALA_CODE_NODE (vala_variable_declarator_get_type_reference (self)), visitor);
	}
}


static GeeCollection* vala_variable_declarator_real_get_parameters (ValaInvokable* base) {
	ValaVariableDeclarator * self;
	ValaCallback* _tmp1;
	ValaCallback* cb;
	GeeCollection* _tmp2;
	self = VALA_VARIABLE_DECLARATOR (base);
	if (!vala_invokable_is_invokable (VALA_INVOKABLE (self))) {
		return NULL;
	}
	_tmp1 = NULL;
	cb = (_tmp1 = VALA_CALLBACK (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (self))), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
	_tmp2 = NULL;
	return (_tmp2 = vala_callback_get_parameters (cb), (cb == NULL ? NULL : (cb = (g_object_unref (cb), NULL))), _tmp2);
	(cb == NULL ? NULL : (cb = (g_object_unref (cb), NULL)));
}


static ValaTypeReference* vala_variable_declarator_real_get_return_type (ValaInvokable* base) {
	ValaVariableDeclarator * self;
	ValaCallback* _tmp1;
	ValaCallback* cb;
	ValaTypeReference* _tmp2;
	ValaTypeReference* _tmp3;
	self = VALA_VARIABLE_DECLARATOR (base);
	if (!vala_invokable_is_invokable (VALA_INVOKABLE (self))) {
		return NULL;
	}
	_tmp1 = NULL;
	cb = (_tmp1 = VALA_CALLBACK (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (self))), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
	_tmp2 = NULL;
	_tmp3 = NULL;
	return (_tmp3 = (_tmp2 = vala_callback_get_return_type (cb), (_tmp2 == NULL ? NULL : g_object_ref (_tmp2))), (cb == NULL ? NULL : (cb = (g_object_unref (cb), NULL))), _tmp3);
	(cb == NULL ? NULL : (cb = (g_object_unref (cb), NULL)));
}


static gboolean vala_variable_declarator_real_is_invokable (ValaInvokable* base) {
	ValaVariableDeclarator * self;
	self = VALA_VARIABLE_DECLARATOR (base);
	return (VALA_IS_CALLBACK (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (self))));
}


static void vala_variable_declarator_real_replace (ValaCodeNode* base, ValaCodeNode* old_node, ValaCodeNode* new_node) {
	ValaVariableDeclarator * self;
	self = VALA_VARIABLE_DECLARATOR (base);
	g_return_if_fail (VALA_IS_CODE_NODE (old_node));
	g_return_if_fail (VALA_IS_CODE_NODE (new_node));
	if (VALA_CODE_NODE (vala_variable_declarator_get_initializer (self)) == old_node) {
		vala_variable_declarator_set_initializer (self, VALA_EXPRESSION (new_node));
	}
}


ValaExpression* vala_variable_declarator_get_initializer (ValaVariableDeclarator* self) {
	g_return_val_if_fail (VALA_IS_VARIABLE_DECLARATOR (self), NULL);
	return self->priv->_initializer;
}


void vala_variable_declarator_set_initializer (ValaVariableDeclarator* self, ValaExpression* value) {
	ValaExpression* _tmp2;
	ValaExpression* _tmp1;
	g_return_if_fail (VALA_IS_VARIABLE_DECLARATOR (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_initializer = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_initializer == NULL ? NULL : (self->priv->_initializer = (g_object_unref (self->priv->_initializer), NULL))), _tmp2);
	if (self->priv->_initializer != NULL) {
		vala_code_node_set_parent_node (VALA_CODE_NODE (self->priv->_initializer), VALA_CODE_NODE (self));
	}
}


ValaTypeReference* vala_variable_declarator_get_type_reference (ValaVariableDeclarator* self) {
	g_return_val_if_fail (VALA_IS_VARIABLE_DECLARATOR (self), NULL);
	return self->priv->_type_reference;
}


void vala_variable_declarator_set_type_reference (ValaVariableDeclarator* self, ValaTypeReference* value) {
	ValaTypeReference* _tmp2;
	ValaTypeReference* _tmp1;
	g_return_if_fail (VALA_IS_VARIABLE_DECLARATOR (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_type_reference = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_type_reference == NULL ? NULL : (self->priv->_type_reference = (g_object_unref (self->priv->_type_reference), NULL))), _tmp2);
}


static void vala_variable_declarator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaVariableDeclarator * self;
	self = VALA_VARIABLE_DECLARATOR (object);
	switch (property_id) {
		case VALA_VARIABLE_DECLARATOR_INITIALIZER:
		g_value_set_object (value, vala_variable_declarator_get_initializer (self));
		break;
		case VALA_VARIABLE_DECLARATOR_TYPE_REFERENCE:
		g_value_set_object (value, vala_variable_declarator_get_type_reference (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_variable_declarator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaVariableDeclarator * self;
	self = VALA_VARIABLE_DECLARATOR (object);
	switch (property_id) {
		case VALA_VARIABLE_DECLARATOR_INITIALIZER:
		vala_variable_declarator_set_initializer (self, g_value_get_object (value));
		break;
		case VALA_VARIABLE_DECLARATOR_TYPE_REFERENCE:
		vala_variable_declarator_set_type_reference (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_variable_declarator_class_init (ValaVariableDeclaratorClass * klass) {
	vala_variable_declarator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaVariableDeclaratorPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_variable_declarator_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_variable_declarator_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_variable_declarator_dispose;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_variable_declarator_real_accept;
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_variable_declarator_real_accept_children;
	VALA_CODE_NODE_CLASS (klass)->replace = vala_variable_declarator_real_replace;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_VARIABLE_DECLARATOR_INITIALIZER, g_param_spec_object ("initializer", "initializer", "initializer", VALA_TYPE_EXPRESSION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_VARIABLE_DECLARATOR_TYPE_REFERENCE, g_param_spec_object ("type-reference", "type-reference", "type-reference", VALA_TYPE_TYPE_REFERENCE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_variable_declarator_vala_invokable_interface_init (ValaInvokableIface * iface) {
	vala_variable_declarator_vala_invokable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_parameters = vala_variable_declarator_real_get_parameters;
	iface->get_return_type = vala_variable_declarator_real_get_return_type;
	iface->is_invokable = vala_variable_declarator_real_is_invokable;
}


static void vala_variable_declarator_init (ValaVariableDeclarator * self) {
	self->priv = VALA_VARIABLE_DECLARATOR_GET_PRIVATE (self);
}


static void vala_variable_declarator_dispose (GObject * obj) {
	ValaVariableDeclarator * self;
	self = VALA_VARIABLE_DECLARATOR (obj);
	(self->priv->_type_reference == NULL ? NULL : (self->priv->_type_reference = (g_object_unref (self->priv->_type_reference), NULL)));
	(self->priv->_initializer == NULL ? NULL : (self->priv->_initializer = (g_object_unref (self->priv->_initializer), NULL)));
	G_OBJECT_CLASS (vala_variable_declarator_parent_class)->dispose (obj);
}


GType vala_variable_declarator_get_type (void) {
	static GType vala_variable_declarator_type_id = 0;
	if (G_UNLIKELY (vala_variable_declarator_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaVariableDeclaratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_variable_declarator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaVariableDeclarator), 0, (GInstanceInitFunc) vala_variable_declarator_init };
		static const GInterfaceInfo vala_invokable_info = { (GInterfaceInitFunc) vala_variable_declarator_vala_invokable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		vala_variable_declarator_type_id = g_type_register_static (VALA_TYPE_SYMBOL, "ValaVariableDeclarator", &g_define_type_info, 0);
		g_type_add_interface_static (vala_variable_declarator_type_id, VALA_TYPE_INVOKABLE, &vala_invokable_info);
	}
	return vala_variable_declarator_type_id;
}




