/* valaccodegenerator.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <rasa@gmx.ch>
 */

#ifndef __GOBJECT_VALACCODEGENERATOR_H__
#define __GOBJECT_VALACCODEGENERATOR_H__

#include <glib.h>
#include <glib-object.h>
#include <vala/valacodegenerator.h>
#include <vala/valasymbol.h>
#include <gee/arraylist.h>
#include <vala/valatypereference.h>
#include <vala/valadatatype.h>
#include <vala/valacodecontext.h>
#include <vala/valaenum.h>
#include <vala/valaenumvalue.h>
#include <vala/valacallback.h>
#include <vala/valamember.h>
#include <vala/valaconstant.h>
#include <vala/valafield.h>
#include <vala/valaformalparameter.h>
#include <vala/valaproperty.h>
#include <vala/valapropertyaccessor.h>
#include <vala/valaconstructor.h>
#include <vala/valadestructor.h>
#include <vala/valablock.h>
#include <vala/valaemptystatement.h>
#include <vala/valadeclarationstatement.h>
#include <vala/valavariabledeclarator.h>
#include <vala/valainitializerlist.h>
#include <vala/valacodenode.h>
#include <ccode/valaccodeexpression.h>
#include <vala/valaexpression.h>
#include <vala/valaexpressionstatement.h>
#include <vala/valaifstatement.h>
#include <vala/valaswitchstatement.h>
#include <vala/valaswitchsection.h>
#include <vala/valawhilestatement.h>
#include <vala/valadostatement.h>
#include <vala/valaforstatement.h>
#include <vala/valaforeachstatement.h>
#include <vala/valabreakstatement.h>
#include <vala/valacontinuestatement.h>
#include <vala/valareturnstatement.h>
#include <vala/valathrowstatement.h>
#include <vala/valatrystatement.h>
#include <vala/valacatchclause.h>
#include <vala/valalockstatement.h>
#include <vala/valaarraycreationexpression.h>
#include <vala/valabooleanliteral.h>
#include <vala/valacharacterliteral.h>
#include <vala/valaintegerliteral.h>
#include <vala/valarealliteral.h>
#include <vala/valastringliteral.h>
#include <vala/valanullliteral.h>
#include <vala/valaliteralexpression.h>
#include <vala/valaparenthesizedexpression.h>
#include <vala/valaelementaccess.h>
#include <vala/valabaseaccess.h>
#include <vala/valapostfixexpression.h>
#include <vala/valaobjectcreationexpression.h>
#include <vala/valasizeofexpression.h>
#include <vala/valatypeofexpression.h>
#include <vala/valaunaryexpression.h>
#include <vala/valacastexpression.h>
#include <vala/valapointerindirection.h>
#include <vala/valaaddressofexpression.h>
#include <vala/valareferencetransferexpression.h>
#include <vala/valabinaryexpression.h>
#include <vala/valatypecheck.h>
#include <vala/valaconditionalexpression.h>
#include <vala/valalambdaexpression.h>
#include <vala/valaassignment.h>
#include <ccode/valaccodefunctioncall.h>
#include <vala/valamemberaccess.h>
#include <vala/valacodebinding.h>
#include <vala/valanamespace.h>
#include <vala/valaclass.h>
#include <vala/valastruct.h>
#include <vala/valainterface.h>
#include <vala/valamethod.h>
#include <vala/valacreationmethod.h>
#include <vala/valasignal.h>
#include <vala/valatypeparameter.h>
#include <vala/valalocalvariabledeclaration.h>
#include <vala/valaswitchlabel.h>
#include <vala/valainvocationexpression.h>
#include <ccode/valaccodeidentifier.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valasourcefile.h>

G_BEGIN_DECLS


#define VALA_TYPE_CCODE_GENERATOR (vala_ccode_generator_get_type ())
#define VALA_CCODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGenerator))
#define VALA_CCODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGeneratorClass))
#define VALA_IS_CCODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_GENERATOR))
#define VALA_IS_CCODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_GENERATOR))
#define VALA_CCODE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGeneratorClass))

typedef struct _ValaCCodeGenerator ValaCCodeGenerator;
typedef struct _ValaCCodeGeneratorClass ValaCCodeGeneratorClass;
typedef struct _ValaCCodeGeneratorPrivate ValaCCodeGeneratorPrivate;

/**
 * Code visitor generating C Code.
 */
struct _ValaCCodeGenerator {
	ValaCodeGenerator parent;
	ValaCCodeGeneratorPrivate * priv;
	ValaSymbol* current_type_symbol;
	GeeArrayList* temp_vars;
	gboolean in_creation_method;
	ValaTypeReference* bool_type;
	ValaTypeReference* char_type;
	ValaTypeReference* unichar_type;
	ValaTypeReference* short_type;
	ValaTypeReference* ushort_type;
	ValaTypeReference* int_type;
	ValaTypeReference* uint_type;
	ValaTypeReference* long_type;
	ValaTypeReference* ulong_type;
	ValaTypeReference* int64_type;
	ValaTypeReference* uint64_type;
	ValaTypeReference* string_type;
	ValaTypeReference* float_type;
	ValaTypeReference* double_type;
	ValaDataType* gtypeinstance_type;
	ValaDataType* gobject_type;
	ValaDataType* gerror_type;
	ValaDataType* glist_type;
	ValaDataType* gslist_type;
	ValaDataType* gstring_type;
	ValaDataType* garray_type;
	ValaTypeReference* gquark_type;
	ValaTypeReference* mutex_type;
	ValaDataType* type_module_type;
	ValaDataType* iterable_type;
	ValaDataType* iterator_type;
	ValaDataType* list_type;
	ValaDataType* map_type;
	ValaDataType* connection_type;
};
struct _ValaCCodeGeneratorClass {
	ValaCodeGeneratorClass parent;
};

ValaCCodeGenerator* vala_ccode_generator_new (gboolean manage_memory);
ValaVariableDeclarator* vala_ccode_generator_get_temp_variable_declarator (ValaCCodeGenerator* self, ValaTypeReference* type, gboolean takes_ownership, ValaCodeNode* node_reference);
ValaCCodeExpression* vala_ccode_generator_get_unref_expression (ValaCCodeGenerator* self, ValaCCodeExpression* cvar, ValaTypeReference* type, ValaExpression* expr);
ValaCCodeExpression* vala_ccode_generator_get_array_length_cexpression (ValaCCodeGenerator* self, ValaExpression* array_expr, gint dim);
void vala_ccode_generator_visit_expression (ValaCCodeGenerator* self, ValaExpression* expr);
ValaCCodeExpression* vala_ccode_generator_convert_from_generic_pointer (ValaCCodeGenerator* self, ValaCCodeExpression* cexpr, ValaTypeReference* actual_type);
ValaCCodeExpression* vala_ccode_generator_convert_to_generic_pointer (ValaCCodeGenerator* self, ValaCCodeExpression* cexpr, ValaTypeReference* actual_type);
ValaCCodeExpression* vala_ccode_generator_get_implicit_cast_expression (ValaCCodeGenerator* self, ValaCCodeExpression* cexpr, ValaTypeReference* expression_type, ValaTypeReference* target_type);
ValaCCodeFunctionCall* vala_ccode_generator_get_property_set_call (ValaCCodeGenerator* self, ValaProperty* prop, ValaMemberAccess* ma, ValaCCodeExpression* cexpr);
ValaCCodeIdentifier* vala_ccode_generator_get_value_setter_function (ValaCCodeGenerator* self, ValaTypeReference* type_reference);
char* vala_ccode_generator_get_signal_marshaller_function (ValaCCodeGenerator* self, ValaSignal* sig, const char* prefix);
gboolean vala_ccode_generator_get_memory_management (ValaCCodeGenerator* self);
void vala_ccode_generator_set_memory_management (ValaCCodeGenerator* self, gboolean value);
GType vala_ccode_generator_get_type (void);

G_END_DECLS

#endif
