/* valadbusbindingprovider.vala
 *
 * Copyright (C) 2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <gobject/valadbusbindingprovider.h>
#include <vala/valadatatype.h>
#include <gee/arraylist.h>
#include <gee/collection.h>
#include <vala/valaexpression.h>
#include <vala/valatypereference.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <vala/valacodenode.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valasourcereference.h>
#include <vala/valamethod.h>
#include <vala/valamember.h>
#include <vala/valaformalparameter.h>
#include <vala/valainvocationexpression.h>
#include <vala/valaassignment.h>
#include <vala/valainterface.h>
#include <vala/valascope.h>
#include <gobject/valadbusmethod.h>
#include <gobject/valadbussignal.h>

struct _ValaDBusBindingProviderPrivate {
	ValaCodeContext* _context;
	ValaDataType* string_type;
	ValaDataType* connection_type;
	ValaDataType* dbus_error_type;
	GeeCollection* symbols;
};
#define VALA_DBUS_BINDING_PROVIDER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_DBUS_BINDING_PROVIDER, ValaDBusBindingProviderPrivate))
enum  {
	VALA_DBUS_BINDING_PROVIDER_DUMMY_PROPERTY,
	VALA_DBUS_BINDING_PROVIDER_CONTEXT
};
static ValaSymbol* vala_dbus_binding_provider_real_get_binding (ValaBindingProvider* base, ValaMemberAccess* ma);
static gboolean vala_dbus_binding_provider_is_dbus_interface (ValaDBusBindingProvider* self, ValaDataType* t);
static gpointer vala_dbus_binding_provider_parent_class = NULL;
static ValaBindingProviderIface* vala_dbus_binding_provider_vala_binding_provider_parent_iface = NULL;
static void vala_dbus_binding_provider_dispose (GObject * obj);


ValaDBusBindingProvider* vala_dbus_binding_provider_new (void) {
	ValaDBusBindingProvider * self;
	self = g_object_newv (VALA_TYPE_DBUS_BINDING_PROVIDER, 0, NULL);
	return self;
}


static ValaSymbol* vala_dbus_binding_provider_real_get_binding (ValaBindingProvider* base, ValaMemberAccess* ma) {
	ValaDBusBindingProvider * self;
	self = VALA_DBUS_BINDING_PROVIDER (base);
	g_return_val_if_fail (VALA_IS_MEMBER_ACCESS (ma), NULL);
	if (self->priv->connection_type != NULL && vala_member_access_get_inner (ma) != NULL && vala_expression_get_static_type (vala_member_access_get_inner (ma)) != NULL && vala_type_reference_get_data_type (vala_expression_get_static_type (vala_member_access_get_inner (ma))) == self->priv->connection_type) {
		GeeCollection* type_args;
		GeeIterator* type_args_it;
		ValaTypeReference* ret_type;
		ValaTypeReference* _tmp1;
		ValaMethod* m;
		ValaTypeReference* string_type_ref;
		ValaFormalParameter* _tmp3;
		ValaFormalParameter* _tmp4;
		ValaMethod* _tmp5;
		type_args = vala_member_access_get_type_arguments (ma);
		if (gee_collection_get_size (type_args) != 1) {
			gpointer _tmp0;
			return (_tmp0 = NULL, (type_args == NULL ? NULL : (type_args = (g_object_unref (type_args), NULL))), _tmp0);
		}
		type_args_it = gee_iterable_iterator (GEE_ITERABLE (type_args));
		gee_iterator_next (type_args_it);
		ret_type = vala_type_reference_new ();
		_tmp1 = NULL;
		vala_type_reference_set_data_type (ret_type, vala_type_reference_get_data_type ((_tmp1 = gee_iterator_get (type_args_it))));
		(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
		if (!vala_dbus_binding_provider_is_dbus_interface (self, vala_type_reference_get_data_type (ret_type))) {
			gpointer _tmp2;
			return (_tmp2 = NULL, (type_args == NULL ? NULL : (type_args = (g_object_unref (type_args), NULL))), (type_args_it == NULL ? NULL : (type_args_it = (g_object_unref (type_args_it), NULL))), (ret_type == NULL ? NULL : (ret_type = (g_object_unref (ret_type), NULL))), _tmp2);
		}
		m = vala_code_context_create_method (self->priv->_context, "get_object", ret_type, vala_code_node_get_source_reference (VALA_CODE_NODE (ma)));
		vala_method_set_cname (m, "dbus_g_proxy_new_for_name");
		vala_member_add_cheader_filename (VALA_MEMBER (m), "dbus/dbus-glib.h");
		vala_symbol_set_access (VALA_SYMBOL (m), VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		string_type_ref = vala_type_reference_new ();
		vala_type_reference_set_data_type (string_type_ref, self->priv->string_type);
		_tmp3 = NULL;
		vala_method_add_parameter (m, (_tmp3 = vala_code_context_create_formal_parameter (self->priv->_context, "name", string_type_ref, NULL)));
		(_tmp3 = (g_object_unref (_tmp3), NULL));
		_tmp4 = NULL;
		vala_method_add_parameter (m, (_tmp4 = vala_code_context_create_formal_parameter (self->priv->_context, "path", string_type_ref, NULL)));
		(_tmp4 = (g_object_unref (_tmp4), NULL));
		gee_collection_add (self->priv->symbols, m);
		_tmp5 = NULL;
		return VALA_SYMBOL ((_tmp5 = m, (type_args == NULL ? NULL : (type_args = (g_object_unref (type_args), NULL))), (type_args_it == NULL ? NULL : (type_args_it = (g_object_unref (type_args_it), NULL))), (ret_type == NULL ? NULL : (ret_type = (g_object_unref (ret_type), NULL))), (string_type_ref == NULL ? NULL : (string_type_ref = (g_object_unref (string_type_ref), NULL))), _tmp5));
		(type_args == NULL ? NULL : (type_args = (g_object_unref (type_args), NULL)));
		(type_args_it == NULL ? NULL : (type_args_it = (g_object_unref (type_args_it), NULL)));
		(ret_type == NULL ? NULL : (ret_type = (g_object_unref (ret_type), NULL)));
		(m = (g_object_unref (m), NULL));
		(string_type_ref == NULL ? NULL : (string_type_ref = (g_object_unref (string_type_ref), NULL)));
	} else {
		if (vala_member_access_get_inner (ma) != NULL && vala_expression_get_static_type (vala_member_access_get_inner (ma)) != NULL && vala_dbus_binding_provider_is_dbus_interface (self, vala_type_reference_get_data_type (vala_expression_get_static_type (vala_member_access_get_inner (ma))))) {
			if (VALA_IS_INVOCATION_EXPRESSION (vala_code_node_get_parent_node (VALA_CODE_NODE (ma)))) {
				ValaInvocationExpression* _tmp6;
				ValaInvocationExpression* expr;
				ValaTypeReference* ret_type;
				ValaDBusMethod* m;
				ValaFormalParameter* _tmp7;
				ValaDBusMethod* _tmp8;
				_tmp6 = NULL;
				expr = (_tmp6 = VALA_INVOCATION_EXPRESSION (vala_code_node_get_parent_node (VALA_CODE_NODE (ma))), (_tmp6 == NULL ? NULL : g_object_ref (_tmp6)));
				ret_type = vala_type_reference_new ();
				if (vala_expression_get_expected_type (VALA_EXPRESSION (expr)) != NULL) {
					vala_type_reference_set_data_type (ret_type, vala_type_reference_get_data_type (vala_expression_get_expected_type (VALA_EXPRESSION (expr))));
					vala_type_reference_set_transfers_ownership (ret_type, vala_data_type_is_reference_type (vala_type_reference_get_data_type (ret_type)));
				}
				m = vala_dbus_method_new (vala_member_access_get_member_name (ma), ret_type, vala_code_node_get_source_reference (VALA_CODE_NODE (ma)));
				if (vala_expression_get_expected_type (VALA_EXPRESSION (expr)) != NULL) {
					ValaTypeReference* error_type;
					error_type = vala_type_reference_new ();
					vala_type_reference_set_data_type (error_type, self->priv->dbus_error_type);
					vala_method_add_error_domain (VALA_METHOD (m), error_type);
					(error_type == NULL ? NULL : (error_type = (g_object_unref (error_type), NULL)));
				}
				vala_symbol_set_access (VALA_SYMBOL (m), VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
				_tmp7 = NULL;
				vala_method_add_parameter (VALA_METHOD (m), (_tmp7 = vala_formal_parameter_new_with_ellipsis (NULL)));
				(_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL)));
				gee_collection_add (self->priv->symbols, m);
				_tmp8 = NULL;
				return VALA_SYMBOL ((_tmp8 = m, (expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL))), (ret_type == NULL ? NULL : (ret_type = (g_object_unref (ret_type), NULL))), _tmp8));
				(expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL)));
				(ret_type == NULL ? NULL : (ret_type = (g_object_unref (ret_type), NULL)));
				(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
			} else {
				if (VALA_IS_ASSIGNMENT (vala_code_node_get_parent_node (VALA_CODE_NODE (ma)))) {
					ValaAssignment* _tmp9;
					ValaAssignment* a;
					ValaTypeReference* _tmp11;
					ValaDBusSignal* _tmp12;
					ValaDBusSignal* s;
					ValaDBusSignal* _tmp13;
					_tmp9 = NULL;
					a = (_tmp9 = VALA_ASSIGNMENT (vala_code_node_get_parent_node (VALA_CODE_NODE (ma))), (_tmp9 == NULL ? NULL : g_object_ref (_tmp9)));
					if (vala_assignment_get_left (a) != VALA_EXPRESSION (ma)) {
						gpointer _tmp10;
						return (_tmp10 = NULL, (a == NULL ? NULL : (a = (g_object_unref (a), NULL))), _tmp10);
					}
					_tmp11 = NULL;
					_tmp12 = NULL;
					s = (_tmp12 = vala_dbus_signal_new (vala_member_access_get_member_name (ma), (_tmp11 = vala_type_reference_new ()), vala_code_node_get_source_reference (VALA_CODE_NODE (ma))), (_tmp11 == NULL ? NULL : (_tmp11 = (g_object_unref (_tmp11), NULL))), _tmp12);
					vala_symbol_set_access (VALA_SYMBOL (s), VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
					gee_collection_add (self->priv->symbols, s);
					_tmp13 = NULL;
					return VALA_SYMBOL ((_tmp13 = s, (a == NULL ? NULL : (a = (g_object_unref (a), NULL))), _tmp13));
					(a == NULL ? NULL : (a = (g_object_unref (a), NULL)));
					(s == NULL ? NULL : (s = (g_object_unref (s), NULL)));
				}
			}
		}
	}
	return NULL;
}


static gboolean vala_dbus_binding_provider_is_dbus_interface (ValaDBusBindingProvider* self, ValaDataType* t) {
	ValaAttribute* _tmp1;
	gboolean _tmp2;
	g_return_val_if_fail (VALA_IS_DBUS_BINDING_PROVIDER (self), FALSE);
	g_return_val_if_fail (VALA_IS_DATA_TYPE (t), FALSE);
	if (!(VALA_IS_INTERFACE (t))) {
		return FALSE;
	}
	_tmp1 = NULL;
	return (_tmp2 = ((_tmp1 = vala_code_node_get_attribute (VALA_CODE_NODE (t), "DBusInterface")) != NULL), (_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL))), _tmp2);
}


void vala_dbus_binding_provider_set_context (ValaDBusBindingProvider* self, ValaCodeContext* value) {
	ValaCodeContext* _tmp1;
	ValaCodeContext* _tmp0;
	ValaDataType* _tmp2;
	ValaSymbol* dbus_ns;
	g_return_if_fail (VALA_IS_DBUS_BINDING_PROVIDER (self));
	_tmp1 = NULL;
	_tmp0 = NULL;
	self->priv->_context = (_tmp1 = (_tmp0 = value, (_tmp0 == NULL ? NULL : g_object_ref (_tmp0))), (self->priv->_context == NULL ? NULL : (self->priv->_context = (g_object_unref (self->priv->_context), NULL))), _tmp1);
	_tmp2 = NULL;
	self->priv->string_type = (_tmp2 = VALA_DATA_TYPE (vala_scope_lookup (vala_symbol_get_scope (VALA_SYMBOL (vala_code_context_get_root (self->priv->_context))), "string")), (self->priv->string_type == NULL ? NULL : (self->priv->string_type = (g_object_unref (self->priv->string_type), NULL))), _tmp2);
	dbus_ns = vala_scope_lookup (vala_symbol_get_scope (VALA_SYMBOL (vala_code_context_get_root (self->priv->_context))), "DBus");
	if (dbus_ns != NULL) {
		ValaDataType* _tmp3;
		ValaDataType* _tmp4;
		_tmp3 = NULL;
		self->priv->connection_type = (_tmp3 = VALA_DATA_TYPE (vala_scope_lookup (vala_symbol_get_scope (dbus_ns), "Connection")), (self->priv->connection_type == NULL ? NULL : (self->priv->connection_type = (g_object_unref (self->priv->connection_type), NULL))), _tmp3);
		_tmp4 = NULL;
		self->priv->dbus_error_type = (_tmp4 = VALA_DATA_TYPE (vala_scope_lookup (vala_symbol_get_scope (dbus_ns), "Error")), (self->priv->dbus_error_type == NULL ? NULL : (self->priv->dbus_error_type = (g_object_unref (self->priv->dbus_error_type), NULL))), _tmp4);
	}
	(dbus_ns == NULL ? NULL : (dbus_ns = (g_object_unref (dbus_ns), NULL)));
}


static void vala_dbus_binding_provider_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaDBusBindingProvider * self;
	self = VALA_DBUS_BINDING_PROVIDER (object);
	switch (property_id) {
		case VALA_DBUS_BINDING_PROVIDER_CONTEXT:
		vala_dbus_binding_provider_set_context (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_dbus_binding_provider_class_init (ValaDBusBindingProviderClass * klass) {
	vala_dbus_binding_provider_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaDBusBindingProviderPrivate));
	G_OBJECT_CLASS (klass)->set_property = vala_dbus_binding_provider_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_dbus_binding_provider_dispose;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_DBUS_BINDING_PROVIDER_CONTEXT, g_param_spec_object ("context", "context", "context", VALA_TYPE_CODE_CONTEXT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
}


static void vala_dbus_binding_provider_vala_binding_provider_interface_init (ValaBindingProviderIface * iface) {
	vala_dbus_binding_provider_vala_binding_provider_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_binding = vala_dbus_binding_provider_real_get_binding;
}


static void vala_dbus_binding_provider_init (ValaDBusBindingProvider * self) {
	self->priv = VALA_DBUS_BINDING_PROVIDER_GET_PRIVATE (self);
	self->priv->symbols = GEE_COLLECTION (gee_array_list_new (VALA_TYPE_SYMBOL, ((GBoxedCopyFunc) g_object_ref), g_object_unref, g_direct_equal));
}


static void vala_dbus_binding_provider_dispose (GObject * obj) {
	ValaDBusBindingProvider * self;
	self = VALA_DBUS_BINDING_PROVIDER (obj);
	(self->priv->_context == NULL ? NULL : (self->priv->_context = (g_object_unref (self->priv->_context), NULL)));
	(self->priv->string_type == NULL ? NULL : (self->priv->string_type = (g_object_unref (self->priv->string_type), NULL)));
	(self->priv->connection_type == NULL ? NULL : (self->priv->connection_type = (g_object_unref (self->priv->connection_type), NULL)));
	(self->priv->dbus_error_type == NULL ? NULL : (self->priv->dbus_error_type = (g_object_unref (self->priv->dbus_error_type), NULL)));
	(self->priv->symbols == NULL ? NULL : (self->priv->symbols = (g_object_unref (self->priv->symbols), NULL)));
	G_OBJECT_CLASS (vala_dbus_binding_provider_parent_class)->dispose (obj);
}


GType vala_dbus_binding_provider_get_type (void) {
	static GType vala_dbus_binding_provider_type_id = 0;
	if (G_UNLIKELY (vala_dbus_binding_provider_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaDBusBindingProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_dbus_binding_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaDBusBindingProvider), 0, (GInstanceInitFunc) vala_dbus_binding_provider_init };
		static const GInterfaceInfo vala_binding_provider_info = { (GInterfaceInitFunc) vala_dbus_binding_provider_vala_binding_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		vala_dbus_binding_provider_type_id = g_type_register_static (G_TYPE_OBJECT, "ValaDBusBindingProvider", &g_define_type_info, 0);
		g_type_add_interface_static (vala_dbus_binding_provider_type_id, VALA_TYPE_BINDING_PROVIDER, &vala_binding_provider_info);
	}
	return vala_dbus_binding_provider_type_id;
}




