/* valalockstatement.vala
 *
 * Copyright (C) 2006-2007  Raffaele Sandrini, Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Raffaele Sandrini <rasa@gmx.ch>
 */

#ifndef __VALA_VALALOCKSTATEMENT_H__
#define __VALA_VALALOCKSTATEMENT_H__

#include <glib.h>
#include <glib-object.h>
#include <vala/valacodenode.h>
#include <vala/valastatement.h>

G_BEGIN_DECLS


#define VALA_TYPE_LOCK_STATEMENT (vala_lock_statement_get_type ())
#define VALA_LOCK_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LOCK_STATEMENT, ValaLockStatement))
#define VALA_LOCK_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LOCK_STATEMENT, ValaLockStatementClass))
#define VALA_IS_LOCK_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LOCK_STATEMENT))
#define VALA_IS_LOCK_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LOCK_STATEMENT))
#define VALA_LOCK_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LOCK_STATEMENT, ValaLockStatementClass))

typedef struct _ValaLockStatementPrivate ValaLockStatementPrivate;

/**
 * Represents a lock statement e.g. "lock (a) { f(a) }".
 */
struct _ValaLockStatement {
	ValaCodeNode parent;
	ValaLockStatementPrivate * priv;
};
struct _ValaLockStatementClass {
	ValaCodeNodeClass parent;
};

ValaLockStatement* vala_lock_statement_new (ValaExpression* resource, ValaBlock* body, ValaSourceReference* source_reference);
ValaExpression* vala_lock_statement_get_resource (ValaLockStatement* self);
void vala_lock_statement_set_resource (ValaLockStatement* self, ValaExpression* value);
ValaBlock* vala_lock_statement_get_body (ValaLockStatement* self);
void vala_lock_statement_set_body (ValaLockStatement* self, ValaBlock* value);
GType vala_lock_statement_get_type (void);

G_END_DECLS

#endif
