/* valasymbolresolver.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#ifndef __VALA_VALASYMBOLRESOLVER_H__
#define __VALA_VALASYMBOLRESOLVER_H__

#include <glib.h>
#include <glib-object.h>
#include <vala/valacodevisitor.h>
#include <vala/valacodecontext.h>
#include <vala/valasourcefile.h>
#include <vala/valaclass.h>
#include <vala/valastruct.h>
#include <vala/valainterface.h>
#include <vala/valaenum.h>
#include <vala/valacallback.h>
#include <vala/valaconstant.h>
#include <vala/valafield.h>
#include <vala/valamethod.h>
#include <vala/valacreationmethod.h>
#include <vala/valaformalparameter.h>
#include <vala/valaproperty.h>
#include <vala/valapropertyaccessor.h>
#include <vala/valasignal.h>
#include <vala/valaconstructor.h>
#include <vala/valadestructor.h>
#include <vala/valablock.h>
#include <vala/valanamespacereference.h>
#include <vala/valatypereference.h>
#include <vala/valavariabledeclarator.h>
#include <vala/valainitializerlist.h>
#include <vala/valaswitchsection.h>
#include <vala/valaforeachstatement.h>
#include <vala/valareturnstatement.h>
#include <vala/valathrowstatement.h>
#include <vala/valatrystatement.h>
#include <vala/valacatchclause.h>
#include <vala/valaarraycreationexpression.h>
#include <vala/valainvocationexpression.h>
#include <vala/valaobjectcreationexpression.h>
#include <vala/valalambdaexpression.h>
#include <vala/valaassignment.h>

G_BEGIN_DECLS


#define VALA_TYPE_SYMBOL_RESOLVER (vala_symbol_resolver_get_type ())
#define VALA_SYMBOL_RESOLVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SYMBOL_RESOLVER, ValaSymbolResolver))
#define VALA_SYMBOL_RESOLVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SYMBOL_RESOLVER, ValaSymbolResolverClass))
#define VALA_IS_SYMBOL_RESOLVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SYMBOL_RESOLVER))
#define VALA_IS_SYMBOL_RESOLVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SYMBOL_RESOLVER))
#define VALA_SYMBOL_RESOLVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SYMBOL_RESOLVER, ValaSymbolResolverClass))

typedef struct _ValaSymbolResolver ValaSymbolResolver;
typedef struct _ValaSymbolResolverClass ValaSymbolResolverClass;
typedef struct _ValaSymbolResolverPrivate ValaSymbolResolverPrivate;

/**
 * Code visitor resolving symbol names.
 */
struct _ValaSymbolResolver {
	ValaCodeVisitor parent;
	ValaSymbolResolverPrivate * priv;
};
struct _ValaSymbolResolverClass {
	ValaCodeVisitorClass parent;
};

void vala_symbol_resolver_resolve (ValaSymbolResolver* self, ValaCodeContext* context);
ValaSymbolResolver* vala_symbol_resolver_new (void);
GType vala_symbol_resolver_get_type (void);

G_END_DECLS

#endif
