/* valaccodegenerator.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <rasa@gmx.ch>
 */

#include <gobject/valaccodegenerator.h>
#include <vala/valasymbol.h>
#include <ccode/valaccodefragment.h>
#include <ccode/valaccodestruct.h>
#include <ccode/valaccodeenum.h>
#include <ccode/valaccodefunction.h>
#include <ccode/valaccodeblock.h>
#include <gee/set.h>
#include <vala/valavaluetype.h>
#include <vala/valascope.h>
#include <vala/valaclasstype.h>
#include <gee/collection.h>
#include <vala/valacodevisitor.h>
#include <vala/valasourcereference.h>
#include <ccode/valaccodecomment.h>
#include <ccode/valaccodenode.h>
#include <ccode/valaccodemacroreplacement.h>
#include <ccode/valaccodeconstant.h>
#include <ccode/valaccodereturnstatement.h>
#include <ccode/valaccodeenumvalue.h>
#include <ccode/valaccodefunctiondeclarator.h>
#include <ccode/valaccodeformalparameter.h>
#include <ccode/valaccodetypedefinition.h>
#include <ccode/valaccodedeclarator.h>
#include <vala/valalockable.h>
#include <ccode/valaccodeexpressionstatement.h>
#include <ccode/valaccodeassignment.h>
#include <ccode/valaccodememberaccess.h>
#include <vala/valareport.h>
#include <vala/valaarray.h>
#include <ccode/valaccodedeclaration.h>
#include <ccode/valaccodevariabledeclarator.h>
#include <ccode/valaccodemodifiers.h>
#include <gee/list.h>
#include <ccode/valaccodeparenthesizedexpression.h>
#include <vala/valavoidtype.h>
#include <vala/valareferencetype.h>
#include <vala/valainterfacetype.h>
#include <ccode/valaccodeunaryexpression.h>
#include <ccode/valaccodebinaryexpression.h>
#include <ccode/valaccodeifstatement.h>
#include <ccode/valaccodestatement.h>
#include <ccode/valaccodecastexpression.h>
#include <vala/valainstancecast.h>
#include <ccode/valaccodeemptystatement.h>
#include <vala/valastatement.h>
#include <vala/valadelegatetype.h>
#include <vala/valapointertype.h>
#include <ccode/valaccodecommaexpression.h>
#include <ccode/valaccodeinitializerlist.h>
#include <ccode/valaccodeconditionalexpression.h>
#include <ccode/valaccodegotostatement.h>
#include <ccode/valaccodedostatement.h>
#include <ccode/valaccodewhilestatement.h>
#include <ccode/valaccodeforstatement.h>
#include <ccode/valaccodeelementaccess.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <vala/valasemanticanalyzer.h>
#include <ccode/valaccodebreakstatement.h>
#include <ccode/valaccodecontinuestatement.h>
#include <ccode/valaccodelabel.h>
#include <vala/valamemberinitializer.h>
#include <vala/valanulltype.h>
#include <vala/valamethodtype.h>
#include <ccode/valaccodenewline.h>
#include <ccode/valaccodeswitchstatement.h>
#include <ccode/valaccodecasestatement.h>
#include <vala/valasignaltype.h>
#include <vala/valaarrayresizemethod.h>
#include <vala/valaarraymovemethod.h>
#include <vala/valaattribute.h>
#include <vala/valaarraylengthfield.h>
#include <ccode/valaccodeincludedirective.h>
#include <gee/hashset.h>
#include <vala/valasourcefilecycle.h>
#include <ccode/valaccodewriter.h>
#include <ccode/valaccodeoncesection.h>
#include <gobject/valaccodemethodbinding.h>
#include <gobject/valaccodearraycreationexpressionbinding.h>
#include <gobject/valaccodeelementaccessbinding.h>
#include <gobject/valaccodeassignmentbinding.h>
#include <gobject/valaclassregisterfunction.h>
#include <gobject/valatyperegisterfunction.h>
#include <gobject/valainterfaceregisterfunction.h>
#include <gobject/valadbusmethod.h>

struct _ValaCCodeGeneratorPrivate {
	ValaCodeContext* context;
	ValaSymbol* root_symbol;
	ValaSymbol* current_symbol;
	ValaClass* current_class;
	ValaMethod* current_method;
	ValaDataType* current_return_type;
	ValaTryStatement* current_try;
	ValaCCodeFragment* header_begin;
	ValaCCodeFragment* header_type_declaration;
	ValaCCodeFragment* header_type_definition;
	ValaCCodeFragment* header_type_member_declaration;
	ValaCCodeFragment* source_begin;
	ValaCCodeFragment* source_include_directives;
	ValaCCodeFragment* source_type_member_declaration;
	ValaCCodeFragment* source_signal_marshaller_declaration;
	ValaCCodeFragment* source_type_member_definition;
	ValaCCodeFragment* class_init_fragment;
	ValaCCodeFragment* instance_init_fragment;
	ValaCCodeFragment* instance_dispose_fragment;
	ValaCCodeFragment* source_signal_marshaller_definition;
	ValaCCodeFragment* module_init_fragment;
	ValaCCodeStruct* instance_struct;
	ValaCCodeStruct* type_struct;
	ValaCCodeStruct* instance_priv_struct;
	ValaCCodeEnum* prop_enum;
	ValaCCodeEnum* cenum;
	ValaCCodeFunction* function;
	ValaCCodeBlock* block;
	GeeArrayList* temp_ref_vars;
	GeeSet* user_marshal_set;
	GeeSet* predefined_marshal_set;
	GeeSet* c_keywords;
	gint next_temp_var_id;
	gint current_try_id;
	gint next_try_id;
	gboolean current_method_inner_error;
	ValaMethod* substring_method;
	gboolean in_plugin;
	char* module_init_param_name;
	gboolean string_h_needed;
	gboolean requires_free_checked;
	gboolean requires_array_free;
	gboolean requires_array_move;
};
#define VALA_CCODE_GENERATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGeneratorPrivate))
enum  {
	VALA_CCODE_GENERATOR_DUMMY_PROPERTY
};
static void vala_ccode_generator_real_emit (ValaCodeGenerator* base, ValaCodeContext* context);
static void vala_ccode_generator_real_visit_enum (ValaCodeVisitor* base, ValaEnum* en);
static void vala_ccode_generator_real_visit_enum_value (ValaCodeVisitor* base, ValaEnumValue* ev);
static void vala_ccode_generator_real_visit_delegate (ValaCodeVisitor* base, ValaDelegate* d);
static void vala_ccode_generator_real_visit_member (ValaCodeVisitor* base, ValaMember* m);
static void vala_ccode_generator_real_visit_constant (ValaCodeVisitor* base, ValaConstant* c);
static void vala_ccode_generator_real_visit_field (ValaCodeVisitor* base, ValaField* f);
static gboolean vala_ccode_generator_is_constant_ccode_expression (ValaCCodeGenerator* self, ValaCCodeExpression* cexpr);
static void vala_ccode_generator_real_visit_formal_parameter (ValaCodeVisitor* base, ValaFormalParameter* p);
static void vala_ccode_generator_real_visit_property (ValaCodeVisitor* base, ValaProperty* prop);
static void vala_ccode_generator_real_visit_property_accessor (ValaCodeVisitor* base, ValaPropertyAccessor* acc);
static void vala_ccode_generator_real_visit_constructor (ValaCodeVisitor* base, ValaConstructor* c);
static void vala_ccode_generator_real_visit_destructor (ValaCodeVisitor* base, ValaDestructor* d);
static void vala_ccode_generator_real_visit_block (ValaCodeVisitor* base, ValaBlock* b);
static void vala_ccode_generator_real_visit_empty_statement (ValaCodeVisitor* base, ValaEmptyStatement* stmt);
static void vala_ccode_generator_real_visit_declaration_statement (ValaCodeVisitor* base, ValaDeclarationStatement* stmt);
static char* vala_ccode_generator_get_variable_cname (ValaCCodeGenerator* self, const char* name);
static void vala_ccode_generator_real_visit_variable_declarator (ValaCodeVisitor* base, ValaVariableDeclarator* decl);
static void vala_ccode_generator_real_visit_initializer_list (ValaCodeVisitor* base, ValaInitializerList* list);
static ValaCCodeExpression* vala_ccode_generator_get_type_id_expression (ValaCCodeGenerator* self, ValaDataType* type);
static ValaCCodeExpression* vala_ccode_generator_get_dup_func_expression (ValaCCodeGenerator* self, ValaDataType* type);
static ValaCCodeExpression* vala_ccode_generator_get_destroy_func_expression (ValaCCodeGenerator* self, ValaDataType* type);
static void vala_ccode_generator_real_visit_end_full_expression (ValaCodeVisitor* base, ValaExpression* expr);
static void vala_ccode_generator_append_temp_decl (ValaCCodeGenerator* self, ValaCCodeFragment* cfrag, GeeCollection* temp_vars);
static void vala_ccode_generator_add_simple_check (ValaCCodeGenerator* self, ValaCodeNode* node, ValaCCodeFragment* cfrag);
static void vala_ccode_generator_real_visit_expression_statement (ValaCodeVisitor* base, ValaExpressionStatement* stmt);
static void vala_ccode_generator_create_temp_decl (ValaCCodeGenerator* self, ValaStatement* stmt, GeeCollection* temp_vars);
static void vala_ccode_generator_real_visit_if_statement (ValaCodeVisitor* base, ValaIfStatement* stmt);
static void vala_ccode_generator_real_visit_switch_statement (ValaCodeVisitor* base, ValaSwitchStatement* stmt);
static void vala_ccode_generator_real_visit_switch_section (ValaCodeVisitor* base, ValaSwitchSection* section);
static void vala_ccode_generator_real_visit_while_statement (ValaCodeVisitor* base, ValaWhileStatement* stmt);
static void vala_ccode_generator_real_visit_do_statement (ValaCodeVisitor* base, ValaDoStatement* stmt);
static void vala_ccode_generator_real_visit_for_statement (ValaCodeVisitor* base, ValaForStatement* stmt);
static void vala_ccode_generator_real_visit_foreach_statement (ValaCodeVisitor* base, ValaForeachStatement* stmt);
static void vala_ccode_generator_real_visit_break_statement (ValaCodeVisitor* base, ValaBreakStatement* stmt);
static void vala_ccode_generator_real_visit_continue_statement (ValaCodeVisitor* base, ValaContinueStatement* stmt);
static void vala_ccode_generator_append_local_free (ValaCCodeGenerator* self, ValaSymbol* sym, ValaCCodeFragment* cfrag, gboolean stop_at_loop);
static void vala_ccode_generator_create_local_free (ValaCCodeGenerator* self, ValaCodeNode* stmt, gboolean stop_at_loop);
static gboolean vala_ccode_generator_append_local_free_expr (ValaCCodeGenerator* self, ValaSymbol* sym, ValaCCodeCommaExpression* ccomma, gboolean stop_at_loop);
static void vala_ccode_generator_create_local_free_expr (ValaCCodeGenerator* self, ValaExpression* expr);
static void vala_ccode_generator_real_visit_return_statement (ValaCodeVisitor* base, ValaReturnStatement* stmt);
static void vala_ccode_generator_real_visit_throw_statement (ValaCodeVisitor* base, ValaThrowStatement* stmt);
static void vala_ccode_generator_real_visit_try_statement (ValaCodeVisitor* base, ValaTryStatement* stmt);
static void vala_ccode_generator_real_visit_catch_clause (ValaCodeVisitor* base, ValaCatchClause* clause);
static char* vala_ccode_generator_get_symbol_lock_name (ValaCCodeGenerator* self, ValaSymbol* sym);
static void vala_ccode_generator_real_visit_lock_statement (ValaCodeVisitor* base, ValaLockStatement* stmt);
static void vala_ccode_generator_real_visit_array_creation_expression (ValaCodeVisitor* base, ValaArrayCreationExpression* expr);
static void vala_ccode_generator_real_visit_boolean_literal (ValaCodeVisitor* base, ValaBooleanLiteral* expr);
static void vala_ccode_generator_real_visit_character_literal (ValaCodeVisitor* base, ValaCharacterLiteral* expr);
static void vala_ccode_generator_real_visit_integer_literal (ValaCodeVisitor* base, ValaIntegerLiteral* expr);
static void vala_ccode_generator_real_visit_real_literal (ValaCodeVisitor* base, ValaRealLiteral* expr);
static void vala_ccode_generator_real_visit_string_literal (ValaCodeVisitor* base, ValaStringLiteral* expr);
static void vala_ccode_generator_real_visit_null_literal (ValaCodeVisitor* base, ValaNullLiteral* expr);
static void vala_ccode_generator_real_visit_literal_expression (ValaCodeVisitor* base, ValaLiteralExpression* expr);
static void vala_ccode_generator_real_visit_parenthesized_expression (ValaCodeVisitor* base, ValaParenthesizedExpression* expr);
static char* vala_ccode_generator_get_array_length_cname (ValaCCodeGenerator* self, const char* array_cname, gint dim);
static char* vala_ccode_generator_get_delegate_target_cname (ValaCCodeGenerator* self, const char* delegate_cname);
static void vala_ccode_generator_real_visit_element_access (ValaCodeVisitor* base, ValaElementAccess* expr);
static void vala_ccode_generator_real_visit_base_access (ValaCodeVisitor* base, ValaBaseAccess* expr);
static void vala_ccode_generator_real_visit_postfix_expression (ValaCodeVisitor* base, ValaPostfixExpression* expr);
static ValaMemberAccess* vala_ccode_generator_find_property_access (ValaCCodeGenerator* self, ValaExpression* expr);
static ValaCCodeExpression* vala_ccode_generator_get_ref_expression (ValaCCodeGenerator* self, ValaExpression* expr);
static void vala_ccode_generator_real_visit_object_creation_expression (ValaCodeVisitor* base, ValaObjectCreationExpression* expr);
static void vala_ccode_generator_real_visit_sizeof_expression (ValaCodeVisitor* base, ValaSizeofExpression* expr);
static void vala_ccode_generator_real_visit_typeof_expression (ValaCodeVisitor* base, ValaTypeofExpression* expr);
static void vala_ccode_generator_real_visit_unary_expression (ValaCodeVisitor* base, ValaUnaryExpression* expr);
static void vala_ccode_generator_real_visit_cast_expression (ValaCodeVisitor* base, ValaCastExpression* expr);
static void vala_ccode_generator_real_visit_pointer_indirection (ValaCodeVisitor* base, ValaPointerIndirection* expr);
static void vala_ccode_generator_real_visit_addressof_expression (ValaCodeVisitor* base, ValaAddressofExpression* expr);
static void vala_ccode_generator_real_visit_reference_transfer_expression (ValaCodeVisitor* base, ValaReferenceTransferExpression* expr);
static void vala_ccode_generator_real_visit_binary_expression (ValaCodeVisitor* base, ValaBinaryExpression* expr);
static ValaCCodeFunctionCall* vala_ccode_generator_create_type_check (ValaCCodeNode* ccodenode, ValaTypesymbol* type);
static void vala_ccode_generator_real_visit_type_check (ValaCodeVisitor* base, ValaTypeCheck* expr);
static void vala_ccode_generator_real_visit_conditional_expression (ValaCodeVisitor* base, ValaConditionalExpression* expr);
static void vala_ccode_generator_real_visit_lambda_expression (ValaCodeVisitor* base, ValaLambdaExpression* l);
static void vala_ccode_generator_real_visit_assignment (ValaCodeVisitor* base, ValaAssignment* a);
static ValaCodeBinding* vala_ccode_generator_real_create_namespace_binding (ValaCodeGenerator* base, ValaNamespace* node);
static ValaCodeBinding* vala_ccode_generator_real_create_class_binding (ValaCodeGenerator* base, ValaClass* node);
static ValaCodeBinding* vala_ccode_generator_real_create_struct_binding (ValaCodeGenerator* base, ValaStruct* node);
static ValaCodeBinding* vala_ccode_generator_real_create_interface_binding (ValaCodeGenerator* base, ValaInterface* node);
static ValaCodeBinding* vala_ccode_generator_real_create_enum_binding (ValaCodeGenerator* base, ValaEnum* node);
static ValaCodeBinding* vala_ccode_generator_real_create_enum_value_binding (ValaCodeGenerator* base, ValaEnumValue* node);
static ValaCodeBinding* vala_ccode_generator_real_create_delegate_binding (ValaCodeGenerator* base, ValaDelegate* node);
static ValaCodeBinding* vala_ccode_generator_real_create_constant_binding (ValaCodeGenerator* base, ValaConstant* node);
static ValaCodeBinding* vala_ccode_generator_real_create_field_binding (ValaCodeGenerator* base, ValaField* node);
static ValaCodeBinding* vala_ccode_generator_real_create_method_binding (ValaCodeGenerator* base, ValaMethod* node);
static ValaCodeBinding* vala_ccode_generator_real_create_creation_method_binding (ValaCodeGenerator* base, ValaCreationMethod* node);
static ValaCodeBinding* vala_ccode_generator_real_create_formal_parameter_binding (ValaCodeGenerator* base, ValaFormalParameter* node);
static ValaCodeBinding* vala_ccode_generator_real_create_property_binding (ValaCodeGenerator* base, ValaProperty* node);
static ValaCodeBinding* vala_ccode_generator_real_create_property_accessor_binding (ValaCodeGenerator* base, ValaPropertyAccessor* node);
static ValaCodeBinding* vala_ccode_generator_real_create_signal_binding (ValaCodeGenerator* base, ValaSignal* node);
static ValaCodeBinding* vala_ccode_generator_real_create_constructor_binding (ValaCodeGenerator* base, ValaConstructor* node);
static ValaCodeBinding* vala_ccode_generator_real_create_destructor_binding (ValaCodeGenerator* base, ValaDestructor* node);
static ValaCodeBinding* vala_ccode_generator_real_create_type_parameter_binding (ValaCodeGenerator* base, ValaTypeParameter* node);
static ValaCodeBinding* vala_ccode_generator_real_create_block_binding (ValaCodeGenerator* base, ValaBlock* node);
static ValaCodeBinding* vala_ccode_generator_real_create_empty_statement_binding (ValaCodeGenerator* base, ValaEmptyStatement* node);
static ValaCodeBinding* vala_ccode_generator_real_create_declaration_statement_binding (ValaCodeGenerator* base, ValaDeclarationStatement* node);
static ValaCodeBinding* vala_ccode_generator_real_create_local_variable_declaration_binding (ValaCodeGenerator* base, ValaLocalVariableDeclaration* node);
static ValaCodeBinding* vala_ccode_generator_real_create_variable_declarator_binding (ValaCodeGenerator* base, ValaVariableDeclarator* node);
static ValaCodeBinding* vala_ccode_generator_real_create_initializer_list_binding (ValaCodeGenerator* base, ValaInitializerList* node);
static ValaCodeBinding* vala_ccode_generator_real_create_expression_statement_binding (ValaCodeGenerator* base, ValaExpressionStatement* node);
static ValaCodeBinding* vala_ccode_generator_real_create_if_statement_binding (ValaCodeGenerator* base, ValaIfStatement* node);
static ValaCodeBinding* vala_ccode_generator_real_create_switch_statement_binding (ValaCodeGenerator* base, ValaSwitchStatement* node);
static ValaCodeBinding* vala_ccode_generator_real_create_switch_section_binding (ValaCodeGenerator* base, ValaSwitchSection* node);
static ValaCodeBinding* vala_ccode_generator_real_create_switch_label_binding (ValaCodeGenerator* base, ValaSwitchLabel* node);
static ValaCodeBinding* vala_ccode_generator_real_create_while_statement_binding (ValaCodeGenerator* base, ValaWhileStatement* node);
static ValaCodeBinding* vala_ccode_generator_real_create_do_statement_binding (ValaCodeGenerator* base, ValaDoStatement* node);
static ValaCodeBinding* vala_ccode_generator_real_create_for_statement_binding (ValaCodeGenerator* base, ValaForStatement* node);
static ValaCodeBinding* vala_ccode_generator_real_create_foreach_statement_binding (ValaCodeGenerator* base, ValaForeachStatement* node);
static ValaCodeBinding* vala_ccode_generator_real_create_break_statement_binding (ValaCodeGenerator* base, ValaBreakStatement* node);
static ValaCodeBinding* vala_ccode_generator_real_create_continue_statement_binding (ValaCodeGenerator* base, ValaContinueStatement* node);
static ValaCodeBinding* vala_ccode_generator_real_create_return_statement_binding (ValaCodeGenerator* base, ValaReturnStatement* node);
static ValaCodeBinding* vala_ccode_generator_real_create_throw_statement_binding (ValaCodeGenerator* base, ValaThrowStatement* node);
static ValaCodeBinding* vala_ccode_generator_real_create_try_statement_binding (ValaCodeGenerator* base, ValaTryStatement* node);
static ValaCodeBinding* vala_ccode_generator_real_create_catch_clause_binding (ValaCodeGenerator* base, ValaCatchClause* node);
static ValaCodeBinding* vala_ccode_generator_real_create_lock_statement_binding (ValaCodeGenerator* base, ValaLockStatement* node);
static ValaCodeBinding* vala_ccode_generator_real_create_array_creation_expression_binding (ValaCodeGenerator* base, ValaArrayCreationExpression* node);
static ValaCodeBinding* vala_ccode_generator_real_create_boolean_literal_binding (ValaCodeGenerator* base, ValaBooleanLiteral* node);
static ValaCodeBinding* vala_ccode_generator_real_create_character_literal_binding (ValaCodeGenerator* base, ValaCharacterLiteral* node);
static ValaCodeBinding* vala_ccode_generator_real_create_integer_literal_binding (ValaCodeGenerator* base, ValaIntegerLiteral* node);
static ValaCodeBinding* vala_ccode_generator_real_create_real_literal_binding (ValaCodeGenerator* base, ValaRealLiteral* node);
static ValaCodeBinding* vala_ccode_generator_real_create_string_literal_binding (ValaCodeGenerator* base, ValaStringLiteral* node);
static ValaCodeBinding* vala_ccode_generator_real_create_null_literal_binding (ValaCodeGenerator* base, ValaNullLiteral* node);
static ValaCodeBinding* vala_ccode_generator_real_create_literal_expression_binding (ValaCodeGenerator* base, ValaLiteralExpression* node);
static ValaCodeBinding* vala_ccode_generator_real_create_parenthesized_expression_binding (ValaCodeGenerator* base, ValaParenthesizedExpression* node);
static ValaCodeBinding* vala_ccode_generator_real_create_member_access_binding (ValaCodeGenerator* base, ValaMemberAccess* node);
static ValaCodeBinding* vala_ccode_generator_real_create_member_access_simple_binding (ValaCodeGenerator* base, ValaMemberAccess* node);
static ValaCodeBinding* vala_ccode_generator_real_create_invocation_expression_binding (ValaCodeGenerator* base, ValaInvocationExpression* node);
static ValaCodeBinding* vala_ccode_generator_real_create_element_access_binding (ValaCodeGenerator* base, ValaElementAccess* node);
static ValaCodeBinding* vala_ccode_generator_real_create_base_access_binding (ValaCodeGenerator* base, ValaBaseAccess* node);
static ValaCodeBinding* vala_ccode_generator_real_create_postfix_expression_binding (ValaCodeGenerator* base, ValaPostfixExpression* node);
static ValaCodeBinding* vala_ccode_generator_real_create_object_creation_expression_binding (ValaCodeGenerator* base, ValaObjectCreationExpression* node);
static ValaCodeBinding* vala_ccode_generator_real_create_sizeof_expression_binding (ValaCodeGenerator* base, ValaSizeofExpression* node);
static ValaCodeBinding* vala_ccode_generator_real_create_typeof_expression_binding (ValaCodeGenerator* base, ValaTypeofExpression* node);
static ValaCodeBinding* vala_ccode_generator_real_create_unary_expression_binding (ValaCodeGenerator* base, ValaUnaryExpression* node);
static ValaCodeBinding* vala_ccode_generator_real_create_cast_expression_binding (ValaCodeGenerator* base, ValaCastExpression* node);
static ValaCodeBinding* vala_ccode_generator_real_create_pointer_indirection_binding (ValaCodeGenerator* base, ValaPointerIndirection* node);
static ValaCodeBinding* vala_ccode_generator_real_create_addressof_expression_binding (ValaCodeGenerator* base, ValaAddressofExpression* node);
static ValaCodeBinding* vala_ccode_generator_real_create_reference_transfer_expression_binding (ValaCodeGenerator* base, ValaReferenceTransferExpression* node);
static ValaCodeBinding* vala_ccode_generator_real_create_binary_expression_binding (ValaCodeGenerator* base, ValaBinaryExpression* node);
static ValaCodeBinding* vala_ccode_generator_real_create_type_check_binding (ValaCodeGenerator* base, ValaTypeCheck* node);
static ValaCodeBinding* vala_ccode_generator_real_create_conditional_expression_binding (ValaCodeGenerator* base, ValaConditionalExpression* node);
static ValaCodeBinding* vala_ccode_generator_real_create_lambda_expression_binding (ValaCodeGenerator* base, ValaLambdaExpression* node);
static ValaCodeBinding* vala_ccode_generator_real_create_lambda_expression_with_statement_body_binding (ValaCodeGenerator* base, ValaLambdaExpression* node);
static ValaCodeBinding* vala_ccode_generator_real_create_assignment_binding (ValaCodeGenerator* base, ValaAssignment* node);
static void vala_ccode_generator_real_visit_class (ValaCodeVisitor* base, ValaClass* cl);
static void vala_ccode_generator_add_class_init_function (ValaCCodeGenerator* self, ValaClass* cl);
static void vala_ccode_generator_add_interface_init_function (ValaCCodeGenerator* self, ValaClass* cl, ValaInterface* iface);
static void vala_ccode_generator_add_instance_init_function (ValaCCodeGenerator* self, ValaClass* cl);
static void vala_ccode_generator_add_dispose_function (ValaCCodeGenerator* self, ValaClass* cl);
static gboolean vala_ccode_generator_class_has_readable_properties (ValaCCodeGenerator* self, ValaClass* cl);
static gboolean vala_ccode_generator_class_has_writable_properties (ValaCCodeGenerator* self, ValaClass* cl);
static void vala_ccode_generator_add_get_property_function (ValaCCodeGenerator* self, ValaClass* cl);
static void vala_ccode_generator_add_set_property_function (ValaCCodeGenerator* self, ValaClass* cl);
static ValaCCodeStatement* vala_ccode_generator_get_invalid_property_id_warn_statement (ValaCCodeGenerator* self);
static void vala_ccode_generator_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface);
static ValaCCodeFunctionCall* vala_ccode_generator_get_param_spec (ValaCCodeGenerator* self, ValaProperty* prop);
static ValaCCodeFunctionCall* vala_ccode_generator_get_signal_creation (ValaCCodeGenerator* self, ValaSignal* sig, ValaTypesymbol* type);
static void vala_ccode_generator_add_interface_base_init_function (ValaCCodeGenerator* self, ValaInterface* iface);
static void vala_ccode_generator_real_visit_invocation_expression (ValaCodeVisitor* base, ValaInvocationExpression* expr);
static ValaCCodeExpression* vala_ccode_generator_get_dbus_array_type (ValaCCodeGenerator* self, ValaArray* array);
static void vala_ccode_generator_process_cmember (ValaCCodeGenerator* self, ValaMemberAccess* expr, ValaCCodeExpression* pub_inst, ValaDataType* base_type);
static void vala_ccode_generator_real_visit_member_access (ValaCodeVisitor* base, ValaMemberAccess* expr);
static void vala_ccode_generator_real_visit_method (ValaCodeVisitor* base, ValaMethod* m);
static ValaCCodeStatement* vala_ccode_generator_create_method_type_check_statement (ValaCCodeGenerator* self, ValaMethod* m, ValaDataType* return_type, ValaTypesymbol* t, gboolean non_null, const char* var_name);
static ValaCCodeStatement* vala_ccode_generator_create_property_type_check_statement (ValaCCodeGenerator* self, ValaProperty* prop, gboolean getter, ValaTypesymbol* t, gboolean non_null, const char* var_name);
static ValaCCodeStatement* vala_ccode_generator_create_type_check_statement (ValaCCodeGenerator* self, ValaCodeNode* method_node, ValaDataType* ret_type, ValaTypesymbol* t, gboolean non_null, const char* var_name);
static ValaCCodeStatement* vala_ccode_generator_create_precondition_statement (ValaCCodeGenerator* self, ValaCodeNode* method_node, ValaDataType* ret_type, ValaExpression* precondition);
static ValaCCodeStatement* vala_ccode_generator_create_postcondition_statement (ValaCCodeGenerator* self, ValaExpression* postcondition);
static ValaCCodeExpression* vala_ccode_generator_default_value_for_type (ValaCCodeGenerator* self, ValaDataType* type);
static ValaTypesymbol* vala_ccode_generator_find_parent_type (ValaCCodeGenerator* self, ValaSymbol* sym);
static void vala_ccode_generator_real_visit_creation_method (ValaCodeVisitor* base, ValaCreationMethod* m);
static gboolean vala_ccode_generator_is_possible_entry_point (ValaCCodeGenerator* self, ValaMethod* m, gboolean* return_value, gboolean* args_parameter);
static void vala_ccode_generator_add_object_creation (ValaCCodeGenerator* self, ValaCCodeBlock* b, gboolean has_params);
static ValaClass* vala_ccode_generator_find_fundamental_class (ValaCCodeGenerator* self, ValaClass* cl);
static char* vala_ccode_generator_get_marshaller_type_name (ValaCCodeGenerator* self, ValaDataType* t);
static char* vala_ccode_generator_get_value_type_name_from_type_reference (ValaCCodeGenerator* self, ValaDataType* t);
static char* vala_ccode_generator_get_signal_signature (ValaCCodeGenerator* self, ValaSignal* sig);
static void vala_ccode_generator_real_visit_signal (ValaCodeVisitor* base, ValaSignal* sig);
static ValaCCodeIncludeDirective* vala_ccode_generator_get_internal_include (ValaCCodeGenerator* self, const char* filename);
static ValaCCodeForStatement* vala_ccode_generator_get_vala_array_free_loop (ValaCCodeGenerator* self, gboolean have_length);
static void vala_ccode_generator_append_vala_array_free (ValaCCodeGenerator* self);
static void vala_ccode_generator_append_vala_array_move (ValaCCodeGenerator* self);
static void vala_ccode_generator_real_visit_source_file (ValaCodeVisitor* base, ValaSourceFile* source_file);
static char* vala_ccode_generator_get_define_for_filename (const char* filename);
static void vala_ccode_generator_real_visit_struct (ValaCodeVisitor* base, ValaStruct* st);
static GObject * vala_ccode_generator_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer vala_ccode_generator_parent_class = NULL;
static void vala_ccode_generator_dispose (GObject * obj);


ValaCCodeGenerator* vala_ccode_generator_new (void) {
	ValaCCodeGenerator * self;
	self = g_object_newv (VALA_TYPE_CCODE_GENERATOR, 0, NULL);
	return self;
}


static void vala_ccode_generator_real_emit (ValaCodeGenerator* base, ValaCodeContext* context) {
	ValaCCodeGenerator * self;
	ValaCodeContext* _tmp1;
	ValaCodeContext* _tmp0;
	ValaSymbol* _tmp3;
	ValaNamespace* _tmp2;
	ValaDataType* _tmp5;
	ValaTypesymbol* _tmp4;
	ValaDataType* _tmp7;
	ValaTypesymbol* _tmp6;
	ValaDataType* _tmp9;
	ValaTypesymbol* _tmp8;
	ValaDataType* _tmp11;
	ValaTypesymbol* _tmp10;
	ValaDataType* _tmp13;
	ValaTypesymbol* _tmp12;
	ValaDataType* _tmp15;
	ValaTypesymbol* _tmp14;
	ValaDataType* _tmp17;
	ValaTypesymbol* _tmp16;
	ValaDataType* _tmp19;
	ValaTypesymbol* _tmp18;
	ValaDataType* _tmp21;
	ValaTypesymbol* _tmp20;
	ValaDataType* _tmp23;
	ValaTypesymbol* _tmp22;
	ValaDataType* _tmp25;
	ValaTypesymbol* _tmp24;
	ValaDataType* _tmp27;
	ValaTypesymbol* _tmp26;
	ValaDataType* _tmp29;
	ValaTypesymbol* _tmp28;
	ValaDataType* _tmp31;
	ValaClass* _tmp30;
	ValaMethod* _tmp32;
	ValaSymbol* glib_ns;
	ValaTypesymbol* _tmp33;
	ValaTypesymbol* _tmp34;
	ValaTypesymbol* _tmp35;
	ValaTypesymbol* _tmp36;
	ValaTypesymbol* _tmp37;
	ValaTypesymbol* _tmp38;
	ValaTypesymbol* _tmp39;
	ValaDataType* _tmp41;
	ValaTypesymbol* _tmp40;
	ValaDataType* _tmp43;
	ValaClass* _tmp42;
	ValaTypesymbol* _tmp44;
	ValaSymbol* gee_ns;
	ValaSymbol* dbus_ns;
	GeeCollection* source_files;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (context == NULL || VALA_IS_CODE_CONTEXT (context));
	_tmp1 = NULL;
	_tmp0 = NULL;
	self->priv->context = (_tmp1 = (_tmp0 = context, (_tmp0 == NULL ? NULL : g_object_ref (_tmp0))), (self->priv->context == NULL ? NULL : (self->priv->context = (g_object_unref (self->priv->context), NULL))), _tmp1);
	vala_code_context_find_header_cycles (context);
	_tmp3 = NULL;
	_tmp2 = NULL;
	self->priv->root_symbol = (_tmp3 = VALA_SYMBOL ((_tmp2 = vala_code_context_get_root (context), (_tmp2 == NULL ? NULL : g_object_ref (_tmp2)))), (self->priv->root_symbol == NULL ? NULL : (self->priv->root_symbol = (g_object_unref (self->priv->root_symbol), NULL))), _tmp3);
	_tmp5 = NULL;
	_tmp4 = NULL;
	self->bool_type = (_tmp5 = VALA_DATA_TYPE (vala_value_type_new ((_tmp4 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), "bool"))))), (self->bool_type == NULL ? NULL : (self->bool_type = (g_object_unref (self->bool_type), NULL))), _tmp5);
	(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
	_tmp7 = NULL;
	_tmp6 = NULL;
	self->char_type = (_tmp7 = VALA_DATA_TYPE (vala_value_type_new ((_tmp6 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), "char"))))), (self->char_type == NULL ? NULL : (self->char_type = (g_object_unref (self->char_type), NULL))), _tmp7);
	(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
	_tmp9 = NULL;
	_tmp8 = NULL;
	self->unichar_type = (_tmp9 = VALA_DATA_TYPE (vala_value_type_new ((_tmp8 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), "unichar"))))), (self->unichar_type == NULL ? NULL : (self->unichar_type = (g_object_unref (self->unichar_type), NULL))), _tmp9);
	(_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL)));
	_tmp11 = NULL;
	_tmp10 = NULL;
	self->short_type = (_tmp11 = VALA_DATA_TYPE (vala_value_type_new ((_tmp10 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), "short"))))), (self->short_type == NULL ? NULL : (self->short_type = (g_object_unref (self->short_type), NULL))), _tmp11);
	(_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL)));
	_tmp13 = NULL;
	_tmp12 = NULL;
	self->ushort_type = (_tmp13 = VALA_DATA_TYPE (vala_value_type_new ((_tmp12 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), "ushort"))))), (self->ushort_type == NULL ? NULL : (self->ushort_type = (g_object_unref (self->ushort_type), NULL))), _tmp13);
	(_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL)));
	_tmp15 = NULL;
	_tmp14 = NULL;
	self->int_type = (_tmp15 = VALA_DATA_TYPE (vala_value_type_new ((_tmp14 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), "int"))))), (self->int_type == NULL ? NULL : (self->int_type = (g_object_unref (self->int_type), NULL))), _tmp15);
	(_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL)));
	_tmp17 = NULL;
	_tmp16 = NULL;
	self->uint_type = (_tmp17 = VALA_DATA_TYPE (vala_value_type_new ((_tmp16 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), "uint"))))), (self->uint_type == NULL ? NULL : (self->uint_type = (g_object_unref (self->uint_type), NULL))), _tmp17);
	(_tmp16 == NULL ? NULL : (_tmp16 = (g_object_unref (_tmp16), NULL)));
	_tmp19 = NULL;
	_tmp18 = NULL;
	self->long_type = (_tmp19 = VALA_DATA_TYPE (vala_value_type_new ((_tmp18 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), "long"))))), (self->long_type == NULL ? NULL : (self->long_type = (g_object_unref (self->long_type), NULL))), _tmp19);
	(_tmp18 == NULL ? NULL : (_tmp18 = (g_object_unref (_tmp18), NULL)));
	_tmp21 = NULL;
	_tmp20 = NULL;
	self->ulong_type = (_tmp21 = VALA_DATA_TYPE (vala_value_type_new ((_tmp20 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), "ulong"))))), (self->ulong_type == NULL ? NULL : (self->ulong_type = (g_object_unref (self->ulong_type), NULL))), _tmp21);
	(_tmp20 == NULL ? NULL : (_tmp20 = (g_object_unref (_tmp20), NULL)));
	_tmp23 = NULL;
	_tmp22 = NULL;
	self->int64_type = (_tmp23 = VALA_DATA_TYPE (vala_value_type_new ((_tmp22 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), "int64"))))), (self->int64_type == NULL ? NULL : (self->int64_type = (g_object_unref (self->int64_type), NULL))), _tmp23);
	(_tmp22 == NULL ? NULL : (_tmp22 = (g_object_unref (_tmp22), NULL)));
	_tmp25 = NULL;
	_tmp24 = NULL;
	self->uint64_type = (_tmp25 = VALA_DATA_TYPE (vala_value_type_new ((_tmp24 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), "uint64"))))), (self->uint64_type == NULL ? NULL : (self->uint64_type = (g_object_unref (self->uint64_type), NULL))), _tmp25);
	(_tmp24 == NULL ? NULL : (_tmp24 = (g_object_unref (_tmp24), NULL)));
	_tmp27 = NULL;
	_tmp26 = NULL;
	self->float_type = (_tmp27 = VALA_DATA_TYPE (vala_value_type_new ((_tmp26 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), "float"))))), (self->float_type == NULL ? NULL : (self->float_type = (g_object_unref (self->float_type), NULL))), _tmp27);
	(_tmp26 == NULL ? NULL : (_tmp26 = (g_object_unref (_tmp26), NULL)));
	_tmp29 = NULL;
	_tmp28 = NULL;
	self->double_type = (_tmp29 = VALA_DATA_TYPE (vala_value_type_new ((_tmp28 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), "double"))))), (self->double_type == NULL ? NULL : (self->double_type = (g_object_unref (self->double_type), NULL))), _tmp29);
	(_tmp28 == NULL ? NULL : (_tmp28 = (g_object_unref (_tmp28), NULL)));
	_tmp31 = NULL;
	_tmp30 = NULL;
	self->string_type = (_tmp31 = VALA_DATA_TYPE (vala_class_type_new ((_tmp30 = VALA_CLASS (vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), "string"))))), (self->string_type == NULL ? NULL : (self->string_type = (g_object_unref (self->string_type), NULL))), _tmp31);
	(_tmp30 == NULL ? NULL : (_tmp30 = (g_object_unref (_tmp30), NULL)));
	_tmp32 = NULL;
	self->priv->substring_method = (_tmp32 = VALA_METHOD (vala_scope_lookup (vala_symbol_get_scope (VALA_SYMBOL (vala_data_type_get_data_type (self->string_type))), "substring")), (self->priv->substring_method == NULL ? NULL : (self->priv->substring_method = (g_object_unref (self->priv->substring_method), NULL))), _tmp32);
	glib_ns = vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), "GLib");
	_tmp33 = NULL;
	self->gtypeinstance_type = (_tmp33 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "TypeInstance")), (self->gtypeinstance_type == NULL ? NULL : (self->gtypeinstance_type = (g_object_unref (self->gtypeinstance_type), NULL))), _tmp33);
	_tmp34 = NULL;
	self->gobject_type = (_tmp34 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "Object")), (self->gobject_type == NULL ? NULL : (self->gobject_type = (g_object_unref (self->gobject_type), NULL))), _tmp34);
	_tmp35 = NULL;
	self->gerror_type = (_tmp35 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "Error")), (self->gerror_type == NULL ? NULL : (self->gerror_type = (g_object_unref (self->gerror_type), NULL))), _tmp35);
	_tmp36 = NULL;
	self->glist_type = (_tmp36 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "List")), (self->glist_type == NULL ? NULL : (self->glist_type = (g_object_unref (self->glist_type), NULL))), _tmp36);
	_tmp37 = NULL;
	self->gslist_type = (_tmp37 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "SList")), (self->gslist_type == NULL ? NULL : (self->gslist_type = (g_object_unref (self->gslist_type), NULL))), _tmp37);
	_tmp38 = NULL;
	self->gstring_type = (_tmp38 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "String")), (self->gstring_type == NULL ? NULL : (self->gstring_type = (g_object_unref (self->gstring_type), NULL))), _tmp38);
	_tmp39 = NULL;
	self->garray_type = (_tmp39 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "Array")), (self->garray_type == NULL ? NULL : (self->garray_type = (g_object_unref (self->garray_type), NULL))), _tmp39);
	_tmp41 = NULL;
	_tmp40 = NULL;
	self->gquark_type = (_tmp41 = VALA_DATA_TYPE (vala_value_type_new ((_tmp40 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "Quark"))))), (self->gquark_type == NULL ? NULL : (self->gquark_type = (g_object_unref (self->gquark_type), NULL))), _tmp41);
	(_tmp40 == NULL ? NULL : (_tmp40 = (g_object_unref (_tmp40), NULL)));
	_tmp43 = NULL;
	_tmp42 = NULL;
	self->mutex_type = (_tmp43 = VALA_DATA_TYPE (vala_class_type_new ((_tmp42 = VALA_CLASS (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "Mutex"))))), (self->mutex_type == NULL ? NULL : (self->mutex_type = (g_object_unref (self->mutex_type), NULL))), _tmp43);
	(_tmp42 == NULL ? NULL : (_tmp42 = (g_object_unref (_tmp42), NULL)));
	_tmp44 = NULL;
	self->type_module_type = (_tmp44 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "TypeModule")), (self->type_module_type == NULL ? NULL : (self->type_module_type = (g_object_unref (self->type_module_type), NULL))), _tmp44);
	if (vala_code_context_get_module_init_method (context) != NULL) {
		ValaCCodeFragment* _tmp45;
		_tmp45 = NULL;
		self->priv->module_init_fragment = (_tmp45 = vala_ccode_fragment_new (), (self->priv->module_init_fragment == NULL ? NULL : (self->priv->module_init_fragment = (g_object_unref (self->priv->module_init_fragment), NULL))), _tmp45);
		{
			GeeCollection* parameter_collection;
			GeeIterator* parameter_it;
			parameter_collection = vala_method_get_parameters (vala_code_context_get_module_init_method (context));
			parameter_it = gee_iterable_iterator (GEE_ITERABLE (parameter_collection));
			while (gee_iterator_next (parameter_it)) {
				ValaFormalParameter* parameter;
				parameter = gee_iterator_get (parameter_it);
				{
					if (vala_data_type_get_data_type (vala_formal_parameter_get_type_reference (parameter)) == self->type_module_type) {
						char* _tmp47;
						const char* _tmp46;
						self->priv->in_plugin = TRUE;
						_tmp47 = NULL;
						_tmp46 = NULL;
						self->priv->module_init_param_name = (_tmp47 = (_tmp46 = vala_symbol_get_name (VALA_SYMBOL (parameter)), (_tmp46 == NULL ? NULL : g_strdup (_tmp46))), (self->priv->module_init_param_name = (g_free (self->priv->module_init_param_name), NULL)), _tmp47);
						(parameter == NULL ? NULL : (parameter = (g_object_unref (parameter), NULL)));
						break;
					}
					(parameter == NULL ? NULL : (parameter = (g_object_unref (parameter), NULL)));
				}
			}
			(parameter_collection == NULL ? NULL : (parameter_collection = (g_object_unref (parameter_collection), NULL)));
			(parameter_it == NULL ? NULL : (parameter_it = (g_object_unref (parameter_it), NULL)));
		}
	}
	gee_ns = vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), "Gee");
	if (gee_ns != NULL) {
		ValaTypesymbol* _tmp48;
		ValaTypesymbol* _tmp49;
		ValaTypesymbol* _tmp50;
		ValaTypesymbol* _tmp51;
		_tmp48 = NULL;
		self->iterable_type = (_tmp48 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (gee_ns), "Iterable")), (self->iterable_type == NULL ? NULL : (self->iterable_type = (g_object_unref (self->iterable_type), NULL))), _tmp48);
		_tmp49 = NULL;
		self->iterator_type = (_tmp49 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (gee_ns), "Iterator")), (self->iterator_type == NULL ? NULL : (self->iterator_type = (g_object_unref (self->iterator_type), NULL))), _tmp49);
		_tmp50 = NULL;
		self->list_type = (_tmp50 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (gee_ns), "List")), (self->list_type == NULL ? NULL : (self->list_type = (g_object_unref (self->list_type), NULL))), _tmp50);
		_tmp51 = NULL;
		self->map_type = (_tmp51 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (gee_ns), "Map")), (self->map_type == NULL ? NULL : (self->map_type = (g_object_unref (self->map_type), NULL))), _tmp51);
	}
	dbus_ns = vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), "DBus");
	if (dbus_ns != NULL) {
		ValaTypesymbol* _tmp52;
		_tmp52 = NULL;
		self->connection_type = (_tmp52 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (dbus_ns), "Connection")), (self->connection_type == NULL ? NULL : (self->connection_type = (g_object_unref (self->connection_type), NULL))), _tmp52);
	}
	/* we're only interested in non-pkg source files */
	source_files = vala_code_context_get_source_files (context);
	{
		GeeCollection* file_collection;
		GeeIterator* file_it;
		file_collection = source_files;
		file_it = gee_iterable_iterator (GEE_ITERABLE (file_collection));
		while (gee_iterator_next (file_it)) {
			ValaSourceFile* file;
			file = gee_iterator_get (file_it);
			{
				if (!vala_source_file_get_pkg (file)) {
					vala_source_file_accept (file, VALA_CODE_VISITOR (self));
				}
				(file == NULL ? NULL : (file = (g_object_unref (file), NULL)));
			}
		}
		(file_it == NULL ? NULL : (file_it = (g_object_unref (file_it), NULL)));
	}
	(glib_ns == NULL ? NULL : (glib_ns = (g_object_unref (glib_ns), NULL)));
	(gee_ns == NULL ? NULL : (gee_ns = (g_object_unref (gee_ns), NULL)));
	(dbus_ns == NULL ? NULL : (dbus_ns = (g_object_unref (dbus_ns), NULL)));
	(source_files == NULL ? NULL : (source_files = (g_object_unref (source_files), NULL)));
}


static void vala_ccode_generator_real_visit_enum (ValaCodeVisitor* base, ValaEnum* en) {
	ValaCCodeGenerator * self;
	ValaCCodeEnum* _tmp1;
	char* _tmp0;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (en == NULL || VALA_IS_ENUM (en));
	_tmp1 = NULL;
	_tmp0 = NULL;
	self->priv->cenum = (_tmp1 = vala_ccode_enum_new ((_tmp0 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (en), FALSE))), (self->priv->cenum == NULL ? NULL : (self->priv->cenum = (g_object_unref (self->priv->cenum), NULL))), _tmp1);
	(_tmp0 = (g_free (_tmp0), NULL));
	if (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (en))) != NULL) {
		ValaCCodeComment* _tmp2;
		_tmp2 = NULL;
		vala_ccode_fragment_append (self->priv->header_type_definition, VALA_CCODE_NODE ((_tmp2 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (en)))))));
		(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
	}
	vala_ccode_fragment_append (self->priv->header_type_definition, VALA_CCODE_NODE (self->priv->cenum));
	vala_code_node_accept_children (VALA_CODE_NODE (en), VALA_CODE_VISITOR (self));
	if (vala_enum_get_error_domain (en)) {
		char* _tmp3;
		char* _tmp4;
		char* quark_fun_name;
		char* _tmp6;
		char* _tmp5;
		ValaCCodeMacroReplacement* _tmp7;
		ValaCCodeMacroReplacement* error_domain_define;
		char* _tmp8;
		ValaCCodeFunction* _tmp9;
		ValaCCodeFunction* cquark_fun;
		ValaCCodeBlock* cquark_block;
		ValaCCodeIdentifier* _tmp10;
		ValaCCodeFunctionCall* _tmp11;
		ValaCCodeFunctionCall* cquark_call;
		ValaCCodeConstant* _tmp15;
		char* _tmp14;
		char* _tmp13;
		char* _tmp12;
		ValaCCodeReturnStatement* _tmp16;
		ValaCCodeFunction* _tmp17;
		_tmp3 = NULL;
		_tmp4 = NULL;
		quark_fun_name = (_tmp4 = g_strconcat ((_tmp3 = vala_symbol_get_lower_case_cprefix (VALA_SYMBOL (en))), "quark", NULL), (_tmp3 = (g_free (_tmp3), NULL)), _tmp4);
		_tmp6 = NULL;
		_tmp5 = NULL;
		_tmp7 = NULL;
		error_domain_define = (_tmp7 = vala_ccode_macro_replacement_new ((_tmp5 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (en), NULL)), (_tmp6 = g_strconcat (quark_fun_name, " ()", NULL))), (_tmp6 = (g_free (_tmp6), NULL)), (_tmp5 = (g_free (_tmp5), NULL)), _tmp7);
		vala_ccode_fragment_append (self->priv->header_type_definition, VALA_CCODE_NODE (error_domain_define));
		_tmp8 = NULL;
		_tmp9 = NULL;
		cquark_fun = (_tmp9 = vala_ccode_function_new (quark_fun_name, (_tmp8 = vala_typesymbol_get_cname (vala_data_type_get_data_type (self->gquark_type), FALSE))), (_tmp8 = (g_free (_tmp8), NULL)), _tmp9);
		cquark_block = vala_ccode_block_new ();
		_tmp10 = NULL;
		_tmp11 = NULL;
		cquark_call = (_tmp11 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp10 = vala_ccode_identifier_new ("g_quark_from_static_string")))), (_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL))), _tmp11);
		_tmp15 = NULL;
		_tmp14 = NULL;
		_tmp13 = NULL;
		_tmp12 = NULL;
		vala_ccode_function_call_add_argument (cquark_call, VALA_CCODE_EXPRESSION ((_tmp15 = vala_ccode_constant_new ((_tmp14 = g_strconcat ((_tmp13 = g_strconcat ("\"", (_tmp12 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (en), NULL)), NULL)), "-quark\"", NULL))))));
		(_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL)));
		(_tmp14 = (g_free (_tmp14), NULL));
		(_tmp13 = (g_free (_tmp13), NULL));
		(_tmp12 = (g_free (_tmp12), NULL));
		_tmp16 = NULL;
		vala_ccode_block_add_statement (cquark_block, VALA_CCODE_NODE ((_tmp16 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION (cquark_call)))));
		(_tmp16 == NULL ? NULL : (_tmp16 = (g_object_unref (_tmp16), NULL)));
		_tmp17 = NULL;
		vala_ccode_fragment_append (self->priv->header_type_member_declaration, VALA_CCODE_NODE ((_tmp17 = vala_ccode_function_copy (cquark_fun))));
		(_tmp17 == NULL ? NULL : (_tmp17 = (g_object_unref (_tmp17), NULL)));
		vala_ccode_function_set_block (cquark_fun, cquark_block);
		vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (cquark_fun));
		(quark_fun_name = (g_free (quark_fun_name), NULL));
		(error_domain_define == NULL ? NULL : (error_domain_define = (g_object_unref (error_domain_define), NULL)));
		(cquark_fun == NULL ? NULL : (cquark_fun = (g_object_unref (cquark_fun), NULL)));
		(cquark_block == NULL ? NULL : (cquark_block = (g_object_unref (cquark_block), NULL)));
		(cquark_call == NULL ? NULL : (cquark_call = (g_object_unref (cquark_call), NULL)));
	}
}


static void vala_ccode_generator_real_visit_enum_value (ValaCodeVisitor* base, ValaEnumValue* ev) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (ev == NULL || VALA_IS_ENUM_VALUE (ev));
	if (vala_enum_value_get_value (ev) == NULL) {
		ValaCCodeEnumValue* _tmp1;
		char* _tmp0;
		_tmp1 = NULL;
		_tmp0 = NULL;
		vala_ccode_enum_add_value (self->priv->cenum, (_tmp1 = vala_ccode_enum_value_new ((_tmp0 = vala_enum_value_get_cname (ev)), NULL)));
		(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
		(_tmp0 = (g_free (_tmp0), NULL));
	} else {
		ValaCCodeEnumValue* _tmp3;
		char* _tmp2;
		vala_code_node_accept (VALA_CODE_NODE (vala_enum_value_get_value (ev)), VALA_CODE_VISITOR (self));
		_tmp3 = NULL;
		_tmp2 = NULL;
		vala_ccode_enum_add_value (self->priv->cenum, (_tmp3 = vala_ccode_enum_value_new ((_tmp2 = vala_enum_value_get_cname (ev)), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_enum_value_get_value (ev)))))));
		(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
		(_tmp2 = (g_free (_tmp2), NULL));
	}
}


static void vala_ccode_generator_real_visit_delegate (ValaCodeVisitor* base, ValaDelegate* d) {
	ValaCCodeGenerator * self;
	char* _tmp0;
	ValaCCodeFunctionDeclarator* _tmp1;
	ValaCCodeFunctionDeclarator* cfundecl;
	char* _tmp2;
	ValaCCodeTypeDefinition* _tmp3;
	ValaCCodeTypeDefinition* ctypedef;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (d == NULL || VALA_IS_DELEGATE (d));
	vala_code_node_accept_children (VALA_CODE_NODE (d), VALA_CODE_VISITOR (self));
	_tmp0 = NULL;
	_tmp1 = NULL;
	cfundecl = (_tmp1 = vala_ccode_function_declarator_new ((_tmp0 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (d), FALSE))), (_tmp0 = (g_free (_tmp0), NULL)), _tmp1);
	{
		GeeCollection* param_collection;
		GeeIterator* param_it;
		param_collection = vala_delegate_get_parameters (d);
		param_it = gee_iterable_iterator (GEE_ITERABLE (param_collection));
		while (gee_iterator_next (param_it)) {
			ValaFormalParameter* param;
			param = gee_iterator_get (param_it);
			{
				vala_ccode_function_declarator_add_parameter (cfundecl, VALA_CCODE_FORMAL_PARAMETER (vala_code_node_get_ccodenode (VALA_CODE_NODE (param))));
				(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
			}
		}
		(param_collection == NULL ? NULL : (param_collection = (g_object_unref (param_collection), NULL)));
		(param_it == NULL ? NULL : (param_it = (g_object_unref (param_it), NULL)));
	}
	if (vala_delegate_get_instance (d)) {
		ValaCCodeFormalParameter* cparam;
		cparam = vala_ccode_formal_parameter_new ("user_data", "void*");
		vala_ccode_function_declarator_add_parameter (cfundecl, cparam);
		(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
	}
	_tmp2 = NULL;
	_tmp3 = NULL;
	ctypedef = (_tmp3 = vala_ccode_type_definition_new ((_tmp2 = vala_data_type_get_cname (vala_delegate_get_return_type (d), FALSE, FALSE)), VALA_CCODE_DECLARATOR (cfundecl)), (_tmp2 = (g_free (_tmp2), NULL)), _tmp3);
	if (!vala_symbol_is_internal_symbol (VALA_SYMBOL (d))) {
		vala_ccode_fragment_append (self->priv->header_type_definition, VALA_CCODE_NODE (ctypedef));
	} else {
		vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE (ctypedef));
	}
	(cfundecl == NULL ? NULL : (cfundecl = (g_object_unref (cfundecl), NULL)));
	(ctypedef == NULL ? NULL : (ctypedef = (g_object_unref (ctypedef), NULL)));
}


static void vala_ccode_generator_real_visit_member (ValaCodeVisitor* base, ValaMember* m) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (m == NULL || VALA_IS_MEMBER (m));
	/* stuff meant for all lockable members */
	if (VALA_IS_LOCKABLE (m) && vala_lockable_get_lock_used ((VALA_LOCKABLE (m)))) {
		char* _tmp1;
		char* _tmp0;
		ValaCCodeExpressionStatement* _tmp10;
		ValaCCodeAssignment* _tmp9;
		ValaCCodeFunctionCall* _tmp8;
		ValaCCodeIdentifier* _tmp7;
		char* _tmp6;
		ValaCCodeMemberAccess* _tmp5;
		char* _tmp4;
		ValaCCodeMemberAccess* _tmp3;
		ValaCCodeIdentifier* _tmp2;
		ValaCCodeIdentifier* _tmp11;
		ValaCCodeFunctionCall* _tmp12;
		ValaCCodeFunctionCall* fc;
		ValaCCodeMemberAccess* _tmp16;
		char* _tmp15;
		ValaCCodeMemberAccess* _tmp14;
		ValaCCodeIdentifier* _tmp13;
		char* _tmp17;
		gboolean _tmp18;
		ValaCCodeIdentifier* _tmp22;
		char* _tmp21;
		_tmp1 = NULL;
		_tmp0 = NULL;
		vala_ccode_struct_add_field (self->priv->instance_priv_struct, (_tmp0 = vala_data_type_get_cname (self->mutex_type, FALSE, FALSE)), (_tmp1 = vala_ccode_generator_get_symbol_lock_name (self, VALA_SYMBOL (m))));
		(_tmp1 = (g_free (_tmp1), NULL));
		(_tmp0 = (g_free (_tmp0), NULL));
		_tmp10 = NULL;
		_tmp9 = NULL;
		_tmp8 = NULL;
		_tmp7 = NULL;
		_tmp6 = NULL;
		_tmp5 = NULL;
		_tmp4 = NULL;
		_tmp3 = NULL;
		_tmp2 = NULL;
		vala_ccode_fragment_append (self->priv->instance_init_fragment, VALA_CCODE_NODE ((_tmp10 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp9 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp3 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_identifier_new ("self"))), "priv"))), (_tmp4 = vala_ccode_generator_get_symbol_lock_name (self, VALA_SYMBOL (m)))))), VALA_CCODE_EXPRESSION ((_tmp8 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp7 = vala_ccode_identifier_new ((_tmp6 = vala_method_get_cname (vala_struct_get_default_construction_method ((VALA_STRUCT (vala_data_type_get_data_type (self->mutex_type)))))))))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
		(_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL)));
		(_tmp9 == NULL ? NULL : (_tmp9 = (g_object_unref (_tmp9), NULL)));
		(_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL)));
		(_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL)));
		(_tmp6 = (g_free (_tmp6), NULL));
		(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
		(_tmp4 = (g_free (_tmp4), NULL));
		(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
		(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
		self->priv->requires_free_checked = TRUE;
		_tmp11 = NULL;
		_tmp12 = NULL;
		fc = (_tmp12 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp11 = vala_ccode_identifier_new ("VALA_FREE_CHECKED")))), (_tmp11 == NULL ? NULL : (_tmp11 = (g_object_unref (_tmp11), NULL))), _tmp12);
		_tmp16 = NULL;
		_tmp15 = NULL;
		_tmp14 = NULL;
		_tmp13 = NULL;
		vala_ccode_function_call_add_argument (fc, VALA_CCODE_EXPRESSION ((_tmp16 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp14 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp13 = vala_ccode_identifier_new ("self"))), "priv"))), (_tmp15 = vala_ccode_generator_get_symbol_lock_name (self, VALA_SYMBOL (m)))))));
		(_tmp16 == NULL ? NULL : (_tmp16 = (g_object_unref (_tmp16), NULL)));
		(_tmp15 = (g_free (_tmp15), NULL));
		(_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL)));
		(_tmp13 == NULL ? NULL : (_tmp13 = (g_object_unref (_tmp13), NULL)));
		_tmp17 = NULL;
		if ((_tmp18 = (_tmp17 = vala_typesymbol_get_free_function (vala_data_type_get_data_type (self->mutex_type))) == NULL, (_tmp17 = (g_free (_tmp17), NULL)), _tmp18)) {
			char* _tmp20;
			char* _tmp19;
			_tmp20 = NULL;
			_tmp19 = NULL;
			vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (vala_data_type_get_data_type (self->mutex_type))), (_tmp20 = g_strdup_printf ("The type `%s` doesn't contain a free function", (_tmp19 = vala_symbol_get_full_name (VALA_SYMBOL (vala_data_type_get_data_type (self->mutex_type)))))));
			(_tmp20 = (g_free (_tmp20), NULL));
			(_tmp19 = (g_free (_tmp19), NULL));
			(fc == NULL ? NULL : (fc = (g_object_unref (fc), NULL)));
			return;
		}
		_tmp22 = NULL;
		_tmp21 = NULL;
		vala_ccode_function_call_add_argument (fc, VALA_CCODE_EXPRESSION ((_tmp22 = vala_ccode_identifier_new ((_tmp21 = vala_typesymbol_get_free_function (vala_data_type_get_data_type (self->mutex_type)))))));
		(_tmp22 == NULL ? NULL : (_tmp22 = (g_object_unref (_tmp22), NULL)));
		(_tmp21 = (g_free (_tmp21), NULL));
		if (self->priv->instance_dispose_fragment != NULL) {
			ValaCCodeExpressionStatement* _tmp23;
			_tmp23 = NULL;
			vala_ccode_fragment_append (self->priv->instance_dispose_fragment, VALA_CCODE_NODE ((_tmp23 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (fc)))));
			(_tmp23 == NULL ? NULL : (_tmp23 = (g_object_unref (_tmp23), NULL)));
		}
		(fc == NULL ? NULL : (fc = (g_object_unref (fc), NULL)));
	}
}


static void vala_ccode_generator_real_visit_constant (ValaCodeVisitor* base, ValaConstant* c) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (c == NULL || VALA_IS_CONSTANT (c));
	vala_code_node_accept_children (VALA_CODE_NODE (c), VALA_CODE_VISITOR (self));
	if (VALA_IS_TYPESYMBOL (vala_symbol_get_parent_symbol (VALA_SYMBOL (c)))) {
		ValaTypesymbol* _tmp0;
		ValaTypesymbol* t;
		_tmp0 = NULL;
		t = (_tmp0 = VALA_TYPESYMBOL (vala_symbol_get_parent_symbol (VALA_SYMBOL (c))), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
		if (!vala_symbol_is_internal_symbol (VALA_SYMBOL (c)) && !(VALA_IS_ARRAY (vala_data_type_get_data_type (vala_constant_get_type_reference (c))))) {
			char* _tmp1;
			ValaCCodeMacroReplacement* _tmp2;
			ValaCCodeMacroReplacement* cdefine;
			_tmp1 = NULL;
			_tmp2 = NULL;
			cdefine = (_tmp2 = vala_ccode_macro_replacement_new_with_expression ((_tmp1 = vala_constant_get_cname (c)), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_constant_get_initializer (c))))), (_tmp1 = (g_free (_tmp1), NULL)), _tmp2);
			vala_ccode_fragment_append (self->priv->header_type_member_declaration, VALA_CCODE_NODE (cdefine));
			(cdefine == NULL ? NULL : (cdefine = (g_object_unref (cdefine), NULL)));
		} else {
			char* _tmp3;
			ValaCCodeDeclaration* _tmp4;
			ValaCCodeDeclaration* cdecl_;
			char* arr;
			ValaCCodeVariableDeclarator* _tmp8;
			char* _tmp7;
			char* _tmp6;
			_tmp3 = NULL;
			_tmp4 = NULL;
			cdecl_ = (_tmp4 = vala_ccode_declaration_new ((_tmp3 = vala_data_type_get_const_cname (vala_constant_get_type_reference (c)))), (_tmp3 = (g_free (_tmp3), NULL)), _tmp4);
			arr = g_strdup ("");
			if (VALA_IS_ARRAY (vala_data_type_get_data_type (vala_constant_get_type_reference (c)))) {
				char* _tmp5;
				_tmp5 = NULL;
				arr = (_tmp5 = g_strdup ("[]"), (arr = (g_free (arr), NULL)), _tmp5);
			}
			_tmp8 = NULL;
			_tmp7 = NULL;
			_tmp6 = NULL;
			vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp8 = vala_ccode_variable_declarator_new_with_initializer ((_tmp7 = g_strdup_printf ("%s%s", (_tmp6 = vala_constant_get_cname (c)), arr)), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_constant_get_initializer (c))))))));
			(_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL)));
			(_tmp7 = (g_free (_tmp7), NULL));
			(_tmp6 = (g_free (_tmp6), NULL));
			vala_ccode_declaration_set_modifiers (cdecl_, VALA_CCODE_MODIFIERS_STATIC);
			if (!vala_symbol_is_internal_symbol (VALA_SYMBOL (c))) {
				vala_ccode_fragment_append (self->priv->header_type_member_declaration, VALA_CCODE_NODE (cdecl_));
			} else {
				vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE (cdecl_));
			}
			(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
			(arr = (g_free (arr), NULL));
		}
		(t == NULL ? NULL : (t = (g_object_unref (t), NULL)));
	}
}


static void vala_ccode_generator_real_visit_field (ValaCodeVisitor* base, ValaField* f) {
	ValaCCodeGenerator * self;
	ValaClass* _tmp1;
	ValaSymbol* _tmp0;
	ValaClass* cl;
	gboolean is_gtypeinstance;
	ValaCCodeExpression* lhs;
	ValaCCodeStruct* st;
	char* field_ctype;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (f == NULL || VALA_IS_FIELD (f));
	vala_code_node_accept_children (VALA_CODE_NODE (f), VALA_CODE_VISITOR (self));
	_tmp1 = NULL;
	_tmp0 = NULL;
	cl = (_tmp1 = (_tmp0 = vala_symbol_get_parent_symbol (VALA_SYMBOL (f)), (VALA_IS_CLASS (_tmp0) ? ((ValaClass*) _tmp0) : NULL)), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
	is_gtypeinstance = (cl != NULL && vala_typesymbol_is_subtype_of (VALA_TYPESYMBOL (cl), self->gtypeinstance_type));
	lhs = NULL;
	st = NULL;
	field_ctype = vala_data_type_get_cname (vala_field_get_type_reference (f), FALSE, FALSE);
	if (vala_field_get_is_volatile (f)) {
		char* _tmp2;
		_tmp2 = NULL;
		field_ctype = (_tmp2 = g_strconcat ("volatile ", field_ctype, NULL), (field_ctype = (g_free (field_ctype), NULL)), _tmp2);
	}
	if (vala_symbol_get_access (VALA_SYMBOL (f)) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		ValaCCodeStruct* _tmp4;
		ValaCCodeStruct* _tmp3;
		_tmp4 = NULL;
		_tmp3 = NULL;
		st = (_tmp4 = (_tmp3 = self->priv->instance_struct, (_tmp3 == NULL ? NULL : g_object_ref (_tmp3))), (st == NULL ? NULL : (st = (g_object_unref (st), NULL))), _tmp4);
		if (vala_field_get_instance (f)) {
			ValaCCodeExpression* _tmp7;
			char* _tmp6;
			ValaCCodeIdentifier* _tmp5;
			_tmp7 = NULL;
			_tmp6 = NULL;
			_tmp5 = NULL;
			lhs = (_tmp7 = VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_identifier_new ("self"))), (_tmp6 = vala_field_get_cname (f)))), (lhs == NULL ? NULL : (lhs = (g_object_unref (lhs), NULL))), _tmp7);
			(_tmp6 = (g_free (_tmp6), NULL));
			(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
		} else {
			ValaCCodeDeclaration* cdecl_;
			ValaCCodeVariableDeclarator* _tmp9;
			char* _tmp8;
			ValaCCodeExpression* _tmp14;
			char* _tmp13;
			cdecl_ = vala_ccode_declaration_new (field_ctype);
			_tmp9 = NULL;
			_tmp8 = NULL;
			vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp9 = vala_ccode_variable_declarator_new ((_tmp8 = vala_field_get_cname (f))))));
			(_tmp9 == NULL ? NULL : (_tmp9 = (g_object_unref (_tmp9), NULL)));
			(_tmp8 = (g_free (_tmp8), NULL));
			vala_ccode_declaration_set_modifiers (cdecl_, VALA_CCODE_MODIFIERS_EXTERN);
			vala_ccode_fragment_append (self->priv->header_type_member_declaration, VALA_CCODE_NODE (cdecl_));
			if (vala_field_get_initializer (f) != NULL) {
				ValaCCodeExpression* _tmp10;
				ValaCCodeExpression* init;
				_tmp10 = NULL;
				init = (_tmp10 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_field_get_initializer (f)))), (_tmp10 == NULL ? NULL : g_object_ref (_tmp10)));
				if (vala_ccode_generator_is_constant_ccode_expression (self, init)) {
					ValaCCodeDeclaration* cinit_decl;
					char* _tmp11;
					ValaCCodeVariableDeclarator* _tmp12;
					ValaCCodeVariableDeclarator* var_decl;
					cinit_decl = vala_ccode_declaration_new (field_ctype);
					_tmp11 = NULL;
					_tmp12 = NULL;
					var_decl = (_tmp12 = vala_ccode_variable_declarator_new ((_tmp11 = vala_field_get_cname (f))), (_tmp11 = (g_free (_tmp11), NULL)), _tmp12);
					vala_ccode_variable_declarator_set_initializer (var_decl, init);
					vala_ccode_declaration_add_declarator (cinit_decl, VALA_CCODE_DECLARATOR (var_decl));
					vala_ccode_declaration_set_modifiers (cinit_decl, VALA_CCODE_MODIFIERS_EXTERN);
					vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE (cinit_decl));
					(cinit_decl == NULL ? NULL : (cinit_decl = (g_object_unref (cinit_decl), NULL)));
					(var_decl == NULL ? NULL : (var_decl = (g_object_unref (var_decl), NULL)));
				}
				(init == NULL ? NULL : (init = (g_object_unref (init), NULL)));
			}
			_tmp14 = NULL;
			_tmp13 = NULL;
			lhs = (_tmp14 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ((_tmp13 = vala_field_get_cname (f)))), (lhs == NULL ? NULL : (lhs = (g_object_unref (lhs), NULL))), _tmp14);
			(_tmp13 = (g_free (_tmp13), NULL));
			(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
		}
	} else {
		if (vala_symbol_get_access (VALA_SYMBOL (f)) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			if (vala_field_get_instance (f)) {
				if (is_gtypeinstance) {
					ValaCCodeStruct* _tmp16;
					ValaCCodeStruct* _tmp15;
					ValaCCodeExpression* _tmp20;
					char* _tmp19;
					ValaCCodeMemberAccess* _tmp18;
					ValaCCodeIdentifier* _tmp17;
					_tmp16 = NULL;
					_tmp15 = NULL;
					st = (_tmp16 = (_tmp15 = self->priv->instance_priv_struct, (_tmp15 == NULL ? NULL : g_object_ref (_tmp15))), (st == NULL ? NULL : (st = (g_object_unref (st), NULL))), _tmp16);
					_tmp20 = NULL;
					_tmp19 = NULL;
					_tmp18 = NULL;
					_tmp17 = NULL;
					lhs = (_tmp20 = VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp18 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp17 = vala_ccode_identifier_new ("self"))), "priv"))), (_tmp19 = vala_field_get_cname (f)))), (lhs == NULL ? NULL : (lhs = (g_object_unref (lhs), NULL))), _tmp20);
					(_tmp19 = (g_free (_tmp19), NULL));
					(_tmp18 == NULL ? NULL : (_tmp18 = (g_object_unref (_tmp18), NULL)));
					(_tmp17 == NULL ? NULL : (_tmp17 = (g_object_unref (_tmp17), NULL)));
				} else {
					ValaCCodeStruct* _tmp22;
					ValaCCodeStruct* _tmp21;
					ValaCCodeExpression* _tmp25;
					char* _tmp24;
					ValaCCodeIdentifier* _tmp23;
					_tmp22 = NULL;
					_tmp21 = NULL;
					st = (_tmp22 = (_tmp21 = self->priv->instance_struct, (_tmp21 == NULL ? NULL : g_object_ref (_tmp21))), (st == NULL ? NULL : (st = (g_object_unref (st), NULL))), _tmp22);
					_tmp25 = NULL;
					_tmp24 = NULL;
					_tmp23 = NULL;
					lhs = (_tmp25 = VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp23 = vala_ccode_identifier_new ("self"))), (_tmp24 = vala_field_get_cname (f)))), (lhs == NULL ? NULL : (lhs = (g_object_unref (lhs), NULL))), _tmp25);
					(_tmp24 = (g_free (_tmp24), NULL));
					(_tmp23 == NULL ? NULL : (_tmp23 = (g_object_unref (_tmp23), NULL)));
				}
			} else {
				ValaCCodeDeclaration* cdecl_;
				char* _tmp26;
				ValaCCodeVariableDeclarator* _tmp27;
				ValaCCodeVariableDeclarator* var_decl;
				ValaCCodeExpression* _tmp30;
				char* _tmp29;
				cdecl_ = vala_ccode_declaration_new (field_ctype);
				_tmp26 = NULL;
				_tmp27 = NULL;
				var_decl = (_tmp27 = vala_ccode_variable_declarator_new ((_tmp26 = vala_field_get_cname (f))), (_tmp26 = (g_free (_tmp26), NULL)), _tmp27);
				if (vala_field_get_initializer (f) != NULL) {
					ValaCCodeExpression* _tmp28;
					ValaCCodeExpression* init;
					_tmp28 = NULL;
					init = (_tmp28 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_field_get_initializer (f)))), (_tmp28 == NULL ? NULL : g_object_ref (_tmp28)));
					if (vala_ccode_generator_is_constant_ccode_expression (self, init)) {
						vala_ccode_variable_declarator_set_initializer (var_decl, init);
					}
					(init == NULL ? NULL : (init = (g_object_unref (init), NULL)));
				}
				vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR (var_decl));
				vala_ccode_declaration_set_modifiers (cdecl_, VALA_CCODE_MODIFIERS_STATIC);
				vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE (cdecl_));
				_tmp30 = NULL;
				_tmp29 = NULL;
				lhs = (_tmp30 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ((_tmp29 = vala_field_get_cname (f)))), (lhs == NULL ? NULL : (lhs = (g_object_unref (lhs), NULL))), _tmp30);
				(_tmp29 = (g_free (_tmp29), NULL));
				(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
				(var_decl == NULL ? NULL : (var_decl = (g_object_unref (var_decl), NULL)));
			}
		}
	}
	if (vala_field_get_instance (f)) {
		char* _tmp31;
		_tmp31 = NULL;
		vala_ccode_struct_add_field (st, field_ctype, (_tmp31 = vala_field_get_cname (f)));
		(_tmp31 = (g_free (_tmp31), NULL));
		if (VALA_IS_ARRAY (vala_data_type_get_data_type (vala_field_get_type_reference (f))) && !vala_field_get_no_array_length (f)) {
			ValaArray* _tmp32;
			ValaArray* arr;
			/* create fields to store array dimensions*/
			_tmp32 = NULL;
			arr = (_tmp32 = VALA_ARRAY (vala_data_type_get_data_type (vala_field_get_type_reference (f))), (_tmp32 == NULL ? NULL : g_object_ref (_tmp32)));
			{
				gint dim;
				dim = 0;
				for (dim = 1; dim <= vala_array_get_rank (arr); dim++) {
					ValaDataType* len_type;
					char* _tmp34;
					char* _tmp33;
					len_type = vala_data_type_copy (self->int_type);
					_tmp34 = NULL;
					_tmp33 = NULL;
					vala_ccode_struct_add_field (st, (_tmp33 = vala_data_type_get_cname (len_type, FALSE, FALSE)), (_tmp34 = vala_ccode_generator_get_array_length_cname (self, vala_symbol_get_name (VALA_SYMBOL (f)), dim)));
					(_tmp34 = (g_free (_tmp34), NULL));
					(_tmp33 = (g_free (_tmp33), NULL));
					(len_type == NULL ? NULL : (len_type = (g_object_unref (len_type), NULL)));
				}
			}
			(arr == NULL ? NULL : (arr = (g_object_unref (arr), NULL)));
		}
		if (vala_field_get_initializer (f) != NULL) {
			ValaCCodeExpression* _tmp35;
			ValaCCodeExpression* rhs;
			ValaCCodeExpression* _tmp36;
			ValaCCodeExpressionStatement* _tmp38;
			ValaCCodeAssignment* _tmp37;
			_tmp35 = NULL;
			rhs = (_tmp35 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_field_get_initializer (f)))), (_tmp35 == NULL ? NULL : g_object_ref (_tmp35)));
			_tmp36 = NULL;
			rhs = (_tmp36 = vala_ccode_generator_get_implicit_cast_expression (self, rhs, vala_expression_get_static_type (vala_field_get_initializer (f)), vala_field_get_type_reference (f)), (rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL))), _tmp36);
			_tmp38 = NULL;
			_tmp37 = NULL;
			vala_ccode_fragment_append (self->priv->instance_init_fragment, VALA_CCODE_NODE ((_tmp38 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp37 = vala_ccode_assignment_new (lhs, rhs, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
			(_tmp38 == NULL ? NULL : (_tmp38 = (g_object_unref (_tmp38), NULL)));
			(_tmp37 == NULL ? NULL : (_tmp37 = (g_object_unref (_tmp37), NULL)));
			if (VALA_IS_ARRAY (vala_data_type_get_data_type (vala_field_get_type_reference (f))) && !vala_field_get_no_array_length (f) && VALA_IS_ARRAY_CREATION_EXPRESSION (vala_field_get_initializer (f))) {
				ValaArray* _tmp39;
				ValaArray* array;
				ValaMemberAccess* ma;
				GeeList* sizes;
				_tmp39 = NULL;
				array = (_tmp39 = VALA_ARRAY (vala_data_type_get_data_type (vala_field_get_type_reference (f))), (_tmp39 == NULL ? NULL : g_object_ref (_tmp39)));
				ma = vala_member_access_new_simple (vala_symbol_get_name (VALA_SYMBOL (f)), NULL);
				vala_expression_set_symbol_reference (VALA_EXPRESSION (ma), VALA_SYMBOL (f));
				sizes = vala_array_creation_expression_get_sizes ((VALA_ARRAY_CREATION_EXPRESSION (vala_field_get_initializer (f))));
				{
					gint dim;
					dim = 0;
					for (dim = 1; dim <= vala_array_get_rank (array); dim++) {
						ValaCCodeExpression* array_len_lhs;
						ValaExpression* size;
						ValaCCodeExpressionStatement* _tmp41;
						ValaCCodeAssignment* _tmp40;
						array_len_lhs = vala_ccode_generator_get_array_length_cexpression (self, VALA_EXPRESSION (ma), dim);
						size = gee_list_get (((GeeList*) sizes), dim - 1);
						_tmp41 = NULL;
						_tmp40 = NULL;
						vala_ccode_fragment_append (self->priv->instance_init_fragment, VALA_CCODE_NODE ((_tmp41 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp40 = vala_ccode_assignment_new (array_len_lhs, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (size))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
						(_tmp41 == NULL ? NULL : (_tmp41 = (g_object_unref (_tmp41), NULL)));
						(_tmp40 == NULL ? NULL : (_tmp40 = (g_object_unref (_tmp40), NULL)));
						(array_len_lhs == NULL ? NULL : (array_len_lhs = (g_object_unref (array_len_lhs), NULL)));
						(size == NULL ? NULL : (size = (g_object_unref (size), NULL)));
					}
				}
				(array == NULL ? NULL : (array = (g_object_unref (array), NULL)));
				(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
				(sizes == NULL ? NULL : (sizes = (g_object_unref (sizes), NULL)));
			}
			(rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL)));
		}
		if (vala_data_type_get_takes_ownership (vala_field_get_type_reference (f)) && self->priv->instance_dispose_fragment != NULL) {
			ValaMemberAccess* ma;
			ValaCCodeExpressionStatement* _tmp43;
			ValaCCodeExpression* _tmp42;
			ma = vala_member_access_new_simple (vala_symbol_get_name (VALA_SYMBOL (f)), NULL);
			vala_expression_set_symbol_reference (VALA_EXPRESSION (ma), VALA_SYMBOL (f));
			_tmp43 = NULL;
			_tmp42 = NULL;
			vala_ccode_fragment_append (self->priv->instance_dispose_fragment, VALA_CCODE_NODE ((_tmp43 = vala_ccode_expression_statement_new ((_tmp42 = vala_ccode_generator_get_unref_expression (self, lhs, vala_field_get_type_reference (f), VALA_EXPRESSION (ma)))))));
			(_tmp43 == NULL ? NULL : (_tmp43 = (g_object_unref (_tmp43), NULL)));
			(_tmp42 == NULL ? NULL : (_tmp42 = (g_object_unref (_tmp42), NULL)));
			(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
		}
	} else {
		if (vala_field_get_initializer (f) != NULL) {
			ValaCCodeExpression* _tmp44;
			ValaCCodeExpression* rhs;
			_tmp44 = NULL;
			rhs = (_tmp44 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_field_get_initializer (f)))), (_tmp44 == NULL ? NULL : g_object_ref (_tmp44)));
			if (!vala_ccode_generator_is_constant_ccode_expression (self, rhs)) {
				if (VALA_IS_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (f)))) {
					ValaCCodeExpressionStatement* _tmp46;
					ValaCCodeAssignment* _tmp45;
					_tmp46 = NULL;
					_tmp45 = NULL;
					vala_ccode_fragment_append (self->priv->class_init_fragment, VALA_CCODE_NODE ((_tmp46 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp45 = vala_ccode_assignment_new (lhs, rhs, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
					(_tmp46 == NULL ? NULL : (_tmp46 = (g_object_unref (_tmp46), NULL)));
					(_tmp45 == NULL ? NULL : (_tmp45 = (g_object_unref (_tmp45), NULL)));
				} else {
					vala_code_node_set_error (VALA_CODE_NODE (f), TRUE);
					vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (f)), "Non-constant field initializers not supported in this context");
					(rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL)));
					(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
					(lhs == NULL ? NULL : (lhs = (g_object_unref (lhs), NULL)));
					(st == NULL ? NULL : (st = (g_object_unref (st), NULL)));
					(field_ctype = (g_free (field_ctype), NULL));
					return;
				}
			}
			(rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL)));
		}
	}
	(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
	(lhs == NULL ? NULL : (lhs = (g_object_unref (lhs), NULL)));
	(st == NULL ? NULL : (st = (g_object_unref (st), NULL)));
	(field_ctype = (g_free (field_ctype), NULL));
}


static gboolean vala_ccode_generator_is_constant_ccode_expression (ValaCCodeGenerator* self, ValaCCodeExpression* cexpr) {
	ValaCCodeParenthesizedExpression* _tmp2;
	ValaCCodeExpression* _tmp1;
	ValaCCodeParenthesizedExpression* cparenthesized;
	gboolean _tmp3;
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), FALSE);
	g_return_val_if_fail (cexpr == NULL || VALA_IS_CCODE_EXPRESSION (cexpr), FALSE);
	if (VALA_IS_CCODE_CONSTANT (cexpr)) {
		return TRUE;
	}
	_tmp2 = NULL;
	_tmp1 = NULL;
	cparenthesized = (_tmp2 = ((_tmp1 = cexpr, (VALA_IS_CCODE_PARENTHESIZED_EXPRESSION (_tmp1) ? ((ValaCCodeParenthesizedExpression*) _tmp1) : NULL))), (_tmp2 == NULL ? NULL : g_object_ref (_tmp2)));
	return (_tmp3 = (NULL != cparenthesized && vala_ccode_generator_is_constant_ccode_expression (self, vala_ccode_parenthesized_expression_get_inner (cparenthesized))), (cparenthesized == NULL ? NULL : (cparenthesized = (g_object_unref (cparenthesized), NULL))), _tmp3);
}


static void vala_ccode_generator_real_visit_formal_parameter (ValaCodeVisitor* base, ValaFormalParameter* p) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (p == NULL || VALA_IS_FORMAL_PARAMETER (p));
	vala_code_node_accept_children (VALA_CODE_NODE (p), VALA_CODE_VISITOR (self));
	if (!vala_formal_parameter_get_ellipsis (p)) {
		char* ctypename;
		const char* _tmp0;
		char* cname;
		ValaCCodeFormalParameter* _tmp4;
		ctypename = vala_data_type_get_cname (vala_formal_parameter_get_type_reference (p), FALSE, !vala_data_type_get_transfers_ownership (vala_formal_parameter_get_type_reference (p)));
		_tmp0 = NULL;
		cname = (_tmp0 = vala_symbol_get_name (VALA_SYMBOL (p)), (_tmp0 == NULL ? NULL : g_strdup (_tmp0)));
		/* pass non-simple structs always by reference*/
		if (VALA_IS_STRUCT (vala_data_type_get_data_type (vala_formal_parameter_get_type_reference (p)))) {
			ValaStruct* _tmp1;
			ValaStruct* st;
			_tmp1 = NULL;
			st = (_tmp1 = VALA_STRUCT (vala_data_type_get_data_type (vala_formal_parameter_get_type_reference (p))), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
			if (!vala_struct_is_simple_type (st) && !vala_data_type_get_is_ref (vala_formal_parameter_get_type_reference (p)) && !vala_data_type_get_is_out (vala_formal_parameter_get_type_reference (p))) {
				char* _tmp2;
				char* _tmp3;
				_tmp2 = NULL;
				ctypename = (_tmp2 = g_strconcat (ctypename, ("*"), NULL), (ctypename = (g_free (ctypename), NULL)), _tmp2);
				_tmp3 = NULL;
				cname = (_tmp3 = g_strdup_printf ("_%s_p", vala_symbol_get_name (VALA_SYMBOL (p))), (cname = (g_free (cname), NULL)), _tmp3);
			}
			(st == NULL ? NULL : (st = (g_object_unref (st), NULL)));
		}
		_tmp4 = NULL;
		vala_code_node_set_ccodenode (VALA_CODE_NODE (p), VALA_CCODE_NODE ((_tmp4 = vala_ccode_formal_parameter_new (cname, ctypename))));
		(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
		(ctypename = (g_free (ctypename), NULL));
		(cname = (g_free (cname), NULL));
	} else {
		ValaCCodeFormalParameter* _tmp5;
		_tmp5 = NULL;
		vala_code_node_set_ccodenode (VALA_CODE_NODE (p), VALA_CCODE_NODE ((_tmp5 = vala_ccode_formal_parameter_new_with_ellipsis ())));
		(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
	}
}


static void vala_ccode_generator_real_visit_property (ValaCodeVisitor* base, ValaProperty* prop) {
	ValaCCodeGenerator * self;
	gint old_next_temp_var_id;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (prop == NULL || VALA_IS_PROPERTY (prop));
	old_next_temp_var_id = self->priv->next_temp_var_id;
	self->priv->next_temp_var_id = 0;
	vala_code_node_accept_children (VALA_CODE_NODE (prop), VALA_CODE_VISITOR (self));
	self->priv->next_temp_var_id = old_next_temp_var_id;
	if (VALA_IS_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (prop)))) {
		ValaCCodeEnumValue* _tmp1;
		char* _tmp0;
		_tmp1 = NULL;
		_tmp0 = NULL;
		vala_ccode_enum_add_value (self->priv->prop_enum, (_tmp1 = vala_ccode_enum_value_new ((_tmp0 = vala_property_get_upper_case_cname (prop)), NULL)));
		(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
		(_tmp0 = (g_free (_tmp0), NULL));
	}
}


static void vala_ccode_generator_real_visit_property_accessor (ValaCodeVisitor* base, ValaPropertyAccessor* acc) {
	ValaCCodeGenerator * self;
	ValaProperty* _tmp0;
	ValaProperty* prop;
	ValaDataType* _tmp4;
	ValaTypesymbol* _tmp5;
	ValaTypesymbol* t;
	ValaReferenceType* this_type;
	char* _tmp8;
	ValaCCodeFormalParameter* _tmp9;
	ValaCCodeFormalParameter* cselfparam;
	char* _tmp10;
	ValaCCodeFormalParameter* _tmp11;
	ValaCCodeFormalParameter* cvalueparam;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (acc == NULL || VALA_IS_PROPERTY_ACCESSOR (acc));
	_tmp0 = NULL;
	prop = (_tmp0 = VALA_PROPERTY (vala_property_accessor_get_prop (acc)), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	if (vala_property_accessor_get_readable (acc)) {
		ValaDataType* _tmp2;
		ValaDataType* _tmp1;
		_tmp2 = NULL;
		_tmp1 = NULL;
		self->priv->current_return_type = (_tmp2 = (_tmp1 = vala_property_get_type_reference (prop), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->current_return_type == NULL ? NULL : (self->priv->current_return_type = (g_object_unref (self->priv->current_return_type), NULL))), _tmp2);
	} else {
		ValaDataType* _tmp3;
		_tmp3 = NULL;
		self->priv->current_return_type = (_tmp3 = VALA_DATA_TYPE (vala_void_type_new ()), (self->priv->current_return_type == NULL ? NULL : (self->priv->current_return_type = (g_object_unref (self->priv->current_return_type), NULL))), _tmp3);
	}
	vala_code_node_accept_children (VALA_CODE_NODE (acc), VALA_CODE_VISITOR (self));
	_tmp4 = NULL;
	self->priv->current_return_type = (_tmp4 = NULL, (self->priv->current_return_type == NULL ? NULL : (self->priv->current_return_type = (g_object_unref (self->priv->current_return_type), NULL))), _tmp4);
	_tmp5 = NULL;
	t = (_tmp5 = VALA_TYPESYMBOL (vala_symbol_get_parent_symbol (VALA_SYMBOL (prop))), (_tmp5 == NULL ? NULL : g_object_ref (_tmp5)));
	this_type = NULL;
	if (VALA_IS_CLASS (t)) {
		ValaReferenceType* _tmp6;
		_tmp6 = NULL;
		this_type = (_tmp6 = VALA_REFERENCE_TYPE (vala_class_type_new (VALA_CLASS (t))), (this_type == NULL ? NULL : (this_type = (g_object_unref (this_type), NULL))), _tmp6);
	} else {
		ValaReferenceType* _tmp7;
		_tmp7 = NULL;
		this_type = (_tmp7 = VALA_REFERENCE_TYPE (vala_interface_type_new (VALA_INTERFACE (t))), (this_type == NULL ? NULL : (this_type = (g_object_unref (this_type), NULL))), _tmp7);
	}
	_tmp8 = NULL;
	_tmp9 = NULL;
	cselfparam = (_tmp9 = vala_ccode_formal_parameter_new ("self", (_tmp8 = vala_data_type_get_cname (VALA_DATA_TYPE (this_type), FALSE, FALSE))), (_tmp8 = (g_free (_tmp8), NULL)), _tmp9);
	_tmp10 = NULL;
	_tmp11 = NULL;
	cvalueparam = (_tmp11 = vala_ccode_formal_parameter_new ("value", (_tmp10 = vala_data_type_get_cname (vala_property_get_type_reference (prop), FALSE, TRUE))), (_tmp10 = (g_free (_tmp10), NULL)), _tmp11);
	if (vala_property_get_is_abstract (prop) || vala_property_get_is_virtual (prop)) {
		ValaCCodeBlock* block;
		if (vala_property_accessor_get_readable (acc)) {
			ValaCCodeFunction* _tmp15;
			char* _tmp14;
			char* _tmp13;
			char* _tmp12;
			_tmp15 = NULL;
			_tmp14 = NULL;
			_tmp13 = NULL;
			_tmp12 = NULL;
			self->priv->function = (_tmp15 = vala_ccode_function_new ((_tmp13 = g_strdup_printf ("%s_get_%s", (_tmp12 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (t), NULL)), vala_symbol_get_name (VALA_SYMBOL (prop)))), (_tmp14 = vala_data_type_get_cname (vala_property_get_type_reference (prop), FALSE, FALSE))), (self->priv->function == NULL ? NULL : (self->priv->function = (g_object_unref (self->priv->function), NULL))), _tmp15);
			(_tmp14 = (g_free (_tmp14), NULL));
			(_tmp13 = (g_free (_tmp13), NULL));
			(_tmp12 = (g_free (_tmp12), NULL));
		} else {
			ValaCCodeFunction* _tmp18;
			char* _tmp17;
			char* _tmp16;
			_tmp18 = NULL;
			_tmp17 = NULL;
			_tmp16 = NULL;
			self->priv->function = (_tmp18 = vala_ccode_function_new ((_tmp17 = g_strdup_printf ("%s_set_%s", (_tmp16 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (t), NULL)), vala_symbol_get_name (VALA_SYMBOL (prop)))), "void"), (self->priv->function == NULL ? NULL : (self->priv->function = (g_object_unref (self->priv->function), NULL))), _tmp18);
			(_tmp17 = (g_free (_tmp17), NULL));
			(_tmp16 = (g_free (_tmp16), NULL));
		}
		vala_ccode_function_add_parameter (self->priv->function, cselfparam);
		if (vala_property_accessor_get_writable (acc) || vala_property_accessor_get_construction (acc)) {
			vala_ccode_function_add_parameter (self->priv->function, cvalueparam);
		}
		if (!vala_symbol_is_internal_symbol (VALA_SYMBOL (prop)) && (vala_property_accessor_get_readable (acc) || vala_property_accessor_get_writable (acc))) {
			ValaCCodeFunction* _tmp19;
			/* accessor function should be public if the property is a public symbol and it's not a construct-only setter*/
			_tmp19 = NULL;
			vala_ccode_fragment_append (self->priv->header_type_member_declaration, VALA_CCODE_NODE ((_tmp19 = vala_ccode_function_copy (self->priv->function))));
			(_tmp19 == NULL ? NULL : (_tmp19 = (g_object_unref (_tmp19), NULL)));
		} else {
			ValaCCodeFunction* _tmp20;
			vala_ccode_function_set_modifiers (self->priv->function, vala_ccode_function_get_modifiers (self->priv->function) | (VALA_CCODE_MODIFIERS_STATIC));
			_tmp20 = NULL;
			vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE ((_tmp20 = vala_ccode_function_copy (self->priv->function))));
			(_tmp20 == NULL ? NULL : (_tmp20 = (g_object_unref (_tmp20), NULL)));
		}
		block = vala_ccode_block_new ();
		vala_ccode_function_set_block (self->priv->function, block);
		if (vala_property_accessor_get_readable (acc)) {
			char* _tmp21;
			ValaCCodeDeclaration* _tmp22;
			ValaCCodeDeclaration* decl;
			ValaCCodeVariableDeclarator* _tmp23;
			ValaCCodeIdentifier* _tmp24;
			ValaCCodeFunctionCall* _tmp25;
			ValaCCodeFunctionCall* ccall;
			ValaCCodeIdentifier* _tmp26;
			ValaCCodeFunctionCall* _tmp27;
			ValaCCodeFunctionCall* ccast;
			ValaCCodeIdentifier* _tmp28;
			ValaCCodeConstant* _tmp29;
			ValaCCodeUnaryExpression* _tmp31;
			ValaCCodeIdentifier* _tmp30;
			ValaCCodeConstant* _tmp32;
			ValaCCodeExpressionStatement* _tmp33;
			ValaCCodeReturnStatement* _tmp43;
			ValaCCodeIdentifier* _tmp42;
			/* declare temporary variable to save the property value*/
			_tmp21 = NULL;
			_tmp22 = NULL;
			decl = (_tmp22 = vala_ccode_declaration_new ((_tmp21 = vala_data_type_get_cname (vala_property_get_type_reference (prop), FALSE, FALSE))), (_tmp21 = (g_free (_tmp21), NULL)), _tmp22);
			_tmp23 = NULL;
			vala_ccode_declaration_add_declarator (decl, VALA_CCODE_DECLARATOR ((_tmp23 = vala_ccode_variable_declarator_new ("value"))));
			(_tmp23 == NULL ? NULL : (_tmp23 = (g_object_unref (_tmp23), NULL)));
			vala_ccode_block_add_statement (block, VALA_CCODE_NODE (decl));
			_tmp24 = NULL;
			_tmp25 = NULL;
			ccall = (_tmp25 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp24 = vala_ccode_identifier_new ("g_object_get")))), (_tmp24 == NULL ? NULL : (_tmp24 = (g_object_unref (_tmp24), NULL))), _tmp25);
			_tmp26 = NULL;
			_tmp27 = NULL;
			ccast = (_tmp27 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp26 = vala_ccode_identifier_new ("G_OBJECT")))), (_tmp26 == NULL ? NULL : (_tmp26 = (g_object_unref (_tmp26), NULL))), _tmp27);
			_tmp28 = NULL;
			vala_ccode_function_call_add_argument (ccast, VALA_CCODE_EXPRESSION ((_tmp28 = vala_ccode_identifier_new ("self"))));
			(_tmp28 == NULL ? NULL : (_tmp28 = (g_object_unref (_tmp28), NULL)));
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (ccast));
			/* property name is second argument of g_object_get*/
			_tmp29 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp29 = vala_property_get_canonical_cconstant (prop))));
			(_tmp29 == NULL ? NULL : (_tmp29 = (g_object_unref (_tmp29), NULL)));
			_tmp31 = NULL;
			_tmp30 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp31 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp30 = vala_ccode_identifier_new ("value")))))));
			(_tmp31 == NULL ? NULL : (_tmp31 = (g_object_unref (_tmp31), NULL)));
			(_tmp30 == NULL ? NULL : (_tmp30 = (g_object_unref (_tmp30), NULL)));
			_tmp32 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp32 = vala_ccode_constant_new ("NULL"))));
			(_tmp32 == NULL ? NULL : (_tmp32 = (g_object_unref (_tmp32), NULL)));
			_tmp33 = NULL;
			vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp33 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
			(_tmp33 == NULL ? NULL : (_tmp33 = (g_object_unref (_tmp33), NULL)));
			/* HACK: decrement the refcount before returning the value to simulate a weak reference getter function*/
			if (vala_typesymbol_is_reference_counting (vala_data_type_get_data_type (vala_property_get_type_reference (prop)))) {
				ValaCCodeConstant* _tmp35;
				ValaCCodeIdentifier* _tmp34;
				ValaCCodeBinaryExpression* _tmp36;
				ValaCCodeBinaryExpression* unref_cond;
				ValaCCodeExpression* _tmp37;
				ValaCCodeFunctionCall* _tmp38;
				ValaCCodeFunctionCall* unref_function;
				ValaCCodeIdentifier* _tmp39;
				ValaCCodeBlock* unref_block;
				ValaCCodeExpressionStatement* _tmp40;
				ValaCCodeIfStatement* _tmp41;
				_tmp35 = NULL;
				_tmp34 = NULL;
				_tmp36 = NULL;
				unref_cond = (_tmp36 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, VALA_CCODE_EXPRESSION ((_tmp34 = vala_ccode_identifier_new ("value"))), VALA_CCODE_EXPRESSION ((_tmp35 = vala_ccode_constant_new ("NULL")))), (_tmp35 == NULL ? NULL : (_tmp35 = (g_object_unref (_tmp35), NULL))), (_tmp34 == NULL ? NULL : (_tmp34 = (g_object_unref (_tmp34), NULL))), _tmp36);
				_tmp37 = NULL;
				_tmp38 = NULL;
				unref_function = (_tmp38 = vala_ccode_function_call_new ((_tmp37 = vala_ccode_generator_get_destroy_func_expression (self, vala_property_get_type_reference (prop)))), (_tmp37 == NULL ? NULL : (_tmp37 = (g_object_unref (_tmp37), NULL))), _tmp38);
				_tmp39 = NULL;
				vala_ccode_function_call_add_argument (unref_function, VALA_CCODE_EXPRESSION ((_tmp39 = vala_ccode_identifier_new ("value"))));
				(_tmp39 == NULL ? NULL : (_tmp39 = (g_object_unref (_tmp39), NULL)));
				unref_block = vala_ccode_block_new ();
				_tmp40 = NULL;
				vala_ccode_block_add_statement (unref_block, VALA_CCODE_NODE ((_tmp40 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (unref_function)))));
				(_tmp40 == NULL ? NULL : (_tmp40 = (g_object_unref (_tmp40), NULL)));
				_tmp41 = NULL;
				vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp41 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (unref_cond), VALA_CCODE_STATEMENT (unref_block), NULL))));
				(_tmp41 == NULL ? NULL : (_tmp41 = (g_object_unref (_tmp41), NULL)));
				(unref_cond == NULL ? NULL : (unref_cond = (g_object_unref (unref_cond), NULL)));
				(unref_function == NULL ? NULL : (unref_function = (g_object_unref (unref_function), NULL)));
				(unref_block == NULL ? NULL : (unref_block = (g_object_unref (unref_block), NULL)));
			}
			_tmp43 = NULL;
			_tmp42 = NULL;
			vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp43 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION ((_tmp42 = vala_ccode_identifier_new ("value")))))));
			(_tmp43 == NULL ? NULL : (_tmp43 = (g_object_unref (_tmp43), NULL)));
			(_tmp42 == NULL ? NULL : (_tmp42 = (g_object_unref (_tmp42), NULL)));
			(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
			(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
			(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
		} else {
			ValaCCodeIdentifier* _tmp44;
			ValaCCodeFunctionCall* _tmp45;
			ValaCCodeFunctionCall* ccall;
			ValaCCodeIdentifier* _tmp46;
			ValaCCodeFunctionCall* _tmp47;
			ValaCCodeFunctionCall* ccast;
			ValaCCodeIdentifier* _tmp48;
			ValaCCodeConstant* _tmp49;
			ValaCCodeIdentifier* _tmp50;
			ValaCCodeConstant* _tmp51;
			ValaCCodeExpressionStatement* _tmp52;
			_tmp44 = NULL;
			_tmp45 = NULL;
			ccall = (_tmp45 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp44 = vala_ccode_identifier_new ("g_object_set")))), (_tmp44 == NULL ? NULL : (_tmp44 = (g_object_unref (_tmp44), NULL))), _tmp45);
			_tmp46 = NULL;
			_tmp47 = NULL;
			ccast = (_tmp47 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp46 = vala_ccode_identifier_new ("G_OBJECT")))), (_tmp46 == NULL ? NULL : (_tmp46 = (g_object_unref (_tmp46), NULL))), _tmp47);
			_tmp48 = NULL;
			vala_ccode_function_call_add_argument (ccast, VALA_CCODE_EXPRESSION ((_tmp48 = vala_ccode_identifier_new ("self"))));
			(_tmp48 == NULL ? NULL : (_tmp48 = (g_object_unref (_tmp48), NULL)));
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (ccast));
			/* property name is second argument of g_object_set*/
			_tmp49 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp49 = vala_property_get_canonical_cconstant (prop))));
			(_tmp49 == NULL ? NULL : (_tmp49 = (g_object_unref (_tmp49), NULL)));
			_tmp50 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp50 = vala_ccode_identifier_new ("value"))));
			(_tmp50 == NULL ? NULL : (_tmp50 = (g_object_unref (_tmp50), NULL)));
			_tmp51 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp51 = vala_ccode_constant_new ("NULL"))));
			(_tmp51 == NULL ? NULL : (_tmp51 = (g_object_unref (_tmp51), NULL)));
			_tmp52 = NULL;
			vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp52 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
			(_tmp52 == NULL ? NULL : (_tmp52 = (g_object_unref (_tmp52), NULL)));
			(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
			(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
		}
		vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (self->priv->function));
		(block == NULL ? NULL : (block = (g_object_unref (block), NULL)));
	}
	if (!vala_property_get_is_abstract (prop)) {
		gboolean is_virtual;
		char* prefix;
		is_virtual = vala_property_get_base_property (prop) != NULL || vala_property_get_base_interface_property (prop) != NULL;
		prefix = vala_symbol_get_lower_case_cname (VALA_SYMBOL (t), NULL);
		if (is_virtual) {
			char* _tmp53;
			_tmp53 = NULL;
			prefix = (_tmp53 = g_strconcat (prefix, ("_real"), NULL), (prefix = (g_free (prefix), NULL)), _tmp53);
		}
		if (vala_property_accessor_get_readable (acc)) {
			ValaCCodeFunction* _tmp56;
			char* _tmp55;
			char* _tmp54;
			_tmp56 = NULL;
			_tmp55 = NULL;
			_tmp54 = NULL;
			self->priv->function = (_tmp56 = vala_ccode_function_new ((_tmp54 = g_strdup_printf ("%s_get_%s", prefix, vala_symbol_get_name (VALA_SYMBOL (prop)))), (_tmp55 = vala_data_type_get_cname (vala_property_get_type_reference (prop), FALSE, FALSE))), (self->priv->function == NULL ? NULL : (self->priv->function = (g_object_unref (self->priv->function), NULL))), _tmp56);
			(_tmp55 = (g_free (_tmp55), NULL));
			(_tmp54 = (g_free (_tmp54), NULL));
		} else {
			ValaCCodeFunction* _tmp58;
			char* _tmp57;
			_tmp58 = NULL;
			_tmp57 = NULL;
			self->priv->function = (_tmp58 = vala_ccode_function_new ((_tmp57 = g_strdup_printf ("%s_set_%s", prefix, vala_symbol_get_name (VALA_SYMBOL (prop)))), "void"), (self->priv->function == NULL ? NULL : (self->priv->function = (g_object_unref (self->priv->function), NULL))), _tmp58);
			(_tmp57 = (g_free (_tmp57), NULL));
		}
		if (is_virtual) {
			vala_ccode_function_set_modifiers (self->priv->function, vala_ccode_function_get_modifiers (self->priv->function) | (VALA_CCODE_MODIFIERS_STATIC));
		}
		vala_ccode_function_add_parameter (self->priv->function, cselfparam);
		if (vala_property_accessor_get_writable (acc) || vala_property_accessor_get_construction (acc)) {
			vala_ccode_function_add_parameter (self->priv->function, cvalueparam);
		}
		if (!is_virtual) {
			if (!vala_symbol_is_internal_symbol (VALA_SYMBOL (prop)) && (vala_property_accessor_get_readable (acc) || vala_property_accessor_get_writable (acc))) {
				ValaCCodeFunction* _tmp59;
				/* accessor function should be public if the property is a public symbol and it's not a construct-only setter*/
				_tmp59 = NULL;
				vala_ccode_fragment_append (self->priv->header_type_member_declaration, VALA_CCODE_NODE ((_tmp59 = vala_ccode_function_copy (self->priv->function))));
				(_tmp59 == NULL ? NULL : (_tmp59 = (g_object_unref (_tmp59), NULL)));
			} else {
				ValaCCodeFunction* _tmp60;
				vala_ccode_function_set_modifiers (self->priv->function, vala_ccode_function_get_modifiers (self->priv->function) | (VALA_CCODE_MODIFIERS_STATIC));
				_tmp60 = NULL;
				vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE ((_tmp60 = vala_ccode_function_copy (self->priv->function))));
				(_tmp60 == NULL ? NULL : (_tmp60 = (g_object_unref (_tmp60), NULL)));
			}
		}
		if (vala_property_accessor_get_body (acc) != NULL) {
			ValaCCodeStatement* _tmp61;
			vala_ccode_function_set_block (self->priv->function, VALA_CCODE_BLOCK (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_property_accessor_get_body (acc)))));
			_tmp61 = NULL;
			vala_ccode_block_prepend_statement (vala_ccode_function_get_block (self->priv->function), VALA_CCODE_NODE ((_tmp61 = vala_ccode_generator_create_property_type_check_statement (self, prop, vala_property_accessor_get_readable (acc), t, TRUE, "self"))));
			(_tmp61 == NULL ? NULL : (_tmp61 = (g_object_unref (_tmp61), NULL)));
			/* notify on property changes*/
			if (vala_property_get_notify (prop) && (vala_property_accessor_get_writable (acc) || vala_property_accessor_get_construction (acc))) {
				ValaCCodeIdentifier* _tmp62;
				ValaCCodeFunctionCall* _tmp63;
				ValaCCodeFunctionCall* notify_call;
				ValaCCodeCastExpression* _tmp65;
				ValaCCodeIdentifier* _tmp64;
				ValaCCodeConstant* _tmp66;
				ValaCCodeExpressionStatement* _tmp67;
				_tmp62 = NULL;
				_tmp63 = NULL;
				notify_call = (_tmp63 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp62 = vala_ccode_identifier_new ("g_object_notify")))), (_tmp62 == NULL ? NULL : (_tmp62 = (g_object_unref (_tmp62), NULL))), _tmp63);
				_tmp65 = NULL;
				_tmp64 = NULL;
				vala_ccode_function_call_add_argument (notify_call, VALA_CCODE_EXPRESSION ((_tmp65 = vala_ccode_cast_expression_new (VALA_CCODE_EXPRESSION ((_tmp64 = vala_ccode_identifier_new ("self"))), "GObject *"))));
				(_tmp65 == NULL ? NULL : (_tmp65 = (g_object_unref (_tmp65), NULL)));
				(_tmp64 == NULL ? NULL : (_tmp64 = (g_object_unref (_tmp64), NULL)));
				_tmp66 = NULL;
				vala_ccode_function_call_add_argument (notify_call, VALA_CCODE_EXPRESSION ((_tmp66 = vala_property_get_canonical_cconstant (prop))));
				(_tmp66 == NULL ? NULL : (_tmp66 = (g_object_unref (_tmp66), NULL)));
				_tmp67 = NULL;
				vala_ccode_block_add_statement (vala_ccode_function_get_block (self->priv->function), VALA_CCODE_NODE ((_tmp67 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (notify_call)))));
				(_tmp67 == NULL ? NULL : (_tmp67 = (g_object_unref (_tmp67), NULL)));
				(notify_call == NULL ? NULL : (notify_call = (g_object_unref (notify_call), NULL)));
			}
		}
		vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (self->priv->function));
		(prefix = (g_free (prefix), NULL));
	}
	(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
	(t == NULL ? NULL : (t = (g_object_unref (t), NULL)));
	(this_type == NULL ? NULL : (this_type = (g_object_unref (this_type), NULL)));
	(cselfparam == NULL ? NULL : (cselfparam = (g_object_unref (cselfparam), NULL)));
	(cvalueparam == NULL ? NULL : (cvalueparam = (g_object_unref (cvalueparam), NULL)));
}


static void vala_ccode_generator_real_visit_constructor (ValaCodeVisitor* base, ValaConstructor* c) {
	ValaCCodeGenerator * self;
	ValaClass* _tmp0;
	ValaClass* cl;
	ValaCCodeFunction* _tmp3;
	char* _tmp2;
	char* _tmp1;
	ValaCCodeFormalParameter* _tmp4;
	ValaCCodeFormalParameter* _tmp5;
	ValaCCodeFormalParameter* _tmp6;
	ValaCCodeFunction* _tmp7;
	ValaCCodeBlock* cblock;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeVariableDeclarator* _tmp8;
	ValaCCodeDeclaration* _tmp11;
	char* _tmp10;
	char* _tmp9;
	ValaCCodeVariableDeclarator* _tmp12;
	ValaCCodeDeclaration* _tmp13;
	ValaCCodeVariableDeclarator* _tmp14;
	ValaCCodeIdentifier* _tmp15;
	ValaCCodeFunctionCall* _tmp16;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* _tmp18;
	char* _tmp17;
	ValaCCodeIdentifier* _tmp21;
	char* _tmp20;
	char* _tmp19;
	ValaCCodeFunctionCall* _tmp22;
	ValaCCodeFunctionCall* ccast;
	ValaCCodeExpressionStatement* _tmp25;
	ValaCCodeAssignment* _tmp24;
	ValaCCodeIdentifier* _tmp23;
	ValaCCodeFunctionCall* _tmp27;
	ValaCCodeIdentifier* _tmp26;
	ValaCCodeIdentifier* _tmp28;
	ValaCCodeFunctionCall* _tmp30;
	ValaCCodeIdentifier* _tmp29;
	ValaCCodeExpressionStatement* _tmp33;
	ValaCCodeAssignment* _tmp32;
	ValaCCodeIdentifier* _tmp31;
	ValaCCodeFunctionCall* _tmp36;
	ValaCCodeMemberAccess* _tmp35;
	ValaCCodeIdentifier* _tmp34;
	ValaCCodeIdentifier* _tmp37;
	ValaCCodeIdentifier* _tmp38;
	ValaCCodeIdentifier* _tmp39;
	ValaCCodeExpressionStatement* _tmp42;
	ValaCCodeAssignment* _tmp41;
	ValaCCodeIdentifier* _tmp40;
	ValaCCodeFunctionCall* _tmp44;
	ValaCCodeIdentifier* _tmp43;
	ValaCCodeDeclaration* _tmp47;
	char* _tmp46;
	char* _tmp45;
	ValaCCodeVariableDeclarator* _tmp48;
	ValaCCodeReturnStatement* _tmp52;
	ValaCCodeIdentifier* _tmp51;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (c == NULL || VALA_IS_CONSTRUCTOR (c));
	self->priv->current_method_inner_error = FALSE;
	vala_code_node_accept_children (VALA_CODE_NODE (c), VALA_CODE_VISITOR (self));
	_tmp0 = NULL;
	cl = (_tmp0 = VALA_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (c))), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	_tmp3 = NULL;
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->function = (_tmp3 = vala_ccode_function_new ((_tmp2 = g_strdup_printf ("%s_constructor", (_tmp1 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)))), "GObject *"), (self->priv->function == NULL ? NULL : (self->priv->function = (g_object_unref (self->priv->function), NULL))), _tmp3);
	(_tmp2 = (g_free (_tmp2), NULL));
	(_tmp1 = (g_free (_tmp1), NULL));
	vala_ccode_function_set_modifiers (self->priv->function, VALA_CCODE_MODIFIERS_STATIC);
	_tmp4 = NULL;
	vala_ccode_function_add_parameter (self->priv->function, (_tmp4 = vala_ccode_formal_parameter_new ("type", "GType")));
	(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
	_tmp5 = NULL;
	vala_ccode_function_add_parameter (self->priv->function, (_tmp5 = vala_ccode_formal_parameter_new ("n_construct_properties", "guint")));
	(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
	_tmp6 = NULL;
	vala_ccode_function_add_parameter (self->priv->function, (_tmp6 = vala_ccode_formal_parameter_new ("construct_properties", "GObjectConstructParam *")));
	(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
	_tmp7 = NULL;
	vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE ((_tmp7 = vala_ccode_function_copy (self->priv->function))));
	(_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL)));
	cblock = vala_ccode_block_new ();
	cdecl_ = vala_ccode_declaration_new ("GObject *");
	_tmp8 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp8 = vala_ccode_variable_declarator_new ("obj"))));
	(_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL)));
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cdecl_));
	_tmp11 = NULL;
	_tmp10 = NULL;
	_tmp9 = NULL;
	cdecl_ = (_tmp11 = vala_ccode_declaration_new ((_tmp10 = g_strdup_printf ("%sClass *", (_tmp9 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE))))), (cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL))), _tmp11);
	(_tmp10 = (g_free (_tmp10), NULL));
	(_tmp9 = (g_free (_tmp9), NULL));
	_tmp12 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp12 = vala_ccode_variable_declarator_new ("klass"))));
	(_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL)));
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cdecl_));
	_tmp13 = NULL;
	cdecl_ = (_tmp13 = vala_ccode_declaration_new ("GObjectClass *"), (cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL))), _tmp13);
	_tmp14 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp14 = vala_ccode_variable_declarator_new ("parent_class"))));
	(_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL)));
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cdecl_));
	_tmp15 = NULL;
	_tmp16 = NULL;
	ccall = (_tmp16 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp15 = vala_ccode_identifier_new ("g_type_class_peek")))), (_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL))), _tmp16);
	_tmp18 = NULL;
	_tmp17 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp18 = vala_ccode_identifier_new ((_tmp17 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (cl), "TYPE_"))))));
	(_tmp18 == NULL ? NULL : (_tmp18 = (g_object_unref (_tmp18), NULL)));
	(_tmp17 = (g_free (_tmp17), NULL));
	_tmp21 = NULL;
	_tmp20 = NULL;
	_tmp19 = NULL;
	_tmp22 = NULL;
	ccast = (_tmp22 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp21 = vala_ccode_identifier_new ((_tmp20 = g_strdup_printf ("%s_CLASS", (_tmp19 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (cl), NULL)))))))), (_tmp21 == NULL ? NULL : (_tmp21 = (g_object_unref (_tmp21), NULL))), (_tmp20 = (g_free (_tmp20), NULL)), (_tmp19 = (g_free (_tmp19), NULL)), _tmp22);
	vala_ccode_function_call_add_argument (ccast, VALA_CCODE_EXPRESSION (ccall));
	_tmp25 = NULL;
	_tmp24 = NULL;
	_tmp23 = NULL;
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((_tmp25 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp24 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp23 = vala_ccode_identifier_new ("klass"))), VALA_CCODE_EXPRESSION (ccast), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
	(_tmp25 == NULL ? NULL : (_tmp25 = (g_object_unref (_tmp25), NULL)));
	(_tmp24 == NULL ? NULL : (_tmp24 = (g_object_unref (_tmp24), NULL)));
	(_tmp23 == NULL ? NULL : (_tmp23 = (g_object_unref (_tmp23), NULL)));
	_tmp27 = NULL;
	_tmp26 = NULL;
	ccall = (_tmp27 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp26 = vala_ccode_identifier_new ("g_type_class_peek_parent")))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), _tmp27);
	(_tmp26 == NULL ? NULL : (_tmp26 = (g_object_unref (_tmp26), NULL)));
	_tmp28 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp28 = vala_ccode_identifier_new ("klass"))));
	(_tmp28 == NULL ? NULL : (_tmp28 = (g_object_unref (_tmp28), NULL)));
	_tmp30 = NULL;
	_tmp29 = NULL;
	ccast = (_tmp30 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp29 = vala_ccode_identifier_new ("G_OBJECT_CLASS")))), (ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL))), _tmp30);
	(_tmp29 == NULL ? NULL : (_tmp29 = (g_object_unref (_tmp29), NULL)));
	vala_ccode_function_call_add_argument (ccast, VALA_CCODE_EXPRESSION (ccall));
	_tmp33 = NULL;
	_tmp32 = NULL;
	_tmp31 = NULL;
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((_tmp33 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp32 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp31 = vala_ccode_identifier_new ("parent_class"))), VALA_CCODE_EXPRESSION (ccast), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
	(_tmp33 == NULL ? NULL : (_tmp33 = (g_object_unref (_tmp33), NULL)));
	(_tmp32 == NULL ? NULL : (_tmp32 = (g_object_unref (_tmp32), NULL)));
	(_tmp31 == NULL ? NULL : (_tmp31 = (g_object_unref (_tmp31), NULL)));
	_tmp36 = NULL;
	_tmp35 = NULL;
	_tmp34 = NULL;
	ccall = (_tmp36 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp35 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp34 = vala_ccode_identifier_new ("parent_class"))), "constructor")))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), _tmp36);
	(_tmp35 == NULL ? NULL : (_tmp35 = (g_object_unref (_tmp35), NULL)));
	(_tmp34 == NULL ? NULL : (_tmp34 = (g_object_unref (_tmp34), NULL)));
	_tmp37 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp37 = vala_ccode_identifier_new ("type"))));
	(_tmp37 == NULL ? NULL : (_tmp37 = (g_object_unref (_tmp37), NULL)));
	_tmp38 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp38 = vala_ccode_identifier_new ("n_construct_properties"))));
	(_tmp38 == NULL ? NULL : (_tmp38 = (g_object_unref (_tmp38), NULL)));
	_tmp39 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp39 = vala_ccode_identifier_new ("construct_properties"))));
	(_tmp39 == NULL ? NULL : (_tmp39 = (g_object_unref (_tmp39), NULL)));
	_tmp42 = NULL;
	_tmp41 = NULL;
	_tmp40 = NULL;
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((_tmp42 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp41 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp40 = vala_ccode_identifier_new ("obj"))), VALA_CCODE_EXPRESSION (ccall), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
	(_tmp42 == NULL ? NULL : (_tmp42 = (g_object_unref (_tmp42), NULL)));
	(_tmp41 == NULL ? NULL : (_tmp41 = (g_object_unref (_tmp41), NULL)));
	(_tmp40 == NULL ? NULL : (_tmp40 = (g_object_unref (_tmp40), NULL)));
	_tmp44 = NULL;
	_tmp43 = NULL;
	ccall = (_tmp44 = VALA_CCODE_FUNCTION_CALL (vala_instance_cast_new (VALA_CCODE_EXPRESSION ((_tmp43 = vala_ccode_identifier_new ("obj"))), VALA_TYPESYMBOL (cl))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), _tmp44);
	(_tmp43 == NULL ? NULL : (_tmp43 = (g_object_unref (_tmp43), NULL)));
	_tmp47 = NULL;
	_tmp46 = NULL;
	_tmp45 = NULL;
	cdecl_ = (_tmp47 = vala_ccode_declaration_new ((_tmp46 = g_strdup_printf ("%s *", (_tmp45 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE))))), (cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL))), _tmp47);
	(_tmp46 = (g_free (_tmp46), NULL));
	(_tmp45 = (g_free (_tmp45), NULL));
	_tmp48 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp48 = vala_ccode_variable_declarator_new_with_initializer ("self", VALA_CCODE_EXPRESSION (ccall)))));
	(_tmp48 == NULL ? NULL : (_tmp48 = (g_object_unref (_tmp48), NULL)));
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cdecl_));
	if (self->priv->current_method_inner_error) {
		ValaCCodeDeclaration* cdecl_;
		ValaCCodeVariableDeclarator* _tmp50;
		ValaCCodeConstant* _tmp49;
		/* always separate error parameter and inner_error local variable
		 * as error may be set to NULL but we're always interested in inner errors
		 */
		cdecl_ = vala_ccode_declaration_new ("GError *");
		_tmp50 = NULL;
		_tmp49 = NULL;
		vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp50 = vala_ccode_variable_declarator_new_with_initializer ("inner_error", VALA_CCODE_EXPRESSION ((_tmp49 = vala_ccode_constant_new ("NULL")))))));
		(_tmp50 == NULL ? NULL : (_tmp50 = (g_object_unref (_tmp50), NULL)));
		(_tmp49 == NULL ? NULL : (_tmp49 = (g_object_unref (_tmp49), NULL)));
		vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cdecl_));
		(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
	}
	vala_ccode_block_add_statement (cblock, vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_constructor_get_body (c))));
	_tmp52 = NULL;
	_tmp51 = NULL;
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((_tmp52 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION ((_tmp51 = vala_ccode_identifier_new ("obj")))))));
	(_tmp52 == NULL ? NULL : (_tmp52 = (g_object_unref (_tmp52), NULL)));
	(_tmp51 == NULL ? NULL : (_tmp51 = (g_object_unref (_tmp51), NULL)));
	vala_ccode_function_set_block (self->priv->function, cblock);
	if (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (c))) != NULL) {
		ValaCCodeComment* _tmp53;
		_tmp53 = NULL;
		vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE ((_tmp53 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (c)))))));
		(_tmp53 == NULL ? NULL : (_tmp53 = (g_object_unref (_tmp53), NULL)));
	}
	vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (self->priv->function));
	(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
	(cblock == NULL ? NULL : (cblock = (g_object_unref (cblock), NULL)));
	(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
}


static void vala_ccode_generator_real_visit_destructor (ValaCodeVisitor* base, ValaDestructor* d) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (d == NULL || VALA_IS_DESTRUCTOR (d));
	vala_code_node_accept_children (VALA_CODE_NODE (d), VALA_CODE_VISITOR (self));
}


static void vala_ccode_generator_real_visit_block (ValaCodeVisitor* base, ValaBlock* b) {
	ValaCCodeGenerator * self;
	ValaSymbol* _tmp1;
	ValaBlock* _tmp0;
	GeeCollection* local_vars;
	ValaCCodeBlock* cblock;
	ValaSymbol* _tmp9;
	ValaSymbol* _tmp8;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (b == NULL || VALA_IS_BLOCK (b));
	_tmp1 = NULL;
	_tmp0 = NULL;
	self->priv->current_symbol = (_tmp1 = VALA_SYMBOL ((_tmp0 = b, (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)))), (self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL))), _tmp1);
	vala_code_node_accept_children (VALA_CODE_NODE (b), VALA_CODE_VISITOR (self));
	local_vars = vala_block_get_local_variables (b);
	{
		GeeCollection* decl_collection;
		GeeIterator* decl_it;
		decl_collection = local_vars;
		decl_it = gee_iterable_iterator (GEE_ITERABLE (decl_collection));
		while (gee_iterator_next (decl_it)) {
			ValaVariableDeclarator* decl;
			decl = gee_iterator_get (decl_it);
			{
				vala_symbol_set_active (VALA_SYMBOL (decl), FALSE);
				(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
			}
		}
		(decl_it == NULL ? NULL : (decl_it = (g_object_unref (decl_it), NULL)));
	}
	cblock = vala_ccode_block_new ();
	{
		GeeCollection* stmt_collection;
		GeeIterator* stmt_it;
		stmt_collection = vala_block_get_statements (b);
		stmt_it = gee_iterable_iterator (GEE_ITERABLE (stmt_collection));
		while (gee_iterator_next (stmt_it)) {
			ValaCodeNode* stmt;
			stmt = gee_iterator_get (stmt_it);
			{
				ValaSourceReference* _tmp2;
				ValaSourceReference* src;
				_tmp2 = NULL;
				src = (_tmp2 = vala_code_node_get_source_reference (stmt), (_tmp2 == NULL ? NULL : g_object_ref (_tmp2)));
				if (src != NULL && vala_source_reference_get_comment (src) != NULL) {
					ValaCCodeComment* _tmp3;
					_tmp3 = NULL;
					vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((_tmp3 = vala_ccode_comment_new (vala_source_reference_get_comment (src)))));
					(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
				}
				if (VALA_IS_CCODE_FRAGMENT (vala_code_node_get_ccodenode (stmt))) {
					{
						GeeCollection* cstmt_collection;
						GeeIterator* cstmt_it;
						cstmt_collection = vala_ccode_fragment_get_children ((VALA_CCODE_FRAGMENT (vala_code_node_get_ccodenode (stmt))));
						cstmt_it = gee_iterable_iterator (GEE_ITERABLE (cstmt_collection));
						while (gee_iterator_next (cstmt_it)) {
							ValaCCodeStatement* cstmt;
							cstmt = gee_iterator_get (cstmt_it);
							{
								vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cstmt));
								(cstmt == NULL ? NULL : (cstmt = (g_object_unref (cstmt), NULL)));
							}
						}
						(cstmt_collection == NULL ? NULL : (cstmt_collection = (g_object_unref (cstmt_collection), NULL)));
						(cstmt_it == NULL ? NULL : (cstmt_it = (g_object_unref (cstmt_it), NULL)));
					}
				} else {
					vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode (stmt))));
				}
				(stmt == NULL ? NULL : (stmt = (g_object_unref (stmt), NULL)));
				(src == NULL ? NULL : (src = (g_object_unref (src), NULL)));
			}
		}
		(stmt_collection == NULL ? NULL : (stmt_collection = (g_object_unref (stmt_collection), NULL)));
		(stmt_it == NULL ? NULL : (stmt_it = (g_object_unref (stmt_it), NULL)));
	}
	{
		GeeCollection* decl_collection;
		GeeIterator* decl_it;
		decl_collection = local_vars;
		decl_it = gee_iterable_iterator (GEE_ITERABLE (decl_collection));
		while (gee_iterator_next (decl_it)) {
			ValaVariableDeclarator* decl;
			decl = gee_iterator_get (decl_it);
			{
				if (vala_data_type_get_takes_ownership (vala_variable_declarator_get_type_reference (decl))) {
					ValaMemberAccess* ma;
					ValaCCodeExpressionStatement* _tmp7;
					ValaCCodeExpression* _tmp6;
					ValaCCodeIdentifier* _tmp5;
					char* _tmp4;
					ma = vala_member_access_new_simple (vala_symbol_get_name (VALA_SYMBOL (decl)), NULL);
					vala_expression_set_symbol_reference (VALA_EXPRESSION (ma), VALA_SYMBOL (decl));
					_tmp7 = NULL;
					_tmp6 = NULL;
					_tmp5 = NULL;
					_tmp4 = NULL;
					vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((_tmp7 = vala_ccode_expression_statement_new ((_tmp6 = vala_ccode_generator_get_unref_expression (self, VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_identifier_new ((_tmp4 = vala_ccode_generator_get_variable_cname (self, vala_symbol_get_name (VALA_SYMBOL (decl))))))), vala_variable_declarator_get_type_reference (decl), VALA_EXPRESSION (ma)))))));
					(_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL)));
					(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
					(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
					(_tmp4 = (g_free (_tmp4), NULL));
					(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
				}
				(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
			}
		}
		(decl_it == NULL ? NULL : (decl_it = (g_object_unref (decl_it), NULL)));
	}
	vala_code_node_set_ccodenode (VALA_CODE_NODE (b), VALA_CCODE_NODE (cblock));
	_tmp9 = NULL;
	_tmp8 = NULL;
	self->priv->current_symbol = (_tmp9 = (_tmp8 = vala_symbol_get_parent_symbol (self->priv->current_symbol), (_tmp8 == NULL ? NULL : g_object_ref (_tmp8))), (self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL))), _tmp9);
	(local_vars == NULL ? NULL : (local_vars = (g_object_unref (local_vars), NULL)));
	(cblock == NULL ? NULL : (cblock = (g_object_unref (cblock), NULL)));
}


static void vala_ccode_generator_real_visit_empty_statement (ValaCodeVisitor* base, ValaEmptyStatement* stmt) {
	ValaCCodeGenerator * self;
	ValaCCodeEmptyStatement* _tmp0;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (stmt == NULL || VALA_IS_EMPTY_STATEMENT (stmt));
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((_tmp0 = vala_ccode_empty_statement_new ())));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
}


static void vala_ccode_generator_real_visit_declaration_statement (ValaCodeVisitor* base, ValaDeclarationStatement* stmt) {
	ValaCCodeGenerator * self;
	ValaCCodeFragment* cfrag;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (stmt == NULL || VALA_IS_DECLARATION_STATEMENT (stmt));
	/* split declaration statement as var declarators
	 * might have different types */
	cfrag = vala_ccode_fragment_new ();
	{
		GeeCollection* decl_collection;
		GeeIterator* decl_it;
		decl_collection = vala_local_variable_declaration_get_variable_declarators (vala_declaration_statement_get_declaration (stmt));
		decl_it = gee_iterable_iterator (GEE_ITERABLE (decl_collection));
		while (gee_iterator_next (decl_it)) {
			ValaVariableDeclarator* decl;
			decl = gee_iterator_get (decl_it);
			{
				char* _tmp0;
				ValaCCodeDeclaration* _tmp1;
				ValaCCodeDeclaration* cdecl_;
				_tmp0 = NULL;
				_tmp1 = NULL;
				cdecl_ = (_tmp1 = vala_ccode_declaration_new ((_tmp0 = vala_data_type_get_cname (vala_variable_declarator_get_type_reference (decl), FALSE, !vala_data_type_get_takes_ownership (vala_variable_declarator_get_type_reference (decl))))), (_tmp0 = (g_free (_tmp0), NULL)), _tmp1);
				vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR (VALA_CCODE_VARIABLE_DECLARATOR (vala_code_node_get_ccodenode (VALA_CODE_NODE (decl)))));
				vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE (cdecl_));
				if (vala_variable_declarator_get_initializer (decl) != NULL && vala_expression_get_can_fail (vala_variable_declarator_get_initializer (decl))) {
					vala_ccode_generator_add_simple_check (self, VALA_CODE_NODE (vala_variable_declarator_get_initializer (decl)), cfrag);
				}
				/* try to initialize uninitialized variables */
				if (vala_variable_declarator_get_initializer (decl) == NULL && VALA_IS_STRUCT (vala_data_type_get_data_type (vala_variable_declarator_get_type_reference (decl)))) {
					char* _tmp2;
					gboolean _tmp3;
					_tmp2 = NULL;
					if ((_tmp3 = (_tmp2 = vala_typesymbol_get_default_value (vala_data_type_get_data_type (vala_variable_declarator_get_type_reference (decl)))) != NULL, (_tmp2 = (g_free (_tmp2), NULL)), _tmp3)) {
						ValaCCodeConstant* _tmp5;
						char* _tmp4;
						_tmp5 = NULL;
						_tmp4 = NULL;
						vala_ccode_variable_declarator_set_initializer ((VALA_CCODE_VARIABLE_DECLARATOR (vala_code_node_get_ccodenode (VALA_CODE_NODE (decl)))), VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_constant_new ((_tmp4 = vala_typesymbol_get_default_value (vala_data_type_get_data_type (vala_variable_declarator_get_type_reference (decl))))))));
						(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
						(_tmp4 = (g_free (_tmp4), NULL));
					} else {
						ValaStruct* _tmp6;
						ValaStruct* st;
						ValaCCodeIdentifier* _tmp7;
						ValaCCodeFunctionCall* _tmp8;
						ValaCCodeFunctionCall* czero;
						ValaCCodeUnaryExpression* _tmp11;
						ValaCCodeIdentifier* _tmp10;
						char* _tmp9;
						ValaCCodeConstant* _tmp12;
						ValaCCodeIdentifier* _tmp15;
						char* _tmp14;
						char* _tmp13;
						ValaCCodeExpressionStatement* _tmp16;
						_tmp6 = NULL;
						st = (_tmp6 = VALA_STRUCT (vala_data_type_get_data_type (vala_variable_declarator_get_type_reference (decl))), (_tmp6 == NULL ? NULL : g_object_ref (_tmp6)));
						/* memset needs string.h */
						self->priv->string_h_needed = TRUE;
						_tmp7 = NULL;
						_tmp8 = NULL;
						czero = (_tmp8 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp7 = vala_ccode_identifier_new ("memset")))), (_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL))), _tmp8);
						_tmp11 = NULL;
						_tmp10 = NULL;
						_tmp9 = NULL;
						vala_ccode_function_call_add_argument (czero, VALA_CCODE_EXPRESSION ((_tmp11 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp10 = vala_ccode_identifier_new ((_tmp9 = vala_ccode_generator_get_variable_cname (self, vala_symbol_get_name (VALA_SYMBOL (decl)))))))))));
						(_tmp11 == NULL ? NULL : (_tmp11 = (g_object_unref (_tmp11), NULL)));
						(_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL)));
						(_tmp9 = (g_free (_tmp9), NULL));
						_tmp12 = NULL;
						vala_ccode_function_call_add_argument (czero, VALA_CCODE_EXPRESSION ((_tmp12 = vala_ccode_constant_new ("0"))));
						(_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL)));
						_tmp15 = NULL;
						_tmp14 = NULL;
						_tmp13 = NULL;
						vala_ccode_function_call_add_argument (czero, VALA_CCODE_EXPRESSION ((_tmp15 = vala_ccode_identifier_new ((_tmp14 = g_strdup_printf ("sizeof (%s)", (_tmp13 = vala_data_type_get_cname (vala_variable_declarator_get_type_reference (decl), FALSE, FALSE))))))));
						(_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL)));
						(_tmp14 = (g_free (_tmp14), NULL));
						(_tmp13 = (g_free (_tmp13), NULL));
						_tmp16 = NULL;
						vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((_tmp16 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (czero)))));
						(_tmp16 == NULL ? NULL : (_tmp16 = (g_object_unref (_tmp16), NULL)));
						(st == NULL ? NULL : (st = (g_object_unref (st), NULL)));
						(czero == NULL ? NULL : (czero = (g_object_unref (czero), NULL)));
					}
				}
				(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
				(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
			}
		}
		(decl_collection == NULL ? NULL : (decl_collection = (g_object_unref (decl_collection), NULL)));
		(decl_it == NULL ? NULL : (decl_it = (g_object_unref (decl_it), NULL)));
	}
	vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE (cfrag));
	{
		GeeCollection* decl_collection;
		GeeIterator* decl_it;
		decl_collection = vala_local_variable_declaration_get_variable_declarators (vala_declaration_statement_get_declaration (stmt));
		decl_it = gee_iterable_iterator (GEE_ITERABLE (decl_collection));
		while (gee_iterator_next (decl_it)) {
			ValaVariableDeclarator* decl;
			decl = gee_iterator_get (decl_it);
			{
				if (vala_variable_declarator_get_initializer (decl) != NULL) {
					vala_ccode_generator_create_temp_decl (self, VALA_STATEMENT (stmt), GEE_COLLECTION (vala_variable_declarator_get_initializer (decl)->temp_vars));
				}
				(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
			}
		}
		(decl_collection == NULL ? NULL : (decl_collection = (g_object_unref (decl_collection), NULL)));
		(decl_it == NULL ? NULL : (decl_it = (g_object_unref (decl_it), NULL)));
	}
	vala_ccode_generator_create_temp_decl (self, VALA_STATEMENT (stmt), GEE_COLLECTION (self->temp_vars));
	gee_collection_clear (GEE_COLLECTION (self->temp_vars));
	(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
}


static char* vala_ccode_generator_get_variable_cname (ValaCCodeGenerator* self, const char* name) {
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	if (gee_collection_contains (GEE_COLLECTION (self->priv->c_keywords), name)) {
		return g_strconcat (name, "_", NULL);
	} else {
		const char* _tmp1;
		_tmp1 = NULL;
		return (_tmp1 = name, (_tmp1 == NULL ? NULL : g_strdup (_tmp1)));
	}
}


static void vala_ccode_generator_real_visit_variable_declarator (ValaCodeVisitor* base, ValaVariableDeclarator* decl) {
	ValaCCodeGenerator * self;
	ValaCCodeExpression* rhs;
	ValaCCodeVariableDeclarator* _tmp34;
	char* _tmp33;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (decl == NULL || VALA_IS_VARIABLE_DECLARATOR (decl));
	vala_code_node_accept_children (VALA_CODE_NODE (decl), VALA_CODE_VISITOR (self));
	if (VALA_IS_ARRAY (vala_data_type_get_data_type (vala_variable_declarator_get_type_reference (decl)))) {
		ValaArray* _tmp0;
		ValaArray* arr;
		/* create variables to store array dimensions*/
		_tmp0 = NULL;
		arr = (_tmp0 = VALA_ARRAY (vala_data_type_get_data_type (vala_variable_declarator_get_type_reference (decl))), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
		{
			gint dim;
			dim = 0;
			for (dim = 1; dim <= vala_array_get_rank (arr); dim++) {
				char* _tmp1;
				ValaVariableDeclarator* _tmp2;
				ValaVariableDeclarator* len_decl;
				ValaDataType* _tmp3;
				_tmp1 = NULL;
				_tmp2 = NULL;
				len_decl = (_tmp2 = vala_variable_declarator_new ((_tmp1 = vala_ccode_generator_get_array_length_cname (self, vala_symbol_get_name (VALA_SYMBOL (decl)), dim)), NULL, NULL), (_tmp1 = (g_free (_tmp1), NULL)), _tmp2);
				_tmp3 = NULL;
				vala_variable_declarator_set_type_reference (len_decl, (_tmp3 = vala_data_type_copy (self->int_type)));
				(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
				gee_list_insert (GEE_LIST (self->temp_vars), 0, len_decl);
				(len_decl == NULL ? NULL : (len_decl = (g_object_unref (len_decl), NULL)));
			}
		}
		(arr == NULL ? NULL : (arr = (g_object_unref (arr), NULL)));
	} else {
		if (VALA_IS_DELEGATE_TYPE (vala_variable_declarator_get_type_reference (decl))) {
			ValaDelegateType* _tmp4;
			ValaDelegateType* deleg_type;
			ValaDelegate* _tmp5;
			ValaDelegate* d;
			_tmp4 = NULL;
			deleg_type = (_tmp4 = VALA_DELEGATE_TYPE (vala_variable_declarator_get_type_reference (decl)), (_tmp4 == NULL ? NULL : g_object_ref (_tmp4)));
			_tmp5 = NULL;
			d = (_tmp5 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp5 == NULL ? NULL : g_object_ref (_tmp5)));
			if (vala_delegate_get_instance (d)) {
				char* _tmp6;
				ValaVariableDeclarator* _tmp7;
				ValaVariableDeclarator* target_decl;
				ValaPointerType* _tmp9;
				ValaVoidType* _tmp8;
				/* create variable to store delegate target*/
				_tmp6 = NULL;
				_tmp7 = NULL;
				target_decl = (_tmp7 = vala_variable_declarator_new ((_tmp6 = vala_ccode_generator_get_delegate_target_cname (self, vala_symbol_get_name (VALA_SYMBOL (decl)))), NULL, NULL), (_tmp6 = (g_free (_tmp6), NULL)), _tmp7);
				_tmp9 = NULL;
				_tmp8 = NULL;
				vala_variable_declarator_set_type_reference (target_decl, VALA_DATA_TYPE ((_tmp9 = vala_pointer_type_new (VALA_DATA_TYPE ((_tmp8 = vala_void_type_new ()))))));
				(_tmp9 == NULL ? NULL : (_tmp9 = (g_object_unref (_tmp9), NULL)));
				(_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL)));
				gee_list_insert (GEE_LIST (self->temp_vars), 0, target_decl);
				(target_decl == NULL ? NULL : (target_decl = (g_object_unref (target_decl), NULL)));
			}
			(deleg_type == NULL ? NULL : (deleg_type = (g_object_unref (deleg_type), NULL)));
			(d == NULL ? NULL : (d = (g_object_unref (d), NULL)));
		}
	}
	rhs = NULL;
	if (vala_variable_declarator_get_initializer (decl) != NULL) {
		ValaCCodeExpression* _tmp11;
		ValaCCodeExpression* _tmp10;
		ValaCCodeExpression* _tmp12;
		_tmp11 = NULL;
		_tmp10 = NULL;
		rhs = (_tmp11 = (_tmp10 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_variable_declarator_get_initializer (decl)))), (_tmp10 == NULL ? NULL : g_object_ref (_tmp10))), (rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL))), _tmp11);
		_tmp12 = NULL;
		rhs = (_tmp12 = vala_ccode_generator_get_implicit_cast_expression (self, rhs, vala_expression_get_static_type (vala_variable_declarator_get_initializer (decl)), vala_variable_declarator_get_type_reference (decl)), (rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL))), _tmp12);
		if (VALA_IS_ARRAY (vala_data_type_get_data_type (vala_variable_declarator_get_type_reference (decl)))) {
			ValaArray* _tmp13;
			ValaArray* arr;
			ValaCCodeCommaExpression* ccomma;
			ValaVariableDeclarator* temp_decl;
			ValaCCodeAssignment* _tmp15;
			ValaCCodeIdentifier* _tmp14;
			ValaCCodeIdentifier* _tmp19;
			ValaCCodeExpression* _tmp21;
			ValaCCodeCommaExpression* _tmp20;
			_tmp13 = NULL;
			arr = (_tmp13 = VALA_ARRAY (vala_data_type_get_data_type (vala_variable_declarator_get_type_reference (decl))), (_tmp13 == NULL ? NULL : g_object_ref (_tmp13)));
			ccomma = vala_ccode_comma_expression_new ();
			temp_decl = vala_ccode_generator_get_temp_variable_declarator (self, vala_variable_declarator_get_type_reference (decl), TRUE, VALA_CODE_NODE (decl));
			gee_list_insert (GEE_LIST (self->temp_vars), 0, temp_decl);
			_tmp15 = NULL;
			_tmp14 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp15 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp14 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_decl))))), rhs, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
			(_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL)));
			(_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL)));
			{
				gint dim;
				dim = 0;
				for (dim = 1; dim <= vala_array_get_rank (arr); dim++) {
					char* _tmp16;
					ValaCCodeIdentifier* _tmp17;
					ValaCCodeIdentifier* lhs_array_len;
					ValaCCodeExpression* rhs_array_len;
					ValaCCodeAssignment* _tmp18;
					_tmp16 = NULL;
					_tmp17 = NULL;
					lhs_array_len = (_tmp17 = vala_ccode_identifier_new ((_tmp16 = vala_ccode_generator_get_array_length_cname (self, vala_symbol_get_name (VALA_SYMBOL (decl)), dim))), (_tmp16 = (g_free (_tmp16), NULL)), _tmp17);
					rhs_array_len = vala_ccode_generator_get_array_length_cexpression (self, vala_variable_declarator_get_initializer (decl), dim);
					_tmp18 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp18 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (lhs_array_len), rhs_array_len, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
					(_tmp18 == NULL ? NULL : (_tmp18 = (g_object_unref (_tmp18), NULL)));
					(lhs_array_len == NULL ? NULL : (lhs_array_len = (g_object_unref (lhs_array_len), NULL)));
					(rhs_array_len == NULL ? NULL : (rhs_array_len = (g_object_unref (rhs_array_len), NULL)));
				}
			}
			_tmp19 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp19 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_decl))))));
			(_tmp19 == NULL ? NULL : (_tmp19 = (g_object_unref (_tmp19), NULL)));
			_tmp21 = NULL;
			_tmp20 = NULL;
			rhs = (_tmp21 = VALA_CCODE_EXPRESSION ((_tmp20 = ccomma, (_tmp20 == NULL ? NULL : g_object_ref (_tmp20)))), (rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL))), _tmp21);
			(arr == NULL ? NULL : (arr = (g_object_unref (arr), NULL)));
			(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
			(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
		} else {
			if (VALA_IS_DELEGATE_TYPE (vala_variable_declarator_get_type_reference (decl))) {
				ValaDelegateType* _tmp22;
				ValaDelegateType* deleg_type;
				ValaDelegate* _tmp23;
				ValaDelegate* d;
				_tmp22 = NULL;
				deleg_type = (_tmp22 = VALA_DELEGATE_TYPE (vala_variable_declarator_get_type_reference (decl)), (_tmp22 == NULL ? NULL : g_object_ref (_tmp22)));
				_tmp23 = NULL;
				d = (_tmp23 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp23 == NULL ? NULL : g_object_ref (_tmp23)));
				if (vala_delegate_get_instance (d)) {
					ValaCCodeCommaExpression* ccomma;
					ValaVariableDeclarator* temp_decl;
					ValaCCodeAssignment* _tmp25;
					ValaCCodeIdentifier* _tmp24;
					char* _tmp26;
					ValaCCodeIdentifier* _tmp27;
					ValaCCodeIdentifier* lhs_delegate_target;
					ValaCCodeExpression* rhs_delegate_target;
					ValaCCodeAssignment* _tmp28;
					ValaCCodeIdentifier* _tmp29;
					ValaCCodeExpression* _tmp31;
					ValaCCodeCommaExpression* _tmp30;
					ccomma = vala_ccode_comma_expression_new ();
					temp_decl = vala_ccode_generator_get_temp_variable_declarator (self, vala_variable_declarator_get_type_reference (decl), TRUE, VALA_CODE_NODE (decl));
					gee_list_insert (GEE_LIST (self->temp_vars), 0, temp_decl);
					_tmp25 = NULL;
					_tmp24 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp25 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp24 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_decl))))), rhs, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
					(_tmp25 == NULL ? NULL : (_tmp25 = (g_object_unref (_tmp25), NULL)));
					(_tmp24 == NULL ? NULL : (_tmp24 = (g_object_unref (_tmp24), NULL)));
					_tmp26 = NULL;
					_tmp27 = NULL;
					lhs_delegate_target = (_tmp27 = vala_ccode_identifier_new ((_tmp26 = vala_ccode_generator_get_delegate_target_cname (self, vala_symbol_get_name (VALA_SYMBOL (decl))))), (_tmp26 = (g_free (_tmp26), NULL)), _tmp27);
					rhs_delegate_target = vala_ccode_generator_get_delegate_target_cexpression (self, vala_variable_declarator_get_initializer (decl));
					_tmp28 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp28 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (lhs_delegate_target), rhs_delegate_target, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
					(_tmp28 == NULL ? NULL : (_tmp28 = (g_object_unref (_tmp28), NULL)));
					_tmp29 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp29 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_decl))))));
					(_tmp29 == NULL ? NULL : (_tmp29 = (g_object_unref (_tmp29), NULL)));
					_tmp31 = NULL;
					_tmp30 = NULL;
					rhs = (_tmp31 = VALA_CCODE_EXPRESSION ((_tmp30 = ccomma, (_tmp30 == NULL ? NULL : g_object_ref (_tmp30)))), (rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL))), _tmp31);
					(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
					(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
					(lhs_delegate_target == NULL ? NULL : (lhs_delegate_target = (g_object_unref (lhs_delegate_target), NULL)));
					(rhs_delegate_target == NULL ? NULL : (rhs_delegate_target = (g_object_unref (rhs_delegate_target), NULL)));
				}
				(deleg_type == NULL ? NULL : (deleg_type = (g_object_unref (deleg_type), NULL)));
				(d == NULL ? NULL : (d = (g_object_unref (d), NULL)));
			}
		}
	} else {
		if (vala_data_type_get_data_type (vala_variable_declarator_get_type_reference (decl)) != NULL && vala_typesymbol_is_reference_type (vala_data_type_get_data_type (vala_variable_declarator_get_type_reference (decl)))) {
			ValaCCodeExpression* _tmp32;
			_tmp32 = NULL;
			rhs = (_tmp32 = VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL")), (rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL))), _tmp32);
		}
	}
	_tmp34 = NULL;
	_tmp33 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (decl), VALA_CCODE_NODE ((_tmp34 = vala_ccode_variable_declarator_new_with_initializer ((_tmp33 = vala_ccode_generator_get_variable_cname (self, vala_symbol_get_name (VALA_SYMBOL (decl)))), rhs))));
	(_tmp34 == NULL ? NULL : (_tmp34 = (g_object_unref (_tmp34), NULL)));
	(_tmp33 = (g_free (_tmp33), NULL));
	vala_symbol_set_active (VALA_SYMBOL (decl), TRUE);
	(rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL)));
}


static void vala_ccode_generator_real_visit_initializer_list (ValaCodeVisitor* base, ValaInitializerList* list) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (list == NULL || VALA_IS_INITIALIZER_LIST (list));
	vala_code_node_accept_children (VALA_CODE_NODE (list), VALA_CODE_VISITOR (self));
	if (vala_expression_get_expected_type (VALA_EXPRESSION (list)) != NULL && VALA_IS_ARRAY (vala_data_type_get_data_type (vala_expression_get_expected_type (VALA_EXPRESSION (list))))) {
	} else {
		ValaCCodeInitializerList* clist;
		/* TODO */
		clist = vala_ccode_initializer_list_new ();
		{
			GeeCollection* expr_collection;
			GeeIterator* expr_it;
			expr_collection = vala_initializer_list_get_initializers (list);
			expr_it = gee_iterable_iterator (GEE_ITERABLE (expr_collection));
			while (gee_iterator_next (expr_it)) {
				ValaExpression* expr;
				expr = gee_iterator_get (expr_it);
				{
					vala_ccode_initializer_list_append (clist, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (expr))));
					(expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL)));
				}
			}
			(expr_collection == NULL ? NULL : (expr_collection = (g_object_unref (expr_collection), NULL)));
			(expr_it == NULL ? NULL : (expr_it = (g_object_unref (expr_it), NULL)));
		}
		vala_code_node_set_ccodenode (VALA_CODE_NODE (list), VALA_CCODE_NODE (clist));
		(clist == NULL ? NULL : (clist = (g_object_unref (clist), NULL)));
	}
}


ValaVariableDeclarator* vala_ccode_generator_get_temp_variable_declarator (ValaCCodeGenerator* self, ValaDataType* type, gboolean takes_ownership, ValaCodeNode* node_reference) {
	char* _tmp0;
	ValaVariableDeclarator* _tmp1;
	ValaVariableDeclarator* decl;
	ValaDataType* _tmp2;
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	g_return_val_if_fail (type == NULL || VALA_IS_DATA_TYPE (type), NULL);
	g_return_val_if_fail (node_reference == NULL || VALA_IS_CODE_NODE (node_reference), NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	decl = (_tmp1 = vala_variable_declarator_new ((_tmp0 = g_strdup_printf ("_tmp%d", self->priv->next_temp_var_id)), NULL, NULL), (_tmp0 = (g_free (_tmp0), NULL)), _tmp1);
	_tmp2 = NULL;
	vala_variable_declarator_set_type_reference (decl, (_tmp2 = vala_data_type_copy (type)));
	(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
	vala_data_type_set_is_ref (vala_variable_declarator_get_type_reference (decl), FALSE);
	vala_data_type_set_is_out (vala_variable_declarator_get_type_reference (decl), FALSE);
	vala_data_type_set_takes_ownership (vala_variable_declarator_get_type_reference (decl), takes_ownership);
	if (node_reference != NULL) {
		vala_code_node_set_source_reference (VALA_CODE_NODE (decl), vala_code_node_get_source_reference (node_reference));
	}
	self->priv->next_temp_var_id++;
	return decl;
}


static ValaCCodeExpression* vala_ccode_generator_get_type_id_expression (ValaCCodeGenerator* self, ValaDataType* type) {
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	g_return_val_if_fail (type == NULL || VALA_IS_DATA_TYPE (type), NULL);
	if (vala_data_type_get_data_type (type) != NULL) {
		char* _tmp0;
		ValaCCodeIdentifier* _tmp1;
		_tmp0 = NULL;
		_tmp1 = NULL;
		return VALA_CCODE_EXPRESSION ((_tmp1 = vala_ccode_identifier_new ((_tmp0 = vala_typesymbol_get_type_id (vala_data_type_get_data_type (type)))), (_tmp0 = (g_free (_tmp0), NULL)), _tmp1));
	} else {
		if (vala_data_type_get_type_parameter (type) != NULL) {
			char* _tmp3;
			char* _tmp4;
			char* var_name;
			ValaCCodeMemberAccess* _tmp6;
			ValaCCodeIdentifier* _tmp5;
			ValaCCodeMemberAccess* _tmp7;
			ValaCCodeMemberAccess* _tmp8;
			_tmp3 = NULL;
			_tmp4 = NULL;
			var_name = (_tmp4 = g_strdup_printf ("%s_type", (_tmp3 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (vala_data_type_get_type_parameter (type))), -1))), (_tmp3 = (g_free (_tmp3), NULL)), _tmp4);
			_tmp6 = NULL;
			_tmp5 = NULL;
			_tmp7 = NULL;
			_tmp8 = NULL;
			return VALA_CCODE_EXPRESSION ((_tmp8 = (_tmp7 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp6 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_identifier_new ("self"))), "priv"))), var_name), (_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL))), (_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL))), _tmp7), (var_name = (g_free (var_name), NULL)), _tmp8));
		} else {
			return VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("G_TYPE_NONE"));
		}
	}
}


static ValaCCodeExpression* vala_ccode_generator_get_dup_func_expression (ValaCCodeGenerator* self, ValaDataType* type) {
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	g_return_val_if_fail (type == NULL || VALA_IS_DATA_TYPE (type), NULL);
	if (vala_data_type_get_data_type (type) != NULL) {
		char* dup_function;
		gpointer _tmp6;
		dup_function = NULL;
		if (vala_typesymbol_is_reference_counting (vala_data_type_get_data_type (type))) {
			char* _tmp0;
			_tmp0 = NULL;
			dup_function = (_tmp0 = vala_typesymbol_get_ref_function (vala_data_type_get_data_type (type)), (dup_function = (g_free (dup_function), NULL)), _tmp0);
		} else {
			char* _tmp2;
			if (vala_data_type_get_data_type (type) != vala_data_type_get_data_type (self->string_type)) {
				char* _tmp1;
				/* duplicating non-reference counted structs may cause side-effects (and performance issues)*/
				_tmp1 = NULL;
				vala_report_warning (vala_code_node_get_source_reference (VALA_CODE_NODE (type)), (_tmp1 = g_strdup_printf ("duplicating %s instance, use weak variable or explicitly invoke copy method", vala_symbol_get_name (VALA_SYMBOL (vala_data_type_get_data_type (type))))));
				(_tmp1 = (g_free (_tmp1), NULL));
			}
			_tmp2 = NULL;
			dup_function = (_tmp2 = vala_typesymbol_get_dup_function (vala_data_type_get_data_type (type)), (dup_function = (g_free (dup_function), NULL)), _tmp2);
			if (dup_function == NULL) {
				char* _tmp4;
				char* _tmp3;
				_tmp4 = NULL;
				_tmp3 = NULL;
				vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (vala_data_type_get_data_type (type))), (_tmp4 = g_strdup_printf ("The type `%s` doesn't contain a copy function", (_tmp3 = vala_symbol_get_full_name (VALA_SYMBOL (vala_data_type_get_data_type (type)))))));
				(_tmp4 = (g_free (_tmp4), NULL));
				(_tmp3 = (g_free (_tmp3), NULL));
			}
		}
		if (NULL != dup_function) {
			ValaCCodeIdentifier* _tmp5;
			_tmp5 = NULL;
			return VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_identifier_new (dup_function), (dup_function = (g_free (dup_function), NULL)), _tmp5));
		}
		return (_tmp6 = NULL, (dup_function = (g_free (dup_function), NULL)), _tmp6);
	} else {
		if (vala_data_type_get_type_parameter (type) != NULL && VALA_IS_CLASS (self->current_type_symbol)) {
			char* _tmp7;
			char* _tmp8;
			char* func_name;
			ValaCCodeMemberAccess* _tmp10;
			ValaCCodeIdentifier* _tmp9;
			ValaCCodeMemberAccess* _tmp11;
			ValaCCodeMemberAccess* _tmp12;
			_tmp7 = NULL;
			_tmp8 = NULL;
			func_name = (_tmp8 = g_strdup_printf ("%s_dup_func", (_tmp7 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (vala_data_type_get_type_parameter (type))), -1))), (_tmp7 = (g_free (_tmp7), NULL)), _tmp8);
			_tmp10 = NULL;
			_tmp9 = NULL;
			_tmp11 = NULL;
			_tmp12 = NULL;
			return VALA_CCODE_EXPRESSION ((_tmp12 = (_tmp11 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp10 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp9 = vala_ccode_identifier_new ("self"))), "priv"))), func_name), (_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL))), (_tmp9 == NULL ? NULL : (_tmp9 = (g_object_unref (_tmp9), NULL))), _tmp11), (func_name = (g_free (func_name), NULL)), _tmp12));
		} else {
			return VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL"));
		}
	}
}


static ValaCCodeExpression* vala_ccode_generator_get_destroy_func_expression (ValaCCodeGenerator* self, ValaDataType* type) {
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	g_return_val_if_fail (type == NULL || VALA_IS_DATA_TYPE (type), NULL);
	if (vala_data_type_get_data_type (type) != NULL) {
		char* unref_function;
		ValaCCodeIdentifier* _tmp5;
		unref_function = NULL;
		if (vala_typesymbol_is_reference_counting (vala_data_type_get_data_type (type))) {
			char* _tmp0;
			_tmp0 = NULL;
			unref_function = (_tmp0 = vala_typesymbol_get_unref_function (vala_data_type_get_data_type (type)), (unref_function = (g_free (unref_function), NULL)), _tmp0);
		} else {
			char* _tmp1;
			_tmp1 = NULL;
			unref_function = (_tmp1 = vala_typesymbol_get_free_function (vala_data_type_get_data_type (type)), (unref_function = (g_free (unref_function), NULL)), _tmp1);
		}
		if (unref_function == NULL) {
			char* _tmp3;
			char* _tmp2;
			gpointer _tmp4;
			_tmp3 = NULL;
			_tmp2 = NULL;
			vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (vala_data_type_get_data_type (type))), (_tmp3 = g_strdup_printf ("The type `%s` doesn't contain a free function", (_tmp2 = vala_symbol_get_full_name (VALA_SYMBOL (vala_data_type_get_data_type (type)))))));
			(_tmp3 = (g_free (_tmp3), NULL));
			(_tmp2 = (g_free (_tmp2), NULL));
			return (_tmp4 = NULL, (unref_function = (g_free (unref_function), NULL)), _tmp4);
		}
		_tmp5 = NULL;
		return VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_identifier_new (unref_function), (unref_function = (g_free (unref_function), NULL)), _tmp5));
	} else {
		if (vala_data_type_get_type_parameter (type) != NULL && VALA_IS_CLASS (self->current_type_symbol)) {
			char* _tmp6;
			char* _tmp7;
			char* func_name;
			ValaCCodeMemberAccess* _tmp9;
			ValaCCodeIdentifier* _tmp8;
			ValaCCodeMemberAccess* _tmp10;
			ValaCCodeMemberAccess* _tmp11;
			_tmp6 = NULL;
			_tmp7 = NULL;
			func_name = (_tmp7 = g_strdup_printf ("%s_destroy_func", (_tmp6 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (vala_data_type_get_type_parameter (type))), -1))), (_tmp6 = (g_free (_tmp6), NULL)), _tmp7);
			_tmp9 = NULL;
			_tmp8 = NULL;
			_tmp10 = NULL;
			_tmp11 = NULL;
			return VALA_CCODE_EXPRESSION ((_tmp11 = (_tmp10 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp9 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp8 = vala_ccode_identifier_new ("self"))), "priv"))), func_name), (_tmp9 == NULL ? NULL : (_tmp9 = (g_object_unref (_tmp9), NULL))), (_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL))), _tmp10), (func_name = (g_free (func_name), NULL)), _tmp11));
		} else {
			return VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL"));
		}
	}
}


ValaCCodeExpression* vala_ccode_generator_get_unref_expression (ValaCCodeGenerator* self, ValaCCodeExpression* cvar, ValaDataType* type, ValaExpression* expr) {
	ValaCCodeConstant* _tmp1;
	ValaCCodeBinaryExpression* _tmp2;
	ValaCCodeBinaryExpression* cisnull;
	ValaCCodeExpression* _tmp8;
	ValaCCodeFunctionCall* _tmp9;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeCommaExpression* ccomma;
	ValaCCodeConstant* _tmp25;
	ValaCCodeAssignment* cassign;
	char* _tmp26;
	gboolean _tmp27;
	ValaCCodeParenthesizedExpression* _tmp30;
	ValaCCodeConstant* _tmp29;
	ValaCCodeConditionalExpression* _tmp31;
	ValaCCodeConditionalExpression* _tmp32;
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	g_return_val_if_fail (cvar == NULL || VALA_IS_CCODE_EXPRESSION (cvar), NULL);
	g_return_val_if_fail (type == NULL || VALA_IS_DATA_TYPE (type), NULL);
	g_return_val_if_fail (expr == NULL || VALA_IS_EXPRESSION (expr), NULL);
	/* (foo == NULL ? NULL : foo = (unref (foo), NULL)) 
	 can be simplified to
	 * foo = (unref (foo), NULL)
	 * if foo is of static type non-null
	 */
	if (vala_data_type_get_is_null (type)) {
		return VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL"));
	}
	_tmp1 = NULL;
	_tmp2 = NULL;
	cisnull = (_tmp2 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, cvar, VALA_CCODE_EXPRESSION ((_tmp1 = vala_ccode_constant_new ("NULL")))), (_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL))), _tmp2);
	if (vala_data_type_get_data_type (type) == NULL) {
		ValaCCodeConstant* _tmp5;
		ValaCCodeExpression* _tmp4;
		ValaCCodeBinaryExpression* _tmp6;
		ValaCCodeBinaryExpression* cunrefisnull;
		ValaCCodeBinaryExpression* _tmp7;
		if (!(VALA_IS_CLASS (self->current_type_symbol)) || !vala_typesymbol_is_subtype_of (VALA_TYPESYMBOL (self->priv->current_class), self->gobject_type)) {
			ValaCCodeConstant* _tmp3;
			_tmp3 = NULL;
			return VALA_CCODE_EXPRESSION ((_tmp3 = vala_ccode_constant_new ("NULL"), (cisnull == NULL ? NULL : (cisnull = (g_object_unref (cisnull), NULL))), _tmp3));
		}
		/* unref functions are optional for type parameters*/
		_tmp5 = NULL;
		_tmp4 = NULL;
		_tmp6 = NULL;
		cunrefisnull = (_tmp6 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (_tmp4 = vala_ccode_generator_get_destroy_func_expression (self, type)), VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_constant_new ("NULL")))), (_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL))), (_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL))), _tmp6);
		_tmp7 = NULL;
		cisnull = (_tmp7 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_OR, VALA_CCODE_EXPRESSION (cisnull), VALA_CCODE_EXPRESSION (cunrefisnull)), (cisnull == NULL ? NULL : (cisnull = (g_object_unref (cisnull), NULL))), _tmp7);
		(cunrefisnull == NULL ? NULL : (cunrefisnull = (g_object_unref (cunrefisnull), NULL)));
	}
	_tmp8 = NULL;
	_tmp9 = NULL;
	ccall = (_tmp9 = vala_ccode_function_call_new ((_tmp8 = vala_ccode_generator_get_destroy_func_expression (self, type))), (_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL))), _tmp9);
	vala_ccode_function_call_add_argument (ccall, cvar);
	/* set freed references to NULL to prevent further use */
	ccomma = vala_ccode_comma_expression_new ();
	if (vala_data_type_get_data_type (type) == self->glist_type || vala_data_type_get_data_type (type) == self->gslist_type) {
		gboolean takes_ownership;
		ValaCCodeExpression* destroy_func_expression;
		takes_ownership = FALSE;
		destroy_func_expression = NULL;
		{
			GeeList* type_arg_collection;
			GeeIterator* type_arg_it;
			type_arg_collection = vala_data_type_get_type_arguments (type);
			type_arg_it = gee_iterable_iterator (GEE_ITERABLE (type_arg_collection));
			while (gee_iterator_next (type_arg_it)) {
				ValaDataType* type_arg;
				type_arg = gee_iterator_get (type_arg_it);
				{
					takes_ownership = vala_data_type_get_takes_ownership (type_arg);
					if (takes_ownership) {
						ValaCCodeExpression* _tmp10;
						_tmp10 = NULL;
						destroy_func_expression = (_tmp10 = vala_ccode_generator_get_destroy_func_expression (self, type_arg), (destroy_func_expression == NULL ? NULL : (destroy_func_expression = (g_object_unref (destroy_func_expression), NULL))), _tmp10);
					}
					(type_arg == NULL ? NULL : (type_arg = (g_object_unref (type_arg), NULL)));
				}
			}
			(type_arg_collection == NULL ? NULL : (type_arg_collection = (g_object_unref (type_arg_collection), NULL)));
			(type_arg_it == NULL ? NULL : (type_arg_it = (g_object_unref (type_arg_it), NULL)));
		}
		if (takes_ownership) {
			ValaCCodeFunctionCall* cunrefcall;
			ValaCCodeCastExpression* _tmp15;
			ValaCCodeConstant* _tmp16;
			cunrefcall = NULL;
			if (vala_data_type_get_data_type (type) == self->glist_type) {
				ValaCCodeFunctionCall* _tmp12;
				ValaCCodeIdentifier* _tmp11;
				_tmp12 = NULL;
				_tmp11 = NULL;
				cunrefcall = (_tmp12 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp11 = vala_ccode_identifier_new ("g_list_foreach")))), (cunrefcall == NULL ? NULL : (cunrefcall = (g_object_unref (cunrefcall), NULL))), _tmp12);
				(_tmp11 == NULL ? NULL : (_tmp11 = (g_object_unref (_tmp11), NULL)));
			} else {
				ValaCCodeFunctionCall* _tmp14;
				ValaCCodeIdentifier* _tmp13;
				_tmp14 = NULL;
				_tmp13 = NULL;
				cunrefcall = (_tmp14 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp13 = vala_ccode_identifier_new ("g_slist_foreach")))), (cunrefcall == NULL ? NULL : (cunrefcall = (g_object_unref (cunrefcall), NULL))), _tmp14);
				(_tmp13 == NULL ? NULL : (_tmp13 = (g_object_unref (_tmp13), NULL)));
			}
			vala_ccode_function_call_add_argument (cunrefcall, cvar);
			_tmp15 = NULL;
			vala_ccode_function_call_add_argument (cunrefcall, VALA_CCODE_EXPRESSION ((_tmp15 = vala_ccode_cast_expression_new (destroy_func_expression, "GFunc"))));
			(_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL)));
			_tmp16 = NULL;
			vala_ccode_function_call_add_argument (cunrefcall, VALA_CCODE_EXPRESSION ((_tmp16 = vala_ccode_constant_new ("NULL"))));
			(_tmp16 == NULL ? NULL : (_tmp16 = (g_object_unref (_tmp16), NULL)));
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (cunrefcall));
			(cunrefcall == NULL ? NULL : (cunrefcall = (g_object_unref (cunrefcall), NULL)));
		}
		(destroy_func_expression == NULL ? NULL : (destroy_func_expression = (g_object_unref (destroy_func_expression), NULL)));
	} else {
		if (vala_data_type_get_data_type (type) == self->gstring_type) {
			ValaCCodeConstant* _tmp17;
			_tmp17 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp17 = vala_ccode_constant_new ("TRUE"))));
			(_tmp17 == NULL ? NULL : (_tmp17 = (g_object_unref (_tmp17), NULL)));
		} else {
			if (VALA_IS_ARRAY (vala_data_type_get_data_type (type))) {
				ValaArray* _tmp18;
				ValaArray* arr;
				_tmp18 = NULL;
				arr = (_tmp18 = VALA_ARRAY (vala_data_type_get_data_type (type)), (_tmp18 == NULL ? NULL : g_object_ref (_tmp18)));
				if (vala_array_get_element_type (arr) == NULL || vala_typesymbol_is_reference_type (vala_array_get_element_type (arr))) {
					gboolean first;
					ValaCCodeExpression* csizeexpr;
					ValaCCodeIdentifier* _tmp22;
					ValaDataType* element_type;
					ValaCCodeCastExpression* _tmp24;
					ValaCCodeExpression* _tmp23;
					self->priv->requires_array_free = TRUE;
					first = TRUE;
					csizeexpr = NULL;
					{
						gint dim;
						dim = 0;
						for (dim = 1; dim <= vala_array_get_rank (arr); dim++) {
							if (first) {
								ValaCCodeExpression* _tmp19;
								_tmp19 = NULL;
								csizeexpr = (_tmp19 = vala_ccode_generator_get_array_length_cexpression (self, expr, dim), (csizeexpr == NULL ? NULL : (csizeexpr = (g_object_unref (csizeexpr), NULL))), _tmp19);
								first = FALSE;
							} else {
								ValaCCodeExpression* _tmp21;
								ValaCCodeExpression* _tmp20;
								_tmp21 = NULL;
								_tmp20 = NULL;
								csizeexpr = (_tmp21 = VALA_CCODE_EXPRESSION (vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, csizeexpr, (_tmp20 = vala_ccode_generator_get_array_length_cexpression (self, expr, dim)))), (csizeexpr == NULL ? NULL : (csizeexpr = (g_object_unref (csizeexpr), NULL))), _tmp21);
								(_tmp20 == NULL ? NULL : (_tmp20 = (g_object_unref (_tmp20), NULL)));
							}
						}
					}
					_tmp22 = NULL;
					vala_ccode_function_call_set_call (ccall, VALA_CCODE_EXPRESSION ((_tmp22 = vala_ccode_identifier_new ("_vala_array_free"))));
					(_tmp22 == NULL ? NULL : (_tmp22 = (g_object_unref (_tmp22), NULL)));
					vala_ccode_function_call_add_argument (ccall, csizeexpr);
					element_type = vala_data_type_new ();
					vala_data_type_set_data_type (element_type, vala_array_get_element_type (arr));
					vala_data_type_set_type_parameter (element_type, vala_array_get_element_type_parameter (arr));
					_tmp24 = NULL;
					_tmp23 = NULL;
					vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp24 = vala_ccode_cast_expression_new ((_tmp23 = vala_ccode_generator_get_destroy_func_expression (self, element_type)), "GDestroyNotify"))));
					(_tmp24 == NULL ? NULL : (_tmp24 = (g_object_unref (_tmp24), NULL)));
					(_tmp23 == NULL ? NULL : (_tmp23 = (g_object_unref (_tmp23), NULL)));
					(csizeexpr == NULL ? NULL : (csizeexpr = (g_object_unref (csizeexpr), NULL)));
					(element_type == NULL ? NULL : (element_type = (g_object_unref (element_type), NULL)));
				}
				(arr == NULL ? NULL : (arr = (g_object_unref (arr), NULL)));
			}
		}
	}
	vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (ccall));
	_tmp25 = NULL;
	vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp25 = vala_ccode_constant_new ("NULL"))));
	(_tmp25 == NULL ? NULL : (_tmp25 = (g_object_unref (_tmp25), NULL)));
	cassign = vala_ccode_assignment_new (cvar, VALA_CCODE_EXPRESSION (ccomma), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
	/* g_free (NULL) is allowed*/
	_tmp26 = NULL;
	if ((_tmp27 = (vala_code_context_get_non_null (self->priv->context) && !vala_data_type_get_nullable (type)) || (vala_data_type_get_data_type (type) != NULL && !vala_typesymbol_is_reference_counting (vala_data_type_get_data_type (type)) && g_utf8_collate ((_tmp26 = vala_typesymbol_get_free_function (vala_data_type_get_data_type (type))), "g_free") == 0), (_tmp26 = (g_free (_tmp26), NULL)), _tmp27)) {
		ValaCCodeParenthesizedExpression* _tmp28;
		_tmp28 = NULL;
		return VALA_CCODE_EXPRESSION ((_tmp28 = vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION (cassign)), (cisnull == NULL ? NULL : (cisnull = (g_object_unref (cisnull), NULL))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), (ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL))), (cassign == NULL ? NULL : (cassign = (g_object_unref (cassign), NULL))), _tmp28));
	}
	_tmp30 = NULL;
	_tmp29 = NULL;
	_tmp31 = NULL;
	_tmp32 = NULL;
	return VALA_CCODE_EXPRESSION ((_tmp32 = (_tmp31 = vala_ccode_conditional_expression_new (VALA_CCODE_EXPRESSION (cisnull), VALA_CCODE_EXPRESSION ((_tmp29 = vala_ccode_constant_new ("NULL"))), VALA_CCODE_EXPRESSION ((_tmp30 = vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION (cassign))))), (_tmp30 == NULL ? NULL : (_tmp30 = (g_object_unref (_tmp30), NULL))), (_tmp29 == NULL ? NULL : (_tmp29 = (g_object_unref (_tmp29), NULL))), _tmp31), (cisnull == NULL ? NULL : (cisnull = (g_object_unref (cisnull), NULL))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), (ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL))), (cassign == NULL ? NULL : (cassign = (g_object_unref (cassign), NULL))), _tmp32));
}


static void vala_ccode_generator_real_visit_end_full_expression (ValaCodeVisitor* base, ValaExpression* expr) {
	ValaCCodeGenerator * self;
	ValaVariableDeclarator* full_expr_decl;
	ValaCCodeCommaExpression* expr_list;
	ValaCCodeAssignment* _tmp1;
	ValaCCodeIdentifier* _tmp0;
	ValaCCodeIdentifier* _tmp4;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (expr == NULL || VALA_IS_EXPRESSION (expr));
	/* expr is a full expression, i.e. an initializer, the
	 * expression in an expression statement, the controlling
	 * expression in if, while, for, or foreach statements
	 *
	 * we unref temporary variables at the end of a full
	 * expression
	 
	 can't automatically deep copy lists yet, so do it
	 * manually for now
	 * replace with
	 * expr.temp_vars = temp_vars;
	 * when deep list copying works
	 */
	gee_collection_clear (GEE_COLLECTION (expr->temp_vars));
	{
		GeeArrayList* decl1_collection;
		GeeIterator* decl1_it;
		decl1_collection = self->temp_vars;
		decl1_it = gee_iterable_iterator (GEE_ITERABLE (decl1_collection));
		while (gee_iterator_next (decl1_it)) {
			ValaVariableDeclarator* decl1;
			decl1 = gee_iterator_get (decl1_it);
			{
				gee_collection_add (GEE_COLLECTION (expr->temp_vars), decl1);
				(decl1 == NULL ? NULL : (decl1 = (g_object_unref (decl1), NULL)));
			}
		}
		(decl1_it == NULL ? NULL : (decl1_it = (g_object_unref (decl1_it), NULL)));
	}
	gee_collection_clear (GEE_COLLECTION (self->temp_vars));
	if (gee_collection_get_size (GEE_COLLECTION ((GEE_LIST (self->priv->temp_ref_vars)))) == 0) {
		return;
	}
	/* nothing to do without temporary variables */
	full_expr_decl = vala_ccode_generator_get_temp_variable_declarator (self, vala_expression_get_static_type (expr), TRUE, VALA_CODE_NODE (expr));
	gee_collection_add (GEE_COLLECTION (expr->temp_vars), full_expr_decl);
	expr_list = vala_ccode_comma_expression_new ();
	_tmp1 = NULL;
	_tmp0 = NULL;
	vala_ccode_comma_expression_append_expression (expr_list, VALA_CCODE_EXPRESSION ((_tmp1 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp0 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (full_expr_decl))))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (expr))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
	(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	{
		GeeArrayList* decl_collection;
		GeeIterator* decl_it;
		decl_collection = self->priv->temp_ref_vars;
		decl_it = gee_iterable_iterator (GEE_ITERABLE (decl_collection));
		while (gee_iterator_next (decl_it)) {
			ValaVariableDeclarator* decl;
			decl = gee_iterator_get (decl_it);
			{
				ValaMemberAccess* ma;
				ValaCCodeExpression* _tmp3;
				ValaCCodeIdentifier* _tmp2;
				ma = vala_member_access_new_simple (vala_symbol_get_name (VALA_SYMBOL (decl)), NULL);
				vala_expression_set_symbol_reference (VALA_EXPRESSION (ma), VALA_SYMBOL (decl));
				_tmp3 = NULL;
				_tmp2 = NULL;
				vala_ccode_comma_expression_append_expression (expr_list, (_tmp3 = vala_ccode_generator_get_unref_expression (self, VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (decl))))), vala_variable_declarator_get_type_reference (decl), VALA_EXPRESSION (ma))));
				(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
				(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
				(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
				(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
			}
		}
		(decl_it == NULL ? NULL : (decl_it = (g_object_unref (decl_it), NULL)));
	}
	_tmp4 = NULL;
	vala_ccode_comma_expression_append_expression (expr_list, VALA_CCODE_EXPRESSION ((_tmp4 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (full_expr_decl))))));
	(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (expr_list));
	gee_collection_clear (GEE_COLLECTION (self->priv->temp_ref_vars));
	(full_expr_decl == NULL ? NULL : (full_expr_decl = (g_object_unref (full_expr_decl), NULL)));
	(expr_list == NULL ? NULL : (expr_list = (g_object_unref (expr_list), NULL)));
}


static void vala_ccode_generator_append_temp_decl (ValaCCodeGenerator* self, ValaCCodeFragment* cfrag, GeeCollection* temp_vars) {
	g_return_if_fail (VALA_IS_CCODE_GENERATOR (self));
	g_return_if_fail (cfrag == NULL || VALA_IS_CCODE_FRAGMENT (cfrag));
	g_return_if_fail (temp_vars == NULL || GEE_IS_COLLECTION (temp_vars));
	{
		GeeCollection* decl_collection;
		GeeIterator* decl_it;
		decl_collection = temp_vars;
		decl_it = gee_iterable_iterator (GEE_ITERABLE (decl_collection));
		while (gee_iterator_next (decl_it)) {
			ValaVariableDeclarator* decl;
			decl = gee_iterator_get (decl_it);
			{
				char* _tmp0;
				ValaCCodeDeclaration* _tmp1;
				ValaCCodeDeclaration* cdecl_;
				ValaCCodeVariableDeclarator* vardecl;
				_tmp0 = NULL;
				_tmp1 = NULL;
				cdecl_ = (_tmp1 = vala_ccode_declaration_new ((_tmp0 = vala_data_type_get_cname (vala_variable_declarator_get_type_reference (decl), TRUE, !vala_data_type_get_takes_ownership (vala_variable_declarator_get_type_reference (decl))))), (_tmp0 = (g_free (_tmp0), NULL)), _tmp1);
				vardecl = vala_ccode_variable_declarator_new (vala_symbol_get_name (VALA_SYMBOL (decl)));
				/* sets #line*/
				vala_code_node_set_ccodenode (VALA_CODE_NODE (decl), VALA_CCODE_NODE (vardecl));
				vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR (vardecl));
				if (vala_data_type_get_data_type (vala_variable_declarator_get_type_reference (decl)) != NULL && vala_typesymbol_is_reference_type (vala_data_type_get_data_type (vala_variable_declarator_get_type_reference (decl)))) {
					ValaCCodeConstant* _tmp2;
					_tmp2 = NULL;
					vala_ccode_variable_declarator_set_initializer (vardecl, VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_constant_new ("NULL"))));
					(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
				}
				vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE (cdecl_));
				(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
				(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
				(vardecl == NULL ? NULL : (vardecl = (g_object_unref (vardecl), NULL)));
			}
		}
		(decl_it == NULL ? NULL : (decl_it = (g_object_unref (decl_it), NULL)));
	}
}


static void vala_ccode_generator_add_simple_check (ValaCCodeGenerator* self, ValaCodeNode* node, ValaCCodeFragment* cfrag) {
	ValaCCodeFragment* cprint_frag;
	ValaCCodeIdentifier* _tmp0;
	ValaCCodeFunctionCall* _tmp1;
	ValaCCodeFunctionCall* ccritical;
	ValaCCodeConstant* _tmp2;
	ValaCCodeConstant* _tmp3;
	ValaCCodeConstant* _tmp4;
	ValaCCodeMemberAccess* _tmp6;
	ValaCCodeIdentifier* _tmp5;
	ValaCCodeExpressionStatement* _tmp7;
	ValaCCodeIdentifier* _tmp8;
	ValaCCodeFunctionCall* _tmp9;
	ValaCCodeFunctionCall* cclear;
	ValaCCodeUnaryExpression* _tmp11;
	ValaCCodeIdentifier* _tmp10;
	ValaCCodeExpressionStatement* _tmp12;
	g_return_if_fail (VALA_IS_CCODE_GENERATOR (self));
	g_return_if_fail (node == NULL || VALA_IS_CODE_NODE (node));
	g_return_if_fail (cfrag == NULL || VALA_IS_CCODE_FRAGMENT (cfrag));
	cprint_frag = vala_ccode_fragment_new ();
	_tmp0 = NULL;
	_tmp1 = NULL;
	ccritical = (_tmp1 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp0 = vala_ccode_identifier_new ("g_critical")))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1);
	_tmp2 = NULL;
	vala_ccode_function_call_add_argument (ccritical, VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_constant_new ("\"file %s: line %d: uncaught error: %s\""))));
	(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
	_tmp3 = NULL;
	vala_ccode_function_call_add_argument (ccritical, VALA_CCODE_EXPRESSION ((_tmp3 = vala_ccode_constant_new ("__FILE__"))));
	(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
	_tmp4 = NULL;
	vala_ccode_function_call_add_argument (ccritical, VALA_CCODE_EXPRESSION ((_tmp4 = vala_ccode_constant_new ("__LINE__"))));
	(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
	_tmp6 = NULL;
	_tmp5 = NULL;
	vala_ccode_function_call_add_argument (ccritical, VALA_CCODE_EXPRESSION ((_tmp6 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_identifier_new ("inner_error"))), "message"))));
	(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
	(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
	_tmp7 = NULL;
	vala_ccode_fragment_append (cprint_frag, VALA_CCODE_NODE ((_tmp7 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccritical)))));
	(_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL)));
	_tmp8 = NULL;
	_tmp9 = NULL;
	cclear = (_tmp9 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp8 = vala_ccode_identifier_new ("g_clear_error")))), (_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL))), _tmp9);
	_tmp11 = NULL;
	_tmp10 = NULL;
	vala_ccode_function_call_add_argument (cclear, VALA_CCODE_EXPRESSION ((_tmp11 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp10 = vala_ccode_identifier_new ("inner_error")))))));
	(_tmp11 == NULL ? NULL : (_tmp11 = (g_object_unref (_tmp11), NULL)));
	(_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL)));
	_tmp12 = NULL;
	vala_ccode_fragment_append (cprint_frag, VALA_CCODE_NODE ((_tmp12 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cclear)))));
	(_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL)));
	if (self->priv->current_try != NULL) {
		ValaCCodeBlock* cerror_block;
		ValaCCodeConstant* _tmp23;
		ValaCCodeIdentifier* _tmp22;
		ValaCCodeBinaryExpression* _tmp24;
		ValaCCodeBinaryExpression* ccond;
		ValaCCodeIfStatement* _tmp25;
		/* surrounding try found
		 TODO might be the wrong one when using nested try statements*/
		cerror_block = vala_ccode_block_new ();
		{
			GeeCollection* clause_collection;
			GeeIterator* clause_it;
			clause_collection = vala_try_statement_get_catch_clauses (self->priv->current_try);
			clause_it = gee_iterable_iterator (GEE_ITERABLE (clause_collection));
			while (gee_iterator_next (clause_it)) {
				ValaCatchClause* clause;
				clause = gee_iterator_get (clause_it);
				{
					char* _tmp14;
					char* _tmp13;
					ValaCCodeGotoStatement* _tmp15;
					ValaCCodeGotoStatement* cgoto_stmt;
					/* go to catch clause if error domain matches*/
					_tmp14 = NULL;
					_tmp13 = NULL;
					_tmp15 = NULL;
					cgoto_stmt = (_tmp15 = vala_ccode_goto_statement_new ((_tmp14 = g_strdup_printf ("__catch%d_%s", self->priv->current_try_id, (_tmp13 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (vala_data_type_get_data_type (vala_catch_clause_get_type_reference (clause))), NULL))))), (_tmp14 = (g_free (_tmp14), NULL)), (_tmp13 = (g_free (_tmp13), NULL)), _tmp15);
					if (vala_data_type_get_data_type (vala_catch_clause_get_type_reference (clause)) == self->gerror_type) {
						/* general catch clause*/
						vala_ccode_block_add_statement (cerror_block, VALA_CCODE_NODE (cgoto_stmt));
					} else {
						ValaCCodeIdentifier* _tmp19;
						char* _tmp18;
						ValaCCodeMemberAccess* _tmp17;
						ValaCCodeIdentifier* _tmp16;
						ValaCCodeBinaryExpression* _tmp20;
						ValaCCodeBinaryExpression* ccond;
						ValaCCodeBlock* cgoto_block;
						ValaCCodeIfStatement* _tmp21;
						_tmp19 = NULL;
						_tmp18 = NULL;
						_tmp17 = NULL;
						_tmp16 = NULL;
						_tmp20 = NULL;
						ccond = (_tmp20 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, VALA_CCODE_EXPRESSION ((_tmp17 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp16 = vala_ccode_identifier_new ("inner_error"))), "domain"))), VALA_CCODE_EXPRESSION ((_tmp19 = vala_ccode_identifier_new ((_tmp18 = vala_typesymbol_get_upper_case_cname (vala_data_type_get_data_type (vala_catch_clause_get_type_reference (clause)), NULL)))))), (_tmp19 == NULL ? NULL : (_tmp19 = (g_object_unref (_tmp19), NULL))), (_tmp18 = (g_free (_tmp18), NULL)), (_tmp17 == NULL ? NULL : (_tmp17 = (g_object_unref (_tmp17), NULL))), (_tmp16 == NULL ? NULL : (_tmp16 = (g_object_unref (_tmp16), NULL))), _tmp20);
						cgoto_block = vala_ccode_block_new ();
						vala_ccode_block_add_statement (cgoto_block, VALA_CCODE_NODE (cgoto_stmt));
						_tmp21 = NULL;
						vala_ccode_block_add_statement (cerror_block, VALA_CCODE_NODE ((_tmp21 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (ccond), VALA_CCODE_STATEMENT (cgoto_block), NULL))));
						(_tmp21 == NULL ? NULL : (_tmp21 = (g_object_unref (_tmp21), NULL)));
						(ccond == NULL ? NULL : (ccond = (g_object_unref (ccond), NULL)));
						(cgoto_block == NULL ? NULL : (cgoto_block = (g_object_unref (cgoto_block), NULL)));
					}
					(clause == NULL ? NULL : (clause = (g_object_unref (clause), NULL)));
					(cgoto_stmt == NULL ? NULL : (cgoto_stmt = (g_object_unref (cgoto_stmt), NULL)));
				}
			}
			(clause_collection == NULL ? NULL : (clause_collection = (g_object_unref (clause_collection), NULL)));
			(clause_it == NULL ? NULL : (clause_it = (g_object_unref (clause_it), NULL)));
		}
		/* print critical message if no catch clause matches*/
		vala_ccode_block_add_statement (cerror_block, VALA_CCODE_NODE (cprint_frag));
		/* check error domain if expression failed*/
		_tmp23 = NULL;
		_tmp22 = NULL;
		_tmp24 = NULL;
		ccond = (_tmp24 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, VALA_CCODE_EXPRESSION ((_tmp22 = vala_ccode_identifier_new ("inner_error"))), VALA_CCODE_EXPRESSION ((_tmp23 = vala_ccode_constant_new ("NULL")))), (_tmp23 == NULL ? NULL : (_tmp23 = (g_object_unref (_tmp23), NULL))), (_tmp22 == NULL ? NULL : (_tmp22 = (g_object_unref (_tmp22), NULL))), _tmp24);
		_tmp25 = NULL;
		vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((_tmp25 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (ccond), VALA_CCODE_STATEMENT (cerror_block), NULL))));
		(_tmp25 == NULL ? NULL : (_tmp25 = (g_object_unref (_tmp25), NULL)));
		(cerror_block == NULL ? NULL : (cerror_block = (g_object_unref (cerror_block), NULL)));
		(ccond == NULL ? NULL : (ccond = (g_object_unref (ccond), NULL)));
	} else {
		GeeCollection* _tmp26;
		gboolean _tmp27;
		_tmp26 = NULL;
		if ((_tmp27 = self->priv->current_method != NULL && gee_collection_get_size ((_tmp26 = vala_method_get_error_domains (self->priv->current_method))) > 0, (_tmp26 == NULL ? NULL : (_tmp26 = (g_object_unref (_tmp26), NULL))), _tmp27)) {
			ValaCCodeIdentifier* _tmp28;
			ValaCCodeFunctionCall* _tmp29;
			ValaCCodeFunctionCall* cpropagate;
			ValaCCodeIdentifier* _tmp30;
			ValaCCodeIdentifier* _tmp31;
			ValaCCodeBlock* cerror_block;
			ValaCCodeExpressionStatement* _tmp32;
			ValaCCodeConstant* _tmp37;
			ValaCCodeIdentifier* _tmp36;
			ValaCCodeBinaryExpression* _tmp38;
			ValaCCodeBinaryExpression* ccond;
			ValaCCodeIfStatement* _tmp39;
			/* current method can fail, propagate error
			 TODO ensure one of the error domains matches*/
			_tmp28 = NULL;
			_tmp29 = NULL;
			cpropagate = (_tmp29 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp28 = vala_ccode_identifier_new ("g_propagate_error")))), (_tmp28 == NULL ? NULL : (_tmp28 = (g_object_unref (_tmp28), NULL))), _tmp29);
			_tmp30 = NULL;
			vala_ccode_function_call_add_argument (cpropagate, VALA_CCODE_EXPRESSION ((_tmp30 = vala_ccode_identifier_new ("error"))));
			(_tmp30 == NULL ? NULL : (_tmp30 = (g_object_unref (_tmp30), NULL)));
			_tmp31 = NULL;
			vala_ccode_function_call_add_argument (cpropagate, VALA_CCODE_EXPRESSION ((_tmp31 = vala_ccode_identifier_new ("inner_error"))));
			(_tmp31 == NULL ? NULL : (_tmp31 = (g_object_unref (_tmp31), NULL)));
			cerror_block = vala_ccode_block_new ();
			_tmp32 = NULL;
			vala_ccode_block_add_statement (cerror_block, VALA_CCODE_NODE ((_tmp32 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cpropagate)))));
			(_tmp32 == NULL ? NULL : (_tmp32 = (g_object_unref (_tmp32), NULL)));
			if (self->priv->current_return_type != NULL && vala_data_type_get_data_type (self->priv->current_return_type) != NULL) {
				ValaCCodeReturnStatement* _tmp34;
				ValaCCodeExpression* _tmp33;
				_tmp34 = NULL;
				_tmp33 = NULL;
				vala_ccode_block_add_statement (cerror_block, VALA_CCODE_NODE ((_tmp34 = vala_ccode_return_statement_new ((_tmp33 = vala_ccode_generator_default_value_for_type (self, self->priv->current_return_type))))));
				(_tmp34 == NULL ? NULL : (_tmp34 = (g_object_unref (_tmp34), NULL)));
				(_tmp33 == NULL ? NULL : (_tmp33 = (g_object_unref (_tmp33), NULL)));
			} else {
				ValaCCodeReturnStatement* _tmp35;
				_tmp35 = NULL;
				vala_ccode_block_add_statement (cerror_block, VALA_CCODE_NODE ((_tmp35 = vala_ccode_return_statement_new (NULL))));
				(_tmp35 == NULL ? NULL : (_tmp35 = (g_object_unref (_tmp35), NULL)));
			}
			_tmp37 = NULL;
			_tmp36 = NULL;
			_tmp38 = NULL;
			ccond = (_tmp38 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, VALA_CCODE_EXPRESSION ((_tmp36 = vala_ccode_identifier_new ("inner_error"))), VALA_CCODE_EXPRESSION ((_tmp37 = vala_ccode_constant_new ("NULL")))), (_tmp37 == NULL ? NULL : (_tmp37 = (g_object_unref (_tmp37), NULL))), (_tmp36 == NULL ? NULL : (_tmp36 = (g_object_unref (_tmp36), NULL))), _tmp38);
			_tmp39 = NULL;
			vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((_tmp39 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (ccond), VALA_CCODE_STATEMENT (cerror_block), NULL))));
			(_tmp39 == NULL ? NULL : (_tmp39 = (g_object_unref (_tmp39), NULL)));
			(cpropagate == NULL ? NULL : (cpropagate = (g_object_unref (cpropagate), NULL)));
			(cerror_block == NULL ? NULL : (cerror_block = (g_object_unref (cerror_block), NULL)));
			(ccond == NULL ? NULL : (ccond = (g_object_unref (ccond), NULL)));
		} else {
			ValaCCodeBlock* cerror_block;
			ValaCCodeConstant* _tmp41;
			ValaCCodeIdentifier* _tmp40;
			ValaCCodeBinaryExpression* _tmp42;
			ValaCCodeBinaryExpression* ccond;
			ValaCCodeIfStatement* _tmp43;
			/* TODO improve check and move to semantic analyzer*/
			vala_report_warning (vala_code_node_get_source_reference (node), "unhandled error");
			cerror_block = vala_ccode_block_new ();
			/* print critical message*/
			vala_ccode_block_add_statement (cerror_block, VALA_CCODE_NODE (cprint_frag));
			/* check error domain if expression failed*/
			_tmp41 = NULL;
			_tmp40 = NULL;
			_tmp42 = NULL;
			ccond = (_tmp42 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, VALA_CCODE_EXPRESSION ((_tmp40 = vala_ccode_identifier_new ("inner_error"))), VALA_CCODE_EXPRESSION ((_tmp41 = vala_ccode_constant_new ("NULL")))), (_tmp41 == NULL ? NULL : (_tmp41 = (g_object_unref (_tmp41), NULL))), (_tmp40 == NULL ? NULL : (_tmp40 = (g_object_unref (_tmp40), NULL))), _tmp42);
			_tmp43 = NULL;
			vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((_tmp43 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (ccond), VALA_CCODE_STATEMENT (cerror_block), NULL))));
			(_tmp43 == NULL ? NULL : (_tmp43 = (g_object_unref (_tmp43), NULL)));
			(cerror_block == NULL ? NULL : (cerror_block = (g_object_unref (cerror_block), NULL)));
			(ccond == NULL ? NULL : (ccond = (g_object_unref (ccond), NULL)));
		}
	}
	(cprint_frag == NULL ? NULL : (cprint_frag = (g_object_unref (cprint_frag), NULL)));
	(ccritical == NULL ? NULL : (ccritical = (g_object_unref (ccritical), NULL)));
	(cclear == NULL ? NULL : (cclear = (g_object_unref (cclear), NULL)));
}


static void vala_ccode_generator_real_visit_expression_statement (ValaCodeVisitor* base, ValaExpressionStatement* stmt) {
	ValaCCodeGenerator * self;
	ValaCCodeExpressionStatement* _tmp0;
	ValaCCodeFragment* cfrag;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (stmt == NULL || VALA_IS_EXPRESSION_STATEMENT (stmt));
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((_tmp0 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_expression_statement_get_expression (stmt))))))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	if (vala_code_node_get_tree_can_fail (VALA_CODE_NODE (stmt)) && vala_expression_get_can_fail (vala_expression_statement_get_expression (stmt))) {
		ValaCCodeFragment* cfrag;
		/* simple case, no node breakdown necessary*/
		cfrag = vala_ccode_fragment_new ();
		vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
		vala_ccode_generator_add_simple_check (self, VALA_CODE_NODE (vala_expression_statement_get_expression (stmt)), cfrag);
		vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE (cfrag));
		(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
	}
	/* free temporary objects */
	if (gee_collection_get_size (GEE_COLLECTION ((GEE_LIST (self->temp_vars)))) == 0) {
		return;
	}
	/* nothing to do without temporary variables */
	cfrag = vala_ccode_fragment_new ();
	vala_ccode_generator_append_temp_decl (self, cfrag, GEE_COLLECTION (self->temp_vars));
	vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
	{
		GeeArrayList* decl_collection;
		GeeIterator* decl_it;
		decl_collection = self->priv->temp_ref_vars;
		decl_it = gee_iterable_iterator (GEE_ITERABLE (decl_collection));
		while (gee_iterator_next (decl_it)) {
			ValaVariableDeclarator* decl;
			decl = gee_iterator_get (decl_it);
			{
				ValaMemberAccess* ma;
				ValaCCodeExpressionStatement* _tmp3;
				ValaCCodeExpression* _tmp2;
				ValaCCodeIdentifier* _tmp1;
				ma = vala_member_access_new_simple (vala_symbol_get_name (VALA_SYMBOL (decl)), NULL);
				vala_expression_set_symbol_reference (VALA_EXPRESSION (ma), VALA_SYMBOL (decl));
				_tmp3 = NULL;
				_tmp2 = NULL;
				_tmp1 = NULL;
				vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((_tmp3 = vala_ccode_expression_statement_new ((_tmp2 = vala_ccode_generator_get_unref_expression (self, VALA_CCODE_EXPRESSION ((_tmp1 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (decl))))), vala_variable_declarator_get_type_reference (decl), VALA_EXPRESSION (ma)))))));
				(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
				(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
				(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
				(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
				(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
			}
		}
		(decl_it == NULL ? NULL : (decl_it = (g_object_unref (decl_it), NULL)));
	}
	vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE (cfrag));
	gee_collection_clear (GEE_COLLECTION (self->temp_vars));
	gee_collection_clear (GEE_COLLECTION (self->priv->temp_ref_vars));
	(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
}


static void vala_ccode_generator_create_temp_decl (ValaCCodeGenerator* self, ValaStatement* stmt, GeeCollection* temp_vars) {
	ValaCCodeFragment* cfrag;
	g_return_if_fail (VALA_IS_CCODE_GENERATOR (self));
	g_return_if_fail (stmt == NULL || VALA_IS_STATEMENT (stmt));
	g_return_if_fail (temp_vars == NULL || GEE_IS_COLLECTION (temp_vars));
	/* declare temporary variables */
	if (gee_collection_get_size (temp_vars) == 0) {
		return;
	}
	/* nothing to do without temporary variables */
	cfrag = vala_ccode_fragment_new ();
	vala_ccode_generator_append_temp_decl (self, cfrag, temp_vars);
	/* FIXME cast to CodeNode shouldn't be necessary as Statement requires CodeNode*/
	vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode ((VALA_CODE_NODE (stmt))));
	vala_code_node_set_ccodenode ((VALA_CODE_NODE (stmt)), VALA_CCODE_NODE (cfrag));
	(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
}


static void vala_ccode_generator_real_visit_if_statement (ValaCodeVisitor* base, ValaIfStatement* stmt) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (stmt == NULL || VALA_IS_IF_STATEMENT (stmt));
	if (vala_if_statement_get_false_statement (stmt) != NULL) {
		ValaCCodeIfStatement* _tmp0;
		_tmp0 = NULL;
		vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((_tmp0 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_if_statement_get_condition (stmt)))), VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_if_statement_get_true_statement (stmt)))), VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_if_statement_get_false_statement (stmt))))))));
		(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	} else {
		ValaCCodeIfStatement* _tmp1;
		_tmp1 = NULL;
		vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((_tmp1 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_if_statement_get_condition (stmt)))), VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_if_statement_get_true_statement (stmt)))), NULL))));
		(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
	}
	vala_ccode_generator_create_temp_decl (self, VALA_STATEMENT (stmt), GEE_COLLECTION (vala_if_statement_get_condition (stmt)->temp_vars));
}


static void vala_ccode_generator_real_visit_switch_statement (ValaCodeVisitor* base, ValaSwitchStatement* stmt) {
	ValaCCodeGenerator * self;
	ValaVariableDeclarator* temp_decl;
	ValaCCodeIdentifier* ctemp;
	ValaCCodeAssignment* cinit;
	ValaCCodeConstant* czero;
	ValaCCodeFragment* cswitchblock;
	gboolean is_string_cmp;
	ValaCCodeExpressionStatement* _tmp14;
	GeeCollection* default_statements;
	gint label_count;
	ValaCCodeStatement* ctopstmt;
	ValaCCodeIfStatement* coldif;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (stmt == NULL || VALA_IS_SWITCH_STATEMENT (stmt));
	/* we need a temporary variable to save the property value*/
	temp_decl = vala_ccode_generator_get_temp_variable_declarator (self, vala_expression_get_static_type (vala_switch_statement_get_expression (stmt)), TRUE, VALA_CODE_NODE (stmt));
	gee_list_insert (GEE_LIST (vala_switch_statement_get_expression (stmt)->temp_vars), 0, temp_decl);
	ctemp = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_decl)));
	cinit = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (ctemp), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_switch_statement_get_expression (stmt)))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
	czero = vala_ccode_constant_new ("0");
	cswitchblock = vala_ccode_fragment_new ();
	vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE (cswitchblock));
	is_string_cmp = vala_typesymbol_is_subtype_of (vala_data_type_get_data_type (vala_variable_declarator_get_type_reference (temp_decl)), vala_data_type_get_data_type (self->string_type));
	if (is_string_cmp) {
		ValaCCodeConstant* _tmp0;
		ValaCCodeBinaryExpression* _tmp1;
		ValaCCodeBinaryExpression* cisnull;
		ValaCCodeIdentifier* _tmp2;
		ValaCCodeFunctionCall* _tmp3;
		ValaCCodeFunctionCall* cquark;
		ValaCCodeConstant* _tmp4;
		ValaCCodeConditionalExpression* _tmp5;
		ValaCCodeConditionalExpression* ccond;
		ValaVariableDeclarator* _tmp6;
		gint label_count;
		ValaCCodeExpressionStatement* _tmp11;
		ValaCCodeIdentifier* _tmp12;
		ValaCCodeAssignment* _tmp13;
		_tmp0 = NULL;
		_tmp1 = NULL;
		cisnull = (_tmp1 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, VALA_CCODE_EXPRESSION ((_tmp0 = vala_ccode_constant_new ("NULL"))), VALA_CCODE_EXPRESSION (ctemp)), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1);
		_tmp2 = NULL;
		_tmp3 = NULL;
		cquark = (_tmp3 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_identifier_new ("g_quark_from_string")))), (_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL))), _tmp3);
		vala_ccode_function_call_add_argument (cquark, VALA_CCODE_EXPRESSION (ctemp));
		_tmp4 = NULL;
		_tmp5 = NULL;
		ccond = (_tmp5 = vala_ccode_conditional_expression_new (VALA_CCODE_EXPRESSION (cisnull), VALA_CCODE_EXPRESSION ((_tmp4 = vala_ccode_constant_new ("0"))), VALA_CCODE_EXPRESSION (cquark)), (_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL))), _tmp5);
		_tmp6 = NULL;
		temp_decl = (_tmp6 = vala_ccode_generator_get_temp_variable_declarator (self, self->gquark_type, TRUE, NULL), (temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL))), _tmp6);
		gee_list_insert (GEE_LIST (vala_switch_statement_get_expression (stmt)->temp_vars), 0, temp_decl);
		label_count = 0;
		{
			GeeCollection* section_collection;
			GeeIterator* section_it;
			section_collection = vala_switch_statement_get_sections (stmt);
			section_it = gee_iterable_iterator (GEE_ITERABLE (section_collection));
			while (gee_iterator_next (section_it)) {
				ValaSwitchSection* section;
				section = gee_iterator_get (section_it);
				{
					if (vala_switch_section_has_default_label (section)) {
						(section == NULL ? NULL : (section = (g_object_unref (section), NULL)));
						continue;
					}
					{
						GeeCollection* label_collection;
						GeeIterator* label_it;
						label_collection = vala_switch_section_get_labels (section);
						label_it = gee_iterable_iterator (GEE_ITERABLE (label_collection));
						while (gee_iterator_next (label_it)) {
							ValaSwitchLabel* label;
							label = gee_iterator_get (label_it);
							{
								ValaCCodeExpression* _tmp7;
								ValaCCodeExpression* cexpr;
								_tmp7 = NULL;
								cexpr = (_tmp7 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_switch_label_get_expression (label)))), (_tmp7 == NULL ? NULL : g_object_ref (_tmp7)));
								if (vala_ccode_generator_is_constant_ccode_expression (self, cexpr)) {
									char* cname;
									char* _tmp8;
									ValaCCodeDeclaration* _tmp9;
									ValaCCodeDeclaration* cdecl_;
									ValaCCodeVariableDeclarator* _tmp10;
									cname = g_strdup_printf ("%s_label%d", vala_symbol_get_name (VALA_SYMBOL (temp_decl)), label_count++);
									_tmp8 = NULL;
									_tmp9 = NULL;
									cdecl_ = (_tmp9 = vala_ccode_declaration_new ((_tmp8 = vala_data_type_get_cname (self->gquark_type, FALSE, FALSE))), (_tmp8 = (g_free (_tmp8), NULL)), _tmp9);
									vala_ccode_declaration_set_modifiers (cdecl_, VALA_CCODE_MODIFIERS_STATIC);
									_tmp10 = NULL;
									vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp10 = vala_ccode_variable_declarator_new_with_initializer (cname, VALA_CCODE_EXPRESSION (czero)))));
									(_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL)));
									vala_ccode_fragment_append (cswitchblock, VALA_CCODE_NODE (cdecl_));
									(cname = (g_free (cname), NULL));
									(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
								}
								(label == NULL ? NULL : (label = (g_object_unref (label), NULL)));
								(cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL)));
							}
						}
						(label_collection == NULL ? NULL : (label_collection = (g_object_unref (label_collection), NULL)));
						(label_it == NULL ? NULL : (label_it = (g_object_unref (label_it), NULL)));
					}
					(section == NULL ? NULL : (section = (g_object_unref (section), NULL)));
				}
			}
			(section_collection == NULL ? NULL : (section_collection = (g_object_unref (section_collection), NULL)));
			(section_it == NULL ? NULL : (section_it = (g_object_unref (section_it), NULL)));
		}
		_tmp11 = NULL;
		vala_ccode_fragment_append (cswitchblock, VALA_CCODE_NODE ((_tmp11 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cinit)))));
		(_tmp11 == NULL ? NULL : (_tmp11 = (g_object_unref (_tmp11), NULL)));
		_tmp12 = NULL;
		ctemp = (_tmp12 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_decl))), (ctemp == NULL ? NULL : (ctemp = (g_object_unref (ctemp), NULL))), _tmp12);
		_tmp13 = NULL;
		cinit = (_tmp13 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (ctemp), VALA_CCODE_EXPRESSION (ccond), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (cinit == NULL ? NULL : (cinit = (g_object_unref (cinit), NULL))), _tmp13);
		(cisnull == NULL ? NULL : (cisnull = (g_object_unref (cisnull), NULL)));
		(cquark == NULL ? NULL : (cquark = (g_object_unref (cquark), NULL)));
		(ccond == NULL ? NULL : (ccond = (g_object_unref (ccond), NULL)));
	}
	_tmp14 = NULL;
	vala_ccode_fragment_append (cswitchblock, VALA_CCODE_NODE ((_tmp14 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cinit)))));
	(_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL)));
	vala_ccode_generator_create_temp_decl (self, VALA_STATEMENT (stmt), GEE_COLLECTION (vala_switch_statement_get_expression (stmt)->temp_vars));
	default_statements = NULL;
	label_count = 0;
	/* generate nested if statements*/
	ctopstmt = NULL;
	coldif = NULL;
	{
		GeeCollection* section_collection;
		GeeIterator* section_it;
		section_collection = vala_switch_statement_get_sections (stmt);
		section_it = gee_iterable_iterator (GEE_ITERABLE (section_collection));
		while (gee_iterator_next (section_it)) {
			ValaSwitchSection* section;
			section = gee_iterator_get (section_it);
			{
				ValaCCodeBinaryExpression* cor;
				ValaCCodeBlock* cblock;
				ValaCCodeConstant* _tmp31;
				ValaCCodeDoStatement* _tmp32;
				ValaCCodeDoStatement* cdo;
				ValaCCodeIfStatement* cif;
				ValaCCodeIfStatement* _tmp36;
				ValaCCodeIfStatement* _tmp35;
				if (vala_switch_section_has_default_label (section)) {
					GeeCollection* _tmp15;
					_tmp15 = NULL;
					default_statements = (_tmp15 = vala_switch_section_get_statements (section), (default_statements == NULL ? NULL : (default_statements = (g_object_unref (default_statements), NULL))), _tmp15);
					(section == NULL ? NULL : (section = (g_object_unref (section), NULL)));
					continue;
				}
				cor = NULL;
				{
					GeeCollection* label_collection;
					GeeIterator* label_it;
					label_collection = vala_switch_section_get_labels (section);
					label_it = gee_iterable_iterator (GEE_ITERABLE (label_collection));
					while (gee_iterator_next (label_it)) {
						ValaSwitchLabel* label;
						label = gee_iterator_get (label_it);
						{
							ValaCCodeExpression* _tmp16;
							ValaCCodeExpression* cexpr;
							ValaCCodeBinaryExpression* ccmp;
							_tmp16 = NULL;
							cexpr = (_tmp16 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_switch_label_get_expression (label)))), (_tmp16 == NULL ? NULL : g_object_ref (_tmp16)));
							if (is_string_cmp) {
								if (vala_ccode_generator_is_constant_ccode_expression (self, cexpr)) {
									char* _tmp17;
									ValaCCodeIdentifier* _tmp18;
									ValaCCodeIdentifier* cname;
									ValaCCodeBinaryExpression* ccond;
									ValaCCodeIdentifier* _tmp19;
									ValaCCodeFunctionCall* _tmp20;
									ValaCCodeFunctionCall* ccall;
									ValaCCodeAssignment* _tmp21;
									ValaCCodeParenthesizedExpression* _tmp22;
									ValaCCodeParenthesizedExpression* cinit;
									ValaCCodeExpression* _tmp23;
									_tmp17 = NULL;
									_tmp18 = NULL;
									cname = (_tmp18 = vala_ccode_identifier_new ((_tmp17 = g_strdup_printf ("%s_label%d", vala_symbol_get_name (VALA_SYMBOL (temp_decl)), label_count++))), (_tmp17 = (g_free (_tmp17), NULL)), _tmp18);
									ccond = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, VALA_CCODE_EXPRESSION (czero), VALA_CCODE_EXPRESSION (cname));
									_tmp19 = NULL;
									_tmp20 = NULL;
									ccall = (_tmp20 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp19 = vala_ccode_identifier_new ("g_quark_from_static_string")))), (_tmp19 == NULL ? NULL : (_tmp19 = (g_object_unref (_tmp19), NULL))), _tmp20);
									_tmp21 = NULL;
									_tmp22 = NULL;
									cinit = (_tmp22 = vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION ((_tmp21 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (cname), VALA_CCODE_EXPRESSION (ccall), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))), (_tmp21 == NULL ? NULL : (_tmp21 = (g_object_unref (_tmp21), NULL))), _tmp22);
									vala_ccode_function_call_add_argument (ccall, cexpr);
									_tmp23 = NULL;
									cexpr = (_tmp23 = VALA_CCODE_EXPRESSION (vala_ccode_conditional_expression_new (VALA_CCODE_EXPRESSION (ccond), VALA_CCODE_EXPRESSION (cname), VALA_CCODE_EXPRESSION (cinit))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), _tmp23);
									(cname == NULL ? NULL : (cname = (g_object_unref (cname), NULL)));
									(ccond == NULL ? NULL : (ccond = (g_object_unref (ccond), NULL)));
									(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
									(cinit == NULL ? NULL : (cinit = (g_object_unref (cinit), NULL)));
								} else {
									ValaCCodeIdentifier* _tmp24;
									ValaCCodeFunctionCall* _tmp25;
									ValaCCodeFunctionCall* ccall;
									ValaCCodeExpression* _tmp27;
									ValaCCodeFunctionCall* _tmp26;
									_tmp24 = NULL;
									_tmp25 = NULL;
									ccall = (_tmp25 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp24 = vala_ccode_identifier_new ("g_quark_from_string")))), (_tmp24 == NULL ? NULL : (_tmp24 = (g_object_unref (_tmp24), NULL))), _tmp25);
									vala_ccode_function_call_add_argument (ccall, cexpr);
									_tmp27 = NULL;
									_tmp26 = NULL;
									cexpr = (_tmp27 = VALA_CCODE_EXPRESSION ((_tmp26 = ccall, (_tmp26 == NULL ? NULL : g_object_ref (_tmp26)))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), _tmp27);
									(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
								}
							}
							ccmp = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, VALA_CCODE_EXPRESSION (ctemp), cexpr);
							if (cor == NULL) {
								ValaCCodeBinaryExpression* _tmp29;
								ValaCCodeBinaryExpression* _tmp28;
								_tmp29 = NULL;
								_tmp28 = NULL;
								cor = (_tmp29 = (_tmp28 = ccmp, (_tmp28 == NULL ? NULL : g_object_ref (_tmp28))), (cor == NULL ? NULL : (cor = (g_object_unref (cor), NULL))), _tmp29);
							} else {
								ValaCCodeBinaryExpression* _tmp30;
								_tmp30 = NULL;
								cor = (_tmp30 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_OR, VALA_CCODE_EXPRESSION (cor), VALA_CCODE_EXPRESSION (ccmp)), (cor == NULL ? NULL : (cor = (g_object_unref (cor), NULL))), _tmp30);
							}
							(label == NULL ? NULL : (label = (g_object_unref (label), NULL)));
							(cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL)));
							(ccmp == NULL ? NULL : (ccmp = (g_object_unref (ccmp), NULL)));
						}
					}
					(label_collection == NULL ? NULL : (label_collection = (g_object_unref (label_collection), NULL)));
					(label_it == NULL ? NULL : (label_it = (g_object_unref (label_it), NULL)));
				}
				cblock = vala_ccode_block_new ();
				{
					GeeCollection* body_stmt_collection;
					GeeIterator* body_stmt_it;
					body_stmt_collection = vala_switch_section_get_statements (section);
					body_stmt_it = gee_iterable_iterator (GEE_ITERABLE (body_stmt_collection));
					while (gee_iterator_next (body_stmt_it)) {
						ValaCodeNode* body_stmt;
						body_stmt = gee_iterator_get (body_stmt_it);
						{
							if (VALA_IS_CCODE_FRAGMENT (vala_code_node_get_ccodenode (body_stmt))) {
								{
									GeeCollection* cstmt_collection;
									GeeIterator* cstmt_it;
									cstmt_collection = vala_ccode_fragment_get_children ((VALA_CCODE_FRAGMENT (vala_code_node_get_ccodenode (body_stmt))));
									cstmt_it = gee_iterable_iterator (GEE_ITERABLE (cstmt_collection));
									while (gee_iterator_next (cstmt_it)) {
										ValaCCodeStatement* cstmt;
										cstmt = gee_iterator_get (cstmt_it);
										{
											vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cstmt));
											(cstmt == NULL ? NULL : (cstmt = (g_object_unref (cstmt), NULL)));
										}
									}
									(cstmt_collection == NULL ? NULL : (cstmt_collection = (g_object_unref (cstmt_collection), NULL)));
									(cstmt_it == NULL ? NULL : (cstmt_it = (g_object_unref (cstmt_it), NULL)));
								}
							} else {
								vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode (body_stmt))));
							}
							(body_stmt == NULL ? NULL : (body_stmt = (g_object_unref (body_stmt), NULL)));
						}
					}
					(body_stmt_collection == NULL ? NULL : (body_stmt_collection = (g_object_unref (body_stmt_collection), NULL)));
					(body_stmt_it == NULL ? NULL : (body_stmt_it = (g_object_unref (body_stmt_it), NULL)));
				}
				_tmp31 = NULL;
				_tmp32 = NULL;
				cdo = (_tmp32 = vala_ccode_do_statement_new (VALA_CCODE_STATEMENT (cblock), VALA_CCODE_EXPRESSION ((_tmp31 = vala_ccode_constant_new ("0")))), (_tmp31 == NULL ? NULL : (_tmp31 = (g_object_unref (_tmp31), NULL))), _tmp32);
				cif = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (cor), VALA_CCODE_STATEMENT (cdo), NULL);
				if (coldif != NULL) {
					vala_ccode_if_statement_set_false_statement (coldif, VALA_CCODE_STATEMENT (cif));
				} else {
					ValaCCodeStatement* _tmp34;
					ValaCCodeIfStatement* _tmp33;
					_tmp34 = NULL;
					_tmp33 = NULL;
					ctopstmt = (_tmp34 = VALA_CCODE_STATEMENT ((_tmp33 = cif, (_tmp33 == NULL ? NULL : g_object_ref (_tmp33)))), (ctopstmt == NULL ? NULL : (ctopstmt = (g_object_unref (ctopstmt), NULL))), _tmp34);
				}
				_tmp36 = NULL;
				_tmp35 = NULL;
				coldif = (_tmp36 = (_tmp35 = cif, (_tmp35 == NULL ? NULL : g_object_ref (_tmp35))), (coldif == NULL ? NULL : (coldif = (g_object_unref (coldif), NULL))), _tmp36);
				(section == NULL ? NULL : (section = (g_object_unref (section), NULL)));
				(cor == NULL ? NULL : (cor = (g_object_unref (cor), NULL)));
				(cblock == NULL ? NULL : (cblock = (g_object_unref (cblock), NULL)));
				(cdo == NULL ? NULL : (cdo = (g_object_unref (cdo), NULL)));
				(cif == NULL ? NULL : (cif = (g_object_unref (cif), NULL)));
			}
		}
		(section_collection == NULL ? NULL : (section_collection = (g_object_unref (section_collection), NULL)));
		(section_it == NULL ? NULL : (section_it = (g_object_unref (section_it), NULL)));
	}
	if (default_statements != NULL) {
		ValaCCodeBlock* cblock;
		ValaCCodeConstant* _tmp37;
		ValaCCodeDoStatement* _tmp38;
		ValaCCodeDoStatement* cdo;
		cblock = vala_ccode_block_new ();
		{
			GeeCollection* body_stmt_collection;
			GeeIterator* body_stmt_it;
			body_stmt_collection = default_statements;
			body_stmt_it = gee_iterable_iterator (GEE_ITERABLE (body_stmt_collection));
			while (gee_iterator_next (body_stmt_it)) {
				ValaCodeNode* body_stmt;
				body_stmt = gee_iterator_get (body_stmt_it);
				{
					vala_ccode_block_add_statement (cblock, vala_code_node_get_ccodenode (body_stmt));
					(body_stmt == NULL ? NULL : (body_stmt = (g_object_unref (body_stmt), NULL)));
				}
			}
			(body_stmt_it == NULL ? NULL : (body_stmt_it = (g_object_unref (body_stmt_it), NULL)));
		}
		_tmp37 = NULL;
		_tmp38 = NULL;
		cdo = (_tmp38 = vala_ccode_do_statement_new (VALA_CCODE_STATEMENT (cblock), VALA_CCODE_EXPRESSION ((_tmp37 = vala_ccode_constant_new ("0")))), (_tmp37 == NULL ? NULL : (_tmp37 = (g_object_unref (_tmp37), NULL))), _tmp38);
		if (coldif == NULL) {
			ValaCCodeStatement* _tmp40;
			ValaCCodeDoStatement* _tmp39;
			/* there is only one section and that section
			 contains a default label*/
			_tmp40 = NULL;
			_tmp39 = NULL;
			ctopstmt = (_tmp40 = VALA_CCODE_STATEMENT ((_tmp39 = cdo, (_tmp39 == NULL ? NULL : g_object_ref (_tmp39)))), (ctopstmt == NULL ? NULL : (ctopstmt = (g_object_unref (ctopstmt), NULL))), _tmp40);
		} else {
			vala_ccode_if_statement_set_false_statement (coldif, VALA_CCODE_STATEMENT (cdo));
		}
		(cblock == NULL ? NULL : (cblock = (g_object_unref (cblock), NULL)));
		(cdo == NULL ? NULL : (cdo = (g_object_unref (cdo), NULL)));
	}
	vala_ccode_fragment_append (cswitchblock, VALA_CCODE_NODE (ctopstmt));
	(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
	(ctemp == NULL ? NULL : (ctemp = (g_object_unref (ctemp), NULL)));
	(cinit == NULL ? NULL : (cinit = (g_object_unref (cinit), NULL)));
	(czero == NULL ? NULL : (czero = (g_object_unref (czero), NULL)));
	(cswitchblock == NULL ? NULL : (cswitchblock = (g_object_unref (cswitchblock), NULL)));
	(default_statements == NULL ? NULL : (default_statements = (g_object_unref (default_statements), NULL)));
	(ctopstmt == NULL ? NULL : (ctopstmt = (g_object_unref (ctopstmt), NULL)));
	(coldif == NULL ? NULL : (coldif = (g_object_unref (coldif), NULL)));
}


static void vala_ccode_generator_real_visit_switch_section (ValaCodeVisitor* base, ValaSwitchSection* section) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (section == NULL || VALA_IS_SWITCH_SECTION (section));
	vala_code_visitor_visit_block (VALA_CODE_VISITOR (self), VALA_BLOCK (section));
}


static void vala_ccode_generator_real_visit_while_statement (ValaCodeVisitor* base, ValaWhileStatement* stmt) {
	ValaCCodeGenerator * self;
	ValaCCodeWhileStatement* _tmp0;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (stmt == NULL || VALA_IS_WHILE_STATEMENT (stmt));
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((_tmp0 = vala_ccode_while_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_while_statement_get_condition (stmt)))), VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_while_statement_get_body (stmt))))))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	vala_ccode_generator_create_temp_decl (self, VALA_STATEMENT (stmt), GEE_COLLECTION (vala_while_statement_get_condition (stmt)->temp_vars));
}


static void vala_ccode_generator_real_visit_do_statement (ValaCodeVisitor* base, ValaDoStatement* stmt) {
	ValaCCodeGenerator * self;
	ValaCCodeDoStatement* _tmp0;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (stmt == NULL || VALA_IS_DO_STATEMENT (stmt));
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((_tmp0 = vala_ccode_do_statement_new (VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_do_statement_get_body (stmt)))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_do_statement_get_condition (stmt))))))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	vala_ccode_generator_create_temp_decl (self, VALA_STATEMENT (stmt), GEE_COLLECTION (vala_do_statement_get_condition (stmt)->temp_vars));
}


static void vala_ccode_generator_real_visit_for_statement (ValaCodeVisitor* base, ValaForStatement* stmt) {
	ValaCCodeGenerator * self;
	ValaCCodeForStatement* cfor;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (stmt == NULL || VALA_IS_FOR_STATEMENT (stmt));
	cfor = vala_ccode_for_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_for_statement_get_condition (stmt)))), VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_for_statement_get_body (stmt)))));
	vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE (cfor));
	{
		GeeCollection* init_expr_collection;
		GeeIterator* init_expr_it;
		init_expr_collection = vala_for_statement_get_initializer (stmt);
		init_expr_it = gee_iterable_iterator (GEE_ITERABLE (init_expr_collection));
		while (gee_iterator_next (init_expr_it)) {
			ValaExpression* init_expr;
			init_expr = gee_iterator_get (init_expr_it);
			{
				vala_ccode_for_statement_add_initializer (cfor, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (init_expr))));
				vala_ccode_generator_create_temp_decl (self, VALA_STATEMENT (stmt), GEE_COLLECTION (init_expr->temp_vars));
				(init_expr == NULL ? NULL : (init_expr = (g_object_unref (init_expr), NULL)));
			}
		}
		(init_expr_collection == NULL ? NULL : (init_expr_collection = (g_object_unref (init_expr_collection), NULL)));
		(init_expr_it == NULL ? NULL : (init_expr_it = (g_object_unref (init_expr_it), NULL)));
	}
	{
		GeeCollection* it_expr_collection;
		GeeIterator* it_expr_it;
		it_expr_collection = vala_for_statement_get_iterator (stmt);
		it_expr_it = gee_iterable_iterator (GEE_ITERABLE (it_expr_collection));
		while (gee_iterator_next (it_expr_it)) {
			ValaExpression* it_expr;
			it_expr = gee_iterator_get (it_expr_it);
			{
				vala_ccode_for_statement_add_iterator (cfor, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (it_expr))));
				vala_ccode_generator_create_temp_decl (self, VALA_STATEMENT (stmt), GEE_COLLECTION (it_expr->temp_vars));
				(it_expr == NULL ? NULL : (it_expr = (g_object_unref (it_expr), NULL)));
			}
		}
		(it_expr_collection == NULL ? NULL : (it_expr_collection = (g_object_unref (it_expr_collection), NULL)));
		(it_expr_it == NULL ? NULL : (it_expr_it = (g_object_unref (it_expr_it), NULL)));
	}
	vala_ccode_generator_create_temp_decl (self, VALA_STATEMENT (stmt), GEE_COLLECTION (vala_for_statement_get_condition (stmt)->temp_vars));
	(cfor == NULL ? NULL : (cfor = (g_object_unref (cfor), NULL)));
}


static void vala_ccode_generator_real_visit_foreach_statement (ValaCodeVisitor* base, ValaForeachStatement* stmt) {
	ValaCCodeGenerator * self;
	ValaCCodeBlock* cblock;
	ValaCCodeFragment* cfrag;
	ValaVariableDeclarator* _tmp0;
	ValaVariableDeclarator* collection_backup;
	ValaDataType* collection_type;
	char* _tmp1;
	ValaCCodeDeclaration* _tmp2;
	ValaCCodeDeclaration* ccoldecl;
	ValaCCodeVariableDeclarator* ccolvardecl;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (stmt == NULL || VALA_IS_FOREACH_STATEMENT (stmt));
	vala_symbol_set_active (VALA_SYMBOL (vala_foreach_statement_get_variable_declarator (stmt)), TRUE);
	vala_symbol_set_active (VALA_SYMBOL (vala_foreach_statement_get_collection_variable_declarator (stmt)), TRUE);
	if (vala_foreach_statement_get_iterator_variable_declarator (stmt) != NULL) {
		vala_symbol_set_active (VALA_SYMBOL (vala_foreach_statement_get_iterator_variable_declarator (stmt)), TRUE);
	}
	vala_code_visitor_visit_block (VALA_CODE_VISITOR (self), VALA_BLOCK (stmt));
	cblock = vala_ccode_block_new ();
	/* sets #line*/
	vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE (cblock));
	cfrag = vala_ccode_fragment_new ();
	vala_ccode_generator_append_temp_decl (self, cfrag, GEE_COLLECTION (vala_foreach_statement_get_collection (stmt)->temp_vars));
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cfrag));
	_tmp0 = NULL;
	collection_backup = (_tmp0 = vala_foreach_statement_get_collection_variable_declarator (stmt), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	collection_type = vala_data_type_copy (vala_variable_declarator_get_type_reference (collection_backup));
	vala_data_type_set_is_ref (collection_type, FALSE);
	vala_data_type_set_is_out (collection_type, FALSE);
	_tmp1 = NULL;
	_tmp2 = NULL;
	ccoldecl = (_tmp2 = vala_ccode_declaration_new ((_tmp1 = vala_data_type_get_cname (collection_type, FALSE, FALSE))), (_tmp1 = (g_free (_tmp1), NULL)), _tmp2);
	ccolvardecl = vala_ccode_variable_declarator_new_with_initializer (vala_symbol_get_name (VALA_SYMBOL (collection_backup)), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_foreach_statement_get_collection (stmt)))));
	vala_ccode_node_set_line (VALA_CCODE_NODE (ccolvardecl), vala_ccode_node_get_line (VALA_CCODE_NODE (cblock)));
	vala_ccode_declaration_add_declarator (ccoldecl, VALA_CCODE_DECLARATOR (ccolvardecl));
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (ccoldecl));
	if (vala_code_node_get_tree_can_fail (VALA_CODE_NODE (stmt)) && vala_expression_get_can_fail (vala_foreach_statement_get_collection (stmt))) {
		ValaCCodeFragment* cfrag;
		/* exception handling*/
		cfrag = vala_ccode_fragment_new ();
		vala_ccode_generator_add_simple_check (self, VALA_CODE_NODE (vala_foreach_statement_get_collection (stmt)), cfrag);
		vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cfrag));
		(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
	}
	if (VALA_IS_ARRAY (vala_data_type_get_data_type (vala_expression_get_static_type (vala_foreach_statement_get_collection (stmt))))) {
		ValaArray* _tmp3;
		ValaArray* arr;
		ValaCCodeExpression* array_len;
		_tmp3 = NULL;
		arr = (_tmp3 = VALA_ARRAY (vala_data_type_get_data_type (vala_expression_get_static_type (vala_foreach_statement_get_collection (stmt)))), (_tmp3 == NULL ? NULL : g_object_ref (_tmp3)));
		array_len = vala_ccode_generator_get_array_length_cexpression (self, vala_foreach_statement_get_collection (stmt), 1);
		/* the array has no length parameter i.e. is NULL-terminated array */
		if (VALA_IS_CCODE_CONSTANT (array_len)) {
			char* it_name;
			char* _tmp4;
			ValaCCodeDeclaration* _tmp5;
			ValaCCodeDeclaration* citdecl;
			ValaCCodeVariableDeclarator* _tmp6;
			ValaCCodeBlock* cbody;
			char* _tmp7;
			ValaCCodeIdentifier* _tmp8;
			ValaCCodeExpression* element_expr;
			char* _tmp12;
			ValaCCodeDeclaration* _tmp13;
			ValaCCodeDeclaration* cdecl_;
			ValaCCodeVariableDeclarator* _tmp14;
			ValaCCodeConstant* _tmp17;
			ValaCCodeIdentifier* _tmp16;
			char* _tmp15;
			ValaCCodeBinaryExpression* _tmp18;
			ValaCCodeBinaryExpression* ccond;
			ValaCCodeForStatement* cfor;
			ValaCCodeAssignment* _tmp21;
			ValaCCodeIdentifier* _tmp20;
			ValaCCodeIdentifier* _tmp19;
			ValaCCodeAssignment* _tmp26;
			ValaCCodeBinaryExpression* _tmp25;
			ValaCCodeConstant* _tmp24;
			ValaCCodeIdentifier* _tmp23;
			ValaCCodeIdentifier* _tmp22;
			it_name = g_strdup_printf ("%s_it", vala_foreach_statement_get_variable_name (stmt));
			_tmp4 = NULL;
			_tmp5 = NULL;
			citdecl = (_tmp5 = vala_ccode_declaration_new ((_tmp4 = vala_data_type_get_cname (collection_type, FALSE, FALSE))), (_tmp4 = (g_free (_tmp4), NULL)), _tmp5);
			_tmp6 = NULL;
			vala_ccode_declaration_add_declarator (citdecl, VALA_CCODE_DECLARATOR ((_tmp6 = vala_ccode_variable_declarator_new (it_name))));
			(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
			vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (citdecl));
			cbody = vala_ccode_block_new ();
			_tmp7 = NULL;
			_tmp8 = NULL;
			element_expr = VALA_CCODE_EXPRESSION ((_tmp8 = vala_ccode_identifier_new ((_tmp7 = g_strdup_printf ("*%s", it_name))), (_tmp7 = (g_free (_tmp7), NULL)), _tmp8));
			if (vala_data_type_get_takes_ownership (vala_foreach_statement_get_type_reference (stmt))) {
				ValaMemberAccess* ma;
				ValaCCodeExpression* _tmp9;
				ValaCCodeDeclaration* clendecl;
				ValaCCodeVariableDeclarator* _tmp11;
				char* _tmp10;
				ValaCCodeFragment* cfrag;
				ma = vala_member_access_new_simple (vala_foreach_statement_get_variable_name (stmt), NULL);
				vala_expression_set_static_type (VALA_EXPRESSION (ma), vala_foreach_statement_get_type_reference (stmt));
				vala_code_node_set_ccodenode (VALA_CODE_NODE (ma), VALA_CCODE_NODE (element_expr));
				_tmp9 = NULL;
				element_expr = (_tmp9 = vala_ccode_generator_get_ref_expression (self, VALA_EXPRESSION (ma)), (element_expr == NULL ? NULL : (element_expr = (g_object_unref (element_expr), NULL))), _tmp9);
				clendecl = vala_ccode_declaration_new ("int");
				_tmp11 = NULL;
				_tmp10 = NULL;
				vala_ccode_declaration_add_declarator (clendecl, VALA_CCODE_DECLARATOR ((_tmp11 = vala_ccode_variable_declarator_new_with_initializer ((_tmp10 = vala_ccode_generator_get_array_length_cname (self, vala_symbol_get_name (VALA_SYMBOL (collection_backup)), 1)), array_len))));
				(_tmp11 == NULL ? NULL : (_tmp11 = (g_object_unref (_tmp11), NULL)));
				(_tmp10 = (g_free (_tmp10), NULL));
				vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (clendecl));
				cfrag = vala_ccode_fragment_new ();
				vala_ccode_generator_append_temp_decl (self, cfrag, GEE_COLLECTION (self->temp_vars));
				vala_ccode_block_add_statement (cbody, VALA_CCODE_NODE (cfrag));
				gee_collection_clear (GEE_COLLECTION (self->temp_vars));
				(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
				(clendecl == NULL ? NULL : (clendecl = (g_object_unref (clendecl), NULL)));
				(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
			}
			_tmp12 = NULL;
			_tmp13 = NULL;
			cdecl_ = (_tmp13 = vala_ccode_declaration_new ((_tmp12 = vala_data_type_get_cname (vala_foreach_statement_get_type_reference (stmt), FALSE, FALSE))), (_tmp12 = (g_free (_tmp12), NULL)), _tmp13);
			_tmp14 = NULL;
			vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp14 = vala_ccode_variable_declarator_new_with_initializer (vala_foreach_statement_get_variable_name (stmt), element_expr))));
			(_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL)));
			vala_ccode_block_add_statement (cbody, VALA_CCODE_NODE (cdecl_));
			vala_ccode_block_add_statement (cbody, vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_foreach_statement_get_body (stmt))));
			_tmp17 = NULL;
			_tmp16 = NULL;
			_tmp15 = NULL;
			_tmp18 = NULL;
			ccond = (_tmp18 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, VALA_CCODE_EXPRESSION ((_tmp16 = vala_ccode_identifier_new ((_tmp15 = g_strdup_printf ("*%s", it_name))))), VALA_CCODE_EXPRESSION ((_tmp17 = vala_ccode_constant_new ("NULL")))), (_tmp17 == NULL ? NULL : (_tmp17 = (g_object_unref (_tmp17), NULL))), (_tmp16 == NULL ? NULL : (_tmp16 = (g_object_unref (_tmp16), NULL))), (_tmp15 = (g_free (_tmp15), NULL)), _tmp18);
			cfor = vala_ccode_for_statement_new (VALA_CCODE_EXPRESSION (ccond), VALA_CCODE_STATEMENT (cbody));
			_tmp21 = NULL;
			_tmp20 = NULL;
			_tmp19 = NULL;
			vala_ccode_for_statement_add_initializer (cfor, VALA_CCODE_EXPRESSION ((_tmp21 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp19 = vala_ccode_identifier_new (it_name))), VALA_CCODE_EXPRESSION ((_tmp20 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (collection_backup))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
			(_tmp21 == NULL ? NULL : (_tmp21 = (g_object_unref (_tmp21), NULL)));
			(_tmp20 == NULL ? NULL : (_tmp20 = (g_object_unref (_tmp20), NULL)));
			(_tmp19 == NULL ? NULL : (_tmp19 = (g_object_unref (_tmp19), NULL)));
			_tmp26 = NULL;
			_tmp25 = NULL;
			_tmp24 = NULL;
			_tmp23 = NULL;
			_tmp22 = NULL;
			vala_ccode_for_statement_add_iterator (cfor, VALA_CCODE_EXPRESSION ((_tmp26 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp22 = vala_ccode_identifier_new (it_name))), VALA_CCODE_EXPRESSION ((_tmp25 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, VALA_CCODE_EXPRESSION ((_tmp23 = vala_ccode_identifier_new (it_name))), VALA_CCODE_EXPRESSION ((_tmp24 = vala_ccode_constant_new ("1")))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
			(_tmp26 == NULL ? NULL : (_tmp26 = (g_object_unref (_tmp26), NULL)));
			(_tmp25 == NULL ? NULL : (_tmp25 = (g_object_unref (_tmp25), NULL)));
			(_tmp24 == NULL ? NULL : (_tmp24 = (g_object_unref (_tmp24), NULL)));
			(_tmp23 == NULL ? NULL : (_tmp23 = (g_object_unref (_tmp23), NULL)));
			(_tmp22 == NULL ? NULL : (_tmp22 = (g_object_unref (_tmp22), NULL)));
			vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cfor));
			(it_name = (g_free (it_name), NULL));
			(citdecl == NULL ? NULL : (citdecl = (g_object_unref (citdecl), NULL)));
			(cbody == NULL ? NULL : (cbody = (g_object_unref (cbody), NULL)));
			(element_expr == NULL ? NULL : (element_expr = (g_object_unref (element_expr), NULL)));
			(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
			(ccond == NULL ? NULL : (ccond = (g_object_unref (ccond), NULL)));
			(cfor == NULL ? NULL : (cfor = (g_object_unref (cfor), NULL)));
		} else {
			char* it_name;
			ValaCCodeDeclaration* citdecl;
			ValaCCodeVariableDeclarator* _tmp27;
			ValaCCodeBlock* cbody;
			ValaCCodeIdentifier* _tmp29;
			ValaCCodeIdentifier* _tmp28;
			ValaCCodeElementAccess* _tmp30;
			ValaCCodeExpression* element_expr;
			char* _tmp32;
			ValaCCodeDeclaration* _tmp33;
			ValaCCodeDeclaration* cdecl_;
			ValaCCodeVariableDeclarator* _tmp34;
			ValaCCodeConstant* _tmp35;
			ValaCCodeBinaryExpression* _tmp36;
			ValaCCodeBinaryExpression* ccond_ind1;
			ValaCCodeIdentifier* _tmp37;
			ValaCCodeBinaryExpression* _tmp38;
			ValaCCodeBinaryExpression* ccond_ind2;
			ValaCCodeBinaryExpression* ccond_ind;
			ValaCCodeBinaryExpression* ccond;
			ValaCCodeForStatement* cfor;
			ValaCCodeAssignment* _tmp56;
			ValaCCodeConstant* _tmp55;
			ValaCCodeIdentifier* _tmp54;
			ValaCCodeAssignment* _tmp61;
			ValaCCodeBinaryExpression* _tmp60;
			ValaCCodeConstant* _tmp59;
			ValaCCodeIdentifier* _tmp58;
			ValaCCodeIdentifier* _tmp57;
			/* the array has a length parameter */
			it_name = (g_strconcat (vala_foreach_statement_get_variable_name (stmt), "_it", NULL));
			citdecl = vala_ccode_declaration_new ("int");
			_tmp27 = NULL;
			vala_ccode_declaration_add_declarator (citdecl, VALA_CCODE_DECLARATOR ((_tmp27 = vala_ccode_variable_declarator_new (it_name))));
			(_tmp27 == NULL ? NULL : (_tmp27 = (g_object_unref (_tmp27), NULL)));
			vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (citdecl));
			cbody = vala_ccode_block_new ();
			_tmp29 = NULL;
			_tmp28 = NULL;
			_tmp30 = NULL;
			element_expr = VALA_CCODE_EXPRESSION ((_tmp30 = vala_ccode_element_access_new (VALA_CCODE_EXPRESSION ((_tmp28 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (collection_backup))))), VALA_CCODE_EXPRESSION ((_tmp29 = vala_ccode_identifier_new (it_name)))), (_tmp29 == NULL ? NULL : (_tmp29 = (g_object_unref (_tmp29), NULL))), (_tmp28 == NULL ? NULL : (_tmp28 = (g_object_unref (_tmp28), NULL))), _tmp30));
			if (vala_data_type_get_takes_ownership (vala_foreach_statement_get_type_reference (stmt))) {
				ValaMemberAccess* ma;
				ValaCCodeExpression* _tmp31;
				ValaCCodeFragment* cfrag;
				ma = vala_member_access_new_simple (vala_foreach_statement_get_variable_name (stmt), NULL);
				vala_expression_set_static_type (VALA_EXPRESSION (ma), vala_foreach_statement_get_type_reference (stmt));
				vala_code_node_set_ccodenode (VALA_CODE_NODE (ma), VALA_CCODE_NODE (element_expr));
				_tmp31 = NULL;
				element_expr = (_tmp31 = vala_ccode_generator_get_ref_expression (self, VALA_EXPRESSION (ma)), (element_expr == NULL ? NULL : (element_expr = (g_object_unref (element_expr), NULL))), _tmp31);
				cfrag = vala_ccode_fragment_new ();
				vala_ccode_generator_append_temp_decl (self, cfrag, GEE_COLLECTION (self->temp_vars));
				vala_ccode_block_add_statement (cbody, VALA_CCODE_NODE (cfrag));
				gee_collection_clear (GEE_COLLECTION (self->temp_vars));
				(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
				(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
			}
			_tmp32 = NULL;
			_tmp33 = NULL;
			cdecl_ = (_tmp33 = vala_ccode_declaration_new ((_tmp32 = vala_data_type_get_cname (vala_foreach_statement_get_type_reference (stmt), FALSE, FALSE))), (_tmp32 = (g_free (_tmp32), NULL)), _tmp33);
			_tmp34 = NULL;
			vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp34 = vala_ccode_variable_declarator_new_with_initializer (vala_foreach_statement_get_variable_name (stmt), element_expr))));
			(_tmp34 == NULL ? NULL : (_tmp34 = (g_object_unref (_tmp34), NULL)));
			vala_ccode_block_add_statement (cbody, VALA_CCODE_NODE (cdecl_));
			vala_ccode_block_add_statement (cbody, vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_foreach_statement_get_body (stmt))));
			_tmp35 = NULL;
			_tmp36 = NULL;
			ccond_ind1 = (_tmp36 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, array_len, VALA_CCODE_EXPRESSION ((_tmp35 = vala_ccode_constant_new ("-1")))), (_tmp35 == NULL ? NULL : (_tmp35 = (g_object_unref (_tmp35), NULL))), _tmp36);
			_tmp37 = NULL;
			_tmp38 = NULL;
			ccond_ind2 = (_tmp38 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_LESS_THAN, VALA_CCODE_EXPRESSION ((_tmp37 = vala_ccode_identifier_new (it_name))), array_len), (_tmp37 == NULL ? NULL : (_tmp37 = (g_object_unref (_tmp37), NULL))), _tmp38);
			ccond_ind = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_AND, VALA_CCODE_EXPRESSION (ccond_ind1), VALA_CCODE_EXPRESSION (ccond_ind2));
			/* only check for null if the containers elements are of reference-type */
			ccond = NULL;
			if (vala_typesymbol_is_reference_type (vala_array_get_element_type (arr))) {
				ValaCCodeConstant* _tmp39;
				ValaCCodeBinaryExpression* _tmp40;
				ValaCCodeBinaryExpression* ccond_term1;
				ValaCCodeConstant* _tmp44;
				ValaCCodeElementAccess* _tmp43;
				ValaCCodeIdentifier* _tmp42;
				ValaCCodeIdentifier* _tmp41;
				ValaCCodeBinaryExpression* _tmp45;
				ValaCCodeBinaryExpression* ccond_term2;
				ValaCCodeBinaryExpression* ccond_term;
				ValaCCodeBinaryExpression* _tmp48;
				ValaCCodeParenthesizedExpression* _tmp47;
				ValaCCodeParenthesizedExpression* _tmp46;
				_tmp39 = NULL;
				_tmp40 = NULL;
				ccond_term1 = (_tmp40 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, array_len, VALA_CCODE_EXPRESSION ((_tmp39 = vala_ccode_constant_new ("-1")))), (_tmp39 == NULL ? NULL : (_tmp39 = (g_object_unref (_tmp39), NULL))), _tmp40);
				_tmp44 = NULL;
				_tmp43 = NULL;
				_tmp42 = NULL;
				_tmp41 = NULL;
				_tmp45 = NULL;
				ccond_term2 = (_tmp45 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, VALA_CCODE_EXPRESSION ((_tmp43 = vala_ccode_element_access_new (VALA_CCODE_EXPRESSION ((_tmp41 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (collection_backup))))), VALA_CCODE_EXPRESSION ((_tmp42 = vala_ccode_identifier_new (it_name)))))), VALA_CCODE_EXPRESSION ((_tmp44 = vala_ccode_constant_new ("NULL")))), (_tmp44 == NULL ? NULL : (_tmp44 = (g_object_unref (_tmp44), NULL))), (_tmp43 == NULL ? NULL : (_tmp43 = (g_object_unref (_tmp43), NULL))), (_tmp42 == NULL ? NULL : (_tmp42 = (g_object_unref (_tmp42), NULL))), (_tmp41 == NULL ? NULL : (_tmp41 = (g_object_unref (_tmp41), NULL))), _tmp45);
				ccond_term = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_AND, VALA_CCODE_EXPRESSION (ccond_term1), VALA_CCODE_EXPRESSION (ccond_term2));
				_tmp48 = NULL;
				_tmp47 = NULL;
				_tmp46 = NULL;
				ccond = (_tmp48 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_OR, VALA_CCODE_EXPRESSION ((_tmp46 = vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION (ccond_ind)))), VALA_CCODE_EXPRESSION ((_tmp47 = vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION (ccond_term))))), (ccond == NULL ? NULL : (ccond = (g_object_unref (ccond), NULL))), _tmp48);
				(_tmp47 == NULL ? NULL : (_tmp47 = (g_object_unref (_tmp47), NULL)));
				(_tmp46 == NULL ? NULL : (_tmp46 = (g_object_unref (_tmp46), NULL)));
				(ccond_term1 == NULL ? NULL : (ccond_term1 = (g_object_unref (ccond_term1), NULL)));
				(ccond_term2 == NULL ? NULL : (ccond_term2 = (g_object_unref (ccond_term2), NULL)));
				(ccond_term == NULL ? NULL : (ccond_term = (g_object_unref (ccond_term), NULL)));
			} else {
				ValaCCodeIdentifier* _tmp49;
				ValaCCodeFunctionCall* _tmp50;
				ValaCCodeFunctionCall* cassert;
				ValaCCodeExpressionStatement* _tmp51;
				ValaCCodeBinaryExpression* _tmp53;
				ValaCCodeBinaryExpression* _tmp52;
				/* assert when trying to iterate over value-type arrays of unknown length */
				_tmp49 = NULL;
				_tmp50 = NULL;
				cassert = (_tmp50 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp49 = vala_ccode_identifier_new ("g_assert")))), (_tmp49 == NULL ? NULL : (_tmp49 = (g_object_unref (_tmp49), NULL))), _tmp50);
				vala_ccode_function_call_add_argument (cassert, VALA_CCODE_EXPRESSION (ccond_ind1));
				_tmp51 = NULL;
				vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((_tmp51 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cassert)))));
				(_tmp51 == NULL ? NULL : (_tmp51 = (g_object_unref (_tmp51), NULL)));
				_tmp53 = NULL;
				_tmp52 = NULL;
				ccond = (_tmp53 = (_tmp52 = ccond_ind2, (_tmp52 == NULL ? NULL : g_object_ref (_tmp52))), (ccond == NULL ? NULL : (ccond = (g_object_unref (ccond), NULL))), _tmp53);
				(cassert == NULL ? NULL : (cassert = (g_object_unref (cassert), NULL)));
			}
			cfor = vala_ccode_for_statement_new (VALA_CCODE_EXPRESSION (ccond), VALA_CCODE_STATEMENT (cbody));
			_tmp56 = NULL;
			_tmp55 = NULL;
			_tmp54 = NULL;
			vala_ccode_for_statement_add_initializer (cfor, VALA_CCODE_EXPRESSION ((_tmp56 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp54 = vala_ccode_identifier_new (it_name))), VALA_CCODE_EXPRESSION ((_tmp55 = vala_ccode_constant_new ("0"))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
			(_tmp56 == NULL ? NULL : (_tmp56 = (g_object_unref (_tmp56), NULL)));
			(_tmp55 == NULL ? NULL : (_tmp55 = (g_object_unref (_tmp55), NULL)));
			(_tmp54 == NULL ? NULL : (_tmp54 = (g_object_unref (_tmp54), NULL)));
			_tmp61 = NULL;
			_tmp60 = NULL;
			_tmp59 = NULL;
			_tmp58 = NULL;
			_tmp57 = NULL;
			vala_ccode_for_statement_add_iterator (cfor, VALA_CCODE_EXPRESSION ((_tmp61 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp57 = vala_ccode_identifier_new (it_name))), VALA_CCODE_EXPRESSION ((_tmp60 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, VALA_CCODE_EXPRESSION ((_tmp58 = vala_ccode_identifier_new (it_name))), VALA_CCODE_EXPRESSION ((_tmp59 = vala_ccode_constant_new ("1")))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
			(_tmp61 == NULL ? NULL : (_tmp61 = (g_object_unref (_tmp61), NULL)));
			(_tmp60 == NULL ? NULL : (_tmp60 = (g_object_unref (_tmp60), NULL)));
			(_tmp59 == NULL ? NULL : (_tmp59 = (g_object_unref (_tmp59), NULL)));
			(_tmp58 == NULL ? NULL : (_tmp58 = (g_object_unref (_tmp58), NULL)));
			(_tmp57 == NULL ? NULL : (_tmp57 = (g_object_unref (_tmp57), NULL)));
			vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cfor));
			(it_name = (g_free (it_name), NULL));
			(citdecl == NULL ? NULL : (citdecl = (g_object_unref (citdecl), NULL)));
			(cbody == NULL ? NULL : (cbody = (g_object_unref (cbody), NULL)));
			(element_expr == NULL ? NULL : (element_expr = (g_object_unref (element_expr), NULL)));
			(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
			(ccond_ind1 == NULL ? NULL : (ccond_ind1 = (g_object_unref (ccond_ind1), NULL)));
			(ccond_ind2 == NULL ? NULL : (ccond_ind2 = (g_object_unref (ccond_ind2), NULL)));
			(ccond_ind == NULL ? NULL : (ccond_ind = (g_object_unref (ccond_ind), NULL)));
			(ccond == NULL ? NULL : (ccond = (g_object_unref (ccond), NULL)));
			(cfor == NULL ? NULL : (cfor = (g_object_unref (cfor), NULL)));
		}
		(arr == NULL ? NULL : (arr = (g_object_unref (arr), NULL)));
		(array_len == NULL ? NULL : (array_len = (g_object_unref (array_len), NULL)));
	} else {
		if (vala_data_type_get_data_type (vala_expression_get_static_type (vala_foreach_statement_get_collection (stmt))) == self->glist_type || vala_data_type_get_data_type (vala_expression_get_static_type (vala_foreach_statement_get_collection (stmt))) == self->gslist_type) {
			char* it_name;
			char* _tmp62;
			ValaCCodeDeclaration* _tmp63;
			ValaCCodeDeclaration* citdecl;
			ValaCCodeVariableDeclarator* citvardecl;
			ValaCCodeBlock* cbody;
			ValaCCodeIdentifier* _tmp64;
			ValaCCodeMemberAccess* _tmp65;
			ValaCCodeExpression* element_expr;
			ValaCCodeExpression* _tmp66;
			char* _tmp68;
			ValaCCodeDeclaration* _tmp69;
			ValaCCodeDeclaration* cdecl_;
			ValaCCodeVariableDeclarator* cvardecl;
			ValaCCodeConstant* _tmp71;
			ValaCCodeIdentifier* _tmp70;
			ValaCCodeBinaryExpression* _tmp72;
			ValaCCodeBinaryExpression* ccond;
			ValaCCodeForStatement* cfor;
			ValaCCodeAssignment* _tmp75;
			ValaCCodeIdentifier* _tmp74;
			ValaCCodeIdentifier* _tmp73;
			ValaCCodeAssignment* _tmp79;
			ValaCCodeMemberAccess* _tmp78;
			ValaCCodeIdentifier* _tmp77;
			ValaCCodeIdentifier* _tmp76;
			it_name = g_strdup_printf ("%s_it", vala_foreach_statement_get_variable_name (stmt));
			_tmp62 = NULL;
			_tmp63 = NULL;
			citdecl = (_tmp63 = vala_ccode_declaration_new ((_tmp62 = vala_data_type_get_cname (collection_type, FALSE, FALSE))), (_tmp62 = (g_free (_tmp62), NULL)), _tmp63);
			citvardecl = vala_ccode_variable_declarator_new (it_name);
			vala_ccode_node_set_line (VALA_CCODE_NODE (citvardecl), vala_ccode_node_get_line (VALA_CCODE_NODE (cblock)));
			vala_ccode_declaration_add_declarator (citdecl, VALA_CCODE_DECLARATOR (citvardecl));
			vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (citdecl));
			cbody = vala_ccode_block_new ();
			_tmp64 = NULL;
			_tmp65 = NULL;
			element_expr = VALA_CCODE_EXPRESSION ((_tmp65 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp64 = vala_ccode_identifier_new (it_name))), "data"), (_tmp64 == NULL ? NULL : (_tmp64 = (g_object_unref (_tmp64), NULL))), _tmp65));
			_tmp66 = NULL;
			element_expr = (_tmp66 = vala_ccode_generator_convert_from_generic_pointer (self, element_expr, vala_foreach_statement_get_type_reference (stmt)), (element_expr == NULL ? NULL : (element_expr = (g_object_unref (element_expr), NULL))), _tmp66);
			if (vala_data_type_get_takes_ownership (vala_foreach_statement_get_type_reference (stmt))) {
				ValaMemberAccess* ma;
				ValaCCodeExpression* _tmp67;
				ValaCCodeFragment* cfrag;
				ma = vala_member_access_new_simple (vala_foreach_statement_get_variable_name (stmt), NULL);
				vala_expression_set_static_type (VALA_EXPRESSION (ma), vala_foreach_statement_get_type_reference (stmt));
				vala_code_node_set_ccodenode (VALA_CODE_NODE (ma), VALA_CCODE_NODE (element_expr));
				_tmp67 = NULL;
				element_expr = (_tmp67 = vala_ccode_generator_get_ref_expression (self, VALA_EXPRESSION (ma)), (element_expr == NULL ? NULL : (element_expr = (g_object_unref (element_expr), NULL))), _tmp67);
				cfrag = vala_ccode_fragment_new ();
				vala_ccode_generator_append_temp_decl (self, cfrag, GEE_COLLECTION (self->temp_vars));
				vala_ccode_block_add_statement (cbody, VALA_CCODE_NODE (cfrag));
				gee_collection_clear (GEE_COLLECTION (self->temp_vars));
				(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
				(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
			}
			_tmp68 = NULL;
			_tmp69 = NULL;
			cdecl_ = (_tmp69 = vala_ccode_declaration_new ((_tmp68 = vala_data_type_get_cname (vala_foreach_statement_get_type_reference (stmt), FALSE, FALSE))), (_tmp68 = (g_free (_tmp68), NULL)), _tmp69);
			cvardecl = vala_ccode_variable_declarator_new_with_initializer (vala_foreach_statement_get_variable_name (stmt), element_expr);
			vala_ccode_node_set_line (VALA_CCODE_NODE (cvardecl), vala_ccode_node_get_line (VALA_CCODE_NODE (cblock)));
			vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR (cvardecl));
			vala_ccode_block_add_statement (cbody, VALA_CCODE_NODE (cdecl_));
			vala_ccode_block_add_statement (cbody, vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_foreach_statement_get_body (stmt))));
			_tmp71 = NULL;
			_tmp70 = NULL;
			_tmp72 = NULL;
			ccond = (_tmp72 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, VALA_CCODE_EXPRESSION ((_tmp70 = vala_ccode_identifier_new (it_name))), VALA_CCODE_EXPRESSION ((_tmp71 = vala_ccode_constant_new ("NULL")))), (_tmp71 == NULL ? NULL : (_tmp71 = (g_object_unref (_tmp71), NULL))), (_tmp70 == NULL ? NULL : (_tmp70 = (g_object_unref (_tmp70), NULL))), _tmp72);
			cfor = vala_ccode_for_statement_new (VALA_CCODE_EXPRESSION (ccond), VALA_CCODE_STATEMENT (cbody));
			_tmp75 = NULL;
			_tmp74 = NULL;
			_tmp73 = NULL;
			vala_ccode_for_statement_add_initializer (cfor, VALA_CCODE_EXPRESSION ((_tmp75 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp73 = vala_ccode_identifier_new (it_name))), VALA_CCODE_EXPRESSION ((_tmp74 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (collection_backup))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
			(_tmp75 == NULL ? NULL : (_tmp75 = (g_object_unref (_tmp75), NULL)));
			(_tmp74 == NULL ? NULL : (_tmp74 = (g_object_unref (_tmp74), NULL)));
			(_tmp73 == NULL ? NULL : (_tmp73 = (g_object_unref (_tmp73), NULL)));
			_tmp79 = NULL;
			_tmp78 = NULL;
			_tmp77 = NULL;
			_tmp76 = NULL;
			vala_ccode_for_statement_add_iterator (cfor, VALA_CCODE_EXPRESSION ((_tmp79 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp76 = vala_ccode_identifier_new (it_name))), VALA_CCODE_EXPRESSION ((_tmp78 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp77 = vala_ccode_identifier_new (it_name))), "next"))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
			(_tmp79 == NULL ? NULL : (_tmp79 = (g_object_unref (_tmp79), NULL)));
			(_tmp78 == NULL ? NULL : (_tmp78 = (g_object_unref (_tmp78), NULL)));
			(_tmp77 == NULL ? NULL : (_tmp77 = (g_object_unref (_tmp77), NULL)));
			(_tmp76 == NULL ? NULL : (_tmp76 = (g_object_unref (_tmp76), NULL)));
			vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cfor));
			(it_name = (g_free (it_name), NULL));
			(citdecl == NULL ? NULL : (citdecl = (g_object_unref (citdecl), NULL)));
			(citvardecl == NULL ? NULL : (citvardecl = (g_object_unref (citvardecl), NULL)));
			(cbody == NULL ? NULL : (cbody = (g_object_unref (cbody), NULL)));
			(element_expr == NULL ? NULL : (element_expr = (g_object_unref (element_expr), NULL)));
			(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
			(cvardecl == NULL ? NULL : (cvardecl = (g_object_unref (cvardecl), NULL)));
			(ccond == NULL ? NULL : (ccond = (g_object_unref (ccond), NULL)));
			(cfor == NULL ? NULL : (cfor = (g_object_unref (cfor), NULL)));
		} else {
			if (vala_typesymbol_is_subtype_of (vala_data_type_get_data_type (vala_expression_get_static_type (vala_foreach_statement_get_collection (stmt))), self->iterable_type)) {
				char* it_name;
				char* _tmp81;
				char* _tmp80;
				ValaCCodeDeclaration* _tmp82;
				ValaCCodeDeclaration* citdecl;
				ValaMethod* it_method;
				ValaCCodeIdentifier* _tmp84;
				char* _tmp83;
				ValaCCodeFunctionCall* _tmp85;
				ValaCCodeFunctionCall* it_ccall;
				ValaInstanceCast* _tmp87;
				ValaCCodeIdentifier* _tmp86;
				ValaCCodeVariableDeclarator* citvardecl;
				ValaCCodeBlock* cbody;
				ValaMethod* get_method;
				ValaCCodeIdentifier* _tmp89;
				char* _tmp88;
				ValaCCodeFunctionCall* _tmp90;
				ValaCCodeFunctionCall* get_ccall;
				ValaCCodeIdentifier* _tmp91;
				ValaCCodeFunctionCall* _tmp92;
				ValaCCodeExpression* element_expr;
				ValaCCodeExpression* _tmp93;
				GeeList* _tmp94;
				GeeIterator* _tmp95;
				GeeIterator* type_arg_it;
				ValaDataType* _tmp96;
				ValaDataType* _tmp97;
				ValaDataType* it_type;
				char* _tmp99;
				ValaCCodeDeclaration* _tmp100;
				ValaCCodeDeclaration* cdecl_;
				ValaCCodeVariableDeclarator* cvardecl;
				ValaMethod* next_method;
				ValaCCodeIdentifier* _tmp102;
				char* _tmp101;
				ValaCCodeFunctionCall* _tmp103;
				ValaCCodeFunctionCall* next_ccall;
				ValaCCodeIdentifier* _tmp104;
				ValaCCodeWhileStatement* cwhile;
				it_name = g_strdup_printf ("%s_it", vala_foreach_statement_get_variable_name (stmt));
				_tmp81 = NULL;
				_tmp80 = NULL;
				_tmp82 = NULL;
				citdecl = (_tmp82 = vala_ccode_declaration_new ((_tmp81 = g_strconcat ((_tmp80 = vala_typesymbol_get_cname (self->iterator_type, FALSE)), "*", NULL))), (_tmp81 = (g_free (_tmp81), NULL)), (_tmp80 = (g_free (_tmp80), NULL)), _tmp82);
				it_method = VALA_METHOD (vala_scope_lookup (vala_symbol_get_scope (VALA_SYMBOL (self->iterable_type)), "iterator"));
				_tmp84 = NULL;
				_tmp83 = NULL;
				_tmp85 = NULL;
				it_ccall = (_tmp85 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp84 = vala_ccode_identifier_new ((_tmp83 = vala_method_get_cname (it_method)))))), (_tmp84 == NULL ? NULL : (_tmp84 = (g_object_unref (_tmp84), NULL))), (_tmp83 = (g_free (_tmp83), NULL)), _tmp85);
				_tmp87 = NULL;
				_tmp86 = NULL;
				vala_ccode_function_call_add_argument (it_ccall, VALA_CCODE_EXPRESSION ((_tmp87 = vala_instance_cast_new (VALA_CCODE_EXPRESSION ((_tmp86 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (collection_backup))))), self->iterable_type))));
				(_tmp87 == NULL ? NULL : (_tmp87 = (g_object_unref (_tmp87), NULL)));
				(_tmp86 == NULL ? NULL : (_tmp86 = (g_object_unref (_tmp86), NULL)));
				citvardecl = vala_ccode_variable_declarator_new_with_initializer (it_name, VALA_CCODE_EXPRESSION (it_ccall));
				vala_ccode_node_set_line (VALA_CCODE_NODE (citvardecl), vala_ccode_node_get_line (VALA_CCODE_NODE (cblock)));
				vala_ccode_declaration_add_declarator (citdecl, VALA_CCODE_DECLARATOR (citvardecl));
				vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (citdecl));
				cbody = vala_ccode_block_new ();
				get_method = VALA_METHOD (vala_scope_lookup (vala_symbol_get_scope (VALA_SYMBOL (self->iterator_type)), "get"));
				_tmp89 = NULL;
				_tmp88 = NULL;
				_tmp90 = NULL;
				get_ccall = (_tmp90 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp89 = vala_ccode_identifier_new ((_tmp88 = vala_method_get_cname (get_method)))))), (_tmp89 == NULL ? NULL : (_tmp89 = (g_object_unref (_tmp89), NULL))), (_tmp88 = (g_free (_tmp88), NULL)), _tmp90);
				_tmp91 = NULL;
				vala_ccode_function_call_add_argument (get_ccall, VALA_CCODE_EXPRESSION ((_tmp91 = vala_ccode_identifier_new (it_name))));
				(_tmp91 == NULL ? NULL : (_tmp91 = (g_object_unref (_tmp91), NULL)));
				_tmp92 = NULL;
				element_expr = VALA_CCODE_EXPRESSION ((_tmp92 = get_ccall, (_tmp92 == NULL ? NULL : g_object_ref (_tmp92))));
				_tmp93 = NULL;
				element_expr = (_tmp93 = vala_ccode_generator_convert_from_generic_pointer (self, element_expr, vala_foreach_statement_get_type_reference (stmt)), (element_expr == NULL ? NULL : (element_expr = (g_object_unref (element_expr), NULL))), _tmp93);
				_tmp94 = NULL;
				_tmp95 = NULL;
				type_arg_it = (_tmp95 = gee_iterable_iterator (GEE_ITERABLE ((_tmp94 = vala_data_type_get_type_arguments (vala_method_get_return_type (it_method))))), (_tmp94 == NULL ? NULL : (_tmp94 = (g_object_unref (_tmp94), NULL))), _tmp95);
				gee_iterator_next (type_arg_it);
				_tmp96 = NULL;
				_tmp97 = NULL;
				it_type = (_tmp97 = vala_semantic_analyzer_get_actual_type (vala_expression_get_static_type (vala_foreach_statement_get_collection (stmt)), VALA_SYMBOL (it_method), (_tmp96 = gee_iterator_get (type_arg_it)), VALA_CODE_NODE (stmt)), (_tmp96 == NULL ? NULL : (_tmp96 = (g_object_unref (_tmp96), NULL))), _tmp97);
				if (vala_data_type_get_takes_ownership (vala_foreach_statement_get_type_reference (stmt)) && !vala_data_type_get_takes_ownership (it_type)) {
					ValaMemberAccess* ma;
					ValaCCodeExpression* _tmp98;
					ValaCCodeFragment* cfrag;
					ma = vala_member_access_new_simple (vala_foreach_statement_get_variable_name (stmt), NULL);
					vala_expression_set_static_type (VALA_EXPRESSION (ma), vala_foreach_statement_get_type_reference (stmt));
					vala_code_node_set_ccodenode (VALA_CODE_NODE (ma), VALA_CCODE_NODE (element_expr));
					_tmp98 = NULL;
					element_expr = (_tmp98 = vala_ccode_generator_get_ref_expression (self, VALA_EXPRESSION (ma)), (element_expr == NULL ? NULL : (element_expr = (g_object_unref (element_expr), NULL))), _tmp98);
					cfrag = vala_ccode_fragment_new ();
					vala_ccode_generator_append_temp_decl (self, cfrag, GEE_COLLECTION (self->temp_vars));
					vala_ccode_block_add_statement (cbody, VALA_CCODE_NODE (cfrag));
					gee_collection_clear (GEE_COLLECTION (self->temp_vars));
					(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
					(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
				}
				_tmp99 = NULL;
				_tmp100 = NULL;
				cdecl_ = (_tmp100 = vala_ccode_declaration_new ((_tmp99 = vala_data_type_get_cname (vala_foreach_statement_get_type_reference (stmt), FALSE, FALSE))), (_tmp99 = (g_free (_tmp99), NULL)), _tmp100);
				cvardecl = vala_ccode_variable_declarator_new_with_initializer (vala_foreach_statement_get_variable_name (stmt), element_expr);
				vala_ccode_node_set_line (VALA_CCODE_NODE (cvardecl), vala_ccode_node_get_line (VALA_CCODE_NODE (cblock)));
				vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR (cvardecl));
				vala_ccode_block_add_statement (cbody, VALA_CCODE_NODE (cdecl_));
				vala_ccode_block_add_statement (cbody, vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_foreach_statement_get_body (stmt))));
				next_method = VALA_METHOD (vala_scope_lookup (vala_symbol_get_scope (VALA_SYMBOL (self->iterator_type)), "next"));
				_tmp102 = NULL;
				_tmp101 = NULL;
				_tmp103 = NULL;
				next_ccall = (_tmp103 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp102 = vala_ccode_identifier_new ((_tmp101 = vala_method_get_cname (next_method)))))), (_tmp102 == NULL ? NULL : (_tmp102 = (g_object_unref (_tmp102), NULL))), (_tmp101 = (g_free (_tmp101), NULL)), _tmp103);
				_tmp104 = NULL;
				vala_ccode_function_call_add_argument (next_ccall, VALA_CCODE_EXPRESSION ((_tmp104 = vala_ccode_identifier_new (it_name))));
				(_tmp104 == NULL ? NULL : (_tmp104 = (g_object_unref (_tmp104), NULL)));
				cwhile = vala_ccode_while_statement_new (VALA_CCODE_EXPRESSION (next_ccall), VALA_CCODE_STATEMENT (cbody));
				vala_ccode_node_set_line (VALA_CCODE_NODE (cwhile), vala_ccode_node_get_line (VALA_CCODE_NODE (cblock)));
				vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cwhile));
				(it_name = (g_free (it_name), NULL));
				(citdecl == NULL ? NULL : (citdecl = (g_object_unref (citdecl), NULL)));
				(it_method == NULL ? NULL : (it_method = (g_object_unref (it_method), NULL)));
				(it_ccall == NULL ? NULL : (it_ccall = (g_object_unref (it_ccall), NULL)));
				(citvardecl == NULL ? NULL : (citvardecl = (g_object_unref (citvardecl), NULL)));
				(cbody == NULL ? NULL : (cbody = (g_object_unref (cbody), NULL)));
				(get_method == NULL ? NULL : (get_method = (g_object_unref (get_method), NULL)));
				(get_ccall == NULL ? NULL : (get_ccall = (g_object_unref (get_ccall), NULL)));
				(element_expr == NULL ? NULL : (element_expr = (g_object_unref (element_expr), NULL)));
				(type_arg_it == NULL ? NULL : (type_arg_it = (g_object_unref (type_arg_it), NULL)));
				(it_type == NULL ? NULL : (it_type = (g_object_unref (it_type), NULL)));
				(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
				(cvardecl == NULL ? NULL : (cvardecl = (g_object_unref (cvardecl), NULL)));
				(next_method == NULL ? NULL : (next_method = (g_object_unref (next_method), NULL)));
				(next_ccall == NULL ? NULL : (next_ccall = (g_object_unref (next_ccall), NULL)));
				(cwhile == NULL ? NULL : (cwhile = (g_object_unref (cwhile), NULL)));
			}
		}
	}
	{
		GeeCollection* decl_collection;
		GeeIterator* decl_it;
		decl_collection = vala_block_get_local_variables (VALA_BLOCK (stmt));
		decl_it = gee_iterable_iterator (GEE_ITERABLE (decl_collection));
		while (gee_iterator_next (decl_it)) {
			ValaVariableDeclarator* decl;
			decl = gee_iterator_get (decl_it);
			{
				if (vala_data_type_get_takes_ownership (vala_variable_declarator_get_type_reference (decl))) {
					ValaMemberAccess* ma;
					ValaCCodeExpression* _tmp107;
					ValaCCodeIdentifier* _tmp106;
					char* _tmp105;
					ValaCCodeExpressionStatement* _tmp108;
					ValaCCodeExpressionStatement* cunref;
					ma = vala_member_access_new_simple (vala_symbol_get_name (VALA_SYMBOL (decl)), NULL);
					vala_expression_set_symbol_reference (VALA_EXPRESSION (ma), VALA_SYMBOL (decl));
					_tmp107 = NULL;
					_tmp106 = NULL;
					_tmp105 = NULL;
					_tmp108 = NULL;
					cunref = (_tmp108 = vala_ccode_expression_statement_new ((_tmp107 = vala_ccode_generator_get_unref_expression (self, VALA_CCODE_EXPRESSION ((_tmp106 = vala_ccode_identifier_new ((_tmp105 = vala_ccode_generator_get_variable_cname (self, vala_symbol_get_name (VALA_SYMBOL (decl))))))), vala_variable_declarator_get_type_reference (decl), VALA_EXPRESSION (ma)))), (_tmp107 == NULL ? NULL : (_tmp107 = (g_object_unref (_tmp107), NULL))), (_tmp106 == NULL ? NULL : (_tmp106 = (g_object_unref (_tmp106), NULL))), (_tmp105 = (g_free (_tmp105), NULL)), _tmp108);
					vala_ccode_node_set_line (VALA_CCODE_NODE (cunref), vala_ccode_node_get_line (VALA_CCODE_NODE (cblock)));
					vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cunref));
					(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
					(cunref == NULL ? NULL : (cunref = (g_object_unref (cunref), NULL)));
				}
				(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
			}
		}
		(decl_collection == NULL ? NULL : (decl_collection = (g_object_unref (decl_collection), NULL)));
		(decl_it == NULL ? NULL : (decl_it = (g_object_unref (decl_it), NULL)));
	}
	(cblock == NULL ? NULL : (cblock = (g_object_unref (cblock), NULL)));
	(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
	(collection_backup == NULL ? NULL : (collection_backup = (g_object_unref (collection_backup), NULL)));
	(collection_type == NULL ? NULL : (collection_type = (g_object_unref (collection_type), NULL)));
	(ccoldecl == NULL ? NULL : (ccoldecl = (g_object_unref (ccoldecl), NULL)));
	(ccolvardecl == NULL ? NULL : (ccolvardecl = (g_object_unref (ccolvardecl), NULL)));
}


static void vala_ccode_generator_real_visit_break_statement (ValaCodeVisitor* base, ValaBreakStatement* stmt) {
	ValaCCodeGenerator * self;
	ValaCCodeBreakStatement* _tmp0;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (stmt == NULL || VALA_IS_BREAK_STATEMENT (stmt));
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((_tmp0 = vala_ccode_break_statement_new ())));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	vala_ccode_generator_create_local_free (self, VALA_CODE_NODE (stmt), TRUE);
}


static void vala_ccode_generator_real_visit_continue_statement (ValaCodeVisitor* base, ValaContinueStatement* stmt) {
	ValaCCodeGenerator * self;
	ValaCCodeContinueStatement* _tmp0;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (stmt == NULL || VALA_IS_CONTINUE_STATEMENT (stmt));
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((_tmp0 = vala_ccode_continue_statement_new ())));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	vala_ccode_generator_create_local_free (self, VALA_CODE_NODE (stmt), TRUE);
}


static void vala_ccode_generator_append_local_free (ValaCCodeGenerator* self, ValaSymbol* sym, ValaCCodeFragment* cfrag, gboolean stop_at_loop) {
	ValaBlock* _tmp0;
	ValaBlock* b;
	GeeCollection* local_vars;
	g_return_if_fail (VALA_IS_CCODE_GENERATOR (self));
	g_return_if_fail (sym == NULL || VALA_IS_SYMBOL (sym));
	g_return_if_fail (cfrag == NULL || VALA_IS_CCODE_FRAGMENT (cfrag));
	_tmp0 = NULL;
	b = (_tmp0 = VALA_BLOCK (sym), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	local_vars = vala_block_get_local_variables (b);
	{
		GeeCollection* decl_collection;
		GeeIterator* decl_it;
		decl_collection = local_vars;
		decl_it = gee_iterable_iterator (GEE_ITERABLE (decl_collection));
		while (gee_iterator_next (decl_it)) {
			ValaVariableDeclarator* decl;
			decl = gee_iterator_get (decl_it);
			{
				if (vala_symbol_get_active (VALA_SYMBOL (decl)) && vala_typesymbol_is_reference_type (vala_data_type_get_data_type (vala_variable_declarator_get_type_reference (decl))) && vala_data_type_get_takes_ownership (vala_variable_declarator_get_type_reference (decl))) {
					ValaMemberAccess* ma;
					ValaCCodeExpressionStatement* _tmp4;
					ValaCCodeExpression* _tmp3;
					ValaCCodeIdentifier* _tmp2;
					char* _tmp1;
					ma = vala_member_access_new_simple (vala_symbol_get_name (VALA_SYMBOL (decl)), NULL);
					vala_expression_set_symbol_reference (VALA_EXPRESSION (ma), VALA_SYMBOL (decl));
					_tmp4 = NULL;
					_tmp3 = NULL;
					_tmp2 = NULL;
					_tmp1 = NULL;
					vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((_tmp4 = vala_ccode_expression_statement_new ((_tmp3 = vala_ccode_generator_get_unref_expression (self, VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_identifier_new ((_tmp1 = vala_ccode_generator_get_variable_cname (self, vala_symbol_get_name (VALA_SYMBOL (decl))))))), vala_variable_declarator_get_type_reference (decl), VALA_EXPRESSION (ma)))))));
					(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
					(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
					(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
					(_tmp1 = (g_free (_tmp1), NULL));
					(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
				}
				(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
			}
		}
		(decl_it == NULL ? NULL : (decl_it = (g_object_unref (decl_it), NULL)));
	}
	if (stop_at_loop) {
		if (VALA_IS_DO_STATEMENT (vala_code_node_get_parent_node (VALA_CODE_NODE (b))) || VALA_IS_WHILE_STATEMENT (vala_code_node_get_parent_node (VALA_CODE_NODE (b))) || VALA_IS_FOR_STATEMENT (vala_code_node_get_parent_node (VALA_CODE_NODE (b))) || VALA_IS_FOREACH_STATEMENT (vala_code_node_get_parent_node (VALA_CODE_NODE (b))) || VALA_IS_SWITCH_STATEMENT (vala_code_node_get_parent_node (VALA_CODE_NODE (b)))) {
			(b == NULL ? NULL : (b = (g_object_unref (b), NULL)));
			(local_vars == NULL ? NULL : (local_vars = (g_object_unref (local_vars), NULL)));
			return;
		}
	}
	if (VALA_IS_BLOCK (vala_symbol_get_parent_symbol (sym))) {
		vala_ccode_generator_append_local_free (self, vala_symbol_get_parent_symbol (sym), cfrag, stop_at_loop);
	}
	(b == NULL ? NULL : (b = (g_object_unref (b), NULL)));
	(local_vars == NULL ? NULL : (local_vars = (g_object_unref (local_vars), NULL)));
}


static void vala_ccode_generator_create_local_free (ValaCCodeGenerator* self, ValaCodeNode* stmt, gboolean stop_at_loop) {
	ValaCCodeFragment* cfrag;
	g_return_if_fail (VALA_IS_CCODE_GENERATOR (self));
	g_return_if_fail (stmt == NULL || VALA_IS_CODE_NODE (stmt));
	cfrag = vala_ccode_fragment_new ();
	vala_ccode_generator_append_local_free (self, self->priv->current_symbol, cfrag, stop_at_loop);
	vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode (stmt));
	vala_code_node_set_ccodenode (stmt, VALA_CCODE_NODE (cfrag));
	(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
}


static gboolean vala_ccode_generator_append_local_free_expr (ValaCCodeGenerator* self, ValaSymbol* sym, ValaCCodeCommaExpression* ccomma, gboolean stop_at_loop) {
	gboolean found;
	ValaBlock* _tmp0;
	ValaBlock* b;
	GeeCollection* local_vars;
	gboolean _tmp4;
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), FALSE);
	g_return_val_if_fail (sym == NULL || VALA_IS_SYMBOL (sym), FALSE);
	g_return_val_if_fail (ccomma == NULL || VALA_IS_CCODE_COMMA_EXPRESSION (ccomma), FALSE);
	found = FALSE;
	_tmp0 = NULL;
	b = (_tmp0 = VALA_BLOCK (sym), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	local_vars = vala_block_get_local_variables (b);
	{
		GeeCollection* decl_collection;
		GeeIterator* decl_it;
		decl_collection = local_vars;
		decl_it = gee_iterable_iterator (GEE_ITERABLE (decl_collection));
		while (gee_iterator_next (decl_it)) {
			ValaVariableDeclarator* decl;
			decl = gee_iterator_get (decl_it);
			{
				if (vala_symbol_get_active (VALA_SYMBOL (decl)) && vala_data_type_get_data_type (vala_variable_declarator_get_type_reference (decl)) != NULL && vala_typesymbol_is_reference_type (vala_data_type_get_data_type (vala_variable_declarator_get_type_reference (decl))) && vala_data_type_get_takes_ownership (vala_variable_declarator_get_type_reference (decl))) {
					ValaMemberAccess* ma;
					ValaCCodeExpression* _tmp3;
					ValaCCodeIdentifier* _tmp2;
					char* _tmp1;
					found = TRUE;
					ma = vala_member_access_new_simple (vala_symbol_get_name (VALA_SYMBOL (decl)), NULL);
					vala_expression_set_symbol_reference (VALA_EXPRESSION (ma), VALA_SYMBOL (decl));
					_tmp3 = NULL;
					_tmp2 = NULL;
					_tmp1 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, (_tmp3 = vala_ccode_generator_get_unref_expression (self, VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_identifier_new ((_tmp1 = vala_ccode_generator_get_variable_cname (self, vala_symbol_get_name (VALA_SYMBOL (decl))))))), vala_variable_declarator_get_type_reference (decl), VALA_EXPRESSION (ma))));
					(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
					(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
					(_tmp1 = (g_free (_tmp1), NULL));
					(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
				}
				(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
			}
		}
		(decl_it == NULL ? NULL : (decl_it = (g_object_unref (decl_it), NULL)));
	}
	if (VALA_IS_BLOCK (vala_symbol_get_parent_symbol (sym))) {
		found = vala_ccode_generator_append_local_free_expr (self, vala_symbol_get_parent_symbol (sym), ccomma, stop_at_loop) || found;
	}
	return (_tmp4 = found, (b == NULL ? NULL : (b = (g_object_unref (b), NULL))), (local_vars == NULL ? NULL : (local_vars = (g_object_unref (local_vars), NULL))), _tmp4);
}


static void vala_ccode_generator_create_local_free_expr (ValaCCodeGenerator* self, ValaExpression* expr) {
	ValaVariableDeclarator* return_expr_decl;
	ValaCCodeCommaExpression* ccomma;
	ValaCCodeAssignment* _tmp1;
	ValaCCodeIdentifier* _tmp0;
	ValaCCodeIdentifier* _tmp2;
	g_return_if_fail (VALA_IS_CCODE_GENERATOR (self));
	g_return_if_fail (expr == NULL || VALA_IS_EXPRESSION (expr));
	return_expr_decl = vala_ccode_generator_get_temp_variable_declarator (self, vala_expression_get_static_type (expr), TRUE, VALA_CODE_NODE (expr));
	ccomma = vala_ccode_comma_expression_new ();
	_tmp1 = NULL;
	_tmp0 = NULL;
	vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp1 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp0 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (return_expr_decl))))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (expr))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
	(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	if (!vala_ccode_generator_append_local_free_expr (self, self->priv->current_symbol, ccomma, FALSE)) {
		(return_expr_decl == NULL ? NULL : (return_expr_decl = (g_object_unref (return_expr_decl), NULL)));
		(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
		return;
	}
	/* no local variables need to be freed */
	_tmp2 = NULL;
	vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (return_expr_decl))))));
	(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccomma));
	gee_collection_add (GEE_COLLECTION (expr->temp_vars), return_expr_decl);
	(return_expr_decl == NULL ? NULL : (return_expr_decl = (g_object_unref (return_expr_decl), NULL)));
	(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
}


static void vala_ccode_generator_real_visit_return_statement (ValaCodeVisitor* base, ValaReturnStatement* stmt) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (stmt == NULL || VALA_IS_RETURN_STATEMENT (stmt));
	if (vala_return_statement_get_return_expression (stmt) != NULL) {
		/* avoid unnecessary ref/unref pair*/
		if (vala_expression_get_ref_missing (vala_return_statement_get_return_expression (stmt)) && VALA_IS_VARIABLE_DECLARATOR (vala_expression_get_symbol_reference (vala_return_statement_get_return_expression (stmt)))) {
			ValaVariableDeclarator* _tmp0;
			ValaVariableDeclarator* decl;
			_tmp0 = NULL;
			decl = (_tmp0 = VALA_VARIABLE_DECLARATOR (vala_expression_get_symbol_reference (vala_return_statement_get_return_expression (stmt))), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
			if (vala_data_type_get_takes_ownership (vala_variable_declarator_get_type_reference (decl))) {
				/* return expression is local variable taking ownership and
				 * current method is transferring ownership */
				vala_expression_set_ref_sink (vala_return_statement_get_return_expression (stmt), TRUE);
				/* don't ref expression*/
				vala_expression_set_ref_missing (vala_return_statement_get_return_expression (stmt), FALSE);
			}
			(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
		}
	}
	vala_code_node_accept_children (VALA_CODE_NODE (stmt), VALA_CODE_VISITOR (self));
	if (vala_return_statement_get_return_expression (stmt) == NULL) {
		ValaCCodeReturnStatement* _tmp1;
		_tmp1 = NULL;
		vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((_tmp1 = vala_ccode_return_statement_new (NULL))));
		(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
		vala_ccode_generator_create_local_free (self, VALA_CODE_NODE (stmt), FALSE);
	} else {
		ValaSymbol* return_expression_symbol;
		ValaCCodeExpression* _tmp13;
		ValaCCodeReturnStatement* _tmp14;
		return_expression_symbol = NULL;
		/* avoid unnecessary ref/unref pair*/
		if (vala_expression_get_ref_sink (vala_return_statement_get_return_expression (stmt)) && VALA_IS_VARIABLE_DECLARATOR (vala_expression_get_symbol_reference (vala_return_statement_get_return_expression (stmt)))) {
			ValaVariableDeclarator* _tmp2;
			ValaVariableDeclarator* decl;
			_tmp2 = NULL;
			decl = (_tmp2 = VALA_VARIABLE_DECLARATOR (vala_expression_get_symbol_reference (vala_return_statement_get_return_expression (stmt))), (_tmp2 == NULL ? NULL : g_object_ref (_tmp2)));
			if (vala_data_type_get_takes_ownership (vala_variable_declarator_get_type_reference (decl))) {
				ValaSymbol* _tmp4;
				ValaVariableDeclarator* _tmp3;
				/* return expression is local variable taking ownership and
				 * current method is transferring ownership 
				 don't unref expression*/
				_tmp4 = NULL;
				_tmp3 = NULL;
				return_expression_symbol = (_tmp4 = VALA_SYMBOL ((_tmp3 = decl, (_tmp3 == NULL ? NULL : g_object_ref (_tmp3)))), (return_expression_symbol == NULL ? NULL : (return_expression_symbol = (g_object_unref (return_expression_symbol), NULL))), _tmp4);
				vala_symbol_set_active (return_expression_symbol, FALSE);
			}
			(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
		}
		/* return array length if appropriate*/
		if (self->priv->current_method != NULL && !vala_method_get_no_array_length (self->priv->current_method) && VALA_IS_ARRAY (vala_data_type_get_data_type (self->priv->current_return_type))) {
			ValaVariableDeclarator* return_expr_decl;
			ValaCCodeCommaExpression* ccomma;
			ValaCCodeAssignment* _tmp6;
			ValaCCodeIdentifier* _tmp5;
			ValaArray* _tmp7;
			ValaArray* arr;
			ValaCCodeIdentifier* _tmp12;
			return_expr_decl = vala_ccode_generator_get_temp_variable_declarator (self, vala_expression_get_static_type (vala_return_statement_get_return_expression (stmt)), TRUE, VALA_CODE_NODE (stmt));
			ccomma = vala_ccode_comma_expression_new ();
			_tmp6 = NULL;
			_tmp5 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp6 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (return_expr_decl))))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_return_statement_get_return_expression (stmt)))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
			(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
			(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
			_tmp7 = NULL;
			arr = (_tmp7 = VALA_ARRAY (vala_data_type_get_data_type (self->priv->current_return_type)), (_tmp7 == NULL ? NULL : g_object_ref (_tmp7)));
			{
				gint dim;
				dim = 0;
				for (dim = 1; dim <= vala_array_get_rank (arr); dim++) {
					ValaCCodeIdentifier* _tmp9;
					char* _tmp8;
					ValaCCodeUnaryExpression* _tmp10;
					ValaCCodeUnaryExpression* len_l;
					ValaCCodeExpression* len_r;
					ValaCCodeAssignment* _tmp11;
					_tmp9 = NULL;
					_tmp8 = NULL;
					_tmp10 = NULL;
					len_l = (_tmp10 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, VALA_CCODE_EXPRESSION ((_tmp9 = vala_ccode_identifier_new ((_tmp8 = vala_ccode_generator_get_array_length_cname (self, "result", dim)))))), (_tmp9 == NULL ? NULL : (_tmp9 = (g_object_unref (_tmp9), NULL))), (_tmp8 = (g_free (_tmp8), NULL)), _tmp10);
					len_r = vala_ccode_generator_get_array_length_cexpression (self, vala_return_statement_get_return_expression (stmt), dim);
					_tmp11 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp11 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (len_l), len_r, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
					(_tmp11 == NULL ? NULL : (_tmp11 = (g_object_unref (_tmp11), NULL)));
					(len_l == NULL ? NULL : (len_l = (g_object_unref (len_l), NULL)));
					(len_r == NULL ? NULL : (len_r = (g_object_unref (len_r), NULL)));
				}
			}
			_tmp12 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp12 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (return_expr_decl))))));
			(_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL)));
			vala_code_node_set_ccodenode (VALA_CODE_NODE (vala_return_statement_get_return_expression (stmt)), VALA_CCODE_NODE (ccomma));
			gee_collection_add (GEE_COLLECTION (vala_return_statement_get_return_expression (stmt)->temp_vars), return_expr_decl);
			(return_expr_decl == NULL ? NULL : (return_expr_decl = (g_object_unref (return_expr_decl), NULL)));
			(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
			(arr == NULL ? NULL : (arr = (g_object_unref (arr), NULL)));
		}
		vala_ccode_generator_create_local_free_expr (self, vala_return_statement_get_return_expression (stmt));
		_tmp13 = NULL;
		vala_code_node_set_ccodenode (VALA_CODE_NODE (vala_return_statement_get_return_expression (stmt)), VALA_CCODE_NODE ((_tmp13 = vala_ccode_generator_get_implicit_cast_expression (self, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_return_statement_get_return_expression (stmt)))), vala_expression_get_static_type (vala_return_statement_get_return_expression (stmt)), self->priv->current_return_type))));
		(_tmp13 == NULL ? NULL : (_tmp13 = (g_object_unref (_tmp13), NULL)));
		_tmp14 = NULL;
		vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((_tmp14 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_return_statement_get_return_expression (stmt))))))));
		(_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL)));
		vala_ccode_generator_create_temp_decl (self, VALA_STATEMENT (stmt), GEE_COLLECTION (vala_return_statement_get_return_expression (stmt)->temp_vars));
		if (return_expression_symbol != NULL) {
			vala_symbol_set_active (return_expression_symbol, TRUE);
		}
		(return_expression_symbol == NULL ? NULL : (return_expression_symbol = (g_object_unref (return_expression_symbol), NULL)));
	}
}


static void vala_ccode_generator_real_visit_throw_statement (ValaCodeVisitor* base, ValaThrowStatement* stmt) {
	ValaCCodeGenerator * self;
	ValaCCodeFragment* cfrag;
	ValaCCodeExpressionStatement* _tmp0;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (stmt == NULL || VALA_IS_THROW_STATEMENT (stmt));
	vala_code_node_accept_children (VALA_CODE_NODE (stmt), VALA_CODE_VISITOR (self));
	cfrag = vala_ccode_fragment_new ();
	/* declare temporary objects */
	vala_ccode_generator_append_temp_decl (self, cfrag, GEE_COLLECTION (self->temp_vars));
	_tmp0 = NULL;
	vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((_tmp0 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_throw_statement_get_error_expression (stmt))))))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	{
		GeeArrayList* decl_collection;
		GeeIterator* decl_it;
		decl_collection = self->priv->temp_ref_vars;
		decl_it = gee_iterable_iterator (GEE_ITERABLE (decl_collection));
		while (gee_iterator_next (decl_it)) {
			ValaVariableDeclarator* decl;
			decl = gee_iterator_get (decl_it);
			{
				ValaMemberAccess* ma;
				ValaCCodeExpressionStatement* _tmp3;
				ValaCCodeExpression* _tmp2;
				ValaCCodeIdentifier* _tmp1;
				/* free temporary objects */
				ma = vala_member_access_new_simple (vala_symbol_get_name (VALA_SYMBOL (decl)), NULL);
				vala_expression_set_symbol_reference (VALA_EXPRESSION (ma), VALA_SYMBOL (decl));
				_tmp3 = NULL;
				_tmp2 = NULL;
				_tmp1 = NULL;
				vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((_tmp3 = vala_ccode_expression_statement_new ((_tmp2 = vala_ccode_generator_get_unref_expression (self, VALA_CCODE_EXPRESSION ((_tmp1 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (decl))))), vala_variable_declarator_get_type_reference (decl), VALA_EXPRESSION (ma)))))));
				(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
				(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
				(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
				(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
				(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
			}
		}
		(decl_it == NULL ? NULL : (decl_it = (g_object_unref (decl_it), NULL)));
	}
	gee_collection_clear (GEE_COLLECTION (self->temp_vars));
	gee_collection_clear (GEE_COLLECTION (self->priv->temp_ref_vars));
	if (self->priv->current_return_type != NULL && vala_data_type_get_data_type (self->priv->current_return_type) != NULL) {
		ValaCCodeReturnStatement* _tmp5;
		ValaCCodeExpression* _tmp4;
		_tmp5 = NULL;
		_tmp4 = NULL;
		vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((_tmp5 = vala_ccode_return_statement_new ((_tmp4 = vala_ccode_generator_default_value_for_type (self, self->priv->current_return_type))))));
		(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
		(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
	} else {
		ValaCCodeReturnStatement* _tmp6;
		_tmp6 = NULL;
		vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((_tmp6 = vala_ccode_return_statement_new (NULL))));
		(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
	}
	vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE (cfrag));
	(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
}


static void vala_ccode_generator_real_visit_try_statement (ValaCodeVisitor* base, ValaTryStatement* stmt) {
	ValaCCodeGenerator * self;
	ValaTryStatement* _tmp0;
	ValaTryStatement* old_try;
	gint old_try_id;
	ValaTryStatement* _tmp2;
	ValaTryStatement* _tmp1;
	ValaCCodeFragment* cfrag;
	ValaCCodeLabel* _tmp6;
	char* _tmp5;
	ValaTryStatement* _tmp9;
	ValaTryStatement* _tmp8;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (stmt == NULL || VALA_IS_TRY_STATEMENT (stmt));
	_tmp0 = NULL;
	old_try = (_tmp0 = self->priv->current_try, (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	old_try_id = self->priv->current_try_id;
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->current_try = (_tmp2 = (_tmp1 = stmt, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->current_try == NULL ? NULL : (self->priv->current_try = (g_object_unref (self->priv->current_try), NULL))), _tmp2);
	self->priv->current_try_id = self->priv->next_try_id++;
	vala_code_node_accept_children (VALA_CODE_NODE (stmt), VALA_CODE_VISITOR (self));
	cfrag = vala_ccode_fragment_new ();
	vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_try_statement_get_body (stmt))));
	{
		GeeCollection* clause_collection;
		GeeIterator* clause_it;
		clause_collection = vala_try_statement_get_catch_clauses (stmt);
		clause_it = gee_iterable_iterator (GEE_ITERABLE (clause_collection));
		while (gee_iterator_next (clause_it)) {
			ValaCatchClause* clause;
			clause = gee_iterator_get (clause_it);
			{
				ValaCCodeGotoStatement* _tmp4;
				char* _tmp3;
				_tmp4 = NULL;
				_tmp3 = NULL;
				vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((_tmp4 = vala_ccode_goto_statement_new ((_tmp3 = g_strdup_printf ("__finally%d", self->priv->current_try_id))))));
				(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
				(_tmp3 = (g_free (_tmp3), NULL));
				vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode (VALA_CODE_NODE (clause)));
				(clause == NULL ? NULL : (clause = (g_object_unref (clause), NULL)));
			}
		}
		(clause_collection == NULL ? NULL : (clause_collection = (g_object_unref (clause_collection), NULL)));
		(clause_it == NULL ? NULL : (clause_it = (g_object_unref (clause_it), NULL)));
	}
	_tmp6 = NULL;
	_tmp5 = NULL;
	vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((_tmp6 = vala_ccode_label_new ((_tmp5 = g_strdup_printf ("__finally%d", self->priv->current_try_id))))));
	(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
	(_tmp5 = (g_free (_tmp5), NULL));
	if (vala_try_statement_get_finally_body (stmt) != NULL) {
		vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_try_statement_get_finally_body (stmt))));
	} else {
		ValaCCodeEmptyStatement* _tmp7;
		/* avoid gcc error: label at end of compound statement*/
		_tmp7 = NULL;
		vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((_tmp7 = vala_ccode_empty_statement_new ())));
		(_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL)));
	}
	vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE (cfrag));
	_tmp9 = NULL;
	_tmp8 = NULL;
	self->priv->current_try = (_tmp9 = (_tmp8 = old_try, (_tmp8 == NULL ? NULL : g_object_ref (_tmp8))), (self->priv->current_try == NULL ? NULL : (self->priv->current_try = (g_object_unref (self->priv->current_try), NULL))), _tmp9);
	self->priv->current_try_id = old_try_id;
	(old_try == NULL ? NULL : (old_try = (g_object_unref (old_try), NULL)));
	(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
}


static void vala_ccode_generator_real_visit_catch_clause (ValaCodeVisitor* base, ValaCatchClause* clause) {
	ValaCCodeGenerator * self;
	ValaCCodeFragment* cfrag;
	ValaCCodeLabel* _tmp2;
	char* _tmp1;
	char* _tmp0;
	ValaCCodeBlock* cblock;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeVariableDeclarator* _tmp4;
	ValaCCodeIdentifier* _tmp3;
	ValaCCodeExpressionStatement* _tmp8;
	ValaCCodeAssignment* _tmp7;
	ValaCCodeConstant* _tmp6;
	ValaCCodeIdentifier* _tmp5;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (clause == NULL || VALA_IS_CATCH_CLAUSE (clause));
	vala_code_node_accept_children (VALA_CODE_NODE (clause), VALA_CODE_VISITOR (self));
	cfrag = vala_ccode_fragment_new ();
	_tmp2 = NULL;
	_tmp1 = NULL;
	_tmp0 = NULL;
	vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((_tmp2 = vala_ccode_label_new ((_tmp1 = g_strdup_printf ("__catch%d_%s", self->priv->current_try_id, (_tmp0 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (vala_data_type_get_data_type (vala_catch_clause_get_type_reference (clause))), NULL))))))));
	(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
	(_tmp1 = (g_free (_tmp1), NULL));
	(_tmp0 = (g_free (_tmp0), NULL));
	cblock = vala_ccode_block_new ();
	cdecl_ = vala_ccode_declaration_new ("GError *");
	_tmp4 = NULL;
	_tmp3 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp4 = vala_ccode_variable_declarator_new_with_initializer (vala_catch_clause_get_variable_name (clause), VALA_CCODE_EXPRESSION ((_tmp3 = vala_ccode_identifier_new ("inner_error")))))));
	(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
	(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cdecl_));
	_tmp8 = NULL;
	_tmp7 = NULL;
	_tmp6 = NULL;
	_tmp5 = NULL;
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((_tmp8 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp7 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_identifier_new ("inner_error"))), VALA_CCODE_EXPRESSION ((_tmp6 = vala_ccode_constant_new ("NULL"))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
	(_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL)));
	(_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL)));
	(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
	(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
	vala_ccode_block_add_statement (cblock, vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_catch_clause_get_body (clause))));
	vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE (cblock));
	vala_code_node_set_ccodenode (VALA_CODE_NODE (clause), VALA_CCODE_NODE (cfrag));
	(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
	(cblock == NULL ? NULL : (cblock = (g_object_unref (cblock), NULL)));
	(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
}


static char* vala_ccode_generator_get_symbol_lock_name (ValaCCodeGenerator* self, ValaSymbol* sym) {
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	g_return_val_if_fail (sym == NULL || VALA_IS_SYMBOL (sym), NULL);
	return g_strdup_printf ("__lock_%s", vala_symbol_get_name (sym));
}


/**
 * Visit operation called for lock statements.
 *
 * @param stmt a lock statement
 */
static void vala_ccode_generator_real_visit_lock_statement (ValaCodeVisitor* base, ValaLockStatement* stmt) {
	ValaCCodeGenerator * self;
	ValaCCodeFragment* cn;
	ValaCCodeExpression* l;
	ValaCCodeFunctionCall* fc;
	ValaExpression* _tmp0;
	ValaExpression* inner_node;
	ValaCCodeExpression* _tmp7;
	char* _tmp6;
	ValaCCodeMemberAccess* _tmp5;
	ValaCCodeFunctionCall* _tmp11;
	ValaCCodeIdentifier* _tmp10;
	char* _tmp9;
	ValaMethod* _tmp8;
	ValaCCodeExpressionStatement* _tmp12;
	ValaCCodeFunctionCall* _tmp16;
	ValaCCodeIdentifier* _tmp15;
	char* _tmp14;
	ValaMethod* _tmp13;
	ValaCCodeExpressionStatement* _tmp17;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (stmt == NULL || VALA_IS_LOCK_STATEMENT (stmt));
	cn = vala_ccode_fragment_new ();
	l = NULL;
	fc = NULL;
	_tmp0 = NULL;
	inner_node = (_tmp0 = vala_member_access_get_inner ((VALA_MEMBER_ACCESS (vala_lock_statement_get_resource (stmt)))), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	if (inner_node == NULL) {
		ValaCCodeExpression* _tmp1;
		_tmp1 = NULL;
		l = (_tmp1 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("self")), (l == NULL ? NULL : (l = (g_object_unref (l), NULL))), _tmp1);
	} else {
		if (vala_symbol_get_parent_symbol (vala_expression_get_symbol_reference (vala_lock_statement_get_resource (stmt))) != VALA_SYMBOL (self->current_type_symbol)) {
			ValaCCodeExpression* _tmp2;
			_tmp2 = NULL;
			l = (_tmp2 = VALA_CCODE_EXPRESSION (vala_instance_cast_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (inner_node))), VALA_TYPESYMBOL (vala_symbol_get_parent_symbol (vala_expression_get_symbol_reference (vala_lock_statement_get_resource (stmt)))))), (l == NULL ? NULL : (l = (g_object_unref (l), NULL))), _tmp2);
		} else {
			ValaCCodeExpression* _tmp4;
			ValaCCodeExpression* _tmp3;
			_tmp4 = NULL;
			_tmp3 = NULL;
			l = (_tmp4 = (_tmp3 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (inner_node))), (_tmp3 == NULL ? NULL : g_object_ref (_tmp3))), (l == NULL ? NULL : (l = (g_object_unref (l), NULL))), _tmp4);
		}
	}
	_tmp7 = NULL;
	_tmp6 = NULL;
	_tmp5 = NULL;
	l = (_tmp7 = VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_member_access_new_pointer (l, "priv"))), (_tmp6 = vala_ccode_generator_get_symbol_lock_name (self, vala_expression_get_symbol_reference (vala_lock_statement_get_resource (stmt)))))), (l == NULL ? NULL : (l = (g_object_unref (l), NULL))), _tmp7);
	(_tmp6 = (g_free (_tmp6), NULL));
	(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
	_tmp11 = NULL;
	_tmp10 = NULL;
	_tmp9 = NULL;
	_tmp8 = NULL;
	fc = (_tmp11 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp10 = vala_ccode_identifier_new ((_tmp9 = vala_method_get_cname ((_tmp8 = (VALA_METHOD (vala_scope_lookup (vala_symbol_get_scope (VALA_SYMBOL (vala_data_type_get_data_type (self->mutex_type))), "lock")))))))))), (fc == NULL ? NULL : (fc = (g_object_unref (fc), NULL))), _tmp11);
	(_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL)));
	(_tmp9 = (g_free (_tmp9), NULL));
	(_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL)));
	vala_ccode_function_call_add_argument (fc, l);
	_tmp12 = NULL;
	vala_ccode_fragment_append (cn, VALA_CCODE_NODE ((_tmp12 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (fc)))));
	(_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL)));
	vala_ccode_fragment_append (cn, vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_lock_statement_get_body (stmt))));
	_tmp16 = NULL;
	_tmp15 = NULL;
	_tmp14 = NULL;
	_tmp13 = NULL;
	fc = (_tmp16 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp15 = vala_ccode_identifier_new ((_tmp14 = vala_method_get_cname ((_tmp13 = (VALA_METHOD (vala_scope_lookup (vala_symbol_get_scope (VALA_SYMBOL (vala_data_type_get_data_type (self->mutex_type))), "unlock")))))))))), (fc == NULL ? NULL : (fc = (g_object_unref (fc), NULL))), _tmp16);
	(_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL)));
	(_tmp14 = (g_free (_tmp14), NULL));
	(_tmp13 == NULL ? NULL : (_tmp13 = (g_object_unref (_tmp13), NULL)));
	vala_ccode_function_call_add_argument (fc, l);
	_tmp17 = NULL;
	vala_ccode_fragment_append (cn, VALA_CCODE_NODE ((_tmp17 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (fc)))));
	(_tmp17 == NULL ? NULL : (_tmp17 = (g_object_unref (_tmp17), NULL)));
	vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE (cn));
	(cn == NULL ? NULL : (cn = (g_object_unref (cn), NULL)));
	(l == NULL ? NULL : (l = (g_object_unref (l), NULL)));
	(fc == NULL ? NULL : (fc = (g_object_unref (fc), NULL)));
	(inner_node == NULL ? NULL : (inner_node = (g_object_unref (inner_node), NULL)));
}


static void vala_ccode_generator_real_visit_array_creation_expression (ValaCodeVisitor* base, ValaArrayCreationExpression* expr) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (expr == NULL || VALA_IS_ARRAY_CREATION_EXPRESSION (expr));
	vala_code_binding_emit (vala_code_node_get_code_binding (VALA_CODE_NODE (expr)));
}


static void vala_ccode_generator_real_visit_boolean_literal (ValaCodeVisitor* base, ValaBooleanLiteral* expr) {
	ValaCCodeGenerator * self;
	ValaCCodeConstant* _tmp0;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (expr == NULL || VALA_IS_BOOLEAN_LITERAL (expr));
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp0 = vala_ccode_constant_new ((vala_boolean_literal_get_value (expr) ? "TRUE" : "FALSE")))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
}


static void vala_ccode_generator_real_visit_character_literal (ValaCodeVisitor* base, ValaCharacterLiteral* expr) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (expr == NULL || VALA_IS_CHARACTER_LITERAL (expr));
	if (vala_character_literal_get_char (expr) >= 0x20 && vala_character_literal_get_char (expr) < 0x80) {
		ValaCCodeConstant* _tmp0;
		_tmp0 = NULL;
		vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp0 = vala_ccode_constant_new (vala_character_literal_get_value (expr)))));
		(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	} else {
		ValaCCodeConstant* _tmp2;
		char* _tmp1;
		_tmp2 = NULL;
		_tmp1 = NULL;
		vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp2 = vala_ccode_constant_new ((_tmp1 = g_strdup_printf ("%uU", vala_character_literal_get_char (expr)))))));
		(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
		(_tmp1 = (g_free (_tmp1), NULL));
	}
}


static void vala_ccode_generator_real_visit_integer_literal (ValaCodeVisitor* base, ValaIntegerLiteral* expr) {
	ValaCCodeGenerator * self;
	ValaCCodeConstant* _tmp0;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (expr == NULL || VALA_IS_INTEGER_LITERAL (expr));
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp0 = vala_ccode_constant_new (vala_integer_literal_get_value (expr)))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
}


static void vala_ccode_generator_real_visit_real_literal (ValaCodeVisitor* base, ValaRealLiteral* expr) {
	ValaCCodeGenerator * self;
	ValaCCodeConstant* _tmp0;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (expr == NULL || VALA_IS_REAL_LITERAL (expr));
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp0 = vala_ccode_constant_new (vala_real_literal_get_value (expr)))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
}


static void vala_ccode_generator_real_visit_string_literal (ValaCodeVisitor* base, ValaStringLiteral* expr) {
	ValaCCodeGenerator * self;
	ValaCCodeConstant* _tmp0;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (expr == NULL || VALA_IS_STRING_LITERAL (expr));
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp0 = vala_ccode_constant_new (vala_string_literal_get_value (expr)))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
}


static void vala_ccode_generator_real_visit_null_literal (ValaCodeVisitor* base, ValaNullLiteral* expr) {
	ValaCCodeGenerator * self;
	ValaCCodeConstant* _tmp0;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (expr == NULL || VALA_IS_NULL_LITERAL (expr));
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp0 = vala_ccode_constant_new ("NULL"))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
}


static void vala_ccode_generator_real_visit_literal_expression (ValaCodeVisitor* base, ValaLiteralExpression* expr) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (expr == NULL || VALA_IS_LITERAL_EXPRESSION (expr));
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_literal_expression_get_literal (expr))));
	vala_ccode_generator_visit_expression (self, VALA_EXPRESSION (expr));
}


static void vala_ccode_generator_real_visit_parenthesized_expression (ValaCodeVisitor* base, ValaParenthesizedExpression* expr) {
	ValaCCodeGenerator * self;
	ValaCCodeParenthesizedExpression* _tmp0;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (expr == NULL || VALA_IS_PARENTHESIZED_EXPRESSION (expr));
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp0 = vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_parenthesized_expression_get_inner (expr))))))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	vala_ccode_generator_visit_expression (self, VALA_EXPRESSION (expr));
}


static char* vala_ccode_generator_get_array_length_cname (ValaCCodeGenerator* self, const char* array_cname, gint dim) {
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	return g_strdup_printf ("%s_length%d", array_cname, dim);
}


ValaCCodeExpression* vala_ccode_generator_get_array_length_cexpression (ValaCCodeGenerator* self, ValaExpression* array_expr, gint dim) {
	gboolean is_out;
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	g_return_val_if_fail (array_expr == NULL || VALA_IS_EXPRESSION (array_expr), NULL);
	is_out = FALSE;
	if (VALA_IS_UNARY_EXPRESSION (array_expr)) {
		ValaUnaryExpression* _tmp0;
		ValaUnaryExpression* unary_expr;
		_tmp0 = NULL;
		unary_expr = (_tmp0 = VALA_UNARY_EXPRESSION (array_expr), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
		if (vala_unary_expression_get_operator (unary_expr) == VALA_UNARY_OPERATOR_OUT || vala_unary_expression_get_operator (unary_expr) == VALA_UNARY_OPERATOR_REF) {
			array_expr = vala_unary_expression_get_inner (unary_expr);
			is_out = TRUE;
		}
		(unary_expr == NULL ? NULL : (unary_expr = (g_object_unref (unary_expr), NULL)));
	} else {
		if (VALA_IS_REFERENCE_TRANSFER_EXPRESSION (array_expr)) {
			ValaReferenceTransferExpression* _tmp1;
			ValaReferenceTransferExpression* reftransfer_expr;
			_tmp1 = NULL;
			reftransfer_expr = (_tmp1 = VALA_REFERENCE_TRANSFER_EXPRESSION (array_expr), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
			array_expr = vala_reference_transfer_expression_get_inner (reftransfer_expr);
			(reftransfer_expr == NULL ? NULL : (reftransfer_expr = (g_object_unref (reftransfer_expr), NULL)));
		}
	}
	if (VALA_IS_ARRAY_CREATION_EXPRESSION (array_expr)) {
		GeeList* size;
		ValaExpression* length_expr;
		ValaCCodeExpression* _tmp2;
		ValaCCodeExpression* _tmp3;
		size = vala_array_creation_expression_get_sizes ((VALA_ARRAY_CREATION_EXPRESSION (array_expr)));
		length_expr = gee_list_get (((GeeList*) size), dim - 1);
		_tmp2 = NULL;
		_tmp3 = NULL;
		return (_tmp3 = (_tmp2 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (length_expr))), (_tmp2 == NULL ? NULL : g_object_ref (_tmp2))), (size == NULL ? NULL : (size = (g_object_unref (size), NULL))), (length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL))), _tmp3);
	} else {
		if (VALA_IS_INVOCATION_EXPRESSION (array_expr)) {
			ValaInvocationExpression* _tmp4;
			ValaInvocationExpression* invocation_expr;
			GeeList* size;
			ValaCCodeExpression* _tmp5;
			_tmp4 = NULL;
			invocation_expr = (_tmp4 = VALA_INVOCATION_EXPRESSION (array_expr), (_tmp4 == NULL ? NULL : g_object_ref (_tmp4)));
			size = vala_invocation_expression_get_array_sizes (invocation_expr);
			_tmp5 = NULL;
			return (_tmp5 = gee_list_get (((GeeList*) size), dim - 1), (invocation_expr == NULL ? NULL : (invocation_expr = (g_object_unref (invocation_expr), NULL))), (size == NULL ? NULL : (size = (g_object_unref (size), NULL))), _tmp5);
		} else {
			if (vala_expression_get_symbol_reference (array_expr) != NULL) {
				if (VALA_IS_FORMAL_PARAMETER (vala_expression_get_symbol_reference (array_expr))) {
					ValaFormalParameter* _tmp6;
					ValaFormalParameter* param;
					_tmp6 = NULL;
					param = (_tmp6 = VALA_FORMAL_PARAMETER (vala_expression_get_symbol_reference (array_expr)), (_tmp6 == NULL ? NULL : g_object_ref (_tmp6)));
					if (!vala_formal_parameter_get_no_array_length (param)) {
						char* _tmp7;
						ValaCCodeIdentifier* _tmp8;
						ValaCCodeExpression* length_expr;
						_tmp7 = NULL;
						_tmp8 = NULL;
						length_expr = VALA_CCODE_EXPRESSION ((_tmp8 = vala_ccode_identifier_new ((_tmp7 = vala_ccode_generator_get_array_length_cname (self, vala_symbol_get_name (VALA_SYMBOL (param)), dim))), (_tmp7 = (g_free (_tmp7), NULL)), _tmp8));
						if (vala_data_type_get_is_out (vala_formal_parameter_get_type_reference (param)) || vala_data_type_get_is_ref (vala_formal_parameter_get_type_reference (param))) {
							ValaCCodeExpression* _tmp10;
							ValaCCodeUnaryExpression* _tmp9;
							/* accessing argument of out/ref param*/
							_tmp10 = NULL;
							_tmp9 = NULL;
							length_expr = (_tmp10 = VALA_CCODE_EXPRESSION (vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION ((_tmp9 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, length_expr))))), (length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL))), _tmp10);
							(_tmp9 == NULL ? NULL : (_tmp9 = (g_object_unref (_tmp9), NULL)));
						}
						if (is_out) {
							ValaCCodeUnaryExpression* _tmp11;
							_tmp11 = NULL;
							return VALA_CCODE_EXPRESSION ((_tmp11 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, length_expr), (length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL))), (param == NULL ? NULL : (param = (g_object_unref (param), NULL))), _tmp11));
						} else {
							ValaCCodeExpression* _tmp12;
							_tmp12 = NULL;
							return (_tmp12 = length_expr, (param == NULL ? NULL : (param = (g_object_unref (param), NULL))), _tmp12);
						}
						(length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL)));
					}
					(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
				} else {
					/* passing array as out/ref*/
					if (VALA_IS_VARIABLE_DECLARATOR (vala_expression_get_symbol_reference (array_expr))) {
						ValaVariableDeclarator* _tmp13;
						ValaVariableDeclarator* decl;
						char* _tmp14;
						ValaCCodeIdentifier* _tmp15;
						ValaCCodeIdentifier* length_expr;
						_tmp13 = NULL;
						decl = (_tmp13 = VALA_VARIABLE_DECLARATOR (vala_expression_get_symbol_reference (array_expr)), (_tmp13 == NULL ? NULL : g_object_ref (_tmp13)));
						_tmp14 = NULL;
						_tmp15 = NULL;
						length_expr = (_tmp15 = vala_ccode_identifier_new ((_tmp14 = vala_ccode_generator_get_array_length_cname (self, vala_symbol_get_name (VALA_SYMBOL (decl)), dim))), (_tmp14 = (g_free (_tmp14), NULL)), _tmp15);
						if (is_out) {
							ValaCCodeUnaryExpression* _tmp16;
							_tmp16 = NULL;
							return VALA_CCODE_EXPRESSION ((_tmp16 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (length_expr)), (decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL))), (length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL))), _tmp16));
						} else {
							ValaCCodeIdentifier* _tmp17;
							_tmp17 = NULL;
							return VALA_CCODE_EXPRESSION ((_tmp17 = length_expr, (decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL))), _tmp17));
						}
						(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
						(length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL)));
					} else {
						if (VALA_IS_FIELD (vala_expression_get_symbol_reference (array_expr))) {
							ValaField* _tmp18;
							ValaField* field;
							_tmp18 = NULL;
							field = (_tmp18 = VALA_FIELD (vala_expression_get_symbol_reference (array_expr)), (_tmp18 == NULL ? NULL : g_object_ref (_tmp18)));
							if (!vala_field_get_no_array_length (field)) {
								char* length_cname;
								ValaMemberAccess* _tmp19;
								ValaMemberAccess* ma;
								ValaCCodeExpression* pub_inst;
								ValaTypesymbol* base_type;
								ValaCCodeExpression* length_expr;
								length_cname = vala_ccode_generator_get_array_length_cname (self, vala_symbol_get_name (VALA_SYMBOL (field)), dim);
								_tmp19 = NULL;
								ma = (_tmp19 = VALA_MEMBER_ACCESS (array_expr), (_tmp19 == NULL ? NULL : g_object_ref (_tmp19)));
								pub_inst = NULL;
								base_type = NULL;
								length_expr = NULL;
								if (vala_member_access_get_inner (ma) == NULL) {
									ValaCCodeExpression* _tmp20;
									_tmp20 = NULL;
									pub_inst = (_tmp20 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("self")), (pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL))), _tmp20);
									if (self->current_type_symbol != NULL) {
										ValaTypesymbol* _tmp22;
										ValaTypesymbol* _tmp21;
										/* base type is available if this is a type method */
										_tmp22 = NULL;
										_tmp21 = NULL;
										base_type = (_tmp22 = (_tmp21 = VALA_TYPESYMBOL (self->current_type_symbol), (_tmp21 == NULL ? NULL : g_object_ref (_tmp21))), (base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL))), _tmp22);
									}
								} else {
									ValaCCodeExpression* _tmp24;
									ValaCCodeExpression* _tmp23;
									_tmp24 = NULL;
									_tmp23 = NULL;
									pub_inst = (_tmp24 = (_tmp23 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_member_access_get_inner (ma)))), (_tmp23 == NULL ? NULL : g_object_ref (_tmp23))), (pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL))), _tmp24);
									if (vala_expression_get_static_type (vala_member_access_get_inner (ma)) != NULL) {
										ValaTypesymbol* _tmp26;
										ValaTypesymbol* _tmp25;
										_tmp26 = NULL;
										_tmp25 = NULL;
										base_type = (_tmp26 = (_tmp25 = vala_data_type_get_data_type (vala_expression_get_static_type (vala_member_access_get_inner (ma))), (_tmp25 == NULL ? NULL : g_object_ref (_tmp25))), (base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL))), _tmp26);
									}
								}
								if (vala_field_get_instance (field)) {
									ValaDataType* instance_expression_type;
									ValaDataType* instance_target_type;
									ValaCCodeExpression* typed_inst;
									ValaCCodeExpression* inst;
									instance_expression_type = vala_data_type_new ();
									vala_data_type_set_data_type (instance_expression_type, base_type);
									instance_target_type = vala_data_type_new ();
									vala_data_type_set_data_type (instance_target_type, VALA_TYPESYMBOL (vala_symbol_get_parent_symbol (VALA_SYMBOL (field))));
									typed_inst = vala_ccode_generator_get_implicit_cast_expression (self, pub_inst, instance_expression_type, instance_target_type);
									inst = NULL;
									if (vala_symbol_get_access (VALA_SYMBOL (field)) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
										ValaCCodeExpression* _tmp27;
										_tmp27 = NULL;
										inst = (_tmp27 = VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (typed_inst, "priv")), (inst == NULL ? NULL : (inst = (g_object_unref (inst), NULL))), _tmp27);
									} else {
										ValaCCodeExpression* _tmp29;
										ValaCCodeExpression* _tmp28;
										_tmp29 = NULL;
										_tmp28 = NULL;
										inst = (_tmp29 = (_tmp28 = typed_inst, (_tmp28 == NULL ? NULL : g_object_ref (_tmp28))), (inst == NULL ? NULL : (inst = (g_object_unref (inst), NULL))), _tmp29);
									}
									if (vala_typesymbol_is_reference_type ((VALA_TYPESYMBOL (vala_symbol_get_parent_symbol (VALA_SYMBOL (field)))))) {
										ValaCCodeExpression* _tmp30;
										_tmp30 = NULL;
										length_expr = (_tmp30 = VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (inst, length_cname)), (length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL))), _tmp30);
									} else {
										ValaCCodeExpression* _tmp31;
										_tmp31 = NULL;
										length_expr = (_tmp31 = VALA_CCODE_EXPRESSION (vala_ccode_member_access_new (inst, length_cname, FALSE)), (length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL))), _tmp31);
									}
									(instance_expression_type == NULL ? NULL : (instance_expression_type = (g_object_unref (instance_expression_type), NULL)));
									(instance_target_type == NULL ? NULL : (instance_target_type = (g_object_unref (instance_target_type), NULL)));
									(typed_inst == NULL ? NULL : (typed_inst = (g_object_unref (typed_inst), NULL)));
									(inst == NULL ? NULL : (inst = (g_object_unref (inst), NULL)));
								} else {
									ValaCCodeExpression* _tmp32;
									_tmp32 = NULL;
									length_expr = (_tmp32 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (length_cname)), (length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL))), _tmp32);
								}
								if (is_out) {
									ValaCCodeUnaryExpression* _tmp33;
									_tmp33 = NULL;
									return VALA_CCODE_EXPRESSION ((_tmp33 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, length_expr), (length_cname = (g_free (length_cname), NULL)), (ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL))), (pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL))), (base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL))), (length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL))), (field == NULL ? NULL : (field = (g_object_unref (field), NULL))), _tmp33));
								} else {
									ValaCCodeExpression* _tmp34;
									_tmp34 = NULL;
									return (_tmp34 = length_expr, (length_cname = (g_free (length_cname), NULL)), (ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL))), (pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL))), (base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL))), (field == NULL ? NULL : (field = (g_object_unref (field), NULL))), _tmp34);
								}
								(length_cname = (g_free (length_cname), NULL));
								(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
								(pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL)));
								(base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL)));
								(length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL)));
							}
							(field == NULL ? NULL : (field = (g_object_unref (field), NULL)));
						}
					}
				}
			}
		}
	}
	if (!is_out) {
		return VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("-1"));
	} else {
		return VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL"));
	}
}


/* allow arrays with unknown length even for value types
 * as else it may be impossible to bind some libraries
 * users of affected libraries should explicitly set
 * the array length as early as possible
 * by setting the virtual length field of the array
 */
static char* vala_ccode_generator_get_delegate_target_cname (ValaCCodeGenerator* self, const char* delegate_cname) {
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	return g_strdup_printf ("%s_target", delegate_cname);
}


ValaCCodeExpression* vala_ccode_generator_get_delegate_target_cexpression (ValaCCodeGenerator* self, ValaExpression* delegate_expr) {
	gboolean is_out;
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	g_return_val_if_fail (delegate_expr == NULL || VALA_IS_EXPRESSION (delegate_expr), NULL);
	is_out = FALSE;
	if (VALA_IS_UNARY_EXPRESSION (delegate_expr)) {
		ValaUnaryExpression* _tmp0;
		ValaUnaryExpression* unary_expr;
		_tmp0 = NULL;
		unary_expr = (_tmp0 = VALA_UNARY_EXPRESSION (delegate_expr), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
		if (vala_unary_expression_get_operator (unary_expr) == VALA_UNARY_OPERATOR_OUT || vala_unary_expression_get_operator (unary_expr) == VALA_UNARY_OPERATOR_REF) {
			delegate_expr = vala_unary_expression_get_inner (unary_expr);
			is_out = TRUE;
		}
		(unary_expr == NULL ? NULL : (unary_expr = (g_object_unref (unary_expr), NULL)));
	}
	if (VALA_IS_INVOCATION_EXPRESSION (delegate_expr)) {
		ValaInvocationExpression* _tmp1;
		ValaInvocationExpression* invocation_expr;
		ValaCCodeExpression* _tmp2;
		ValaCCodeExpression* _tmp3;
		_tmp1 = NULL;
		invocation_expr = (_tmp1 = VALA_INVOCATION_EXPRESSION (delegate_expr), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
		_tmp2 = NULL;
		_tmp3 = NULL;
		return (_tmp3 = (_tmp2 = vala_invocation_expression_get_delegate_target (invocation_expr), (_tmp2 == NULL ? NULL : g_object_ref (_tmp2))), (invocation_expr == NULL ? NULL : (invocation_expr = (g_object_unref (invocation_expr), NULL))), _tmp3);
	} else {
		if (vala_expression_get_symbol_reference (delegate_expr) != NULL) {
			if (VALA_IS_FORMAL_PARAMETER (vala_expression_get_symbol_reference (delegate_expr))) {
				ValaFormalParameter* _tmp4;
				ValaFormalParameter* param;
				char* _tmp5;
				ValaCCodeIdentifier* _tmp6;
				ValaCCodeExpression* target_expr;
				_tmp4 = NULL;
				param = (_tmp4 = VALA_FORMAL_PARAMETER (vala_expression_get_symbol_reference (delegate_expr)), (_tmp4 == NULL ? NULL : g_object_ref (_tmp4)));
				_tmp5 = NULL;
				_tmp6 = NULL;
				target_expr = VALA_CCODE_EXPRESSION ((_tmp6 = vala_ccode_identifier_new ((_tmp5 = vala_ccode_generator_get_delegate_target_cname (self, vala_symbol_get_name (VALA_SYMBOL (param))))), (_tmp5 = (g_free (_tmp5), NULL)), _tmp6));
				if (vala_data_type_get_is_out (vala_formal_parameter_get_type_reference (param)) || vala_data_type_get_is_ref (vala_formal_parameter_get_type_reference (param))) {
					ValaCCodeExpression* _tmp8;
					ValaCCodeUnaryExpression* _tmp7;
					/* accessing argument of out/ref param*/
					_tmp8 = NULL;
					_tmp7 = NULL;
					target_expr = (_tmp8 = VALA_CCODE_EXPRESSION (vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION ((_tmp7 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, target_expr))))), (target_expr == NULL ? NULL : (target_expr = (g_object_unref (target_expr), NULL))), _tmp8);
					(_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL)));
				}
				if (is_out) {
					ValaCCodeUnaryExpression* _tmp9;
					_tmp9 = NULL;
					return VALA_CCODE_EXPRESSION ((_tmp9 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, target_expr), (param == NULL ? NULL : (param = (g_object_unref (param), NULL))), (target_expr == NULL ? NULL : (target_expr = (g_object_unref (target_expr), NULL))), _tmp9));
				} else {
					ValaCCodeExpression* _tmp10;
					_tmp10 = NULL;
					return (_tmp10 = target_expr, (param == NULL ? NULL : (param = (g_object_unref (param), NULL))), _tmp10);
				}
				(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
				(target_expr == NULL ? NULL : (target_expr = (g_object_unref (target_expr), NULL)));
			} else {
				/* passing array as out/ref*/
				if (VALA_IS_VARIABLE_DECLARATOR (vala_expression_get_symbol_reference (delegate_expr))) {
					ValaVariableDeclarator* _tmp11;
					ValaVariableDeclarator* decl;
					char* _tmp12;
					ValaCCodeIdentifier* _tmp13;
					ValaCCodeIdentifier* target_expr;
					_tmp11 = NULL;
					decl = (_tmp11 = VALA_VARIABLE_DECLARATOR (vala_expression_get_symbol_reference (delegate_expr)), (_tmp11 == NULL ? NULL : g_object_ref (_tmp11)));
					_tmp12 = NULL;
					_tmp13 = NULL;
					target_expr = (_tmp13 = vala_ccode_identifier_new ((_tmp12 = vala_ccode_generator_get_delegate_target_cname (self, vala_symbol_get_name (VALA_SYMBOL (decl))))), (_tmp12 = (g_free (_tmp12), NULL)), _tmp13);
					if (is_out) {
						ValaCCodeUnaryExpression* _tmp14;
						_tmp14 = NULL;
						return VALA_CCODE_EXPRESSION ((_tmp14 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (target_expr)), (decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL))), (target_expr == NULL ? NULL : (target_expr = (g_object_unref (target_expr), NULL))), _tmp14));
					} else {
						ValaCCodeIdentifier* _tmp15;
						_tmp15 = NULL;
						return VALA_CCODE_EXPRESSION ((_tmp15 = target_expr, (decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL))), _tmp15));
					}
					(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
					(target_expr == NULL ? NULL : (target_expr = (g_object_unref (target_expr), NULL)));
				} else {
					if (VALA_IS_FIELD (vala_expression_get_symbol_reference (delegate_expr))) {
						ValaField* _tmp16;
						ValaField* field;
						char* target_cname;
						ValaMemberAccess* _tmp17;
						ValaMemberAccess* ma;
						ValaCCodeExpression* pub_inst;
						ValaTypesymbol* base_type;
						ValaCCodeExpression* target_expr;
						_tmp16 = NULL;
						field = (_tmp16 = VALA_FIELD (vala_expression_get_symbol_reference (delegate_expr)), (_tmp16 == NULL ? NULL : g_object_ref (_tmp16)));
						target_cname = vala_ccode_generator_get_delegate_target_cname (self, vala_symbol_get_name (VALA_SYMBOL (field)));
						_tmp17 = NULL;
						ma = (_tmp17 = VALA_MEMBER_ACCESS (delegate_expr), (_tmp17 == NULL ? NULL : g_object_ref (_tmp17)));
						pub_inst = NULL;
						base_type = NULL;
						target_expr = NULL;
						if (vala_member_access_get_inner (ma) == NULL) {
							ValaCCodeExpression* _tmp18;
							_tmp18 = NULL;
							pub_inst = (_tmp18 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("self")), (pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL))), _tmp18);
							if (self->current_type_symbol != NULL) {
								ValaTypesymbol* _tmp20;
								ValaTypesymbol* _tmp19;
								/* base type is available if this is a type method */
								_tmp20 = NULL;
								_tmp19 = NULL;
								base_type = (_tmp20 = (_tmp19 = VALA_TYPESYMBOL (self->current_type_symbol), (_tmp19 == NULL ? NULL : g_object_ref (_tmp19))), (base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL))), _tmp20);
							}
						} else {
							ValaCCodeExpression* _tmp22;
							ValaCCodeExpression* _tmp21;
							_tmp22 = NULL;
							_tmp21 = NULL;
							pub_inst = (_tmp22 = (_tmp21 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_member_access_get_inner (ma)))), (_tmp21 == NULL ? NULL : g_object_ref (_tmp21))), (pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL))), _tmp22);
							if (vala_expression_get_static_type (vala_member_access_get_inner (ma)) != NULL) {
								ValaTypesymbol* _tmp24;
								ValaTypesymbol* _tmp23;
								_tmp24 = NULL;
								_tmp23 = NULL;
								base_type = (_tmp24 = (_tmp23 = vala_data_type_get_data_type (vala_expression_get_static_type (vala_member_access_get_inner (ma))), (_tmp23 == NULL ? NULL : g_object_ref (_tmp23))), (base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL))), _tmp24);
							}
						}
						if (vala_field_get_instance (field)) {
							ValaDataType* instance_expression_type;
							ValaDataType* instance_target_type;
							ValaCCodeExpression* typed_inst;
							ValaCCodeExpression* inst;
							instance_expression_type = vala_data_type_new ();
							vala_data_type_set_data_type (instance_expression_type, base_type);
							instance_target_type = vala_data_type_new ();
							vala_data_type_set_data_type (instance_target_type, VALA_TYPESYMBOL (vala_symbol_get_parent_symbol (VALA_SYMBOL (field))));
							typed_inst = vala_ccode_generator_get_implicit_cast_expression (self, pub_inst, instance_expression_type, instance_target_type);
							inst = NULL;
							if (vala_symbol_get_access (VALA_SYMBOL (field)) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
								ValaCCodeExpression* _tmp25;
								_tmp25 = NULL;
								inst = (_tmp25 = VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (typed_inst, "priv")), (inst == NULL ? NULL : (inst = (g_object_unref (inst), NULL))), _tmp25);
							} else {
								ValaCCodeExpression* _tmp27;
								ValaCCodeExpression* _tmp26;
								_tmp27 = NULL;
								_tmp26 = NULL;
								inst = (_tmp27 = (_tmp26 = typed_inst, (_tmp26 == NULL ? NULL : g_object_ref (_tmp26))), (inst == NULL ? NULL : (inst = (g_object_unref (inst), NULL))), _tmp27);
							}
							if (vala_typesymbol_is_reference_type ((VALA_TYPESYMBOL (vala_symbol_get_parent_symbol (VALA_SYMBOL (field)))))) {
								ValaCCodeExpression* _tmp28;
								_tmp28 = NULL;
								target_expr = (_tmp28 = VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (inst, target_cname)), (target_expr == NULL ? NULL : (target_expr = (g_object_unref (target_expr), NULL))), _tmp28);
							} else {
								ValaCCodeExpression* _tmp29;
								_tmp29 = NULL;
								target_expr = (_tmp29 = VALA_CCODE_EXPRESSION (vala_ccode_member_access_new (inst, target_cname, FALSE)), (target_expr == NULL ? NULL : (target_expr = (g_object_unref (target_expr), NULL))), _tmp29);
							}
							(instance_expression_type == NULL ? NULL : (instance_expression_type = (g_object_unref (instance_expression_type), NULL)));
							(instance_target_type == NULL ? NULL : (instance_target_type = (g_object_unref (instance_target_type), NULL)));
							(typed_inst == NULL ? NULL : (typed_inst = (g_object_unref (typed_inst), NULL)));
							(inst == NULL ? NULL : (inst = (g_object_unref (inst), NULL)));
						} else {
							ValaCCodeExpression* _tmp30;
							_tmp30 = NULL;
							target_expr = (_tmp30 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (target_cname)), (target_expr == NULL ? NULL : (target_expr = (g_object_unref (target_expr), NULL))), _tmp30);
						}
						if (is_out) {
							ValaCCodeUnaryExpression* _tmp31;
							_tmp31 = NULL;
							return VALA_CCODE_EXPRESSION ((_tmp31 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, target_expr), (field == NULL ? NULL : (field = (g_object_unref (field), NULL))), (target_cname = (g_free (target_cname), NULL)), (ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL))), (pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL))), (base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL))), (target_expr == NULL ? NULL : (target_expr = (g_object_unref (target_expr), NULL))), _tmp31));
						} else {
							ValaCCodeExpression* _tmp32;
							_tmp32 = NULL;
							return (_tmp32 = target_expr, (field == NULL ? NULL : (field = (g_object_unref (field), NULL))), (target_cname = (g_free (target_cname), NULL)), (ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL))), (pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL))), (base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL))), _tmp32);
						}
						(field == NULL ? NULL : (field = (g_object_unref (field), NULL)));
						(target_cname = (g_free (target_cname), NULL));
						(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
						(pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL)));
						(base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL)));
						(target_expr == NULL ? NULL : (target_expr = (g_object_unref (target_expr), NULL)));
					} else {
						if (VALA_IS_METHOD (vala_expression_get_symbol_reference (delegate_expr))) {
							ValaMemberAccess* _tmp33;
							ValaMemberAccess* ma;
							_tmp33 = NULL;
							ma = (_tmp33 = VALA_MEMBER_ACCESS (delegate_expr), (_tmp33 == NULL ? NULL : g_object_ref (_tmp33)));
							if (vala_member_access_get_inner (ma) == NULL) {
								if (self->priv->current_method != NULL && vala_method_get_instance (self->priv->current_method)) {
									ValaCCodeIdentifier* _tmp34;
									_tmp34 = NULL;
									return VALA_CCODE_EXPRESSION ((_tmp34 = vala_ccode_identifier_new ("self"), (ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL))), _tmp34));
								} else {
									ValaCCodeConstant* _tmp35;
									_tmp35 = NULL;
									return VALA_CCODE_EXPRESSION ((_tmp35 = vala_ccode_constant_new ("NULL"), (ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL))), _tmp35));
								}
							} else {
								ValaCCodeExpression* _tmp36;
								ValaCCodeExpression* _tmp37;
								_tmp36 = NULL;
								_tmp37 = NULL;
								return (_tmp37 = (_tmp36 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_member_access_get_inner (ma)))), (_tmp36 == NULL ? NULL : g_object_ref (_tmp36))), (ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL))), _tmp37);
							}
							(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
						}
					}
				}
			}
		}
	}
	return VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL"));
}


static void vala_ccode_generator_real_visit_element_access (ValaCodeVisitor* base, ValaElementAccess* expr) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (expr == NULL || VALA_IS_ELEMENT_ACCESS (expr));
	vala_code_binding_emit (vala_code_node_get_code_binding (VALA_CODE_NODE (expr)));
}


static void vala_ccode_generator_real_visit_base_access (ValaCodeVisitor* base, ValaBaseAccess* expr) {
	ValaCCodeGenerator * self;
	ValaInstanceCast* _tmp1;
	ValaCCodeIdentifier* _tmp0;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (expr == NULL || VALA_IS_BASE_ACCESS (expr));
	_tmp1 = NULL;
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp1 = vala_instance_cast_new (VALA_CCODE_EXPRESSION ((_tmp0 = vala_ccode_identifier_new ("self"))), vala_data_type_get_data_type (vala_expression_get_static_type (VALA_EXPRESSION (expr)))))));
	(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
}


static void vala_ccode_generator_real_visit_postfix_expression (ValaCodeVisitor* base, ValaPostfixExpression* expr) {
	ValaCCodeGenerator * self;
	ValaMemberAccess* ma;
	ValaCCodeUnaryOperator op;
	ValaCCodeUnaryExpression* _tmp7;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (expr == NULL || VALA_IS_POSTFIX_EXPRESSION (expr));
	ma = vala_ccode_generator_find_property_access (self, vala_postfix_expression_get_inner (expr));
	if (ma != NULL) {
		ValaProperty* _tmp0;
		ValaProperty* prop;
		ValaCCodeCommaExpression* ccomma;
		ValaVariableDeclarator* temp_decl;
		ValaCCodeAssignment* _tmp2;
		ValaCCodeIdentifier* _tmp1;
		ValaCCodeBinaryOperator op;
		ValaCCodeConstant* _tmp4;
		ValaCCodeIdentifier* _tmp3;
		ValaCCodeBinaryExpression* _tmp5;
		ValaCCodeBinaryExpression* cexpr;
		ValaCCodeFunctionCall* ccall;
		ValaCCodeIdentifier* _tmp6;
		/* property postfix expression*/
		_tmp0 = NULL;
		prop = (_tmp0 = VALA_PROPERTY (vala_expression_get_symbol_reference (VALA_EXPRESSION (ma))), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
		ccomma = vala_ccode_comma_expression_new ();
		/* assign current value to temp variable*/
		temp_decl = vala_ccode_generator_get_temp_variable_declarator (self, vala_property_get_type_reference (prop), TRUE, VALA_CODE_NODE (expr));
		gee_list_insert (GEE_LIST (self->temp_vars), 0, temp_decl);
		_tmp2 = NULL;
		_tmp1 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp1 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_decl))))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_postfix_expression_get_inner (expr)))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
		(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
		(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
		/* increment/decrement property*/
		op = (vala_postfix_expression_get_increment (expr) ? VALA_CCODE_BINARY_OPERATOR_PLUS : VALA_CCODE_BINARY_OPERATOR_MINUS);
		_tmp4 = NULL;
		_tmp3 = NULL;
		_tmp5 = NULL;
		cexpr = (_tmp5 = vala_ccode_binary_expression_new (op, VALA_CCODE_EXPRESSION ((_tmp3 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_decl))))), VALA_CCODE_EXPRESSION ((_tmp4 = vala_ccode_constant_new ("1")))), (_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL))), (_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL))), _tmp5);
		ccall = vala_ccode_generator_get_property_set_call (self, prop, ma, VALA_CCODE_EXPRESSION (cexpr));
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (ccall));
		/* return previous value*/
		_tmp6 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp6 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_decl))))));
		(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
		vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccomma));
		(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
		(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
		(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
		(cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL)));
		(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
		(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
		return;
	}
	op = (vala_postfix_expression_get_increment (expr) ? VALA_CCODE_UNARY_OPERATOR_POSTFIX_INCREMENT : VALA_CCODE_UNARY_OPERATOR_POSTFIX_DECREMENT);
	_tmp7 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp7 = vala_ccode_unary_expression_new (op, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_postfix_expression_get_inner (expr))))))));
	(_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL)));
	vala_ccode_generator_visit_expression (self, VALA_EXPRESSION (expr));
	(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
}


static ValaMemberAccess* vala_ccode_generator_find_property_access (ValaCCodeGenerator* self, ValaExpression* expr) {
	ValaMemberAccess* _tmp3;
	ValaMemberAccess* ma;
	gpointer _tmp5;
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	g_return_val_if_fail (expr == NULL || VALA_IS_EXPRESSION (expr), NULL);
	if (VALA_IS_PARENTHESIZED_EXPRESSION (expr)) {
		ValaParenthesizedExpression* _tmp0;
		ValaParenthesizedExpression* pe;
		ValaMemberAccess* _tmp1;
		_tmp0 = NULL;
		pe = (_tmp0 = VALA_PARENTHESIZED_EXPRESSION (expr), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
		_tmp1 = NULL;
		return (_tmp1 = vala_ccode_generator_find_property_access (self, vala_parenthesized_expression_get_inner (pe)), (pe == NULL ? NULL : (pe = (g_object_unref (pe), NULL))), _tmp1);
	}
	if (!(VALA_IS_MEMBER_ACCESS (expr))) {
		return NULL;
	}
	_tmp3 = NULL;
	ma = (_tmp3 = VALA_MEMBER_ACCESS (expr), (_tmp3 == NULL ? NULL : g_object_ref (_tmp3)));
	if (VALA_IS_PROPERTY (vala_expression_get_symbol_reference (VALA_EXPRESSION (ma)))) {
		return ma;
	}
	return (_tmp5 = NULL, (ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL))), _tmp5);
}


static ValaCCodeExpression* vala_ccode_generator_get_ref_expression (ValaCCodeGenerator* self, ValaExpression* expr) {
	ValaCCodeExpression* dupexpr;
	ValaCCodeFunctionCall* ccall;
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	g_return_val_if_fail (expr == NULL || VALA_IS_EXPRESSION (expr), NULL);
	/* (temp = expr, temp == NULL ? NULL : ref (temp))
	 *
	 * can be simplified to
	 * ref (expr)
	 * if static type of expr is non-null
	 */
	dupexpr = vala_ccode_generator_get_dup_func_expression (self, vala_expression_get_static_type (expr));
	if (NULL == dupexpr) {
		gpointer _tmp0;
		return (_tmp0 = NULL, (dupexpr == NULL ? NULL : (dupexpr = (g_object_unref (dupexpr), NULL))), _tmp0);
	}
	ccall = vala_ccode_function_call_new (dupexpr);
	if (((vala_code_context_get_non_null (self->priv->context) && !vala_data_type_get_nullable (vala_expression_get_static_type (expr))) && vala_data_type_get_type_parameter (vala_expression_get_static_type (expr)) == NULL) || VALA_IS_LITERAL_EXPRESSION (expr)) {
		ValaCCodeFunctionCall* _tmp1;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (expr))));
		_tmp1 = NULL;
		return VALA_CCODE_EXPRESSION ((_tmp1 = ccall, (dupexpr == NULL ? NULL : (dupexpr = (g_object_unref (dupexpr), NULL))), _tmp1));
	} else {
		ValaVariableDeclarator* decl;
		ValaCCodeIdentifier* ctemp;
		ValaCCodeConstant* _tmp2;
		ValaCCodeBinaryExpression* _tmp3;
		ValaCCodeBinaryExpression* cisnull;
		ValaCCodeCommaExpression* ccomma;
		ValaCCodeAssignment* _tmp11;
		ValaCCodeExpression* cifnull;
		ValaCCodeConditionalExpression* _tmp18;
		ValaCCodeCommaExpression* _tmp19;
		decl = vala_ccode_generator_get_temp_variable_declarator (self, vala_expression_get_static_type (expr), FALSE, VALA_CODE_NODE (expr));
		gee_list_insert (GEE_LIST (self->temp_vars), 0, decl);
		ctemp = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (decl)));
		_tmp2 = NULL;
		_tmp3 = NULL;
		cisnull = (_tmp3 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, VALA_CCODE_EXPRESSION (ctemp), VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_constant_new ("NULL")))), (_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL))), _tmp3);
		if (vala_data_type_get_data_type (vala_expression_get_static_type (expr)) == NULL) {
			ValaCCodeConstant* _tmp7;
			ValaCCodeExpression* _tmp6;
			ValaCCodeBinaryExpression* _tmp8;
			ValaCCodeBinaryExpression* cdupisnull;
			ValaCCodeBinaryExpression* _tmp9;
			if (!(VALA_IS_CLASS (self->current_type_symbol))) {
				ValaCCodeExpression* _tmp4;
				ValaCCodeExpression* _tmp5;
				_tmp4 = NULL;
				_tmp5 = NULL;
				return (_tmp5 = (_tmp4 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (expr))), (_tmp4 == NULL ? NULL : g_object_ref (_tmp4))), (decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL))), (ctemp == NULL ? NULL : (ctemp = (g_object_unref (ctemp), NULL))), (cisnull == NULL ? NULL : (cisnull = (g_object_unref (cisnull), NULL))), (dupexpr == NULL ? NULL : (dupexpr = (g_object_unref (dupexpr), NULL))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), _tmp5);
			}
			/* dup functions are optional for type parameters*/
			_tmp7 = NULL;
			_tmp6 = NULL;
			_tmp8 = NULL;
			cdupisnull = (_tmp8 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (_tmp6 = vala_ccode_generator_get_dup_func_expression (self, vala_expression_get_static_type (expr))), VALA_CCODE_EXPRESSION ((_tmp7 = vala_ccode_constant_new ("NULL")))), (_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL))), (_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL))), _tmp8);
			_tmp9 = NULL;
			cisnull = (_tmp9 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_OR, VALA_CCODE_EXPRESSION (cisnull), VALA_CCODE_EXPRESSION (cdupisnull)), (cisnull == NULL ? NULL : (cisnull = (g_object_unref (cisnull), NULL))), _tmp9);
			(cdupisnull == NULL ? NULL : (cdupisnull = (g_object_unref (cdupisnull), NULL)));
		}
		if (vala_data_type_get_data_type (vala_expression_get_static_type (expr)) != NULL) {
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (ctemp));
		} else {
			ValaCCodeCastExpression* _tmp10;
			/* cast from gconstpointer to gpointer as GBoxedCopyFunc expects gpointer*/
			_tmp10 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp10 = vala_ccode_cast_expression_new (VALA_CCODE_EXPRESSION (ctemp), "gpointer"))));
			(_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL)));
		}
		ccomma = vala_ccode_comma_expression_new ();
		_tmp11 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp11 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (ctemp), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (expr))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
		(_tmp11 == NULL ? NULL : (_tmp11 = (g_object_unref (_tmp11), NULL)));
		if (vala_data_type_get_data_type (vala_expression_get_static_type (expr)) == self->glist_type) {
			gboolean is_ref;
			gboolean is_class;
			gboolean is_interface;
			is_ref = FALSE;
			is_class = FALSE;
			is_interface = FALSE;
			{
				GeeList* type_arg_collection;
				GeeIterator* type_arg_it;
				type_arg_collection = vala_data_type_get_type_arguments (vala_expression_get_static_type (expr));
				type_arg_it = gee_iterable_iterator (GEE_ITERABLE (type_arg_collection));
				while (gee_iterator_next (type_arg_it)) {
					ValaDataType* type_arg;
					type_arg = gee_iterator_get (type_arg_it);
					{
						is_ref = is_ref | (vala_data_type_get_takes_ownership (type_arg));
						is_class = is_class | (VALA_IS_CLASS (vala_data_type_get_data_type (type_arg)));
						is_interface = is_interface | (VALA_IS_INTERFACE (vala_data_type_get_data_type (type_arg)));
						(type_arg == NULL ? NULL : (type_arg = (g_object_unref (type_arg), NULL)));
					}
				}
				(type_arg_collection == NULL ? NULL : (type_arg_collection = (g_object_unref (type_arg_collection), NULL)));
				(type_arg_it == NULL ? NULL : (type_arg_it = (g_object_unref (type_arg_it), NULL)));
			}
			if (is_ref && (is_class || is_interface)) {
				ValaCCodeIdentifier* _tmp12;
				ValaCCodeFunctionCall* _tmp13;
				ValaCCodeFunctionCall* crefcall;
				ValaCCodeIdentifier* _tmp14;
				ValaCCodeConstant* _tmp15;
				_tmp12 = NULL;
				_tmp13 = NULL;
				crefcall = (_tmp13 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp12 = vala_ccode_identifier_new ("g_list_foreach")))), (_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL))), _tmp13);
				vala_ccode_function_call_add_argument (crefcall, VALA_CCODE_EXPRESSION (ctemp));
				_tmp14 = NULL;
				vala_ccode_function_call_add_argument (crefcall, VALA_CCODE_EXPRESSION ((_tmp14 = vala_ccode_identifier_new ("(GFunc) g_object_ref"))));
				(_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL)));
				_tmp15 = NULL;
				vala_ccode_function_call_add_argument (crefcall, VALA_CCODE_EXPRESSION ((_tmp15 = vala_ccode_constant_new ("NULL"))));
				(_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL)));
				vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (crefcall));
				(crefcall == NULL ? NULL : (crefcall = (g_object_unref (crefcall), NULL)));
			}
		}
		cifnull = NULL;
		if (vala_data_type_get_data_type (vala_expression_get_static_type (expr)) != NULL) {
			ValaCCodeExpression* _tmp16;
			_tmp16 = NULL;
			cifnull = (_tmp16 = VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL")), (cifnull == NULL ? NULL : (cifnull = (g_object_unref (cifnull), NULL))), _tmp16);
		} else {
			ValaCCodeExpression* _tmp17;
			/* the value might be non-null even when the dup function is null,
			 so we may not just use NULL for type parameters
			 cast from gconstpointer to gpointer as methods in
			 generic classes may not return gconstpointer*/
			_tmp17 = NULL;
			cifnull = (_tmp17 = VALA_CCODE_EXPRESSION (vala_ccode_cast_expression_new (VALA_CCODE_EXPRESSION (ctemp), "gpointer")), (cifnull == NULL ? NULL : (cifnull = (g_object_unref (cifnull), NULL))), _tmp17);
		}
		_tmp18 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp18 = vala_ccode_conditional_expression_new (VALA_CCODE_EXPRESSION (cisnull), cifnull, VALA_CCODE_EXPRESSION (ccall)))));
		(_tmp18 == NULL ? NULL : (_tmp18 = (g_object_unref (_tmp18), NULL)));
		_tmp19 = NULL;
		return VALA_CCODE_EXPRESSION ((_tmp19 = ccomma, (decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL))), (ctemp == NULL ? NULL : (ctemp = (g_object_unref (ctemp), NULL))), (cisnull == NULL ? NULL : (cisnull = (g_object_unref (cisnull), NULL))), (cifnull == NULL ? NULL : (cifnull = (g_object_unref (cifnull), NULL))), (dupexpr == NULL ? NULL : (dupexpr = (g_object_unref (dupexpr), NULL))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), _tmp19));
	}
	(dupexpr == NULL ? NULL : (dupexpr = (g_object_unref (dupexpr), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
}


void vala_ccode_generator_visit_expression (ValaCCodeGenerator* self, ValaExpression* expr) {
	g_return_if_fail (VALA_IS_CCODE_GENERATOR (self));
	g_return_if_fail (expr == NULL || VALA_IS_EXPRESSION (expr));
	if (vala_expression_get_static_type (expr) != NULL && vala_data_type_get_transfers_ownership (vala_expression_get_static_type (expr)) && vala_data_type_get_floating_reference (vala_expression_get_static_type (expr))) {
		ValaCCodeIdentifier* _tmp0;
		ValaCCodeFunctionCall* _tmp1;
		ValaCCodeFunctionCall* csink;
		/* constructor of GInitiallyUnowned subtype
		 * returns floating reference, sink it
		 */
		_tmp0 = NULL;
		_tmp1 = NULL;
		csink = (_tmp1 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp0 = vala_ccode_identifier_new ("g_object_ref_sink")))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1);
		vala_ccode_function_call_add_argument (csink, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (expr))));
		vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (csink));
		(csink == NULL ? NULL : (csink = (g_object_unref (csink), NULL)));
	}
	if (vala_expression_get_ref_leaked (expr)) {
		ValaVariableDeclarator* decl;
		ValaCCodeParenthesizedExpression* _tmp5;
		ValaCCodeAssignment* _tmp4;
		ValaCCodeIdentifier* _tmp3;
		char* _tmp2;
		decl = vala_ccode_generator_get_temp_variable_declarator (self, vala_expression_get_static_type (expr), TRUE, VALA_CODE_NODE (expr));
		gee_list_insert (GEE_LIST (self->temp_vars), 0, decl);
		gee_list_insert (GEE_LIST (self->priv->temp_ref_vars), 0, decl);
		_tmp5 = NULL;
		_tmp4 = NULL;
		_tmp3 = NULL;
		_tmp2 = NULL;
		vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp5 = vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION ((_tmp4 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp3 = vala_ccode_identifier_new ((_tmp2 = vala_ccode_generator_get_variable_cname (self, vala_symbol_get_name (VALA_SYMBOL (decl))))))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (expr))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
		(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
		(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
		(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
		(_tmp2 = (g_free (_tmp2), NULL));
		(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
	} else {
		if (vala_expression_get_ref_missing (expr)) {
			ValaCCodeExpression* _tmp6;
			_tmp6 = NULL;
			vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp6 = vala_ccode_generator_get_ref_expression (self, expr))));
			(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
		}
	}
}


static void vala_ccode_generator_real_visit_object_creation_expression (ValaCodeVisitor* base, ValaObjectCreationExpression* expr) {
	ValaCCodeGenerator * self;
	ValaCCodeExpression* instance;
	ValaCCodeFunctionCall* creation_call;
	GeeCollection* _tmp0;
	gboolean _tmp1;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (expr == NULL || VALA_IS_OBJECT_CREATION_EXPRESSION (expr));
	vala_code_node_accept_children (VALA_CODE_NODE (expr), VALA_CODE_VISITOR (self));
	instance = NULL;
	creation_call = NULL;
	_tmp0 = NULL;
	if ((_tmp1 = VALA_IS_STRUCT (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr))) || gee_collection_get_size ((_tmp0 = vala_object_creation_expression_get_object_initializer (expr))) > 0, (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1)) {
		ValaVariableDeclarator* temp_decl;
		ValaCCodeExpression* _tmp3;
		char* _tmp2;
		/* value-type initialization or object creation expression with object initializer*/
		temp_decl = vala_ccode_generator_get_temp_variable_declarator (self, vala_object_creation_expression_get_type_reference (expr), FALSE, VALA_CODE_NODE (expr));
		gee_collection_add (GEE_COLLECTION (self->temp_vars), temp_decl);
		_tmp3 = NULL;
		_tmp2 = NULL;
		instance = (_tmp3 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ((_tmp2 = vala_ccode_generator_get_variable_cname (self, vala_symbol_get_name (VALA_SYMBOL (temp_decl)))))), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), _tmp3);
		(_tmp2 = (g_free (_tmp2), NULL));
		(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
	}
	if (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr)) == NULL) {
		/* no creation method*/
		if (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr)) == self->glist_type || vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr)) == self->gslist_type) {
			ValaCCodeConstant* _tmp4;
			/* NULL is an empty list*/
			_tmp4 = NULL;
			vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp4 = vala_ccode_constant_new ("NULL"))));
			(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
		} else {
			if (VALA_IS_CLASS (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr))) && vala_typesymbol_is_subtype_of (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr)), self->gobject_type)) {
				ValaCCodeFunctionCall* _tmp6;
				ValaCCodeIdentifier* _tmp5;
				ValaCCodeConstant* _tmp8;
				char* _tmp7;
				ValaCCodeConstant* _tmp9;
				_tmp6 = NULL;
				_tmp5 = NULL;
				creation_call = (_tmp6 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_identifier_new ("g_object_new")))), (creation_call == NULL ? NULL : (creation_call = (g_object_unref (creation_call), NULL))), _tmp6);
				(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
				_tmp8 = NULL;
				_tmp7 = NULL;
				vala_ccode_function_call_add_argument (creation_call, VALA_CCODE_EXPRESSION ((_tmp8 = vala_ccode_constant_new ((_tmp7 = vala_typesymbol_get_type_id (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr))))))));
				(_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL)));
				(_tmp7 = (g_free (_tmp7), NULL));
				_tmp9 = NULL;
				vala_ccode_function_call_add_argument (creation_call, VALA_CCODE_EXPRESSION ((_tmp9 = vala_ccode_constant_new ("NULL"))));
				(_tmp9 == NULL ? NULL : (_tmp9 = (g_object_unref (_tmp9), NULL)));
			} else {
				if (VALA_IS_CLASS (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr)))) {
					ValaCCodeFunctionCall* _tmp11;
					ValaCCodeIdentifier* _tmp10;
					ValaCCodeConstant* _tmp13;
					char* _tmp12;
					ValaCCodeConstant* _tmp14;
					_tmp11 = NULL;
					_tmp10 = NULL;
					creation_call = (_tmp11 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp10 = vala_ccode_identifier_new ("g_new0")))), (creation_call == NULL ? NULL : (creation_call = (g_object_unref (creation_call), NULL))), _tmp11);
					(_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL)));
					_tmp13 = NULL;
					_tmp12 = NULL;
					vala_ccode_function_call_add_argument (creation_call, VALA_CCODE_EXPRESSION ((_tmp13 = vala_ccode_constant_new ((_tmp12 = vala_typesymbol_get_cname (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr)), FALSE))))));
					(_tmp13 == NULL ? NULL : (_tmp13 = (g_object_unref (_tmp13), NULL)));
					(_tmp12 = (g_free (_tmp12), NULL));
					_tmp14 = NULL;
					vala_ccode_function_call_add_argument (creation_call, VALA_CCODE_EXPRESSION ((_tmp14 = vala_ccode_constant_new ("1"))));
					(_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL)));
				} else {
					if (VALA_IS_STRUCT (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr)))) {
						ValaCCodeFunctionCall* _tmp16;
						ValaCCodeIdentifier* _tmp15;
						ValaCCodeUnaryExpression* _tmp17;
						ValaCCodeConstant* _tmp18;
						ValaCCodeIdentifier* _tmp21;
						char* _tmp20;
						char* _tmp19;
						/* memset needs string.h*/
						self->priv->string_h_needed = TRUE;
						_tmp16 = NULL;
						_tmp15 = NULL;
						creation_call = (_tmp16 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp15 = vala_ccode_identifier_new ("memset")))), (creation_call == NULL ? NULL : (creation_call = (g_object_unref (creation_call), NULL))), _tmp16);
						(_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL)));
						_tmp17 = NULL;
						vala_ccode_function_call_add_argument (creation_call, VALA_CCODE_EXPRESSION ((_tmp17 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, instance))));
						(_tmp17 == NULL ? NULL : (_tmp17 = (g_object_unref (_tmp17), NULL)));
						_tmp18 = NULL;
						vala_ccode_function_call_add_argument (creation_call, VALA_CCODE_EXPRESSION ((_tmp18 = vala_ccode_constant_new ("0"))));
						(_tmp18 == NULL ? NULL : (_tmp18 = (g_object_unref (_tmp18), NULL)));
						_tmp21 = NULL;
						_tmp20 = NULL;
						_tmp19 = NULL;
						vala_ccode_function_call_add_argument (creation_call, VALA_CCODE_EXPRESSION ((_tmp21 = vala_ccode_identifier_new ((_tmp20 = g_strdup_printf ("sizeof (%s)", (_tmp19 = vala_data_type_get_cname (vala_object_creation_expression_get_type_reference (expr), FALSE, FALSE))))))));
						(_tmp21 == NULL ? NULL : (_tmp21 = (g_object_unref (_tmp21), NULL)));
						(_tmp20 = (g_free (_tmp20), NULL));
						(_tmp19 = (g_free (_tmp19), NULL));
					}
				}
			}
		}
	} else {
		if (VALA_IS_METHOD (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr)))) {
			ValaMethod* _tmp22;
			ValaMethod* m;
			GeeCollection* params;
			ValaCCodeFunctionCall* _tmp25;
			ValaCCodeIdentifier* _tmp24;
			char* _tmp23;
			gboolean ellipsis;
			gint i;
			GeeIterator* params_it;
			/* use creation method*/
			_tmp22 = NULL;
			m = (_tmp22 = VALA_METHOD (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr))), (_tmp22 == NULL ? NULL : g_object_ref (_tmp22)));
			params = vala_method_get_parameters (m);
			_tmp25 = NULL;
			_tmp24 = NULL;
			_tmp23 = NULL;
			creation_call = (_tmp25 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp24 = vala_ccode_identifier_new ((_tmp23 = vala_method_get_cname (m)))))), (creation_call == NULL ? NULL : (creation_call = (g_object_unref (creation_call), NULL))), _tmp25);
			(_tmp24 == NULL ? NULL : (_tmp24 = (g_object_unref (_tmp24), NULL)));
			(_tmp23 = (g_free (_tmp23), NULL));
			if (VALA_IS_STRUCT (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr)))) {
				ValaCCodeUnaryExpression* _tmp26;
				_tmp26 = NULL;
				vala_ccode_function_call_add_argument (creation_call, VALA_CCODE_EXPRESSION ((_tmp26 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, instance))));
				(_tmp26 == NULL ? NULL : (_tmp26 = (g_object_unref (_tmp26), NULL)));
			} else {
				if (VALA_IS_CLASS (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr)))) {
					ValaClass* _tmp27;
					ValaClass* cl;
					_tmp27 = NULL;
					cl = (_tmp27 = VALA_CLASS (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr))), (_tmp27 == NULL ? NULL : g_object_ref (_tmp27)));
					if (VALA_TYPESYMBOL (vala_class_get_base_class (cl)) == self->gtypeinstance_type) {
						ValaCCodeIdentifier* _tmp29;
						char* _tmp28;
						_tmp29 = NULL;
						_tmp28 = NULL;
						vala_ccode_function_call_add_argument (creation_call, VALA_CCODE_EXPRESSION ((_tmp29 = vala_ccode_identifier_new ((_tmp28 = vala_typesymbol_get_type_id (VALA_TYPESYMBOL (cl)))))));
						(_tmp29 == NULL ? NULL : (_tmp29 = (g_object_unref (_tmp29), NULL)));
						(_tmp28 = (g_free (_tmp28), NULL));
					}
					(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
				}
			}
			if (VALA_IS_CLASS (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr))) && vala_typesymbol_is_subtype_of (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr)), self->gobject_type)) {
				{
					GeeList* type_arg_collection;
					GeeIterator* type_arg_it;
					type_arg_collection = vala_data_type_get_type_arguments (vala_object_creation_expression_get_type_reference (expr));
					type_arg_it = gee_iterable_iterator (GEE_ITERABLE (type_arg_collection));
					while (gee_iterator_next (type_arg_it)) {
						ValaDataType* type_arg;
						type_arg = gee_iterator_get (type_arg_it);
						{
							ValaCCodeExpression* _tmp30;
							_tmp30 = NULL;
							vala_ccode_function_call_add_argument (creation_call, (_tmp30 = vala_ccode_generator_get_type_id_expression (self, type_arg)));
							(_tmp30 == NULL ? NULL : (_tmp30 = (g_object_unref (_tmp30), NULL)));
							if (vala_data_type_get_takes_ownership (type_arg)) {
								ValaCCodeCastExpression* _tmp32;
								ValaCCodeExpression* _tmp31;
								ValaCCodeExpression* _tmp33;
								_tmp32 = NULL;
								_tmp31 = NULL;
								vala_ccode_function_call_add_argument (creation_call, VALA_CCODE_EXPRESSION ((_tmp32 = vala_ccode_cast_expression_new ((_tmp31 = vala_ccode_generator_get_dup_func_expression (self, type_arg)), "GBoxedCopyFunc"))));
								(_tmp32 == NULL ? NULL : (_tmp32 = (g_object_unref (_tmp32), NULL)));
								(_tmp31 == NULL ? NULL : (_tmp31 = (g_object_unref (_tmp31), NULL)));
								_tmp33 = NULL;
								vala_ccode_function_call_add_argument (creation_call, (_tmp33 = vala_ccode_generator_get_destroy_func_expression (self, type_arg)));
								(_tmp33 == NULL ? NULL : (_tmp33 = (g_object_unref (_tmp33), NULL)));
							} else {
								ValaCCodeConstant* _tmp34;
								ValaCCodeConstant* _tmp35;
								_tmp34 = NULL;
								vala_ccode_function_call_add_argument (creation_call, VALA_CCODE_EXPRESSION ((_tmp34 = vala_ccode_constant_new ("NULL"))));
								(_tmp34 == NULL ? NULL : (_tmp34 = (g_object_unref (_tmp34), NULL)));
								_tmp35 = NULL;
								vala_ccode_function_call_add_argument (creation_call, VALA_CCODE_EXPRESSION ((_tmp35 = vala_ccode_constant_new ("NULL"))));
								(_tmp35 == NULL ? NULL : (_tmp35 = (g_object_unref (_tmp35), NULL)));
							}
							(type_arg == NULL ? NULL : (type_arg = (g_object_unref (type_arg), NULL)));
						}
					}
					(type_arg_collection == NULL ? NULL : (type_arg_collection = (g_object_unref (type_arg_collection), NULL)));
					(type_arg_it == NULL ? NULL : (type_arg_it = (g_object_unref (type_arg_it), NULL)));
				}
			}
			ellipsis = FALSE;
			i = 1;
			params_it = gee_iterable_iterator (GEE_ITERABLE (params));
			{
				GeeCollection* arg_collection;
				GeeIterator* arg_it;
				arg_collection = vala_object_creation_expression_get_argument_list (expr);
				arg_it = gee_iterable_iterator (GEE_ITERABLE (arg_collection));
				while (gee_iterator_next (arg_it)) {
					ValaExpression* arg;
					arg = gee_iterator_get (arg_it);
					{
						ValaCCodeExpression* _tmp36;
						ValaCCodeExpression* cexpr;
						_tmp36 = NULL;
						cexpr = (_tmp36 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (arg))), (_tmp36 == NULL ? NULL : g_object_ref (_tmp36)));
						if (gee_iterator_next (params_it)) {
							ValaFormalParameter* param;
							param = gee_iterator_get (params_it);
							ellipsis = vala_formal_parameter_get_ellipsis (param);
							if (!vala_formal_parameter_get_ellipsis (param)) {
								ValaCCodeExpression* _tmp37;
								_tmp37 = NULL;
								cexpr = (_tmp37 = vala_ccode_generator_get_implicit_cast_expression (self, cexpr, vala_expression_get_static_type (arg), vala_formal_parameter_get_type_reference (param)), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), _tmp37);
								/* pass non-simple struct instances always by reference*/
								if (VALA_IS_STRUCT (vala_data_type_get_data_type (vala_formal_parameter_get_type_reference (param))) && !vala_struct_is_simple_type ((VALA_STRUCT (vala_data_type_get_data_type (vala_formal_parameter_get_type_reference (param)))))) {
									/* we already use a reference for arguments of ref and out parameters*/
									if (!vala_data_type_get_is_ref (vala_formal_parameter_get_type_reference (param)) && !vala_data_type_get_is_out (vala_formal_parameter_get_type_reference (param))) {
										ValaCCodeExpression* _tmp38;
										_tmp38 = NULL;
										cexpr = (_tmp38 = VALA_CCODE_EXPRESSION (vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, cexpr)), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), _tmp38);
									}
								}
							}
							(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
						}
						vala_ccode_function_call_add_argument (creation_call, cexpr);
						i++;
						(arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL)));
						(cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL)));
					}
				}
				(arg_collection == NULL ? NULL : (arg_collection = (g_object_unref (arg_collection), NULL)));
				(arg_it == NULL ? NULL : (arg_it = (g_object_unref (arg_it), NULL)));
			}
			while (gee_iterator_next (params_it)) {
				ValaFormalParameter* param;
				param = gee_iterator_get (params_it);
				if (vala_formal_parameter_get_ellipsis (param)) {
					ellipsis = TRUE;
					(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
					break;
				}
				if (vala_formal_parameter_get_default_expression (param) == NULL) {
					char* _tmp39;
					_tmp39 = NULL;
					vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (expr)), (_tmp39 = g_strdup_printf ("no default expression for argument %d", i)));
					(_tmp39 = (g_free (_tmp39), NULL));
					(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
					(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
					(params == NULL ? NULL : (params = (g_object_unref (params), NULL)));
					(params_it == NULL ? NULL : (params_it = (g_object_unref (params_it), NULL)));
					(instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL)));
					(creation_call == NULL ? NULL : (creation_call = (g_object_unref (creation_call), NULL)));
					return;
				}
				/* evaluate default expression here as the code
				 * generator might not have visited the formal
				 * parameter yet */
				vala_code_node_accept (VALA_CODE_NODE (vala_formal_parameter_get_default_expression (param)), VALA_CODE_VISITOR (self));
				vala_ccode_function_call_add_argument (creation_call, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_formal_parameter_get_default_expression (param)))));
				i++;
				(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
			}
			if (vala_expression_get_can_fail (VALA_EXPRESSION (expr))) {
				ValaCCodeUnaryExpression* _tmp41;
				ValaCCodeIdentifier* _tmp40;
				/* method can fail*/
				self->priv->current_method_inner_error = TRUE;
				_tmp41 = NULL;
				_tmp40 = NULL;
				vala_ccode_function_call_add_argument (creation_call, VALA_CCODE_EXPRESSION ((_tmp41 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp40 = vala_ccode_identifier_new ("inner_error")))))));
				(_tmp41 == NULL ? NULL : (_tmp41 = (g_object_unref (_tmp41), NULL)));
				(_tmp40 == NULL ? NULL : (_tmp40 = (g_object_unref (_tmp40), NULL)));
			}
			if (ellipsis) {
				ValaCCodeConstant* _tmp42;
				/* ensure variable argument list ends with NULL*/
				_tmp42 = NULL;
				vala_ccode_function_call_add_argument (creation_call, VALA_CCODE_EXPRESSION ((_tmp42 = vala_ccode_constant_new ("NULL"))));
				(_tmp42 == NULL ? NULL : (_tmp42 = (g_object_unref (_tmp42), NULL)));
			}
			(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
			(params == NULL ? NULL : (params = (g_object_unref (params), NULL)));
			(params_it == NULL ? NULL : (params_it = (g_object_unref (params_it), NULL)));
		} else {
			if (VALA_IS_ENUM_VALUE (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr)))) {
				ValaEnumValue* _tmp43;
				ValaEnumValue* ev;
				ValaEnum* _tmp44;
				ValaEnum* en;
				ValaCCodeFunctionCall* _tmp46;
				ValaCCodeIdentifier* _tmp45;
				ValaCCodeIdentifier* _tmp47;
				ValaCCodeIdentifier* _tmp49;
				char* _tmp48;
				ValaCCodeIdentifier* _tmp51;
				char* _tmp50;
				/* error code*/
				_tmp43 = NULL;
				ev = (_tmp43 = VALA_ENUM_VALUE (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr))), (_tmp43 == NULL ? NULL : g_object_ref (_tmp43)));
				_tmp44 = NULL;
				en = (_tmp44 = VALA_ENUM (vala_symbol_get_parent_symbol (VALA_SYMBOL (ev))), (_tmp44 == NULL ? NULL : g_object_ref (_tmp44)));
				_tmp46 = NULL;
				_tmp45 = NULL;
				creation_call = (_tmp46 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp45 = vala_ccode_identifier_new ("g_set_error")))), (creation_call == NULL ? NULL : (creation_call = (g_object_unref (creation_call), NULL))), _tmp46);
				(_tmp45 == NULL ? NULL : (_tmp45 = (g_object_unref (_tmp45), NULL)));
				_tmp47 = NULL;
				vala_ccode_function_call_add_argument (creation_call, VALA_CCODE_EXPRESSION ((_tmp47 = vala_ccode_identifier_new ("error"))));
				(_tmp47 == NULL ? NULL : (_tmp47 = (g_object_unref (_tmp47), NULL)));
				_tmp49 = NULL;
				_tmp48 = NULL;
				vala_ccode_function_call_add_argument (creation_call, VALA_CCODE_EXPRESSION ((_tmp49 = vala_ccode_identifier_new ((_tmp48 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (en), NULL))))));
				(_tmp49 == NULL ? NULL : (_tmp49 = (g_object_unref (_tmp49), NULL)));
				(_tmp48 = (g_free (_tmp48), NULL));
				_tmp51 = NULL;
				_tmp50 = NULL;
				vala_ccode_function_call_add_argument (creation_call, VALA_CCODE_EXPRESSION ((_tmp51 = vala_ccode_identifier_new ((_tmp50 = vala_enum_value_get_cname (ev))))));
				(_tmp51 == NULL ? NULL : (_tmp51 = (g_object_unref (_tmp51), NULL)));
				(_tmp50 = (g_free (_tmp50), NULL));
				{
					GeeCollection* arg_collection;
					GeeIterator* arg_it;
					arg_collection = vala_object_creation_expression_get_argument_list (expr);
					arg_it = gee_iterable_iterator (GEE_ITERABLE (arg_collection));
					while (gee_iterator_next (arg_it)) {
						ValaExpression* arg;
						arg = gee_iterator_get (arg_it);
						{
							vala_ccode_function_call_add_argument (creation_call, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (arg))));
							(arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL)));
						}
					}
					(arg_collection == NULL ? NULL : (arg_collection = (g_object_unref (arg_collection), NULL)));
					(arg_it == NULL ? NULL : (arg_it = (g_object_unref (arg_it), NULL)));
				}
				(ev == NULL ? NULL : (ev = (g_object_unref (ev), NULL)));
				(en == NULL ? NULL : (en = (g_object_unref (en), NULL)));
			} else {
				g_assert (FALSE);
			}
		}
	}
	if (instance != NULL) {
		ValaCCodeCommaExpression* ccomma;
		ccomma = vala_ccode_comma_expression_new ();
		if (VALA_IS_STRUCT (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr)))) {
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (creation_call));
		} else {
			ValaCCodeAssignment* _tmp52;
			_tmp52 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp52 = vala_ccode_assignment_new (instance, VALA_CCODE_EXPRESSION (creation_call), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
			(_tmp52 == NULL ? NULL : (_tmp52 = (g_object_unref (_tmp52), NULL)));
		}
		{
			GeeCollection* init_collection;
			GeeIterator* init_it;
			init_collection = vala_object_creation_expression_get_object_initializer (expr);
			init_it = gee_iterable_iterator (GEE_ITERABLE (init_collection));
			while (gee_iterator_next (init_it)) {
				ValaMemberInitializer* init;
				init = gee_iterator_get (init_it);
				{
					if (VALA_IS_FIELD (vala_member_initializer_get_symbol_reference (init))) {
						ValaField* _tmp53;
						ValaField* f;
						ValaDataType* instance_target_type;
						ValaCCodeExpression* typed_inst;
						ValaCCodeExpression* lhs;
						ValaCCodeAssignment* _tmp58;
						_tmp53 = NULL;
						f = (_tmp53 = VALA_FIELD (vala_member_initializer_get_symbol_reference (init)), (_tmp53 == NULL ? NULL : g_object_ref (_tmp53)));
						instance_target_type = vala_data_type_new ();
						vala_data_type_set_data_type (instance_target_type, VALA_TYPESYMBOL (vala_symbol_get_parent_symbol (VALA_SYMBOL (f))));
						typed_inst = vala_ccode_generator_get_implicit_cast_expression (self, instance, vala_object_creation_expression_get_type_reference (expr), instance_target_type);
						lhs = NULL;
						if (VALA_IS_STRUCT (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr)))) {
							ValaCCodeExpression* _tmp55;
							char* _tmp54;
							_tmp55 = NULL;
							_tmp54 = NULL;
							lhs = (_tmp55 = VALA_CCODE_EXPRESSION (vala_ccode_member_access_new (typed_inst, (_tmp54 = vala_field_get_cname (f)), FALSE)), (lhs == NULL ? NULL : (lhs = (g_object_unref (lhs), NULL))), _tmp55);
							(_tmp54 = (g_free (_tmp54), NULL));
						} else {
							ValaCCodeExpression* _tmp57;
							char* _tmp56;
							_tmp57 = NULL;
							_tmp56 = NULL;
							lhs = (_tmp57 = VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (typed_inst, (_tmp56 = vala_field_get_cname (f)))), (lhs == NULL ? NULL : (lhs = (g_object_unref (lhs), NULL))), _tmp57);
							(_tmp56 = (g_free (_tmp56), NULL));
						}
						_tmp58 = NULL;
						vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp58 = vala_ccode_assignment_new (lhs, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_member_initializer_get_initializer (init)))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
						(_tmp58 == NULL ? NULL : (_tmp58 = (g_object_unref (_tmp58), NULL)));
						(f == NULL ? NULL : (f = (g_object_unref (f), NULL)));
						(instance_target_type == NULL ? NULL : (instance_target_type = (g_object_unref (instance_target_type), NULL)));
						(typed_inst == NULL ? NULL : (typed_inst = (g_object_unref (typed_inst), NULL)));
						(lhs == NULL ? NULL : (lhs = (g_object_unref (lhs), NULL)));
					} else {
						if (VALA_IS_PROPERTY (vala_member_initializer_get_symbol_reference (init))) {
							ValaMemberAccess* inst_ma;
							ValaMemberAccess* ma;
							ValaCCodeFunctionCall* _tmp59;
							inst_ma = vala_member_access_new_simple ("new", NULL);
							vala_expression_set_static_type (VALA_EXPRESSION (inst_ma), vala_object_creation_expression_get_type_reference (expr));
							vala_code_node_set_ccodenode (VALA_CODE_NODE (inst_ma), VALA_CCODE_NODE (instance));
							ma = vala_member_access_new (VALA_EXPRESSION (inst_ma), vala_member_initializer_get_name (init), NULL);
							_tmp59 = NULL;
							vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp59 = vala_ccode_generator_get_property_set_call (self, VALA_PROPERTY (vala_member_initializer_get_symbol_reference (init)), ma, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_member_initializer_get_initializer (init))))))));
							(_tmp59 == NULL ? NULL : (_tmp59 = (g_object_unref (_tmp59), NULL)));
							(inst_ma == NULL ? NULL : (inst_ma = (g_object_unref (inst_ma), NULL)));
							(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
						}
					}
					(init == NULL ? NULL : (init = (g_object_unref (init), NULL)));
				}
			}
			(init_collection == NULL ? NULL : (init_collection = (g_object_unref (init_collection), NULL)));
			(init_it == NULL ? NULL : (init_it = (g_object_unref (init_it), NULL)));
		}
		vala_ccode_comma_expression_append_expression (ccomma, instance);
		vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccomma));
		(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
	} else {
		if (creation_call != NULL) {
			vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (creation_call));
		}
	}
	vala_ccode_generator_visit_expression (self, VALA_EXPRESSION (expr));
	(instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL)));
	(creation_call == NULL ? NULL : (creation_call = (g_object_unref (creation_call), NULL)));
}


static void vala_ccode_generator_real_visit_sizeof_expression (ValaCodeVisitor* base, ValaSizeofExpression* expr) {
	ValaCCodeGenerator * self;
	ValaCCodeIdentifier* _tmp0;
	ValaCCodeFunctionCall* _tmp1;
	ValaCCodeFunctionCall* csizeof;
	ValaCCodeIdentifier* _tmp3;
	char* _tmp2;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (expr == NULL || VALA_IS_SIZEOF_EXPRESSION (expr));
	_tmp0 = NULL;
	_tmp1 = NULL;
	csizeof = (_tmp1 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp0 = vala_ccode_identifier_new ("sizeof")))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1);
	_tmp3 = NULL;
	_tmp2 = NULL;
	vala_ccode_function_call_add_argument (csizeof, VALA_CCODE_EXPRESSION ((_tmp3 = vala_ccode_identifier_new ((_tmp2 = vala_typesymbol_get_cname (vala_data_type_get_data_type (vala_sizeof_expression_get_type_reference (expr)), FALSE))))));
	(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
	(_tmp2 = (g_free (_tmp2), NULL));
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (csizeof));
	(csizeof == NULL ? NULL : (csizeof = (g_object_unref (csizeof), NULL)));
}


static void vala_ccode_generator_real_visit_typeof_expression (ValaCodeVisitor* base, ValaTypeofExpression* expr) {
	ValaCCodeGenerator * self;
	ValaCCodeExpression* _tmp0;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (expr == NULL || VALA_IS_TYPEOF_EXPRESSION (expr));
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp0 = vala_ccode_generator_get_type_id_expression (self, vala_typeof_expression_get_type_reference (expr)))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
}


static void vala_ccode_generator_real_visit_unary_expression (ValaCodeVisitor* base, ValaUnaryExpression* expr) {
	ValaCCodeGenerator * self;
	ValaCCodeUnaryOperator op;
	ValaCCodeUnaryExpression* _tmp0;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (expr == NULL || VALA_IS_UNARY_EXPRESSION (expr));
	if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_PLUS) {
		op = VALA_CCODE_UNARY_OPERATOR_PLUS;
	} else {
		if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_MINUS) {
			op = VALA_CCODE_UNARY_OPERATOR_MINUS;
		} else {
			if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_LOGICAL_NEGATION) {
				op = VALA_CCODE_UNARY_OPERATOR_LOGICAL_NEGATION;
			} else {
				if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_BITWISE_COMPLEMENT) {
					op = VALA_CCODE_UNARY_OPERATOR_BITWISE_COMPLEMENT;
				} else {
					if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_INCREMENT) {
						op = VALA_CCODE_UNARY_OPERATOR_PREFIX_INCREMENT;
					} else {
						if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_DECREMENT) {
							op = VALA_CCODE_UNARY_OPERATOR_PREFIX_DECREMENT;
						} else {
							if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_REF) {
								op = VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF;
							} else {
								if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_OUT) {
									op = VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF;
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp0 = vala_ccode_unary_expression_new (op, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_unary_expression_get_inner (expr))))))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	vala_ccode_generator_visit_expression (self, VALA_EXPRESSION (expr));
}


static void vala_ccode_generator_real_visit_cast_expression (ValaCodeVisitor* base, ValaCastExpression* expr) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (expr == NULL || VALA_IS_CAST_EXPRESSION (expr));
	if (vala_data_type_get_data_type (vala_cast_expression_get_type_reference (expr)) != NULL && vala_typesymbol_is_subtype_of (vala_data_type_get_data_type (vala_cast_expression_get_type_reference (expr)), self->gtypeinstance_type)) {
		/* GObject cast*/
		if (vala_cast_expression_get_is_silent_cast (expr)) {
			ValaCCodeCommaExpression* ccomma;
			ValaVariableDeclarator* temp_decl;
			ValaCCodeIdentifier* ctemp;
			ValaCCodeAssignment* cinit;
			ValaCCodeFunctionCall* ccheck;
			char* _tmp0;
			ValaCCodeCastExpression* _tmp1;
			ValaCCodeCastExpression* ccast;
			ValaCCodeConstant* cnull;
			ValaCCodeConditionalExpression* _tmp2;
			ccomma = vala_ccode_comma_expression_new ();
			temp_decl = vala_ccode_generator_get_temp_variable_declarator (self, vala_expression_get_static_type (vala_cast_expression_get_inner (expr)), TRUE, VALA_CODE_NODE (expr));
			gee_collection_add (GEE_COLLECTION (self->temp_vars), temp_decl);
			ctemp = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_decl)));
			cinit = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (ctemp), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_cast_expression_get_inner (expr)))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
			ccheck = vala_ccode_generator_create_type_check (VALA_CCODE_NODE (ctemp), vala_data_type_get_data_type (vala_cast_expression_get_type_reference (expr)));
			_tmp0 = NULL;
			_tmp1 = NULL;
			ccast = (_tmp1 = vala_ccode_cast_expression_new (VALA_CCODE_EXPRESSION (ctemp), (_tmp0 = vala_data_type_get_cname (vala_cast_expression_get_type_reference (expr), FALSE, FALSE))), (_tmp0 = (g_free (_tmp0), NULL)), _tmp1);
			cnull = vala_ccode_constant_new ("NULL");
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (cinit));
			_tmp2 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_conditional_expression_new (VALA_CCODE_EXPRESSION (ccheck), VALA_CCODE_EXPRESSION (ccast), VALA_CCODE_EXPRESSION (cnull)))));
			(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
			vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccomma));
			(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
			(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
			(ctemp == NULL ? NULL : (ctemp = (g_object_unref (ctemp), NULL)));
			(cinit == NULL ? NULL : (cinit = (g_object_unref (cinit), NULL)));
			(ccheck == NULL ? NULL : (ccheck = (g_object_unref (ccheck), NULL)));
			(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
			(cnull == NULL ? NULL : (cnull = (g_object_unref (cnull), NULL)));
		} else {
			ValaInstanceCast* _tmp3;
			_tmp3 = NULL;
			vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp3 = vala_instance_cast_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_cast_expression_get_inner (expr)))), vala_data_type_get_data_type (vala_cast_expression_get_type_reference (expr))))));
			(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
		}
	} else {
		ValaCCodeCastExpression* _tmp5;
		char* _tmp4;
		if (vala_cast_expression_get_is_silent_cast (expr)) {
			vala_code_node_set_error (VALA_CODE_NODE (expr), TRUE);
			vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (expr)), "Operation not supported for this type");
			return;
		}
		_tmp5 = NULL;
		_tmp4 = NULL;
		vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp5 = vala_ccode_cast_expression_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_cast_expression_get_inner (expr)))), (_tmp4 = vala_data_type_get_cname (vala_cast_expression_get_type_reference (expr), FALSE, FALSE))))));
		(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
		(_tmp4 = (g_free (_tmp4), NULL));
	}
	vala_ccode_generator_visit_expression (self, VALA_EXPRESSION (expr));
}


static void vala_ccode_generator_real_visit_pointer_indirection (ValaCodeVisitor* base, ValaPointerIndirection* expr) {
	ValaCCodeGenerator * self;
	ValaCCodeUnaryExpression* _tmp0;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (expr == NULL || VALA_IS_POINTER_INDIRECTION (expr));
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp0 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_pointer_indirection_get_inner (expr))))))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
}


static void vala_ccode_generator_real_visit_addressof_expression (ValaCodeVisitor* base, ValaAddressofExpression* expr) {
	ValaCCodeGenerator * self;
	ValaCCodeUnaryExpression* _tmp0;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (expr == NULL || VALA_IS_ADDRESSOF_EXPRESSION (expr));
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp0 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_addressof_expression_get_inner (expr))))))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
}


static void vala_ccode_generator_real_visit_reference_transfer_expression (ValaCodeVisitor* base, ValaReferenceTransferExpression* expr) {
	ValaCCodeGenerator * self;
	ValaCCodeCommaExpression* ccomma;
	ValaVariableDeclarator* temp_decl;
	ValaCCodeIdentifier* cvar;
	ValaCCodeAssignment* _tmp0;
	ValaCCodeAssignment* _tmp2;
	ValaCCodeConstant* _tmp1;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (expr == NULL || VALA_IS_REFERENCE_TRANSFER_EXPRESSION (expr));
	/* (tmp = var, var = null, tmp) */
	ccomma = vala_ccode_comma_expression_new ();
	temp_decl = vala_ccode_generator_get_temp_variable_declarator (self, vala_expression_get_static_type (VALA_EXPRESSION (expr)), TRUE, VALA_CODE_NODE (expr));
	gee_list_insert (GEE_LIST (self->temp_vars), 0, temp_decl);
	cvar = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_decl)));
	_tmp0 = NULL;
	vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp0 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (cvar), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_reference_transfer_expression_get_inner (expr)))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	_tmp2 = NULL;
	_tmp1 = NULL;
	vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_reference_transfer_expression_get_inner (expr)))), VALA_CCODE_EXPRESSION ((_tmp1 = vala_ccode_constant_new ("NULL"))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
	(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
	(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
	vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (cvar));
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccomma));
	vala_ccode_generator_visit_expression (self, VALA_EXPRESSION (expr));
	(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
	(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
	(cvar == NULL ? NULL : (cvar = (g_object_unref (cvar), NULL)));
}


static void vala_ccode_generator_real_visit_binary_expression (ValaCodeVisitor* base, ValaBinaryExpression* expr) {
	ValaCCodeGenerator * self;
	ValaCCodeExpression* _tmp0;
	ValaCCodeExpression* cleft;
	ValaCCodeExpression* _tmp1;
	ValaCCodeExpression* cright;
	ValaCCodeBinaryOperator op;
	ValaCCodeBinaryExpression* _tmp12;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (expr == NULL || VALA_IS_BINARY_EXPRESSION (expr));
	_tmp0 = NULL;
	cleft = (_tmp0 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_binary_expression_get_left (expr)))), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	_tmp1 = NULL;
	cright = (_tmp1 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_binary_expression_get_right (expr)))), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
	if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_PLUS) {
		op = VALA_CCODE_BINARY_OPERATOR_PLUS;
	} else {
		if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_MINUS) {
			op = VALA_CCODE_BINARY_OPERATOR_MINUS;
		} else {
			if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_MUL) {
				op = VALA_CCODE_BINARY_OPERATOR_MUL;
			} else {
				if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_DIV) {
					op = VALA_CCODE_BINARY_OPERATOR_DIV;
				} else {
					if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_MOD) {
						op = VALA_CCODE_BINARY_OPERATOR_MOD;
					} else {
						if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_SHIFT_LEFT) {
							op = VALA_CCODE_BINARY_OPERATOR_SHIFT_LEFT;
						} else {
							if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_SHIFT_RIGHT) {
								op = VALA_CCODE_BINARY_OPERATOR_SHIFT_RIGHT;
							} else {
								if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_LESS_THAN) {
									op = VALA_CCODE_BINARY_OPERATOR_LESS_THAN;
								} else {
									if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_GREATER_THAN) {
										op = VALA_CCODE_BINARY_OPERATOR_GREATER_THAN;
									} else {
										if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_LESS_THAN_OR_EQUAL) {
											op = VALA_CCODE_BINARY_OPERATOR_LESS_THAN_OR_EQUAL;
										} else {
											if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL) {
												op = VALA_CCODE_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL;
											} else {
												if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_EQUALITY) {
													op = VALA_CCODE_BINARY_OPERATOR_EQUALITY;
												} else {
													if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_INEQUALITY) {
														op = VALA_CCODE_BINARY_OPERATOR_INEQUALITY;
													} else {
														if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_BITWISE_AND) {
															op = VALA_CCODE_BINARY_OPERATOR_BITWISE_AND;
														} else {
															if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_BITWISE_OR) {
																op = VALA_CCODE_BINARY_OPERATOR_BITWISE_OR;
															} else {
																if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_BITWISE_XOR) {
																	op = VALA_CCODE_BINARY_OPERATOR_BITWISE_XOR;
																} else {
																	if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_AND) {
																		op = VALA_CCODE_BINARY_OPERATOR_AND;
																	} else {
																		if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_OR) {
																			op = VALA_CCODE_BINARY_OPERATOR_OR;
																		} else {
																			if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_IN) {
																				ValaCCodeBinaryExpression* _tmp7;
																				ValaCCodeParenthesizedExpression* _tmp6;
																				ValaCCodeParenthesizedExpression* _tmp5;
																				ValaCCodeBinaryExpression* _tmp4;
																				ValaCCodeParenthesizedExpression* _tmp3;
																				ValaCCodeParenthesizedExpression* _tmp2;
																				_tmp7 = NULL;
																				_tmp6 = NULL;
																				_tmp5 = NULL;
																				_tmp4 = NULL;
																				_tmp3 = NULL;
																				_tmp2 = NULL;
																				vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp7 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION ((_tmp4 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_BITWISE_AND, VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_parenthesized_expression_new (cright))), VALA_CCODE_EXPRESSION ((_tmp3 = vala_ccode_parenthesized_expression_new (cleft))))))))), VALA_CCODE_EXPRESSION ((_tmp6 = vala_ccode_parenthesized_expression_new (cleft)))))));
																				(_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL)));
																				(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
																				(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
																				(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
																				(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
																				(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
																				vala_ccode_generator_visit_expression (self, VALA_EXPRESSION (expr));
																				(cleft == NULL ? NULL : (cleft = (g_object_unref (cleft), NULL)));
																				(cright == NULL ? NULL : (cright = (g_object_unref (cright), NULL)));
																				return;
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_EQUALITY || vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_INEQUALITY) {
		if (vala_expression_get_static_type (vala_binary_expression_get_left (expr)) != NULL && vala_expression_get_static_type (vala_binary_expression_get_right (expr)) != NULL && VALA_IS_CLASS (vala_data_type_get_data_type (vala_expression_get_static_type (vala_binary_expression_get_left (expr)))) && vala_typesymbol_is_subtype_of (VALA_TYPESYMBOL ((VALA_CLASS (vala_data_type_get_data_type (vala_expression_get_static_type (vala_binary_expression_get_left (expr)))))), self->gobject_type) && VALA_IS_CLASS (vala_data_type_get_data_type (vala_expression_get_static_type (vala_binary_expression_get_right (expr)))) && vala_typesymbol_is_subtype_of (VALA_TYPESYMBOL ((VALA_CLASS (vala_data_type_get_data_type (vala_expression_get_static_type (vala_binary_expression_get_right (expr)))))), self->gobject_type)) {
			ValaClass* _tmp8;
			ValaClass* left_cl;
			ValaClass* _tmp9;
			ValaClass* right_cl;
			_tmp8 = NULL;
			left_cl = (_tmp8 = VALA_CLASS (vala_data_type_get_data_type (vala_expression_get_static_type (vala_binary_expression_get_left (expr)))), (_tmp8 == NULL ? NULL : g_object_ref (_tmp8)));
			_tmp9 = NULL;
			right_cl = (_tmp9 = VALA_CLASS (vala_data_type_get_data_type (vala_expression_get_static_type (vala_binary_expression_get_right (expr)))), (_tmp9 == NULL ? NULL : g_object_ref (_tmp9)));
			if (left_cl != right_cl) {
				if (vala_typesymbol_is_subtype_of (VALA_TYPESYMBOL (left_cl), VALA_TYPESYMBOL (right_cl))) {
					ValaCCodeExpression* _tmp10;
					_tmp10 = NULL;
					cleft = (_tmp10 = VALA_CCODE_EXPRESSION (vala_instance_cast_new (cleft, VALA_TYPESYMBOL (right_cl))), (cleft == NULL ? NULL : (cleft = (g_object_unref (cleft), NULL))), _tmp10);
				} else {
					if (vala_typesymbol_is_subtype_of (VALA_TYPESYMBOL (right_cl), VALA_TYPESYMBOL (left_cl))) {
						ValaCCodeExpression* _tmp11;
						_tmp11 = NULL;
						cright = (_tmp11 = VALA_CCODE_EXPRESSION (vala_instance_cast_new (cright, VALA_TYPESYMBOL (left_cl))), (cright == NULL ? NULL : (cright = (g_object_unref (cright), NULL))), _tmp11);
					}
				}
			}
			(left_cl == NULL ? NULL : (left_cl = (g_object_unref (left_cl), NULL)));
			(right_cl == NULL ? NULL : (right_cl = (g_object_unref (right_cl), NULL)));
		}
	}
	_tmp12 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp12 = vala_ccode_binary_expression_new (op, cleft, cright))));
	(_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL)));
	vala_ccode_generator_visit_expression (self, VALA_EXPRESSION (expr));
	(cleft == NULL ? NULL : (cleft = (g_object_unref (cleft), NULL)));
	(cright == NULL ? NULL : (cright = (g_object_unref (cright), NULL)));
}


static ValaCCodeFunctionCall* vala_ccode_generator_create_type_check (ValaCCodeNode* ccodenode, ValaTypesymbol* type) {
	ValaCCodeIdentifier* _tmp1;
	char* _tmp0;
	ValaCCodeFunctionCall* _tmp2;
	ValaCCodeFunctionCall* ccheck;
	g_return_val_if_fail (ccodenode == NULL || VALA_IS_CCODE_NODE (ccodenode), NULL);
	g_return_val_if_fail (type == NULL || VALA_IS_TYPESYMBOL (type), NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp2 = NULL;
	ccheck = (_tmp2 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp1 = vala_ccode_identifier_new ((_tmp0 = vala_typesymbol_get_upper_case_cname (type, "IS_")))))), (_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL))), (_tmp0 = (g_free (_tmp0), NULL)), _tmp2);
	vala_ccode_function_call_add_argument (ccheck, VALA_CCODE_EXPRESSION (ccodenode));
	return ccheck;
}


static void vala_ccode_generator_real_visit_type_check (ValaCodeVisitor* base, ValaTypeCheck* expr) {
	ValaCCodeGenerator * self;
	ValaCCodeFunctionCall* _tmp0;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (expr == NULL || VALA_IS_TYPECHECK (expr));
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp0 = vala_ccode_generator_create_type_check (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_typecheck_get_expression (expr))), vala_data_type_get_data_type (vala_typecheck_get_type_reference (expr))))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
}


static void vala_ccode_generator_real_visit_conditional_expression (ValaCodeVisitor* base, ValaConditionalExpression* expr) {
	ValaCCodeGenerator * self;
	ValaCCodeConditionalExpression* _tmp0;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (expr == NULL || VALA_IS_CONDITIONAL_EXPRESSION (expr));
	_tmp0 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp0 = vala_ccode_conditional_expression_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_conditional_expression_get_condition (expr)))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_conditional_expression_get_true_expression (expr)))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_conditional_expression_get_false_expression (expr))))))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	vala_ccode_generator_visit_expression (self, VALA_EXPRESSION (expr));
}


static void vala_ccode_generator_real_visit_lambda_expression (ValaCodeVisitor* base, ValaLambdaExpression* l) {
	ValaCCodeGenerator * self;
	GeeArrayList* _tmp0;
	GeeArrayList* old_temp_vars;
	GeeArrayList* _tmp1;
	GeeArrayList* old_temp_ref_vars;
	GeeArrayList* _tmp2;
	GeeArrayList* _tmp3;
	GeeArrayList* _tmp5;
	GeeArrayList* _tmp4;
	GeeArrayList* _tmp7;
	GeeArrayList* _tmp6;
	ValaCCodeIdentifier* _tmp9;
	char* _tmp8;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (l == NULL || VALA_IS_LAMBDA_EXPRESSION (l));
	_tmp0 = NULL;
	old_temp_vars = (_tmp0 = self->temp_vars, (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	_tmp1 = NULL;
	old_temp_ref_vars = (_tmp1 = self->priv->temp_ref_vars, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
	_tmp2 = NULL;
	self->temp_vars = (_tmp2 = gee_array_list_new (VALA_TYPE_VARIABLE_DECLARATOR, ((GBoxedCopyFunc) g_object_ref), g_object_unref, g_direct_equal), (self->temp_vars == NULL ? NULL : (self->temp_vars = (g_object_unref (self->temp_vars), NULL))), _tmp2);
	_tmp3 = NULL;
	self->priv->temp_ref_vars = (_tmp3 = gee_array_list_new (VALA_TYPE_VARIABLE_DECLARATOR, ((GBoxedCopyFunc) g_object_ref), g_object_unref, g_direct_equal), (self->priv->temp_ref_vars == NULL ? NULL : (self->priv->temp_ref_vars = (g_object_unref (self->priv->temp_ref_vars), NULL))), _tmp3);
	vala_code_node_accept_children (VALA_CODE_NODE (l), VALA_CODE_VISITOR (self));
	_tmp5 = NULL;
	_tmp4 = NULL;
	self->temp_vars = (_tmp5 = (_tmp4 = old_temp_vars, (_tmp4 == NULL ? NULL : g_object_ref (_tmp4))), (self->temp_vars == NULL ? NULL : (self->temp_vars = (g_object_unref (self->temp_vars), NULL))), _tmp5);
	_tmp7 = NULL;
	_tmp6 = NULL;
	self->priv->temp_ref_vars = (_tmp7 = (_tmp6 = old_temp_ref_vars, (_tmp6 == NULL ? NULL : g_object_ref (_tmp6))), (self->priv->temp_ref_vars == NULL ? NULL : (self->priv->temp_ref_vars = (g_object_unref (self->priv->temp_ref_vars), NULL))), _tmp7);
	_tmp9 = NULL;
	_tmp8 = NULL;
	vala_code_node_set_ccodenode (VALA_CODE_NODE (l), VALA_CCODE_NODE ((_tmp9 = vala_ccode_identifier_new ((_tmp8 = vala_method_get_cname (vala_lambda_expression_get_method (l)))))));
	(_tmp9 == NULL ? NULL : (_tmp9 = (g_object_unref (_tmp9), NULL)));
	(_tmp8 = (g_free (_tmp8), NULL));
	(old_temp_vars == NULL ? NULL : (old_temp_vars = (g_object_unref (old_temp_vars), NULL)));
	(old_temp_ref_vars == NULL ? NULL : (old_temp_ref_vars = (g_object_unref (old_temp_ref_vars), NULL)));
}


ValaCCodeExpression* vala_ccode_generator_convert_from_generic_pointer (ValaCCodeGenerator* self, ValaCCodeExpression* cexpr, ValaDataType* actual_type) {
	ValaCCodeExpression* _tmp0;
	ValaCCodeExpression* result;
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	g_return_val_if_fail (cexpr == NULL || VALA_IS_CCODE_EXPRESSION (cexpr), NULL);
	g_return_val_if_fail (actual_type == NULL || VALA_IS_DATA_TYPE (actual_type), NULL);
	_tmp0 = NULL;
	result = (_tmp0 = cexpr, (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	if (VALA_IS_STRUCT (vala_data_type_get_data_type (actual_type))) {
		ValaStruct* _tmp1;
		ValaStruct* st;
		_tmp1 = NULL;
		st = (_tmp1 = VALA_STRUCT (vala_data_type_get_data_type (actual_type)), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
		if (VALA_TYPESYMBOL (st) == vala_data_type_get_data_type (self->uint_type)) {
			ValaCCodeIdentifier* _tmp2;
			ValaCCodeFunctionCall* _tmp3;
			ValaCCodeFunctionCall* cconv;
			ValaCCodeExpression* _tmp5;
			ValaCCodeFunctionCall* _tmp4;
			_tmp2 = NULL;
			_tmp3 = NULL;
			cconv = (_tmp3 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_identifier_new ("GPOINTER_TO_UINT")))), (_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL))), _tmp3);
			vala_ccode_function_call_add_argument (cconv, cexpr);
			_tmp5 = NULL;
			_tmp4 = NULL;
			result = (_tmp5 = VALA_CCODE_EXPRESSION ((_tmp4 = cconv, (_tmp4 == NULL ? NULL : g_object_ref (_tmp4)))), (result == NULL ? NULL : (result = (g_object_unref (result), NULL))), _tmp5);
			(cconv == NULL ? NULL : (cconv = (g_object_unref (cconv), NULL)));
		} else {
			if (VALA_TYPESYMBOL (st) == vala_data_type_get_data_type (self->bool_type) || vala_struct_is_integer_type (st)) {
				ValaCCodeIdentifier* _tmp6;
				ValaCCodeFunctionCall* _tmp7;
				ValaCCodeFunctionCall* cconv;
				ValaCCodeExpression* _tmp9;
				ValaCCodeFunctionCall* _tmp8;
				_tmp6 = NULL;
				_tmp7 = NULL;
				cconv = (_tmp7 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp6 = vala_ccode_identifier_new ("GPOINTER_TO_INT")))), (_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL))), _tmp7);
				vala_ccode_function_call_add_argument (cconv, cexpr);
				_tmp9 = NULL;
				_tmp8 = NULL;
				result = (_tmp9 = VALA_CCODE_EXPRESSION ((_tmp8 = cconv, (_tmp8 == NULL ? NULL : g_object_ref (_tmp8)))), (result == NULL ? NULL : (result = (g_object_unref (result), NULL))), _tmp9);
				(cconv == NULL ? NULL : (cconv = (g_object_unref (cconv), NULL)));
			}
		}
		(st == NULL ? NULL : (st = (g_object_unref (st), NULL)));
	}
	return result;
}


ValaCCodeExpression* vala_ccode_generator_convert_to_generic_pointer (ValaCCodeGenerator* self, ValaCCodeExpression* cexpr, ValaDataType* actual_type) {
	ValaCCodeExpression* _tmp0;
	ValaCCodeExpression* result;
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	g_return_val_if_fail (cexpr == NULL || VALA_IS_CCODE_EXPRESSION (cexpr), NULL);
	g_return_val_if_fail (actual_type == NULL || VALA_IS_DATA_TYPE (actual_type), NULL);
	_tmp0 = NULL;
	result = (_tmp0 = cexpr, (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	if (VALA_IS_STRUCT (vala_data_type_get_data_type (actual_type))) {
		ValaStruct* _tmp1;
		ValaStruct* st;
		_tmp1 = NULL;
		st = (_tmp1 = VALA_STRUCT (vala_data_type_get_data_type (actual_type)), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
		if (VALA_TYPESYMBOL (st) == vala_data_type_get_data_type (self->uint_type)) {
			ValaCCodeIdentifier* _tmp2;
			ValaCCodeFunctionCall* _tmp3;
			ValaCCodeFunctionCall* cconv;
			ValaCCodeExpression* _tmp5;
			ValaCCodeFunctionCall* _tmp4;
			_tmp2 = NULL;
			_tmp3 = NULL;
			cconv = (_tmp3 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_identifier_new ("GUINT_TO_POINTER")))), (_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL))), _tmp3);
			vala_ccode_function_call_add_argument (cconv, cexpr);
			_tmp5 = NULL;
			_tmp4 = NULL;
			result = (_tmp5 = VALA_CCODE_EXPRESSION ((_tmp4 = cconv, (_tmp4 == NULL ? NULL : g_object_ref (_tmp4)))), (result == NULL ? NULL : (result = (g_object_unref (result), NULL))), _tmp5);
			(cconv == NULL ? NULL : (cconv = (g_object_unref (cconv), NULL)));
		} else {
			if (VALA_TYPESYMBOL (st) == vala_data_type_get_data_type (self->bool_type) || vala_struct_is_integer_type (st)) {
				ValaCCodeIdentifier* _tmp6;
				ValaCCodeFunctionCall* _tmp7;
				ValaCCodeFunctionCall* cconv;
				ValaCCodeExpression* _tmp9;
				ValaCCodeFunctionCall* _tmp8;
				_tmp6 = NULL;
				_tmp7 = NULL;
				cconv = (_tmp7 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp6 = vala_ccode_identifier_new ("GINT_TO_POINTER")))), (_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL))), _tmp7);
				vala_ccode_function_call_add_argument (cconv, cexpr);
				_tmp9 = NULL;
				_tmp8 = NULL;
				result = (_tmp9 = VALA_CCODE_EXPRESSION ((_tmp8 = cconv, (_tmp8 == NULL ? NULL : g_object_ref (_tmp8)))), (result == NULL ? NULL : (result = (g_object_unref (result), NULL))), _tmp9);
				(cconv == NULL ? NULL : (cconv = (g_object_unref (cconv), NULL)));
			}
		}
		(st == NULL ? NULL : (st = (g_object_unref (st), NULL)));
	}
	return result;
}


ValaCCodeExpression* vala_ccode_generator_get_implicit_cast_expression (ValaCCodeGenerator* self, ValaCCodeExpression* cexpr, ValaDataType* expression_type, ValaDataType* target_type) {
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	g_return_val_if_fail (cexpr == NULL || VALA_IS_CCODE_EXPRESSION (cexpr), NULL);
	g_return_val_if_fail (expression_type == NULL || VALA_IS_DATA_TYPE (expression_type), NULL);
	g_return_val_if_fail (target_type == NULL || VALA_IS_DATA_TYPE (target_type), NULL);
	if (NULL == expression_type) {
		ValaCCodeExpression* _tmp0;
		_tmp0 = NULL;
		return (_tmp0 = cexpr, (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	}
	if (vala_data_type_get_data_type (expression_type) != NULL && vala_data_type_get_data_type (expression_type) == vala_data_type_get_data_type (target_type)) {
		ValaCCodeExpression* _tmp2;
		_tmp2 = NULL;
		return (_tmp2 = cexpr, (_tmp2 == NULL ? NULL : g_object_ref (_tmp2)));
	}
	/* same type, no cast required*/
	if (vala_data_type_get_type_parameter (expression_type) != NULL) {
		return vala_ccode_generator_convert_from_generic_pointer (self, cexpr, target_type);
	} else {
		if (vala_data_type_get_type_parameter (target_type) != NULL) {
			return vala_ccode_generator_convert_to_generic_pointer (self, cexpr, expression_type);
		}
	}
	if (VALA_IS_NULL_TYPE (expression_type)) {
		ValaCCodeExpression* _tmp6;
		_tmp6 = NULL;
		return (_tmp6 = cexpr, (_tmp6 == NULL ? NULL : g_object_ref (_tmp6)));
	}
	/* null literal, no cast required when not converting to generic type pointer*/
	if (vala_code_context_get_checking (self->priv->context) && vala_data_type_get_data_type (target_type) != NULL && vala_typesymbol_is_subtype_of (vala_data_type_get_data_type (target_type), self->gtypeinstance_type)) {
		return VALA_CCODE_EXPRESSION (vala_instance_cast_new (cexpr, vala_data_type_get_data_type (target_type)));
	} else {
		char* _tmp10;
		char* _tmp9;
		gboolean _tmp11;
		_tmp10 = NULL;
		_tmp9 = NULL;
		if ((_tmp11 = vala_data_type_get_data_type (target_type) != NULL && vala_typesymbol_is_reference_type (vala_data_type_get_data_type (target_type)) && g_utf8_collate ((_tmp9 = vala_data_type_get_cname (expression_type, FALSE, FALSE)), (_tmp10 = vala_data_type_get_cname (target_type, FALSE, FALSE))) != 0, (_tmp10 = (g_free (_tmp10), NULL)), (_tmp9 = (g_free (_tmp9), NULL)), _tmp11)) {
			char* _tmp12;
			ValaCCodeCastExpression* _tmp13;
			_tmp12 = NULL;
			_tmp13 = NULL;
			return VALA_CCODE_EXPRESSION ((_tmp13 = vala_ccode_cast_expression_new (cexpr, (_tmp12 = vala_data_type_get_cname (target_type, FALSE, FALSE))), (_tmp12 = (g_free (_tmp12), NULL)), _tmp13));
		} else {
			if (VALA_IS_DELEGATE_TYPE (target_type) && VALA_IS_METHOD_TYPE (expression_type)) {
				char* _tmp15;
				ValaCCodeCastExpression* _tmp16;
				_tmp15 = NULL;
				_tmp16 = NULL;
				return VALA_CCODE_EXPRESSION ((_tmp16 = vala_ccode_cast_expression_new (cexpr, (_tmp15 = vala_data_type_get_cname (target_type, FALSE, FALSE))), (_tmp15 = (g_free (_tmp15), NULL)), _tmp16));
			} else {
				ValaCCodeExpression* _tmp18;
				_tmp18 = NULL;
				return (_tmp18 = cexpr, (_tmp18 == NULL ? NULL : g_object_ref (_tmp18)));
			}
		}
	}
}


static void vala_ccode_generator_real_visit_assignment (ValaCodeVisitor* base, ValaAssignment* a) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (a == NULL || VALA_IS_ASSIGNMENT (a));
	vala_code_binding_emit (vala_code_node_get_code_binding (VALA_CODE_NODE (a)));
}


ValaCCodeFunctionCall* vala_ccode_generator_get_property_set_call (ValaCCodeGenerator* self, ValaProperty* prop, ValaMemberAccess* ma, ValaCCodeExpression* cexpr) {
	ValaClass* _tmp0;
	ValaClass* cl;
	char* set_func;
	ValaProperty* _tmp1;
	ValaProperty* base_property;
	ValaCCodeIdentifier* _tmp9;
	ValaCCodeFunctionCall* _tmp10;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeExpression* instance;
	ValaDataType* instance_expression_type;
	ValaDataType* instance_target_type;
	ValaCCodeExpression* _tmp17;
	ValaCCodeFunctionCall* _tmp20;
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	g_return_val_if_fail (prop == NULL || VALA_IS_PROPERTY (prop), NULL);
	g_return_val_if_fail (ma == NULL || VALA_IS_MEMBER_ACCESS (ma), NULL);
	g_return_val_if_fail (cexpr == NULL || VALA_IS_CCODE_EXPRESSION (cexpr), NULL);
	_tmp0 = NULL;
	cl = (_tmp0 = VALA_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (prop))), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	set_func = g_strdup ("g_object_set");
	_tmp1 = NULL;
	base_property = (_tmp1 = prop, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
	if (!vala_property_get_no_accessor_method (prop)) {
		ValaTypesymbol* _tmp6;
		ValaTypesymbol* base_property_type;
		char* _tmp8;
		char* _tmp7;
		if (vala_property_get_base_property (prop) != NULL) {
			ValaProperty* _tmp3;
			ValaProperty* _tmp2;
			_tmp3 = NULL;
			_tmp2 = NULL;
			base_property = (_tmp3 = (_tmp2 = vala_property_get_base_property (prop), (_tmp2 == NULL ? NULL : g_object_ref (_tmp2))), (base_property == NULL ? NULL : (base_property = (g_object_unref (base_property), NULL))), _tmp3);
		} else {
			if (vala_property_get_base_interface_property (prop) != NULL) {
				ValaProperty* _tmp5;
				ValaProperty* _tmp4;
				_tmp5 = NULL;
				_tmp4 = NULL;
				base_property = (_tmp5 = (_tmp4 = vala_property_get_base_interface_property (prop), (_tmp4 == NULL ? NULL : g_object_ref (_tmp4))), (base_property == NULL ? NULL : (base_property = (g_object_unref (base_property), NULL))), _tmp5);
			}
		}
		_tmp6 = NULL;
		base_property_type = (_tmp6 = VALA_TYPESYMBOL (vala_symbol_get_parent_symbol (VALA_SYMBOL (base_property))), (_tmp6 == NULL ? NULL : g_object_ref (_tmp6)));
		_tmp8 = NULL;
		_tmp7 = NULL;
		set_func = (_tmp8 = g_strdup_printf ("%s_set_%s", (_tmp7 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (base_property_type), NULL)), vala_symbol_get_name (VALA_SYMBOL (base_property))), (set_func = (g_free (set_func), NULL)), _tmp8);
		(_tmp7 = (g_free (_tmp7), NULL));
		(base_property_type == NULL ? NULL : (base_property_type = (g_object_unref (base_property_type), NULL)));
	}
	_tmp9 = NULL;
	_tmp10 = NULL;
	ccall = (_tmp10 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp9 = vala_ccode_identifier_new (set_func)))), (_tmp9 == NULL ? NULL : (_tmp9 = (g_object_unref (_tmp9), NULL))), _tmp10);
	/* target instance is first argument */
	instance = NULL;
	instance_expression_type = NULL;
	if (vala_member_access_get_inner (ma) == NULL) {
		ValaCCodeExpression* _tmp11;
		ValaDataType* _tmp12;
		_tmp11 = NULL;
		instance = (_tmp11 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("self")), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), _tmp11);
		_tmp12 = NULL;
		instance_expression_type = (_tmp12 = vala_data_type_new (), (instance_expression_type == NULL ? NULL : (instance_expression_type = (g_object_unref (instance_expression_type), NULL))), _tmp12);
		vala_data_type_set_data_type (instance_expression_type, self->current_type_symbol);
	} else {
		ValaCCodeExpression* _tmp14;
		ValaCCodeExpression* _tmp13;
		ValaDataType* _tmp16;
		ValaDataType* _tmp15;
		_tmp14 = NULL;
		_tmp13 = NULL;
		instance = (_tmp14 = (_tmp13 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_member_access_get_inner (ma)))), (_tmp13 == NULL ? NULL : g_object_ref (_tmp13))), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), _tmp14);
		_tmp16 = NULL;
		_tmp15 = NULL;
		instance_expression_type = (_tmp16 = (_tmp15 = vala_expression_get_static_type (vala_member_access_get_inner (ma)), (_tmp15 == NULL ? NULL : g_object_ref (_tmp15))), (instance_expression_type == NULL ? NULL : (instance_expression_type = (g_object_unref (instance_expression_type), NULL))), _tmp16);
	}
	instance_target_type = vala_data_type_new ();
	vala_data_type_set_data_type (instance_target_type, VALA_TYPESYMBOL (vala_symbol_get_parent_symbol (VALA_SYMBOL (base_property))));
	_tmp17 = NULL;
	instance = (_tmp17 = vala_ccode_generator_get_implicit_cast_expression (self, instance, instance_expression_type, instance_target_type), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), _tmp17);
	vala_ccode_function_call_add_argument (ccall, instance);
	if (vala_property_get_no_accessor_method (prop)) {
		ValaCCodeConstant* _tmp18;
		/* property name is second argument of g_object_set */
		_tmp18 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp18 = vala_property_get_canonical_cconstant (prop))));
		(_tmp18 == NULL ? NULL : (_tmp18 = (g_object_unref (_tmp18), NULL)));
	}
	vala_ccode_function_call_add_argument (ccall, cexpr);
	if (vala_property_get_no_accessor_method (prop)) {
		ValaCCodeConstant* _tmp19;
		_tmp19 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp19 = vala_ccode_constant_new ("NULL"))));
		(_tmp19 == NULL ? NULL : (_tmp19 = (g_object_unref (_tmp19), NULL)));
	}
	_tmp20 = NULL;
	return (_tmp20 = ccall, (cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL))), (set_func = (g_free (set_func), NULL)), (base_property == NULL ? NULL : (base_property = (g_object_unref (base_property), NULL))), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), (instance_expression_type == NULL ? NULL : (instance_expression_type = (g_object_unref (instance_expression_type), NULL))), (instance_target_type == NULL ? NULL : (instance_target_type = (g_object_unref (instance_target_type), NULL))), _tmp20);
}


static ValaCodeBinding* vala_ccode_generator_real_create_namespace_binding (ValaCodeGenerator* base, ValaNamespace* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (node == NULL || VALA_IS_NAMESPACE (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_class_binding (ValaCodeGenerator* base, ValaClass* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (node == NULL || VALA_IS_CLASS (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_struct_binding (ValaCodeGenerator* base, ValaStruct* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (node == NULL || VALA_IS_STRUCT (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_interface_binding (ValaCodeGenerator* base, ValaInterface* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (node == NULL || VALA_IS_INTERFACE (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_enum_binding (ValaCodeGenerator* base, ValaEnum* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (node == NULL || VALA_IS_ENUM (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_enum_value_binding (ValaCodeGenerator* base, ValaEnumValue* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (node == NULL || VALA_IS_ENUM_VALUE (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_delegate_binding (ValaCodeGenerator* base, ValaDelegate* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (node == NULL || VALA_IS_DELEGATE (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_constant_binding (ValaCodeGenerator* base, ValaConstant* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (node == NULL || VALA_IS_CONSTANT (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_field_binding (ValaCodeGenerator* base, ValaField* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (node == NULL || VALA_IS_FIELD (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_method_binding (ValaCodeGenerator* base, ValaMethod* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (node == NULL || VALA_IS_METHOD (node), NULL);
	return VALA_CODE_BINDING (vala_ccode_method_binding_new (VALA_CODE_GENERATOR (self), node));
}


static ValaCodeBinding* vala_ccode_generator_real_create_creation_method_binding (ValaCodeGenerator* base, ValaCreationMethod* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (node == NULL || VALA_IS_CREATION_METHOD (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_formal_parameter_binding (ValaCodeGenerator* base, ValaFormalParameter* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (node == NULL || VALA_IS_FORMAL_PARAMETER (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_property_binding (ValaCodeGenerator* base, ValaProperty* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (node == NULL || VALA_IS_PROPERTY (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_property_accessor_binding (ValaCodeGenerator* base, ValaPropertyAccessor* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (node == NULL || VALA_IS_PROPERTY_ACCESSOR (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_signal_binding (ValaCodeGenerator* base, ValaSignal* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (node == NULL || VALA_IS_SIGNAL (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_constructor_binding (ValaCodeGenerator* base, ValaConstructor* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (node == NULL || VALA_IS_CONSTRUCTOR (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_destructor_binding (ValaCodeGenerator* base, ValaDestructor* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (node == NULL || VALA_IS_DESTRUCTOR (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_type_parameter_binding (ValaCodeGenerator* base, ValaTypeParameter* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (node == NULL || VALA_IS_TYPEPARAMETER (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_block_binding (ValaCodeGenerator* base, ValaBlock* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (node == NULL || VALA_IS_BLOCK (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_empty_statement_binding (ValaCodeGenerator* base, ValaEmptyStatement* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (node == NULL || VALA_IS_EMPTY_STATEMENT (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_declaration_statement_binding (ValaCodeGenerator* base, ValaDeclarationStatement* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (node == NULL || VALA_IS_DECLARATION_STATEMENT (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_local_variable_declaration_binding (ValaCodeGenerator* base, ValaLocalVariableDeclaration* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (node == NULL || VALA_IS_LOCAL_VARIABLE_DECLARATION (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_variable_declarator_binding (ValaCodeGenerator* base, ValaVariableDeclarator* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (node == NULL || VALA_IS_VARIABLE_DECLARATOR (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_initializer_list_binding (ValaCodeGenerator* base, ValaInitializerList* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (node == NULL || VALA_IS_INITIALIZER_LIST (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_expression_statement_binding (ValaCodeGenerator* base, ValaExpressionStatement* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (node == NULL || VALA_IS_EXPRESSION_STATEMENT (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_if_statement_binding (ValaCodeGenerator* base, ValaIfStatement* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (node == NULL || VALA_IS_IF_STATEMENT (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_switch_statement_binding (ValaCodeGenerator* base, ValaSwitchStatement* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (node == NULL || VALA_IS_SWITCH_STATEMENT (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_switch_section_binding (ValaCodeGenerator* base, ValaSwitchSection* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (node == NULL || VALA_IS_SWITCH_SECTION (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_switch_label_binding (ValaCodeGenerator* base, ValaSwitchLabel* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (node == NULL || VALA_IS_SWITCH_LABEL (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_while_statement_binding (ValaCodeGenerator* base, ValaWhileStatement* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (node == NULL || VALA_IS_WHILE_STATEMENT (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_do_statement_binding (ValaCodeGenerator* base, ValaDoStatement* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (node == NULL || VALA_IS_DO_STATEMENT (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_for_statement_binding (ValaCodeGenerator* base, ValaForStatement* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (node == NULL || VALA_IS_FOR_STATEMENT (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_foreach_statement_binding (ValaCodeGenerator* base, ValaForeachStatement* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (node == NULL || VALA_IS_FOREACH_STATEMENT (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_break_statement_binding (ValaCodeGenerator* base, ValaBreakStatement* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (node == NULL || VALA_IS_BREAK_STATEMENT (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_continue_statement_binding (ValaCodeGenerator* base, ValaContinueStatement* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (node == NULL || VALA_IS_CONTINUE_STATEMENT (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_return_statement_binding (ValaCodeGenerator* base, ValaReturnStatement* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (node == NULL || VALA_IS_RETURN_STATEMENT (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_throw_statement_binding (ValaCodeGenerator* base, ValaThrowStatement* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (node == NULL || VALA_IS_THROW_STATEMENT (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_try_statement_binding (ValaCodeGenerator* base, ValaTryStatement* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (node == NULL || VALA_IS_TRY_STATEMENT (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_catch_clause_binding (ValaCodeGenerator* base, ValaCatchClause* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (node == NULL || VALA_IS_CATCH_CLAUSE (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_lock_statement_binding (ValaCodeGenerator* base, ValaLockStatement* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (node == NULL || VALA_IS_LOCK_STATEMENT (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_array_creation_expression_binding (ValaCodeGenerator* base, ValaArrayCreationExpression* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (node == NULL || VALA_IS_ARRAY_CREATION_EXPRESSION (node), NULL);
	return VALA_CODE_BINDING (vala_ccode_array_creation_expression_binding_new (VALA_CODE_GENERATOR (self), node));
}


static ValaCodeBinding* vala_ccode_generator_real_create_boolean_literal_binding (ValaCodeGenerator* base, ValaBooleanLiteral* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (node == NULL || VALA_IS_BOOLEAN_LITERAL (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_character_literal_binding (ValaCodeGenerator* base, ValaCharacterLiteral* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (node == NULL || VALA_IS_CHARACTER_LITERAL (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_integer_literal_binding (ValaCodeGenerator* base, ValaIntegerLiteral* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (node == NULL || VALA_IS_INTEGER_LITERAL (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_real_literal_binding (ValaCodeGenerator* base, ValaRealLiteral* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (node == NULL || VALA_IS_REAL_LITERAL (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_string_literal_binding (ValaCodeGenerator* base, ValaStringLiteral* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (node == NULL || VALA_IS_STRING_LITERAL (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_null_literal_binding (ValaCodeGenerator* base, ValaNullLiteral* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (node == NULL || VALA_IS_NULL_LITERAL (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_literal_expression_binding (ValaCodeGenerator* base, ValaLiteralExpression* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (node == NULL || VALA_IS_LITERAL_EXPRESSION (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_parenthesized_expression_binding (ValaCodeGenerator* base, ValaParenthesizedExpression* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (node == NULL || VALA_IS_PARENTHESIZED_EXPRESSION (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_member_access_binding (ValaCodeGenerator* base, ValaMemberAccess* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (node == NULL || VALA_IS_MEMBER_ACCESS (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_member_access_simple_binding (ValaCodeGenerator* base, ValaMemberAccess* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (node == NULL || VALA_IS_MEMBER_ACCESS (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_invocation_expression_binding (ValaCodeGenerator* base, ValaInvocationExpression* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (node == NULL || VALA_IS_INVOCATION_EXPRESSION (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_element_access_binding (ValaCodeGenerator* base, ValaElementAccess* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (node == NULL || VALA_IS_ELEMENT_ACCESS (node), NULL);
	return VALA_CODE_BINDING (vala_ccode_element_access_binding_new (VALA_CODE_GENERATOR (self), node));
}


static ValaCodeBinding* vala_ccode_generator_real_create_base_access_binding (ValaCodeGenerator* base, ValaBaseAccess* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (node == NULL || VALA_IS_BASE_ACCESS (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_postfix_expression_binding (ValaCodeGenerator* base, ValaPostfixExpression* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (node == NULL || VALA_IS_POSTFIX_EXPRESSION (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_object_creation_expression_binding (ValaCodeGenerator* base, ValaObjectCreationExpression* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (node == NULL || VALA_IS_OBJECT_CREATION_EXPRESSION (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_sizeof_expression_binding (ValaCodeGenerator* base, ValaSizeofExpression* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (node == NULL || VALA_IS_SIZEOF_EXPRESSION (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_typeof_expression_binding (ValaCodeGenerator* base, ValaTypeofExpression* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (node == NULL || VALA_IS_TYPEOF_EXPRESSION (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_unary_expression_binding (ValaCodeGenerator* base, ValaUnaryExpression* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (node == NULL || VALA_IS_UNARY_EXPRESSION (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_cast_expression_binding (ValaCodeGenerator* base, ValaCastExpression* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (node == NULL || VALA_IS_CAST_EXPRESSION (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_pointer_indirection_binding (ValaCodeGenerator* base, ValaPointerIndirection* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (node == NULL || VALA_IS_POINTER_INDIRECTION (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_addressof_expression_binding (ValaCodeGenerator* base, ValaAddressofExpression* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (node == NULL || VALA_IS_ADDRESSOF_EXPRESSION (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_reference_transfer_expression_binding (ValaCodeGenerator* base, ValaReferenceTransferExpression* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (node == NULL || VALA_IS_REFERENCE_TRANSFER_EXPRESSION (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_binary_expression_binding (ValaCodeGenerator* base, ValaBinaryExpression* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (node == NULL || VALA_IS_BINARY_EXPRESSION (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_type_check_binding (ValaCodeGenerator* base, ValaTypeCheck* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (node == NULL || VALA_IS_TYPECHECK (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_conditional_expression_binding (ValaCodeGenerator* base, ValaConditionalExpression* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (node == NULL || VALA_IS_CONDITIONAL_EXPRESSION (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_lambda_expression_binding (ValaCodeGenerator* base, ValaLambdaExpression* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (node == NULL || VALA_IS_LAMBDA_EXPRESSION (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_lambda_expression_with_statement_body_binding (ValaCodeGenerator* base, ValaLambdaExpression* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (node == NULL || VALA_IS_LAMBDA_EXPRESSION (node), NULL);
	return NULL;
}


static ValaCodeBinding* vala_ccode_generator_real_create_assignment_binding (ValaCodeGenerator* base, ValaAssignment* node) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_val_if_fail (node == NULL || VALA_IS_ASSIGNMENT (node), NULL);
	return VALA_CODE_BINDING (vala_ccode_assignment_binding_new (VALA_CODE_GENERATOR (self), node));
}


static void vala_ccode_generator_real_visit_class (ValaCodeVisitor* base, ValaClass* cl) {
	ValaCCodeGenerator * self;
	ValaSymbol* _tmp0;
	ValaSymbol* old_symbol;
	ValaTypesymbol* _tmp1;
	ValaTypesymbol* old_type_symbol;
	ValaClass* _tmp2;
	ValaClass* old_class;
	ValaCCodeStruct* _tmp3;
	ValaCCodeStruct* old_instance_struct;
	ValaCCodeStruct* _tmp4;
	ValaCCodeStruct* old_type_struct;
	ValaCCodeStruct* _tmp5;
	ValaCCodeStruct* old_instance_priv_struct;
	ValaCCodeEnum* _tmp6;
	ValaCCodeEnum* old_prop_enum;
	ValaCCodeFragment* _tmp7;
	ValaCCodeFragment* old_class_init_fragment;
	ValaCCodeFragment* _tmp8;
	ValaCCodeFragment* old_instance_init_fragment;
	ValaCCodeFragment* _tmp9;
	ValaCCodeFragment* old_instance_dispose_fragment;
	ValaSymbol* _tmp11;
	ValaClass* _tmp10;
	ValaTypesymbol* _tmp13;
	ValaClass* _tmp12;
	ValaClass* _tmp15;
	ValaClass* _tmp14;
	gboolean is_gtypeinstance;
	gboolean is_gobject;
	gboolean is_fundamental;
	char* _tmp16;
	gboolean _tmp17;
	ValaCCodeFragment* decl_frag;
	ValaCCodeFragment* def_frag;
	ValaTypesymbol* _tmp183;
	ValaTypesymbol* _tmp182;
	ValaClass* _tmp185;
	ValaClass* _tmp184;
	ValaCCodeStruct* _tmp187;
	ValaCCodeStruct* _tmp186;
	ValaCCodeStruct* _tmp189;
	ValaCCodeStruct* _tmp188;
	ValaCCodeStruct* _tmp191;
	ValaCCodeStruct* _tmp190;
	ValaCCodeEnum* _tmp193;
	ValaCCodeEnum* _tmp192;
	ValaCCodeFragment* _tmp195;
	ValaCCodeFragment* _tmp194;
	ValaCCodeFragment* _tmp197;
	ValaCCodeFragment* _tmp196;
	ValaCCodeFragment* _tmp199;
	ValaCCodeFragment* _tmp198;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (cl == NULL || VALA_IS_CLASS (cl));
	_tmp0 = NULL;
	old_symbol = (_tmp0 = self->priv->current_symbol, (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	_tmp1 = NULL;
	old_type_symbol = (_tmp1 = self->current_type_symbol, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
	_tmp2 = NULL;
	old_class = (_tmp2 = self->priv->current_class, (_tmp2 == NULL ? NULL : g_object_ref (_tmp2)));
	_tmp3 = NULL;
	old_instance_struct = (_tmp3 = self->priv->instance_struct, (_tmp3 == NULL ? NULL : g_object_ref (_tmp3)));
	_tmp4 = NULL;
	old_type_struct = (_tmp4 = self->priv->type_struct, (_tmp4 == NULL ? NULL : g_object_ref (_tmp4)));
	_tmp5 = NULL;
	old_instance_priv_struct = (_tmp5 = self->priv->instance_priv_struct, (_tmp5 == NULL ? NULL : g_object_ref (_tmp5)));
	_tmp6 = NULL;
	old_prop_enum = (_tmp6 = self->priv->prop_enum, (_tmp6 == NULL ? NULL : g_object_ref (_tmp6)));
	_tmp7 = NULL;
	old_class_init_fragment = (_tmp7 = self->priv->class_init_fragment, (_tmp7 == NULL ? NULL : g_object_ref (_tmp7)));
	_tmp8 = NULL;
	old_instance_init_fragment = (_tmp8 = self->priv->instance_init_fragment, (_tmp8 == NULL ? NULL : g_object_ref (_tmp8)));
	_tmp9 = NULL;
	old_instance_dispose_fragment = (_tmp9 = self->priv->instance_dispose_fragment, (_tmp9 == NULL ? NULL : g_object_ref (_tmp9)));
	_tmp11 = NULL;
	_tmp10 = NULL;
	self->priv->current_symbol = (_tmp11 = VALA_SYMBOL ((_tmp10 = cl, (_tmp10 == NULL ? NULL : g_object_ref (_tmp10)))), (self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL))), _tmp11);
	_tmp13 = NULL;
	_tmp12 = NULL;
	self->current_type_symbol = (_tmp13 = VALA_TYPESYMBOL ((_tmp12 = cl, (_tmp12 == NULL ? NULL : g_object_ref (_tmp12)))), (self->current_type_symbol == NULL ? NULL : (self->current_type_symbol = (g_object_unref (self->current_type_symbol), NULL))), _tmp13);
	_tmp15 = NULL;
	_tmp14 = NULL;
	self->priv->current_class = (_tmp15 = (_tmp14 = cl, (_tmp14 == NULL ? NULL : g_object_ref (_tmp14))), (self->priv->current_class == NULL ? NULL : (self->priv->current_class = (g_object_unref (self->priv->current_class), NULL))), _tmp15);
	is_gtypeinstance = vala_typesymbol_is_subtype_of (VALA_TYPESYMBOL (cl), self->gtypeinstance_type);
	is_gobject = vala_typesymbol_is_subtype_of (VALA_TYPESYMBOL (cl), self->gobject_type);
	is_fundamental = (VALA_TYPESYMBOL (vala_class_get_base_class (cl)) == self->gtypeinstance_type);
	_tmp16 = NULL;
	if ((_tmp17 = g_utf8_strlen ((_tmp16 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE)), -1) < 3, (_tmp16 = (g_free (_tmp16), NULL)), _tmp17)) {
		char* _tmp19;
		char* _tmp18;
		vala_code_node_set_error (VALA_CODE_NODE (cl), TRUE);
		_tmp19 = NULL;
		_tmp18 = NULL;
		vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (cl)), (_tmp19 = g_strdup_printf ("Class name `%s' is too short", (_tmp18 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE)))));
		(_tmp19 = (g_free (_tmp19), NULL));
		(_tmp18 = (g_free (_tmp18), NULL));
		(old_symbol == NULL ? NULL : (old_symbol = (g_object_unref (old_symbol), NULL)));
		(old_type_symbol == NULL ? NULL : (old_type_symbol = (g_object_unref (old_type_symbol), NULL)));
		(old_class == NULL ? NULL : (old_class = (g_object_unref (old_class), NULL)));
		(old_instance_struct == NULL ? NULL : (old_instance_struct = (g_object_unref (old_instance_struct), NULL)));
		(old_type_struct == NULL ? NULL : (old_type_struct = (g_object_unref (old_type_struct), NULL)));
		(old_instance_priv_struct == NULL ? NULL : (old_instance_priv_struct = (g_object_unref (old_instance_priv_struct), NULL)));
		(old_prop_enum == NULL ? NULL : (old_prop_enum = (g_object_unref (old_prop_enum), NULL)));
		(old_class_init_fragment == NULL ? NULL : (old_class_init_fragment = (g_object_unref (old_class_init_fragment), NULL)));
		(old_instance_init_fragment == NULL ? NULL : (old_instance_init_fragment = (g_object_unref (old_instance_init_fragment), NULL)));
		(old_instance_dispose_fragment == NULL ? NULL : (old_instance_dispose_fragment = (g_object_unref (old_instance_dispose_fragment), NULL)));
		return;
	}
	if (!vala_class_get_is_static (cl)) {
		ValaCCodeStruct* _tmp22;
		char* _tmp21;
		char* _tmp20;
		ValaCCodeStruct* _tmp25;
		char* _tmp24;
		char* _tmp23;
		ValaCCodeStruct* _tmp28;
		char* _tmp27;
		char* _tmp26;
		ValaCCodeEnum* _tmp29;
		ValaCCodeEnumValue* _tmp32;
		char* _tmp31;
		char* _tmp30;
		ValaCCodeFragment* _tmp33;
		ValaCCodeFragment* _tmp34;
		ValaCCodeFragment* _tmp35;
		_tmp22 = NULL;
		_tmp21 = NULL;
		_tmp20 = NULL;
		self->priv->instance_struct = (_tmp22 = vala_ccode_struct_new ((_tmp21 = g_strdup_printf ("_%s", (_tmp20 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE))))), (self->priv->instance_struct == NULL ? NULL : (self->priv->instance_struct = (g_object_unref (self->priv->instance_struct), NULL))), _tmp22);
		(_tmp21 = (g_free (_tmp21), NULL));
		(_tmp20 = (g_free (_tmp20), NULL));
		_tmp25 = NULL;
		_tmp24 = NULL;
		_tmp23 = NULL;
		self->priv->type_struct = (_tmp25 = vala_ccode_struct_new ((_tmp24 = g_strdup_printf ("_%sClass", (_tmp23 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE))))), (self->priv->type_struct == NULL ? NULL : (self->priv->type_struct = (g_object_unref (self->priv->type_struct), NULL))), _tmp25);
		(_tmp24 = (g_free (_tmp24), NULL));
		(_tmp23 = (g_free (_tmp23), NULL));
		_tmp28 = NULL;
		_tmp27 = NULL;
		_tmp26 = NULL;
		self->priv->instance_priv_struct = (_tmp28 = vala_ccode_struct_new ((_tmp27 = g_strdup_printf ("_%sPrivate", (_tmp26 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE))))), (self->priv->instance_priv_struct == NULL ? NULL : (self->priv->instance_priv_struct = (g_object_unref (self->priv->instance_priv_struct), NULL))), _tmp28);
		(_tmp27 = (g_free (_tmp27), NULL));
		(_tmp26 = (g_free (_tmp26), NULL));
		_tmp29 = NULL;
		self->priv->prop_enum = (_tmp29 = vala_ccode_enum_new (NULL), (self->priv->prop_enum == NULL ? NULL : (self->priv->prop_enum = (g_object_unref (self->priv->prop_enum), NULL))), _tmp29);
		_tmp32 = NULL;
		_tmp31 = NULL;
		_tmp30 = NULL;
		vala_ccode_enum_add_value (self->priv->prop_enum, (_tmp32 = vala_ccode_enum_value_new ((_tmp31 = g_strdup_printf ("%s_DUMMY_PROPERTY", (_tmp30 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (cl), NULL)))), NULL)));
		(_tmp32 == NULL ? NULL : (_tmp32 = (g_object_unref (_tmp32), NULL)));
		(_tmp31 = (g_free (_tmp31), NULL));
		(_tmp30 = (g_free (_tmp30), NULL));
		_tmp33 = NULL;
		self->priv->class_init_fragment = (_tmp33 = vala_ccode_fragment_new (), (self->priv->class_init_fragment == NULL ? NULL : (self->priv->class_init_fragment = (g_object_unref (self->priv->class_init_fragment), NULL))), _tmp33);
		_tmp34 = NULL;
		self->priv->instance_init_fragment = (_tmp34 = vala_ccode_fragment_new (), (self->priv->instance_init_fragment == NULL ? NULL : (self->priv->instance_init_fragment = (g_object_unref (self->priv->instance_init_fragment), NULL))), _tmp34);
		_tmp35 = NULL;
		self->priv->instance_dispose_fragment = (_tmp35 = vala_ccode_fragment_new (), (self->priv->instance_dispose_fragment == NULL ? NULL : (self->priv->instance_dispose_fragment = (g_object_unref (self->priv->instance_dispose_fragment), NULL))), _tmp35);
	}
	decl_frag = NULL;
	def_frag = NULL;
	if (vala_symbol_get_access (VALA_SYMBOL (cl)) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		ValaCCodeFragment* _tmp37;
		ValaCCodeFragment* _tmp36;
		ValaCCodeFragment* _tmp39;
		ValaCCodeFragment* _tmp38;
		_tmp37 = NULL;
		_tmp36 = NULL;
		decl_frag = (_tmp37 = (_tmp36 = self->priv->header_type_declaration, (_tmp36 == NULL ? NULL : g_object_ref (_tmp36))), (decl_frag == NULL ? NULL : (decl_frag = (g_object_unref (decl_frag), NULL))), _tmp37);
		_tmp39 = NULL;
		_tmp38 = NULL;
		def_frag = (_tmp39 = (_tmp38 = self->priv->header_type_definition, (_tmp38 == NULL ? NULL : g_object_ref (_tmp38))), (def_frag == NULL ? NULL : (def_frag = (g_object_unref (def_frag), NULL))), _tmp39);
	} else {
		ValaCCodeFragment* _tmp41;
		ValaCCodeFragment* _tmp40;
		ValaCCodeFragment* _tmp43;
		ValaCCodeFragment* _tmp42;
		_tmp41 = NULL;
		_tmp40 = NULL;
		decl_frag = (_tmp41 = (_tmp40 = self->priv->source_type_member_declaration, (_tmp40 == NULL ? NULL : g_object_ref (_tmp40))), (decl_frag == NULL ? NULL : (decl_frag = (g_object_unref (decl_frag), NULL))), _tmp41);
		_tmp43 = NULL;
		_tmp42 = NULL;
		def_frag = (_tmp43 = (_tmp42 = self->priv->source_type_member_declaration, (_tmp42 == NULL ? NULL : g_object_ref (_tmp42))), (def_frag == NULL ? NULL : (def_frag = (g_object_unref (def_frag), NULL))), _tmp43);
	}
	if (is_gtypeinstance) {
		ValaCCodeNewline* _tmp44;
		char* _tmp45;
		char* _tmp46;
		char* macro;
		ValaCCodeMacroReplacement* _tmp48;
		char* _tmp47;
		char* _tmp51;
		char* _tmp50;
		char* _tmp49;
		ValaCCodeMacroReplacement* _tmp54;
		char* _tmp53;
		char* _tmp52;
		char* _tmp57;
		char* _tmp56;
		char* _tmp55;
		ValaCCodeMacroReplacement* _tmp60;
		char* _tmp59;
		char* _tmp58;
		char* _tmp62;
		char* _tmp61;
		ValaCCodeMacroReplacement* _tmp65;
		char* _tmp64;
		char* _tmp63;
		char* _tmp67;
		char* _tmp66;
		ValaCCodeMacroReplacement* _tmp70;
		char* _tmp69;
		char* _tmp68;
		char* _tmp73;
		char* _tmp72;
		char* _tmp71;
		ValaCCodeMacroReplacement* _tmp76;
		char* _tmp75;
		char* _tmp74;
		ValaCCodeNewline* _tmp77;
		_tmp44 = NULL;
		vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((_tmp44 = vala_ccode_newline_new ())));
		(_tmp44 == NULL ? NULL : (_tmp44 = (g_object_unref (_tmp44), NULL)));
		_tmp45 = NULL;
		_tmp46 = NULL;
		macro = (_tmp46 = g_strdup_printf ("(%s_get_type ())", (_tmp45 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL))), (_tmp45 = (g_free (_tmp45), NULL)), _tmp46);
		_tmp48 = NULL;
		_tmp47 = NULL;
		vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((_tmp48 = vala_ccode_macro_replacement_new ((_tmp47 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (cl), "TYPE_")), macro))));
		(_tmp48 == NULL ? NULL : (_tmp48 = (g_object_unref (_tmp48), NULL)));
		(_tmp47 = (g_free (_tmp47), NULL));
		_tmp51 = NULL;
		_tmp50 = NULL;
		_tmp49 = NULL;
		macro = (_tmp51 = g_strdup_printf ("(G_TYPE_CHECK_INSTANCE_CAST ((obj), %s, %s))", (_tmp49 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (cl), "TYPE_")), (_tmp50 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE))), (macro = (g_free (macro), NULL)), _tmp51);
		(_tmp50 = (g_free (_tmp50), NULL));
		(_tmp49 = (g_free (_tmp49), NULL));
		_tmp54 = NULL;
		_tmp53 = NULL;
		_tmp52 = NULL;
		vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((_tmp54 = vala_ccode_macro_replacement_new ((_tmp53 = g_strdup_printf ("%s(obj)", (_tmp52 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (cl), NULL)))), macro))));
		(_tmp54 == NULL ? NULL : (_tmp54 = (g_object_unref (_tmp54), NULL)));
		(_tmp53 = (g_free (_tmp53), NULL));
		(_tmp52 = (g_free (_tmp52), NULL));
		_tmp57 = NULL;
		_tmp56 = NULL;
		_tmp55 = NULL;
		macro = (_tmp57 = g_strdup_printf ("(G_TYPE_CHECK_CLASS_CAST ((klass), %s, %sClass))", (_tmp55 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (cl), "TYPE_")), (_tmp56 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE))), (macro = (g_free (macro), NULL)), _tmp57);
		(_tmp56 = (g_free (_tmp56), NULL));
		(_tmp55 = (g_free (_tmp55), NULL));
		_tmp60 = NULL;
		_tmp59 = NULL;
		_tmp58 = NULL;
		vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((_tmp60 = vala_ccode_macro_replacement_new ((_tmp59 = g_strdup_printf ("%s_CLASS(klass)", (_tmp58 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (cl), NULL)))), macro))));
		(_tmp60 == NULL ? NULL : (_tmp60 = (g_object_unref (_tmp60), NULL)));
		(_tmp59 = (g_free (_tmp59), NULL));
		(_tmp58 = (g_free (_tmp58), NULL));
		_tmp62 = NULL;
		_tmp61 = NULL;
		macro = (_tmp62 = g_strdup_printf ("(G_TYPE_CHECK_INSTANCE_TYPE ((obj), %s))", (_tmp61 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (cl), "TYPE_"))), (macro = (g_free (macro), NULL)), _tmp62);
		(_tmp61 = (g_free (_tmp61), NULL));
		_tmp65 = NULL;
		_tmp64 = NULL;
		_tmp63 = NULL;
		vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((_tmp65 = vala_ccode_macro_replacement_new ((_tmp64 = g_strdup_printf ("%s(obj)", (_tmp63 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (cl), "IS_")))), macro))));
		(_tmp65 == NULL ? NULL : (_tmp65 = (g_object_unref (_tmp65), NULL)));
		(_tmp64 = (g_free (_tmp64), NULL));
		(_tmp63 = (g_free (_tmp63), NULL));
		_tmp67 = NULL;
		_tmp66 = NULL;
		macro = (_tmp67 = g_strdup_printf ("(G_TYPE_CHECK_CLASS_TYPE ((klass), %s))", (_tmp66 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (cl), "TYPE_"))), (macro = (g_free (macro), NULL)), _tmp67);
		(_tmp66 = (g_free (_tmp66), NULL));
		_tmp70 = NULL;
		_tmp69 = NULL;
		_tmp68 = NULL;
		vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((_tmp70 = vala_ccode_macro_replacement_new ((_tmp69 = g_strdup_printf ("%s_CLASS(klass)", (_tmp68 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (cl), "IS_")))), macro))));
		(_tmp70 == NULL ? NULL : (_tmp70 = (g_object_unref (_tmp70), NULL)));
		(_tmp69 = (g_free (_tmp69), NULL));
		(_tmp68 = (g_free (_tmp68), NULL));
		_tmp73 = NULL;
		_tmp72 = NULL;
		_tmp71 = NULL;
		macro = (_tmp73 = g_strdup_printf ("(G_TYPE_INSTANCE_GET_CLASS ((obj), %s, %sClass))", (_tmp71 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (cl), "TYPE_")), (_tmp72 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE))), (macro = (g_free (macro), NULL)), _tmp73);
		(_tmp72 = (g_free (_tmp72), NULL));
		(_tmp71 = (g_free (_tmp71), NULL));
		_tmp76 = NULL;
		_tmp75 = NULL;
		_tmp74 = NULL;
		vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((_tmp76 = vala_ccode_macro_replacement_new ((_tmp75 = g_strdup_printf ("%s_GET_CLASS(obj)", (_tmp74 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (cl), NULL)))), macro))));
		(_tmp76 == NULL ? NULL : (_tmp76 = (g_object_unref (_tmp76), NULL)));
		(_tmp75 = (g_free (_tmp75), NULL));
		(_tmp74 = (g_free (_tmp74), NULL));
		_tmp77 = NULL;
		vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((_tmp77 = vala_ccode_newline_new ())));
		(_tmp77 == NULL ? NULL : (_tmp77 = (g_object_unref (_tmp77), NULL)));
		(macro = (g_free (macro), NULL));
	}
	if (!vala_class_get_is_static (cl) && vala_source_file_get_cycle (vala_source_reference_get_file (vala_code_node_get_source_reference (VALA_CODE_NODE (cl)))) == NULL) {
		ValaCCodeTypeDefinition* _tmp81;
		ValaCCodeVariableDeclarator* _tmp80;
		char* _tmp79;
		char* _tmp78;
		_tmp81 = NULL;
		_tmp80 = NULL;
		_tmp79 = NULL;
		_tmp78 = NULL;
		vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((_tmp81 = vala_ccode_type_definition_new ((_tmp78 = g_strdup_printf ("struct %s", vala_ccode_struct_get_name (self->priv->instance_struct))), VALA_CCODE_DECLARATOR ((_tmp80 = vala_ccode_variable_declarator_new ((_tmp79 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE)))))))));
		(_tmp81 == NULL ? NULL : (_tmp81 = (g_object_unref (_tmp81), NULL)));
		(_tmp80 == NULL ? NULL : (_tmp80 = (g_object_unref (_tmp80), NULL)));
		(_tmp79 = (g_free (_tmp79), NULL));
		(_tmp78 = (g_free (_tmp78), NULL));
	}
	if (vala_class_get_base_class (cl) != NULL) {
		char* _tmp82;
		_tmp82 = NULL;
		vala_ccode_struct_add_field (self->priv->instance_struct, (_tmp82 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (vala_class_get_base_class (cl)), FALSE)), "parent_instance");
		(_tmp82 = (g_free (_tmp82), NULL));
		if (is_fundamental) {
			vala_ccode_struct_add_field (self->priv->instance_struct, "volatile int", "ref_count");
		}
	}
	if (is_gtypeinstance) {
		ValaCCodeTypeDefinition* _tmp92;
		ValaCCodeVariableDeclarator* _tmp91;
		char* _tmp90;
		char* _tmp89;
		char* _tmp88;
		char* _tmp94;
		char* _tmp93;
		if (vala_source_file_get_cycle (vala_source_reference_get_file (vala_code_node_get_source_reference (VALA_CODE_NODE (cl)))) == NULL) {
			ValaCCodeTypeDefinition* _tmp87;
			ValaCCodeVariableDeclarator* _tmp86;
			char* _tmp85;
			char* _tmp84;
			char* _tmp83;
			_tmp87 = NULL;
			_tmp86 = NULL;
			_tmp85 = NULL;
			_tmp84 = NULL;
			_tmp83 = NULL;
			vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((_tmp87 = vala_ccode_type_definition_new ((_tmp83 = g_strdup_printf ("struct %s", vala_ccode_struct_get_name (self->priv->type_struct))), VALA_CCODE_DECLARATOR ((_tmp86 = vala_ccode_variable_declarator_new ((_tmp85 = g_strdup_printf ("%sClass", (_tmp84 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE)))))))))));
			(_tmp87 == NULL ? NULL : (_tmp87 = (g_object_unref (_tmp87), NULL)));
			(_tmp86 == NULL ? NULL : (_tmp86 = (g_object_unref (_tmp86), NULL)));
			(_tmp85 = (g_free (_tmp85), NULL));
			(_tmp84 = (g_free (_tmp84), NULL));
			(_tmp83 = (g_free (_tmp83), NULL));
		}
		_tmp92 = NULL;
		_tmp91 = NULL;
		_tmp90 = NULL;
		_tmp89 = NULL;
		_tmp88 = NULL;
		vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((_tmp92 = vala_ccode_type_definition_new ((_tmp88 = g_strdup_printf ("struct %s", vala_ccode_struct_get_name (self->priv->instance_priv_struct))), VALA_CCODE_DECLARATOR ((_tmp91 = vala_ccode_variable_declarator_new ((_tmp90 = g_strdup_printf ("%sPrivate", (_tmp89 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE)))))))))));
		(_tmp92 == NULL ? NULL : (_tmp92 = (g_object_unref (_tmp92), NULL)));
		(_tmp91 == NULL ? NULL : (_tmp91 = (g_object_unref (_tmp91), NULL)));
		(_tmp90 = (g_free (_tmp90), NULL));
		(_tmp89 = (g_free (_tmp89), NULL));
		(_tmp88 = (g_free (_tmp88), NULL));
		_tmp94 = NULL;
		_tmp93 = NULL;
		vala_ccode_struct_add_field (self->priv->instance_struct, (_tmp94 = g_strdup_printf ("%sPrivate *", (_tmp93 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE)))), "priv");
		(_tmp94 = (g_free (_tmp94), NULL));
		(_tmp93 = (g_free (_tmp93), NULL));
		if (is_fundamental) {
			char* _tmp96;
			char* _tmp95;
			vala_ccode_struct_add_field (self->priv->type_struct, "GTypeClass", "parent_class");
			_tmp96 = NULL;
			_tmp95 = NULL;
			vala_ccode_struct_add_field (self->priv->type_struct, "void", (_tmp96 = g_strdup_printf ("(*finalize) (%s *self)", (_tmp95 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE)))));
			(_tmp96 = (g_free (_tmp96), NULL));
			(_tmp95 = (g_free (_tmp95), NULL));
		} else {
			char* _tmp98;
			char* _tmp97;
			_tmp98 = NULL;
			_tmp97 = NULL;
			vala_ccode_struct_add_field (self->priv->type_struct, (_tmp98 = g_strdup_printf ("%sClass", (_tmp97 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (vala_class_get_base_class (cl)), FALSE)))), "parent_class");
			(_tmp98 = (g_free (_tmp98), NULL));
			(_tmp97 = (g_free (_tmp97), NULL));
		}
	}
	if (!vala_class_get_is_static (cl)) {
		if (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (cl))) != NULL) {
			ValaCCodeComment* _tmp99;
			_tmp99 = NULL;
			vala_ccode_fragment_append (def_frag, VALA_CCODE_NODE ((_tmp99 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (cl)))))));
			(_tmp99 == NULL ? NULL : (_tmp99 = (g_object_unref (_tmp99), NULL)));
		}
		vala_ccode_fragment_append (def_frag, VALA_CCODE_NODE (self->priv->instance_struct));
	}
	if (is_gtypeinstance) {
		GeeCollection* _tmp100;
		gboolean _tmp101;
		vala_ccode_fragment_append (def_frag, VALA_CCODE_NODE (self->priv->type_struct));
		/* only add the *Private struct if it is not empty, i.e. we actually have private data */
		_tmp100 = NULL;
		if ((_tmp101 = vala_class_get_has_private_fields (cl) || gee_collection_get_size ((_tmp100 = vala_class_get_type_parameters (cl))) > 0, (_tmp100 == NULL ? NULL : (_tmp100 = (g_object_unref (_tmp100), NULL))), _tmp101)) {
			char* _tmp103;
			char* _tmp102;
			char* _tmp104;
			char* macro;
			ValaCCodeMacroReplacement* _tmp107;
			char* _tmp106;
			char* _tmp105;
			vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE (self->priv->instance_priv_struct));
			_tmp103 = NULL;
			_tmp102 = NULL;
			_tmp104 = NULL;
			macro = (_tmp104 = g_strdup_printf ("(G_TYPE_INSTANCE_GET_PRIVATE ((o), %s, %sPrivate))", (_tmp102 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (cl), "TYPE_")), (_tmp103 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE))), (_tmp103 = (g_free (_tmp103), NULL)), (_tmp102 = (g_free (_tmp102), NULL)), _tmp104);
			_tmp107 = NULL;
			_tmp106 = NULL;
			_tmp105 = NULL;
			vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE ((_tmp107 = vala_ccode_macro_replacement_new ((_tmp106 = g_strdup_printf ("%s_GET_PRIVATE(o)", (_tmp105 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (cl), NULL)))), macro))));
			(_tmp107 == NULL ? NULL : (_tmp107 = (g_object_unref (_tmp107), NULL)));
			(_tmp106 = (g_free (_tmp106), NULL));
			(_tmp105 = (g_free (_tmp105), NULL));
			(macro = (g_free (macro), NULL));
		}
		vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE (self->priv->prop_enum));
	}
	vala_code_node_accept_children (VALA_CODE_NODE (cl), VALA_CODE_VISITOR (self));
	if (is_gtypeinstance) {
		ValaClassRegisterFunction* type_fun;
		ValaCCodeFragment* _tmp121;
		if (is_fundamental) {
			ValaCCodeConstant* _tmp110;
			ValaCCodeMemberAccess* _tmp109;
			ValaCCodeIdentifier* _tmp108;
			ValaCCodeAssignment* _tmp111;
			ValaCCodeAssignment* ref_count;
			ValaCCodeExpressionStatement* _tmp112;
			_tmp110 = NULL;
			_tmp109 = NULL;
			_tmp108 = NULL;
			_tmp111 = NULL;
			ref_count = (_tmp111 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp109 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp108 = vala_ccode_identifier_new ("self"))), "ref_count"))), VALA_CCODE_EXPRESSION ((_tmp110 = vala_ccode_constant_new ("1"))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (_tmp110 == NULL ? NULL : (_tmp110 = (g_object_unref (_tmp110), NULL))), (_tmp109 == NULL ? NULL : (_tmp109 = (g_object_unref (_tmp109), NULL))), (_tmp108 == NULL ? NULL : (_tmp108 = (g_object_unref (_tmp108), NULL))), _tmp111);
			_tmp112 = NULL;
			vala_ccode_fragment_append (self->priv->instance_init_fragment, VALA_CCODE_NODE ((_tmp112 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ref_count)))));
			(_tmp112 == NULL ? NULL : (_tmp112 = (g_object_unref (_tmp112), NULL)));
			(ref_count == NULL ? NULL : (ref_count = (g_object_unref (ref_count), NULL)));
		} else {
			if (is_gobject) {
				GeeCollection* _tmp113;
				gboolean _tmp114;
				GeeCollection* _tmp115;
				gboolean _tmp116;
				_tmp113 = NULL;
				if ((_tmp114 = vala_ccode_generator_class_has_readable_properties (self, cl) || gee_collection_get_size ((_tmp113 = vala_class_get_type_parameters (cl))) > 0, (_tmp113 == NULL ? NULL : (_tmp113 = (g_object_unref (_tmp113), NULL))), _tmp114)) {
					vala_ccode_generator_add_get_property_function (self, cl);
				}
				_tmp115 = NULL;
				if ((_tmp116 = vala_ccode_generator_class_has_writable_properties (self, cl) || gee_collection_get_size ((_tmp115 = vala_class_get_type_parameters (cl))) > 0, (_tmp115 == NULL ? NULL : (_tmp115 = (g_object_unref (_tmp115), NULL))), _tmp116)) {
					vala_ccode_generator_add_set_property_function (self, cl);
				}
			}
		}
		vala_ccode_generator_add_class_init_function (self, cl);
		{
			GeeCollection* base_type_collection;
			GeeIterator* base_type_it;
			base_type_collection = vala_class_get_base_types (cl);
			base_type_it = gee_iterable_iterator (GEE_ITERABLE (base_type_collection));
			while (gee_iterator_next (base_type_it)) {
				ValaDataType* base_type;
				base_type = gee_iterator_get (base_type_it);
				{
					if (VALA_IS_INTERFACE (vala_data_type_get_data_type (base_type))) {
						vala_ccode_generator_add_interface_init_function (self, cl, VALA_INTERFACE (vala_data_type_get_data_type (base_type)));
					}
					(base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL)));
				}
			}
			(base_type_collection == NULL ? NULL : (base_type_collection = (g_object_unref (base_type_collection), NULL)));
			(base_type_it == NULL ? NULL : (base_type_it = (g_object_unref (base_type_it), NULL)));
		}
		vala_ccode_generator_add_instance_init_function (self, cl);
		if (is_gobject) {
			GeeCollection* _tmp117;
			gboolean _tmp118;
			_tmp117 = NULL;
			if ((_tmp118 = gee_collection_get_size ((_tmp117 = vala_class_get_fields (cl))) > 0 || vala_class_get_destructor (cl) != NULL, (_tmp117 == NULL ? NULL : (_tmp117 = (g_object_unref (_tmp117), NULL))), _tmp118)) {
				vala_ccode_generator_add_dispose_function (self, cl);
			}
		}
		type_fun = vala_class_register_function_new (cl);
		vala_typeregister_function_init_from_type (VALA_TYPEREGISTER_FUNCTION (type_fun), self->priv->in_plugin);
		if (vala_symbol_get_access (VALA_SYMBOL (cl)) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaCCodeFragment* _tmp119;
			_tmp119 = NULL;
			vala_ccode_fragment_append (self->priv->header_type_member_declaration, VALA_CCODE_NODE ((_tmp119 = vala_typeregister_function_get_declaration (VALA_TYPEREGISTER_FUNCTION (type_fun)))));
			(_tmp119 == NULL ? NULL : (_tmp119 = (g_object_unref (_tmp119), NULL)));
		} else {
			ValaCCodeFragment* _tmp120;
			_tmp120 = NULL;
			vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE ((_tmp120 = vala_typeregister_function_get_declaration (VALA_TYPEREGISTER_FUNCTION (type_fun)))));
			(_tmp120 == NULL ? NULL : (_tmp120 = (g_object_unref (_tmp120), NULL)));
		}
		_tmp121 = NULL;
		vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE ((_tmp121 = vala_typeregister_function_get_definition (VALA_TYPEREGISTER_FUNCTION (type_fun)))));
		(_tmp121 == NULL ? NULL : (_tmp121 = (g_object_unref (_tmp121), NULL)));
		if (self->priv->in_plugin) {
			ValaCCodeIdentifier* _tmp124;
			char* _tmp123;
			char* _tmp122;
			ValaCCodeFunctionCall* _tmp125;
			ValaCCodeFunctionCall* register_call;
			ValaCCodeIdentifier* _tmp126;
			ValaCCodeExpressionStatement* _tmp127;
			/* FIXME resolve potential dependency issues, i.e. base types have to be registered before derived types*/
			_tmp124 = NULL;
			_tmp123 = NULL;
			_tmp122 = NULL;
			_tmp125 = NULL;
			register_call = (_tmp125 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp124 = vala_ccode_identifier_new ((_tmp123 = g_strdup_printf ("%s_register_type", (_tmp122 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)))))))), (_tmp124 == NULL ? NULL : (_tmp124 = (g_object_unref (_tmp124), NULL))), (_tmp123 = (g_free (_tmp123), NULL)), (_tmp122 = (g_free (_tmp122), NULL)), _tmp125);
			_tmp126 = NULL;
			vala_ccode_function_call_add_argument (register_call, VALA_CCODE_EXPRESSION ((_tmp126 = vala_ccode_identifier_new (self->priv->module_init_param_name))));
			(_tmp126 == NULL ? NULL : (_tmp126 = (g_object_unref (_tmp126), NULL)));
			_tmp127 = NULL;
			vala_ccode_fragment_append (self->priv->module_init_fragment, VALA_CCODE_NODE ((_tmp127 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (register_call)))));
			(_tmp127 == NULL ? NULL : (_tmp127 = (g_object_unref (_tmp127), NULL)));
			(register_call == NULL ? NULL : (register_call = (g_object_unref (register_call), NULL)));
		}
		if (is_fundamental) {
			char* _tmp129;
			char* _tmp128;
			ValaCCodeFunction* _tmp130;
			ValaCCodeFunction* ref_fun;
			char* _tmp132;
			char* _tmp131;
			ValaCCodeFunction* _tmp133;
			ValaCCodeFunction* unref_fun;
			ValaCCodeFormalParameter* _tmp134;
			ValaCCodeFormalParameter* _tmp135;
			ValaCCodeBlock* ref_block;
			ValaCCodeBlock* unref_block;
			char* _tmp141;
			char* _tmp140;
			ValaCCodeDeclaration* _tmp142;
			ValaCCodeDeclaration* cdecl_;
			ValaCCodeVariableDeclarator* _tmp144;
			ValaCCodeIdentifier* _tmp143;
			ValaCCodeIdentifier* _tmp145;
			ValaCCodeMemberAccess* _tmp146;
			ValaCCodeMemberAccess* ref_count;
			ValaCCodeIdentifier* _tmp147;
			ValaCCodeFunctionCall* _tmp148;
			ValaCCodeFunctionCall* ccall;
			ValaCCodeUnaryExpression* _tmp149;
			ValaCCodeExpressionStatement* _tmp150;
			ValaCCodeReturnStatement* _tmp152;
			ValaCCodeIdentifier* _tmp151;
			ValaCCodeBlock* destroy_block;
			ValaCCodeIdentifier* _tmp155;
			char* _tmp154;
			char* _tmp153;
			ValaCCodeFunctionCall* _tmp156;
			ValaCCodeFunctionCall* get_class;
			ValaCCodeIdentifier* _tmp157;
			ValaCCodeMemberAccess* finalize;
			ValaCCodeFunctionCall* finalize_call;
			ValaCCodeIdentifier* _tmp158;
			ValaCCodeIdentifier* _tmp159;
			ValaCCodeFunctionCall* _tmp160;
			ValaCCodeFunctionCall* free;
			ValaCCodeCastExpression* _tmp162;
			ValaCCodeIdentifier* _tmp161;
			ValaCCodeExpressionStatement* _tmp163;
			ValaCCodeFunctionCall* _tmp165;
			ValaCCodeIdentifier* _tmp164;
			ValaCCodeUnaryExpression* _tmp166;
			ValaCCodeIfStatement* _tmp167;
			_tmp129 = NULL;
			_tmp128 = NULL;
			_tmp130 = NULL;
			ref_fun = (_tmp130 = vala_ccode_function_new ((_tmp129 = g_strconcat ((_tmp128 = vala_symbol_get_lower_case_cprefix (VALA_SYMBOL (cl))), "ref", NULL)), "gpointer"), (_tmp129 = (g_free (_tmp129), NULL)), (_tmp128 = (g_free (_tmp128), NULL)), _tmp130);
			_tmp132 = NULL;
			_tmp131 = NULL;
			_tmp133 = NULL;
			unref_fun = (_tmp133 = vala_ccode_function_new ((_tmp132 = g_strconcat ((_tmp131 = vala_symbol_get_lower_case_cprefix (VALA_SYMBOL (cl))), "unref", NULL)), "void"), (_tmp132 = (g_free (_tmp132), NULL)), (_tmp131 = (g_free (_tmp131), NULL)), _tmp133);
			if (vala_symbol_get_access (VALA_SYMBOL (cl)) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
				vala_ccode_function_set_modifiers (ref_fun, VALA_CCODE_MODIFIERS_STATIC);
				vala_ccode_function_set_modifiers (unref_fun, VALA_CCODE_MODIFIERS_STATIC);
			}
			_tmp134 = NULL;
			vala_ccode_function_add_parameter (ref_fun, (_tmp134 = vala_ccode_formal_parameter_new ("instance", "gpointer")));
			(_tmp134 == NULL ? NULL : (_tmp134 = (g_object_unref (_tmp134), NULL)));
			_tmp135 = NULL;
			vala_ccode_function_add_parameter (unref_fun, (_tmp135 = vala_ccode_formal_parameter_new ("instance", "gpointer")));
			(_tmp135 == NULL ? NULL : (_tmp135 = (g_object_unref (_tmp135), NULL)));
			if (vala_symbol_get_access (VALA_SYMBOL (cl)) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
				ValaCCodeFunction* _tmp136;
				ValaCCodeFunction* _tmp137;
				_tmp136 = NULL;
				vala_ccode_fragment_append (self->priv->header_type_member_declaration, VALA_CCODE_NODE ((_tmp136 = vala_ccode_function_copy (ref_fun))));
				(_tmp136 == NULL ? NULL : (_tmp136 = (g_object_unref (_tmp136), NULL)));
				_tmp137 = NULL;
				vala_ccode_fragment_append (self->priv->header_type_member_declaration, VALA_CCODE_NODE ((_tmp137 = vala_ccode_function_copy (unref_fun))));
				(_tmp137 == NULL ? NULL : (_tmp137 = (g_object_unref (_tmp137), NULL)));
			} else {
				ValaCCodeFunction* _tmp138;
				ValaCCodeFunction* _tmp139;
				_tmp138 = NULL;
				vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE ((_tmp138 = vala_ccode_function_copy (ref_fun))));
				(_tmp138 == NULL ? NULL : (_tmp138 = (g_object_unref (_tmp138), NULL)));
				_tmp139 = NULL;
				vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE ((_tmp139 = vala_ccode_function_copy (unref_fun))));
				(_tmp139 == NULL ? NULL : (_tmp139 = (g_object_unref (_tmp139), NULL)));
			}
			ref_block = vala_ccode_block_new ();
			unref_block = vala_ccode_block_new ();
			_tmp141 = NULL;
			_tmp140 = NULL;
			_tmp142 = NULL;
			cdecl_ = (_tmp142 = vala_ccode_declaration_new ((_tmp141 = g_strconcat ((_tmp140 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE)), "*", NULL))), (_tmp141 = (g_free (_tmp141), NULL)), (_tmp140 = (g_free (_tmp140), NULL)), _tmp142);
			_tmp144 = NULL;
			_tmp143 = NULL;
			vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp144 = vala_ccode_variable_declarator_new_with_initializer ("self", VALA_CCODE_EXPRESSION ((_tmp143 = vala_ccode_identifier_new ("instance")))))));
			(_tmp144 == NULL ? NULL : (_tmp144 = (g_object_unref (_tmp144), NULL)));
			(_tmp143 == NULL ? NULL : (_tmp143 = (g_object_unref (_tmp143), NULL)));
			vala_ccode_block_add_statement (ref_block, VALA_CCODE_NODE (cdecl_));
			vala_ccode_block_add_statement (unref_block, VALA_CCODE_NODE (cdecl_));
			_tmp145 = NULL;
			_tmp146 = NULL;
			ref_count = (_tmp146 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp145 = vala_ccode_identifier_new ("self"))), "ref_count"), (_tmp145 == NULL ? NULL : (_tmp145 = (g_object_unref (_tmp145), NULL))), _tmp146);
			_tmp147 = NULL;
			_tmp148 = NULL;
			ccall = (_tmp148 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp147 = vala_ccode_identifier_new ("g_atomic_int_inc")))), (_tmp147 == NULL ? NULL : (_tmp147 = (g_object_unref (_tmp147), NULL))), _tmp148);
			_tmp149 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp149 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (ref_count)))));
			(_tmp149 == NULL ? NULL : (_tmp149 = (g_object_unref (_tmp149), NULL)));
			_tmp150 = NULL;
			vala_ccode_block_add_statement (ref_block, VALA_CCODE_NODE ((_tmp150 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
			(_tmp150 == NULL ? NULL : (_tmp150 = (g_object_unref (_tmp150), NULL)));
			_tmp152 = NULL;
			_tmp151 = NULL;
			vala_ccode_block_add_statement (ref_block, VALA_CCODE_NODE ((_tmp152 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION ((_tmp151 = vala_ccode_identifier_new ("instance")))))));
			(_tmp152 == NULL ? NULL : (_tmp152 = (g_object_unref (_tmp152), NULL)));
			(_tmp151 == NULL ? NULL : (_tmp151 = (g_object_unref (_tmp151), NULL)));
			destroy_block = vala_ccode_block_new ();
			_tmp155 = NULL;
			_tmp154 = NULL;
			_tmp153 = NULL;
			_tmp156 = NULL;
			get_class = (_tmp156 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp155 = vala_ccode_identifier_new ((_tmp154 = g_strdup_printf ("%s_GET_CLASS", (_tmp153 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (cl), NULL)))))))), (_tmp155 == NULL ? NULL : (_tmp155 = (g_object_unref (_tmp155), NULL))), (_tmp154 = (g_free (_tmp154), NULL)), (_tmp153 = (g_free (_tmp153), NULL)), _tmp156);
			_tmp157 = NULL;
			vala_ccode_function_call_add_argument (get_class, VALA_CCODE_EXPRESSION ((_tmp157 = vala_ccode_identifier_new ("self"))));
			(_tmp157 == NULL ? NULL : (_tmp157 = (g_object_unref (_tmp157), NULL)));
			finalize = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (get_class), "finalize");
			finalize_call = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (finalize));
			_tmp158 = NULL;
			vala_ccode_function_call_add_argument (finalize_call, VALA_CCODE_EXPRESSION ((_tmp158 = vala_ccode_identifier_new ("self"))));
			(_tmp158 == NULL ? NULL : (_tmp158 = (g_object_unref (_tmp158), NULL)));
			/*destroy_block.add_statement (new CCodeExpressionStatement (finalize_call));*/
			_tmp159 = NULL;
			_tmp160 = NULL;
			free = (_tmp160 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp159 = vala_ccode_identifier_new ("g_type_free_instance")))), (_tmp159 == NULL ? NULL : (_tmp159 = (g_object_unref (_tmp159), NULL))), _tmp160);
			_tmp162 = NULL;
			_tmp161 = NULL;
			vala_ccode_function_call_add_argument (free, VALA_CCODE_EXPRESSION ((_tmp162 = vala_ccode_cast_expression_new (VALA_CCODE_EXPRESSION ((_tmp161 = vala_ccode_identifier_new ("self"))), "GTypeInstance *"))));
			(_tmp162 == NULL ? NULL : (_tmp162 = (g_object_unref (_tmp162), NULL)));
			(_tmp161 == NULL ? NULL : (_tmp161 = (g_object_unref (_tmp161), NULL)));
			_tmp163 = NULL;
			vala_ccode_block_add_statement (destroy_block, VALA_CCODE_NODE ((_tmp163 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (free)))));
			(_tmp163 == NULL ? NULL : (_tmp163 = (g_object_unref (_tmp163), NULL)));
			_tmp165 = NULL;
			_tmp164 = NULL;
			ccall = (_tmp165 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp164 = vala_ccode_identifier_new ("g_atomic_int_dec_and_test")))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), _tmp165);
			(_tmp164 == NULL ? NULL : (_tmp164 = (g_object_unref (_tmp164), NULL)));
			_tmp166 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp166 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (ref_count)))));
			(_tmp166 == NULL ? NULL : (_tmp166 = (g_object_unref (_tmp166), NULL)));
			_tmp167 = NULL;
			vala_ccode_block_add_statement (unref_block, VALA_CCODE_NODE ((_tmp167 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (ccall), VALA_CCODE_STATEMENT (destroy_block), NULL))));
			(_tmp167 == NULL ? NULL : (_tmp167 = (g_object_unref (_tmp167), NULL)));
			vala_ccode_function_set_block (ref_fun, ref_block);
			vala_ccode_function_set_block (unref_fun, unref_block);
			vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (ref_fun));
			vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (unref_fun));
			vala_class_set_ref_function (cl, vala_ccode_function_get_name (ref_fun));
			vala_class_set_unref_function (cl, vala_ccode_function_get_name (unref_fun));
			(ref_fun == NULL ? NULL : (ref_fun = (g_object_unref (ref_fun), NULL)));
			(unref_fun == NULL ? NULL : (unref_fun = (g_object_unref (unref_fun), NULL)));
			(ref_block == NULL ? NULL : (ref_block = (g_object_unref (ref_block), NULL)));
			(unref_block == NULL ? NULL : (unref_block = (g_object_unref (unref_block), NULL)));
			(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
			(ref_count == NULL ? NULL : (ref_count = (g_object_unref (ref_count), NULL)));
			(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
			(destroy_block == NULL ? NULL : (destroy_block = (g_object_unref (destroy_block), NULL)));
			(get_class == NULL ? NULL : (get_class = (g_object_unref (get_class), NULL)));
			(finalize == NULL ? NULL : (finalize = (g_object_unref (finalize), NULL)));
			(finalize_call == NULL ? NULL : (finalize_call = (g_object_unref (finalize_call), NULL)));
			(free == NULL ? NULL : (free = (g_object_unref (free), NULL)));
		}
		(type_fun == NULL ? NULL : (type_fun = (g_object_unref (type_fun), NULL)));
	} else {
		if (!vala_class_get_is_static (cl)) {
			char* _tmp169;
			char* _tmp168;
			ValaCCodeFunction* _tmp170;
			ValaCCodeFunction* function;
			ValaCCodeFormalParameter* _tmp173;
			char* _tmp172;
			char* _tmp171;
			ValaCCodeBlock* cblock;
			ValaCCodeIdentifier* _tmp176;
			ValaCCodeFunctionCall* _tmp177;
			ValaCCodeFunctionCall* ccall;
			ValaCCodeIdentifier* _tmp179;
			char* _tmp178;
			ValaCCodeIdentifier* _tmp180;
			ValaCCodeExpressionStatement* _tmp181;
			_tmp169 = NULL;
			_tmp168 = NULL;
			_tmp170 = NULL;
			function = (_tmp170 = vala_ccode_function_new ((_tmp169 = g_strconcat ((_tmp168 = vala_symbol_get_lower_case_cprefix (VALA_SYMBOL (cl))), "free", NULL)), "void"), (_tmp169 = (g_free (_tmp169), NULL)), (_tmp168 = (g_free (_tmp168), NULL)), _tmp170);
			if (vala_symbol_get_access (VALA_SYMBOL (cl)) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
				vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
			}
			_tmp173 = NULL;
			_tmp172 = NULL;
			_tmp171 = NULL;
			vala_ccode_function_add_parameter (function, (_tmp173 = vala_ccode_formal_parameter_new ("self", (_tmp172 = g_strconcat ((_tmp171 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE)), "*", NULL)))));
			(_tmp173 == NULL ? NULL : (_tmp173 = (g_object_unref (_tmp173), NULL)));
			(_tmp172 = (g_free (_tmp172), NULL));
			(_tmp171 = (g_free (_tmp171), NULL));
			if (vala_symbol_get_access (VALA_SYMBOL (cl)) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
				ValaCCodeFunction* _tmp174;
				_tmp174 = NULL;
				vala_ccode_fragment_append (self->priv->header_type_member_declaration, VALA_CCODE_NODE ((_tmp174 = vala_ccode_function_copy (function))));
				(_tmp174 == NULL ? NULL : (_tmp174 = (g_object_unref (_tmp174), NULL)));
			} else {
				ValaCCodeFunction* _tmp175;
				_tmp175 = NULL;
				vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE ((_tmp175 = vala_ccode_function_copy (function))));
				(_tmp175 == NULL ? NULL : (_tmp175 = (g_object_unref (_tmp175), NULL)));
			}
			cblock = vala_ccode_block_new ();
			vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (self->priv->instance_dispose_fragment));
			_tmp176 = NULL;
			_tmp177 = NULL;
			ccall = (_tmp177 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp176 = vala_ccode_identifier_new ("g_slice_free")))), (_tmp176 == NULL ? NULL : (_tmp176 = (g_object_unref (_tmp176), NULL))), _tmp177);
			_tmp179 = NULL;
			_tmp178 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp179 = vala_ccode_identifier_new ((_tmp178 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE))))));
			(_tmp179 == NULL ? NULL : (_tmp179 = (g_object_unref (_tmp179), NULL)));
			(_tmp178 = (g_free (_tmp178), NULL));
			_tmp180 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp180 = vala_ccode_identifier_new ("self"))));
			(_tmp180 == NULL ? NULL : (_tmp180 = (g_object_unref (_tmp180), NULL)));
			_tmp181 = NULL;
			vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((_tmp181 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
			(_tmp181 == NULL ? NULL : (_tmp181 = (g_object_unref (_tmp181), NULL)));
			vala_ccode_function_set_block (function, cblock);
			vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (function));
			(function == NULL ? NULL : (function = (g_object_unref (function), NULL)));
			(cblock == NULL ? NULL : (cblock = (g_object_unref (cblock), NULL)));
			(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
		}
	}
	_tmp183 = NULL;
	_tmp182 = NULL;
	self->current_type_symbol = (_tmp183 = (_tmp182 = old_type_symbol, (_tmp182 == NULL ? NULL : g_object_ref (_tmp182))), (self->current_type_symbol == NULL ? NULL : (self->current_type_symbol = (g_object_unref (self->current_type_symbol), NULL))), _tmp183);
	_tmp185 = NULL;
	_tmp184 = NULL;
	self->priv->current_class = (_tmp185 = (_tmp184 = old_class, (_tmp184 == NULL ? NULL : g_object_ref (_tmp184))), (self->priv->current_class == NULL ? NULL : (self->priv->current_class = (g_object_unref (self->priv->current_class), NULL))), _tmp185);
	_tmp187 = NULL;
	_tmp186 = NULL;
	self->priv->instance_struct = (_tmp187 = (_tmp186 = old_instance_struct, (_tmp186 == NULL ? NULL : g_object_ref (_tmp186))), (self->priv->instance_struct == NULL ? NULL : (self->priv->instance_struct = (g_object_unref (self->priv->instance_struct), NULL))), _tmp187);
	_tmp189 = NULL;
	_tmp188 = NULL;
	self->priv->type_struct = (_tmp189 = (_tmp188 = old_type_struct, (_tmp188 == NULL ? NULL : g_object_ref (_tmp188))), (self->priv->type_struct == NULL ? NULL : (self->priv->type_struct = (g_object_unref (self->priv->type_struct), NULL))), _tmp189);
	_tmp191 = NULL;
	_tmp190 = NULL;
	self->priv->instance_priv_struct = (_tmp191 = (_tmp190 = old_instance_priv_struct, (_tmp190 == NULL ? NULL : g_object_ref (_tmp190))), (self->priv->instance_priv_struct == NULL ? NULL : (self->priv->instance_priv_struct = (g_object_unref (self->priv->instance_priv_struct), NULL))), _tmp191);
	_tmp193 = NULL;
	_tmp192 = NULL;
	self->priv->prop_enum = (_tmp193 = (_tmp192 = old_prop_enum, (_tmp192 == NULL ? NULL : g_object_ref (_tmp192))), (self->priv->prop_enum == NULL ? NULL : (self->priv->prop_enum = (g_object_unref (self->priv->prop_enum), NULL))), _tmp193);
	_tmp195 = NULL;
	_tmp194 = NULL;
	self->priv->class_init_fragment = (_tmp195 = (_tmp194 = old_class_init_fragment, (_tmp194 == NULL ? NULL : g_object_ref (_tmp194))), (self->priv->class_init_fragment == NULL ? NULL : (self->priv->class_init_fragment = (g_object_unref (self->priv->class_init_fragment), NULL))), _tmp195);
	_tmp197 = NULL;
	_tmp196 = NULL;
	self->priv->instance_init_fragment = (_tmp197 = (_tmp196 = old_instance_init_fragment, (_tmp196 == NULL ? NULL : g_object_ref (_tmp196))), (self->priv->instance_init_fragment == NULL ? NULL : (self->priv->instance_init_fragment = (g_object_unref (self->priv->instance_init_fragment), NULL))), _tmp197);
	_tmp199 = NULL;
	_tmp198 = NULL;
	self->priv->instance_dispose_fragment = (_tmp199 = (_tmp198 = old_instance_dispose_fragment, (_tmp198 == NULL ? NULL : g_object_ref (_tmp198))), (self->priv->instance_dispose_fragment == NULL ? NULL : (self->priv->instance_dispose_fragment = (g_object_unref (self->priv->instance_dispose_fragment), NULL))), _tmp199);
	(old_symbol == NULL ? NULL : (old_symbol = (g_object_unref (old_symbol), NULL)));
	(old_type_symbol == NULL ? NULL : (old_type_symbol = (g_object_unref (old_type_symbol), NULL)));
	(old_class == NULL ? NULL : (old_class = (g_object_unref (old_class), NULL)));
	(old_instance_struct == NULL ? NULL : (old_instance_struct = (g_object_unref (old_instance_struct), NULL)));
	(old_type_struct == NULL ? NULL : (old_type_struct = (g_object_unref (old_type_struct), NULL)));
	(old_instance_priv_struct == NULL ? NULL : (old_instance_priv_struct = (g_object_unref (old_instance_priv_struct), NULL)));
	(old_prop_enum == NULL ? NULL : (old_prop_enum = (g_object_unref (old_prop_enum), NULL)));
	(old_class_init_fragment == NULL ? NULL : (old_class_init_fragment = (g_object_unref (old_class_init_fragment), NULL)));
	(old_instance_init_fragment == NULL ? NULL : (old_instance_init_fragment = (g_object_unref (old_instance_init_fragment), NULL)));
	(old_instance_dispose_fragment == NULL ? NULL : (old_instance_dispose_fragment = (g_object_unref (old_instance_dispose_fragment), NULL)));
	(decl_frag == NULL ? NULL : (decl_frag = (g_object_unref (decl_frag), NULL)));
	(def_frag == NULL ? NULL : (def_frag = (g_object_unref (def_frag), NULL)));
}


static void vala_ccode_generator_add_class_init_function (ValaCCodeGenerator* self, ValaClass* cl) {
	char* _tmp1;
	char* _tmp0;
	ValaCCodeFunction* _tmp2;
	ValaCCodeFunction* class_init;
	ValaCCodeFormalParameter* _tmp5;
	char* _tmp4;
	char* _tmp3;
	ValaCCodeBlock* init_block;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeDeclaration* parent_decl;
	char* _tmp7;
	char* _tmp6;
	ValaCCodeVariableDeclarator* _tmp8;
	ValaCCodeVariableDeclarator* parent_var_decl;
	ValaCCodeConstant* _tmp9;
	ValaCCodeFunctionCall* _tmp11;
	ValaCCodeIdentifier* _tmp10;
	ValaCCodeIdentifier* _tmp12;
	ValaCCodeIdentifier* _tmp15;
	char* _tmp14;
	char* _tmp13;
	ValaCCodeAssignment* _tmp16;
	ValaCCodeAssignment* parent_assignment;
	ValaCCodeExpressionStatement* _tmp17;
	GeeCollection* _tmp18;
	gboolean _tmp19;
	g_return_if_fail (VALA_IS_CCODE_GENERATOR (self));
	g_return_if_fail (cl == NULL || VALA_IS_CLASS (cl));
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp2 = NULL;
	class_init = (_tmp2 = vala_ccode_function_new ((_tmp1 = g_strdup_printf ("%s_class_init", (_tmp0 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)))), "void"), (_tmp1 = (g_free (_tmp1), NULL)), (_tmp0 = (g_free (_tmp0), NULL)), _tmp2);
	_tmp5 = NULL;
	_tmp4 = NULL;
	_tmp3 = NULL;
	vala_ccode_function_add_parameter (class_init, (_tmp5 = vala_ccode_formal_parameter_new ("klass", (_tmp4 = g_strdup_printf ("%sClass *", (_tmp3 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE)))))));
	(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
	(_tmp4 = (g_free (_tmp4), NULL));
	(_tmp3 = (g_free (_tmp3), NULL));
	vala_ccode_function_set_modifiers (class_init, VALA_CCODE_MODIFIERS_STATIC);
	init_block = vala_ccode_block_new ();
	vala_ccode_function_set_block (class_init, init_block);
	ccall = NULL;
	/* save pointer to parent class */
	parent_decl = vala_ccode_declaration_new ("gpointer");
	_tmp7 = NULL;
	_tmp6 = NULL;
	_tmp8 = NULL;
	parent_var_decl = (_tmp8 = vala_ccode_variable_declarator_new ((_tmp7 = g_strdup_printf ("%s_parent_class", (_tmp6 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL))))), (_tmp7 = (g_free (_tmp7), NULL)), (_tmp6 = (g_free (_tmp6), NULL)), _tmp8);
	_tmp9 = NULL;
	vala_ccode_variable_declarator_set_initializer (parent_var_decl, VALA_CCODE_EXPRESSION ((_tmp9 = vala_ccode_constant_new ("NULL"))));
	(_tmp9 == NULL ? NULL : (_tmp9 = (g_object_unref (_tmp9), NULL)));
	vala_ccode_declaration_add_declarator (parent_decl, VALA_CCODE_DECLARATOR (parent_var_decl));
	vala_ccode_declaration_set_modifiers (parent_decl, VALA_CCODE_MODIFIERS_STATIC);
	vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE (parent_decl));
	_tmp11 = NULL;
	_tmp10 = NULL;
	ccall = (_tmp11 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp10 = vala_ccode_identifier_new ("g_type_class_peek_parent")))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), _tmp11);
	(_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL)));
	_tmp12 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp12 = vala_ccode_identifier_new ("klass"))));
	(_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL)));
	_tmp15 = NULL;
	_tmp14 = NULL;
	_tmp13 = NULL;
	_tmp16 = NULL;
	parent_assignment = (_tmp16 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp15 = vala_ccode_identifier_new ((_tmp14 = g_strdup_printf ("%s_parent_class", (_tmp13 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL))))))), VALA_CCODE_EXPRESSION (ccall), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL))), (_tmp14 = (g_free (_tmp14), NULL)), (_tmp13 = (g_free (_tmp13), NULL)), _tmp16);
	_tmp17 = NULL;
	vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp17 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (parent_assignment)))));
	(_tmp17 == NULL ? NULL : (_tmp17 = (g_object_unref (_tmp17), NULL)));
	/* add struct for private fields */
	_tmp18 = NULL;
	if ((_tmp19 = vala_class_get_has_private_fields (cl) || gee_collection_get_size ((_tmp18 = vala_class_get_type_parameters (cl))) > 0, (_tmp18 == NULL ? NULL : (_tmp18 = (g_object_unref (_tmp18), NULL))), _tmp19)) {
		ValaCCodeFunctionCall* _tmp21;
		ValaCCodeIdentifier* _tmp20;
		ValaCCodeIdentifier* _tmp22;
		ValaCCodeConstant* _tmp25;
		char* _tmp24;
		char* _tmp23;
		ValaCCodeExpressionStatement* _tmp26;
		_tmp21 = NULL;
		_tmp20 = NULL;
		ccall = (_tmp21 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp20 = vala_ccode_identifier_new ("g_type_class_add_private")))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), _tmp21);
		(_tmp20 == NULL ? NULL : (_tmp20 = (g_object_unref (_tmp20), NULL)));
		_tmp22 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp22 = vala_ccode_identifier_new ("klass"))));
		(_tmp22 == NULL ? NULL : (_tmp22 = (g_object_unref (_tmp22), NULL)));
		_tmp25 = NULL;
		_tmp24 = NULL;
		_tmp23 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp25 = vala_ccode_constant_new ((_tmp24 = g_strdup_printf ("sizeof (%sPrivate)", (_tmp23 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE))))))));
		(_tmp25 == NULL ? NULL : (_tmp25 = (g_object_unref (_tmp25), NULL)));
		(_tmp24 = (g_free (_tmp24), NULL));
		(_tmp23 = (g_free (_tmp23), NULL));
		_tmp26 = NULL;
		vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp26 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
		(_tmp26 == NULL ? NULL : (_tmp26 = (g_object_unref (_tmp26), NULL)));
	}
	if (vala_typesymbol_is_subtype_of (VALA_TYPESYMBOL (cl), self->gobject_type)) {
		ValaCCodeFunctionCall* _tmp28;
		ValaCCodeIdentifier* _tmp27;
		ValaCCodeIdentifier* _tmp29;
		GeeCollection* _tmp30;
		gboolean _tmp31;
		GeeCollection* _tmp38;
		gboolean _tmp39;
		GeeCollection* _tmp55;
		gboolean _tmp56;
		/* set property handlers */
		_tmp28 = NULL;
		_tmp27 = NULL;
		ccall = (_tmp28 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp27 = vala_ccode_identifier_new ("G_OBJECT_CLASS")))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), _tmp28);
		(_tmp27 == NULL ? NULL : (_tmp27 = (g_object_unref (_tmp27), NULL)));
		_tmp29 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp29 = vala_ccode_identifier_new ("klass"))));
		(_tmp29 == NULL ? NULL : (_tmp29 = (g_object_unref (_tmp29), NULL)));
		_tmp30 = NULL;
		if ((_tmp31 = vala_ccode_generator_class_has_readable_properties (self, cl) || gee_collection_get_size ((_tmp30 = vala_class_get_type_parameters (cl))) > 0, (_tmp30 == NULL ? NULL : (_tmp30 = (g_object_unref (_tmp30), NULL))), _tmp31)) {
			ValaCCodeExpressionStatement* _tmp37;
			ValaCCodeAssignment* _tmp36;
			ValaCCodeIdentifier* _tmp35;
			char* _tmp34;
			char* _tmp33;
			ValaCCodeMemberAccess* _tmp32;
			_tmp37 = NULL;
			_tmp36 = NULL;
			_tmp35 = NULL;
			_tmp34 = NULL;
			_tmp33 = NULL;
			_tmp32 = NULL;
			vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp37 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp36 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp32 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (ccall), "get_property"))), VALA_CCODE_EXPRESSION ((_tmp35 = vala_ccode_identifier_new ((_tmp34 = g_strdup_printf ("%s_get_property", (_tmp33 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL))))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
			(_tmp37 == NULL ? NULL : (_tmp37 = (g_object_unref (_tmp37), NULL)));
			(_tmp36 == NULL ? NULL : (_tmp36 = (g_object_unref (_tmp36), NULL)));
			(_tmp35 == NULL ? NULL : (_tmp35 = (g_object_unref (_tmp35), NULL)));
			(_tmp34 = (g_free (_tmp34), NULL));
			(_tmp33 = (g_free (_tmp33), NULL));
			(_tmp32 == NULL ? NULL : (_tmp32 = (g_object_unref (_tmp32), NULL)));
		}
		_tmp38 = NULL;
		if ((_tmp39 = vala_ccode_generator_class_has_writable_properties (self, cl) || gee_collection_get_size ((_tmp38 = vala_class_get_type_parameters (cl))) > 0, (_tmp38 == NULL ? NULL : (_tmp38 = (g_object_unref (_tmp38), NULL))), _tmp39)) {
			ValaCCodeExpressionStatement* _tmp45;
			ValaCCodeAssignment* _tmp44;
			ValaCCodeIdentifier* _tmp43;
			char* _tmp42;
			char* _tmp41;
			ValaCCodeMemberAccess* _tmp40;
			_tmp45 = NULL;
			_tmp44 = NULL;
			_tmp43 = NULL;
			_tmp42 = NULL;
			_tmp41 = NULL;
			_tmp40 = NULL;
			vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp45 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp44 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp40 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (ccall), "set_property"))), VALA_CCODE_EXPRESSION ((_tmp43 = vala_ccode_identifier_new ((_tmp42 = g_strdup_printf ("%s_set_property", (_tmp41 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL))))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
			(_tmp45 == NULL ? NULL : (_tmp45 = (g_object_unref (_tmp45), NULL)));
			(_tmp44 == NULL ? NULL : (_tmp44 = (g_object_unref (_tmp44), NULL)));
			(_tmp43 == NULL ? NULL : (_tmp43 = (g_object_unref (_tmp43), NULL)));
			(_tmp42 = (g_free (_tmp42), NULL));
			(_tmp41 = (g_free (_tmp41), NULL));
			(_tmp40 == NULL ? NULL : (_tmp40 = (g_object_unref (_tmp40), NULL)));
		}
		/* set constructor */
		if (vala_class_get_constructor (cl) != NULL) {
			ValaCCodeIdentifier* _tmp46;
			ValaCCodeFunctionCall* _tmp47;
			ValaCCodeFunctionCall* ccast;
			ValaCCodeIdentifier* _tmp48;
			ValaCCodeExpressionStatement* _tmp54;
			ValaCCodeAssignment* _tmp53;
			ValaCCodeIdentifier* _tmp52;
			char* _tmp51;
			char* _tmp50;
			ValaCCodeMemberAccess* _tmp49;
			_tmp46 = NULL;
			_tmp47 = NULL;
			ccast = (_tmp47 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp46 = vala_ccode_identifier_new ("G_OBJECT_CLASS")))), (_tmp46 == NULL ? NULL : (_tmp46 = (g_object_unref (_tmp46), NULL))), _tmp47);
			_tmp48 = NULL;
			vala_ccode_function_call_add_argument (ccast, VALA_CCODE_EXPRESSION ((_tmp48 = vala_ccode_identifier_new ("klass"))));
			(_tmp48 == NULL ? NULL : (_tmp48 = (g_object_unref (_tmp48), NULL)));
			_tmp54 = NULL;
			_tmp53 = NULL;
			_tmp52 = NULL;
			_tmp51 = NULL;
			_tmp50 = NULL;
			_tmp49 = NULL;
			vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp54 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp53 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp49 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (ccast), "constructor"))), VALA_CCODE_EXPRESSION ((_tmp52 = vala_ccode_identifier_new ((_tmp51 = g_strdup_printf ("%s_constructor", (_tmp50 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL))))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
			(_tmp54 == NULL ? NULL : (_tmp54 = (g_object_unref (_tmp54), NULL)));
			(_tmp53 == NULL ? NULL : (_tmp53 = (g_object_unref (_tmp53), NULL)));
			(_tmp52 == NULL ? NULL : (_tmp52 = (g_object_unref (_tmp52), NULL)));
			(_tmp51 = (g_free (_tmp51), NULL));
			(_tmp50 = (g_free (_tmp50), NULL));
			(_tmp49 == NULL ? NULL : (_tmp49 = (g_object_unref (_tmp49), NULL)));
			(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
		}
		/* set dispose function */
		_tmp55 = NULL;
		if ((_tmp56 = gee_collection_get_size ((_tmp55 = vala_class_get_fields (cl))) > 0, (_tmp55 == NULL ? NULL : (_tmp55 = (g_object_unref (_tmp55), NULL))), _tmp56)) {
			ValaCCodeIdentifier* _tmp57;
			ValaCCodeFunctionCall* _tmp58;
			ValaCCodeFunctionCall* ccast;
			ValaCCodeIdentifier* _tmp59;
			ValaCCodeExpressionStatement* _tmp65;
			ValaCCodeAssignment* _tmp64;
			ValaCCodeIdentifier* _tmp63;
			char* _tmp62;
			char* _tmp61;
			ValaCCodeMemberAccess* _tmp60;
			_tmp57 = NULL;
			_tmp58 = NULL;
			ccast = (_tmp58 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp57 = vala_ccode_identifier_new ("G_OBJECT_CLASS")))), (_tmp57 == NULL ? NULL : (_tmp57 = (g_object_unref (_tmp57), NULL))), _tmp58);
			_tmp59 = NULL;
			vala_ccode_function_call_add_argument (ccast, VALA_CCODE_EXPRESSION ((_tmp59 = vala_ccode_identifier_new ("klass"))));
			(_tmp59 == NULL ? NULL : (_tmp59 = (g_object_unref (_tmp59), NULL)));
			_tmp65 = NULL;
			_tmp64 = NULL;
			_tmp63 = NULL;
			_tmp62 = NULL;
			_tmp61 = NULL;
			_tmp60 = NULL;
			vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp65 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp64 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp60 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (ccast), "dispose"))), VALA_CCODE_EXPRESSION ((_tmp63 = vala_ccode_identifier_new ((_tmp62 = g_strdup_printf ("%s_dispose", (_tmp61 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL))))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
			(_tmp65 == NULL ? NULL : (_tmp65 = (g_object_unref (_tmp65), NULL)));
			(_tmp64 == NULL ? NULL : (_tmp64 = (g_object_unref (_tmp64), NULL)));
			(_tmp63 == NULL ? NULL : (_tmp63 = (g_object_unref (_tmp63), NULL)));
			(_tmp62 = (g_free (_tmp62), NULL));
			(_tmp61 = (g_free (_tmp61), NULL));
			(_tmp60 == NULL ? NULL : (_tmp60 = (g_object_unref (_tmp60), NULL)));
			(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
		}
	}
	{
		GeeCollection* m_collection;
		GeeIterator* m_it;
		m_collection = vala_class_get_methods (cl);
		m_it = gee_iterable_iterator (GEE_ITERABLE (m_collection));
		while (gee_iterator_next (m_it)) {
			ValaMethod* m;
			m = gee_iterator_get (m_it);
			{
				ValaSymbol* _tmp66;
				ValaSymbol* base_type;
				ValaCCodeIdentifier* _tmp69;
				char* _tmp68;
				char* _tmp67;
				ValaCCodeFunctionCall* _tmp70;
				ValaCCodeFunctionCall* ccast;
				ValaCCodeIdentifier* _tmp71;
				ValaCCodeExpressionStatement* _tmp76;
				ValaCCodeAssignment* _tmp75;
				ValaCCodeIdentifier* _tmp74;
				char* _tmp73;
				ValaCCodeMemberAccess* _tmp72;
				/* connect overridden methods */
				if (vala_method_get_base_method (m) == NULL) {
					(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
					continue;
				}
				_tmp66 = NULL;
				base_type = (_tmp66 = vala_symbol_get_parent_symbol (VALA_SYMBOL (vala_method_get_base_method (m))), (_tmp66 == NULL ? NULL : g_object_ref (_tmp66)));
				_tmp69 = NULL;
				_tmp68 = NULL;
				_tmp67 = NULL;
				_tmp70 = NULL;
				ccast = (_tmp70 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp69 = vala_ccode_identifier_new ((_tmp68 = g_strdup_printf ("%s_CLASS", (_tmp67 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL ((VALA_CLASS (base_type))), NULL)))))))), (_tmp69 == NULL ? NULL : (_tmp69 = (g_object_unref (_tmp69), NULL))), (_tmp68 = (g_free (_tmp68), NULL)), (_tmp67 = (g_free (_tmp67), NULL)), _tmp70);
				_tmp71 = NULL;
				vala_ccode_function_call_add_argument (ccast, VALA_CCODE_EXPRESSION ((_tmp71 = vala_ccode_identifier_new ("klass"))));
				(_tmp71 == NULL ? NULL : (_tmp71 = (g_object_unref (_tmp71), NULL)));
				_tmp76 = NULL;
				_tmp75 = NULL;
				_tmp74 = NULL;
				_tmp73 = NULL;
				_tmp72 = NULL;
				vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp76 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp75 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp72 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (ccast), vala_method_get_vfunc_name (vala_method_get_base_method (m))))), VALA_CCODE_EXPRESSION ((_tmp74 = vala_ccode_identifier_new ((_tmp73 = vala_method_get_real_cname (m))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
				(_tmp76 == NULL ? NULL : (_tmp76 = (g_object_unref (_tmp76), NULL)));
				(_tmp75 == NULL ? NULL : (_tmp75 = (g_object_unref (_tmp75), NULL)));
				(_tmp74 == NULL ? NULL : (_tmp74 = (g_object_unref (_tmp74), NULL)));
				(_tmp73 = (g_free (_tmp73), NULL));
				(_tmp72 == NULL ? NULL : (_tmp72 = (g_object_unref (_tmp72), NULL)));
				(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
				(base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL)));
				(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
			}
		}
		(m_collection == NULL ? NULL : (m_collection = (g_object_unref (m_collection), NULL)));
		(m_it == NULL ? NULL : (m_it = (g_object_unref (m_it), NULL)));
	}
	if (vala_typesymbol_is_subtype_of (VALA_TYPESYMBOL (cl), self->gobject_type)) {
		GeeCollection* props;
		{
			GeeCollection* type_param_collection;
			GeeIterator* type_param_it;
			type_param_collection = vala_class_get_type_parameters (cl);
			type_param_it = gee_iterable_iterator (GEE_ITERABLE (type_param_collection));
			while (gee_iterator_next (type_param_it)) {
				ValaTypeParameter* type_param;
				type_param = gee_iterator_get (type_param_it);
				{
					char* func_name;
					char* enum_value;
					ValaCCodeConstant* func_name_constant;
					ValaCCodeFunctionCall* cinst;
					ValaCCodeFunctionCall* cspec;
					char* _tmp78;
					char* _tmp77;
					ValaCCodeConstant* _tmp81;
					char* _tmp80;
					char* _tmp79;
					char* _tmp84;
					char* _tmp83;
					char* _tmp82;
					ValaCCodeFunctionCall* _tmp86;
					ValaCCodeIdentifier* _tmp85;
					ValaCCodeConstant* _tmp87;
					ValaCCodeFunctionCall* _tmp89;
					ValaCCodeIdentifier* _tmp88;
					ValaCCodeConstant* _tmp90;
					ValaCCodeConstant* _tmp91;
					ValaCCodeIdentifier* _tmp92;
					ValaCCodeConstant* _tmp93;
					ValaCCodeExpressionStatement* _tmp94;
					ValaCCodeEnumValue* _tmp95;
					char* _tmp97;
					char* _tmp96;
					ValaCCodeConstant* _tmp100;
					char* _tmp99;
					char* _tmp98;
					char* _tmp103;
					char* _tmp102;
					char* _tmp101;
					ValaCCodeFunctionCall* _tmp105;
					ValaCCodeIdentifier* _tmp104;
					ValaCCodeConstant* _tmp106;
					ValaCCodeFunctionCall* _tmp108;
					ValaCCodeIdentifier* _tmp107;
					ValaCCodeConstant* _tmp109;
					ValaCCodeConstant* _tmp110;
					ValaCCodeConstant* _tmp111;
					ValaCCodeExpressionStatement* _tmp112;
					ValaCCodeEnumValue* _tmp113;
					char* _tmp115;
					char* _tmp114;
					ValaCCodeConstant* _tmp118;
					char* _tmp117;
					char* _tmp116;
					char* _tmp121;
					char* _tmp120;
					char* _tmp119;
					ValaCCodeFunctionCall* _tmp123;
					ValaCCodeIdentifier* _tmp122;
					ValaCCodeConstant* _tmp124;
					ValaCCodeFunctionCall* _tmp126;
					ValaCCodeIdentifier* _tmp125;
					ValaCCodeConstant* _tmp127;
					ValaCCodeConstant* _tmp128;
					ValaCCodeConstant* _tmp129;
					ValaCCodeExpressionStatement* _tmp130;
					ValaCCodeEnumValue* _tmp131;
					/* create type, dup_func, and destroy_func properties for generic types */
					func_name = NULL;
					enum_value = NULL;
					func_name_constant = NULL;
					cinst = NULL;
					cspec = NULL;
					_tmp78 = NULL;
					_tmp77 = NULL;
					func_name = (_tmp78 = g_strdup_printf ("%s_type", (_tmp77 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1))), (func_name = (g_free (func_name), NULL)), _tmp78);
					(_tmp77 = (g_free (_tmp77), NULL));
					_tmp81 = NULL;
					_tmp80 = NULL;
					_tmp79 = NULL;
					func_name_constant = (_tmp81 = vala_ccode_constant_new ((_tmp80 = g_strdup_printf ("\"%s-type\"", (_tmp79 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1))))), (func_name_constant == NULL ? NULL : (func_name_constant = (g_object_unref (func_name_constant), NULL))), _tmp81);
					(_tmp80 = (g_free (_tmp80), NULL));
					(_tmp79 = (g_free (_tmp79), NULL));
					_tmp84 = NULL;
					_tmp83 = NULL;
					_tmp82 = NULL;
					enum_value = (_tmp84 = g_utf8_strup ((_tmp83 = g_strdup_printf ("%s_%s", (_tmp82 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)), func_name)), -1), (enum_value = (g_free (enum_value), NULL)), _tmp84);
					(_tmp83 = (g_free (_tmp83), NULL));
					(_tmp82 = (g_free (_tmp82), NULL));
					_tmp86 = NULL;
					_tmp85 = NULL;
					cinst = (_tmp86 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp85 = vala_ccode_identifier_new ("g_object_class_install_property")))), (cinst == NULL ? NULL : (cinst = (g_object_unref (cinst), NULL))), _tmp86);
					(_tmp85 == NULL ? NULL : (_tmp85 = (g_object_unref (_tmp85), NULL)));
					vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION (ccall));
					_tmp87 = NULL;
					vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION ((_tmp87 = vala_ccode_constant_new (enum_value))));
					(_tmp87 == NULL ? NULL : (_tmp87 = (g_object_unref (_tmp87), NULL)));
					_tmp89 = NULL;
					_tmp88 = NULL;
					cspec = (_tmp89 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp88 = vala_ccode_identifier_new ("g_param_spec_gtype")))), (cspec == NULL ? NULL : (cspec = (g_object_unref (cspec), NULL))), _tmp89);
					(_tmp88 == NULL ? NULL : (_tmp88 = (g_object_unref (_tmp88), NULL)));
					vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (func_name_constant));
					_tmp90 = NULL;
					vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp90 = vala_ccode_constant_new ("\"type\""))));
					(_tmp90 == NULL ? NULL : (_tmp90 = (g_object_unref (_tmp90), NULL)));
					_tmp91 = NULL;
					vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp91 = vala_ccode_constant_new ("\"type\""))));
					(_tmp91 == NULL ? NULL : (_tmp91 = (g_object_unref (_tmp91), NULL)));
					_tmp92 = NULL;
					vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp92 = vala_ccode_identifier_new ("G_TYPE_NONE"))));
					(_tmp92 == NULL ? NULL : (_tmp92 = (g_object_unref (_tmp92), NULL)));
					_tmp93 = NULL;
					vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp93 = vala_ccode_constant_new ("G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE"))));
					(_tmp93 == NULL ? NULL : (_tmp93 = (g_object_unref (_tmp93), NULL)));
					vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION (cspec));
					_tmp94 = NULL;
					vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp94 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cinst)))));
					(_tmp94 == NULL ? NULL : (_tmp94 = (g_object_unref (_tmp94), NULL)));
					_tmp95 = NULL;
					vala_ccode_enum_add_value (self->priv->prop_enum, (_tmp95 = vala_ccode_enum_value_new (enum_value, NULL)));
					(_tmp95 == NULL ? NULL : (_tmp95 = (g_object_unref (_tmp95), NULL)));
					vala_ccode_struct_add_field (self->priv->instance_priv_struct, "GType", func_name);
					_tmp97 = NULL;
					_tmp96 = NULL;
					func_name = (_tmp97 = g_strdup_printf ("%s_dup_func", (_tmp96 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1))), (func_name = (g_free (func_name), NULL)), _tmp97);
					(_tmp96 = (g_free (_tmp96), NULL));
					_tmp100 = NULL;
					_tmp99 = NULL;
					_tmp98 = NULL;
					func_name_constant = (_tmp100 = vala_ccode_constant_new ((_tmp99 = g_strdup_printf ("\"%s-dup-func\"", (_tmp98 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1))))), (func_name_constant == NULL ? NULL : (func_name_constant = (g_object_unref (func_name_constant), NULL))), _tmp100);
					(_tmp99 = (g_free (_tmp99), NULL));
					(_tmp98 = (g_free (_tmp98), NULL));
					_tmp103 = NULL;
					_tmp102 = NULL;
					_tmp101 = NULL;
					enum_value = (_tmp103 = g_utf8_strup ((_tmp102 = g_strdup_printf ("%s_%s", (_tmp101 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)), func_name)), -1), (enum_value = (g_free (enum_value), NULL)), _tmp103);
					(_tmp102 = (g_free (_tmp102), NULL));
					(_tmp101 = (g_free (_tmp101), NULL));
					_tmp105 = NULL;
					_tmp104 = NULL;
					cinst = (_tmp105 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp104 = vala_ccode_identifier_new ("g_object_class_install_property")))), (cinst == NULL ? NULL : (cinst = (g_object_unref (cinst), NULL))), _tmp105);
					(_tmp104 == NULL ? NULL : (_tmp104 = (g_object_unref (_tmp104), NULL)));
					vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION (ccall));
					_tmp106 = NULL;
					vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION ((_tmp106 = vala_ccode_constant_new (enum_value))));
					(_tmp106 == NULL ? NULL : (_tmp106 = (g_object_unref (_tmp106), NULL)));
					_tmp108 = NULL;
					_tmp107 = NULL;
					cspec = (_tmp108 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp107 = vala_ccode_identifier_new ("g_param_spec_pointer")))), (cspec == NULL ? NULL : (cspec = (g_object_unref (cspec), NULL))), _tmp108);
					(_tmp107 == NULL ? NULL : (_tmp107 = (g_object_unref (_tmp107), NULL)));
					vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (func_name_constant));
					_tmp109 = NULL;
					vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp109 = vala_ccode_constant_new ("\"dup func\""))));
					(_tmp109 == NULL ? NULL : (_tmp109 = (g_object_unref (_tmp109), NULL)));
					_tmp110 = NULL;
					vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp110 = vala_ccode_constant_new ("\"dup func\""))));
					(_tmp110 == NULL ? NULL : (_tmp110 = (g_object_unref (_tmp110), NULL)));
					_tmp111 = NULL;
					vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp111 = vala_ccode_constant_new ("G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE"))));
					(_tmp111 == NULL ? NULL : (_tmp111 = (g_object_unref (_tmp111), NULL)));
					vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION (cspec));
					_tmp112 = NULL;
					vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp112 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cinst)))));
					(_tmp112 == NULL ? NULL : (_tmp112 = (g_object_unref (_tmp112), NULL)));
					_tmp113 = NULL;
					vala_ccode_enum_add_value (self->priv->prop_enum, (_tmp113 = vala_ccode_enum_value_new (enum_value, NULL)));
					(_tmp113 == NULL ? NULL : (_tmp113 = (g_object_unref (_tmp113), NULL)));
					vala_ccode_struct_add_field (self->priv->instance_priv_struct, "GBoxedCopyFunc", func_name);
					_tmp115 = NULL;
					_tmp114 = NULL;
					func_name = (_tmp115 = g_strdup_printf ("%s_destroy_func", (_tmp114 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1))), (func_name = (g_free (func_name), NULL)), _tmp115);
					(_tmp114 = (g_free (_tmp114), NULL));
					_tmp118 = NULL;
					_tmp117 = NULL;
					_tmp116 = NULL;
					func_name_constant = (_tmp118 = vala_ccode_constant_new ((_tmp117 = g_strdup_printf ("\"%s-destroy-func\"", (_tmp116 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1))))), (func_name_constant == NULL ? NULL : (func_name_constant = (g_object_unref (func_name_constant), NULL))), _tmp118);
					(_tmp117 = (g_free (_tmp117), NULL));
					(_tmp116 = (g_free (_tmp116), NULL));
					_tmp121 = NULL;
					_tmp120 = NULL;
					_tmp119 = NULL;
					enum_value = (_tmp121 = g_utf8_strup ((_tmp120 = g_strdup_printf ("%s_%s", (_tmp119 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)), func_name)), -1), (enum_value = (g_free (enum_value), NULL)), _tmp121);
					(_tmp120 = (g_free (_tmp120), NULL));
					(_tmp119 = (g_free (_tmp119), NULL));
					_tmp123 = NULL;
					_tmp122 = NULL;
					cinst = (_tmp123 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp122 = vala_ccode_identifier_new ("g_object_class_install_property")))), (cinst == NULL ? NULL : (cinst = (g_object_unref (cinst), NULL))), _tmp123);
					(_tmp122 == NULL ? NULL : (_tmp122 = (g_object_unref (_tmp122), NULL)));
					vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION (ccall));
					_tmp124 = NULL;
					vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION ((_tmp124 = vala_ccode_constant_new (enum_value))));
					(_tmp124 == NULL ? NULL : (_tmp124 = (g_object_unref (_tmp124), NULL)));
					_tmp126 = NULL;
					_tmp125 = NULL;
					cspec = (_tmp126 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp125 = vala_ccode_identifier_new ("g_param_spec_pointer")))), (cspec == NULL ? NULL : (cspec = (g_object_unref (cspec), NULL))), _tmp126);
					(_tmp125 == NULL ? NULL : (_tmp125 = (g_object_unref (_tmp125), NULL)));
					vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (func_name_constant));
					_tmp127 = NULL;
					vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp127 = vala_ccode_constant_new ("\"destroy func\""))));
					(_tmp127 == NULL ? NULL : (_tmp127 = (g_object_unref (_tmp127), NULL)));
					_tmp128 = NULL;
					vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp128 = vala_ccode_constant_new ("\"destroy func\""))));
					(_tmp128 == NULL ? NULL : (_tmp128 = (g_object_unref (_tmp128), NULL)));
					_tmp129 = NULL;
					vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp129 = vala_ccode_constant_new ("G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE"))));
					(_tmp129 == NULL ? NULL : (_tmp129 = (g_object_unref (_tmp129), NULL)));
					vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION (cspec));
					_tmp130 = NULL;
					vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp130 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cinst)))));
					(_tmp130 == NULL ? NULL : (_tmp130 = (g_object_unref (_tmp130), NULL)));
					_tmp131 = NULL;
					vala_ccode_enum_add_value (self->priv->prop_enum, (_tmp131 = vala_ccode_enum_value_new (enum_value, NULL)));
					(_tmp131 == NULL ? NULL : (_tmp131 = (g_object_unref (_tmp131), NULL)));
					vala_ccode_struct_add_field (self->priv->instance_priv_struct, "GDestroyNotify", func_name);
					(type_param == NULL ? NULL : (type_param = (g_object_unref (type_param), NULL)));
					(func_name = (g_free (func_name), NULL));
					(enum_value = (g_free (enum_value), NULL));
					(func_name_constant == NULL ? NULL : (func_name_constant = (g_object_unref (func_name_constant), NULL)));
					(cinst == NULL ? NULL : (cinst = (g_object_unref (cinst), NULL)));
					(cspec == NULL ? NULL : (cspec = (g_object_unref (cspec), NULL)));
				}
			}
			(type_param_collection == NULL ? NULL : (type_param_collection = (g_object_unref (type_param_collection), NULL)));
			(type_param_it == NULL ? NULL : (type_param_it = (g_object_unref (type_param_it), NULL)));
		}
		/* create properties */
		props = vala_class_get_properties (cl);
		{
			GeeCollection* prop_collection;
			GeeIterator* prop_it;
			prop_collection = props;
			prop_it = gee_iterable_iterator (GEE_ITERABLE (prop_collection));
			while (gee_iterator_next (prop_it)) {
				ValaProperty* prop;
				prop = gee_iterator_get (prop_it);
				{
					if (vala_property_get_overrides (prop) || vala_property_get_base_interface_property (prop) != NULL) {
						ValaCCodeIdentifier* _tmp132;
						ValaCCodeFunctionCall* _tmp133;
						ValaCCodeFunctionCall* cinst;
						ValaCCodeConstant* _tmp135;
						char* _tmp134;
						ValaCCodeConstant* _tmp136;
						ValaCCodeExpressionStatement* _tmp137;
						_tmp132 = NULL;
						_tmp133 = NULL;
						cinst = (_tmp133 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp132 = vala_ccode_identifier_new ("g_object_class_override_property")))), (_tmp132 == NULL ? NULL : (_tmp132 = (g_object_unref (_tmp132), NULL))), _tmp133);
						vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION (ccall));
						_tmp135 = NULL;
						_tmp134 = NULL;
						vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION ((_tmp135 = vala_ccode_constant_new ((_tmp134 = vala_property_get_upper_case_cname (prop))))));
						(_tmp135 == NULL ? NULL : (_tmp135 = (g_object_unref (_tmp135), NULL)));
						(_tmp134 = (g_free (_tmp134), NULL));
						_tmp136 = NULL;
						vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION ((_tmp136 = vala_property_get_canonical_cconstant (prop))));
						(_tmp136 == NULL ? NULL : (_tmp136 = (g_object_unref (_tmp136), NULL)));
						_tmp137 = NULL;
						vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp137 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cinst)))));
						(_tmp137 == NULL ? NULL : (_tmp137 = (g_object_unref (_tmp137), NULL)));
						(cinst == NULL ? NULL : (cinst = (g_object_unref (cinst), NULL)));
					} else {
						ValaCCodeIdentifier* _tmp138;
						ValaCCodeFunctionCall* _tmp139;
						ValaCCodeFunctionCall* cinst;
						ValaCCodeConstant* _tmp141;
						char* _tmp140;
						ValaCCodeFunctionCall* _tmp142;
						ValaCCodeExpressionStatement* _tmp143;
						_tmp138 = NULL;
						_tmp139 = NULL;
						cinst = (_tmp139 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp138 = vala_ccode_identifier_new ("g_object_class_install_property")))), (_tmp138 == NULL ? NULL : (_tmp138 = (g_object_unref (_tmp138), NULL))), _tmp139);
						vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION (ccall));
						_tmp141 = NULL;
						_tmp140 = NULL;
						vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION ((_tmp141 = vala_ccode_constant_new ((_tmp140 = vala_property_get_upper_case_cname (prop))))));
						(_tmp141 == NULL ? NULL : (_tmp141 = (g_object_unref (_tmp141), NULL)));
						(_tmp140 = (g_free (_tmp140), NULL));
						_tmp142 = NULL;
						vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION ((_tmp142 = vala_ccode_generator_get_param_spec (self, prop))));
						(_tmp142 == NULL ? NULL : (_tmp142 = (g_object_unref (_tmp142), NULL)));
						_tmp143 = NULL;
						vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp143 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cinst)))));
						(_tmp143 == NULL ? NULL : (_tmp143 = (g_object_unref (_tmp143), NULL)));
						(cinst == NULL ? NULL : (cinst = (g_object_unref (cinst), NULL)));
					}
					(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
				}
			}
			(prop_it == NULL ? NULL : (prop_it = (g_object_unref (prop_it), NULL)));
		}
		{
			GeeCollection* sig_collection;
			GeeIterator* sig_it;
			sig_collection = vala_class_get_signals (cl);
			sig_it = gee_iterable_iterator (GEE_ITERABLE (sig_collection));
			while (gee_iterator_next (sig_it)) {
				ValaSignal* sig;
				sig = gee_iterator_get (sig_it);
				{
					ValaCCodeExpressionStatement* _tmp145;
					ValaCCodeFunctionCall* _tmp144;
					/* create signals */
					_tmp145 = NULL;
					_tmp144 = NULL;
					vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp145 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp144 = vala_ccode_generator_get_signal_creation (self, sig, VALA_TYPESYMBOL (cl))))))));
					(_tmp145 == NULL ? NULL : (_tmp145 = (g_object_unref (_tmp145), NULL)));
					(_tmp144 == NULL ? NULL : (_tmp144 = (g_object_unref (_tmp144), NULL)));
					(sig == NULL ? NULL : (sig = (g_object_unref (sig), NULL)));
				}
			}
			(sig_collection == NULL ? NULL : (sig_collection = (g_object_unref (sig_collection), NULL)));
			(sig_it == NULL ? NULL : (sig_it = (g_object_unref (sig_it), NULL)));
		}
		(props == NULL ? NULL : (props = (g_object_unref (props), NULL)));
	}
	vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE (self->priv->class_init_fragment));
	vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (class_init));
	(class_init == NULL ? NULL : (class_init = (g_object_unref (class_init), NULL)));
	(init_block == NULL ? NULL : (init_block = (g_object_unref (init_block), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(parent_decl == NULL ? NULL : (parent_decl = (g_object_unref (parent_decl), NULL)));
	(parent_var_decl == NULL ? NULL : (parent_var_decl = (g_object_unref (parent_var_decl), NULL)));
	(parent_assignment == NULL ? NULL : (parent_assignment = (g_object_unref (parent_assignment), NULL)));
}


static void vala_ccode_generator_add_interface_init_function (ValaCCodeGenerator* self, ValaClass* cl, ValaInterface* iface) {
	char* _tmp2;
	char* _tmp1;
	char* _tmp0;
	ValaCCodeFunction* _tmp3;
	ValaCCodeFunction* iface_init;
	ValaCCodeFormalParameter* _tmp6;
	char* _tmp5;
	char* _tmp4;
	ValaCCodeBlock* init_block;
	ValaCCodeFunctionCall* ccall;
	char* _tmp8;
	char* _tmp7;
	char* _tmp9;
	char* parent_iface_var;
	char* _tmp11;
	char* _tmp10;
	ValaCCodeDeclaration* _tmp12;
	ValaCCodeDeclaration* parent_decl;
	ValaCCodeVariableDeclarator* parent_var_decl;
	ValaCCodeConstant* _tmp13;
	ValaCCodeFunctionCall* _tmp15;
	ValaCCodeIdentifier* _tmp14;
	ValaCCodeIdentifier* _tmp16;
	ValaCCodeIdentifier* _tmp17;
	ValaCCodeAssignment* _tmp18;
	ValaCCodeAssignment* parent_assignment;
	ValaCCodeExpressionStatement* _tmp19;
	g_return_if_fail (VALA_IS_CCODE_GENERATOR (self));
	g_return_if_fail (cl == NULL || VALA_IS_CLASS (cl));
	g_return_if_fail (iface == NULL || VALA_IS_INTERFACE (iface));
	_tmp2 = NULL;
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp3 = NULL;
	iface_init = (_tmp3 = vala_ccode_function_new ((_tmp2 = g_strdup_printf ("%s_%s_interface_init", (_tmp0 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)), (_tmp1 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (iface), NULL)))), "void"), (_tmp2 = (g_free (_tmp2), NULL)), (_tmp1 = (g_free (_tmp1), NULL)), (_tmp0 = (g_free (_tmp0), NULL)), _tmp3);
	_tmp6 = NULL;
	_tmp5 = NULL;
	_tmp4 = NULL;
	vala_ccode_function_add_parameter (iface_init, (_tmp6 = vala_ccode_formal_parameter_new ("iface", (_tmp5 = g_strdup_printf ("%s *", (_tmp4 = vala_interface_get_type_cname (iface)))))));
	(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
	(_tmp5 = (g_free (_tmp5), NULL));
	(_tmp4 = (g_free (_tmp4), NULL));
	vala_ccode_function_set_modifiers (iface_init, VALA_CCODE_MODIFIERS_STATIC);
	init_block = vala_ccode_block_new ();
	vala_ccode_function_set_block (iface_init, init_block);
	ccall = NULL;
	/* save pointer to parent vtable */
	_tmp8 = NULL;
	_tmp7 = NULL;
	_tmp9 = NULL;
	parent_iface_var = (_tmp9 = g_strdup_printf ("%s_%s_parent_iface", (_tmp7 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)), (_tmp8 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (iface), NULL))), (_tmp8 = (g_free (_tmp8), NULL)), (_tmp7 = (g_free (_tmp7), NULL)), _tmp9);
	_tmp11 = NULL;
	_tmp10 = NULL;
	_tmp12 = NULL;
	parent_decl = (_tmp12 = vala_ccode_declaration_new ((_tmp11 = g_strconcat ((_tmp10 = vala_interface_get_type_cname (iface)), "*", NULL))), (_tmp11 = (g_free (_tmp11), NULL)), (_tmp10 = (g_free (_tmp10), NULL)), _tmp12);
	parent_var_decl = vala_ccode_variable_declarator_new (parent_iface_var);
	_tmp13 = NULL;
	vala_ccode_variable_declarator_set_initializer (parent_var_decl, VALA_CCODE_EXPRESSION ((_tmp13 = vala_ccode_constant_new ("NULL"))));
	(_tmp13 == NULL ? NULL : (_tmp13 = (g_object_unref (_tmp13), NULL)));
	vala_ccode_declaration_add_declarator (parent_decl, VALA_CCODE_DECLARATOR (parent_var_decl));
	vala_ccode_declaration_set_modifiers (parent_decl, VALA_CCODE_MODIFIERS_STATIC);
	vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE (parent_decl));
	_tmp15 = NULL;
	_tmp14 = NULL;
	ccall = (_tmp15 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp14 = vala_ccode_identifier_new ("g_type_interface_peek_parent")))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), _tmp15);
	(_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL)));
	_tmp16 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp16 = vala_ccode_identifier_new ("iface"))));
	(_tmp16 == NULL ? NULL : (_tmp16 = (g_object_unref (_tmp16), NULL)));
	_tmp17 = NULL;
	_tmp18 = NULL;
	parent_assignment = (_tmp18 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp17 = vala_ccode_identifier_new (parent_iface_var))), VALA_CCODE_EXPRESSION (ccall), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (_tmp17 == NULL ? NULL : (_tmp17 = (g_object_unref (_tmp17), NULL))), _tmp18);
	_tmp19 = NULL;
	vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp19 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (parent_assignment)))));
	(_tmp19 == NULL ? NULL : (_tmp19 = (g_object_unref (_tmp19), NULL)));
	{
		GeeCollection* m_collection;
		GeeIterator* m_it;
		m_collection = vala_class_get_methods (cl);
		m_it = gee_iterable_iterator (GEE_ITERABLE (m_collection));
		while (gee_iterator_next (m_it)) {
			ValaMethod* m;
			m = gee_iterator_get (m_it);
			{
				ValaSymbol* _tmp20;
				ValaSymbol* base_type;
				ValaCCodeIdentifier* ciface;
				char* cname;
				ValaCCodeExpressionStatement* _tmp25;
				ValaCCodeAssignment* _tmp24;
				ValaCCodeIdentifier* _tmp23;
				ValaCCodeMemberAccess* _tmp22;
				if (vala_method_get_base_interface_method (m) == NULL) {
					(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
					continue;
				}
				_tmp20 = NULL;
				base_type = (_tmp20 = vala_symbol_get_parent_symbol (VALA_SYMBOL (vala_method_get_base_interface_method (m))), (_tmp20 == NULL ? NULL : g_object_ref (_tmp20)));
				if (base_type != VALA_SYMBOL (iface)) {
					(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
					(base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL)));
					continue;
				}
				ciface = vala_ccode_identifier_new ("iface");
				cname = vala_method_get_real_cname (m);
				if (vala_method_get_is_abstract (m) || vala_method_get_is_virtual (m)) {
					char* _tmp21;
					/* FIXME results in C compiler warning*/
					_tmp21 = NULL;
					cname = (_tmp21 = vala_method_get_cname (m), (cname = (g_free (cname), NULL)), _tmp21);
				}
				_tmp25 = NULL;
				_tmp24 = NULL;
				_tmp23 = NULL;
				_tmp22 = NULL;
				vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp25 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp24 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp22 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (ciface), vala_method_get_vfunc_name (vala_method_get_base_interface_method (m))))), VALA_CCODE_EXPRESSION ((_tmp23 = vala_ccode_identifier_new (cname))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
				(_tmp25 == NULL ? NULL : (_tmp25 = (g_object_unref (_tmp25), NULL)));
				(_tmp24 == NULL ? NULL : (_tmp24 = (g_object_unref (_tmp24), NULL)));
				(_tmp23 == NULL ? NULL : (_tmp23 = (g_object_unref (_tmp23), NULL)));
				(_tmp22 == NULL ? NULL : (_tmp22 = (g_object_unref (_tmp22), NULL)));
				(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
				(base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL)));
				(ciface == NULL ? NULL : (ciface = (g_object_unref (ciface), NULL)));
				(cname = (g_free (cname), NULL));
			}
		}
		(m_collection == NULL ? NULL : (m_collection = (g_object_unref (m_collection), NULL)));
		(m_it == NULL ? NULL : (m_it = (g_object_unref (m_it), NULL)));
	}
	vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (iface_init));
	(iface_init == NULL ? NULL : (iface_init = (g_object_unref (iface_init), NULL)));
	(init_block == NULL ? NULL : (init_block = (g_object_unref (init_block), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(parent_iface_var = (g_free (parent_iface_var), NULL));
	(parent_decl == NULL ? NULL : (parent_decl = (g_object_unref (parent_decl), NULL)));
	(parent_var_decl == NULL ? NULL : (parent_var_decl = (g_object_unref (parent_var_decl), NULL)));
	(parent_assignment == NULL ? NULL : (parent_assignment = (g_object_unref (parent_assignment), NULL)));
}


static void vala_ccode_generator_add_instance_init_function (ValaCCodeGenerator* self, ValaClass* cl) {
	char* _tmp1;
	char* _tmp0;
	ValaCCodeFunction* _tmp2;
	ValaCCodeFunction* instance_init;
	ValaCCodeFormalParameter* _tmp5;
	char* _tmp4;
	char* _tmp3;
	ValaCCodeBlock* init_block;
	GeeCollection* _tmp6;
	gboolean _tmp7;
	ValaSymbol* init_sym;
	g_return_if_fail (VALA_IS_CCODE_GENERATOR (self));
	g_return_if_fail (cl == NULL || VALA_IS_CLASS (cl));
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp2 = NULL;
	instance_init = (_tmp2 = vala_ccode_function_new ((_tmp1 = g_strdup_printf ("%s_init", (_tmp0 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)))), "void"), (_tmp1 = (g_free (_tmp1), NULL)), (_tmp0 = (g_free (_tmp0), NULL)), _tmp2);
	_tmp5 = NULL;
	_tmp4 = NULL;
	_tmp3 = NULL;
	vala_ccode_function_add_parameter (instance_init, (_tmp5 = vala_ccode_formal_parameter_new ("self", (_tmp4 = g_strdup_printf ("%s *", (_tmp3 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE)))))));
	(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
	(_tmp4 = (g_free (_tmp4), NULL));
	(_tmp3 = (g_free (_tmp3), NULL));
	vala_ccode_function_set_modifiers (instance_init, VALA_CCODE_MODIFIERS_STATIC);
	init_block = vala_ccode_block_new ();
	vala_ccode_function_set_block (instance_init, init_block);
	_tmp6 = NULL;
	if ((_tmp7 = vala_class_get_has_private_fields (cl) || gee_collection_get_size ((_tmp6 = vala_class_get_type_parameters (cl))) > 0, (_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL))), _tmp7)) {
		ValaCCodeIdentifier* _tmp10;
		char* _tmp9;
		char* _tmp8;
		ValaCCodeFunctionCall* _tmp11;
		ValaCCodeFunctionCall* ccall;
		ValaCCodeIdentifier* _tmp12;
		ValaCCodeExpressionStatement* _tmp16;
		ValaCCodeAssignment* _tmp15;
		ValaCCodeMemberAccess* _tmp14;
		ValaCCodeIdentifier* _tmp13;
		_tmp10 = NULL;
		_tmp9 = NULL;
		_tmp8 = NULL;
		_tmp11 = NULL;
		ccall = (_tmp11 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp10 = vala_ccode_identifier_new ((_tmp9 = g_strdup_printf ("%s_GET_PRIVATE", (_tmp8 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (cl), NULL)))))))), (_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL))), (_tmp9 = (g_free (_tmp9), NULL)), (_tmp8 = (g_free (_tmp8), NULL)), _tmp11);
		_tmp12 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp12 = vala_ccode_identifier_new ("self"))));
		(_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL)));
		_tmp16 = NULL;
		_tmp15 = NULL;
		_tmp14 = NULL;
		_tmp13 = NULL;
		vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp16 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp15 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp14 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp13 = vala_ccode_identifier_new ("self"))), "priv"))), VALA_CCODE_EXPRESSION (ccall), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
		(_tmp16 == NULL ? NULL : (_tmp16 = (g_object_unref (_tmp16), NULL)));
		(_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL)));
		(_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL)));
		(_tmp13 == NULL ? NULL : (_tmp13 = (g_object_unref (_tmp13), NULL)));
		(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	}
	vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE (self->priv->instance_init_fragment));
	init_sym = vala_scope_lookup (vala_symbol_get_scope (VALA_SYMBOL (cl)), "init");
	if (init_sym != NULL) {
		ValaMethod* _tmp17;
		ValaMethod* init_fun;
		_tmp17 = NULL;
		init_fun = (_tmp17 = VALA_METHOD (init_sym), (_tmp17 == NULL ? NULL : g_object_ref (_tmp17)));
		vala_ccode_block_add_statement (init_block, vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_method_get_body (init_fun))));
		(init_fun == NULL ? NULL : (init_fun = (g_object_unref (init_fun), NULL)));
	}
	vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (instance_init));
	(instance_init == NULL ? NULL : (instance_init = (g_object_unref (instance_init), NULL)));
	(init_block == NULL ? NULL : (init_block = (g_object_unref (init_block), NULL)));
	(init_sym == NULL ? NULL : (init_sym = (g_object_unref (init_sym), NULL)));
}


static void vala_ccode_generator_add_dispose_function (ValaCCodeGenerator* self, ValaClass* cl) {
	ValaCCodeFunction* _tmp2;
	char* _tmp1;
	char* _tmp0;
	ValaCCodeFormalParameter* _tmp3;
	ValaCCodeFunction* _tmp4;
	ValaCCodeBlock* cblock;
	ValaCCodeIdentifier* _tmp5;
	ValaInstanceCast* _tmp6;
	ValaCCodeFunctionCall* ccall;
	char* _tmp8;
	char* _tmp7;
	ValaCCodeDeclaration* _tmp9;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeVariableDeclarator* _tmp10;
	ValaCCodeIdentifier* _tmp11;
	ValaCCodeFunctionCall* _tmp12;
	ValaCCodeFunctionCall* ccast;
	ValaCCodeIdentifier* _tmp15;
	char* _tmp14;
	char* _tmp13;
	ValaCCodeFunctionCall* _tmp17;
	ValaCCodeMemberAccess* _tmp16;
	ValaCCodeIdentifier* _tmp18;
	ValaCCodeExpressionStatement* _tmp19;
	g_return_if_fail (VALA_IS_CCODE_GENERATOR (self));
	g_return_if_fail (cl == NULL || VALA_IS_CLASS (cl));
	_tmp2 = NULL;
	_tmp1 = NULL;
	_tmp0 = NULL;
	self->priv->function = (_tmp2 = vala_ccode_function_new ((_tmp1 = g_strdup_printf ("%s_dispose", (_tmp0 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)))), "void"), (self->priv->function == NULL ? NULL : (self->priv->function = (g_object_unref (self->priv->function), NULL))), _tmp2);
	(_tmp1 = (g_free (_tmp1), NULL));
	(_tmp0 = (g_free (_tmp0), NULL));
	vala_ccode_function_set_modifiers (self->priv->function, VALA_CCODE_MODIFIERS_STATIC);
	_tmp3 = NULL;
	vala_ccode_function_add_parameter (self->priv->function, (_tmp3 = vala_ccode_formal_parameter_new ("obj", "GObject *")));
	(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
	_tmp4 = NULL;
	vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE ((_tmp4 = vala_ccode_function_copy (self->priv->function))));
	(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
	cblock = vala_ccode_block_new ();
	_tmp5 = NULL;
	_tmp6 = NULL;
	ccall = VALA_CCODE_FUNCTION_CALL ((_tmp6 = vala_instance_cast_new (VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_identifier_new ("obj"))), VALA_TYPESYMBOL (cl)), (_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL))), _tmp6));
	_tmp8 = NULL;
	_tmp7 = NULL;
	_tmp9 = NULL;
	cdecl_ = (_tmp9 = vala_ccode_declaration_new ((_tmp8 = g_strdup_printf ("%s *", (_tmp7 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE))))), (_tmp8 = (g_free (_tmp8), NULL)), (_tmp7 = (g_free (_tmp7), NULL)), _tmp9);
	_tmp10 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp10 = vala_ccode_variable_declarator_new_with_initializer ("self", VALA_CCODE_EXPRESSION (ccall)))));
	(_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL)));
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cdecl_));
	if (vala_class_get_destructor (cl) != NULL) {
		vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (VALA_CCODE_BLOCK (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_destructor_get_body (vala_class_get_destructor (cl)))))));
	}
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (self->priv->instance_dispose_fragment));
	/* chain up to dispose function of the base class*/
	_tmp11 = NULL;
	_tmp12 = NULL;
	ccast = (_tmp12 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp11 = vala_ccode_identifier_new ("G_OBJECT_CLASS")))), (_tmp11 == NULL ? NULL : (_tmp11 = (g_object_unref (_tmp11), NULL))), _tmp12);
	_tmp15 = NULL;
	_tmp14 = NULL;
	_tmp13 = NULL;
	vala_ccode_function_call_add_argument (ccast, VALA_CCODE_EXPRESSION ((_tmp15 = vala_ccode_identifier_new ((_tmp14 = g_strdup_printf ("%s_parent_class", (_tmp13 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL))))))));
	(_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL)));
	(_tmp14 = (g_free (_tmp14), NULL));
	(_tmp13 = (g_free (_tmp13), NULL));
	_tmp17 = NULL;
	_tmp16 = NULL;
	ccall = (_tmp17 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp16 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (ccast), "dispose")))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), _tmp17);
	(_tmp16 == NULL ? NULL : (_tmp16 = (g_object_unref (_tmp16), NULL)));
	_tmp18 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp18 = vala_ccode_identifier_new ("obj"))));
	(_tmp18 == NULL ? NULL : (_tmp18 = (g_object_unref (_tmp18), NULL)));
	_tmp19 = NULL;
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((_tmp19 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
	(_tmp19 == NULL ? NULL : (_tmp19 = (g_object_unref (_tmp19), NULL)));
	vala_ccode_function_set_block (self->priv->function, cblock);
	vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (self->priv->function));
	(cblock == NULL ? NULL : (cblock = (g_object_unref (cblock), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
	(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
}


ValaCCodeIdentifier* vala_ccode_generator_get_value_setter_function (ValaCCodeGenerator* self, ValaDataType* type_reference) {
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	g_return_val_if_fail (type_reference == NULL || VALA_IS_DATA_TYPE (type_reference), NULL);
	if (vala_data_type_get_data_type (type_reference) != NULL) {
		char* _tmp0;
		ValaCCodeIdentifier* _tmp1;
		_tmp0 = NULL;
		_tmp1 = NULL;
		return (_tmp1 = vala_ccode_identifier_new ((_tmp0 = vala_typesymbol_get_set_value_function (vala_data_type_get_data_type (type_reference)))), (_tmp0 = (g_free (_tmp0), NULL)), _tmp1);
	} else {
		return vala_ccode_identifier_new ("g_value_set_pointer");
	}
}


static gboolean vala_ccode_generator_class_has_readable_properties (ValaCCodeGenerator* self, ValaClass* cl) {
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), FALSE);
	g_return_val_if_fail (cl == NULL || VALA_IS_CLASS (cl), FALSE);
	{
		GeeCollection* prop_collection;
		GeeIterator* prop_it;
		prop_collection = vala_class_get_properties (cl);
		prop_it = gee_iterable_iterator (GEE_ITERABLE (prop_collection));
		while (gee_iterator_next (prop_it)) {
			ValaProperty* prop;
			prop = gee_iterator_get (prop_it);
			{
				if (vala_property_get_get_accessor (prop) != NULL) {
					gboolean _tmp0;
					return (_tmp0 = TRUE, (prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL))), (prop_collection == NULL ? NULL : (prop_collection = (g_object_unref (prop_collection), NULL))), (prop_it == NULL ? NULL : (prop_it = (g_object_unref (prop_it), NULL))), _tmp0);
				}
				(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
			}
		}
		(prop_collection == NULL ? NULL : (prop_collection = (g_object_unref (prop_collection), NULL)));
		(prop_it == NULL ? NULL : (prop_it = (g_object_unref (prop_it), NULL)));
	}
	return FALSE;
}


static gboolean vala_ccode_generator_class_has_writable_properties (ValaCCodeGenerator* self, ValaClass* cl) {
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), FALSE);
	g_return_val_if_fail (cl == NULL || VALA_IS_CLASS (cl), FALSE);
	{
		GeeCollection* prop_collection;
		GeeIterator* prop_it;
		prop_collection = vala_class_get_properties (cl);
		prop_it = gee_iterable_iterator (GEE_ITERABLE (prop_collection));
		while (gee_iterator_next (prop_it)) {
			ValaProperty* prop;
			prop = gee_iterator_get (prop_it);
			{
				if (vala_property_get_set_accessor (prop) != NULL) {
					gboolean _tmp0;
					return (_tmp0 = TRUE, (prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL))), (prop_collection == NULL ? NULL : (prop_collection = (g_object_unref (prop_collection), NULL))), (prop_it == NULL ? NULL : (prop_it = (g_object_unref (prop_it), NULL))), _tmp0);
				}
				(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
			}
		}
		(prop_collection == NULL ? NULL : (prop_collection = (g_object_unref (prop_collection), NULL)));
		(prop_it == NULL ? NULL : (prop_it = (g_object_unref (prop_it), NULL)));
	}
	return FALSE;
}


static void vala_ccode_generator_add_get_property_function (ValaCCodeGenerator* self, ValaClass* cl) {
	char* _tmp1;
	char* _tmp0;
	ValaCCodeFunction* _tmp2;
	ValaCCodeFunction* get_prop;
	ValaCCodeFormalParameter* _tmp3;
	ValaCCodeFormalParameter* _tmp4;
	ValaCCodeFormalParameter* _tmp5;
	ValaCCodeFormalParameter* _tmp6;
	ValaCCodeBlock* block;
	ValaCCodeIdentifier* _tmp7;
	ValaInstanceCast* _tmp8;
	ValaInstanceCast* ccall;
	char* _tmp10;
	char* _tmp9;
	ValaCCodeDeclaration* _tmp11;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeVariableDeclarator* _tmp12;
	ValaCCodeIdentifier* _tmp13;
	ValaCCodeSwitchStatement* _tmp14;
	ValaCCodeSwitchStatement* cswitch;
	GeeCollection* props;
	ValaCCodeStatement* _tmp27;
	ValaCCodeBreakStatement* _tmp28;
	g_return_if_fail (VALA_IS_CCODE_GENERATOR (self));
	g_return_if_fail (cl == NULL || VALA_IS_CLASS (cl));
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp2 = NULL;
	get_prop = (_tmp2 = vala_ccode_function_new ((_tmp1 = g_strdup_printf ("%s_get_property", (_tmp0 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)))), "void"), (_tmp1 = (g_free (_tmp1), NULL)), (_tmp0 = (g_free (_tmp0), NULL)), _tmp2);
	vala_ccode_function_set_modifiers (get_prop, VALA_CCODE_MODIFIERS_STATIC);
	_tmp3 = NULL;
	vala_ccode_function_add_parameter (get_prop, (_tmp3 = vala_ccode_formal_parameter_new ("object", "GObject *")));
	(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
	_tmp4 = NULL;
	vala_ccode_function_add_parameter (get_prop, (_tmp4 = vala_ccode_formal_parameter_new ("property_id", "guint")));
	(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
	_tmp5 = NULL;
	vala_ccode_function_add_parameter (get_prop, (_tmp5 = vala_ccode_formal_parameter_new ("value", "GValue *")));
	(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
	_tmp6 = NULL;
	vala_ccode_function_add_parameter (get_prop, (_tmp6 = vala_ccode_formal_parameter_new ("pspec", "GParamSpec *")));
	(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
	block = vala_ccode_block_new ();
	_tmp7 = NULL;
	_tmp8 = NULL;
	ccall = (_tmp8 = vala_instance_cast_new (VALA_CCODE_EXPRESSION ((_tmp7 = vala_ccode_identifier_new ("object"))), VALA_TYPESYMBOL (cl)), (_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL))), _tmp8);
	_tmp10 = NULL;
	_tmp9 = NULL;
	_tmp11 = NULL;
	cdecl_ = (_tmp11 = vala_ccode_declaration_new ((_tmp10 = g_strdup_printf ("%s *", (_tmp9 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE))))), (_tmp10 = (g_free (_tmp10), NULL)), (_tmp9 = (g_free (_tmp9), NULL)), _tmp11);
	_tmp12 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp12 = vala_ccode_variable_declarator_new_with_initializer ("self", VALA_CCODE_EXPRESSION (ccall)))));
	(_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL)));
	vala_ccode_block_add_statement (block, VALA_CCODE_NODE (cdecl_));
	_tmp13 = NULL;
	_tmp14 = NULL;
	cswitch = (_tmp14 = vala_ccode_switch_statement_new (VALA_CCODE_EXPRESSION ((_tmp13 = vala_ccode_identifier_new ("property_id")))), (_tmp13 == NULL ? NULL : (_tmp13 = (g_object_unref (_tmp13), NULL))), _tmp14);
	props = vala_class_get_properties (cl);
	{
		GeeCollection* prop_collection;
		GeeIterator* prop_it;
		prop_collection = props;
		prop_it = gee_iterable_iterator (GEE_ITERABLE (prop_collection));
		while (gee_iterator_next (prop_it)) {
			ValaProperty* prop;
			prop = gee_iterator_get (prop_it);
			{
				gboolean is_virtual;
				char* prefix;
				ValaCCodeIdentifier* _tmp17;
				char* _tmp16;
				ValaCCodeCaseStatement* _tmp18;
				ValaCCodeCaseStatement* ccase;
				ValaCCodeIdentifier* _tmp20;
				char* _tmp19;
				ValaCCodeFunctionCall* _tmp21;
				ValaCCodeFunctionCall* ccall;
				ValaCCodeIdentifier* _tmp22;
				ValaCCodeFunctionCall* csetcall;
				ValaCCodeIdentifier* _tmp23;
				ValaCCodeIdentifier* _tmp24;
				ValaCCodeExpressionStatement* _tmp25;
				ValaCCodeBreakStatement* _tmp26;
				if (vala_property_get_get_accessor (prop) == NULL || vala_property_get_is_abstract (prop)) {
					(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
					continue;
				}
				is_virtual = vala_property_get_base_property (prop) != NULL || vala_property_get_base_interface_property (prop) != NULL;
				prefix = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL);
				if (is_virtual) {
					char* _tmp15;
					_tmp15 = NULL;
					prefix = (_tmp15 = g_strconcat (prefix, ("_real"), NULL), (prefix = (g_free (prefix), NULL)), _tmp15);
				}
				_tmp17 = NULL;
				_tmp16 = NULL;
				_tmp18 = NULL;
				ccase = (_tmp18 = vala_ccode_case_statement_new (VALA_CCODE_EXPRESSION ((_tmp17 = vala_ccode_identifier_new ((_tmp16 = vala_property_get_upper_case_cname (prop)))))), (_tmp17 == NULL ? NULL : (_tmp17 = (g_object_unref (_tmp17), NULL))), (_tmp16 = (g_free (_tmp16), NULL)), _tmp18);
				_tmp20 = NULL;
				_tmp19 = NULL;
				_tmp21 = NULL;
				ccall = (_tmp21 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp20 = vala_ccode_identifier_new ((_tmp19 = g_strdup_printf ("%s_get_%s", prefix, vala_symbol_get_name (VALA_SYMBOL (prop)))))))), (_tmp20 == NULL ? NULL : (_tmp20 = (g_object_unref (_tmp20), NULL))), (_tmp19 = (g_free (_tmp19), NULL)), _tmp21);
				_tmp22 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp22 = vala_ccode_identifier_new ("self"))));
				(_tmp22 == NULL ? NULL : (_tmp22 = (g_object_unref (_tmp22), NULL)));
				csetcall = vala_ccode_function_call_new (NULL);
				_tmp23 = NULL;
				vala_ccode_function_call_set_call (csetcall, VALA_CCODE_EXPRESSION ((_tmp23 = vala_ccode_generator_get_value_setter_function (self, vala_property_get_type_reference (prop)))));
				(_tmp23 == NULL ? NULL : (_tmp23 = (g_object_unref (_tmp23), NULL)));
				_tmp24 = NULL;
				vala_ccode_function_call_add_argument (csetcall, VALA_CCODE_EXPRESSION ((_tmp24 = vala_ccode_identifier_new ("value"))));
				(_tmp24 == NULL ? NULL : (_tmp24 = (g_object_unref (_tmp24), NULL)));
				vala_ccode_function_call_add_argument (csetcall, VALA_CCODE_EXPRESSION (ccall));
				_tmp25 = NULL;
				vala_ccode_case_statement_add_statement (ccase, VALA_CCODE_STATEMENT ((_tmp25 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (csetcall)))));
				(_tmp25 == NULL ? NULL : (_tmp25 = (g_object_unref (_tmp25), NULL)));
				_tmp26 = NULL;
				vala_ccode_case_statement_add_statement (ccase, VALA_CCODE_STATEMENT ((_tmp26 = vala_ccode_break_statement_new ())));
				(_tmp26 == NULL ? NULL : (_tmp26 = (g_object_unref (_tmp26), NULL)));
				vala_ccode_switch_statement_add_case (cswitch, ccase);
				(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
				(prefix = (g_free (prefix), NULL));
				(ccase == NULL ? NULL : (ccase = (g_object_unref (ccase), NULL)));
				(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
				(csetcall == NULL ? NULL : (csetcall = (g_object_unref (csetcall), NULL)));
			}
		}
		(prop_it == NULL ? NULL : (prop_it = (g_object_unref (prop_it), NULL)));
	}
	_tmp27 = NULL;
	vala_ccode_switch_statement_add_default_statement (cswitch, (_tmp27 = vala_ccode_generator_get_invalid_property_id_warn_statement (self)));
	(_tmp27 == NULL ? NULL : (_tmp27 = (g_object_unref (_tmp27), NULL)));
	_tmp28 = NULL;
	vala_ccode_switch_statement_add_default_statement (cswitch, VALA_CCODE_STATEMENT ((_tmp28 = vala_ccode_break_statement_new ())));
	(_tmp28 == NULL ? NULL : (_tmp28 = (g_object_unref (_tmp28), NULL)));
	vala_ccode_block_add_statement (block, VALA_CCODE_NODE (cswitch));
	vala_ccode_function_set_block (get_prop, block);
	vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (get_prop));
	(get_prop == NULL ? NULL : (get_prop = (g_object_unref (get_prop), NULL)));
	(block == NULL ? NULL : (block = (g_object_unref (block), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
	(cswitch == NULL ? NULL : (cswitch = (g_object_unref (cswitch), NULL)));
	(props == NULL ? NULL : (props = (g_object_unref (props), NULL)));
}


static void vala_ccode_generator_add_set_property_function (ValaCCodeGenerator* self, ValaClass* cl) {
	char* _tmp1;
	char* _tmp0;
	ValaCCodeFunction* _tmp2;
	ValaCCodeFunction* set_prop;
	ValaCCodeFormalParameter* _tmp3;
	ValaCCodeFormalParameter* _tmp4;
	ValaCCodeFormalParameter* _tmp5;
	ValaCCodeFormalParameter* _tmp6;
	ValaCCodeBlock* block;
	ValaCCodeIdentifier* _tmp7;
	ValaInstanceCast* _tmp8;
	ValaInstanceCast* ccall;
	char* _tmp10;
	char* _tmp9;
	ValaCCodeDeclaration* _tmp11;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeVariableDeclarator* _tmp12;
	ValaCCodeIdentifier* _tmp13;
	ValaCCodeSwitchStatement* _tmp14;
	ValaCCodeSwitchStatement* cswitch;
	GeeCollection* props;
	ValaCCodeStatement* _tmp29;
	ValaCCodeBreakStatement* _tmp30;
	g_return_if_fail (VALA_IS_CCODE_GENERATOR (self));
	g_return_if_fail (cl == NULL || VALA_IS_CLASS (cl));
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp2 = NULL;
	set_prop = (_tmp2 = vala_ccode_function_new ((_tmp1 = g_strdup_printf ("%s_set_property", (_tmp0 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)))), "void"), (_tmp1 = (g_free (_tmp1), NULL)), (_tmp0 = (g_free (_tmp0), NULL)), _tmp2);
	vala_ccode_function_set_modifiers (set_prop, VALA_CCODE_MODIFIERS_STATIC);
	_tmp3 = NULL;
	vala_ccode_function_add_parameter (set_prop, (_tmp3 = vala_ccode_formal_parameter_new ("object", "GObject *")));
	(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
	_tmp4 = NULL;
	vala_ccode_function_add_parameter (set_prop, (_tmp4 = vala_ccode_formal_parameter_new ("property_id", "guint")));
	(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
	_tmp5 = NULL;
	vala_ccode_function_add_parameter (set_prop, (_tmp5 = vala_ccode_formal_parameter_new ("value", "const GValue *")));
	(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
	_tmp6 = NULL;
	vala_ccode_function_add_parameter (set_prop, (_tmp6 = vala_ccode_formal_parameter_new ("pspec", "GParamSpec *")));
	(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
	block = vala_ccode_block_new ();
	_tmp7 = NULL;
	_tmp8 = NULL;
	ccall = (_tmp8 = vala_instance_cast_new (VALA_CCODE_EXPRESSION ((_tmp7 = vala_ccode_identifier_new ("object"))), VALA_TYPESYMBOL (cl)), (_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL))), _tmp8);
	_tmp10 = NULL;
	_tmp9 = NULL;
	_tmp11 = NULL;
	cdecl_ = (_tmp11 = vala_ccode_declaration_new ((_tmp10 = g_strdup_printf ("%s *", (_tmp9 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE))))), (_tmp10 = (g_free (_tmp10), NULL)), (_tmp9 = (g_free (_tmp9), NULL)), _tmp11);
	_tmp12 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp12 = vala_ccode_variable_declarator_new_with_initializer ("self", VALA_CCODE_EXPRESSION (ccall)))));
	(_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL)));
	vala_ccode_block_add_statement (block, VALA_CCODE_NODE (cdecl_));
	_tmp13 = NULL;
	_tmp14 = NULL;
	cswitch = (_tmp14 = vala_ccode_switch_statement_new (VALA_CCODE_EXPRESSION ((_tmp13 = vala_ccode_identifier_new ("property_id")))), (_tmp13 == NULL ? NULL : (_tmp13 = (g_object_unref (_tmp13), NULL))), _tmp14);
	props = vala_class_get_properties (cl);
	{
		GeeCollection* prop_collection;
		GeeIterator* prop_it;
		prop_collection = props;
		prop_it = gee_iterable_iterator (GEE_ITERABLE (prop_collection));
		while (gee_iterator_next (prop_it)) {
			ValaProperty* prop;
			prop = gee_iterator_get (prop_it);
			{
				gboolean is_virtual;
				char* prefix;
				ValaCCodeIdentifier* _tmp17;
				char* _tmp16;
				ValaCCodeCaseStatement* _tmp18;
				ValaCCodeCaseStatement* ccase;
				ValaCCodeIdentifier* _tmp20;
				char* _tmp19;
				ValaCCodeFunctionCall* _tmp21;
				ValaCCodeFunctionCall* ccall;
				ValaCCodeIdentifier* _tmp22;
				ValaCCodeFunctionCall* cgetcall;
				ValaCCodeIdentifier* _tmp26;
				ValaCCodeExpressionStatement* _tmp27;
				ValaCCodeBreakStatement* _tmp28;
				if (vala_property_get_set_accessor (prop) == NULL || vala_property_get_is_abstract (prop)) {
					(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
					continue;
				}
				is_virtual = vala_property_get_base_property (prop) != NULL || vala_property_get_base_interface_property (prop) != NULL;
				prefix = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL);
				if (is_virtual) {
					char* _tmp15;
					_tmp15 = NULL;
					prefix = (_tmp15 = g_strconcat (prefix, ("_real"), NULL), (prefix = (g_free (prefix), NULL)), _tmp15);
				}
				_tmp17 = NULL;
				_tmp16 = NULL;
				_tmp18 = NULL;
				ccase = (_tmp18 = vala_ccode_case_statement_new (VALA_CCODE_EXPRESSION ((_tmp17 = vala_ccode_identifier_new ((_tmp16 = vala_property_get_upper_case_cname (prop)))))), (_tmp17 == NULL ? NULL : (_tmp17 = (g_object_unref (_tmp17), NULL))), (_tmp16 = (g_free (_tmp16), NULL)), _tmp18);
				_tmp20 = NULL;
				_tmp19 = NULL;
				_tmp21 = NULL;
				ccall = (_tmp21 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp20 = vala_ccode_identifier_new ((_tmp19 = g_strdup_printf ("%s_set_%s", prefix, vala_symbol_get_name (VALA_SYMBOL (prop)))))))), (_tmp20 == NULL ? NULL : (_tmp20 = (g_object_unref (_tmp20), NULL))), (_tmp19 = (g_free (_tmp19), NULL)), _tmp21);
				_tmp22 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp22 = vala_ccode_identifier_new ("self"))));
				(_tmp22 == NULL ? NULL : (_tmp22 = (g_object_unref (_tmp22), NULL)));
				cgetcall = vala_ccode_function_call_new (NULL);
				if (vala_data_type_get_data_type (vala_property_get_type_reference (prop)) != NULL) {
					ValaCCodeIdentifier* _tmp24;
					char* _tmp23;
					_tmp24 = NULL;
					_tmp23 = NULL;
					vala_ccode_function_call_set_call (cgetcall, VALA_CCODE_EXPRESSION ((_tmp24 = vala_ccode_identifier_new ((_tmp23 = vala_typesymbol_get_get_value_function (vala_data_type_get_data_type (vala_property_get_type_reference (prop))))))));
					(_tmp24 == NULL ? NULL : (_tmp24 = (g_object_unref (_tmp24), NULL)));
					(_tmp23 = (g_free (_tmp23), NULL));
				} else {
					ValaCCodeIdentifier* _tmp25;
					_tmp25 = NULL;
					vala_ccode_function_call_set_call (cgetcall, VALA_CCODE_EXPRESSION ((_tmp25 = vala_ccode_identifier_new ("g_value_get_pointer"))));
					(_tmp25 == NULL ? NULL : (_tmp25 = (g_object_unref (_tmp25), NULL)));
				}
				_tmp26 = NULL;
				vala_ccode_function_call_add_argument (cgetcall, VALA_CCODE_EXPRESSION ((_tmp26 = vala_ccode_identifier_new ("value"))));
				(_tmp26 == NULL ? NULL : (_tmp26 = (g_object_unref (_tmp26), NULL)));
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (cgetcall));
				_tmp27 = NULL;
				vala_ccode_case_statement_add_statement (ccase, VALA_CCODE_STATEMENT ((_tmp27 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
				(_tmp27 == NULL ? NULL : (_tmp27 = (g_object_unref (_tmp27), NULL)));
				_tmp28 = NULL;
				vala_ccode_case_statement_add_statement (ccase, VALA_CCODE_STATEMENT ((_tmp28 = vala_ccode_break_statement_new ())));
				(_tmp28 == NULL ? NULL : (_tmp28 = (g_object_unref (_tmp28), NULL)));
				vala_ccode_switch_statement_add_case (cswitch, ccase);
				(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
				(prefix = (g_free (prefix), NULL));
				(ccase == NULL ? NULL : (ccase = (g_object_unref (ccase), NULL)));
				(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
				(cgetcall == NULL ? NULL : (cgetcall = (g_object_unref (cgetcall), NULL)));
			}
		}
		(prop_it == NULL ? NULL : (prop_it = (g_object_unref (prop_it), NULL)));
	}
	_tmp29 = NULL;
	vala_ccode_switch_statement_add_default_statement (cswitch, (_tmp29 = vala_ccode_generator_get_invalid_property_id_warn_statement (self)));
	(_tmp29 == NULL ? NULL : (_tmp29 = (g_object_unref (_tmp29), NULL)));
	_tmp30 = NULL;
	vala_ccode_switch_statement_add_default_statement (cswitch, VALA_CCODE_STATEMENT ((_tmp30 = vala_ccode_break_statement_new ())));
	(_tmp30 == NULL ? NULL : (_tmp30 = (g_object_unref (_tmp30), NULL)));
	vala_ccode_block_add_statement (block, VALA_CCODE_NODE (cswitch));
	{
		GeeCollection* type_param_collection;
		GeeIterator* type_param_it;
		type_param_collection = vala_class_get_type_parameters (cl);
		type_param_it = gee_iterable_iterator (GEE_ITERABLE (type_param_collection));
		while (gee_iterator_next (type_param_it)) {
			ValaTypeParameter* type_param;
			type_param = gee_iterator_get (type_param_it);
			{
				char* func_name;
				char* enum_value;
				ValaCCodeCaseStatement* ccase;
				ValaCCodeMemberAccess* cfield;
				ValaCCodeFunctionCall* cgetcall;
				char* _tmp32;
				char* _tmp31;
				char* _tmp35;
				char* _tmp34;
				char* _tmp33;
				ValaCCodeCaseStatement* _tmp37;
				ValaCCodeIdentifier* _tmp36;
				ValaCCodeMemberAccess* _tmp40;
				ValaCCodeMemberAccess* _tmp39;
				ValaCCodeIdentifier* _tmp38;
				ValaCCodeFunctionCall* _tmp42;
				ValaCCodeIdentifier* _tmp41;
				ValaCCodeIdentifier* _tmp43;
				ValaCCodeExpressionStatement* _tmp45;
				ValaCCodeAssignment* _tmp44;
				ValaCCodeBreakStatement* _tmp46;
				char* _tmp48;
				char* _tmp47;
				char* _tmp51;
				char* _tmp50;
				char* _tmp49;
				ValaCCodeCaseStatement* _tmp53;
				ValaCCodeIdentifier* _tmp52;
				ValaCCodeMemberAccess* _tmp56;
				ValaCCodeMemberAccess* _tmp55;
				ValaCCodeIdentifier* _tmp54;
				ValaCCodeFunctionCall* _tmp58;
				ValaCCodeIdentifier* _tmp57;
				ValaCCodeIdentifier* _tmp59;
				ValaCCodeExpressionStatement* _tmp61;
				ValaCCodeAssignment* _tmp60;
				ValaCCodeBreakStatement* _tmp62;
				char* _tmp64;
				char* _tmp63;
				char* _tmp67;
				char* _tmp66;
				char* _tmp65;
				ValaCCodeCaseStatement* _tmp69;
				ValaCCodeIdentifier* _tmp68;
				ValaCCodeMemberAccess* _tmp72;
				ValaCCodeMemberAccess* _tmp71;
				ValaCCodeIdentifier* _tmp70;
				ValaCCodeFunctionCall* _tmp74;
				ValaCCodeIdentifier* _tmp73;
				ValaCCodeIdentifier* _tmp75;
				ValaCCodeExpressionStatement* _tmp77;
				ValaCCodeAssignment* _tmp76;
				ValaCCodeBreakStatement* _tmp78;
				/* type, dup func, and destroy func properties for generic types */
				func_name = NULL;
				enum_value = NULL;
				ccase = NULL;
				cfield = NULL;
				cgetcall = NULL;
				_tmp32 = NULL;
				_tmp31 = NULL;
				func_name = (_tmp32 = g_strdup_printf ("%s_type", (_tmp31 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1))), (func_name = (g_free (func_name), NULL)), _tmp32);
				(_tmp31 = (g_free (_tmp31), NULL));
				_tmp35 = NULL;
				_tmp34 = NULL;
				_tmp33 = NULL;
				enum_value = (_tmp35 = g_utf8_strup ((_tmp34 = g_strdup_printf ("%s_%s", (_tmp33 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)), func_name)), -1), (enum_value = (g_free (enum_value), NULL)), _tmp35);
				(_tmp34 = (g_free (_tmp34), NULL));
				(_tmp33 = (g_free (_tmp33), NULL));
				_tmp37 = NULL;
				_tmp36 = NULL;
				ccase = (_tmp37 = vala_ccode_case_statement_new (VALA_CCODE_EXPRESSION ((_tmp36 = vala_ccode_identifier_new (enum_value)))), (ccase == NULL ? NULL : (ccase = (g_object_unref (ccase), NULL))), _tmp37);
				(_tmp36 == NULL ? NULL : (_tmp36 = (g_object_unref (_tmp36), NULL)));
				_tmp40 = NULL;
				_tmp39 = NULL;
				_tmp38 = NULL;
				cfield = (_tmp40 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp39 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp38 = vala_ccode_identifier_new ("self"))), "priv"))), func_name), (cfield == NULL ? NULL : (cfield = (g_object_unref (cfield), NULL))), _tmp40);
				(_tmp39 == NULL ? NULL : (_tmp39 = (g_object_unref (_tmp39), NULL)));
				(_tmp38 == NULL ? NULL : (_tmp38 = (g_object_unref (_tmp38), NULL)));
				_tmp42 = NULL;
				_tmp41 = NULL;
				cgetcall = (_tmp42 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp41 = vala_ccode_identifier_new ("g_value_get_gtype")))), (cgetcall == NULL ? NULL : (cgetcall = (g_object_unref (cgetcall), NULL))), _tmp42);
				(_tmp41 == NULL ? NULL : (_tmp41 = (g_object_unref (_tmp41), NULL)));
				_tmp43 = NULL;
				vala_ccode_function_call_add_argument (cgetcall, VALA_CCODE_EXPRESSION ((_tmp43 = vala_ccode_identifier_new ("value"))));
				(_tmp43 == NULL ? NULL : (_tmp43 = (g_object_unref (_tmp43), NULL)));
				_tmp45 = NULL;
				_tmp44 = NULL;
				vala_ccode_case_statement_add_statement (ccase, VALA_CCODE_STATEMENT ((_tmp45 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp44 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (cfield), VALA_CCODE_EXPRESSION (cgetcall), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
				(_tmp45 == NULL ? NULL : (_tmp45 = (g_object_unref (_tmp45), NULL)));
				(_tmp44 == NULL ? NULL : (_tmp44 = (g_object_unref (_tmp44), NULL)));
				_tmp46 = NULL;
				vala_ccode_case_statement_add_statement (ccase, VALA_CCODE_STATEMENT ((_tmp46 = vala_ccode_break_statement_new ())));
				(_tmp46 == NULL ? NULL : (_tmp46 = (g_object_unref (_tmp46), NULL)));
				vala_ccode_switch_statement_add_case (cswitch, ccase);
				_tmp48 = NULL;
				_tmp47 = NULL;
				func_name = (_tmp48 = g_strdup_printf ("%s_dup_func", (_tmp47 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1))), (func_name = (g_free (func_name), NULL)), _tmp48);
				(_tmp47 = (g_free (_tmp47), NULL));
				_tmp51 = NULL;
				_tmp50 = NULL;
				_tmp49 = NULL;
				enum_value = (_tmp51 = g_utf8_strup ((_tmp50 = g_strdup_printf ("%s_%s", (_tmp49 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)), func_name)), -1), (enum_value = (g_free (enum_value), NULL)), _tmp51);
				(_tmp50 = (g_free (_tmp50), NULL));
				(_tmp49 = (g_free (_tmp49), NULL));
				_tmp53 = NULL;
				_tmp52 = NULL;
				ccase = (_tmp53 = vala_ccode_case_statement_new (VALA_CCODE_EXPRESSION ((_tmp52 = vala_ccode_identifier_new (enum_value)))), (ccase == NULL ? NULL : (ccase = (g_object_unref (ccase), NULL))), _tmp53);
				(_tmp52 == NULL ? NULL : (_tmp52 = (g_object_unref (_tmp52), NULL)));
				_tmp56 = NULL;
				_tmp55 = NULL;
				_tmp54 = NULL;
				cfield = (_tmp56 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp55 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp54 = vala_ccode_identifier_new ("self"))), "priv"))), func_name), (cfield == NULL ? NULL : (cfield = (g_object_unref (cfield), NULL))), _tmp56);
				(_tmp55 == NULL ? NULL : (_tmp55 = (g_object_unref (_tmp55), NULL)));
				(_tmp54 == NULL ? NULL : (_tmp54 = (g_object_unref (_tmp54), NULL)));
				_tmp58 = NULL;
				_tmp57 = NULL;
				cgetcall = (_tmp58 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp57 = vala_ccode_identifier_new ("g_value_get_pointer")))), (cgetcall == NULL ? NULL : (cgetcall = (g_object_unref (cgetcall), NULL))), _tmp58);
				(_tmp57 == NULL ? NULL : (_tmp57 = (g_object_unref (_tmp57), NULL)));
				_tmp59 = NULL;
				vala_ccode_function_call_add_argument (cgetcall, VALA_CCODE_EXPRESSION ((_tmp59 = vala_ccode_identifier_new ("value"))));
				(_tmp59 == NULL ? NULL : (_tmp59 = (g_object_unref (_tmp59), NULL)));
				_tmp61 = NULL;
				_tmp60 = NULL;
				vala_ccode_case_statement_add_statement (ccase, VALA_CCODE_STATEMENT ((_tmp61 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp60 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (cfield), VALA_CCODE_EXPRESSION (cgetcall), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
				(_tmp61 == NULL ? NULL : (_tmp61 = (g_object_unref (_tmp61), NULL)));
				(_tmp60 == NULL ? NULL : (_tmp60 = (g_object_unref (_tmp60), NULL)));
				_tmp62 = NULL;
				vala_ccode_case_statement_add_statement (ccase, VALA_CCODE_STATEMENT ((_tmp62 = vala_ccode_break_statement_new ())));
				(_tmp62 == NULL ? NULL : (_tmp62 = (g_object_unref (_tmp62), NULL)));
				vala_ccode_switch_statement_add_case (cswitch, ccase);
				_tmp64 = NULL;
				_tmp63 = NULL;
				func_name = (_tmp64 = g_strdup_printf ("%s_destroy_func", (_tmp63 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1))), (func_name = (g_free (func_name), NULL)), _tmp64);
				(_tmp63 = (g_free (_tmp63), NULL));
				_tmp67 = NULL;
				_tmp66 = NULL;
				_tmp65 = NULL;
				enum_value = (_tmp67 = g_utf8_strup ((_tmp66 = g_strdup_printf ("%s_%s", (_tmp65 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)), func_name)), -1), (enum_value = (g_free (enum_value), NULL)), _tmp67);
				(_tmp66 = (g_free (_tmp66), NULL));
				(_tmp65 = (g_free (_tmp65), NULL));
				_tmp69 = NULL;
				_tmp68 = NULL;
				ccase = (_tmp69 = vala_ccode_case_statement_new (VALA_CCODE_EXPRESSION ((_tmp68 = vala_ccode_identifier_new (enum_value)))), (ccase == NULL ? NULL : (ccase = (g_object_unref (ccase), NULL))), _tmp69);
				(_tmp68 == NULL ? NULL : (_tmp68 = (g_object_unref (_tmp68), NULL)));
				_tmp72 = NULL;
				_tmp71 = NULL;
				_tmp70 = NULL;
				cfield = (_tmp72 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp71 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp70 = vala_ccode_identifier_new ("self"))), "priv"))), func_name), (cfield == NULL ? NULL : (cfield = (g_object_unref (cfield), NULL))), _tmp72);
				(_tmp71 == NULL ? NULL : (_tmp71 = (g_object_unref (_tmp71), NULL)));
				(_tmp70 == NULL ? NULL : (_tmp70 = (g_object_unref (_tmp70), NULL)));
				_tmp74 = NULL;
				_tmp73 = NULL;
				cgetcall = (_tmp74 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp73 = vala_ccode_identifier_new ("g_value_get_pointer")))), (cgetcall == NULL ? NULL : (cgetcall = (g_object_unref (cgetcall), NULL))), _tmp74);
				(_tmp73 == NULL ? NULL : (_tmp73 = (g_object_unref (_tmp73), NULL)));
				_tmp75 = NULL;
				vala_ccode_function_call_add_argument (cgetcall, VALA_CCODE_EXPRESSION ((_tmp75 = vala_ccode_identifier_new ("value"))));
				(_tmp75 == NULL ? NULL : (_tmp75 = (g_object_unref (_tmp75), NULL)));
				_tmp77 = NULL;
				_tmp76 = NULL;
				vala_ccode_case_statement_add_statement (ccase, VALA_CCODE_STATEMENT ((_tmp77 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp76 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (cfield), VALA_CCODE_EXPRESSION (cgetcall), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
				(_tmp77 == NULL ? NULL : (_tmp77 = (g_object_unref (_tmp77), NULL)));
				(_tmp76 == NULL ? NULL : (_tmp76 = (g_object_unref (_tmp76), NULL)));
				_tmp78 = NULL;
				vala_ccode_case_statement_add_statement (ccase, VALA_CCODE_STATEMENT ((_tmp78 = vala_ccode_break_statement_new ())));
				(_tmp78 == NULL ? NULL : (_tmp78 = (g_object_unref (_tmp78), NULL)));
				vala_ccode_switch_statement_add_case (cswitch, ccase);
				(type_param == NULL ? NULL : (type_param = (g_object_unref (type_param), NULL)));
				(func_name = (g_free (func_name), NULL));
				(enum_value = (g_free (enum_value), NULL));
				(ccase == NULL ? NULL : (ccase = (g_object_unref (ccase), NULL)));
				(cfield == NULL ? NULL : (cfield = (g_object_unref (cfield), NULL)));
				(cgetcall == NULL ? NULL : (cgetcall = (g_object_unref (cgetcall), NULL)));
			}
		}
		(type_param_collection == NULL ? NULL : (type_param_collection = (g_object_unref (type_param_collection), NULL)));
		(type_param_it == NULL ? NULL : (type_param_it = (g_object_unref (type_param_it), NULL)));
	}
	vala_ccode_function_set_block (set_prop, block);
	vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (set_prop));
	(set_prop == NULL ? NULL : (set_prop = (g_object_unref (set_prop), NULL)));
	(block == NULL ? NULL : (block = (g_object_unref (block), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
	(cswitch == NULL ? NULL : (cswitch = (g_object_unref (cswitch), NULL)));
	(props == NULL ? NULL : (props = (g_object_unref (props), NULL)));
}


static ValaCCodeStatement* vala_ccode_generator_get_invalid_property_id_warn_statement (ValaCCodeGenerator* self) {
	ValaCCodeIdentifier* _tmp0;
	ValaCCodeFunctionCall* _tmp1;
	ValaCCodeFunctionCall* cwarn;
	ValaCCodeIdentifier* _tmp2;
	ValaCCodeIdentifier* _tmp3;
	ValaCCodeIdentifier* _tmp4;
	ValaCCodeExpressionStatement* _tmp5;
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	/* warn on invalid property id*/
	_tmp0 = NULL;
	_tmp1 = NULL;
	cwarn = (_tmp1 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp0 = vala_ccode_identifier_new ("G_OBJECT_WARN_INVALID_PROPERTY_ID")))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1);
	_tmp2 = NULL;
	vala_ccode_function_call_add_argument (cwarn, VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_identifier_new ("object"))));
	(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
	_tmp3 = NULL;
	vala_ccode_function_call_add_argument (cwarn, VALA_CCODE_EXPRESSION ((_tmp3 = vala_ccode_identifier_new ("property_id"))));
	(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
	_tmp4 = NULL;
	vala_ccode_function_call_add_argument (cwarn, VALA_CCODE_EXPRESSION ((_tmp4 = vala_ccode_identifier_new ("pspec"))));
	(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
	_tmp5 = NULL;
	return VALA_CCODE_STATEMENT ((_tmp5 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cwarn)), (cwarn == NULL ? NULL : (cwarn = (g_object_unref (cwarn), NULL))), _tmp5));
}


static void vala_ccode_generator_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface) {
	ValaCCodeGenerator * self;
	ValaSymbol* _tmp1;
	ValaInterface* _tmp0;
	ValaTypesymbol* _tmp3;
	ValaInterface* _tmp2;
	char* _tmp4;
	gboolean _tmp5;
	ValaCCodeFragment* decl_frag;
	ValaCCodeFragment* def_frag;
	ValaTypesymbol* _tmp55;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (iface == NULL || VALA_IS_INTERFACE (iface));
	_tmp1 = NULL;
	_tmp0 = NULL;
	self->priv->current_symbol = (_tmp1 = VALA_SYMBOL ((_tmp0 = iface, (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)))), (self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL))), _tmp1);
	_tmp3 = NULL;
	_tmp2 = NULL;
	self->current_type_symbol = (_tmp3 = VALA_TYPESYMBOL ((_tmp2 = iface, (_tmp2 == NULL ? NULL : g_object_ref (_tmp2)))), (self->current_type_symbol == NULL ? NULL : (self->current_type_symbol = (g_object_unref (self->current_type_symbol), NULL))), _tmp3);
	_tmp4 = NULL;
	if ((_tmp5 = g_utf8_strlen ((_tmp4 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (iface), FALSE)), -1) < 3, (_tmp4 = (g_free (_tmp4), NULL)), _tmp5)) {
		char* _tmp7;
		char* _tmp6;
		vala_code_node_set_error (VALA_CODE_NODE (iface), TRUE);
		_tmp7 = NULL;
		_tmp6 = NULL;
		vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (iface)), (_tmp7 = g_strdup_printf ("Interface name `%s' is too short", (_tmp6 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (iface), FALSE)))));
		(_tmp7 = (g_free (_tmp7), NULL));
		(_tmp6 = (g_free (_tmp6), NULL));
		return;
	}
	decl_frag = NULL;
	def_frag = NULL;
	if (vala_symbol_get_access (VALA_SYMBOL (iface)) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		ValaCCodeFragment* _tmp9;
		ValaCCodeFragment* _tmp8;
		ValaCCodeFragment* _tmp11;
		ValaCCodeFragment* _tmp10;
		_tmp9 = NULL;
		_tmp8 = NULL;
		decl_frag = (_tmp9 = (_tmp8 = self->priv->header_type_declaration, (_tmp8 == NULL ? NULL : g_object_ref (_tmp8))), (decl_frag == NULL ? NULL : (decl_frag = (g_object_unref (decl_frag), NULL))), _tmp9);
		_tmp11 = NULL;
		_tmp10 = NULL;
		def_frag = (_tmp11 = (_tmp10 = self->priv->header_type_definition, (_tmp10 == NULL ? NULL : g_object_ref (_tmp10))), (def_frag == NULL ? NULL : (def_frag = (g_object_unref (def_frag), NULL))), _tmp11);
	} else {
		ValaCCodeFragment* _tmp13;
		ValaCCodeFragment* _tmp12;
		ValaCCodeFragment* _tmp15;
		ValaCCodeFragment* _tmp14;
		_tmp13 = NULL;
		_tmp12 = NULL;
		decl_frag = (_tmp13 = (_tmp12 = self->priv->source_type_member_declaration, (_tmp12 == NULL ? NULL : g_object_ref (_tmp12))), (decl_frag == NULL ? NULL : (decl_frag = (g_object_unref (decl_frag), NULL))), _tmp13);
		_tmp15 = NULL;
		_tmp14 = NULL;
		def_frag = (_tmp15 = (_tmp14 = self->priv->source_type_member_declaration, (_tmp14 == NULL ? NULL : g_object_ref (_tmp14))), (def_frag == NULL ? NULL : (def_frag = (g_object_unref (def_frag), NULL))), _tmp15);
	}
	if (!vala_interface_get_is_static (iface) && !vala_interface_get_declaration_only (iface)) {
		ValaCCodeStruct* _tmp18;
		char* _tmp17;
		char* _tmp16;
		ValaCCodeNewline* _tmp19;
		char* _tmp20;
		char* _tmp21;
		char* macro;
		ValaCCodeMacroReplacement* _tmp23;
		char* _tmp22;
		char* _tmp26;
		char* _tmp25;
		char* _tmp24;
		ValaCCodeMacroReplacement* _tmp29;
		char* _tmp28;
		char* _tmp27;
		char* _tmp31;
		char* _tmp30;
		ValaCCodeMacroReplacement* _tmp34;
		char* _tmp33;
		char* _tmp32;
		char* _tmp37;
		char* _tmp36;
		char* _tmp35;
		ValaCCodeMacroReplacement* _tmp40;
		char* _tmp39;
		char* _tmp38;
		ValaCCodeNewline* _tmp41;
		_tmp18 = NULL;
		_tmp17 = NULL;
		_tmp16 = NULL;
		self->priv->type_struct = (_tmp18 = vala_ccode_struct_new ((_tmp17 = g_strdup_printf ("_%s", (_tmp16 = vala_interface_get_type_cname (iface))))), (self->priv->type_struct == NULL ? NULL : (self->priv->type_struct = (g_object_unref (self->priv->type_struct), NULL))), _tmp18);
		(_tmp17 = (g_free (_tmp17), NULL));
		(_tmp16 = (g_free (_tmp16), NULL));
		_tmp19 = NULL;
		vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((_tmp19 = vala_ccode_newline_new ())));
		(_tmp19 == NULL ? NULL : (_tmp19 = (g_object_unref (_tmp19), NULL)));
		_tmp20 = NULL;
		_tmp21 = NULL;
		macro = (_tmp21 = g_strdup_printf ("(%s_get_type ())", (_tmp20 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (iface), NULL))), (_tmp20 = (g_free (_tmp20), NULL)), _tmp21);
		_tmp23 = NULL;
		_tmp22 = NULL;
		vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((_tmp23 = vala_ccode_macro_replacement_new ((_tmp22 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (iface), "TYPE_")), macro))));
		(_tmp23 == NULL ? NULL : (_tmp23 = (g_object_unref (_tmp23), NULL)));
		(_tmp22 = (g_free (_tmp22), NULL));
		_tmp26 = NULL;
		_tmp25 = NULL;
		_tmp24 = NULL;
		macro = (_tmp26 = g_strdup_printf ("(G_TYPE_CHECK_INSTANCE_CAST ((obj), %s, %s))", (_tmp24 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (iface), "TYPE_")), (_tmp25 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (iface), FALSE))), (macro = (g_free (macro), NULL)), _tmp26);
		(_tmp25 = (g_free (_tmp25), NULL));
		(_tmp24 = (g_free (_tmp24), NULL));
		_tmp29 = NULL;
		_tmp28 = NULL;
		_tmp27 = NULL;
		vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((_tmp29 = vala_ccode_macro_replacement_new ((_tmp28 = g_strdup_printf ("%s(obj)", (_tmp27 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (iface), NULL)))), macro))));
		(_tmp29 == NULL ? NULL : (_tmp29 = (g_object_unref (_tmp29), NULL)));
		(_tmp28 = (g_free (_tmp28), NULL));
		(_tmp27 = (g_free (_tmp27), NULL));
		_tmp31 = NULL;
		_tmp30 = NULL;
		macro = (_tmp31 = g_strdup_printf ("(G_TYPE_CHECK_INSTANCE_TYPE ((obj), %s))", (_tmp30 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (iface), "TYPE_"))), (macro = (g_free (macro), NULL)), _tmp31);
		(_tmp30 = (g_free (_tmp30), NULL));
		_tmp34 = NULL;
		_tmp33 = NULL;
		_tmp32 = NULL;
		vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((_tmp34 = vala_ccode_macro_replacement_new ((_tmp33 = g_strdup_printf ("%s(obj)", (_tmp32 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (iface), "IS_")))), macro))));
		(_tmp34 == NULL ? NULL : (_tmp34 = (g_object_unref (_tmp34), NULL)));
		(_tmp33 = (g_free (_tmp33), NULL));
		(_tmp32 = (g_free (_tmp32), NULL));
		_tmp37 = NULL;
		_tmp36 = NULL;
		_tmp35 = NULL;
		macro = (_tmp37 = g_strdup_printf ("(G_TYPE_INSTANCE_GET_INTERFACE ((obj), %s, %s))", (_tmp35 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (iface), "TYPE_")), (_tmp36 = vala_interface_get_type_cname (iface))), (macro = (g_free (macro), NULL)), _tmp37);
		(_tmp36 = (g_free (_tmp36), NULL));
		(_tmp35 = (g_free (_tmp35), NULL));
		_tmp40 = NULL;
		_tmp39 = NULL;
		_tmp38 = NULL;
		vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((_tmp40 = vala_ccode_macro_replacement_new ((_tmp39 = g_strdup_printf ("%s_GET_INTERFACE(obj)", (_tmp38 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (iface), NULL)))), macro))));
		(_tmp40 == NULL ? NULL : (_tmp40 = (g_object_unref (_tmp40), NULL)));
		(_tmp39 = (g_free (_tmp39), NULL));
		(_tmp38 = (g_free (_tmp38), NULL));
		_tmp41 = NULL;
		vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((_tmp41 = vala_ccode_newline_new ())));
		(_tmp41 == NULL ? NULL : (_tmp41 = (g_object_unref (_tmp41), NULL)));
		if (vala_source_file_get_cycle (vala_source_reference_get_file (vala_code_node_get_source_reference (VALA_CODE_NODE (iface)))) == NULL) {
			ValaCCodeTypeDefinition* _tmp46;
			ValaCCodeVariableDeclarator* _tmp45;
			char* _tmp44;
			char* _tmp43;
			char* _tmp42;
			ValaCCodeTypeDefinition* _tmp50;
			ValaCCodeVariableDeclarator* _tmp49;
			char* _tmp48;
			char* _tmp47;
			_tmp46 = NULL;
			_tmp45 = NULL;
			_tmp44 = NULL;
			_tmp43 = NULL;
			_tmp42 = NULL;
			vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((_tmp46 = vala_ccode_type_definition_new ((_tmp43 = g_strdup_printf ("struct _%s", (_tmp42 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (iface), FALSE)))), VALA_CCODE_DECLARATOR ((_tmp45 = vala_ccode_variable_declarator_new ((_tmp44 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (iface), FALSE)))))))));
			(_tmp46 == NULL ? NULL : (_tmp46 = (g_object_unref (_tmp46), NULL)));
			(_tmp45 == NULL ? NULL : (_tmp45 = (g_object_unref (_tmp45), NULL)));
			(_tmp44 = (g_free (_tmp44), NULL));
			(_tmp43 = (g_free (_tmp43), NULL));
			(_tmp42 = (g_free (_tmp42), NULL));
			_tmp50 = NULL;
			_tmp49 = NULL;
			_tmp48 = NULL;
			_tmp47 = NULL;
			vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((_tmp50 = vala_ccode_type_definition_new ((_tmp47 = g_strdup_printf ("struct %s", vala_ccode_struct_get_name (self->priv->type_struct))), VALA_CCODE_DECLARATOR ((_tmp49 = vala_ccode_variable_declarator_new ((_tmp48 = vala_interface_get_type_cname (iface)))))))));
			(_tmp50 == NULL ? NULL : (_tmp50 = (g_object_unref (_tmp50), NULL)));
			(_tmp49 == NULL ? NULL : (_tmp49 = (g_object_unref (_tmp49), NULL)));
			(_tmp48 = (g_free (_tmp48), NULL));
			(_tmp47 = (g_free (_tmp47), NULL));
		}
		vala_ccode_struct_add_field (self->priv->type_struct, "GTypeInterface", "parent_iface");
		if (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (iface))) != NULL) {
			ValaCCodeComment* _tmp51;
			_tmp51 = NULL;
			vala_ccode_fragment_append (def_frag, VALA_CCODE_NODE ((_tmp51 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (iface)))))));
			(_tmp51 == NULL ? NULL : (_tmp51 = (g_object_unref (_tmp51), NULL)));
		}
		vala_ccode_fragment_append (def_frag, VALA_CCODE_NODE (self->priv->type_struct));
		(macro = (g_free (macro), NULL));
	}
	vala_code_node_accept_children (VALA_CODE_NODE (iface), VALA_CODE_VISITOR (self));
	if (!vala_interface_get_is_static (iface) && !vala_interface_get_declaration_only (iface)) {
		ValaInterfaceRegisterFunction* type_fun;
		ValaCCodeFragment* _tmp54;
		vala_ccode_generator_add_interface_base_init_function (self, iface);
		type_fun = vala_interface_register_function_new (iface);
		vala_typeregister_function_init_from_type (VALA_TYPEREGISTER_FUNCTION (type_fun), FALSE);
		if (vala_symbol_get_access (VALA_SYMBOL (iface)) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaCCodeFragment* _tmp52;
			_tmp52 = NULL;
			vala_ccode_fragment_append (self->priv->header_type_member_declaration, VALA_CCODE_NODE ((_tmp52 = vala_typeregister_function_get_declaration (VALA_TYPEREGISTER_FUNCTION (type_fun)))));
			(_tmp52 == NULL ? NULL : (_tmp52 = (g_object_unref (_tmp52), NULL)));
		} else {
			ValaCCodeFragment* _tmp53;
			_tmp53 = NULL;
			vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE ((_tmp53 = vala_typeregister_function_get_declaration (VALA_TYPEREGISTER_FUNCTION (type_fun)))));
			(_tmp53 == NULL ? NULL : (_tmp53 = (g_object_unref (_tmp53), NULL)));
		}
		_tmp54 = NULL;
		vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE ((_tmp54 = vala_typeregister_function_get_definition (VALA_TYPEREGISTER_FUNCTION (type_fun)))));
		(_tmp54 == NULL ? NULL : (_tmp54 = (g_object_unref (_tmp54), NULL)));
		(type_fun == NULL ? NULL : (type_fun = (g_object_unref (type_fun), NULL)));
	}
	_tmp55 = NULL;
	self->current_type_symbol = (_tmp55 = NULL, (self->current_type_symbol == NULL ? NULL : (self->current_type_symbol = (g_object_unref (self->current_type_symbol), NULL))), _tmp55);
	(decl_frag == NULL ? NULL : (decl_frag = (g_object_unref (decl_frag), NULL)));
	(def_frag == NULL ? NULL : (def_frag = (g_object_unref (def_frag), NULL)));
}


static ValaCCodeFunctionCall* vala_ccode_generator_get_param_spec (ValaCCodeGenerator* self, ValaProperty* prop) {
	ValaCCodeFunctionCall* cspec;
	ValaCCodeConstant* _tmp0;
	ValaCCodeConstant* _tmp1;
	ValaCCodeConstant* _tmp2;
	char* pflags;
	ValaCCodeConstant* _tmp39;
	ValaCCodeFunctionCall* _tmp40;
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	g_return_val_if_fail (prop == NULL || VALA_IS_PROPERTY (prop), NULL);
	cspec = vala_ccode_function_call_new (NULL);
	_tmp0 = NULL;
	vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp0 = vala_property_get_canonical_cconstant (prop))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	_tmp1 = NULL;
	vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp1 = vala_property_get_canonical_cconstant (prop))));
	(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
	_tmp2 = NULL;
	vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp2 = vala_property_get_canonical_cconstant (prop))));
	(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
	if ((VALA_IS_CLASS (vala_data_type_get_data_type (vala_property_get_type_reference (prop))) && vala_typesymbol_is_subtype_of (VALA_TYPESYMBOL ((VALA_CLASS (vala_data_type_get_data_type (vala_property_get_type_reference (prop))))), self->gobject_type)) || VALA_IS_INTERFACE (vala_data_type_get_data_type (vala_property_get_type_reference (prop)))) {
		ValaCCodeIdentifier* _tmp3;
		ValaCCodeIdentifier* _tmp5;
		char* _tmp4;
		_tmp3 = NULL;
		vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp3 = vala_ccode_identifier_new ("g_param_spec_object"))));
		(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
		_tmp5 = NULL;
		_tmp4 = NULL;
		vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_identifier_new ((_tmp4 = vala_typesymbol_get_upper_case_cname (vala_data_type_get_data_type (vala_property_get_type_reference (prop)), "TYPE_"))))));
		(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
		(_tmp4 = (g_free (_tmp4), NULL));
	} else {
		if (vala_data_type_get_data_type (vala_property_get_type_reference (prop)) == vala_data_type_get_data_type (self->string_type)) {
			ValaCCodeIdentifier* _tmp6;
			ValaCCodeConstant* _tmp7;
			_tmp6 = NULL;
			vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp6 = vala_ccode_identifier_new ("g_param_spec_string"))));
			(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
			_tmp7 = NULL;
			vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp7 = vala_ccode_constant_new ("NULL"))));
			(_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL)));
		} else {
			if (vala_data_type_get_data_type (vala_property_get_type_reference (prop)) == vala_data_type_get_data_type (self->int_type) || VALA_IS_ENUM (vala_data_type_get_data_type (vala_property_get_type_reference (prop)))) {
				ValaCCodeIdentifier* _tmp8;
				ValaCCodeConstant* _tmp9;
				ValaCCodeConstant* _tmp10;
				ValaCCodeConstant* _tmp11;
				_tmp8 = NULL;
				vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp8 = vala_ccode_identifier_new ("g_param_spec_int"))));
				(_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL)));
				_tmp9 = NULL;
				vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp9 = vala_ccode_constant_new ("G_MININT"))));
				(_tmp9 == NULL ? NULL : (_tmp9 = (g_object_unref (_tmp9), NULL)));
				_tmp10 = NULL;
				vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp10 = vala_ccode_constant_new ("G_MAXINT"))));
				(_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL)));
				_tmp11 = NULL;
				vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp11 = vala_ccode_constant_new ("0"))));
				(_tmp11 == NULL ? NULL : (_tmp11 = (g_object_unref (_tmp11), NULL)));
			} else {
				if (vala_data_type_get_data_type (vala_property_get_type_reference (prop)) == vala_data_type_get_data_type (self->uint_type)) {
					ValaCCodeIdentifier* _tmp12;
					ValaCCodeConstant* _tmp13;
					ValaCCodeConstant* _tmp14;
					ValaCCodeConstant* _tmp15;
					_tmp12 = NULL;
					vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp12 = vala_ccode_identifier_new ("g_param_spec_uint"))));
					(_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL)));
					_tmp13 = NULL;
					vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp13 = vala_ccode_constant_new ("0"))));
					(_tmp13 == NULL ? NULL : (_tmp13 = (g_object_unref (_tmp13), NULL)));
					_tmp14 = NULL;
					vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp14 = vala_ccode_constant_new ("G_MAXUINT"))));
					(_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL)));
					_tmp15 = NULL;
					vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp15 = vala_ccode_constant_new ("0U"))));
					(_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL)));
				} else {
					if (vala_data_type_get_data_type (vala_property_get_type_reference (prop)) == vala_data_type_get_data_type (self->long_type)) {
						ValaCCodeIdentifier* _tmp16;
						ValaCCodeConstant* _tmp17;
						ValaCCodeConstant* _tmp18;
						ValaCCodeConstant* _tmp19;
						_tmp16 = NULL;
						vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp16 = vala_ccode_identifier_new ("g_param_spec_long"))));
						(_tmp16 == NULL ? NULL : (_tmp16 = (g_object_unref (_tmp16), NULL)));
						_tmp17 = NULL;
						vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp17 = vala_ccode_constant_new ("G_MINLONG"))));
						(_tmp17 == NULL ? NULL : (_tmp17 = (g_object_unref (_tmp17), NULL)));
						_tmp18 = NULL;
						vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp18 = vala_ccode_constant_new ("G_MAXLONG"))));
						(_tmp18 == NULL ? NULL : (_tmp18 = (g_object_unref (_tmp18), NULL)));
						_tmp19 = NULL;
						vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp19 = vala_ccode_constant_new ("0L"))));
						(_tmp19 == NULL ? NULL : (_tmp19 = (g_object_unref (_tmp19), NULL)));
					} else {
						if (vala_data_type_get_data_type (vala_property_get_type_reference (prop)) == vala_data_type_get_data_type (self->ulong_type)) {
							ValaCCodeIdentifier* _tmp20;
							ValaCCodeConstant* _tmp21;
							ValaCCodeConstant* _tmp22;
							ValaCCodeConstant* _tmp23;
							_tmp20 = NULL;
							vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp20 = vala_ccode_identifier_new ("g_param_spec_ulong"))));
							(_tmp20 == NULL ? NULL : (_tmp20 = (g_object_unref (_tmp20), NULL)));
							_tmp21 = NULL;
							vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp21 = vala_ccode_constant_new ("0"))));
							(_tmp21 == NULL ? NULL : (_tmp21 = (g_object_unref (_tmp21), NULL)));
							_tmp22 = NULL;
							vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp22 = vala_ccode_constant_new ("G_MAXULONG"))));
							(_tmp22 == NULL ? NULL : (_tmp22 = (g_object_unref (_tmp22), NULL)));
							_tmp23 = NULL;
							vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp23 = vala_ccode_constant_new ("0UL"))));
							(_tmp23 == NULL ? NULL : (_tmp23 = (g_object_unref (_tmp23), NULL)));
						} else {
							if (vala_data_type_get_data_type (vala_property_get_type_reference (prop)) == vala_data_type_get_data_type (self->bool_type)) {
								ValaCCodeIdentifier* _tmp24;
								ValaCCodeConstant* _tmp25;
								_tmp24 = NULL;
								vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp24 = vala_ccode_identifier_new ("g_param_spec_boolean"))));
								(_tmp24 == NULL ? NULL : (_tmp24 = (g_object_unref (_tmp24), NULL)));
								_tmp25 = NULL;
								vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp25 = vala_ccode_constant_new ("FALSE"))));
								(_tmp25 == NULL ? NULL : (_tmp25 = (g_object_unref (_tmp25), NULL)));
							} else {
								if (vala_data_type_get_data_type (vala_property_get_type_reference (prop)) == vala_data_type_get_data_type (self->float_type)) {
									ValaCCodeIdentifier* _tmp26;
									ValaCCodeConstant* _tmp27;
									ValaCCodeConstant* _tmp28;
									ValaCCodeConstant* _tmp29;
									_tmp26 = NULL;
									vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp26 = vala_ccode_identifier_new ("g_param_spec_float"))));
									(_tmp26 == NULL ? NULL : (_tmp26 = (g_object_unref (_tmp26), NULL)));
									_tmp27 = NULL;
									vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp27 = vala_ccode_constant_new ("-G_MAXFLOAT"))));
									(_tmp27 == NULL ? NULL : (_tmp27 = (g_object_unref (_tmp27), NULL)));
									_tmp28 = NULL;
									vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp28 = vala_ccode_constant_new ("G_MAXFLOAT"))));
									(_tmp28 == NULL ? NULL : (_tmp28 = (g_object_unref (_tmp28), NULL)));
									_tmp29 = NULL;
									vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp29 = vala_ccode_constant_new ("0.0F"))));
									(_tmp29 == NULL ? NULL : (_tmp29 = (g_object_unref (_tmp29), NULL)));
								} else {
									if (vala_data_type_get_data_type (vala_property_get_type_reference (prop)) == vala_data_type_get_data_type (self->double_type)) {
										ValaCCodeIdentifier* _tmp30;
										ValaCCodeConstant* _tmp31;
										ValaCCodeConstant* _tmp32;
										ValaCCodeConstant* _tmp33;
										_tmp30 = NULL;
										vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp30 = vala_ccode_identifier_new ("g_param_spec_double"))));
										(_tmp30 == NULL ? NULL : (_tmp30 = (g_object_unref (_tmp30), NULL)));
										_tmp31 = NULL;
										vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp31 = vala_ccode_constant_new ("-G_MAXDOUBLE"))));
										(_tmp31 == NULL ? NULL : (_tmp31 = (g_object_unref (_tmp31), NULL)));
										_tmp32 = NULL;
										vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp32 = vala_ccode_constant_new ("G_MAXDOUBLE"))));
										(_tmp32 == NULL ? NULL : (_tmp32 = (g_object_unref (_tmp32), NULL)));
										_tmp33 = NULL;
										vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp33 = vala_ccode_constant_new ("0.0"))));
										(_tmp33 == NULL ? NULL : (_tmp33 = (g_object_unref (_tmp33), NULL)));
									} else {
										ValaCCodeIdentifier* _tmp34;
										_tmp34 = NULL;
										vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp34 = vala_ccode_identifier_new ("g_param_spec_pointer"))));
										(_tmp34 == NULL ? NULL : (_tmp34 = (g_object_unref (_tmp34), NULL)));
									}
								}
							}
						}
					}
				}
			}
		}
	}
	pflags = g_strdup ("G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB");
	if (vala_property_get_get_accessor (prop) != NULL) {
		char* _tmp35;
		_tmp35 = NULL;
		pflags = (_tmp35 = g_strdup_printf ("%s%s", pflags, " | G_PARAM_READABLE"), (pflags = (g_free (pflags), NULL)), _tmp35);
	}
	if (vala_property_get_set_accessor (prop) != NULL) {
		char* _tmp36;
		_tmp36 = NULL;
		pflags = (_tmp36 = g_strdup_printf ("%s%s", pflags, " | G_PARAM_WRITABLE"), (pflags = (g_free (pflags), NULL)), _tmp36);
		if (vala_property_accessor_get_construction (vala_property_get_set_accessor (prop))) {
			if (vala_property_accessor_get_writable (vala_property_get_set_accessor (prop))) {
				char* _tmp37;
				_tmp37 = NULL;
				pflags = (_tmp37 = g_strdup_printf ("%s%s", pflags, " | G_PARAM_CONSTRUCT"), (pflags = (g_free (pflags), NULL)), _tmp37);
			} else {
				char* _tmp38;
				_tmp38 = NULL;
				pflags = (_tmp38 = g_strdup_printf ("%s%s", pflags, " | G_PARAM_CONSTRUCT_ONLY"), (pflags = (g_free (pflags), NULL)), _tmp38);
			}
		}
	}
	_tmp39 = NULL;
	vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp39 = vala_ccode_constant_new (pflags))));
	(_tmp39 == NULL ? NULL : (_tmp39 = (g_object_unref (_tmp39), NULL)));
	_tmp40 = NULL;
	return (_tmp40 = cspec, (pflags = (g_free (pflags), NULL)), _tmp40);
}


static ValaCCodeFunctionCall* vala_ccode_generator_get_signal_creation (ValaCCodeGenerator* self, ValaSignal* sig, ValaTypesymbol* type) {
	ValaCCodeIdentifier* _tmp0;
	ValaCCodeFunctionCall* _tmp1;
	ValaCCodeFunctionCall* csignew;
	ValaCCodeConstant* _tmp3;
	char* _tmp2;
	ValaCCodeIdentifier* _tmp5;
	char* _tmp4;
	ValaCCodeConstant* _tmp6;
	ValaCCodeConstant* _tmp7;
	ValaCCodeConstant* _tmp8;
	ValaCCodeConstant* _tmp9;
	char* marshaller;
	ValaCCodeIdentifier* marshal_arg;
	GeeCollection* params;
	gint params_len;
	ValaCCodeConstant* _tmp15;
	char* _tmp14;
	ValaCCodeFunctionCall* _tmp19;
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	g_return_val_if_fail (sig == NULL || VALA_IS_SIGNAL (sig), NULL);
	g_return_val_if_fail (type == NULL || VALA_IS_TYPESYMBOL (type), NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	csignew = (_tmp1 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp0 = vala_ccode_identifier_new ("g_signal_new")))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1);
	_tmp3 = NULL;
	_tmp2 = NULL;
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((_tmp3 = vala_ccode_constant_new ((_tmp2 = g_strdup_printf ("\"%s\"", vala_symbol_get_name (VALA_SYMBOL (sig))))))));
	(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
	(_tmp2 = (g_free (_tmp2), NULL));
	_tmp5 = NULL;
	_tmp4 = NULL;
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_identifier_new ((_tmp4 = vala_typesymbol_get_upper_case_cname (type, "TYPE_"))))));
	(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
	(_tmp4 = (g_free (_tmp4), NULL));
	_tmp6 = NULL;
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((_tmp6 = vala_ccode_constant_new ("G_SIGNAL_RUN_LAST"))));
	(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
	_tmp7 = NULL;
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((_tmp7 = vala_ccode_constant_new ("0"))));
	(_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL)));
	_tmp8 = NULL;
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((_tmp8 = vala_ccode_constant_new ("NULL"))));
	(_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL)));
	_tmp9 = NULL;
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((_tmp9 = vala_ccode_constant_new ("NULL"))));
	(_tmp9 == NULL ? NULL : (_tmp9 = (g_object_unref (_tmp9), NULL)));
	marshaller = vala_ccode_generator_get_signal_marshaller_function (self, sig, NULL);
	marshal_arg = vala_ccode_identifier_new (marshaller);
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION (marshal_arg));
	params = vala_signal_get_parameters (sig);
	params_len = gee_collection_get_size (params);
	if (VALA_IS_POINTER_TYPE (vala_signal_get_return_type (sig)) || vala_data_type_get_type_parameter (vala_signal_get_return_type (sig)) != NULL) {
		ValaCCodeConstant* _tmp10;
		_tmp10 = NULL;
		vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((_tmp10 = vala_ccode_constant_new ("G_TYPE_POINTER"))));
		(_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL)));
	} else {
		if (vala_data_type_get_data_type (vala_signal_get_return_type (sig)) == NULL) {
			ValaCCodeConstant* _tmp11;
			_tmp11 = NULL;
			vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((_tmp11 = vala_ccode_constant_new ("G_TYPE_NONE"))));
			(_tmp11 == NULL ? NULL : (_tmp11 = (g_object_unref (_tmp11), NULL)));
		} else {
			ValaCCodeConstant* _tmp13;
			char* _tmp12;
			_tmp13 = NULL;
			_tmp12 = NULL;
			vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((_tmp13 = vala_ccode_constant_new ((_tmp12 = vala_typesymbol_get_type_id (vala_data_type_get_data_type (vala_signal_get_return_type (sig))))))));
			(_tmp13 == NULL ? NULL : (_tmp13 = (g_object_unref (_tmp13), NULL)));
			(_tmp12 = (g_free (_tmp12), NULL));
		}
	}
	_tmp15 = NULL;
	_tmp14 = NULL;
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((_tmp15 = vala_ccode_constant_new ((_tmp14 = g_strdup_printf ("%d", params_len))))));
	(_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL)));
	(_tmp14 = (g_free (_tmp14), NULL));
	{
		GeeCollection* param_collection;
		GeeIterator* param_it;
		param_collection = params;
		param_it = gee_iterable_iterator (GEE_ITERABLE (param_collection));
		while (gee_iterator_next (param_it)) {
			ValaFormalParameter* param;
			param = gee_iterator_get (param_it);
			{
				if (VALA_IS_POINTER_TYPE (vala_formal_parameter_get_type_reference (param)) || vala_data_type_get_type_parameter (vala_formal_parameter_get_type_reference (param)) != NULL || vala_data_type_get_is_ref (vala_formal_parameter_get_type_reference (param)) || vala_data_type_get_is_out (vala_formal_parameter_get_type_reference (param))) {
					ValaCCodeConstant* _tmp16;
					_tmp16 = NULL;
					vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((_tmp16 = vala_ccode_constant_new ("G_TYPE_POINTER"))));
					(_tmp16 == NULL ? NULL : (_tmp16 = (g_object_unref (_tmp16), NULL)));
				} else {
					ValaCCodeConstant* _tmp18;
					char* _tmp17;
					_tmp18 = NULL;
					_tmp17 = NULL;
					vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((_tmp18 = vala_ccode_constant_new ((_tmp17 = vala_typesymbol_get_type_id (vala_data_type_get_data_type (vala_formal_parameter_get_type_reference (param))))))));
					(_tmp18 == NULL ? NULL : (_tmp18 = (g_object_unref (_tmp18), NULL)));
					(_tmp17 = (g_free (_tmp17), NULL));
				}
				(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
			}
		}
		(param_it == NULL ? NULL : (param_it = (g_object_unref (param_it), NULL)));
	}
	vala_ccode_identifier_set_name (marshal_arg, marshaller);
	_tmp19 = NULL;
	return (_tmp19 = csignew, (marshaller = (g_free (marshaller), NULL)), (marshal_arg == NULL ? NULL : (marshal_arg = (g_object_unref (marshal_arg), NULL))), (params == NULL ? NULL : (params = (g_object_unref (params), NULL))), _tmp19);
}


static void vala_ccode_generator_add_interface_base_init_function (ValaCCodeGenerator* self, ValaInterface* iface) {
	char* _tmp1;
	char* _tmp0;
	ValaCCodeFunction* _tmp2;
	ValaCCodeFunction* base_init;
	ValaCCodeFormalParameter* _tmp5;
	char* _tmp4;
	char* _tmp3;
	ValaCCodeBlock* init_block;
	ValaCCodeBlock* _tmp6;
	char* _tmp7;
	ValaCCodeDeclaration* _tmp8;
	ValaCCodeDeclaration* decl;
	ValaCCodeVariableDeclarator* _tmp10;
	ValaCCodeConstant* _tmp9;
	ValaCCodeUnaryExpression* _tmp12;
	ValaCCodeIdentifier* _tmp11;
	ValaCCodeIfStatement* _tmp13;
	ValaCCodeIfStatement* cif;
	ValaCCodeExpressionStatement* _tmp17;
	ValaCCodeAssignment* _tmp16;
	ValaCCodeConstant* _tmp15;
	ValaCCodeIdentifier* _tmp14;
	GeeCollection* props;
	g_return_if_fail (VALA_IS_CCODE_GENERATOR (self));
	g_return_if_fail (iface == NULL || VALA_IS_INTERFACE (iface));
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp2 = NULL;
	base_init = (_tmp2 = vala_ccode_function_new ((_tmp1 = g_strdup_printf ("%s_base_init", (_tmp0 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (iface), NULL)))), "void"), (_tmp1 = (g_free (_tmp1), NULL)), (_tmp0 = (g_free (_tmp0), NULL)), _tmp2);
	_tmp5 = NULL;
	_tmp4 = NULL;
	_tmp3 = NULL;
	vala_ccode_function_add_parameter (base_init, (_tmp5 = vala_ccode_formal_parameter_new ("iface", (_tmp4 = g_strdup_printf ("%sIface *", (_tmp3 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (iface), FALSE)))))));
	(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
	(_tmp4 = (g_free (_tmp4), NULL));
	(_tmp3 = (g_free (_tmp3), NULL));
	vala_ccode_function_set_modifiers (base_init, VALA_CCODE_MODIFIERS_STATIC);
	init_block = vala_ccode_block_new ();
	/* make sure not to run the initialization code twice */
	_tmp6 = NULL;
	vala_ccode_function_set_block (base_init, (_tmp6 = vala_ccode_block_new ()));
	(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
	_tmp7 = NULL;
	_tmp8 = NULL;
	decl = (_tmp8 = vala_ccode_declaration_new ((_tmp7 = vala_data_type_get_cname (self->bool_type, FALSE, FALSE))), (_tmp7 = (g_free (_tmp7), NULL)), _tmp8);
	vala_ccode_declaration_set_modifiers (decl, vala_ccode_declaration_get_modifiers (decl) | (VALA_CCODE_MODIFIERS_STATIC));
	_tmp10 = NULL;
	_tmp9 = NULL;
	vala_ccode_declaration_add_declarator (decl, VALA_CCODE_DECLARATOR ((_tmp10 = vala_ccode_variable_declarator_new_with_initializer ("initialized", VALA_CCODE_EXPRESSION ((_tmp9 = vala_ccode_constant_new ("FALSE")))))));
	(_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL)));
	(_tmp9 == NULL ? NULL : (_tmp9 = (g_object_unref (_tmp9), NULL)));
	vala_ccode_block_add_statement (vala_ccode_function_get_block (base_init), VALA_CCODE_NODE (decl));
	_tmp12 = NULL;
	_tmp11 = NULL;
	_tmp13 = NULL;
	cif = (_tmp13 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION ((_tmp12 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_LOGICAL_NEGATION, VALA_CCODE_EXPRESSION ((_tmp11 = vala_ccode_identifier_new ("initialized")))))), VALA_CCODE_STATEMENT (init_block), NULL), (_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL))), (_tmp11 == NULL ? NULL : (_tmp11 = (g_object_unref (_tmp11), NULL))), _tmp13);
	vala_ccode_block_add_statement (vala_ccode_function_get_block (base_init), VALA_CCODE_NODE (cif));
	_tmp17 = NULL;
	_tmp16 = NULL;
	_tmp15 = NULL;
	_tmp14 = NULL;
	vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp17 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp16 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp14 = vala_ccode_identifier_new ("initialized"))), VALA_CCODE_EXPRESSION ((_tmp15 = vala_ccode_constant_new ("TRUE"))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
	(_tmp17 == NULL ? NULL : (_tmp17 = (g_object_unref (_tmp17), NULL)));
	(_tmp16 == NULL ? NULL : (_tmp16 = (g_object_unref (_tmp16), NULL)));
	(_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL)));
	(_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL)));
	/* create properties */
	props = vala_interface_get_properties (iface);
	{
		GeeCollection* prop_collection;
		GeeIterator* prop_it;
		prop_collection = props;
		prop_it = gee_iterable_iterator (GEE_ITERABLE (prop_collection));
		while (gee_iterator_next (prop_it)) {
			ValaProperty* prop;
			prop = gee_iterator_get (prop_it);
			{
				ValaCCodeIdentifier* _tmp18;
				ValaCCodeFunctionCall* _tmp19;
				ValaCCodeFunctionCall* cinst;
				ValaCCodeIdentifier* _tmp20;
				ValaCCodeFunctionCall* _tmp21;
				ValaCCodeExpressionStatement* _tmp22;
				_tmp18 = NULL;
				_tmp19 = NULL;
				cinst = (_tmp19 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp18 = vala_ccode_identifier_new ("g_object_interface_install_property")))), (_tmp18 == NULL ? NULL : (_tmp18 = (g_object_unref (_tmp18), NULL))), _tmp19);
				_tmp20 = NULL;
				vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION ((_tmp20 = vala_ccode_identifier_new ("iface"))));
				(_tmp20 == NULL ? NULL : (_tmp20 = (g_object_unref (_tmp20), NULL)));
				_tmp21 = NULL;
				vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION ((_tmp21 = vala_ccode_generator_get_param_spec (self, prop))));
				(_tmp21 == NULL ? NULL : (_tmp21 = (g_object_unref (_tmp21), NULL)));
				_tmp22 = NULL;
				vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp22 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cinst)))));
				(_tmp22 == NULL ? NULL : (_tmp22 = (g_object_unref (_tmp22), NULL)));
				(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
				(cinst == NULL ? NULL : (cinst = (g_object_unref (cinst), NULL)));
			}
		}
		(prop_it == NULL ? NULL : (prop_it = (g_object_unref (prop_it), NULL)));
	}
	{
		GeeCollection* sig_collection;
		GeeIterator* sig_it;
		sig_collection = vala_interface_get_signals (iface);
		sig_it = gee_iterable_iterator (GEE_ITERABLE (sig_collection));
		while (gee_iterator_next (sig_it)) {
			ValaSignal* sig;
			sig = gee_iterator_get (sig_it);
			{
				ValaCCodeExpressionStatement* _tmp24;
				ValaCCodeFunctionCall* _tmp23;
				/* create signals */
				_tmp24 = NULL;
				_tmp23 = NULL;
				vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp24 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp23 = vala_ccode_generator_get_signal_creation (self, sig, VALA_TYPESYMBOL (iface))))))));
				(_tmp24 == NULL ? NULL : (_tmp24 = (g_object_unref (_tmp24), NULL)));
				(_tmp23 == NULL ? NULL : (_tmp23 = (g_object_unref (_tmp23), NULL)));
				(sig == NULL ? NULL : (sig = (g_object_unref (sig), NULL)));
			}
		}
		(sig_collection == NULL ? NULL : (sig_collection = (g_object_unref (sig_collection), NULL)));
		(sig_it == NULL ? NULL : (sig_it = (g_object_unref (sig_it), NULL)));
	}
	vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (base_init));
	(base_init == NULL ? NULL : (base_init = (g_object_unref (base_init), NULL)));
	(init_block == NULL ? NULL : (init_block = (g_object_unref (init_block), NULL)));
	(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
	(cif == NULL ? NULL : (cif = (g_object_unref (cif), NULL)));
	(props == NULL ? NULL : (props = (g_object_unref (props), NULL)));
}


static void vala_ccode_generator_real_visit_invocation_expression (ValaCodeVisitor* base, ValaInvocationExpression* expr) {
	ValaCCodeGenerator * self;
	ValaCCodeFunctionCall* ccall;
	ValaMethod* m;
	GeeCollection* params;
	ValaMemberAccess* _tmp0;
	ValaMemberAccess* ma;
	ValaDataType* _tmp1;
	ValaDataType* itype;
	GeeCollection* _tmp2;
	ValaCCodeFunctionCall* _tmp7;
	ValaCCodeExpression* ccall_expr;
	ValaCCodeExpression* instance;
	gboolean ellipsis;
	gint i;
	GeeIterator* params_it;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (expr == NULL || VALA_IS_INVOCATION_EXPRESSION (expr));
	vala_code_node_accept_children (VALA_CODE_NODE (expr), VALA_CODE_VISITOR (self));
	/* the bare function call*/
	ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_invocation_expression_get_call (expr)))));
	m = NULL;
	params = NULL;
	if (!(VALA_IS_MEMBER_ACCESS (vala_invocation_expression_get_call (expr)))) {
		vala_code_node_set_error (VALA_CODE_NODE (expr), TRUE);
		vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (expr)), "unsupported method invocation");
		(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
		(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
		(params == NULL ? NULL : (params = (g_object_unref (params), NULL)));
		return;
	}
	_tmp0 = NULL;
	ma = (_tmp0 = VALA_MEMBER_ACCESS (vala_invocation_expression_get_call (expr)), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	_tmp1 = NULL;
	itype = (_tmp1 = vala_expression_get_static_type (vala_invocation_expression_get_call (expr)), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
	_tmp2 = NULL;
	params = (_tmp2 = vala_data_type_get_parameters (itype), (params == NULL ? NULL : (params = (g_object_unref (params), NULL))), _tmp2);
	if (VALA_IS_METHOD_TYPE (itype)) {
		ValaMethod* _tmp4;
		ValaMethod* _tmp3;
		_tmp4 = NULL;
		_tmp3 = NULL;
		m = (_tmp4 = (_tmp3 = vala_method_type_get_method_symbol ((VALA_METHOD_TYPE (itype))), (_tmp3 == NULL ? NULL : g_object_ref (_tmp3))), (m == NULL ? NULL : (m = (g_object_unref (m), NULL))), _tmp4);
	} else {
		if (VALA_IS_SIGNAL_TYPE (itype)) {
			ValaCCodeFunctionCall* _tmp6;
			ValaCCodeFunctionCall* _tmp5;
			_tmp6 = NULL;
			_tmp5 = NULL;
			ccall = (_tmp6 = (_tmp5 = VALA_CCODE_FUNCTION_CALL (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_invocation_expression_get_call (expr)))), (_tmp5 == NULL ? NULL : g_object_ref (_tmp5))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), _tmp6);
		}
	}
	/* the complete call expression, might include casts, comma expressions, and/or assignments*/
	_tmp7 = NULL;
	ccall_expr = VALA_CCODE_EXPRESSION ((_tmp7 = ccall, (_tmp7 == NULL ? NULL : g_object_ref (_tmp7))));
	if (VALA_IS_ARRAY_RESIZE_METHOD (m)) {
		ValaArray* _tmp8;
		ValaArray* array;
		ValaCCodeIdentifier* _tmp10;
		char* _tmp9;
		_tmp8 = NULL;
		array = (_tmp8 = VALA_ARRAY (vala_symbol_get_parent_symbol (VALA_SYMBOL (m))), (_tmp8 == NULL ? NULL : g_object_ref (_tmp8)));
		_tmp10 = NULL;
		_tmp9 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp10 = vala_ccode_identifier_new ((_tmp9 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (array), FALSE))))));
		(_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL)));
		(_tmp9 = (g_free (_tmp9), NULL));
		(array == NULL ? NULL : (array = (g_object_unref (array), NULL)));
	} else {
		if (VALA_IS_ARRAY_MOVE_METHOD (m)) {
			self->priv->requires_array_move = TRUE;
		}
	}
	instance = NULL;
	if (m != NULL && vala_method_get_instance (m)) {
		ValaMethod* _tmp11;
		ValaMethod* base_method;
		ValaDataType* instance_expression_type;
		_tmp11 = NULL;
		base_method = (_tmp11 = m, (_tmp11 == NULL ? NULL : g_object_ref (_tmp11)));
		if (vala_method_get_base_interface_method (m) != NULL) {
			ValaMethod* _tmp13;
			ValaMethod* _tmp12;
			_tmp13 = NULL;
			_tmp12 = NULL;
			base_method = (_tmp13 = (_tmp12 = vala_method_get_base_interface_method (m), (_tmp12 == NULL ? NULL : g_object_ref (_tmp12))), (base_method == NULL ? NULL : (base_method = (g_object_unref (base_method), NULL))), _tmp13);
		} else {
			if (vala_method_get_base_method (m) != NULL) {
				ValaMethod* _tmp15;
				ValaMethod* _tmp14;
				_tmp15 = NULL;
				_tmp14 = NULL;
				base_method = (_tmp15 = (_tmp14 = vala_method_get_base_method (m), (_tmp14 == NULL ? NULL : g_object_ref (_tmp14))), (base_method == NULL ? NULL : (base_method = (g_object_unref (base_method), NULL))), _tmp15);
			}
		}
		instance_expression_type = NULL;
		if (vala_member_access_get_inner (ma) == NULL) {
			ValaCCodeExpression* _tmp16;
			ValaDataType* _tmp17;
			_tmp16 = NULL;
			instance = (_tmp16 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("self")), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), _tmp16);
			_tmp17 = NULL;
			instance_expression_type = (_tmp17 = vala_data_type_new (), (instance_expression_type == NULL ? NULL : (instance_expression_type = (g_object_unref (instance_expression_type), NULL))), _tmp17);
			vala_data_type_set_data_type (instance_expression_type, self->current_type_symbol);
		} else {
			ValaCCodeExpression* _tmp19;
			ValaCCodeExpression* _tmp18;
			ValaDataType* _tmp21;
			ValaDataType* _tmp20;
			_tmp19 = NULL;
			_tmp18 = NULL;
			instance = (_tmp19 = (_tmp18 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_member_access_get_inner (ma)))), (_tmp18 == NULL ? NULL : g_object_ref (_tmp18))), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), _tmp19);
			_tmp21 = NULL;
			_tmp20 = NULL;
			instance_expression_type = (_tmp21 = (_tmp20 = vala_expression_get_static_type (vala_member_access_get_inner (ma)), (_tmp20 == NULL ? NULL : g_object_ref (_tmp20))), (instance_expression_type == NULL ? NULL : (instance_expression_type = (g_object_unref (instance_expression_type), NULL))), _tmp21);
		}
		if (VALA_IS_STRUCT (vala_symbol_get_parent_symbol (VALA_SYMBOL (m))) && !vala_struct_is_simple_type ((VALA_STRUCT (vala_symbol_get_parent_symbol (VALA_SYMBOL (m))))) && (vala_member_access_get_inner (ma) != NULL || vala_symbol_get_parent_symbol (VALA_SYMBOL (m)) != VALA_SYMBOL (self->current_type_symbol))) {
			ValaCCodeExpression* _tmp22;
			_tmp22 = NULL;
			instance = (_tmp22 = VALA_CCODE_EXPRESSION (vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, instance)), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), _tmp22);
		}
		/* parent_symbol may be null for late bound methods*/
		if (vala_symbol_get_parent_symbol (VALA_SYMBOL (base_method)) != NULL) {
			ValaDataType* instance_target_type;
			ValaCCodeExpression* _tmp23;
			instance_target_type = vala_data_type_new ();
			vala_data_type_set_data_type (instance_target_type, VALA_TYPESYMBOL (vala_symbol_get_parent_symbol (VALA_SYMBOL (base_method))));
			_tmp23 = NULL;
			instance = (_tmp23 = vala_ccode_generator_get_implicit_cast_expression (self, instance, instance_expression_type, instance_target_type), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), _tmp23);
			(instance_target_type == NULL ? NULL : (instance_target_type = (g_object_unref (instance_target_type), NULL)));
		}
		if (!vala_method_get_instance_last (m)) {
			vala_ccode_function_call_add_argument (ccall, instance);
		}
		(base_method == NULL ? NULL : (base_method = (g_object_unref (base_method), NULL)));
		(instance_expression_type == NULL ? NULL : (instance_expression_type = (g_object_unref (instance_expression_type), NULL)));
	}
	if (VALA_IS_ARRAY_MOVE_METHOD (m)) {
		ValaArray* _tmp24;
		ValaArray* array;
		ValaCCodeIdentifier* _tmp25;
		ValaCCodeFunctionCall* _tmp26;
		ValaCCodeFunctionCall* csizeof;
		ValaCCodeIdentifier* _tmp28;
		char* _tmp27;
		_tmp24 = NULL;
		array = (_tmp24 = VALA_ARRAY (vala_symbol_get_parent_symbol (VALA_SYMBOL (m))), (_tmp24 == NULL ? NULL : g_object_ref (_tmp24)));
		_tmp25 = NULL;
		_tmp26 = NULL;
		csizeof = (_tmp26 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp25 = vala_ccode_identifier_new ("sizeof")))), (_tmp25 == NULL ? NULL : (_tmp25 = (g_object_unref (_tmp25), NULL))), _tmp26);
		_tmp28 = NULL;
		_tmp27 = NULL;
		vala_ccode_function_call_add_argument (csizeof, VALA_CCODE_EXPRESSION ((_tmp28 = vala_ccode_identifier_new ((_tmp27 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (array), FALSE))))));
		(_tmp28 == NULL ? NULL : (_tmp28 = (g_object_unref (_tmp28), NULL)));
		(_tmp27 = (g_free (_tmp27), NULL));
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (csizeof));
		(array == NULL ? NULL : (array = (g_object_unref (array), NULL)));
		(csizeof == NULL ? NULL : (csizeof = (g_object_unref (csizeof), NULL)));
	} else {
		if (VALA_IS_DBUS_METHOD (m)) {
			gboolean found_out;
			ValaExpression* callback;
			ValaCCodeConstant* _tmp32;
			char* _tmp31;
			found_out = FALSE;
			callback = NULL;
			{
				GeeCollection* arg_collection;
				GeeIterator* arg_it;
				arg_collection = vala_invocation_expression_get_argument_list (expr);
				arg_it = gee_iterable_iterator (GEE_ITERABLE (arg_collection));
				while (gee_iterator_next (arg_it)) {
					ValaExpression* arg;
					arg = gee_iterator_get (arg_it);
					{
						if (VALA_IS_METHOD (vala_expression_get_symbol_reference (arg))) {
							ValaExpression* _tmp30;
							ValaExpression* _tmp29;
							/* callback*/
							if (callback != NULL) {
								vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (expr)), "only one reply callback may be specified in invocation of DBus method");
								vala_code_node_set_error (VALA_CODE_NODE (expr), TRUE);
								(arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL)));
								(arg_collection == NULL ? NULL : (arg_collection = (g_object_unref (arg_collection), NULL)));
								(arg_it == NULL ? NULL : (arg_it = (g_object_unref (arg_it), NULL)));
								(callback == NULL ? NULL : (callback = (g_object_unref (callback), NULL)));
								(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
								(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
								(params == NULL ? NULL : (params = (g_object_unref (params), NULL)));
								(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
								(itype == NULL ? NULL : (itype = (g_object_unref (itype), NULL)));
								(ccall_expr == NULL ? NULL : (ccall_expr = (g_object_unref (ccall_expr), NULL)));
								(instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL)));
								return;
							} else {
								if (found_out) {
									vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (expr)), "out argument and reply callback conflict in invocation of DBus method");
									vala_code_node_set_error (VALA_CODE_NODE (expr), TRUE);
									(arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL)));
									(arg_collection == NULL ? NULL : (arg_collection = (g_object_unref (arg_collection), NULL)));
									(arg_it == NULL ? NULL : (arg_it = (g_object_unref (arg_it), NULL)));
									(callback == NULL ? NULL : (callback = (g_object_unref (callback), NULL)));
									(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
									(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
									(params == NULL ? NULL : (params = (g_object_unref (params), NULL)));
									(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
									(itype == NULL ? NULL : (itype = (g_object_unref (itype), NULL)));
									(ccall_expr == NULL ? NULL : (ccall_expr = (g_object_unref (ccall_expr), NULL)));
									(instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL)));
									return;
								}
							}
							_tmp30 = NULL;
							_tmp29 = NULL;
							callback = (_tmp30 = (_tmp29 = arg, (_tmp29 == NULL ? NULL : g_object_ref (_tmp29))), (callback == NULL ? NULL : (callback = (g_object_unref (callback), NULL))), _tmp30);
						} else {
							if (VALA_IS_UNARY_EXPRESSION (arg) && vala_unary_expression_get_operator ((VALA_UNARY_EXPRESSION (arg))) == VALA_UNARY_OPERATOR_OUT) {
								/* out arg*/
								if (callback != NULL) {
									vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (expr)), "out argument and reply callback conflict in invocation of DBus method");
									vala_code_node_set_error (VALA_CODE_NODE (expr), TRUE);
									(arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL)));
									(arg_collection == NULL ? NULL : (arg_collection = (g_object_unref (arg_collection), NULL)));
									(arg_it == NULL ? NULL : (arg_it = (g_object_unref (arg_it), NULL)));
									(callback == NULL ? NULL : (callback = (g_object_unref (callback), NULL)));
									(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
									(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
									(params == NULL ? NULL : (params = (g_object_unref (params), NULL)));
									(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
									(itype == NULL ? NULL : (itype = (g_object_unref (itype), NULL)));
									(ccall_expr == NULL ? NULL : (ccall_expr = (g_object_unref (ccall_expr), NULL)));
									(instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL)));
									return;
								}
								found_out = TRUE;
							} else {
								/* in arg*/
								if (callback != NULL || found_out) {
									vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (expr)), "in argument must not follow out argument or reply callback in invocation of DBus method");
									vala_code_node_set_error (VALA_CODE_NODE (expr), TRUE);
									(arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL)));
									(arg_collection == NULL ? NULL : (arg_collection = (g_object_unref (arg_collection), NULL)));
									(arg_it == NULL ? NULL : (arg_it = (g_object_unref (arg_it), NULL)));
									(callback == NULL ? NULL : (callback = (g_object_unref (callback), NULL)));
									(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
									(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
									(params == NULL ? NULL : (params = (g_object_unref (params), NULL)));
									(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
									(itype == NULL ? NULL : (itype = (g_object_unref (itype), NULL)));
									(ccall_expr == NULL ? NULL : (ccall_expr = (g_object_unref (ccall_expr), NULL)));
									(instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL)));
									return;
								}
							}
						}
						(arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL)));
					}
				}
				(arg_collection == NULL ? NULL : (arg_collection = (g_object_unref (arg_collection), NULL)));
				(arg_it == NULL ? NULL : (arg_it = (g_object_unref (arg_it), NULL)));
			}
			_tmp32 = NULL;
			_tmp31 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp32 = vala_ccode_constant_new ((_tmp31 = g_strdup_printf ("\"%s\"", vala_symbol_get_name (VALA_SYMBOL (m))))))));
			(_tmp32 == NULL ? NULL : (_tmp32 = (g_object_unref (_tmp32), NULL)));
			(_tmp31 = (g_free (_tmp31), NULL));
			if (callback != NULL) {
				ValaMethod* _tmp33;
				ValaMethod* reply_method;
				char* _tmp35;
				char* _tmp34;
				ValaCCodeFunction* _tmp36;
				ValaCCodeFunction* cb_fun;
				ValaCCodeFormalParameter* _tmp37;
				ValaCCodeFormalParameter* _tmp38;
				ValaCCodeFormalParameter* _tmp39;
				ValaCCodeBlock* _tmp40;
				ValaCCodeDeclaration* cerrdecl;
				ValaCCodeVariableDeclarator* _tmp42;
				ValaCCodeConstant* _tmp41;
				ValaCCodeIdentifier* _tmp43;
				ValaCCodeFunctionCall* _tmp44;
				ValaCCodeFunctionCall* cend_call;
				ValaCCodeIdentifier* _tmp45;
				ValaCCodeIdentifier* _tmp46;
				ValaCCodeUnaryExpression* _tmp48;
				ValaCCodeIdentifier* _tmp47;
				ValaCCodeFunctionCall* creply_call;
				ValaCCodeIdentifier* _tmp49;
				GeeCollection* _tmp50;
				gint _tmp51;
				gint param_count;
				gint i;
				ValaCCodeIdentifier* _tmp72;
				ValaCCodeExpressionStatement* _tmp73;
				ValaCCodeIdentifier* _tmp74;
				ValaCCodeExpressionStatement* _tmp75;
				ValaCCodeIdentifier* _tmp76;
				ValaCCodeConstant* _tmp77;
				ValaCCodeConstant* _tmp78;
				_tmp33 = NULL;
				reply_method = (_tmp33 = VALA_METHOD (vala_expression_get_symbol_reference (callback)), (_tmp33 == NULL ? NULL : g_object_ref (_tmp33)));
				_tmp35 = NULL;
				_tmp34 = NULL;
				_tmp36 = NULL;
				cb_fun = (_tmp36 = vala_ccode_function_new ((_tmp35 = g_strdup_printf ("_%s_cb", (_tmp34 = vala_method_get_cname (reply_method)))), "void"), (_tmp35 = (g_free (_tmp35), NULL)), (_tmp34 = (g_free (_tmp34), NULL)), _tmp36);
				vala_ccode_function_set_modifiers (cb_fun, VALA_CCODE_MODIFIERS_STATIC);
				_tmp37 = NULL;
				vala_ccode_function_add_parameter (cb_fun, (_tmp37 = vala_ccode_formal_parameter_new ("proxy", "DBusGProxy*")));
				(_tmp37 == NULL ? NULL : (_tmp37 = (g_object_unref (_tmp37), NULL)));
				_tmp38 = NULL;
				vala_ccode_function_add_parameter (cb_fun, (_tmp38 = vala_ccode_formal_parameter_new ("call", "DBusGProxyCall*")));
				(_tmp38 == NULL ? NULL : (_tmp38 = (g_object_unref (_tmp38), NULL)));
				_tmp39 = NULL;
				vala_ccode_function_add_parameter (cb_fun, (_tmp39 = vala_ccode_formal_parameter_new ("user_data", "void*")));
				(_tmp39 == NULL ? NULL : (_tmp39 = (g_object_unref (_tmp39), NULL)));
				_tmp40 = NULL;
				vala_ccode_function_set_block (cb_fun, (_tmp40 = vala_ccode_block_new ()));
				(_tmp40 == NULL ? NULL : (_tmp40 = (g_object_unref (_tmp40), NULL)));
				cerrdecl = vala_ccode_declaration_new ("GError*");
				_tmp42 = NULL;
				_tmp41 = NULL;
				vala_ccode_declaration_add_declarator (cerrdecl, VALA_CCODE_DECLARATOR ((_tmp42 = vala_ccode_variable_declarator_new_with_initializer ("error", VALA_CCODE_EXPRESSION ((_tmp41 = vala_ccode_constant_new ("NULL")))))));
				(_tmp42 == NULL ? NULL : (_tmp42 = (g_object_unref (_tmp42), NULL)));
				(_tmp41 == NULL ? NULL : (_tmp41 = (g_object_unref (_tmp41), NULL)));
				vala_ccode_block_add_statement (vala_ccode_function_get_block (cb_fun), VALA_CCODE_NODE (cerrdecl));
				_tmp43 = NULL;
				_tmp44 = NULL;
				cend_call = (_tmp44 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp43 = vala_ccode_identifier_new ("dbus_g_proxy_end_call")))), (_tmp43 == NULL ? NULL : (_tmp43 = (g_object_unref (_tmp43), NULL))), _tmp44);
				_tmp45 = NULL;
				vala_ccode_function_call_add_argument (cend_call, VALA_CCODE_EXPRESSION ((_tmp45 = vala_ccode_identifier_new ("proxy"))));
				(_tmp45 == NULL ? NULL : (_tmp45 = (g_object_unref (_tmp45), NULL)));
				_tmp46 = NULL;
				vala_ccode_function_call_add_argument (cend_call, VALA_CCODE_EXPRESSION ((_tmp46 = vala_ccode_identifier_new ("call"))));
				(_tmp46 == NULL ? NULL : (_tmp46 = (g_object_unref (_tmp46), NULL)));
				_tmp48 = NULL;
				_tmp47 = NULL;
				vala_ccode_function_call_add_argument (cend_call, VALA_CCODE_EXPRESSION ((_tmp48 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp47 = vala_ccode_identifier_new ("error")))))));
				(_tmp48 == NULL ? NULL : (_tmp48 = (g_object_unref (_tmp48), NULL)));
				(_tmp47 == NULL ? NULL : (_tmp47 = (g_object_unref (_tmp47), NULL)));
				creply_call = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (callback))));
				_tmp49 = NULL;
				vala_ccode_function_call_add_argument (creply_call, VALA_CCODE_EXPRESSION ((_tmp49 = vala_ccode_identifier_new ("user_data"))));
				(_tmp49 == NULL ? NULL : (_tmp49 = (g_object_unref (_tmp49), NULL)));
				_tmp50 = NULL;
				param_count = (_tmp51 = gee_collection_get_size ((_tmp50 = vala_method_get_parameters (reply_method))), (_tmp50 == NULL ? NULL : (_tmp50 = (g_object_unref (_tmp50), NULL))), _tmp51);
				i = 0;
				{
					GeeCollection* param_collection;
					GeeIterator* param_it;
					param_collection = vala_method_get_parameters (reply_method);
					param_it = gee_iterable_iterator (GEE_ITERABLE (param_collection));
					while (gee_iterator_next (param_it)) {
						ValaFormalParameter* param;
						param = gee_iterator_get (param_it);
						{
							if (((i = i + 1)) == param_count) {
								(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
								break;
							}
							/* error parameter*/
							if (VALA_IS_ARRAY (vala_data_type_get_data_type (vala_formal_parameter_get_type_reference (param))) && vala_array_get_element_type ((VALA_ARRAY (vala_data_type_get_data_type (vala_formal_parameter_get_type_reference (param))))) != vala_data_type_get_data_type (self->string_type)) {
								ValaArray* _tmp52;
								ValaArray* array;
								ValaCCodeDeclaration* cdecl_;
								ValaCCodeVariableDeclarator* _tmp53;
								ValaCCodeExpression* _tmp54;
								ValaCCodeUnaryExpression* _tmp56;
								ValaCCodeIdentifier* _tmp55;
								ValaCCodeMemberAccess* _tmp58;
								ValaCCodeIdentifier* _tmp57;
								ValaCCodeMemberAccess* _tmp60;
								ValaCCodeIdentifier* _tmp59;
								_tmp52 = NULL;
								array = (_tmp52 = VALA_ARRAY (vala_data_type_get_data_type (vala_formal_parameter_get_type_reference (param))), (_tmp52 == NULL ? NULL : g_object_ref (_tmp52)));
								cdecl_ = vala_ccode_declaration_new ("GArray*");
								_tmp53 = NULL;
								vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp53 = vala_ccode_variable_declarator_new (vala_symbol_get_name (VALA_SYMBOL (param))))));
								(_tmp53 == NULL ? NULL : (_tmp53 = (g_object_unref (_tmp53), NULL)));
								vala_ccode_block_add_statement (vala_ccode_function_get_block (cb_fun), VALA_CCODE_NODE (cdecl_));
								_tmp54 = NULL;
								vala_ccode_function_call_add_argument (cend_call, (_tmp54 = vala_ccode_generator_get_dbus_array_type (self, array)));
								(_tmp54 == NULL ? NULL : (_tmp54 = (g_object_unref (_tmp54), NULL)));
								_tmp56 = NULL;
								_tmp55 = NULL;
								vala_ccode_function_call_add_argument (cend_call, VALA_CCODE_EXPRESSION ((_tmp56 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp55 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (param)))))))));
								(_tmp56 == NULL ? NULL : (_tmp56 = (g_object_unref (_tmp56), NULL)));
								(_tmp55 == NULL ? NULL : (_tmp55 = (g_object_unref (_tmp55), NULL)));
								_tmp58 = NULL;
								_tmp57 = NULL;
								vala_ccode_function_call_add_argument (creply_call, VALA_CCODE_EXPRESSION ((_tmp58 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp57 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (param))))), "len"))));
								(_tmp58 == NULL ? NULL : (_tmp58 = (g_object_unref (_tmp58), NULL)));
								(_tmp57 == NULL ? NULL : (_tmp57 = (g_object_unref (_tmp57), NULL)));
								_tmp60 = NULL;
								_tmp59 = NULL;
								vala_ccode_function_call_add_argument (creply_call, VALA_CCODE_EXPRESSION ((_tmp60 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp59 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (param))))), "data"))));
								(_tmp60 == NULL ? NULL : (_tmp60 = (g_object_unref (_tmp60), NULL)));
								(_tmp59 == NULL ? NULL : (_tmp59 = (g_object_unref (_tmp59), NULL)));
								(array == NULL ? NULL : (array = (g_object_unref (array), NULL)));
								(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
							} else {
								char* _tmp61;
								ValaCCodeDeclaration* _tmp62;
								ValaCCodeDeclaration* cdecl_;
								ValaCCodeVariableDeclarator* _tmp63;
								ValaCCodeIdentifier* _tmp65;
								char* _tmp64;
								ValaCCodeUnaryExpression* _tmp67;
								ValaCCodeIdentifier* _tmp66;
								ValaCCodeIdentifier* _tmp71;
								_tmp61 = NULL;
								_tmp62 = NULL;
								cdecl_ = (_tmp62 = vala_ccode_declaration_new ((_tmp61 = vala_data_type_get_cname (vala_formal_parameter_get_type_reference (param), FALSE, FALSE))), (_tmp61 = (g_free (_tmp61), NULL)), _tmp62);
								_tmp63 = NULL;
								vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp63 = vala_ccode_variable_declarator_new (vala_symbol_get_name (VALA_SYMBOL (param))))));
								(_tmp63 == NULL ? NULL : (_tmp63 = (g_object_unref (_tmp63), NULL)));
								vala_ccode_block_add_statement (vala_ccode_function_get_block (cb_fun), VALA_CCODE_NODE (cdecl_));
								_tmp65 = NULL;
								_tmp64 = NULL;
								vala_ccode_function_call_add_argument (cend_call, VALA_CCODE_EXPRESSION ((_tmp65 = vala_ccode_identifier_new ((_tmp64 = vala_typesymbol_get_type_id (vala_data_type_get_data_type (vala_formal_parameter_get_type_reference (param))))))));
								(_tmp65 == NULL ? NULL : (_tmp65 = (g_object_unref (_tmp65), NULL)));
								(_tmp64 = (g_free (_tmp64), NULL));
								_tmp67 = NULL;
								_tmp66 = NULL;
								vala_ccode_function_call_add_argument (cend_call, VALA_CCODE_EXPRESSION ((_tmp67 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp66 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (param)))))))));
								(_tmp67 == NULL ? NULL : (_tmp67 = (g_object_unref (_tmp67), NULL)));
								(_tmp66 == NULL ? NULL : (_tmp66 = (g_object_unref (_tmp66), NULL)));
								if (VALA_IS_ARRAY (vala_data_type_get_data_type (vala_formal_parameter_get_type_reference (param))) && vala_array_get_element_type ((VALA_ARRAY (vala_data_type_get_data_type (vala_formal_parameter_get_type_reference (param))))) == vala_data_type_get_data_type (self->string_type)) {
									ValaCCodeIdentifier* _tmp68;
									ValaCCodeFunctionCall* _tmp69;
									ValaCCodeFunctionCall* cstrvlen;
									ValaCCodeIdentifier* _tmp70;
									/* special case string array*/
									_tmp68 = NULL;
									_tmp69 = NULL;
									cstrvlen = (_tmp69 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp68 = vala_ccode_identifier_new ("g_strv_length")))), (_tmp68 == NULL ? NULL : (_tmp68 = (g_object_unref (_tmp68), NULL))), _tmp69);
									_tmp70 = NULL;
									vala_ccode_function_call_add_argument (cstrvlen, VALA_CCODE_EXPRESSION ((_tmp70 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (param))))));
									(_tmp70 == NULL ? NULL : (_tmp70 = (g_object_unref (_tmp70), NULL)));
									vala_ccode_function_call_add_argument (creply_call, VALA_CCODE_EXPRESSION (cstrvlen));
									(cstrvlen == NULL ? NULL : (cstrvlen = (g_object_unref (cstrvlen), NULL)));
								}
								_tmp71 = NULL;
								vala_ccode_function_call_add_argument (creply_call, VALA_CCODE_EXPRESSION ((_tmp71 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (param))))));
								(_tmp71 == NULL ? NULL : (_tmp71 = (g_object_unref (_tmp71), NULL)));
								(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
							}
							(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
						}
					}
					(param_collection == NULL ? NULL : (param_collection = (g_object_unref (param_collection), NULL)));
					(param_it == NULL ? NULL : (param_it = (g_object_unref (param_it), NULL)));
				}
				_tmp72 = NULL;
				vala_ccode_function_call_add_argument (cend_call, VALA_CCODE_EXPRESSION ((_tmp72 = vala_ccode_identifier_new ("G_TYPE_INVALID"))));
				(_tmp72 == NULL ? NULL : (_tmp72 = (g_object_unref (_tmp72), NULL)));
				_tmp73 = NULL;
				vala_ccode_block_add_statement (vala_ccode_function_get_block (cb_fun), VALA_CCODE_NODE ((_tmp73 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cend_call)))));
				(_tmp73 == NULL ? NULL : (_tmp73 = (g_object_unref (_tmp73), NULL)));
				_tmp74 = NULL;
				vala_ccode_function_call_add_argument (creply_call, VALA_CCODE_EXPRESSION ((_tmp74 = vala_ccode_identifier_new ("error"))));
				(_tmp74 == NULL ? NULL : (_tmp74 = (g_object_unref (_tmp74), NULL)));
				_tmp75 = NULL;
				vala_ccode_block_add_statement (vala_ccode_function_get_block (cb_fun), VALA_CCODE_NODE ((_tmp75 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (creply_call)))));
				(_tmp75 == NULL ? NULL : (_tmp75 = (g_object_unref (_tmp75), NULL)));
				vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (cb_fun));
				_tmp76 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp76 = vala_ccode_identifier_new (vala_ccode_function_get_name (cb_fun)))));
				(_tmp76 == NULL ? NULL : (_tmp76 = (g_object_unref (_tmp76), NULL)));
				_tmp77 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp77 = vala_ccode_constant_new ("self"))));
				(_tmp77 == NULL ? NULL : (_tmp77 = (g_object_unref (_tmp77), NULL)));
				_tmp78 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp78 = vala_ccode_constant_new ("NULL"))));
				(_tmp78 == NULL ? NULL : (_tmp78 = (g_object_unref (_tmp78), NULL)));
				(reply_method == NULL ? NULL : (reply_method = (g_object_unref (reply_method), NULL)));
				(cb_fun == NULL ? NULL : (cb_fun = (g_object_unref (cb_fun), NULL)));
				(cerrdecl == NULL ? NULL : (cerrdecl = (g_object_unref (cerrdecl), NULL)));
				(cend_call == NULL ? NULL : (cend_call = (g_object_unref (cend_call), NULL)));
				(creply_call == NULL ? NULL : (creply_call = (g_object_unref (creply_call), NULL)));
			} else {
				if (found_out || vala_data_type_get_data_type (vala_method_get_return_type (m)) != NULL) {
					ValaCCodeIdentifier* _tmp79;
					ValaCCodeUnaryExpression* _tmp81;
					ValaCCodeIdentifier* _tmp80;
					_tmp79 = NULL;
					vala_ccode_function_call_set_call (ccall, VALA_CCODE_EXPRESSION ((_tmp79 = vala_ccode_identifier_new ("dbus_g_proxy_call"))));
					(_tmp79 == NULL ? NULL : (_tmp79 = (g_object_unref (_tmp79), NULL)));
					/* method can fail*/
					self->priv->current_method_inner_error = TRUE;
					_tmp81 = NULL;
					_tmp80 = NULL;
					vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp81 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp80 = vala_ccode_identifier_new ("inner_error")))))));
					(_tmp81 == NULL ? NULL : (_tmp81 = (g_object_unref (_tmp81), NULL)));
					(_tmp80 == NULL ? NULL : (_tmp80 = (g_object_unref (_tmp80), NULL)));
				} else {
					ValaCCodeIdentifier* _tmp82;
					_tmp82 = NULL;
					vala_ccode_function_call_set_call (ccall, VALA_CCODE_EXPRESSION ((_tmp82 = vala_ccode_identifier_new ("dbus_g_proxy_call_no_reply"))));
					(_tmp82 == NULL ? NULL : (_tmp82 = (g_object_unref (_tmp82), NULL)));
				}
			}
			(callback == NULL ? NULL : (callback = (g_object_unref (callback), NULL)));
		}
	}
	ellipsis = FALSE;
	i = 1;
	params_it = gee_iterable_iterator (GEE_ITERABLE (params));
	{
		GeeCollection* arg_collection;
		GeeIterator* arg_it;
		arg_collection = vala_invocation_expression_get_argument_list (expr);
		arg_it = gee_iterable_iterator (GEE_ITERABLE (arg_collection));
		while (gee_iterator_next (arg_it)) {
			ValaExpression* arg;
			arg = gee_iterator_get (arg_it);
			{
				ValaCCodeExpression* _tmp85;
				ValaCCodeExpression* cexpr;
				GeeList* extra_args;
				if (VALA_IS_DBUS_METHOD (m)) {
					ValaCCodeIdentifier* _tmp84;
					char* _tmp83;
					if (VALA_IS_METHOD (vala_expression_get_symbol_reference (arg))) {
						(arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL)));
						break;
					}
					/* callback parameter*/
					_tmp84 = NULL;
					_tmp83 = NULL;
					vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp84 = vala_ccode_identifier_new ((_tmp83 = vala_typesymbol_get_type_id (vala_data_type_get_data_type (vala_expression_get_static_type (arg))))))));
					(_tmp84 == NULL ? NULL : (_tmp84 = (g_object_unref (_tmp84), NULL)));
					(_tmp83 = (g_free (_tmp83), NULL));
				}
				_tmp85 = NULL;
				cexpr = (_tmp85 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (arg))), (_tmp85 == NULL ? NULL : g_object_ref (_tmp85)));
				extra_args = GEE_LIST (gee_array_list_new (VALA_TYPE_CCODE_EXPRESSION, ((GBoxedCopyFunc) g_object_ref), g_object_unref, g_direct_equal));
				if (gee_iterator_next (params_it)) {
					ValaFormalParameter* param;
					param = gee_iterator_get (params_it);
					ellipsis = vala_formal_parameter_get_ellipsis (param);
					if (!ellipsis) {
						if (VALA_IS_DELEGATE (vala_data_type_get_data_type (vala_formal_parameter_get_type_reference (param)))) {
							ValaCCodeExpression* _tmp87;
							char* _tmp86;
							_tmp87 = NULL;
							_tmp86 = NULL;
							cexpr = (_tmp87 = VALA_CCODE_EXPRESSION (vala_ccode_cast_expression_new (cexpr, (_tmp86 = vala_typesymbol_get_cname (vala_data_type_get_data_type (vala_formal_parameter_get_type_reference (param)), FALSE)))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), _tmp87);
							(_tmp86 = (g_free (_tmp86), NULL));
						} else {
							ValaCCodeExpression* _tmp93;
							if (!vala_formal_parameter_get_no_array_length (param) && VALA_IS_ARRAY (vala_data_type_get_data_type (vala_formal_parameter_get_type_reference (param)))) {
								ValaArray* _tmp88;
								ValaArray* arr;
								_tmp88 = NULL;
								arr = (_tmp88 = VALA_ARRAY (vala_data_type_get_data_type (vala_formal_parameter_get_type_reference (param))), (_tmp88 == NULL ? NULL : g_object_ref (_tmp88)));
								{
									gint dim;
									dim = 0;
									for (dim = 1; dim <= vala_array_get_rank (arr); dim++) {
										ValaCCodeExpression* _tmp89;
										_tmp89 = NULL;
										vala_ccode_function_call_add_argument (ccall, (_tmp89 = vala_ccode_generator_get_array_length_cexpression (self, arg, dim)));
										(_tmp89 == NULL ? NULL : (_tmp89 = (g_object_unref (_tmp89), NULL)));
									}
								}
								(arr == NULL ? NULL : (arr = (g_object_unref (arr), NULL)));
							} else {
								if (VALA_IS_DELEGATE_TYPE (vala_formal_parameter_get_type_reference (param))) {
									ValaDelegateType* _tmp90;
									ValaDelegateType* deleg_type;
									ValaDelegate* _tmp91;
									ValaDelegate* d;
									_tmp90 = NULL;
									deleg_type = (_tmp90 = VALA_DELEGATE_TYPE (vala_formal_parameter_get_type_reference (param)), (_tmp90 == NULL ? NULL : g_object_ref (_tmp90)));
									_tmp91 = NULL;
									d = (_tmp91 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp91 == NULL ? NULL : g_object_ref (_tmp91)));
									if (vala_delegate_get_instance (d)) {
										ValaCCodeExpression* _tmp92;
										_tmp92 = NULL;
										gee_collection_add (GEE_COLLECTION (extra_args), (_tmp92 = vala_ccode_generator_get_delegate_target_cexpression (self, arg)));
										(_tmp92 == NULL ? NULL : (_tmp92 = (g_object_unref (_tmp92), NULL)));
									}
									(deleg_type == NULL ? NULL : (deleg_type = (g_object_unref (deleg_type), NULL)));
									(d == NULL ? NULL : (d = (g_object_unref (d), NULL)));
								}
							}
							_tmp93 = NULL;
							cexpr = (_tmp93 = vala_ccode_generator_get_implicit_cast_expression (self, cexpr, vala_expression_get_static_type (arg), vala_formal_parameter_get_type_reference (param)), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), _tmp93);
							/* pass non-simple struct instances always by reference*/
							if (!(VALA_IS_NULL_TYPE (vala_expression_get_static_type (arg))) && VALA_IS_STRUCT (vala_data_type_get_data_type (vala_formal_parameter_get_type_reference (param))) && !vala_struct_is_simple_type ((VALA_STRUCT (vala_data_type_get_data_type (vala_formal_parameter_get_type_reference (param)))))) {
								/* we already use a reference for arguments of ref and out parameters*/
								if (!vala_data_type_get_is_ref (vala_formal_parameter_get_type_reference (param)) && !vala_data_type_get_is_out (vala_formal_parameter_get_type_reference (param))) {
									ValaCCodeExpression* _tmp94;
									_tmp94 = NULL;
									cexpr = (_tmp94 = VALA_CCODE_EXPRESSION (vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, cexpr)), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), _tmp94);
								}
							}
							/* unref old value for non-null non-weak out arguments*/
							if (vala_data_type_get_is_out (vala_formal_parameter_get_type_reference (param)) && vala_data_type_get_takes_ownership (vala_formal_parameter_get_type_reference (param)) && !(VALA_IS_NULL_TYPE (vala_expression_get_static_type (arg)))) {
								ValaUnaryExpression* _tmp95;
								ValaUnaryExpression* unary;
								ValaCCodeCommaExpression* ccomma;
								ValaVariableDeclarator* temp_decl;
								ValaCCodeExpression* _tmp97;
								ValaCCodeIdentifier* _tmp96;
								ValaVariableDeclarator* ret_temp_decl;
								ValaCCodeExpression* _tmp101;
								ValaCCodeAssignment* _tmp103;
								ValaCCodeIdentifier* _tmp102;
								ValaCCodeExpression* _tmp106;
								ValaCCodeCommaExpression* _tmp105;
								_tmp95 = NULL;
								unary = (_tmp95 = VALA_UNARY_EXPRESSION (arg), (_tmp95 == NULL ? NULL : g_object_ref (_tmp95)));
								/* (ret_tmp = call (&tmp), free (var1), var1 = tmp, ret_tmp)*/
								ccomma = vala_ccode_comma_expression_new ();
								temp_decl = vala_ccode_generator_get_temp_variable_declarator (self, vala_expression_get_static_type (vala_unary_expression_get_inner (unary)), TRUE, NULL);
								gee_list_insert (GEE_LIST (self->temp_vars), 0, temp_decl);
								_tmp97 = NULL;
								_tmp96 = NULL;
								cexpr = (_tmp97 = VALA_CCODE_EXPRESSION (vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp96 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_decl))))))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), _tmp97);
								(_tmp96 == NULL ? NULL : (_tmp96 = (g_object_unref (_tmp96), NULL)));
								/* call function*/
								ret_temp_decl = NULL;
								if (VALA_IS_VOID_TYPE (vala_method_get_return_type (m))) {
									vala_ccode_comma_expression_append_expression (ccomma, ccall_expr);
								} else {
									ValaVariableDeclarator* _tmp98;
									ValaCCodeAssignment* _tmp100;
									ValaCCodeIdentifier* _tmp99;
									_tmp98 = NULL;
									ret_temp_decl = (_tmp98 = vala_ccode_generator_get_temp_variable_declarator (self, vala_method_get_return_type (m), TRUE, NULL), (ret_temp_decl == NULL ? NULL : (ret_temp_decl = (g_object_unref (ret_temp_decl), NULL))), _tmp98);
									gee_list_insert (GEE_LIST (self->temp_vars), 0, ret_temp_decl);
									_tmp100 = NULL;
									_tmp99 = NULL;
									vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp100 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp99 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (ret_temp_decl))))), ccall_expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
									(_tmp100 == NULL ? NULL : (_tmp100 = (g_object_unref (_tmp100), NULL)));
									(_tmp99 == NULL ? NULL : (_tmp99 = (g_object_unref (_tmp99), NULL)));
								}
								/* unref old value*/
								_tmp101 = NULL;
								vala_ccode_comma_expression_append_expression (ccomma, (_tmp101 = vala_ccode_generator_get_unref_expression (self, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_unary_expression_get_inner (unary)))), vala_expression_get_static_type (arg), arg)));
								(_tmp101 == NULL ? NULL : (_tmp101 = (g_object_unref (_tmp101), NULL)));
								/* assign new value*/
								_tmp103 = NULL;
								_tmp102 = NULL;
								vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp103 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_unary_expression_get_inner (unary)))), VALA_CCODE_EXPRESSION ((_tmp102 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_decl))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
								(_tmp103 == NULL ? NULL : (_tmp103 = (g_object_unref (_tmp103), NULL)));
								(_tmp102 == NULL ? NULL : (_tmp102 = (g_object_unref (_tmp102), NULL)));
								/* return value*/
								if (!(VALA_IS_VOID_TYPE (vala_method_get_return_type (m)))) {
									ValaCCodeIdentifier* _tmp104;
									_tmp104 = NULL;
									vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp104 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (ret_temp_decl))))));
									(_tmp104 == NULL ? NULL : (_tmp104 = (g_object_unref (_tmp104), NULL)));
								}
								_tmp106 = NULL;
								_tmp105 = NULL;
								ccall_expr = (_tmp106 = VALA_CCODE_EXPRESSION ((_tmp105 = ccomma, (_tmp105 == NULL ? NULL : g_object_ref (_tmp105)))), (ccall_expr == NULL ? NULL : (ccall_expr = (g_object_unref (ccall_expr), NULL))), _tmp106);
								(unary == NULL ? NULL : (unary = (g_object_unref (unary), NULL)));
								(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
								(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
								(ret_temp_decl == NULL ? NULL : (ret_temp_decl = (g_object_unref (ret_temp_decl), NULL)));
							}
						}
					} else {
						if (vala_expression_get_can_fail (VALA_EXPRESSION (expr)) && !(VALA_IS_DBUS_METHOD (m))) {
							ValaCCodeUnaryExpression* _tmp108;
							ValaCCodeIdentifier* _tmp107;
							/* method can fail*/
							self->priv->current_method_inner_error = TRUE;
							_tmp108 = NULL;
							_tmp107 = NULL;
							vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp108 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp107 = vala_ccode_identifier_new ("inner_error")))))));
							(_tmp108 == NULL ? NULL : (_tmp108 = (g_object_unref (_tmp108), NULL)));
							(_tmp107 == NULL ? NULL : (_tmp107 = (g_object_unref (_tmp107), NULL)));
						}
					}
					(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
				}
				vala_ccode_function_call_add_argument (ccall, cexpr);
				{
					GeeList* extra_arg_collection;
					GeeIterator* extra_arg_it;
					extra_arg_collection = extra_args;
					extra_arg_it = gee_iterable_iterator (GEE_ITERABLE (extra_arg_collection));
					while (gee_iterator_next (extra_arg_it)) {
						ValaCCodeExpression* extra_arg;
						extra_arg = gee_iterator_get (extra_arg_it);
						{
							vala_ccode_function_call_add_argument (ccall, extra_arg);
							(extra_arg == NULL ? NULL : (extra_arg = (g_object_unref (extra_arg), NULL)));
						}
					}
					(extra_arg_it == NULL ? NULL : (extra_arg_it = (g_object_unref (extra_arg_it), NULL)));
				}
				i++;
				(arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL)));
				(cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL)));
				(extra_args == NULL ? NULL : (extra_args = (g_object_unref (extra_args), NULL)));
			}
		}
		(arg_collection == NULL ? NULL : (arg_collection = (g_object_unref (arg_collection), NULL)));
		(arg_it == NULL ? NULL : (arg_it = (g_object_unref (arg_it), NULL)));
	}
	while (gee_iterator_next (params_it)) {
		ValaFormalParameter* param;
		param = gee_iterator_get (params_it);
		if (vala_formal_parameter_get_ellipsis (param)) {
			ellipsis = TRUE;
			if (vala_expression_get_can_fail (VALA_EXPRESSION (expr)) && !(VALA_IS_DBUS_METHOD (m))) {
				ValaCCodeUnaryExpression* _tmp110;
				ValaCCodeIdentifier* _tmp109;
				/* method can fail*/
				self->priv->current_method_inner_error = TRUE;
				_tmp110 = NULL;
				_tmp109 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp110 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp109 = vala_ccode_identifier_new ("inner_error")))))));
				(_tmp110 == NULL ? NULL : (_tmp110 = (g_object_unref (_tmp110), NULL)));
				(_tmp109 == NULL ? NULL : (_tmp109 = (g_object_unref (_tmp109), NULL)));
			}
			(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
			break;
		}
		if (vala_formal_parameter_get_default_expression (param) == NULL) {
			char* _tmp111;
			_tmp111 = NULL;
			vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (expr)), (_tmp111 = g_strdup_printf ("no default expression for argument %d", i)));
			(_tmp111 = (g_free (_tmp111), NULL));
			(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
			(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
			(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
			(params == NULL ? NULL : (params = (g_object_unref (params), NULL)));
			(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
			(itype == NULL ? NULL : (itype = (g_object_unref (itype), NULL)));
			(ccall_expr == NULL ? NULL : (ccall_expr = (g_object_unref (ccall_expr), NULL)));
			(instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL)));
			(params_it == NULL ? NULL : (params_it = (g_object_unref (params_it), NULL)));
			return;
		}
		/* evaluate default expression here as the code
		 * generator might not have visited the formal
		 * parameter yet */
		vala_code_node_accept (VALA_CODE_NODE (vala_formal_parameter_get_default_expression (param)), VALA_CODE_VISITOR (self));
		if (!vala_formal_parameter_get_no_array_length (param) && vala_formal_parameter_get_type_reference (param) != NULL && VALA_IS_ARRAY (vala_data_type_get_data_type (vala_formal_parameter_get_type_reference (param)))) {
			ValaArray* _tmp112;
			ValaArray* arr;
			_tmp112 = NULL;
			arr = (_tmp112 = VALA_ARRAY (vala_data_type_get_data_type (vala_formal_parameter_get_type_reference (param))), (_tmp112 == NULL ? NULL : g_object_ref (_tmp112)));
			{
				gint dim;
				dim = 0;
				for (dim = 1; dim <= vala_array_get_rank (arr); dim++) {
					ValaCCodeExpression* _tmp113;
					_tmp113 = NULL;
					vala_ccode_function_call_add_argument (ccall, (_tmp113 = vala_ccode_generator_get_array_length_cexpression (self, vala_formal_parameter_get_default_expression (param), dim)));
					(_tmp113 == NULL ? NULL : (_tmp113 = (g_object_unref (_tmp113), NULL)));
				}
			}
			(arr == NULL ? NULL : (arr = (g_object_unref (arr), NULL)));
		}
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_formal_parameter_get_default_expression (param)))));
		i++;
		(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
	}
	/* add length argument for methods returning arrays */
	if (m != NULL && VALA_IS_ARRAY (vala_data_type_get_data_type (vala_method_get_return_type (m))) && !(VALA_IS_DBUS_METHOD (m))) {
		ValaArray* _tmp114;
		ValaArray* arr;
		_tmp114 = NULL;
		arr = (_tmp114 = VALA_ARRAY (vala_data_type_get_data_type (vala_method_get_return_type (m))), (_tmp114 == NULL ? NULL : g_object_ref (_tmp114)));
		{
			gint dim;
			dim = 0;
			for (dim = 1; dim <= vala_array_get_rank (arr); dim++) {
				if (!vala_method_get_no_array_length (m)) {
					ValaVariableDeclarator* temp_decl;
					ValaCCodeIdentifier* temp_ref;
					ValaCCodeUnaryExpression* _tmp115;
					temp_decl = vala_ccode_generator_get_temp_variable_declarator (self, self->int_type, TRUE, NULL);
					temp_ref = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_decl)));
					gee_list_insert (GEE_LIST (self->temp_vars), 0, temp_decl);
					_tmp115 = NULL;
					vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp115 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (temp_ref)))));
					(_tmp115 == NULL ? NULL : (_tmp115 = (g_object_unref (_tmp115), NULL)));
					vala_invocation_expression_append_array_size (expr, VALA_CCODE_EXPRESSION (temp_ref));
					(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
					(temp_ref == NULL ? NULL : (temp_ref = (g_object_unref (temp_ref), NULL)));
				} else {
					ValaCCodeConstant* _tmp116;
					_tmp116 = NULL;
					vala_invocation_expression_append_array_size (expr, VALA_CCODE_EXPRESSION ((_tmp116 = vala_ccode_constant_new ("-1"))));
					(_tmp116 == NULL ? NULL : (_tmp116 = (g_object_unref (_tmp116), NULL)));
				}
			}
		}
		(arr == NULL ? NULL : (arr = (g_object_unref (arr), NULL)));
	} else {
		if (m != NULL && VALA_IS_DELEGATE_TYPE (vala_method_get_return_type (m))) {
			ValaDelegateType* _tmp117;
			ValaDelegateType* deleg_type;
			ValaDelegate* _tmp118;
			ValaDelegate* d;
			_tmp117 = NULL;
			deleg_type = (_tmp117 = VALA_DELEGATE_TYPE (vala_method_get_return_type (m)), (_tmp117 == NULL ? NULL : g_object_ref (_tmp117)));
			_tmp118 = NULL;
			d = (_tmp118 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp118 == NULL ? NULL : g_object_ref (_tmp118)));
			if (vala_delegate_get_instance (d)) {
				ValaPointerType* _tmp120;
				ValaVoidType* _tmp119;
				ValaVariableDeclarator* _tmp121;
				ValaVariableDeclarator* temp_decl;
				ValaCCodeIdentifier* temp_ref;
				ValaCCodeUnaryExpression* _tmp122;
				_tmp120 = NULL;
				_tmp119 = NULL;
				_tmp121 = NULL;
				temp_decl = (_tmp121 = vala_ccode_generator_get_temp_variable_declarator (self, VALA_DATA_TYPE ((_tmp120 = vala_pointer_type_new (VALA_DATA_TYPE ((_tmp119 = vala_void_type_new ()))))), TRUE, NULL), (_tmp120 == NULL ? NULL : (_tmp120 = (g_object_unref (_tmp120), NULL))), (_tmp119 == NULL ? NULL : (_tmp119 = (g_object_unref (_tmp119), NULL))), _tmp121);
				temp_ref = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_decl)));
				gee_list_insert (GEE_LIST (self->temp_vars), 0, temp_decl);
				_tmp122 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp122 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (temp_ref)))));
				(_tmp122 == NULL ? NULL : (_tmp122 = (g_object_unref (_tmp122), NULL)));
				vala_invocation_expression_set_delegate_target (expr, VALA_CCODE_EXPRESSION (temp_ref));
				(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
				(temp_ref == NULL ? NULL : (temp_ref = (g_object_unref (temp_ref), NULL)));
			}
			(deleg_type == NULL ? NULL : (deleg_type = (g_object_unref (deleg_type), NULL)));
			(d == NULL ? NULL : (d = (g_object_unref (d), NULL)));
		}
	}
	if (self->connection_type != NULL && vala_member_access_get_inner (ma) != NULL && vala_expression_get_static_type (vala_member_access_get_inner (ma)) != NULL && vala_data_type_get_data_type (vala_expression_get_static_type (vala_member_access_get_inner (ma))) == self->connection_type && g_utf8_collate (vala_symbol_get_name (VALA_SYMBOL (m)), "get_object") == 0) {
		ValaInterface* _tmp123;
		ValaInterface* dbus_iface;
		ValaAttribute* dbus_attr;
		ValaCCodeConstant* _tmp126;
		char* _tmp125;
		char* _tmp124;
		_tmp123 = NULL;
		dbus_iface = (_tmp123 = VALA_INTERFACE (vala_data_type_get_data_type (vala_method_get_return_type (m))), (_tmp123 == NULL ? NULL : g_object_ref (_tmp123)));
		dbus_attr = vala_code_node_get_attribute (VALA_CODE_NODE (dbus_iface), "DBusInterface");
		_tmp126 = NULL;
		_tmp125 = NULL;
		_tmp124 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp126 = vala_ccode_constant_new ((_tmp125 = g_strdup_printf ("\"%s\"", (_tmp124 = vala_attribute_get_string (dbus_attr, "name"))))))));
		(_tmp126 == NULL ? NULL : (_tmp126 = (g_object_unref (_tmp126), NULL)));
		(_tmp125 = (g_free (_tmp125), NULL));
		(_tmp124 = (g_free (_tmp124), NULL));
		(dbus_iface == NULL ? NULL : (dbus_iface = (g_object_unref (dbus_iface), NULL)));
		(dbus_attr == NULL ? NULL : (dbus_attr = (g_object_unref (dbus_attr), NULL)));
	} else {
		if (VALA_IS_DBUS_METHOD (m)) {
			ValaCCodeIdentifier* _tmp127;
			_tmp127 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp127 = vala_ccode_identifier_new ("G_TYPE_INVALID"))));
			(_tmp127 == NULL ? NULL : (_tmp127 = (g_object_unref (_tmp127), NULL)));
		}
	}
	if (!ellipsis && vala_expression_get_can_fail (VALA_EXPRESSION (expr)) && !(VALA_IS_DBUS_METHOD (m))) {
		ValaCCodeUnaryExpression* _tmp129;
		ValaCCodeIdentifier* _tmp128;
		/* method can fail*/
		self->priv->current_method_inner_error = TRUE;
		_tmp129 = NULL;
		_tmp128 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp129 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp128 = vala_ccode_identifier_new ("inner_error")))))));
		(_tmp129 == NULL ? NULL : (_tmp129 = (g_object_unref (_tmp129), NULL)));
		(_tmp128 == NULL ? NULL : (_tmp128 = (g_object_unref (_tmp128), NULL)));
	}
	if (m != NULL && vala_method_get_instance (m) && vala_method_get_instance_last (m)) {
		vala_ccode_function_call_add_argument (ccall, instance);
	} else {
		if (ellipsis) {
			/* ensure variable argument list ends with NULL
			 * except when using printf-style arguments */
			if ((m == NULL || !vala_method_get_printf_format (m)) && !(VALA_IS_DBUS_METHOD (m))) {
				ValaCCodeConstant* _tmp130;
				_tmp130 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp130 = vala_ccode_constant_new (vala_method_get_sentinel (m)))));
				(_tmp130 == NULL ? NULL : (_tmp130 = (g_object_unref (_tmp130), NULL)));
			}
		} else {
			if (VALA_IS_DELEGATE_TYPE (itype)) {
				ValaDelegateType* _tmp131;
				ValaDelegateType* deleg_type;
				ValaDelegate* _tmp132;
				ValaDelegate* d;
				_tmp131 = NULL;
				deleg_type = (_tmp131 = VALA_DELEGATE_TYPE (itype), (_tmp131 == NULL ? NULL : g_object_ref (_tmp131)));
				_tmp132 = NULL;
				d = (_tmp132 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp132 == NULL ? NULL : g_object_ref (_tmp132)));
				if (vala_delegate_get_instance (d)) {
					ValaCCodeExpression* _tmp133;
					_tmp133 = NULL;
					vala_ccode_function_call_add_argument (ccall, (_tmp133 = vala_ccode_generator_get_delegate_target_cexpression (self, vala_invocation_expression_get_call (expr))));
					(_tmp133 == NULL ? NULL : (_tmp133 = (g_object_unref (_tmp133), NULL)));
				}
				(deleg_type == NULL ? NULL : (deleg_type = (g_object_unref (deleg_type), NULL)));
				(d == NULL ? NULL : (d = (g_object_unref (d), NULL)));
			}
		}
	}
	if (m != NULL && vala_method_get_instance (m) && vala_method_get_returns_modified_pointer (m)) {
		ValaCCodeAssignment* _tmp134;
		_tmp134 = NULL;
		vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp134 = vala_ccode_assignment_new (instance, ccall_expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
		(_tmp134 == NULL ? NULL : (_tmp134 = (g_object_unref (_tmp134), NULL)));
	} else {
		/* cast pointer to actual type if this is a generic method return value */
		if (m != NULL && vala_data_type_get_type_parameter (vala_method_get_return_type (m)) != NULL && vala_data_type_get_data_type (vala_expression_get_static_type (VALA_EXPRESSION (expr))) != NULL) {
			ValaCCodeExpression* _tmp135;
			_tmp135 = NULL;
			vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp135 = vala_ccode_generator_convert_from_generic_pointer (self, ccall_expr, vala_expression_get_static_type (VALA_EXPRESSION (expr))))));
			(_tmp135 == NULL ? NULL : (_tmp135 = (g_object_unref (_tmp135), NULL)));
		} else {
			vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccall_expr));
		}
		vala_ccode_generator_visit_expression (self, VALA_EXPRESSION (expr));
	}
	if (VALA_IS_ARRAY_RESIZE_METHOD (m)) {
		GeeCollection* _tmp136;
		GeeIterator* _tmp137;
		GeeIterator* arg_it;
		ValaCCodeExpression* _tmp139;
		ValaExpression* _tmp138;
		ValaCCodeExpression* _tmp140;
		ValaCCodeExpression* new_size;
		ValaVariableDeclarator* temp_decl;
		ValaCCodeIdentifier* temp_ref;
		ValaCCodeExpression* clen;
		ValaCCodeExpression* _tmp141;
		ValaCCodeExpression* celems;
		char* _tmp143;
		char* _tmp142;
		ValaCCodeIdentifier* _tmp144;
		ValaCCodeIdentifier* csizeof;
		ValaCCodeBinaryExpression* _tmp145;
		ValaCCodeParenthesizedExpression* _tmp146;
		ValaCCodeParenthesizedExpression* cdelta;
		ValaCCodeBinaryExpression* ccheck;
		ValaCCodeIdentifier* _tmp147;
		ValaCCodeFunctionCall* _tmp148;
		ValaCCodeFunctionCall* czero;
		ValaCCodeBinaryExpression* _tmp149;
		ValaCCodeConstant* _tmp150;
		ValaCCodeBinaryExpression* _tmp151;
		ValaCCodeCommaExpression* ccomma;
		ValaCCodeAssignment* _tmp152;
		ValaCCodeConditionalExpression* _tmp154;
		ValaCCodeConstant* _tmp153;
		ValaCCodeAssignment* _tmp156;
		ValaCCodeExpression* _tmp155;
		/* FIXME: size expression must not be evaluated twice at runtime (potential side effects)*/
		_tmp136 = NULL;
		_tmp137 = NULL;
		arg_it = (_tmp137 = gee_iterable_iterator (GEE_ITERABLE ((_tmp136 = vala_invocation_expression_get_argument_list (expr)))), (_tmp136 == NULL ? NULL : (_tmp136 = (g_object_unref (_tmp136), NULL))), _tmp137);
		gee_iterator_next (arg_it);
		_tmp139 = NULL;
		_tmp138 = NULL;
		_tmp140 = NULL;
		new_size = (_tmp140 = (_tmp139 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE ((_tmp138 = gee_iterator_get (arg_it))))), (_tmp139 == NULL ? NULL : g_object_ref (_tmp139))), (_tmp138 == NULL ? NULL : (_tmp138 = (g_object_unref (_tmp138), NULL))), _tmp140);
		temp_decl = vala_ccode_generator_get_temp_variable_declarator (self, self->int_type, TRUE, NULL);
		temp_ref = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_decl)));
		gee_list_insert (GEE_LIST (self->temp_vars), 0, temp_decl);
		/* memset needs string.h */
		self->priv->string_h_needed = TRUE;
		clen = vala_ccode_generator_get_array_length_cexpression (self, vala_member_access_get_inner (ma), 1);
		_tmp141 = NULL;
		celems = (_tmp141 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_member_access_get_inner (ma)))), (_tmp141 == NULL ? NULL : g_object_ref (_tmp141)));
		_tmp143 = NULL;
		_tmp142 = NULL;
		_tmp144 = NULL;
		csizeof = (_tmp144 = vala_ccode_identifier_new ((_tmp143 = g_strdup_printf ("sizeof (%s)", (_tmp142 = vala_typesymbol_get_cname (vala_data_type_get_data_type (vala_expression_get_static_type (vala_member_access_get_inner (ma))), FALSE))))), (_tmp143 = (g_free (_tmp143), NULL)), (_tmp142 = (g_free (_tmp142), NULL)), _tmp144);
		_tmp145 = NULL;
		_tmp146 = NULL;
		cdelta = (_tmp146 = vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION ((_tmp145 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, VALA_CCODE_EXPRESSION (temp_ref), clen)))), (_tmp145 == NULL ? NULL : (_tmp145 = (g_object_unref (_tmp145), NULL))), _tmp146);
		ccheck = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN, VALA_CCODE_EXPRESSION (temp_ref), clen);
		_tmp147 = NULL;
		_tmp148 = NULL;
		czero = (_tmp148 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp147 = vala_ccode_identifier_new ("memset")))), (_tmp147 == NULL ? NULL : (_tmp147 = (g_object_unref (_tmp147), NULL))), _tmp148);
		_tmp149 = NULL;
		vala_ccode_function_call_add_argument (czero, VALA_CCODE_EXPRESSION ((_tmp149 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, celems, clen))));
		(_tmp149 == NULL ? NULL : (_tmp149 = (g_object_unref (_tmp149), NULL)));
		_tmp150 = NULL;
		vala_ccode_function_call_add_argument (czero, VALA_CCODE_EXPRESSION ((_tmp150 = vala_ccode_constant_new ("0"))));
		(_tmp150 == NULL ? NULL : (_tmp150 = (g_object_unref (_tmp150), NULL)));
		_tmp151 = NULL;
		vala_ccode_function_call_add_argument (czero, VALA_CCODE_EXPRESSION ((_tmp151 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, VALA_CCODE_EXPRESSION (csizeof), VALA_CCODE_EXPRESSION (cdelta)))));
		(_tmp151 == NULL ? NULL : (_tmp151 = (g_object_unref (_tmp151), NULL)));
		ccomma = vala_ccode_comma_expression_new ();
		_tmp152 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp152 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (temp_ref), new_size, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
		(_tmp152 == NULL ? NULL : (_tmp152 = (g_object_unref (_tmp152), NULL)));
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (expr))));
		_tmp154 = NULL;
		_tmp153 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp154 = vala_ccode_conditional_expression_new (VALA_CCODE_EXPRESSION (ccheck), VALA_CCODE_EXPRESSION (czero), VALA_CCODE_EXPRESSION ((_tmp153 = vala_ccode_constant_new ("NULL")))))));
		(_tmp154 == NULL ? NULL : (_tmp154 = (g_object_unref (_tmp154), NULL)));
		(_tmp153 == NULL ? NULL : (_tmp153 = (g_object_unref (_tmp153), NULL)));
		_tmp156 = NULL;
		_tmp155 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp156 = vala_ccode_assignment_new ((_tmp155 = vala_ccode_generator_get_array_length_cexpression (self, vala_member_access_get_inner (ma), 1)), VALA_CCODE_EXPRESSION (temp_ref), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
		(_tmp156 == NULL ? NULL : (_tmp156 = (g_object_unref (_tmp156), NULL)));
		(_tmp155 == NULL ? NULL : (_tmp155 = (g_object_unref (_tmp155), NULL)));
		vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccomma));
		(arg_it == NULL ? NULL : (arg_it = (g_object_unref (arg_it), NULL)));
		(new_size == NULL ? NULL : (new_size = (g_object_unref (new_size), NULL)));
		(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
		(temp_ref == NULL ? NULL : (temp_ref = (g_object_unref (temp_ref), NULL)));
		(clen == NULL ? NULL : (clen = (g_object_unref (clen), NULL)));
		(celems == NULL ? NULL : (celems = (g_object_unref (celems), NULL)));
		(csizeof == NULL ? NULL : (csizeof = (g_object_unref (csizeof), NULL)));
		(cdelta == NULL ? NULL : (cdelta = (g_object_unref (cdelta), NULL)));
		(ccheck == NULL ? NULL : (ccheck = (g_object_unref (ccheck), NULL)));
		(czero == NULL ? NULL : (czero = (g_object_unref (czero), NULL)));
		(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
	} else {
		if (m == self->priv->substring_method) {
			ValaVariableDeclarator* temp_decl;
			ValaCCodeIdentifier* temp_ref;
			GeeList* args;
			ValaCCodeIdentifier* _tmp157;
			ValaCCodeFunctionCall* _tmp158;
			ValaCCodeFunctionCall* coffsetcall;
			ValaCCodeExpression* _tmp159;
			ValaCCodeExpression* _tmp160;
			ValaCCodeIdentifier* _tmp161;
			ValaCCodeFunctionCall* _tmp162;
			ValaCCodeFunctionCall* coffsetcall2;
			ValaCCodeExpression* _tmp163;
			ValaCCodeIdentifier* _tmp164;
			ValaCCodeFunctionCall* _tmp165;
			ValaCCodeFunctionCall* cndupcall;
			ValaCCodeBinaryExpression* _tmp166;
			ValaCCodeCommaExpression* ccomma;
			ValaCCodeAssignment* _tmp167;
			temp_decl = vala_ccode_generator_get_temp_variable_declarator (self, self->string_type, TRUE, NULL);
			temp_ref = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_decl)));
			gee_list_insert (GEE_LIST (self->temp_vars), 0, temp_decl);
			args = vala_ccode_function_call_get_arguments (ccall);
			_tmp157 = NULL;
			_tmp158 = NULL;
			coffsetcall = (_tmp158 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp157 = vala_ccode_identifier_new ("g_utf8_offset_to_pointer")))), (_tmp157 == NULL ? NULL : (_tmp157 = (g_object_unref (_tmp157), NULL))), _tmp158);
			/* full string*/
			_tmp159 = NULL;
			vala_ccode_function_call_add_argument (coffsetcall, (_tmp159 = gee_list_get (((GeeList*) args), 0)));
			(_tmp159 == NULL ? NULL : (_tmp159 = (g_object_unref (_tmp159), NULL)));
			/* offset*/
			_tmp160 = NULL;
			vala_ccode_function_call_add_argument (coffsetcall, (_tmp160 = gee_list_get (((GeeList*) args), 1)));
			(_tmp160 == NULL ? NULL : (_tmp160 = (g_object_unref (_tmp160), NULL)));
			_tmp161 = NULL;
			_tmp162 = NULL;
			coffsetcall2 = (_tmp162 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp161 = vala_ccode_identifier_new ("g_utf8_offset_to_pointer")))), (_tmp161 == NULL ? NULL : (_tmp161 = (g_object_unref (_tmp161), NULL))), _tmp162);
			vala_ccode_function_call_add_argument (coffsetcall2, VALA_CCODE_EXPRESSION (temp_ref));
			/* len*/
			_tmp163 = NULL;
			vala_ccode_function_call_add_argument (coffsetcall2, (_tmp163 = gee_list_get (((GeeList*) args), 2)));
			(_tmp163 == NULL ? NULL : (_tmp163 = (g_object_unref (_tmp163), NULL)));
			_tmp164 = NULL;
			_tmp165 = NULL;
			cndupcall = (_tmp165 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp164 = vala_ccode_identifier_new ("g_strndup")))), (_tmp164 == NULL ? NULL : (_tmp164 = (g_object_unref (_tmp164), NULL))), _tmp165);
			vala_ccode_function_call_add_argument (cndupcall, VALA_CCODE_EXPRESSION (temp_ref));
			_tmp166 = NULL;
			vala_ccode_function_call_add_argument (cndupcall, VALA_CCODE_EXPRESSION ((_tmp166 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, VALA_CCODE_EXPRESSION (coffsetcall2), VALA_CCODE_EXPRESSION (temp_ref)))));
			(_tmp166 == NULL ? NULL : (_tmp166 = (g_object_unref (_tmp166), NULL)));
			ccomma = vala_ccode_comma_expression_new ();
			_tmp167 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp167 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (temp_ref), VALA_CCODE_EXPRESSION (coffsetcall), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
			(_tmp167 == NULL ? NULL : (_tmp167 = (g_object_unref (_tmp167), NULL)));
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (cndupcall));
			vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccomma));
			(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
			(temp_ref == NULL ? NULL : (temp_ref = (g_object_unref (temp_ref), NULL)));
			(args == NULL ? NULL : (args = (g_object_unref (args), NULL)));
			(coffsetcall == NULL ? NULL : (coffsetcall = (g_object_unref (coffsetcall), NULL)));
			(coffsetcall2 == NULL ? NULL : (coffsetcall2 = (g_object_unref (coffsetcall2), NULL)));
			(cndupcall == NULL ? NULL : (cndupcall = (g_object_unref (cndupcall), NULL)));
			(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
		} else {
			if (VALA_IS_DBUS_METHOD (m) && vala_data_type_get_data_type (vala_method_get_return_type (m)) != NULL) {
				/* synchronous D-Bus method call with reply*/
				if (VALA_IS_ARRAY (vala_data_type_get_data_type (vala_method_get_return_type (m))) && vala_array_get_element_type ((VALA_ARRAY (vala_data_type_get_data_type (vala_method_get_return_type (m))))) != vala_data_type_get_data_type (self->string_type)) {
					ValaArray* _tmp168;
					ValaArray* array;
					ValaCCodeExpression* _tmp169;
					ValaDataType* garray_type_reference;
					ValaVariableDeclarator* temp_decl;
					ValaCCodeUnaryExpression* _tmp171;
					ValaCCodeIdentifier* _tmp170;
					ValaCCodeIdentifier* _tmp172;
					ValaCCodeCommaExpression* ccomma;
					ValaCCodeMemberAccess* _tmp174;
					ValaCCodeIdentifier* _tmp173;
					_tmp168 = NULL;
					array = (_tmp168 = VALA_ARRAY (vala_data_type_get_data_type (vala_method_get_return_type (m))), (_tmp168 == NULL ? NULL : g_object_ref (_tmp168)));
					_tmp169 = NULL;
					vala_ccode_function_call_add_argument (ccall, (_tmp169 = vala_ccode_generator_get_dbus_array_type (self, array)));
					(_tmp169 == NULL ? NULL : (_tmp169 = (g_object_unref (_tmp169), NULL)));
					garray_type_reference = vala_data_type_new ();
					vala_data_type_set_data_type (garray_type_reference, self->garray_type);
					temp_decl = vala_ccode_generator_get_temp_variable_declarator (self, garray_type_reference, TRUE, NULL);
					gee_list_insert (GEE_LIST (self->temp_vars), 0, temp_decl);
					_tmp171 = NULL;
					_tmp170 = NULL;
					vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp171 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp170 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_decl)))))))));
					(_tmp171 == NULL ? NULL : (_tmp171 = (g_object_unref (_tmp171), NULL)));
					(_tmp170 == NULL ? NULL : (_tmp170 = (g_object_unref (_tmp170), NULL)));
					_tmp172 = NULL;
					vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp172 = vala_ccode_identifier_new ("G_TYPE_INVALID"))));
					(_tmp172 == NULL ? NULL : (_tmp172 = (g_object_unref (_tmp172), NULL)));
					ccomma = vala_ccode_comma_expression_new ();
					vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (ccall));
					_tmp174 = NULL;
					_tmp173 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp174 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp173 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_decl))))), "data"))));
					(_tmp174 == NULL ? NULL : (_tmp174 = (g_object_unref (_tmp174), NULL)));
					(_tmp173 == NULL ? NULL : (_tmp173 = (g_object_unref (_tmp173), NULL)));
					vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccomma));
					if (!vala_method_get_no_array_length (m)) {
						ValaCCodeMemberAccess* _tmp176;
						ValaCCodeIdentifier* _tmp175;
						_tmp176 = NULL;
						_tmp175 = NULL;
						vala_invocation_expression_append_array_size (expr, VALA_CCODE_EXPRESSION ((_tmp176 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp175 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_decl))))), "len"))));
						(_tmp176 == NULL ? NULL : (_tmp176 = (g_object_unref (_tmp176), NULL)));
						(_tmp175 == NULL ? NULL : (_tmp175 = (g_object_unref (_tmp175), NULL)));
					} else {
						ValaCCodeConstant* _tmp177;
						_tmp177 = NULL;
						vala_invocation_expression_append_array_size (expr, VALA_CCODE_EXPRESSION ((_tmp177 = vala_ccode_constant_new ("-1"))));
						(_tmp177 == NULL ? NULL : (_tmp177 = (g_object_unref (_tmp177), NULL)));
					}
					(array == NULL ? NULL : (array = (g_object_unref (array), NULL)));
					(garray_type_reference == NULL ? NULL : (garray_type_reference = (g_object_unref (garray_type_reference), NULL)));
					(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
					(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
				} else {
					ValaCCodeIdentifier* _tmp179;
					char* _tmp178;
					ValaVariableDeclarator* temp_decl;
					ValaCCodeUnaryExpression* _tmp181;
					ValaCCodeIdentifier* _tmp180;
					ValaCCodeIdentifier* _tmp182;
					ValaCCodeCommaExpression* ccomma;
					ValaCCodeIdentifier* _tmp183;
					_tmp179 = NULL;
					_tmp178 = NULL;
					vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp179 = vala_ccode_identifier_new ((_tmp178 = vala_typesymbol_get_type_id (vala_data_type_get_data_type (vala_method_get_return_type (m))))))));
					(_tmp179 == NULL ? NULL : (_tmp179 = (g_object_unref (_tmp179), NULL)));
					(_tmp178 = (g_free (_tmp178), NULL));
					temp_decl = vala_ccode_generator_get_temp_variable_declarator (self, vala_method_get_return_type (m), TRUE, NULL);
					gee_list_insert (GEE_LIST (self->temp_vars), 0, temp_decl);
					_tmp181 = NULL;
					_tmp180 = NULL;
					vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp181 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp180 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_decl)))))))));
					(_tmp181 == NULL ? NULL : (_tmp181 = (g_object_unref (_tmp181), NULL)));
					(_tmp180 == NULL ? NULL : (_tmp180 = (g_object_unref (_tmp180), NULL)));
					_tmp182 = NULL;
					vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp182 = vala_ccode_identifier_new ("G_TYPE_INVALID"))));
					(_tmp182 == NULL ? NULL : (_tmp182 = (g_object_unref (_tmp182), NULL)));
					ccomma = vala_ccode_comma_expression_new ();
					vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (ccall));
					_tmp183 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp183 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_decl))))));
					(_tmp183 == NULL ? NULL : (_tmp183 = (g_object_unref (_tmp183), NULL)));
					vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccomma));
					if (VALA_IS_ARRAY (vala_data_type_get_data_type (vala_method_get_return_type (m))) && vala_array_get_element_type ((VALA_ARRAY (vala_data_type_get_data_type (vala_method_get_return_type (m))))) == vala_data_type_get_data_type (self->string_type)) {
						/* special case string array*/
						if (!vala_method_get_no_array_length (m)) {
							ValaCCodeIdentifier* _tmp184;
							ValaCCodeFunctionCall* _tmp185;
							ValaCCodeFunctionCall* cstrvlen;
							ValaCCodeIdentifier* _tmp186;
							_tmp184 = NULL;
							_tmp185 = NULL;
							cstrvlen = (_tmp185 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp184 = vala_ccode_identifier_new ("g_strv_length")))), (_tmp184 == NULL ? NULL : (_tmp184 = (g_object_unref (_tmp184), NULL))), _tmp185);
							_tmp186 = NULL;
							vala_ccode_function_call_add_argument (cstrvlen, VALA_CCODE_EXPRESSION ((_tmp186 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_decl))))));
							(_tmp186 == NULL ? NULL : (_tmp186 = (g_object_unref (_tmp186), NULL)));
							vala_invocation_expression_append_array_size (expr, VALA_CCODE_EXPRESSION (cstrvlen));
							(cstrvlen == NULL ? NULL : (cstrvlen = (g_object_unref (cstrvlen), NULL)));
						} else {
							ValaCCodeConstant* _tmp187;
							_tmp187 = NULL;
							vala_invocation_expression_append_array_size (expr, VALA_CCODE_EXPRESSION ((_tmp187 = vala_ccode_constant_new ("-1"))));
							(_tmp187 == NULL ? NULL : (_tmp187 = (g_object_unref (_tmp187), NULL)));
						}
					}
					(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
					(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
				}
			}
		}
	}
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
	(params == NULL ? NULL : (params = (g_object_unref (params), NULL)));
	(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
	(itype == NULL ? NULL : (itype = (g_object_unref (itype), NULL)));
	(ccall_expr == NULL ? NULL : (ccall_expr = (g_object_unref (ccall_expr), NULL)));
	(instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL)));
	(params_it == NULL ? NULL : (params_it = (g_object_unref (params_it), NULL)));
}


static ValaCCodeExpression* vala_ccode_generator_get_dbus_array_type (ValaCCodeGenerator* self, ValaArray* array) {
	ValaCCodeIdentifier* _tmp0;
	ValaCCodeFunctionCall* _tmp1;
	ValaCCodeFunctionCall* carray_type;
	ValaCCodeConstant* _tmp2;
	ValaCCodeIdentifier* _tmp4;
	char* _tmp3;
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	g_return_val_if_fail (array == NULL || VALA_IS_ARRAY (array), NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	carray_type = (_tmp1 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp0 = vala_ccode_identifier_new ("dbus_g_type_get_collection")))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1);
	_tmp2 = NULL;
	vala_ccode_function_call_add_argument (carray_type, VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_constant_new ("\"GArray\""))));
	(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
	_tmp4 = NULL;
	_tmp3 = NULL;
	vala_ccode_function_call_add_argument (carray_type, VALA_CCODE_EXPRESSION ((_tmp4 = vala_ccode_identifier_new ((_tmp3 = vala_typesymbol_get_type_id (vala_array_get_element_type (array)))))));
	(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
	(_tmp3 = (g_free (_tmp3), NULL));
	return VALA_CCODE_EXPRESSION (carray_type);
}


static void vala_ccode_generator_process_cmember (ValaCCodeGenerator* self, ValaMemberAccess* expr, ValaCCodeExpression* pub_inst, ValaDataType* base_type) {
	g_return_if_fail (VALA_IS_CCODE_GENERATOR (self));
	g_return_if_fail (expr == NULL || VALA_IS_MEMBER_ACCESS (expr));
	g_return_if_fail (pub_inst == NULL || VALA_IS_CCODE_EXPRESSION (pub_inst));
	g_return_if_fail (base_type == NULL || VALA_IS_DATA_TYPE (base_type));
	if (VALA_IS_METHOD (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr)))) {
		ValaMethod* _tmp0;
		ValaMethod* m;
		_tmp0 = NULL;
		m = (_tmp0 = VALA_METHOD (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr))), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
		if (VALA_IS_BASE_ACCESS (vala_member_access_get_inner (expr))) {
			if (vala_method_get_base_interface_method (m) != NULL) {
				ValaInterface* _tmp1;
				ValaInterface* base_iface;
				char* _tmp3;
				char* _tmp2;
				char* _tmp4;
				char* parent_iface_var;
				ValaCCodeMemberAccess* _tmp6;
				ValaCCodeIdentifier* _tmp5;
				_tmp1 = NULL;
				base_iface = (_tmp1 = VALA_INTERFACE (vala_symbol_get_parent_symbol (VALA_SYMBOL (vala_method_get_base_interface_method (m)))), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
				_tmp3 = NULL;
				_tmp2 = NULL;
				_tmp4 = NULL;
				parent_iface_var = (_tmp4 = g_strdup_printf ("%s_%s_parent_iface", (_tmp2 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (self->priv->current_class), NULL)), (_tmp3 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (base_iface), NULL))), (_tmp3 = (g_free (_tmp3), NULL)), (_tmp2 = (g_free (_tmp2), NULL)), _tmp4);
				_tmp6 = NULL;
				_tmp5 = NULL;
				vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp6 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_identifier_new (parent_iface_var))), vala_symbol_get_name (VALA_SYMBOL (m))))));
				(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
				(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
				(base_iface == NULL ? NULL : (base_iface = (g_object_unref (base_iface), NULL)));
				(parent_iface_var = (g_free (parent_iface_var), NULL));
				(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
				return;
			} else {
				if (vala_method_get_base_method (m) != NULL) {
					ValaClass* _tmp7;
					ValaClass* base_class;
					ValaCCodeIdentifier* _tmp10;
					char* _tmp9;
					char* _tmp8;
					ValaCCodeFunctionCall* _tmp11;
					ValaCCodeFunctionCall* vcast;
					ValaCCodeIdentifier* _tmp14;
					char* _tmp13;
					char* _tmp12;
					ValaCCodeMemberAccess* _tmp15;
					_tmp7 = NULL;
					base_class = (_tmp7 = VALA_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (vala_method_get_base_method (m)))), (_tmp7 == NULL ? NULL : g_object_ref (_tmp7)));
					_tmp10 = NULL;
					_tmp9 = NULL;
					_tmp8 = NULL;
					_tmp11 = NULL;
					vcast = (_tmp11 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp10 = vala_ccode_identifier_new ((_tmp9 = g_strdup_printf ("%s_CLASS", (_tmp8 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (base_class), NULL)))))))), (_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL))), (_tmp9 = (g_free (_tmp9), NULL)), (_tmp8 = (g_free (_tmp8), NULL)), _tmp11);
					_tmp14 = NULL;
					_tmp13 = NULL;
					_tmp12 = NULL;
					vala_ccode_function_call_add_argument (vcast, VALA_CCODE_EXPRESSION ((_tmp14 = vala_ccode_identifier_new ((_tmp13 = g_strdup_printf ("%s_parent_class", (_tmp12 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (self->priv->current_class), NULL))))))));
					(_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL)));
					(_tmp13 = (g_free (_tmp13), NULL));
					(_tmp12 = (g_free (_tmp12), NULL));
					_tmp15 = NULL;
					vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp15 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vcast), vala_symbol_get_name (VALA_SYMBOL (m))))));
					(_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL)));
					(base_class == NULL ? NULL : (base_class = (g_object_unref (base_class), NULL)));
					(vcast == NULL ? NULL : (vcast = (g_object_unref (vcast), NULL)));
					(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
					return;
				}
			}
		}
		if (vala_method_get_base_interface_method (m) != NULL) {
			ValaCCodeIdentifier* _tmp17;
			char* _tmp16;
			_tmp17 = NULL;
			_tmp16 = NULL;
			vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp17 = vala_ccode_identifier_new ((_tmp16 = vala_method_get_cname (vala_method_get_base_interface_method (m)))))));
			(_tmp17 == NULL ? NULL : (_tmp17 = (g_object_unref (_tmp17), NULL)));
			(_tmp16 = (g_free (_tmp16), NULL));
		} else {
			if (vala_method_get_base_method (m) != NULL) {
				ValaCCodeMethodBinding* binding;
				binding = vala_ccode_method_binding_get (vala_method_get_base_method (m));
				if (!vala_ccode_method_binding_get_has_wrapper (binding)) {
					ValaCCodeExpression* _tmp18;
					ValaCCodeExpression* inst;
					ValaClass* _tmp20;
					ValaClass* base_class;
					ValaCCodeIdentifier* _tmp23;
					char* _tmp22;
					char* _tmp21;
					ValaCCodeFunctionCall* _tmp24;
					ValaCCodeFunctionCall* vclass;
					ValaCCodeMemberAccess* _tmp25;
					_tmp18 = NULL;
					inst = (_tmp18 = pub_inst, (_tmp18 == NULL ? NULL : g_object_ref (_tmp18)));
					if (vala_member_access_get_inner (expr) != NULL && !vala_expression_is_pure (vala_member_access_get_inner (expr))) {
						ValaVariableDeclarator* temp_decl;
						ValaCCodeIdentifier* ctemp;
						ValaCCodeExpression* _tmp19;
						/* instance expression has side-effects
						 store in temp. variable*/
						temp_decl = vala_ccode_generator_get_temp_variable_declarator (self, vala_expression_get_static_type (vala_member_access_get_inner (expr)), TRUE, NULL);
						gee_list_insert (GEE_LIST (self->temp_vars), 0, temp_decl);
						ctemp = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_decl)));
						_tmp19 = NULL;
						inst = (_tmp19 = VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (ctemp), pub_inst, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)), (inst == NULL ? NULL : (inst = (g_object_unref (inst), NULL))), _tmp19);
						vala_code_node_set_ccodenode (VALA_CODE_NODE (vala_member_access_get_inner (expr)), VALA_CCODE_NODE (ctemp));
						(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
						(ctemp == NULL ? NULL : (ctemp = (g_object_unref (ctemp), NULL)));
					}
					_tmp20 = NULL;
					base_class = (_tmp20 = VALA_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (vala_method_get_base_method (m)))), (_tmp20 == NULL ? NULL : g_object_ref (_tmp20)));
					_tmp23 = NULL;
					_tmp22 = NULL;
					_tmp21 = NULL;
					_tmp24 = NULL;
					vclass = (_tmp24 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp23 = vala_ccode_identifier_new ((_tmp22 = g_strdup_printf ("%s_GET_CLASS", (_tmp21 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (base_class), NULL)))))))), (_tmp23 == NULL ? NULL : (_tmp23 = (g_object_unref (_tmp23), NULL))), (_tmp22 = (g_free (_tmp22), NULL)), (_tmp21 = (g_free (_tmp21), NULL)), _tmp24);
					vala_ccode_function_call_add_argument (vclass, inst);
					_tmp25 = NULL;
					vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp25 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vclass), vala_symbol_get_name (VALA_SYMBOL (m))))));
					(_tmp25 == NULL ? NULL : (_tmp25 = (g_object_unref (_tmp25), NULL)));
					(inst == NULL ? NULL : (inst = (g_object_unref (inst), NULL)));
					(base_class == NULL ? NULL : (base_class = (g_object_unref (base_class), NULL)));
					(vclass == NULL ? NULL : (vclass = (g_object_unref (vclass), NULL)));
				} else {
					ValaCCodeIdentifier* _tmp27;
					char* _tmp26;
					_tmp27 = NULL;
					_tmp26 = NULL;
					vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp27 = vala_ccode_identifier_new ((_tmp26 = vala_method_get_cname (vala_method_get_base_method (m)))))));
					(_tmp27 == NULL ? NULL : (_tmp27 = (g_object_unref (_tmp27), NULL)));
					(_tmp26 = (g_free (_tmp26), NULL));
				}
				(binding == NULL ? NULL : (binding = (g_object_unref (binding), NULL)));
			} else {
				ValaCCodeIdentifier* _tmp29;
				char* _tmp28;
				_tmp29 = NULL;
				_tmp28 = NULL;
				vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp29 = vala_ccode_identifier_new ((_tmp28 = vala_method_get_cname (m))))));
				(_tmp29 == NULL ? NULL : (_tmp29 = (g_object_unref (_tmp29), NULL)));
				(_tmp28 = (g_free (_tmp28), NULL));
			}
		}
		(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
	} else {
		if (VALA_IS_ARRAY_LENGTH_FIELD (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr)))) {
			ValaCCodeExpression* _tmp30;
			_tmp30 = NULL;
			vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp30 = vala_ccode_generator_get_array_length_cexpression (self, vala_member_access_get_inner (expr), 1))));
			(_tmp30 == NULL ? NULL : (_tmp30 = (g_object_unref (_tmp30), NULL)));
		} else {
			if (VALA_IS_FIELD (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr)))) {
				ValaField* _tmp31;
				ValaField* f;
				_tmp31 = NULL;
				f = (_tmp31 = VALA_FIELD (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr))), (_tmp31 == NULL ? NULL : g_object_ref (_tmp31)));
				if (vala_field_get_instance (f)) {
					ValaDataType* _tmp32;
					ValaDataType* instance_expression_type;
					ValaDataType* instance_target_type;
					ValaCCodeExpression* typed_inst;
					gboolean is_gtypeinstance;
					ValaCCodeExpression* inst;
					_tmp32 = NULL;
					instance_expression_type = (_tmp32 = base_type, (_tmp32 == NULL ? NULL : g_object_ref (_tmp32)));
					instance_target_type = vala_data_type_new ();
					vala_data_type_set_data_type (instance_target_type, VALA_TYPESYMBOL (vala_symbol_get_parent_symbol (VALA_SYMBOL (f))));
					typed_inst = vala_ccode_generator_get_implicit_cast_expression (self, pub_inst, instance_expression_type, instance_target_type);
					is_gtypeinstance = (vala_typesymbol_is_subtype_of (vala_data_type_get_data_type (instance_target_type), self->gtypeinstance_type));
					inst = NULL;
					if (is_gtypeinstance && vala_symbol_get_access (VALA_SYMBOL (f)) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
						ValaCCodeExpression* _tmp33;
						_tmp33 = NULL;
						inst = (_tmp33 = VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (typed_inst, "priv")), (inst == NULL ? NULL : (inst = (g_object_unref (inst), NULL))), _tmp33);
					} else {
						ValaCCodeExpression* _tmp35;
						ValaCCodeExpression* _tmp34;
						_tmp35 = NULL;
						_tmp34 = NULL;
						inst = (_tmp35 = (_tmp34 = typed_inst, (_tmp34 == NULL ? NULL : g_object_ref (_tmp34))), (inst == NULL ? NULL : (inst = (g_object_unref (inst), NULL))), _tmp35);
					}
					if (vala_typesymbol_is_reference_type (vala_data_type_get_data_type (instance_target_type))) {
						ValaCCodeMemberAccess* _tmp37;
						char* _tmp36;
						_tmp37 = NULL;
						_tmp36 = NULL;
						vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp37 = vala_ccode_member_access_new_pointer (inst, (_tmp36 = vala_field_get_cname (f))))));
						(_tmp37 == NULL ? NULL : (_tmp37 = (g_object_unref (_tmp37), NULL)));
						(_tmp36 = (g_free (_tmp36), NULL));
					} else {
						ValaCCodeMemberAccess* _tmp39;
						char* _tmp38;
						_tmp39 = NULL;
						_tmp38 = NULL;
						vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp39 = vala_ccode_member_access_new (inst, (_tmp38 = vala_field_get_cname (f)), FALSE))));
						(_tmp39 == NULL ? NULL : (_tmp39 = (g_object_unref (_tmp39), NULL)));
						(_tmp38 = (g_free (_tmp38), NULL));
					}
					(instance_expression_type == NULL ? NULL : (instance_expression_type = (g_object_unref (instance_expression_type), NULL)));
					(instance_target_type == NULL ? NULL : (instance_target_type = (g_object_unref (instance_target_type), NULL)));
					(typed_inst == NULL ? NULL : (typed_inst = (g_object_unref (typed_inst), NULL)));
					(inst == NULL ? NULL : (inst = (g_object_unref (inst), NULL)));
				} else {
					ValaCCodeIdentifier* _tmp41;
					char* _tmp40;
					_tmp41 = NULL;
					_tmp40 = NULL;
					vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp41 = vala_ccode_identifier_new ((_tmp40 = vala_field_get_cname (f))))));
					(_tmp41 == NULL ? NULL : (_tmp41 = (g_object_unref (_tmp41), NULL)));
					(_tmp40 = (g_free (_tmp40), NULL));
				}
				(f == NULL ? NULL : (f = (g_object_unref (f), NULL)));
			} else {
				if (VALA_IS_CONSTANT (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr)))) {
					ValaConstant* _tmp42;
					ValaConstant* c;
					ValaCCodeIdentifier* _tmp44;
					char* _tmp43;
					_tmp42 = NULL;
					c = (_tmp42 = VALA_CONSTANT (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr))), (_tmp42 == NULL ? NULL : g_object_ref (_tmp42)));
					_tmp44 = NULL;
					_tmp43 = NULL;
					vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp44 = vala_ccode_identifier_new ((_tmp43 = vala_constant_get_cname (c))))));
					(_tmp44 == NULL ? NULL : (_tmp44 = (g_object_unref (_tmp44), NULL)));
					(_tmp43 = (g_free (_tmp43), NULL));
					(c == NULL ? NULL : (c = (g_object_unref (c), NULL)));
				} else {
					if (VALA_IS_PROPERTY (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr)))) {
						ValaProperty* _tmp45;
						ValaProperty* prop;
						_tmp45 = NULL;
						prop = (_tmp45 = VALA_PROPERTY (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr))), (_tmp45 == NULL ? NULL : g_object_ref (_tmp45)));
						if (!vala_property_get_no_accessor_method (prop)) {
							ValaProperty* _tmp46;
							ValaProperty* base_property;
							ValaTypesymbol* _tmp51;
							ValaTypesymbol* base_property_type;
							ValaCCodeIdentifier* _tmp54;
							char* _tmp53;
							char* _tmp52;
							ValaCCodeFunctionCall* _tmp55;
							ValaCCodeFunctionCall* ccall;
							ValaDataType* _tmp56;
							ValaDataType* instance_expression_type;
							ValaDataType* instance_target_type;
							ValaCCodeExpression* typed_pub_inst;
							_tmp46 = NULL;
							base_property = (_tmp46 = prop, (_tmp46 == NULL ? NULL : g_object_ref (_tmp46)));
							if (vala_property_get_base_property (prop) != NULL) {
								ValaProperty* _tmp48;
								ValaProperty* _tmp47;
								_tmp48 = NULL;
								_tmp47 = NULL;
								base_property = (_tmp48 = (_tmp47 = vala_property_get_base_property (prop), (_tmp47 == NULL ? NULL : g_object_ref (_tmp47))), (base_property == NULL ? NULL : (base_property = (g_object_unref (base_property), NULL))), _tmp48);
							} else {
								if (vala_property_get_base_interface_property (prop) != NULL) {
									ValaProperty* _tmp50;
									ValaProperty* _tmp49;
									_tmp50 = NULL;
									_tmp49 = NULL;
									base_property = (_tmp50 = (_tmp49 = vala_property_get_base_interface_property (prop), (_tmp49 == NULL ? NULL : g_object_ref (_tmp49))), (base_property == NULL ? NULL : (base_property = (g_object_unref (base_property), NULL))), _tmp50);
								}
							}
							_tmp51 = NULL;
							base_property_type = (_tmp51 = VALA_TYPESYMBOL (vala_symbol_get_parent_symbol (VALA_SYMBOL (base_property))), (_tmp51 == NULL ? NULL : g_object_ref (_tmp51)));
							_tmp54 = NULL;
							_tmp53 = NULL;
							_tmp52 = NULL;
							_tmp55 = NULL;
							ccall = (_tmp55 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp54 = vala_ccode_identifier_new ((_tmp53 = g_strdup_printf ("%s_get_%s", (_tmp52 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (base_property_type), NULL)), vala_symbol_get_name (VALA_SYMBOL (base_property)))))))), (_tmp54 == NULL ? NULL : (_tmp54 = (g_object_unref (_tmp54), NULL))), (_tmp53 = (g_free (_tmp53), NULL)), (_tmp52 = (g_free (_tmp52), NULL)), _tmp55);
							_tmp56 = NULL;
							instance_expression_type = (_tmp56 = base_type, (_tmp56 == NULL ? NULL : g_object_ref (_tmp56)));
							instance_target_type = vala_data_type_new ();
							vala_data_type_set_data_type (instance_target_type, base_property_type);
							typed_pub_inst = vala_ccode_generator_get_implicit_cast_expression (self, pub_inst, instance_expression_type, instance_target_type);
							vala_ccode_function_call_add_argument (ccall, typed_pub_inst);
							vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccall));
							(base_property == NULL ? NULL : (base_property = (g_object_unref (base_property), NULL)));
							(base_property_type == NULL ? NULL : (base_property_type = (g_object_unref (base_property_type), NULL)));
							(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
							(instance_expression_type == NULL ? NULL : (instance_expression_type = (g_object_unref (instance_expression_type), NULL)));
							(instance_target_type == NULL ? NULL : (instance_target_type = (g_object_unref (instance_target_type), NULL)));
							(typed_pub_inst == NULL ? NULL : (typed_pub_inst = (g_object_unref (typed_pub_inst), NULL)));
						} else {
							ValaCCodeIdentifier* _tmp57;
							ValaCCodeFunctionCall* _tmp58;
							ValaCCodeFunctionCall* ccall;
							ValaCCodeIdentifier* _tmp59;
							ValaCCodeFunctionCall* _tmp60;
							ValaCCodeFunctionCall* ccast;
							ValaCCodeConstant* _tmp61;
							ValaVariableDeclarator* temp_decl;
							ValaCCodeIdentifier* ctemp;
							ValaCCodeUnaryExpression* _tmp62;
							ValaCCodeConstant* _tmp63;
							ValaCCodeCommaExpression* ccomma;
							_tmp57 = NULL;
							_tmp58 = NULL;
							ccall = (_tmp58 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp57 = vala_ccode_identifier_new ("g_object_get")))), (_tmp57 == NULL ? NULL : (_tmp57 = (g_object_unref (_tmp57), NULL))), _tmp58);
							_tmp59 = NULL;
							_tmp60 = NULL;
							ccast = (_tmp60 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp59 = vala_ccode_identifier_new ("G_OBJECT")))), (_tmp59 == NULL ? NULL : (_tmp59 = (g_object_unref (_tmp59), NULL))), _tmp60);
							vala_ccode_function_call_add_argument (ccast, pub_inst);
							vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (ccast));
							/* property name is second argument of g_object_get*/
							_tmp61 = NULL;
							vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp61 = vala_property_get_canonical_cconstant (prop))));
							(_tmp61 == NULL ? NULL : (_tmp61 = (g_object_unref (_tmp61), NULL)));
							/* we need a temporary variable to save the property value*/
							temp_decl = vala_ccode_generator_get_temp_variable_declarator (self, vala_expression_get_static_type (VALA_EXPRESSION (expr)), TRUE, NULL);
							gee_list_insert (GEE_LIST (self->temp_vars), 0, temp_decl);
							ctemp = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_decl)));
							_tmp62 = NULL;
							vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp62 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (ctemp)))));
							(_tmp62 == NULL ? NULL : (_tmp62 = (g_object_unref (_tmp62), NULL)));
							_tmp63 = NULL;
							vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp63 = vala_ccode_constant_new ("NULL"))));
							(_tmp63 == NULL ? NULL : (_tmp63 = (g_object_unref (_tmp63), NULL)));
							ccomma = vala_ccode_comma_expression_new ();
							vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (ccall));
							vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (ctemp));
							vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccomma));
							(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
							(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
							(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
							(ctemp == NULL ? NULL : (ctemp = (g_object_unref (ctemp), NULL)));
							(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
						}
						(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
					} else {
						if (VALA_IS_ENUM_VALUE (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr)))) {
							ValaEnumValue* _tmp64;
							ValaEnumValue* ev;
							ValaCCodeConstant* _tmp66;
							char* _tmp65;
							_tmp64 = NULL;
							ev = (_tmp64 = VALA_ENUM_VALUE (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr))), (_tmp64 == NULL ? NULL : g_object_ref (_tmp64)));
							_tmp66 = NULL;
							_tmp65 = NULL;
							vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp66 = vala_ccode_constant_new ((_tmp65 = vala_enum_value_get_cname (ev))))));
							(_tmp66 == NULL ? NULL : (_tmp66 = (g_object_unref (_tmp66), NULL)));
							(_tmp65 = (g_free (_tmp65), NULL));
							(ev == NULL ? NULL : (ev = (g_object_unref (ev), NULL)));
						} else {
							if (VALA_IS_VARIABLE_DECLARATOR (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr)))) {
								ValaVariableDeclarator* _tmp67;
								ValaVariableDeclarator* decl;
								ValaCCodeIdentifier* _tmp69;
								char* _tmp68;
								_tmp67 = NULL;
								decl = (_tmp67 = VALA_VARIABLE_DECLARATOR (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr))), (_tmp67 == NULL ? NULL : g_object_ref (_tmp67)));
								_tmp69 = NULL;
								_tmp68 = NULL;
								vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp69 = vala_ccode_identifier_new ((_tmp68 = vala_ccode_generator_get_variable_cname (self, vala_symbol_get_name (VALA_SYMBOL (decl))))))));
								(_tmp69 == NULL ? NULL : (_tmp69 = (g_object_unref (_tmp69), NULL)));
								(_tmp68 = (g_free (_tmp68), NULL));
								(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
							} else {
								if (VALA_IS_FORMAL_PARAMETER (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr)))) {
									ValaFormalParameter* _tmp70;
									ValaFormalParameter* p;
									_tmp70 = NULL;
									p = (_tmp70 = VALA_FORMAL_PARAMETER (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr))), (_tmp70 == NULL ? NULL : g_object_ref (_tmp70)));
									if (g_utf8_collate (vala_symbol_get_name (VALA_SYMBOL (p)), "this") == 0) {
										vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (pub_inst));
									} else {
										if (vala_data_type_get_is_out (vala_formal_parameter_get_type_reference (p)) || vala_data_type_get_is_ref (vala_formal_parameter_get_type_reference (p))) {
											ValaCCodeIdentifier* _tmp72;
											char* _tmp71;
											_tmp72 = NULL;
											_tmp71 = NULL;
											vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp72 = vala_ccode_identifier_new ((_tmp71 = g_strdup_printf ("(*%s)", vala_symbol_get_name (VALA_SYMBOL (p))))))));
											(_tmp72 == NULL ? NULL : (_tmp72 = (g_object_unref (_tmp72), NULL)));
											(_tmp71 = (g_free (_tmp71), NULL));
										} else {
											ValaCCodeIdentifier* _tmp73;
											_tmp73 = NULL;
											vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp73 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (p))))));
											(_tmp73 == NULL ? NULL : (_tmp73 = (g_object_unref (_tmp73), NULL)));
										}
									}
									(p == NULL ? NULL : (p = (g_object_unref (p), NULL)));
								} else {
									if (VALA_IS_SIGNAL (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr)))) {
										ValaSignal* _tmp74;
										ValaSignal* sig;
										ValaTypesymbol* _tmp75;
										ValaTypesymbol* cl;
										_tmp74 = NULL;
										sig = (_tmp74 = VALA_SIGNAL (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr))), (_tmp74 == NULL ? NULL : g_object_ref (_tmp74)));
										_tmp75 = NULL;
										cl = (_tmp75 = VALA_TYPESYMBOL (vala_symbol_get_parent_symbol (VALA_SYMBOL (sig))), (_tmp75 == NULL ? NULL : g_object_ref (_tmp75)));
										if (vala_signal_get_has_emitter (sig)) {
											ValaCCodeIdentifier* _tmp78;
											char* _tmp77;
											char* _tmp76;
											ValaCCodeFunctionCall* _tmp79;
											ValaCCodeFunctionCall* ccall;
											ValaDataType* _tmp80;
											ValaDataType* instance_expression_type;
											ValaDataType* instance_target_type;
											ValaCCodeExpression* typed_pub_inst;
											_tmp78 = NULL;
											_tmp77 = NULL;
											_tmp76 = NULL;
											_tmp79 = NULL;
											ccall = (_tmp79 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp78 = vala_ccode_identifier_new ((_tmp77 = g_strdup_printf ("%s_%s", (_tmp76 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)), vala_symbol_get_name (VALA_SYMBOL (sig)))))))), (_tmp78 == NULL ? NULL : (_tmp78 = (g_object_unref (_tmp78), NULL))), (_tmp77 = (g_free (_tmp77), NULL)), (_tmp76 = (g_free (_tmp76), NULL)), _tmp79);
											_tmp80 = NULL;
											instance_expression_type = (_tmp80 = base_type, (_tmp80 == NULL ? NULL : g_object_ref (_tmp80)));
											instance_target_type = vala_data_type_new ();
											vala_data_type_set_data_type (instance_target_type, cl);
											typed_pub_inst = vala_ccode_generator_get_implicit_cast_expression (self, pub_inst, instance_expression_type, instance_target_type);
											vala_ccode_function_call_add_argument (ccall, typed_pub_inst);
											vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccall));
											(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
											(instance_expression_type == NULL ? NULL : (instance_expression_type = (g_object_unref (instance_expression_type), NULL)));
											(instance_target_type == NULL ? NULL : (instance_target_type = (g_object_unref (instance_target_type), NULL)));
											(typed_pub_inst == NULL ? NULL : (typed_pub_inst = (g_object_unref (typed_pub_inst), NULL)));
										} else {
											ValaCCodeIdentifier* _tmp81;
											ValaCCodeFunctionCall* _tmp82;
											ValaCCodeFunctionCall* ccall;
											ValaCCodeIdentifier* _tmp83;
											ValaCCodeFunctionCall* _tmp84;
											ValaCCodeFunctionCall* ccast;
											ValaCCodeConstant* _tmp85;
											_tmp81 = NULL;
											_tmp82 = NULL;
											ccall = (_tmp82 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp81 = vala_ccode_identifier_new ("g_signal_emit_by_name")))), (_tmp81 == NULL ? NULL : (_tmp81 = (g_object_unref (_tmp81), NULL))), _tmp82);
											/* FIXME: use C cast if debugging disabled*/
											_tmp83 = NULL;
											_tmp84 = NULL;
											ccast = (_tmp84 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp83 = vala_ccode_identifier_new ("G_OBJECT")))), (_tmp83 == NULL ? NULL : (_tmp83 = (g_object_unref (_tmp83), NULL))), _tmp84);
											vala_ccode_function_call_add_argument (ccast, pub_inst);
											vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (ccast));
											_tmp85 = NULL;
											vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp85 = vala_signal_get_canonical_cconstant (sig))));
											(_tmp85 == NULL ? NULL : (_tmp85 = (g_object_unref (_tmp85), NULL)));
											vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccall));
											(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
											(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
										}
										(sig == NULL ? NULL : (sig = (g_object_unref (sig), NULL)));
										(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
									}
								}
							}
						}
					}
				}
			}
		}
	}
}


static void vala_ccode_generator_real_visit_member_access (ValaCodeVisitor* base, ValaMemberAccess* expr) {
	ValaCCodeGenerator * self;
	ValaCCodeExpression* pub_inst;
	ValaDataType* base_type;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (expr == NULL || VALA_IS_MEMBER_ACCESS (expr));
	pub_inst = NULL;
	base_type = NULL;
	if (vala_member_access_get_inner (expr) == NULL) {
		ValaCCodeExpression* _tmp0;
		_tmp0 = NULL;
		pub_inst = (_tmp0 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("self")), (pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL))), _tmp0);
		if (self->current_type_symbol != NULL) {
			/* base type is available if this is a type method */
			if (VALA_IS_CLASS (self->current_type_symbol)) {
				ValaDataType* _tmp1;
				_tmp1 = NULL;
				base_type = (_tmp1 = VALA_DATA_TYPE (vala_class_type_new (VALA_CLASS (self->current_type_symbol))), (base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL))), _tmp1);
			} else {
				if (VALA_IS_INTERFACE (self->current_type_symbol)) {
					ValaDataType* _tmp2;
					_tmp2 = NULL;
					base_type = (_tmp2 = VALA_DATA_TYPE (vala_interface_type_new (VALA_INTERFACE (self->current_type_symbol))), (base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL))), _tmp2);
				} else {
					ValaDataType* _tmp3;
					ValaCCodeExpression* _tmp4;
					_tmp3 = NULL;
					base_type = (_tmp3 = VALA_DATA_TYPE (vala_value_type_new (self->current_type_symbol)), (base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL))), _tmp3);
					_tmp4 = NULL;
					pub_inst = (_tmp4 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("(*self)")), (pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL))), _tmp4);
				}
			}
		}
	} else {
		ValaCCodeExpression* _tmp6;
		ValaCCodeExpression* _tmp5;
		_tmp6 = NULL;
		_tmp5 = NULL;
		pub_inst = (_tmp6 = (_tmp5 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_member_access_get_inner (expr)))), (_tmp5 == NULL ? NULL : g_object_ref (_tmp5))), (pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL))), _tmp6);
		if (vala_expression_get_static_type (vala_member_access_get_inner (expr)) != NULL) {
			ValaDataType* _tmp8;
			ValaDataType* _tmp7;
			_tmp8 = NULL;
			_tmp7 = NULL;
			base_type = (_tmp8 = (_tmp7 = vala_expression_get_static_type (vala_member_access_get_inner (expr)), (_tmp7 == NULL ? NULL : g_object_ref (_tmp7))), (base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL))), _tmp8);
		}
	}
	vala_ccode_generator_process_cmember (self, expr, pub_inst, base_type);
	vala_ccode_generator_visit_expression (self, VALA_EXPRESSION (expr));
	(pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL)));
	(base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL)));
}


static void vala_ccode_generator_real_visit_method (ValaCodeVisitor* base, ValaMethod* m) {
	ValaCCodeGenerator * self;
	ValaMethod* _tmp0;
	ValaMethod* old_method;
	ValaDataType* _tmp1;
	ValaDataType* old_return_type;
	gboolean old_method_inner_error;
	gint old_next_temp_var_id;
	ValaSymbol* _tmp3;
	ValaMethod* _tmp2;
	ValaMethod* _tmp5;
	ValaMethod* _tmp4;
	ValaDataType* _tmp7;
	ValaDataType* _tmp6;
	gboolean in_gtypeinstance_creation_method;
	gboolean in_gobject_creation_method;
	gboolean in_fundamental_creation_method;
	ValaDataType* _tmp8;
	ValaDataType* creturn_type;
	gboolean inner_error;
	ValaSymbol* _tmp17;
	ValaSymbol* _tmp16;
	ValaMethod* _tmp19;
	ValaMethod* _tmp18;
	ValaDataType* _tmp21;
	ValaDataType* _tmp20;
	ValaCCodeFunction* _tmp25;
	char* _tmp24;
	char* _tmp23;
	ValaCCodeFunctionDeclarator* vdeclarator;
	ValaCCodeFormalParameter* instance_param;
	GeeCollection* params;
	GeeCollection* _tmp65;
	gboolean _tmp66;
	gboolean visible;
	gboolean return_value;
	gboolean args_parameter;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (m == NULL || VALA_IS_METHOD (m));
	_tmp0 = NULL;
	old_method = (_tmp0 = self->priv->current_method, (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	_tmp1 = NULL;
	old_return_type = (_tmp1 = self->priv->current_return_type, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
	old_method_inner_error = self->priv->current_method_inner_error;
	old_next_temp_var_id = self->priv->next_temp_var_id;
	_tmp3 = NULL;
	_tmp2 = NULL;
	self->priv->current_symbol = (_tmp3 = VALA_SYMBOL ((_tmp2 = m, (_tmp2 == NULL ? NULL : g_object_ref (_tmp2)))), (self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL))), _tmp3);
	_tmp5 = NULL;
	_tmp4 = NULL;
	self->priv->current_method = (_tmp5 = (_tmp4 = m, (_tmp4 == NULL ? NULL : g_object_ref (_tmp4))), (self->priv->current_method == NULL ? NULL : (self->priv->current_method = (g_object_unref (self->priv->current_method), NULL))), _tmp5);
	_tmp7 = NULL;
	_tmp6 = NULL;
	self->priv->current_return_type = (_tmp7 = (_tmp6 = vala_method_get_return_type (m), (_tmp6 == NULL ? NULL : g_object_ref (_tmp6))), (self->priv->current_return_type == NULL ? NULL : (self->priv->current_return_type = (g_object_unref (self->priv->current_return_type), NULL))), _tmp7);
	self->priv->current_method_inner_error = FALSE;
	self->priv->next_temp_var_id = 0;
	in_gtypeinstance_creation_method = FALSE;
	in_gobject_creation_method = FALSE;
	in_fundamental_creation_method = FALSE;
	_tmp8 = NULL;
	creturn_type = (_tmp8 = self->priv->current_return_type, (_tmp8 == NULL ? NULL : g_object_ref (_tmp8)));
	if (VALA_IS_CREATION_METHOD (m)) {
		ValaClass* _tmp10;
		ValaTypesymbol* _tmp9;
		ValaClass* cl;
		self->in_creation_method = TRUE;
		_tmp10 = NULL;
		_tmp9 = NULL;
		cl = (_tmp10 = (_tmp9 = self->current_type_symbol, (VALA_IS_CLASS (_tmp9) ? ((ValaClass*) _tmp9) : NULL)), (_tmp10 == NULL ? NULL : g_object_ref (_tmp10)));
		if (cl != NULL && vala_typesymbol_is_subtype_of (VALA_TYPESYMBOL (cl), self->gtypeinstance_type)) {
			in_gtypeinstance_creation_method = TRUE;
			if (VALA_TYPESYMBOL (vala_class_get_base_class (cl)) == self->gtypeinstance_type) {
				in_fundamental_creation_method = TRUE;
			} else {
				if (vala_typesymbol_is_subtype_of (VALA_TYPESYMBOL (cl), self->gobject_type)) {
					in_gobject_creation_method = TRUE;
				}
			}
		}
		if (cl != NULL) {
			ValaDataType* _tmp11;
			_tmp11 = NULL;
			creturn_type = (_tmp11 = VALA_DATA_TYPE (vala_class_type_new (cl)), (creturn_type == NULL ? NULL : (creturn_type = (g_object_unref (creturn_type), NULL))), _tmp11);
		}
		(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
	}
	vala_code_node_accept_children (VALA_CODE_NODE (m), VALA_CODE_VISITOR (self));
	if (VALA_IS_CREATION_METHOD (m)) {
		if (in_gobject_creation_method && vala_method_get_body (m) != NULL) {
			ValaCCodeBlock* cblock;
			cblock = vala_ccode_block_new ();
			{
				GeeCollection* stmt_collection;
				GeeIterator* stmt_it;
				stmt_collection = vala_block_get_statements (vala_method_get_body (m));
				stmt_it = gee_iterable_iterator (GEE_ITERABLE (stmt_collection));
				while (gee_iterator_next (stmt_it)) {
					ValaCodeNode* stmt;
					stmt = gee_iterator_get (stmt_it);
					{
						ValaProperty* _tmp12;
						gboolean _tmp13;
						_tmp12 = NULL;
						if ((_tmp13 = vala_property_accessor_get_construction (vala_property_get_set_accessor ((_tmp12 = vala_expression_statement_assigned_property ((VALA_EXPRESSION_STATEMENT (stmt)))))), (_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL))), _tmp13)) {
							if (VALA_IS_CCODE_FRAGMENT (vala_code_node_get_ccodenode (stmt))) {
								{
									GeeCollection* cstmt_collection;
									GeeIterator* cstmt_it;
									cstmt_collection = vala_ccode_fragment_get_children ((VALA_CCODE_FRAGMENT (vala_code_node_get_ccodenode (stmt))));
									cstmt_it = gee_iterable_iterator (GEE_ITERABLE (cstmt_collection));
									while (gee_iterator_next (cstmt_it)) {
										ValaCCodeStatement* cstmt;
										cstmt = gee_iterator_get (cstmt_it);
										{
											vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cstmt));
											(cstmt == NULL ? NULL : (cstmt = (g_object_unref (cstmt), NULL)));
										}
									}
									(cstmt_collection == NULL ? NULL : (cstmt_collection = (g_object_unref (cstmt_collection), NULL)));
									(cstmt_it == NULL ? NULL : (cstmt_it = (g_object_unref (cstmt_it), NULL)));
								}
							} else {
								vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode (stmt))));
							}
						}
						(stmt == NULL ? NULL : (stmt = (g_object_unref (stmt), NULL)));
					}
				}
				(stmt_collection == NULL ? NULL : (stmt_collection = (g_object_unref (stmt_collection), NULL)));
				(stmt_it == NULL ? NULL : (stmt_it = (g_object_unref (stmt_it), NULL)));
			}
			vala_ccode_generator_add_object_creation (self, cblock, vala_creation_method_get_n_construction_params ((VALA_CREATION_METHOD (m))) > 0);
			{
				GeeCollection* stmt_collection;
				GeeIterator* stmt_it;
				stmt_collection = vala_block_get_statements (vala_method_get_body (m));
				stmt_it = gee_iterable_iterator (GEE_ITERABLE (stmt_collection));
				while (gee_iterator_next (stmt_it)) {
					ValaCodeNode* stmt;
					stmt = gee_iterator_get (stmt_it);
					{
						ValaProperty* _tmp14;
						gboolean _tmp15;
						_tmp14 = NULL;
						if ((_tmp15 = !vala_property_accessor_get_construction (vala_property_get_set_accessor ((_tmp14 = vala_expression_statement_assigned_property ((VALA_EXPRESSION_STATEMENT (stmt)))))), (_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL))), _tmp15)) {
							if (VALA_IS_CCODE_FRAGMENT (vala_code_node_get_ccodenode (stmt))) {
								{
									GeeCollection* cstmt_collection;
									GeeIterator* cstmt_it;
									cstmt_collection = vala_ccode_fragment_get_children ((VALA_CCODE_FRAGMENT (vala_code_node_get_ccodenode (stmt))));
									cstmt_it = gee_iterable_iterator (GEE_ITERABLE (cstmt_collection));
									while (gee_iterator_next (cstmt_it)) {
										ValaCCodeStatement* cstmt;
										cstmt = gee_iterator_get (cstmt_it);
										{
											vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cstmt));
											(cstmt == NULL ? NULL : (cstmt = (g_object_unref (cstmt), NULL)));
										}
									}
									(cstmt_collection == NULL ? NULL : (cstmt_collection = (g_object_unref (cstmt_collection), NULL)));
									(cstmt_it == NULL ? NULL : (cstmt_it = (g_object_unref (cstmt_it), NULL)));
								}
							} else {
								vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode (stmt))));
							}
						}
						(stmt == NULL ? NULL : (stmt = (g_object_unref (stmt), NULL)));
					}
				}
				(stmt_collection == NULL ? NULL : (stmt_collection = (g_object_unref (stmt_collection), NULL)));
				(stmt_it == NULL ? NULL : (stmt_it = (g_object_unref (stmt_it), NULL)));
			}
			vala_code_node_set_ccodenode (VALA_CODE_NODE (vala_method_get_body (m)), VALA_CCODE_NODE (cblock));
			(cblock == NULL ? NULL : (cblock = (g_object_unref (cblock), NULL)));
		}
		self->in_creation_method = FALSE;
	}
	inner_error = self->priv->current_method_inner_error;
	_tmp17 = NULL;
	_tmp16 = NULL;
	self->priv->current_symbol = (_tmp17 = (_tmp16 = vala_symbol_get_parent_symbol (self->priv->current_symbol), (_tmp16 == NULL ? NULL : g_object_ref (_tmp16))), (self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL))), _tmp17);
	_tmp19 = NULL;
	_tmp18 = NULL;
	self->priv->current_method = (_tmp19 = (_tmp18 = self->priv->current_method, (_tmp18 == NULL ? NULL : g_object_ref (_tmp18))), (self->priv->current_method == NULL ? NULL : (self->priv->current_method = (g_object_unref (self->priv->current_method), NULL))), _tmp19);
	_tmp21 = NULL;
	_tmp20 = NULL;
	self->priv->current_return_type = (_tmp21 = (_tmp20 = old_return_type, (_tmp20 == NULL ? NULL : g_object_ref (_tmp20))), (self->priv->current_return_type == NULL ? NULL : (self->priv->current_return_type = (g_object_unref (self->priv->current_return_type), NULL))), _tmp21);
	self->priv->current_method_inner_error = old_method_inner_error;
	self->priv->next_temp_var_id = old_next_temp_var_id;
	if (self->current_type_symbol != NULL && VALA_IS_INTERFACE (self->current_type_symbol)) {
		ValaInterface* _tmp22;
		ValaInterface* iface;
		_tmp22 = NULL;
		iface = (_tmp22 = VALA_INTERFACE (self->current_type_symbol), (_tmp22 == NULL ? NULL : g_object_ref (_tmp22)));
		if (vala_interface_get_is_static (iface)) {
			(iface == NULL ? NULL : (iface = (g_object_unref (iface), NULL)));
			(old_method == NULL ? NULL : (old_method = (g_object_unref (old_method), NULL)));
			(old_return_type == NULL ? NULL : (old_return_type = (g_object_unref (old_return_type), NULL)));
			(creturn_type == NULL ? NULL : (creturn_type = (g_object_unref (creturn_type), NULL)));
			return;
		}
		(iface == NULL ? NULL : (iface = (g_object_unref (iface), NULL)));
	}
	_tmp25 = NULL;
	_tmp24 = NULL;
	_tmp23 = NULL;
	self->priv->function = (_tmp25 = vala_ccode_function_new ((_tmp23 = vala_method_get_real_cname (m)), (_tmp24 = vala_data_type_get_cname (creturn_type, FALSE, FALSE))), (self->priv->function == NULL ? NULL : (self->priv->function = (g_object_unref (self->priv->function), NULL))), _tmp25);
	(_tmp24 = (g_free (_tmp24), NULL));
	(_tmp23 = (g_free (_tmp23), NULL));
	vala_code_node_set_ccodenode (VALA_CODE_NODE (m), VALA_CCODE_NODE (self->priv->function));
	if (vala_method_get_is_inline (m)) {
		vala_ccode_function_set_modifiers (self->priv->function, vala_ccode_function_get_modifiers (self->priv->function) | (VALA_CCODE_MODIFIERS_INLINE));
	}
	vdeclarator = NULL;
	instance_param = NULL;
	if (vala_method_get_instance (m) || (VALA_IS_STRUCT (vala_symbol_get_parent_symbol (VALA_SYMBOL (m))) && VALA_IS_CREATION_METHOD (m))) {
		ValaTypesymbol* parent_type;
		ValaDataType* this_type;
		parent_type = vala_ccode_generator_find_parent_type (self, VALA_SYMBOL (m));
		this_type = NULL;
		if (VALA_IS_CLASS (parent_type)) {
			ValaDataType* _tmp26;
			_tmp26 = NULL;
			this_type = (_tmp26 = VALA_DATA_TYPE (vala_class_type_new (VALA_CLASS (parent_type))), (this_type == NULL ? NULL : (this_type = (g_object_unref (this_type), NULL))), _tmp26);
		} else {
			if (VALA_IS_INTERFACE (parent_type)) {
				ValaDataType* _tmp27;
				_tmp27 = NULL;
				this_type = (_tmp27 = VALA_DATA_TYPE (vala_interface_type_new (VALA_INTERFACE (parent_type))), (this_type == NULL ? NULL : (this_type = (g_object_unref (this_type), NULL))), _tmp27);
			} else {
				ValaDataType* _tmp28;
				_tmp28 = NULL;
				this_type = (_tmp28 = VALA_DATA_TYPE (vala_value_type_new (parent_type)), (this_type == NULL ? NULL : (this_type = (g_object_unref (this_type), NULL))), _tmp28);
			}
		}
		if (vala_method_get_base_interface_method (m) != NULL && !vala_method_get_is_abstract (m) && !vala_method_get_is_virtual (m)) {
			ValaInterfaceType* base_type;
			ValaCCodeFormalParameter* _tmp30;
			char* _tmp29;
			base_type = vala_interface_type_new (VALA_INTERFACE (vala_symbol_get_parent_symbol (VALA_SYMBOL (vala_method_get_base_interface_method (m)))));
			_tmp30 = NULL;
			_tmp29 = NULL;
			instance_param = (_tmp30 = vala_ccode_formal_parameter_new ("base", (_tmp29 = vala_data_type_get_cname (VALA_DATA_TYPE (base_type), FALSE, FALSE))), (instance_param == NULL ? NULL : (instance_param = (g_object_unref (instance_param), NULL))), _tmp30);
			(_tmp29 = (g_free (_tmp29), NULL));
			(base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL)));
		} else {
			if (vala_method_get_overrides (m)) {
				ValaClassType* base_type;
				ValaCCodeFormalParameter* _tmp32;
				char* _tmp31;
				base_type = vala_class_type_new (VALA_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (vala_method_get_base_method (m)))));
				_tmp32 = NULL;
				_tmp31 = NULL;
				instance_param = (_tmp32 = vala_ccode_formal_parameter_new ("base", (_tmp31 = vala_data_type_get_cname (VALA_DATA_TYPE (base_type), FALSE, FALSE))), (instance_param == NULL ? NULL : (instance_param = (g_object_unref (instance_param), NULL))), _tmp32);
				(_tmp31 = (g_free (_tmp31), NULL));
				(base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL)));
			} else {
				if (VALA_IS_STRUCT (vala_symbol_get_parent_symbol (VALA_SYMBOL (m))) && !vala_struct_is_simple_type ((VALA_STRUCT (vala_symbol_get_parent_symbol (VALA_SYMBOL (m)))))) {
					ValaCCodeFormalParameter* _tmp34;
					char* _tmp33;
					_tmp34 = NULL;
					_tmp33 = NULL;
					instance_param = (_tmp34 = vala_ccode_formal_parameter_new ("*self", (_tmp33 = vala_data_type_get_cname (this_type, FALSE, FALSE))), (instance_param == NULL ? NULL : (instance_param = (g_object_unref (instance_param), NULL))), _tmp34);
					(_tmp33 = (g_free (_tmp33), NULL));
				} else {
					ValaCCodeFormalParameter* _tmp36;
					char* _tmp35;
					_tmp36 = NULL;
					_tmp35 = NULL;
					instance_param = (_tmp36 = vala_ccode_formal_parameter_new ("self", (_tmp35 = vala_data_type_get_cname (this_type, FALSE, FALSE))), (instance_param == NULL ? NULL : (instance_param = (g_object_unref (instance_param), NULL))), _tmp36);
					(_tmp35 = (g_free (_tmp35), NULL));
				}
			}
		}
		if (!vala_method_get_instance_last (m)) {
			vala_ccode_function_add_parameter (self->priv->function, instance_param);
		}
		if (vala_method_get_is_abstract (m) || vala_method_get_is_virtual (m)) {
			char* _tmp37;
			ValaCCodeDeclaration* _tmp38;
			ValaCCodeDeclaration* vdecl;
			ValaCCodeFunctionDeclarator* _tmp39;
			_tmp37 = NULL;
			_tmp38 = NULL;
			vdecl = (_tmp38 = vala_ccode_declaration_new ((_tmp37 = vala_data_type_get_cname (creturn_type, FALSE, FALSE))), (_tmp37 = (g_free (_tmp37), NULL)), _tmp38);
			_tmp39 = NULL;
			vdeclarator = (_tmp39 = vala_ccode_function_declarator_new (vala_method_get_vfunc_name (m)), (vdeclarator == NULL ? NULL : (vdeclarator = (g_object_unref (vdeclarator), NULL))), _tmp39);
			vala_ccode_declaration_add_declarator (vdecl, VALA_CCODE_DECLARATOR (vdeclarator));
			vala_ccode_struct_add_declaration (self->priv->type_struct, vdecl);
			vala_ccode_function_declarator_add_parameter (vdeclarator, instance_param);
			(vdecl == NULL ? NULL : (vdecl = (g_object_unref (vdecl), NULL)));
		}
		(parent_type == NULL ? NULL : (parent_type = (g_object_unref (parent_type), NULL)));
		(this_type == NULL ? NULL : (this_type = (g_object_unref (this_type), NULL)));
	}
	if (in_fundamental_creation_method) {
		ValaCCodeFormalParameter* _tmp40;
		_tmp40 = NULL;
		vala_ccode_function_add_parameter (self->priv->function, (_tmp40 = vala_ccode_formal_parameter_new ("type", "GType")));
		(_tmp40 == NULL ? NULL : (_tmp40 = (g_object_unref (_tmp40), NULL)));
	}
	if (in_gobject_creation_method) {
		{
			GeeCollection* type_param_collection;
			GeeIterator* type_param_it;
			type_param_collection = vala_class_get_type_parameters (self->priv->current_class);
			type_param_it = gee_iterable_iterator (GEE_ITERABLE (type_param_collection));
			while (gee_iterator_next (type_param_it)) {
				ValaTypeParameter* type_param;
				type_param = gee_iterator_get (type_param_it);
				{
					ValaCCodeFormalParameter* _tmp43;
					char* _tmp42;
					char* _tmp41;
					ValaCCodeFormalParameter* _tmp46;
					char* _tmp45;
					char* _tmp44;
					ValaCCodeFormalParameter* _tmp49;
					char* _tmp48;
					char* _tmp47;
					/* memory management for generic types*/
					_tmp43 = NULL;
					_tmp42 = NULL;
					_tmp41 = NULL;
					vala_ccode_function_add_parameter (self->priv->function, (_tmp43 = vala_ccode_formal_parameter_new ((_tmp42 = g_strdup_printf ("%s_type", (_tmp41 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1)))), "GType")));
					(_tmp43 == NULL ? NULL : (_tmp43 = (g_object_unref (_tmp43), NULL)));
					(_tmp42 = (g_free (_tmp42), NULL));
					(_tmp41 = (g_free (_tmp41), NULL));
					_tmp46 = NULL;
					_tmp45 = NULL;
					_tmp44 = NULL;
					vala_ccode_function_add_parameter (self->priv->function, (_tmp46 = vala_ccode_formal_parameter_new ((_tmp45 = g_strdup_printf ("%s_dup_func", (_tmp44 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1)))), "GBoxedCopyFunc")));
					(_tmp46 == NULL ? NULL : (_tmp46 = (g_object_unref (_tmp46), NULL)));
					(_tmp45 = (g_free (_tmp45), NULL));
					(_tmp44 = (g_free (_tmp44), NULL));
					_tmp49 = NULL;
					_tmp48 = NULL;
					_tmp47 = NULL;
					vala_ccode_function_add_parameter (self->priv->function, (_tmp49 = vala_ccode_formal_parameter_new ((_tmp48 = g_strdup_printf ("%s_destroy_func", (_tmp47 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1)))), "GDestroyNotify")));
					(_tmp49 == NULL ? NULL : (_tmp49 = (g_object_unref (_tmp49), NULL)));
					(_tmp48 = (g_free (_tmp48), NULL));
					(_tmp47 = (g_free (_tmp47), NULL));
					(type_param == NULL ? NULL : (type_param = (g_object_unref (type_param), NULL)));
				}
			}
			(type_param_collection == NULL ? NULL : (type_param_collection = (g_object_unref (type_param_collection), NULL)));
			(type_param_it == NULL ? NULL : (type_param_it = (g_object_unref (type_param_it), NULL)));
		}
	}
	params = vala_method_get_parameters (m);
	{
		GeeCollection* param_collection;
		GeeIterator* param_it;
		param_collection = params;
		param_it = gee_iterable_iterator (GEE_ITERABLE (param_collection));
		while (gee_iterator_next (param_it)) {
			ValaFormalParameter* param;
			param = gee_iterator_get (param_it);
			{
				if (!vala_formal_parameter_get_no_array_length (param) && vala_formal_parameter_get_type_reference (param) != NULL && VALA_IS_ARRAY (vala_data_type_get_data_type (vala_formal_parameter_get_type_reference (param)))) {
					ValaArray* _tmp50;
					ValaArray* arr;
					char* length_ctype;
					_tmp50 = NULL;
					arr = (_tmp50 = VALA_ARRAY (vala_data_type_get_data_type (vala_formal_parameter_get_type_reference (param))), (_tmp50 == NULL ? NULL : g_object_ref (_tmp50)));
					length_ctype = g_strdup ("int");
					if (vala_data_type_get_is_out (vala_formal_parameter_get_type_reference (param)) || vala_data_type_get_is_ref (vala_formal_parameter_get_type_reference (param))) {
						char* _tmp51;
						_tmp51 = NULL;
						length_ctype = (_tmp51 = g_strdup ("int*"), (length_ctype = (g_free (length_ctype), NULL)), _tmp51);
					}
					{
						gint dim;
						dim = 0;
						for (dim = 1; dim <= vala_array_get_rank (arr); dim++) {
							char* _tmp52;
							ValaCCodeFormalParameter* _tmp53;
							ValaCCodeFormalParameter* cparam;
							_tmp52 = NULL;
							_tmp53 = NULL;
							cparam = (_tmp53 = vala_ccode_formal_parameter_new ((_tmp52 = vala_ccode_generator_get_array_length_cname (self, vala_symbol_get_name (VALA_SYMBOL (param)), dim)), length_ctype), (_tmp52 = (g_free (_tmp52), NULL)), _tmp53);
							vala_ccode_function_add_parameter (self->priv->function, cparam);
							if (vdeclarator != NULL) {
								vala_ccode_function_declarator_add_parameter (vdeclarator, cparam);
							}
							(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
						}
					}
					(arr == NULL ? NULL : (arr = (g_object_unref (arr), NULL)));
					(length_ctype = (g_free (length_ctype), NULL));
				}
				vala_ccode_function_add_parameter (self->priv->function, VALA_CCODE_FORMAL_PARAMETER (vala_code_node_get_ccodenode (VALA_CODE_NODE (param))));
				if (vdeclarator != NULL) {
					vala_ccode_function_declarator_add_parameter (vdeclarator, VALA_CCODE_FORMAL_PARAMETER (vala_code_node_get_ccodenode (VALA_CODE_NODE (param))));
				}
				if (VALA_IS_DELEGATE_TYPE (vala_formal_parameter_get_type_reference (param))) {
					ValaDelegateType* _tmp54;
					ValaDelegateType* deleg_type;
					ValaDelegate* _tmp55;
					ValaDelegate* d;
					_tmp54 = NULL;
					deleg_type = (_tmp54 = VALA_DELEGATE_TYPE (vala_formal_parameter_get_type_reference (param)), (_tmp54 == NULL ? NULL : g_object_ref (_tmp54)));
					_tmp55 = NULL;
					d = (_tmp55 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp55 == NULL ? NULL : g_object_ref (_tmp55)));
					if (vala_delegate_get_instance (d)) {
						char* _tmp56;
						ValaCCodeFormalParameter* _tmp57;
						ValaCCodeFormalParameter* cparam;
						_tmp56 = NULL;
						_tmp57 = NULL;
						cparam = (_tmp57 = vala_ccode_formal_parameter_new ((_tmp56 = vala_ccode_generator_get_delegate_target_cname (self, vala_symbol_get_name (VALA_SYMBOL (param)))), "void*"), (_tmp56 = (g_free (_tmp56), NULL)), _tmp57);
						vala_ccode_function_add_parameter (self->priv->function, cparam);
						if (vdeclarator != NULL) {
							vala_ccode_function_declarator_add_parameter (vdeclarator, cparam);
						}
						(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
					}
					(deleg_type == NULL ? NULL : (deleg_type = (g_object_unref (deleg_type), NULL)));
					(d == NULL ? NULL : (d = (g_object_unref (d), NULL)));
				}
				(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
			}
		}
		(param_it == NULL ? NULL : (param_it = (g_object_unref (param_it), NULL)));
	}
	if (!vala_method_get_no_array_length (m) && VALA_IS_ARRAY (vala_data_type_get_data_type (creturn_type))) {
		ValaArray* _tmp58;
		ValaArray* arr;
		/* return array length if appropriate*/
		_tmp58 = NULL;
		arr = (_tmp58 = VALA_ARRAY (vala_data_type_get_data_type (creturn_type)), (_tmp58 == NULL ? NULL : g_object_ref (_tmp58)));
		{
			gint dim;
			dim = 0;
			for (dim = 1; dim <= vala_array_get_rank (arr); dim++) {
				char* _tmp59;
				ValaCCodeFormalParameter* _tmp60;
				ValaCCodeFormalParameter* cparam;
				_tmp59 = NULL;
				_tmp60 = NULL;
				cparam = (_tmp60 = vala_ccode_formal_parameter_new ((_tmp59 = vala_ccode_generator_get_array_length_cname (self, "result", dim)), "int*"), (_tmp59 = (g_free (_tmp59), NULL)), _tmp60);
				vala_ccode_function_add_parameter (self->priv->function, cparam);
				if (vdeclarator != NULL) {
					vala_ccode_function_declarator_add_parameter (vdeclarator, cparam);
				}
				(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
			}
		}
		(arr == NULL ? NULL : (arr = (g_object_unref (arr), NULL)));
	} else {
		if (VALA_IS_DELEGATE_TYPE (creturn_type)) {
			ValaDelegateType* _tmp61;
			ValaDelegateType* deleg_type;
			ValaDelegate* _tmp62;
			ValaDelegate* d;
			/* return delegate target if appropriate*/
			_tmp61 = NULL;
			deleg_type = (_tmp61 = VALA_DELEGATE_TYPE (creturn_type), (_tmp61 == NULL ? NULL : g_object_ref (_tmp61)));
			_tmp62 = NULL;
			d = (_tmp62 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp62 == NULL ? NULL : g_object_ref (_tmp62)));
			if (vala_delegate_get_instance (d)) {
				char* _tmp63;
				ValaCCodeFormalParameter* _tmp64;
				ValaCCodeFormalParameter* cparam;
				_tmp63 = NULL;
				_tmp64 = NULL;
				cparam = (_tmp64 = vala_ccode_formal_parameter_new ((_tmp63 = vala_ccode_generator_get_delegate_target_cname (self, "result")), "void*"), (_tmp63 = (g_free (_tmp63), NULL)), _tmp64);
				vala_ccode_function_add_parameter (self->priv->function, cparam);
				if (vdeclarator != NULL) {
					vala_ccode_function_declarator_add_parameter (vdeclarator, cparam);
				}
				(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
			}
			(deleg_type == NULL ? NULL : (deleg_type = (g_object_unref (deleg_type), NULL)));
			(d == NULL ? NULL : (d = (g_object_unref (d), NULL)));
		}
	}
	if (vala_method_get_instance (m) && vala_method_get_instance_last (m)) {
		vala_ccode_function_add_parameter (self->priv->function, instance_param);
	}
	_tmp65 = NULL;
	if ((_tmp66 = gee_collection_get_size ((_tmp65 = vala_method_get_error_domains (m))) > 0, (_tmp65 == NULL ? NULL : (_tmp65 = (g_object_unref (_tmp65), NULL))), _tmp66)) {
		ValaCCodeFormalParameter* cparam;
		cparam = vala_ccode_formal_parameter_new ("error", "GError**");
		vala_ccode_function_add_parameter (self->priv->function, cparam);
		if (vdeclarator != NULL) {
			vala_ccode_function_declarator_add_parameter (vdeclarator, cparam);
		}
		(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
	}
	visible = !vala_symbol_is_internal_symbol (VALA_SYMBOL (m));
	/* real function declaration and definition not needed
	 * for abstract methods */
	if (!vala_method_get_is_abstract (m)) {
		if (visible && vala_method_get_base_method (m) == NULL && vala_method_get_base_interface_method (m) == NULL) {
			ValaCCodeFunction* _tmp67;
			/* public methods need function declaration in
			 * header file except virtual/overridden methods */
			_tmp67 = NULL;
			vala_ccode_fragment_append (self->priv->header_type_member_declaration, VALA_CCODE_NODE ((_tmp67 = vala_ccode_function_copy (self->priv->function))));
			(_tmp67 == NULL ? NULL : (_tmp67 = (g_object_unref (_tmp67), NULL)));
		} else {
			ValaCCodeFunction* _tmp68;
			/* declare all other functions in source file to
			 * avoid dependency on order within source file */
			vala_ccode_function_set_modifiers (self->priv->function, vala_ccode_function_get_modifiers (self->priv->function) | (VALA_CCODE_MODIFIERS_STATIC));
			_tmp68 = NULL;
			vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE ((_tmp68 = vala_ccode_function_copy (self->priv->function))));
			(_tmp68 == NULL ? NULL : (_tmp68 = (g_object_unref (_tmp68), NULL)));
		}
		/* Methods imported from a plain C file don't
		 * have a body, e.g. Vala.Parser.parse_file () */
		if (vala_method_get_body (m) != NULL) {
			ValaCCodeFragment* cinit;
			vala_ccode_function_set_block (self->priv->function, VALA_CCODE_BLOCK (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_method_get_body (m)))));
			vala_ccode_node_set_line (VALA_CCODE_NODE (vala_ccode_function_get_block (self->priv->function)), vala_ccode_node_get_line (VALA_CCODE_NODE (self->priv->function)));
			cinit = vala_ccode_fragment_new ();
			vala_ccode_block_prepend_statement (vala_ccode_function_get_block (self->priv->function), VALA_CCODE_NODE (cinit));
			if (VALA_IS_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (m)))) {
				ValaClass* _tmp69;
				ValaClass* cl;
				_tmp69 = NULL;
				cl = (_tmp69 = VALA_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (m))), (_tmp69 == NULL ? NULL : g_object_ref (_tmp69)));
				if (vala_method_get_overrides (m) || (vala_method_get_base_interface_method (m) != NULL && !vala_method_get_is_abstract (m) && !vala_method_get_is_virtual (m))) {
					ValaMethod* base_method;
					ValaReferenceType* base_expression_type;
					ValaClassType* self_target_type;
					ValaCCodeIdentifier* _tmp76;
					ValaCCodeExpression* _tmp77;
					ValaCCodeExpression* cself;
					char* _tmp79;
					char* _tmp78;
					ValaCCodeDeclaration* _tmp80;
					ValaCCodeDeclaration* cdecl_;
					ValaCCodeVariableDeclarator* _tmp81;
					base_method = NULL;
					base_expression_type = NULL;
					if (vala_method_get_overrides (m)) {
						ValaMethod* _tmp71;
						ValaMethod* _tmp70;
						ValaReferenceType* _tmp72;
						_tmp71 = NULL;
						_tmp70 = NULL;
						base_method = (_tmp71 = (_tmp70 = vala_method_get_base_method (m), (_tmp70 == NULL ? NULL : g_object_ref (_tmp70))), (base_method == NULL ? NULL : (base_method = (g_object_unref (base_method), NULL))), _tmp71);
						_tmp72 = NULL;
						base_expression_type = (_tmp72 = VALA_REFERENCE_TYPE (vala_class_type_new (VALA_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (base_method))))), (base_expression_type == NULL ? NULL : (base_expression_type = (g_object_unref (base_expression_type), NULL))), _tmp72);
					} else {
						ValaMethod* _tmp74;
						ValaMethod* _tmp73;
						ValaReferenceType* _tmp75;
						_tmp74 = NULL;
						_tmp73 = NULL;
						base_method = (_tmp74 = (_tmp73 = vala_method_get_base_interface_method (m), (_tmp73 == NULL ? NULL : g_object_ref (_tmp73))), (base_method == NULL ? NULL : (base_method = (g_object_unref (base_method), NULL))), _tmp74);
						_tmp75 = NULL;
						base_expression_type = (_tmp75 = VALA_REFERENCE_TYPE (vala_interface_type_new (VALA_INTERFACE (vala_symbol_get_parent_symbol (VALA_SYMBOL (base_method))))), (base_expression_type == NULL ? NULL : (base_expression_type = (g_object_unref (base_expression_type), NULL))), _tmp75);
					}
					self_target_type = vala_class_type_new (cl);
					_tmp76 = NULL;
					_tmp77 = NULL;
					cself = (_tmp77 = vala_ccode_generator_get_implicit_cast_expression (self, VALA_CCODE_EXPRESSION ((_tmp76 = vala_ccode_identifier_new ("base"))), VALA_DATA_TYPE (base_expression_type), VALA_DATA_TYPE (self_target_type)), (_tmp76 == NULL ? NULL : (_tmp76 = (g_object_unref (_tmp76), NULL))), _tmp77);
					_tmp79 = NULL;
					_tmp78 = NULL;
					_tmp80 = NULL;
					cdecl_ = (_tmp80 = vala_ccode_declaration_new ((_tmp79 = g_strdup_printf ("%s *", (_tmp78 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE))))), (_tmp79 = (g_free (_tmp79), NULL)), (_tmp78 = (g_free (_tmp78), NULL)), _tmp80);
					_tmp81 = NULL;
					vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp81 = vala_ccode_variable_declarator_new_with_initializer ("self", cself))));
					(_tmp81 == NULL ? NULL : (_tmp81 = (g_object_unref (_tmp81), NULL)));
					vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (cdecl_));
					(base_method == NULL ? NULL : (base_method = (g_object_unref (base_method), NULL)));
					(base_expression_type == NULL ? NULL : (base_expression_type = (g_object_unref (base_expression_type), NULL)));
					(self_target_type == NULL ? NULL : (self_target_type = (g_object_unref (self_target_type), NULL)));
					(cself == NULL ? NULL : (cself = (g_object_unref (cself), NULL)));
					(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
				} else {
					if (vala_method_get_instance (m)) {
						ValaCCodeStatement* ccheckstmt;
						ccheckstmt = vala_ccode_generator_create_method_type_check_statement (self, m, creturn_type, VALA_TYPESYMBOL (cl), TRUE, "self");
						vala_ccode_node_set_line (VALA_CCODE_NODE (ccheckstmt), vala_ccode_node_get_line (VALA_CCODE_NODE (self->priv->function)));
						vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (ccheckstmt));
						(ccheckstmt == NULL ? NULL : (ccheckstmt = (g_object_unref (ccheckstmt), NULL)));
					}
				}
				(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
			}
			{
				GeeCollection* param_collection;
				GeeIterator* param_it;
				param_collection = vala_method_get_parameters (m);
				param_it = gee_iterable_iterator (GEE_ITERABLE (param_collection));
				while (gee_iterator_next (param_it)) {
					ValaFormalParameter* param;
					param = gee_iterator_get (param_it);
					{
						ValaTypesymbol* _tmp82;
						ValaTypesymbol* t;
						if (vala_formal_parameter_get_ellipsis (param)) {
							(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
							break;
						}
						_tmp82 = NULL;
						t = (_tmp82 = vala_data_type_get_data_type (vala_formal_parameter_get_type_reference (param)), (_tmp82 == NULL ? NULL : g_object_ref (_tmp82)));
						if (t != NULL && vala_typesymbol_is_reference_type (t)) {
							if (!vala_data_type_get_is_out (vala_formal_parameter_get_type_reference (param))) {
								ValaCCodeStatement* type_check;
								type_check = vala_ccode_generator_create_method_type_check_statement (self, m, creturn_type, t, (vala_code_context_get_non_null (self->priv->context) && !vala_data_type_get_nullable (vala_formal_parameter_get_type_reference (param))), vala_symbol_get_name (VALA_SYMBOL (param)));
								if (type_check != NULL) {
									vala_ccode_node_set_line (VALA_CCODE_NODE (type_check), vala_ccode_node_get_line (VALA_CCODE_NODE (self->priv->function)));
									vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (type_check));
								}
								(type_check == NULL ? NULL : (type_check = (g_object_unref (type_check), NULL)));
							} else {
								ValaCCodeConstant* _tmp85;
								ValaCCodeUnaryExpression* _tmp84;
								ValaCCodeIdentifier* _tmp83;
								ValaCCodeAssignment* _tmp86;
								ValaCCodeAssignment* a;
								ValaCCodeExpressionStatement* _tmp87;
								/* ensure that the passed reference for output parameter is cleared*/
								_tmp85 = NULL;
								_tmp84 = NULL;
								_tmp83 = NULL;
								_tmp86 = NULL;
								a = (_tmp86 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp84 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, VALA_CCODE_EXPRESSION ((_tmp83 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (param)))))))), VALA_CCODE_EXPRESSION ((_tmp85 = vala_ccode_constant_new ("NULL"))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (_tmp85 == NULL ? NULL : (_tmp85 = (g_object_unref (_tmp85), NULL))), (_tmp84 == NULL ? NULL : (_tmp84 = (g_object_unref (_tmp84), NULL))), (_tmp83 == NULL ? NULL : (_tmp83 = (g_object_unref (_tmp83), NULL))), _tmp86);
								_tmp87 = NULL;
								vala_ccode_fragment_append (cinit, VALA_CCODE_NODE ((_tmp87 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (a)))));
								(_tmp87 == NULL ? NULL : (_tmp87 = (g_object_unref (_tmp87), NULL)));
								(a == NULL ? NULL : (a = (g_object_unref (a), NULL)));
							}
						} else {
							if (VALA_IS_STRUCT (t)) {
								ValaStruct* _tmp88;
								ValaStruct* st;
								_tmp88 = NULL;
								st = (_tmp88 = VALA_STRUCT (t), (_tmp88 == NULL ? NULL : g_object_ref (_tmp88)));
								if (!vala_struct_is_simple_type (st) && !vala_data_type_get_is_ref (vala_formal_parameter_get_type_reference (param)) && !vala_data_type_get_is_out (vala_formal_parameter_get_type_reference (param))) {
									char* _tmp89;
									ValaCCodeDeclaration* _tmp90;
									ValaCCodeDeclaration* cdecl_;
									ValaCCodeVariableDeclarator* _tmp94;
									ValaCCodeUnaryExpression* _tmp93;
									ValaCCodeIdentifier* _tmp92;
									char* _tmp91;
									_tmp89 = NULL;
									_tmp90 = NULL;
									cdecl_ = (_tmp90 = vala_ccode_declaration_new ((_tmp89 = vala_data_type_get_cname (vala_formal_parameter_get_type_reference (param), FALSE, FALSE))), (_tmp89 = (g_free (_tmp89), NULL)), _tmp90);
									_tmp94 = NULL;
									_tmp93 = NULL;
									_tmp92 = NULL;
									_tmp91 = NULL;
									vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp94 = vala_ccode_variable_declarator_new_with_initializer (vala_symbol_get_name (VALA_SYMBOL (param)), VALA_CCODE_EXPRESSION ((_tmp93 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, VALA_CCODE_EXPRESSION ((_tmp92 = vala_ccode_identifier_new ((_tmp91 = g_strdup_printf ("_%s_p", vala_symbol_get_name (VALA_SYMBOL (param))))))))))))));
									(_tmp94 == NULL ? NULL : (_tmp94 = (g_object_unref (_tmp94), NULL)));
									(_tmp93 == NULL ? NULL : (_tmp93 = (g_object_unref (_tmp93), NULL)));
									(_tmp92 == NULL ? NULL : (_tmp92 = (g_object_unref (_tmp92), NULL)));
									(_tmp91 = (g_free (_tmp91), NULL));
									vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (cdecl_));
									(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
								}
								(st == NULL ? NULL : (st = (g_object_unref (st), NULL)));
							}
						}
						(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
						(t == NULL ? NULL : (t = (g_object_unref (t), NULL)));
					}
				}
				(param_collection == NULL ? NULL : (param_collection = (g_object_unref (param_collection), NULL)));
				(param_it == NULL ? NULL : (param_it = (g_object_unref (param_it), NULL)));
			}
			if (inner_error) {
				ValaCCodeDeclaration* cdecl_;
				ValaCCodeVariableDeclarator* _tmp96;
				ValaCCodeConstant* _tmp95;
				/* always separate error parameter and inner_error local variable
				 * as error may be set to NULL but we're always interested in inner errors
				 */
				cdecl_ = vala_ccode_declaration_new ("GError *");
				_tmp96 = NULL;
				_tmp95 = NULL;
				vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp96 = vala_ccode_variable_declarator_new_with_initializer ("inner_error", VALA_CCODE_EXPRESSION ((_tmp95 = vala_ccode_constant_new ("NULL")))))));
				(_tmp96 == NULL ? NULL : (_tmp96 = (g_object_unref (_tmp96), NULL)));
				(_tmp95 == NULL ? NULL : (_tmp95 = (g_object_unref (_tmp95), NULL)));
				vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (cdecl_));
				(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
			}
			if (vala_code_node_get_source_reference (VALA_CODE_NODE (m)) != NULL && vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (m))) != NULL) {
				ValaCCodeComment* _tmp97;
				_tmp97 = NULL;
				vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE ((_tmp97 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (m)))))));
				(_tmp97 == NULL ? NULL : (_tmp97 = (g_object_unref (_tmp97), NULL)));
			}
			vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (self->priv->function));
			if (VALA_IS_CREATION_METHOD (m)) {
				if (in_gobject_creation_method) {
					gint n_params;
					n_params = vala_creation_method_get_n_construction_params ((VALA_CREATION_METHOD (m)));
					if (n_params > 0) {
						ValaCCodeIdentifier* _tmp98;
						ValaCCodeFunctionCall* _tmp99;
						ValaCCodeFunctionCall* cparamsinit;
						ValaCCodeIdentifier* _tmp100;
						ValaCCodeConstant* _tmp102;
						char* _tmp101;
						ValaCCodeDeclaration* cdecl_;
						ValaCCodeVariableDeclarator* _tmp103;
						ValaCCodeDeclaration* _tmp104;
						ValaCCodeVariableDeclarator* _tmp106;
						ValaCCodeIdentifier* _tmp105;
						/* declare construction parameter array*/
						_tmp98 = NULL;
						_tmp99 = NULL;
						cparamsinit = (_tmp99 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp98 = vala_ccode_identifier_new ("g_new0")))), (_tmp98 == NULL ? NULL : (_tmp98 = (g_object_unref (_tmp98), NULL))), _tmp99);
						_tmp100 = NULL;
						vala_ccode_function_call_add_argument (cparamsinit, VALA_CCODE_EXPRESSION ((_tmp100 = vala_ccode_identifier_new ("GParameter"))));
						(_tmp100 == NULL ? NULL : (_tmp100 = (g_object_unref (_tmp100), NULL)));
						_tmp102 = NULL;
						_tmp101 = NULL;
						vala_ccode_function_call_add_argument (cparamsinit, VALA_CCODE_EXPRESSION ((_tmp102 = vala_ccode_constant_new ((_tmp101 = g_strdup_printf ("%i", n_params))))));
						(_tmp102 == NULL ? NULL : (_tmp102 = (g_object_unref (_tmp102), NULL)));
						(_tmp101 = (g_free (_tmp101), NULL));
						cdecl_ = vala_ccode_declaration_new ("GParameter *");
						_tmp103 = NULL;
						vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp103 = vala_ccode_variable_declarator_new_with_initializer ("__params", VALA_CCODE_EXPRESSION (cparamsinit)))));
						(_tmp103 == NULL ? NULL : (_tmp103 = (g_object_unref (_tmp103), NULL)));
						vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (cdecl_));
						_tmp104 = NULL;
						cdecl_ = (_tmp104 = vala_ccode_declaration_new ("GParameter *"), (cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL))), _tmp104);
						_tmp106 = NULL;
						_tmp105 = NULL;
						vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp106 = vala_ccode_variable_declarator_new_with_initializer ("__params_it", VALA_CCODE_EXPRESSION ((_tmp105 = vala_ccode_identifier_new ("__params")))))));
						(_tmp106 == NULL ? NULL : (_tmp106 = (g_object_unref (_tmp106), NULL)));
						(_tmp105 == NULL ? NULL : (_tmp105 = (g_object_unref (_tmp105), NULL)));
						vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (cdecl_));
						(cparamsinit == NULL ? NULL : (cparamsinit = (g_object_unref (cparamsinit), NULL)));
						(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
					}
					{
						GeeCollection* type_param_collection;
						GeeIterator* type_param_it;
						type_param_collection = vala_class_get_type_parameters (self->priv->current_class);
						type_param_it = gee_iterable_iterator (GEE_ITERABLE (type_param_collection));
						while (gee_iterator_next (type_param_it)) {
							ValaTypeParameter* type_param;
							type_param = gee_iterator_get (type_param_it);
							{
								char* func_name;
								ValaCCodeMemberAccess* cmember;
								ValaCCodeAssignment* cassign;
								char* _tmp108;
								char* _tmp107;
								ValaCCodeMemberAccess* _tmp111;
								ValaCCodeMemberAccess* _tmp110;
								ValaCCodeIdentifier* _tmp109;
								ValaCCodeAssignment* _tmp113;
								ValaCCodeIdentifier* _tmp112;
								ValaCCodeExpressionStatement* _tmp114;
								char* _tmp116;
								char* _tmp115;
								ValaCCodeMemberAccess* _tmp119;
								ValaCCodeMemberAccess* _tmp118;
								ValaCCodeIdentifier* _tmp117;
								ValaCCodeAssignment* _tmp121;
								ValaCCodeIdentifier* _tmp120;
								ValaCCodeExpressionStatement* _tmp122;
								char* _tmp124;
								char* _tmp123;
								ValaCCodeMemberAccess* _tmp127;
								ValaCCodeMemberAccess* _tmp126;
								ValaCCodeIdentifier* _tmp125;
								ValaCCodeAssignment* _tmp129;
								ValaCCodeIdentifier* _tmp128;
								ValaCCodeExpressionStatement* _tmp130;
								/* type, dup func, and destroy func properties for generic types */
								func_name = NULL;
								cmember = NULL;
								cassign = NULL;
								_tmp108 = NULL;
								_tmp107 = NULL;
								func_name = (_tmp108 = g_strdup_printf ("%s_type", (_tmp107 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1))), (func_name = (g_free (func_name), NULL)), _tmp108);
								(_tmp107 = (g_free (_tmp107), NULL));
								_tmp111 = NULL;
								_tmp110 = NULL;
								_tmp109 = NULL;
								cmember = (_tmp111 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp110 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp109 = vala_ccode_identifier_new ("self"))), "priv"))), func_name), (cmember == NULL ? NULL : (cmember = (g_object_unref (cmember), NULL))), _tmp111);
								(_tmp110 == NULL ? NULL : (_tmp110 = (g_object_unref (_tmp110), NULL)));
								(_tmp109 == NULL ? NULL : (_tmp109 = (g_object_unref (_tmp109), NULL)));
								_tmp113 = NULL;
								_tmp112 = NULL;
								cassign = (_tmp113 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (cmember), VALA_CCODE_EXPRESSION ((_tmp112 = vala_ccode_identifier_new (func_name))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (cassign == NULL ? NULL : (cassign = (g_object_unref (cassign), NULL))), _tmp113);
								(_tmp112 == NULL ? NULL : (_tmp112 = (g_object_unref (_tmp112), NULL)));
								_tmp114 = NULL;
								vala_ccode_block_add_statement (vala_ccode_function_get_block (self->priv->function), VALA_CCODE_NODE ((_tmp114 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cassign)))));
								(_tmp114 == NULL ? NULL : (_tmp114 = (g_object_unref (_tmp114), NULL)));
								_tmp116 = NULL;
								_tmp115 = NULL;
								func_name = (_tmp116 = g_strdup_printf ("%s_dup_func", (_tmp115 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1))), (func_name = (g_free (func_name), NULL)), _tmp116);
								(_tmp115 = (g_free (_tmp115), NULL));
								_tmp119 = NULL;
								_tmp118 = NULL;
								_tmp117 = NULL;
								cmember = (_tmp119 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp118 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp117 = vala_ccode_identifier_new ("self"))), "priv"))), func_name), (cmember == NULL ? NULL : (cmember = (g_object_unref (cmember), NULL))), _tmp119);
								(_tmp118 == NULL ? NULL : (_tmp118 = (g_object_unref (_tmp118), NULL)));
								(_tmp117 == NULL ? NULL : (_tmp117 = (g_object_unref (_tmp117), NULL)));
								_tmp121 = NULL;
								_tmp120 = NULL;
								cassign = (_tmp121 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (cmember), VALA_CCODE_EXPRESSION ((_tmp120 = vala_ccode_identifier_new (func_name))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (cassign == NULL ? NULL : (cassign = (g_object_unref (cassign), NULL))), _tmp121);
								(_tmp120 == NULL ? NULL : (_tmp120 = (g_object_unref (_tmp120), NULL)));
								_tmp122 = NULL;
								vala_ccode_block_add_statement (vala_ccode_function_get_block (self->priv->function), VALA_CCODE_NODE ((_tmp122 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cassign)))));
								(_tmp122 == NULL ? NULL : (_tmp122 = (g_object_unref (_tmp122), NULL)));
								_tmp124 = NULL;
								_tmp123 = NULL;
								func_name = (_tmp124 = g_strdup_printf ("%s_destroy_func", (_tmp123 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1))), (func_name = (g_free (func_name), NULL)), _tmp124);
								(_tmp123 = (g_free (_tmp123), NULL));
								_tmp127 = NULL;
								_tmp126 = NULL;
								_tmp125 = NULL;
								cmember = (_tmp127 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp126 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp125 = vala_ccode_identifier_new ("self"))), "priv"))), func_name), (cmember == NULL ? NULL : (cmember = (g_object_unref (cmember), NULL))), _tmp127);
								(_tmp126 == NULL ? NULL : (_tmp126 = (g_object_unref (_tmp126), NULL)));
								(_tmp125 == NULL ? NULL : (_tmp125 = (g_object_unref (_tmp125), NULL)));
								_tmp129 = NULL;
								_tmp128 = NULL;
								cassign = (_tmp129 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (cmember), VALA_CCODE_EXPRESSION ((_tmp128 = vala_ccode_identifier_new (func_name))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (cassign == NULL ? NULL : (cassign = (g_object_unref (cassign), NULL))), _tmp129);
								(_tmp128 == NULL ? NULL : (_tmp128 = (g_object_unref (_tmp128), NULL)));
								_tmp130 = NULL;
								vala_ccode_block_add_statement (vala_ccode_function_get_block (self->priv->function), VALA_CCODE_NODE ((_tmp130 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cassign)))));
								(_tmp130 == NULL ? NULL : (_tmp130 = (g_object_unref (_tmp130), NULL)));
								(type_param == NULL ? NULL : (type_param = (g_object_unref (type_param), NULL)));
								(func_name = (g_free (func_name), NULL));
								(cmember == NULL ? NULL : (cmember = (g_object_unref (cmember), NULL)));
								(cassign == NULL ? NULL : (cassign = (g_object_unref (cassign), NULL)));
							}
						}
						(type_param_collection == NULL ? NULL : (type_param_collection = (g_object_unref (type_param_collection), NULL)));
						(type_param_it == NULL ? NULL : (type_param_it = (g_object_unref (type_param_it), NULL)));
					}
				} else {
					if (in_fundamental_creation_method) {
						ValaClass* _tmp131;
						ValaClass* cl;
						char* _tmp133;
						char* _tmp132;
						ValaCCodeDeclaration* _tmp134;
						ValaCCodeDeclaration* cdecl_;
						ValaCCodeIdentifier* _tmp135;
						ValaCCodeFunctionCall* _tmp136;
						ValaCCodeFunctionCall* ccall;
						ValaCCodeIdentifier* _tmp137;
						ValaCCodeVariableDeclarator* _tmp141;
						ValaCCodeCastExpression* _tmp140;
						char* _tmp139;
						char* _tmp138;
						_tmp131 = NULL;
						cl = (_tmp131 = VALA_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (m))), (_tmp131 == NULL ? NULL : g_object_ref (_tmp131)));
						_tmp133 = NULL;
						_tmp132 = NULL;
						_tmp134 = NULL;
						cdecl_ = (_tmp134 = vala_ccode_declaration_new ((_tmp133 = g_strconcat ((_tmp132 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE)), "*", NULL))), (_tmp133 = (g_free (_tmp133), NULL)), (_tmp132 = (g_free (_tmp132), NULL)), _tmp134);
						_tmp135 = NULL;
						_tmp136 = NULL;
						ccall = (_tmp136 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp135 = vala_ccode_identifier_new ("g_type_create_instance")))), (_tmp135 == NULL ? NULL : (_tmp135 = (g_object_unref (_tmp135), NULL))), _tmp136);
						_tmp137 = NULL;
						vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp137 = vala_ccode_identifier_new ("type"))));
						(_tmp137 == NULL ? NULL : (_tmp137 = (g_object_unref (_tmp137), NULL)));
						_tmp141 = NULL;
						_tmp140 = NULL;
						_tmp139 = NULL;
						_tmp138 = NULL;
						vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp141 = vala_ccode_variable_declarator_new_with_initializer ("self", VALA_CCODE_EXPRESSION ((_tmp140 = vala_ccode_cast_expression_new (VALA_CCODE_EXPRESSION (ccall), (_tmp139 = g_strconcat ((_tmp138 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE)), "*", NULL)))))))));
						(_tmp141 == NULL ? NULL : (_tmp141 = (g_object_unref (_tmp141), NULL)));
						(_tmp140 == NULL ? NULL : (_tmp140 = (g_object_unref (_tmp140), NULL)));
						(_tmp139 = (g_free (_tmp139), NULL));
						(_tmp138 = (g_free (_tmp138), NULL));
						vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (cdecl_));
						(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
						(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
						(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
					} else {
						if (in_gtypeinstance_creation_method) {
							ValaClass* _tmp142;
							ValaClass* cl;
							char* _tmp144;
							char* _tmp143;
							ValaCCodeDeclaration* _tmp145;
							ValaCCodeDeclaration* cdecl_;
							ValaClass* fundamental_class;
							ValaCCodeIdentifier* _tmp147;
							char* _tmp146;
							ValaCCodeFunctionCall* _tmp148;
							ValaCCodeFunctionCall* ccall;
							ValaCCodeIdentifier* _tmp150;
							char* _tmp149;
							ValaCCodeVariableDeclarator* _tmp151;
							_tmp142 = NULL;
							cl = (_tmp142 = VALA_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (m))), (_tmp142 == NULL ? NULL : g_object_ref (_tmp142)));
							_tmp144 = NULL;
							_tmp143 = NULL;
							_tmp145 = NULL;
							cdecl_ = (_tmp145 = vala_ccode_declaration_new ((_tmp144 = g_strconcat ((_tmp143 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE)), "*", NULL))), (_tmp144 = (g_free (_tmp144), NULL)), (_tmp143 = (g_free (_tmp143), NULL)), _tmp145);
							fundamental_class = vala_ccode_generator_find_fundamental_class (self, cl);
							_tmp147 = NULL;
							_tmp146 = NULL;
							_tmp148 = NULL;
							ccall = (_tmp148 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp147 = vala_ccode_identifier_new ((_tmp146 = vala_method_get_cname (vala_class_get_default_construction_method (fundamental_class))))))), (_tmp147 == NULL ? NULL : (_tmp147 = (g_object_unref (_tmp147), NULL))), (_tmp146 = (g_free (_tmp146), NULL)), _tmp148);
							_tmp150 = NULL;
							_tmp149 = NULL;
							vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp150 = vala_ccode_identifier_new ((_tmp149 = vala_typesymbol_get_type_id (VALA_TYPESYMBOL (cl)))))));
							(_tmp150 == NULL ? NULL : (_tmp150 = (g_object_unref (_tmp150), NULL)));
							(_tmp149 = (g_free (_tmp149), NULL));
							_tmp151 = NULL;
							vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp151 = vala_ccode_variable_declarator_new_with_initializer ("self", VALA_CCODE_EXPRESSION (ccall)))));
							(_tmp151 == NULL ? NULL : (_tmp151 = (g_object_unref (_tmp151), NULL)));
							vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (cdecl_));
							(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
							(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
							(fundamental_class == NULL ? NULL : (fundamental_class = (g_object_unref (fundamental_class), NULL)));
							(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
						} else {
							if (VALA_IS_CLASS (self->current_type_symbol)) {
								ValaClass* _tmp152;
								ValaClass* cl;
								char* _tmp154;
								char* _tmp153;
								ValaCCodeDeclaration* _tmp155;
								ValaCCodeDeclaration* cdecl_;
								ValaCCodeIdentifier* _tmp156;
								ValaCCodeFunctionCall* _tmp157;
								ValaCCodeFunctionCall* ccall;
								ValaCCodeIdentifier* _tmp159;
								char* _tmp158;
								ValaCCodeVariableDeclarator* _tmp160;
								_tmp152 = NULL;
								cl = (_tmp152 = VALA_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (m))), (_tmp152 == NULL ? NULL : g_object_ref (_tmp152)));
								_tmp154 = NULL;
								_tmp153 = NULL;
								_tmp155 = NULL;
								cdecl_ = (_tmp155 = vala_ccode_declaration_new ((_tmp154 = g_strconcat ((_tmp153 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE)), "*", NULL))), (_tmp154 = (g_free (_tmp154), NULL)), (_tmp153 = (g_free (_tmp153), NULL)), _tmp155);
								_tmp156 = NULL;
								_tmp157 = NULL;
								ccall = (_tmp157 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp156 = vala_ccode_identifier_new ("g_slice_new0")))), (_tmp156 == NULL ? NULL : (_tmp156 = (g_object_unref (_tmp156), NULL))), _tmp157);
								_tmp159 = NULL;
								_tmp158 = NULL;
								vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp159 = vala_ccode_identifier_new ((_tmp158 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE))))));
								(_tmp159 == NULL ? NULL : (_tmp159 = (g_object_unref (_tmp159), NULL)));
								(_tmp158 = (g_free (_tmp158), NULL));
								_tmp160 = NULL;
								vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp160 = vala_ccode_variable_declarator_new_with_initializer ("self", VALA_CCODE_EXPRESSION (ccall)))));
								(_tmp160 == NULL ? NULL : (_tmp160 = (g_object_unref (_tmp160), NULL)));
								vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (cdecl_));
								(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
								(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
								(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
							} else {
								ValaStruct* _tmp161;
								ValaStruct* st;
								ValaCCodeIdentifier* _tmp162;
								ValaCCodeFunctionCall* _tmp163;
								ValaCCodeFunctionCall* czero;
								ValaCCodeIdentifier* _tmp164;
								ValaCCodeConstant* _tmp165;
								ValaCCodeIdentifier* _tmp168;
								char* _tmp167;
								char* _tmp166;
								ValaCCodeExpressionStatement* _tmp169;
								_tmp161 = NULL;
								st = (_tmp161 = VALA_STRUCT (vala_symbol_get_parent_symbol (VALA_SYMBOL (m))), (_tmp161 == NULL ? NULL : g_object_ref (_tmp161)));
								/* memset needs string.h*/
								self->priv->string_h_needed = TRUE;
								_tmp162 = NULL;
								_tmp163 = NULL;
								czero = (_tmp163 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp162 = vala_ccode_identifier_new ("memset")))), (_tmp162 == NULL ? NULL : (_tmp162 = (g_object_unref (_tmp162), NULL))), _tmp163);
								_tmp164 = NULL;
								vala_ccode_function_call_add_argument (czero, VALA_CCODE_EXPRESSION ((_tmp164 = vala_ccode_identifier_new ("self"))));
								(_tmp164 == NULL ? NULL : (_tmp164 = (g_object_unref (_tmp164), NULL)));
								_tmp165 = NULL;
								vala_ccode_function_call_add_argument (czero, VALA_CCODE_EXPRESSION ((_tmp165 = vala_ccode_constant_new ("0"))));
								(_tmp165 == NULL ? NULL : (_tmp165 = (g_object_unref (_tmp165), NULL)));
								_tmp168 = NULL;
								_tmp167 = NULL;
								_tmp166 = NULL;
								vala_ccode_function_call_add_argument (czero, VALA_CCODE_EXPRESSION ((_tmp168 = vala_ccode_identifier_new ((_tmp167 = g_strdup_printf ("sizeof (%s)", (_tmp166 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (st), FALSE))))))));
								(_tmp168 == NULL ? NULL : (_tmp168 = (g_object_unref (_tmp168), NULL)));
								(_tmp167 = (g_free (_tmp167), NULL));
								(_tmp166 = (g_free (_tmp166), NULL));
								_tmp169 = NULL;
								vala_ccode_fragment_append (cinit, VALA_CCODE_NODE ((_tmp169 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (czero)))));
								(_tmp169 == NULL ? NULL : (_tmp169 = (g_object_unref (_tmp169), NULL)));
								(st == NULL ? NULL : (st = (g_object_unref (st), NULL)));
								(czero == NULL ? NULL : (czero = (g_object_unref (czero), NULL)));
							}
						}
					}
				}
			}
			if (vala_code_context_get_module_init_method (self->priv->context) == m && self->priv->in_plugin) {
				/* GTypeModule-based plug-in, register types*/
				vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (self->priv->module_init_fragment));
			}
			{
				GeeCollection* precondition_collection;
				GeeIterator* precondition_it;
				precondition_collection = vala_method_get_preconditions (m);
				precondition_it = gee_iterable_iterator (GEE_ITERABLE (precondition_collection));
				while (gee_iterator_next (precondition_it)) {
					ValaExpression* precondition;
					precondition = gee_iterator_get (precondition_it);
					{
						ValaCCodeStatement* _tmp170;
						_tmp170 = NULL;
						vala_ccode_fragment_append (cinit, VALA_CCODE_NODE ((_tmp170 = vala_ccode_generator_create_precondition_statement (self, VALA_CODE_NODE (m), creturn_type, precondition))));
						(_tmp170 == NULL ? NULL : (_tmp170 = (g_object_unref (_tmp170), NULL)));
						(precondition == NULL ? NULL : (precondition = (g_object_unref (precondition), NULL)));
					}
				}
				(precondition_collection == NULL ? NULL : (precondition_collection = (g_object_unref (precondition_collection), NULL)));
				(precondition_it == NULL ? NULL : (precondition_it = (g_object_unref (precondition_it), NULL)));
			}
			(cinit == NULL ? NULL : (cinit = (g_object_unref (cinit), NULL)));
		}
	}
	if (vala_method_get_is_abstract (m) || vala_method_get_is_virtual (m)) {
		char* _tmp172;
		char* _tmp171;
		ValaCCodeFunction* _tmp173;
		ValaCCodeFunction* vfunc;
		ValaReferenceType* this_type;
		char* _tmp176;
		ValaCCodeFormalParameter* _tmp177;
		ValaCCodeFormalParameter* cparam;
		ValaCCodeBlock* vblock;
		ValaCCodeFunctionCall* vcast;
		ValaCCodeIdentifier* _tmp189;
		ValaCCodeMemberAccess* _tmp190;
		ValaCCodeFunctionCall* _tmp191;
		ValaCCodeFunctionCall* vcall;
		ValaCCodeIdentifier* _tmp192;
		GeeCollection* params;
		GeeCollection* _tmp203;
		gboolean _tmp204;
		ValaCCodeStatement* cstmt;
		_tmp172 = NULL;
		_tmp171 = NULL;
		_tmp173 = NULL;
		vfunc = (_tmp173 = vala_ccode_function_new ((_tmp171 = vala_method_get_cname (m)), (_tmp172 = vala_data_type_get_cname (creturn_type, FALSE, FALSE))), (_tmp172 = (g_free (_tmp172), NULL)), (_tmp171 = (g_free (_tmp171), NULL)), _tmp173);
		vala_ccode_node_set_line (VALA_CCODE_NODE (vfunc), vala_ccode_node_get_line (VALA_CCODE_NODE (self->priv->function)));
		this_type = NULL;
		if (VALA_IS_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (m)))) {
			ValaReferenceType* _tmp174;
			_tmp174 = NULL;
			this_type = (_tmp174 = VALA_REFERENCE_TYPE (vala_class_type_new (VALA_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (m))))), (this_type == NULL ? NULL : (this_type = (g_object_unref (this_type), NULL))), _tmp174);
		} else {
			ValaReferenceType* _tmp175;
			_tmp175 = NULL;
			this_type = (_tmp175 = VALA_REFERENCE_TYPE (vala_interface_type_new (VALA_INTERFACE (vala_symbol_get_parent_symbol (VALA_SYMBOL (m))))), (this_type == NULL ? NULL : (this_type = (g_object_unref (this_type), NULL))), _tmp175);
		}
		_tmp176 = NULL;
		_tmp177 = NULL;
		cparam = (_tmp177 = vala_ccode_formal_parameter_new ("self", (_tmp176 = vala_data_type_get_cname (VALA_DATA_TYPE (this_type), FALSE, FALSE))), (_tmp176 = (g_free (_tmp176), NULL)), _tmp177);
		vala_ccode_function_add_parameter (vfunc, cparam);
		vblock = vala_ccode_block_new ();
		{
			GeeCollection* precondition_collection;
			GeeIterator* precondition_it;
			precondition_collection = vala_method_get_preconditions (m);
			precondition_it = gee_iterable_iterator (GEE_ITERABLE (precondition_collection));
			while (gee_iterator_next (precondition_it)) {
				ValaExpression* precondition;
				precondition = gee_iterator_get (precondition_it);
				{
					ValaCCodeStatement* _tmp178;
					_tmp178 = NULL;
					vala_ccode_block_add_statement (vblock, VALA_CCODE_NODE ((_tmp178 = vala_ccode_generator_create_precondition_statement (self, VALA_CODE_NODE (m), creturn_type, precondition))));
					(_tmp178 == NULL ? NULL : (_tmp178 = (g_object_unref (_tmp178), NULL)));
					(precondition == NULL ? NULL : (precondition = (g_object_unref (precondition), NULL)));
				}
			}
			(precondition_collection == NULL ? NULL : (precondition_collection = (g_object_unref (precondition_collection), NULL)));
			(precondition_it == NULL ? NULL : (precondition_it = (g_object_unref (precondition_it), NULL)));
		}
		vcast = NULL;
		if (VALA_IS_INTERFACE (vala_symbol_get_parent_symbol (VALA_SYMBOL (m)))) {
			ValaInterface* _tmp179;
			ValaInterface* iface;
			ValaCCodeFunctionCall* _tmp183;
			ValaCCodeIdentifier* _tmp182;
			char* _tmp181;
			char* _tmp180;
			_tmp179 = NULL;
			iface = (_tmp179 = VALA_INTERFACE (vala_symbol_get_parent_symbol (VALA_SYMBOL (m))), (_tmp179 == NULL ? NULL : g_object_ref (_tmp179)));
			_tmp183 = NULL;
			_tmp182 = NULL;
			_tmp181 = NULL;
			_tmp180 = NULL;
			vcast = (_tmp183 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp182 = vala_ccode_identifier_new ((_tmp181 = g_strdup_printf ("%s_GET_INTERFACE", (_tmp180 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (iface), NULL)))))))), (vcast == NULL ? NULL : (vcast = (g_object_unref (vcast), NULL))), _tmp183);
			(_tmp182 == NULL ? NULL : (_tmp182 = (g_object_unref (_tmp182), NULL)));
			(_tmp181 = (g_free (_tmp181), NULL));
			(_tmp180 = (g_free (_tmp180), NULL));
			(iface == NULL ? NULL : (iface = (g_object_unref (iface), NULL)));
		} else {
			ValaClass* _tmp184;
			ValaClass* cl;
			ValaCCodeFunctionCall* _tmp188;
			ValaCCodeIdentifier* _tmp187;
			char* _tmp186;
			char* _tmp185;
			_tmp184 = NULL;
			cl = (_tmp184 = VALA_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (m))), (_tmp184 == NULL ? NULL : g_object_ref (_tmp184)));
			_tmp188 = NULL;
			_tmp187 = NULL;
			_tmp186 = NULL;
			_tmp185 = NULL;
			vcast = (_tmp188 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp187 = vala_ccode_identifier_new ((_tmp186 = g_strdup_printf ("%s_GET_CLASS", (_tmp185 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (cl), NULL)))))))), (vcast == NULL ? NULL : (vcast = (g_object_unref (vcast), NULL))), _tmp188);
			(_tmp187 == NULL ? NULL : (_tmp187 = (g_object_unref (_tmp187), NULL)));
			(_tmp186 = (g_free (_tmp186), NULL));
			(_tmp185 = (g_free (_tmp185), NULL));
			(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
		}
		_tmp189 = NULL;
		vala_ccode_function_call_add_argument (vcast, VALA_CCODE_EXPRESSION ((_tmp189 = vala_ccode_identifier_new ("self"))));
		(_tmp189 == NULL ? NULL : (_tmp189 = (g_object_unref (_tmp189), NULL)));
		_tmp190 = NULL;
		_tmp191 = NULL;
		vcall = (_tmp191 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp190 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vcast), vala_method_get_vfunc_name (m))))), (_tmp190 == NULL ? NULL : (_tmp190 = (g_object_unref (_tmp190), NULL))), _tmp191);
		_tmp192 = NULL;
		vala_ccode_function_call_add_argument (vcall, VALA_CCODE_EXPRESSION ((_tmp192 = vala_ccode_identifier_new ("self"))));
		(_tmp192 == NULL ? NULL : (_tmp192 = (g_object_unref (_tmp192), NULL)));
		params = vala_method_get_parameters (m);
		{
			GeeCollection* param_collection;
			GeeIterator* param_it;
			param_collection = params;
			param_it = gee_iterable_iterator (GEE_ITERABLE (param_collection));
			while (gee_iterator_next (param_it)) {
				ValaFormalParameter* param;
				param = gee_iterator_get (param_it);
				{
					ValaCCodeIdentifier* _tmp198;
					if (!vala_formal_parameter_get_no_array_length (param) && VALA_IS_ARRAY (vala_data_type_get_data_type (vala_formal_parameter_get_type_reference (param)))) {
						ValaArray* _tmp193;
						ValaArray* arr;
						char* length_ctype;
						_tmp193 = NULL;
						arr = (_tmp193 = VALA_ARRAY (vala_data_type_get_data_type (vala_formal_parameter_get_type_reference (param))), (_tmp193 == NULL ? NULL : g_object_ref (_tmp193)));
						length_ctype = g_strdup ("int");
						if (vala_data_type_get_is_out (vala_formal_parameter_get_type_reference (param)) || vala_data_type_get_is_ref (vala_formal_parameter_get_type_reference (param))) {
							char* _tmp194;
							_tmp194 = NULL;
							length_ctype = (_tmp194 = g_strdup ("int*"), (length_ctype = (g_free (length_ctype), NULL)), _tmp194);
						}
						{
							gint dim;
							dim = 0;
							for (dim = 1; dim <= vala_array_get_rank (arr); dim++) {
								char* _tmp195;
								ValaCCodeFormalParameter* _tmp196;
								ValaCCodeFormalParameter* cparam;
								ValaCCodeIdentifier* _tmp197;
								_tmp195 = NULL;
								_tmp196 = NULL;
								cparam = (_tmp196 = vala_ccode_formal_parameter_new ((_tmp195 = vala_ccode_generator_get_array_length_cname (self, vala_symbol_get_name (VALA_SYMBOL (param)), dim)), length_ctype), (_tmp195 = (g_free (_tmp195), NULL)), _tmp196);
								vala_ccode_function_add_parameter (vfunc, cparam);
								_tmp197 = NULL;
								vala_ccode_function_call_add_argument (vcall, VALA_CCODE_EXPRESSION ((_tmp197 = vala_ccode_identifier_new (vala_ccode_formal_parameter_get_name (cparam)))));
								(_tmp197 == NULL ? NULL : (_tmp197 = (g_object_unref (_tmp197), NULL)));
								(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
							}
						}
						(arr == NULL ? NULL : (arr = (g_object_unref (arr), NULL)));
						(length_ctype = (g_free (length_ctype), NULL));
					}
					vala_ccode_function_add_parameter (vfunc, VALA_CCODE_FORMAL_PARAMETER (vala_code_node_get_ccodenode (VALA_CODE_NODE (param))));
					_tmp198 = NULL;
					vala_ccode_function_call_add_argument (vcall, VALA_CCODE_EXPRESSION ((_tmp198 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (param))))));
					(_tmp198 == NULL ? NULL : (_tmp198 = (g_object_unref (_tmp198), NULL)));
					(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
				}
			}
			(param_it == NULL ? NULL : (param_it = (g_object_unref (param_it), NULL)));
		}
		/* return array length if appropriate*/
		if (!vala_method_get_no_array_length (m) && VALA_IS_ARRAY (vala_data_type_get_data_type (creturn_type))) {
			ValaArray* _tmp199;
			ValaArray* arr;
			_tmp199 = NULL;
			arr = (_tmp199 = VALA_ARRAY (vala_data_type_get_data_type (creturn_type)), (_tmp199 == NULL ? NULL : g_object_ref (_tmp199)));
			{
				gint dim;
				dim = 0;
				for (dim = 1; dim <= vala_array_get_rank (arr); dim++) {
					char* _tmp200;
					ValaCCodeFormalParameter* _tmp201;
					ValaCCodeFormalParameter* cparam;
					ValaCCodeIdentifier* _tmp202;
					_tmp200 = NULL;
					_tmp201 = NULL;
					cparam = (_tmp201 = vala_ccode_formal_parameter_new ((_tmp200 = vala_ccode_generator_get_array_length_cname (self, "result", dim)), "int*"), (_tmp200 = (g_free (_tmp200), NULL)), _tmp201);
					vala_ccode_function_add_parameter (vfunc, cparam);
					_tmp202 = NULL;
					vala_ccode_function_call_add_argument (vcall, VALA_CCODE_EXPRESSION ((_tmp202 = vala_ccode_identifier_new (vala_ccode_formal_parameter_get_name (cparam)))));
					(_tmp202 == NULL ? NULL : (_tmp202 = (g_object_unref (_tmp202), NULL)));
					(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
				}
			}
			(arr == NULL ? NULL : (arr = (g_object_unref (arr), NULL)));
		}
		_tmp203 = NULL;
		if ((_tmp204 = gee_collection_get_size ((_tmp203 = vala_method_get_error_domains (m))) > 0, (_tmp203 == NULL ? NULL : (_tmp203 = (g_object_unref (_tmp203), NULL))), _tmp204)) {
			ValaCCodeFormalParameter* cparam;
			ValaCCodeIdentifier* _tmp205;
			cparam = vala_ccode_formal_parameter_new ("error", "GError**");
			vala_ccode_function_add_parameter (vfunc, cparam);
			_tmp205 = NULL;
			vala_ccode_function_call_add_argument (vcall, VALA_CCODE_EXPRESSION ((_tmp205 = vala_ccode_identifier_new (vala_ccode_formal_parameter_get_name (cparam)))));
			(_tmp205 == NULL ? NULL : (_tmp205 = (g_object_unref (_tmp205), NULL)));
			(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
		}
		cstmt = NULL;
		if (VALA_IS_VOID_TYPE (creturn_type)) {
			ValaCCodeStatement* _tmp206;
			_tmp206 = NULL;
			cstmt = (_tmp206 = VALA_CCODE_STATEMENT (vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vcall))), (cstmt == NULL ? NULL : (cstmt = (g_object_unref (cstmt), NULL))), _tmp206);
		} else {
			char* _tmp207;
			ValaCCodeDeclaration* _tmp208;
			ValaCCodeDeclaration* cdecl_;
			ValaCCodeVariableDeclarator* _tmp209;
			ValaCCodeStatement* _tmp211;
			ValaCCodeDeclaration* _tmp210;
			/* store method return value */
			_tmp207 = NULL;
			_tmp208 = NULL;
			cdecl_ = (_tmp208 = vala_ccode_declaration_new ((_tmp207 = vala_data_type_get_cname (creturn_type, FALSE, FALSE))), (_tmp207 = (g_free (_tmp207), NULL)), _tmp208);
			_tmp209 = NULL;
			vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp209 = vala_ccode_variable_declarator_new_with_initializer ("result", VALA_CCODE_EXPRESSION (vcall)))));
			(_tmp209 == NULL ? NULL : (_tmp209 = (g_object_unref (_tmp209), NULL)));
			_tmp211 = NULL;
			_tmp210 = NULL;
			cstmt = (_tmp211 = VALA_CCODE_STATEMENT ((_tmp210 = cdecl_, (_tmp210 == NULL ? NULL : g_object_ref (_tmp210)))), (cstmt == NULL ? NULL : (cstmt = (g_object_unref (cstmt), NULL))), _tmp211);
			(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
		}
		vala_ccode_node_set_line (VALA_CCODE_NODE (cstmt), vala_ccode_node_get_line (VALA_CCODE_NODE (vfunc)));
		vala_ccode_block_add_statement (vblock, VALA_CCODE_NODE (cstmt));
		{
			GeeCollection* postcondition_collection;
			GeeIterator* postcondition_it;
			postcondition_collection = vala_method_get_postconditions (m);
			postcondition_it = gee_iterable_iterator (GEE_ITERABLE (postcondition_collection));
			while (gee_iterator_next (postcondition_it)) {
				ValaExpression* postcondition;
				postcondition = gee_iterator_get (postcondition_it);
				{
					ValaCCodeStatement* _tmp212;
					_tmp212 = NULL;
					vala_ccode_block_add_statement (vblock, VALA_CCODE_NODE ((_tmp212 = vala_ccode_generator_create_postcondition_statement (self, postcondition))));
					(_tmp212 == NULL ? NULL : (_tmp212 = (g_object_unref (_tmp212), NULL)));
					(postcondition == NULL ? NULL : (postcondition = (g_object_unref (postcondition), NULL)));
				}
			}
			(postcondition_collection == NULL ? NULL : (postcondition_collection = (g_object_unref (postcondition_collection), NULL)));
			(postcondition_it == NULL ? NULL : (postcondition_it = (g_object_unref (postcondition_it), NULL)));
		}
		if (!(VALA_IS_VOID_TYPE (creturn_type))) {
			ValaCCodeIdentifier* _tmp213;
			ValaCCodeReturnStatement* _tmp214;
			ValaCCodeReturnStatement* cret_stmt;
			_tmp213 = NULL;
			_tmp214 = NULL;
			cret_stmt = (_tmp214 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION ((_tmp213 = vala_ccode_identifier_new ("result")))), (_tmp213 == NULL ? NULL : (_tmp213 = (g_object_unref (_tmp213), NULL))), _tmp214);
			vala_ccode_node_set_line (VALA_CCODE_NODE (cret_stmt), vala_ccode_node_get_line (VALA_CCODE_NODE (vfunc)));
			vala_ccode_block_add_statement (vblock, VALA_CCODE_NODE (cret_stmt));
			(cret_stmt == NULL ? NULL : (cret_stmt = (g_object_unref (cret_stmt), NULL)));
		}
		if (visible) {
			ValaCCodeFunction* _tmp215;
			_tmp215 = NULL;
			vala_ccode_fragment_append (self->priv->header_type_member_declaration, VALA_CCODE_NODE ((_tmp215 = vala_ccode_function_copy (vfunc))));
			(_tmp215 == NULL ? NULL : (_tmp215 = (g_object_unref (_tmp215), NULL)));
		} else {
			ValaCCodeFunction* _tmp216;
			vala_ccode_function_set_modifiers (vfunc, vala_ccode_function_get_modifiers (vfunc) | (VALA_CCODE_MODIFIERS_STATIC));
			_tmp216 = NULL;
			vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE ((_tmp216 = vala_ccode_function_copy (vfunc))));
			(_tmp216 == NULL ? NULL : (_tmp216 = (g_object_unref (_tmp216), NULL)));
		}
		vala_ccode_function_set_block (vfunc, vblock);
		if (vala_method_get_is_abstract (m) && vala_code_node_get_source_reference (VALA_CODE_NODE (m)) != NULL && vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (m))) != NULL) {
			ValaCCodeComment* _tmp217;
			_tmp217 = NULL;
			vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE ((_tmp217 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (m)))))));
			(_tmp217 == NULL ? NULL : (_tmp217 = (g_object_unref (_tmp217), NULL)));
		}
		vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (vfunc));
		(vfunc == NULL ? NULL : (vfunc = (g_object_unref (vfunc), NULL)));
		(this_type == NULL ? NULL : (this_type = (g_object_unref (this_type), NULL)));
		(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
		(vblock == NULL ? NULL : (vblock = (g_object_unref (vblock), NULL)));
		(vcast == NULL ? NULL : (vcast = (g_object_unref (vcast), NULL)));
		(vcall == NULL ? NULL : (vcall = (g_object_unref (vcall), NULL)));
		(params == NULL ? NULL : (params = (g_object_unref (params), NULL)));
		(cstmt == NULL ? NULL : (cstmt = (g_object_unref (cstmt), NULL)));
	}
	if (VALA_IS_CREATION_METHOD (m)) {
		if (vala_creation_method_get_n_construction_params ((VALA_CREATION_METHOD (m))) > 0) {
			ValaCCodeIdentifier* _tmp219;
			ValaCCodeIdentifier* _tmp218;
			ValaCCodeBinaryExpression* _tmp220;
			ValaCCodeBinaryExpression* ccond;
			ValaCCodeBlock* cdofreeparam;
			ValaCCodeExpressionStatement* _tmp223;
			ValaCCodeUnaryExpression* _tmp222;
			ValaCCodeIdentifier* _tmp221;
			ValaCCodeIdentifier* _tmp224;
			ValaCCodeFunctionCall* _tmp225;
			ValaCCodeFunctionCall* cunsetcall;
			ValaCCodeUnaryExpression* _tmp228;
			ValaCCodeMemberAccess* _tmp227;
			ValaCCodeIdentifier* _tmp226;
			ValaCCodeExpressionStatement* _tmp229;
			ValaCCodeWhileStatement* _tmp230;
			ValaCCodeIdentifier* _tmp231;
			ValaCCodeFunctionCall* _tmp232;
			ValaCCodeFunctionCall* cfreeparams;
			ValaCCodeIdentifier* _tmp233;
			ValaCCodeExpressionStatement* _tmp234;
			_tmp219 = NULL;
			_tmp218 = NULL;
			_tmp220 = NULL;
			ccond = (_tmp220 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN, VALA_CCODE_EXPRESSION ((_tmp218 = vala_ccode_identifier_new ("__params_it"))), VALA_CCODE_EXPRESSION ((_tmp219 = vala_ccode_identifier_new ("__params")))), (_tmp219 == NULL ? NULL : (_tmp219 = (g_object_unref (_tmp219), NULL))), (_tmp218 == NULL ? NULL : (_tmp218 = (g_object_unref (_tmp218), NULL))), _tmp220);
			cdofreeparam = vala_ccode_block_new ();
			_tmp223 = NULL;
			_tmp222 = NULL;
			_tmp221 = NULL;
			vala_ccode_block_add_statement (cdofreeparam, VALA_CCODE_NODE ((_tmp223 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp222 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_PREFIX_DECREMENT, VALA_CCODE_EXPRESSION ((_tmp221 = vala_ccode_identifier_new ("__params_it"))))))))));
			(_tmp223 == NULL ? NULL : (_tmp223 = (g_object_unref (_tmp223), NULL)));
			(_tmp222 == NULL ? NULL : (_tmp222 = (g_object_unref (_tmp222), NULL)));
			(_tmp221 == NULL ? NULL : (_tmp221 = (g_object_unref (_tmp221), NULL)));
			_tmp224 = NULL;
			_tmp225 = NULL;
			cunsetcall = (_tmp225 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp224 = vala_ccode_identifier_new ("g_value_unset")))), (_tmp224 == NULL ? NULL : (_tmp224 = (g_object_unref (_tmp224), NULL))), _tmp225);
			_tmp228 = NULL;
			_tmp227 = NULL;
			_tmp226 = NULL;
			vala_ccode_function_call_add_argument (cunsetcall, VALA_CCODE_EXPRESSION ((_tmp228 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp227 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp226 = vala_ccode_identifier_new ("__params_it"))), "value")))))));
			(_tmp228 == NULL ? NULL : (_tmp228 = (g_object_unref (_tmp228), NULL)));
			(_tmp227 == NULL ? NULL : (_tmp227 = (g_object_unref (_tmp227), NULL)));
			(_tmp226 == NULL ? NULL : (_tmp226 = (g_object_unref (_tmp226), NULL)));
			_tmp229 = NULL;
			vala_ccode_block_add_statement (cdofreeparam, VALA_CCODE_NODE ((_tmp229 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cunsetcall)))));
			(_tmp229 == NULL ? NULL : (_tmp229 = (g_object_unref (_tmp229), NULL)));
			_tmp230 = NULL;
			vala_ccode_block_add_statement (vala_ccode_function_get_block (self->priv->function), VALA_CCODE_NODE ((_tmp230 = vala_ccode_while_statement_new (VALA_CCODE_EXPRESSION (ccond), VALA_CCODE_STATEMENT (cdofreeparam)))));
			(_tmp230 == NULL ? NULL : (_tmp230 = (g_object_unref (_tmp230), NULL)));
			_tmp231 = NULL;
			_tmp232 = NULL;
			cfreeparams = (_tmp232 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp231 = vala_ccode_identifier_new ("g_free")))), (_tmp231 == NULL ? NULL : (_tmp231 = (g_object_unref (_tmp231), NULL))), _tmp232);
			_tmp233 = NULL;
			vala_ccode_function_call_add_argument (cfreeparams, VALA_CCODE_EXPRESSION ((_tmp233 = vala_ccode_identifier_new ("__params"))));
			(_tmp233 == NULL ? NULL : (_tmp233 = (g_object_unref (_tmp233), NULL)));
			_tmp234 = NULL;
			vala_ccode_block_add_statement (vala_ccode_function_get_block (self->priv->function), VALA_CCODE_NODE ((_tmp234 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cfreeparams)))));
			(_tmp234 == NULL ? NULL : (_tmp234 = (g_object_unref (_tmp234), NULL)));
			(ccond == NULL ? NULL : (ccond = (g_object_unref (ccond), NULL)));
			(cdofreeparam == NULL ? NULL : (cdofreeparam = (g_object_unref (cdofreeparam), NULL)));
			(cunsetcall == NULL ? NULL : (cunsetcall = (g_object_unref (cunsetcall), NULL)));
			(cfreeparams == NULL ? NULL : (cfreeparams = (g_object_unref (cfreeparams), NULL)));
		}
		if (VALA_IS_CLASS (self->current_type_symbol)) {
			ValaCCodeReturnStatement* creturn;
			ValaCCodeIdentifier* _tmp235;
			creturn = vala_ccode_return_statement_new (NULL);
			_tmp235 = NULL;
			vala_ccode_return_statement_set_return_expression (creturn, VALA_CCODE_EXPRESSION ((_tmp235 = vala_ccode_identifier_new ("self"))));
			(_tmp235 == NULL ? NULL : (_tmp235 = (g_object_unref (_tmp235), NULL)));
			vala_ccode_block_add_statement (vala_ccode_function_get_block (self->priv->function), VALA_CCODE_NODE (creturn));
			(creturn == NULL ? NULL : (creturn = (g_object_unref (creturn), NULL)));
		}
	}
	return_value = TRUE;
	args_parameter = TRUE;
	if (vala_ccode_generator_is_possible_entry_point (self, m, &return_value, &args_parameter)) {
		ValaCCodeFunction* cmain;
		ValaCCodeFormalParameter* _tmp236;
		ValaCCodeFormalParameter* _tmp237;
		ValaCCodeBlock* main_block;
		ValaCCodeFunctionCall* _tmp243;
		ValaCCodeIdentifier* _tmp242;
		ValaCCodeExpressionStatement* _tmp244;
		ValaCCodeExpressionStatement* type_init_call;
		ValaCCodeIdentifier* _tmp245;
		ValaCCodeFunctionCall* _tmp246;
		ValaCCodeFunctionCall* main_call;
		/* m is possible entry point, add appropriate startup code*/
		cmain = vala_ccode_function_new ("main", "int");
		vala_ccode_node_set_line (VALA_CCODE_NODE (cmain), vala_ccode_node_get_line (VALA_CCODE_NODE (self->priv->function)));
		_tmp236 = NULL;
		vala_ccode_function_add_parameter (cmain, (_tmp236 = vala_ccode_formal_parameter_new ("argc", "int")));
		(_tmp236 == NULL ? NULL : (_tmp236 = (g_object_unref (_tmp236), NULL)));
		_tmp237 = NULL;
		vala_ccode_function_add_parameter (cmain, (_tmp237 = vala_ccode_formal_parameter_new ("argv", "char **")));
		(_tmp237 == NULL ? NULL : (_tmp237 = (g_object_unref (_tmp237), NULL)));
		main_block = vala_ccode_block_new ();
		if (vala_code_context_get_thread (self->priv->context)) {
			ValaCCodeIdentifier* _tmp238;
			ValaCCodeFunctionCall* _tmp239;
			ValaCCodeFunctionCall* thread_init_call;
			ValaCCodeConstant* _tmp240;
			ValaCCodeExpressionStatement* _tmp241;
			_tmp238 = NULL;
			_tmp239 = NULL;
			thread_init_call = (_tmp239 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp238 = vala_ccode_identifier_new ("g_thread_init")))), (_tmp238 == NULL ? NULL : (_tmp238 = (g_object_unref (_tmp238), NULL))), _tmp239);
			vala_ccode_node_set_line (VALA_CCODE_NODE (thread_init_call), vala_ccode_node_get_line (VALA_CCODE_NODE (cmain)));
			_tmp240 = NULL;
			vala_ccode_function_call_add_argument (thread_init_call, VALA_CCODE_EXPRESSION ((_tmp240 = vala_ccode_constant_new ("NULL"))));
			(_tmp240 == NULL ? NULL : (_tmp240 = (g_object_unref (_tmp240), NULL)));
			_tmp241 = NULL;
			vala_ccode_block_add_statement (main_block, VALA_CCODE_NODE ((_tmp241 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (thread_init_call)))));
			(_tmp241 == NULL ? NULL : (_tmp241 = (g_object_unref (_tmp241), NULL)));
			(thread_init_call == NULL ? NULL : (thread_init_call = (g_object_unref (thread_init_call), NULL)));
		}
		_tmp243 = NULL;
		_tmp242 = NULL;
		_tmp244 = NULL;
		type_init_call = (_tmp244 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp243 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp242 = vala_ccode_identifier_new ("g_type_init"))))))), (_tmp243 == NULL ? NULL : (_tmp243 = (g_object_unref (_tmp243), NULL))), (_tmp242 == NULL ? NULL : (_tmp242 = (g_object_unref (_tmp242), NULL))), _tmp244);
		vala_ccode_node_set_line (VALA_CCODE_NODE (type_init_call), vala_ccode_node_get_line (VALA_CCODE_NODE (cmain)));
		vala_ccode_block_add_statement (main_block, VALA_CCODE_NODE (type_init_call));
		_tmp245 = NULL;
		_tmp246 = NULL;
		main_call = (_tmp246 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp245 = vala_ccode_identifier_new (vala_ccode_function_get_name (self->priv->function))))), (_tmp245 == NULL ? NULL : (_tmp245 = (g_object_unref (_tmp245), NULL))), _tmp246);
		if (args_parameter) {
			ValaCCodeIdentifier* _tmp247;
			ValaCCodeIdentifier* _tmp248;
			_tmp247 = NULL;
			vala_ccode_function_call_add_argument (main_call, VALA_CCODE_EXPRESSION ((_tmp247 = vala_ccode_identifier_new ("argc"))));
			(_tmp247 == NULL ? NULL : (_tmp247 = (g_object_unref (_tmp247), NULL)));
			_tmp248 = NULL;
			vala_ccode_function_call_add_argument (main_call, VALA_CCODE_EXPRESSION ((_tmp248 = vala_ccode_identifier_new ("argv"))));
			(_tmp248 == NULL ? NULL : (_tmp248 = (g_object_unref (_tmp248), NULL)));
		}
		if (return_value) {
			ValaCCodeReturnStatement* main_stmt;
			main_stmt = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION (main_call));
			vala_ccode_node_set_line (VALA_CCODE_NODE (main_stmt), vala_ccode_node_get_line (VALA_CCODE_NODE (cmain)));
			vala_ccode_block_add_statement (main_block, VALA_CCODE_NODE (main_stmt));
			(main_stmt == NULL ? NULL : (main_stmt = (g_object_unref (main_stmt), NULL)));
		} else {
			ValaCCodeExpressionStatement* main_stmt;
			ValaCCodeConstant* _tmp249;
			ValaCCodeReturnStatement* _tmp250;
			ValaCCodeReturnStatement* ret_stmt;
			/* method returns void, always use 0 as exit code*/
			main_stmt = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (main_call));
			vala_ccode_node_set_line (VALA_CCODE_NODE (main_stmt), vala_ccode_node_get_line (VALA_CCODE_NODE (cmain)));
			vala_ccode_block_add_statement (main_block, VALA_CCODE_NODE (main_stmt));
			_tmp249 = NULL;
			_tmp250 = NULL;
			ret_stmt = (_tmp250 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION ((_tmp249 = vala_ccode_constant_new ("0")))), (_tmp249 == NULL ? NULL : (_tmp249 = (g_object_unref (_tmp249), NULL))), _tmp250);
			vala_ccode_node_set_line (VALA_CCODE_NODE (ret_stmt), vala_ccode_node_get_line (VALA_CCODE_NODE (cmain)));
			vala_ccode_block_add_statement (main_block, VALA_CCODE_NODE (ret_stmt));
			(main_stmt == NULL ? NULL : (main_stmt = (g_object_unref (main_stmt), NULL)));
			(ret_stmt == NULL ? NULL : (ret_stmt = (g_object_unref (ret_stmt), NULL)));
		}
		vala_ccode_function_set_block (cmain, main_block);
		vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (cmain));
		(cmain == NULL ? NULL : (cmain = (g_object_unref (cmain), NULL)));
		(main_block == NULL ? NULL : (main_block = (g_object_unref (main_block), NULL)));
		(type_init_call == NULL ? NULL : (type_init_call = (g_object_unref (type_init_call), NULL)));
		(main_call == NULL ? NULL : (main_call = (g_object_unref (main_call), NULL)));
	}
	(old_method == NULL ? NULL : (old_method = (g_object_unref (old_method), NULL)));
	(old_return_type == NULL ? NULL : (old_return_type = (g_object_unref (old_return_type), NULL)));
	(creturn_type == NULL ? NULL : (creturn_type = (g_object_unref (creturn_type), NULL)));
	(vdeclarator == NULL ? NULL : (vdeclarator = (g_object_unref (vdeclarator), NULL)));
	(instance_param == NULL ? NULL : (instance_param = (g_object_unref (instance_param), NULL)));
	(params == NULL ? NULL : (params = (g_object_unref (params), NULL)));
}


static ValaCCodeStatement* vala_ccode_generator_create_method_type_check_statement (ValaCCodeGenerator* self, ValaMethod* m, ValaDataType* return_type, ValaTypesymbol* t, gboolean non_null, const char* var_name) {
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	g_return_val_if_fail (m == NULL || VALA_IS_METHOD (m), NULL);
	g_return_val_if_fail (return_type == NULL || VALA_IS_DATA_TYPE (return_type), NULL);
	g_return_val_if_fail (t == NULL || VALA_IS_TYPESYMBOL (t), NULL);
	return vala_ccode_generator_create_type_check_statement (self, VALA_CODE_NODE (m), return_type, t, non_null, var_name);
}


static ValaCCodeStatement* vala_ccode_generator_create_property_type_check_statement (ValaCCodeGenerator* self, ValaProperty* prop, gboolean getter, ValaTypesymbol* t, gboolean non_null, const char* var_name) {
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	g_return_val_if_fail (prop == NULL || VALA_IS_PROPERTY (prop), NULL);
	g_return_val_if_fail (t == NULL || VALA_IS_TYPESYMBOL (t), NULL);
	if (getter) {
		return vala_ccode_generator_create_type_check_statement (self, VALA_CODE_NODE (prop), vala_property_get_type_reference (prop), t, non_null, var_name);
	} else {
		ValaVoidType* _tmp1;
		ValaCCodeStatement* _tmp2;
		_tmp1 = NULL;
		_tmp2 = NULL;
		return (_tmp2 = vala_ccode_generator_create_type_check_statement (self, VALA_CODE_NODE (prop), VALA_DATA_TYPE ((_tmp1 = vala_void_type_new ())), t, non_null, var_name), (_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL))), _tmp2);
	}
}


static ValaCCodeStatement* vala_ccode_generator_create_type_check_statement (ValaCCodeGenerator* self, ValaCodeNode* method_node, ValaDataType* ret_type, ValaTypesymbol* t, gboolean non_null, const char* var_name) {
	ValaCCodeFunctionCall* ccheck;
	ValaCCodeExpressionStatement* _tmp18;
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	g_return_val_if_fail (method_node == NULL || VALA_IS_CODE_NODE (method_node), NULL);
	g_return_val_if_fail (ret_type == NULL || VALA_IS_DATA_TYPE (ret_type), NULL);
	g_return_val_if_fail (t == NULL || VALA_IS_TYPESYMBOL (t), NULL);
	ccheck = vala_ccode_function_call_new (NULL);
	if ((VALA_IS_CLASS (t) && vala_typesymbol_is_subtype_of (VALA_TYPESYMBOL ((VALA_CLASS (t))), self->gobject_type)) || (VALA_IS_INTERFACE (t) && !vala_interface_get_declaration_only ((VALA_INTERFACE (t))))) {
		ValaCCodeIdentifier* _tmp1;
		char* _tmp0;
		ValaCCodeFunctionCall* _tmp2;
		ValaCCodeFunctionCall* ctype_check;
		ValaCCodeIdentifier* _tmp3;
		ValaCCodeFunctionCall* _tmp4;
		ValaCCodeExpression* cexpr;
		_tmp1 = NULL;
		_tmp0 = NULL;
		_tmp2 = NULL;
		ctype_check = (_tmp2 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp1 = vala_ccode_identifier_new ((_tmp0 = vala_typesymbol_get_upper_case_cname (t, "IS_")))))), (_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL))), (_tmp0 = (g_free (_tmp0), NULL)), _tmp2);
		_tmp3 = NULL;
		vala_ccode_function_call_add_argument (ctype_check, VALA_CCODE_EXPRESSION ((_tmp3 = vala_ccode_identifier_new (var_name))));
		(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
		_tmp4 = NULL;
		cexpr = VALA_CCODE_EXPRESSION ((_tmp4 = ctype_check, (_tmp4 == NULL ? NULL : g_object_ref (_tmp4))));
		if (!non_null) {
			ValaCCodeConstant* _tmp6;
			ValaCCodeIdentifier* _tmp5;
			ValaCCodeBinaryExpression* _tmp7;
			ValaCCodeBinaryExpression* cnull;
			ValaCCodeExpression* _tmp8;
			_tmp6 = NULL;
			_tmp5 = NULL;
			_tmp7 = NULL;
			cnull = (_tmp7 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_identifier_new (var_name))), VALA_CCODE_EXPRESSION ((_tmp6 = vala_ccode_constant_new ("NULL")))), (_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL))), (_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL))), _tmp7);
			_tmp8 = NULL;
			cexpr = (_tmp8 = VALA_CCODE_EXPRESSION (vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_OR, VALA_CCODE_EXPRESSION (cnull), VALA_CCODE_EXPRESSION (ctype_check))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), _tmp8);
			(cnull == NULL ? NULL : (cnull = (g_object_unref (cnull), NULL)));
		}
		vala_ccode_function_call_add_argument (ccheck, cexpr);
		(ctype_check == NULL ? NULL : (ctype_check = (g_object_unref (ctype_check), NULL)));
		(cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL)));
	} else {
		if (!non_null) {
			gpointer _tmp9;
			return (_tmp9 = NULL, (ccheck == NULL ? NULL : (ccheck = (g_object_unref (ccheck), NULL))), _tmp9);
		} else {
			ValaCCodeConstant* _tmp11;
			ValaCCodeIdentifier* _tmp10;
			ValaCCodeBinaryExpression* _tmp12;
			ValaCCodeBinaryExpression* cnonnull;
			_tmp11 = NULL;
			_tmp10 = NULL;
			_tmp12 = NULL;
			cnonnull = (_tmp12 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, VALA_CCODE_EXPRESSION ((_tmp10 = vala_ccode_identifier_new (var_name))), VALA_CCODE_EXPRESSION ((_tmp11 = vala_ccode_constant_new ("NULL")))), (_tmp11 == NULL ? NULL : (_tmp11 = (g_object_unref (_tmp11), NULL))), (_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL))), _tmp12);
			vala_ccode_function_call_add_argument (ccheck, VALA_CCODE_EXPRESSION (cnonnull));
			(cnonnull == NULL ? NULL : (cnonnull = (g_object_unref (cnonnull), NULL)));
		}
	}
	if (VALA_IS_VOID_TYPE (ret_type)) {
		ValaCCodeIdentifier* _tmp13;
		/* void function */
		_tmp13 = NULL;
		vala_ccode_function_call_set_call (ccheck, VALA_CCODE_EXPRESSION ((_tmp13 = vala_ccode_identifier_new ("g_return_if_fail"))));
		(_tmp13 == NULL ? NULL : (_tmp13 = (g_object_unref (_tmp13), NULL)));
	} else {
		ValaCCodeIdentifier* _tmp14;
		ValaCCodeExpression* cdefault;
		_tmp14 = NULL;
		vala_ccode_function_call_set_call (ccheck, VALA_CCODE_EXPRESSION ((_tmp14 = vala_ccode_identifier_new ("g_return_val_if_fail"))));
		(_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL)));
		cdefault = vala_ccode_generator_default_value_for_type (self, ret_type);
		if (cdefault != NULL) {
			vala_ccode_function_call_add_argument (ccheck, cdefault);
		} else {
			ValaCCodeConstant* _tmp15;
			ValaCCodeExpressionStatement* _tmp16;
			ValaCCodeExpressionStatement* _tmp17;
			vala_report_warning (vala_code_node_get_source_reference (method_node), "not supported return type for runtime type checks");
			_tmp15 = NULL;
			_tmp16 = NULL;
			_tmp17 = NULL;
			return VALA_CCODE_STATEMENT ((_tmp17 = (_tmp16 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp15 = vala_ccode_constant_new ("0")))), (_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL))), _tmp16), (cdefault == NULL ? NULL : (cdefault = (g_object_unref (cdefault), NULL))), (ccheck == NULL ? NULL : (ccheck = (g_object_unref (ccheck), NULL))), _tmp17));
		}
		(cdefault == NULL ? NULL : (cdefault = (g_object_unref (cdefault), NULL)));
	}
	_tmp18 = NULL;
	return VALA_CCODE_STATEMENT ((_tmp18 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccheck)), (ccheck == NULL ? NULL : (ccheck = (g_object_unref (ccheck), NULL))), _tmp18));
}


static ValaCCodeStatement* vala_ccode_generator_create_precondition_statement (ValaCCodeGenerator* self, ValaCodeNode* method_node, ValaDataType* ret_type, ValaExpression* precondition) {
	ValaCCodeFunctionCall* ccheck;
	ValaCCodeExpressionStatement* _tmp5;
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	g_return_val_if_fail (method_node == NULL || VALA_IS_CODE_NODE (method_node), NULL);
	g_return_val_if_fail (ret_type == NULL || VALA_IS_DATA_TYPE (ret_type), NULL);
	g_return_val_if_fail (precondition == NULL || VALA_IS_EXPRESSION (precondition), NULL);
	ccheck = vala_ccode_function_call_new (NULL);
	vala_ccode_function_call_add_argument (ccheck, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (precondition))));
	if (VALA_IS_VOID_TYPE (ret_type)) {
		ValaCCodeIdentifier* _tmp0;
		/* void function */
		_tmp0 = NULL;
		vala_ccode_function_call_set_call (ccheck, VALA_CCODE_EXPRESSION ((_tmp0 = vala_ccode_identifier_new ("g_return_if_fail"))));
		(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	} else {
		ValaCCodeIdentifier* _tmp1;
		ValaCCodeExpression* cdefault;
		_tmp1 = NULL;
		vala_ccode_function_call_set_call (ccheck, VALA_CCODE_EXPRESSION ((_tmp1 = vala_ccode_identifier_new ("g_return_val_if_fail"))));
		(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
		cdefault = vala_ccode_generator_default_value_for_type (self, ret_type);
		if (cdefault != NULL) {
			vala_ccode_function_call_add_argument (ccheck, cdefault);
		} else {
			ValaCCodeConstant* _tmp2;
			ValaCCodeExpressionStatement* _tmp3;
			ValaCCodeExpressionStatement* _tmp4;
			vala_report_warning (vala_code_node_get_source_reference (method_node), "not supported return type for runtime type checks");
			_tmp2 = NULL;
			_tmp3 = NULL;
			_tmp4 = NULL;
			return VALA_CCODE_STATEMENT ((_tmp4 = (_tmp3 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_constant_new ("0")))), (_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL))), _tmp3), (cdefault == NULL ? NULL : (cdefault = (g_object_unref (cdefault), NULL))), (ccheck == NULL ? NULL : (ccheck = (g_object_unref (ccheck), NULL))), _tmp4));
		}
		(cdefault == NULL ? NULL : (cdefault = (g_object_unref (cdefault), NULL)));
	}
	_tmp5 = NULL;
	return VALA_CCODE_STATEMENT ((_tmp5 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccheck)), (ccheck == NULL ? NULL : (ccheck = (g_object_unref (ccheck), NULL))), _tmp5));
}


static ValaCCodeStatement* vala_ccode_generator_create_postcondition_statement (ValaCCodeGenerator* self, ValaExpression* postcondition) {
	ValaCCodeIdentifier* _tmp0;
	ValaCCodeFunctionCall* _tmp1;
	ValaCCodeFunctionCall* cassert;
	ValaCCodeExpressionStatement* _tmp2;
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	g_return_val_if_fail (postcondition == NULL || VALA_IS_EXPRESSION (postcondition), NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	cassert = (_tmp1 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp0 = vala_ccode_identifier_new ("g_assert")))), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1);
	vala_ccode_function_call_add_argument (cassert, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (postcondition))));
	_tmp2 = NULL;
	return VALA_CCODE_STATEMENT ((_tmp2 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cassert)), (cassert == NULL ? NULL : (cassert = (g_object_unref (cassert), NULL))), _tmp2));
}


static ValaCCodeExpression* vala_ccode_generator_default_value_for_type (ValaCCodeGenerator* self, ValaDataType* type) {
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	g_return_val_if_fail (type == NULL || VALA_IS_DATA_TYPE (type), NULL);
	if ((vala_data_type_get_data_type (type) != NULL && vala_typesymbol_is_reference_type (vala_data_type_get_data_type (type))) || VALA_IS_POINTER_TYPE (type)) {
		return VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL"));
	} else {
		char* _tmp1;
		gboolean _tmp2;
		_tmp1 = NULL;
		if ((_tmp2 = vala_data_type_get_data_type (type) != NULL && (_tmp1 = vala_typesymbol_get_default_value (vala_data_type_get_data_type (type))) != NULL, (_tmp1 = (g_free (_tmp1), NULL)), _tmp2)) {
			char* _tmp3;
			ValaCCodeConstant* _tmp4;
			_tmp3 = NULL;
			_tmp4 = NULL;
			return VALA_CCODE_EXPRESSION ((_tmp4 = vala_ccode_constant_new ((_tmp3 = vala_typesymbol_get_default_value (vala_data_type_get_data_type (type)))), (_tmp3 = (g_free (_tmp3), NULL)), _tmp4));
		}
	}
	return NULL;
}


static ValaTypesymbol* vala_ccode_generator_find_parent_type (ValaCCodeGenerator* self, ValaSymbol* sym) {
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	g_return_val_if_fail (sym == NULL || VALA_IS_SYMBOL (sym), NULL);
	while (sym != NULL) {
		if (VALA_IS_TYPESYMBOL (sym)) {
			ValaTypesymbol* _tmp0;
			_tmp0 = NULL;
			return (_tmp0 = VALA_TYPESYMBOL (sym), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
		}
		sym = vala_symbol_get_parent_symbol (sym);
	}
	return NULL;
}


static void vala_ccode_generator_real_visit_creation_method (ValaCodeVisitor* base, ValaCreationMethod* m) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (m == NULL || VALA_IS_CREATION_METHOD (m));
	if (vala_method_get_body (VALA_METHOD (m)) != NULL && VALA_IS_CLASS (self->current_type_symbol) && vala_typesymbol_is_subtype_of (VALA_TYPESYMBOL (self->priv->current_class), self->gobject_type)) {
		gint n_params;
		n_params = 0;
		{
			GeeCollection* stmt_collection;
			GeeIterator* stmt_it;
			stmt_collection = vala_block_get_statements (vala_method_get_body (VALA_METHOD (m)));
			stmt_it = gee_iterable_iterator (GEE_ITERABLE (stmt_collection));
			while (gee_iterator_next (stmt_it)) {
				ValaStatement* stmt;
				stmt = gee_iterator_get (stmt_it);
				{
					ValaProperty* _tmp0;
					gboolean _tmp1;
					ValaProperty* _tmp2;
					gboolean _tmp3;
					_tmp0 = NULL;
					if ((_tmp1 = !(VALA_IS_EXPRESSION_STATEMENT (stmt)) || (_tmp0 = vala_expression_statement_assigned_property ((VALA_EXPRESSION_STATEMENT (stmt)))) == NULL, (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1)) {
						vala_code_node_set_error (VALA_CODE_NODE (m), TRUE);
						vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (stmt)), "class creation methods only allow property assignment statements");
						(stmt == NULL ? NULL : (stmt = (g_object_unref (stmt), NULL)));
						(stmt_collection == NULL ? NULL : (stmt_collection = (g_object_unref (stmt_collection), NULL)));
						(stmt_it == NULL ? NULL : (stmt_it = (g_object_unref (stmt_it), NULL)));
						return;
					}
					_tmp2 = NULL;
					if ((_tmp3 = vala_property_accessor_get_construction (vala_property_get_set_accessor ((_tmp2 = vala_expression_statement_assigned_property ((VALA_EXPRESSION_STATEMENT (stmt)))))), (_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL))), _tmp3)) {
						n_params++;
					}
					(stmt == NULL ? NULL : (stmt = (g_object_unref (stmt), NULL)));
				}
			}
			(stmt_collection == NULL ? NULL : (stmt_collection = (g_object_unref (stmt_collection), NULL)));
			(stmt_it == NULL ? NULL : (stmt_it = (g_object_unref (stmt_it), NULL)));
		}
		vala_creation_method_set_n_construction_params (m, n_params);
	}
	vala_code_visitor_visit_method (VALA_CODE_VISITOR (self), VALA_METHOD (m));
}


static gboolean vala_ccode_generator_is_possible_entry_point (ValaCCodeGenerator* self, ValaMethod* m, gboolean* return_value, gboolean* args_parameter) {
	GeeCollection* params;
	GeeIterator* params_it;
	ValaFormalParameter* param;
	ValaArray* _tmp7;
	ValaArray* array_type;
	gboolean _tmp9;
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), FALSE);
	g_return_val_if_fail (m == NULL || VALA_IS_METHOD (m), FALSE);
	if (vala_symbol_get_name (VALA_SYMBOL (m)) == NULL || g_utf8_collate (vala_symbol_get_name (VALA_SYMBOL (m)), "main") != 0) {
		return FALSE;
	}
	/* method must be called "main"*/
	if (vala_method_get_instance (m)) {
		return FALSE;
	}
	/* method must be static*/
	if (vala_data_type_get_data_type (vala_method_get_return_type (m)) == NULL) {
		(*return_value) = FALSE;
	} else {
		if (vala_data_type_get_data_type (vala_method_get_return_type (m)) == vala_data_type_get_data_type (self->int_type)) {
			(*return_value) = TRUE;
		} else {
			return FALSE;
		}
	}
	/* return type must be void or int*/
	params = vala_method_get_parameters (m);
	if (gee_collection_get_size (params) == 0) {
		gboolean _tmp3;
		/* method may have no parameters*/
		(*args_parameter) = FALSE;
		return (_tmp3 = TRUE, (params == NULL ? NULL : (params = (g_object_unref (params), NULL))), _tmp3);
	}
	if (gee_collection_get_size (params) > 1) {
		gboolean _tmp4;
		return (_tmp4 = FALSE, (params == NULL ? NULL : (params = (g_object_unref (params), NULL))), _tmp4);
	}
	/* method must not have more than one parameter*/
	params_it = gee_iterable_iterator (GEE_ITERABLE (params));
	gee_iterator_next (params_it);
	param = gee_iterator_get (params_it);
	if (vala_data_type_get_is_out (vala_formal_parameter_get_type_reference (param))) {
		gboolean _tmp5;
		return (_tmp5 = FALSE, (params == NULL ? NULL : (params = (g_object_unref (params), NULL))), (params_it == NULL ? NULL : (params_it = (g_object_unref (params_it), NULL))), (param == NULL ? NULL : (param = (g_object_unref (param), NULL))), _tmp5);
	}
	/* parameter must not be an out parameter*/
	if (!(VALA_IS_ARRAY (vala_data_type_get_data_type (vala_formal_parameter_get_type_reference (param))))) {
		gboolean _tmp6;
		return (_tmp6 = FALSE, (params == NULL ? NULL : (params = (g_object_unref (params), NULL))), (params_it == NULL ? NULL : (params_it = (g_object_unref (params_it), NULL))), (param == NULL ? NULL : (param = (g_object_unref (param), NULL))), _tmp6);
	}
	/* parameter must be an array*/
	_tmp7 = NULL;
	array_type = (_tmp7 = VALA_ARRAY (vala_data_type_get_data_type (vala_formal_parameter_get_type_reference (param))), (_tmp7 == NULL ? NULL : g_object_ref (_tmp7)));
	if (vala_array_get_element_type (array_type) != vala_data_type_get_data_type (self->string_type)) {
		gboolean _tmp8;
		return (_tmp8 = FALSE, (params == NULL ? NULL : (params = (g_object_unref (params), NULL))), (params_it == NULL ? NULL : (params_it = (g_object_unref (params_it), NULL))), (param == NULL ? NULL : (param = (g_object_unref (param), NULL))), (array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL))), _tmp8);
	}
	/* parameter must be an array of strings*/
	(*args_parameter) = TRUE;
	return (_tmp9 = TRUE, (params == NULL ? NULL : (params = (g_object_unref (params), NULL))), (params_it == NULL ? NULL : (params_it = (g_object_unref (params_it), NULL))), (param == NULL ? NULL : (param = (g_object_unref (param), NULL))), (array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL))), _tmp9);
}


static void vala_ccode_generator_add_object_creation (ValaCCodeGenerator* self, ValaCCodeBlock* b, gboolean has_params) {
	ValaClass* _tmp0;
	ValaClass* cl;
	ValaCCodeIdentifier* _tmp1;
	ValaCCodeFunctionCall* _tmp2;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeConstant* _tmp4;
	char* _tmp3;
	ValaCCodeVariableDeclarator* cdecl_;
	char* _tmp10;
	char* _tmp9;
	ValaCCodeDeclaration* _tmp11;
	ValaCCodeDeclaration* cdeclaration;
	g_return_if_fail (VALA_IS_CCODE_GENERATOR (self));
	g_return_if_fail (b == NULL || VALA_IS_CCODE_BLOCK (b));
	_tmp0 = NULL;
	cl = (_tmp0 = VALA_CLASS (self->current_type_symbol), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	_tmp1 = NULL;
	_tmp2 = NULL;
	ccall = (_tmp2 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp1 = vala_ccode_identifier_new ("g_object_newv")))), (_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL))), _tmp2);
	_tmp4 = NULL;
	_tmp3 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp4 = vala_ccode_constant_new ((_tmp3 = vala_typesymbol_get_type_id (VALA_TYPESYMBOL (cl)))))));
	(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
	(_tmp3 = (g_free (_tmp3), NULL));
	if (has_params) {
		ValaCCodeConstant* _tmp5;
		ValaCCodeConstant* _tmp6;
		_tmp5 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_constant_new ("__params_it - __params"))));
		(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
		_tmp6 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp6 = vala_ccode_constant_new ("__params"))));
		(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
	} else {
		ValaCCodeConstant* _tmp7;
		ValaCCodeConstant* _tmp8;
		_tmp7 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp7 = vala_ccode_constant_new ("0"))));
		(_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL)));
		_tmp8 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp8 = vala_ccode_constant_new ("NULL"))));
		(_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL)));
	}
	cdecl_ = vala_ccode_variable_declarator_new ("self");
	vala_ccode_variable_declarator_set_initializer (cdecl_, VALA_CCODE_EXPRESSION (ccall));
	_tmp10 = NULL;
	_tmp9 = NULL;
	_tmp11 = NULL;
	cdeclaration = (_tmp11 = vala_ccode_declaration_new ((_tmp10 = g_strdup_printf ("%s *", (_tmp9 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE))))), (_tmp10 = (g_free (_tmp10), NULL)), (_tmp9 = (g_free (_tmp9), NULL)), _tmp11);
	vala_ccode_declaration_add_declarator (cdeclaration, VALA_CCODE_DECLARATOR (cdecl_));
	vala_ccode_block_add_statement (b, VALA_CCODE_NODE (cdeclaration));
	(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
	(cdeclaration == NULL ? NULL : (cdeclaration = (g_object_unref (cdeclaration), NULL)));
}


static ValaClass* vala_ccode_generator_find_fundamental_class (ValaCCodeGenerator* self, ValaClass* cl) {
	ValaClass* _tmp0;
	ValaClass* fundamental_class;
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	g_return_val_if_fail (cl == NULL || VALA_IS_CLASS (cl), NULL);
	_tmp0 = NULL;
	fundamental_class = (_tmp0 = cl, (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	while (fundamental_class != NULL && VALA_TYPESYMBOL (vala_class_get_base_class (fundamental_class)) != self->gtypeinstance_type) {
		ValaClass* _tmp2;
		ValaClass* _tmp1;
		_tmp2 = NULL;
		_tmp1 = NULL;
		fundamental_class = (_tmp2 = (_tmp1 = vala_class_get_base_class (fundamental_class), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (fundamental_class == NULL ? NULL : (fundamental_class = (g_object_unref (fundamental_class), NULL))), _tmp2);
	}
	return fundamental_class;
}


static char* vala_ccode_generator_get_marshaller_type_name (ValaCCodeGenerator* self, ValaDataType* t) {
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	g_return_val_if_fail (t == NULL || VALA_IS_DATA_TYPE (t), NULL);
	if (VALA_IS_POINTER_TYPE (t) || vala_data_type_get_type_parameter (t) != NULL || vala_data_type_get_is_ref (t) || vala_data_type_get_is_out (t)) {
		const char* _tmp0;
		_tmp0 = NULL;
		return (_tmp0 = ("POINTER"), (_tmp0 == NULL ? NULL : g_strdup (_tmp0)));
	} else {
		if (VALA_IS_VOID_TYPE (t)) {
			const char* _tmp2;
			_tmp2 = NULL;
			return (_tmp2 = ("VOID"), (_tmp2 == NULL ? NULL : g_strdup (_tmp2)));
		} else {
			return vala_typesymbol_get_marshaller_type_name (vala_data_type_get_data_type (t));
		}
	}
}


char* vala_ccode_generator_get_signal_marshaller_function (ValaCCodeGenerator* self, ValaSignal* sig, const char* prefix) {
	char* signature;
	char* ret;
	GeeCollection* params;
	char* _tmp1;
	char* _tmp0;
	char* _tmp5;
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	g_return_val_if_fail (sig == NULL || VALA_IS_SIGNAL (sig), NULL);
	signature = vala_ccode_generator_get_signal_signature (self, sig);
	ret = NULL;
	params = vala_signal_get_parameters (sig);
	if (prefix == NULL) {
		if (gee_collection_contains (GEE_COLLECTION (self->priv->predefined_marshal_set), signature)) {
			prefix = "g_cclosure_marshal";
		} else {
			prefix = "g_cclosure_user_marshal";
		}
	}
	_tmp1 = NULL;
	_tmp0 = NULL;
	ret = (_tmp1 = g_strdup_printf ("%s_%s_", prefix, (_tmp0 = vala_ccode_generator_get_marshaller_type_name (self, vala_signal_get_return_type (sig)))), (ret = (g_free (ret), NULL)), _tmp1);
	(_tmp0 = (g_free (_tmp0), NULL));
	if (params == NULL) {
		char* _tmp2;
		_tmp2 = NULL;
		ret = (_tmp2 = g_strconcat (ret, "_VOID", NULL), (ret = (g_free (ret), NULL)), _tmp2);
	} else {
		{
			GeeCollection* p_collection;
			GeeIterator* p_it;
			p_collection = params;
			p_it = gee_iterable_iterator (GEE_ITERABLE (p_collection));
			while (gee_iterator_next (p_it)) {
				ValaFormalParameter* p;
				p = gee_iterator_get (p_it);
				{
					char* _tmp4;
					char* _tmp3;
					_tmp4 = NULL;
					_tmp3 = NULL;
					ret = (_tmp4 = g_strdup_printf ("%s_%s", ret, (_tmp3 = vala_ccode_generator_get_marshaller_type_name (self, vala_formal_parameter_get_type_reference (p)))), (ret = (g_free (ret), NULL)), _tmp4);
					(_tmp3 = (g_free (_tmp3), NULL));
					(p == NULL ? NULL : (p = (g_object_unref (p), NULL)));
				}
			}
			(p_it == NULL ? NULL : (p_it = (g_object_unref (p_it), NULL)));
		}
	}
	_tmp5 = NULL;
	return (_tmp5 = ret, (signature = (g_free (signature), NULL)), (params == NULL ? NULL : (params = (g_object_unref (params), NULL))), _tmp5);
}


static char* vala_ccode_generator_get_value_type_name_from_type_reference (ValaCCodeGenerator* self, ValaDataType* t) {
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	g_return_val_if_fail (t == NULL || VALA_IS_DATA_TYPE (t), NULL);
	if (VALA_IS_POINTER_TYPE (t) || vala_data_type_get_type_parameter (t) != NULL || vala_data_type_get_is_ref (t) || vala_data_type_get_is_out (t)) {
		return g_strdup ("gpointer");
	} else {
		if (VALA_IS_VOID_TYPE (t)) {
			return g_strdup ("void");
		} else {
			if (vala_data_type_get_data_type (t) == vala_data_type_get_data_type (self->string_type)) {
				return g_strdup ("const char*");
			} else {
				if (VALA_IS_CLASS (vala_data_type_get_data_type (t)) || VALA_IS_INTERFACE (vala_data_type_get_data_type (t))) {
					return g_strdup ("gpointer");
				} else {
					if (VALA_IS_STRUCT (vala_data_type_get_data_type (t))) {
						return vala_typesymbol_get_cname (vala_data_type_get_data_type (t), FALSE);
					} else {
						if (VALA_IS_ENUM (vala_data_type_get_data_type (t))) {
							return g_strdup ("gint");
						} else {
							if (VALA_IS_ARRAY (vala_data_type_get_data_type (t))) {
								return g_strdup ("gpointer");
							}
						}
					}
				}
			}
		}
	}
	return NULL;
}


static char* vala_ccode_generator_get_signal_signature (ValaCCodeGenerator* self, ValaSignal* sig) {
	char* signature;
	GeeCollection* params;
	char* _tmp1;
	char* _tmp0;
	char* _tmp7;
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	g_return_val_if_fail (sig == NULL || VALA_IS_SIGNAL (sig), NULL);
	signature = NULL;
	params = vala_signal_get_parameters (sig);
	_tmp1 = NULL;
	_tmp0 = NULL;
	signature = (_tmp1 = g_strdup_printf ("%s:", (_tmp0 = vala_ccode_generator_get_marshaller_type_name (self, vala_signal_get_return_type (sig)))), (signature = (g_free (signature), NULL)), _tmp1);
	(_tmp0 = (g_free (_tmp0), NULL));
	if (params == NULL) {
		char* _tmp2;
		_tmp2 = NULL;
		signature = (_tmp2 = g_strconcat (signature, "VOID", NULL), (signature = (g_free (signature), NULL)), _tmp2);
	} else {
		gboolean first;
		first = TRUE;
		{
			GeeCollection* p_collection;
			GeeIterator* p_it;
			p_collection = params;
			p_it = gee_iterable_iterator (GEE_ITERABLE (p_collection));
			while (gee_iterator_next (p_it)) {
				ValaFormalParameter* p;
				p = gee_iterator_get (p_it);
				{
					if (first) {
						char* _tmp4;
						char* _tmp3;
						_tmp4 = NULL;
						_tmp3 = NULL;
						signature = (_tmp4 = g_strconcat (signature, (_tmp3 = vala_ccode_generator_get_marshaller_type_name (self, vala_formal_parameter_get_type_reference (p))), NULL), (signature = (g_free (signature), NULL)), _tmp4);
						(_tmp3 = (g_free (_tmp3), NULL));
						first = FALSE;
					} else {
						char* _tmp6;
						char* _tmp5;
						_tmp6 = NULL;
						_tmp5 = NULL;
						signature = (_tmp6 = g_strdup_printf ("%s,%s", signature, (_tmp5 = vala_ccode_generator_get_marshaller_type_name (self, vala_formal_parameter_get_type_reference (p)))), (signature = (g_free (signature), NULL)), _tmp6);
						(_tmp5 = (g_free (_tmp5), NULL));
					}
					(p == NULL ? NULL : (p = (g_object_unref (p), NULL)));
				}
			}
			(p_it == NULL ? NULL : (p_it = (g_object_unref (p_it), NULL)));
		}
	}
	_tmp7 = NULL;
	return (_tmp7 = signature, (params == NULL ? NULL : (params = (g_object_unref (params), NULL))), _tmp7);
}


static void vala_ccode_generator_real_visit_signal (ValaCodeVisitor* base, ValaSignal* sig) {
	ValaCCodeGenerator * self;
	char* signature;
	GeeCollection* params;
	gint n_params;
	gint i;
	char* _tmp4;
	char* _tmp5;
	ValaCCodeFunction* _tmp6;
	ValaCCodeFunction* signal_marshaller;
	ValaCCodeFormalParameter* _tmp7;
	ValaCCodeFormalParameter* _tmp8;
	ValaCCodeFormalParameter* _tmp9;
	ValaCCodeFormalParameter* _tmp10;
	ValaCCodeFormalParameter* _tmp11;
	ValaCCodeFormalParameter* _tmp12;
	ValaCCodeFunction* _tmp13;
	ValaCCodeBlock* marshaller_body;
	char* _tmp14;
	ValaCCodeFunctionDeclarator* _tmp15;
	ValaCCodeFunctionDeclarator* callback_decl;
	ValaCCodeFormalParameter* _tmp16;
	ValaCCodeFormalParameter* _tmp20;
	ValaCCodeTypeDefinition* _tmp22;
	char* _tmp21;
	char* _tmp23;
	ValaCCodeDeclaration* _tmp24;
	ValaCCodeDeclaration* var_decl;
	ValaCCodeVariableDeclarator* _tmp25;
	ValaCCodeDeclaration* _tmp26;
	ValaCCodeVariableDeclarator* _tmp29;
	ValaCCodeCastExpression* _tmp28;
	ValaCCodeIdentifier* _tmp27;
	ValaCCodeDeclaration* _tmp30;
	ValaCCodeVariableDeclarator* _tmp31;
	ValaCCodeVariableDeclarator* _tmp32;
	ValaCCodeFunctionCall* fc;
	ValaCCodeFunctionCall* _tmp43;
	ValaCCodeIdentifier* _tmp42;
	ValaCCodeBinaryExpression* _tmp47;
	ValaCCodeConstant* _tmp46;
	char* _tmp45;
	ValaCCodeIdentifier* _tmp44;
	ValaCCodeExpressionStatement* _tmp48;
	ValaCCodeIdentifier* _tmp49;
	ValaCCodeMemberAccess* _tmp50;
	ValaCCodeMemberAccess* data;
	ValaCCodeMemberAccess* _tmp52;
	ValaCCodeIdentifier* _tmp51;
	ValaCCodeMemberAccess* _tmp53;
	ValaCCodeMemberAccess* param;
	ValaCCodeConstant* _tmp54;
	ValaCCodeFunctionCall* _tmp55;
	ValaCCodeFunctionCall* cond;
	ValaCCodeIdentifier* _tmp56;
	ValaCCodeBlock* true_block;
	ValaCCodeExpressionStatement* _tmp59;
	ValaCCodeAssignment* _tmp58;
	ValaCCodeIdentifier* _tmp57;
	ValaCCodeExpressionStatement* _tmp62;
	ValaCCodeAssignment* _tmp61;
	ValaCCodeIdentifier* _tmp60;
	ValaCCodeBlock* false_block;
	ValaCCodeExpressionStatement* _tmp65;
	ValaCCodeAssignment* _tmp64;
	ValaCCodeIdentifier* _tmp63;
	ValaCCodeExpressionStatement* _tmp68;
	ValaCCodeAssignment* _tmp67;
	ValaCCodeIdentifier* _tmp66;
	ValaCCodeIfStatement* _tmp69;
	ValaCCodeCastExpression* _tmp77;
	char* _tmp76;
	ValaCCodeConditionalExpression* _tmp75;
	ValaCCodeMemberAccess* _tmp74;
	ValaCCodeIdentifier* _tmp73;
	ValaCCodeIdentifier* _tmp72;
	ValaCCodeIdentifier* _tmp71;
	ValaCCodeIdentifier* _tmp70;
	ValaCCodeAssignment* _tmp78;
	ValaCCodeAssignment* c_assign;
	ValaCCodeExpressionStatement* _tmp79;
	ValaCCodeFunctionCall* _tmp81;
	ValaCCodeIdentifier* _tmp80;
	ValaCCodeIdentifier* _tmp82;
	ValaCCodeIdentifier* _tmp91;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (sig == NULL || VALA_IS_SIGNAL (sig));
	/* parent_symbol may be null for late bound signals*/
	if (vala_symbol_get_parent_symbol (VALA_SYMBOL (sig)) != NULL) {
		ValaTypesymbol* _tmp1;
		ValaSymbol* _tmp0;
		ValaTypesymbol* dt;
		_tmp1 = NULL;
		_tmp0 = NULL;
		dt = (_tmp1 = (_tmp0 = vala_symbol_get_parent_symbol (VALA_SYMBOL (sig)), (VALA_IS_TYPESYMBOL (_tmp0) ? ((ValaTypesymbol*) _tmp0) : NULL)), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
		if (!vala_typesymbol_is_subtype_of (dt, self->gobject_type)) {
			char* _tmp3;
			char* _tmp2;
			vala_code_node_set_error (VALA_CODE_NODE (sig), TRUE);
			_tmp3 = NULL;
			_tmp2 = NULL;
			vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (sig)), (_tmp3 = g_strdup_printf ("Only classes and interfaces deriving from GLib.Object support signals. `%s' does not derive from GLib.Object.", (_tmp2 = vala_symbol_get_full_name (VALA_SYMBOL (dt))))));
			(_tmp3 = (g_free (_tmp3), NULL));
			(_tmp2 = (g_free (_tmp2), NULL));
			(dt == NULL ? NULL : (dt = (g_object_unref (dt), NULL)));
			return;
		}
		(dt == NULL ? NULL : (dt = (g_object_unref (dt), NULL)));
	}
	vala_code_node_accept_children (VALA_CODE_NODE (sig), VALA_CODE_VISITOR (self));
	signature = NULL;
	params = vala_signal_get_parameters (sig);
	n_params = 0;
	i = 0;
	/* check whether a signal with the same signature already exists for this source file (or predefined) */
	_tmp4 = NULL;
	signature = (_tmp4 = vala_ccode_generator_get_signal_signature (self, sig), (signature = (g_free (signature), NULL)), _tmp4);
	if (gee_collection_contains (GEE_COLLECTION (self->priv->predefined_marshal_set), signature) || gee_collection_contains (GEE_COLLECTION (self->priv->user_marshal_set), signature)) {
		(signature = (g_free (signature), NULL));
		(params == NULL ? NULL : (params = (g_object_unref (params), NULL)));
		return;
	}
	_tmp5 = NULL;
	_tmp6 = NULL;
	signal_marshaller = (_tmp6 = vala_ccode_function_new ((_tmp5 = vala_ccode_generator_get_signal_marshaller_function (self, sig, NULL)), "void"), (_tmp5 = (g_free (_tmp5), NULL)), _tmp6);
	vala_ccode_function_set_modifiers (signal_marshaller, VALA_CCODE_MODIFIERS_STATIC);
	_tmp7 = NULL;
	vala_ccode_function_add_parameter (signal_marshaller, (_tmp7 = vala_ccode_formal_parameter_new ("closure", "GClosure *")));
	(_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL)));
	_tmp8 = NULL;
	vala_ccode_function_add_parameter (signal_marshaller, (_tmp8 = vala_ccode_formal_parameter_new ("return_value", "GValue *")));
	(_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL)));
	_tmp9 = NULL;
	vala_ccode_function_add_parameter (signal_marshaller, (_tmp9 = vala_ccode_formal_parameter_new ("n_param_values", "guint")));
	(_tmp9 == NULL ? NULL : (_tmp9 = (g_object_unref (_tmp9), NULL)));
	_tmp10 = NULL;
	vala_ccode_function_add_parameter (signal_marshaller, (_tmp10 = vala_ccode_formal_parameter_new ("param_values", "const GValue *")));
	(_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL)));
	_tmp11 = NULL;
	vala_ccode_function_add_parameter (signal_marshaller, (_tmp11 = vala_ccode_formal_parameter_new ("invocation_hint", "gpointer")));
	(_tmp11 == NULL ? NULL : (_tmp11 = (g_object_unref (_tmp11), NULL)));
	_tmp12 = NULL;
	vala_ccode_function_add_parameter (signal_marshaller, (_tmp12 = vala_ccode_formal_parameter_new ("marshal_data", "gpointer")));
	(_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL)));
	_tmp13 = NULL;
	vala_ccode_fragment_append (self->priv->source_signal_marshaller_declaration, VALA_CCODE_NODE ((_tmp13 = vala_ccode_function_copy (signal_marshaller))));
	(_tmp13 == NULL ? NULL : (_tmp13 = (g_object_unref (_tmp13), NULL)));
	marshaller_body = vala_ccode_block_new ();
	_tmp14 = NULL;
	_tmp15 = NULL;
	callback_decl = (_tmp15 = vala_ccode_function_declarator_new ((_tmp14 = vala_ccode_generator_get_signal_marshaller_function (self, sig, "GMarshalFunc"))), (_tmp14 = (g_free (_tmp14), NULL)), _tmp15);
	_tmp16 = NULL;
	vala_ccode_function_declarator_add_parameter (callback_decl, (_tmp16 = vala_ccode_formal_parameter_new ("data1", "gpointer")));
	(_tmp16 == NULL ? NULL : (_tmp16 = (g_object_unref (_tmp16), NULL)));
	n_params = 1;
	{
		GeeCollection* p_collection;
		GeeIterator* p_it;
		p_collection = params;
		p_it = gee_iterable_iterator (GEE_ITERABLE (p_collection));
		while (gee_iterator_next (p_it)) {
			ValaFormalParameter* p;
			p = gee_iterator_get (p_it);
			{
				ValaCCodeFormalParameter* _tmp19;
				char* _tmp18;
				char* _tmp17;
				_tmp19 = NULL;
				_tmp18 = NULL;
				_tmp17 = NULL;
				vala_ccode_function_declarator_add_parameter (callback_decl, (_tmp19 = vala_ccode_formal_parameter_new ((_tmp17 = g_strdup_printf ("arg_%d", n_params)), (_tmp18 = vala_ccode_generator_get_value_type_name_from_type_reference (self, vala_formal_parameter_get_type_reference (p))))));
				(_tmp19 == NULL ? NULL : (_tmp19 = (g_object_unref (_tmp19), NULL)));
				(_tmp18 = (g_free (_tmp18), NULL));
				(_tmp17 = (g_free (_tmp17), NULL));
				n_params++;
				(p == NULL ? NULL : (p = (g_object_unref (p), NULL)));
			}
		}
		(p_it == NULL ? NULL : (p_it = (g_object_unref (p_it), NULL)));
	}
	_tmp20 = NULL;
	vala_ccode_function_declarator_add_parameter (callback_decl, (_tmp20 = vala_ccode_formal_parameter_new ("data2", "gpointer")));
	(_tmp20 == NULL ? NULL : (_tmp20 = (g_object_unref (_tmp20), NULL)));
	_tmp22 = NULL;
	_tmp21 = NULL;
	vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE ((_tmp22 = vala_ccode_type_definition_new ((_tmp21 = vala_ccode_generator_get_value_type_name_from_type_reference (self, vala_signal_get_return_type (sig))), VALA_CCODE_DECLARATOR (callback_decl)))));
	(_tmp22 == NULL ? NULL : (_tmp22 = (g_object_unref (_tmp22), NULL)));
	(_tmp21 = (g_free (_tmp21), NULL));
	_tmp23 = NULL;
	_tmp24 = NULL;
	var_decl = (_tmp24 = vala_ccode_declaration_new ((_tmp23 = vala_ccode_generator_get_signal_marshaller_function (self, sig, "GMarshalFunc"))), (_tmp23 = (g_free (_tmp23), NULL)), _tmp24);
	vala_ccode_declaration_set_modifiers (var_decl, VALA_CCODE_MODIFIERS_REGISTER);
	_tmp25 = NULL;
	vala_ccode_declaration_add_declarator (var_decl, VALA_CCODE_DECLARATOR ((_tmp25 = vala_ccode_variable_declarator_new ("callback"))));
	(_tmp25 == NULL ? NULL : (_tmp25 = (g_object_unref (_tmp25), NULL)));
	vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE (var_decl));
	_tmp26 = NULL;
	var_decl = (_tmp26 = vala_ccode_declaration_new ("GCClosure *"), (var_decl == NULL ? NULL : (var_decl = (g_object_unref (var_decl), NULL))), _tmp26);
	vala_ccode_declaration_set_modifiers (var_decl, VALA_CCODE_MODIFIERS_REGISTER);
	_tmp29 = NULL;
	_tmp28 = NULL;
	_tmp27 = NULL;
	vala_ccode_declaration_add_declarator (var_decl, VALA_CCODE_DECLARATOR ((_tmp29 = vala_ccode_variable_declarator_new_with_initializer ("cc", VALA_CCODE_EXPRESSION ((_tmp28 = vala_ccode_cast_expression_new (VALA_CCODE_EXPRESSION ((_tmp27 = vala_ccode_identifier_new ("closure"))), "GCClosure *")))))));
	(_tmp29 == NULL ? NULL : (_tmp29 = (g_object_unref (_tmp29), NULL)));
	(_tmp28 == NULL ? NULL : (_tmp28 = (g_object_unref (_tmp28), NULL)));
	(_tmp27 == NULL ? NULL : (_tmp27 = (g_object_unref (_tmp27), NULL)));
	vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE (var_decl));
	_tmp30 = NULL;
	var_decl = (_tmp30 = vala_ccode_declaration_new ("gpointer"), (var_decl == NULL ? NULL : (var_decl = (g_object_unref (var_decl), NULL))), _tmp30);
	vala_ccode_declaration_set_modifiers (var_decl, VALA_CCODE_MODIFIERS_REGISTER);
	_tmp31 = NULL;
	vala_ccode_declaration_add_declarator (var_decl, VALA_CCODE_DECLARATOR ((_tmp31 = vala_ccode_variable_declarator_new ("data1"))));
	(_tmp31 == NULL ? NULL : (_tmp31 = (g_object_unref (_tmp31), NULL)));
	_tmp32 = NULL;
	vala_ccode_declaration_add_declarator (var_decl, VALA_CCODE_DECLARATOR ((_tmp32 = vala_ccode_variable_declarator_new ("data2"))));
	(_tmp32 == NULL ? NULL : (_tmp32 = (g_object_unref (_tmp32), NULL)));
	vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE (var_decl));
	fc = NULL;
	if (vala_data_type_get_data_type (vala_signal_get_return_type (sig)) != NULL) {
		ValaCCodeDeclaration* _tmp34;
		char* _tmp33;
		ValaCCodeVariableDeclarator* _tmp35;
		ValaCCodeFunctionCall* _tmp37;
		ValaCCodeIdentifier* _tmp36;
		ValaCCodeBinaryExpression* _tmp40;
		ValaCCodeConstant* _tmp39;
		ValaCCodeIdentifier* _tmp38;
		ValaCCodeExpressionStatement* _tmp41;
		_tmp34 = NULL;
		_tmp33 = NULL;
		var_decl = (_tmp34 = vala_ccode_declaration_new ((_tmp33 = vala_ccode_generator_get_value_type_name_from_type_reference (self, vala_signal_get_return_type (sig)))), (var_decl == NULL ? NULL : (var_decl = (g_object_unref (var_decl), NULL))), _tmp34);
		(_tmp33 = (g_free (_tmp33), NULL));
		_tmp35 = NULL;
		vala_ccode_declaration_add_declarator (var_decl, VALA_CCODE_DECLARATOR ((_tmp35 = vala_ccode_variable_declarator_new ("v_return"))));
		(_tmp35 == NULL ? NULL : (_tmp35 = (g_object_unref (_tmp35), NULL)));
		vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE (var_decl));
		_tmp37 = NULL;
		_tmp36 = NULL;
		fc = (_tmp37 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp36 = vala_ccode_identifier_new ("g_return_if_fail")))), (fc == NULL ? NULL : (fc = (g_object_unref (fc), NULL))), _tmp37);
		(_tmp36 == NULL ? NULL : (_tmp36 = (g_object_unref (_tmp36), NULL)));
		_tmp40 = NULL;
		_tmp39 = NULL;
		_tmp38 = NULL;
		vala_ccode_function_call_add_argument (fc, VALA_CCODE_EXPRESSION ((_tmp40 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, VALA_CCODE_EXPRESSION ((_tmp38 = vala_ccode_identifier_new ("return_value"))), VALA_CCODE_EXPRESSION ((_tmp39 = vala_ccode_constant_new ("NULL")))))));
		(_tmp40 == NULL ? NULL : (_tmp40 = (g_object_unref (_tmp40), NULL)));
		(_tmp39 == NULL ? NULL : (_tmp39 = (g_object_unref (_tmp39), NULL)));
		(_tmp38 == NULL ? NULL : (_tmp38 = (g_object_unref (_tmp38), NULL)));
		_tmp41 = NULL;
		vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE ((_tmp41 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (fc)))));
		(_tmp41 == NULL ? NULL : (_tmp41 = (g_object_unref (_tmp41), NULL)));
	}
	_tmp43 = NULL;
	_tmp42 = NULL;
	fc = (_tmp43 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp42 = vala_ccode_identifier_new ("g_return_if_fail")))), (fc == NULL ? NULL : (fc = (g_object_unref (fc), NULL))), _tmp43);
	(_tmp42 == NULL ? NULL : (_tmp42 = (g_object_unref (_tmp42), NULL)));
	_tmp47 = NULL;
	_tmp46 = NULL;
	_tmp45 = NULL;
	_tmp44 = NULL;
	vala_ccode_function_call_add_argument (fc, VALA_CCODE_EXPRESSION ((_tmp47 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, VALA_CCODE_EXPRESSION ((_tmp44 = vala_ccode_identifier_new ("n_param_values"))), VALA_CCODE_EXPRESSION ((_tmp46 = vala_ccode_constant_new ((_tmp45 = g_strdup_printf ("%i", n_params)))))))));
	(_tmp47 == NULL ? NULL : (_tmp47 = (g_object_unref (_tmp47), NULL)));
	(_tmp46 == NULL ? NULL : (_tmp46 = (g_object_unref (_tmp46), NULL)));
	(_tmp45 = (g_free (_tmp45), NULL));
	(_tmp44 == NULL ? NULL : (_tmp44 = (g_object_unref (_tmp44), NULL)));
	_tmp48 = NULL;
	vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE ((_tmp48 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (fc)))));
	(_tmp48 == NULL ? NULL : (_tmp48 = (g_object_unref (_tmp48), NULL)));
	_tmp49 = NULL;
	_tmp50 = NULL;
	data = (_tmp50 = vala_ccode_member_access_new (VALA_CCODE_EXPRESSION ((_tmp49 = vala_ccode_identifier_new ("closure"))), "data", TRUE), (_tmp49 == NULL ? NULL : (_tmp49 = (g_object_unref (_tmp49), NULL))), _tmp50);
	_tmp52 = NULL;
	_tmp51 = NULL;
	_tmp53 = NULL;
	param = (_tmp53 = vala_ccode_member_access_new (VALA_CCODE_EXPRESSION ((_tmp52 = vala_ccode_member_access_new (VALA_CCODE_EXPRESSION ((_tmp51 = vala_ccode_identifier_new ("param_values"))), "data[0]", TRUE))), "v_pointer", FALSE), (_tmp52 == NULL ? NULL : (_tmp52 = (g_object_unref (_tmp52), NULL))), (_tmp51 == NULL ? NULL : (_tmp51 = (g_object_unref (_tmp51), NULL))), _tmp53);
	_tmp54 = NULL;
	_tmp55 = NULL;
	cond = (_tmp55 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp54 = vala_ccode_constant_new ("G_CCLOSURE_SWAP_DATA")))), (_tmp54 == NULL ? NULL : (_tmp54 = (g_object_unref (_tmp54), NULL))), _tmp55);
	_tmp56 = NULL;
	vala_ccode_function_call_add_argument (cond, VALA_CCODE_EXPRESSION ((_tmp56 = vala_ccode_identifier_new ("closure"))));
	(_tmp56 == NULL ? NULL : (_tmp56 = (g_object_unref (_tmp56), NULL)));
	true_block = vala_ccode_block_new ();
	_tmp59 = NULL;
	_tmp58 = NULL;
	_tmp57 = NULL;
	vala_ccode_block_add_statement (true_block, VALA_CCODE_NODE ((_tmp59 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp58 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp57 = vala_ccode_identifier_new ("data1"))), VALA_CCODE_EXPRESSION (data), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
	(_tmp59 == NULL ? NULL : (_tmp59 = (g_object_unref (_tmp59), NULL)));
	(_tmp58 == NULL ? NULL : (_tmp58 = (g_object_unref (_tmp58), NULL)));
	(_tmp57 == NULL ? NULL : (_tmp57 = (g_object_unref (_tmp57), NULL)));
	_tmp62 = NULL;
	_tmp61 = NULL;
	_tmp60 = NULL;
	vala_ccode_block_add_statement (true_block, VALA_CCODE_NODE ((_tmp62 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp61 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp60 = vala_ccode_identifier_new ("data2"))), VALA_CCODE_EXPRESSION (param), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
	(_tmp62 == NULL ? NULL : (_tmp62 = (g_object_unref (_tmp62), NULL)));
	(_tmp61 == NULL ? NULL : (_tmp61 = (g_object_unref (_tmp61), NULL)));
	(_tmp60 == NULL ? NULL : (_tmp60 = (g_object_unref (_tmp60), NULL)));
	false_block = vala_ccode_block_new ();
	_tmp65 = NULL;
	_tmp64 = NULL;
	_tmp63 = NULL;
	vala_ccode_block_add_statement (false_block, VALA_CCODE_NODE ((_tmp65 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp64 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp63 = vala_ccode_identifier_new ("data1"))), VALA_CCODE_EXPRESSION (param), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
	(_tmp65 == NULL ? NULL : (_tmp65 = (g_object_unref (_tmp65), NULL)));
	(_tmp64 == NULL ? NULL : (_tmp64 = (g_object_unref (_tmp64), NULL)));
	(_tmp63 == NULL ? NULL : (_tmp63 = (g_object_unref (_tmp63), NULL)));
	_tmp68 = NULL;
	_tmp67 = NULL;
	_tmp66 = NULL;
	vala_ccode_block_add_statement (false_block, VALA_CCODE_NODE ((_tmp68 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp67 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp66 = vala_ccode_identifier_new ("data2"))), VALA_CCODE_EXPRESSION (data), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
	(_tmp68 == NULL ? NULL : (_tmp68 = (g_object_unref (_tmp68), NULL)));
	(_tmp67 == NULL ? NULL : (_tmp67 = (g_object_unref (_tmp67), NULL)));
	(_tmp66 == NULL ? NULL : (_tmp66 = (g_object_unref (_tmp66), NULL)));
	_tmp69 = NULL;
	vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE ((_tmp69 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (cond), VALA_CCODE_STATEMENT (true_block), VALA_CCODE_STATEMENT (false_block)))));
	(_tmp69 == NULL ? NULL : (_tmp69 = (g_object_unref (_tmp69), NULL)));
	_tmp77 = NULL;
	_tmp76 = NULL;
	_tmp75 = NULL;
	_tmp74 = NULL;
	_tmp73 = NULL;
	_tmp72 = NULL;
	_tmp71 = NULL;
	_tmp70 = NULL;
	_tmp78 = NULL;
	c_assign = (_tmp78 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp70 = vala_ccode_identifier_new ("callback"))), VALA_CCODE_EXPRESSION ((_tmp77 = vala_ccode_cast_expression_new (VALA_CCODE_EXPRESSION ((_tmp75 = vala_ccode_conditional_expression_new (VALA_CCODE_EXPRESSION ((_tmp71 = vala_ccode_identifier_new ("marshal_data"))), VALA_CCODE_EXPRESSION ((_tmp72 = vala_ccode_identifier_new ("marshal_data"))), VALA_CCODE_EXPRESSION ((_tmp74 = vala_ccode_member_access_new (VALA_CCODE_EXPRESSION ((_tmp73 = vala_ccode_identifier_new ("cc"))), "callback", TRUE)))))), (_tmp76 = vala_ccode_generator_get_signal_marshaller_function (self, sig, "GMarshalFunc"))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (_tmp77 == NULL ? NULL : (_tmp77 = (g_object_unref (_tmp77), NULL))), (_tmp76 = (g_free (_tmp76), NULL)), (_tmp75 == NULL ? NULL : (_tmp75 = (g_object_unref (_tmp75), NULL))), (_tmp74 == NULL ? NULL : (_tmp74 = (g_object_unref (_tmp74), NULL))), (_tmp73 == NULL ? NULL : (_tmp73 = (g_object_unref (_tmp73), NULL))), (_tmp72 == NULL ? NULL : (_tmp72 = (g_object_unref (_tmp72), NULL))), (_tmp71 == NULL ? NULL : (_tmp71 = (g_object_unref (_tmp71), NULL))), (_tmp70 == NULL ? NULL : (_tmp70 = (g_object_unref (_tmp70), NULL))), _tmp78);
	_tmp79 = NULL;
	vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE ((_tmp79 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (c_assign)))));
	(_tmp79 == NULL ? NULL : (_tmp79 = (g_object_unref (_tmp79), NULL)));
	_tmp81 = NULL;
	_tmp80 = NULL;
	fc = (_tmp81 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp80 = vala_ccode_identifier_new ("callback")))), (fc == NULL ? NULL : (fc = (g_object_unref (fc), NULL))), _tmp81);
	(_tmp80 == NULL ? NULL : (_tmp80 = (g_object_unref (_tmp80), NULL)));
	_tmp82 = NULL;
	vala_ccode_function_call_add_argument (fc, VALA_CCODE_EXPRESSION ((_tmp82 = vala_ccode_identifier_new ("data1"))));
	(_tmp82 == NULL ? NULL : (_tmp82 = (g_object_unref (_tmp82), NULL)));
	i = 1;
	{
		GeeCollection* p_collection;
		GeeIterator* p_it;
		p_collection = params;
		p_it = gee_iterable_iterator (GEE_ITERABLE (p_collection));
		while (gee_iterator_next (p_it)) {
			ValaFormalParameter* p;
			p = gee_iterator_get (p_it);
			{
				char* get_value_function;
				ValaCCodeIdentifier* _tmp85;
				ValaCCodeFunctionCall* _tmp86;
				ValaCCodeFunctionCall* inner_fc;
				ValaCCodeBinaryExpression* _tmp90;
				ValaCCodeIdentifier* _tmp89;
				char* _tmp88;
				ValaCCodeIdentifier* _tmp87;
				get_value_function = NULL;
				if (VALA_IS_POINTER_TYPE (vala_formal_parameter_get_type_reference (p)) || vala_data_type_get_type_parameter (vala_formal_parameter_get_type_reference (p)) != NULL || vala_data_type_get_is_ref (vala_formal_parameter_get_type_reference (p)) || vala_data_type_get_is_out (vala_formal_parameter_get_type_reference (p))) {
					char* _tmp83;
					_tmp83 = NULL;
					get_value_function = (_tmp83 = g_strdup ("g_value_get_pointer"), (get_value_function = (g_free (get_value_function), NULL)), _tmp83);
				} else {
					char* _tmp84;
					_tmp84 = NULL;
					get_value_function = (_tmp84 = vala_typesymbol_get_get_value_function (vala_data_type_get_data_type (vala_formal_parameter_get_type_reference (p))), (get_value_function = (g_free (get_value_function), NULL)), _tmp84);
				}
				_tmp85 = NULL;
				_tmp86 = NULL;
				inner_fc = (_tmp86 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp85 = vala_ccode_identifier_new (get_value_function)))), (_tmp85 == NULL ? NULL : (_tmp85 = (g_object_unref (_tmp85), NULL))), _tmp86);
				_tmp90 = NULL;
				_tmp89 = NULL;
				_tmp88 = NULL;
				_tmp87 = NULL;
				vala_ccode_function_call_add_argument (inner_fc, VALA_CCODE_EXPRESSION ((_tmp90 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, VALA_CCODE_EXPRESSION ((_tmp87 = vala_ccode_identifier_new ("param_values"))), VALA_CCODE_EXPRESSION ((_tmp89 = vala_ccode_identifier_new ((_tmp88 = g_strdup_printf ("%i", i)))))))));
				(_tmp90 == NULL ? NULL : (_tmp90 = (g_object_unref (_tmp90), NULL)));
				(_tmp89 == NULL ? NULL : (_tmp89 = (g_object_unref (_tmp89), NULL)));
				(_tmp88 = (g_free (_tmp88), NULL));
				(_tmp87 == NULL ? NULL : (_tmp87 = (g_object_unref (_tmp87), NULL)));
				vala_ccode_function_call_add_argument (fc, VALA_CCODE_EXPRESSION (inner_fc));
				i++;
				(p == NULL ? NULL : (p = (g_object_unref (p), NULL)));
				(get_value_function = (g_free (get_value_function), NULL));
				(inner_fc == NULL ? NULL : (inner_fc = (g_object_unref (inner_fc), NULL)));
			}
		}
		(p_it == NULL ? NULL : (p_it = (g_object_unref (p_it), NULL)));
	}
	_tmp91 = NULL;
	vala_ccode_function_call_add_argument (fc, VALA_CCODE_EXPRESSION ((_tmp91 = vala_ccode_identifier_new ("data2"))));
	(_tmp91 == NULL ? NULL : (_tmp91 = (g_object_unref (_tmp91), NULL)));
	if (vala_data_type_get_data_type (vala_signal_get_return_type (sig)) != NULL) {
		ValaCCodeExpressionStatement* _tmp94;
		ValaCCodeAssignment* _tmp93;
		ValaCCodeIdentifier* _tmp92;
		ValaCCodeFunctionCall* set_fc;
		ValaCCodeIdentifier* _tmp104;
		ValaCCodeIdentifier* _tmp105;
		ValaCCodeExpressionStatement* _tmp106;
		_tmp94 = NULL;
		_tmp93 = NULL;
		_tmp92 = NULL;
		vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE ((_tmp94 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp93 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp92 = vala_ccode_identifier_new ("v_return"))), VALA_CCODE_EXPRESSION (fc), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
		(_tmp94 == NULL ? NULL : (_tmp94 = (g_object_unref (_tmp94), NULL)));
		(_tmp93 == NULL ? NULL : (_tmp93 = (g_object_unref (_tmp93), NULL)));
		(_tmp92 == NULL ? NULL : (_tmp92 = (g_object_unref (_tmp92), NULL)));
		set_fc = NULL;
		if (vala_data_type_get_type_parameter (vala_signal_get_return_type (sig)) != NULL) {
			ValaCCodeFunctionCall* _tmp96;
			ValaCCodeIdentifier* _tmp95;
			_tmp96 = NULL;
			_tmp95 = NULL;
			set_fc = (_tmp96 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp95 = vala_ccode_identifier_new ("g_value_set_pointer")))), (set_fc == NULL ? NULL : (set_fc = (g_object_unref (set_fc), NULL))), _tmp96);
			(_tmp95 == NULL ? NULL : (_tmp95 = (g_object_unref (_tmp95), NULL)));
		} else {
			if (VALA_IS_CLASS (vala_data_type_get_data_type (vala_signal_get_return_type (sig))) || VALA_IS_INTERFACE (vala_data_type_get_data_type (vala_signal_get_return_type (sig)))) {
				ValaCCodeFunctionCall* _tmp98;
				ValaCCodeIdentifier* _tmp97;
				_tmp98 = NULL;
				_tmp97 = NULL;
				set_fc = (_tmp98 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp97 = vala_ccode_identifier_new ("g_value_take_object")))), (set_fc == NULL ? NULL : (set_fc = (g_object_unref (set_fc), NULL))), _tmp98);
				(_tmp97 == NULL ? NULL : (_tmp97 = (g_object_unref (_tmp97), NULL)));
			} else {
				if (vala_data_type_get_data_type (vala_signal_get_return_type (sig)) == vala_data_type_get_data_type (self->string_type)) {
					ValaCCodeFunctionCall* _tmp100;
					ValaCCodeIdentifier* _tmp99;
					_tmp100 = NULL;
					_tmp99 = NULL;
					set_fc = (_tmp100 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp99 = vala_ccode_identifier_new ("g_value_take_string")))), (set_fc == NULL ? NULL : (set_fc = (g_object_unref (set_fc), NULL))), _tmp100);
					(_tmp99 == NULL ? NULL : (_tmp99 = (g_object_unref (_tmp99), NULL)));
				} else {
					ValaCCodeFunctionCall* _tmp103;
					ValaCCodeIdentifier* _tmp102;
					char* _tmp101;
					_tmp103 = NULL;
					_tmp102 = NULL;
					_tmp101 = NULL;
					set_fc = (_tmp103 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp102 = vala_ccode_identifier_new ((_tmp101 = vala_typesymbol_get_set_value_function (vala_data_type_get_data_type (vala_signal_get_return_type (sig)))))))), (set_fc == NULL ? NULL : (set_fc = (g_object_unref (set_fc), NULL))), _tmp103);
					(_tmp102 == NULL ? NULL : (_tmp102 = (g_object_unref (_tmp102), NULL)));
					(_tmp101 = (g_free (_tmp101), NULL));
				}
			}
		}
		_tmp104 = NULL;
		vala_ccode_function_call_add_argument (set_fc, VALA_CCODE_EXPRESSION ((_tmp104 = vala_ccode_identifier_new ("return_value"))));
		(_tmp104 == NULL ? NULL : (_tmp104 = (g_object_unref (_tmp104), NULL)));
		_tmp105 = NULL;
		vala_ccode_function_call_add_argument (set_fc, VALA_CCODE_EXPRESSION ((_tmp105 = vala_ccode_identifier_new ("v_return"))));
		(_tmp105 == NULL ? NULL : (_tmp105 = (g_object_unref (_tmp105), NULL)));
		_tmp106 = NULL;
		vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE ((_tmp106 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (set_fc)))));
		(_tmp106 == NULL ? NULL : (_tmp106 = (g_object_unref (_tmp106), NULL)));
		(set_fc == NULL ? NULL : (set_fc = (g_object_unref (set_fc), NULL)));
	} else {
		ValaCCodeExpressionStatement* _tmp107;
		_tmp107 = NULL;
		vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE ((_tmp107 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (fc)))));
		(_tmp107 == NULL ? NULL : (_tmp107 = (g_object_unref (_tmp107), NULL)));
	}
	vala_ccode_function_set_block (signal_marshaller, marshaller_body);
	vala_ccode_fragment_append (self->priv->source_signal_marshaller_definition, VALA_CCODE_NODE (signal_marshaller));
	gee_collection_add (GEE_COLLECTION (self->priv->user_marshal_set), signature);
	(signature = (g_free (signature), NULL));
	(params == NULL ? NULL : (params = (g_object_unref (params), NULL)));
	(signal_marshaller == NULL ? NULL : (signal_marshaller = (g_object_unref (signal_marshaller), NULL)));
	(marshaller_body == NULL ? NULL : (marshaller_body = (g_object_unref (marshaller_body), NULL)));
	(callback_decl == NULL ? NULL : (callback_decl = (g_object_unref (callback_decl), NULL)));
	(var_decl == NULL ? NULL : (var_decl = (g_object_unref (var_decl), NULL)));
	(fc == NULL ? NULL : (fc = (g_object_unref (fc), NULL)));
	(data == NULL ? NULL : (data = (g_object_unref (data), NULL)));
	(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
	(cond == NULL ? NULL : (cond = (g_object_unref (cond), NULL)));
	(true_block == NULL ? NULL : (true_block = (g_object_unref (true_block), NULL)));
	(false_block == NULL ? NULL : (false_block = (g_object_unref (false_block), NULL)));
	(c_assign == NULL ? NULL : (c_assign = (g_object_unref (c_assign), NULL)));
}


static ValaCCodeIncludeDirective* vala_ccode_generator_get_internal_include (ValaCCodeGenerator* self, const char* filename) {
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	return vala_ccode_include_directive_new (filename, vala_code_context_get_library (self->priv->context) == NULL);
}


static ValaCCodeForStatement* vala_ccode_generator_get_vala_array_free_loop (ValaCCodeGenerator* self, gboolean have_length) {
	ValaCCodeBlock* cbody;
	ValaCCodeIdentifier* _tmp0;
	ValaCCodeCastExpression* _tmp1;
	ValaCCodeCastExpression* cptrarray;
	ValaCCodeIdentifier* _tmp2;
	ValaCCodeElementAccess* _tmp3;
	ValaCCodeElementAccess* cea;
	ValaCCodeIdentifier* _tmp4;
	ValaCCodeFunctionCall* _tmp5;
	ValaCCodeFunctionCall* cfreecall;
	ValaCCodeExpression* cforcond;
	ValaCCodeForStatement* cfor;
	ValaCCodeAssignment* _tmp18;
	ValaCCodeConstant* _tmp17;
	ValaCCodeIdentifier* _tmp16;
	ValaCCodeAssignment* _tmp23;
	ValaCCodeBinaryExpression* _tmp22;
	ValaCCodeConstant* _tmp21;
	ValaCCodeIdentifier* _tmp20;
	ValaCCodeIdentifier* _tmp19;
	ValaCCodeForStatement* _tmp24;
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (self), NULL);
	cbody = vala_ccode_block_new ();
	_tmp0 = NULL;
	_tmp1 = NULL;
	cptrarray = (_tmp1 = vala_ccode_cast_expression_new (VALA_CCODE_EXPRESSION ((_tmp0 = vala_ccode_identifier_new ("array"))), "gpointer*"), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1);
	_tmp2 = NULL;
	_tmp3 = NULL;
	cea = (_tmp3 = vala_ccode_element_access_new (VALA_CCODE_EXPRESSION (cptrarray), VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_identifier_new ("i")))), (_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL))), _tmp3);
	_tmp4 = NULL;
	_tmp5 = NULL;
	cfreecall = (_tmp5 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp4 = vala_ccode_identifier_new ("destroy_func")))), (_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL))), _tmp5);
	vala_ccode_function_call_add_argument (cfreecall, VALA_CCODE_EXPRESSION (cea));
	cforcond = NULL;
	if (have_length) {
		ValaCCodeConstant* _tmp6;
		ValaCCodeBinaryExpression* _tmp7;
		ValaCCodeBinaryExpression* cfreecond;
		ValaCCodeExpression* _tmp10;
		ValaCCodeIdentifier* _tmp9;
		ValaCCodeIdentifier* _tmp8;
		ValaCCodeIfStatement* _tmp12;
		ValaCCodeExpressionStatement* _tmp11;
		_tmp6 = NULL;
		_tmp7 = NULL;
		cfreecond = (_tmp7 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, VALA_CCODE_EXPRESSION (cea), VALA_CCODE_EXPRESSION ((_tmp6 = vala_ccode_constant_new ("NULL")))), (_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL))), _tmp7);
		_tmp10 = NULL;
		_tmp9 = NULL;
		_tmp8 = NULL;
		cforcond = (_tmp10 = VALA_CCODE_EXPRESSION (vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_LESS_THAN, VALA_CCODE_EXPRESSION ((_tmp8 = vala_ccode_identifier_new ("i"))), VALA_CCODE_EXPRESSION ((_tmp9 = vala_ccode_identifier_new ("array_length"))))), (cforcond == NULL ? NULL : (cforcond = (g_object_unref (cforcond), NULL))), _tmp10);
		(_tmp9 == NULL ? NULL : (_tmp9 = (g_object_unref (_tmp9), NULL)));
		(_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL)));
		_tmp12 = NULL;
		_tmp11 = NULL;
		vala_ccode_block_add_statement (cbody, VALA_CCODE_NODE ((_tmp12 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (cfreecond), VALA_CCODE_STATEMENT ((_tmp11 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cfreecall)))), NULL))));
		(_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL)));
		(_tmp11 == NULL ? NULL : (_tmp11 = (g_object_unref (_tmp11), NULL)));
		(cfreecond == NULL ? NULL : (cfreecond = (g_object_unref (cfreecond), NULL)));
	} else {
		ValaCCodeExpression* _tmp14;
		ValaCCodeConstant* _tmp13;
		ValaCCodeExpressionStatement* _tmp15;
		_tmp14 = NULL;
		_tmp13 = NULL;
		cforcond = (_tmp14 = VALA_CCODE_EXPRESSION (vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, VALA_CCODE_EXPRESSION (cea), VALA_CCODE_EXPRESSION ((_tmp13 = vala_ccode_constant_new ("NULL"))))), (cforcond == NULL ? NULL : (cforcond = (g_object_unref (cforcond), NULL))), _tmp14);
		(_tmp13 == NULL ? NULL : (_tmp13 = (g_object_unref (_tmp13), NULL)));
		_tmp15 = NULL;
		vala_ccode_block_add_statement (cbody, VALA_CCODE_NODE ((_tmp15 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cfreecall)))));
		(_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL)));
	}
	cfor = vala_ccode_for_statement_new (cforcond, VALA_CCODE_STATEMENT (cbody));
	_tmp18 = NULL;
	_tmp17 = NULL;
	_tmp16 = NULL;
	vala_ccode_for_statement_add_initializer (cfor, VALA_CCODE_EXPRESSION ((_tmp18 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp16 = vala_ccode_identifier_new ("i"))), VALA_CCODE_EXPRESSION ((_tmp17 = vala_ccode_constant_new ("0"))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
	(_tmp18 == NULL ? NULL : (_tmp18 = (g_object_unref (_tmp18), NULL)));
	(_tmp17 == NULL ? NULL : (_tmp17 = (g_object_unref (_tmp17), NULL)));
	(_tmp16 == NULL ? NULL : (_tmp16 = (g_object_unref (_tmp16), NULL)));
	_tmp23 = NULL;
	_tmp22 = NULL;
	_tmp21 = NULL;
	_tmp20 = NULL;
	_tmp19 = NULL;
	vala_ccode_for_statement_add_iterator (cfor, VALA_CCODE_EXPRESSION ((_tmp23 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp19 = vala_ccode_identifier_new ("i"))), VALA_CCODE_EXPRESSION ((_tmp22 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, VALA_CCODE_EXPRESSION ((_tmp20 = vala_ccode_identifier_new ("i"))), VALA_CCODE_EXPRESSION ((_tmp21 = vala_ccode_constant_new ("1")))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
	(_tmp23 == NULL ? NULL : (_tmp23 = (g_object_unref (_tmp23), NULL)));
	(_tmp22 == NULL ? NULL : (_tmp22 = (g_object_unref (_tmp22), NULL)));
	(_tmp21 == NULL ? NULL : (_tmp21 = (g_object_unref (_tmp21), NULL)));
	(_tmp20 == NULL ? NULL : (_tmp20 = (g_object_unref (_tmp20), NULL)));
	(_tmp19 == NULL ? NULL : (_tmp19 = (g_object_unref (_tmp19), NULL)));
	_tmp24 = NULL;
	return (_tmp24 = cfor, (cbody == NULL ? NULL : (cbody = (g_object_unref (cbody), NULL))), (cptrarray == NULL ? NULL : (cptrarray = (g_object_unref (cptrarray), NULL))), (cea == NULL ? NULL : (cea = (g_object_unref (cea), NULL))), (cfreecall == NULL ? NULL : (cfreecall = (g_object_unref (cfreecall), NULL))), (cforcond == NULL ? NULL : (cforcond = (g_object_unref (cforcond), NULL))), _tmp24);
}


static void vala_ccode_generator_append_vala_array_free (ValaCCodeGenerator* self) {
	ValaCCodeFunction* fun;
	ValaCCodeFormalParameter* _tmp0;
	ValaCCodeFormalParameter* _tmp1;
	ValaCCodeFormalParameter* _tmp2;
	ValaCCodeFunction* _tmp3;
	ValaCCodeBlock* cdofree;
	ValaCCodeDeclaration* citdecl;
	ValaCCodeVariableDeclarator* _tmp4;
	ValaCCodeConstant* _tmp6;
	ValaCCodeIdentifier* _tmp5;
	ValaCCodeBinaryExpression* _tmp7;
	ValaCCodeBinaryExpression* clencheck;
	ValaCCodeForStatement* _tmp9;
	ValaCCodeForStatement* _tmp8;
	ValaCCodeIfStatement* _tmp10;
	ValaCCodeIfStatement* ciflen;
	ValaCCodeConstant* _tmp12;
	ValaCCodeIdentifier* _tmp11;
	ValaCCodeBinaryExpression* _tmp13;
	ValaCCodeBinaryExpression* ccondarr;
	ValaCCodeConstant* _tmp15;
	ValaCCodeIdentifier* _tmp14;
	ValaCCodeBinaryExpression* _tmp16;
	ValaCCodeBinaryExpression* ccondfunc;
	ValaCCodeBinaryExpression* _tmp17;
	ValaCCodeIfStatement* _tmp18;
	ValaCCodeIfStatement* cif;
	ValaCCodeBlock* _tmp19;
	ValaCCodeIdentifier* _tmp20;
	ValaCCodeFunctionCall* _tmp21;
	ValaCCodeFunctionCall* carrfree;
	ValaCCodeIdentifier* _tmp22;
	ValaCCodeExpressionStatement* _tmp23;
	g_return_if_fail (VALA_IS_CCODE_GENERATOR (self));
	fun = vala_ccode_function_new ("_vala_array_free", "void");
	vala_ccode_function_set_modifiers (fun, VALA_CCODE_MODIFIERS_STATIC);
	_tmp0 = NULL;
	vala_ccode_function_add_parameter (fun, (_tmp0 = vala_ccode_formal_parameter_new ("array", "gpointer")));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	_tmp1 = NULL;
	vala_ccode_function_add_parameter (fun, (_tmp1 = vala_ccode_formal_parameter_new ("array_length", "gint")));
	(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
	_tmp2 = NULL;
	vala_ccode_function_add_parameter (fun, (_tmp2 = vala_ccode_formal_parameter_new ("destroy_func", "GDestroyNotify")));
	(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
	_tmp3 = NULL;
	vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE ((_tmp3 = vala_ccode_function_copy (fun))));
	(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
	cdofree = vala_ccode_block_new ();
	citdecl = vala_ccode_declaration_new ("int");
	_tmp4 = NULL;
	vala_ccode_declaration_add_declarator (citdecl, VALA_CCODE_DECLARATOR ((_tmp4 = vala_ccode_variable_declarator_new ("i"))));
	(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
	vala_ccode_block_add_statement (cdofree, VALA_CCODE_NODE (citdecl));
	_tmp6 = NULL;
	_tmp5 = NULL;
	_tmp7 = NULL;
	clencheck = (_tmp7 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL, VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_identifier_new ("array_length"))), VALA_CCODE_EXPRESSION ((_tmp6 = vala_ccode_constant_new ("0")))), (_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL))), (_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL))), _tmp7);
	_tmp9 = NULL;
	_tmp8 = NULL;
	_tmp10 = NULL;
	ciflen = (_tmp10 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (clencheck), VALA_CCODE_STATEMENT ((_tmp8 = vala_ccode_generator_get_vala_array_free_loop (self, TRUE))), VALA_CCODE_STATEMENT ((_tmp9 = vala_ccode_generator_get_vala_array_free_loop (self, FALSE)))), (_tmp9 == NULL ? NULL : (_tmp9 = (g_object_unref (_tmp9), NULL))), (_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL))), _tmp10);
	vala_ccode_block_add_statement (cdofree, VALA_CCODE_NODE (ciflen));
	_tmp12 = NULL;
	_tmp11 = NULL;
	_tmp13 = NULL;
	ccondarr = (_tmp13 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, VALA_CCODE_EXPRESSION ((_tmp11 = vala_ccode_identifier_new ("array"))), VALA_CCODE_EXPRESSION ((_tmp12 = vala_ccode_constant_new ("NULL")))), (_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL))), (_tmp11 == NULL ? NULL : (_tmp11 = (g_object_unref (_tmp11), NULL))), _tmp13);
	_tmp15 = NULL;
	_tmp14 = NULL;
	_tmp16 = NULL;
	ccondfunc = (_tmp16 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, VALA_CCODE_EXPRESSION ((_tmp14 = vala_ccode_identifier_new ("destroy_func"))), VALA_CCODE_EXPRESSION ((_tmp15 = vala_ccode_constant_new ("NULL")))), (_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL))), (_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL))), _tmp16);
	_tmp17 = NULL;
	_tmp18 = NULL;
	cif = (_tmp18 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION ((_tmp17 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_AND, VALA_CCODE_EXPRESSION (ccondarr), VALA_CCODE_EXPRESSION (ccondfunc)))), VALA_CCODE_STATEMENT (cdofree), NULL), (_tmp17 == NULL ? NULL : (_tmp17 = (g_object_unref (_tmp17), NULL))), _tmp18);
	_tmp19 = NULL;
	vala_ccode_function_set_block (fun, (_tmp19 = vala_ccode_block_new ()));
	(_tmp19 == NULL ? NULL : (_tmp19 = (g_object_unref (_tmp19), NULL)));
	vala_ccode_block_add_statement (vala_ccode_function_get_block (fun), VALA_CCODE_NODE (cif));
	_tmp20 = NULL;
	_tmp21 = NULL;
	carrfree = (_tmp21 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp20 = vala_ccode_identifier_new ("g_free")))), (_tmp20 == NULL ? NULL : (_tmp20 = (g_object_unref (_tmp20), NULL))), _tmp21);
	_tmp22 = NULL;
	vala_ccode_function_call_add_argument (carrfree, VALA_CCODE_EXPRESSION ((_tmp22 = vala_ccode_identifier_new ("array"))));
	(_tmp22 == NULL ? NULL : (_tmp22 = (g_object_unref (_tmp22), NULL)));
	_tmp23 = NULL;
	vala_ccode_block_add_statement (vala_ccode_function_get_block (fun), VALA_CCODE_NODE ((_tmp23 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (carrfree)))));
	(_tmp23 == NULL ? NULL : (_tmp23 = (g_object_unref (_tmp23), NULL)));
	vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (fun));
	(fun == NULL ? NULL : (fun = (g_object_unref (fun), NULL)));
	(cdofree == NULL ? NULL : (cdofree = (g_object_unref (cdofree), NULL)));
	(citdecl == NULL ? NULL : (citdecl = (g_object_unref (citdecl), NULL)));
	(clencheck == NULL ? NULL : (clencheck = (g_object_unref (clencheck), NULL)));
	(ciflen == NULL ? NULL : (ciflen = (g_object_unref (ciflen), NULL)));
	(ccondarr == NULL ? NULL : (ccondarr = (g_object_unref (ccondarr), NULL)));
	(ccondfunc == NULL ? NULL : (ccondfunc = (g_object_unref (ccondfunc), NULL)));
	(cif == NULL ? NULL : (cif = (g_object_unref (cif), NULL)));
	(carrfree == NULL ? NULL : (carrfree = (g_object_unref (carrfree), NULL)));
}


static void vala_ccode_generator_append_vala_array_move (ValaCCodeGenerator* self) {
	ValaCCodeFunction* fun;
	ValaCCodeFormalParameter* _tmp0;
	ValaCCodeFormalParameter* _tmp1;
	ValaCCodeFormalParameter* _tmp2;
	ValaCCodeFormalParameter* _tmp3;
	ValaCCodeFormalParameter* _tmp4;
	ValaCCodeFunction* _tmp5;
	ValaCCodeIdentifier* array;
	ValaCCodeIdentifier* element_size;
	ValaCCodeIdentifier* length;
	ValaCCodeIdentifier* src;
	ValaCCodeIdentifier* dest;
	ValaCCodeBinaryExpression* _tmp6;
	ValaCCodeBinaryExpression* _tmp7;
	ValaCCodeBinaryExpression* src_address;
	ValaCCodeBinaryExpression* _tmp8;
	ValaCCodeBinaryExpression* _tmp9;
	ValaCCodeBinaryExpression* dest_address;
	ValaCCodeBinaryExpression* _tmp12;
	ValaCCodeParenthesizedExpression* _tmp11;
	ValaCCodeBinaryExpression* _tmp10;
	ValaCCodeBinaryExpression* _tmp13;
	ValaCCodeBinaryExpression* dest_end_address;
	ValaCCodeBlock* _tmp14;
	ValaCCodeIdentifier* _tmp15;
	ValaCCodeFunctionCall* _tmp16;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeBinaryExpression* _tmp17;
	ValaCCodeExpressionStatement* _tmp18;
	ValaCCodeIdentifier* _tmp19;
	ValaCCodeFunctionCall* _tmp20;
	ValaCCodeFunctionCall* czero1;
	ValaCCodeCastExpression* _tmp21;
	ValaCCodeConstant* _tmp22;
	ValaCCodeBinaryExpression* _tmp25;
	ValaCCodeParenthesizedExpression* _tmp24;
	ValaCCodeBinaryExpression* _tmp23;
	ValaCCodeBlock* czeroblock1;
	ValaCCodeExpressionStatement* _tmp26;
	ValaCCodeIdentifier* _tmp27;
	ValaCCodeFunctionCall* _tmp28;
	ValaCCodeFunctionCall* czero2;
	ValaCCodeCastExpression* _tmp29;
	ValaCCodeConstant* _tmp30;
	ValaCCodeBinaryExpression* _tmp33;
	ValaCCodeParenthesizedExpression* _tmp32;
	ValaCCodeBinaryExpression* _tmp31;
	ValaCCodeBlock* czeroblock2;
	ValaCCodeExpressionStatement* _tmp34;
	ValaCCodeIfStatement* _tmp36;
	ValaCCodeBinaryExpression* _tmp35;
	g_return_if_fail (VALA_IS_CCODE_GENERATOR (self));
	self->priv->string_h_needed = TRUE;
	/* assumes that overwritten array elements are null before invocation
	 FIXME will leak memory if that's not the case*/
	fun = vala_ccode_function_new ("_vala_array_move", "void");
	vala_ccode_function_set_modifiers (fun, VALA_CCODE_MODIFIERS_STATIC);
	_tmp0 = NULL;
	vala_ccode_function_add_parameter (fun, (_tmp0 = vala_ccode_formal_parameter_new ("array", "gpointer")));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	_tmp1 = NULL;
	vala_ccode_function_add_parameter (fun, (_tmp1 = vala_ccode_formal_parameter_new ("element_size", "gsize")));
	(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
	_tmp2 = NULL;
	vala_ccode_function_add_parameter (fun, (_tmp2 = vala_ccode_formal_parameter_new ("src", "gint")));
	(_tmp2 == NULL ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL)));
	_tmp3 = NULL;
	vala_ccode_function_add_parameter (fun, (_tmp3 = vala_ccode_formal_parameter_new ("dest", "gint")));
	(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
	_tmp4 = NULL;
	vala_ccode_function_add_parameter (fun, (_tmp4 = vala_ccode_formal_parameter_new ("length", "gint")));
	(_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL)));
	_tmp5 = NULL;
	vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE ((_tmp5 = vala_ccode_function_copy (fun))));
	(_tmp5 == NULL ? NULL : (_tmp5 = (g_object_unref (_tmp5), NULL)));
	array = vala_ccode_identifier_new ("array");
	element_size = vala_ccode_identifier_new ("element_size");
	length = vala_ccode_identifier_new ("length");
	src = vala_ccode_identifier_new ("src");
	dest = vala_ccode_identifier_new ("dest");
	_tmp6 = NULL;
	_tmp7 = NULL;
	src_address = (_tmp7 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, VALA_CCODE_EXPRESSION (array), VALA_CCODE_EXPRESSION ((_tmp6 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, VALA_CCODE_EXPRESSION (src), VALA_CCODE_EXPRESSION (element_size))))), (_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL))), _tmp7);
	_tmp8 = NULL;
	_tmp9 = NULL;
	dest_address = (_tmp9 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, VALA_CCODE_EXPRESSION (array), VALA_CCODE_EXPRESSION ((_tmp8 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, VALA_CCODE_EXPRESSION (dest), VALA_CCODE_EXPRESSION (element_size))))), (_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL))), _tmp9);
	_tmp12 = NULL;
	_tmp11 = NULL;
	_tmp10 = NULL;
	_tmp13 = NULL;
	dest_end_address = (_tmp13 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, VALA_CCODE_EXPRESSION (array), VALA_CCODE_EXPRESSION ((_tmp12 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, VALA_CCODE_EXPRESSION ((_tmp11 = vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION ((_tmp10 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, VALA_CCODE_EXPRESSION (dest), VALA_CCODE_EXPRESSION (length))))))), VALA_CCODE_EXPRESSION (element_size))))), (_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL))), (_tmp11 == NULL ? NULL : (_tmp11 = (g_object_unref (_tmp11), NULL))), (_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL))), _tmp13);
	_tmp14 = NULL;
	vala_ccode_function_set_block (fun, (_tmp14 = vala_ccode_block_new ()));
	(_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL)));
	_tmp15 = NULL;
	_tmp16 = NULL;
	ccall = (_tmp16 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp15 = vala_ccode_identifier_new ("g_memmove")))), (_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL))), _tmp16);
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (dest_address));
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (src_address));
	_tmp17 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp17 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, VALA_CCODE_EXPRESSION (length), VALA_CCODE_EXPRESSION (element_size)))));
	(_tmp17 == NULL ? NULL : (_tmp17 = (g_object_unref (_tmp17), NULL)));
	_tmp18 = NULL;
	vala_ccode_block_add_statement (vala_ccode_function_get_block (fun), VALA_CCODE_NODE ((_tmp18 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
	(_tmp18 == NULL ? NULL : (_tmp18 = (g_object_unref (_tmp18), NULL)));
	_tmp19 = NULL;
	_tmp20 = NULL;
	czero1 = (_tmp20 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp19 = vala_ccode_identifier_new ("memset")))), (_tmp19 == NULL ? NULL : (_tmp19 = (g_object_unref (_tmp19), NULL))), _tmp20);
	_tmp21 = NULL;
	vala_ccode_function_call_add_argument (czero1, VALA_CCODE_EXPRESSION ((_tmp21 = vala_ccode_cast_expression_new (VALA_CCODE_EXPRESSION (src_address), "char *"))));
	(_tmp21 == NULL ? NULL : (_tmp21 = (g_object_unref (_tmp21), NULL)));
	_tmp22 = NULL;
	vala_ccode_function_call_add_argument (czero1, VALA_CCODE_EXPRESSION ((_tmp22 = vala_ccode_constant_new ("0"))));
	(_tmp22 == NULL ? NULL : (_tmp22 = (g_object_unref (_tmp22), NULL)));
	_tmp25 = NULL;
	_tmp24 = NULL;
	_tmp23 = NULL;
	vala_ccode_function_call_add_argument (czero1, VALA_CCODE_EXPRESSION ((_tmp25 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, VALA_CCODE_EXPRESSION ((_tmp24 = vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION ((_tmp23 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, VALA_CCODE_EXPRESSION (dest), VALA_CCODE_EXPRESSION (src))))))), VALA_CCODE_EXPRESSION (element_size)))));
	(_tmp25 == NULL ? NULL : (_tmp25 = (g_object_unref (_tmp25), NULL)));
	(_tmp24 == NULL ? NULL : (_tmp24 = (g_object_unref (_tmp24), NULL)));
	(_tmp23 == NULL ? NULL : (_tmp23 = (g_object_unref (_tmp23), NULL)));
	czeroblock1 = vala_ccode_block_new ();
	_tmp26 = NULL;
	vala_ccode_block_add_statement (czeroblock1, VALA_CCODE_NODE ((_tmp26 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (czero1)))));
	(_tmp26 == NULL ? NULL : (_tmp26 = (g_object_unref (_tmp26), NULL)));
	_tmp27 = NULL;
	_tmp28 = NULL;
	czero2 = (_tmp28 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp27 = vala_ccode_identifier_new ("memset")))), (_tmp27 == NULL ? NULL : (_tmp27 = (g_object_unref (_tmp27), NULL))), _tmp28);
	_tmp29 = NULL;
	vala_ccode_function_call_add_argument (czero2, VALA_CCODE_EXPRESSION ((_tmp29 = vala_ccode_cast_expression_new (VALA_CCODE_EXPRESSION (dest_end_address), "char *"))));
	(_tmp29 == NULL ? NULL : (_tmp29 = (g_object_unref (_tmp29), NULL)));
	_tmp30 = NULL;
	vala_ccode_function_call_add_argument (czero2, VALA_CCODE_EXPRESSION ((_tmp30 = vala_ccode_constant_new ("0"))));
	(_tmp30 == NULL ? NULL : (_tmp30 = (g_object_unref (_tmp30), NULL)));
	_tmp33 = NULL;
	_tmp32 = NULL;
	_tmp31 = NULL;
	vala_ccode_function_call_add_argument (czero2, VALA_CCODE_EXPRESSION ((_tmp33 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, VALA_CCODE_EXPRESSION ((_tmp32 = vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION ((_tmp31 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, VALA_CCODE_EXPRESSION (src), VALA_CCODE_EXPRESSION (dest))))))), VALA_CCODE_EXPRESSION (element_size)))));
	(_tmp33 == NULL ? NULL : (_tmp33 = (g_object_unref (_tmp33), NULL)));
	(_tmp32 == NULL ? NULL : (_tmp32 = (g_object_unref (_tmp32), NULL)));
	(_tmp31 == NULL ? NULL : (_tmp31 = (g_object_unref (_tmp31), NULL)));
	czeroblock2 = vala_ccode_block_new ();
	_tmp34 = NULL;
	vala_ccode_block_add_statement (czeroblock2, VALA_CCODE_NODE ((_tmp34 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (czero2)))));
	(_tmp34 == NULL ? NULL : (_tmp34 = (g_object_unref (_tmp34), NULL)));
	_tmp36 = NULL;
	_tmp35 = NULL;
	vala_ccode_block_add_statement (vala_ccode_function_get_block (fun), VALA_CCODE_NODE ((_tmp36 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION ((_tmp35 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_LESS_THAN, VALA_CCODE_EXPRESSION (src), VALA_CCODE_EXPRESSION (dest)))), VALA_CCODE_STATEMENT (czeroblock1), VALA_CCODE_STATEMENT (czeroblock2)))));
	(_tmp36 == NULL ? NULL : (_tmp36 = (g_object_unref (_tmp36), NULL)));
	(_tmp35 == NULL ? NULL : (_tmp35 = (g_object_unref (_tmp35), NULL)));
	vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (fun));
	(fun == NULL ? NULL : (fun = (g_object_unref (fun), NULL)));
	(array == NULL ? NULL : (array = (g_object_unref (array), NULL)));
	(element_size == NULL ? NULL : (element_size = (g_object_unref (element_size), NULL)));
	(length == NULL ? NULL : (length = (g_object_unref (length), NULL)));
	(src == NULL ? NULL : (src = (g_object_unref (src), NULL)));
	(dest == NULL ? NULL : (dest = (g_object_unref (dest), NULL)));
	(src_address == NULL ? NULL : (src_address = (g_object_unref (src_address), NULL)));
	(dest_address == NULL ? NULL : (dest_address = (g_object_unref (dest_address), NULL)));
	(dest_end_address == NULL ? NULL : (dest_end_address = (g_object_unref (dest_end_address), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(czero1 == NULL ? NULL : (czero1 = (g_object_unref (czero1), NULL)));
	(czeroblock1 == NULL ? NULL : (czeroblock1 = (g_object_unref (czeroblock1), NULL)));
	(czero2 == NULL ? NULL : (czero2 = (g_object_unref (czero2), NULL)));
	(czeroblock2 == NULL ? NULL : (czeroblock2 = (g_object_unref (czeroblock2), NULL)));
}


static void vala_ccode_generator_real_visit_source_file (ValaCodeVisitor* base, ValaSourceFile* source_file) {
	ValaCCodeGenerator * self;
	ValaCCodeFragment* _tmp0;
	ValaCCodeFragment* _tmp1;
	ValaCCodeFragment* _tmp2;
	ValaCCodeFragment* _tmp3;
	ValaCCodeFragment* _tmp4;
	ValaCCodeFragment* _tmp5;
	ValaCCodeFragment* _tmp6;
	ValaCCodeFragment* _tmp7;
	ValaCCodeFragment* _tmp8;
	ValaCCodeFragment* _tmp9;
	GeeSet* _tmp10;
	ValaCCodeIncludeDirective* _tmp11;
	ValaCCodeIncludeDirective* _tmp12;
	GeeList* used_includes;
	char* _tmp17;
	char* _tmp52;
	char* _tmp53;
	char* header_define;
	ValaCCodeComment* comment;
	char* _tmp57;
	ValaCCodeWriter* _tmp58;
	ValaCCodeWriter* writer;
	ValaCCodeOnceSection* once;
	ValaCCodeNewline* _tmp59;
	ValaCCodeNewline* _tmp60;
	ValaCCodeIdentifier* _tmp61;
	ValaCCodeNewline* _tmp62;
	ValaCCodeNewline* _tmp63;
	ValaCCodeNewline* _tmp64;
	ValaCCodeNewline* _tmp65;
	ValaCCodeNewline* _tmp66;
	ValaCCodeIdentifier* _tmp67;
	ValaCCodeNewline* _tmp68;
	ValaCCodeNewline* _tmp69;
	ValaCCodeWriter* _tmp71;
	char* _tmp70;
	ValaCCodeFragment* _tmp72;
	ValaCCodeFragment* _tmp73;
	ValaCCodeFragment* _tmp74;
	ValaCCodeFragment* _tmp75;
	ValaCCodeFragment* _tmp76;
	ValaCCodeFragment* _tmp77;
	ValaCCodeFragment* _tmp78;
	ValaCCodeFragment* _tmp79;
	ValaCCodeFragment* _tmp80;
	ValaCCodeFragment* _tmp81;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (source_file == NULL || VALA_IS_SOURCE_FILE (source_file));
	_tmp0 = NULL;
	self->priv->header_begin = (_tmp0 = vala_ccode_fragment_new (), (self->priv->header_begin == NULL ? NULL : (self->priv->header_begin = (g_object_unref (self->priv->header_begin), NULL))), _tmp0);
	_tmp1 = NULL;
	self->priv->header_type_declaration = (_tmp1 = vala_ccode_fragment_new (), (self->priv->header_type_declaration == NULL ? NULL : (self->priv->header_type_declaration = (g_object_unref (self->priv->header_type_declaration), NULL))), _tmp1);
	_tmp2 = NULL;
	self->priv->header_type_definition = (_tmp2 = vala_ccode_fragment_new (), (self->priv->header_type_definition == NULL ? NULL : (self->priv->header_type_definition = (g_object_unref (self->priv->header_type_definition), NULL))), _tmp2);
	_tmp3 = NULL;
	self->priv->header_type_member_declaration = (_tmp3 = vala_ccode_fragment_new (), (self->priv->header_type_member_declaration == NULL ? NULL : (self->priv->header_type_member_declaration = (g_object_unref (self->priv->header_type_member_declaration), NULL))), _tmp3);
	_tmp4 = NULL;
	self->priv->source_begin = (_tmp4 = vala_ccode_fragment_new (), (self->priv->source_begin == NULL ? NULL : (self->priv->source_begin = (g_object_unref (self->priv->source_begin), NULL))), _tmp4);
	_tmp5 = NULL;
	self->priv->source_include_directives = (_tmp5 = vala_ccode_fragment_new (), (self->priv->source_include_directives == NULL ? NULL : (self->priv->source_include_directives = (g_object_unref (self->priv->source_include_directives), NULL))), _tmp5);
	_tmp6 = NULL;
	self->priv->source_type_member_declaration = (_tmp6 = vala_ccode_fragment_new (), (self->priv->source_type_member_declaration == NULL ? NULL : (self->priv->source_type_member_declaration = (g_object_unref (self->priv->source_type_member_declaration), NULL))), _tmp6);
	_tmp7 = NULL;
	self->priv->source_type_member_definition = (_tmp7 = vala_ccode_fragment_new (), (self->priv->source_type_member_definition == NULL ? NULL : (self->priv->source_type_member_definition = (g_object_unref (self->priv->source_type_member_definition), NULL))), _tmp7);
	_tmp8 = NULL;
	self->priv->source_signal_marshaller_definition = (_tmp8 = vala_ccode_fragment_new (), (self->priv->source_signal_marshaller_definition == NULL ? NULL : (self->priv->source_signal_marshaller_definition = (g_object_unref (self->priv->source_signal_marshaller_definition), NULL))), _tmp8);
	_tmp9 = NULL;
	self->priv->source_signal_marshaller_declaration = (_tmp9 = vala_ccode_fragment_new (), (self->priv->source_signal_marshaller_declaration == NULL ? NULL : (self->priv->source_signal_marshaller_declaration = (g_object_unref (self->priv->source_signal_marshaller_declaration), NULL))), _tmp9);
	_tmp10 = NULL;
	self->priv->user_marshal_set = (_tmp10 = GEE_SET (gee_hash_set_new (G_TYPE_STRING, ((GBoxedCopyFunc) g_strdup), g_free, g_str_hash, g_str_equal)), (self->priv->user_marshal_set == NULL ? NULL : (self->priv->user_marshal_set = (g_object_unref (self->priv->user_marshal_set), NULL))), _tmp10);
	self->priv->next_temp_var_id = 0;
	self->priv->string_h_needed = FALSE;
	self->priv->requires_free_checked = FALSE;
	self->priv->requires_array_free = FALSE;
	self->priv->requires_array_move = FALSE;
	_tmp11 = NULL;
	vala_ccode_fragment_append (self->priv->header_begin, VALA_CCODE_NODE ((_tmp11 = vala_ccode_include_directive_new ("glib.h", FALSE))));
	(_tmp11 == NULL ? NULL : (_tmp11 = (g_object_unref (_tmp11), NULL)));
	_tmp12 = NULL;
	vala_ccode_fragment_append (self->priv->header_begin, VALA_CCODE_NODE ((_tmp12 = vala_ccode_include_directive_new ("glib-object.h", FALSE))));
	(_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL)));
	if (vala_code_context_get_basedir (self->priv->context) != NULL || vala_code_context_get_library (self->priv->context) != NULL) {
		ValaCCodeIncludeDirective* _tmp14;
		char* _tmp13;
		_tmp14 = NULL;
		_tmp13 = NULL;
		vala_ccode_fragment_append (self->priv->source_include_directives, VALA_CCODE_NODE ((_tmp14 = vala_ccode_include_directive_new ((_tmp13 = vala_source_file_get_cinclude_filename (source_file)), FALSE))));
		(_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL)));
		(_tmp13 = (g_free (_tmp13), NULL));
	} else {
		ValaCCodeIncludeDirective* _tmp16;
		char* _tmp15;
		_tmp16 = NULL;
		_tmp15 = NULL;
		vala_ccode_fragment_append (self->priv->source_include_directives, VALA_CCODE_NODE ((_tmp16 = vala_ccode_include_directive_new ((_tmp15 = vala_source_file_get_cinclude_filename (source_file)), TRUE))));
		(_tmp16 == NULL ? NULL : (_tmp16 = (g_object_unref (_tmp16), NULL)));
		(_tmp15 = (g_free (_tmp15), NULL));
	}
	used_includes = GEE_LIST (gee_array_list_new (G_TYPE_STRING, ((GBoxedCopyFunc) g_strdup), g_free, g_str_equal));
	gee_collection_add (GEE_COLLECTION (used_includes), "glib.h");
	gee_collection_add (GEE_COLLECTION (used_includes), "glib-object.h");
	_tmp17 = NULL;
	gee_collection_add (GEE_COLLECTION (used_includes), (_tmp17 = vala_source_file_get_cinclude_filename (source_file)));
	(_tmp17 = (g_free (_tmp17), NULL));
	{
		GeeCollection* filename_collection;
		GeeIterator* filename_it;
		filename_collection = vala_source_file_get_header_external_includes (source_file);
		filename_it = gee_iterable_iterator (GEE_ITERABLE (filename_collection));
		while (gee_iterator_next (filename_it)) {
			char* filename;
			filename = gee_iterator_get (filename_it);
			{
				if (!gee_collection_contains (GEE_COLLECTION (used_includes), filename)) {
					ValaCCodeIncludeDirective* _tmp18;
					_tmp18 = NULL;
					vala_ccode_fragment_append (self->priv->header_begin, VALA_CCODE_NODE ((_tmp18 = vala_ccode_include_directive_new (filename, FALSE))));
					(_tmp18 == NULL ? NULL : (_tmp18 = (g_object_unref (_tmp18), NULL)));
					gee_collection_add (GEE_COLLECTION (used_includes), filename);
				}
				(filename = (g_free (filename), NULL));
			}
		}
		(filename_collection == NULL ? NULL : (filename_collection = (g_object_unref (filename_collection), NULL)));
		(filename_it == NULL ? NULL : (filename_it = (g_object_unref (filename_it), NULL)));
	}
	{
		GeeCollection* filename_collection;
		GeeIterator* filename_it;
		filename_collection = vala_source_file_get_header_internal_includes (source_file);
		filename_it = gee_iterable_iterator (GEE_ITERABLE (filename_collection));
		while (gee_iterator_next (filename_it)) {
			char* filename;
			filename = gee_iterator_get (filename_it);
			{
				if (!gee_collection_contains (GEE_COLLECTION (used_includes), filename)) {
					ValaCCodeIncludeDirective* _tmp19;
					_tmp19 = NULL;
					vala_ccode_fragment_append (self->priv->header_begin, VALA_CCODE_NODE ((_tmp19 = vala_ccode_generator_get_internal_include (self, filename))));
					(_tmp19 == NULL ? NULL : (_tmp19 = (g_object_unref (_tmp19), NULL)));
					gee_collection_add (GEE_COLLECTION (used_includes), filename);
				}
				(filename = (g_free (filename), NULL));
			}
		}
		(filename_collection == NULL ? NULL : (filename_collection = (g_object_unref (filename_collection), NULL)));
		(filename_it == NULL ? NULL : (filename_it = (g_object_unref (filename_it), NULL)));
	}
	{
		GeeCollection* filename_collection;
		GeeIterator* filename_it;
		filename_collection = vala_source_file_get_source_external_includes (source_file);
		filename_it = gee_iterable_iterator (GEE_ITERABLE (filename_collection));
		while (gee_iterator_next (filename_it)) {
			char* filename;
			filename = gee_iterator_get (filename_it);
			{
				if (!gee_collection_contains (GEE_COLLECTION (used_includes), filename)) {
					ValaCCodeIncludeDirective* _tmp20;
					_tmp20 = NULL;
					vala_ccode_fragment_append (self->priv->source_include_directives, VALA_CCODE_NODE ((_tmp20 = vala_ccode_include_directive_new (filename, FALSE))));
					(_tmp20 == NULL ? NULL : (_tmp20 = (g_object_unref (_tmp20), NULL)));
					gee_collection_add (GEE_COLLECTION (used_includes), filename);
				}
				(filename = (g_free (filename), NULL));
			}
		}
		(filename_collection == NULL ? NULL : (filename_collection = (g_object_unref (filename_collection), NULL)));
		(filename_it == NULL ? NULL : (filename_it = (g_object_unref (filename_it), NULL)));
	}
	{
		GeeCollection* filename_collection;
		GeeIterator* filename_it;
		filename_collection = vala_source_file_get_source_internal_includes (source_file);
		filename_it = gee_iterable_iterator (GEE_ITERABLE (filename_collection));
		while (gee_iterator_next (filename_it)) {
			char* filename;
			filename = gee_iterator_get (filename_it);
			{
				if (!gee_collection_contains (GEE_COLLECTION (used_includes), filename)) {
					ValaCCodeIncludeDirective* _tmp21;
					_tmp21 = NULL;
					vala_ccode_fragment_append (self->priv->source_include_directives, VALA_CCODE_NODE ((_tmp21 = vala_ccode_generator_get_internal_include (self, filename))));
					(_tmp21 == NULL ? NULL : (_tmp21 = (g_object_unref (_tmp21), NULL)));
					gee_collection_add (GEE_COLLECTION (used_includes), filename);
				}
				(filename = (g_free (filename), NULL));
			}
		}
		(filename_collection == NULL ? NULL : (filename_collection = (g_object_unref (filename_collection), NULL)));
		(filename_it == NULL ? NULL : (filename_it = (g_object_unref (filename_it), NULL)));
	}
	if (vala_source_file_get_is_cycle_head (source_file)) {
		{
			GeeList* cycle_file_collection;
			GeeIterator* cycle_file_it;
			cycle_file_collection = vala_source_file_get_cycle (source_file)->files;
			cycle_file_it = gee_iterable_iterator (GEE_ITERABLE (cycle_file_collection));
			while (gee_iterator_next (cycle_file_it)) {
				ValaSourceFile* _tmp51;
				ValaSourceFile* cycle_file;
				_tmp51 = NULL;
				cycle_file = (_tmp51 = gee_iterator_get (cycle_file_it), (_tmp51 == NULL ? NULL : g_object_ref (_tmp51)));
				{
					{
						GeeCollection* node_collection;
						GeeIterator* node_it;
						node_collection = vala_source_file_get_nodes (cycle_file);
						node_it = gee_iterable_iterator (GEE_ITERABLE (node_collection));
						while (gee_iterator_next (node_it)) {
							ValaCodeNode* node;
							node = gee_iterator_get (node_it);
							{
								if (VALA_IS_STRUCT (node)) {
									ValaStruct* _tmp22;
									ValaStruct* st;
									ValaCCodeTypeDefinition* _tmp27;
									ValaCCodeVariableDeclarator* _tmp26;
									char* _tmp25;
									char* _tmp24;
									char* _tmp23;
									_tmp22 = NULL;
									st = (_tmp22 = VALA_STRUCT (node), (_tmp22 == NULL ? NULL : g_object_ref (_tmp22)));
									_tmp27 = NULL;
									_tmp26 = NULL;
									_tmp25 = NULL;
									_tmp24 = NULL;
									_tmp23 = NULL;
									vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((_tmp27 = vala_ccode_type_definition_new ((_tmp24 = g_strdup_printf ("struct _%s", (_tmp23 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (st), FALSE)))), VALA_CCODE_DECLARATOR ((_tmp26 = vala_ccode_variable_declarator_new ((_tmp25 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (st), FALSE)))))))));
									(_tmp27 == NULL ? NULL : (_tmp27 = (g_object_unref (_tmp27), NULL)));
									(_tmp26 == NULL ? NULL : (_tmp26 = (g_object_unref (_tmp26), NULL)));
									(_tmp25 = (g_free (_tmp25), NULL));
									(_tmp24 = (g_free (_tmp24), NULL));
									(_tmp23 = (g_free (_tmp23), NULL));
									(st == NULL ? NULL : (st = (g_object_unref (st), NULL)));
								} else {
									if (VALA_IS_CLASS (node)) {
										ValaClass* _tmp28;
										ValaClass* cl;
										_tmp28 = NULL;
										cl = (_tmp28 = VALA_CLASS (node), (_tmp28 == NULL ? NULL : g_object_ref (_tmp28)));
										if (!vala_class_get_is_static (cl)) {
											ValaCCodeTypeDefinition* _tmp33;
											ValaCCodeVariableDeclarator* _tmp32;
											char* _tmp31;
											char* _tmp30;
											char* _tmp29;
											ValaCCodeTypeDefinition* _tmp39;
											ValaCCodeVariableDeclarator* _tmp38;
											char* _tmp37;
											char* _tmp36;
											char* _tmp35;
											char* _tmp34;
											_tmp33 = NULL;
											_tmp32 = NULL;
											_tmp31 = NULL;
											_tmp30 = NULL;
											_tmp29 = NULL;
											vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((_tmp33 = vala_ccode_type_definition_new ((_tmp30 = g_strdup_printf ("struct _%s", (_tmp29 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE)))), VALA_CCODE_DECLARATOR ((_tmp32 = vala_ccode_variable_declarator_new ((_tmp31 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE)))))))));
											(_tmp33 == NULL ? NULL : (_tmp33 = (g_object_unref (_tmp33), NULL)));
											(_tmp32 == NULL ? NULL : (_tmp32 = (g_object_unref (_tmp32), NULL)));
											(_tmp31 = (g_free (_tmp31), NULL));
											(_tmp30 = (g_free (_tmp30), NULL));
											(_tmp29 = (g_free (_tmp29), NULL));
											_tmp39 = NULL;
											_tmp38 = NULL;
											_tmp37 = NULL;
											_tmp36 = NULL;
											_tmp35 = NULL;
											_tmp34 = NULL;
											vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((_tmp39 = vala_ccode_type_definition_new ((_tmp35 = g_strdup_printf ("struct _%sClass", (_tmp34 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE)))), VALA_CCODE_DECLARATOR ((_tmp38 = vala_ccode_variable_declarator_new ((_tmp37 = g_strdup_printf ("%sClass", (_tmp36 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE)))))))))));
											(_tmp39 == NULL ? NULL : (_tmp39 = (g_object_unref (_tmp39), NULL)));
											(_tmp38 == NULL ? NULL : (_tmp38 = (g_object_unref (_tmp38), NULL)));
											(_tmp37 = (g_free (_tmp37), NULL));
											(_tmp36 = (g_free (_tmp36), NULL));
											(_tmp35 = (g_free (_tmp35), NULL));
											(_tmp34 = (g_free (_tmp34), NULL));
										}
										(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
									} else {
										if (VALA_IS_INTERFACE (node)) {
											ValaInterface* _tmp40;
											ValaInterface* iface;
											_tmp40 = NULL;
											iface = (_tmp40 = VALA_INTERFACE (node), (_tmp40 == NULL ? NULL : g_object_ref (_tmp40)));
											if (!vala_interface_get_is_static (iface) && !vala_interface_get_declaration_only (iface)) {
												ValaCCodeTypeDefinition* _tmp45;
												ValaCCodeVariableDeclarator* _tmp44;
												char* _tmp43;
												char* _tmp42;
												char* _tmp41;
												ValaCCodeTypeDefinition* _tmp50;
												ValaCCodeVariableDeclarator* _tmp49;
												char* _tmp48;
												char* _tmp47;
												char* _tmp46;
												_tmp45 = NULL;
												_tmp44 = NULL;
												_tmp43 = NULL;
												_tmp42 = NULL;
												_tmp41 = NULL;
												vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((_tmp45 = vala_ccode_type_definition_new ((_tmp42 = g_strdup_printf ("struct _%s", (_tmp41 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (iface), FALSE)))), VALA_CCODE_DECLARATOR ((_tmp44 = vala_ccode_variable_declarator_new ((_tmp43 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (iface), FALSE)))))))));
												(_tmp45 == NULL ? NULL : (_tmp45 = (g_object_unref (_tmp45), NULL)));
												(_tmp44 == NULL ? NULL : (_tmp44 = (g_object_unref (_tmp44), NULL)));
												(_tmp43 = (g_free (_tmp43), NULL));
												(_tmp42 = (g_free (_tmp42), NULL));
												(_tmp41 = (g_free (_tmp41), NULL));
												_tmp50 = NULL;
												_tmp49 = NULL;
												_tmp48 = NULL;
												_tmp47 = NULL;
												_tmp46 = NULL;
												vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((_tmp50 = vala_ccode_type_definition_new ((_tmp47 = g_strdup_printf ("struct _%s", (_tmp46 = vala_interface_get_type_cname (iface)))), VALA_CCODE_DECLARATOR ((_tmp49 = vala_ccode_variable_declarator_new ((_tmp48 = vala_interface_get_type_cname (iface)))))))));
												(_tmp50 == NULL ? NULL : (_tmp50 = (g_object_unref (_tmp50), NULL)));
												(_tmp49 == NULL ? NULL : (_tmp49 = (g_object_unref (_tmp49), NULL)));
												(_tmp48 = (g_free (_tmp48), NULL));
												(_tmp47 = (g_free (_tmp47), NULL));
												(_tmp46 = (g_free (_tmp46), NULL));
											}
											(iface == NULL ? NULL : (iface = (g_object_unref (iface), NULL)));
										}
									}
								}
								(node == NULL ? NULL : (node = (g_object_unref (node), NULL)));
							}
						}
						(node_collection == NULL ? NULL : (node_collection = (g_object_unref (node_collection), NULL)));
						(node_it == NULL ? NULL : (node_it = (g_object_unref (node_it), NULL)));
					}
					(cycle_file == NULL ? NULL : (cycle_file = (g_object_unref (cycle_file), NULL)));
				}
			}
			(cycle_file_it == NULL ? NULL : (cycle_file_it = (g_object_unref (cycle_file_it), NULL)));
		}
	}
	vala_source_file_accept_children (source_file, VALA_CODE_VISITOR (self));
	_tmp52 = NULL;
	_tmp53 = NULL;
	header_define = (_tmp53 = vala_ccode_generator_get_define_for_filename ((_tmp52 = vala_source_file_get_cinclude_filename (source_file))), (_tmp52 = (g_free (_tmp52), NULL)), _tmp53);
	/* generate hardcoded "well-known" macros */
	if (self->priv->requires_free_checked) {
		ValaCCodeMacroReplacement* _tmp54;
		_tmp54 = NULL;
		vala_ccode_fragment_append (self->priv->source_begin, VALA_CCODE_NODE ((_tmp54 = vala_ccode_macro_replacement_new ("VALA_FREE_CHECKED(o,f)", "((o) == NULL ? NULL : ((o) = (f (o), NULL)))"))));
		(_tmp54 == NULL ? NULL : (_tmp54 = (g_object_unref (_tmp54), NULL)));
	}
	if (self->priv->requires_array_free) {
		vala_ccode_generator_append_vala_array_free (self);
	}
	if (self->priv->requires_array_move) {
		vala_ccode_generator_append_vala_array_move (self);
	}
	if (self->priv->string_h_needed) {
		ValaCCodeIncludeDirective* _tmp55;
		_tmp55 = NULL;
		vala_ccode_fragment_append (self->priv->source_include_directives, VALA_CCODE_NODE ((_tmp55 = vala_ccode_include_directive_new ("string.h", FALSE))));
		(_tmp55 == NULL ? NULL : (_tmp55 = (g_object_unref (_tmp55), NULL)));
	}
	comment = NULL;
	if (vala_source_file_get_comment (source_file) != NULL) {
		ValaCCodeComment* _tmp56;
		_tmp56 = NULL;
		comment = (_tmp56 = vala_ccode_comment_new (vala_source_file_get_comment (source_file)), (comment == NULL ? NULL : (comment = (g_object_unref (comment), NULL))), _tmp56);
	}
	_tmp57 = NULL;
	_tmp58 = NULL;
	writer = (_tmp58 = vala_ccode_writer_new ((_tmp57 = vala_source_file_get_cheader_filename (source_file))), (_tmp57 = (g_free (_tmp57), NULL)), _tmp58);
	if (comment != NULL) {
		vala_ccode_node_write (VALA_CCODE_NODE (comment), writer);
	}
	vala_ccode_writer_write_newline (writer);
	once = vala_ccode_once_section_new (header_define);
	_tmp59 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((_tmp59 = vala_ccode_newline_new ())));
	(_tmp59 == NULL ? NULL : (_tmp59 = (g_object_unref (_tmp59), NULL)));
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE (self->priv->header_begin));
	_tmp60 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((_tmp60 = vala_ccode_newline_new ())));
	(_tmp60 == NULL ? NULL : (_tmp60 = (g_object_unref (_tmp60), NULL)));
	_tmp61 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((_tmp61 = vala_ccode_identifier_new ("G_BEGIN_DECLS"))));
	(_tmp61 == NULL ? NULL : (_tmp61 = (g_object_unref (_tmp61), NULL)));
	_tmp62 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((_tmp62 = vala_ccode_newline_new ())));
	(_tmp62 == NULL ? NULL : (_tmp62 = (g_object_unref (_tmp62), NULL)));
	_tmp63 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((_tmp63 = vala_ccode_newline_new ())));
	(_tmp63 == NULL ? NULL : (_tmp63 = (g_object_unref (_tmp63), NULL)));
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE (self->priv->header_type_declaration));
	_tmp64 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((_tmp64 = vala_ccode_newline_new ())));
	(_tmp64 == NULL ? NULL : (_tmp64 = (g_object_unref (_tmp64), NULL)));
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE (self->priv->header_type_definition));
	_tmp65 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((_tmp65 = vala_ccode_newline_new ())));
	(_tmp65 == NULL ? NULL : (_tmp65 = (g_object_unref (_tmp65), NULL)));
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE (self->priv->header_type_member_declaration));
	_tmp66 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((_tmp66 = vala_ccode_newline_new ())));
	(_tmp66 == NULL ? NULL : (_tmp66 = (g_object_unref (_tmp66), NULL)));
	_tmp67 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((_tmp67 = vala_ccode_identifier_new ("G_END_DECLS"))));
	(_tmp67 == NULL ? NULL : (_tmp67 = (g_object_unref (_tmp67), NULL)));
	_tmp68 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((_tmp68 = vala_ccode_newline_new ())));
	(_tmp68 == NULL ? NULL : (_tmp68 = (g_object_unref (_tmp68), NULL)));
	_tmp69 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((_tmp69 = vala_ccode_newline_new ())));
	(_tmp69 == NULL ? NULL : (_tmp69 = (g_object_unref (_tmp69), NULL)));
	vala_ccode_node_write (VALA_CCODE_NODE (once), writer);
	vala_ccode_writer_close (writer);
	_tmp71 = NULL;
	_tmp70 = NULL;
	writer = (_tmp71 = vala_ccode_writer_new ((_tmp70 = vala_source_file_get_csource_filename (source_file))), (writer == NULL ? NULL : (writer = (g_object_unref (writer), NULL))), _tmp71);
	(_tmp70 = (g_free (_tmp70), NULL));
	vala_ccode_writer_set_line_directives (writer, vala_code_context_get_debug (self->priv->context));
	if (comment != NULL) {
		vala_ccode_node_write (VALA_CCODE_NODE (comment), writer);
	}
	vala_ccode_node_write (VALA_CCODE_NODE (self->priv->source_begin), writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write (VALA_CCODE_NODE (self->priv->source_include_directives), writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write_declaration (VALA_CCODE_NODE (self->priv->source_type_member_declaration), writer);
	vala_ccode_node_write (VALA_CCODE_NODE (self->priv->source_type_member_declaration), writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write_declaration (VALA_CCODE_NODE (self->priv->source_signal_marshaller_declaration), writer);
	vala_ccode_node_write (VALA_CCODE_NODE (self->priv->source_signal_marshaller_declaration), writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write (VALA_CCODE_NODE (self->priv->source_type_member_definition), writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write (VALA_CCODE_NODE (self->priv->source_signal_marshaller_definition), writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_writer_close (writer);
	_tmp72 = NULL;
	self->priv->header_begin = (_tmp72 = NULL, (self->priv->header_begin == NULL ? NULL : (self->priv->header_begin = (g_object_unref (self->priv->header_begin), NULL))), _tmp72);
	_tmp73 = NULL;
	self->priv->header_type_declaration = (_tmp73 = NULL, (self->priv->header_type_declaration == NULL ? NULL : (self->priv->header_type_declaration = (g_object_unref (self->priv->header_type_declaration), NULL))), _tmp73);
	_tmp74 = NULL;
	self->priv->header_type_definition = (_tmp74 = NULL, (self->priv->header_type_definition == NULL ? NULL : (self->priv->header_type_definition = (g_object_unref (self->priv->header_type_definition), NULL))), _tmp74);
	_tmp75 = NULL;
	self->priv->header_type_member_declaration = (_tmp75 = NULL, (self->priv->header_type_member_declaration == NULL ? NULL : (self->priv->header_type_member_declaration = (g_object_unref (self->priv->header_type_member_declaration), NULL))), _tmp75);
	_tmp76 = NULL;
	self->priv->source_begin = (_tmp76 = NULL, (self->priv->source_begin == NULL ? NULL : (self->priv->source_begin = (g_object_unref (self->priv->source_begin), NULL))), _tmp76);
	_tmp77 = NULL;
	self->priv->source_include_directives = (_tmp77 = NULL, (self->priv->source_include_directives == NULL ? NULL : (self->priv->source_include_directives = (g_object_unref (self->priv->source_include_directives), NULL))), _tmp77);
	_tmp78 = NULL;
	self->priv->source_type_member_declaration = (_tmp78 = NULL, (self->priv->source_type_member_declaration == NULL ? NULL : (self->priv->source_type_member_declaration = (g_object_unref (self->priv->source_type_member_declaration), NULL))), _tmp78);
	_tmp79 = NULL;
	self->priv->source_type_member_definition = (_tmp79 = NULL, (self->priv->source_type_member_definition == NULL ? NULL : (self->priv->source_type_member_definition = (g_object_unref (self->priv->source_type_member_definition), NULL))), _tmp79);
	_tmp80 = NULL;
	self->priv->source_signal_marshaller_definition = (_tmp80 = NULL, (self->priv->source_signal_marshaller_definition == NULL ? NULL : (self->priv->source_signal_marshaller_definition = (g_object_unref (self->priv->source_signal_marshaller_definition), NULL))), _tmp80);
	_tmp81 = NULL;
	self->priv->source_signal_marshaller_declaration = (_tmp81 = NULL, (self->priv->source_signal_marshaller_declaration == NULL ? NULL : (self->priv->source_signal_marshaller_declaration = (g_object_unref (self->priv->source_signal_marshaller_declaration), NULL))), _tmp81);
	(used_includes == NULL ? NULL : (used_includes = (g_object_unref (used_includes), NULL)));
	(header_define = (g_free (header_define), NULL));
	(comment == NULL ? NULL : (comment = (g_object_unref (comment), NULL)));
	(writer == NULL ? NULL : (writer = (g_object_unref (writer), NULL)));
	(once == NULL ? NULL : (once = (g_object_unref (once), NULL)));
}


static char* vala_ccode_generator_get_define_for_filename (const char* filename) {
	GString* define;
	const char* _tmp0;
	char* i;
	const char* _tmp3;
	char* _tmp4;
	define = g_string_new ("__");
	_tmp0 = NULL;
	i = (_tmp0 = filename, (_tmp0 == NULL ? NULL : g_strdup (_tmp0)));
	while (g_utf8_strlen (i, -1) > 0) {
		gunichar c;
		char* _tmp2;
		const char* _tmp1;
		c = g_utf8_get_char (i);
		if (g_unichar_isalnum (c) && c < 0x80) {
			g_string_append_unichar (define, g_unichar_toupper (c));
		} else {
			g_string_append_c (define, '_');
		}
		_tmp2 = NULL;
		_tmp1 = NULL;
		i = (_tmp2 = (_tmp1 = g_utf8_next_char (i), (_tmp1 == NULL ? NULL : g_strdup (_tmp1))), (i = (g_free (i), NULL)), _tmp2);
	}
	g_string_append (define, "__");
	_tmp3 = NULL;
	_tmp4 = NULL;
	return (_tmp4 = (_tmp3 = define->str, (_tmp3 == NULL ? NULL : g_strdup (_tmp3))), (define == NULL ? NULL : (define = (g_string_free (define, TRUE), NULL))), (i = (g_free (i), NULL)), _tmp4);
}


static void vala_ccode_generator_real_visit_struct (ValaCodeVisitor* base, ValaStruct* st) {
	ValaCCodeGenerator * self;
	ValaTypesymbol* _tmp0;
	ValaTypesymbol* old_type_symbol;
	ValaCCodeStruct* _tmp1;
	ValaCCodeStruct* old_instance_struct;
	ValaCCodeFragment* _tmp2;
	ValaCCodeFragment* old_instance_dispose_fragment;
	ValaTypesymbol* _tmp4;
	ValaStruct* _tmp3;
	ValaCCodeStruct* _tmp7;
	char* _tmp6;
	char* _tmp5;
	ValaCCodeFragment* _tmp8;
	ValaCCodeFragment* decl_frag;
	ValaCCodeFragment* def_frag;
	ValaTypesymbol* _tmp37;
	ValaTypesymbol* _tmp36;
	ValaCCodeStruct* _tmp39;
	ValaCCodeStruct* _tmp38;
	ValaCCodeFragment* _tmp41;
	ValaCCodeFragment* _tmp40;
	self = VALA_CCODE_GENERATOR (base);
	g_return_if_fail (st == NULL || VALA_IS_STRUCT (st));
	_tmp0 = NULL;
	old_type_symbol = (_tmp0 = self->current_type_symbol, (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	_tmp1 = NULL;
	old_instance_struct = (_tmp1 = self->priv->instance_struct, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
	_tmp2 = NULL;
	old_instance_dispose_fragment = (_tmp2 = self->priv->instance_dispose_fragment, (_tmp2 == NULL ? NULL : g_object_ref (_tmp2)));
	_tmp4 = NULL;
	_tmp3 = NULL;
	self->current_type_symbol = (_tmp4 = VALA_TYPESYMBOL ((_tmp3 = st, (_tmp3 == NULL ? NULL : g_object_ref (_tmp3)))), (self->current_type_symbol == NULL ? NULL : (self->current_type_symbol = (g_object_unref (self->current_type_symbol), NULL))), _tmp4);
	_tmp7 = NULL;
	_tmp6 = NULL;
	_tmp5 = NULL;
	self->priv->instance_struct = (_tmp7 = vala_ccode_struct_new ((_tmp6 = g_strdup_printf ("_%s", (_tmp5 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (st), FALSE))))), (self->priv->instance_struct == NULL ? NULL : (self->priv->instance_struct = (g_object_unref (self->priv->instance_struct), NULL))), _tmp7);
	(_tmp6 = (g_free (_tmp6), NULL));
	(_tmp5 = (g_free (_tmp5), NULL));
	_tmp8 = NULL;
	self->priv->instance_dispose_fragment = (_tmp8 = vala_ccode_fragment_new (), (self->priv->instance_dispose_fragment == NULL ? NULL : (self->priv->instance_dispose_fragment = (g_object_unref (self->priv->instance_dispose_fragment), NULL))), _tmp8);
	decl_frag = NULL;
	def_frag = NULL;
	if (vala_symbol_get_access (VALA_SYMBOL (st)) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		ValaCCodeFragment* _tmp10;
		ValaCCodeFragment* _tmp9;
		ValaCCodeFragment* _tmp12;
		ValaCCodeFragment* _tmp11;
		_tmp10 = NULL;
		_tmp9 = NULL;
		decl_frag = (_tmp10 = (_tmp9 = self->priv->header_type_declaration, (_tmp9 == NULL ? NULL : g_object_ref (_tmp9))), (decl_frag == NULL ? NULL : (decl_frag = (g_object_unref (decl_frag), NULL))), _tmp10);
		_tmp12 = NULL;
		_tmp11 = NULL;
		def_frag = (_tmp12 = (_tmp11 = self->priv->header_type_definition, (_tmp11 == NULL ? NULL : g_object_ref (_tmp11))), (def_frag == NULL ? NULL : (def_frag = (g_object_unref (def_frag), NULL))), _tmp12);
	} else {
		ValaCCodeFragment* _tmp14;
		ValaCCodeFragment* _tmp13;
		ValaCCodeFragment* _tmp16;
		ValaCCodeFragment* _tmp15;
		_tmp14 = NULL;
		_tmp13 = NULL;
		decl_frag = (_tmp14 = (_tmp13 = self->priv->source_type_member_declaration, (_tmp13 == NULL ? NULL : g_object_ref (_tmp13))), (decl_frag == NULL ? NULL : (decl_frag = (g_object_unref (decl_frag), NULL))), _tmp14);
		_tmp16 = NULL;
		_tmp15 = NULL;
		def_frag = (_tmp16 = (_tmp15 = self->priv->source_type_member_declaration, (_tmp15 == NULL ? NULL : g_object_ref (_tmp15))), (def_frag == NULL ? NULL : (def_frag = (g_object_unref (def_frag), NULL))), _tmp16);
	}
	if (vala_source_file_get_cycle (vala_source_reference_get_file (vala_code_node_get_source_reference (VALA_CODE_NODE (st)))) == NULL) {
		ValaCCodeTypeDefinition* _tmp21;
		ValaCCodeVariableDeclarator* _tmp20;
		char* _tmp19;
		char* _tmp18;
		char* _tmp17;
		_tmp21 = NULL;
		_tmp20 = NULL;
		_tmp19 = NULL;
		_tmp18 = NULL;
		_tmp17 = NULL;
		vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((_tmp21 = vala_ccode_type_definition_new ((_tmp18 = g_strdup_printf ("struct _%s", (_tmp17 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (st), FALSE)))), VALA_CCODE_DECLARATOR ((_tmp20 = vala_ccode_variable_declarator_new ((_tmp19 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (st), FALSE)))))))));
		(_tmp21 == NULL ? NULL : (_tmp21 = (g_object_unref (_tmp21), NULL)));
		(_tmp20 == NULL ? NULL : (_tmp20 = (g_object_unref (_tmp20), NULL)));
		(_tmp19 = (g_free (_tmp19), NULL));
		(_tmp18 = (g_free (_tmp18), NULL));
		(_tmp17 = (g_free (_tmp17), NULL));
	}
	if (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (st))) != NULL) {
		ValaCCodeComment* _tmp22;
		_tmp22 = NULL;
		vala_ccode_fragment_append (def_frag, VALA_CCODE_NODE ((_tmp22 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (st)))))));
		(_tmp22 == NULL ? NULL : (_tmp22 = (g_object_unref (_tmp22), NULL)));
	}
	vala_ccode_fragment_append (def_frag, VALA_CCODE_NODE (self->priv->instance_struct));
	vala_code_node_accept_children (VALA_CODE_NODE (st), VALA_CODE_VISITOR (self));
	if (vala_struct_get_default_construction_method (st) != NULL) {
		char* _tmp24;
		char* _tmp23;
		ValaCCodeFunction* _tmp25;
		ValaCCodeFunction* function;
		ValaCCodeFormalParameter* _tmp28;
		char* _tmp27;
		char* _tmp26;
		ValaCCodeFunction* _tmp29;
		ValaCCodeBlock* cblock;
		ValaCCodeIdentifier* _tmp30;
		ValaCCodeFunctionCall* _tmp31;
		ValaCCodeFunctionCall* ccall;
		ValaCCodeIdentifier* _tmp33;
		char* _tmp32;
		ValaCCodeIdentifier* _tmp34;
		ValaCCodeExpressionStatement* _tmp35;
		_tmp24 = NULL;
		_tmp23 = NULL;
		_tmp25 = NULL;
		function = (_tmp25 = vala_ccode_function_new ((_tmp24 = g_strconcat ((_tmp23 = vala_symbol_get_lower_case_cprefix (VALA_SYMBOL (st))), "free", NULL)), "void"), (_tmp24 = (g_free (_tmp24), NULL)), (_tmp23 = (g_free (_tmp23), NULL)), _tmp25);
		if (vala_symbol_get_access (VALA_SYMBOL (st)) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
		}
		_tmp28 = NULL;
		_tmp27 = NULL;
		_tmp26 = NULL;
		vala_ccode_function_add_parameter (function, (_tmp28 = vala_ccode_formal_parameter_new ("self", (_tmp27 = g_strconcat ((_tmp26 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (st), FALSE)), "*", NULL)))));
		(_tmp28 == NULL ? NULL : (_tmp28 = (g_object_unref (_tmp28), NULL)));
		(_tmp27 = (g_free (_tmp27), NULL));
		(_tmp26 = (g_free (_tmp26), NULL));
		_tmp29 = NULL;
		vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((_tmp29 = vala_ccode_function_copy (function))));
		(_tmp29 == NULL ? NULL : (_tmp29 = (g_object_unref (_tmp29), NULL)));
		cblock = vala_ccode_block_new ();
		vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (self->priv->instance_dispose_fragment));
		_tmp30 = NULL;
		_tmp31 = NULL;
		ccall = (_tmp31 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp30 = vala_ccode_identifier_new ("g_slice_free")))), (_tmp30 == NULL ? NULL : (_tmp30 = (g_object_unref (_tmp30), NULL))), _tmp31);
		_tmp33 = NULL;
		_tmp32 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp33 = vala_ccode_identifier_new ((_tmp32 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (st), FALSE))))));
		(_tmp33 == NULL ? NULL : (_tmp33 = (g_object_unref (_tmp33), NULL)));
		(_tmp32 = (g_free (_tmp32), NULL));
		_tmp34 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp34 = vala_ccode_identifier_new ("self"))));
		(_tmp34 == NULL ? NULL : (_tmp34 = (g_object_unref (_tmp34), NULL)));
		_tmp35 = NULL;
		vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((_tmp35 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
		(_tmp35 == NULL ? NULL : (_tmp35 = (g_object_unref (_tmp35), NULL)));
		vala_ccode_function_set_block (function, cblock);
		vala_ccode_fragment_append (def_frag, VALA_CCODE_NODE (function));
		(function == NULL ? NULL : (function = (g_object_unref (function), NULL)));
		(cblock == NULL ? NULL : (cblock = (g_object_unref (cblock), NULL)));
		(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	}
	_tmp37 = NULL;
	_tmp36 = NULL;
	self->current_type_symbol = (_tmp37 = (_tmp36 = old_type_symbol, (_tmp36 == NULL ? NULL : g_object_ref (_tmp36))), (self->current_type_symbol == NULL ? NULL : (self->current_type_symbol = (g_object_unref (self->current_type_symbol), NULL))), _tmp37);
	_tmp39 = NULL;
	_tmp38 = NULL;
	self->priv->instance_struct = (_tmp39 = (_tmp38 = old_instance_struct, (_tmp38 == NULL ? NULL : g_object_ref (_tmp38))), (self->priv->instance_struct == NULL ? NULL : (self->priv->instance_struct = (g_object_unref (self->priv->instance_struct), NULL))), _tmp39);
	_tmp41 = NULL;
	_tmp40 = NULL;
	self->priv->instance_dispose_fragment = (_tmp41 = (_tmp40 = old_instance_dispose_fragment, (_tmp40 == NULL ? NULL : g_object_ref (_tmp40))), (self->priv->instance_dispose_fragment == NULL ? NULL : (self->priv->instance_dispose_fragment = (g_object_unref (self->priv->instance_dispose_fragment), NULL))), _tmp41);
	(old_type_symbol == NULL ? NULL : (old_type_symbol = (g_object_unref (old_type_symbol), NULL)));
	(old_instance_struct == NULL ? NULL : (old_instance_struct = (g_object_unref (old_instance_struct), NULL)));
	(old_instance_dispose_fragment == NULL ? NULL : (old_instance_dispose_fragment = (g_object_unref (old_instance_dispose_fragment), NULL)));
	(decl_frag == NULL ? NULL : (decl_frag = (g_object_unref (decl_frag), NULL)));
	(def_frag == NULL ? NULL : (def_frag = (g_object_unref (def_frag), NULL)));
}


static GObject * vala_ccode_generator_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	ValaCCodeGeneratorClass * klass;
	GObjectClass * parent_class;
	ValaCCodeGenerator * self;
	klass = VALA_CCODE_GENERATOR_CLASS (g_type_class_peek (VALA_TYPE_CCODE_GENERATOR));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = VALA_CCODE_GENERATOR (obj);
	{
		GeeSet* _tmp0;
		GeeSet* _tmp1;
		_tmp0 = NULL;
		self->priv->predefined_marshal_set = (_tmp0 = GEE_SET (gee_hash_set_new (G_TYPE_STRING, ((GBoxedCopyFunc) g_strdup), g_free, g_str_hash, g_str_equal)), (self->priv->predefined_marshal_set == NULL ? NULL : (self->priv->predefined_marshal_set = (g_object_unref (self->priv->predefined_marshal_set), NULL))), _tmp0);
		gee_collection_add (GEE_COLLECTION (self->priv->predefined_marshal_set), "VOID:VOID");
		gee_collection_add (GEE_COLLECTION (self->priv->predefined_marshal_set), "VOID:BOOLEAN");
		gee_collection_add (GEE_COLLECTION (self->priv->predefined_marshal_set), "VOID:CHAR");
		gee_collection_add (GEE_COLLECTION (self->priv->predefined_marshal_set), "VOID:UCHAR");
		gee_collection_add (GEE_COLLECTION (self->priv->predefined_marshal_set), "VOID:INT");
		gee_collection_add (GEE_COLLECTION (self->priv->predefined_marshal_set), "VOID:UINT");
		gee_collection_add (GEE_COLLECTION (self->priv->predefined_marshal_set), "VOID:LONG");
		gee_collection_add (GEE_COLLECTION (self->priv->predefined_marshal_set), "VOID:ULONG");
		gee_collection_add (GEE_COLLECTION (self->priv->predefined_marshal_set), "VOID:ENUM");
		gee_collection_add (GEE_COLLECTION (self->priv->predefined_marshal_set), "VOID:FLAGS");
		gee_collection_add (GEE_COLLECTION (self->priv->predefined_marshal_set), "VOID:FLOAT");
		gee_collection_add (GEE_COLLECTION (self->priv->predefined_marshal_set), "VOID:DOUBLE");
		gee_collection_add (GEE_COLLECTION (self->priv->predefined_marshal_set), "VOID:STRING");
		gee_collection_add (GEE_COLLECTION (self->priv->predefined_marshal_set), "VOID:POINTER");
		gee_collection_add (GEE_COLLECTION (self->priv->predefined_marshal_set), "VOID:OBJECT");
		gee_collection_add (GEE_COLLECTION (self->priv->predefined_marshal_set), "STRING:OBJECT,POINTER");
		gee_collection_add (GEE_COLLECTION (self->priv->predefined_marshal_set), "VOID:UINT,POINTER");
		gee_collection_add (GEE_COLLECTION (self->priv->predefined_marshal_set), "BOOLEAN:FLAGS");
		_tmp1 = NULL;
		self->priv->c_keywords = (_tmp1 = GEE_SET (gee_hash_set_new (G_TYPE_STRING, ((GBoxedCopyFunc) g_strdup), g_free, g_str_hash, g_str_equal)), (self->priv->c_keywords == NULL ? NULL : (self->priv->c_keywords = (g_object_unref (self->priv->c_keywords), NULL))), _tmp1);
		/* C99 keywords*/
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "_Bool");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "_Complex");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "_Imaginary");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "auto");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "break");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "case");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "char");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "const");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "continue");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "default");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "do");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "double");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "else");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "enum");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "extern");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "float");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "for");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "goto");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "if");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "inline");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "int");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "long");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "register");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "restrict");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "return");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "short");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "signed");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "sizeof");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "static");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "struct");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "switch");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "typedef");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "union");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "unsigned");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "void");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "volatile");
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "while");
		/* MSVC keywords*/
		gee_collection_add (GEE_COLLECTION (self->priv->c_keywords), "cdecl");
	}
	return obj;
}


static void vala_ccode_generator_class_init (ValaCCodeGeneratorClass * klass) {
	vala_ccode_generator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCCodeGeneratorPrivate));
	G_OBJECT_CLASS (klass)->constructor = vala_ccode_generator_constructor;
	G_OBJECT_CLASS (klass)->dispose = vala_ccode_generator_dispose;
	VALA_CODE_GENERATOR_CLASS (klass)->emit = vala_ccode_generator_real_emit;
	VALA_CODE_VISITOR_CLASS (klass)->visit_enum = vala_ccode_generator_real_visit_enum;
	VALA_CODE_VISITOR_CLASS (klass)->visit_enum_value = vala_ccode_generator_real_visit_enum_value;
	VALA_CODE_VISITOR_CLASS (klass)->visit_delegate = vala_ccode_generator_real_visit_delegate;
	VALA_CODE_VISITOR_CLASS (klass)->visit_member = vala_ccode_generator_real_visit_member;
	VALA_CODE_VISITOR_CLASS (klass)->visit_constant = vala_ccode_generator_real_visit_constant;
	VALA_CODE_VISITOR_CLASS (klass)->visit_field = vala_ccode_generator_real_visit_field;
	VALA_CODE_VISITOR_CLASS (klass)->visit_formal_parameter = vala_ccode_generator_real_visit_formal_parameter;
	VALA_CODE_VISITOR_CLASS (klass)->visit_property = vala_ccode_generator_real_visit_property;
	VALA_CODE_VISITOR_CLASS (klass)->visit_property_accessor = vala_ccode_generator_real_visit_property_accessor;
	VALA_CODE_VISITOR_CLASS (klass)->visit_constructor = vala_ccode_generator_real_visit_constructor;
	VALA_CODE_VISITOR_CLASS (klass)->visit_destructor = vala_ccode_generator_real_visit_destructor;
	VALA_CODE_VISITOR_CLASS (klass)->visit_block = vala_ccode_generator_real_visit_block;
	VALA_CODE_VISITOR_CLASS (klass)->visit_empty_statement = vala_ccode_generator_real_visit_empty_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_declaration_statement = vala_ccode_generator_real_visit_declaration_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_variable_declarator = vala_ccode_generator_real_visit_variable_declarator;
	VALA_CODE_VISITOR_CLASS (klass)->visit_initializer_list = vala_ccode_generator_real_visit_initializer_list;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_full_expression = vala_ccode_generator_real_visit_end_full_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_expression_statement = vala_ccode_generator_real_visit_expression_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_if_statement = vala_ccode_generator_real_visit_if_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_switch_statement = vala_ccode_generator_real_visit_switch_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_switch_section = vala_ccode_generator_real_visit_switch_section;
	VALA_CODE_VISITOR_CLASS (klass)->visit_while_statement = vala_ccode_generator_real_visit_while_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_do_statement = vala_ccode_generator_real_visit_do_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_for_statement = vala_ccode_generator_real_visit_for_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_foreach_statement = vala_ccode_generator_real_visit_foreach_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_break_statement = vala_ccode_generator_real_visit_break_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_continue_statement = vala_ccode_generator_real_visit_continue_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_return_statement = vala_ccode_generator_real_visit_return_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_throw_statement = vala_ccode_generator_real_visit_throw_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_try_statement = vala_ccode_generator_real_visit_try_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_catch_clause = vala_ccode_generator_real_visit_catch_clause;
	VALA_CODE_VISITOR_CLASS (klass)->visit_lock_statement = vala_ccode_generator_real_visit_lock_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_array_creation_expression = vala_ccode_generator_real_visit_array_creation_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_boolean_literal = vala_ccode_generator_real_visit_boolean_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_character_literal = vala_ccode_generator_real_visit_character_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_integer_literal = vala_ccode_generator_real_visit_integer_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_real_literal = vala_ccode_generator_real_visit_real_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_string_literal = vala_ccode_generator_real_visit_string_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_null_literal = vala_ccode_generator_real_visit_null_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_literal_expression = vala_ccode_generator_real_visit_literal_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_parenthesized_expression = vala_ccode_generator_real_visit_parenthesized_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_element_access = vala_ccode_generator_real_visit_element_access;
	VALA_CODE_VISITOR_CLASS (klass)->visit_base_access = vala_ccode_generator_real_visit_base_access;
	VALA_CODE_VISITOR_CLASS (klass)->visit_postfix_expression = vala_ccode_generator_real_visit_postfix_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_object_creation_expression = vala_ccode_generator_real_visit_object_creation_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_sizeof_expression = vala_ccode_generator_real_visit_sizeof_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_typeof_expression = vala_ccode_generator_real_visit_typeof_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_unary_expression = vala_ccode_generator_real_visit_unary_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_cast_expression = vala_ccode_generator_real_visit_cast_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_pointer_indirection = vala_ccode_generator_real_visit_pointer_indirection;
	VALA_CODE_VISITOR_CLASS (klass)->visit_addressof_expression = vala_ccode_generator_real_visit_addressof_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_reference_transfer_expression = vala_ccode_generator_real_visit_reference_transfer_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_binary_expression = vala_ccode_generator_real_visit_binary_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_type_check = vala_ccode_generator_real_visit_type_check;
	VALA_CODE_VISITOR_CLASS (klass)->visit_conditional_expression = vala_ccode_generator_real_visit_conditional_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_lambda_expression = vala_ccode_generator_real_visit_lambda_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_assignment = vala_ccode_generator_real_visit_assignment;
	VALA_CODE_GENERATOR_CLASS (klass)->create_namespace_binding = vala_ccode_generator_real_create_namespace_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_class_binding = vala_ccode_generator_real_create_class_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_struct_binding = vala_ccode_generator_real_create_struct_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_interface_binding = vala_ccode_generator_real_create_interface_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_enum_binding = vala_ccode_generator_real_create_enum_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_enum_value_binding = vala_ccode_generator_real_create_enum_value_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_delegate_binding = vala_ccode_generator_real_create_delegate_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_constant_binding = vala_ccode_generator_real_create_constant_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_field_binding = vala_ccode_generator_real_create_field_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_method_binding = vala_ccode_generator_real_create_method_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_creation_method_binding = vala_ccode_generator_real_create_creation_method_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_formal_parameter_binding = vala_ccode_generator_real_create_formal_parameter_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_property_binding = vala_ccode_generator_real_create_property_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_property_accessor_binding = vala_ccode_generator_real_create_property_accessor_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_signal_binding = vala_ccode_generator_real_create_signal_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_constructor_binding = vala_ccode_generator_real_create_constructor_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_destructor_binding = vala_ccode_generator_real_create_destructor_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_type_parameter_binding = vala_ccode_generator_real_create_type_parameter_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_block_binding = vala_ccode_generator_real_create_block_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_empty_statement_binding = vala_ccode_generator_real_create_empty_statement_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_declaration_statement_binding = vala_ccode_generator_real_create_declaration_statement_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_local_variable_declaration_binding = vala_ccode_generator_real_create_local_variable_declaration_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_variable_declarator_binding = vala_ccode_generator_real_create_variable_declarator_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_initializer_list_binding = vala_ccode_generator_real_create_initializer_list_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_expression_statement_binding = vala_ccode_generator_real_create_expression_statement_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_if_statement_binding = vala_ccode_generator_real_create_if_statement_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_switch_statement_binding = vala_ccode_generator_real_create_switch_statement_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_switch_section_binding = vala_ccode_generator_real_create_switch_section_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_switch_label_binding = vala_ccode_generator_real_create_switch_label_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_while_statement_binding = vala_ccode_generator_real_create_while_statement_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_do_statement_binding = vala_ccode_generator_real_create_do_statement_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_for_statement_binding = vala_ccode_generator_real_create_for_statement_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_foreach_statement_binding = vala_ccode_generator_real_create_foreach_statement_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_break_statement_binding = vala_ccode_generator_real_create_break_statement_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_continue_statement_binding = vala_ccode_generator_real_create_continue_statement_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_return_statement_binding = vala_ccode_generator_real_create_return_statement_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_throw_statement_binding = vala_ccode_generator_real_create_throw_statement_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_try_statement_binding = vala_ccode_generator_real_create_try_statement_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_catch_clause_binding = vala_ccode_generator_real_create_catch_clause_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_lock_statement_binding = vala_ccode_generator_real_create_lock_statement_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_array_creation_expression_binding = vala_ccode_generator_real_create_array_creation_expression_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_boolean_literal_binding = vala_ccode_generator_real_create_boolean_literal_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_character_literal_binding = vala_ccode_generator_real_create_character_literal_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_integer_literal_binding = vala_ccode_generator_real_create_integer_literal_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_real_literal_binding = vala_ccode_generator_real_create_real_literal_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_string_literal_binding = vala_ccode_generator_real_create_string_literal_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_null_literal_binding = vala_ccode_generator_real_create_null_literal_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_literal_expression_binding = vala_ccode_generator_real_create_literal_expression_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_parenthesized_expression_binding = vala_ccode_generator_real_create_parenthesized_expression_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_member_access_binding = vala_ccode_generator_real_create_member_access_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_member_access_simple_binding = vala_ccode_generator_real_create_member_access_simple_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_invocation_expression_binding = vala_ccode_generator_real_create_invocation_expression_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_element_access_binding = vala_ccode_generator_real_create_element_access_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_base_access_binding = vala_ccode_generator_real_create_base_access_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_postfix_expression_binding = vala_ccode_generator_real_create_postfix_expression_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_object_creation_expression_binding = vala_ccode_generator_real_create_object_creation_expression_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_sizeof_expression_binding = vala_ccode_generator_real_create_sizeof_expression_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_typeof_expression_binding = vala_ccode_generator_real_create_typeof_expression_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_unary_expression_binding = vala_ccode_generator_real_create_unary_expression_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_cast_expression_binding = vala_ccode_generator_real_create_cast_expression_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_pointer_indirection_binding = vala_ccode_generator_real_create_pointer_indirection_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_addressof_expression_binding = vala_ccode_generator_real_create_addressof_expression_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_reference_transfer_expression_binding = vala_ccode_generator_real_create_reference_transfer_expression_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_binary_expression_binding = vala_ccode_generator_real_create_binary_expression_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_type_check_binding = vala_ccode_generator_real_create_type_check_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_conditional_expression_binding = vala_ccode_generator_real_create_conditional_expression_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_lambda_expression_binding = vala_ccode_generator_real_create_lambda_expression_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_lambda_expression_with_statement_body_binding = vala_ccode_generator_real_create_lambda_expression_with_statement_body_binding;
	VALA_CODE_GENERATOR_CLASS (klass)->create_assignment_binding = vala_ccode_generator_real_create_assignment_binding;
	VALA_CODE_VISITOR_CLASS (klass)->visit_class = vala_ccode_generator_real_visit_class;
	VALA_CODE_VISITOR_CLASS (klass)->visit_interface = vala_ccode_generator_real_visit_interface;
	VALA_CODE_VISITOR_CLASS (klass)->visit_invocation_expression = vala_ccode_generator_real_visit_invocation_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_member_access = vala_ccode_generator_real_visit_member_access;
	VALA_CODE_VISITOR_CLASS (klass)->visit_method = vala_ccode_generator_real_visit_method;
	VALA_CODE_VISITOR_CLASS (klass)->visit_creation_method = vala_ccode_generator_real_visit_creation_method;
	VALA_CODE_VISITOR_CLASS (klass)->visit_signal = vala_ccode_generator_real_visit_signal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_source_file = vala_ccode_generator_real_visit_source_file;
	VALA_CODE_VISITOR_CLASS (klass)->visit_struct = vala_ccode_generator_real_visit_struct;
}


static void vala_ccode_generator_init (ValaCCodeGenerator * self) {
	self->priv = VALA_CCODE_GENERATOR_GET_PRIVATE (self);
	self->temp_vars = gee_array_list_new (VALA_TYPE_VARIABLE_DECLARATOR, ((GBoxedCopyFunc) g_object_ref), g_object_unref, g_direct_equal);
	self->priv->temp_ref_vars = gee_array_list_new (VALA_TYPE_VARIABLE_DECLARATOR, ((GBoxedCopyFunc) g_object_ref), g_object_unref, g_direct_equal);
	self->priv->next_temp_var_id = 0;
	self->priv->current_try_id = 0;
	self->priv->next_try_id = 0;
	self->in_creation_method = FALSE;
	self->priv->current_method_inner_error = FALSE;
	self->priv->in_plugin = FALSE;
}


static void vala_ccode_generator_dispose (GObject * obj) {
	ValaCCodeGenerator * self;
	self = VALA_CCODE_GENERATOR (obj);
	(self->priv->context == NULL ? NULL : (self->priv->context = (g_object_unref (self->priv->context), NULL)));
	(self->priv->root_symbol == NULL ? NULL : (self->priv->root_symbol = (g_object_unref (self->priv->root_symbol), NULL)));
	(self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL)));
	(self->current_type_symbol == NULL ? NULL : (self->current_type_symbol = (g_object_unref (self->current_type_symbol), NULL)));
	(self->priv->current_class == NULL ? NULL : (self->priv->current_class = (g_object_unref (self->priv->current_class), NULL)));
	(self->priv->current_method == NULL ? NULL : (self->priv->current_method = (g_object_unref (self->priv->current_method), NULL)));
	(self->priv->current_return_type == NULL ? NULL : (self->priv->current_return_type = (g_object_unref (self->priv->current_return_type), NULL)));
	(self->priv->current_try == NULL ? NULL : (self->priv->current_try = (g_object_unref (self->priv->current_try), NULL)));
	(self->priv->header_begin == NULL ? NULL : (self->priv->header_begin = (g_object_unref (self->priv->header_begin), NULL)));
	(self->priv->header_type_declaration == NULL ? NULL : (self->priv->header_type_declaration = (g_object_unref (self->priv->header_type_declaration), NULL)));
	(self->priv->header_type_definition == NULL ? NULL : (self->priv->header_type_definition = (g_object_unref (self->priv->header_type_definition), NULL)));
	(self->priv->header_type_member_declaration == NULL ? NULL : (self->priv->header_type_member_declaration = (g_object_unref (self->priv->header_type_member_declaration), NULL)));
	(self->priv->source_begin == NULL ? NULL : (self->priv->source_begin = (g_object_unref (self->priv->source_begin), NULL)));
	(self->priv->source_include_directives == NULL ? NULL : (self->priv->source_include_directives = (g_object_unref (self->priv->source_include_directives), NULL)));
	(self->priv->source_type_member_declaration == NULL ? NULL : (self->priv->source_type_member_declaration = (g_object_unref (self->priv->source_type_member_declaration), NULL)));
	(self->priv->source_signal_marshaller_declaration == NULL ? NULL : (self->priv->source_signal_marshaller_declaration = (g_object_unref (self->priv->source_signal_marshaller_declaration), NULL)));
	(self->priv->source_type_member_definition == NULL ? NULL : (self->priv->source_type_member_definition = (g_object_unref (self->priv->source_type_member_definition), NULL)));
	(self->priv->class_init_fragment == NULL ? NULL : (self->priv->class_init_fragment = (g_object_unref (self->priv->class_init_fragment), NULL)));
	(self->priv->instance_init_fragment == NULL ? NULL : (self->priv->instance_init_fragment = (g_object_unref (self->priv->instance_init_fragment), NULL)));
	(self->priv->instance_dispose_fragment == NULL ? NULL : (self->priv->instance_dispose_fragment = (g_object_unref (self->priv->instance_dispose_fragment), NULL)));
	(self->priv->source_signal_marshaller_definition == NULL ? NULL : (self->priv->source_signal_marshaller_definition = (g_object_unref (self->priv->source_signal_marshaller_definition), NULL)));
	(self->priv->module_init_fragment == NULL ? NULL : (self->priv->module_init_fragment = (g_object_unref (self->priv->module_init_fragment), NULL)));
	(self->priv->instance_struct == NULL ? NULL : (self->priv->instance_struct = (g_object_unref (self->priv->instance_struct), NULL)));
	(self->priv->type_struct == NULL ? NULL : (self->priv->type_struct = (g_object_unref (self->priv->type_struct), NULL)));
	(self->priv->instance_priv_struct == NULL ? NULL : (self->priv->instance_priv_struct = (g_object_unref (self->priv->instance_priv_struct), NULL)));
	(self->priv->prop_enum == NULL ? NULL : (self->priv->prop_enum = (g_object_unref (self->priv->prop_enum), NULL)));
	(self->priv->cenum == NULL ? NULL : (self->priv->cenum = (g_object_unref (self->priv->cenum), NULL)));
	(self->priv->function == NULL ? NULL : (self->priv->function = (g_object_unref (self->priv->function), NULL)));
	(self->priv->block == NULL ? NULL : (self->priv->block = (g_object_unref (self->priv->block), NULL)));
	(self->temp_vars == NULL ? NULL : (self->temp_vars = (g_object_unref (self->temp_vars), NULL)));
	(self->priv->temp_ref_vars == NULL ? NULL : (self->priv->temp_ref_vars = (g_object_unref (self->priv->temp_ref_vars), NULL)));
	(self->priv->user_marshal_set == NULL ? NULL : (self->priv->user_marshal_set = (g_object_unref (self->priv->user_marshal_set), NULL)));
	(self->priv->predefined_marshal_set == NULL ? NULL : (self->priv->predefined_marshal_set = (g_object_unref (self->priv->predefined_marshal_set), NULL)));
	(self->priv->c_keywords == NULL ? NULL : (self->priv->c_keywords = (g_object_unref (self->priv->c_keywords), NULL)));
	(self->bool_type == NULL ? NULL : (self->bool_type = (g_object_unref (self->bool_type), NULL)));
	(self->char_type == NULL ? NULL : (self->char_type = (g_object_unref (self->char_type), NULL)));
	(self->unichar_type == NULL ? NULL : (self->unichar_type = (g_object_unref (self->unichar_type), NULL)));
	(self->short_type == NULL ? NULL : (self->short_type = (g_object_unref (self->short_type), NULL)));
	(self->ushort_type == NULL ? NULL : (self->ushort_type = (g_object_unref (self->ushort_type), NULL)));
	(self->int_type == NULL ? NULL : (self->int_type = (g_object_unref (self->int_type), NULL)));
	(self->uint_type == NULL ? NULL : (self->uint_type = (g_object_unref (self->uint_type), NULL)));
	(self->long_type == NULL ? NULL : (self->long_type = (g_object_unref (self->long_type), NULL)));
	(self->ulong_type == NULL ? NULL : (self->ulong_type = (g_object_unref (self->ulong_type), NULL)));
	(self->int64_type == NULL ? NULL : (self->int64_type = (g_object_unref (self->int64_type), NULL)));
	(self->uint64_type == NULL ? NULL : (self->uint64_type = (g_object_unref (self->uint64_type), NULL)));
	(self->string_type == NULL ? NULL : (self->string_type = (g_object_unref (self->string_type), NULL)));
	(self->float_type == NULL ? NULL : (self->float_type = (g_object_unref (self->float_type), NULL)));
	(self->double_type == NULL ? NULL : (self->double_type = (g_object_unref (self->double_type), NULL)));
	(self->gtypeinstance_type == NULL ? NULL : (self->gtypeinstance_type = (g_object_unref (self->gtypeinstance_type), NULL)));
	(self->gobject_type == NULL ? NULL : (self->gobject_type = (g_object_unref (self->gobject_type), NULL)));
	(self->gerror_type == NULL ? NULL : (self->gerror_type = (g_object_unref (self->gerror_type), NULL)));
	(self->glist_type == NULL ? NULL : (self->glist_type = (g_object_unref (self->glist_type), NULL)));
	(self->gslist_type == NULL ? NULL : (self->gslist_type = (g_object_unref (self->gslist_type), NULL)));
	(self->gstring_type == NULL ? NULL : (self->gstring_type = (g_object_unref (self->gstring_type), NULL)));
	(self->garray_type == NULL ? NULL : (self->garray_type = (g_object_unref (self->garray_type), NULL)));
	(self->gquark_type == NULL ? NULL : (self->gquark_type = (g_object_unref (self->gquark_type), NULL)));
	(self->mutex_type == NULL ? NULL : (self->mutex_type = (g_object_unref (self->mutex_type), NULL)));
	(self->type_module_type == NULL ? NULL : (self->type_module_type = (g_object_unref (self->type_module_type), NULL)));
	(self->iterable_type == NULL ? NULL : (self->iterable_type = (g_object_unref (self->iterable_type), NULL)));
	(self->iterator_type == NULL ? NULL : (self->iterator_type = (g_object_unref (self->iterator_type), NULL)));
	(self->list_type == NULL ? NULL : (self->list_type = (g_object_unref (self->list_type), NULL)));
	(self->map_type == NULL ? NULL : (self->map_type = (g_object_unref (self->map_type), NULL)));
	(self->connection_type == NULL ? NULL : (self->connection_type = (g_object_unref (self->connection_type), NULL)));
	(self->priv->substring_method == NULL ? NULL : (self->priv->substring_method = (g_object_unref (self->priv->substring_method), NULL)));
	(self->priv->module_init_param_name = (g_free (self->priv->module_init_param_name), NULL));
	G_OBJECT_CLASS (vala_ccode_generator_parent_class)->dispose (obj);
}


GType vala_ccode_generator_get_type (void) {
	static GType vala_ccode_generator_type_id = 0;
	if (G_UNLIKELY (vala_ccode_generator_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeGeneratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_generator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeGenerator), 0, (GInstanceInitFunc) vala_ccode_generator_init };
		vala_ccode_generator_type_id = g_type_register_static (VALA_TYPE_CODE_GENERATOR, "ValaCCodeGenerator", &g_define_type_info, 0);
	}
	return vala_ccode_generator_type_id;
}




