/* valadbusmethod.vala
 *
 * Copyright (C) 2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __GOBJECT_VALADBUSMETHOD_H__
#define __GOBJECT_VALADBUSMETHOD_H__

#include <glib.h>
#include <glib-object.h>
#include <vala/valamethod.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valadatatype.h>
#include <vala/valasourcereference.h>
#include <gee/collection.h>

G_BEGIN_DECLS


#define VALA_TYPE_DBUS_METHOD (vala_dbus_method_get_type ())
#define VALA_DBUS_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DBUS_METHOD, ValaDBusMethod))
#define VALA_DBUS_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DBUS_METHOD, ValaDBusMethodClass))
#define VALA_IS_DBUS_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DBUS_METHOD))
#define VALA_IS_DBUS_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DBUS_METHOD))
#define VALA_DBUS_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DBUS_METHOD, ValaDBusMethodClass))

typedef struct _ValaDBusMethod ValaDBusMethod;
typedef struct _ValaDBusMethodClass ValaDBusMethodClass;
typedef struct _ValaDBusMethodPrivate ValaDBusMethodPrivate;

/**
 * Represents a dynamic bound DBus method.
 */
struct _ValaDBusMethod {
	ValaMethod parent_instance;
	ValaDBusMethodPrivate * priv;
};
struct _ValaDBusMethodClass {
	ValaMethodClass parent_class;
};

ValaDBusMethod* vala_dbus_method_new (const char* name, ValaDataType* return_type, ValaSourceReference* source_reference);
GType vala_dbus_method_get_type (void);

G_END_DECLS

#endif
