/* valaarray.vala
 *
 * Copyright (C) 2006-2007  Raffaele Sandrini, Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Raffaele Sandrini <rasa@gmx.ch>
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALA_VALAARRAY_H__
#define __VALA_VALAARRAY_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee/collection.h>
#include <vala/valatypesymbol.h>
#include <vala/valacodenode.h>
#include <vala/valaarraymovemethod.h>

G_BEGIN_DECLS


#define VALA_TYPE_ARRAY (vala_array_get_type ())
#define VALA_ARRAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ARRAY, ValaArray))
#define VALA_ARRAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ARRAY, ValaArrayClass))
#define VALA_IS_ARRAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ARRAY))
#define VALA_IS_ARRAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ARRAY))
#define VALA_ARRAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ARRAY, ValaArrayClass))

typedef struct _ValaArrayPrivate ValaArrayPrivate;

/**
 * Represents an array type i.e. everything with direct accessable elements.
 */
struct _ValaArray {
	ValaTypesymbol parent_instance;
	ValaArrayPrivate * priv;
};
struct _ValaArrayClass {
	ValaTypesymbolClass parent_class;
};

ValaArray* vala_array_new (ValaTypesymbol* _element_type, gint _rank, ValaSourceReference* _source_reference);
ValaArray* vala_array_new_with_type_parameter (ValaTypeParameter* _element_type_parameter, gint _rank, ValaSourceReference* _source_reference);
ValaArrayLengthField* vala_array_get_length_field (ValaArray* self);
ValaArrayResizeMethod* vala_array_get_resize_method (ValaArray* self);
ValaArrayMoveMethod* vala_array_get_move_method (ValaArray* self);
ValaTypesymbol* vala_array_get_element_type (ValaArray* self);
void vala_array_set_element_type (ValaArray* self, ValaTypesymbol* value);
ValaTypeParameter* vala_array_get_element_type_parameter (ValaArray* self);
void vala_array_set_element_type_parameter (ValaArray* self, ValaTypeParameter* value);
gint vala_array_get_rank (ValaArray* self);
void vala_array_set_rank (ValaArray* self, gint value);
GType vala_array_get_type (void);

G_END_DECLS

#endif
