/* valaexpressionstatement.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valaexpressionstatement.h>
#include <vala/valaexpression.h>
#include <vala/valasourcereference.h>
#include <vala/valacodevisitor.h>
#include <vala/valaproperty.h>
#include <vala/valaassignment.h>
#include <vala/valamemberaccess.h>

struct _ValaExpressionStatementPrivate {
	ValaExpression* _expression;
};
#define VALA_EXPRESSION_STATEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_EXPRESSION_STATEMENT, ValaExpressionStatementPrivate))
enum  {
	VALA_EXPRESSION_STATEMENT_DUMMY_PROPERTY,
	VALA_EXPRESSION_STATEMENT_EXPRESSION
};
static void vala_expression_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_expression_statement_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node);
static gpointer vala_expression_statement_parent_class = NULL;
static ValaStatementIface* vala_expression_statement_vala_statement_parent_iface = NULL;
static void vala_expression_statement_dispose (GObject * obj);


/**
 * Creates a new expression statement.
 *
 * @param expr   expression to evaluate
 * @param source reference to source code
 * @return       newly created expression statement
 */
ValaExpressionStatement* vala_expression_statement_new (ValaExpression* expression, ValaSourceReference* source_reference) {
	GParameter * __params;
	GParameter * __params_it;
	ValaExpressionStatement * self;
	g_return_val_if_fail (expression == NULL || VALA_IS_EXPRESSION (expression), NULL);
	g_return_val_if_fail (source_reference == NULL || VALA_IS_SOURCE_REFERENCE (source_reference), NULL);
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	(__params_it->name = "expression", g_value_init (&__params_it->value, VALA_TYPE_EXPRESSION), g_value_set_object (&__params_it->value, expression), __params_it++);
	self = g_object_newv (VALA_TYPE_EXPRESSION_STATEMENT, __params_it - __params, __params);
	vala_code_node_set_source_reference (VALA_CODE_NODE (self), source_reference);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


static void vala_expression_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaExpressionStatement * self;
	self = VALA_EXPRESSION_STATEMENT (base);
	g_return_if_fail (visitor == NULL || VALA_IS_CODE_VISITOR (visitor));
	vala_code_node_accept (VALA_CODE_NODE (vala_expression_statement_get_expression (self)), visitor);
	vala_code_visitor_visit_expression_statement (visitor, self);
}


static void vala_expression_statement_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node) {
	ValaExpressionStatement * self;
	self = VALA_EXPRESSION_STATEMENT (base);
	g_return_if_fail (old_node == NULL || VALA_IS_EXPRESSION (old_node));
	g_return_if_fail (new_node == NULL || VALA_IS_EXPRESSION (new_node));
	if (vala_expression_statement_get_expression (self) == old_node) {
		vala_expression_statement_set_expression (self, new_node);
	}
}


/**
 * Returns the property this statement sets, if any.
 *
 * @return the property this statement sets, or null if it doesn't set
 *         a property
 */
ValaProperty* vala_expression_statement_assigned_property (ValaExpressionStatement* self) {
	g_return_val_if_fail (VALA_IS_EXPRESSION_STATEMENT (self), NULL);
	if (VALA_IS_ASSIGNMENT (vala_expression_statement_get_expression (self))) {
		ValaAssignment* _tmp0;
		ValaAssignment* assign;
		_tmp0 = NULL;
		assign = (_tmp0 = VALA_ASSIGNMENT (vala_expression_statement_get_expression (self)), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
		if (VALA_IS_MEMBER_ACCESS (vala_assignment_get_left (assign))) {
			ValaMemberAccess* _tmp1;
			ValaMemberAccess* ma;
			_tmp1 = NULL;
			ma = (_tmp1 = VALA_MEMBER_ACCESS (vala_assignment_get_left (assign)), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
			if (VALA_IS_PROPERTY (vala_expression_get_symbol_reference (VALA_EXPRESSION (ma)))) {
				ValaProperty* _tmp2;
				ValaProperty* _tmp3;
				_tmp2 = NULL;
				_tmp3 = NULL;
				return (_tmp3 = (_tmp2 = VALA_PROPERTY (vala_expression_get_symbol_reference (VALA_EXPRESSION (ma))), (_tmp2 == NULL ? NULL : g_object_ref (_tmp2))), (ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL))), (assign == NULL ? NULL : (assign = (g_object_unref (assign), NULL))), _tmp3);
			}
			(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
		}
		(assign == NULL ? NULL : (assign = (g_object_unref (assign), NULL)));
	}
	return NULL;
}


ValaExpression* vala_expression_statement_get_expression (ValaExpressionStatement* self) {
	g_return_val_if_fail (VALA_IS_EXPRESSION_STATEMENT (self), NULL);
	return self->priv->_expression;
}


void vala_expression_statement_set_expression (ValaExpressionStatement* self, ValaExpression* value) {
	ValaExpression* _tmp2;
	ValaExpression* _tmp1;
	g_return_if_fail (VALA_IS_EXPRESSION_STATEMENT (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_expression = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_expression == NULL ? NULL : (self->priv->_expression = (g_object_unref (self->priv->_expression), NULL))), _tmp2);
	vala_code_node_set_parent_node (VALA_CODE_NODE (self->priv->_expression), VALA_CODE_NODE (self));
}


static void vala_expression_statement_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaExpressionStatement * self;
	self = VALA_EXPRESSION_STATEMENT (object);
	switch (property_id) {
		case VALA_EXPRESSION_STATEMENT_EXPRESSION:
		g_value_set_object (value, vala_expression_statement_get_expression (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_expression_statement_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaExpressionStatement * self;
	self = VALA_EXPRESSION_STATEMENT (object);
	switch (property_id) {
		case VALA_EXPRESSION_STATEMENT_EXPRESSION:
		vala_expression_statement_set_expression (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_expression_statement_class_init (ValaExpressionStatementClass * klass) {
	vala_expression_statement_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaExpressionStatementPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_expression_statement_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_expression_statement_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_expression_statement_dispose;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_expression_statement_real_accept;
	VALA_CODE_NODE_CLASS (klass)->replace_expression = vala_expression_statement_real_replace_expression;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_EXPRESSION_STATEMENT_EXPRESSION, g_param_spec_object ("expression", "expression", "expression", VALA_TYPE_EXPRESSION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void vala_expression_statement_vala_statement_interface_init (ValaStatementIface * iface) {
	vala_expression_statement_vala_statement_parent_iface = g_type_interface_peek_parent (iface);
}


static void vala_expression_statement_init (ValaExpressionStatement * self) {
	self->priv = VALA_EXPRESSION_STATEMENT_GET_PRIVATE (self);
}


static void vala_expression_statement_dispose (GObject * obj) {
	ValaExpressionStatement * self;
	self = VALA_EXPRESSION_STATEMENT (obj);
	(self->priv->_expression == NULL ? NULL : (self->priv->_expression = (g_object_unref (self->priv->_expression), NULL)));
	G_OBJECT_CLASS (vala_expression_statement_parent_class)->dispose (obj);
}


GType vala_expression_statement_get_type (void) {
	static GType vala_expression_statement_type_id = 0;
	if (G_UNLIKELY (vala_expression_statement_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaExpressionStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_expression_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaExpressionStatement), 0, (GInstanceInitFunc) vala_expression_statement_init };
		static const GInterfaceInfo vala_statement_info = { (GInterfaceInitFunc) vala_expression_statement_vala_statement_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		vala_expression_statement_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaExpressionStatement", &g_define_type_info, 0);
		g_type_add_interface_static (vala_expression_statement_type_id, VALA_TYPE_STATEMENT, &vala_statement_info);
	}
	return vala_expression_statement_type_id;
}




