/* valainvalidtype.vala
 *
 * Copyright (C) 2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valainvalidtype.h>
#include <vala/valacodenode.h>

enum  {
	VALA_INVALID_TYPE_DUMMY_PROPERTY
};
static gpointer vala_invalid_type_parent_class = NULL;


ValaInvalidType* vala_invalid_type_new (void) {
	ValaInvalidType * self;
	self = g_object_newv (VALA_TYPE_INVALID_TYPE, 0, NULL);
	vala_code_node_set_error (VALA_CODE_NODE (self), TRUE);
	return self;
}


static void vala_invalid_type_class_init (ValaInvalidTypeClass * klass) {
	vala_invalid_type_parent_class = g_type_class_peek_parent (klass);
}


static void vala_invalid_type_init (ValaInvalidType * self) {
}


GType vala_invalid_type_get_type (void) {
	static GType vala_invalid_type_type_id = 0;
	if (G_UNLIKELY (vala_invalid_type_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaInvalidTypeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_invalid_type_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaInvalidType), 0, (GInstanceInitFunc) vala_invalid_type_init };
		vala_invalid_type_type_id = g_type_register_static (VALA_TYPE_DATA_TYPE, "ValaInvalidType", &g_define_type_info, 0);
	}
	return vala_invalid_type_type_id;
}




