/* valaccodeinitializerlist.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __CCODE_VALACCODEINITIALIZERLIST_H__
#define __CCODE_VALACCODEINITIALIZERLIST_H__

#include <glib.h>
#include <glib-object.h>
#include <ccode/valaccodeexpression.h>
#include <ccode/valaccodewriter.h>

G_BEGIN_DECLS


#define VALA_TYPE_CCODE_INITIALIZER_LIST (vala_ccode_initializer_list_get_type ())
#define VALA_CCODE_INITIALIZER_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_INITIALIZER_LIST, ValaCCodeInitializerList))
#define VALA_CCODE_INITIALIZER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_INITIALIZER_LIST, ValaCCodeInitializerListClass))
#define VALA_IS_CCODE_INITIALIZER_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_INITIALIZER_LIST))
#define VALA_IS_CCODE_INITIALIZER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_INITIALIZER_LIST))
#define VALA_CCODE_INITIALIZER_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_INITIALIZER_LIST, ValaCCodeInitializerListClass))

typedef struct _ValaCCodeInitializerList ValaCCodeInitializerList;
typedef struct _ValaCCodeInitializerListClass ValaCCodeInitializerListClass;
typedef struct _ValaCCodeInitializerListPrivate ValaCCodeInitializerListPrivate;

/**
 * Represents a struct or array initializer list in the C code.
 */
struct _ValaCCodeInitializerList {
	ValaCCodeExpression parent_instance;
	ValaCCodeInitializerListPrivate * priv;
};
struct _ValaCCodeInitializerListClass {
	ValaCCodeExpressionClass parent_class;
};

void vala_ccode_initializer_list_append (ValaCCodeInitializerList* self, ValaCCodeExpression* expr);
ValaCCodeInitializerList* vala_ccode_initializer_list_new (void);
GType vala_ccode_initializer_list_get_type (void);

G_END_DECLS

#endif
