/* valaccodeexpressionbinding.vala
 *
 * Copyright (C) 2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <gobject/valaccodeexpressionbinding.h>

struct _ValaCCodeExpressionBindingPrivate {
	ValaCCodeExpression* _codenode;
};
#define VALA_CCODE_EXPRESSION_BINDING_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_EXPRESSION_BINDING, ValaCCodeExpressionBindingPrivate))
enum  {
	VALA_CCODE_EXPRESSION_BINDING_DUMMY_PROPERTY,
	VALA_CCODE_EXPRESSION_BINDING_CODENODE
};
static gpointer vala_ccode_expression_binding_parent_class = NULL;
static void vala_ccode_expression_binding_dispose (GObject * obj);


ValaCCodeExpression* vala_ccode_expression_binding_get_codenode (ValaCCodeExpressionBinding* self) {
	g_return_val_if_fail (VALA_IS_CCODE_EXPRESSION_BINDING (self), NULL);
	return self->priv->_codenode;
}


void vala_ccode_expression_binding_set_codenode (ValaCCodeExpressionBinding* self, ValaCCodeExpression* value) {
	ValaCCodeExpression* _tmp2;
	ValaCCodeExpression* _tmp1;
	g_return_if_fail (VALA_IS_CCODE_EXPRESSION_BINDING (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_codenode = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_codenode == NULL ? NULL : (self->priv->_codenode = (g_object_unref (self->priv->_codenode), NULL))), _tmp2);
}


static void vala_ccode_expression_binding_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaCCodeExpressionBinding * self;
	self = VALA_CCODE_EXPRESSION_BINDING (object);
	switch (property_id) {
		case VALA_CCODE_EXPRESSION_BINDING_CODENODE:
		g_value_set_object (value, vala_ccode_expression_binding_get_codenode (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_expression_binding_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaCCodeExpressionBinding * self;
	self = VALA_CCODE_EXPRESSION_BINDING (object);
	switch (property_id) {
		case VALA_CCODE_EXPRESSION_BINDING_CODENODE:
		vala_ccode_expression_binding_set_codenode (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_expression_binding_class_init (ValaCCodeExpressionBindingClass * klass) {
	vala_ccode_expression_binding_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCCodeExpressionBindingPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_ccode_expression_binding_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_ccode_expression_binding_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_ccode_expression_binding_dispose;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_EXPRESSION_BINDING_CODENODE, g_param_spec_object ("codenode", "codenode", "codenode", VALA_TYPE_CCODE_EXPRESSION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_ccode_expression_binding_init (ValaCCodeExpressionBinding * self) {
	self->priv = VALA_CCODE_EXPRESSION_BINDING_GET_PRIVATE (self);
}


static void vala_ccode_expression_binding_dispose (GObject * obj) {
	ValaCCodeExpressionBinding * self;
	self = VALA_CCODE_EXPRESSION_BINDING (obj);
	(self->priv->_codenode == NULL ? NULL : (self->priv->_codenode = (g_object_unref (self->priv->_codenode), NULL)));
	G_OBJECT_CLASS (vala_ccode_expression_binding_parent_class)->dispose (obj);
}


GType vala_ccode_expression_binding_get_type (void) {
	static GType vala_ccode_expression_binding_type_id = 0;
	if (G_UNLIKELY (vala_ccode_expression_binding_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeExpressionBindingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_expression_binding_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeExpressionBinding), 0, (GInstanceInitFunc) vala_ccode_expression_binding_init };
		vala_ccode_expression_binding_type_id = g_type_register_static (VALA_TYPE_CCODE_BINDING, "ValaCCodeExpressionBinding", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	}
	return vala_ccode_expression_binding_type_id;
}




