/* valapointertype.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valapointertype.h>
#include <vala/valatypesymbol.h>
#include <vala/valacodenode.h>
#include <vala/valasemanticanalyzer.h>

struct _ValaPointerTypePrivate {
	ValaDataType* _base_type;
};
#define VALA_POINTER_TYPE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_POINTER_TYPE, ValaPointerTypePrivate))
enum  {
	VALA_POINTER_TYPE_DUMMY_PROPERTY,
	VALA_POINTER_TYPE_BASE_TYPE
};
static char* vala_pointer_type_real_to_string (ValaCodeNode* base);
static char* vala_pointer_type_real_get_cname (ValaDataType* base, gboolean var_type, gboolean const_type);
static ValaDataType* vala_pointer_type_real_copy (ValaDataType* base);
static gboolean vala_pointer_type_real_compatible (ValaDataType* base, ValaDataType* target_type, gboolean enable_non_null);
static ValaSymbol* vala_pointer_type_real_get_pointer_member (ValaDataType* base, const char* member_name);
static GeeCollection* vala_pointer_type_real_get_symbols (ValaDataType* base);
static gpointer vala_pointer_type_parent_class = NULL;
static void vala_pointer_type_dispose (GObject * obj);


ValaPointerType* vala_pointer_type_new (ValaDataType* base_type) {
	ValaPointerType * self;
	g_return_val_if_fail (base_type == NULL || VALA_IS_DATA_TYPE (base_type), NULL);
	self = g_object_newv (VALA_TYPE_POINTER_TYPE, 0, NULL);
	vala_pointer_type_set_base_type (self, base_type);
	return self;
}


static char* vala_pointer_type_real_to_string (ValaCodeNode* base) {
	ValaPointerType * self;
	char* _tmp0;
	char* _tmp1;
	self = VALA_POINTER_TYPE (base);
	_tmp0 = NULL;
	_tmp1 = NULL;
	return (_tmp1 = g_strconcat ((_tmp0 = vala_code_node_to_string (VALA_CODE_NODE (vala_pointer_type_get_base_type (self)))), "*", NULL), (_tmp0 = (g_free (_tmp0), NULL)), _tmp1);
}


static char* vala_pointer_type_real_get_cname (ValaDataType* base, gboolean var_type, gboolean const_type) {
	ValaPointerType * self;
	self = VALA_POINTER_TYPE (base);
	if (vala_data_type_get_data_type (vala_pointer_type_get_base_type (self)) != NULL && vala_typesymbol_is_reference_type (vala_data_type_get_data_type (vala_pointer_type_get_base_type (self)))) {
		return vala_data_type_get_cname (vala_pointer_type_get_base_type (self), var_type, const_type);
	} else {
		char* _tmp1;
		char* _tmp2;
		_tmp1 = NULL;
		_tmp2 = NULL;
		return (_tmp2 = g_strconcat ((_tmp1 = vala_data_type_get_cname (vala_pointer_type_get_base_type (self), var_type, const_type)), "*", NULL), (_tmp1 = (g_free (_tmp1), NULL)), _tmp2);
	}
}


static ValaDataType* vala_pointer_type_real_copy (ValaDataType* base) {
	ValaPointerType * self;
	self = VALA_POINTER_TYPE (base);
	return VALA_DATA_TYPE (vala_pointer_type_new (vala_pointer_type_get_base_type (self)));
}


static gboolean vala_pointer_type_real_compatible (ValaDataType* base, ValaDataType* target_type, gboolean enable_non_null) {
	ValaPointerType * self;
	ValaAttribute* _tmp0;
	gboolean _tmp1;
	self = VALA_POINTER_TYPE (base);
	g_return_val_if_fail (target_type == NULL || VALA_IS_DATA_TYPE (target_type), FALSE);
	_tmp0 = NULL;
	if ((_tmp1 = VALA_IS_POINTER_TYPE (target_type) || (vala_data_type_get_data_type (target_type) != NULL && (_tmp0 = vala_code_node_get_attribute (VALA_CODE_NODE (vala_data_type_get_data_type (target_type)), "PointerType")) != NULL), (_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL))), _tmp1)) {
		return TRUE;
	}
	/* temporarily ignore type parameters */
	if (vala_data_type_get_type_parameter (target_type) != NULL) {
		return TRUE;
	}
	if (vala_data_type_is_reference_type_or_type_parameter (vala_pointer_type_get_base_type (self))) {
		return vala_data_type_compatible (vala_pointer_type_get_base_type (self), target_type, enable_non_null);
	}
	return FALSE;
}


/* Object* is compatible with Object if Object is a reference type*/
static ValaSymbol* vala_pointer_type_real_get_pointer_member (ValaDataType* base, const char* member_name) {
	ValaPointerType * self;
	ValaTypesymbol* _tmp0;
	ValaSymbol* base_symbol;
	ValaSymbol* _tmp2;
	self = VALA_POINTER_TYPE (base);
	_tmp0 = NULL;
	base_symbol = VALA_SYMBOL ((_tmp0 = vala_data_type_get_data_type (vala_pointer_type_get_base_type (self)), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0))));
	if (base_symbol == NULL) {
		gpointer _tmp1;
		return (_tmp1 = NULL, (base_symbol == NULL ? NULL : (base_symbol = (g_object_unref (base_symbol), NULL))), _tmp1);
	}
	_tmp2 = NULL;
	return (_tmp2 = vala_semantic_analyzer_symbol_lookup_inherited (base_symbol, member_name), (base_symbol == NULL ? NULL : (base_symbol = (g_object_unref (base_symbol), NULL))), _tmp2);
}


static GeeCollection* vala_pointer_type_real_get_symbols (ValaDataType* base) {
	ValaPointerType * self;
	self = VALA_POINTER_TYPE (base);
	return vala_data_type_get_symbols (vala_pointer_type_get_base_type (self));
}


ValaDataType* vala_pointer_type_get_base_type (ValaPointerType* self) {
	g_return_val_if_fail (VALA_IS_POINTER_TYPE (self), NULL);
	return self->priv->_base_type;
}


void vala_pointer_type_set_base_type (ValaPointerType* self, ValaDataType* value) {
	ValaDataType* _tmp2;
	ValaDataType* _tmp1;
	g_return_if_fail (VALA_IS_POINTER_TYPE (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_base_type = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_base_type == NULL ? NULL : (self->priv->_base_type = (g_object_unref (self->priv->_base_type), NULL))), _tmp2);
}


static void vala_pointer_type_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaPointerType * self;
	self = VALA_POINTER_TYPE (object);
	switch (property_id) {
		case VALA_POINTER_TYPE_BASE_TYPE:
		g_value_set_object (value, vala_pointer_type_get_base_type (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_pointer_type_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaPointerType * self;
	self = VALA_POINTER_TYPE (object);
	switch (property_id) {
		case VALA_POINTER_TYPE_BASE_TYPE:
		vala_pointer_type_set_base_type (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_pointer_type_class_init (ValaPointerTypeClass * klass) {
	vala_pointer_type_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaPointerTypePrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_pointer_type_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_pointer_type_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_pointer_type_dispose;
	VALA_CODE_NODE_CLASS (klass)->to_string = vala_pointer_type_real_to_string;
	VALA_DATA_TYPE_CLASS (klass)->get_cname = vala_pointer_type_real_get_cname;
	VALA_DATA_TYPE_CLASS (klass)->copy = vala_pointer_type_real_copy;
	VALA_DATA_TYPE_CLASS (klass)->compatible = vala_pointer_type_real_compatible;
	VALA_DATA_TYPE_CLASS (klass)->get_pointer_member = vala_pointer_type_real_get_pointer_member;
	VALA_DATA_TYPE_CLASS (klass)->get_symbols = vala_pointer_type_real_get_symbols;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_POINTER_TYPE_BASE_TYPE, g_param_spec_object ("base-type", "base-type", "base-type", VALA_TYPE_DATA_TYPE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_pointer_type_init (ValaPointerType * self) {
	self->priv = VALA_POINTER_TYPE_GET_PRIVATE (self);
}


static void vala_pointer_type_dispose (GObject * obj) {
	ValaPointerType * self;
	self = VALA_POINTER_TYPE (obj);
	(self->priv->_base_type == NULL ? NULL : (self->priv->_base_type = (g_object_unref (self->priv->_base_type), NULL)));
	G_OBJECT_CLASS (vala_pointer_type_parent_class)->dispose (obj);
}


GType vala_pointer_type_get_type (void) {
	static GType vala_pointer_type_type_id = 0;
	if (G_UNLIKELY (vala_pointer_type_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaPointerTypeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_pointer_type_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaPointerType), 0, (GInstanceInitFunc) vala_pointer_type_init };
		vala_pointer_type_type_id = g_type_register_static (VALA_TYPE_DATA_TYPE, "ValaPointerType", &g_define_type_info, 0);
	}
	return vala_pointer_type_type_id;
}




