/* libsoup-2.4.vapi generated by lt-vapigen, do not modify. */

[CCode (cprefix = "Soup", lower_case_cprefix = "soup_")]
namespace Soup {
	[CCode (cprefix = "SOUP_ADDRESS_FAMILY_", cheader_filename = "libsoup/soup.h")]
	public enum AddressFamily {
		INVALID,
		IPV4,
		IPV6,
	}
	[CCode (cprefix = "SOUP_DATE_", cheader_filename = "libsoup/soup.h")]
	public enum DateFormat {
		HTTP,
		COOKIE,
		RFC2822,
		ISO8601_COMPACT,
		ISO8601_FULL,
		ISO8601,
		ISO8601_XMLRPC,
	}
	[CCode (cprefix = "SOUP_ENCODING_", cheader_filename = "libsoup/soup.h")]
	public enum Encoding {
		UNRECOGNIZED,
		NONE,
		CONTENT_LENGTH,
		EOF,
		CHUNKED,
		BYTERANGES,
	}
	[CCode (cprefix = "SOUP_HTTP_", cheader_filename = "libsoup/soup.h")]
	public enum HTTPVersion {
		1_0,
		1_1,
	}
	[CCode (cprefix = "SOUP_STATUS_", cheader_filename = "libsoup/soup.h")]
	public enum KnownStatusCode {
		NONE,
		CANCELLED,
		CANT_RESOLVE,
		CANT_RESOLVE_PROXY,
		CANT_CONNECT,
		CANT_CONNECT_PROXY,
		SSL_FAILED,
		IO_ERROR,
		MALFORMED,
		TRY_AGAIN,
		CONTINUE,
		SWITCHING_PROTOCOLS,
		PROCESSING,
		OK,
		CREATED,
		ACCEPTED,
		NON_AUTHORITATIVE,
		NO_CONTENT,
		RESET_CONTENT,
		PARTIAL_CONTENT,
		MULTI_STATUS,
		MULTIPLE_CHOICES,
		MOVED_PERMANENTLY,
		FOUND,
		MOVED_TEMPORARILY,
		SEE_OTHER,
		NOT_MODIFIED,
		USE_PROXY,
		NOT_APPEARING_IN_THIS_PROTOCOL,
		TEMPORARY_REDIRECT,
		BAD_REQUEST,
		UNAUTHORIZED,
		PAYMENT_REQUIRED,
		FORBIDDEN,
		NOT_FOUND,
		METHOD_NOT_ALLOWED,
		NOT_ACCEPTABLE,
		PROXY_AUTHENTICATION_REQUIRED,
		PROXY_UNAUTHORIZED,
		REQUEST_TIMEOUT,
		CONFLICT,
		GONE,
		LENGTH_REQUIRED,
		PRECONDITION_FAILED,
		REQUEST_ENTITY_TOO_LARGE,
		REQUEST_URI_TOO_LONG,
		UNSUPPORTED_MEDIA_TYPE,
		REQUESTED_RANGE_NOT_SATISFIABLE,
		INVALID_RANGE,
		EXPECTATION_FAILED,
		UNPROCESSABLE_ENTITY,
		LOCKED,
		FAILED_DEPENDENCY,
		INTERNAL_SERVER_ERROR,
		NOT_IMPLEMENTED,
		BAD_GATEWAY,
		SERVICE_UNAVAILABLE,
		GATEWAY_TIMEOUT,
		HTTP_VERSION_NOT_SUPPORTED,
		INSUFFICIENT_STORAGE,
		NOT_EXTENDED,
	}
	[CCode (cprefix = "SOUP_LOGGER_LOG_", cheader_filename = "libsoup/soup.h")]
	public enum LoggerLogLevel {
		NONE,
		MINIMAL,
		HEADERS,
		BODY,
	}
	[CCode (cprefix = "SOUP_MEMORY_", cheader_filename = "libsoup/soup.h")]
	public enum MemoryUse {
		STATIC,
		TAKE,
		COPY,
		TEMPORARY,
	}
	[CCode (cprefix = "SOUP_MESSAGE_HEADERS_", cheader_filename = "libsoup/soup.h")]
	public enum MessageHeadersType {
		REQUEST,
		RESPONSE,
	}
	[CCode (cprefix = "SOUP_SSL_ERROR_", cheader_filename = "libsoup/soup.h")]
	public enum SSLError {
		HANDSHAKE_NEEDS_READ,
		HANDSHAKE_NEEDS_WRITE,
		CERTIFICATE,
	}
	[CCode (cprefix = "SOUP_SOCKET_", cheader_filename = "libsoup/soup.h")]
	public enum SocketIOStatus {
		OK,
		WOULD_BLOCK,
		EOF,
		ERROR,
	}
	[CCode (cprefix = "SOUP_XMLRPC_ERROR_", cheader_filename = "libsoup/soup.h")]
	public enum XMLRPCError {
		ARGUMENTS,
		RETVAL,
	}
	[CCode (cprefix = "SOUP_XMLRPC_FAULT_", cheader_filename = "libsoup/soup.h")]
	public enum XMLRPCFault {
		PARSE_ERROR_NOT_WELL_FORMED,
		PARSE_ERROR_UNSUPPORTED_ENCODING,
		PARSE_ERROR_INVALID_CHARACTER_FOR_ENCODING,
		SERVER_ERROR_INVALID_XML_RPC,
		SERVER_ERROR_REQUESTED_METHOD_NOT_FOUND,
		SERVER_ERROR_INVALID_METHOD_PARAMETERS,
		SERVER_ERROR_INTERNAL_XML_RPC_ERROR,
		APPLICATION_ERROR,
		SYSTEM_ERROR,
		TRANSPORT_ERROR,
	}
	[CCode (cprefix = "SOUP_EXPECTATION_", cheader_filename = "libsoup/soup.h")]
	[Flags]
	public enum Expectation {
		UNRECOGNIZED,
		CONTINUE,
	}
	[CCode (cprefix = "SOUP_MESSAGE_", cheader_filename = "libsoup/soup.h")]
	[Flags]
	public enum MessageFlags {
		NO_REDIRECT,
		OVERWRITE_CHUNKS,
	}
	[CCode (cheader_filename = "libsoup/soup.h")]
	public class MessageHeadersIter {
		[NoArrayLength]
		public weak pointer[] dummy;
		public void init (Soup.MessageHeaders hdrs);
		public bool next (out weak string name, out weak string value);
	}
	[CCode (copy_function = "soup_buffer_copy", cheader_filename = "libsoup/soup.h")]
	public class Buffer : GLib.Boxed {
		public weak string data;
		public ulong length;
		public weak Soup.Buffer copy ();
		public pointer get_owner ();
		public Buffer (Soup.MemoryUse use, pointer data, ulong length);
		public Buffer.subbuffer (Soup.Buffer parent, ulong offset, ulong length);
		public Buffer.with_owner (pointer data, ulong length, pointer owner, GLib.DestroyNotify owner_dnotify);
	}
	[CCode (cheader_filename = "libsoup/soup.h")]
	public class ByteArray : GLib.Boxed {
	}
	[CCode (cheader_filename = "libsoup/soup.h")]
	public class ClientContext : GLib.Boxed {
		public weak Soup.Address get_address ();
		public weak Soup.AuthDomain get_auth_domain ();
		public weak string get_auth_user ();
		public weak string get_host ();
		public weak Soup.Socket get_socket ();
	}
	[CCode (copy_function = "soup_date_copy", cheader_filename = "libsoup/soup.h")]
	public class Date : GLib.Boxed {
		public int year;
		public int month;
		public int day;
		public int hour;
		public int minute;
		public int second;
		public bool utc;
		public int offset;
		public weak Soup.Date copy ();
		public Date (int year, int month, int day, int hour, int minute, int second);
		public Date.from_now (int offset_seconds);
		public Date.from_string (string date_string);
		public Date.from_time_t (ulong when);
		public weak string to_string (Soup.DateFormat format);
		public ulong to_time_t ();
	}
	[CCode (cheader_filename = "libsoup/soup.h")]
	public class MessageBody : GLib.Boxed {
		public weak string data;
		public int64 length;
		public void append (Soup.MemoryUse use, pointer data, ulong length);
		public void append_buffer (Soup.Buffer buffer);
		public void complete ();
		public weak Soup.Buffer flatten ();
		public weak Soup.Buffer get_chunk (int64 offset);
		public MessageBody ();
		public void truncate ();
	}
	[CCode (cheader_filename = "libsoup/soup.h")]
	public class MessageHeaders : GLib.Boxed {
		public void append (string name, string value);
		public void clear ();
		public void @foreach (Soup.MessageHeadersForeachFunc func);
		public weak string get (string name);
		public int64 get_content_length ();
		public Soup.Encoding get_encoding ();
		public Soup.Expectation get_expectations ();
		public MessageHeaders (Soup.MessageHeadersType type);
		public void remove (string name);
		public void replace (string name, string value);
		public void set_content_length (int64 content_length);
		public void set_encoding (Soup.Encoding encoding);
		public void set_expectations (Soup.Expectation expectations);
	}
	[CCode (copy_function = "soup_uri_copy", cheader_filename = "libsoup/soup.h")]
	public class URI : GLib.Boxed {
		public weak string scheme;
		public weak string user;
		public weak string password;
		public weak string host;
		public uint port;
		public weak string path;
		public weak string query;
		public weak string fragment;
		public weak Soup.URI copy ();
		public static weak string decode (string part);
		public static weak string encode (string part, string escape_extra);
		public bool equal (Soup.URI uri2);
		public URI (string uri_string);
		public URI.with_base (Soup.URI @base, string uri_string);
		public static weak string normalize (string part, string unescape_extra);
		public void set_fragment (string fragment);
		public void set_host (string host);
		public void set_password (string password);
		public void set_path (string path);
		public void set_port (uint port);
		public void set_query (string query);
		public void set_query_from_fields (...);
		public void set_query_from_form (GLib.HashTable form);
		public void set_scheme (string scheme);
		public void set_user (string user);
		public weak string to_string (bool just_path_and_query);
		public bool uses_default_port ();
	}
	[CCode (cheader_filename = "libsoup/soup.h")]
	public class Address : GLib.Object {
		public weak string get_name ();
		public weak string get_physical ();
		public uint get_port ();
		public pointer get_sockaddr (int len);
		public Address (string name, uint port);
		public Address.any (Soup.AddressFamily family, uint port);
		public Address.from_sockaddr (pointer sa, int len);
		public void resolve_async (GLib.MainContext async_context, GLib.Cancellable cancellable, Soup.AddressCallback callback);
		public uint resolve_sync (GLib.Cancellable cancellable);
		[NoAccessorMethod]
		public weak Soup.AddressFamily family { get; construct; }
		[NoAccessorMethod]
		public weak string name { get; construct; }
		public weak string physical { get; }
		[NoAccessorMethod]
		public weak int port { get; construct; }
		[NoAccessorMethod]
		public weak pointer sockaddr { get; construct; }
	}
	[CCode (cheader_filename = "libsoup/soup.h")]
	public class Auth : GLib.Object {
		public void free_protection_space (GLib.SList space);
		public weak string get_host ();
		public weak string get_info ();
		public weak string get_realm ();
		public weak string get_scheme_name ();
		public Auth (GLib.Type type, Soup.Message msg, string auth_header);
		public virtual void authenticate (string username, string password);
		public virtual weak string get_authorization (Soup.Message msg);
		public virtual weak GLib.SList get_protection_space (Soup.URI source_uri);
		public virtual bool update (Soup.Message msg, string auth_header);
		[NoAccessorMethod]
		public weak string host { get; construct; }
		[NoAccessorMethod]
		public weak bool is_authenticated { get; }
		[NoAccessorMethod]
		public weak bool is_for_proxy { get; construct; }
		[NoAccessorMethod]
		public weak string realm { get; construct; }
		public weak string scheme_name { get; }
	}
	[CCode (cheader_filename = "libsoup/soup.h")]
	public class AuthDomain : GLib.Object {
		public void add_path (string path);
		public bool covers (Soup.Message msg);
		public weak string get_realm ();
		public void remove_path (string path);
		public void set_filter (Soup.AuthDomainFilter filter, pointer filter_data, GLib.DestroyNotify dnotify);
		public void set_generic_auth_callback (Soup.AuthDomainGenericAuthCallback auth_callback, pointer auth_data, GLib.DestroyNotify dnotify);
		public bool try_generic_auth_callback (Soup.Message msg, string username);
		public virtual weak string accepts (Soup.Message msg);
		public virtual weak string challenge (Soup.Message msg);
		public virtual bool check_password (Soup.Message msg, string username, string password);
		[NoAccessorMethod]
		public weak pointer filter { get; set; }
		[NoAccessorMethod]
		public weak pointer filter_data { get; set; }
		[NoAccessorMethod]
		public weak pointer generic_auth_callback { get; set; }
		[NoAccessorMethod]
		public weak pointer generic_auth_data { get; set; }
		[NoAccessorMethod]
		public weak bool proxy { get; construct; }
		[NoAccessorMethod]
		public weak string realm { get; construct; }
	}
	[CCode (cheader_filename = "libsoup/soup.h")]
	public class AuthDomainBasic : Soup.AuthDomain {
		public AuthDomainBasic (string optname1);
		public static void set_auth_callback (Soup.AuthDomain domain, Soup.AuthDomainBasicAuthCallback callback, GLib.DestroyNotify dnotify);
		[NoAccessorMethod]
		public weak pointer auth_callback { get; set; }
		[NoAccessorMethod]
		public weak pointer auth_data { get; set; }
	}
	[CCode (cheader_filename = "libsoup/soup.h")]
	public class AuthDomainDigest : Soup.AuthDomain {
		public static weak string encode_password (string username, string realm, string password);
		public AuthDomainDigest (string optname1);
		public static void set_auth_callback (Soup.AuthDomain domain, Soup.AuthDomainDigestAuthCallback callback, GLib.DestroyNotify dnotify);
		[NoAccessorMethod]
		public weak pointer auth_callback { get; set; }
		[NoAccessorMethod]
		public weak pointer auth_data { get; set; }
	}
	[CCode (cheader_filename = "libsoup/soup.h")]
	public class Logger : GLib.Object {
		public void attach (Soup.Session session);
		public void detach (Soup.Session session);
		public Logger (Soup.LoggerLogLevel level, int max_body_size);
		public void set_printer (Soup.LoggerPrinter printer, pointer printer_data, GLib.DestroyNotify destroy);
		public void set_request_filter (Soup.LoggerFilter request_filter, pointer filter_data, GLib.DestroyNotify destroy);
		public void set_response_filter (Soup.LoggerFilter response_filter, pointer filter_data, GLib.DestroyNotify destroy);
	}
	[CCode (cheader_filename = "libsoup/soup.h")]
	public class Message : GLib.Object {
		public weak Soup.MessageBody request_body;
		public weak Soup.MessageHeaders request_headers;
		public weak Soup.MessageBody response_body;
		public weak Soup.MessageHeaders response_headers;
		public uint add_header_handler (string @signal, string header, GLib.Callback callback);
		public uint add_status_code_handler (string @signal, uint status_code, GLib.Callback callback);
		public Soup.MessageFlags get_flags ();
		public Soup.HTTPVersion get_http_version ();
		public weak Soup.URI get_uri ();
		public bool is_keepalive ();
		public Message (string method, string uri_string);
		public Message.from_uri (string method, Soup.URI uri);
		public void set_chunk_allocator (Soup.ChunkAllocator allocator, GLib.DestroyNotify destroy_notify);
		public void set_flags (Soup.MessageFlags flags);
		public void set_http_version (Soup.HTTPVersion version);
		public void set_request (string content_type, Soup.MemoryUse req_use, string req_body, ulong req_length);
		public void set_response (string content_type, Soup.MemoryUse resp_use, string resp_body, ulong resp_length);
		public void set_status (uint status_code);
		public void set_status_full (uint status_code, string reason_phrase);
		public void set_uri (Soup.URI uri);
		public weak Soup.MessageFlags flags { get; set; }
		public weak Soup.HTTPVersion http_version { get; set; }
		[NoAccessorMethod]
		public weak string method { get; set; }
		[NoAccessorMethod]
		public weak string reason_phrase { get; set; }
		[NoAccessorMethod]
		public weak uint status_code { get; set; }
		public weak Soup.URI uri { get; set; }
		[HasEmitter]
		public signal void finished ();
		[HasEmitter]
		public signal void got_body ();
		[HasEmitter]
		public signal void got_chunk (Soup.Buffer chunk);
		[HasEmitter]
		public signal void got_headers ();
		[HasEmitter]
		public signal void got_informational ();
		[HasEmitter]
		public signal void restarted ();
		[HasEmitter]
		public signal void wrote_body ();
		[HasEmitter]
		public signal void wrote_chunk ();
		[HasEmitter]
		public signal void wrote_headers ();
		[HasEmitter]
		public signal void wrote_informational ();
	}
	[CCode (cheader_filename = "libsoup/soup.h")]
	public class Server : GLib.Object {
		public void add_auth_domain (Soup.AuthDomain auth_domain);
		public void add_handler (string path, Soup.ServerCallback callback, GLib.DestroyNotify destroy);
		public weak GLib.MainContext get_async_context ();
		public weak Soup.Socket get_listener ();
		public uint get_port ();
		public bool is_https ();
		public Server (string optname1, ...);
		public void pause_message (Soup.Message msg);
		public void quit ();
		public void remove_auth_domain (Soup.AuthDomain auth_domain);
		public void remove_handler (string path);
		public void run ();
		public void run_async ();
		public void unpause_message (Soup.Message msg);
		[NoAccessorMethod]
		public weak pointer async_context { get; construct; }
		[NoAccessorMethod]
		public weak Soup.Address @interface { get; construct; }
		[NoAccessorMethod]
		public weak uint port { get; construct; }
		[NoAccessorMethod]
		public weak bool raw_paths { get; construct; }
		[NoAccessorMethod]
		public weak string server_header { get; set construct; }
		[NoAccessorMethod]
		public weak string ssl_cert_file { get; construct; }
		[NoAccessorMethod]
		public weak string ssl_key_file { get; construct; }
		public signal void request_aborted (Soup.Message msg, Soup.ClientContext client);
		public signal void request_finished (Soup.Message msg, Soup.ClientContext client);
		public signal void request_read (Soup.Message msg, Soup.ClientContext client);
		public signal void request_started (Soup.Message msg, Soup.ClientContext client);
	}
	[CCode (cheader_filename = "libsoup/soup.h")]
	public class Session : GLib.Object {
		public void abort ();
		public weak GLib.MainContext get_async_context ();
		public void pause_message (Soup.Message msg);
		public void unpause_message (Soup.Message msg);
		public virtual void cancel_message (Soup.Message msg, uint status_code);
		public virtual void queue_message (Soup.Message# msg, Soup.SessionCallback callback);
		public virtual void requeue_message (Soup.Message msg);
		public virtual uint send_message (Soup.Message msg);
		[NoAccessorMethod]
		public weak pointer async_context { get; construct; }
		[NoAccessorMethod]
		public weak int max_conns { get; set; }
		[NoAccessorMethod]
		public weak int max_conns_per_host { get; set; }
		[NoAccessorMethod]
		public weak Soup.URI proxy_uri { get; set; }
		[NoAccessorMethod]
		public weak string ssl_ca_file { get; set; }
		[NoAccessorMethod]
		public weak uint timeout { get; set; }
		[NoAccessorMethod]
		public weak bool use_ntlm { get; set; }
		[NoAccessorMethod]
		public weak string user_agent { get; set; }
		public signal void authenticate (Soup.Message msg, Soup.Auth auth, bool retrying);
		public signal void request_started (Soup.Message msg, Soup.Socket socket);
	}
	[CCode (cheader_filename = "libsoup/soup.h")]
	public class SessionAsync : Soup.Session {
		public SessionAsync ();
		public SessionAsync.with_options (string optname1);
	}
	[CCode (cheader_filename = "libsoup/soup.h")]
	public class SessionSync : Soup.Session {
		public SessionSync ();
		public SessionSync.with_options (string optname1);
	}
	[CCode (cheader_filename = "libsoup/soup.h")]
	public class Socket : GLib.Object {
		public void connect_async (GLib.Cancellable cancellable, Soup.SocketCallback callback);
		public uint connect_sync (GLib.Cancellable cancellable);
		public void disconnect ();
		public weak Soup.Address get_local_address ();
		public weak Soup.Address get_remote_address ();
		public bool is_connected ();
		public bool is_ssl ();
		public bool listen ();
		public Socket (string optname1);
		public Soup.SocketIOStatus read (pointer buffer, ulong len, ulong nread, GLib.Cancellable cancellable) throws GLib.Error;
		public Soup.SocketIOStatus read_until (pointer buffer, ulong len, pointer boundary, ulong boundary_len, ulong nread, bool got_boundary, GLib.Cancellable cancellable) throws GLib.Error;
		public bool start_proxy_ssl (string ssl_host, GLib.Cancellable cancellable);
		public bool start_ssl (GLib.Cancellable cancellable);
		public Soup.SocketIOStatus write (pointer buffer, ulong len, ulong nwrote, GLib.Cancellable cancellable) throws GLib.Error;
		[NoAccessorMethod]
		public weak pointer async_context { get; construct; }
		[NoAccessorMethod]
		public weak bool is_server { get; }
		[NoAccessorMethod]
		public weak Soup.Address local_address { get; construct; }
		[NoAccessorMethod]
		public weak bool non_blocking { get; set; }
		[NoAccessorMethod]
		public weak Soup.Address remote_address { get; construct; }
		[NoAccessorMethod]
		public weak pointer ssl_creds { get; set; }
		[NoAccessorMethod]
		public weak uint timeout { get; set; }
		public signal void disconnected ();
		public signal void new_connection (Soup.Socket p0);
		public signal void readable ();
		public signal void writable ();
	}
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static delegate void AddressCallback (Soup.Address addr, uint status, pointer data);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public delegate bool AuthDomainBasicAuthCallback (Soup.AuthDomain domain, Soup.Message msg, string username, string password);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public delegate weak string AuthDomainDigestAuthCallback (Soup.AuthDomain domain, Soup.Message msg, string username);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public delegate bool AuthDomainFilter (Soup.AuthDomain domain, Soup.Message msg);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public delegate bool AuthDomainGenericAuthCallback (Soup.AuthDomain domain, Soup.Message msg, string username);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public delegate weak Soup.Buffer ChunkAllocator (Soup.Message msg, ulong max_len);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public delegate Soup.LoggerLogLevel LoggerFilter (Soup.Logger logger, Soup.Message msg);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public delegate void LoggerPrinter (Soup.Logger logger, Soup.LoggerLogLevel level, string direction, string data);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public delegate void MessageHeadersForeachFunc (string name, string value);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public delegate void ServerCallback (Soup.Server server, Soup.Message msg, string path, GLib.HashTable query, Soup.ClientContext client);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public delegate void SessionCallback (Soup.Session session, Soup.Message msg);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public delegate void SocketCallback (Soup.Socket sock, uint status);
	public const int AF_INET6;
	public const int ADDRESS_ANY_PORT;
	public const string ADDRESS_FAMILY;
	public const string ADDRESS_NAME;
	public const string ADDRESS_PHYSICAL;
	public const string ADDRESS_PORT;
	public const string ADDRESS_SOCKADDR;
	public const string AUTH_DOMAIN_ADD_PATH;
	public const string AUTH_DOMAIN_BASIC_AUTH_CALLBACK;
	public const string AUTH_DOMAIN_BASIC_AUTH_DATA;
	public const int AUTH_DOMAIN_BASIC_H;
	public const string AUTH_DOMAIN_DIGEST_AUTH_CALLBACK;
	public const string AUTH_DOMAIN_DIGEST_AUTH_DATA;
	public const int AUTH_DOMAIN_DIGEST_H;
	public const string AUTH_DOMAIN_FILTER;
	public const string AUTH_DOMAIN_FILTER_DATA;
	public const string AUTH_DOMAIN_GENERIC_AUTH_CALLBACK;
	public const string AUTH_DOMAIN_GENERIC_AUTH_DATA;
	public const int AUTH_DOMAIN_H;
	public const string AUTH_DOMAIN_PROXY;
	public const string AUTH_DOMAIN_REALM;
	public const string AUTH_DOMAIN_REMOVE_PATH;
	public const int AUTH_H;
	public const string AUTH_HOST;
	public const string AUTH_IS_AUTHENTICATED;
	public const string AUTH_IS_FOR_PROXY;
	public const string AUTH_REALM;
	public const string AUTH_SCHEME_NAME;
	public const int DATE_H;
	public const int FORM_H;
	public const int H;
	public const int HEADERS_H;
	public const int LOGGER_H;
	public const int MESSAGE_BODY_H;
	public const string MESSAGE_FLAGS;
	public const int MESSAGE_H;
	public const int MESSAGE_HEADERS_H;
	public const string MESSAGE_HTTP_VERSION;
	public const string MESSAGE_METHOD;
	public const string MESSAGE_REASON_PHRASE;
	public const string MESSAGE_STATUS_CODE;
	public const string MESSAGE_URI;
	public const int METHOD_H;
	public const int MISC_H;
	public const string SERVER_ASYNC_CONTEXT;
	public const int SERVER_H;
	public const string SERVER_INTERFACE;
	public const string SERVER_PORT;
	public const string SERVER_RAW_PATHS;
	public const string SERVER_SERVER_HEADER;
	public const string SERVER_SSL_CERT_FILE;
	public const string SERVER_SSL_KEY_FILE;
	public const string SESSION_ASYNC_CONTEXT;
	public const int SESSION_ASYNC_H;
	public const int SESSION_H;
	public const string SESSION_MAX_CONNS;
	public const string SESSION_MAX_CONNS_PER_HOST;
	public const string SESSION_PROXY_URI;
	public const string SESSION_SSL_CA_FILE;
	public const int SESSION_SYNC_H;
	public const string SESSION_TIMEOUT;
	public const string SESSION_USER_AGENT;
	public const string SESSION_USE_NTLM;
	public const string SOCKET_ASYNC_CONTEXT;
	public const string SOCKET_FLAG_NONBLOCKING;
	public const int SOCKET_H;
	public const string SOCKET_IS_SERVER;
	public const string SOCKET_LOCAL_ADDRESS;
	public const string SOCKET_REMOTE_ADDRESS;
	public const string SOCKET_SSL_CREDENTIALS;
	public const string SOCKET_TIMEOUT;
	public const int STATUS_H;
	public const int TYPES_H;
	public const int URI_H;
	public const int VALUE_UTILS_H;
	public const int XMLRPC_H;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static weak GLib.Source add_idle (GLib.MainContext async_context, GLib.SourceFunc function, pointer data);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static weak GLib.Source add_timeout (GLib.MainContext async_context, uint interval, GLib.SourceFunc function, pointer data);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static weak GLib.HashTable form_decode (string encoded_form);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static weak string form_encode (...);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static weak string form_encode_datalist (out weak GLib.Data form_data_set);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static weak string form_encode_hash (GLib.HashTable form_data_set);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static weak string form_encode_valist (string first_field, pointer args);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static weak Soup.Message form_request_new (string method, string uri, ...);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static weak Soup.Message form_request_new_from_datalist (string method, string uri, out weak GLib.Data form_data_set);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static weak Soup.Message form_request_new_from_hash (string method, string uri, GLib.HashTable form_data_set);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static bool header_contains (string header, string token);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static void header_free_list (GLib.SList list);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static void header_free_param_list (GLib.HashTable param_list);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static weak GLib.SList header_parse_list (string header);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static weak GLib.HashTable header_parse_param_list (string header);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static weak GLib.SList header_parse_quality_list (string header, GLib.SList unacceptable);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static uint headers_parse_request (string str, int len, Soup.MessageHeaders req_headers, out weak string req_method, out weak string req_path, Soup.HTTPVersion ver);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static bool headers_parse_response (string str, int len, Soup.MessageHeaders headers, Soup.HTTPVersion ver, uint status_code, out weak string reason_phrase);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static bool headers_parse_status_line (string status_line, Soup.HTTPVersion ver, uint status_code, out weak string reason_phrase);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static GLib.Quark http_error_quark ();
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static GLib.Quark ssl_error_quark ();
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static weak string status_get_phrase (uint status_code);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static bool str_case_equal (pointer v1, pointer v2);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static uint str_case_hash (pointer key);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static void value_array_append (GLib.ValueArray array, GLib.Type type);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static void value_array_append_vals (GLib.ValueArray array, ...);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static GLib.ValueArray value_array_from_args (pointer args);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static bool value_array_get_nth (GLib.ValueArray array, uint index_, GLib.Type type);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static void value_array_insert (GLib.ValueArray array, uint index_, GLib.Type type);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static GLib.ValueArray value_array_new ();
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static GLib.ValueArray value_array_new_with_vals (...);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static bool value_array_to_args (GLib.ValueArray array, pointer args);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static void value_hash_insert (GLib.HashTable hash, string key, GLib.Type type);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static void value_hash_insert_vals (GLib.HashTable hash, ...);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static void value_hash_insert_value (GLib.HashTable hash, string key, GLib.Value value);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static bool value_hash_lookup (GLib.HashTable hash, string key, GLib.Type type);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static bool value_hash_lookup_vals (GLib.HashTable hash, ...);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static weak GLib.HashTable value_hash_new ();
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static weak GLib.HashTable value_hash_new_with_vals (...);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static weak string xmlrpc_build_fault (int fault_code, string fault_format);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static weak string xmlrpc_build_method_call (string method_name, GLib.Value[] params);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static weak string xmlrpc_build_method_response (GLib.Value value);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static GLib.Quark xmlrpc_error_quark ();
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static bool xmlrpc_extract_method_call (string method_call, int length, out weak string method_name);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static bool xmlrpc_extract_method_response (string method_response, int length, GLib.Type type) throws GLib.Error;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static GLib.Quark xmlrpc_fault_quark ();
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static bool xmlrpc_parse_method_call (string method_call, int length, out weak string method_name, out GLib.ValueArray params);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static bool xmlrpc_parse_method_response (string method_response, int length, GLib.Value value) throws GLib.Error;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static weak Soup.Message xmlrpc_request_new (string uri, string method_name);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static void xmlrpc_set_fault (Soup.Message msg, int fault_code, string fault_format);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static void xmlrpc_set_response (Soup.Message msg, GLib.Type type);
}
