/* valaccodefragment.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <ccode/valaccodefragment.h>
#include <gee/arraylist.h>
#include <gee/list.h>
#include <gee/readonlycollection.h>

struct _ValaCCodeFragmentPrivate {
	GeeList* children;
};
#define VALA_CCODE_FRAGMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_FRAGMENT, ValaCCodeFragmentPrivate))
enum  {
	VALA_CCODE_FRAGMENT_DUMMY_PROPERTY
};
static void vala_ccode_fragment_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static void vala_ccode_fragment_real_write_declaration (ValaCCodeNode* base, ValaCCodeWriter* writer);
static void vala_ccode_fragment_real_write_combined (ValaCCodeNode* base, ValaCCodeWriter* writer);
static gpointer vala_ccode_fragment_parent_class = NULL;
static void vala_ccode_fragment_dispose (GObject * obj);


/**
 * Appends the specified code node to this code fragment.
 *
 * @param node a C code node
 */
void vala_ccode_fragment_append (ValaCCodeFragment* self, ValaCCodeNode* node) {
	g_return_if_fail (VALA_IS_CCODE_FRAGMENT (self));
	g_return_if_fail (node == NULL || VALA_IS_CCODE_NODE (node));
	gee_collection_add (GEE_COLLECTION (self->priv->children), node);
}


/**
 * Returns a copy of the list of children.
 *
 * @return children list
 */
GeeCollection* vala_ccode_fragment_get_children (ValaCCodeFragment* self) {
	g_return_val_if_fail (VALA_IS_CCODE_FRAGMENT (self), NULL);
	return GEE_COLLECTION (gee_read_only_collection_new (VALA_TYPE_CCODE_NODE, ((GBoxedCopyFunc) g_object_ref), g_object_unref, GEE_COLLECTION (self->priv->children)));
}


static void vala_ccode_fragment_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer) {
	ValaCCodeFragment * self;
	self = VALA_CCODE_FRAGMENT (base);
	g_return_if_fail (writer == NULL || VALA_IS_CCODE_WRITER (writer));
	{
		GeeList* node_collection;
		GeeIterator* node_it;
		node_collection = self->priv->children;
		node_it = gee_iterable_iterator (GEE_ITERABLE (node_collection));
		while (gee_iterator_next (node_it)) {
			ValaCCodeNode* node;
			node = ((ValaCCodeNode*) gee_iterator_get (node_it));
			{
				vala_ccode_node_write (node, writer);
				(node == NULL ? NULL : (node = (g_object_unref (node), NULL)));
			}
		}
		(node_it == NULL ? NULL : (node_it = (g_object_unref (node_it), NULL)));
	}
}


static void vala_ccode_fragment_real_write_declaration (ValaCCodeNode* base, ValaCCodeWriter* writer) {
	ValaCCodeFragment * self;
	self = VALA_CCODE_FRAGMENT (base);
	g_return_if_fail (writer == NULL || VALA_IS_CCODE_WRITER (writer));
	{
		GeeList* node_collection;
		GeeIterator* node_it;
		node_collection = self->priv->children;
		node_it = gee_iterable_iterator (GEE_ITERABLE (node_collection));
		while (gee_iterator_next (node_it)) {
			ValaCCodeNode* node;
			node = ((ValaCCodeNode*) gee_iterator_get (node_it));
			{
				vala_ccode_node_write_declaration (node, writer);
				(node == NULL ? NULL : (node = (g_object_unref (node), NULL)));
			}
		}
		(node_it == NULL ? NULL : (node_it = (g_object_unref (node_it), NULL)));
	}
}


static void vala_ccode_fragment_real_write_combined (ValaCCodeNode* base, ValaCCodeWriter* writer) {
	ValaCCodeFragment * self;
	self = VALA_CCODE_FRAGMENT (base);
	g_return_if_fail (writer == NULL || VALA_IS_CCODE_WRITER (writer));
	{
		GeeList* node_collection;
		GeeIterator* node_it;
		node_collection = self->priv->children;
		node_it = gee_iterable_iterator (GEE_ITERABLE (node_collection));
		while (gee_iterator_next (node_it)) {
			ValaCCodeNode* node;
			node = ((ValaCCodeNode*) gee_iterator_get (node_it));
			{
				vala_ccode_node_write_combined (node, writer);
				(node == NULL ? NULL : (node = (g_object_unref (node), NULL)));
			}
		}
		(node_it == NULL ? NULL : (node_it = (g_object_unref (node_it), NULL)));
	}
}


/**
 * Represents a container for C code nodes.
 */
ValaCCodeFragment* vala_ccode_fragment_new (void) {
	ValaCCodeFragment * self;
	self = g_object_newv (VALA_TYPE_CCODE_FRAGMENT, 0, NULL);
	return self;
}


static void vala_ccode_fragment_class_init (ValaCCodeFragmentClass * klass) {
	vala_ccode_fragment_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCCodeFragmentPrivate));
	G_OBJECT_CLASS (klass)->dispose = vala_ccode_fragment_dispose;
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_fragment_real_write;
	VALA_CCODE_NODE_CLASS (klass)->write_declaration = vala_ccode_fragment_real_write_declaration;
	VALA_CCODE_NODE_CLASS (klass)->write_combined = vala_ccode_fragment_real_write_combined;
}


static void vala_ccode_fragment_init (ValaCCodeFragment * self) {
	self->priv = VALA_CCODE_FRAGMENT_GET_PRIVATE (self);
	self->priv->children = GEE_LIST (gee_array_list_new (VALA_TYPE_CCODE_NODE, ((GBoxedCopyFunc) g_object_ref), g_object_unref, g_direct_equal));
}


static void vala_ccode_fragment_dispose (GObject * obj) {
	ValaCCodeFragment * self;
	self = VALA_CCODE_FRAGMENT (obj);
	(self->priv->children == NULL ? NULL : (self->priv->children = (g_object_unref (self->priv->children), NULL)));
	G_OBJECT_CLASS (vala_ccode_fragment_parent_class)->dispose (obj);
}


GType vala_ccode_fragment_get_type (void) {
	static GType vala_ccode_fragment_type_id = 0;
	if (G_UNLIKELY (vala_ccode_fragment_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeFragmentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_fragment_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeFragment), 0, (GInstanceInitFunc) vala_ccode_fragment_init };
		vala_ccode_fragment_type_id = g_type_register_static (VALA_TYPE_CCODE_NODE, "ValaCCodeFragment", &g_define_type_info, 0);
	}
	return vala_ccode_fragment_type_id;
}




