/* valaarraytype.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valaarraytype.h>
#include <vala/valacodenode.h>
#include <vala/valatypesymbol.h>
#include <vala/valatypeparameter.h>

struct _ValaArrayTypePrivate {
	ValaDataType* _element_type;
	gint _rank;
};
#define VALA_ARRAY_TYPE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_ARRAY_TYPE, ValaArrayTypePrivate))
enum  {
	VALA_ARRAY_TYPE_DUMMY_PROPERTY,
	VALA_ARRAY_TYPE_ELEMENT_TYPE,
	VALA_ARRAY_TYPE_RANK
};
static ValaDataType* vala_array_type_real_copy (ValaDataType* base);
static gboolean vala_array_type_real_is_array (ValaDataType* base);
static GObject * vala_array_type_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer vala_array_type_parent_class = NULL;
static void vala_array_type_dispose (GObject * obj);


ValaArrayType* vala_array_type_new (ValaDataType* element_type, gint rank) {
	GParameter * __params;
	GParameter * __params_it;
	ValaArrayType * self;
	g_return_val_if_fail (element_type == NULL || VALA_IS_DATA_TYPE (element_type), NULL);
	__params = g_new0 (GParameter, 2);
	__params_it = __params;
	__params_it->name = "element-type";
	g_value_init (&__params_it->value, VALA_TYPE_DATA_TYPE);
	g_value_set_object (&__params_it->value, element_type);
	__params_it++;
	__params_it->name = "rank";
	g_value_init (&__params_it->value, G_TYPE_INT);
	g_value_set_int (&__params_it->value, rank);
	__params_it++;
	self = g_object_newv (VALA_TYPE_ARRAY_TYPE, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


static ValaDataType* vala_array_type_real_copy (ValaDataType* base) {
	ValaArrayType * self;
	ValaArrayType* result;
	self = VALA_ARRAY_TYPE (base);
	result = vala_array_type_new (vala_array_type_get_element_type (self), vala_array_type_get_rank (self));
	vala_code_node_set_source_reference (VALA_CODE_NODE (result), vala_code_node_get_source_reference (VALA_CODE_NODE (self)));
	vala_data_type_set_transfers_ownership (VALA_DATA_TYPE (result), vala_data_type_get_transfers_ownership (VALA_DATA_TYPE (self)));
	vala_data_type_set_takes_ownership (VALA_DATA_TYPE (result), vala_data_type_get_takes_ownership (VALA_DATA_TYPE (self)));
	vala_data_type_set_is_out (VALA_DATA_TYPE (result), vala_data_type_get_is_out (VALA_DATA_TYPE (self)));
	vala_data_type_set_nullable (VALA_DATA_TYPE (result), vala_data_type_get_nullable (VALA_DATA_TYPE (self)));
	vala_data_type_set_requires_null_check (VALA_DATA_TYPE (result), vala_data_type_get_requires_null_check (VALA_DATA_TYPE (self)));
	vala_data_type_set_floating_reference (VALA_DATA_TYPE (result), vala_data_type_get_floating_reference (VALA_DATA_TYPE (self)));
	vala_data_type_set_is_ref (VALA_DATA_TYPE (result), vala_data_type_get_is_ref (VALA_DATA_TYPE (self)));
	{
		GeeList* arg_collection;
		GeeIterator* arg_it;
		arg_collection = vala_data_type_get_type_arguments (VALA_DATA_TYPE (self));
		arg_it = gee_iterable_iterator (GEE_ITERABLE (arg_collection));
		while (gee_iterator_next (arg_it)) {
			ValaDataType* arg;
			arg = ((ValaDataType*) gee_iterator_get (arg_it));
			{
				ValaDataType* _tmp0;
				_tmp0 = NULL;
				vala_data_type_add_type_argument (VALA_DATA_TYPE (result), (_tmp0 = vala_data_type_copy (arg)));
				(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
				(arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL)));
			}
		}
		(arg_collection == NULL ? NULL : (arg_collection = (g_object_unref (arg_collection), NULL)));
		(arg_it == NULL ? NULL : (arg_it = (g_object_unref (arg_it), NULL)));
	}
	return VALA_DATA_TYPE (result);
}


static gboolean vala_array_type_real_is_array (ValaDataType* base) {
	ValaArrayType * self;
	self = VALA_ARRAY_TYPE (base);
	return TRUE;
}


ValaDataType* vala_array_type_get_element_type (ValaArrayType* self) {
	g_return_val_if_fail (VALA_IS_ARRAY_TYPE (self), NULL);
	return self->priv->_element_type;
}


void vala_array_type_set_element_type (ValaArrayType* self, ValaDataType* value) {
	g_return_if_fail (VALA_IS_ARRAY_TYPE (self));
	self->priv->_element_type = value;
}


gint vala_array_type_get_rank (ValaArrayType* self) {
	g_return_val_if_fail (VALA_IS_ARRAY_TYPE (self), 0);
	return self->priv->_rank;
}


void vala_array_type_set_rank (ValaArrayType* self, gint value) {
	g_return_if_fail (VALA_IS_ARRAY_TYPE (self));
	self->priv->_rank = value;
}


static GObject * vala_array_type_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	ValaArrayTypeClass * klass;
	GObjectClass * parent_class;
	ValaArrayType * self;
	klass = VALA_ARRAY_TYPE_CLASS (g_type_class_peek (VALA_TYPE_ARRAY_TYPE));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = VALA_ARRAY_TYPE (obj);
	{
		if (vala_data_type_get_data_type (vala_array_type_get_element_type (self)) != NULL) {
			ValaArray* _tmp0;
			_tmp0 = NULL;
			vala_data_type_set_data_type (VALA_DATA_TYPE (self), VALA_TYPESYMBOL ((_tmp0 = vala_typesymbol_get_array (vala_data_type_get_data_type (vala_array_type_get_element_type (self)), vala_array_type_get_rank (self)))));
			(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
		} else {
			ValaArray* _tmp1;
			_tmp1 = NULL;
			vala_data_type_set_data_type (VALA_DATA_TYPE (self), VALA_TYPESYMBOL ((_tmp1 = vala_typeparameter_get_array (vala_data_type_get_type_parameter (vala_array_type_get_element_type (self)), vala_array_type_get_rank (self)))));
			(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
		}
	}
	return obj;
}


static void vala_array_type_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaArrayType * self;
	self = VALA_ARRAY_TYPE (object);
	switch (property_id) {
		case VALA_ARRAY_TYPE_ELEMENT_TYPE:
		g_value_set_object (value, vala_array_type_get_element_type (self));
		break;
		case VALA_ARRAY_TYPE_RANK:
		g_value_set_int (value, vala_array_type_get_rank (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_array_type_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaArrayType * self;
	self = VALA_ARRAY_TYPE (object);
	switch (property_id) {
		case VALA_ARRAY_TYPE_ELEMENT_TYPE:
		vala_array_type_set_element_type (self, g_value_get_object (value));
		break;
		case VALA_ARRAY_TYPE_RANK:
		vala_array_type_set_rank (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_array_type_class_init (ValaArrayTypeClass * klass) {
	vala_array_type_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaArrayTypePrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_array_type_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_array_type_set_property;
	G_OBJECT_CLASS (klass)->constructor = vala_array_type_constructor;
	G_OBJECT_CLASS (klass)->dispose = vala_array_type_dispose;
	VALA_DATA_TYPE_CLASS (klass)->copy = vala_array_type_real_copy;
	VALA_DATA_TYPE_CLASS (klass)->is_array = vala_array_type_real_is_array;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_ARRAY_TYPE_ELEMENT_TYPE, g_param_spec_object ("element-type", "element-type", "element-type", VALA_TYPE_DATA_TYPE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_ARRAY_TYPE_RANK, g_param_spec_int ("rank", "rank", "rank", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void vala_array_type_init (ValaArrayType * self) {
	self->priv = VALA_ARRAY_TYPE_GET_PRIVATE (self);
}


static void vala_array_type_dispose (GObject * obj) {
	ValaArrayType * self;
	self = VALA_ARRAY_TYPE (obj);
	G_OBJECT_CLASS (vala_array_type_parent_class)->dispose (obj);
}


GType vala_array_type_get_type (void) {
	static GType vala_array_type_type_id = 0;
	if (G_UNLIKELY (vala_array_type_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaArrayTypeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_array_type_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaArrayType), 0, (GInstanceInitFunc) vala_array_type_init };
		vala_array_type_type_id = g_type_register_static (VALA_TYPE_REFERENCE_TYPE, "ValaArrayType", &g_define_type_info, 0);
	}
	return vala_array_type_type_id;
}




