/* valaclasstype.vala
 *
 * Copyright (C) 2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALA_VALACLASSTYPE_H__
#define __VALA_VALACLASSTYPE_H__

#include <glib.h>
#include <glib-object.h>
#include <vala/valareferencetype.h>
#include <vala/valaclass.h>

G_BEGIN_DECLS


#define VALA_TYPE_CLASS_TYPE (vala_class_type_get_type ())
#define VALA_CLASS_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CLASS_TYPE, ValaClassType))
#define VALA_CLASS_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CLASS_TYPE, ValaClassTypeClass))
#define VALA_IS_CLASS_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CLASS_TYPE))
#define VALA_IS_CLASS_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CLASS_TYPE))
#define VALA_CLASS_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CLASS_TYPE, ValaClassTypeClass))

typedef struct _ValaClassType ValaClassType;
typedef struct _ValaClassTypeClass ValaClassTypeClass;
typedef struct _ValaClassTypePrivate ValaClassTypePrivate;

/**
 * A class type.
 */
struct _ValaClassType {
	ValaReferenceType parent_instance;
	ValaClassTypePrivate * priv;
};
struct _ValaClassTypeClass {
	ValaReferenceTypeClass parent_class;
};

ValaClassType* vala_class_type_new (ValaClass* class_symbol);
ValaClass* vala_class_type_get_class_symbol (ValaClassType* self);
void vala_class_type_set_class_symbol (ValaClassType* self, ValaClass* value);
GType vala_class_type_get_type (void);

G_END_DECLS

#endif
