/* valaccodearraymodule.c generated by valac, the Vala compiler
 * generated from valaccodearraymodule.vala, do not modify */

/* valaccodearraymodule.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <valaccode.h>
#include <valagee.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>


#define VALA_TYPE_CCODE_BASE_MODULE (vala_ccode_base_module_get_type ())
#define VALA_CCODE_BASE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModule))
#define VALA_CCODE_BASE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModuleClass))
#define VALA_IS_CCODE_BASE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_BASE_MODULE))
#define VALA_IS_CCODE_BASE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_BASE_MODULE))
#define VALA_CCODE_BASE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModuleClass))

typedef struct _ValaCCodeBaseModule ValaCCodeBaseModule;
typedef struct _ValaCCodeBaseModuleClass ValaCCodeBaseModuleClass;
typedef struct _ValaCCodeBaseModulePrivate ValaCCodeBaseModulePrivate;

#define VALA_CCODE_BASE_MODULE_TYPE_EMIT_CONTEXT (vala_ccode_base_module_emit_context_get_type ())
#define VALA_CCODE_BASE_MODULE_EMIT_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_CCODE_BASE_MODULE_TYPE_EMIT_CONTEXT, ValaCCodeBaseModuleEmitContext))
#define VALA_CCODE_BASE_MODULE_EMIT_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_CCODE_BASE_MODULE_TYPE_EMIT_CONTEXT, ValaCCodeBaseModuleEmitContextClass))
#define VALA_CCODE_BASE_MODULE_IS_EMIT_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_CCODE_BASE_MODULE_TYPE_EMIT_CONTEXT))
#define VALA_CCODE_BASE_MODULE_IS_EMIT_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_CCODE_BASE_MODULE_TYPE_EMIT_CONTEXT))
#define VALA_CCODE_BASE_MODULE_EMIT_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_CCODE_BASE_MODULE_TYPE_EMIT_CONTEXT, ValaCCodeBaseModuleEmitContextClass))

typedef struct _ValaCCodeBaseModuleEmitContext ValaCCodeBaseModuleEmitContext;
typedef struct _ValaCCodeBaseModuleEmitContextClass ValaCCodeBaseModuleEmitContextClass;

#define VALA_TYPE_CCODE_STRUCT_MODULE (vala_ccode_struct_module_get_type ())
#define VALA_CCODE_STRUCT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModule))
#define VALA_CCODE_STRUCT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModuleClass))
#define VALA_IS_CCODE_STRUCT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_STRUCT_MODULE))
#define VALA_IS_CCODE_STRUCT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_STRUCT_MODULE))
#define VALA_CCODE_STRUCT_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModuleClass))

typedef struct _ValaCCodeStructModule ValaCCodeStructModule;
typedef struct _ValaCCodeStructModuleClass ValaCCodeStructModuleClass;
typedef struct _ValaCCodeStructModulePrivate ValaCCodeStructModulePrivate;

#define VALA_TYPE_CCODE_METHOD_MODULE (vala_ccode_method_module_get_type ())
#define VALA_CCODE_METHOD_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModule))
#define VALA_CCODE_METHOD_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModuleClass))
#define VALA_IS_CCODE_METHOD_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_METHOD_MODULE))
#define VALA_IS_CCODE_METHOD_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_METHOD_MODULE))
#define VALA_CCODE_METHOD_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModuleClass))

typedef struct _ValaCCodeMethodModule ValaCCodeMethodModule;
typedef struct _ValaCCodeMethodModuleClass ValaCCodeMethodModuleClass;
typedef struct _ValaCCodeMethodModulePrivate ValaCCodeMethodModulePrivate;

#define VALA_TYPE_CCODE_CONTROL_FLOW_MODULE (vala_ccode_control_flow_module_get_type ())
#define VALA_CCODE_CONTROL_FLOW_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModule))
#define VALA_CCODE_CONTROL_FLOW_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModuleClass))
#define VALA_IS_CCODE_CONTROL_FLOW_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE))
#define VALA_IS_CCODE_CONTROL_FLOW_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE))
#define VALA_CCODE_CONTROL_FLOW_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModuleClass))

typedef struct _ValaCCodeControlFlowModule ValaCCodeControlFlowModule;
typedef struct _ValaCCodeControlFlowModuleClass ValaCCodeControlFlowModuleClass;
typedef struct _ValaCCodeControlFlowModulePrivate ValaCCodeControlFlowModulePrivate;

#define VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE (vala_ccode_member_access_module_get_type ())
#define VALA_CCODE_MEMBER_ACCESS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModule))
#define VALA_CCODE_MEMBER_ACCESS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModuleClass))
#define VALA_IS_CCODE_MEMBER_ACCESS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE))
#define VALA_IS_CCODE_MEMBER_ACCESS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE))
#define VALA_CCODE_MEMBER_ACCESS_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModuleClass))

typedef struct _ValaCCodeMemberAccessModule ValaCCodeMemberAccessModule;
typedef struct _ValaCCodeMemberAccessModuleClass ValaCCodeMemberAccessModuleClass;
typedef struct _ValaCCodeMemberAccessModulePrivate ValaCCodeMemberAccessModulePrivate;

#define VALA_TYPE_CCODE_ASSIGNMENT_MODULE (vala_ccode_assignment_module_get_type ())
#define VALA_CCODE_ASSIGNMENT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_ASSIGNMENT_MODULE, ValaCCodeAssignmentModule))
#define VALA_CCODE_ASSIGNMENT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_ASSIGNMENT_MODULE, ValaCCodeAssignmentModuleClass))
#define VALA_IS_CCODE_ASSIGNMENT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_ASSIGNMENT_MODULE))
#define VALA_IS_CCODE_ASSIGNMENT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_ASSIGNMENT_MODULE))
#define VALA_CCODE_ASSIGNMENT_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_ASSIGNMENT_MODULE, ValaCCodeAssignmentModuleClass))

typedef struct _ValaCCodeAssignmentModule ValaCCodeAssignmentModule;
typedef struct _ValaCCodeAssignmentModuleClass ValaCCodeAssignmentModuleClass;
typedef struct _ValaCCodeAssignmentModulePrivate ValaCCodeAssignmentModulePrivate;

#define VALA_TYPE_CCODE_METHOD_CALL_MODULE (vala_ccode_method_call_module_get_type ())
#define VALA_CCODE_METHOD_CALL_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModule))
#define VALA_CCODE_METHOD_CALL_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModuleClass))
#define VALA_IS_CCODE_METHOD_CALL_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_METHOD_CALL_MODULE))
#define VALA_IS_CCODE_METHOD_CALL_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_METHOD_CALL_MODULE))
#define VALA_CCODE_METHOD_CALL_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModuleClass))

typedef struct _ValaCCodeMethodCallModule ValaCCodeMethodCallModule;
typedef struct _ValaCCodeMethodCallModuleClass ValaCCodeMethodCallModuleClass;
typedef struct _ValaCCodeMethodCallModulePrivate ValaCCodeMethodCallModulePrivate;

#define VALA_TYPE_CCODE_ARRAY_MODULE (vala_ccode_array_module_get_type ())
#define VALA_CCODE_ARRAY_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_ARRAY_MODULE, ValaCCodeArrayModule))
#define VALA_CCODE_ARRAY_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_ARRAY_MODULE, ValaCCodeArrayModuleClass))
#define VALA_IS_CCODE_ARRAY_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_ARRAY_MODULE))
#define VALA_IS_CCODE_ARRAY_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_ARRAY_MODULE))
#define VALA_CCODE_ARRAY_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_ARRAY_MODULE, ValaCCodeArrayModuleClass))

typedef struct _ValaCCodeArrayModule ValaCCodeArrayModule;
typedef struct _ValaCCodeArrayModuleClass ValaCCodeArrayModuleClass;
typedef struct _ValaCCodeArrayModulePrivate ValaCCodeArrayModulePrivate;
#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_ccode_base_module_emit_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_base_module_emit_context_unref (var), NULL)))

struct _ValaCCodeBaseModule {
	ValaCodeGenerator parent_instance;
	ValaCCodeBaseModulePrivate * priv;
	ValaSymbol* root_symbol;
	ValaCCodeBaseModuleEmitContext* emit_context;
	ValaCCodeFile* header_file;
	ValaCCodeFile* internal_header_file;
	ValaCCodeFile* cfile;
	ValaCCodeBaseModuleEmitContext* class_init_context;
	ValaCCodeBaseModuleEmitContext* base_init_context;
	ValaCCodeBaseModuleEmitContext* class_finalize_context;
	ValaCCodeBaseModuleEmitContext* base_finalize_context;
	ValaCCodeBaseModuleEmitContext* instance_init_context;
	ValaCCodeBaseModuleEmitContext* instance_finalize_context;
	ValaCCodeStruct* param_spec_struct;
	ValaCCodeStruct* closure_struct;
	ValaCCodeEnum* prop_enum;
	ValaSet* user_marshal_set;
	ValaSet* predefined_marshal_set;
	gint next_regex_id;
	gboolean in_constructor;
	gboolean in_static_or_class_context;
	gint next_coroutine_state;
	ValaDataType* void_type;
	ValaDataType* bool_type;
	ValaDataType* char_type;
	ValaDataType* uchar_type;
	ValaDataType* unichar_type;
	ValaDataType* short_type;
	ValaDataType* ushort_type;
	ValaDataType* int_type;
	ValaDataType* uint_type;
	ValaDataType* long_type;
	ValaDataType* ulong_type;
	ValaDataType* int8_type;
	ValaDataType* uint8_type;
	ValaDataType* int16_type;
	ValaDataType* uint16_type;
	ValaDataType* int32_type;
	ValaDataType* uint32_type;
	ValaDataType* int64_type;
	ValaDataType* uint64_type;
	ValaDataType* string_type;
	ValaDataType* regex_type;
	ValaDataType* float_type;
	ValaDataType* double_type;
	ValaTypeSymbol* gtype_type;
	ValaTypeSymbol* gobject_type;
	ValaErrorType* gerror_type;
	ValaClass* glist_type;
	ValaClass* gslist_type;
	ValaClass* gnode_type;
	ValaClass* gvaluearray_type;
	ValaTypeSymbol* gstringbuilder_type;
	ValaTypeSymbol* garray_type;
	ValaTypeSymbol* gbytearray_type;
	ValaTypeSymbol* gptrarray_type;
	ValaTypeSymbol* gthreadpool_type;
	ValaDataType* gquark_type;
	ValaStruct* gvalue_type;
	ValaClass* gvariant_type;
	ValaStruct* mutex_type;
	ValaTypeSymbol* type_module_type;
	ValaTypeSymbol* dbus_proxy_type;
	ValaTypeSymbol* dbus_object_type;
	gboolean in_plugin;
	char* module_init_param_name;
	gboolean gvaluecollector_h_needed;
	gboolean requires_array_free;
	gboolean requires_array_move;
	gboolean requires_array_length;
	gboolean requires_strcmp0;
	ValaSet* wrappers;
};

struct _ValaCCodeBaseModuleClass {
	ValaCodeGeneratorClass parent_class;
	void (*append_vala_array_free) (ValaCCodeBaseModule* self);
	void (*append_vala_array_move) (ValaCCodeBaseModule* self);
	void (*append_vala_array_length) (ValaCCodeBaseModule* self);
	gboolean (*generate_enum_declaration) (ValaCCodeBaseModule* self, ValaEnum* en, ValaCCodeFile* decl_space);
	void (*generate_class_struct_declaration) (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeFile* decl_space);
	void (*generate_struct_declaration) (ValaCCodeBaseModule* self, ValaStruct* st, ValaCCodeFile* decl_space);
	void (*generate_delegate_declaration) (ValaCCodeBaseModule* self, ValaDelegate* d, ValaCCodeFile* decl_space);
	void (*generate_cparameters) (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeFile* decl_space, ValaMap* cparam_map, ValaCCodeFunction* func, ValaCCodeFunctionDeclarator* vdeclarator, ValaMap* carg_map, ValaCCodeFunctionCall* vcall, gint direction);
	ValaCCodeExpression* (*get_dup_func_expression) (ValaCCodeBaseModule* self, ValaDataType* type, ValaSourceReference* source_reference, gboolean is_chainup);
	char* (*append_struct_array_free) (ValaCCodeBaseModule* self, ValaStruct* st);
	ValaCCodeExpression* (*get_unref_expression) (ValaCCodeBaseModule* self, ValaCCodeExpression* cvar, ValaDataType* type, ValaExpression* expr, gboolean is_macro_definition);
	void (*append_local_free) (ValaCCodeBaseModule* self, ValaSymbol* sym, gboolean stop_at_loop);
	char* (*get_delegate_target_cname) (ValaCCodeBaseModule* self, const char* delegate_cname);
	ValaCCodeExpression* (*get_delegate_target_cexpression) (ValaCCodeBaseModule* self, ValaExpression* delegate_expr, ValaCCodeExpression** delegate_target_destroy_notify);
	char* (*get_delegate_target_destroy_notify_cname) (ValaCCodeBaseModule* self, const char* delegate_cname);
	ValaCCodeExpression* (*get_ref_cexpression) (ValaCCodeBaseModule* self, ValaDataType* expression_type, ValaCCodeExpression* cexpr, ValaExpression* expr, ValaCodeNode* node);
	void (*generate_class_declaration) (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeFile* decl_space);
	void (*generate_interface_declaration) (ValaCCodeBaseModule* self, ValaInterface* iface, ValaCCodeFile* decl_space);
	void (*generate_method_declaration) (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeFile* decl_space);
	void (*generate_error_domain_declaration) (ValaCCodeBaseModule* self, ValaErrorDomain* edomain, ValaCCodeFile* decl_space);
	ValaCCodeExpression* (*deserialize_expression) (ValaCCodeBaseModule* self, ValaCCodeFragment* fragment, ValaDataType* type, ValaCCodeExpression* variant_expr, ValaCCodeExpression* expr);
	ValaCCodeExpression* (*serialize_expression) (ValaCCodeBaseModule* self, ValaCCodeFragment* fragment, ValaDataType* type, ValaCCodeExpression* expr);
	ValaCCodeExpression* (*get_implicit_cast_expression) (ValaCCodeBaseModule* self, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr);
	gboolean (*is_gobject_property) (ValaCCodeBaseModule* self, ValaProperty* prop);
	char* (*get_custom_creturn_type) (ValaCCodeBaseModule* self, ValaMethod* m);
	void (*generate_dynamic_method_wrapper) (ValaCCodeBaseModule* self, ValaDynamicMethod* method);
	gboolean (*method_has_wrapper) (ValaCCodeBaseModule* self, ValaMethod* method);
	ValaCCodeFunctionCall* (*get_param_spec) (ValaCCodeBaseModule* self, ValaProperty* prop);
	ValaCCodeFunctionCall* (*get_signal_creation) (ValaCCodeBaseModule* self, ValaSignal* sig, ValaTypeSymbol* type);
	ValaCCodeFragment* (*register_dbus_info) (ValaCCodeBaseModule* self, ValaObjectTypeSymbol* bindable);
	char* (*get_dynamic_property_getter_cname) (ValaCCodeBaseModule* self, ValaDynamicProperty* node);
	char* (*get_dynamic_property_setter_cname) (ValaCCodeBaseModule* self, ValaDynamicProperty* node);
	char* (*get_dynamic_signal_cname) (ValaCCodeBaseModule* self, ValaDynamicSignal* node);
	char* (*get_dynamic_signal_connect_wrapper_name) (ValaCCodeBaseModule* self, ValaDynamicSignal* node);
	char* (*get_dynamic_signal_connect_after_wrapper_name) (ValaCCodeBaseModule* self, ValaDynamicSignal* node);
	char* (*get_dynamic_signal_disconnect_wrapper_name) (ValaCCodeBaseModule* self, ValaDynamicSignal* node);
	void (*generate_marshaller) (ValaCCodeBaseModule* self, ValaList* params, ValaDataType* return_type, gboolean dbus);
	char* (*get_marshaller_function) (ValaCCodeBaseModule* self, ValaList* params, ValaDataType* return_type, const char* prefix, gboolean dbus);
	char* (*get_array_length_cname) (ValaCCodeBaseModule* self, const char* array_cname, gint dim);
	char* (*get_parameter_array_length_cname) (ValaCCodeBaseModule* self, ValaFormalParameter* param, gint dim);
	ValaCCodeExpression* (*get_array_length_cexpression) (ValaCCodeBaseModule* self, ValaExpression* array_expr, gint dim);
	char* (*get_array_size_cname) (ValaCCodeBaseModule* self, const char* array_cname);
	ValaCCodeExpression* (*get_array_size_cexpression) (ValaCCodeBaseModule* self, ValaExpression* array_expr);
	void (*add_simple_check) (ValaCCodeBaseModule* self, ValaCodeNode* node, gboolean always_fails);
};

struct _ValaCCodeStructModule {
	ValaCCodeBaseModule parent_instance;
	ValaCCodeStructModulePrivate * priv;
};

struct _ValaCCodeStructModuleClass {
	ValaCCodeBaseModuleClass parent_class;
};

struct _ValaCCodeMethodModule {
	ValaCCodeStructModule parent_instance;
	ValaCCodeMethodModulePrivate * priv;
};

struct _ValaCCodeMethodModuleClass {
	ValaCCodeStructModuleClass parent_class;
	void (*generate_method_result_declaration) (ValaCCodeMethodModule* self, ValaMethod* m, ValaCCodeFile* decl_space, ValaCCodeFunction* cfunc, ValaMap* cparam_map, ValaMap* carg_map);
	void (*generate_parameter) (ValaCCodeMethodModule* self, ValaFormalParameter* param, ValaCCodeFile* decl_space, ValaMap* cparam_map, ValaMap* carg_map);
};

struct _ValaCCodeControlFlowModule {
	ValaCCodeMethodModule parent_instance;
	ValaCCodeControlFlowModulePrivate * priv;
};

struct _ValaCCodeControlFlowModuleClass {
	ValaCCodeMethodModuleClass parent_class;
};

struct _ValaCCodeMemberAccessModule {
	ValaCCodeControlFlowModule parent_instance;
	ValaCCodeMemberAccessModulePrivate * priv;
};

struct _ValaCCodeMemberAccessModuleClass {
	ValaCCodeControlFlowModuleClass parent_class;
};

struct _ValaCCodeAssignmentModule {
	ValaCCodeMemberAccessModule parent_instance;
	ValaCCodeAssignmentModulePrivate * priv;
};

struct _ValaCCodeAssignmentModuleClass {
	ValaCCodeMemberAccessModuleClass parent_class;
};

struct _ValaCCodeMethodCallModule {
	ValaCCodeAssignmentModule parent_instance;
	ValaCCodeMethodCallModulePrivate * priv;
};

struct _ValaCCodeMethodCallModuleClass {
	ValaCCodeAssignmentModuleClass parent_class;
};

struct _ValaCCodeArrayModule {
	ValaCCodeMethodCallModule parent_instance;
	ValaCCodeArrayModulePrivate * priv;
};

struct _ValaCCodeArrayModuleClass {
	ValaCCodeMethodCallModuleClass parent_class;
};

struct _ValaCCodeArrayModulePrivate {
	gint next_array_dup_id;
	gint next_array_add_id;
};


static gpointer vala_ccode_array_module_parent_class = NULL;

GType vala_ccode_base_module_get_type (void) G_GNUC_CONST;
gpointer vala_ccode_base_module_emit_context_ref (gpointer instance);
void vala_ccode_base_module_emit_context_unref (gpointer instance);
GParamSpec* vala_ccode_base_module_param_spec_emit_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_ccode_base_module_value_set_emit_context (GValue* value, gpointer v_object);
void vala_ccode_base_module_value_take_emit_context (GValue* value, gpointer v_object);
gpointer vala_ccode_base_module_value_get_emit_context (const GValue* value);
GType vala_ccode_base_module_emit_context_get_type (void) G_GNUC_CONST;
GType vala_ccode_struct_module_get_type (void) G_GNUC_CONST;
GType vala_ccode_method_module_get_type (void) G_GNUC_CONST;
GType vala_ccode_control_flow_module_get_type (void) G_GNUC_CONST;
GType vala_ccode_member_access_module_get_type (void) G_GNUC_CONST;
GType vala_ccode_assignment_module_get_type (void) G_GNUC_CONST;
GType vala_ccode_method_call_module_get_type (void) G_GNUC_CONST;
GType vala_ccode_array_module_get_type (void) G_GNUC_CONST;
#define VALA_CCODE_ARRAY_MODULE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_ARRAY_MODULE, ValaCCodeArrayModulePrivate))
enum  {
	VALA_CCODE_ARRAY_MODULE_DUMMY_PROPERTY
};
static void vala_ccode_array_module_append_initializer_list (ValaCCodeArrayModule* self, ValaCCodeCommaExpression* ce, ValaCCodeExpression* name_cnode, ValaInitializerList* initializer_list, gint rank, gint* i);
static void vala_ccode_array_module_real_visit_array_creation_expression (ValaCodeVisitor* base, ValaArrayCreationExpression* expr);
ValaLocalVariable* vala_ccode_base_module_get_temp_variable (ValaCCodeBaseModule* self, ValaDataType* type, gboolean value_owned, ValaCodeNode* node_reference, gboolean init);
ValaCCodeExpression* vala_ccode_base_module_get_variable_cexpression (ValaCCodeBaseModule* self, const char* name);
void vala_ccode_base_module_emit_temp_var (ValaCCodeBaseModule* self, ValaLocalVariable* local);
ValaCodeContext* vala_ccode_base_module_get_context (ValaCCodeBaseModule* self);
gboolean vala_ccode_base_module_is_pure_ccode_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* cexpr);
static char* vala_ccode_array_module_real_get_array_length_cname (ValaCCodeBaseModule* base, const char* array_cname, gint dim);
static char* vala_ccode_array_module_real_get_parameter_array_length_cname (ValaCCodeBaseModule* base, ValaFormalParameter* param, gint dim);
char* vala_ccode_base_module_get_array_length_cname (ValaCCodeBaseModule* self, const char* array_cname, gint dim);
char* vala_ccode_base_module_get_variable_cname (ValaCCodeBaseModule* self, const char* name);
static ValaCCodeExpression* vala_ccode_array_module_real_get_array_length_cexpression (ValaCCodeBaseModule* base, ValaExpression* array_expr, gint dim);
ValaCCodeExpression* vala_ccode_base_module_get_array_length_cexpression (ValaCCodeBaseModule* self, ValaExpression* array_expr, gint dim);
ValaCCodeNode* vala_ccode_base_module_get_ccodenode (ValaCCodeBaseModule* self, ValaCodeNode* node);
gint vala_ccode_base_module_get_block_id (ValaCCodeBaseModule* self, ValaBlock* b);
char* vala_ccode_base_module_get_parameter_array_length_cname (ValaCCodeBaseModule* self, ValaFormalParameter* param, gint dim);
static char* vala_ccode_array_module_real_get_array_size_cname (ValaCCodeBaseModule* base, const char* array_cname);
static ValaCCodeExpression* vala_ccode_array_module_real_get_array_size_cexpression (ValaCCodeBaseModule* base, ValaExpression* array_expr);
char* vala_ccode_base_module_get_array_size_cname (ValaCCodeBaseModule* self, const char* array_cname);
static void vala_ccode_array_module_real_visit_element_access (ValaCodeVisitor* base, ValaElementAccess* expr);
static void vala_ccode_array_module_real_visit_slice_expression (ValaCodeVisitor* base, ValaSliceExpression* expr);
static ValaCCodeForStatement* vala_ccode_array_module_get_struct_array_free_loop (ValaCCodeArrayModule* self, ValaStruct* st);
ValaCCodeExpression* vala_ccode_base_module_get_destroy_func_expression (ValaCCodeBaseModule* self, ValaDataType* type, gboolean is_chainup);
static char* vala_ccode_array_module_real_append_struct_array_free (ValaCCodeBaseModule* base, ValaStruct* st);
static ValaCCodeForStatement* vala_ccode_array_module_get_vala_array_free_loop (ValaCCodeArrayModule* self);
static void vala_ccode_array_module_real_append_vala_array_free (ValaCCodeBaseModule* base);
static void vala_ccode_array_module_real_append_vala_array_move (ValaCCodeBaseModule* base);
static void vala_ccode_array_module_real_append_vala_array_length (ValaCCodeBaseModule* base);
static ValaCCodeExpression* vala_ccode_array_module_real_get_ref_cexpression (ValaCCodeBaseModule* base, ValaDataType* expression_type, ValaCCodeExpression* cexpr, ValaExpression* expr, ValaCodeNode* node);
ValaCCodeExpression* vala_ccode_base_module_get_ref_cexpression (ValaCCodeBaseModule* self, ValaDataType* expression_type, ValaCCodeExpression* cexpr, ValaExpression* expr, ValaCodeNode* node);
static char* vala_ccode_array_module_generate_array_copy_wrapper (ValaCCodeArrayModule* self, ValaArrayType* array_type);
static ValaCCodeExpression* vala_ccode_array_module_real_get_dup_func_expression (ValaCCodeBaseModule* base, ValaDataType* type, ValaSourceReference* source_reference, gboolean is_chainup);
static char* vala_ccode_array_module_generate_array_dup_wrapper (ValaCCodeArrayModule* self, ValaArrayType* array_type);
ValaCCodeExpression* vala_ccode_base_module_get_dup_func_expression (ValaCCodeBaseModule* self, ValaDataType* type, ValaSourceReference* source_reference, gboolean is_chainup);
static ValaCCodeExpression* vala_ccode_array_module_real_get_unref_expression (ValaCCodeBaseModule* base, ValaCCodeExpression* cvar, ValaDataType* type, ValaExpression* expr, gboolean is_macro_definition);
ValaCCodeExpression* vala_ccode_base_module_get_unref_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* cvar, ValaDataType* type, ValaExpression* expr, gboolean is_macro_definition);
gboolean vala_ccode_base_module_add_wrapper (ValaCCodeBaseModule* self, const char* wrapper_name);
void vala_ccode_base_module_push_context (ValaCCodeBaseModule* self, ValaCCodeBaseModuleEmitContext* emit_context);
ValaCCodeBaseModuleEmitContext* vala_ccode_base_module_emit_context_new (ValaSymbol* symbol);
ValaCCodeBaseModuleEmitContext* vala_ccode_base_module_emit_context_construct (GType object_type, ValaSymbol* symbol);
void vala_ccode_base_module_push_function (ValaCCodeBaseModule* self, ValaCCodeFunction* func);
gboolean vala_ccode_base_module_requires_copy (ValaCCodeBaseModule* self, ValaDataType* type);
ValaCCodeFunction* vala_ccode_base_module_get_ccode (ValaCCodeBaseModule* self);
void vala_ccode_base_module_pop_context (ValaCCodeBaseModule* self);
static char* vala_ccode_array_module_generate_array_add_wrapper (ValaCCodeArrayModule* self, ValaArrayType* array_type);
static gboolean vala_ccode_array_module_is_array_add (ValaCCodeArrayModule* self, ValaAssignment* assignment);
static void vala_ccode_array_module_real_visit_assignment (ValaCodeVisitor* base, ValaAssignment* assignment);
ValaCCodeExpression* vala_ccode_base_module_get_array_size_cexpression (ValaCCodeBaseModule* self, ValaExpression* array_expr);
ValaCCodeExpression* vala_ccode_base_module_handle_struct_argument (ValaCCodeBaseModule* self, ValaFormalParameter* param, ValaExpression* arg, ValaCCodeExpression* cexpr);
static void vala_ccode_array_module_real_generate_parameter (ValaCCodeMethodModule* base, ValaFormalParameter* param, ValaCCodeFile* decl_space, ValaMap* cparam_map, ValaMap* carg_map);
void vala_ccode_method_module_generate_parameter (ValaCCodeMethodModule* self, ValaFormalParameter* param, ValaCCodeFile* decl_space, ValaMap* cparam_map, ValaMap* carg_map);
void vala_ccode_base_module_generate_type_declaration (ValaCCodeBaseModule* self, ValaDataType* type, ValaCCodeFile* decl_space);
gint vala_ccode_base_module_get_param_pos (ValaCCodeBaseModule* self, double param_pos, gboolean ellipsis);
ValaCCodeArrayModule* vala_ccode_array_module_new (void);
ValaCCodeArrayModule* vala_ccode_array_module_construct (GType object_type);
ValaCCodeMethodCallModule* vala_ccode_method_call_module_new (void);
ValaCCodeMethodCallModule* vala_ccode_method_call_module_construct (GType object_type);
static void vala_ccode_array_module_finalize (ValaCodeVisitor* obj);


static void vala_ccode_array_module_append_initializer_list (ValaCCodeArrayModule* self, ValaCCodeCommaExpression* ce, ValaCCodeExpression* name_cnode, ValaInitializerList* initializer_list, gint rank, gint* i) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (ce != NULL);
	g_return_if_fail (name_cnode != NULL);
	g_return_if_fail (initializer_list != NULL);
	{
		ValaList* _e_list;
		gint _e_size;
		gint _e_index;
		_e_list = vala_initializer_list_get_initializers (initializer_list);
		_e_size = vala_collection_get_size ((ValaCollection*) _e_list);
		_e_index = -1;
		while (TRUE) {
			ValaExpression* e;
			if (!((_e_index = _e_index + 1) < _e_size)) {
				break;
			}
			e = (ValaExpression*) vala_list_get (_e_list, _e_index);
			if (rank > 1) {
				vala_ccode_array_module_append_initializer_list (self, ce, name_cnode, VALA_INITIALIZER_LIST (e), rank - 1, i);
			} else {
				char* _tmp0_;
				ValaCCodeConstant* _tmp1_;
				ValaCCodeElementAccess* _tmp2_;
				ValaCCodeAssignment* _tmp3_;
				vala_ccode_comma_expression_append_expression (ce, (ValaCCodeExpression*) (_tmp3_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp2_ = vala_ccode_element_access_new (name_cnode, (ValaCCodeExpression*) (_tmp1_ = vala_ccode_constant_new (_tmp0_ = g_strdup_printf ("%i", *i))))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) e)), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
				_vala_ccode_node_unref0 (_tmp3_);
				_vala_ccode_node_unref0 (_tmp2_);
				_vala_ccode_node_unref0 (_tmp1_);
				_g_free0 (_tmp0_);
				(*i)++;
			}
			_vala_code_node_unref0 (e);
		}
		_vala_iterable_unref0 (_e_list);
	}
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


static gpointer _vala_ccode_node_ref0 (gpointer self) {
	return self ? vala_ccode_node_ref (self) : NULL;
}


static void vala_ccode_array_module_real_visit_array_creation_expression (ValaCodeVisitor* base, ValaArrayCreationExpression* expr) {
	ValaCCodeArrayModule * self;
	ValaDataType* _tmp0_;
	ValaArrayType* array_type;
	gboolean _tmp1_ = FALSE;
	ValaCCodeFunctionCall* gnew;
	gboolean first;
	ValaCCodeExpression* cexpr;
	gboolean _tmp11_ = FALSE;
	self = (ValaCCodeArrayModule*) base;
	g_return_if_fail (expr != NULL);
	array_type = _vala_code_node_ref0 ((_tmp0_ = vala_expression_get_target_type ((ValaExpression*) expr), VALA_IS_ARRAY_TYPE (_tmp0_) ? ((ValaArrayType*) _tmp0_) : NULL));
	if (array_type != NULL) {
		_tmp1_ = vala_array_type_get_fixed_length (array_type);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		ValaCCodeCommaExpression* ce;
		ValaLocalVariable* temp_var;
		ValaCCodeExpression* name_cnode;
		gint i;
		ce = vala_ccode_comma_expression_new ();
		temp_var = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) array_type, TRUE, (ValaCodeNode*) expr, TRUE);
		name_cnode = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) temp_var));
		i = 0;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, temp_var);
		vala_ccode_array_module_append_initializer_list (self, ce, name_cnode, vala_array_creation_expression_get_initializer_list (expr), vala_array_creation_expression_get_rank (expr), &i);
		vala_ccode_comma_expression_append_expression (ce, name_cnode);
		vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ce);
		_vala_ccode_node_unref0 (name_cnode);
		_vala_code_node_unref0 (temp_var);
		_vala_ccode_node_unref0 (ce);
		_vala_code_node_unref0 (array_type);
		return;
	}
	gnew = NULL;
	if (vala_code_context_get_profile (vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self)) == VALA_PROFILE_POSIX) {
		ValaCCodeIdentifier* _tmp2_;
		ValaCCodeFunctionCall* _tmp3_;
		vala_ccode_file_add_include (((ValaCCodeBaseModule*) self)->cfile, "stdlib.h", FALSE);
		gnew = (_tmp3_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp2_ = vala_ccode_identifier_new ("calloc"))), _vala_ccode_node_unref0 (gnew), _tmp3_);
		_vala_ccode_node_unref0 (_tmp2_);
	} else {
		ValaCCodeIdentifier* _tmp4_;
		ValaCCodeFunctionCall* _tmp5_;
		char* _tmp6_;
		ValaCCodeIdentifier* _tmp7_;
		gnew = (_tmp5_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp4_ = vala_ccode_identifier_new ("g_new0"))), _vala_ccode_node_unref0 (gnew), _tmp5_);
		_vala_ccode_node_unref0 (_tmp4_);
		vala_ccode_function_call_add_argument (gnew, (ValaCCodeExpression*) (_tmp7_ = vala_ccode_identifier_new (_tmp6_ = vala_data_type_get_cname (vala_array_creation_expression_get_element_type (expr)))));
		_vala_ccode_node_unref0 (_tmp7_);
		_g_free0 (_tmp6_);
	}
	first = TRUE;
	cexpr = NULL;
	{
		ValaList* _size_list;
		gint _size_size;
		gint _size_index;
		_size_list = vala_array_creation_expression_get_sizes (expr);
		_size_size = vala_collection_get_size ((ValaCollection*) _size_list);
		_size_index = -1;
		while (TRUE) {
			ValaExpression* size;
			ValaCCodeExpression* csize;
			if (!((_size_index = _size_index + 1) < _size_size)) {
				break;
			}
			size = (ValaExpression*) vala_list_get (_size_list, _size_index);
			csize = _vala_ccode_node_ref0 (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) size)));
			if (!vala_ccode_base_module_is_pure_ccode_expression ((ValaCCodeBaseModule*) self, csize)) {
				ValaLocalVariable* temp_var;
				ValaCCodeExpression* name_cnode;
				ValaCCodeExpression* _tmp8_;
				temp_var = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, ((ValaCCodeBaseModule*) self)->int_type, FALSE, (ValaCodeNode*) expr, TRUE);
				name_cnode = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) temp_var));
				vala_code_node_set_ccodenode ((ValaCodeNode*) size, (ValaCCodeNode*) name_cnode);
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, temp_var);
				csize = (_tmp8_ = (ValaCCodeExpression*) vala_ccode_assignment_new (name_cnode, csize, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), _vala_ccode_node_unref0 (csize), _tmp8_);
				_vala_ccode_node_unref0 (name_cnode);
				_vala_code_node_unref0 (temp_var);
			}
			if (first) {
				ValaCCodeExpression* _tmp9_;
				cexpr = (_tmp9_ = _vala_ccode_node_ref0 (csize), _vala_ccode_node_unref0 (cexpr), _tmp9_);
				first = FALSE;
			} else {
				ValaCCodeExpression* _tmp10_;
				cexpr = (_tmp10_ = (ValaCCodeExpression*) vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, cexpr, csize), _vala_ccode_node_unref0 (cexpr), _tmp10_);
			}
			_vala_ccode_node_unref0 (csize);
			_vala_code_node_unref0 (size);
		}
		_vala_iterable_unref0 (_size_list);
	}
	if (vala_data_type_get_data_type (vala_array_creation_expression_get_element_type (expr)) != NULL) {
		_tmp11_ = vala_typesymbol_is_reference_type (vala_data_type_get_data_type (vala_array_creation_expression_get_element_type (expr)));
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		ValaCCodeConstant* _tmp12_;
		ValaCCodeExpression* _tmp13_;
		cexpr = (_tmp13_ = (ValaCCodeExpression*) vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, cexpr, (ValaCCodeExpression*) (_tmp12_ = vala_ccode_constant_new ("1"))), _vala_ccode_node_unref0 (cexpr), _tmp13_);
		_vala_ccode_node_unref0 (_tmp12_);
	}
	vala_ccode_function_call_add_argument (gnew, cexpr);
	if (vala_code_context_get_profile (vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self)) == VALA_PROFILE_POSIX) {
		ValaCCodeIdentifier* _tmp14_;
		ValaCCodeFunctionCall* _tmp15_;
		ValaCCodeFunctionCall* csizeof;
		char* _tmp16_;
		ValaCCodeIdentifier* _tmp17_;
		csizeof = (_tmp15_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp14_ = vala_ccode_identifier_new ("sizeof"))), _vala_ccode_node_unref0 (_tmp14_), _tmp15_);
		vala_ccode_function_call_add_argument (csizeof, (ValaCCodeExpression*) (_tmp17_ = vala_ccode_identifier_new (_tmp16_ = vala_data_type_get_cname (vala_array_creation_expression_get_element_type (expr)))));
		_vala_ccode_node_unref0 (_tmp17_);
		_g_free0 (_tmp16_);
		vala_ccode_function_call_add_argument (gnew, (ValaCCodeExpression*) csizeof);
		_vala_ccode_node_unref0 (csizeof);
	}
	if (vala_array_creation_expression_get_initializer_list (expr) != NULL) {
		ValaCCodeCommaExpression* ce;
		ValaLocalVariable* temp_var;
		ValaCCodeExpression* name_cnode;
		gint i;
		ValaCCodeAssignment* _tmp18_;
		ce = vala_ccode_comma_expression_new ();
		temp_var = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, vala_expression_get_value_type ((ValaExpression*) expr), TRUE, (ValaCodeNode*) expr, TRUE);
		name_cnode = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) temp_var));
		i = 0;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, temp_var);
		vala_ccode_comma_expression_append_expression (ce, (ValaCCodeExpression*) (_tmp18_ = vala_ccode_assignment_new (name_cnode, (ValaCCodeExpression*) gnew, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
		_vala_ccode_node_unref0 (_tmp18_);
		vala_ccode_array_module_append_initializer_list (self, ce, name_cnode, vala_array_creation_expression_get_initializer_list (expr), vala_array_creation_expression_get_rank (expr), &i);
		vala_ccode_comma_expression_append_expression (ce, name_cnode);
		vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ce);
		_vala_ccode_node_unref0 (name_cnode);
		_vala_code_node_unref0 (temp_var);
		_vala_ccode_node_unref0 (ce);
	} else {
		vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) gnew);
	}
	_vala_ccode_node_unref0 (cexpr);
	_vala_ccode_node_unref0 (gnew);
	_vala_code_node_unref0 (array_type);
}


static char* vala_ccode_array_module_real_get_array_length_cname (ValaCCodeBaseModule* base, const char* array_cname, gint dim) {
	ValaCCodeArrayModule * self;
	char* result = NULL;
	self = (ValaCCodeArrayModule*) base;
	g_return_val_if_fail (array_cname != NULL, NULL);
	result = g_strdup_printf ("%s_length%d", array_cname, dim);
	return result;
}


static char* vala_ccode_array_module_real_get_parameter_array_length_cname (ValaCCodeBaseModule* base, ValaFormalParameter* param, gint dim) {
	ValaCCodeArrayModule * self;
	char* result = NULL;
	self = (ValaCCodeArrayModule*) base;
	g_return_val_if_fail (param != NULL, NULL);
	if (vala_formal_parameter_get_has_array_length_cname (param)) {
		result = vala_formal_parameter_get_array_length_cname (param);
		return result;
	} else {
		char* _tmp0_;
		char* _tmp1_;
		result = (_tmp1_ = vala_ccode_base_module_get_array_length_cname ((ValaCCodeBaseModule*) self, _tmp0_ = vala_ccode_base_module_get_variable_cname ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) param)), dim), _g_free0 (_tmp0_), _tmp1_);
		return result;
	}
}


static ValaCCodeExpression* vala_ccode_array_module_real_get_array_length_cexpression (ValaCCodeBaseModule* base, ValaExpression* array_expr, gint dim) {
	ValaCCodeArrayModule * self;
	ValaCCodeExpression* result = NULL;
	ValaDataType* _tmp0_;
	ValaArrayType* array_type;
	gboolean _tmp1_ = FALSE;
	gboolean is_out;
	self = (ValaCCodeArrayModule*) base;
	g_return_val_if_fail (array_expr != NULL, NULL);
	array_type = _vala_code_node_ref0 ((_tmp0_ = vala_expression_get_value_type (array_expr), VALA_IS_ARRAY_TYPE (_tmp0_) ? ((ValaArrayType*) _tmp0_) : NULL));
	if (array_type != NULL) {
		_tmp1_ = vala_array_type_get_fixed_length (array_type);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		char* _tmp2_;
		ValaCCodeExpression* _tmp3_;
		result = (_tmp3_ = (ValaCCodeExpression*) vala_ccode_constant_new (_tmp2_ = g_strdup_printf ("%i", vala_array_type_get_length (array_type))), _g_free0 (_tmp2_), _tmp3_);
		_vala_code_node_unref0 (array_type);
		return result;
	}
	if (dim == (-1)) {
		gboolean _tmp4_ = FALSE;
		if (array_type != NULL) {
			_tmp4_ = vala_array_type_get_rank (array_type) > 1;
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			ValaCCodeExpression* cexpr;
			cexpr = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, array_expr, 1);
			{
				gboolean _tmp5_;
				dim = 2;
				_tmp5_ = TRUE;
				while (TRUE) {
					ValaCCodeExpression* _tmp6_;
					ValaCCodeExpression* _tmp7_;
					if (!_tmp5_) {
						dim++;
					}
					_tmp5_ = FALSE;
					if (!(dim <= vala_array_type_get_rank (array_type))) {
						break;
					}
					cexpr = (_tmp7_ = (ValaCCodeExpression*) vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, cexpr, _tmp6_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, array_expr, dim)), _vala_ccode_node_unref0 (cexpr), _tmp7_);
					_vala_ccode_node_unref0 (_tmp6_);
				}
			}
			result = cexpr;
			_vala_code_node_unref0 (array_type);
			return result;
		} else {
			dim = 1;
		}
	}
	is_out = FALSE;
	if (VALA_IS_UNARY_EXPRESSION (array_expr)) {
		ValaUnaryExpression* unary_expr;
		gboolean _tmp8_ = FALSE;
		unary_expr = _vala_code_node_ref0 (VALA_UNARY_EXPRESSION (array_expr));
		if (vala_unary_expression_get_operator (unary_expr) == VALA_UNARY_OPERATOR_OUT) {
			_tmp8_ = TRUE;
		} else {
			_tmp8_ = vala_unary_expression_get_operator (unary_expr) == VALA_UNARY_OPERATOR_REF;
		}
		if (_tmp8_) {
			array_expr = vala_unary_expression_get_inner (unary_expr);
			is_out = TRUE;
		}
		_vala_code_node_unref0 (unary_expr);
	} else {
		if (VALA_IS_REFERENCE_TRANSFER_EXPRESSION (array_expr)) {
			ValaReferenceTransferExpression* reftransfer_expr;
			reftransfer_expr = _vala_code_node_ref0 (VALA_REFERENCE_TRANSFER_EXPRESSION (array_expr));
			array_expr = vala_reference_transfer_expression_get_inner (reftransfer_expr);
			_vala_code_node_unref0 (reftransfer_expr);
		}
	}
	if (VALA_IS_ARRAY_CREATION_EXPRESSION (array_expr)) {
		ValaList* size;
		ValaExpression* length_expr;
		size = vala_array_creation_expression_get_sizes (VALA_ARRAY_CREATION_EXPRESSION (array_expr));
		length_expr = (ValaExpression*) vala_list_get (size, dim - 1);
		result = VALA_CCODE_EXPRESSION (vala_ccode_base_module_get_ccodenode ((ValaCCodeBaseModule*) self, (ValaCodeNode*) length_expr));
		_vala_code_node_unref0 (length_expr);
		_vala_iterable_unref0 (size);
		_vala_code_node_unref0 (array_type);
		return result;
	} else {
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		if (VALA_IS_METHOD_CALL (array_expr)) {
			_tmp10_ = TRUE;
		} else {
			_tmp10_ = VALA_IS_CAST_EXPRESSION (array_expr);
		}
		if (_tmp10_) {
			_tmp9_ = TRUE;
		} else {
			_tmp9_ = VALA_IS_SLICE_EXPRESSION (array_expr);
		}
		if (_tmp9_) {
			ValaList* size;
			gboolean _tmp11_ = FALSE;
			size = vala_expression_get_array_sizes (array_expr);
			if (size != NULL) {
				_tmp11_ = vala_collection_get_size ((ValaCollection*) size) >= dim;
			} else {
				_tmp11_ = FALSE;
			}
			if (_tmp11_) {
				result = (ValaCCodeExpression*) vala_list_get (size, dim - 1);
				_vala_iterable_unref0 (size);
				_vala_code_node_unref0 (array_type);
				return result;
			}
			_vala_iterable_unref0 (size);
		} else {
			if (vala_expression_get_symbol_reference (array_expr) != NULL) {
				if (VALA_IS_FORMAL_PARAMETER (vala_expression_get_symbol_reference (array_expr))) {
					ValaFormalParameter* param;
					param = _vala_code_node_ref0 (VALA_FORMAL_PARAMETER (vala_expression_get_symbol_reference (array_expr)));
					if (vala_formal_parameter_get_captured (param)) {
						ValaBlock* block;
						char* _tmp12_;
						ValaCCodeExpression* _tmp13_;
						char* _tmp14_;
						ValaCCodeMemberAccess* _tmp15_;
						ValaCCodeMemberAccess* length_expr;
						block = _vala_code_node_ref0 (vala_method_get_body (VALA_METHOD (vala_symbol_get_parent_symbol ((ValaSymbol*) param))));
						length_expr = (_tmp15_ = vala_ccode_member_access_new_pointer (_tmp13_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp12_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, block))), _tmp14_ = vala_ccode_base_module_get_parameter_array_length_cname ((ValaCCodeBaseModule*) self, param, dim)), _g_free0 (_tmp14_), _vala_ccode_node_unref0 (_tmp13_), _g_free0 (_tmp12_), _tmp15_);
						if (is_out) {
							result = (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) length_expr);
							_vala_ccode_node_unref0 (length_expr);
							_vala_code_node_unref0 (block);
							_vala_code_node_unref0 (param);
							_vala_code_node_unref0 (array_type);
							return result;
						} else {
							result = (ValaCCodeExpression*) length_expr;
							_vala_code_node_unref0 (block);
							_vala_code_node_unref0 (param);
							_vala_code_node_unref0 (array_type);
							return result;
						}
						_vala_ccode_node_unref0 (length_expr);
						_vala_code_node_unref0 (block);
					} else {
						if (vala_formal_parameter_get_array_null_terminated (param)) {
							ValaCCodeExpression* carray_expr;
							ValaCCodeIdentifier* _tmp16_;
							ValaCCodeFunctionCall* _tmp17_;
							ValaCCodeFunctionCall* len_call;
							carray_expr = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) param));
							((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
							len_call = (_tmp17_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp16_ = vala_ccode_identifier_new ("_vala_array_length"))), _vala_ccode_node_unref0 (_tmp16_), _tmp17_);
							vala_ccode_function_call_add_argument (len_call, carray_expr);
							result = (ValaCCodeExpression*) len_call;
							_vala_ccode_node_unref0 (carray_expr);
							_vala_code_node_unref0 (param);
							_vala_code_node_unref0 (array_type);
							return result;
						} else {
							if (!vala_formal_parameter_get_no_array_length (param)) {
								char* _tmp18_;
								ValaCCodeExpression* _tmp19_;
								ValaCCodeExpression* length_expr;
								length_expr = (_tmp19_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp18_ = vala_ccode_base_module_get_parameter_array_length_cname ((ValaCCodeBaseModule*) self, param, dim)), _g_free0 (_tmp18_), _tmp19_);
								if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN) {
									ValaCCodeExpression* _tmp20_;
									length_expr = (_tmp20_ = (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, length_expr), _vala_ccode_node_unref0 (length_expr), _tmp20_);
								}
								if (is_out) {
									result = (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, length_expr);
									_vala_ccode_node_unref0 (length_expr);
									_vala_code_node_unref0 (param);
									_vala_code_node_unref0 (array_type);
									return result;
								} else {
									result = length_expr;
									_vala_code_node_unref0 (param);
									_vala_code_node_unref0 (array_type);
									return result;
								}
								_vala_ccode_node_unref0 (length_expr);
							}
						}
					}
					_vala_code_node_unref0 (param);
				} else {
					if (VALA_IS_LOCAL_VARIABLE (vala_expression_get_symbol_reference (array_expr))) {
						ValaLocalVariable* local;
						local = _vala_code_node_ref0 (VALA_LOCAL_VARIABLE (vala_expression_get_symbol_reference (array_expr)));
						if (vala_local_variable_get_captured (local)) {
							ValaBlock* block;
							char* _tmp21_;
							ValaCCodeExpression* _tmp22_;
							char* _tmp23_;
							char* _tmp24_;
							ValaCCodeMemberAccess* _tmp25_;
							ValaCCodeMemberAccess* length_expr;
							block = _vala_code_node_ref0 (VALA_BLOCK (vala_symbol_get_parent_symbol ((ValaSymbol*) local)));
							length_expr = (_tmp25_ = vala_ccode_member_access_new_pointer (_tmp22_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp21_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, block))), _tmp24_ = vala_ccode_base_module_get_array_length_cname ((ValaCCodeBaseModule*) self, _tmp23_ = vala_ccode_base_module_get_variable_cname ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) local)), dim)), _g_free0 (_tmp24_), _g_free0 (_tmp23_), _vala_ccode_node_unref0 (_tmp22_), _g_free0 (_tmp21_), _tmp25_);
							if (is_out) {
								result = (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) length_expr);
								_vala_ccode_node_unref0 (length_expr);
								_vala_code_node_unref0 (block);
								_vala_code_node_unref0 (local);
								_vala_code_node_unref0 (array_type);
								return result;
							} else {
								result = (ValaCCodeExpression*) length_expr;
								_vala_code_node_unref0 (block);
								_vala_code_node_unref0 (local);
								_vala_code_node_unref0 (array_type);
								return result;
							}
							_vala_ccode_node_unref0 (length_expr);
							_vala_code_node_unref0 (block);
						} else {
							char* _tmp26_;
							char* _tmp27_;
							ValaCCodeExpression* _tmp28_;
							ValaCCodeExpression* length_expr;
							length_expr = (_tmp28_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp27_ = vala_ccode_base_module_get_array_length_cname ((ValaCCodeBaseModule*) self, _tmp26_ = vala_ccode_base_module_get_variable_cname ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) local)), dim)), _g_free0 (_tmp27_), _g_free0 (_tmp26_), _tmp28_);
							if (is_out) {
								result = (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, length_expr);
								_vala_ccode_node_unref0 (length_expr);
								_vala_code_node_unref0 (local);
								_vala_code_node_unref0 (array_type);
								return result;
							} else {
								result = length_expr;
								_vala_code_node_unref0 (local);
								_vala_code_node_unref0 (array_type);
								return result;
							}
							_vala_ccode_node_unref0 (length_expr);
						}
						_vala_code_node_unref0 (local);
					} else {
						if (VALA_IS_FIELD (vala_expression_get_symbol_reference (array_expr))) {
							ValaField* field;
							field = _vala_code_node_ref0 (VALA_FIELD (vala_expression_get_symbol_reference (array_expr)));
							if (vala_field_get_array_null_terminated (field)) {
								ValaMemberAccess* ma;
								ValaCCodeExpression* carray_expr;
								ValaCCodeIdentifier* _tmp38_;
								ValaCCodeFunctionCall* _tmp39_;
								ValaCCodeFunctionCall* len_call;
								ma = _vala_code_node_ref0 (VALA_MEMBER_ACCESS (array_expr));
								carray_expr = NULL;
								if (vala_field_get_binding (field) == MEMBER_BINDING_INSTANCE) {
									ValaSymbol* _tmp29_;
									ValaClass* cl;
									gboolean _tmp30_ = FALSE;
									gboolean is_gtypeinstance;
									char* array_cname;
									ValaCCodeExpression* typed_inst;
									ValaCCodeExpression* inst;
									gboolean _tmp31_ = FALSE;
									cl = _vala_code_node_ref0 ((_tmp29_ = vala_symbol_get_parent_symbol ((ValaSymbol*) field), VALA_IS_CLASS (_tmp29_) ? ((ValaClass*) _tmp29_) : NULL));
									if (cl != NULL) {
										_tmp30_ = !vala_class_get_is_compact (cl);
									} else {
										_tmp30_ = FALSE;
									}
									is_gtypeinstance = _tmp30_;
									array_cname = vala_field_get_cname (field);
									typed_inst = VALA_CCODE_EXPRESSION (vala_ccode_base_module_get_ccodenode ((ValaCCodeBaseModule*) self, (ValaCodeNode*) vala_member_access_get_inner (ma)));
									inst = NULL;
									if (is_gtypeinstance) {
										_tmp31_ = vala_symbol_get_access ((ValaSymbol*) field) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
									} else {
										_tmp31_ = FALSE;
									}
									if (_tmp31_) {
										ValaCCodeExpression* _tmp32_;
										inst = (_tmp32_ = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer (typed_inst, "priv"), _vala_ccode_node_unref0 (inst), _tmp32_);
									} else {
										ValaCCodeExpression* _tmp33_;
										inst = (_tmp33_ = _vala_ccode_node_ref0 (typed_inst), _vala_ccode_node_unref0 (inst), _tmp33_);
									}
									if (vala_typesymbol_is_reference_type (VALA_TYPESYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) field)))) {
										ValaCCodeExpression* _tmp34_;
										carray_expr = (_tmp34_ = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer (inst, array_cname), _vala_ccode_node_unref0 (carray_expr), _tmp34_);
									} else {
										ValaCCodeExpression* _tmp35_;
										carray_expr = (_tmp35_ = (ValaCCodeExpression*) vala_ccode_member_access_new (inst, array_cname, FALSE), _vala_ccode_node_unref0 (carray_expr), _tmp35_);
									}
									_vala_ccode_node_unref0 (inst);
									_vala_ccode_node_unref0 (typed_inst);
									_g_free0 (array_cname);
									_vala_code_node_unref0 (cl);
								} else {
									char* _tmp36_;
									ValaCCodeExpression* _tmp37_;
									carray_expr = (_tmp37_ = (ValaCCodeExpression*) vala_ccode_identifier_new (_tmp36_ = vala_field_get_cname (field)), _vala_ccode_node_unref0 (carray_expr), _tmp37_);
									_g_free0 (_tmp36_);
								}
								((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
								len_call = (_tmp39_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp38_ = vala_ccode_identifier_new ("_vala_array_length"))), _vala_ccode_node_unref0 (_tmp38_), _tmp39_);
								vala_ccode_function_call_add_argument (len_call, carray_expr);
								result = (ValaCCodeExpression*) len_call;
								_vala_ccode_node_unref0 (carray_expr);
								_vala_code_node_unref0 (ma);
								_vala_code_node_unref0 (field);
								_vala_code_node_unref0 (array_type);
								return result;
							} else {
								if (!vala_field_get_no_array_length (field)) {
									ValaMemberAccess* ma;
									ValaCCodeExpression* length_expr;
									ma = _vala_code_node_ref0 (VALA_MEMBER_ACCESS (array_expr));
									length_expr = NULL;
									if (vala_field_get_has_array_length_cexpr (field)) {
										char* _tmp40_;
										ValaCCodeExpression* _tmp41_;
										length_expr = (_tmp41_ = (ValaCCodeExpression*) vala_ccode_constant_new (_tmp40_ = vala_field_get_array_length_cexpr (field)), _vala_ccode_node_unref0 (length_expr), _tmp41_);
										_g_free0 (_tmp40_);
									} else {
										if (vala_field_get_binding (field) == MEMBER_BINDING_INSTANCE) {
											ValaSymbol* _tmp42_;
											ValaClass* cl;
											gboolean _tmp43_ = FALSE;
											gboolean is_gtypeinstance;
											char* length_cname;
											ValaCCodeExpression* typed_inst;
											ValaCCodeExpression* inst;
											gboolean _tmp46_ = FALSE;
											cl = _vala_code_node_ref0 ((_tmp42_ = vala_symbol_get_parent_symbol ((ValaSymbol*) field), VALA_IS_CLASS (_tmp42_) ? ((ValaClass*) _tmp42_) : NULL));
											if (cl != NULL) {
												_tmp43_ = !vala_class_get_is_compact (cl);
											} else {
												_tmp43_ = FALSE;
											}
											is_gtypeinstance = _tmp43_;
											length_cname = NULL;
											if (vala_field_get_has_array_length_cname (field)) {
												char* _tmp44_;
												length_cname = (_tmp44_ = vala_field_get_array_length_cname (field), _g_free0 (length_cname), _tmp44_);
											} else {
												char* _tmp45_;
												length_cname = (_tmp45_ = vala_ccode_base_module_get_array_length_cname ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) field), dim), _g_free0 (length_cname), _tmp45_);
											}
											typed_inst = VALA_CCODE_EXPRESSION (vala_ccode_base_module_get_ccodenode ((ValaCCodeBaseModule*) self, (ValaCodeNode*) vala_member_access_get_inner (ma)));
											inst = NULL;
											if (is_gtypeinstance) {
												_tmp46_ = vala_symbol_get_access ((ValaSymbol*) field) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
											} else {
												_tmp46_ = FALSE;
											}
											if (_tmp46_) {
												ValaCCodeExpression* _tmp47_;
												inst = (_tmp47_ = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer (typed_inst, "priv"), _vala_ccode_node_unref0 (inst), _tmp47_);
											} else {
												ValaCCodeExpression* _tmp48_;
												inst = (_tmp48_ = _vala_ccode_node_ref0 (typed_inst), _vala_ccode_node_unref0 (inst), _tmp48_);
											}
											if (vala_typesymbol_is_reference_type (VALA_TYPESYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) field)))) {
												ValaCCodeExpression* _tmp49_;
												length_expr = (_tmp49_ = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer (inst, length_cname), _vala_ccode_node_unref0 (length_expr), _tmp49_);
											} else {
												ValaCCodeExpression* _tmp50_;
												length_expr = (_tmp50_ = (ValaCCodeExpression*) vala_ccode_member_access_new (inst, length_cname, FALSE), _vala_ccode_node_unref0 (length_expr), _tmp50_);
											}
											if (vala_field_get_array_length_type (field) != NULL) {
												ValaCodeNode* _tmp51_;
												ValaExpression* parent_expr;
												parent_expr = _vala_code_node_ref0 ((_tmp51_ = vala_code_node_get_parent_node ((ValaCodeNode*) array_expr), VALA_IS_EXPRESSION (_tmp51_) ? ((ValaExpression*) _tmp51_) : NULL));
												if (vala_expression_get_lvalue (array_expr)) {
												} else {
													gboolean _tmp52_ = FALSE;
													gboolean _tmp53_ = FALSE;
													if (parent_expr != NULL) {
														_tmp53_ = VALA_IS_ARRAY_LENGTH_FIELD (vala_expression_get_symbol_reference (parent_expr));
													} else {
														_tmp53_ = FALSE;
													}
													if (_tmp53_) {
														_tmp52_ = vala_expression_get_lvalue (parent_expr);
													} else {
														_tmp52_ = FALSE;
													}
													if (_tmp52_) {
													} else {
														ValaCCodeExpression* _tmp54_;
														length_expr = (_tmp54_ = (ValaCCodeExpression*) vala_ccode_cast_expression_new (length_expr, "gint"), _vala_ccode_node_unref0 (length_expr), _tmp54_);
													}
												}
												_vala_code_node_unref0 (parent_expr);
											}
											_vala_ccode_node_unref0 (inst);
											_vala_ccode_node_unref0 (typed_inst);
											_g_free0 (length_cname);
											_vala_code_node_unref0 (cl);
										} else {
											char* _tmp55_;
											char* _tmp56_;
											ValaCCodeExpression* _tmp57_;
											length_expr = (_tmp57_ = (ValaCCodeExpression*) vala_ccode_identifier_new (_tmp56_ = vala_ccode_base_module_get_array_length_cname ((ValaCCodeBaseModule*) self, _tmp55_ = vala_field_get_cname (field), dim)), _vala_ccode_node_unref0 (length_expr), _tmp57_);
											_g_free0 (_tmp56_);
											_g_free0 (_tmp55_);
										}
									}
									if (is_out) {
										result = (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, length_expr);
										_vala_ccode_node_unref0 (length_expr);
										_vala_code_node_unref0 (ma);
										_vala_code_node_unref0 (field);
										_vala_code_node_unref0 (array_type);
										return result;
									} else {
										result = length_expr;
										_vala_code_node_unref0 (ma);
										_vala_code_node_unref0 (field);
										_vala_code_node_unref0 (array_type);
										return result;
									}
									_vala_ccode_node_unref0 (length_expr);
									_vala_code_node_unref0 (ma);
								}
							}
							_vala_code_node_unref0 (field);
						} else {
							if (VALA_IS_CONSTANT (vala_expression_get_symbol_reference (array_expr))) {
								ValaConstant* constant;
								ValaCCodeIdentifier* _tmp58_;
								ValaCCodeFunctionCall* _tmp59_;
								ValaCCodeFunctionCall* ccall;
								char* _tmp60_;
								ValaCCodeIdentifier* _tmp61_;
								constant = _vala_code_node_ref0 (VALA_CONSTANT (vala_expression_get_symbol_reference (array_expr)));
								ccall = (_tmp59_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp58_ = vala_ccode_identifier_new ("G_N_ELEMENTS"))), _vala_ccode_node_unref0 (_tmp58_), _tmp59_);
								vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp61_ = vala_ccode_identifier_new (_tmp60_ = vala_constant_get_cname (constant))));
								_vala_ccode_node_unref0 (_tmp61_);
								_g_free0 (_tmp60_);
								result = (ValaCCodeExpression*) ccall;
								_vala_code_node_unref0 (constant);
								_vala_code_node_unref0 (array_type);
								return result;
							} else {
								if (VALA_IS_PROPERTY (vala_expression_get_symbol_reference (array_expr))) {
									ValaProperty* prop;
									prop = _vala_code_node_ref0 (VALA_PROPERTY (vala_expression_get_symbol_reference (array_expr)));
									if (!vala_property_get_no_array_length (prop)) {
										ValaList* size;
										gboolean _tmp62_ = FALSE;
										size = vala_expression_get_array_sizes (array_expr);
										if (size != NULL) {
											_tmp62_ = vala_collection_get_size ((ValaCollection*) size) >= dim;
										} else {
											_tmp62_ = FALSE;
										}
										if (_tmp62_) {
											result = (ValaCCodeExpression*) vala_list_get (size, dim - 1);
											_vala_iterable_unref0 (size);
											_vala_code_node_unref0 (prop);
											_vala_code_node_unref0 (array_type);
											return result;
										}
										_vala_iterable_unref0 (size);
									}
									_vala_code_node_unref0 (prop);
								}
							}
						}
					}
				}
			} else {
				if (VALA_IS_NULL_LITERAL (array_expr)) {
					result = (ValaCCodeExpression*) vala_ccode_constant_new ("0");
					_vala_code_node_unref0 (array_type);
					return result;
				}
			}
		}
	}
	if (!is_out) {
		result = (ValaCCodeExpression*) vala_ccode_constant_new ("-1");
		_vala_code_node_unref0 (array_type);
		return result;
	} else {
		result = (ValaCCodeExpression*) vala_ccode_constant_new ("NULL");
		_vala_code_node_unref0 (array_type);
		return result;
	}
	_vala_code_node_unref0 (array_type);
}


static char* vala_ccode_array_module_real_get_array_size_cname (ValaCCodeBaseModule* base, const char* array_cname) {
	ValaCCodeArrayModule * self;
	char* result = NULL;
	self = (ValaCCodeArrayModule*) base;
	g_return_val_if_fail (array_cname != NULL, NULL);
	result = g_strdup_printf ("_%s_size_", array_cname);
	return result;
}


static ValaCCodeExpression* vala_ccode_array_module_real_get_array_size_cexpression (ValaCCodeBaseModule* base, ValaExpression* array_expr) {
	ValaCCodeArrayModule * self;
	ValaCCodeExpression* result = NULL;
	self = (ValaCCodeArrayModule*) base;
	g_return_val_if_fail (array_expr != NULL, NULL);
	if (VALA_IS_LOCAL_VARIABLE (vala_expression_get_symbol_reference (array_expr))) {
		ValaLocalVariable* local;
		local = _vala_code_node_ref0 (VALA_LOCAL_VARIABLE (vala_expression_get_symbol_reference (array_expr)));
		if (vala_local_variable_get_captured (local)) {
			ValaBlock* block;
			char* _tmp0_;
			ValaCCodeExpression* _tmp1_;
			char* _tmp2_;
			char* _tmp3_;
			ValaCCodeExpression* _tmp4_;
			block = _vala_code_node_ref0 (VALA_BLOCK (vala_symbol_get_parent_symbol ((ValaSymbol*) local)));
			result = (_tmp4_ = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer (_tmp1_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp0_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, block))), _tmp3_ = vala_ccode_base_module_get_array_size_cname ((ValaCCodeBaseModule*) self, _tmp2_ = vala_ccode_base_module_get_variable_cname ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) local)))), _g_free0 (_tmp3_), _g_free0 (_tmp2_), _vala_ccode_node_unref0 (_tmp1_), _g_free0 (_tmp0_), _tmp4_);
			_vala_code_node_unref0 (block);
			_vala_code_node_unref0 (local);
			return result;
		} else {
			char* _tmp5_;
			char* _tmp6_;
			ValaCCodeExpression* _tmp7_;
			ValaCCodeExpression* size_expr;
			size_expr = (_tmp7_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp6_ = vala_ccode_base_module_get_array_size_cname ((ValaCCodeBaseModule*) self, _tmp5_ = vala_ccode_base_module_get_variable_cname ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) local)))), _g_free0 (_tmp6_), _g_free0 (_tmp5_), _tmp7_);
			result = size_expr;
			_vala_code_node_unref0 (local);
			return result;
		}
		_vala_code_node_unref0 (local);
	} else {
		if (VALA_IS_FIELD (vala_expression_get_symbol_reference (array_expr))) {
			ValaField* field;
			ValaMemberAccess* ma;
			ValaCCodeExpression* size_expr;
			field = _vala_code_node_ref0 (VALA_FIELD (vala_expression_get_symbol_reference (array_expr)));
			ma = _vala_code_node_ref0 (VALA_MEMBER_ACCESS (array_expr));
			size_expr = NULL;
			if (vala_field_get_binding (field) == MEMBER_BINDING_INSTANCE) {
				ValaSymbol* _tmp8_;
				ValaClass* cl;
				gboolean _tmp9_ = FALSE;
				gboolean is_gtypeinstance;
				char* size_cname;
				ValaCCodeExpression* typed_inst;
				ValaCCodeExpression* inst;
				gboolean _tmp10_ = FALSE;
				cl = _vala_code_node_ref0 ((_tmp8_ = vala_symbol_get_parent_symbol ((ValaSymbol*) field), VALA_IS_CLASS (_tmp8_) ? ((ValaClass*) _tmp8_) : NULL));
				if (cl != NULL) {
					_tmp9_ = !vala_class_get_is_compact (cl);
				} else {
					_tmp9_ = FALSE;
				}
				is_gtypeinstance = _tmp9_;
				size_cname = vala_ccode_base_module_get_array_size_cname ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) field));
				typed_inst = VALA_CCODE_EXPRESSION (vala_ccode_base_module_get_ccodenode ((ValaCCodeBaseModule*) self, (ValaCodeNode*) vala_member_access_get_inner (ma)));
				inst = NULL;
				if (is_gtypeinstance) {
					_tmp10_ = vala_symbol_get_access ((ValaSymbol*) field) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
				} else {
					_tmp10_ = FALSE;
				}
				if (_tmp10_) {
					ValaCCodeExpression* _tmp11_;
					inst = (_tmp11_ = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer (typed_inst, "priv"), _vala_ccode_node_unref0 (inst), _tmp11_);
				} else {
					ValaCCodeExpression* _tmp12_;
					inst = (_tmp12_ = _vala_ccode_node_ref0 (typed_inst), _vala_ccode_node_unref0 (inst), _tmp12_);
				}
				if (vala_typesymbol_is_reference_type (VALA_TYPESYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) field)))) {
					ValaCCodeExpression* _tmp13_;
					size_expr = (_tmp13_ = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer (inst, size_cname), _vala_ccode_node_unref0 (size_expr), _tmp13_);
				} else {
					ValaCCodeExpression* _tmp14_;
					size_expr = (_tmp14_ = (ValaCCodeExpression*) vala_ccode_member_access_new (inst, size_cname, FALSE), _vala_ccode_node_unref0 (size_expr), _tmp14_);
				}
				_vala_ccode_node_unref0 (inst);
				_vala_ccode_node_unref0 (typed_inst);
				_g_free0 (size_cname);
				_vala_code_node_unref0 (cl);
			} else {
				char* _tmp15_;
				char* _tmp16_;
				ValaCCodeExpression* _tmp17_;
				size_expr = (_tmp17_ = (ValaCCodeExpression*) vala_ccode_identifier_new (_tmp16_ = vala_ccode_base_module_get_array_size_cname ((ValaCCodeBaseModule*) self, _tmp15_ = vala_field_get_cname (field))), _vala_ccode_node_unref0 (size_expr), _tmp17_);
				_g_free0 (_tmp16_);
				_g_free0 (_tmp15_);
			}
			result = size_expr;
			_vala_code_node_unref0 (ma);
			_vala_code_node_unref0 (field);
			return result;
		}
	}
	g_assert_not_reached ();
}


static void vala_ccode_array_module_real_visit_element_access (ValaCodeVisitor* base, ValaElementAccess* expr) {
	ValaCCodeArrayModule * self;
	ValaList* indices;
	gint rank;
	ValaCCodeExpression* ccontainer;
	ValaExpression* _tmp0_;
	ValaCCodeExpression* _tmp1_;
	ValaCCodeExpression* cindex;
	self = (ValaCCodeArrayModule*) base;
	g_return_if_fail (expr != NULL);
	indices = vala_element_access_get_indices (expr);
	rank = vala_collection_get_size ((ValaCollection*) indices);
	ccontainer = _vala_ccode_node_ref0 (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_element_access_get_container (expr))));
	cindex = (_tmp1_ = _vala_ccode_node_ref0 (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) (_tmp0_ = (ValaExpression*) vala_list_get (indices, 0))))), _vala_code_node_unref0 (_tmp0_), _tmp1_);
	if (VALA_IS_ARRAY_LENGTH_FIELD (vala_expression_get_symbol_reference (vala_element_access_get_container (expr)))) {
		ValaExpression* _tmp2_;
		ValaIntegerLiteral* lit;
		ValaExpression* _tmp3_;
		ValaMemberAccess* memberaccess;
		gboolean _tmp4_ = FALSE;
		lit = (_tmp2_ = (ValaExpression*) vala_list_get (indices, 0), VALA_IS_INTEGER_LITERAL (_tmp2_) ? ((ValaIntegerLiteral*) _tmp2_) : NULL);
		memberaccess = _vala_code_node_ref0 ((_tmp3_ = vala_element_access_get_container (expr), VALA_IS_MEMBER_ACCESS (_tmp3_) ? ((ValaMemberAccess*) _tmp3_) : NULL));
		if (lit != NULL) {
			_tmp4_ = memberaccess != NULL;
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			gint dim;
			ValaCCodeExpression* _tmp5_;
			dim = atoi (vala_integer_literal_get_value (lit));
			vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp5_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, vala_member_access_get_inner (memberaccess), dim + 1)));
			_vala_ccode_node_unref0 (_tmp5_);
		} else {
			vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) expr), "only integer literals supported as index");
		}
		_vala_code_node_unref0 (memberaccess);
		_vala_code_node_unref0 (lit);
	} else {
		ValaCCodeElementAccess* _tmp11_;
		{
			gint i;
			i = 1;
			{
				gboolean _tmp6_;
				_tmp6_ = TRUE;
				while (TRUE) {
					ValaCCodeExpression* _tmp7_;
					ValaCCodeBinaryExpression* _tmp8_;
					ValaCCodeBinaryExpression* cmul;
					ValaExpression* _tmp9_;
					ValaCCodeExpression* _tmp10_;
					if (!_tmp6_) {
						i++;
					}
					_tmp6_ = FALSE;
					if (!(i < rank)) {
						break;
					}
					cmul = (_tmp8_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, cindex, _tmp7_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, vala_element_access_get_container (expr), i + 1)), _vala_ccode_node_unref0 (_tmp7_), _tmp8_);
					cindex = (_tmp10_ = (ValaCCodeExpression*) vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) cmul, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) (_tmp9_ = (ValaExpression*) vala_list_get (indices, i))))), _vala_ccode_node_unref0 (cindex), _tmp10_);
					_vala_code_node_unref0 (_tmp9_);
					_vala_ccode_node_unref0 (cmul);
				}
			}
		}
		vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp11_ = vala_ccode_element_access_new (ccontainer, cindex)));
		_vala_ccode_node_unref0 (_tmp11_);
	}
	_vala_ccode_node_unref0 (cindex);
	_vala_ccode_node_unref0 (ccontainer);
	_vala_iterable_unref0 (indices);
}


static void vala_ccode_array_module_real_visit_slice_expression (ValaCodeVisitor* base, ValaSliceExpression* expr) {
	ValaCCodeArrayModule * self;
	ValaCCodeExpression* ccontainer;
	ValaCCodeExpression* cstart;
	ValaCCodeExpression* cstop;
	ValaCCodeCommaExpression* ccomma;
	ValaLocalVariable* len_var;
	ValaLocalVariable* slice_var;
	ValaCCodeBinaryExpression* cstartpointer;
	ValaCCodeExpression* _tmp3_;
	ValaCCodeAssignment* _tmp4_;
	ValaCCodeAssignment* slice_assignment;
	ValaCCodeBinaryExpression* splicelen;
	ValaCCodeExpression* _tmp5_;
	ValaCCodeAssignment* _tmp6_;
	ValaCCodeAssignment* len_assignment;
	ValaCCodeExpression* _tmp7_;
	ValaCCodeExpression* _tmp8_;
	self = (ValaCCodeArrayModule*) base;
	g_return_if_fail (expr != NULL);
	ccontainer = _vala_ccode_node_ref0 (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_slice_expression_get_container (expr))));
	cstart = _vala_ccode_node_ref0 (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_slice_expression_get_start (expr))));
	cstop = _vala_ccode_node_ref0 (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_slice_expression_get_stop (expr))));
	ccomma = vala_ccode_comma_expression_new ();
	len_var = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, ((ValaCCodeBaseModule*) self)->int_type, TRUE, NULL, TRUE);
	vala_code_node_set_source_reference ((ValaCodeNode*) len_var, vala_code_node_get_source_reference ((ValaCodeNode*) expr));
	vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, len_var);
	slice_var = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, vala_expression_get_value_type ((ValaExpression*) expr), TRUE, (ValaCodeNode*) expr, TRUE);
	vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, slice_var);
	if (!vala_ccode_base_module_is_pure_ccode_expression ((ValaCCodeBaseModule*) self, cstart)) {
		ValaLocalVariable* start_var;
		ValaCCodeExpression* _tmp0_;
		ValaCCodeAssignment* _tmp1_;
		ValaCCodeAssignment* start_assignment;
		ValaCCodeExpression* _tmp2_;
		start_var = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, ((ValaCCodeBaseModule*) self)->int_type, TRUE, NULL, TRUE);
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, start_var);
		start_assignment = (_tmp1_ = vala_ccode_assignment_new (_tmp0_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) start_var)), cstart, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), _vala_ccode_node_unref0 (_tmp0_), _tmp1_);
		vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) start_assignment);
		cstart = (_tmp2_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) start_var)), _vala_ccode_node_unref0 (cstart), _tmp2_);
		_vala_ccode_node_unref0 (start_assignment);
		_vala_code_node_unref0 (start_var);
	}
	cstartpointer = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, ccontainer, cstart);
	slice_assignment = (_tmp4_ = vala_ccode_assignment_new (_tmp3_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) slice_var)), (ValaCCodeExpression*) cstartpointer, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), _vala_ccode_node_unref0 (_tmp3_), _tmp4_);
	vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) slice_assignment);
	splicelen = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, cstop, cstart);
	len_assignment = (_tmp6_ = vala_ccode_assignment_new (_tmp5_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) len_var)), (ValaCCodeExpression*) splicelen, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), _vala_ccode_node_unref0 (_tmp5_), _tmp6_);
	vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) len_assignment);
	vala_ccode_comma_expression_append_expression (ccomma, _tmp7_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) slice_var)));
	_vala_ccode_node_unref0 (_tmp7_);
	vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccomma);
	vala_expression_append_array_size ((ValaExpression*) expr, _tmp8_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) len_var)));
	_vala_ccode_node_unref0 (_tmp8_);
	_vala_ccode_node_unref0 (len_assignment);
	_vala_ccode_node_unref0 (splicelen);
	_vala_ccode_node_unref0 (slice_assignment);
	_vala_ccode_node_unref0 (cstartpointer);
	_vala_code_node_unref0 (slice_var);
	_vala_code_node_unref0 (len_var);
	_vala_ccode_node_unref0 (ccomma);
	_vala_ccode_node_unref0 (cstop);
	_vala_ccode_node_unref0 (cstart);
	_vala_ccode_node_unref0 (ccontainer);
}


static ValaCCodeForStatement* vala_ccode_array_module_get_struct_array_free_loop (ValaCCodeArrayModule* self, ValaStruct* st) {
	ValaCCodeForStatement* result = NULL;
	ValaCCodeBlock* cbody;
	ValaCCodeIdentifier* cptrarray;
	ValaCCodeIdentifier* _tmp0_;
	ValaCCodeElementAccess* _tmp1_;
	ValaCCodeElementAccess* cea;
	ValaStructValueType* _tmp2_;
	ValaCCodeExpression* _tmp3_;
	ValaCCodeFunctionCall* _tmp4_;
	ValaCCodeFunctionCall* cfreecall;
	ValaCCodeUnaryExpression* _tmp5_;
	ValaCCodeIdentifier* _tmp6_;
	ValaCCodeIdentifier* _tmp7_;
	ValaCCodeBinaryExpression* _tmp8_;
	ValaCCodeBinaryExpression* cforcond;
	ValaCCodeExpressionStatement* _tmp9_;
	ValaCCodeForStatement* cfor;
	ValaCCodeIdentifier* _tmp10_;
	ValaCCodeConstant* _tmp11_;
	ValaCCodeAssignment* _tmp12_;
	ValaCCodeIdentifier* _tmp13_;
	ValaCCodeIdentifier* _tmp14_;
	ValaCCodeConstant* _tmp15_;
	ValaCCodeBinaryExpression* _tmp16_;
	ValaCCodeAssignment* _tmp17_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (st != NULL, NULL);
	cbody = vala_ccode_block_new ();
	cptrarray = vala_ccode_identifier_new ("array");
	cea = (_tmp1_ = vala_ccode_element_access_new ((ValaCCodeExpression*) cptrarray, (ValaCCodeExpression*) (_tmp0_ = vala_ccode_identifier_new ("i"))), _vala_ccode_node_unref0 (_tmp0_), _tmp1_);
	cfreecall = (_tmp4_ = vala_ccode_function_call_new (_tmp3_ = vala_ccode_base_module_get_destroy_func_expression ((ValaCCodeBaseModule*) self, (ValaDataType*) (_tmp2_ = vala_struct_value_type_new (st)), FALSE)), _vala_ccode_node_unref0 (_tmp3_), _vala_code_node_unref0 (_tmp2_), _tmp4_);
	vala_ccode_function_call_add_argument (cfreecall, (ValaCCodeExpression*) (_tmp5_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) cea)));
	_vala_ccode_node_unref0 (_tmp5_);
	cforcond = (_tmp8_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_LESS_THAN, (ValaCCodeExpression*) (_tmp6_ = vala_ccode_identifier_new ("i")), (ValaCCodeExpression*) (_tmp7_ = vala_ccode_identifier_new ("array_length"))), _vala_ccode_node_unref0 (_tmp7_), _vala_ccode_node_unref0 (_tmp6_), _tmp8_);
	vala_ccode_block_add_statement (cbody, (ValaCCodeNode*) (_tmp9_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cfreecall)));
	_vala_ccode_node_unref0 (_tmp9_);
	cfor = vala_ccode_for_statement_new ((ValaCCodeExpression*) cforcond, (ValaCCodeStatement*) cbody);
	vala_ccode_for_statement_add_initializer (cfor, (ValaCCodeExpression*) (_tmp12_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp10_ = vala_ccode_identifier_new ("i")), (ValaCCodeExpression*) (_tmp11_ = vala_ccode_constant_new ("0")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
	_vala_ccode_node_unref0 (_tmp12_);
	_vala_ccode_node_unref0 (_tmp11_);
	_vala_ccode_node_unref0 (_tmp10_);
	vala_ccode_for_statement_add_iterator (cfor, (ValaCCodeExpression*) (_tmp17_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp13_ = vala_ccode_identifier_new ("i")), (ValaCCodeExpression*) (_tmp16_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) (_tmp14_ = vala_ccode_identifier_new ("i")), (ValaCCodeExpression*) (_tmp15_ = vala_ccode_constant_new ("1")))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
	_vala_ccode_node_unref0 (_tmp17_);
	_vala_ccode_node_unref0 (_tmp16_);
	_vala_ccode_node_unref0 (_tmp15_);
	_vala_ccode_node_unref0 (_tmp14_);
	_vala_ccode_node_unref0 (_tmp13_);
	result = cfor;
	_vala_ccode_node_unref0 (cforcond);
	_vala_ccode_node_unref0 (cfreecall);
	_vala_ccode_node_unref0 (cea);
	_vala_ccode_node_unref0 (cptrarray);
	_vala_ccode_node_unref0 (cbody);
	return result;
}


static char* vala_ccode_array_module_real_append_struct_array_free (ValaCCodeBaseModule* base, ValaStruct* st) {
	ValaCCodeArrayModule * self;
	char* result = NULL;
	char* _tmp0_;
	char* _tmp1_;
	char* cname;
	ValaCCodeFunction* fun;
	char* _tmp2_;
	char* _tmp3_;
	ValaCCodeFormalParameter* _tmp4_;
	ValaCCodeFormalParameter* _tmp5_;
	ValaCCodeBlock* cdofree;
	ValaCCodeDeclaration* citdecl;
	ValaCCodeVariableDeclarator* _tmp6_;
	ValaCCodeForStatement* _tmp7_;
	ValaCCodeIdentifier* _tmp8_;
	ValaCCodeConstant* _tmp9_;
	ValaCCodeBinaryExpression* _tmp10_;
	ValaCCodeBinaryExpression* ccondarr;
	ValaCCodeIfStatement* cif;
	ValaCCodeBlock* _tmp11_;
	ValaCCodeIdentifier* _tmp12_;
	ValaCCodeFunctionCall* _tmp13_;
	ValaCCodeFunctionCall* carrfree;
	ValaCCodeIdentifier* _tmp14_;
	ValaCCodeExpressionStatement* _tmp15_;
	self = (ValaCCodeArrayModule*) base;
	g_return_val_if_fail (st != NULL, NULL);
	cname = (_tmp1_ = g_strdup_printf ("_vala_%s_array_free", _tmp0_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) st, FALSE)), _g_free0 (_tmp0_), _tmp1_);
	if (vala_ccode_file_add_declaration (((ValaCCodeBaseModule*) self)->cfile, cname)) {
		result = cname;
		return result;
	}
	fun = vala_ccode_function_new (cname, "void");
	vala_ccode_function_set_modifiers (fun, VALA_CCODE_MODIFIERS_STATIC);
	vala_ccode_function_add_parameter (fun, _tmp4_ = vala_ccode_formal_parameter_new ("array", _tmp3_ = g_strdup_printf ("%s*", _tmp2_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) st, FALSE))));
	_vala_ccode_node_unref0 (_tmp4_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp2_);
	vala_ccode_function_add_parameter (fun, _tmp5_ = vala_ccode_formal_parameter_new ("array_length", "gint"));
	_vala_ccode_node_unref0 (_tmp5_);
	vala_ccode_file_add_function_declaration (((ValaCCodeBaseModule*) self)->cfile, fun);
	cdofree = vala_ccode_block_new ();
	citdecl = vala_ccode_declaration_new ("int");
	vala_ccode_declaration_add_declarator (citdecl, (ValaCCodeDeclarator*) (_tmp6_ = vala_ccode_variable_declarator_new ("i", NULL, NULL)));
	_vala_ccode_node_unref0 (_tmp6_);
	vala_ccode_block_add_statement (cdofree, (ValaCCodeNode*) citdecl);
	vala_ccode_block_add_statement (cdofree, (ValaCCodeNode*) (_tmp7_ = vala_ccode_array_module_get_struct_array_free_loop (self, st)));
	_vala_ccode_node_unref0 (_tmp7_);
	ccondarr = (_tmp10_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, (ValaCCodeExpression*) (_tmp8_ = vala_ccode_identifier_new ("array")), (ValaCCodeExpression*) (_tmp9_ = vala_ccode_constant_new ("NULL"))), _vala_ccode_node_unref0 (_tmp9_), _vala_ccode_node_unref0 (_tmp8_), _tmp10_);
	cif = vala_ccode_if_statement_new ((ValaCCodeExpression*) ccondarr, (ValaCCodeStatement*) cdofree, NULL);
	vala_ccode_function_set_block (fun, _tmp11_ = vala_ccode_block_new ());
	_vala_ccode_node_unref0 (_tmp11_);
	vala_ccode_block_add_statement (vala_ccode_function_get_block (fun), (ValaCCodeNode*) cif);
	carrfree = (_tmp13_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp12_ = vala_ccode_identifier_new ("g_free"))), _vala_ccode_node_unref0 (_tmp12_), _tmp13_);
	vala_ccode_function_call_add_argument (carrfree, (ValaCCodeExpression*) (_tmp14_ = vala_ccode_identifier_new ("array")));
	_vala_ccode_node_unref0 (_tmp14_);
	vala_ccode_block_add_statement (vala_ccode_function_get_block (fun), (ValaCCodeNode*) (_tmp15_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) carrfree)));
	_vala_ccode_node_unref0 (_tmp15_);
	vala_ccode_file_add_function (((ValaCCodeBaseModule*) self)->cfile, fun);
	result = cname;
	_vala_ccode_node_unref0 (carrfree);
	_vala_ccode_node_unref0 (cif);
	_vala_ccode_node_unref0 (ccondarr);
	_vala_ccode_node_unref0 (citdecl);
	_vala_ccode_node_unref0 (cdofree);
	_vala_ccode_node_unref0 (fun);
	return result;
}


static ValaCCodeForStatement* vala_ccode_array_module_get_vala_array_free_loop (ValaCCodeArrayModule* self) {
	ValaCCodeForStatement* result = NULL;
	ValaCCodeBlock* cbody;
	ValaCCodeIdentifier* _tmp0_;
	ValaCCodeCastExpression* _tmp1_;
	ValaCCodeCastExpression* cptrarray;
	ValaCCodeIdentifier* _tmp2_;
	ValaCCodeElementAccess* _tmp3_;
	ValaCCodeElementAccess* cea;
	ValaCCodeIdentifier* _tmp4_;
	ValaCCodeFunctionCall* _tmp5_;
	ValaCCodeFunctionCall* cfreecall;
	ValaCCodeConstant* _tmp6_;
	ValaCCodeBinaryExpression* _tmp7_;
	ValaCCodeBinaryExpression* cfreecond;
	ValaCCodeIdentifier* _tmp8_;
	ValaCCodeIdentifier* _tmp9_;
	ValaCCodeBinaryExpression* _tmp10_;
	ValaCCodeBinaryExpression* cforcond;
	ValaCCodeBlock* cfreeblock;
	ValaCCodeExpressionStatement* _tmp11_;
	ValaCCodeIfStatement* _tmp12_;
	ValaCCodeForStatement* cfor;
	ValaCCodeIdentifier* _tmp13_;
	ValaCCodeConstant* _tmp14_;
	ValaCCodeAssignment* _tmp15_;
	ValaCCodeIdentifier* _tmp16_;
	ValaCCodeIdentifier* _tmp17_;
	ValaCCodeConstant* _tmp18_;
	ValaCCodeBinaryExpression* _tmp19_;
	ValaCCodeAssignment* _tmp20_;
	g_return_val_if_fail (self != NULL, NULL);
	cbody = vala_ccode_block_new ();
	cptrarray = (_tmp1_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) (_tmp0_ = vala_ccode_identifier_new ("array")), "gpointer*"), _vala_ccode_node_unref0 (_tmp0_), _tmp1_);
	cea = (_tmp3_ = vala_ccode_element_access_new ((ValaCCodeExpression*) cptrarray, (ValaCCodeExpression*) (_tmp2_ = vala_ccode_identifier_new ("i"))), _vala_ccode_node_unref0 (_tmp2_), _tmp3_);
	cfreecall = (_tmp5_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp4_ = vala_ccode_identifier_new ("destroy_func"))), _vala_ccode_node_unref0 (_tmp4_), _tmp5_);
	vala_ccode_function_call_add_argument (cfreecall, (ValaCCodeExpression*) cea);
	cfreecond = (_tmp7_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, (ValaCCodeExpression*) cea, (ValaCCodeExpression*) (_tmp6_ = vala_ccode_constant_new ("NULL"))), _vala_ccode_node_unref0 (_tmp6_), _tmp7_);
	cforcond = (_tmp10_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_LESS_THAN, (ValaCCodeExpression*) (_tmp8_ = vala_ccode_identifier_new ("i")), (ValaCCodeExpression*) (_tmp9_ = vala_ccode_identifier_new ("array_length"))), _vala_ccode_node_unref0 (_tmp9_), _vala_ccode_node_unref0 (_tmp8_), _tmp10_);
	cfreeblock = vala_ccode_block_new ();
	vala_ccode_block_add_statement (cfreeblock, (ValaCCodeNode*) (_tmp11_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cfreecall)));
	_vala_ccode_node_unref0 (_tmp11_);
	vala_ccode_block_add_statement (cbody, (ValaCCodeNode*) (_tmp12_ = vala_ccode_if_statement_new ((ValaCCodeExpression*) cfreecond, (ValaCCodeStatement*) cfreeblock, NULL)));
	_vala_ccode_node_unref0 (_tmp12_);
	cfor = vala_ccode_for_statement_new ((ValaCCodeExpression*) cforcond, (ValaCCodeStatement*) cbody);
	vala_ccode_for_statement_add_initializer (cfor, (ValaCCodeExpression*) (_tmp15_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp13_ = vala_ccode_identifier_new ("i")), (ValaCCodeExpression*) (_tmp14_ = vala_ccode_constant_new ("0")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
	_vala_ccode_node_unref0 (_tmp15_);
	_vala_ccode_node_unref0 (_tmp14_);
	_vala_ccode_node_unref0 (_tmp13_);
	vala_ccode_for_statement_add_iterator (cfor, (ValaCCodeExpression*) (_tmp20_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp16_ = vala_ccode_identifier_new ("i")), (ValaCCodeExpression*) (_tmp19_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) (_tmp17_ = vala_ccode_identifier_new ("i")), (ValaCCodeExpression*) (_tmp18_ = vala_ccode_constant_new ("1")))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
	_vala_ccode_node_unref0 (_tmp20_);
	_vala_ccode_node_unref0 (_tmp19_);
	_vala_ccode_node_unref0 (_tmp18_);
	_vala_ccode_node_unref0 (_tmp17_);
	_vala_ccode_node_unref0 (_tmp16_);
	result = cfor;
	_vala_ccode_node_unref0 (cfreeblock);
	_vala_ccode_node_unref0 (cforcond);
	_vala_ccode_node_unref0 (cfreecond);
	_vala_ccode_node_unref0 (cfreecall);
	_vala_ccode_node_unref0 (cea);
	_vala_ccode_node_unref0 (cptrarray);
	_vala_ccode_node_unref0 (cbody);
	return result;
}


static void vala_ccode_array_module_real_append_vala_array_free (ValaCCodeBaseModule* base) {
	ValaCCodeArrayModule * self;
	ValaCCodeFunction* fun;
	ValaCCodeFormalParameter* _tmp0_;
	ValaCCodeFormalParameter* _tmp1_;
	ValaCCodeFormalParameter* _tmp2_;
	ValaCCodeBlock* cdofree;
	ValaCCodeDeclaration* citdecl;
	ValaCCodeVariableDeclarator* _tmp3_;
	ValaCCodeForStatement* _tmp4_;
	ValaCCodeIdentifier* _tmp5_;
	ValaCCodeConstant* _tmp6_;
	ValaCCodeBinaryExpression* _tmp7_;
	ValaCCodeBinaryExpression* ccondarr;
	ValaCCodeIdentifier* _tmp8_;
	ValaCCodeConstant* _tmp9_;
	ValaCCodeBinaryExpression* _tmp10_;
	ValaCCodeBinaryExpression* ccondfunc;
	ValaCCodeBinaryExpression* _tmp11_;
	ValaCCodeIfStatement* _tmp12_;
	ValaCCodeIfStatement* cif;
	ValaCCodeBlock* _tmp13_;
	ValaCCodeFunction* _tmp14_;
	ValaCCodeFormalParameter* _tmp15_;
	ValaCCodeFormalParameter* _tmp16_;
	ValaCCodeFormalParameter* _tmp17_;
	ValaCCodeIdentifier* _tmp18_;
	ValaCCodeFunctionCall* _tmp19_;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* _tmp20_;
	ValaCCodeIdentifier* _tmp21_;
	ValaCCodeIdentifier* _tmp22_;
	ValaCCodeBlock* _tmp23_;
	ValaCCodeExpressionStatement* _tmp24_;
	ValaCCodeIdentifier* _tmp25_;
	ValaCCodeFunctionCall* _tmp26_;
	ValaCCodeFunctionCall* carrfree;
	ValaCCodeIdentifier* _tmp27_;
	ValaCCodeExpressionStatement* _tmp28_;
	self = (ValaCCodeArrayModule*) base;
	fun = vala_ccode_function_new ("_vala_array_destroy", "void");
	vala_ccode_function_set_modifiers (fun, VALA_CCODE_MODIFIERS_STATIC);
	vala_ccode_function_add_parameter (fun, _tmp0_ = vala_ccode_formal_parameter_new ("array", "gpointer"));
	_vala_ccode_node_unref0 (_tmp0_);
	vala_ccode_function_add_parameter (fun, _tmp1_ = vala_ccode_formal_parameter_new ("array_length", "gint"));
	_vala_ccode_node_unref0 (_tmp1_);
	vala_ccode_function_add_parameter (fun, _tmp2_ = vala_ccode_formal_parameter_new ("destroy_func", "GDestroyNotify"));
	_vala_ccode_node_unref0 (_tmp2_);
	vala_ccode_file_add_function_declaration (((ValaCCodeBaseModule*) self)->cfile, fun);
	cdofree = vala_ccode_block_new ();
	citdecl = vala_ccode_declaration_new ("int");
	vala_ccode_declaration_add_declarator (citdecl, (ValaCCodeDeclarator*) (_tmp3_ = vala_ccode_variable_declarator_new ("i", NULL, NULL)));
	_vala_ccode_node_unref0 (_tmp3_);
	vala_ccode_block_add_statement (cdofree, (ValaCCodeNode*) citdecl);
	vala_ccode_block_add_statement (cdofree, (ValaCCodeNode*) (_tmp4_ = vala_ccode_array_module_get_vala_array_free_loop (self)));
	_vala_ccode_node_unref0 (_tmp4_);
	ccondarr = (_tmp7_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, (ValaCCodeExpression*) (_tmp5_ = vala_ccode_identifier_new ("array")), (ValaCCodeExpression*) (_tmp6_ = vala_ccode_constant_new ("NULL"))), _vala_ccode_node_unref0 (_tmp6_), _vala_ccode_node_unref0 (_tmp5_), _tmp7_);
	ccondfunc = (_tmp10_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, (ValaCCodeExpression*) (_tmp8_ = vala_ccode_identifier_new ("destroy_func")), (ValaCCodeExpression*) (_tmp9_ = vala_ccode_constant_new ("NULL"))), _vala_ccode_node_unref0 (_tmp9_), _vala_ccode_node_unref0 (_tmp8_), _tmp10_);
	cif = (_tmp12_ = vala_ccode_if_statement_new ((ValaCCodeExpression*) (_tmp11_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_AND, (ValaCCodeExpression*) ccondarr, (ValaCCodeExpression*) ccondfunc)), (ValaCCodeStatement*) cdofree, NULL), _vala_ccode_node_unref0 (_tmp11_), _tmp12_);
	vala_ccode_function_set_block (fun, _tmp13_ = vala_ccode_block_new ());
	_vala_ccode_node_unref0 (_tmp13_);
	vala_ccode_block_add_statement (vala_ccode_function_get_block (fun), (ValaCCodeNode*) cif);
	vala_ccode_file_add_function (((ValaCCodeBaseModule*) self)->cfile, fun);
	fun = (_tmp14_ = vala_ccode_function_new ("_vala_array_free", "void"), _vala_ccode_node_unref0 (fun), _tmp14_);
	vala_ccode_function_set_modifiers (fun, VALA_CCODE_MODIFIERS_STATIC);
	vala_ccode_function_add_parameter (fun, _tmp15_ = vala_ccode_formal_parameter_new ("array", "gpointer"));
	_vala_ccode_node_unref0 (_tmp15_);
	vala_ccode_function_add_parameter (fun, _tmp16_ = vala_ccode_formal_parameter_new ("array_length", "gint"));
	_vala_ccode_node_unref0 (_tmp16_);
	vala_ccode_function_add_parameter (fun, _tmp17_ = vala_ccode_formal_parameter_new ("destroy_func", "GDestroyNotify"));
	_vala_ccode_node_unref0 (_tmp17_);
	vala_ccode_file_add_function_declaration (((ValaCCodeBaseModule*) self)->cfile, fun);
	ccall = (_tmp19_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp18_ = vala_ccode_identifier_new ("_vala_array_destroy"))), _vala_ccode_node_unref0 (_tmp18_), _tmp19_);
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp20_ = vala_ccode_identifier_new ("array")));
	_vala_ccode_node_unref0 (_tmp20_);
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp21_ = vala_ccode_identifier_new ("array_length")));
	_vala_ccode_node_unref0 (_tmp21_);
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp22_ = vala_ccode_identifier_new ("destroy_func")));
	_vala_ccode_node_unref0 (_tmp22_);
	vala_ccode_function_set_block (fun, _tmp23_ = vala_ccode_block_new ());
	_vala_ccode_node_unref0 (_tmp23_);
	vala_ccode_block_add_statement (vala_ccode_function_get_block (fun), (ValaCCodeNode*) (_tmp24_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
	_vala_ccode_node_unref0 (_tmp24_);
	carrfree = (_tmp26_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp25_ = vala_ccode_identifier_new ("g_free"))), _vala_ccode_node_unref0 (_tmp25_), _tmp26_);
	vala_ccode_function_call_add_argument (carrfree, (ValaCCodeExpression*) (_tmp27_ = vala_ccode_identifier_new ("array")));
	_vala_ccode_node_unref0 (_tmp27_);
	vala_ccode_block_add_statement (vala_ccode_function_get_block (fun), (ValaCCodeNode*) (_tmp28_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) carrfree)));
	_vala_ccode_node_unref0 (_tmp28_);
	vala_ccode_file_add_function (((ValaCCodeBaseModule*) self)->cfile, fun);
	_vala_ccode_node_unref0 (carrfree);
	_vala_ccode_node_unref0 (ccall);
	_vala_ccode_node_unref0 (cif);
	_vala_ccode_node_unref0 (ccondfunc);
	_vala_ccode_node_unref0 (ccondarr);
	_vala_ccode_node_unref0 (citdecl);
	_vala_ccode_node_unref0 (cdofree);
	_vala_ccode_node_unref0 (fun);
}


static void vala_ccode_array_module_real_append_vala_array_move (ValaCCodeBaseModule* base) {
	ValaCCodeArrayModule * self;
	ValaCCodeFunction* fun;
	ValaCCodeFormalParameter* _tmp0_;
	ValaCCodeFormalParameter* _tmp1_;
	ValaCCodeFormalParameter* _tmp2_;
	ValaCCodeFormalParameter* _tmp3_;
	ValaCCodeFormalParameter* _tmp4_;
	ValaCCodeIdentifier* _tmp5_;
	ValaCCodeCastExpression* _tmp6_;
	ValaCCodeCastExpression* array;
	ValaCCodeIdentifier* element_size;
	ValaCCodeIdentifier* length;
	ValaCCodeIdentifier* src;
	ValaCCodeIdentifier* dest;
	ValaCCodeBinaryExpression* _tmp7_;
	ValaCCodeBinaryExpression* _tmp8_;
	ValaCCodeBinaryExpression* src_address;
	ValaCCodeBinaryExpression* _tmp9_;
	ValaCCodeBinaryExpression* _tmp10_;
	ValaCCodeBinaryExpression* dest_address;
	ValaCCodeBinaryExpression* _tmp11_;
	ValaCCodeBinaryExpression* _tmp12_;
	ValaCCodeBinaryExpression* _tmp13_;
	ValaCCodeBinaryExpression* dest_end_address;
	ValaCCodeBlock* _tmp14_;
	ValaCCodeIdentifier* _tmp15_;
	ValaCCodeFunctionCall* _tmp16_;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeBinaryExpression* _tmp17_;
	ValaCCodeExpressionStatement* _tmp18_;
	ValaCCodeIdentifier* _tmp19_;
	ValaCCodeFunctionCall* _tmp20_;
	ValaCCodeFunctionCall* czero1;
	ValaCCodeConstant* _tmp21_;
	ValaCCodeBinaryExpression* _tmp22_;
	ValaCCodeBinaryExpression* _tmp23_;
	ValaCCodeBlock* czeroblock1;
	ValaCCodeExpressionStatement* _tmp24_;
	ValaCCodeIdentifier* _tmp25_;
	ValaCCodeFunctionCall* _tmp26_;
	ValaCCodeFunctionCall* czero2;
	ValaCCodeConstant* _tmp27_;
	ValaCCodeBinaryExpression* _tmp28_;
	ValaCCodeBinaryExpression* _tmp29_;
	ValaCCodeBlock* czeroblock2;
	ValaCCodeExpressionStatement* _tmp30_;
	ValaCCodeBinaryExpression* _tmp31_;
	ValaCCodeIfStatement* _tmp32_;
	self = (ValaCCodeArrayModule*) base;
	vala_ccode_file_add_include (((ValaCCodeBaseModule*) self)->cfile, "string.h", FALSE);
	fun = vala_ccode_function_new ("_vala_array_move", "void");
	vala_ccode_function_set_modifiers (fun, VALA_CCODE_MODIFIERS_STATIC);
	vala_ccode_function_add_parameter (fun, _tmp0_ = vala_ccode_formal_parameter_new ("array", "gpointer"));
	_vala_ccode_node_unref0 (_tmp0_);
	vala_ccode_function_add_parameter (fun, _tmp1_ = vala_ccode_formal_parameter_new ("element_size", "gsize"));
	_vala_ccode_node_unref0 (_tmp1_);
	vala_ccode_function_add_parameter (fun, _tmp2_ = vala_ccode_formal_parameter_new ("src", "gint"));
	_vala_ccode_node_unref0 (_tmp2_);
	vala_ccode_function_add_parameter (fun, _tmp3_ = vala_ccode_formal_parameter_new ("dest", "gint"));
	_vala_ccode_node_unref0 (_tmp3_);
	vala_ccode_function_add_parameter (fun, _tmp4_ = vala_ccode_formal_parameter_new ("length", "gint"));
	_vala_ccode_node_unref0 (_tmp4_);
	vala_ccode_file_add_function_declaration (((ValaCCodeBaseModule*) self)->cfile, fun);
	array = (_tmp6_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) (_tmp5_ = vala_ccode_identifier_new ("array")), "char*"), _vala_ccode_node_unref0 (_tmp5_), _tmp6_);
	element_size = vala_ccode_identifier_new ("element_size");
	length = vala_ccode_identifier_new ("length");
	src = vala_ccode_identifier_new ("src");
	dest = vala_ccode_identifier_new ("dest");
	src_address = (_tmp8_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) array, (ValaCCodeExpression*) (_tmp7_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) src, (ValaCCodeExpression*) element_size))), _vala_ccode_node_unref0 (_tmp7_), _tmp8_);
	dest_address = (_tmp10_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) array, (ValaCCodeExpression*) (_tmp9_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) dest, (ValaCCodeExpression*) element_size))), _vala_ccode_node_unref0 (_tmp9_), _tmp10_);
	dest_end_address = (_tmp13_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) array, (ValaCCodeExpression*) (_tmp12_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) (_tmp11_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) dest, (ValaCCodeExpression*) length)), (ValaCCodeExpression*) element_size))), _vala_ccode_node_unref0 (_tmp12_), _vala_ccode_node_unref0 (_tmp11_), _tmp13_);
	vala_ccode_function_set_block (fun, _tmp14_ = vala_ccode_block_new ());
	_vala_ccode_node_unref0 (_tmp14_);
	ccall = (_tmp16_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp15_ = vala_ccode_identifier_new ("g_memmove"))), _vala_ccode_node_unref0 (_tmp15_), _tmp16_);
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) dest_address);
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) src_address);
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp17_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) length, (ValaCCodeExpression*) element_size)));
	_vala_ccode_node_unref0 (_tmp17_);
	vala_ccode_block_add_statement (vala_ccode_function_get_block (fun), (ValaCCodeNode*) (_tmp18_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
	_vala_ccode_node_unref0 (_tmp18_);
	czero1 = (_tmp20_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp19_ = vala_ccode_identifier_new ("memset"))), _vala_ccode_node_unref0 (_tmp19_), _tmp20_);
	vala_ccode_function_call_add_argument (czero1, (ValaCCodeExpression*) src_address);
	vala_ccode_function_call_add_argument (czero1, (ValaCCodeExpression*) (_tmp21_ = vala_ccode_constant_new ("0")));
	_vala_ccode_node_unref0 (_tmp21_);
	vala_ccode_function_call_add_argument (czero1, (ValaCCodeExpression*) (_tmp23_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) (_tmp22_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, (ValaCCodeExpression*) dest, (ValaCCodeExpression*) src)), (ValaCCodeExpression*) element_size)));
	_vala_ccode_node_unref0 (_tmp23_);
	_vala_ccode_node_unref0 (_tmp22_);
	czeroblock1 = vala_ccode_block_new ();
	vala_ccode_block_add_statement (czeroblock1, (ValaCCodeNode*) (_tmp24_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) czero1)));
	_vala_ccode_node_unref0 (_tmp24_);
	czero2 = (_tmp26_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp25_ = vala_ccode_identifier_new ("memset"))), _vala_ccode_node_unref0 (_tmp25_), _tmp26_);
	vala_ccode_function_call_add_argument (czero2, (ValaCCodeExpression*) dest_end_address);
	vala_ccode_function_call_add_argument (czero2, (ValaCCodeExpression*) (_tmp27_ = vala_ccode_constant_new ("0")));
	_vala_ccode_node_unref0 (_tmp27_);
	vala_ccode_function_call_add_argument (czero2, (ValaCCodeExpression*) (_tmp29_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) (_tmp28_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, (ValaCCodeExpression*) src, (ValaCCodeExpression*) dest)), (ValaCCodeExpression*) element_size)));
	_vala_ccode_node_unref0 (_tmp29_);
	_vala_ccode_node_unref0 (_tmp28_);
	czeroblock2 = vala_ccode_block_new ();
	vala_ccode_block_add_statement (czeroblock2, (ValaCCodeNode*) (_tmp30_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) czero2)));
	_vala_ccode_node_unref0 (_tmp30_);
	vala_ccode_block_add_statement (vala_ccode_function_get_block (fun), (ValaCCodeNode*) (_tmp32_ = vala_ccode_if_statement_new ((ValaCCodeExpression*) (_tmp31_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_LESS_THAN, (ValaCCodeExpression*) src, (ValaCCodeExpression*) dest)), (ValaCCodeStatement*) czeroblock1, (ValaCCodeStatement*) czeroblock2)));
	_vala_ccode_node_unref0 (_tmp32_);
	_vala_ccode_node_unref0 (_tmp31_);
	vala_ccode_file_add_function (((ValaCCodeBaseModule*) self)->cfile, fun);
	_vala_ccode_node_unref0 (czeroblock2);
	_vala_ccode_node_unref0 (czero2);
	_vala_ccode_node_unref0 (czeroblock1);
	_vala_ccode_node_unref0 (czero1);
	_vala_ccode_node_unref0 (ccall);
	_vala_ccode_node_unref0 (dest_end_address);
	_vala_ccode_node_unref0 (dest_address);
	_vala_ccode_node_unref0 (src_address);
	_vala_ccode_node_unref0 (dest);
	_vala_ccode_node_unref0 (src);
	_vala_ccode_node_unref0 (length);
	_vala_ccode_node_unref0 (element_size);
	_vala_ccode_node_unref0 (array);
	_vala_ccode_node_unref0 (fun);
}


static void vala_ccode_array_module_real_append_vala_array_length (ValaCCodeBaseModule* base) {
	ValaCCodeArrayModule * self;
	ValaCCodeFunction* fun;
	ValaCCodeFormalParameter* _tmp0_;
	ValaCCodeBlock* block;
	ValaCCodeDeclaration* len_decl;
	ValaCCodeConstant* _tmp1_;
	ValaCCodeVariableDeclarator* _tmp2_;
	ValaCCodeBlock* non_null_block;
	ValaCCodeBlock* while_body;
	ValaCCodeIdentifier* _tmp3_;
	ValaCCodeUnaryExpression* _tmp4_;
	ValaCCodeExpressionStatement* _tmp5_;
	ValaCCodeIdentifier* _tmp6_;
	ValaCCodeCastExpression* _tmp7_;
	ValaCCodeConstant* _tmp8_;
	ValaCCodeElementAccess* _tmp9_;
	ValaCCodeElementAccess* array_element_check;
	ValaCCodeWhileStatement* _tmp10_;
	ValaCCodeIdentifier* array_check;
	ValaCCodeIfStatement* _tmp11_;
	ValaCCodeIdentifier* _tmp12_;
	ValaCCodeReturnStatement* _tmp13_;
	self = (ValaCCodeArrayModule*) base;
	fun = vala_ccode_function_new ("_vala_array_length", "gint");
	vala_ccode_function_set_modifiers (fun, VALA_CCODE_MODIFIERS_STATIC);
	vala_ccode_function_add_parameter (fun, _tmp0_ = vala_ccode_formal_parameter_new ("array", "gpointer"));
	_vala_ccode_node_unref0 (_tmp0_);
	vala_ccode_file_add_function_declaration (((ValaCCodeBaseModule*) self)->cfile, fun);
	block = vala_ccode_block_new ();
	len_decl = vala_ccode_declaration_new ("int");
	vala_ccode_declaration_add_declarator (len_decl, (ValaCCodeDeclarator*) (_tmp2_ = vala_ccode_variable_declarator_new ("length", (ValaCCodeExpression*) (_tmp1_ = vala_ccode_constant_new ("0")), NULL)));
	_vala_ccode_node_unref0 (_tmp2_);
	_vala_ccode_node_unref0 (_tmp1_);
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) len_decl);
	non_null_block = vala_ccode_block_new ();
	while_body = vala_ccode_block_new ();
	vala_ccode_block_add_statement (while_body, (ValaCCodeNode*) (_tmp5_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp4_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POSTFIX_INCREMENT, (ValaCCodeExpression*) (_tmp3_ = vala_ccode_identifier_new ("length")))))));
	_vala_ccode_node_unref0 (_tmp5_);
	_vala_ccode_node_unref0 (_tmp4_);
	_vala_ccode_node_unref0 (_tmp3_);
	array_element_check = (_tmp9_ = vala_ccode_element_access_new ((ValaCCodeExpression*) (_tmp7_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) (_tmp6_ = vala_ccode_identifier_new ("array")), "gpointer*")), (ValaCCodeExpression*) (_tmp8_ = vala_ccode_constant_new ("length"))), _vala_ccode_node_unref0 (_tmp8_), _vala_ccode_node_unref0 (_tmp7_), _vala_ccode_node_unref0 (_tmp6_), _tmp9_);
	vala_ccode_block_add_statement (non_null_block, (ValaCCodeNode*) (_tmp10_ = vala_ccode_while_statement_new ((ValaCCodeExpression*) array_element_check, (ValaCCodeStatement*) while_body)));
	_vala_ccode_node_unref0 (_tmp10_);
	array_check = vala_ccode_identifier_new ("array");
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp11_ = vala_ccode_if_statement_new ((ValaCCodeExpression*) array_check, (ValaCCodeStatement*) non_null_block, NULL)));
	_vala_ccode_node_unref0 (_tmp11_);
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp13_ = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp12_ = vala_ccode_identifier_new ("length")))));
	_vala_ccode_node_unref0 (_tmp13_);
	_vala_ccode_node_unref0 (_tmp12_);
	vala_ccode_function_set_block (fun, block);
	vala_ccode_file_add_function (((ValaCCodeBaseModule*) self)->cfile, fun);
	_vala_ccode_node_unref0 (array_check);
	_vala_ccode_node_unref0 (array_element_check);
	_vala_ccode_node_unref0 (while_body);
	_vala_ccode_node_unref0 (non_null_block);
	_vala_ccode_node_unref0 (len_decl);
	_vala_ccode_node_unref0 (block);
	_vala_ccode_node_unref0 (fun);
}


static ValaCCodeExpression* vala_ccode_array_module_real_get_ref_cexpression (ValaCCodeBaseModule* base, ValaDataType* expression_type, ValaCCodeExpression* cexpr, ValaExpression* expr, ValaCodeNode* node) {
	ValaCCodeArrayModule * self;
	ValaCCodeExpression* result = NULL;
	self = (ValaCCodeArrayModule*) base;
	g_return_val_if_fail (expression_type != NULL, NULL);
	g_return_val_if_fail (cexpr != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	if (VALA_IS_ARRAY_TYPE (expression_type)) {
		ValaArrayType* array_type;
		ValaLocalVariable* decl;
		ValaCCodeExpression* ctemp;
		char* _tmp0_;
		ValaCCodeIdentifier* _tmp1_;
		ValaCCodeFunctionCall* _tmp2_;
		ValaCCodeFunctionCall* copy_call;
		ValaCCodeCommaExpression* ccomma;
		array_type = _vala_code_node_ref0 (VALA_ARRAY_TYPE (expression_type));
		if (!vala_array_type_get_fixed_length (array_type)) {
			result = VALA_CCODE_BASE_MODULE_CLASS (vala_ccode_array_module_parent_class)->get_ref_cexpression ((ValaCCodeBaseModule*) VALA_CCODE_METHOD_CALL_MODULE (self), expression_type, cexpr, expr, node);
			_vala_code_node_unref0 (array_type);
			return result;
		}
		decl = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, expression_type, FALSE, node, TRUE);
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, decl);
		ctemp = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) decl));
		copy_call = (_tmp2_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp1_ = vala_ccode_identifier_new (_tmp0_ = vala_ccode_array_module_generate_array_copy_wrapper (self, array_type)))), _vala_ccode_node_unref0 (_tmp1_), _g_free0 (_tmp0_), _tmp2_);
		vala_ccode_function_call_add_argument (copy_call, cexpr);
		vala_ccode_function_call_add_argument (copy_call, ctemp);
		ccomma = vala_ccode_comma_expression_new ();
		vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) copy_call);
		vala_ccode_comma_expression_append_expression (ccomma, ctemp);
		result = (ValaCCodeExpression*) ccomma;
		_vala_ccode_node_unref0 (copy_call);
		_vala_ccode_node_unref0 (ctemp);
		_vala_code_node_unref0 (decl);
		_vala_code_node_unref0 (array_type);
		return result;
	} else {
		result = VALA_CCODE_BASE_MODULE_CLASS (vala_ccode_array_module_parent_class)->get_ref_cexpression ((ValaCCodeBaseModule*) VALA_CCODE_METHOD_CALL_MODULE (self), expression_type, cexpr, expr, node);
		return result;
	}
}


static ValaCCodeExpression* vala_ccode_array_module_real_get_dup_func_expression (ValaCCodeBaseModule* base, ValaDataType* type, ValaSourceReference* source_reference, gboolean is_chainup) {
	ValaCCodeArrayModule * self;
	ValaCCodeExpression* result = NULL;
	self = (ValaCCodeArrayModule*) base;
	g_return_val_if_fail (type != NULL, NULL);
	if (VALA_IS_ARRAY_TYPE (type)) {
		ValaArrayType* array_type;
		char* _tmp0_;
		ValaCCodeExpression* _tmp1_;
		array_type = _vala_code_node_ref0 (VALA_ARRAY_TYPE (type));
		g_assert (!vala_array_type_get_fixed_length (array_type));
		result = (_tmp1_ = (ValaCCodeExpression*) vala_ccode_identifier_new (_tmp0_ = vala_ccode_array_module_generate_array_dup_wrapper (self, array_type)), _g_free0 (_tmp0_), _tmp1_);
		_vala_code_node_unref0 (array_type);
		return result;
	} else {
		result = VALA_CCODE_BASE_MODULE_CLASS (vala_ccode_array_module_parent_class)->get_dup_func_expression ((ValaCCodeBaseModule*) VALA_CCODE_METHOD_CALL_MODULE (self), type, source_reference, is_chainup);
		return result;
	}
}


static ValaCCodeExpression* vala_ccode_array_module_real_get_unref_expression (ValaCCodeBaseModule* base, ValaCCodeExpression* cvar, ValaDataType* type, ValaExpression* expr, gboolean is_macro_definition) {
	ValaCCodeArrayModule * self;
	ValaCCodeExpression* result = NULL;
	self = (ValaCCodeArrayModule*) base;
	g_return_val_if_fail (cvar != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	if (VALA_IS_ARRAY_TYPE (type)) {
		ValaArrayType* array_type;
		ValaCCodeExpression* _tmp0_;
		ValaCCodeFunctionCall* _tmp1_;
		ValaCCodeFunctionCall* ccall;
		ValaCCodeIdentifier* _tmp2_;
		ValaCCodeFunctionCall* _tmp3_;
		char* _tmp4_;
		ValaCCodeConstant* _tmp5_;
		ValaCCodeExpression* _tmp6_;
		ValaCCodeCastExpression* _tmp7_;
		array_type = _vala_code_node_ref0 (VALA_ARRAY_TYPE (type));
		if (!vala_array_type_get_fixed_length (array_type)) {
			result = VALA_CCODE_BASE_MODULE_CLASS (vala_ccode_array_module_parent_class)->get_unref_expression ((ValaCCodeBaseModule*) VALA_CCODE_METHOD_CALL_MODULE (self), cvar, type, expr, is_macro_definition);
			_vala_code_node_unref0 (array_type);
			return result;
		}
		((ValaCCodeBaseModule*) self)->requires_array_free = TRUE;
		ccall = (_tmp1_ = vala_ccode_function_call_new (_tmp0_ = vala_ccode_base_module_get_destroy_func_expression ((ValaCCodeBaseModule*) self, type, FALSE)), _vala_ccode_node_unref0 (_tmp0_), _tmp1_);
		ccall = (_tmp3_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp2_ = vala_ccode_identifier_new ("_vala_array_destroy"))), _vala_ccode_node_unref0 (ccall), _tmp3_);
		_vala_ccode_node_unref0 (_tmp2_);
		vala_ccode_function_call_add_argument (ccall, cvar);
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp5_ = vala_ccode_constant_new (_tmp4_ = g_strdup_printf ("%d", vala_array_type_get_length (array_type)))));
		_vala_ccode_node_unref0 (_tmp5_);
		_g_free0 (_tmp4_);
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp7_ = vala_ccode_cast_expression_new (_tmp6_ = vala_ccode_base_module_get_destroy_func_expression ((ValaCCodeBaseModule*) self, vala_array_type_get_element_type (array_type), FALSE), "GDestroyNotify")));
		_vala_ccode_node_unref0 (_tmp7_);
		_vala_ccode_node_unref0 (_tmp6_);
		result = (ValaCCodeExpression*) ccall;
		_vala_code_node_unref0 (array_type);
		return result;
	} else {
		result = VALA_CCODE_BASE_MODULE_CLASS (vala_ccode_array_module_parent_class)->get_unref_expression ((ValaCCodeBaseModule*) VALA_CCODE_METHOD_CALL_MODULE (self), cvar, type, expr, is_macro_definition);
		return result;
	}
}


static char* vala_ccode_array_module_generate_array_dup_wrapper (ValaCCodeArrayModule* self, ValaArrayType* array_type) {
	char* result = NULL;
	char* dup_func;
	char* _tmp0_;
	ValaCCodeFunction* _tmp1_;
	ValaCCodeFunction* function;
	char* _tmp2_;
	ValaCCodeFormalParameter* _tmp3_;
	ValaCCodeFormalParameter* _tmp4_;
	ValaCCodeBaseModuleEmitContext* _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (array_type != NULL, NULL);
	dup_func = g_strdup_printf ("_vala_array_dup%d", self->priv->next_array_dup_id = self->priv->next_array_dup_id + 1);
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, dup_func)) {
		result = dup_func;
		return result;
	}
	function = (_tmp1_ = vala_ccode_function_new (dup_func, _tmp0_ = vala_data_type_get_cname ((ValaDataType*) array_type)), _g_free0 (_tmp0_), _tmp1_);
	vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	vala_ccode_function_add_parameter (function, _tmp3_ = vala_ccode_formal_parameter_new ("self", _tmp2_ = vala_data_type_get_cname ((ValaDataType*) array_type)));
	_vala_ccode_node_unref0 (_tmp3_);
	_g_free0 (_tmp2_);
	vala_ccode_function_add_parameter (function, _tmp4_ = vala_ccode_formal_parameter_new ("length", "int"));
	_vala_ccode_node_unref0 (_tmp4_);
	if (VALA_IS_GENERIC_TYPE (vala_array_type_get_element_type (array_type))) {
		char* _tmp5_;
		char* _tmp6_;
		char* func_name;
		ValaCCodeFormalParameter* _tmp7_;
		func_name = (_tmp6_ = g_strdup_printf ("%s_dup_func", _tmp5_ = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) vala_data_type_get_type_parameter (vala_array_type_get_element_type (array_type))), -1)), _g_free0 (_tmp5_), _tmp6_);
		vala_ccode_function_add_parameter (function, _tmp7_ = vala_ccode_formal_parameter_new (func_name, "GBoxedCopyFunc"));
		_vala_ccode_node_unref0 (_tmp7_);
		_g_free0 (func_name);
	}
	vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp8_ = vala_ccode_base_module_emit_context_new (NULL));
	_vala_ccode_base_module_emit_context_unref0 (_tmp8_);
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, function);
	if (vala_ccode_base_module_requires_copy ((ValaCCodeBaseModule*) self, vala_array_type_get_element_type (array_type))) {
		ValaCCodeVariableDeclarator* cvardecl;
		ValaCCodeIdentifier* _tmp9_;
		ValaCCodeFunctionCall* _tmp10_;
		ValaCCodeFunctionCall* gnew;
		char* _tmp11_;
		ValaCCodeIdentifier* _tmp12_;
		ValaCCodeExpression* length_expr;
		gboolean _tmp13_ = FALSE;
		char* _tmp16_;
		ValaCCodeIdentifier* _tmp17_;
		ValaCCodeAssignment* _tmp18_;
		ValaCCodeVariableDeclarator* _tmp19_;
		ValaCCodeIdentifier* _tmp20_;
		ValaCCodeConstant* _tmp21_;
		ValaCCodeAssignment* _tmp22_;
		ValaCCodeIdentifier* _tmp23_;
		ValaCCodeIdentifier* _tmp24_;
		ValaCCodeBinaryExpression* _tmp25_;
		ValaCCodeIdentifier* _tmp26_;
		ValaCCodeUnaryExpression* _tmp27_;
		ValaCCodeIdentifier* _tmp28_;
		ValaCCodeIdentifier* _tmp29_;
		ValaCCodeElementAccess* _tmp30_;
		ValaCCodeIdentifier* _tmp31_;
		ValaCCodeIdentifier* _tmp32_;
		ValaCCodeElementAccess* _tmp33_;
		ValaCCodeExpression* _tmp34_;
		ValaCCodeAssignment* _tmp35_;
		ValaCCodeIdentifier* _tmp36_;
		cvardecl = vala_ccode_variable_declarator_new ("result", NULL, NULL);
		gnew = (_tmp10_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp9_ = vala_ccode_identifier_new ("g_new0"))), _vala_ccode_node_unref0 (_tmp9_), _tmp10_);
		vala_ccode_function_call_add_argument (gnew, (ValaCCodeExpression*) (_tmp12_ = vala_ccode_identifier_new (_tmp11_ = vala_data_type_get_cname (vala_array_type_get_element_type (array_type)))));
		_vala_ccode_node_unref0 (_tmp12_);
		_g_free0 (_tmp11_);
		length_expr = (ValaCCodeExpression*) vala_ccode_identifier_new ("length");
		if (vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) != NULL) {
			_tmp13_ = vala_typesymbol_is_reference_type (vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)));
		} else {
			_tmp13_ = FALSE;
		}
		if (_tmp13_) {
			ValaCCodeConstant* _tmp14_;
			ValaCCodeExpression* _tmp15_;
			length_expr = (_tmp15_ = (ValaCCodeExpression*) vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, length_expr, (ValaCCodeExpression*) (_tmp14_ = vala_ccode_constant_new ("1"))), _vala_ccode_node_unref0 (length_expr), _tmp15_);
			_vala_ccode_node_unref0 (_tmp14_);
		}
		vala_ccode_function_call_add_argument (gnew, length_expr);
		vala_ccode_function_add_declaration (vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self), _tmp16_ = vala_data_type_get_cname ((ValaDataType*) array_type), (ValaCCodeDeclarator*) cvardecl, 0);
		_g_free0 (_tmp16_);
		vala_ccode_function_add_expression (vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self), (ValaCCodeExpression*) (_tmp18_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp17_ = vala_ccode_identifier_new ("result")), (ValaCCodeExpression*) gnew, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
		_vala_ccode_node_unref0 (_tmp18_);
		_vala_ccode_node_unref0 (_tmp17_);
		vala_ccode_function_add_declaration (vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self), "int", (ValaCCodeDeclarator*) (_tmp19_ = vala_ccode_variable_declarator_new ("i", NULL, NULL)), 0);
		_vala_ccode_node_unref0 (_tmp19_);
		vala_ccode_function_open_for (vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self), (ValaCCodeExpression*) (_tmp22_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp20_ = vala_ccode_identifier_new ("i")), (ValaCCodeExpression*) (_tmp21_ = vala_ccode_constant_new ("0")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)), (ValaCCodeExpression*) (_tmp25_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_LESS_THAN, (ValaCCodeExpression*) (_tmp23_ = vala_ccode_identifier_new ("i")), (ValaCCodeExpression*) (_tmp24_ = vala_ccode_identifier_new ("length")))), (ValaCCodeExpression*) (_tmp27_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POSTFIX_INCREMENT, (ValaCCodeExpression*) (_tmp26_ = vala_ccode_identifier_new ("i")))));
		_vala_ccode_node_unref0 (_tmp27_);
		_vala_ccode_node_unref0 (_tmp26_);
		_vala_ccode_node_unref0 (_tmp25_);
		_vala_ccode_node_unref0 (_tmp24_);
		_vala_ccode_node_unref0 (_tmp23_);
		_vala_ccode_node_unref0 (_tmp22_);
		_vala_ccode_node_unref0 (_tmp21_);
		_vala_ccode_node_unref0 (_tmp20_);
		vala_ccode_function_add_expression (vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self), (ValaCCodeExpression*) (_tmp35_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp30_ = vala_ccode_element_access_new ((ValaCCodeExpression*) (_tmp28_ = vala_ccode_identifier_new ("result")), (ValaCCodeExpression*) (_tmp29_ = vala_ccode_identifier_new ("i")))), _tmp34_ = vala_ccode_base_module_get_ref_cexpression ((ValaCCodeBaseModule*) self, vala_array_type_get_element_type (array_type), (ValaCCodeExpression*) (_tmp33_ = vala_ccode_element_access_new ((ValaCCodeExpression*) (_tmp31_ = vala_ccode_identifier_new ("self")), (ValaCCodeExpression*) (_tmp32_ = vala_ccode_identifier_new ("i")))), NULL, (ValaCodeNode*) array_type), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
		_vala_ccode_node_unref0 (_tmp35_);
		_vala_ccode_node_unref0 (_tmp34_);
		_vala_ccode_node_unref0 (_tmp33_);
		_vala_ccode_node_unref0 (_tmp32_);
		_vala_ccode_node_unref0 (_tmp31_);
		_vala_ccode_node_unref0 (_tmp30_);
		_vala_ccode_node_unref0 (_tmp29_);
		_vala_ccode_node_unref0 (_tmp28_);
		vala_ccode_function_close (vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self));
		vala_ccode_function_add_return (vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self), (ValaCCodeExpression*) (_tmp36_ = vala_ccode_identifier_new ("result")));
		_vala_ccode_node_unref0 (_tmp36_);
		_vala_ccode_node_unref0 (length_expr);
		_vala_ccode_node_unref0 (gnew);
		_vala_ccode_node_unref0 (cvardecl);
	} else {
		ValaCCodeIdentifier* _tmp37_;
		ValaCCodeFunctionCall* _tmp38_;
		ValaCCodeFunctionCall* dup_call;
		ValaCCodeIdentifier* _tmp39_;
		ValaCCodeIdentifier* _tmp40_;
		ValaCCodeFunctionCall* _tmp41_;
		ValaCCodeFunctionCall* sizeof_call;
		char* _tmp42_;
		ValaCCodeIdentifier* _tmp43_;
		ValaCCodeIdentifier* _tmp44_;
		ValaCCodeBinaryExpression* _tmp45_;
		dup_call = (_tmp38_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp37_ = vala_ccode_identifier_new ("g_memdup"))), _vala_ccode_node_unref0 (_tmp37_), _tmp38_);
		vala_ccode_function_call_add_argument (dup_call, (ValaCCodeExpression*) (_tmp39_ = vala_ccode_identifier_new ("self")));
		_vala_ccode_node_unref0 (_tmp39_);
		sizeof_call = (_tmp41_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp40_ = vala_ccode_identifier_new ("sizeof"))), _vala_ccode_node_unref0 (_tmp40_), _tmp41_);
		vala_ccode_function_call_add_argument (sizeof_call, (ValaCCodeExpression*) (_tmp43_ = vala_ccode_identifier_new (_tmp42_ = vala_data_type_get_cname (vala_array_type_get_element_type (array_type)))));
		_vala_ccode_node_unref0 (_tmp43_);
		_g_free0 (_tmp42_);
		vala_ccode_function_call_add_argument (dup_call, (ValaCCodeExpression*) (_tmp45_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) (_tmp44_ = vala_ccode_identifier_new ("length")), (ValaCCodeExpression*) sizeof_call)));
		_vala_ccode_node_unref0 (_tmp45_);
		_vala_ccode_node_unref0 (_tmp44_);
		vala_ccode_function_add_return (vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self), (ValaCCodeExpression*) dup_call);
		_vala_ccode_node_unref0 (sizeof_call);
		_vala_ccode_node_unref0 (dup_call);
	}
	vala_ccode_file_add_function_declaration (((ValaCCodeBaseModule*) self)->cfile, function);
	vala_ccode_file_add_function (((ValaCCodeBaseModule*) self)->cfile, function);
	vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
	result = dup_func;
	_vala_ccode_node_unref0 (function);
	return result;
}


static char* vala_ccode_array_module_generate_array_copy_wrapper (ValaCCodeArrayModule* self, ValaArrayType* array_type) {
	char* result = NULL;
	char* dup_func;
	ValaCCodeFunction* function;
	char* _tmp0_;
	char* _tmp1_;
	ValaCCodeFormalParameter* _tmp2_;
	char* _tmp3_;
	char* _tmp4_;
	ValaCCodeFormalParameter* _tmp5_;
	ValaCCodeBaseModuleEmitContext* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (array_type != NULL, NULL);
	dup_func = g_strdup_printf ("_vala_array_copy%d", self->priv->next_array_dup_id = self->priv->next_array_dup_id + 1);
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, dup_func)) {
		result = dup_func;
		return result;
	}
	function = vala_ccode_function_new (dup_func, "void");
	vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	vala_ccode_function_add_parameter (function, _tmp2_ = vala_ccode_formal_parameter_new ("self", _tmp1_ = g_strconcat (_tmp0_ = vala_data_type_get_cname ((ValaDataType*) array_type), "*", NULL)));
	_vala_ccode_node_unref0 (_tmp2_);
	_g_free0 (_tmp1_);
	_g_free0 (_tmp0_);
	vala_ccode_function_add_parameter (function, _tmp5_ = vala_ccode_formal_parameter_new ("dest", _tmp4_ = g_strconcat (_tmp3_ = vala_data_type_get_cname ((ValaDataType*) array_type), "*", NULL)));
	_vala_ccode_node_unref0 (_tmp5_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp3_);
	vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp6_ = vala_ccode_base_module_emit_context_new (NULL));
	_vala_ccode_base_module_emit_context_unref0 (_tmp6_);
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, function);
	if (vala_ccode_base_module_requires_copy ((ValaCCodeBaseModule*) self, vala_array_type_get_element_type (array_type))) {
		ValaCCodeVariableDeclarator* _tmp7_;
		ValaCCodeIdentifier* _tmp8_;
		ValaCCodeConstant* _tmp9_;
		ValaCCodeAssignment* _tmp10_;
		ValaCCodeIdentifier* _tmp11_;
		char* _tmp12_;
		ValaCCodeConstant* _tmp13_;
		ValaCCodeBinaryExpression* _tmp14_;
		ValaCCodeIdentifier* _tmp15_;
		ValaCCodeUnaryExpression* _tmp16_;
		ValaCCodeIdentifier* _tmp17_;
		ValaCCodeIdentifier* _tmp18_;
		ValaCCodeElementAccess* _tmp19_;
		ValaCCodeIdentifier* _tmp20_;
		ValaCCodeIdentifier* _tmp21_;
		ValaCCodeElementAccess* _tmp22_;
		ValaCCodeExpression* _tmp23_;
		ValaCCodeAssignment* _tmp24_;
		vala_ccode_function_add_declaration (vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self), "int", (ValaCCodeDeclarator*) (_tmp7_ = vala_ccode_variable_declarator_new ("i", NULL, NULL)), 0);
		_vala_ccode_node_unref0 (_tmp7_);
		vala_ccode_function_open_for (vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self), (ValaCCodeExpression*) (_tmp10_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp8_ = vala_ccode_identifier_new ("i")), (ValaCCodeExpression*) (_tmp9_ = vala_ccode_constant_new ("0")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)), (ValaCCodeExpression*) (_tmp14_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_LESS_THAN, (ValaCCodeExpression*) (_tmp11_ = vala_ccode_identifier_new ("i")), (ValaCCodeExpression*) (_tmp13_ = vala_ccode_constant_new (_tmp12_ = g_strdup_printf ("%d", vala_array_type_get_length (array_type)))))), (ValaCCodeExpression*) (_tmp16_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POSTFIX_INCREMENT, (ValaCCodeExpression*) (_tmp15_ = vala_ccode_identifier_new ("i")))));
		_vala_ccode_node_unref0 (_tmp16_);
		_vala_ccode_node_unref0 (_tmp15_);
		_vala_ccode_node_unref0 (_tmp14_);
		_vala_ccode_node_unref0 (_tmp13_);
		_g_free0 (_tmp12_);
		_vala_ccode_node_unref0 (_tmp11_);
		_vala_ccode_node_unref0 (_tmp10_);
		_vala_ccode_node_unref0 (_tmp9_);
		_vala_ccode_node_unref0 (_tmp8_);
		vala_ccode_function_add_expression (vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self), (ValaCCodeExpression*) (_tmp24_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp19_ = vala_ccode_element_access_new ((ValaCCodeExpression*) (_tmp17_ = vala_ccode_identifier_new ("dest")), (ValaCCodeExpression*) (_tmp18_ = vala_ccode_identifier_new ("i")))), _tmp23_ = vala_ccode_base_module_get_ref_cexpression ((ValaCCodeBaseModule*) self, vala_array_type_get_element_type (array_type), (ValaCCodeExpression*) (_tmp22_ = vala_ccode_element_access_new ((ValaCCodeExpression*) (_tmp20_ = vala_ccode_identifier_new ("self")), (ValaCCodeExpression*) (_tmp21_ = vala_ccode_identifier_new ("i")))), NULL, (ValaCodeNode*) array_type), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
		_vala_ccode_node_unref0 (_tmp24_);
		_vala_ccode_node_unref0 (_tmp23_);
		_vala_ccode_node_unref0 (_tmp22_);
		_vala_ccode_node_unref0 (_tmp21_);
		_vala_ccode_node_unref0 (_tmp20_);
		_vala_ccode_node_unref0 (_tmp19_);
		_vala_ccode_node_unref0 (_tmp18_);
		_vala_ccode_node_unref0 (_tmp17_);
	} else {
		ValaCCodeIdentifier* _tmp25_;
		ValaCCodeFunctionCall* _tmp26_;
		ValaCCodeFunctionCall* dup_call;
		ValaCCodeIdentifier* _tmp27_;
		ValaCCodeIdentifier* _tmp28_;
		ValaCCodeIdentifier* _tmp29_;
		ValaCCodeFunctionCall* _tmp30_;
		ValaCCodeFunctionCall* sizeof_call;
		char* _tmp31_;
		ValaCCodeIdentifier* _tmp32_;
		char* _tmp33_;
		ValaCCodeConstant* _tmp34_;
		ValaCCodeBinaryExpression* _tmp35_;
		vala_ccode_file_add_include (((ValaCCodeBaseModule*) self)->cfile, "string.h", FALSE);
		dup_call = (_tmp26_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp25_ = vala_ccode_identifier_new ("memcpy"))), _vala_ccode_node_unref0 (_tmp25_), _tmp26_);
		vala_ccode_function_call_add_argument (dup_call, (ValaCCodeExpression*) (_tmp27_ = vala_ccode_identifier_new ("dest")));
		_vala_ccode_node_unref0 (_tmp27_);
		vala_ccode_function_call_add_argument (dup_call, (ValaCCodeExpression*) (_tmp28_ = vala_ccode_identifier_new ("self")));
		_vala_ccode_node_unref0 (_tmp28_);
		sizeof_call = (_tmp30_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp29_ = vala_ccode_identifier_new ("sizeof"))), _vala_ccode_node_unref0 (_tmp29_), _tmp30_);
		vala_ccode_function_call_add_argument (sizeof_call, (ValaCCodeExpression*) (_tmp32_ = vala_ccode_identifier_new (_tmp31_ = vala_data_type_get_cname (vala_array_type_get_element_type (array_type)))));
		_vala_ccode_node_unref0 (_tmp32_);
		_g_free0 (_tmp31_);
		vala_ccode_function_call_add_argument (dup_call, (ValaCCodeExpression*) (_tmp35_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) (_tmp34_ = vala_ccode_constant_new (_tmp33_ = g_strdup_printf ("%d", vala_array_type_get_length (array_type)))), (ValaCCodeExpression*) sizeof_call)));
		_vala_ccode_node_unref0 (_tmp35_);
		_vala_ccode_node_unref0 (_tmp34_);
		_g_free0 (_tmp33_);
		vala_ccode_function_add_expression (vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self), (ValaCCodeExpression*) dup_call);
		_vala_ccode_node_unref0 (sizeof_call);
		_vala_ccode_node_unref0 (dup_call);
	}
	vala_ccode_file_add_function_declaration (((ValaCCodeBaseModule*) self)->cfile, function);
	vala_ccode_file_add_function (((ValaCCodeBaseModule*) self)->cfile, function);
	vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
	result = dup_func;
	_vala_ccode_node_unref0 (function);
	return result;
}


static char* vala_ccode_array_module_generate_array_add_wrapper (ValaCCodeArrayModule* self, ValaArrayType* array_type) {
	char* result = NULL;
	char* add_func;
	ValaCCodeFunction* function;
	char* _tmp0_;
	char* _tmp1_;
	ValaCCodeFormalParameter* _tmp2_;
	ValaCCodeFormalParameter* _tmp3_;
	ValaCCodeFormalParameter* _tmp4_;
	char* typename;
	ValaCCodeExpression* value;
	ValaCCodeFormalParameter* _tmp9_;
	ValaCCodeIdentifier* _tmp10_;
	ValaCCodeUnaryExpression* _tmp11_;
	ValaCCodeUnaryExpression* array;
	ValaCCodeIdentifier* _tmp12_;
	ValaCCodeUnaryExpression* _tmp13_;
	ValaCCodeUnaryExpression* length;
	ValaCCodeIdentifier* _tmp14_;
	ValaCCodeUnaryExpression* _tmp15_;
	ValaCCodeUnaryExpression* size;
	ValaCCodeBlock* block;
	ValaCCodeIdentifier* _tmp16_;
	ValaCCodeFunctionCall* _tmp17_;
	ValaCCodeFunctionCall* renew_call;
	char* _tmp18_;
	ValaCCodeIdentifier* _tmp19_;
	ValaCCodeBlock* resize_block;
	ValaCCodeConstant* _tmp22_;
	ValaCCodeBinaryExpression* _tmp23_;
	ValaCCodeConstant* _tmp24_;
	ValaCCodeConditionalExpression* _tmp25_;
	ValaCCodeAssignment* _tmp26_;
	ValaCCodeExpressionStatement* _tmp27_;
	ValaCCodeAssignment* _tmp28_;
	ValaCCodeExpressionStatement* _tmp29_;
	ValaCCodeBinaryExpression* csizecheck;
	ValaCCodeIfStatement* _tmp30_;
	ValaCCodeUnaryExpression* _tmp31_;
	ValaCCodeElementAccess* _tmp32_;
	ValaCCodeAssignment* _tmp33_;
	ValaCCodeExpressionStatement* _tmp34_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (array_type != NULL, NULL);
	add_func = g_strdup_printf ("_vala_array_add%d", self->priv->next_array_add_id = self->priv->next_array_add_id + 1);
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, add_func)) {
		result = add_func;
		return result;
	}
	function = vala_ccode_function_new (add_func, "void");
	vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	vala_ccode_function_add_parameter (function, _tmp2_ = vala_ccode_formal_parameter_new ("array", _tmp1_ = g_strconcat (_tmp0_ = vala_data_type_get_cname ((ValaDataType*) array_type), "*", NULL)));
	_vala_ccode_node_unref0 (_tmp2_);
	_g_free0 (_tmp1_);
	_g_free0 (_tmp0_);
	vala_ccode_function_add_parameter (function, _tmp3_ = vala_ccode_formal_parameter_new ("length", "int*"));
	_vala_ccode_node_unref0 (_tmp3_);
	vala_ccode_function_add_parameter (function, _tmp4_ = vala_ccode_formal_parameter_new ("size", "int*"));
	_vala_ccode_node_unref0 (_tmp4_);
	typename = vala_data_type_get_cname (vala_array_type_get_element_type (array_type));
	value = (ValaCCodeExpression*) vala_ccode_identifier_new ("value");
	if (vala_data_type_is_real_struct_type (vala_array_type_get_element_type (array_type))) {
		gboolean _tmp5_ = FALSE;
		if (!vala_data_type_get_nullable (vala_array_type_get_element_type (array_type))) {
			_tmp5_ = TRUE;
		} else {
			_tmp5_ = !vala_data_type_get_value_owned (vala_array_type_get_element_type (array_type));
		}
		if (_tmp5_) {
			char* _tmp6_;
			typename = (_tmp6_ = g_strconcat ("const ", typename, NULL), _g_free0 (typename), _tmp6_);
		}
		if (!vala_data_type_get_nullable (vala_array_type_get_element_type (array_type))) {
			char* _tmp7_;
			ValaCCodeExpression* _tmp8_;
			typename = (_tmp7_ = g_strconcat (typename, "*", NULL), _g_free0 (typename), _tmp7_);
			value = (_tmp8_ = (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, value), _vala_ccode_node_unref0 (value), _tmp8_);
		}
	}
	vala_ccode_function_add_parameter (function, _tmp9_ = vala_ccode_formal_parameter_new ("value", typename));
	_vala_ccode_node_unref0 (_tmp9_);
	array = (_tmp11_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, (ValaCCodeExpression*) (_tmp10_ = vala_ccode_identifier_new ("array"))), _vala_ccode_node_unref0 (_tmp10_), _tmp11_);
	length = (_tmp13_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, (ValaCCodeExpression*) (_tmp12_ = vala_ccode_identifier_new ("length"))), _vala_ccode_node_unref0 (_tmp12_), _tmp13_);
	size = (_tmp15_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, (ValaCCodeExpression*) (_tmp14_ = vala_ccode_identifier_new ("size"))), _vala_ccode_node_unref0 (_tmp14_), _tmp15_);
	block = vala_ccode_block_new ();
	renew_call = (_tmp17_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp16_ = vala_ccode_identifier_new ("g_renew"))), _vala_ccode_node_unref0 (_tmp16_), _tmp17_);
	vala_ccode_function_call_add_argument (renew_call, (ValaCCodeExpression*) (_tmp19_ = vala_ccode_identifier_new (_tmp18_ = vala_data_type_get_cname (vala_array_type_get_element_type (array_type)))));
	_vala_ccode_node_unref0 (_tmp19_);
	_g_free0 (_tmp18_);
	vala_ccode_function_call_add_argument (renew_call, (ValaCCodeExpression*) array);
	if (vala_data_type_is_reference_type_or_type_parameter (vala_array_type_get_element_type (array_type))) {
		ValaCCodeConstant* _tmp20_;
		ValaCCodeBinaryExpression* _tmp21_;
		vala_ccode_function_call_add_argument (renew_call, (ValaCCodeExpression*) (_tmp21_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) size, (ValaCCodeExpression*) (_tmp20_ = vala_ccode_constant_new ("1")))));
		_vala_ccode_node_unref0 (_tmp21_);
		_vala_ccode_node_unref0 (_tmp20_);
	} else {
		vala_ccode_function_call_add_argument (renew_call, (ValaCCodeExpression*) size);
	}
	resize_block = vala_ccode_block_new ();
	vala_ccode_block_add_statement (resize_block, (ValaCCodeNode*) (_tmp27_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp26_ = vala_ccode_assignment_new ((ValaCCodeExpression*) size, (ValaCCodeExpression*) (_tmp25_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) size, (ValaCCodeExpression*) (_tmp23_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) (_tmp22_ = vala_ccode_constant_new ("2")), (ValaCCodeExpression*) size)), (ValaCCodeExpression*) (_tmp24_ = vala_ccode_constant_new ("4")))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	_vala_ccode_node_unref0 (_tmp27_);
	_vala_ccode_node_unref0 (_tmp26_);
	_vala_ccode_node_unref0 (_tmp25_);
	_vala_ccode_node_unref0 (_tmp24_);
	_vala_ccode_node_unref0 (_tmp23_);
	_vala_ccode_node_unref0 (_tmp22_);
	vala_ccode_block_add_statement (resize_block, (ValaCCodeNode*) (_tmp29_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp28_ = vala_ccode_assignment_new ((ValaCCodeExpression*) array, (ValaCCodeExpression*) renew_call, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	_vala_ccode_node_unref0 (_tmp29_);
	_vala_ccode_node_unref0 (_tmp28_);
	csizecheck = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) length, (ValaCCodeExpression*) size);
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp30_ = vala_ccode_if_statement_new ((ValaCCodeExpression*) csizecheck, (ValaCCodeStatement*) resize_block, NULL)));
	_vala_ccode_node_unref0 (_tmp30_);
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp34_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp33_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp32_ = vala_ccode_element_access_new ((ValaCCodeExpression*) array, (ValaCCodeExpression*) (_tmp31_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POSTFIX_INCREMENT, (ValaCCodeExpression*) length)))), value, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	_vala_ccode_node_unref0 (_tmp34_);
	_vala_ccode_node_unref0 (_tmp33_);
	_vala_ccode_node_unref0 (_tmp32_);
	_vala_ccode_node_unref0 (_tmp31_);
	if (vala_data_type_is_reference_type_or_type_parameter (vala_array_type_get_element_type (array_type))) {
		ValaCCodeElementAccess* _tmp35_;
		ValaCCodeConstant* _tmp36_;
		ValaCCodeAssignment* _tmp37_;
		ValaCCodeExpressionStatement* _tmp38_;
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp38_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp37_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp35_ = vala_ccode_element_access_new ((ValaCCodeExpression*) array, (ValaCCodeExpression*) length)), (ValaCCodeExpression*) (_tmp36_ = vala_ccode_constant_new ("NULL")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		_vala_ccode_node_unref0 (_tmp38_);
		_vala_ccode_node_unref0 (_tmp37_);
		_vala_ccode_node_unref0 (_tmp36_);
		_vala_ccode_node_unref0 (_tmp35_);
	}
	vala_ccode_file_add_function_declaration (((ValaCCodeBaseModule*) self)->cfile, function);
	vala_ccode_function_set_block (function, block);
	vala_ccode_file_add_function (((ValaCCodeBaseModule*) self)->cfile, function);
	result = add_func;
	_vala_ccode_node_unref0 (csizecheck);
	_vala_ccode_node_unref0 (resize_block);
	_vala_ccode_node_unref0 (renew_call);
	_vala_ccode_node_unref0 (block);
	_vala_ccode_node_unref0 (size);
	_vala_ccode_node_unref0 (length);
	_vala_ccode_node_unref0 (array);
	_vala_ccode_node_unref0 (value);
	_g_free0 (typename);
	_vala_ccode_node_unref0 (function);
	return result;
}


static gboolean vala_ccode_array_module_is_array_add (ValaCCodeArrayModule* self, ValaAssignment* assignment) {
	gboolean result = FALSE;
	ValaExpression* _tmp0_;
	ValaBinaryExpression* binary;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (assignment != NULL, FALSE);
	binary = _vala_code_node_ref0 ((_tmp0_ = vala_assignment_get_right (assignment), VALA_IS_BINARY_EXPRESSION (_tmp0_) ? ((ValaBinaryExpression*) _tmp0_) : NULL));
	if (binary != NULL) {
		_tmp1_ = VALA_IS_ARRAY_TYPE (vala_expression_get_value_type (vala_binary_expression_get_left (binary)));
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		if (vala_binary_expression_get_operator (binary) == VALA_BINARY_OPERATOR_PLUS) {
			if (vala_expression_get_symbol_reference (vala_assignment_get_left (assignment)) == vala_expression_get_symbol_reference (vala_binary_expression_get_left (binary))) {
				result = TRUE;
				_vala_code_node_unref0 (binary);
				return result;
			}
		}
	}
	result = FALSE;
	_vala_code_node_unref0 (binary);
	return result;
}


static void vala_ccode_array_module_real_visit_assignment (ValaCodeVisitor* base, ValaAssignment* assignment) {
	ValaCCodeArrayModule * self;
	ValaExpression* _tmp0_;
	ValaBinaryExpression* binary;
	ValaExpression* array;
	ValaArrayType* array_type;
	ValaExpression* element;
	ValaFormalParameter* value_param;
	char* _tmp1_;
	ValaCCodeIdentifier* _tmp2_;
	ValaCCodeFunctionCall* _tmp3_;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeUnaryExpression* _tmp4_;
	ValaCCodeExpression* _tmp5_;
	ValaCCodeUnaryExpression* _tmp6_;
	ValaCCodeExpression* _tmp7_;
	ValaCCodeUnaryExpression* _tmp8_;
	ValaCCodeExpression* _tmp9_;
	ValaSymbol* array_var;
	ValaSymbol* _tmp10_;
	ValaLocalVariable* array_local;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	self = (ValaCCodeArrayModule*) base;
	g_return_if_fail (assignment != NULL);
	if (!vala_ccode_array_module_is_array_add (self, assignment)) {
		VALA_CODE_VISITOR_CLASS (vala_ccode_array_module_parent_class)->visit_assignment ((ValaCodeVisitor*) VALA_CCODE_METHOD_CALL_MODULE (self), assignment);
		return;
	}
	binary = _vala_code_node_ref0 ((_tmp0_ = vala_assignment_get_right (assignment), VALA_IS_BINARY_EXPRESSION (_tmp0_) ? ((ValaBinaryExpression*) _tmp0_) : NULL));
	array = _vala_code_node_ref0 (vala_binary_expression_get_left (binary));
	array_type = _vala_code_node_ref0 (VALA_ARRAY_TYPE (vala_expression_get_value_type (array)));
	element = _vala_code_node_ref0 (vala_binary_expression_get_right (binary));
	value_param = vala_formal_parameter_new ("value", vala_expression_get_target_type (element), NULL);
	ccall = (_tmp3_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp2_ = vala_ccode_identifier_new (_tmp1_ = vala_ccode_array_module_generate_array_add_wrapper (self, array_type)))), _vala_ccode_node_unref0 (_tmp2_), _g_free0 (_tmp1_), _tmp3_);
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp4_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) array)))));
	_vala_ccode_node_unref0 (_tmp4_);
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp6_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp5_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, array, -1))));
	_vala_ccode_node_unref0 (_tmp6_);
	_vala_ccode_node_unref0 (_tmp5_);
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp8_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp7_ = vala_ccode_base_module_get_array_size_cexpression ((ValaCCodeBaseModule*) self, array))));
	_vala_ccode_node_unref0 (_tmp8_);
	_vala_ccode_node_unref0 (_tmp7_);
	vala_ccode_function_call_add_argument (ccall, _tmp9_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, value_param, element, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) element))));
	_vala_ccode_node_unref0 (_tmp9_);
	vala_code_node_set_ccodenode ((ValaCodeNode*) assignment, (ValaCCodeNode*) ccall);
	array_var = _vala_code_node_ref0 (vala_expression_get_symbol_reference (vala_assignment_get_left (assignment)));
	array_local = _vala_code_node_ref0 ((_tmp10_ = array_var, VALA_IS_LOCAL_VARIABLE (_tmp10_) ? ((ValaLocalVariable*) _tmp10_) : NULL));
	if (vala_array_type_get_rank (array_type) == 1) {
		_tmp13_ = array_var != NULL;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		_tmp12_ = vala_symbol_is_internal_symbol (array_var);
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_ = FALSE;
		if (VALA_IS_LOCAL_VARIABLE (array_var)) {
			_tmp15_ = !vala_local_variable_get_captured (array_local);
		} else {
			_tmp15_ = FALSE;
		}
		if (_tmp15_) {
			_tmp14_ = TRUE;
		} else {
			_tmp14_ = VALA_IS_FIELD (array_var);
		}
		_tmp11_ = _tmp14_;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
	} else {
		vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) assignment), "Array concatenation not supported for public array variables");
	}
	_vala_code_node_unref0 (array_local);
	_vala_code_node_unref0 (array_var);
	_vala_ccode_node_unref0 (ccall);
	_vala_code_node_unref0 (value_param);
	_vala_code_node_unref0 (element);
	_vala_code_node_unref0 (array_type);
	_vala_code_node_unref0 (array);
	_vala_code_node_unref0 (binary);
}


static void vala_ccode_array_module_real_generate_parameter (ValaCCodeMethodModule* base, ValaFormalParameter* param, ValaCCodeFile* decl_space, ValaMap* cparam_map, ValaMap* carg_map) {
	ValaCCodeArrayModule * self;
	char* ctypename;
	char* _tmp1_;
	ValaCCodeFormalParameter* _tmp2_;
	ValaArrayType* array_type;
	self = (ValaCCodeArrayModule*) base;
	g_return_if_fail (param != NULL);
	g_return_if_fail (decl_space != NULL);
	g_return_if_fail (cparam_map != NULL);
	if (!VALA_IS_ARRAY_TYPE (vala_variable_get_variable_type ((ValaVariable*) param))) {
		VALA_CCODE_METHOD_MODULE_CLASS (vala_ccode_array_module_parent_class)->generate_parameter ((ValaCCodeMethodModule*) VALA_CCODE_METHOD_CALL_MODULE (self), param, decl_space, cparam_map, carg_map);
		return;
	}
	ctypename = vala_data_type_get_cname (vala_variable_get_variable_type ((ValaVariable*) param));
	if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN) {
		char* _tmp0_;
		ctypename = (_tmp0_ = g_strconcat (ctypename, "*", NULL), _g_free0 (ctypename), _tmp0_);
	}
	vala_code_node_set_ccodenode ((ValaCodeNode*) param, (ValaCCodeNode*) (_tmp2_ = vala_ccode_formal_parameter_new (_tmp1_ = vala_ccode_base_module_get_variable_cname ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) param)), ctypename)));
	_vala_ccode_node_unref0 (_tmp2_);
	_g_free0 (_tmp1_);
	array_type = _vala_code_node_ref0 (VALA_ARRAY_TYPE (vala_variable_get_variable_type ((ValaVariable*) param)));
	vala_ccode_base_module_generate_type_declaration ((ValaCCodeBaseModule*) self, vala_array_type_get_element_type (array_type), decl_space);
	vala_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cparameter_position (param), FALSE)), VALA_CCODE_FORMAL_PARAMETER (vala_code_node_get_ccodenode ((ValaCodeNode*) param)));
	if (carg_map != NULL) {
		ValaCCodeExpression* _tmp3_;
		vala_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cparameter_position (param), FALSE)), _tmp3_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) param)));
		_vala_ccode_node_unref0 (_tmp3_);
	}
	if (!vala_formal_parameter_get_no_array_length (param)) {
		char* length_ctype;
		length_ctype = g_strdup ("int");
		if (vala_formal_parameter_get_array_length_type (param) != NULL) {
			char* _tmp4_;
			length_ctype = (_tmp4_ = g_strdup (vala_formal_parameter_get_array_length_type (param)), _g_free0 (length_ctype), _tmp4_);
		}
		if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN) {
			char* _tmp5_;
			length_ctype = (_tmp5_ = g_strdup_printf ("%s*", length_ctype), _g_free0 (length_ctype), _tmp5_);
		}
		{
			gint dim;
			dim = 1;
			{
				gboolean _tmp6_;
				_tmp6_ = TRUE;
				while (TRUE) {
					char* _tmp7_;
					ValaCCodeFormalParameter* _tmp8_;
					ValaCCodeFormalParameter* cparam;
					if (!_tmp6_) {
						dim++;
					}
					_tmp6_ = FALSE;
					if (!(dim <= vala_array_type_get_rank (array_type))) {
						break;
					}
					cparam = (_tmp8_ = vala_ccode_formal_parameter_new (_tmp7_ = vala_ccode_base_module_get_parameter_array_length_cname ((ValaCCodeBaseModule*) self, param, dim), length_ctype), _g_free0 (_tmp7_), _tmp8_);
					vala_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_carray_length_parameter_position (param) + (0.01 * dim), FALSE)), cparam);
					if (carg_map != NULL) {
						ValaCCodeExpression* _tmp9_;
						vala_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_carray_length_parameter_position (param) + (0.01 * dim), FALSE)), _tmp9_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_ccode_formal_parameter_get_name (cparam)));
						_vala_ccode_node_unref0 (_tmp9_);
					}
					_vala_ccode_node_unref0 (cparam);
				}
			}
		}
		_g_free0 (length_ctype);
	}
	_vala_code_node_unref0 (array_type);
	_g_free0 (ctypename);
}


ValaCCodeArrayModule* vala_ccode_array_module_construct (GType object_type) {
	ValaCCodeArrayModule* self;
	self = (ValaCCodeArrayModule*) vala_ccode_method_call_module_construct (object_type);
	return self;
}


ValaCCodeArrayModule* vala_ccode_array_module_new (void) {
	return vala_ccode_array_module_construct (VALA_TYPE_CCODE_ARRAY_MODULE);
}


static void vala_ccode_array_module_class_init (ValaCCodeArrayModuleClass * klass) {
	vala_ccode_array_module_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_VISITOR_CLASS (klass)->finalize = vala_ccode_array_module_finalize;
	g_type_class_add_private (klass, sizeof (ValaCCodeArrayModulePrivate));
	VALA_CODE_VISITOR_CLASS (klass)->visit_array_creation_expression = vala_ccode_array_module_real_visit_array_creation_expression;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->get_array_length_cname = vala_ccode_array_module_real_get_array_length_cname;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->get_parameter_array_length_cname = vala_ccode_array_module_real_get_parameter_array_length_cname;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->get_array_length_cexpression = vala_ccode_array_module_real_get_array_length_cexpression;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->get_array_size_cname = vala_ccode_array_module_real_get_array_size_cname;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->get_array_size_cexpression = vala_ccode_array_module_real_get_array_size_cexpression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_element_access = vala_ccode_array_module_real_visit_element_access;
	VALA_CODE_VISITOR_CLASS (klass)->visit_slice_expression = vala_ccode_array_module_real_visit_slice_expression;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->append_struct_array_free = vala_ccode_array_module_real_append_struct_array_free;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->append_vala_array_free = vala_ccode_array_module_real_append_vala_array_free;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->append_vala_array_move = vala_ccode_array_module_real_append_vala_array_move;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->append_vala_array_length = vala_ccode_array_module_real_append_vala_array_length;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->get_ref_cexpression = vala_ccode_array_module_real_get_ref_cexpression;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->get_dup_func_expression = vala_ccode_array_module_real_get_dup_func_expression;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->get_unref_expression = vala_ccode_array_module_real_get_unref_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_assignment = vala_ccode_array_module_real_visit_assignment;
	VALA_CCODE_METHOD_MODULE_CLASS (klass)->generate_parameter = vala_ccode_array_module_real_generate_parameter;
}


static void vala_ccode_array_module_instance_init (ValaCCodeArrayModule * self) {
	self->priv = VALA_CCODE_ARRAY_MODULE_GET_PRIVATE (self);
	self->priv->next_array_dup_id = 0;
	self->priv->next_array_add_id = 0;
}


static void vala_ccode_array_module_finalize (ValaCodeVisitor* obj) {
	ValaCCodeArrayModule * self;
	self = VALA_CCODE_ARRAY_MODULE (obj);
	VALA_CODE_VISITOR_CLASS (vala_ccode_array_module_parent_class)->finalize (obj);
}


GType vala_ccode_array_module_get_type (void) {
	static volatile gsize vala_ccode_array_module_type_id__volatile = 0;
	if (g_once_init_enter (&vala_ccode_array_module_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeArrayModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_array_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeArrayModule), 0, (GInstanceInitFunc) vala_ccode_array_module_instance_init, NULL };
		GType vala_ccode_array_module_type_id;
		vala_ccode_array_module_type_id = g_type_register_static (VALA_TYPE_CCODE_METHOD_CALL_MODULE, "ValaCCodeArrayModule", &g_define_type_info, 0);
		g_once_init_leave (&vala_ccode_array_module_type_id__volatile, vala_ccode_array_module_type_id);
	}
	return vala_ccode_array_module_type_id__volatile;
}



