/* list.c generated by valac, the Vala compiler
 * generated from list.vala, do not modify */

/* list.vala
 *
 * Copyright (C) 2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>


#define VALA_TYPE_ITERABLE (vala_iterable_get_type ())
#define VALA_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ITERABLE, ValaIterable))
#define VALA_ITERABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ITERABLE, ValaIterableClass))
#define VALA_IS_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ITERABLE))
#define VALA_IS_ITERABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ITERABLE))
#define VALA_ITERABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ITERABLE, ValaIterableClass))

typedef struct _ValaIterable ValaIterable;
typedef struct _ValaIterableClass ValaIterableClass;
typedef struct _ValaIterablePrivate ValaIterablePrivate;

#define VALA_TYPE_ITERATOR (vala_iterator_get_type ())
#define VALA_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ITERATOR, ValaIterator))
#define VALA_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ITERATOR, ValaIteratorClass))
#define VALA_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ITERATOR))
#define VALA_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ITERATOR))
#define VALA_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ITERATOR, ValaIteratorClass))

typedef struct _ValaIterator ValaIterator;
typedef struct _ValaIteratorClass ValaIteratorClass;

#define VALA_TYPE_COLLECTION (vala_collection_get_type ())
#define VALA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_COLLECTION, ValaCollection))
#define VALA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_COLLECTION, ValaCollectionClass))
#define VALA_IS_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_COLLECTION))
#define VALA_IS_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_COLLECTION))
#define VALA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_COLLECTION, ValaCollectionClass))

typedef struct _ValaCollection ValaCollection;
typedef struct _ValaCollectionClass ValaCollectionClass;
typedef struct _ValaCollectionPrivate ValaCollectionPrivate;

#define VALA_TYPE_LIST (vala_list_get_type ())
#define VALA_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LIST, ValaList))
#define VALA_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LIST, ValaListClass))
#define VALA_IS_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LIST))
#define VALA_IS_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LIST))
#define VALA_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LIST, ValaListClass))

typedef struct _ValaList ValaList;
typedef struct _ValaListClass ValaListClass;
typedef struct _ValaListPrivate ValaListPrivate;

struct _ValaIterable {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaIterablePrivate * priv;
};

struct _ValaIterableClass {
	GTypeClass parent_class;
	void (*finalize) (ValaIterable *self);
	GType (*get_element_type) (ValaIterable* self);
	ValaIterator* (*iterator) (ValaIterable* self);
};

struct _ValaCollection {
	ValaIterable parent_instance;
	ValaCollectionPrivate * priv;
};

struct _ValaCollectionClass {
	ValaIterableClass parent_class;
	gboolean (*contains) (ValaCollection* self, gconstpointer item);
	gboolean (*add) (ValaCollection* self, gconstpointer item);
	gboolean (*remove) (ValaCollection* self, gconstpointer item);
	void (*clear) (ValaCollection* self);
	gint (*get_size) (ValaCollection* self);
};

struct _ValaList {
	ValaCollection parent_instance;
	ValaListPrivate * priv;
};

struct _ValaListClass {
	ValaCollectionClass parent_class;
	gpointer (*get) (ValaList* self, gint index);
	void (*set) (ValaList* self, gint index, gconstpointer item);
	gint (*index_of) (ValaList* self, gconstpointer item);
	void (*insert) (ValaList* self, gint index, gconstpointer item);
	void (*remove_at) (ValaList* self, gint index);
};

struct _ValaListPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
};


static gpointer vala_list_parent_class = NULL;

gpointer vala_iterable_ref (gpointer instance);
void vala_iterable_unref (gpointer instance);
GParamSpec* vala_param_spec_iterable (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_iterable (GValue* value, gpointer v_object);
void vala_value_take_iterable (GValue* value, gpointer v_object);
gpointer vala_value_get_iterable (const GValue* value);
GType vala_iterable_get_type (void) G_GNUC_CONST;
gpointer vala_iterator_ref (gpointer instance);
void vala_iterator_unref (gpointer instance);
GParamSpec* vala_param_spec_iterator (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_iterator (GValue* value, gpointer v_object);
void vala_value_take_iterator (GValue* value, gpointer v_object);
gpointer vala_value_get_iterator (const GValue* value);
GType vala_iterator_get_type (void) G_GNUC_CONST;
GType vala_collection_get_type (void) G_GNUC_CONST;
GType vala_list_get_type (void) G_GNUC_CONST;
#define VALA_LIST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_LIST, ValaListPrivate))
enum  {
	VALA_LIST_DUMMY_PROPERTY
};
gpointer vala_list_get (ValaList* self, gint index);
static gpointer vala_list_real_get (ValaList* self, gint index);
void vala_list_set (ValaList* self, gint index, gconstpointer item);
static void vala_list_real_set (ValaList* self, gint index, gconstpointer item);
gint vala_list_index_of (ValaList* self, gconstpointer item);
static gint vala_list_real_index_of (ValaList* self, gconstpointer item);
void vala_list_insert (ValaList* self, gint index, gconstpointer item);
static void vala_list_real_insert (ValaList* self, gint index, gconstpointer item);
void vala_list_remove_at (ValaList* self, gint index);
static void vala_list_real_remove_at (ValaList* self, gint index);
ValaList* vala_list_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
ValaCollection* vala_collection_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);


/**
 * Returns the item at the specified index in this list.
 *
 * @param index zero-based index of the item to be returned
 *
 * @return      the item at the specified index in the list
 */
static gpointer vala_list_real_get (ValaList* self, gint index) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `vala_list_get'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


gpointer vala_list_get (ValaList* self, gint index) {
	return VALA_LIST_GET_CLASS (self)->get (self, index);
}


/**
 * Sets the item at the specified index in this list.
 *
 * @param index zero-based index of the item to be set
 */
static void vala_list_real_set (ValaList* self, gint index, gconstpointer item) {
	g_return_if_fail (self != NULL);
	g_critical ("Type `%s' does not implement abstract method `vala_list_set'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void vala_list_set (ValaList* self, gint index, gconstpointer item) {
	VALA_LIST_GET_CLASS (self)->set (self, index, item);
}


/**
 * Returns the index of the first occurence of the specified item in
 * this list.
 *
 * @return the index of the first occurence of the specified item, or
 *         -1 if the item could not be found
 */
static gint vala_list_real_index_of (ValaList* self, gconstpointer item) {
	g_return_val_if_fail (self != NULL, 0);
	g_critical ("Type `%s' does not implement abstract method `vala_list_index_of'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return 0;
}


gint vala_list_index_of (ValaList* self, gconstpointer item) {
	return VALA_LIST_GET_CLASS (self)->index_of (self, item);
}


/**
 * Inserts an item into this list at the specified position.
 *
 * @param index zero-based index at which item is inserted
 * @param item  item to insert into the list
 */
static void vala_list_real_insert (ValaList* self, gint index, gconstpointer item) {
	g_return_if_fail (self != NULL);
	g_critical ("Type `%s' does not implement abstract method `vala_list_insert'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void vala_list_insert (ValaList* self, gint index, gconstpointer item) {
	VALA_LIST_GET_CLASS (self)->insert (self, index, item);
}


/**
 * Removes the item at the specified index of this list.
 *
 * @param index zero-based index of the item to be removed
 */
static void vala_list_real_remove_at (ValaList* self, gint index) {
	g_return_if_fail (self != NULL);
	g_critical ("Type `%s' does not implement abstract method `vala_list_remove_at'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void vala_list_remove_at (ValaList* self, gint index) {
	VALA_LIST_GET_CLASS (self)->remove_at (self, index);
}


ValaList* vala_list_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func) {
	ValaList* self;
	self = (ValaList*) vala_collection_construct (object_type, g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	return self;
}


static void vala_list_class_init (ValaListClass * klass) {
	vala_list_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaListPrivate));
	VALA_LIST_CLASS (klass)->get = vala_list_real_get;
	VALA_LIST_CLASS (klass)->set = vala_list_real_set;
	VALA_LIST_CLASS (klass)->index_of = vala_list_real_index_of;
	VALA_LIST_CLASS (klass)->insert = vala_list_real_insert;
	VALA_LIST_CLASS (klass)->remove_at = vala_list_real_remove_at;
}


static void vala_list_instance_init (ValaList * self) {
	self->priv = VALA_LIST_GET_PRIVATE (self);
}


/**
 * Represents a collection of items in a well-defined order.
 */
GType vala_list_get_type (void) {
	static volatile gsize vala_list_type_id__volatile = 0;
	if (g_once_init_enter (&vala_list_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaList), 0, (GInstanceInitFunc) vala_list_instance_init, NULL };
		GType vala_list_type_id;
		vala_list_type_id = g_type_register_static (VALA_TYPE_COLLECTION, "ValaList", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&vala_list_type_id__volatile, vala_list_type_id);
	}
	return vala_list_type_id__volatile;
}



