/* valaclass.c generated by valac, the Vala compiler
 * generated from valaclass.vala, do not modify */

/* valaclass.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>


#define VALA_TYPE_CODE_NODE (vala_code_node_get_type ())
#define VALA_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_NODE, ValaCodeNode))
#define VALA_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))
#define VALA_IS_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_NODE))
#define VALA_IS_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_NODE))
#define VALA_CODE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))

typedef struct _ValaCodeNode ValaCodeNode;
typedef struct _ValaCodeNodeClass ValaCodeNodeClass;
typedef struct _ValaCodeNodePrivate ValaCodeNodePrivate;

#define VALA_TYPE_CODE_VISITOR (vala_code_visitor_get_type ())
#define VALA_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitor))
#define VALA_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))
#define VALA_IS_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_VISITOR))
#define VALA_IS_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_VISITOR))
#define VALA_CODE_VISITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))

typedef struct _ValaCodeVisitor ValaCodeVisitor;
typedef struct _ValaCodeVisitorClass ValaCodeVisitorClass;

#define VALA_TYPE_SEMANTIC_ANALYZER (vala_semantic_analyzer_get_type ())
#define VALA_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzer))
#define VALA_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))
#define VALA_IS_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_IS_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_SEMANTIC_ANALYZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))

typedef struct _ValaSemanticAnalyzer ValaSemanticAnalyzer;
typedef struct _ValaSemanticAnalyzerClass ValaSemanticAnalyzerClass;

#define VALA_TYPE_CODE_GENERATOR (vala_code_generator_get_type ())
#define VALA_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGenerator))
#define VALA_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))
#define VALA_IS_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_GENERATOR))
#define VALA_IS_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_GENERATOR))
#define VALA_CODE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))

typedef struct _ValaCodeGenerator ValaCodeGenerator;
typedef struct _ValaCodeGeneratorClass ValaCodeGeneratorClass;

#define VALA_TYPE_DATA_TYPE (vala_data_type_get_type ())
#define VALA_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DATA_TYPE, ValaDataType))
#define VALA_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))
#define VALA_IS_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DATA_TYPE))
#define VALA_IS_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DATA_TYPE))
#define VALA_DATA_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))

typedef struct _ValaDataType ValaDataType;
typedef struct _ValaDataTypeClass ValaDataTypeClass;

#define VALA_TYPE_EXPRESSION (vala_expression_get_type ())
#define VALA_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_EXPRESSION, ValaExpression))
#define VALA_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_EXPRESSION, ValaExpressionClass))
#define VALA_IS_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_EXPRESSION))
#define VALA_IS_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_EXPRESSION))
#define VALA_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_EXPRESSION, ValaExpressionClass))

typedef struct _ValaExpression ValaExpression;
typedef struct _ValaExpressionClass ValaExpressionClass;

#define VALA_TYPE_SYMBOL (vala_symbol_get_type ())
#define VALA_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SYMBOL, ValaSymbol))
#define VALA_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SYMBOL, ValaSymbolClass))
#define VALA_IS_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SYMBOL))
#define VALA_IS_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SYMBOL))
#define VALA_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SYMBOL, ValaSymbolClass))

typedef struct _ValaSymbol ValaSymbol;
typedef struct _ValaSymbolClass ValaSymbolClass;

#define VALA_TYPE_VARIABLE (vala_variable_get_type ())
#define VALA_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VARIABLE, ValaVariable))
#define VALA_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VARIABLE, ValaVariableClass))
#define VALA_IS_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VARIABLE))
#define VALA_IS_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VARIABLE))
#define VALA_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VARIABLE, ValaVariableClass))

typedef struct _ValaVariable ValaVariable;
typedef struct _ValaVariableClass ValaVariableClass;

#define VALA_TYPE_LOCAL_VARIABLE (vala_local_variable_get_type ())
#define VALA_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable))
#define VALA_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))
#define VALA_IS_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_IS_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_LOCAL_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))

typedef struct _ValaLocalVariable ValaLocalVariable;
typedef struct _ValaLocalVariableClass ValaLocalVariableClass;

#define VALA_TYPE_ATTRIBUTE (vala_attribute_get_type ())
#define VALA_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ATTRIBUTE, ValaAttribute))
#define VALA_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))
#define VALA_IS_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ATTRIBUTE))
#define VALA_IS_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ATTRIBUTE))
#define VALA_ATTRIBUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))

typedef struct _ValaAttribute ValaAttribute;
typedef struct _ValaAttributeClass ValaAttributeClass;
typedef struct _ValaSymbolPrivate ValaSymbolPrivate;

#define VALA_TYPE_NAMESPACE (vala_namespace_get_type ())
#define VALA_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_NAMESPACE, ValaNamespace))
#define VALA_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_NAMESPACE, ValaNamespaceClass))
#define VALA_IS_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_NAMESPACE))
#define VALA_IS_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_NAMESPACE))
#define VALA_NAMESPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_NAMESPACE, ValaNamespaceClass))

typedef struct _ValaNamespace ValaNamespace;
typedef struct _ValaNamespaceClass ValaNamespaceClass;

#define VALA_TYPE_TYPESYMBOL (vala_typesymbol_get_type ())
#define VALA_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbol))
#define VALA_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))
#define VALA_IS_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPESYMBOL))
#define VALA_IS_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPESYMBOL))
#define VALA_TYPESYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))

typedef struct _ValaTypeSymbol ValaTypeSymbol;
typedef struct _ValaTypeSymbolClass ValaTypeSymbolClass;

#define VALA_TYPE_OBJECT_TYPE_SYMBOL (vala_object_type_symbol_get_type ())
#define VALA_OBJECT_TYPE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol))
#define VALA_OBJECT_TYPE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbolClass))
#define VALA_IS_OBJECT_TYPE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL))
#define VALA_IS_OBJECT_TYPE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_OBJECT_TYPE_SYMBOL))
#define VALA_OBJECT_TYPE_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbolClass))

typedef struct _ValaObjectTypeSymbol ValaObjectTypeSymbol;
typedef struct _ValaObjectTypeSymbolClass ValaObjectTypeSymbolClass;

#define VALA_TYPE_CLASS (vala_class_get_type ())
#define VALA_CLASS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CLASS, ValaClass))
#define VALA_CLASS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CLASS, ValaClassClass))
#define VALA_IS_CLASS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CLASS))
#define VALA_IS_CLASS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CLASS))
#define VALA_CLASS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CLASS, ValaClassClass))

typedef struct _ValaClass ValaClass;
typedef struct _ValaClassClass ValaClassClass;

#define VALA_TYPE_INTERFACE (vala_interface_get_type ())
#define VALA_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INTERFACE, ValaInterface))
#define VALA_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INTERFACE, ValaInterfaceClass))
#define VALA_IS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INTERFACE))
#define VALA_IS_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INTERFACE))
#define VALA_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INTERFACE, ValaInterfaceClass))

typedef struct _ValaInterface ValaInterface;
typedef struct _ValaInterfaceClass ValaInterfaceClass;

#define VALA_TYPE_STRUCT (vala_struct_get_type ())
#define VALA_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_STRUCT, ValaStruct))
#define VALA_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_STRUCT, ValaStructClass))
#define VALA_IS_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_STRUCT))
#define VALA_IS_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_STRUCT))
#define VALA_STRUCT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_STRUCT, ValaStructClass))

typedef struct _ValaStruct ValaStruct;
typedef struct _ValaStructClass ValaStructClass;

#define VALA_TYPE_ENUM (vala_enum_get_type ())
#define VALA_ENUM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ENUM, ValaEnum))
#define VALA_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ENUM, ValaEnumClass))
#define VALA_IS_ENUM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ENUM))
#define VALA_IS_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ENUM))
#define VALA_ENUM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ENUM, ValaEnumClass))

typedef struct _ValaEnum ValaEnum;
typedef struct _ValaEnumClass ValaEnumClass;

#define VALA_TYPE_ERROR_DOMAIN (vala_error_domain_get_type ())
#define VALA_ERROR_DOMAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain))
#define VALA_ERROR_DOMAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomainClass))
#define VALA_IS_ERROR_DOMAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ERROR_DOMAIN))
#define VALA_IS_ERROR_DOMAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ERROR_DOMAIN))
#define VALA_ERROR_DOMAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomainClass))

typedef struct _ValaErrorDomain ValaErrorDomain;
typedef struct _ValaErrorDomainClass ValaErrorDomainClass;

#define VALA_TYPE_DELEGATE (vala_delegate_get_type ())
#define VALA_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DELEGATE, ValaDelegate))
#define VALA_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DELEGATE, ValaDelegateClass))
#define VALA_IS_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DELEGATE))
#define VALA_IS_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DELEGATE))
#define VALA_DELEGATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DELEGATE, ValaDelegateClass))

typedef struct _ValaDelegate ValaDelegate;
typedef struct _ValaDelegateClass ValaDelegateClass;

#define VALA_TYPE_CONSTANT (vala_constant_get_type ())
#define VALA_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONSTANT, ValaConstant))
#define VALA_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONSTANT, ValaConstantClass))
#define VALA_IS_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONSTANT))
#define VALA_IS_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONSTANT))
#define VALA_CONSTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONSTANT, ValaConstantClass))

typedef struct _ValaConstant ValaConstant;
typedef struct _ValaConstantClass ValaConstantClass;

#define VALA_TYPE_FIELD (vala_field_get_type ())
#define VALA_FIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FIELD, ValaField))
#define VALA_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FIELD, ValaFieldClass))
#define VALA_IS_FIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FIELD))
#define VALA_IS_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FIELD))
#define VALA_FIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FIELD, ValaFieldClass))

typedef struct _ValaField ValaField;
typedef struct _ValaFieldClass ValaFieldClass;

#define VALA_TYPE_METHOD (vala_method_get_type ())
#define VALA_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_METHOD, ValaMethod))
#define VALA_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_METHOD, ValaMethodClass))
#define VALA_IS_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_METHOD))
#define VALA_IS_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_METHOD))
#define VALA_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_METHOD, ValaMethodClass))

typedef struct _ValaMethod ValaMethod;
typedef struct _ValaMethodClass ValaMethodClass;

#define VALA_TYPE_PROPERTY (vala_property_get_type ())
#define VALA_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_PROPERTY, ValaProperty))
#define VALA_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_PROPERTY, ValaPropertyClass))
#define VALA_IS_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_PROPERTY))
#define VALA_IS_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_PROPERTY))
#define VALA_PROPERTY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_PROPERTY, ValaPropertyClass))

typedef struct _ValaProperty ValaProperty;
typedef struct _ValaPropertyClass ValaPropertyClass;

#define VALA_TYPE_SIGNAL (vala_signal_get_type ())
#define VALA_SIGNAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SIGNAL, ValaSignal))
#define VALA_SIGNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SIGNAL, ValaSignalClass))
#define VALA_IS_SIGNAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SIGNAL))
#define VALA_IS_SIGNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SIGNAL))
#define VALA_SIGNAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SIGNAL, ValaSignalClass))

typedef struct _ValaSignal ValaSignal;
typedef struct _ValaSignalClass ValaSignalClass;

#define VALA_TYPE_CONSTRUCTOR (vala_constructor_get_type ())
#define VALA_CONSTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONSTRUCTOR, ValaConstructor))
#define VALA_CONSTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONSTRUCTOR, ValaConstructorClass))
#define VALA_IS_CONSTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONSTRUCTOR))
#define VALA_IS_CONSTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONSTRUCTOR))
#define VALA_CONSTRUCTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONSTRUCTOR, ValaConstructorClass))

typedef struct _ValaConstructor ValaConstructor;
typedef struct _ValaConstructorClass ValaConstructorClass;

#define VALA_TYPE_DESTRUCTOR (vala_destructor_get_type ())
#define VALA_DESTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DESTRUCTOR, ValaDestructor))
#define VALA_DESTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DESTRUCTOR, ValaDestructorClass))
#define VALA_IS_DESTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DESTRUCTOR))
#define VALA_IS_DESTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DESTRUCTOR))
#define VALA_DESTRUCTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DESTRUCTOR, ValaDestructorClass))

typedef struct _ValaDestructor ValaDestructor;
typedef struct _ValaDestructorClass ValaDestructorClass;
typedef struct _ValaTypeSymbolPrivate ValaTypeSymbolPrivate;
typedef struct _ValaObjectTypeSymbolPrivate ValaObjectTypeSymbolPrivate;
typedef struct _ValaClassPrivate ValaClassPrivate;
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

#define VALA_TYPE_SOURCE_REFERENCE (vala_source_reference_get_type ())
#define VALA_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReference))
#define VALA_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))
#define VALA_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))

typedef struct _ValaSourceReference ValaSourceReference;
typedef struct _ValaSourceReferenceClass ValaSourceReferenceClass;

#define VALA_TYPE_COMMENT (vala_comment_get_type ())
#define VALA_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_COMMENT, ValaComment))
#define VALA_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_COMMENT, ValaCommentClass))
#define VALA_IS_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_COMMENT))
#define VALA_IS_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_COMMENT))
#define VALA_COMMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_COMMENT, ValaCommentClass))

typedef struct _ValaComment ValaComment;
typedef struct _ValaCommentClass ValaCommentClass;

#define VALA_TYPE_SCOPE (vala_scope_get_type ())
#define VALA_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SCOPE, ValaScope))
#define VALA_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SCOPE, ValaScopeClass))
#define VALA_IS_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SCOPE))
#define VALA_IS_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SCOPE))
#define VALA_SCOPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SCOPE, ValaScopeClass))

typedef struct _ValaScope ValaScope;
typedef struct _ValaScopeClass ValaScopeClass;

#define VALA_TYPE_CODE_CONTEXT (vala_code_context_get_type ())
#define VALA_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContext))
#define VALA_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))
#define VALA_IS_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_CONTEXT))
#define VALA_IS_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_CONTEXT))
#define VALA_CODE_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))

typedef struct _ValaCodeContext ValaCodeContext;
typedef struct _ValaCodeContextClass ValaCodeContextClass;

#define VALA_TYPE_PROFILE (vala_profile_get_type ())
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))

#define TYPE_MEMBER_BINDING (member_binding_get_type ())

#define VALA_TYPE_SYMBOL_ACCESSIBILITY (vala_symbol_accessibility_get_type ())

#define VALA_TYPE_PROPERTY_ACCESSOR (vala_property_accessor_get_type ())
#define VALA_PROPERTY_ACCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_PROPERTY_ACCESSOR, ValaPropertyAccessor))
#define VALA_PROPERTY_ACCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_PROPERTY_ACCESSOR, ValaPropertyAccessorClass))
#define VALA_IS_PROPERTY_ACCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_PROPERTY_ACCESSOR))
#define VALA_IS_PROPERTY_ACCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_PROPERTY_ACCESSOR))
#define VALA_PROPERTY_ACCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_PROPERTY_ACCESSOR, ValaPropertyAccessorClass))

typedef struct _ValaPropertyAccessor ValaPropertyAccessor;
typedef struct _ValaPropertyAccessorClass ValaPropertyAccessorClass;

#define VALA_TYPE_BLOCK (vala_block_get_type ())
#define VALA_BLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_BLOCK, ValaBlock))
#define VALA_BLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_BLOCK, ValaBlockClass))
#define VALA_IS_BLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_BLOCK))
#define VALA_IS_BLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_BLOCK))
#define VALA_BLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_BLOCK, ValaBlockClass))

typedef struct _ValaBlock ValaBlock;
typedef struct _ValaBlockClass ValaBlockClass;

#define VALA_TYPE_CREATION_METHOD (vala_creation_method_get_type ())
#define VALA_CREATION_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CREATION_METHOD, ValaCreationMethod))
#define VALA_CREATION_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CREATION_METHOD, ValaCreationMethodClass))
#define VALA_IS_CREATION_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CREATION_METHOD))
#define VALA_IS_CREATION_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CREATION_METHOD))
#define VALA_CREATION_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CREATION_METHOD, ValaCreationMethodClass))

typedef struct _ValaCreationMethod ValaCreationMethod;
typedef struct _ValaCreationMethodClass ValaCreationMethodClass;

#define VALA_TYPE_FORMAL_PARAMETER (vala_formal_parameter_get_type ())
#define VALA_FORMAL_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FORMAL_PARAMETER, ValaFormalParameter))
#define VALA_FORMAL_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FORMAL_PARAMETER, ValaFormalParameterClass))
#define VALA_IS_FORMAL_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FORMAL_PARAMETER))
#define VALA_IS_FORMAL_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FORMAL_PARAMETER))
#define VALA_FORMAL_PARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FORMAL_PARAMETER, ValaFormalParameterClass))

typedef struct _ValaFormalParameter ValaFormalParameter;
typedef struct _ValaFormalParameterClass ValaFormalParameterClass;

#define VALA_TYPE_REFERENCE_TYPE (vala_reference_type_get_type ())
#define VALA_REFERENCE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_REFERENCE_TYPE, ValaReferenceType))
#define VALA_REFERENCE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_REFERENCE_TYPE, ValaReferenceTypeClass))
#define VALA_IS_REFERENCE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_REFERENCE_TYPE))
#define VALA_IS_REFERENCE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_REFERENCE_TYPE))
#define VALA_REFERENCE_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_REFERENCE_TYPE, ValaReferenceTypeClass))

typedef struct _ValaReferenceType ValaReferenceType;
typedef struct _ValaReferenceTypeClass ValaReferenceTypeClass;

#define VALA_TYPE_OBJECT_TYPE (vala_object_type_get_type ())
#define VALA_OBJECT_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_OBJECT_TYPE, ValaObjectType))
#define VALA_OBJECT_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_OBJECT_TYPE, ValaObjectTypeClass))
#define VALA_IS_OBJECT_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_OBJECT_TYPE))
#define VALA_IS_OBJECT_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_OBJECT_TYPE))
#define VALA_OBJECT_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_OBJECT_TYPE, ValaObjectTypeClass))

typedef struct _ValaObjectType ValaObjectType;
typedef struct _ValaObjectTypeClass ValaObjectTypeClass;

#define VALA_TYPE_VOID_TYPE (vala_void_type_get_type ())
#define VALA_VOID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VOID_TYPE, ValaVoidType))
#define VALA_VOID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VOID_TYPE, ValaVoidTypeClass))
#define VALA_IS_VOID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VOID_TYPE))
#define VALA_IS_VOID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VOID_TYPE))
#define VALA_VOID_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VOID_TYPE, ValaVoidTypeClass))

typedef struct _ValaVoidType ValaVoidType;
typedef struct _ValaVoidTypeClass ValaVoidTypeClass;

#define VALA_TYPE_TYPEPARAMETER (vala_typeparameter_get_type ())
#define VALA_TYPEPARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPEPARAMETER, ValaTypeParameter))
#define VALA_TYPEPARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPEPARAMETER, ValaTypeParameterClass))
#define VALA_IS_TYPEPARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPEPARAMETER))
#define VALA_IS_TYPEPARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPEPARAMETER))
#define VALA_TYPEPARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPEPARAMETER, ValaTypeParameterClass))

typedef struct _ValaTypeParameter ValaTypeParameter;
typedef struct _ValaTypeParameterClass ValaTypeParameterClass;

#define VALA_TYPE_SOURCE_FILE (vala_source_file_get_type ())
#define VALA_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFile))
#define VALA_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))
#define VALA_IS_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_FILE))
#define VALA_IS_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_FILE))
#define VALA_SOURCE_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))

typedef struct _ValaSourceFile ValaSourceFile;
typedef struct _ValaSourceFileClass ValaSourceFileClass;
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))

#define TYPE_SOURCE_FILE_TYPE (source_file_type_get_type ())

struct _ValaCodeNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCodeNodePrivate * priv;
	GList* attributes;
};

struct _ValaCodeNodeClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCodeNode *self);
	void (*accept) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	void (*accept_children) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	gboolean (*check) (ValaCodeNode* self, ValaSemanticAnalyzer* analyzer);
	void (*emit) (ValaCodeNode* self, ValaCodeGenerator* codegen);
	void (*replace_type) (ValaCodeNode* self, ValaDataType* old_type, ValaDataType* new_type);
	void (*replace_expression) (ValaCodeNode* self, ValaExpression* old_node, ValaExpression* new_node);
	char* (*to_string) (ValaCodeNode* self);
	void (*get_defined_variables) (ValaCodeNode* self, ValaCollection* collection);
	void (*get_used_variables) (ValaCodeNode* self, ValaCollection* collection);
};

struct _ValaSymbol {
	ValaCodeNode parent_instance;
	ValaSymbolPrivate * priv;
};

struct _ValaSymbolClass {
	ValaCodeNodeClass parent_class;
	char* (*get_cprefix) (ValaSymbol* self);
	char* (*get_lower_case_cname) (ValaSymbol* self, const char* infix);
	char* (*get_lower_case_cprefix) (ValaSymbol* self);
	ValaList* (*get_cheader_filenames) (ValaSymbol* self);
	gboolean (*is_instance_member) (ValaSymbol* self);
	gboolean (*is_class_member) (ValaSymbol* self);
	void (*process_deprecated_attribute) (ValaSymbol* self, ValaAttribute* attr);
	void (*add_namespace) (ValaSymbol* self, ValaNamespace* ns);
	void (*add_class) (ValaSymbol* self, ValaClass* cl);
	void (*add_interface) (ValaSymbol* self, ValaInterface* iface);
	void (*add_struct) (ValaSymbol* self, ValaStruct* st);
	void (*add_enum) (ValaSymbol* self, ValaEnum* en);
	void (*add_error_domain) (ValaSymbol* self, ValaErrorDomain* edomain);
	void (*add_delegate) (ValaSymbol* self, ValaDelegate* d);
	void (*add_constant) (ValaSymbol* self, ValaConstant* constant);
	void (*add_field) (ValaSymbol* self, ValaField* f);
	void (*add_method) (ValaSymbol* self, ValaMethod* m);
	void (*add_property) (ValaSymbol* self, ValaProperty* prop);
	void (*add_signal) (ValaSymbol* self, ValaSignal* sig);
	void (*add_constructor) (ValaSymbol* self, ValaConstructor* c);
	void (*add_destructor) (ValaSymbol* self, ValaDestructor* d);
};

struct _ValaTypeSymbol {
	ValaSymbol parent_instance;
	ValaTypeSymbolPrivate * priv;
};

struct _ValaTypeSymbolClass {
	ValaSymbolClass parent_class;
	char* (*get_cname) (ValaTypeSymbol* self, gboolean const_type);
	gboolean (*is_reference_type) (ValaTypeSymbol* self);
	char* (*get_dup_function) (ValaTypeSymbol* self);
	char* (*get_free_function) (ValaTypeSymbol* self);
	char* (*get_copy_function) (ValaTypeSymbol* self);
	char* (*get_destroy_function) (ValaTypeSymbol* self);
	gboolean (*is_reference_counting) (ValaTypeSymbol* self);
	char* (*get_ref_function) (ValaTypeSymbol* self);
	char* (*get_unref_function) (ValaTypeSymbol* self);
	char* (*get_ref_sink_function) (ValaTypeSymbol* self);
	char* (*get_type_id) (ValaTypeSymbol* self);
	char* (*get_marshaller_type_name) (ValaTypeSymbol* self);
	char* (*get_param_spec_function) (ValaTypeSymbol* self);
	char* (*get_get_value_function) (ValaTypeSymbol* self);
	char* (*get_set_value_function) (ValaTypeSymbol* self);
	char* (*get_take_value_function) (ValaTypeSymbol* self);
	char* (*get_upper_case_cname) (ValaTypeSymbol* self, const char* infix);
	char* (*get_default_value) (ValaTypeSymbol* self);
	gboolean (*is_subtype_of) (ValaTypeSymbol* self, ValaTypeSymbol* t);
	gint (*get_type_parameter_index) (ValaTypeSymbol* self, const char* name);
};

struct _ValaObjectTypeSymbol {
	ValaTypeSymbol parent_instance;
	ValaObjectTypeSymbolPrivate * priv;
};

struct _ValaObjectTypeSymbolClass {
	ValaTypeSymbolClass parent_class;
	ValaList* (*get_methods) (ValaObjectTypeSymbol* self);
	ValaList* (*get_signals) (ValaObjectTypeSymbol* self);
	ValaList* (*get_properties) (ValaObjectTypeSymbol* self);
};

struct _ValaClass {
	ValaObjectTypeSymbol parent_instance;
	ValaClassPrivate * priv;
};

struct _ValaClassClass {
	ValaObjectTypeSymbolClass parent_class;
};

struct _ValaClassPrivate {
	ValaClass* _base_class;
	gboolean _is_abstract;
	char* _type_check_function;
	gboolean _has_private_fields;
	gboolean _has_class_private_fields;
	gboolean _free_function_address_of;
	char* cname;
	char* _const_cname;
	char* lower_case_cprefix;
	char* lower_case_csuffix;
	char* type_id;
	char* ref_function;
	char* unref_function;
	gboolean _ref_function_void;
	char* ref_sink_function;
	char* param_spec_function;
	char* copy_function;
	char* free_function;
	char* marshaller_type_name;
	char* get_value_function;
	char* set_value_function;
	char* take_value_function;
	gboolean _is_compact;
	gboolean _is_immutable;
	ValaList* base_types;
	ValaList* constants;
	ValaList* fields;
	ValaList* methods;
	ValaList* properties;
	ValaList* signals;
	ValaList* classes;
	ValaList* structs;
	ValaList* enums;
	ValaList* delegates;
	ValaMethod* _default_construction_method;
	ValaConstructor* _constructor;
	ValaConstructor* _class_constructor;
	ValaConstructor* _static_constructor;
	ValaDestructor* _static_destructor;
	ValaDestructor* _class_destructor;
	ValaDestructor* _destructor;
};

typedef enum  {
	VALA_PROFILE_POSIX,
	VALA_PROFILE_GOBJECT,
	VALA_PROFILE_DOVA
} ValaProfile;

typedef enum  {
	MEMBER_BINDING_INSTANCE,
	MEMBER_BINDING_CLASS,
	MEMBER_BINDING_STATIC
} MemberBinding;

typedef enum  {
	VALA_SYMBOL_ACCESSIBILITY_PRIVATE,
	VALA_SYMBOL_ACCESSIBILITY_INTERNAL,
	VALA_SYMBOL_ACCESSIBILITY_PROTECTED,
	VALA_SYMBOL_ACCESSIBILITY_PUBLIC
} ValaSymbolAccessibility;

typedef enum  {
	SOURCE_FILE_TYPE_NONE,
	SOURCE_FILE_TYPE_SOURCE,
	SOURCE_FILE_TYPE_PACKAGE,
	SOURCE_FILE_TYPE_FAST
} SourceFileType;


static gpointer vala_class_parent_class = NULL;

gpointer vala_code_node_ref (gpointer instance);
void vala_code_node_unref (gpointer instance);
GParamSpec* vala_param_spec_code_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_node (GValue* value, gpointer v_object);
void vala_value_take_code_node (GValue* value, gpointer v_object);
gpointer vala_value_get_code_node (const GValue* value);
GType vala_code_node_get_type (void) G_GNUC_CONST;
gpointer vala_code_visitor_ref (gpointer instance);
void vala_code_visitor_unref (gpointer instance);
GParamSpec* vala_param_spec_code_visitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_visitor (GValue* value, gpointer v_object);
void vala_value_take_code_visitor (GValue* value, gpointer v_object);
gpointer vala_value_get_code_visitor (const GValue* value);
GType vala_code_visitor_get_type (void) G_GNUC_CONST;
GType vala_semantic_analyzer_get_type (void) G_GNUC_CONST;
GType vala_code_generator_get_type (void) G_GNUC_CONST;
GType vala_data_type_get_type (void) G_GNUC_CONST;
GType vala_expression_get_type (void) G_GNUC_CONST;
GType vala_symbol_get_type (void) G_GNUC_CONST;
GType vala_variable_get_type (void) G_GNUC_CONST;
GType vala_local_variable_get_type (void) G_GNUC_CONST;
GType vala_attribute_get_type (void) G_GNUC_CONST;
GType vala_namespace_get_type (void) G_GNUC_CONST;
GType vala_typesymbol_get_type (void) G_GNUC_CONST;
GType vala_object_type_symbol_get_type (void) G_GNUC_CONST;
GType vala_class_get_type (void) G_GNUC_CONST;
GType vala_interface_get_type (void) G_GNUC_CONST;
GType vala_struct_get_type (void) G_GNUC_CONST;
GType vala_enum_get_type (void) G_GNUC_CONST;
GType vala_error_domain_get_type (void) G_GNUC_CONST;
GType vala_delegate_get_type (void) G_GNUC_CONST;
GType vala_constant_get_type (void) G_GNUC_CONST;
GType vala_field_get_type (void) G_GNUC_CONST;
GType vala_method_get_type (void) G_GNUC_CONST;
GType vala_property_get_type (void) G_GNUC_CONST;
GType vala_signal_get_type (void) G_GNUC_CONST;
GType vala_constructor_get_type (void) G_GNUC_CONST;
GType vala_destructor_get_type (void) G_GNUC_CONST;
#define VALA_CLASS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CLASS, ValaClassPrivate))
enum  {
	VALA_CLASS_DUMMY_PROPERTY
};
ValaList* vala_class_get_classes (ValaClass* self);
ValaList* vala_class_get_structs (ValaClass* self);
ValaList* vala_class_get_enums (ValaClass* self);
ValaList* vala_class_get_delegates (ValaClass* self);
gpointer vala_source_reference_ref (gpointer instance);
void vala_source_reference_unref (gpointer instance);
GParamSpec* vala_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_reference (GValue* value, gpointer v_object);
void vala_value_take_source_reference (GValue* value, gpointer v_object);
gpointer vala_value_get_source_reference (const GValue* value);
GType vala_source_reference_get_type (void) G_GNUC_CONST;
gpointer vala_comment_ref (gpointer instance);
void vala_comment_unref (gpointer instance);
GParamSpec* vala_param_spec_comment (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_comment (GValue* value, gpointer v_object);
void vala_value_take_comment (GValue* value, gpointer v_object);
gpointer vala_value_get_comment (const GValue* value);
GType vala_comment_get_type (void) G_GNUC_CONST;
ValaClass* vala_class_new (const char* name, ValaSourceReference* source_reference, ValaComment* comment);
ValaClass* vala_class_construct (GType object_type, const char* name, ValaSourceReference* source_reference, ValaComment* comment);
ValaObjectTypeSymbol* vala_object_type_symbol_construct (GType object_type, const char* name, ValaSourceReference* source_reference, ValaComment* comment);
void vala_class_add_base_type (ValaClass* self, ValaDataType* type);
void vala_code_node_set_parent_node (ValaCodeNode* self, ValaCodeNode* value);
ValaList* vala_class_get_base_types (ValaClass* self);
static void vala_class_real_add_constant (ValaSymbol* base, ValaConstant* c);
gpointer vala_scope_ref (gpointer instance);
void vala_scope_unref (gpointer instance);
GParamSpec* vala_param_spec_scope (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_scope (GValue* value, gpointer v_object);
void vala_value_take_scope (GValue* value, gpointer v_object);
gpointer vala_value_get_scope (const GValue* value);
GType vala_scope_get_type (void) G_GNUC_CONST;
ValaScope* vala_symbol_get_scope (ValaSymbol* self);
void vala_scope_add (ValaScope* self, const char* name, ValaSymbol* sym);
const char* vala_symbol_get_name (ValaSymbol* self);
static void vala_class_real_add_field (ValaSymbol* base, ValaField* f);
gpointer vala_code_context_ref (gpointer instance);
void vala_code_context_unref (gpointer instance);
GParamSpec* vala_param_spec_code_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_context (GValue* value, gpointer v_object);
void vala_value_take_code_context (GValue* value, gpointer v_object);
gpointer vala_value_get_code_context (const GValue* value);
GType vala_code_context_get_type (void) G_GNUC_CONST;
ValaCodeContext* vala_code_context_get (void);
GType vala_profile_get_type (void) G_GNUC_CONST;
ValaProfile vala_code_context_get_profile (ValaCodeContext* self);
GType member_binding_get_type (void) G_GNUC_CONST;
MemberBinding vala_field_get_binding (ValaField* self);
GType vala_symbol_accessibility_get_type (void) G_GNUC_CONST;
ValaSymbolAccessibility vala_symbol_get_access (ValaSymbol* self);
ValaDataType* vala_variable_get_variable_type (ValaVariable* self);
ValaDataType* vala_data_type_copy (ValaDataType* self);
ValaSourceReference* vala_code_node_get_source_reference (ValaCodeNode* self);
ValaComment* vala_symbol_get_comment (ValaSymbol* self);
GType vala_property_accessor_get_type (void) G_GNUC_CONST;
ValaProperty* vala_property_new (const char* name, ValaDataType* property_type, ValaPropertyAccessor* get_accessor, ValaPropertyAccessor* set_accessor, ValaSourceReference* source_reference, ValaComment* comment);
ValaProperty* vala_property_construct (GType object_type, const char* name, ValaDataType* property_type, ValaPropertyAccessor* get_accessor, ValaPropertyAccessor* set_accessor, ValaSourceReference* source_reference, ValaComment* comment);
void vala_symbol_set_access (ValaSymbol* self, ValaSymbolAccessibility value);
ValaDataType* vala_property_get_property_type (ValaProperty* self);
void vala_data_type_set_value_owned (ValaDataType* self, gboolean value);
GType vala_block_get_type (void) G_GNUC_CONST;
ValaPropertyAccessor* vala_property_accessor_new (gboolean readable, gboolean writable, gboolean construction, ValaDataType* value_type, ValaBlock* body, ValaSourceReference* source_reference, ValaComment* comment);
ValaPropertyAccessor* vala_property_accessor_construct (GType object_type, gboolean readable, gboolean writable, gboolean construction, ValaDataType* value_type, ValaBlock* body, ValaSourceReference* source_reference, ValaComment* comment);
void vala_property_set_get_accessor (ValaProperty* self, ValaPropertyAccessor* value);
ValaPropertyAccessor* vala_property_get_get_accessor (ValaProperty* self);
void vala_property_set_set_accessor (ValaProperty* self, ValaPropertyAccessor* value);
ValaPropertyAccessor* vala_property_get_set_accessor (ValaProperty* self);
void vala_symbol_set_name (ValaSymbol* self, const char* value);
void vala_property_set_field (ValaProperty* self, ValaField* value);
void vala_symbol_add_property (ValaSymbol* self, ValaProperty* prop);
static void vala_class_set_has_private_fields (ValaClass* self, gboolean value);
static void vala_class_set_has_class_private_fields (ValaClass* self, gboolean value);
ValaList* vala_class_get_fields (ValaClass* self);
ValaList* vala_class_get_constants (ValaClass* self);
static void vala_class_real_add_method (ValaSymbol* base, ValaMethod* m);
MemberBinding vala_method_get_binding (ValaMethod* self);
GType vala_creation_method_get_type (void) G_GNUC_CONST;
GType vala_formal_parameter_get_type (void) G_GNUC_CONST;
ValaFormalParameter* vala_method_get_this_parameter (ValaMethod* self);
void vala_scope_remove (ValaScope* self, const char* name);
GType vala_reference_type_get_type (void) G_GNUC_CONST;
GType vala_object_type_get_type (void) G_GNUC_CONST;
ValaObjectType* vala_object_type_symbol_get_this_type (ValaObjectTypeSymbol* self);
ValaFormalParameter* vala_formal_parameter_new (const char* name, ValaDataType* variable_type, ValaSourceReference* source_reference);
ValaFormalParameter* vala_formal_parameter_construct (GType object_type, const char* name, ValaDataType* variable_type, ValaSourceReference* source_reference);
void vala_method_set_this_parameter (ValaMethod* self, ValaFormalParameter* value);
ValaDataType* vala_method_get_return_type (ValaMethod* self);
GType vala_void_type_get_type (void) G_GNUC_CONST;
ValaList* vala_method_get_postconditions (ValaMethod* self);
ValaLocalVariable* vala_method_get_result_var (ValaMethod* self);
ValaLocalVariable* vala_local_variable_new (ValaDataType* variable_type, const char* name, ValaExpression* initializer, ValaSourceReference* source_reference);
ValaLocalVariable* vala_local_variable_construct (GType object_type, ValaDataType* variable_type, const char* name, ValaExpression* initializer, ValaSourceReference* source_reference);
void vala_method_set_result_var (ValaMethod* self, ValaLocalVariable* value);
void vala_local_variable_set_is_result (ValaLocalVariable* self, gboolean value);
void vala_class_set_default_construction_method (ValaClass* self, ValaMethod* value);
const char* vala_creation_method_get_class_name (ValaCreationMethod* self);
void vala_report_error (ValaSourceReference* source, const char* message);
char* vala_symbol_get_full_name (ValaSymbol* self);
void vala_code_node_set_error (ValaCodeNode* self, gboolean value);
static ValaList* vala_class_real_get_methods (ValaObjectTypeSymbol* base);
static void vala_class_real_add_property (ValaSymbol* base, ValaProperty* prop);
void vala_property_set_this_parameter (ValaProperty* self, ValaFormalParameter* value);
ValaFormalParameter* vala_property_get_this_parameter (ValaProperty* self);
ValaField* vala_property_get_field (ValaProperty* self);
void vala_symbol_add_field (ValaSymbol* self, ValaField* f);
static ValaList* vala_class_real_get_properties (ValaObjectTypeSymbol* base);
static void vala_class_real_add_signal (ValaSymbol* base, ValaSignal* sig);
static ValaList* vala_class_real_get_signals (ValaObjectTypeSymbol* base);
static void vala_class_real_add_class (ValaSymbol* base, ValaClass* cl);
static void vala_class_real_add_struct (ValaSymbol* base, ValaStruct* st);
static void vala_class_real_add_enum (ValaSymbol* base, ValaEnum* en);
static void vala_class_real_add_delegate (ValaSymbol* base, ValaDelegate* d);
static void vala_class_real_add_constructor (ValaSymbol* base, ValaConstructor* c);
MemberBinding vala_constructor_get_binding (ValaConstructor* self);
ValaConstructor* vala_class_get_constructor (ValaClass* self);
void vala_class_set_constructor (ValaClass* self, ValaConstructor* value);
ValaConstructor* vala_class_get_class_constructor (ValaClass* self);
void vala_class_set_class_constructor (ValaClass* self, ValaConstructor* value);
ValaConstructor* vala_class_get_static_constructor (ValaClass* self);
void vala_class_set_static_constructor (ValaClass* self, ValaConstructor* value);
static void vala_class_real_add_destructor (ValaSymbol* base, ValaDestructor* d);
MemberBinding vala_destructor_get_binding (ValaDestructor* self);
ValaDestructor* vala_class_get_destructor (ValaClass* self);
void vala_class_set_destructor (ValaClass* self, ValaDestructor* value);
ValaDestructor* vala_class_get_class_destructor (ValaClass* self);
void vala_class_set_class_destructor (ValaClass* self, ValaDestructor* value);
ValaDestructor* vala_class_get_static_destructor (ValaClass* self);
void vala_class_set_static_destructor (ValaClass* self, ValaDestructor* value);
static void vala_class_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
void vala_code_visitor_visit_class (ValaCodeVisitor* self, ValaClass* cl);
static void vala_class_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
void vala_code_node_accept (ValaCodeNode* self, ValaCodeVisitor* visitor);
GType vala_typeparameter_get_type (void) G_GNUC_CONST;
ValaList* vala_object_type_symbol_get_type_parameters (ValaObjectTypeSymbol* self);
static char* vala_class_real_get_cprefix (ValaSymbol* base);
char* vala_typesymbol_get_cname (ValaTypeSymbol* self, gboolean const_type);
static char* vala_class_real_get_cname (ValaTypeSymbol* base, gboolean const_type);
const char* vala_class_get_const_cname (ValaClass* self);
gboolean vala_class_get_is_immutable (ValaClass* self);
ValaAttribute* vala_code_node_get_attribute (ValaCodeNode* self, const char* name);
char* vala_attribute_get_string (ValaAttribute* self, const char* name);
char* vala_class_get_default_cname (ValaClass* self);
ValaSymbol* vala_symbol_get_parent_symbol (ValaSymbol* self);
char* vala_symbol_get_cprefix (ValaSymbol* self);
void vala_class_set_cname (ValaClass* self, const char* cname);
static char* vala_class_get_lower_case_csuffix (ValaClass* self);
char* vala_symbol_camel_case_to_lower_case (const char* camel_case);
static char* vala_class_real_get_lower_case_cname (ValaSymbol* base, const char* infix);
char* vala_symbol_get_lower_case_cprefix (ValaSymbol* self);
static char* vala_class_real_get_lower_case_cprefix (ValaSymbol* base);
char* vala_symbol_get_lower_case_cname (ValaSymbol* self, const char* infix);
static char* vala_class_real_get_upper_case_cname (ValaTypeSymbol* base, const char* infix);
static gboolean vala_class_real_is_reference_type (ValaTypeSymbol* base);
static void vala_class_process_gir_attribute (ValaClass* self, ValaAttribute* a);
gboolean vala_attribute_has_argument (ValaAttribute* self, const char* name);
void vala_symbol_set_gir_name (ValaSymbol* self, const char* value);
static void vala_class_process_ccode_attribute (ValaClass* self, ValaAttribute* a);
void vala_class_set_ref_function (ValaClass* self, const char* name);
gboolean vala_attribute_get_bool (ValaAttribute* self, const char* name);
void vala_class_set_ref_function_void (ValaClass* self, gboolean value);
void vala_class_set_unref_function (ValaClass* self, const char* name);
void vala_class_set_ref_sink_function (ValaClass* self, const char* name);
void vala_class_set_dup_function (ValaClass* self, const char* name);
void vala_class_set_free_function (ValaClass* self, const char* name);
static void vala_class_set_free_function_address_of (ValaClass* self, gboolean value);
void vala_class_set_const_cname (ValaClass* self, const char* value);
void vala_symbol_add_cheader_filename (ValaSymbol* self, const char* filename);
void vala_class_set_type_check_function (ValaClass* self, const char* value);
void vala_class_process_attributes (ValaClass* self);
const char* vala_attribute_get_name (ValaAttribute* self);
void vala_class_set_is_compact (ValaClass* self, gboolean value);
void vala_class_set_is_immutable (ValaClass* self, gboolean value);
void vala_symbol_process_deprecated_attribute (ValaSymbol* self, ValaAttribute* attr);
char* vala_class_get_default_type_id (ValaClass* self);
gboolean vala_class_get_is_compact (ValaClass* self);
char* vala_typesymbol_get_upper_case_cname (ValaTypeSymbol* self, const char* infix);
static char* vala_class_real_get_type_id (ValaTypeSymbol* base);
void vala_class_set_type_id (ValaClass* self, const char* type_id);
static char* vala_class_real_get_marshaller_type_name (ValaTypeSymbol* base);
ValaClass* vala_class_get_base_class (ValaClass* self);
char* vala_typesymbol_get_marshaller_type_name (ValaTypeSymbol* self);
char* vala_typesymbol_get_type_id (ValaTypeSymbol* self);
static char* vala_class_real_get_param_spec_function (ValaTypeSymbol* base);
char* vala_class_get_default_param_spec_function (ValaClass* self);
gboolean vala_class_is_fundamental (ValaClass* self);
char* vala_typesymbol_get_param_spec_function (ValaTypeSymbol* self);
static char* vala_class_real_get_get_value_function (ValaTypeSymbol* base);
char* vala_typesymbol_get_get_value_function (ValaTypeSymbol* self);
static char* vala_class_real_get_set_value_function (ValaTypeSymbol* base);
char* vala_typesymbol_get_set_value_function (ValaTypeSymbol* self);
static char* vala_class_real_get_take_value_function (ValaTypeSymbol* base);
char* vala_typesymbol_get_take_value_function (ValaTypeSymbol* self);
static gboolean vala_class_real_is_reference_counting (ValaTypeSymbol* base);
char* vala_typesymbol_get_ref_function (ValaTypeSymbol* self);
static char* vala_class_real_get_ref_function (ValaTypeSymbol* base);
static char* vala_class_real_get_unref_function (ValaTypeSymbol* base);
char* vala_typesymbol_get_unref_function (ValaTypeSymbol* self);
static char* vala_class_real_get_ref_sink_function (ValaTypeSymbol* base);
char* vala_typesymbol_get_ref_sink_function (ValaTypeSymbol* self);
static char* vala_class_real_get_dup_function (ValaTypeSymbol* base);
char* vala_class_get_default_free_function (ValaClass* self);
static char* vala_class_real_get_free_function (ValaTypeSymbol* base);
char* vala_typesymbol_get_free_function (ValaTypeSymbol* self);
static gboolean vala_class_real_is_subtype_of (ValaTypeSymbol* base, ValaTypeSymbol* t);
ValaTypeSymbol* vala_data_type_get_data_type (ValaDataType* self);
gboolean vala_typesymbol_is_subtype_of (ValaTypeSymbol* self, ValaTypeSymbol* t);
static void vala_class_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type);
static void vala_class_get_all_prerequisites (ValaClass* self, ValaInterface* iface, ValaList* list);
ValaList* vala_interface_get_prerequisites (ValaInterface* self);
static gboolean vala_class_class_is_a (ValaClass* self, ValaClass* cl, ValaTypeSymbol* t);
static gboolean vala_class_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer);
gboolean vala_code_node_get_checked (ValaCodeNode* self);
gboolean vala_code_node_get_error (ValaCodeNode* self);
void vala_code_node_set_checked (ValaCodeNode* self, gboolean value);
gpointer vala_source_file_ref (gpointer instance);
void vala_source_file_unref (gpointer instance);
GParamSpec* vala_param_spec_source_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_file (GValue* value, gpointer v_object);
void vala_value_take_source_file (GValue* value, gpointer v_object);
gpointer vala_value_get_source_file (const GValue* value);
GType vala_source_file_get_type (void) G_GNUC_CONST;
ValaSourceFile* vala_semantic_analyzer_get_current_source_file (ValaSemanticAnalyzer* self);
ValaSymbol* vala_semantic_analyzer_get_current_symbol (ValaSemanticAnalyzer* self);
ValaSourceFile* vala_source_reference_get_file (ValaSourceReference* self);
void vala_semantic_analyzer_set_current_source_file (ValaSemanticAnalyzer* self, ValaSourceFile* value);
void vala_semantic_analyzer_set_current_symbol (ValaSemanticAnalyzer* self, ValaSymbol* value);
gboolean vala_code_node_check (ValaCodeNode* self, ValaSemanticAnalyzer* analyzer);
char* vala_code_node_to_string (ValaCodeNode* self);
gboolean vala_semantic_analyzer_is_type_accessible (ValaSemanticAnalyzer* self, ValaSymbol* sym, ValaDataType* type);
ValaList* vala_data_type_get_type_arguments (ValaDataType* self);
gboolean vala_symbol_get_external (ValaSymbol* self);
gboolean vala_symbol_get_external_package (ValaSymbol* self);
GType source_file_type_get_type (void) G_GNUC_CONST;
SourceFileType vala_symbol_get_source_type (ValaSymbol* self);
ValaList* vala_object_type_symbol_get_methods (ValaObjectTypeSymbol* self);
gboolean vala_method_get_is_abstract (ValaMethod* self);
ValaSymbol* vala_scope_lookup (ValaScope* self, const char* name);
gboolean vala_symbol_check_deprecated (ValaSymbol* self, ValaSourceReference* source_ref);
void vala_symbol_set_used (ValaSymbol* self, gboolean value);
ValaList* vala_object_type_symbol_get_properties (ValaObjectTypeSymbol* self);
gboolean vala_property_get_is_abstract (ValaProperty* self);
gboolean vala_class_get_is_abstract (ValaClass* self);
ValaSymbol* vala_semantic_analyzer_symbol_lookup_inherited (ValaSymbol* sym, const char* name);
gboolean vala_method_get_overrides (ValaMethod* self);
gboolean vala_property_get_overrides (ValaProperty* self);
void vala_class_set_base_class (ValaClass* self, ValaClass* value);
void vala_class_set_is_abstract (ValaClass* self, gboolean value);
gboolean vala_class_get_ref_function_void (ValaClass* self);
const char* vala_class_get_type_check_function (ValaClass* self);
gboolean vala_class_get_has_private_fields (ValaClass* self);
gboolean vala_class_get_has_class_private_fields (ValaClass* self);
gboolean vala_class_get_free_function_address_of (ValaClass* self);
gboolean vala_class_get_is_gboxed (ValaClass* self);
ValaMethod* vala_class_get_default_construction_method (ValaClass* self);
ValaFormalParameter* vala_destructor_get_this_parameter (ValaDestructor* self);
void vala_destructor_set_this_parameter (ValaDestructor* self, ValaFormalParameter* value);
gboolean vala_class_get_is_error_base (ValaClass* self);
static void vala_class_finalize (ValaCodeNode* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);


/**
 * Returns a copy of the list of classes.
 *
 * @return list of classes
 */
static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList* vala_class_get_classes (ValaClass* self) {
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = _vala_iterable_ref0 (self->priv->classes);
	return result;
}


/**
 * Returns a copy of the list of structs.
 *
 * @return list of structs
 */
ValaList* vala_class_get_structs (ValaClass* self) {
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = _vala_iterable_ref0 (self->priv->structs);
	return result;
}


/**
 * Returns a copy of the list of enums.
 *
 * @return list of enums
 */
ValaList* vala_class_get_enums (ValaClass* self) {
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = _vala_iterable_ref0 (self->priv->enums);
	return result;
}


/**
 * Returns a copy of the list of delegates.
 *
 * @return list of delegates
 */
ValaList* vala_class_get_delegates (ValaClass* self) {
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = _vala_iterable_ref0 (self->priv->delegates);
	return result;
}


/**
 * Creates a new class.
 *
 * @param name   type name
 * @param source reference to source code
 * @param comment class documentation
 * @return       newly created class
 */
ValaClass* vala_class_construct (GType object_type, const char* name, ValaSourceReference* source_reference, ValaComment* comment) {
	ValaClass* self;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaClass*) vala_object_type_symbol_construct (object_type, name, source_reference, comment);
	return self;
}


ValaClass* vala_class_new (const char* name, ValaSourceReference* source_reference, ValaComment* comment) {
	return vala_class_construct (VALA_TYPE_CLASS, name, source_reference, comment);
}


/**
 * Adds the specified class or interface to the list of base types of
 * this class.
 *
 * @param type a class or interface reference
 */
void vala_class_add_base_type (ValaClass* self, ValaDataType* type) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	vala_collection_add ((ValaCollection*) self->priv->base_types, type);
	vala_code_node_set_parent_node ((ValaCodeNode*) type, (ValaCodeNode*) self);
}


/**
 * Returns a copy of the base type list.
 *
 * @return list of base types
 */
ValaList* vala_class_get_base_types (ValaClass* self) {
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = _vala_iterable_ref0 (self->priv->base_types);
	return result;
}


/**
 * Adds the specified constant as a member to this class.
 *
 * @param c a constant
 */
static void vala_class_real_add_constant (ValaSymbol* base, ValaConstant* c) {
	ValaClass * self;
	self = (ValaClass*) base;
	g_return_if_fail (c != NULL);
	vala_collection_add ((ValaCollection*) self->priv->constants, c);
	vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) self), vala_symbol_get_name ((ValaSymbol*) c), (ValaSymbol*) c);
}


/**
 * Adds the specified field as a member to this class.
 *
 * @param f a field
 */
static void vala_class_real_add_field (ValaSymbol* base, ValaField* f) {
	ValaClass * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	ValaCodeContext* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp12_ = FALSE;
	self = (ValaClass*) base;
	g_return_if_fail (f != NULL);
	if ((_tmp4_ = vala_code_context_get_profile (_tmp3_ = vala_code_context_get ()) == VALA_PROFILE_DOVA, _vala_code_context_unref0 (_tmp3_), _tmp4_)) {
		_tmp2_ = vala_field_get_binding (f) == MEMBER_BINDING_INSTANCE;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gboolean _tmp5_ = FALSE;
		if (vala_symbol_get_access ((ValaSymbol*) f) == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
			_tmp5_ = TRUE;
		} else {
			_tmp5_ = vala_symbol_get_access ((ValaSymbol*) f) == VALA_SYMBOL_ACCESSIBILITY_PROTECTED;
		}
		_tmp1_ = _tmp5_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = _vala_strcmp0 (vala_symbol_get_name ((ValaSymbol*) self), "any") != 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ValaDataType* _tmp6_;
		ValaProperty* _tmp7_;
		ValaProperty* prop;
		ValaDataType* get_type;
		ValaPropertyAccessor* _tmp8_;
		ValaDataType* _tmp9_;
		ValaPropertyAccessor* _tmp10_;
		char* _tmp11_;
		prop = (_tmp7_ = vala_property_new (vala_symbol_get_name ((ValaSymbol*) f), _tmp6_ = vala_data_type_copy (vala_variable_get_variable_type ((ValaVariable*) f)), NULL, NULL, vala_code_node_get_source_reference ((ValaCodeNode*) f), vala_symbol_get_comment ((ValaSymbol*) self)), _vala_code_node_unref0 (_tmp6_), _tmp7_);
		vala_symbol_set_access ((ValaSymbol*) prop, vala_symbol_get_access ((ValaSymbol*) self));
		get_type = vala_data_type_copy (vala_property_get_property_type (prop));
		vala_data_type_set_value_owned (get_type, TRUE);
		vala_property_set_get_accessor (prop, _tmp8_ = vala_property_accessor_new (TRUE, FALSE, FALSE, get_type, NULL, vala_code_node_get_source_reference ((ValaCodeNode*) f), NULL));
		_vala_code_node_unref0 (_tmp8_);
		vala_symbol_set_access ((ValaSymbol*) vala_property_get_get_accessor (prop), VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		vala_property_set_set_accessor (prop, _tmp10_ = vala_property_accessor_new (FALSE, TRUE, FALSE, _tmp9_ = vala_data_type_copy (vala_property_get_property_type (prop)), NULL, vala_code_node_get_source_reference ((ValaCodeNode*) f), NULL));
		_vala_code_node_unref0 (_tmp10_);
		_vala_code_node_unref0 (_tmp9_);
		vala_symbol_set_access ((ValaSymbol*) vala_property_get_set_accessor (prop), VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		vala_symbol_set_name ((ValaSymbol*) f, _tmp11_ = g_strdup_printf ("_%s", vala_symbol_get_name ((ValaSymbol*) f)));
		_g_free0 (_tmp11_);
		vala_symbol_set_access ((ValaSymbol*) f, VALA_SYMBOL_ACCESSIBILITY_PRIVATE);
		vala_property_set_field (prop, f);
		vala_symbol_add_property ((ValaSymbol*) self, prop);
		_vala_code_node_unref0 (get_type);
		_vala_code_node_unref0 (prop);
		return;
	}
	vala_collection_add ((ValaCollection*) self->priv->fields, f);
	if (vala_symbol_get_access ((ValaSymbol*) f) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		_tmp12_ = vala_field_get_binding (f) == MEMBER_BINDING_INSTANCE;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		vala_class_set_has_private_fields (self, TRUE);
	} else {
		gboolean _tmp13_ = FALSE;
		if (vala_symbol_get_access ((ValaSymbol*) f) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			_tmp13_ = vala_field_get_binding (f) == MEMBER_BINDING_CLASS;
		} else {
			_tmp13_ = FALSE;
		}
		if (_tmp13_) {
			vala_class_set_has_class_private_fields (self, TRUE);
		}
	}
	vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) self), vala_symbol_get_name ((ValaSymbol*) f), (ValaSymbol*) f);
}


/**
 * Returns a copy of the list of fields.
 *
 * @return list of fields
 */
ValaList* vala_class_get_fields (ValaClass* self) {
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = _vala_iterable_ref0 (self->priv->fields);
	return result;
}


/**
 * Returns a copy of the list of constants.
 *
 * @return list of constants
 */
ValaList* vala_class_get_constants (ValaClass* self) {
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = _vala_iterable_ref0 (self->priv->constants);
	return result;
}


/**
 * Adds the specified method as a member to this class.
 *
 * @param m a method
 */
static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


static void vala_class_real_add_method (ValaSymbol* base, ValaMethod* m) {
	ValaClass * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp3_ = FALSE;
	self = (ValaClass*) base;
	g_return_if_fail (m != NULL);
	if (vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = VALA_IS_CREATION_METHOD (m);
	}
	if (_tmp0_) {
		ValaObjectType* _tmp1_;
		ValaFormalParameter* _tmp2_;
		if (vala_method_get_this_parameter (m) != NULL) {
			vala_scope_remove (vala_symbol_get_scope ((ValaSymbol*) m), vala_symbol_get_name ((ValaSymbol*) vala_method_get_this_parameter (m)));
		}
		vala_method_set_this_parameter (m, _tmp2_ = vala_formal_parameter_new ("this", (ValaDataType*) (_tmp1_ = vala_object_type_symbol_get_this_type ((ValaObjectTypeSymbol*) self)), NULL));
		_vala_code_node_unref0 (_tmp2_);
		_vala_code_node_unref0 (_tmp1_);
		vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) m), vala_symbol_get_name ((ValaSymbol*) vala_method_get_this_parameter (m)), (ValaSymbol*) vala_method_get_this_parameter (m));
	}
	if (!VALA_IS_VOID_TYPE (vala_method_get_return_type (m))) {
		gboolean _tmp4_ = FALSE;
		ValaCodeContext* _tmp5_;
		gboolean _tmp6_;
		if ((_tmp6_ = vala_code_context_get_profile (_tmp5_ = vala_code_context_get ()) == VALA_PROFILE_DOVA, _vala_code_context_unref0 (_tmp5_), _tmp6_)) {
			_tmp4_ = TRUE;
		} else {
			ValaList* _tmp7_;
			_tmp4_ = vala_collection_get_size ((ValaCollection*) (_tmp7_ = vala_method_get_postconditions (m))) > 0;
			_vala_iterable_unref0 (_tmp7_);
		}
		_tmp3_ = _tmp4_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		ValaDataType* _tmp8_;
		ValaLocalVariable* _tmp9_;
		if (vala_method_get_result_var (m) != NULL) {
			vala_scope_remove (vala_symbol_get_scope ((ValaSymbol*) m), vala_symbol_get_name ((ValaSymbol*) vala_method_get_result_var (m)));
		}
		vala_method_set_result_var (m, _tmp9_ = vala_local_variable_new (_tmp8_ = vala_data_type_copy (vala_method_get_return_type (m)), "result", NULL, vala_code_node_get_source_reference ((ValaCodeNode*) self)));
		_vala_code_node_unref0 (_tmp9_);
		_vala_code_node_unref0 (_tmp8_);
		vala_local_variable_set_is_result (vala_method_get_result_var (m), TRUE);
	}
	if (VALA_IS_CREATION_METHOD (m)) {
		ValaCreationMethod* cm;
		gboolean _tmp10_ = FALSE;
		if (vala_symbol_get_name ((ValaSymbol*) m) == NULL) {
			vala_class_set_default_construction_method (self, m);
			vala_symbol_set_name ((ValaSymbol*) m, ".new");
		}
		cm = _vala_code_node_ref0 (VALA_CREATION_METHOD (m));
		if (vala_creation_method_get_class_name (cm) != NULL) {
			_tmp10_ = _vala_strcmp0 (vala_creation_method_get_class_name (cm), vala_symbol_get_name ((ValaSymbol*) self)) != 0;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			char* _tmp11_;
			char* _tmp12_;
			vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) m), _tmp12_ = g_strdup_printf ("missing return type in method `%s.%s´", _tmp11_ = vala_symbol_get_full_name ((ValaSymbol*) self), vala_creation_method_get_class_name (cm)));
			_g_free0 (_tmp12_);
			_g_free0 (_tmp11_);
			vala_code_node_set_error ((ValaCodeNode*) m, TRUE);
			_vala_code_node_unref0 (cm);
			return;
		}
		_vala_code_node_unref0 (cm);
	}
	vala_collection_add ((ValaCollection*) self->priv->methods, m);
	vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) self), vala_symbol_get_name ((ValaSymbol*) m), (ValaSymbol*) m);
}


/**
 * Returns a copy of the list of methods.
 *
 * @return list of methods
 */
static ValaList* vala_class_real_get_methods (ValaObjectTypeSymbol* base) {
	ValaClass * self;
	ValaList* result = NULL;
	self = (ValaClass*) base;
	result = _vala_iterable_ref0 (self->priv->methods);
	return result;
}


/**
 * Adds the specified property as a member to this class.
 *
 * @param prop a property
 */
static void vala_class_real_add_property (ValaSymbol* base, ValaProperty* prop) {
	ValaClass * self;
	ValaObjectType* _tmp0_;
	ValaFormalParameter* _tmp1_;
	self = (ValaClass*) base;
	g_return_if_fail (prop != NULL);
	vala_collection_add ((ValaCollection*) self->priv->properties, prop);
	vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) self), vala_symbol_get_name ((ValaSymbol*) prop), (ValaSymbol*) prop);
	vala_property_set_this_parameter (prop, _tmp1_ = vala_formal_parameter_new ("this", (ValaDataType*) (_tmp0_ = vala_object_type_symbol_get_this_type ((ValaObjectTypeSymbol*) self)), NULL));
	_vala_code_node_unref0 (_tmp1_);
	_vala_code_node_unref0 (_tmp0_);
	vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) prop), vala_symbol_get_name ((ValaSymbol*) vala_property_get_this_parameter (prop)), (ValaSymbol*) vala_property_get_this_parameter (prop));
	if (vala_property_get_field (prop) != NULL) {
		vala_symbol_add_field ((ValaSymbol*) self, vala_property_get_field (prop));
	}
}


/**
 * Returns a copy of the list of properties.
 *
 * @return list of properties
 */
static ValaList* vala_class_real_get_properties (ValaObjectTypeSymbol* base) {
	ValaClass * self;
	ValaList* result = NULL;
	self = (ValaClass*) base;
	result = _vala_iterable_ref0 (self->priv->properties);
	return result;
}


/**
 * Adds the specified signal as a member to this class.
 *
 * @param sig a signal
 */
static void vala_class_real_add_signal (ValaSymbol* base, ValaSignal* sig) {
	ValaClass * self;
	self = (ValaClass*) base;
	g_return_if_fail (sig != NULL);
	vala_collection_add ((ValaCollection*) self->priv->signals, sig);
	vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) self), vala_symbol_get_name ((ValaSymbol*) sig), (ValaSymbol*) sig);
}


/**
 * Returns a copy of the list of signals.
 *
 * @return list of signals
 */
static ValaList* vala_class_real_get_signals (ValaObjectTypeSymbol* base) {
	ValaClass * self;
	ValaList* result = NULL;
	self = (ValaClass*) base;
	result = _vala_iterable_ref0 (self->priv->signals);
	return result;
}


/**
 * Adds the specified class as an inner class.
 *
 * @param cl a class
 */
static void vala_class_real_add_class (ValaSymbol* base, ValaClass* cl) {
	ValaClass * self;
	self = (ValaClass*) base;
	g_return_if_fail (cl != NULL);
	vala_collection_add ((ValaCollection*) self->priv->classes, cl);
	vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) self), vala_symbol_get_name ((ValaSymbol*) cl), (ValaSymbol*) cl);
}


/**
 * Adds the specified struct as an inner struct.
 *
 * @param st a struct
 */
static void vala_class_real_add_struct (ValaSymbol* base, ValaStruct* st) {
	ValaClass * self;
	self = (ValaClass*) base;
	g_return_if_fail (st != NULL);
	vala_collection_add ((ValaCollection*) self->priv->structs, st);
	vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) self), vala_symbol_get_name ((ValaSymbol*) st), (ValaSymbol*) st);
}


/**
 * Adds the specified enum as an inner enum.
 *
 * @param en an enum
 */
static void vala_class_real_add_enum (ValaSymbol* base, ValaEnum* en) {
	ValaClass * self;
	self = (ValaClass*) base;
	g_return_if_fail (en != NULL);
	vala_collection_add ((ValaCollection*) self->priv->enums, en);
	vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) self), vala_symbol_get_name ((ValaSymbol*) en), (ValaSymbol*) en);
}


/**
 * Adds the specified delegate as an inner delegate.
 *
 * @param d a delegate
 */
static void vala_class_real_add_delegate (ValaSymbol* base, ValaDelegate* d) {
	ValaClass * self;
	self = (ValaClass*) base;
	g_return_if_fail (d != NULL);
	vala_collection_add ((ValaCollection*) self->priv->delegates, d);
	vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) self), vala_symbol_get_name ((ValaSymbol*) d), (ValaSymbol*) d);
}


static void vala_class_real_add_constructor (ValaSymbol* base, ValaConstructor* c) {
	ValaClass * self;
	self = (ValaClass*) base;
	g_return_if_fail (c != NULL);
	if (vala_constructor_get_binding (c) == MEMBER_BINDING_INSTANCE) {
		if (self->priv->_constructor != NULL) {
			vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) c), "class already contains a constructor");
		}
		vala_class_set_constructor (self, c);
	} else {
		if (vala_constructor_get_binding (c) == MEMBER_BINDING_CLASS) {
			if (self->priv->_class_constructor != NULL) {
				vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) c), "class already contains a class constructor");
			}
			vala_class_set_class_constructor (self, c);
		} else {
			if (self->priv->_static_constructor != NULL) {
				vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) c), "class already contains a static constructor");
			}
			vala_class_set_static_constructor (self, c);
		}
	}
}


static void vala_class_real_add_destructor (ValaSymbol* base, ValaDestructor* d) {
	ValaClass * self;
	self = (ValaClass*) base;
	g_return_if_fail (d != NULL);
	if (vala_destructor_get_binding (d) == MEMBER_BINDING_INSTANCE) {
		if (vala_class_get_destructor (self) != NULL) {
			vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) d), "class already contains a destructor");
		}
		vala_class_set_destructor (self, d);
	} else {
		if (vala_destructor_get_binding (d) == MEMBER_BINDING_CLASS) {
			if (self->priv->_class_destructor != NULL) {
				vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) d), "class already contains a class destructor");
			}
			vala_class_set_class_destructor (self, d);
		} else {
			if (self->priv->_static_destructor != NULL) {
				vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) d), "class already contains a static destructor");
			}
			vala_class_set_static_destructor (self, d);
		}
	}
}


static void vala_class_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaClass * self;
	self = (ValaClass*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_class (visitor, self);
}


static void vala_class_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaClass * self;
	self = (ValaClass*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _type_list;
		gint _type_size;
		gint _type_index;
		_type_list = _vala_iterable_ref0 (self->priv->base_types);
		_type_size = vala_collection_get_size ((ValaCollection*) _type_list);
		_type_index = -1;
		while (TRUE) {
			ValaDataType* type;
			if (!((_type_index = _type_index + 1) < _type_size)) {
				break;
			}
			type = (ValaDataType*) vala_list_get (_type_list, _type_index);
			vala_code_node_accept ((ValaCodeNode*) type, visitor);
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	{
		ValaList* _p_list;
		gint _p_size;
		gint _p_index;
		_p_list = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) self);
		_p_size = vala_collection_get_size ((ValaCollection*) _p_list);
		_p_index = -1;
		while (TRUE) {
			ValaTypeParameter* p;
			if (!((_p_index = _p_index + 1) < _p_size)) {
				break;
			}
			p = (ValaTypeParameter*) vala_list_get (_p_list, _p_index);
			vala_code_node_accept ((ValaCodeNode*) p, visitor);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	{
		ValaList* _en_list;
		gint _en_size;
		gint _en_index;
		_en_list = _vala_iterable_ref0 (self->priv->enums);
		_en_size = vala_collection_get_size ((ValaCollection*) _en_list);
		_en_index = -1;
		while (TRUE) {
			ValaEnum* en;
			if (!((_en_index = _en_index + 1) < _en_size)) {
				break;
			}
			en = (ValaEnum*) vala_list_get (_en_list, _en_index);
			vala_code_node_accept ((ValaCodeNode*) en, visitor);
			_vala_code_node_unref0 (en);
		}
		_vala_iterable_unref0 (_en_list);
	}
	{
		ValaList* _f_list;
		gint _f_size;
		gint _f_index;
		_f_list = _vala_iterable_ref0 (self->priv->fields);
		_f_size = vala_collection_get_size ((ValaCollection*) _f_list);
		_f_index = -1;
		while (TRUE) {
			ValaField* f;
			if (!((_f_index = _f_index + 1) < _f_size)) {
				break;
			}
			f = (ValaField*) vala_list_get (_f_list, _f_index);
			vala_code_node_accept ((ValaCodeNode*) f, visitor);
			_vala_code_node_unref0 (f);
		}
		_vala_iterable_unref0 (_f_list);
	}
	{
		ValaList* _c_list;
		gint _c_size;
		gint _c_index;
		_c_list = _vala_iterable_ref0 (self->priv->constants);
		_c_size = vala_collection_get_size ((ValaCollection*) _c_list);
		_c_index = -1;
		while (TRUE) {
			ValaConstant* c;
			if (!((_c_index = _c_index + 1) < _c_size)) {
				break;
			}
			c = (ValaConstant*) vala_list_get (_c_list, _c_index);
			vala_code_node_accept ((ValaCodeNode*) c, visitor);
			_vala_code_node_unref0 (c);
		}
		_vala_iterable_unref0 (_c_list);
	}
	{
		ValaList* _m_list;
		gint _m_size;
		gint _m_index;
		_m_list = _vala_iterable_ref0 (self->priv->methods);
		_m_size = vala_collection_get_size ((ValaCollection*) _m_list);
		_m_index = -1;
		while (TRUE) {
			ValaMethod* m;
			if (!((_m_index = _m_index + 1) < _m_size)) {
				break;
			}
			m = (ValaMethod*) vala_list_get (_m_list, _m_index);
			vala_code_node_accept ((ValaCodeNode*) m, visitor);
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	{
		ValaList* _prop_list;
		gint _prop_size;
		gint _prop_index;
		_prop_list = _vala_iterable_ref0 (self->priv->properties);
		_prop_size = vala_collection_get_size ((ValaCollection*) _prop_list);
		_prop_index = -1;
		while (TRUE) {
			ValaProperty* prop;
			if (!((_prop_index = _prop_index + 1) < _prop_size)) {
				break;
			}
			prop = (ValaProperty*) vala_list_get (_prop_list, _prop_index);
			vala_code_node_accept ((ValaCodeNode*) prop, visitor);
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	{
		ValaList* _sig_list;
		gint _sig_size;
		gint _sig_index;
		_sig_list = _vala_iterable_ref0 (self->priv->signals);
		_sig_size = vala_collection_get_size ((ValaCollection*) _sig_list);
		_sig_index = -1;
		while (TRUE) {
			ValaSignal* sig;
			if (!((_sig_index = _sig_index + 1) < _sig_size)) {
				break;
			}
			sig = (ValaSignal*) vala_list_get (_sig_list, _sig_index);
			vala_code_node_accept ((ValaCodeNode*) sig, visitor);
			_vala_code_node_unref0 (sig);
		}
		_vala_iterable_unref0 (_sig_list);
	}
	if (self->priv->_constructor != NULL) {
		vala_code_node_accept ((ValaCodeNode*) self->priv->_constructor, visitor);
	}
	if (self->priv->_class_constructor != NULL) {
		vala_code_node_accept ((ValaCodeNode*) self->priv->_class_constructor, visitor);
	}
	if (self->priv->_static_constructor != NULL) {
		vala_code_node_accept ((ValaCodeNode*) self->priv->_static_constructor, visitor);
	}
	if (vala_class_get_destructor (self) != NULL) {
		vala_code_node_accept ((ValaCodeNode*) vala_class_get_destructor (self), visitor);
	}
	if (self->priv->_static_destructor != NULL) {
		vala_code_node_accept ((ValaCodeNode*) self->priv->_static_destructor, visitor);
	}
	if (self->priv->_class_destructor != NULL) {
		vala_code_node_accept ((ValaCodeNode*) self->priv->_class_destructor, visitor);
	}
	{
		ValaList* _cl_list;
		gint _cl_size;
		gint _cl_index;
		_cl_list = _vala_iterable_ref0 (self->priv->classes);
		_cl_size = vala_collection_get_size ((ValaCollection*) _cl_list);
		_cl_index = -1;
		while (TRUE) {
			ValaClass* cl;
			if (!((_cl_index = _cl_index + 1) < _cl_size)) {
				break;
			}
			cl = (ValaClass*) vala_list_get (_cl_list, _cl_index);
			vala_code_node_accept ((ValaCodeNode*) cl, visitor);
			_vala_code_node_unref0 (cl);
		}
		_vala_iterable_unref0 (_cl_list);
	}
	{
		ValaList* _st_list;
		gint _st_size;
		gint _st_index;
		_st_list = _vala_iterable_ref0 (self->priv->structs);
		_st_size = vala_collection_get_size ((ValaCollection*) _st_list);
		_st_index = -1;
		while (TRUE) {
			ValaStruct* st;
			if (!((_st_index = _st_index + 1) < _st_size)) {
				break;
			}
			st = (ValaStruct*) vala_list_get (_st_list, _st_index);
			vala_code_node_accept ((ValaCodeNode*) st, visitor);
			_vala_code_node_unref0 (st);
		}
		_vala_iterable_unref0 (_st_list);
	}
	{
		ValaList* _d_list;
		gint _d_size;
		gint _d_index;
		_d_list = _vala_iterable_ref0 (self->priv->delegates);
		_d_size = vala_collection_get_size ((ValaCollection*) _d_list);
		_d_index = -1;
		while (TRUE) {
			ValaDelegate* d;
			if (!((_d_index = _d_index + 1) < _d_size)) {
				break;
			}
			d = (ValaDelegate*) vala_list_get (_d_list, _d_index);
			vala_code_node_accept ((ValaCodeNode*) d, visitor);
			_vala_code_node_unref0 (d);
		}
		_vala_iterable_unref0 (_d_list);
	}
}


static char* vala_class_real_get_cprefix (ValaSymbol* base) {
	ValaClass * self;
	char* result = NULL;
	self = (ValaClass*) base;
	result = vala_typesymbol_get_cname ((ValaTypeSymbol*) self, FALSE);
	return result;
}


static char* vala_class_real_get_cname (ValaTypeSymbol* base, gboolean const_type) {
	ValaClass * self;
	char* result = NULL;
	self = (ValaClass*) base;
	if (const_type) {
		if (self->priv->_const_cname != NULL) {
			result = g_strdup (self->priv->_const_cname);
			return result;
		} else {
			if (vala_class_get_is_immutable (self)) {
				char* _tmp0_;
				char* _tmp1_;
				result = (_tmp1_ = g_strconcat ("const ", _tmp0_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) self, FALSE), NULL), _g_free0 (_tmp0_), _tmp1_);
				return result;
			}
		}
	}
	if (self->priv->cname == NULL) {
		ValaAttribute* attr;
		attr = vala_code_node_get_attribute ((ValaCodeNode*) self, "CCode");
		if (attr != NULL) {
			char* _tmp2_;
			self->priv->cname = (_tmp2_ = vala_attribute_get_string (attr, "cname"), _g_free0 (self->priv->cname), _tmp2_);
		}
		if (self->priv->cname == NULL) {
			char* _tmp3_;
			self->priv->cname = (_tmp3_ = vala_class_get_default_cname (self), _g_free0 (self->priv->cname), _tmp3_);
		}
		_vala_code_node_unref0 (attr);
	}
	result = g_strdup (self->priv->cname);
	return result;
}


/**
 * Returns the default name of this class as it is used in C code.
 *
 * @return the name to be used in C code by default
 */
char* vala_class_get_default_cname (ValaClass* self) {
	char* result = NULL;
	char* _tmp0_;
	char* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	result = (_tmp1_ = g_strdup_printf ("%s%s", _tmp0_ = vala_symbol_get_cprefix (vala_symbol_get_parent_symbol ((ValaSymbol*) self)), vala_symbol_get_name ((ValaSymbol*) self)), _g_free0 (_tmp0_), _tmp1_);
	return result;
}


/**
 * Sets the name of this class as it is used in C code.
 *
 * @param cname the name to be used in C code
 */
void vala_class_set_cname (ValaClass* self, const char* cname) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cname != NULL);
	self->priv->cname = (_tmp0_ = g_strdup (cname), _g_free0 (self->priv->cname), _tmp0_);
}


static const char* string_offset (const char* self, glong offset) {
	const char* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = (const char*) (((gchar*) self) + offset);
	return result;
}


static char* string_substring (const char* self, glong offset, glong len) {
	char* result = NULL;
	glong string_length;
	const char* start;
	g_return_val_if_fail (self != NULL, NULL);
	string_length = strlen (self);
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	start = string_offset (self, offset);
	result = g_strndup (start, ((gchar*) string_offset (start, len)) - ((gchar*) start));
	return result;
}


static char* vala_class_get_lower_case_csuffix (ValaClass* self) {
	char* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->lower_case_csuffix == NULL) {
		char* _tmp0_;
		self->priv->lower_case_csuffix = (_tmp0_ = vala_symbol_camel_case_to_lower_case (vala_symbol_get_name ((ValaSymbol*) self)), _g_free0 (self->priv->lower_case_csuffix), _tmp0_);
		if (g_str_has_prefix (self->priv->lower_case_csuffix, "type_")) {
			char* _tmp1_;
			self->priv->lower_case_csuffix = (_tmp1_ = g_strconcat ("type", string_offset (self->priv->lower_case_csuffix, strlen ("type_")), NULL), _g_free0 (self->priv->lower_case_csuffix), _tmp1_);
		} else {
			if (g_str_has_prefix (self->priv->lower_case_csuffix, "is_")) {
				char* _tmp2_;
				self->priv->lower_case_csuffix = (_tmp2_ = g_strconcat ("is", string_offset (self->priv->lower_case_csuffix, strlen ("is_")), NULL), _g_free0 (self->priv->lower_case_csuffix), _tmp2_);
			}
		}
		if (g_str_has_suffix (self->priv->lower_case_csuffix, "_class")) {
			char* _tmp3_;
			char* _tmp4_;
			self->priv->lower_case_csuffix = (_tmp4_ = g_strconcat (_tmp3_ = string_substring (self->priv->lower_case_csuffix, (glong) 0, strlen (self->priv->lower_case_csuffix) - strlen ("_class")), "class", NULL), _g_free0 (self->priv->lower_case_csuffix), _tmp4_);
			_g_free0 (_tmp3_);
		}
	}
	result = g_strdup (self->priv->lower_case_csuffix);
	return result;
}


static char* vala_class_real_get_lower_case_cname (ValaSymbol* base, const char* infix) {
	ValaClass * self;
	char* result = NULL;
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	self = (ValaClass*) base;
	if (infix == NULL) {
		infix = "";
	}
	result = (_tmp2_ = g_strdup_printf ("%s%s%s", _tmp0_ = vala_symbol_get_lower_case_cprefix (vala_symbol_get_parent_symbol ((ValaSymbol*) self)), infix, _tmp1_ = vala_class_get_lower_case_csuffix (self)), _g_free0 (_tmp1_), _g_free0 (_tmp0_), _tmp2_);
	return result;
}


static char* vala_class_real_get_lower_case_cprefix (ValaSymbol* base) {
	ValaClass * self;
	char* result = NULL;
	self = (ValaClass*) base;
	if (self->priv->lower_case_cprefix == NULL) {
		char* _tmp0_;
		char* _tmp1_;
		self->priv->lower_case_cprefix = (_tmp1_ = g_strdup_printf ("%s_", _tmp0_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) self, NULL)), _g_free0 (self->priv->lower_case_cprefix), _tmp1_);
		_g_free0 (_tmp0_);
	}
	result = g_strdup (self->priv->lower_case_cprefix);
	return result;
}


static char* vala_class_real_get_upper_case_cname (ValaTypeSymbol* base, const char* infix) {
	ValaClass * self;
	char* result = NULL;
	char* _tmp0_;
	char* _tmp1_;
	self = (ValaClass*) base;
	result = (_tmp1_ = g_utf8_strup (_tmp0_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) self, infix), -1), _g_free0 (_tmp0_), _tmp1_);
	return result;
}


static gboolean vala_class_real_is_reference_type (ValaTypeSymbol* base) {
	ValaClass * self;
	gboolean result = FALSE;
	self = (ValaClass*) base;
	result = TRUE;
	return result;
}


static void vala_class_process_gir_attribute (ValaClass* self, ValaAttribute* a) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (a != NULL);
	if (vala_attribute_has_argument (a, "name")) {
		char* _tmp0_;
		vala_symbol_set_gir_name ((ValaSymbol*) self, _tmp0_ = vala_attribute_get_string (a, "name"));
		_g_free0 (_tmp0_);
	}
}


static void vala_class_process_ccode_attribute (ValaClass* self, ValaAttribute* a) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (a != NULL);
	if (vala_attribute_has_argument (a, "ref_function")) {
		char* _tmp0_;
		vala_class_set_ref_function (self, _tmp0_ = vala_attribute_get_string (a, "ref_function"));
		_g_free0 (_tmp0_);
	}
	if (vala_attribute_has_argument (a, "ref_function_void")) {
		vala_class_set_ref_function_void (self, vala_attribute_get_bool (a, "ref_function_void"));
	}
	if (vala_attribute_has_argument (a, "unref_function")) {
		char* _tmp1_;
		vala_class_set_unref_function (self, _tmp1_ = vala_attribute_get_string (a, "unref_function"));
		_g_free0 (_tmp1_);
	}
	if (vala_attribute_has_argument (a, "ref_sink_function")) {
		char* _tmp2_;
		vala_class_set_ref_sink_function (self, _tmp2_ = vala_attribute_get_string (a, "ref_sink_function"));
		_g_free0 (_tmp2_);
	}
	if (vala_attribute_has_argument (a, "copy_function")) {
		char* _tmp3_;
		vala_class_set_dup_function (self, _tmp3_ = vala_attribute_get_string (a, "copy_function"));
		_g_free0 (_tmp3_);
	}
	if (vala_attribute_has_argument (a, "free_function")) {
		char* _tmp4_;
		vala_class_set_free_function (self, _tmp4_ = vala_attribute_get_string (a, "free_function"));
		_g_free0 (_tmp4_);
	}
	if (vala_attribute_has_argument (a, "free_function_address_of")) {
		vala_class_set_free_function_address_of (self, vala_attribute_get_bool (a, "free_function_address_of"));
	}
	if (vala_attribute_has_argument (a, "type_id")) {
		char* _tmp5_;
		self->priv->type_id = (_tmp5_ = vala_attribute_get_string (a, "type_id"), _g_free0 (self->priv->type_id), _tmp5_);
	}
	if (vala_attribute_has_argument (a, "marshaller_type_name")) {
		char* _tmp6_;
		self->priv->marshaller_type_name = (_tmp6_ = vala_attribute_get_string (a, "marshaller_type_name"), _g_free0 (self->priv->marshaller_type_name), _tmp6_);
	}
	if (vala_attribute_has_argument (a, "get_value_function")) {
		char* _tmp7_;
		self->priv->get_value_function = (_tmp7_ = vala_attribute_get_string (a, "get_value_function"), _g_free0 (self->priv->get_value_function), _tmp7_);
	}
	if (vala_attribute_has_argument (a, "set_value_function")) {
		char* _tmp8_;
		self->priv->set_value_function = (_tmp8_ = vala_attribute_get_string (a, "set_value_function"), _g_free0 (self->priv->set_value_function), _tmp8_);
	}
	if (vala_attribute_has_argument (a, "take_value_function")) {
		char* _tmp9_;
		self->priv->take_value_function = (_tmp9_ = vala_attribute_get_string (a, "take_value_function"), _g_free0 (self->priv->take_value_function), _tmp9_);
	}
	if (vala_attribute_has_argument (a, "const_cname")) {
		char* _tmp10_;
		vala_class_set_const_cname (self, _tmp10_ = vala_attribute_get_string (a, "const_cname"));
		_g_free0 (_tmp10_);
	}
	if (vala_attribute_has_argument (a, "cprefix")) {
		char* _tmp11_;
		self->priv->lower_case_cprefix = (_tmp11_ = vala_attribute_get_string (a, "cprefix"), _g_free0 (self->priv->lower_case_cprefix), _tmp11_);
	}
	if (vala_attribute_has_argument (a, "lower_case_csuffix")) {
		char* _tmp12_;
		self->priv->lower_case_csuffix = (_tmp12_ = vala_attribute_get_string (a, "lower_case_csuffix"), _g_free0 (self->priv->lower_case_csuffix), _tmp12_);
	}
	if (vala_attribute_has_argument (a, "cheader_filename")) {
		char* val;
		char** _tmp13_;
		val = vala_attribute_get_string (a, "cheader_filename");
		{
			char** filename_collection;
			int filename_collection_length1;
			int filename_it;
			filename_collection = _tmp13_ = g_strsplit (val, ",", 0);
			filename_collection_length1 = _vala_array_length (_tmp13_);
			for (filename_it = 0; filename_it < _vala_array_length (_tmp13_); filename_it = filename_it + 1) {
				char* filename;
				filename = g_strdup (filename_collection[filename_it]);
				{
					vala_symbol_add_cheader_filename ((ValaSymbol*) self, filename);
					_g_free0 (filename);
				}
			}
			filename_collection = (_vala_array_free (filename_collection, filename_collection_length1, (GDestroyNotify) g_free), NULL);
		}
		_g_free0 (val);
	}
	if (vala_attribute_has_argument (a, "type_check_function")) {
		char* _tmp14_;
		vala_class_set_type_check_function (self, _tmp14_ = vala_attribute_get_string (a, "type_check_function"));
		_g_free0 (_tmp14_);
	}
	if (vala_attribute_has_argument (a, "param_spec_function")) {
		char* _tmp15_;
		self->priv->param_spec_function = (_tmp15_ = vala_attribute_get_string (a, "param_spec_function"), _g_free0 (self->priv->param_spec_function), _tmp15_);
	}
}


/**
 * Process all associated attributes.
 */
void vala_class_process_attributes (ValaClass* self) {
	g_return_if_fail (self != NULL);
	{
		GList* a_collection;
		GList* a_it;
		a_collection = ((ValaCodeNode*) self)->attributes;
		for (a_it = a_collection; a_it != NULL; a_it = a_it->next) {
			ValaAttribute* a;
			a = _vala_code_node_ref0 ((ValaAttribute*) a_it->data);
			{
				if (_vala_strcmp0 (vala_attribute_get_name (a), "CCode") == 0) {
					vala_class_process_ccode_attribute (self, a);
				} else {
					if (_vala_strcmp0 (vala_attribute_get_name (a), "Compact") == 0) {
						vala_class_set_is_compact (self, TRUE);
					} else {
						if (_vala_strcmp0 (vala_attribute_get_name (a), "Immutable") == 0) {
							vala_class_set_is_immutable (self, TRUE);
						} else {
							if (_vala_strcmp0 (vala_attribute_get_name (a), "Deprecated") == 0) {
								vala_symbol_process_deprecated_attribute ((ValaSymbol*) self, a);
							} else {
								if (_vala_strcmp0 (vala_attribute_get_name (a), "GIR") == 0) {
									vala_class_process_gir_attribute (self, a);
								}
							}
						}
					}
				}
				_vala_code_node_unref0 (a);
			}
		}
	}
}


char* vala_class_get_default_type_id (ValaClass* self) {
	char* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (vala_class_get_is_compact (self)) {
		result = g_strdup ("G_TYPE_POINTER");
		return result;
	}
	result = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) self, "TYPE_");
	return result;
}


static char* vala_class_real_get_type_id (ValaTypeSymbol* base) {
	ValaClass * self;
	char* result = NULL;
	self = (ValaClass*) base;
	if (self->priv->type_id == NULL) {
		char* _tmp0_;
		self->priv->type_id = (_tmp0_ = vala_class_get_default_type_id (self), _g_free0 (self->priv->type_id), _tmp0_);
	}
	result = g_strdup (self->priv->type_id);
	return result;
}


void vala_class_set_type_id (ValaClass* self, const char* type_id) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type_id != NULL);
	self->priv->type_id = (_tmp0_ = g_strdup (type_id), _g_free0 (self->priv->type_id), _tmp0_);
}


static char* vala_class_real_get_marshaller_type_name (ValaTypeSymbol* base) {
	ValaClass * self;
	char* result = NULL;
	self = (ValaClass*) base;
	if (self->priv->marshaller_type_name == NULL) {
		if (self->priv->_base_class != NULL) {
			char* _tmp0_;
			self->priv->marshaller_type_name = (_tmp0_ = vala_typesymbol_get_marshaller_type_name ((ValaTypeSymbol*) self->priv->_base_class), _g_free0 (self->priv->marshaller_type_name), _tmp0_);
		} else {
			if (!vala_class_get_is_compact (self)) {
				char* _tmp1_;
				self->priv->marshaller_type_name = (_tmp1_ = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) self, NULL), _g_free0 (self->priv->marshaller_type_name), _tmp1_);
			} else {
				char* _tmp2_;
				gboolean _tmp3_;
				if ((_tmp3_ = _vala_strcmp0 (_tmp2_ = vala_typesymbol_get_type_id ((ValaTypeSymbol*) self), "G_TYPE_POINTER") == 0, _g_free0 (_tmp2_), _tmp3_)) {
					char* _tmp4_;
					self->priv->marshaller_type_name = (_tmp4_ = g_strdup ("POINTER"), _g_free0 (self->priv->marshaller_type_name), _tmp4_);
				} else {
					char* _tmp5_;
					self->priv->marshaller_type_name = (_tmp5_ = g_strdup ("BOXED"), _g_free0 (self->priv->marshaller_type_name), _tmp5_);
				}
			}
		}
	}
	result = g_strdup (self->priv->marshaller_type_name);
	return result;
}


static char* vala_class_real_get_param_spec_function (ValaTypeSymbol* base) {
	ValaClass * self;
	char* result = NULL;
	self = (ValaClass*) base;
	if (self->priv->param_spec_function == NULL) {
		char* _tmp0_;
		self->priv->param_spec_function = (_tmp0_ = vala_class_get_default_param_spec_function (self), _g_free0 (self->priv->param_spec_function), _tmp0_);
	}
	result = g_strdup (self->priv->param_spec_function);
	return result;
}


char* vala_class_get_default_param_spec_function (ValaClass* self) {
	char* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (vala_class_is_fundamental (self)) {
		result = vala_symbol_get_lower_case_cname ((ValaSymbol*) self, "param_spec_");
		return result;
	} else {
		if (self->priv->_base_class != NULL) {
			result = vala_typesymbol_get_param_spec_function ((ValaTypeSymbol*) self->priv->_base_class);
			return result;
		} else {
			char* _tmp0_;
			gboolean _tmp1_;
			if ((_tmp1_ = _vala_strcmp0 (_tmp0_ = vala_typesymbol_get_type_id ((ValaTypeSymbol*) self), "G_TYPE_POINTER") == 0, _g_free0 (_tmp0_), _tmp1_)) {
				result = g_strdup ("g_param_spec_pointer");
				return result;
			} else {
				result = g_strdup ("g_param_spec_boxed");
				return result;
			}
		}
	}
}


static char* vala_class_real_get_get_value_function (ValaTypeSymbol* base) {
	ValaClass * self;
	char* result = NULL;
	self = (ValaClass*) base;
	if (self->priv->get_value_function == NULL) {
		if (vala_class_is_fundamental (self)) {
			char* _tmp0_;
			self->priv->get_value_function = (_tmp0_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) self, "value_get_"), _g_free0 (self->priv->get_value_function), _tmp0_);
		} else {
			if (self->priv->_base_class != NULL) {
				char* _tmp1_;
				self->priv->get_value_function = (_tmp1_ = vala_typesymbol_get_get_value_function ((ValaTypeSymbol*) self->priv->_base_class), _g_free0 (self->priv->get_value_function), _tmp1_);
			} else {
				char* _tmp2_;
				gboolean _tmp3_;
				if ((_tmp3_ = _vala_strcmp0 (_tmp2_ = vala_typesymbol_get_type_id ((ValaTypeSymbol*) self), "G_TYPE_POINTER") == 0, _g_free0 (_tmp2_), _tmp3_)) {
					char* _tmp4_;
					self->priv->get_value_function = (_tmp4_ = g_strdup ("g_value_get_pointer"), _g_free0 (self->priv->get_value_function), _tmp4_);
				} else {
					char* _tmp5_;
					self->priv->get_value_function = (_tmp5_ = g_strdup ("g_value_get_boxed"), _g_free0 (self->priv->get_value_function), _tmp5_);
				}
			}
		}
	}
	result = g_strdup (self->priv->get_value_function);
	return result;
}


static char* vala_class_real_get_set_value_function (ValaTypeSymbol* base) {
	ValaClass * self;
	char* result = NULL;
	self = (ValaClass*) base;
	if (self->priv->set_value_function == NULL) {
		if (vala_class_is_fundamental (self)) {
			char* _tmp0_;
			self->priv->set_value_function = (_tmp0_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) self, "value_set_"), _g_free0 (self->priv->set_value_function), _tmp0_);
		} else {
			if (self->priv->_base_class != NULL) {
				char* _tmp1_;
				self->priv->set_value_function = (_tmp1_ = vala_typesymbol_get_set_value_function ((ValaTypeSymbol*) self->priv->_base_class), _g_free0 (self->priv->set_value_function), _tmp1_);
			} else {
				char* _tmp2_;
				gboolean _tmp3_;
				if ((_tmp3_ = _vala_strcmp0 (_tmp2_ = vala_typesymbol_get_type_id ((ValaTypeSymbol*) self), "G_TYPE_POINTER") == 0, _g_free0 (_tmp2_), _tmp3_)) {
					char* _tmp4_;
					self->priv->set_value_function = (_tmp4_ = g_strdup ("g_value_set_pointer"), _g_free0 (self->priv->set_value_function), _tmp4_);
				} else {
					char* _tmp5_;
					self->priv->set_value_function = (_tmp5_ = g_strdup ("g_value_set_boxed"), _g_free0 (self->priv->set_value_function), _tmp5_);
				}
			}
		}
	}
	result = g_strdup (self->priv->set_value_function);
	return result;
}


static char* vala_class_real_get_take_value_function (ValaTypeSymbol* base) {
	ValaClass * self;
	char* result = NULL;
	self = (ValaClass*) base;
	if (self->priv->take_value_function == NULL) {
		if (vala_class_is_fundamental (self)) {
			char* _tmp0_;
			self->priv->take_value_function = (_tmp0_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) self, "value_take_"), _g_free0 (self->priv->take_value_function), _tmp0_);
		} else {
			if (self->priv->_base_class != NULL) {
				char* _tmp1_;
				self->priv->take_value_function = (_tmp1_ = vala_typesymbol_get_take_value_function ((ValaTypeSymbol*) self->priv->_base_class), _g_free0 (self->priv->take_value_function), _tmp1_);
			} else {
				char* _tmp2_;
				gboolean _tmp3_;
				if ((_tmp3_ = _vala_strcmp0 (_tmp2_ = vala_typesymbol_get_type_id ((ValaTypeSymbol*) self), "G_TYPE_POINTER") == 0, _g_free0 (_tmp2_), _tmp3_)) {
					char* _tmp4_;
					self->priv->take_value_function = (_tmp4_ = g_strdup ("g_value_set_pointer"), _g_free0 (self->priv->take_value_function), _tmp4_);
				} else {
					char* _tmp5_;
					self->priv->take_value_function = (_tmp5_ = g_strdup ("g_value_take_boxed"), _g_free0 (self->priv->take_value_function), _tmp5_);
				}
			}
		}
	}
	result = g_strdup (self->priv->take_value_function);
	return result;
}


static gboolean vala_class_real_is_reference_counting (ValaTypeSymbol* base) {
	ValaClass * self;
	gboolean result = FALSE;
	char* _tmp0_;
	gboolean _tmp1_;
	self = (ValaClass*) base;
	result = (_tmp1_ = (_tmp0_ = vala_typesymbol_get_ref_function ((ValaTypeSymbol*) self)) != NULL, _g_free0 (_tmp0_), _tmp1_);
	return result;
}


gboolean vala_class_is_fundamental (ValaClass* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (!vala_class_get_is_compact (self)) {
		_tmp0_ = self->priv->_base_class == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp1_ = FALSE;
		ValaCodeContext* _tmp2_;
		gboolean _tmp3_;
		if ((_tmp3_ = vala_code_context_get_profile (_tmp2_ = vala_code_context_get ()) == VALA_PROFILE_DOVA, _vala_code_context_unref0 (_tmp2_), _tmp3_)) {
			_tmp1_ = self->priv->_base_class->priv->_base_class == NULL;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			result = TRUE;
			return result;
		}
	}
	result = FALSE;
	return result;
}


static char* vala_class_real_get_ref_function (ValaTypeSymbol* base) {
	ValaClass * self;
	char* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp3_ = FALSE;
	self = (ValaClass*) base;
	if (self->priv->ref_function == NULL) {
		_tmp0_ = vala_class_is_fundamental (self);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		char* _tmp1_;
		char* _tmp2_;
		self->priv->ref_function = (_tmp2_ = g_strconcat (_tmp1_ = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) self), "ref", NULL), _g_free0 (self->priv->ref_function), _tmp2_);
		_g_free0 (_tmp1_);
	}
	if (self->priv->ref_function == NULL) {
		_tmp3_ = self->priv->_base_class != NULL;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		result = vala_typesymbol_get_ref_function ((ValaTypeSymbol*) self->priv->_base_class);
		return result;
	} else {
		result = g_strdup (self->priv->ref_function);
		return result;
	}
}


void vala_class_set_ref_function (ValaClass* self, const char* name) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->ref_function = (_tmp0_ = g_strdup (name), _g_free0 (self->priv->ref_function), _tmp0_);
}


static char* vala_class_real_get_unref_function (ValaTypeSymbol* base) {
	ValaClass * self;
	char* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp3_ = FALSE;
	self = (ValaClass*) base;
	if (self->priv->unref_function == NULL) {
		_tmp0_ = vala_class_is_fundamental (self);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		char* _tmp1_;
		char* _tmp2_;
		self->priv->unref_function = (_tmp2_ = g_strconcat (_tmp1_ = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) self), "unref", NULL), _g_free0 (self->priv->unref_function), _tmp2_);
		_g_free0 (_tmp1_);
	}
	if (self->priv->unref_function == NULL) {
		_tmp3_ = self->priv->_base_class != NULL;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		result = vala_typesymbol_get_unref_function ((ValaTypeSymbol*) self->priv->_base_class);
		return result;
	} else {
		result = g_strdup (self->priv->unref_function);
		return result;
	}
}


void vala_class_set_unref_function (ValaClass* self, const char* name) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->unref_function = (_tmp0_ = g_strdup (name), _g_free0 (self->priv->unref_function), _tmp0_);
}


static char* vala_class_real_get_ref_sink_function (ValaTypeSymbol* base) {
	ValaClass * self;
	char* result = NULL;
	gboolean _tmp0_ = FALSE;
	self = (ValaClass*) base;
	if (self->priv->ref_sink_function == NULL) {
		_tmp0_ = self->priv->_base_class != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = vala_typesymbol_get_ref_sink_function ((ValaTypeSymbol*) self->priv->_base_class);
		return result;
	} else {
		result = g_strdup (self->priv->ref_sink_function);
		return result;
	}
}


void vala_class_set_ref_sink_function (ValaClass* self, const char* name) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->ref_sink_function = (_tmp0_ = g_strdup (name), _g_free0 (self->priv->ref_sink_function), _tmp0_);
}


static char* vala_class_real_get_dup_function (ValaTypeSymbol* base) {
	ValaClass * self;
	char* result = NULL;
	self = (ValaClass*) base;
	result = g_strdup (self->priv->copy_function);
	return result;
}


void vala_class_set_dup_function (ValaClass* self, const char* name) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->copy_function = (_tmp0_ = g_strdup (name), _g_free0 (self->priv->copy_function), _tmp0_);
}


char* vala_class_get_default_free_function (ValaClass* self) {
	char* result = NULL;
	char* _tmp0_;
	char* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	result = (_tmp1_ = g_strconcat (_tmp0_ = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) self), "free", NULL), _g_free0 (_tmp0_), _tmp1_);
	return result;
}


static char* vala_class_real_get_free_function (ValaTypeSymbol* base) {
	ValaClass * self;
	char* result = NULL;
	self = (ValaClass*) base;
	if (self->priv->free_function == NULL) {
		char* _tmp0_;
		if (self->priv->_base_class != NULL) {
			result = vala_typesymbol_get_free_function ((ValaTypeSymbol*) self->priv->_base_class);
			return result;
		}
		self->priv->free_function = (_tmp0_ = vala_class_get_default_free_function (self), _g_free0 (self->priv->free_function), _tmp0_);
	}
	result = g_strdup (self->priv->free_function);
	return result;
}


void vala_class_set_free_function (ValaClass* self, const char* name) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	self->priv->free_function = (_tmp0_ = g_strdup (name), _g_free0 (self->priv->free_function), _tmp0_);
}


static gboolean vala_class_real_is_subtype_of (ValaTypeSymbol* base, ValaTypeSymbol* t) {
	ValaClass * self;
	gboolean result = FALSE;
	self = (ValaClass*) base;
	g_return_val_if_fail (t != NULL, FALSE);
	if (VALA_TYPESYMBOL (self) == t) {
		result = TRUE;
		return result;
	}
	{
		ValaList* _base_type_list;
		gint _base_type_size;
		gint _base_type_index;
		_base_type_list = _vala_iterable_ref0 (self->priv->base_types);
		_base_type_size = vala_collection_get_size ((ValaCollection*) _base_type_list);
		_base_type_index = -1;
		while (TRUE) {
			ValaDataType* base_type;
			gboolean _tmp0_ = FALSE;
			if (!((_base_type_index = _base_type_index + 1) < _base_type_size)) {
				break;
			}
			base_type = (ValaDataType*) vala_list_get (_base_type_list, _base_type_index);
			if (vala_data_type_get_data_type (base_type) != NULL) {
				_tmp0_ = vala_typesymbol_is_subtype_of (vala_data_type_get_data_type (base_type), t);
			} else {
				_tmp0_ = FALSE;
			}
			if (_tmp0_) {
				result = TRUE;
				_vala_code_node_unref0 (base_type);
				_vala_iterable_unref0 (_base_type_list);
				return result;
			}
			_vala_code_node_unref0 (base_type);
		}
		_vala_iterable_unref0 (_base_type_list);
	}
	result = FALSE;
	return result;
}


static void vala_class_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type) {
	ValaClass * self;
	self = (ValaClass*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaDataType* _tmp1_;
				gboolean _tmp2_;
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(i < vala_collection_get_size ((ValaCollection*) self->priv->base_types))) {
					break;
				}
				if ((_tmp2_ = (_tmp1_ = (ValaDataType*) vala_list_get (self->priv->base_types, i)) == old_type, _vala_code_node_unref0 (_tmp1_), _tmp2_)) {
					vala_list_set (self->priv->base_types, i, new_type);
					return;
				}
			}
		}
	}
}


static void vala_class_get_all_prerequisites (ValaClass* self, ValaInterface* iface, ValaList* list) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (iface != NULL);
	g_return_if_fail (list != NULL);
	{
		ValaList* _prereq_list;
		gint _prereq_size;
		gint _prereq_index;
		_prereq_list = vala_interface_get_prerequisites (iface);
		_prereq_size = vala_collection_get_size ((ValaCollection*) _prereq_list);
		_prereq_index = -1;
		while (TRUE) {
			ValaDataType* prereq;
			ValaTypeSymbol* type;
			if (!((_prereq_index = _prereq_index + 1) < _prereq_size)) {
				break;
			}
			prereq = (ValaDataType*) vala_list_get (_prereq_list, _prereq_index);
			type = _vala_code_node_ref0 (vala_data_type_get_data_type (prereq));
			if (type == NULL) {
				_vala_code_node_unref0 (type);
				_vala_code_node_unref0 (prereq);
				continue;
			}
			vala_collection_add ((ValaCollection*) list, type);
			if (VALA_IS_INTERFACE (type)) {
				vala_class_get_all_prerequisites (self, VALA_INTERFACE (type), list);
			}
			_vala_code_node_unref0 (type);
			_vala_code_node_unref0 (prereq);
		}
		_vala_iterable_unref0 (_prereq_list);
	}
}


static gboolean vala_class_class_is_a (ValaClass* self, ValaClass* cl, ValaTypeSymbol* t) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (cl != NULL, FALSE);
	g_return_val_if_fail (t != NULL, FALSE);
	if (VALA_TYPESYMBOL (cl) == t) {
		result = TRUE;
		return result;
	}
	{
		ValaList* _base_type_list;
		gint _base_type_size;
		gint _base_type_index;
		_base_type_list = vala_class_get_base_types (cl);
		_base_type_size = vala_collection_get_size ((ValaCollection*) _base_type_list);
		_base_type_index = -1;
		while (TRUE) {
			ValaDataType* base_type;
			if (!((_base_type_index = _base_type_index + 1) < _base_type_size)) {
				break;
			}
			base_type = (ValaDataType*) vala_list_get (_base_type_list, _base_type_index);
			if (VALA_IS_CLASS (vala_data_type_get_data_type (base_type))) {
				if (vala_class_class_is_a (self, VALA_CLASS (vala_data_type_get_data_type (base_type)), t)) {
					result = TRUE;
					_vala_code_node_unref0 (base_type);
					_vala_iterable_unref0 (_base_type_list);
					return result;
				}
			} else {
				if (vala_data_type_get_data_type (base_type) == t) {
					result = TRUE;
					_vala_code_node_unref0 (base_type);
					_vala_iterable_unref0 (_base_type_list);
					return result;
				}
			}
			_vala_code_node_unref0 (base_type);
		}
		_vala_iterable_unref0 (_base_type_list);
	}
	result = FALSE;
	return result;
}


static gpointer _vala_source_file_ref0 (gpointer self) {
	return self ? vala_source_file_ref (self) : NULL;
}


static gboolean vala_class_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer) {
	ValaClass * self;
	gboolean result = FALSE;
	ValaSourceFile* old_source_file;
	ValaSymbol* old_symbol;
	ValaList* prerequisites;
	ValaList* missing_prereqs;
	self = (ValaClass*) base;
	g_return_val_if_fail (analyzer != NULL, FALSE);
	if (vala_code_node_get_checked ((ValaCodeNode*) self)) {
		result = !vala_code_node_get_error ((ValaCodeNode*) self);
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	vala_class_process_attributes (self);
	old_source_file = _vala_source_file_ref0 (vala_semantic_analyzer_get_current_source_file (analyzer));
	old_symbol = _vala_code_node_ref0 (vala_semantic_analyzer_get_current_symbol (analyzer));
	if (vala_code_node_get_source_reference ((ValaCodeNode*) self) != NULL) {
		vala_semantic_analyzer_set_current_source_file (analyzer, vala_source_reference_get_file (vala_code_node_get_source_reference ((ValaCodeNode*) self)));
	}
	vala_semantic_analyzer_set_current_symbol (analyzer, (ValaSymbol*) self);
	{
		ValaList* _base_type_reference_list;
		gint _base_type_reference_size;
		gint _base_type_reference_index;
		_base_type_reference_list = vala_class_get_base_types (self);
		_base_type_reference_size = vala_collection_get_size ((ValaCollection*) _base_type_reference_list);
		_base_type_reference_index = -1;
		while (TRUE) {
			ValaDataType* base_type_reference;
			ValaList* _tmp6_;
			gint _tmp7_;
			gint n_type_args;
			ValaList* _tmp8_;
			gint _tmp9_;
			gint n_type_params;
			if (!((_base_type_reference_index = _base_type_reference_index + 1) < _base_type_reference_size)) {
				break;
			}
			base_type_reference = (ValaDataType*) vala_list_get (_base_type_reference_list, _base_type_reference_index);
			if (!vala_code_node_check ((ValaCodeNode*) base_type_reference, analyzer)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_iterable_unref0 (_base_type_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			if (!VALA_IS_OBJECT_TYPE (base_type_reference)) {
				char* _tmp0_;
				char* _tmp1_;
				char* _tmp2_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), _tmp2_ = g_strdup_printf ("base type `%s` of class `%s` is not an object type", _tmp0_ = vala_code_node_to_string ((ValaCodeNode*) base_type_reference), _tmp1_ = vala_symbol_get_full_name ((ValaSymbol*) self)));
				_g_free0 (_tmp2_);
				_g_free0 (_tmp1_);
				_g_free0 (_tmp0_);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_iterable_unref0 (_base_type_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			if (!vala_semantic_analyzer_is_type_accessible (analyzer, (ValaSymbol*) self, base_type_reference)) {
				char* _tmp3_;
				char* _tmp4_;
				char* _tmp5_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), _tmp5_ = g_strdup_printf ("base type `%s` is less accessible than class `%s`", _tmp3_ = vala_code_node_to_string ((ValaCodeNode*) base_type_reference), _tmp4_ = vala_symbol_get_full_name ((ValaSymbol*) self)));
				_g_free0 (_tmp5_);
				_g_free0 (_tmp4_);
				_g_free0 (_tmp3_);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_iterable_unref0 (_base_type_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			n_type_args = (_tmp7_ = vala_collection_get_size ((ValaCollection*) (_tmp6_ = vala_data_type_get_type_arguments (base_type_reference))), _vala_iterable_unref0 (_tmp6_), _tmp7_);
			n_type_params = (_tmp9_ = vala_collection_get_size ((ValaCollection*) (_tmp8_ = vala_object_type_symbol_get_type_parameters (VALA_OBJECT_TYPE_SYMBOL (vala_data_type_get_data_type (base_type_reference))))), _vala_iterable_unref0 (_tmp8_), _tmp9_);
			if (n_type_args < n_type_params) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) base_type_reference), "too few type arguments");
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_iterable_unref0 (_base_type_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			} else {
				if (n_type_args > n_type_params) {
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) base_type_reference), "too many type arguments");
					result = FALSE;
					_vala_code_node_unref0 (base_type_reference);
					_vala_iterable_unref0 (_base_type_reference_list);
					_vala_code_node_unref0 (old_symbol);
					_vala_source_file_unref0 (old_source_file);
					return result;
				}
			}
			_vala_code_node_unref0 (base_type_reference);
		}
		_vala_iterable_unref0 (_base_type_reference_list);
	}
	{
		ValaList* _type_list;
		gint _type_size;
		gint _type_index;
		_type_list = _vala_iterable_ref0 (self->priv->base_types);
		_type_size = vala_collection_get_size ((ValaCollection*) _type_list);
		_type_index = -1;
		while (TRUE) {
			ValaDataType* type;
			if (!((_type_index = _type_index + 1) < _type_size)) {
				break;
			}
			type = (ValaDataType*) vala_list_get (_type_list, _type_index);
			vala_code_node_check ((ValaCodeNode*) type, analyzer);
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	{
		ValaList* _p_list;
		gint _p_size;
		gint _p_index;
		_p_list = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) self);
		_p_size = vala_collection_get_size ((ValaCollection*) _p_list);
		_p_index = -1;
		while (TRUE) {
			ValaTypeParameter* p;
			if (!((_p_index = _p_index + 1) < _p_size)) {
				break;
			}
			p = (ValaTypeParameter*) vala_list_get (_p_list, _p_index);
			vala_code_node_check ((ValaCodeNode*) p, analyzer);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	{
		ValaList* _en_list;
		gint _en_size;
		gint _en_index;
		_en_list = _vala_iterable_ref0 (self->priv->enums);
		_en_size = vala_collection_get_size ((ValaCollection*) _en_list);
		_en_index = -1;
		while (TRUE) {
			ValaEnum* en;
			if (!((_en_index = _en_index + 1) < _en_size)) {
				break;
			}
			en = (ValaEnum*) vala_list_get (_en_list, _en_index);
			vala_code_node_check ((ValaCodeNode*) en, analyzer);
			_vala_code_node_unref0 (en);
		}
		_vala_iterable_unref0 (_en_list);
	}
	{
		ValaList* _f_list;
		gint _f_size;
		gint _f_index;
		_f_list = _vala_iterable_ref0 (self->priv->fields);
		_f_size = vala_collection_get_size ((ValaCollection*) _f_list);
		_f_index = -1;
		while (TRUE) {
			ValaField* f;
			if (!((_f_index = _f_index + 1) < _f_size)) {
				break;
			}
			f = (ValaField*) vala_list_get (_f_list, _f_index);
			vala_code_node_check ((ValaCodeNode*) f, analyzer);
			_vala_code_node_unref0 (f);
		}
		_vala_iterable_unref0 (_f_list);
	}
	{
		ValaList* _c_list;
		gint _c_size;
		gint _c_index;
		_c_list = _vala_iterable_ref0 (self->priv->constants);
		_c_size = vala_collection_get_size ((ValaCollection*) _c_list);
		_c_index = -1;
		while (TRUE) {
			ValaConstant* c;
			if (!((_c_index = _c_index + 1) < _c_size)) {
				break;
			}
			c = (ValaConstant*) vala_list_get (_c_list, _c_index);
			vala_code_node_check ((ValaCodeNode*) c, analyzer);
			_vala_code_node_unref0 (c);
		}
		_vala_iterable_unref0 (_c_list);
	}
	{
		ValaList* _m_list;
		gint _m_size;
		gint _m_index;
		_m_list = _vala_iterable_ref0 (self->priv->methods);
		_m_size = vala_collection_get_size ((ValaCollection*) _m_list);
		_m_index = -1;
		while (TRUE) {
			ValaMethod* m;
			if (!((_m_index = _m_index + 1) < _m_size)) {
				break;
			}
			m = (ValaMethod*) vala_list_get (_m_list, _m_index);
			vala_code_node_check ((ValaCodeNode*) m, analyzer);
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	{
		ValaList* _prop_list;
		gint _prop_size;
		gint _prop_index;
		_prop_list = _vala_iterable_ref0 (self->priv->properties);
		_prop_size = vala_collection_get_size ((ValaCollection*) _prop_list);
		_prop_index = -1;
		while (TRUE) {
			ValaProperty* prop;
			if (!((_prop_index = _prop_index + 1) < _prop_size)) {
				break;
			}
			prop = (ValaProperty*) vala_list_get (_prop_list, _prop_index);
			vala_code_node_check ((ValaCodeNode*) prop, analyzer);
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	{
		ValaList* _sig_list;
		gint _sig_size;
		gint _sig_index;
		_sig_list = _vala_iterable_ref0 (self->priv->signals);
		_sig_size = vala_collection_get_size ((ValaCollection*) _sig_list);
		_sig_index = -1;
		while (TRUE) {
			ValaSignal* sig;
			if (!((_sig_index = _sig_index + 1) < _sig_size)) {
				break;
			}
			sig = (ValaSignal*) vala_list_get (_sig_list, _sig_index);
			vala_code_node_check ((ValaCodeNode*) sig, analyzer);
			_vala_code_node_unref0 (sig);
		}
		_vala_iterable_unref0 (_sig_list);
	}
	if (self->priv->_constructor != NULL) {
		vala_code_node_check ((ValaCodeNode*) self->priv->_constructor, analyzer);
	}
	if (self->priv->_class_constructor != NULL) {
		vala_code_node_check ((ValaCodeNode*) self->priv->_class_constructor, analyzer);
	}
	if (self->priv->_static_constructor != NULL) {
		vala_code_node_check ((ValaCodeNode*) self->priv->_static_constructor, analyzer);
	}
	if (vala_class_get_destructor (self) != NULL) {
		vala_code_node_check ((ValaCodeNode*) vala_class_get_destructor (self), analyzer);
	}
	if (self->priv->_static_destructor != NULL) {
		vala_code_node_check ((ValaCodeNode*) self->priv->_static_destructor, analyzer);
	}
	if (self->priv->_class_destructor != NULL) {
		vala_code_node_check ((ValaCodeNode*) self->priv->_class_destructor, analyzer);
	}
	{
		ValaList* _cl_list;
		gint _cl_size;
		gint _cl_index;
		_cl_list = _vala_iterable_ref0 (self->priv->classes);
		_cl_size = vala_collection_get_size ((ValaCollection*) _cl_list);
		_cl_index = -1;
		while (TRUE) {
			ValaClass* cl;
			if (!((_cl_index = _cl_index + 1) < _cl_size)) {
				break;
			}
			cl = (ValaClass*) vala_list_get (_cl_list, _cl_index);
			vala_code_node_check ((ValaCodeNode*) cl, analyzer);
			_vala_code_node_unref0 (cl);
		}
		_vala_iterable_unref0 (_cl_list);
	}
	{
		ValaList* _st_list;
		gint _st_size;
		gint _st_index;
		_st_list = _vala_iterable_ref0 (self->priv->structs);
		_st_size = vala_collection_get_size ((ValaCollection*) _st_list);
		_st_index = -1;
		while (TRUE) {
			ValaStruct* st;
			if (!((_st_index = _st_index + 1) < _st_size)) {
				break;
			}
			st = (ValaStruct*) vala_list_get (_st_list, _st_index);
			vala_code_node_check ((ValaCodeNode*) st, analyzer);
			_vala_code_node_unref0 (st);
		}
		_vala_iterable_unref0 (_st_list);
	}
	{
		ValaList* _d_list;
		gint _d_size;
		gint _d_index;
		_d_list = _vala_iterable_ref0 (self->priv->delegates);
		_d_size = vala_collection_get_size ((ValaCollection*) _d_list);
		_d_index = -1;
		while (TRUE) {
			ValaDelegate* d;
			if (!((_d_index = _d_index + 1) < _d_size)) {
				break;
			}
			d = (ValaDelegate*) vala_list_get (_d_list, _d_index);
			vala_code_node_check ((ValaCodeNode*) d, analyzer);
			_vala_code_node_unref0 (d);
		}
		_vala_iterable_unref0 (_d_list);
	}
	if (vala_class_get_is_compact (self)) {
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_ = FALSE;
		{
			ValaList* _base_type_list;
			gint _base_type_size;
			gint _base_type_index;
			_base_type_list = vala_class_get_base_types (self);
			_base_type_size = vala_collection_get_size ((ValaCollection*) _base_type_list);
			_base_type_index = -1;
			while (TRUE) {
				ValaDataType* base_type;
				if (!((_base_type_index = _base_type_index + 1) < _base_type_size)) {
					break;
				}
				base_type = (ValaDataType*) vala_list_get (_base_type_list, _base_type_index);
				if (VALA_IS_INTERFACE (vala_data_type_get_data_type (base_type))) {
					char* _tmp10_;
					char* _tmp11_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), _tmp11_ = g_strdup_printf ("compact classes `%s` may not implement interfaces", _tmp10_ = vala_symbol_get_full_name ((ValaSymbol*) self)));
					_g_free0 (_tmp11_);
					_g_free0 (_tmp10_);
				}
				_vala_code_node_unref0 (base_type);
			}
			_vala_iterable_unref0 (_base_type_list);
		}
		if (!vala_symbol_get_external ((ValaSymbol*) self)) {
			_tmp13_ = !vala_symbol_get_external_package ((ValaSymbol*) self);
		} else {
			_tmp13_ = FALSE;
		}
		if (_tmp13_) {
			_tmp12_ = self->priv->_base_class != NULL;
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			{
				ValaList* _f_list;
				gint _f_size;
				gint _f_index;
				_f_list = _vala_iterable_ref0 (self->priv->fields);
				_f_size = vala_collection_get_size ((ValaCollection*) _f_list);
				_f_index = -1;
				while (TRUE) {
					ValaField* f;
					if (!((_f_index = _f_index + 1) < _f_size)) {
						break;
					}
					f = (ValaField*) vala_list_get (_f_list, _f_index);
					if (vala_field_get_binding (f) == MEMBER_BINDING_INSTANCE) {
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), "derived compact classes may not have instance fields");
						_vala_code_node_unref0 (f);
						break;
					}
					_vala_code_node_unref0 (f);
				}
				_vala_iterable_unref0 (_f_list);
			}
		}
	}
	prerequisites = (ValaList*) vala_array_list_new (VALA_TYPE_TYPESYMBOL, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	{
		ValaList* _base_type_list;
		gint _base_type_size;
		gint _base_type_index;
		_base_type_list = vala_class_get_base_types (self);
		_base_type_size = vala_collection_get_size ((ValaCollection*) _base_type_list);
		_base_type_index = -1;
		while (TRUE) {
			ValaDataType* base_type;
			if (!((_base_type_index = _base_type_index + 1) < _base_type_size)) {
				break;
			}
			base_type = (ValaDataType*) vala_list_get (_base_type_list, _base_type_index);
			if (VALA_IS_INTERFACE (vala_data_type_get_data_type (base_type))) {
				vala_class_get_all_prerequisites (self, VALA_INTERFACE (vala_data_type_get_data_type (base_type)), prerequisites);
			}
			_vala_code_node_unref0 (base_type);
		}
		_vala_iterable_unref0 (_base_type_list);
	}
	missing_prereqs = (ValaList*) vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_direct_equal);
	{
		ValaList* _prereq_list;
		gint _prereq_size;
		gint _prereq_index;
		_prereq_list = _vala_iterable_ref0 (prerequisites);
		_prereq_size = vala_collection_get_size ((ValaCollection*) _prereq_list);
		_prereq_index = -1;
		while (TRUE) {
			ValaTypeSymbol* prereq;
			if (!((_prereq_index = _prereq_index + 1) < _prereq_size)) {
				break;
			}
			prereq = (ValaTypeSymbol*) vala_list_get (_prereq_list, _prereq_index);
			if (!vala_class_class_is_a (self, self, prereq)) {
				char* _tmp14_;
				vala_list_insert (missing_prereqs, 0, _tmp14_ = vala_symbol_get_full_name ((ValaSymbol*) prereq));
				_g_free0 (_tmp14_);
			}
			_vala_code_node_unref0 (prereq);
		}
		_vala_iterable_unref0 (_prereq_list);
	}
	if (vala_collection_get_size ((ValaCollection*) missing_prereqs) > 0) {
		char* _tmp15_;
		char* _tmp16_;
		char* error_string;
		gboolean first;
		char* _tmp19_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		error_string = (_tmp16_ = g_strdup_printf ("%s: some prerequisites (", _tmp15_ = vala_symbol_get_full_name ((ValaSymbol*) self)), _g_free0 (_tmp15_), _tmp16_);
		first = TRUE;
		{
			ValaList* _s_list;
			gint _s_size;
			gint _s_index;
			_s_list = _vala_iterable_ref0 (missing_prereqs);
			_s_size = vala_collection_get_size ((ValaCollection*) _s_list);
			_s_index = -1;
			while (TRUE) {
				char* s;
				if (!((_s_index = _s_index + 1) < _s_size)) {
					break;
				}
				s = (char*) vala_list_get (_s_list, _s_index);
				if (first) {
					char* _tmp17_;
					error_string = (_tmp17_ = g_strdup_printf ("%s`%s'", error_string, s), _g_free0 (error_string), _tmp17_);
					first = FALSE;
				} else {
					char* _tmp18_;
					error_string = (_tmp18_ = g_strdup_printf ("%s, `%s'", error_string, s), _g_free0 (error_string), _tmp18_);
				}
				_g_free0 (s);
			}
			_vala_iterable_unref0 (_s_list);
		}
		error_string = (_tmp19_ = g_strconcat (error_string, ") are not met", NULL), _g_free0 (error_string), _tmp19_);
		vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), error_string);
		_g_free0 (error_string);
	}
	if (vala_symbol_get_source_type ((ValaSymbol*) self) == SOURCE_FILE_TYPE_SOURCE) {
		{
			ValaList* _base_type_list;
			gint _base_type_size;
			gint _base_type_index;
			_base_type_list = vala_class_get_base_types (self);
			_base_type_size = vala_collection_get_size ((ValaCollection*) _base_type_list);
			_base_type_index = -1;
			while (TRUE) {
				ValaDataType* base_type;
				if (!((_base_type_index = _base_type_index + 1) < _base_type_size)) {
					break;
				}
				base_type = (ValaDataType*) vala_list_get (_base_type_list, _base_type_index);
				if (VALA_IS_INTERFACE (vala_data_type_get_data_type (base_type))) {
					ValaInterface* iface;
					gboolean _tmp20_ = FALSE;
					iface = _vala_code_node_ref0 (VALA_INTERFACE (vala_data_type_get_data_type (base_type)));
					if (self->priv->_base_class != NULL) {
						_tmp20_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) self->priv->_base_class, (ValaTypeSymbol*) iface);
					} else {
						_tmp20_ = FALSE;
					}
					if (_tmp20_) {
						_vala_code_node_unref0 (iface);
						_vala_code_node_unref0 (base_type);
						break;
					}
					{
						ValaList* _m_list;
						gint _m_size;
						gint _m_index;
						_m_list = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) iface);
						_m_size = vala_collection_get_size ((ValaCollection*) _m_list);
						_m_index = -1;
						while (TRUE) {
							ValaMethod* m;
							if (!((_m_index = _m_index + 1) < _m_size)) {
								break;
							}
							m = (ValaMethod*) vala_list_get (_m_list, _m_index);
							if (vala_method_get_is_abstract (m)) {
								ValaSymbol* sym;
								ValaClass* base_class;
								sym = NULL;
								base_class = _vala_code_node_ref0 (self);
								while (TRUE) {
									gboolean _tmp21_ = FALSE;
									ValaSymbol* _tmp22_;
									ValaClass* _tmp23_;
									if (base_class != NULL) {
										_tmp21_ = !VALA_IS_METHOD (sym);
									} else {
										_tmp21_ = FALSE;
									}
									if (!_tmp21_) {
										break;
									}
									sym = (_tmp22_ = vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) base_class), vala_symbol_get_name ((ValaSymbol*) m)), _vala_code_node_unref0 (sym), _tmp22_);
									base_class = (_tmp23_ = _vala_code_node_ref0 (base_class->priv->_base_class), _vala_code_node_unref0 (base_class), _tmp23_);
								}
								if (VALA_IS_METHOD (sym)) {
									vala_symbol_check_deprecated (sym, vala_code_node_get_source_reference ((ValaCodeNode*) self));
									vala_symbol_set_used (sym, TRUE);
								} else {
									char* _tmp24_;
									char* _tmp25_;
									char* _tmp26_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), _tmp26_ = g_strdup_printf ("`%s' does not implement interface method `%s'", _tmp24_ = vala_symbol_get_full_name ((ValaSymbol*) self), _tmp25_ = vala_symbol_get_full_name ((ValaSymbol*) m)));
									_g_free0 (_tmp26_);
									_g_free0 (_tmp25_);
									_g_free0 (_tmp24_);
								}
								_vala_code_node_unref0 (base_class);
								_vala_code_node_unref0 (sym);
							}
							_vala_code_node_unref0 (m);
						}
						_vala_iterable_unref0 (_m_list);
					}
					{
						ValaList* _prop_list;
						gint _prop_size;
						gint _prop_index;
						_prop_list = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) iface);
						_prop_size = vala_collection_get_size ((ValaCollection*) _prop_list);
						_prop_index = -1;
						while (TRUE) {
							ValaProperty* prop;
							if (!((_prop_index = _prop_index + 1) < _prop_size)) {
								break;
							}
							prop = (ValaProperty*) vala_list_get (_prop_list, _prop_index);
							if (vala_property_get_is_abstract (prop)) {
								ValaSymbol* sym;
								ValaClass* base_class;
								sym = NULL;
								base_class = _vala_code_node_ref0 (self);
								while (TRUE) {
									gboolean _tmp27_ = FALSE;
									ValaSymbol* _tmp28_;
									ValaClass* _tmp29_;
									if (base_class != NULL) {
										_tmp27_ = !VALA_IS_PROPERTY (sym);
									} else {
										_tmp27_ = FALSE;
									}
									if (!_tmp27_) {
										break;
									}
									sym = (_tmp28_ = vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) base_class), vala_symbol_get_name ((ValaSymbol*) prop)), _vala_code_node_unref0 (sym), _tmp28_);
									base_class = (_tmp29_ = _vala_code_node_ref0 (base_class->priv->_base_class), _vala_code_node_unref0 (base_class), _tmp29_);
								}
								if (VALA_IS_PROPERTY (sym)) {
									vala_symbol_check_deprecated (sym, vala_code_node_get_source_reference ((ValaCodeNode*) self));
									vala_symbol_set_used (sym, TRUE);
								} else {
									char* _tmp30_;
									char* _tmp31_;
									char* _tmp32_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), _tmp32_ = g_strdup_printf ("`%s' does not implement interface property `%s'", _tmp30_ = vala_symbol_get_full_name ((ValaSymbol*) self), _tmp31_ = vala_symbol_get_full_name ((ValaSymbol*) prop)));
									_g_free0 (_tmp32_);
									_g_free0 (_tmp31_);
									_g_free0 (_tmp30_);
								}
								_vala_code_node_unref0 (base_class);
								_vala_code_node_unref0 (sym);
							}
							_vala_code_node_unref0 (prop);
						}
						_vala_iterable_unref0 (_prop_list);
					}
					_vala_code_node_unref0 (iface);
				}
				_vala_code_node_unref0 (base_type);
			}
			_vala_iterable_unref0 (_base_type_list);
		}
		if (!self->priv->_is_abstract) {
			ValaClass* base_class;
			base_class = _vala_code_node_ref0 (self->priv->_base_class);
			while (TRUE) {
				gboolean _tmp33_ = FALSE;
				ValaClass* _tmp44_;
				if (base_class != NULL) {
					_tmp33_ = base_class->priv->_is_abstract;
				} else {
					_tmp33_ = FALSE;
				}
				if (!_tmp33_) {
					break;
				}
				{
					ValaList* _base_method_list;
					gint _base_method_size;
					gint _base_method_index;
					_base_method_list = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) base_class);
					_base_method_size = vala_collection_get_size ((ValaCollection*) _base_method_list);
					_base_method_index = -1;
					while (TRUE) {
						ValaMethod* base_method;
						if (!((_base_method_index = _base_method_index + 1) < _base_method_size)) {
							break;
						}
						base_method = (ValaMethod*) vala_list_get (_base_method_list, _base_method_index);
						if (vala_method_get_is_abstract (base_method)) {
							ValaSymbol* _tmp34_;
							ValaMethod* override_method;
							gboolean _tmp35_ = FALSE;
							override_method = (_tmp34_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) self, vala_symbol_get_name ((ValaSymbol*) base_method)), VALA_IS_METHOD (_tmp34_) ? ((ValaMethod*) _tmp34_) : NULL);
							if (override_method == NULL) {
								_tmp35_ = TRUE;
							} else {
								_tmp35_ = !vala_method_get_overrides (override_method);
							}
							if (_tmp35_) {
								char* _tmp36_;
								char* _tmp37_;
								char* _tmp38_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), _tmp38_ = g_strdup_printf ("`%s' does not implement abstract method `%s'", _tmp36_ = vala_symbol_get_full_name ((ValaSymbol*) self), _tmp37_ = vala_symbol_get_full_name ((ValaSymbol*) base_method)));
								_g_free0 (_tmp38_);
								_g_free0 (_tmp37_);
								_g_free0 (_tmp36_);
							}
							_vala_code_node_unref0 (override_method);
						}
						_vala_code_node_unref0 (base_method);
					}
					_vala_iterable_unref0 (_base_method_list);
				}
				{
					ValaList* _base_property_list;
					gint _base_property_size;
					gint _base_property_index;
					_base_property_list = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) base_class);
					_base_property_size = vala_collection_get_size ((ValaCollection*) _base_property_list);
					_base_property_index = -1;
					while (TRUE) {
						ValaProperty* base_property;
						if (!((_base_property_index = _base_property_index + 1) < _base_property_size)) {
							break;
						}
						base_property = (ValaProperty*) vala_list_get (_base_property_list, _base_property_index);
						if (vala_property_get_is_abstract (base_property)) {
							ValaSymbol* _tmp39_;
							ValaProperty* override_property;
							gboolean _tmp40_ = FALSE;
							override_property = (_tmp39_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) self, vala_symbol_get_name ((ValaSymbol*) base_property)), VALA_IS_PROPERTY (_tmp39_) ? ((ValaProperty*) _tmp39_) : NULL);
							if (override_property == NULL) {
								_tmp40_ = TRUE;
							} else {
								_tmp40_ = !vala_property_get_overrides (override_property);
							}
							if (_tmp40_) {
								char* _tmp41_;
								char* _tmp42_;
								char* _tmp43_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), _tmp43_ = g_strdup_printf ("`%s' does not implement abstract property `%s'", _tmp41_ = vala_symbol_get_full_name ((ValaSymbol*) self), _tmp42_ = vala_symbol_get_full_name ((ValaSymbol*) base_property)));
								_g_free0 (_tmp43_);
								_g_free0 (_tmp42_);
								_g_free0 (_tmp41_);
							}
							_vala_code_node_unref0 (override_property);
						}
						_vala_code_node_unref0 (base_property);
					}
					_vala_iterable_unref0 (_base_property_list);
				}
				base_class = (_tmp44_ = _vala_code_node_ref0 (base_class->priv->_base_class), _vala_code_node_unref0 (base_class), _tmp44_);
			}
			_vala_code_node_unref0 (base_class);
		}
	}
	vala_semantic_analyzer_set_current_source_file (analyzer, old_source_file);
	vala_semantic_analyzer_set_current_symbol (analyzer, old_symbol);
	result = !vala_code_node_get_error ((ValaCodeNode*) self);
	_vala_iterable_unref0 (missing_prereqs);
	_vala_iterable_unref0 (prerequisites);
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}


ValaClass* vala_class_get_base_class (ValaClass* self) {
	ValaClass* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_base_class;
	return result;
}


void vala_class_set_base_class (ValaClass* self, ValaClass* value) {
	ValaClass* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_base_class = (_tmp0_ = _vala_code_node_ref0 (value), _vala_code_node_unref0 (self->priv->_base_class), _tmp0_);
}


gboolean vala_class_get_is_abstract (ValaClass* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_abstract;
	return result;
}


void vala_class_set_is_abstract (ValaClass* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_is_abstract = value;
}


gboolean vala_class_get_is_compact (ValaClass* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->_base_class != NULL) {
		result = vala_class_get_is_compact (self->priv->_base_class);
		return result;
	}
	result = self->priv->_is_compact;
	return result;
}


void vala_class_set_is_compact (ValaClass* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_is_compact = value;
}


gboolean vala_class_get_is_immutable (ValaClass* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->_base_class != NULL) {
		result = vala_class_get_is_immutable (self->priv->_base_class);
		return result;
	}
	result = self->priv->_is_immutable;
	return result;
}


void vala_class_set_is_immutable (ValaClass* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_is_immutable = value;
}


gboolean vala_class_get_ref_function_void (ValaClass* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->_base_class != NULL) {
		result = vala_class_get_ref_function_void (self->priv->_base_class);
		return result;
	}
	result = self->priv->_ref_function_void;
	return result;
}


void vala_class_set_ref_function_void (ValaClass* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_ref_function_void = value;
}


const char* vala_class_get_type_check_function (ValaClass* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_type_check_function;
	return result;
}


void vala_class_set_type_check_function (ValaClass* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_type_check_function = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_type_check_function), _tmp0_);
}


gboolean vala_class_get_has_private_fields (ValaClass* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_private_fields;
	return result;
}


static void vala_class_set_has_private_fields (ValaClass* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_has_private_fields = value;
}


gboolean vala_class_get_has_class_private_fields (ValaClass* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_class_private_fields;
	return result;
}


static void vala_class_set_has_class_private_fields (ValaClass* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_has_class_private_fields = value;
}


gboolean vala_class_get_free_function_address_of (ValaClass* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_free_function_address_of;
	return result;
}


static void vala_class_set_free_function_address_of (ValaClass* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_free_function_address_of = value;
}


gboolean vala_class_get_is_gboxed (ValaClass* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = _vala_strcmp0 (self->priv->free_function, "g_boxed_free") == 0;
	return result;
}


const char* vala_class_get_const_cname (ValaClass* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_const_cname;
	return result;
}


void vala_class_set_const_cname (ValaClass* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_const_cname = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_const_cname), _tmp0_);
}


ValaMethod* vala_class_get_default_construction_method (ValaClass* self) {
	ValaMethod* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_default_construction_method;
	return result;
}


void vala_class_set_default_construction_method (ValaClass* self, ValaMethod* value) {
	ValaMethod* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_default_construction_method = (_tmp0_ = _vala_code_node_ref0 (value), _vala_code_node_unref0 (self->priv->_default_construction_method), _tmp0_);
}


ValaConstructor* vala_class_get_constructor (ValaClass* self) {
	ValaConstructor* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_constructor;
	return result;
}


void vala_class_set_constructor (ValaClass* self, ValaConstructor* value) {
	ValaConstructor* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_constructor = (_tmp0_ = _vala_code_node_ref0 (value), _vala_code_node_unref0 (self->priv->_constructor), _tmp0_);
}


ValaConstructor* vala_class_get_class_constructor (ValaClass* self) {
	ValaConstructor* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_class_constructor;
	return result;
}


void vala_class_set_class_constructor (ValaClass* self, ValaConstructor* value) {
	ValaConstructor* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_class_constructor = (_tmp0_ = _vala_code_node_ref0 (value), _vala_code_node_unref0 (self->priv->_class_constructor), _tmp0_);
}


ValaConstructor* vala_class_get_static_constructor (ValaClass* self) {
	ValaConstructor* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_static_constructor;
	return result;
}


void vala_class_set_static_constructor (ValaClass* self, ValaConstructor* value) {
	ValaConstructor* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_static_constructor = (_tmp0_ = _vala_code_node_ref0 (value), _vala_code_node_unref0 (self->priv->_static_constructor), _tmp0_);
}


ValaDestructor* vala_class_get_destructor (ValaClass* self) {
	ValaDestructor* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_destructor;
	return result;
}


void vala_class_set_destructor (ValaClass* self, ValaDestructor* value) {
	ValaDestructor* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_destructor = (_tmp0_ = _vala_code_node_ref0 (value), _vala_code_node_unref0 (self->priv->_destructor), _tmp0_);
	if (self->priv->_destructor != NULL) {
		ValaObjectType* _tmp1_;
		ValaFormalParameter* _tmp2_;
		if (vala_destructor_get_this_parameter (self->priv->_destructor) != NULL) {
			vala_scope_remove (vala_symbol_get_scope ((ValaSymbol*) self->priv->_destructor), vala_symbol_get_name ((ValaSymbol*) vala_destructor_get_this_parameter (self->priv->_destructor)));
		}
		vala_destructor_set_this_parameter (self->priv->_destructor, _tmp2_ = vala_formal_parameter_new ("this", (ValaDataType*) (_tmp1_ = vala_object_type_symbol_get_this_type ((ValaObjectTypeSymbol*) self)), NULL));
		_vala_code_node_unref0 (_tmp2_);
		_vala_code_node_unref0 (_tmp1_);
		vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) self->priv->_destructor), vala_symbol_get_name ((ValaSymbol*) vala_destructor_get_this_parameter (self->priv->_destructor)), (ValaSymbol*) vala_destructor_get_this_parameter (self->priv->_destructor));
	}
}


ValaDestructor* vala_class_get_static_destructor (ValaClass* self) {
	ValaDestructor* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_static_destructor;
	return result;
}


void vala_class_set_static_destructor (ValaClass* self, ValaDestructor* value) {
	ValaDestructor* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_static_destructor = (_tmp0_ = _vala_code_node_ref0 (value), _vala_code_node_unref0 (self->priv->_static_destructor), _tmp0_);
}


ValaDestructor* vala_class_get_class_destructor (ValaClass* self) {
	ValaDestructor* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_class_destructor;
	return result;
}


void vala_class_set_class_destructor (ValaClass* self, ValaDestructor* value) {
	ValaDestructor* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_class_destructor = (_tmp0_ = _vala_code_node_ref0 (value), _vala_code_node_unref0 (self->priv->_class_destructor), _tmp0_);
}


gboolean vala_class_get_is_error_base (ValaClass* self) {
	gboolean result;
	ValaAttribute* _tmp0_;
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	result = (_tmp1_ = (_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "ErrorBase")) != NULL, _vala_code_node_unref0 (_tmp0_), _tmp1_);
	return result;
}


static void vala_class_class_init (ValaClassClass * klass) {
	vala_class_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_class_finalize;
	g_type_class_add_private (klass, sizeof (ValaClassPrivate));
	VALA_SYMBOL_CLASS (klass)->add_constant = vala_class_real_add_constant;
	VALA_SYMBOL_CLASS (klass)->add_field = vala_class_real_add_field;
	VALA_SYMBOL_CLASS (klass)->add_method = vala_class_real_add_method;
	VALA_OBJECT_TYPE_SYMBOL_CLASS (klass)->get_methods = vala_class_real_get_methods;
	VALA_SYMBOL_CLASS (klass)->add_property = vala_class_real_add_property;
	VALA_OBJECT_TYPE_SYMBOL_CLASS (klass)->get_properties = vala_class_real_get_properties;
	VALA_SYMBOL_CLASS (klass)->add_signal = vala_class_real_add_signal;
	VALA_OBJECT_TYPE_SYMBOL_CLASS (klass)->get_signals = vala_class_real_get_signals;
	VALA_SYMBOL_CLASS (klass)->add_class = vala_class_real_add_class;
	VALA_SYMBOL_CLASS (klass)->add_struct = vala_class_real_add_struct;
	VALA_SYMBOL_CLASS (klass)->add_enum = vala_class_real_add_enum;
	VALA_SYMBOL_CLASS (klass)->add_delegate = vala_class_real_add_delegate;
	VALA_SYMBOL_CLASS (klass)->add_constructor = vala_class_real_add_constructor;
	VALA_SYMBOL_CLASS (klass)->add_destructor = vala_class_real_add_destructor;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_class_real_accept;
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_class_real_accept_children;
	VALA_SYMBOL_CLASS (klass)->get_cprefix = vala_class_real_get_cprefix;
	VALA_TYPESYMBOL_CLASS (klass)->get_cname = vala_class_real_get_cname;
	VALA_SYMBOL_CLASS (klass)->get_lower_case_cname = vala_class_real_get_lower_case_cname;
	VALA_SYMBOL_CLASS (klass)->get_lower_case_cprefix = vala_class_real_get_lower_case_cprefix;
	VALA_TYPESYMBOL_CLASS (klass)->get_upper_case_cname = vala_class_real_get_upper_case_cname;
	VALA_TYPESYMBOL_CLASS (klass)->is_reference_type = vala_class_real_is_reference_type;
	VALA_TYPESYMBOL_CLASS (klass)->get_type_id = vala_class_real_get_type_id;
	VALA_TYPESYMBOL_CLASS (klass)->get_marshaller_type_name = vala_class_real_get_marshaller_type_name;
	VALA_TYPESYMBOL_CLASS (klass)->get_param_spec_function = vala_class_real_get_param_spec_function;
	VALA_TYPESYMBOL_CLASS (klass)->get_get_value_function = vala_class_real_get_get_value_function;
	VALA_TYPESYMBOL_CLASS (klass)->get_set_value_function = vala_class_real_get_set_value_function;
	VALA_TYPESYMBOL_CLASS (klass)->get_take_value_function = vala_class_real_get_take_value_function;
	VALA_TYPESYMBOL_CLASS (klass)->is_reference_counting = vala_class_real_is_reference_counting;
	VALA_TYPESYMBOL_CLASS (klass)->get_ref_function = vala_class_real_get_ref_function;
	VALA_TYPESYMBOL_CLASS (klass)->get_unref_function = vala_class_real_get_unref_function;
	VALA_TYPESYMBOL_CLASS (klass)->get_ref_sink_function = vala_class_real_get_ref_sink_function;
	VALA_TYPESYMBOL_CLASS (klass)->get_dup_function = vala_class_real_get_dup_function;
	VALA_TYPESYMBOL_CLASS (klass)->get_free_function = vala_class_real_get_free_function;
	VALA_TYPESYMBOL_CLASS (klass)->is_subtype_of = vala_class_real_is_subtype_of;
	VALA_CODE_NODE_CLASS (klass)->replace_type = vala_class_real_replace_type;
	VALA_CODE_NODE_CLASS (klass)->check = vala_class_real_check;
}


static void vala_class_instance_init (ValaClass * self) {
	self->priv = VALA_CLASS_GET_PRIVATE (self);
	self->priv->base_types = (ValaList*) vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->constants = (ValaList*) vala_array_list_new (VALA_TYPE_CONSTANT, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->fields = (ValaList*) vala_array_list_new (VALA_TYPE_FIELD, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->methods = (ValaList*) vala_array_list_new (VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->properties = (ValaList*) vala_array_list_new (VALA_TYPE_PROPERTY, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->signals = (ValaList*) vala_array_list_new (VALA_TYPE_SIGNAL, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->classes = (ValaList*) vala_array_list_new (VALA_TYPE_CLASS, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->structs = (ValaList*) vala_array_list_new (VALA_TYPE_STRUCT, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->enums = (ValaList*) vala_array_list_new (VALA_TYPE_ENUM, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->delegates = (ValaList*) vala_array_list_new (VALA_TYPE_DELEGATE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
}


static void vala_class_finalize (ValaCodeNode* obj) {
	ValaClass * self;
	self = VALA_CLASS (obj);
	_vala_code_node_unref0 (self->priv->_base_class);
	_g_free0 (self->priv->_type_check_function);
	_g_free0 (self->priv->cname);
	_g_free0 (self->priv->_const_cname);
	_g_free0 (self->priv->lower_case_cprefix);
	_g_free0 (self->priv->lower_case_csuffix);
	_g_free0 (self->priv->type_id);
	_g_free0 (self->priv->ref_function);
	_g_free0 (self->priv->unref_function);
	_g_free0 (self->priv->ref_sink_function);
	_g_free0 (self->priv->param_spec_function);
	_g_free0 (self->priv->copy_function);
	_g_free0 (self->priv->free_function);
	_g_free0 (self->priv->marshaller_type_name);
	_g_free0 (self->priv->get_value_function);
	_g_free0 (self->priv->set_value_function);
	_g_free0 (self->priv->take_value_function);
	_vala_iterable_unref0 (self->priv->base_types);
	_vala_iterable_unref0 (self->priv->constants);
	_vala_iterable_unref0 (self->priv->fields);
	_vala_iterable_unref0 (self->priv->methods);
	_vala_iterable_unref0 (self->priv->properties);
	_vala_iterable_unref0 (self->priv->signals);
	_vala_iterable_unref0 (self->priv->classes);
	_vala_iterable_unref0 (self->priv->structs);
	_vala_iterable_unref0 (self->priv->enums);
	_vala_iterable_unref0 (self->priv->delegates);
	_vala_code_node_unref0 (self->priv->_default_construction_method);
	_vala_code_node_unref0 (self->priv->_constructor);
	_vala_code_node_unref0 (self->priv->_class_constructor);
	_vala_code_node_unref0 (self->priv->_static_constructor);
	_vala_code_node_unref0 (self->priv->_static_destructor);
	_vala_code_node_unref0 (self->priv->_class_destructor);
	_vala_code_node_unref0 (self->priv->_destructor);
	VALA_CODE_NODE_CLASS (vala_class_parent_class)->finalize (obj);
}


/**
 * Represents a class declaration in the source code.
 */
GType vala_class_get_type (void) {
	static volatile gsize vala_class_type_id__volatile = 0;
	if (g_once_init_enter (&vala_class_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaClassClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_class_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaClass), 0, (GInstanceInitFunc) vala_class_instance_init, NULL };
		GType vala_class_type_id;
		vala_class_type_id = g_type_register_static (VALA_TYPE_OBJECT_TYPE_SYMBOL, "ValaClass", &g_define_type_info, 0);
		g_once_init_leave (&vala_class_type_id__volatile, vala_class_type_id);
	}
	return vala_class_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}



