/* valadatatype.c generated by valac, the Vala compiler
 * generated from valadatatype.vala, do not modify */

/* valadatatype.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>


#define VALA_TYPE_CODE_NODE (vala_code_node_get_type ())
#define VALA_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_NODE, ValaCodeNode))
#define VALA_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))
#define VALA_IS_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_NODE))
#define VALA_IS_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_NODE))
#define VALA_CODE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))

typedef struct _ValaCodeNode ValaCodeNode;
typedef struct _ValaCodeNodeClass ValaCodeNodeClass;
typedef struct _ValaCodeNodePrivate ValaCodeNodePrivate;

#define VALA_TYPE_CODE_VISITOR (vala_code_visitor_get_type ())
#define VALA_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitor))
#define VALA_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))
#define VALA_IS_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_VISITOR))
#define VALA_IS_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_VISITOR))
#define VALA_CODE_VISITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))

typedef struct _ValaCodeVisitor ValaCodeVisitor;
typedef struct _ValaCodeVisitorClass ValaCodeVisitorClass;

#define VALA_TYPE_SEMANTIC_ANALYZER (vala_semantic_analyzer_get_type ())
#define VALA_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzer))
#define VALA_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))
#define VALA_IS_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_IS_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_SEMANTIC_ANALYZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))

typedef struct _ValaSemanticAnalyzer ValaSemanticAnalyzer;
typedef struct _ValaSemanticAnalyzerClass ValaSemanticAnalyzerClass;

#define VALA_TYPE_CODE_GENERATOR (vala_code_generator_get_type ())
#define VALA_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGenerator))
#define VALA_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))
#define VALA_IS_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_GENERATOR))
#define VALA_IS_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_GENERATOR))
#define VALA_CODE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))

typedef struct _ValaCodeGenerator ValaCodeGenerator;
typedef struct _ValaCodeGeneratorClass ValaCodeGeneratorClass;

#define VALA_TYPE_DATA_TYPE (vala_data_type_get_type ())
#define VALA_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DATA_TYPE, ValaDataType))
#define VALA_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))
#define VALA_IS_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DATA_TYPE))
#define VALA_IS_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DATA_TYPE))
#define VALA_DATA_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))

typedef struct _ValaDataType ValaDataType;
typedef struct _ValaDataTypeClass ValaDataTypeClass;

#define VALA_TYPE_EXPRESSION (vala_expression_get_type ())
#define VALA_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_EXPRESSION, ValaExpression))
#define VALA_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_EXPRESSION, ValaExpressionClass))
#define VALA_IS_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_EXPRESSION))
#define VALA_IS_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_EXPRESSION))
#define VALA_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_EXPRESSION, ValaExpressionClass))

typedef struct _ValaExpression ValaExpression;
typedef struct _ValaExpressionClass ValaExpressionClass;

#define VALA_TYPE_SYMBOL (vala_symbol_get_type ())
#define VALA_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SYMBOL, ValaSymbol))
#define VALA_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SYMBOL, ValaSymbolClass))
#define VALA_IS_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SYMBOL))
#define VALA_IS_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SYMBOL))
#define VALA_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SYMBOL, ValaSymbolClass))

typedef struct _ValaSymbol ValaSymbol;
typedef struct _ValaSymbolClass ValaSymbolClass;

#define VALA_TYPE_VARIABLE (vala_variable_get_type ())
#define VALA_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VARIABLE, ValaVariable))
#define VALA_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VARIABLE, ValaVariableClass))
#define VALA_IS_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VARIABLE))
#define VALA_IS_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VARIABLE))
#define VALA_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VARIABLE, ValaVariableClass))

typedef struct _ValaVariable ValaVariable;
typedef struct _ValaVariableClass ValaVariableClass;

#define VALA_TYPE_LOCAL_VARIABLE (vala_local_variable_get_type ())
#define VALA_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable))
#define VALA_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))
#define VALA_IS_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_IS_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_LOCAL_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))

typedef struct _ValaLocalVariable ValaLocalVariable;
typedef struct _ValaLocalVariableClass ValaLocalVariableClass;

#define VALA_TYPE_ATTRIBUTE (vala_attribute_get_type ())
#define VALA_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ATTRIBUTE, ValaAttribute))
#define VALA_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))
#define VALA_IS_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ATTRIBUTE))
#define VALA_IS_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ATTRIBUTE))
#define VALA_ATTRIBUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))

typedef struct _ValaAttribute ValaAttribute;
typedef struct _ValaAttributeClass ValaAttributeClass;
typedef struct _ValaDataTypePrivate ValaDataTypePrivate;

#define VALA_TYPE_SCOPE (vala_scope_get_type ())
#define VALA_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SCOPE, ValaScope))
#define VALA_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SCOPE, ValaScopeClass))
#define VALA_IS_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SCOPE))
#define VALA_IS_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SCOPE))
#define VALA_SCOPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SCOPE, ValaScopeClass))

typedef struct _ValaScope ValaScope;
typedef struct _ValaScopeClass ValaScopeClass;

#define VALA_TYPE_FORMAL_PARAMETER (vala_formal_parameter_get_type ())
#define VALA_FORMAL_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FORMAL_PARAMETER, ValaFormalParameter))
#define VALA_FORMAL_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FORMAL_PARAMETER, ValaFormalParameterClass))
#define VALA_IS_FORMAL_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FORMAL_PARAMETER))
#define VALA_IS_FORMAL_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FORMAL_PARAMETER))
#define VALA_FORMAL_PARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FORMAL_PARAMETER, ValaFormalParameterClass))

typedef struct _ValaFormalParameter ValaFormalParameter;
typedef struct _ValaFormalParameterClass ValaFormalParameterClass;

#define VALA_TYPE_MEMBER_ACCESS (vala_member_access_get_type ())
#define VALA_MEMBER_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess))
#define VALA_MEMBER_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_MEMBER_ACCESS, ValaMemberAccessClass))
#define VALA_IS_MEMBER_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_MEMBER_ACCESS))
#define VALA_IS_MEMBER_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_MEMBER_ACCESS))
#define VALA_MEMBER_ACCESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_MEMBER_ACCESS, ValaMemberAccessClass))

typedef struct _ValaMemberAccess ValaMemberAccess;
typedef struct _ValaMemberAccessClass ValaMemberAccessClass;

#define VALA_TYPE_TYPESYMBOL (vala_typesymbol_get_type ())
#define VALA_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbol))
#define VALA_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))
#define VALA_IS_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPESYMBOL))
#define VALA_IS_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPESYMBOL))
#define VALA_TYPESYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))

typedef struct _ValaTypeSymbol ValaTypeSymbol;
typedef struct _ValaTypeSymbolClass ValaTypeSymbolClass;

#define VALA_TYPE_TYPEPARAMETER (vala_typeparameter_get_type ())
#define VALA_TYPEPARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPEPARAMETER, ValaTypeParameter))
#define VALA_TYPEPARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPEPARAMETER, ValaTypeParameterClass))
#define VALA_IS_TYPEPARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPEPARAMETER))
#define VALA_IS_TYPEPARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPEPARAMETER))
#define VALA_TYPEPARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPEPARAMETER, ValaTypeParameterClass))

typedef struct _ValaTypeParameter ValaTypeParameter;
typedef struct _ValaTypeParameterClass ValaTypeParameterClass;
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

#define VALA_TYPE_SOURCE_REFERENCE (vala_source_reference_get_type ())
#define VALA_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReference))
#define VALA_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))
#define VALA_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))

typedef struct _ValaSourceReference ValaSourceReference;
typedef struct _ValaSourceReferenceClass ValaSourceReferenceClass;

#define VALA_TYPE_REFERENCE_TYPE (vala_reference_type_get_type ())
#define VALA_REFERENCE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_REFERENCE_TYPE, ValaReferenceType))
#define VALA_REFERENCE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_REFERENCE_TYPE, ValaReferenceTypeClass))
#define VALA_IS_REFERENCE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_REFERENCE_TYPE))
#define VALA_IS_REFERENCE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_REFERENCE_TYPE))
#define VALA_REFERENCE_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_REFERENCE_TYPE, ValaReferenceTypeClass))

typedef struct _ValaReferenceType ValaReferenceType;
typedef struct _ValaReferenceTypeClass ValaReferenceTypeClass;

#define VALA_TYPE_ARRAY_TYPE (vala_array_type_get_type ())
#define VALA_ARRAY_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ARRAY_TYPE, ValaArrayType))
#define VALA_ARRAY_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ARRAY_TYPE, ValaArrayTypeClass))
#define VALA_IS_ARRAY_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ARRAY_TYPE))
#define VALA_IS_ARRAY_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ARRAY_TYPE))
#define VALA_ARRAY_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ARRAY_TYPE, ValaArrayTypeClass))

typedef struct _ValaArrayType ValaArrayType;
typedef struct _ValaArrayTypeClass ValaArrayTypeClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_scope_unref0(var) ((var == NULL) ? NULL : (var = (vala_scope_unref (var), NULL)))

#define VALA_TYPE_CODE_CONTEXT (vala_code_context_get_type ())
#define VALA_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContext))
#define VALA_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))
#define VALA_IS_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_CONTEXT))
#define VALA_IS_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_CONTEXT))
#define VALA_CODE_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))

typedef struct _ValaCodeContext ValaCodeContext;
typedef struct _ValaCodeContextClass ValaCodeContextClass;
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))

#define VALA_TYPE_VALUE_TYPE (vala_value_type_get_type ())
#define VALA_VALUE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VALUE_TYPE, ValaValueType))
#define VALA_VALUE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VALUE_TYPE, ValaValueTypeClass))
#define VALA_IS_VALUE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VALUE_TYPE))
#define VALA_IS_VALUE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VALUE_TYPE))
#define VALA_VALUE_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VALUE_TYPE, ValaValueTypeClass))

typedef struct _ValaValueType ValaValueType;
typedef struct _ValaValueTypeClass ValaValueTypeClass;

#define VALA_TYPE_DELEGATE_TYPE (vala_delegate_type_get_type ())
#define VALA_DELEGATE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DELEGATE_TYPE, ValaDelegateType))
#define VALA_DELEGATE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DELEGATE_TYPE, ValaDelegateTypeClass))
#define VALA_IS_DELEGATE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DELEGATE_TYPE))
#define VALA_IS_DELEGATE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DELEGATE_TYPE))
#define VALA_DELEGATE_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DELEGATE_TYPE, ValaDelegateTypeClass))

typedef struct _ValaDelegateType ValaDelegateType;
typedef struct _ValaDelegateTypeClass ValaDelegateTypeClass;

#define VALA_TYPE_DELEGATE (vala_delegate_get_type ())
#define VALA_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DELEGATE, ValaDelegate))
#define VALA_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DELEGATE, ValaDelegateClass))
#define VALA_IS_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DELEGATE))
#define VALA_IS_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DELEGATE))
#define VALA_DELEGATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DELEGATE, ValaDelegateClass))

typedef struct _ValaDelegate ValaDelegate;
typedef struct _ValaDelegateClass ValaDelegateClass;

#define VALA_TYPE_POINTER_TYPE (vala_pointer_type_get_type ())
#define VALA_POINTER_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_POINTER_TYPE, ValaPointerType))
#define VALA_POINTER_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_POINTER_TYPE, ValaPointerTypeClass))
#define VALA_IS_POINTER_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_POINTER_TYPE))
#define VALA_IS_POINTER_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_POINTER_TYPE))
#define VALA_POINTER_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_POINTER_TYPE, ValaPointerTypeClass))

typedef struct _ValaPointerType ValaPointerType;
typedef struct _ValaPointerTypeClass ValaPointerTypeClass;

#define VALA_TYPE_ENUM (vala_enum_get_type ())
#define VALA_ENUM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ENUM, ValaEnum))
#define VALA_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ENUM, ValaEnumClass))
#define VALA_IS_ENUM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ENUM))
#define VALA_IS_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ENUM))
#define VALA_ENUM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ENUM, ValaEnumClass))

typedef struct _ValaEnum ValaEnum;
typedef struct _ValaEnumClass ValaEnumClass;

#define VALA_TYPE_STRUCT (vala_struct_get_type ())
#define VALA_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_STRUCT, ValaStruct))
#define VALA_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_STRUCT, ValaStructClass))
#define VALA_IS_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_STRUCT))
#define VALA_IS_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_STRUCT))
#define VALA_STRUCT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_STRUCT, ValaStructClass))

typedef struct _ValaStruct ValaStruct;
typedef struct _ValaStructClass ValaStructClass;

#define VALA_TYPE_GENERIC_TYPE (vala_generic_type_get_type ())
#define VALA_GENERIC_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GENERIC_TYPE, ValaGenericType))
#define VALA_GENERIC_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GENERIC_TYPE, ValaGenericTypeClass))
#define VALA_IS_GENERIC_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GENERIC_TYPE))
#define VALA_IS_GENERIC_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GENERIC_TYPE))
#define VALA_GENERIC_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GENERIC_TYPE, ValaGenericTypeClass))

typedef struct _ValaGenericType ValaGenericType;
typedef struct _ValaGenericTypeClass ValaGenericTypeClass;

#define VALA_TYPE_VOID_TYPE (vala_void_type_get_type ())
#define VALA_VOID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VOID_TYPE, ValaVoidType))
#define VALA_VOID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VOID_TYPE, ValaVoidTypeClass))
#define VALA_IS_VOID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VOID_TYPE))
#define VALA_IS_VOID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VOID_TYPE))
#define VALA_VOID_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VOID_TYPE, ValaVoidTypeClass))

typedef struct _ValaVoidType ValaVoidType;
typedef struct _ValaVoidTypeClass ValaVoidTypeClass;

struct _ValaCodeNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCodeNodePrivate * priv;
	GList* attributes;
};

struct _ValaCodeNodeClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCodeNode *self);
	void (*accept) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	void (*accept_children) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	gboolean (*check) (ValaCodeNode* self, ValaSemanticAnalyzer* analyzer);
	void (*emit) (ValaCodeNode* self, ValaCodeGenerator* codegen);
	void (*replace_type) (ValaCodeNode* self, ValaDataType* old_type, ValaDataType* new_type);
	void (*replace_expression) (ValaCodeNode* self, ValaExpression* old_node, ValaExpression* new_node);
	char* (*to_string) (ValaCodeNode* self);
	void (*get_defined_variables) (ValaCodeNode* self, ValaCollection* collection);
	void (*get_used_variables) (ValaCodeNode* self, ValaCollection* collection);
};

struct _ValaDataType {
	ValaCodeNode parent_instance;
	ValaDataTypePrivate * priv;
};

struct _ValaDataTypeClass {
	ValaCodeNodeClass parent_class;
	char* (*get_cname) (ValaDataType* self);
	char* (*get_cdeclarator_suffix) (ValaDataType* self);
	char* (*get_lower_case_cname) (ValaDataType* self, const char* infix);
	char* (*to_qualified_string) (ValaDataType* self, ValaScope* scope);
	ValaDataType* (*copy) (ValaDataType* self);
	gboolean (*equals) (ValaDataType* self, ValaDataType* type2);
	gboolean (*stricter) (ValaDataType* self, ValaDataType* type2);
	gboolean (*compatible) (ValaDataType* self, ValaDataType* target_type);
	gboolean (*is_invokable) (ValaDataType* self);
	ValaDataType* (*get_return_type) (ValaDataType* self);
	ValaList* (*get_parameters) (ValaDataType* self);
	gboolean (*is_reference_type_or_type_parameter) (ValaDataType* self);
	gboolean (*is_array) (ValaDataType* self);
	gboolean (*is_accessible) (ValaDataType* self, ValaSymbol* sym);
	ValaSymbol* (*get_member) (ValaDataType* self, const char* member_name);
	ValaSymbol* (*get_pointer_member) (ValaDataType* self, const char* member_name);
	gboolean (*is_real_struct_type) (ValaDataType* self);
	char* (*get_type_id) (ValaDataType* self);
	gboolean (*is_disposable) (ValaDataType* self);
	ValaDataType* (*get_actual_type) (ValaDataType* self, ValaDataType* derived_instance_type, ValaMemberAccess* method_access, ValaCodeNode* node_reference);
};

struct _ValaDataTypePrivate {
	gboolean _value_owned;
	gboolean _nullable;
	ValaTypeSymbol* _data_type;
	ValaTypeParameter* _type_parameter;
	gboolean _floating_reference;
	gboolean _is_dynamic;
	ValaList* type_argument_list;
};


static gpointer vala_data_type_parent_class = NULL;
static ValaList* vala_data_type__empty_type_list;
static ValaList* vala_data_type__empty_type_list = NULL;

gpointer vala_code_node_ref (gpointer instance);
void vala_code_node_unref (gpointer instance);
GParamSpec* vala_param_spec_code_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_node (GValue* value, gpointer v_object);
void vala_value_take_code_node (GValue* value, gpointer v_object);
gpointer vala_value_get_code_node (const GValue* value);
GType vala_code_node_get_type (void) G_GNUC_CONST;
gpointer vala_code_visitor_ref (gpointer instance);
void vala_code_visitor_unref (gpointer instance);
GParamSpec* vala_param_spec_code_visitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_visitor (GValue* value, gpointer v_object);
void vala_value_take_code_visitor (GValue* value, gpointer v_object);
gpointer vala_value_get_code_visitor (const GValue* value);
GType vala_code_visitor_get_type (void) G_GNUC_CONST;
GType vala_semantic_analyzer_get_type (void) G_GNUC_CONST;
GType vala_code_generator_get_type (void) G_GNUC_CONST;
GType vala_data_type_get_type (void) G_GNUC_CONST;
GType vala_expression_get_type (void) G_GNUC_CONST;
GType vala_symbol_get_type (void) G_GNUC_CONST;
GType vala_variable_get_type (void) G_GNUC_CONST;
GType vala_local_variable_get_type (void) G_GNUC_CONST;
GType vala_attribute_get_type (void) G_GNUC_CONST;
gpointer vala_scope_ref (gpointer instance);
void vala_scope_unref (gpointer instance);
GParamSpec* vala_param_spec_scope (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_scope (GValue* value, gpointer v_object);
void vala_value_take_scope (GValue* value, gpointer v_object);
gpointer vala_value_get_scope (const GValue* value);
GType vala_scope_get_type (void) G_GNUC_CONST;
GType vala_formal_parameter_get_type (void) G_GNUC_CONST;
GType vala_member_access_get_type (void) G_GNUC_CONST;
GType vala_typesymbol_get_type (void) G_GNUC_CONST;
GType vala_typeparameter_get_type (void) G_GNUC_CONST;
#define VALA_DATA_TYPE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_DATA_TYPE, ValaDataTypePrivate))
enum  {
	VALA_DATA_TYPE_DUMMY_PROPERTY
};
void vala_data_type_add_type_argument (ValaDataType* self, ValaDataType* arg);
void vala_code_node_set_parent_node (ValaCodeNode* self, ValaCodeNode* value);
ValaList* vala_data_type_get_type_arguments (ValaDataType* self);
gboolean vala_data_type_has_type_arguments (ValaDataType* self);
void vala_data_type_remove_all_type_arguments (ValaDataType* self);
static void vala_data_type_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
void vala_code_node_accept (ValaCodeNode* self, ValaCodeVisitor* visitor);
void vala_code_visitor_visit_data_type (ValaCodeVisitor* self, ValaDataType* type);
char* vala_data_type_get_cname (ValaDataType* self);
static char* vala_data_type_real_get_cname (ValaDataType* self);
gpointer vala_source_reference_ref (gpointer instance);
void vala_source_reference_unref (gpointer instance);
GParamSpec* vala_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_reference (GValue* value, gpointer v_object);
void vala_value_take_source_reference (GValue* value, gpointer v_object);
gpointer vala_value_get_source_reference (const GValue* value);
GType vala_source_reference_get_type (void) G_GNUC_CONST;
void vala_report_error (ValaSourceReference* source, const char* message);
ValaSourceReference* vala_code_node_get_source_reference (ValaCodeNode* self);
char* vala_data_type_get_cdeclarator_suffix (ValaDataType* self);
static char* vala_data_type_real_get_cdeclarator_suffix (ValaDataType* self);
char* vala_data_type_get_const_cname (ValaDataType* self);
GType vala_reference_type_get_type (void) G_GNUC_CONST;
GType vala_array_type_get_type (void) G_GNUC_CONST;
ValaDataType* vala_array_type_get_element_type (ValaArrayType* self);
ValaTypeSymbol* vala_data_type_get_data_type (ValaDataType* self);
gboolean vala_typesymbol_is_reference_type (ValaTypeSymbol* self);
char* vala_typesymbol_get_cname (ValaTypeSymbol* self, gboolean const_type);
char* vala_data_type_get_lower_case_cname (ValaDataType* self, const char* infix);
static char* vala_data_type_real_get_lower_case_cname (ValaDataType* self, const char* infix);
char* vala_symbol_get_lower_case_cname (ValaSymbol* self, const char* infix);
static char* vala_data_type_real_to_string (ValaCodeNode* base);
char* vala_data_type_to_qualified_string (ValaDataType* self, ValaScope* scope);
static char* vala_data_type_real_to_qualified_string (ValaDataType* self, ValaScope* scope);
ValaSymbol* vala_symbol_get_parent_symbol (ValaSymbol* self);
const char* vala_symbol_get_name (ValaSymbol* self);
ValaSymbol* vala_scope_lookup (ValaScope* self, const char* name);
ValaScope* vala_scope_get_parent_scope (ValaScope* self);
char* vala_symbol_get_full_name (ValaSymbol* self);
gboolean vala_data_type_get_value_owned (ValaDataType* self);
gboolean vala_data_type_get_nullable (ValaDataType* self);
ValaDataType* vala_data_type_copy (ValaDataType* self);
static ValaDataType* vala_data_type_real_copy (ValaDataType* self);
gboolean vala_data_type_equals (ValaDataType* self, ValaDataType* type2);
static gboolean vala_data_type_real_equals (ValaDataType* self, ValaDataType* type2);
ValaTypeParameter* vala_data_type_get_type_parameter (ValaDataType* self);
gboolean vala_typeparameter_equals (ValaTypeParameter* self, ValaTypeParameter* param2);
gboolean vala_data_type_get_floating_reference (ValaDataType* self);
gboolean vala_data_type_stricter (ValaDataType* self, ValaDataType* type2);
static gboolean vala_data_type_real_stricter (ValaDataType* self, ValaDataType* type2);
static void vala_data_type_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type);
gboolean vala_data_type_compatible (ValaDataType* self, ValaDataType* target_type);
static gboolean vala_data_type_real_compatible (ValaDataType* self, ValaDataType* target_type);
gpointer vala_code_context_ref (gpointer instance);
void vala_code_context_unref (gpointer instance);
GParamSpec* vala_param_spec_code_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_context (GValue* value, gpointer v_object);
void vala_value_take_code_context (GValue* value, gpointer v_object);
gpointer vala_value_get_code_context (const GValue* value);
GType vala_code_context_get_type (void) G_GNUC_CONST;
ValaCodeContext* vala_code_context_get (void);
gboolean vala_code_context_get_experimental_non_null (ValaCodeContext* self);
char* vala_data_type_get_type_id (ValaDataType* self);
GType vala_value_type_get_type (void) G_GNUC_CONST;
GType vala_delegate_type_get_type (void) G_GNUC_CONST;
GType vala_delegate_get_type (void) G_GNUC_CONST;
ValaDelegate* vala_delegate_type_get_delegate_symbol (ValaDelegateType* self);
GType vala_pointer_type_get_type (void) G_GNUC_CONST;
GType vala_enum_get_type (void) G_GNUC_CONST;
GType vala_struct_get_type (void) G_GNUC_CONST;
gboolean vala_struct_is_integer_type (ValaStruct* self);
gboolean vala_struct_is_floating_type (ValaStruct* self);
gint vala_struct_get_rank (ValaStruct* self);
gboolean vala_typesymbol_is_subtype_of (ValaTypeSymbol* self, ValaTypeSymbol* t);
gboolean vala_data_type_is_invokable (ValaDataType* self);
static gboolean vala_data_type_real_is_invokable (ValaDataType* self);
ValaDataType* vala_data_type_get_return_type (ValaDataType* self);
static ValaDataType* vala_data_type_real_get_return_type (ValaDataType* self);
ValaList* vala_data_type_get_parameters (ValaDataType* self);
static ValaList* vala_data_type_real_get_parameters (ValaDataType* self);
gboolean vala_data_type_is_reference_type_or_type_parameter (ValaDataType* self);
static gboolean vala_data_type_real_is_reference_type_or_type_parameter (ValaDataType* self);
gboolean vala_data_type_is_array (ValaDataType* self);
static gboolean vala_data_type_real_is_array (ValaDataType* self);
gboolean vala_data_type_is_accessible (ValaDataType* self, ValaSymbol* sym);
static gboolean vala_data_type_real_is_accessible (ValaDataType* self, ValaSymbol* sym);
gboolean vala_symbol_is_accessible (ValaSymbol* self, ValaSymbol* sym);
ValaSymbol* vala_data_type_get_member (ValaDataType* self, const char* member_name);
static ValaSymbol* vala_data_type_real_get_member (ValaDataType* self, const char* member_name);
ValaSymbol* vala_semantic_analyzer_symbol_lookup_inherited (ValaSymbol* sym, const char* name);
ValaSymbol* vala_data_type_get_pointer_member (ValaDataType* self, const char* member_name);
static ValaSymbol* vala_data_type_real_get_pointer_member (ValaDataType* self, const char* member_name);
gboolean vala_data_type_is_real_struct_type (ValaDataType* self);
static gboolean vala_data_type_real_is_real_struct_type (ValaDataType* self);
gboolean vala_struct_is_simple_type (ValaStruct* self);
gboolean vala_data_type_is_real_non_null_struct_type (ValaDataType* self);
static char* vala_data_type_real_get_type_id (ValaDataType* self);
char* vala_typesymbol_get_type_id (ValaTypeSymbol* self);
gboolean vala_data_type_is_disposable (ValaDataType* self);
static gboolean vala_data_type_real_is_disposable (ValaDataType* self);
ValaDataType* vala_data_type_get_actual_type (ValaDataType* self, ValaDataType* derived_instance_type, ValaMemberAccess* method_access, ValaCodeNode* node_reference);
static ValaDataType* vala_data_type_real_get_actual_type (ValaDataType* self, ValaDataType* derived_instance_type, ValaMemberAccess* method_access, ValaCodeNode* node_reference);
GType vala_generic_type_get_type (void) G_GNUC_CONST;
ValaDataType* vala_semantic_analyzer_get_actual_type (ValaDataType* derived_instance_type, ValaMemberAccess* method_access, ValaGenericType* generic_type, ValaCodeNode* node_reference);
gboolean vala_data_type_is_weak (ValaDataType* self);
GType vala_void_type_get_type (void) G_GNUC_CONST;
ValaDataType* vala_data_type_construct (GType object_type);
ValaCodeNode* vala_code_node_construct (GType object_type);
void vala_data_type_set_value_owned (ValaDataType* self, gboolean value);
void vala_data_type_set_nullable (ValaDataType* self, gboolean value);
void vala_data_type_set_data_type (ValaDataType* self, ValaTypeSymbol* value);
void vala_data_type_set_type_parameter (ValaDataType* self, ValaTypeParameter* value);
void vala_data_type_set_floating_reference (ValaDataType* self, gboolean value);
gboolean vala_data_type_get_is_dynamic (ValaDataType* self);
void vala_data_type_set_is_dynamic (ValaDataType* self, gboolean value);
static void vala_data_type_finalize (ValaCodeNode* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);


/**
 * Appends the specified type as generic type argument.
 *
 * @param arg a type reference
 */
void vala_data_type_add_type_argument (ValaDataType* self, ValaDataType* arg) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	if (self->priv->type_argument_list == NULL) {
		ValaList* _tmp0_;
		self->priv->type_argument_list = (_tmp0_ = (ValaList*) vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal), _vala_iterable_unref0 (self->priv->type_argument_list), _tmp0_);
	}
	vala_collection_add ((ValaCollection*) self->priv->type_argument_list, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}


/**
 * Returns a copy of the list of generic type arguments.
 *
 * @return type argument list
 */
static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList* vala_data_type_get_type_arguments (ValaDataType* self) {
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->type_argument_list != NULL) {
		result = _vala_iterable_ref0 (self->priv->type_argument_list);
		return result;
	}
	if (vala_data_type__empty_type_list == NULL) {
		ValaList* _tmp0_;
		vala_data_type__empty_type_list = (_tmp0_ = (ValaList*) vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal), _vala_iterable_unref0 (vala_data_type__empty_type_list), _tmp0_);
	}
	result = _vala_iterable_ref0 (vala_data_type__empty_type_list);
	return result;
}


gboolean vala_data_type_has_type_arguments (ValaDataType* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->type_argument_list == NULL) {
		result = FALSE;
		return result;
	}
	result = vala_collection_get_size ((ValaCollection*) self->priv->type_argument_list) > 0;
	return result;
}


/**
 * Removes all generic type arguments.
 */
void vala_data_type_remove_all_type_arguments (ValaDataType* self) {
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->type_argument_list = (_tmp0_ = NULL, _vala_iterable_unref0 (self->priv->type_argument_list), _tmp0_);
}


static void vala_data_type_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaDataType * self;
	gboolean _tmp0_ = FALSE;
	self = (ValaDataType*) base;
	g_return_if_fail (visitor != NULL);
	if (self->priv->type_argument_list != NULL) {
		_tmp0_ = vala_collection_get_size ((ValaCollection*) self->priv->type_argument_list) > 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		{
			ValaList* _type_arg_list;
			gint _type_arg_size;
			gint _type_arg_index;
			_type_arg_list = _vala_iterable_ref0 (self->priv->type_argument_list);
			_type_arg_size = vala_collection_get_size ((ValaCollection*) _type_arg_list);
			_type_arg_index = -1;
			while (TRUE) {
				ValaDataType* type_arg;
				if (!((_type_arg_index = _type_arg_index + 1) < _type_arg_size)) {
					break;
				}
				type_arg = (ValaDataType*) vala_list_get (_type_arg_list, _type_arg_index);
				vala_code_node_accept ((ValaCodeNode*) type_arg, visitor);
				_vala_code_node_unref0 (type_arg);
			}
			_vala_iterable_unref0 (_type_arg_list);
		}
	}
	vala_code_visitor_visit_data_type (visitor, self);
}


/**
 * Returns the name and qualifiers of this type as it is used in C code.
 *
 * @return the type string to be used in C code
 */
static char* vala_data_type_real_get_cname (ValaDataType* self) {
	char* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), "unresolved type reference");
	result = NULL;
	return result;
}


char* vala_data_type_get_cname (ValaDataType* self) {
	return VALA_DATA_TYPE_GET_CLASS (self)->get_cname (self);
}


static char* vala_data_type_real_get_cdeclarator_suffix (ValaDataType* self) {
	char* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = g_strdup ("");
	return result;
}


char* vala_data_type_get_cdeclarator_suffix (ValaDataType* self) {
	return VALA_DATA_TYPE_GET_CLASS (self)->get_cdeclarator_suffix (self);
}


/**
 * Returns the name and qualifiers of this type as it is used in C code
 * in a const declaration.
 *
 * @return the type string to be used in C code const declarations
 */
static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


char* vala_data_type_get_const_cname (ValaDataType* self) {
	char* result = NULL;
	char* ptr;
	ValaTypeSymbol* t;
	char* _tmp4_;
	char* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	ptr = NULL;
	t = NULL;
	if (VALA_IS_ARRAY_TYPE (self)) {
		ValaTypeSymbol* _tmp0_;
		t = (_tmp0_ = _vala_code_node_ref0 (vala_array_type_get_element_type (VALA_ARRAY_TYPE (self))->priv->_data_type), _vala_code_node_unref0 (t), _tmp0_);
	} else {
		ValaTypeSymbol* _tmp1_;
		t = (_tmp1_ = _vala_code_node_ref0 (self->priv->_data_type), _vala_code_node_unref0 (t), _tmp1_);
	}
	if (!vala_typesymbol_is_reference_type (t)) {
		char* _tmp2_;
		ptr = (_tmp2_ = g_strdup (""), _g_free0 (ptr), _tmp2_);
	} else {
		char* _tmp3_;
		ptr = (_tmp3_ = g_strdup ("*"), _g_free0 (ptr), _tmp3_);
	}
	result = (_tmp5_ = g_strdup_printf ("const %s%s", _tmp4_ = vala_typesymbol_get_cname (t, FALSE), ptr), _g_free0 (_tmp4_), _tmp5_);
	_vala_code_node_unref0 (t);
	_g_free0 (ptr);
	return result;
}


/**
 * Returns the C name of this data type in lower case. Words are
 * separated by underscores.
 *
 * @param infix a string to be placed between namespace and data type
 *              name or null
 * @return      the lower case name to be used in C code
 */
static char* vala_data_type_real_get_lower_case_cname (ValaDataType* self, const char* infix) {
	char* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = vala_symbol_get_lower_case_cname ((ValaSymbol*) self->priv->_data_type, infix);
	return result;
}


char* vala_data_type_get_lower_case_cname (ValaDataType* self, const char* infix) {
	return VALA_DATA_TYPE_GET_CLASS (self)->get_lower_case_cname (self, infix);
}


static char* vala_data_type_real_to_string (ValaCodeNode* base) {
	ValaDataType * self;
	char* result = NULL;
	self = (ValaDataType*) base;
	result = vala_data_type_to_qualified_string (self, NULL);
	return result;
}


static gpointer _vala_scope_ref0 (gpointer self) {
	return self ? vala_scope_ref (self) : NULL;
}


static char* vala_data_type_real_to_qualified_string (ValaDataType* self, ValaScope* scope) {
	char* result = NULL;
	char* s;
	ValaList* type_args;
	g_return_val_if_fail (self != NULL, NULL);
	s = NULL;
	if (self->priv->_data_type != NULL) {
		ValaSymbol* global_symbol;
		ValaSymbol* sym;
		ValaScope* parent_scope;
		gboolean _tmp4_ = FALSE;
		global_symbol = _vala_code_node_ref0 ((ValaSymbol*) self->priv->_data_type);
		while (TRUE) {
			ValaSymbol* _tmp0_;
			if (!(vala_symbol_get_name (vala_symbol_get_parent_symbol (global_symbol)) != NULL)) {
				break;
			}
			global_symbol = (_tmp0_ = _vala_code_node_ref0 (vala_symbol_get_parent_symbol (global_symbol)), _vala_code_node_unref0 (global_symbol), _tmp0_);
		}
		sym = NULL;
		parent_scope = _vala_scope_ref0 (scope);
		while (TRUE) {
			gboolean _tmp1_ = FALSE;
			ValaSymbol* _tmp2_;
			ValaScope* _tmp3_;
			if (sym == NULL) {
				_tmp1_ = parent_scope != NULL;
			} else {
				_tmp1_ = FALSE;
			}
			if (!_tmp1_) {
				break;
			}
			sym = (_tmp2_ = vala_scope_lookup (parent_scope, vala_symbol_get_name (global_symbol)), _vala_code_node_unref0 (sym), _tmp2_);
			parent_scope = (_tmp3_ = _vala_scope_ref0 (vala_scope_get_parent_scope (parent_scope)), _vala_scope_unref0 (parent_scope), _tmp3_);
		}
		if (sym != NULL) {
			_tmp4_ = global_symbol != sym;
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			char* _tmp5_;
			char* _tmp6_;
			s = (_tmp6_ = g_strconcat ("global::", _tmp5_ = vala_symbol_get_full_name ((ValaSymbol*) self->priv->_data_type), NULL), _g_free0 (s), _tmp6_);
			_g_free0 (_tmp5_);
		} else {
			char* _tmp7_;
			s = (_tmp7_ = vala_symbol_get_full_name ((ValaSymbol*) self->priv->_data_type), _g_free0 (s), _tmp7_);
		}
		_vala_scope_unref0 (parent_scope);
		_vala_code_node_unref0 (sym);
		_vala_code_node_unref0 (global_symbol);
	} else {
		char* _tmp8_;
		s = (_tmp8_ = g_strdup ("null"), _g_free0 (s), _tmp8_);
	}
	type_args = vala_data_type_get_type_arguments (self);
	if (vala_collection_get_size ((ValaCollection*) type_args) > 0) {
		char* _tmp9_;
		gboolean first;
		char* _tmp14_;
		s = (_tmp9_ = g_strconcat (s, "<", NULL), _g_free0 (s), _tmp9_);
		first = TRUE;
		{
			ValaList* _type_arg_list;
			gint _type_arg_size;
			gint _type_arg_index;
			_type_arg_list = _vala_iterable_ref0 (type_args);
			_type_arg_size = vala_collection_get_size ((ValaCollection*) _type_arg_list);
			_type_arg_index = -1;
			while (TRUE) {
				ValaDataType* type_arg;
				char* _tmp12_;
				char* _tmp13_;
				if (!((_type_arg_index = _type_arg_index + 1) < _type_arg_size)) {
					break;
				}
				type_arg = (ValaDataType*) vala_list_get (_type_arg_list, _type_arg_index);
				if (!first) {
					char* _tmp10_;
					s = (_tmp10_ = g_strconcat (s, ",", NULL), _g_free0 (s), _tmp10_);
				} else {
					first = FALSE;
				}
				if (!type_arg->priv->_value_owned) {
					char* _tmp11_;
					s = (_tmp11_ = g_strconcat (s, "weak ", NULL), _g_free0 (s), _tmp11_);
				}
				s = (_tmp13_ = g_strconcat (s, _tmp12_ = vala_data_type_to_qualified_string (type_arg, scope), NULL), _g_free0 (s), _tmp13_);
				_g_free0 (_tmp12_);
				_vala_code_node_unref0 (type_arg);
			}
			_vala_iterable_unref0 (_type_arg_list);
		}
		s = (_tmp14_ = g_strconcat (s, ">", NULL), _g_free0 (s), _tmp14_);
	}
	if (self->priv->_nullable) {
		char* _tmp15_;
		s = (_tmp15_ = g_strconcat (s, "?", NULL), _g_free0 (s), _tmp15_);
	}
	result = s;
	_vala_iterable_unref0 (type_args);
	return result;
}


char* vala_data_type_to_qualified_string (ValaDataType* self, ValaScope* scope) {
	return VALA_DATA_TYPE_GET_CLASS (self)->to_qualified_string (self, scope);
}


/**
 * Creates a shallow copy of this type reference.
 *
 * @return copy of this type reference
 */
static ValaDataType* vala_data_type_real_copy (ValaDataType* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `vala_data_type_copy'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


ValaDataType* vala_data_type_copy (ValaDataType* self) {
	return VALA_DATA_TYPE_GET_CLASS (self)->copy (self);
}


/**
 * Checks two type references for equality. May only be used with
 * resolved type references.
 *
 * @param type2 a type reference
 * @return      true if this type reference is equal to type2, false
 *              otherwise
 */
static gboolean vala_data_type_real_equals (ValaDataType* self, ValaDataType* type2) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type2 != NULL, FALSE);
	if (type2->priv->_value_owned != self->priv->_value_owned) {
		result = FALSE;
		return result;
	}
	if (type2->priv->_nullable != self->priv->_nullable) {
		result = FALSE;
		return result;
	}
	if (type2->priv->_data_type != self->priv->_data_type) {
		result = FALSE;
		return result;
	}
	if (type2->priv->_type_parameter != NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->_type_parameter != NULL;
	}
	if (_tmp0_) {
		gboolean _tmp1_ = FALSE;
		if (type2->priv->_type_parameter == NULL) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = self->priv->_type_parameter == NULL;
		}
		if (_tmp1_) {
			result = FALSE;
			return result;
		}
		if (!vala_typeparameter_equals (type2->priv->_type_parameter, self->priv->_type_parameter)) {
			result = FALSE;
			return result;
		}
	}
	if (type2->priv->_floating_reference != self->priv->_floating_reference) {
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


gboolean vala_data_type_equals (ValaDataType* self, ValaDataType* type2) {
	return VALA_DATA_TYPE_GET_CLASS (self)->equals (self, type2);
}


/**
 * Checks whether this type reference is at least as strict as the
 * specified type reference type2.
 *
 * @param type2 a type reference
 * @return      true if this type reference is stricter or equal
 */
static gboolean vala_data_type_real_stricter (ValaDataType* self, ValaDataType* type2) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type2 != NULL, FALSE);
	if (type2->priv->_value_owned != self->priv->_value_owned) {
		result = FALSE;
		return result;
	}
	if (!type2->priv->_nullable) {
		_tmp0_ = self->priv->_nullable;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	if (self->priv->_type_parameter != NULL) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = type2->priv->_type_parameter != NULL;
	}
	if (_tmp1_) {
		result = TRUE;
		return result;
	}
	if (type2->priv->_data_type != self->priv->_data_type) {
		result = FALSE;
		return result;
	}
	if (type2->priv->_floating_reference != self->priv->_floating_reference) {
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


gboolean vala_data_type_stricter (ValaDataType* self, ValaDataType* type2) {
	return VALA_DATA_TYPE_GET_CLASS (self)->stricter (self, type2);
}


static void vala_data_type_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type) {
	ValaDataType * self;
	self = (ValaDataType*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	if (self->priv->type_argument_list != NULL) {
		{
			gint i;
			i = 0;
			{
				gboolean _tmp0_;
				_tmp0_ = TRUE;
				while (TRUE) {
					ValaDataType* _tmp1_;
					gboolean _tmp2_;
					if (!_tmp0_) {
						i++;
					}
					_tmp0_ = FALSE;
					if (!(i < vala_collection_get_size ((ValaCollection*) self->priv->type_argument_list))) {
						break;
					}
					if ((_tmp2_ = (_tmp1_ = (ValaDataType*) vala_list_get (self->priv->type_argument_list, i)) == old_type, _vala_code_node_unref0 (_tmp1_), _tmp2_)) {
						vala_list_set (self->priv->type_argument_list, i, new_type);
						return;
					}
				}
			}
		}
	}
}


static gboolean vala_data_type_real_compatible (ValaDataType* self, ValaDataType* target_type) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaCodeContext* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_ = FALSE;
	char* _tmp5_;
	gboolean _tmp6_;
	char* _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp25_ = FALSE;
	gboolean _tmp30_ = FALSE;
	gboolean _tmp31_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (target_type != NULL, FALSE);
	if ((_tmp3_ = vala_code_context_get_experimental_non_null (_tmp2_ = vala_code_context_get ()), _vala_code_context_unref0 (_tmp2_), _tmp3_)) {
		_tmp1_ = self->priv->_nullable;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = !target_type->priv->_nullable;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	if ((_tmp6_ = _vala_strcmp0 (_tmp5_ = vala_data_type_get_type_id (target_type), "G_TYPE_VALUE") == 0, _g_free0 (_tmp5_), _tmp6_)) {
		char* _tmp7_;
		_tmp4_ = (_tmp7_ = vala_data_type_get_type_id (self)) != NULL;
		_g_free0 (_tmp7_);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		result = TRUE;
		return result;
	}
	if ((_tmp9_ = _vala_strcmp0 (_tmp8_ = vala_data_type_get_type_id (target_type), "G_TYPE_VARIANT") == 0, _g_free0 (_tmp8_), _tmp9_)) {
		result = TRUE;
		return result;
	}
	if (VALA_IS_VALUE_TYPE (self)) {
		_tmp11_ = target_type->priv->_data_type != NULL;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		char* _tmp12_;
		_tmp10_ = _vala_strcmp0 (_tmp12_ = vala_symbol_get_full_name ((ValaSymbol*) target_type->priv->_data_type), "Dova.Value") == 0;
		_g_free0 (_tmp12_);
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		result = TRUE;
		return result;
	}
	if (VALA_IS_DELEGATE_TYPE (target_type)) {
		_tmp13_ = VALA_IS_DELEGATE_TYPE (self);
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		result = vala_delegate_type_get_delegate_symbol (VALA_DELEGATE_TYPE (target_type)) == vala_delegate_type_get_delegate_symbol (VALA_DELEGATE_TYPE (self));
		return result;
	}
	if (VALA_IS_POINTER_TYPE (target_type)) {
		gboolean _tmp14_ = FALSE;
		if (self->priv->_type_parameter != NULL) {
			_tmp14_ = TRUE;
		} else {
			gboolean _tmp15_ = FALSE;
			if (self->priv->_data_type != NULL) {
				gboolean _tmp16_ = FALSE;
				if (vala_typesymbol_is_reference_type (self->priv->_data_type)) {
					_tmp16_ = TRUE;
				} else {
					_tmp16_ = VALA_IS_DELEGATE_TYPE (self);
				}
				_tmp15_ = _tmp16_;
			} else {
				_tmp15_ = FALSE;
			}
			_tmp14_ = _tmp15_;
		}
		if (_tmp14_) {
			result = TRUE;
			return result;
		}
		result = FALSE;
		return result;
	}
	if (target_type->priv->_type_parameter != NULL) {
		result = TRUE;
		return result;
	}
	if (VALA_IS_ARRAY_TYPE (self) != VALA_IS_ARRAY_TYPE (target_type)) {
		result = FALSE;
		return result;
	}
	if (VALA_IS_ENUM (self->priv->_data_type)) {
		_tmp18_ = VALA_IS_STRUCT (target_type->priv->_data_type);
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		_tmp17_ = vala_struct_is_integer_type (VALA_STRUCT (target_type->priv->_data_type));
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		result = TRUE;
		return result;
	}
	if (self->priv->_data_type == target_type->priv->_data_type) {
		gboolean _tmp19_ = FALSE;
		gboolean _tmp20_ = FALSE;
		if (self->priv->type_argument_list != NULL) {
			_tmp20_ = vala_collection_get_size ((ValaCollection*) self->priv->type_argument_list) > 0;
		} else {
			_tmp20_ = FALSE;
		}
		if (_tmp20_) {
			ValaList* _tmp21_;
			_tmp19_ = vala_collection_get_size ((ValaCollection*) self->priv->type_argument_list) == vala_collection_get_size ((ValaCollection*) (_tmp21_ = vala_data_type_get_type_arguments (target_type)));
			_vala_iterable_unref0 (_tmp21_);
		} else {
			_tmp19_ = FALSE;
		}
		if (_tmp19_) {
			{
				gint i;
				i = 0;
				{
					gboolean _tmp22_;
					_tmp22_ = TRUE;
					while (TRUE) {
						ValaDataType* type_arg;
						ValaList* _tmp23_;
						ValaDataType* _tmp24_;
						ValaDataType* target_type_arg;
						if (!_tmp22_) {
							i++;
						}
						_tmp22_ = FALSE;
						if (!(i < vala_collection_get_size ((ValaCollection*) self->priv->type_argument_list))) {
							break;
						}
						type_arg = (ValaDataType*) vala_list_get (self->priv->type_argument_list, i);
						target_type_arg = (_tmp24_ = (ValaDataType*) vala_list_get (_tmp23_ = vala_data_type_get_type_arguments (target_type), i), _vala_iterable_unref0 (_tmp23_), _tmp24_);
						if (!vala_data_type_compatible (type_arg, target_type_arg)) {
							result = FALSE;
							_vala_code_node_unref0 (target_type_arg);
							_vala_code_node_unref0 (type_arg);
							return result;
						}
						_vala_code_node_unref0 (target_type_arg);
						_vala_code_node_unref0 (type_arg);
					}
				}
			}
		}
		result = TRUE;
		return result;
	}
	if (VALA_IS_STRUCT (self->priv->_data_type)) {
		_tmp25_ = VALA_IS_STRUCT (target_type->priv->_data_type);
	} else {
		_tmp25_ = FALSE;
	}
	if (_tmp25_) {
		ValaStruct* expr_struct;
		ValaStruct* expect_struct;
		gboolean _tmp26_ = FALSE;
		gboolean _tmp27_ = FALSE;
		gboolean _tmp28_ = FALSE;
		expr_struct = _vala_code_node_ref0 (VALA_STRUCT (self->priv->_data_type));
		expect_struct = _vala_code_node_ref0 (VALA_STRUCT (target_type->priv->_data_type));
		if (vala_struct_is_integer_type (expr_struct)) {
			_tmp26_ = vala_struct_is_floating_type (expect_struct);
		} else {
			_tmp26_ = FALSE;
		}
		if (_tmp26_) {
			result = TRUE;
			_vala_code_node_unref0 (expect_struct);
			_vala_code_node_unref0 (expr_struct);
			return result;
		}
		if (vala_struct_is_integer_type (expr_struct)) {
			_tmp28_ = vala_struct_is_integer_type (expect_struct);
		} else {
			_tmp28_ = FALSE;
		}
		if (_tmp28_) {
			_tmp27_ = TRUE;
		} else {
			gboolean _tmp29_ = FALSE;
			if (vala_struct_is_floating_type (expr_struct)) {
				_tmp29_ = vala_struct_is_floating_type (expect_struct);
			} else {
				_tmp29_ = FALSE;
			}
			_tmp27_ = _tmp29_;
		}
		if (_tmp27_) {
			if (vala_struct_get_rank (expr_struct) <= vala_struct_get_rank (expect_struct)) {
				result = TRUE;
				_vala_code_node_unref0 (expect_struct);
				_vala_code_node_unref0 (expr_struct);
				return result;
			}
		}
		_vala_code_node_unref0 (expect_struct);
		_vala_code_node_unref0 (expr_struct);
	}
	if (self->priv->_data_type != NULL) {
		_tmp31_ = target_type->priv->_data_type != NULL;
	} else {
		_tmp31_ = FALSE;
	}
	if (_tmp31_) {
		_tmp30_ = vala_typesymbol_is_subtype_of (self->priv->_data_type, target_type->priv->_data_type);
	} else {
		_tmp30_ = FALSE;
	}
	if (_tmp30_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


gboolean vala_data_type_compatible (ValaDataType* self, ValaDataType* target_type) {
	return VALA_DATA_TYPE_GET_CLASS (self)->compatible (self, target_type);
}


/**
 * Returns whether instances of this type are invokable.
 *
 * @return true if invokable, false otherwise
 */
static gboolean vala_data_type_real_is_invokable (ValaDataType* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	result = FALSE;
	return result;
}


gboolean vala_data_type_is_invokable (ValaDataType* self) {
	return VALA_DATA_TYPE_GET_CLASS (self)->is_invokable (self);
}


/**
 * Returns the return type of this invokable.
 *
 * @return return type
 */
static ValaDataType* vala_data_type_real_get_return_type (ValaDataType* self) {
	ValaDataType* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = NULL;
	return result;
}


ValaDataType* vala_data_type_get_return_type (ValaDataType* self) {
	return VALA_DATA_TYPE_GET_CLASS (self)->get_return_type (self);
}


/**
 * Returns copy of the list of invocation parameters.
 *
 * @return parameter list
 */
static ValaList* vala_data_type_real_get_parameters (ValaDataType* self) {
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = NULL;
	return result;
}


ValaList* vala_data_type_get_parameters (ValaDataType* self) {
	return VALA_DATA_TYPE_GET_CLASS (self)->get_parameters (self);
}


static gboolean vala_data_type_real_is_reference_type_or_type_parameter (ValaDataType* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->_data_type != NULL) {
		_tmp1_ = vala_typesymbol_is_reference_type (self->priv->_data_type);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->_type_parameter != NULL;
	}
	result = _tmp0_;
	return result;
}


gboolean vala_data_type_is_reference_type_or_type_parameter (ValaDataType* self) {
	return VALA_DATA_TYPE_GET_CLASS (self)->is_reference_type_or_type_parameter (self);
}


static gboolean vala_data_type_real_is_array (ValaDataType* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	result = FALSE;
	return result;
}


gboolean vala_data_type_is_array (ValaDataType* self) {
	return VALA_DATA_TYPE_GET_CLASS (self)->is_array (self);
}


static gboolean vala_data_type_real_is_accessible (ValaDataType* self, ValaSymbol* sym) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sym != NULL, FALSE);
	if (self->priv->_data_type != NULL) {
		result = vala_symbol_is_accessible ((ValaSymbol*) self->priv->_data_type, sym);
		return result;
	}
	result = TRUE;
	return result;
}


gboolean vala_data_type_is_accessible (ValaDataType* self, ValaSymbol* sym) {
	return VALA_DATA_TYPE_GET_CLASS (self)->is_accessible (self, sym);
}


static ValaSymbol* vala_data_type_real_get_member (ValaDataType* self, const char* member_name) {
	ValaSymbol* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (member_name != NULL, NULL);
	if (self->priv->_data_type != NULL) {
		result = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) self->priv->_data_type, member_name);
		return result;
	}
	result = NULL;
	return result;
}


ValaSymbol* vala_data_type_get_member (ValaDataType* self, const char* member_name) {
	return VALA_DATA_TYPE_GET_CLASS (self)->get_member (self, member_name);
}


static ValaSymbol* vala_data_type_real_get_pointer_member (ValaDataType* self, const char* member_name) {
	ValaSymbol* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (member_name != NULL, NULL);
	result = NULL;
	return result;
}


ValaSymbol* vala_data_type_get_pointer_member (ValaDataType* self, const char* member_name) {
	return VALA_DATA_TYPE_GET_CLASS (self)->get_pointer_member (self, member_name);
}


/**
 * Checks whether this data type references a real struct. A real struct
 * is a struct which is not a simple (fundamental) type.
 */
static gboolean vala_data_type_real_is_real_struct_type (ValaDataType* self) {
	gboolean result = FALSE;
	ValaTypeSymbol* _tmp0_;
	ValaStruct* s;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	s = _vala_code_node_ref0 ((_tmp0_ = self->priv->_data_type, VALA_IS_STRUCT (_tmp0_) ? ((ValaStruct*) _tmp0_) : NULL));
	if (s != NULL) {
		_tmp1_ = !vala_struct_is_simple_type (s);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		result = TRUE;
		_vala_code_node_unref0 (s);
		return result;
	}
	result = FALSE;
	_vala_code_node_unref0 (s);
	return result;
}


gboolean vala_data_type_is_real_struct_type (ValaDataType* self) {
	return VALA_DATA_TYPE_GET_CLASS (self)->is_real_struct_type (self);
}


gboolean vala_data_type_is_real_non_null_struct_type (ValaDataType* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (vala_data_type_is_real_struct_type (self)) {
		_tmp0_ = !self->priv->_nullable;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static char* vala_data_type_real_get_type_id (ValaDataType* self) {
	char* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->_data_type != NULL) {
		result = vala_typesymbol_get_type_id (self->priv->_data_type);
		return result;
	} else {
		result = NULL;
		return result;
	}
}


char* vala_data_type_get_type_id (ValaDataType* self) {
	return VALA_DATA_TYPE_GET_CLASS (self)->get_type_id (self);
}


/**
 * Returns whether the value needs to be disposed, i.e. whether
 * allocated memory or other resources need to be released when
 * the value is no longer needed.
 */
static gboolean vala_data_type_real_is_disposable (ValaDataType* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (!self->priv->_value_owned) {
		result = FALSE;
		return result;
	}
	if (vala_data_type_is_reference_type_or_type_parameter (self)) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


gboolean vala_data_type_is_disposable (ValaDataType* self) {
	return VALA_DATA_TYPE_GET_CLASS (self)->is_disposable (self);
}


static ValaDataType* vala_data_type_real_get_actual_type (ValaDataType* self, ValaDataType* derived_instance_type, ValaMemberAccess* method_access, ValaCodeNode* node_reference) {
	ValaDataType* result = NULL;
	gboolean _tmp0_ = FALSE;
	ValaDataType* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (node_reference != NULL, NULL);
	if (derived_instance_type == NULL) {
		_tmp0_ = method_access == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = _vala_code_node_ref0 (self);
		return result;
	}
	_result_ = _vala_code_node_ref0 (self);
	if (VALA_IS_GENERIC_TYPE (_result_)) {
		ValaDataType* _tmp1_;
		_result_ = (_tmp1_ = vala_semantic_analyzer_get_actual_type (derived_instance_type, method_access, VALA_GENERIC_TYPE (_result_), node_reference), _vala_code_node_unref0 (_result_), _tmp1_);
	} else {
		if (_result_->priv->type_argument_list != NULL) {
			ValaDataType* _tmp2_;
			_result_ = (_tmp2_ = vala_data_type_copy (_result_), _vala_code_node_unref0 (_result_), _tmp2_);
			{
				gint i;
				i = 0;
				{
					gboolean _tmp3_;
					_tmp3_ = TRUE;
					while (TRUE) {
						ValaDataType* _tmp4_;
						ValaDataType* _tmp5_;
						if (!_tmp3_) {
							i++;
						}
						_tmp3_ = FALSE;
						if (!(i < vala_collection_get_size ((ValaCollection*) _result_->priv->type_argument_list))) {
							break;
						}
						vala_list_set (_result_->priv->type_argument_list, i, _tmp5_ = vala_data_type_get_actual_type (_tmp4_ = (ValaDataType*) vala_list_get (_result_->priv->type_argument_list, i), derived_instance_type, method_access, node_reference));
						_vala_code_node_unref0 (_tmp5_);
						_vala_code_node_unref0 (_tmp4_);
					}
				}
			}
		}
	}
	result = _result_;
	return result;
}


ValaDataType* vala_data_type_get_actual_type (ValaDataType* self, ValaDataType* derived_instance_type, ValaMemberAccess* method_access, ValaCodeNode* node_reference) {
	return VALA_DATA_TYPE_GET_CLASS (self)->get_actual_type (self, derived_instance_type, method_access, node_reference);
}


gboolean vala_data_type_is_weak (ValaDataType* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->_value_owned) {
		result = FALSE;
		return result;
	} else {
		gboolean _tmp0_ = FALSE;
		if (VALA_IS_VOID_TYPE (self)) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = VALA_IS_POINTER_TYPE (self);
		}
		if (_tmp0_) {
			result = FALSE;
			return result;
		} else {
			if (VALA_IS_VALUE_TYPE (self)) {
				if (self->priv->_nullable) {
					result = TRUE;
					return result;
				}
				result = FALSE;
				return result;
			}
		}
	}
	result = TRUE;
	return result;
}


ValaDataType* vala_data_type_construct (GType object_type) {
	ValaDataType* self;
	self = (ValaDataType*) vala_code_node_construct (object_type);
	return self;
}


gboolean vala_data_type_get_value_owned (ValaDataType* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_value_owned;
	return result;
}


void vala_data_type_set_value_owned (ValaDataType* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_value_owned = value;
}


gboolean vala_data_type_get_nullable (ValaDataType* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_nullable;
	return result;
}


void vala_data_type_set_nullable (ValaDataType* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_nullable = value;
}


ValaTypeSymbol* vala_data_type_get_data_type (ValaDataType* self) {
	ValaTypeSymbol* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_data_type;
	return result;
}


void vala_data_type_set_data_type (ValaDataType* self, ValaTypeSymbol* value) {
	g_return_if_fail (self != NULL);
	self->priv->_data_type = value;
}


ValaTypeParameter* vala_data_type_get_type_parameter (ValaDataType* self) {
	ValaTypeParameter* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_type_parameter;
	return result;
}


void vala_data_type_set_type_parameter (ValaDataType* self, ValaTypeParameter* value) {
	ValaTypeParameter* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_type_parameter = (_tmp0_ = _vala_code_node_ref0 (value), _vala_code_node_unref0 (self->priv->_type_parameter), _tmp0_);
}


gboolean vala_data_type_get_floating_reference (ValaDataType* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_floating_reference;
	return result;
}


void vala_data_type_set_floating_reference (ValaDataType* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_floating_reference = value;
}


gboolean vala_data_type_get_is_dynamic (ValaDataType* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_dynamic;
	return result;
}


void vala_data_type_set_is_dynamic (ValaDataType* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_is_dynamic = value;
}


static void vala_data_type_class_init (ValaDataTypeClass * klass) {
	vala_data_type_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_data_type_finalize;
	g_type_class_add_private (klass, sizeof (ValaDataTypePrivate));
	VALA_CODE_NODE_CLASS (klass)->accept = vala_data_type_real_accept;
	VALA_DATA_TYPE_CLASS (klass)->get_cname = vala_data_type_real_get_cname;
	VALA_DATA_TYPE_CLASS (klass)->get_cdeclarator_suffix = vala_data_type_real_get_cdeclarator_suffix;
	VALA_DATA_TYPE_CLASS (klass)->get_lower_case_cname = vala_data_type_real_get_lower_case_cname;
	VALA_CODE_NODE_CLASS (klass)->to_string = vala_data_type_real_to_string;
	VALA_DATA_TYPE_CLASS (klass)->to_qualified_string = vala_data_type_real_to_qualified_string;
	VALA_DATA_TYPE_CLASS (klass)->copy = vala_data_type_real_copy;
	VALA_DATA_TYPE_CLASS (klass)->equals = vala_data_type_real_equals;
	VALA_DATA_TYPE_CLASS (klass)->stricter = vala_data_type_real_stricter;
	VALA_CODE_NODE_CLASS (klass)->replace_type = vala_data_type_real_replace_type;
	VALA_DATA_TYPE_CLASS (klass)->compatible = vala_data_type_real_compatible;
	VALA_DATA_TYPE_CLASS (klass)->is_invokable = vala_data_type_real_is_invokable;
	VALA_DATA_TYPE_CLASS (klass)->get_return_type = vala_data_type_real_get_return_type;
	VALA_DATA_TYPE_CLASS (klass)->get_parameters = vala_data_type_real_get_parameters;
	VALA_DATA_TYPE_CLASS (klass)->is_reference_type_or_type_parameter = vala_data_type_real_is_reference_type_or_type_parameter;
	VALA_DATA_TYPE_CLASS (klass)->is_array = vala_data_type_real_is_array;
	VALA_DATA_TYPE_CLASS (klass)->is_accessible = vala_data_type_real_is_accessible;
	VALA_DATA_TYPE_CLASS (klass)->get_member = vala_data_type_real_get_member;
	VALA_DATA_TYPE_CLASS (klass)->get_pointer_member = vala_data_type_real_get_pointer_member;
	VALA_DATA_TYPE_CLASS (klass)->is_real_struct_type = vala_data_type_real_is_real_struct_type;
	VALA_DATA_TYPE_CLASS (klass)->get_type_id = vala_data_type_real_get_type_id;
	VALA_DATA_TYPE_CLASS (klass)->is_disposable = vala_data_type_real_is_disposable;
	VALA_DATA_TYPE_CLASS (klass)->get_actual_type = vala_data_type_real_get_actual_type;
}


static void vala_data_type_instance_init (ValaDataType * self) {
	self->priv = VALA_DATA_TYPE_GET_PRIVATE (self);
}


static void vala_data_type_finalize (ValaCodeNode* obj) {
	ValaDataType * self;
	self = VALA_DATA_TYPE (obj);
	_vala_code_node_unref0 (self->priv->_type_parameter);
	_vala_iterable_unref0 (self->priv->type_argument_list);
	VALA_CODE_NODE_CLASS (vala_data_type_parent_class)->finalize (obj);
}


/**
 * A reference to a data type. This is used to specify static types of
 * expressions.
 */
GType vala_data_type_get_type (void) {
	static volatile gsize vala_data_type_type_id__volatile = 0;
	if (g_once_init_enter (&vala_data_type_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaDataTypeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_data_type_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaDataType), 0, (GInstanceInitFunc) vala_data_type_instance_init, NULL };
		GType vala_data_type_type_id;
		vala_data_type_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaDataType", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&vala_data_type_type_id__volatile, vala_data_type_type_id);
	}
	return vala_data_type_type_id__volatile;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}



