/* valaarraytype.c generated by valac, the Vala compiler
 * generated from valaarraytype.vala, do not modify */

/* valaarraytype.vala
 *
 * Copyright (C) 2007-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>


#define VALA_TYPE_CODE_NODE (vala_code_node_get_type ())
#define VALA_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_NODE, ValaCodeNode))
#define VALA_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))
#define VALA_IS_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_NODE))
#define VALA_IS_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_NODE))
#define VALA_CODE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))

typedef struct _ValaCodeNode ValaCodeNode;
typedef struct _ValaCodeNodeClass ValaCodeNodeClass;
typedef struct _ValaCodeNodePrivate ValaCodeNodePrivate;

#define VALA_TYPE_CODE_VISITOR (vala_code_visitor_get_type ())
#define VALA_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitor))
#define VALA_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))
#define VALA_IS_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_VISITOR))
#define VALA_IS_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_VISITOR))
#define VALA_CODE_VISITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))

typedef struct _ValaCodeVisitor ValaCodeVisitor;
typedef struct _ValaCodeVisitorClass ValaCodeVisitorClass;

#define VALA_TYPE_SEMANTIC_ANALYZER (vala_semantic_analyzer_get_type ())
#define VALA_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzer))
#define VALA_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))
#define VALA_IS_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_IS_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_SEMANTIC_ANALYZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))

typedef struct _ValaSemanticAnalyzer ValaSemanticAnalyzer;
typedef struct _ValaSemanticAnalyzerClass ValaSemanticAnalyzerClass;

#define VALA_TYPE_CODE_GENERATOR (vala_code_generator_get_type ())
#define VALA_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGenerator))
#define VALA_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))
#define VALA_IS_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_GENERATOR))
#define VALA_IS_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_GENERATOR))
#define VALA_CODE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))

typedef struct _ValaCodeGenerator ValaCodeGenerator;
typedef struct _ValaCodeGeneratorClass ValaCodeGeneratorClass;

#define VALA_TYPE_DATA_TYPE (vala_data_type_get_type ())
#define VALA_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DATA_TYPE, ValaDataType))
#define VALA_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))
#define VALA_IS_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DATA_TYPE))
#define VALA_IS_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DATA_TYPE))
#define VALA_DATA_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))

typedef struct _ValaDataType ValaDataType;
typedef struct _ValaDataTypeClass ValaDataTypeClass;

#define VALA_TYPE_EXPRESSION (vala_expression_get_type ())
#define VALA_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_EXPRESSION, ValaExpression))
#define VALA_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_EXPRESSION, ValaExpressionClass))
#define VALA_IS_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_EXPRESSION))
#define VALA_IS_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_EXPRESSION))
#define VALA_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_EXPRESSION, ValaExpressionClass))

typedef struct _ValaExpression ValaExpression;
typedef struct _ValaExpressionClass ValaExpressionClass;

#define VALA_TYPE_SYMBOL (vala_symbol_get_type ())
#define VALA_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SYMBOL, ValaSymbol))
#define VALA_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SYMBOL, ValaSymbolClass))
#define VALA_IS_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SYMBOL))
#define VALA_IS_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SYMBOL))
#define VALA_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SYMBOL, ValaSymbolClass))

typedef struct _ValaSymbol ValaSymbol;
typedef struct _ValaSymbolClass ValaSymbolClass;

#define VALA_TYPE_VARIABLE (vala_variable_get_type ())
#define VALA_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VARIABLE, ValaVariable))
#define VALA_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VARIABLE, ValaVariableClass))
#define VALA_IS_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VARIABLE))
#define VALA_IS_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VARIABLE))
#define VALA_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VARIABLE, ValaVariableClass))

typedef struct _ValaVariable ValaVariable;
typedef struct _ValaVariableClass ValaVariableClass;

#define VALA_TYPE_LOCAL_VARIABLE (vala_local_variable_get_type ())
#define VALA_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable))
#define VALA_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))
#define VALA_IS_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_IS_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_LOCAL_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))

typedef struct _ValaLocalVariable ValaLocalVariable;
typedef struct _ValaLocalVariableClass ValaLocalVariableClass;

#define VALA_TYPE_ATTRIBUTE (vala_attribute_get_type ())
#define VALA_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ATTRIBUTE, ValaAttribute))
#define VALA_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))
#define VALA_IS_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ATTRIBUTE))
#define VALA_IS_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ATTRIBUTE))
#define VALA_ATTRIBUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))

typedef struct _ValaAttribute ValaAttribute;
typedef struct _ValaAttributeClass ValaAttributeClass;
typedef struct _ValaDataTypePrivate ValaDataTypePrivate;

#define VALA_TYPE_SCOPE (vala_scope_get_type ())
#define VALA_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SCOPE, ValaScope))
#define VALA_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SCOPE, ValaScopeClass))
#define VALA_IS_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SCOPE))
#define VALA_IS_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SCOPE))
#define VALA_SCOPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SCOPE, ValaScopeClass))

typedef struct _ValaScope ValaScope;
typedef struct _ValaScopeClass ValaScopeClass;

#define VALA_TYPE_FORMAL_PARAMETER (vala_formal_parameter_get_type ())
#define VALA_FORMAL_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FORMAL_PARAMETER, ValaFormalParameter))
#define VALA_FORMAL_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FORMAL_PARAMETER, ValaFormalParameterClass))
#define VALA_IS_FORMAL_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FORMAL_PARAMETER))
#define VALA_IS_FORMAL_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FORMAL_PARAMETER))
#define VALA_FORMAL_PARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FORMAL_PARAMETER, ValaFormalParameterClass))

typedef struct _ValaFormalParameter ValaFormalParameter;
typedef struct _ValaFormalParameterClass ValaFormalParameterClass;

#define VALA_TYPE_MEMBER_ACCESS (vala_member_access_get_type ())
#define VALA_MEMBER_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess))
#define VALA_MEMBER_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_MEMBER_ACCESS, ValaMemberAccessClass))
#define VALA_IS_MEMBER_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_MEMBER_ACCESS))
#define VALA_IS_MEMBER_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_MEMBER_ACCESS))
#define VALA_MEMBER_ACCESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_MEMBER_ACCESS, ValaMemberAccessClass))

typedef struct _ValaMemberAccess ValaMemberAccess;
typedef struct _ValaMemberAccessClass ValaMemberAccessClass;

#define VALA_TYPE_REFERENCE_TYPE (vala_reference_type_get_type ())
#define VALA_REFERENCE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_REFERENCE_TYPE, ValaReferenceType))
#define VALA_REFERENCE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_REFERENCE_TYPE, ValaReferenceTypeClass))
#define VALA_IS_REFERENCE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_REFERENCE_TYPE))
#define VALA_IS_REFERENCE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_REFERENCE_TYPE))
#define VALA_REFERENCE_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_REFERENCE_TYPE, ValaReferenceTypeClass))

typedef struct _ValaReferenceType ValaReferenceType;
typedef struct _ValaReferenceTypeClass ValaReferenceTypeClass;
typedef struct _ValaReferenceTypePrivate ValaReferenceTypePrivate;

#define VALA_TYPE_ARRAY_TYPE (vala_array_type_get_type ())
#define VALA_ARRAY_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ARRAY_TYPE, ValaArrayType))
#define VALA_ARRAY_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ARRAY_TYPE, ValaArrayTypeClass))
#define VALA_IS_ARRAY_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ARRAY_TYPE))
#define VALA_IS_ARRAY_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ARRAY_TYPE))
#define VALA_ARRAY_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ARRAY_TYPE, ValaArrayTypeClass))

typedef struct _ValaArrayType ValaArrayType;
typedef struct _ValaArrayTypeClass ValaArrayTypeClass;
typedef struct _ValaArrayTypePrivate ValaArrayTypePrivate;

#define VALA_TYPE_FIELD (vala_field_get_type ())
#define VALA_FIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FIELD, ValaField))
#define VALA_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FIELD, ValaFieldClass))
#define VALA_IS_FIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FIELD))
#define VALA_IS_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FIELD))
#define VALA_FIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FIELD, ValaFieldClass))

typedef struct _ValaField ValaField;
typedef struct _ValaFieldClass ValaFieldClass;

#define VALA_TYPE_ARRAY_LENGTH_FIELD (vala_array_length_field_get_type ())
#define VALA_ARRAY_LENGTH_FIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ARRAY_LENGTH_FIELD, ValaArrayLengthField))
#define VALA_ARRAY_LENGTH_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ARRAY_LENGTH_FIELD, ValaArrayLengthFieldClass))
#define VALA_IS_ARRAY_LENGTH_FIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ARRAY_LENGTH_FIELD))
#define VALA_IS_ARRAY_LENGTH_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ARRAY_LENGTH_FIELD))
#define VALA_ARRAY_LENGTH_FIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ARRAY_LENGTH_FIELD, ValaArrayLengthFieldClass))

typedef struct _ValaArrayLengthField ValaArrayLengthField;
typedef struct _ValaArrayLengthFieldClass ValaArrayLengthFieldClass;

#define VALA_TYPE_METHOD (vala_method_get_type ())
#define VALA_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_METHOD, ValaMethod))
#define VALA_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_METHOD, ValaMethodClass))
#define VALA_IS_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_METHOD))
#define VALA_IS_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_METHOD))
#define VALA_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_METHOD, ValaMethodClass))

typedef struct _ValaMethod ValaMethod;
typedef struct _ValaMethodClass ValaMethodClass;

#define VALA_TYPE_ARRAY_RESIZE_METHOD (vala_array_resize_method_get_type ())
#define VALA_ARRAY_RESIZE_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ARRAY_RESIZE_METHOD, ValaArrayResizeMethod))
#define VALA_ARRAY_RESIZE_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ARRAY_RESIZE_METHOD, ValaArrayResizeMethodClass))
#define VALA_IS_ARRAY_RESIZE_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ARRAY_RESIZE_METHOD))
#define VALA_IS_ARRAY_RESIZE_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ARRAY_RESIZE_METHOD))
#define VALA_ARRAY_RESIZE_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ARRAY_RESIZE_METHOD, ValaArrayResizeMethodClass))

typedef struct _ValaArrayResizeMethod ValaArrayResizeMethod;
typedef struct _ValaArrayResizeMethodClass ValaArrayResizeMethodClass;

#define VALA_TYPE_ARRAY_MOVE_METHOD (vala_array_move_method_get_type ())
#define VALA_ARRAY_MOVE_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ARRAY_MOVE_METHOD, ValaArrayMoveMethod))
#define VALA_ARRAY_MOVE_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ARRAY_MOVE_METHOD, ValaArrayMoveMethodClass))
#define VALA_IS_ARRAY_MOVE_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ARRAY_MOVE_METHOD))
#define VALA_IS_ARRAY_MOVE_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ARRAY_MOVE_METHOD))
#define VALA_ARRAY_MOVE_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ARRAY_MOVE_METHOD, ValaArrayMoveMethodClass))

typedef struct _ValaArrayMoveMethod ValaArrayMoveMethod;
typedef struct _ValaArrayMoveMethodClass ValaArrayMoveMethodClass;
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))

#define VALA_TYPE_SOURCE_REFERENCE (vala_source_reference_get_type ())
#define VALA_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReference))
#define VALA_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))
#define VALA_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))

typedef struct _ValaSourceReference ValaSourceReference;
typedef struct _ValaSourceReferenceClass ValaSourceReferenceClass;

#define VALA_TYPE_CODE_CONTEXT (vala_code_context_get_type ())
#define VALA_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContext))
#define VALA_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))
#define VALA_IS_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_CONTEXT))
#define VALA_IS_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_CONTEXT))
#define VALA_CODE_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))

typedef struct _ValaCodeContext ValaCodeContext;
typedef struct _ValaCodeContextClass ValaCodeContextClass;

#define VALA_TYPE_PROFILE (vala_profile_get_type ())
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))

#define VALA_TYPE_NAMESPACE (vala_namespace_get_type ())
#define VALA_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_NAMESPACE, ValaNamespace))
#define VALA_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_NAMESPACE, ValaNamespaceClass))
#define VALA_IS_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_NAMESPACE))
#define VALA_IS_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_NAMESPACE))
#define VALA_NAMESPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_NAMESPACE, ValaNamespaceClass))

typedef struct _ValaNamespace ValaNamespace;
typedef struct _ValaNamespaceClass ValaNamespaceClass;

#define VALA_TYPE_SYMBOL_ACCESSIBILITY (vala_symbol_accessibility_get_type ())

#define VALA_TYPE_SOURCE_FILE (vala_source_file_get_type ())
#define VALA_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFile))
#define VALA_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))
#define VALA_IS_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_FILE))
#define VALA_IS_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_FILE))
#define VALA_SOURCE_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))

typedef struct _ValaSourceFile ValaSourceFile;
typedef struct _ValaSourceFileClass ValaSourceFileClass;

#define VALA_TYPE_TYPESYMBOL (vala_typesymbol_get_type ())
#define VALA_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbol))
#define VALA_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))
#define VALA_IS_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPESYMBOL))
#define VALA_IS_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPESYMBOL))
#define VALA_TYPESYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))

typedef struct _ValaTypeSymbol ValaTypeSymbol;
typedef struct _ValaTypeSymbolClass ValaTypeSymbolClass;

#define VALA_TYPE_STRUCT (vala_struct_get_type ())
#define VALA_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_STRUCT, ValaStruct))
#define VALA_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_STRUCT, ValaStructClass))
#define VALA_IS_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_STRUCT))
#define VALA_IS_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_STRUCT))
#define VALA_STRUCT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_STRUCT, ValaStructClass))

typedef struct _ValaStruct ValaStruct;
typedef struct _ValaStructClass ValaStructClass;

#define VALA_TYPE_VALUE_TYPE (vala_value_type_get_type ())
#define VALA_VALUE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VALUE_TYPE, ValaValueType))
#define VALA_VALUE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VALUE_TYPE, ValaValueTypeClass))
#define VALA_IS_VALUE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VALUE_TYPE))
#define VALA_IS_VALUE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VALUE_TYPE))
#define VALA_VALUE_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VALUE_TYPE, ValaValueTypeClass))

typedef struct _ValaValueType ValaValueType;
typedef struct _ValaValueTypeClass ValaValueTypeClass;

#define VALA_TYPE_INTEGER_TYPE (vala_integer_type_get_type ())
#define VALA_INTEGER_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INTEGER_TYPE, ValaIntegerType))
#define VALA_INTEGER_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INTEGER_TYPE, ValaIntegerTypeClass))
#define VALA_IS_INTEGER_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INTEGER_TYPE))
#define VALA_IS_INTEGER_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INTEGER_TYPE))
#define VALA_INTEGER_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INTEGER_TYPE, ValaIntegerTypeClass))

typedef struct _ValaIntegerType ValaIntegerType;
typedef struct _ValaIntegerTypeClass ValaIntegerTypeClass;

#define VALA_TYPE_VOID_TYPE (vala_void_type_get_type ())
#define VALA_VOID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VOID_TYPE, ValaVoidType))
#define VALA_VOID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VOID_TYPE, ValaVoidTypeClass))
#define VALA_IS_VOID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VOID_TYPE))
#define VALA_IS_VOID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VOID_TYPE))
#define VALA_VOID_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VOID_TYPE, ValaVoidTypeClass))

typedef struct _ValaVoidType ValaVoidType;
typedef struct _ValaVoidTypeClass ValaVoidTypeClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define VALA_TYPE_POINTER_TYPE (vala_pointer_type_get_type ())
#define VALA_POINTER_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_POINTER_TYPE, ValaPointerType))
#define VALA_POINTER_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_POINTER_TYPE, ValaPointerTypeClass))
#define VALA_IS_POINTER_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_POINTER_TYPE))
#define VALA_IS_POINTER_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_POINTER_TYPE))
#define VALA_POINTER_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_POINTER_TYPE, ValaPointerTypeClass))

typedef struct _ValaPointerType ValaPointerType;
typedef struct _ValaPointerTypeClass ValaPointerTypeClass;

#define VALA_TYPE_TYPEPARAMETER (vala_typeparameter_get_type ())
#define VALA_TYPEPARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPEPARAMETER, ValaTypeParameter))
#define VALA_TYPEPARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPEPARAMETER, ValaTypeParameterClass))
#define VALA_IS_TYPEPARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPEPARAMETER))
#define VALA_IS_TYPEPARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPEPARAMETER))
#define VALA_TYPEPARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPEPARAMETER, ValaTypeParameterClass))

typedef struct _ValaTypeParameter ValaTypeParameter;
typedef struct _ValaTypeParameterClass ValaTypeParameterClass;

#define VALA_TYPE_GENERIC_TYPE (vala_generic_type_get_type ())
#define VALA_GENERIC_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GENERIC_TYPE, ValaGenericType))
#define VALA_GENERIC_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GENERIC_TYPE, ValaGenericTypeClass))
#define VALA_IS_GENERIC_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GENERIC_TYPE))
#define VALA_IS_GENERIC_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GENERIC_TYPE))
#define VALA_GENERIC_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GENERIC_TYPE, ValaGenericTypeClass))

typedef struct _ValaGenericType ValaGenericType;
typedef struct _ValaGenericTypeClass ValaGenericTypeClass;

struct _ValaCodeNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCodeNodePrivate * priv;
	GList* attributes;
};

struct _ValaCodeNodeClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCodeNode *self);
	void (*accept) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	void (*accept_children) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	gboolean (*check) (ValaCodeNode* self, ValaSemanticAnalyzer* analyzer);
	void (*emit) (ValaCodeNode* self, ValaCodeGenerator* codegen);
	void (*replace_type) (ValaCodeNode* self, ValaDataType* old_type, ValaDataType* new_type);
	void (*replace_expression) (ValaCodeNode* self, ValaExpression* old_node, ValaExpression* new_node);
	gchar* (*to_string) (ValaCodeNode* self);
	void (*get_defined_variables) (ValaCodeNode* self, ValaCollection* collection);
	void (*get_used_variables) (ValaCodeNode* self, ValaCollection* collection);
};

struct _ValaDataType {
	ValaCodeNode parent_instance;
	ValaDataTypePrivate * priv;
};

struct _ValaDataTypeClass {
	ValaCodeNodeClass parent_class;
	gchar* (*get_cname) (ValaDataType* self);
	gchar* (*get_cdeclarator_suffix) (ValaDataType* self);
	gchar* (*get_lower_case_cname) (ValaDataType* self, const gchar* infix);
	gchar* (*to_qualified_string) (ValaDataType* self, ValaScope* scope);
	ValaDataType* (*copy) (ValaDataType* self);
	gboolean (*equals) (ValaDataType* self, ValaDataType* type2);
	gboolean (*stricter) (ValaDataType* self, ValaDataType* type2);
	gboolean (*compatible) (ValaDataType* self, ValaDataType* target_type);
	gboolean (*is_invokable) (ValaDataType* self);
	ValaDataType* (*get_return_type) (ValaDataType* self);
	ValaList* (*get_parameters) (ValaDataType* self);
	gboolean (*is_reference_type_or_type_parameter) (ValaDataType* self);
	gboolean (*is_array) (ValaDataType* self);
	gboolean (*is_accessible) (ValaDataType* self, ValaSymbol* sym);
	ValaSymbol* (*get_member) (ValaDataType* self, const gchar* member_name);
	ValaSymbol* (*get_pointer_member) (ValaDataType* self, const gchar* member_name);
	gboolean (*is_real_struct_type) (ValaDataType* self);
	gchar* (*get_type_id) (ValaDataType* self);
	gboolean (*is_disposable) (ValaDataType* self);
	ValaDataType* (*get_actual_type) (ValaDataType* self, ValaDataType* derived_instance_type, ValaMemberAccess* method_access, ValaCodeNode* node_reference);
};

struct _ValaReferenceType {
	ValaDataType parent_instance;
	ValaReferenceTypePrivate * priv;
};

struct _ValaReferenceTypeClass {
	ValaDataTypeClass parent_class;
};

struct _ValaArrayType {
	ValaReferenceType parent_instance;
	ValaArrayTypePrivate * priv;
};

struct _ValaArrayTypeClass {
	ValaReferenceTypeClass parent_class;
};

struct _ValaArrayTypePrivate {
	gboolean _invalid_syntax;
	gboolean _inline_allocated;
	gboolean _fixed_length;
	gint _length;
	gint _rank;
	ValaDataType* _element_type;
	ValaArrayLengthField* length_field;
	ValaArrayResizeMethod* resize_method;
	ValaArrayMoveMethod* move_method;
};

typedef enum  {
	VALA_PROFILE_POSIX,
	VALA_PROFILE_GOBJECT,
	VALA_PROFILE_DOVA
} ValaProfile;

typedef enum  {
	VALA_SYMBOL_ACCESSIBILITY_PRIVATE,
	VALA_SYMBOL_ACCESSIBILITY_INTERNAL,
	VALA_SYMBOL_ACCESSIBILITY_PROTECTED,
	VALA_SYMBOL_ACCESSIBILITY_PUBLIC
} ValaSymbolAccessibility;


static gpointer vala_array_type_parent_class = NULL;

gpointer vala_code_node_ref (gpointer instance);
void vala_code_node_unref (gpointer instance);
GParamSpec* vala_param_spec_code_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_node (GValue* value, gpointer v_object);
void vala_value_take_code_node (GValue* value, gpointer v_object);
gpointer vala_value_get_code_node (const GValue* value);
GType vala_code_node_get_type (void) G_GNUC_CONST;
gpointer vala_code_visitor_ref (gpointer instance);
void vala_code_visitor_unref (gpointer instance);
GParamSpec* vala_param_spec_code_visitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_visitor (GValue* value, gpointer v_object);
void vala_value_take_code_visitor (GValue* value, gpointer v_object);
gpointer vala_value_get_code_visitor (const GValue* value);
GType vala_code_visitor_get_type (void) G_GNUC_CONST;
GType vala_semantic_analyzer_get_type (void) G_GNUC_CONST;
GType vala_code_generator_get_type (void) G_GNUC_CONST;
GType vala_data_type_get_type (void) G_GNUC_CONST;
GType vala_expression_get_type (void) G_GNUC_CONST;
GType vala_symbol_get_type (void) G_GNUC_CONST;
GType vala_variable_get_type (void) G_GNUC_CONST;
GType vala_local_variable_get_type (void) G_GNUC_CONST;
GType vala_attribute_get_type (void) G_GNUC_CONST;
gpointer vala_scope_ref (gpointer instance);
void vala_scope_unref (gpointer instance);
GParamSpec* vala_param_spec_scope (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_scope (GValue* value, gpointer v_object);
void vala_value_take_scope (GValue* value, gpointer v_object);
gpointer vala_value_get_scope (const GValue* value);
GType vala_scope_get_type (void) G_GNUC_CONST;
GType vala_formal_parameter_get_type (void) G_GNUC_CONST;
GType vala_member_access_get_type (void) G_GNUC_CONST;
GType vala_reference_type_get_type (void) G_GNUC_CONST;
GType vala_array_type_get_type (void) G_GNUC_CONST;
GType vala_field_get_type (void) G_GNUC_CONST;
GType vala_array_length_field_get_type (void) G_GNUC_CONST;
GType vala_method_get_type (void) G_GNUC_CONST;
GType vala_array_resize_method_get_type (void) G_GNUC_CONST;
GType vala_array_move_method_get_type (void) G_GNUC_CONST;
#define VALA_ARRAY_TYPE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_ARRAY_TYPE, ValaArrayTypePrivate))
enum  {
	VALA_ARRAY_TYPE_DUMMY_PROPERTY
};
gpointer vala_source_reference_ref (gpointer instance);
void vala_source_reference_unref (gpointer instance);
GParamSpec* vala_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_reference (GValue* value, gpointer v_object);
void vala_value_take_source_reference (GValue* value, gpointer v_object);
gpointer vala_value_get_source_reference (const GValue* value);
GType vala_source_reference_get_type (void) G_GNUC_CONST;
ValaArrayType* vala_array_type_new (ValaDataType* element_type, gint rank, ValaSourceReference* source_reference);
ValaArrayType* vala_array_type_construct (GType object_type, ValaDataType* element_type, gint rank, ValaSourceReference* source_reference);
ValaReferenceType* vala_reference_type_construct (GType object_type);
void vala_array_type_set_element_type (ValaArrayType* self, ValaDataType* value);
void vala_array_type_set_rank (ValaArrayType* self, gint value);
void vala_code_node_set_source_reference (ValaCodeNode* self, ValaSourceReference* value);
static ValaSymbol* vala_array_type_real_get_member (ValaDataType* base, const gchar* member_name);
gpointer vala_code_context_ref (gpointer instance);
void vala_code_context_unref (gpointer instance);
GParamSpec* vala_param_spec_code_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_context (GValue* value, gpointer v_object);
void vala_value_take_code_context (GValue* value, gpointer v_object);
gpointer vala_value_get_code_context (const GValue* value);
GType vala_code_context_get_type (void) G_GNUC_CONST;
ValaCodeContext* vala_code_context_get (void);
GType vala_profile_get_type (void) G_GNUC_CONST;
ValaProfile vala_code_context_get_profile (ValaCodeContext* self);
ValaSymbol* vala_semantic_analyzer_symbol_lookup_inherited (ValaSymbol* sym, const gchar* name);
GType vala_namespace_get_type (void) G_GNUC_CONST;
ValaNamespace* vala_code_context_get_root (ValaCodeContext* self);
ValaScope* vala_symbol_get_scope (ValaSymbol* self);
ValaSymbol* vala_scope_lookup (ValaScope* self, const gchar* name);
static ValaArrayLengthField* vala_array_type_get_length_field (ValaArrayType* self);
static ValaArrayMoveMethod* vala_array_type_get_move_method (ValaArrayType* self);
static ValaArrayResizeMethod* vala_array_type_get_resize_method (ValaArrayType* self);
ValaSourceReference* vala_code_node_get_source_reference (ValaCodeNode* self);
ValaArrayLengthField* vala_array_length_field_new (ValaSourceReference* source_reference);
ValaArrayLengthField* vala_array_length_field_construct (GType object_type, ValaSourceReference* source_reference);
GType vala_symbol_accessibility_get_type (void) G_GNUC_CONST;
void vala_symbol_set_access (ValaSymbol* self, ValaSymbolAccessibility value);
gpointer vala_source_file_ref (gpointer instance);
void vala_source_file_unref (gpointer instance);
GParamSpec* vala_param_spec_source_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_file (GValue* value, gpointer v_object);
void vala_value_take_source_file (GValue* value, gpointer v_object);
gpointer vala_value_get_source_file (const GValue* value);
GType vala_source_file_get_type (void) G_GNUC_CONST;
ValaSourceFile* vala_source_reference_get_file (ValaSourceReference* self);
ValaCodeContext* vala_source_file_get_context (ValaSourceFile* self);
gint vala_array_type_get_rank (ValaArrayType* self);
GType vala_typesymbol_get_type (void) G_GNUC_CONST;
GType vala_struct_get_type (void) G_GNUC_CONST;
ValaIntegerType* vala_integer_type_new (ValaStruct* type_symbol, const gchar* literal_value, const gchar* literal_type_name);
ValaIntegerType* vala_integer_type_construct (GType object_type, ValaStruct* type_symbol, const gchar* literal_value, const gchar* literal_type_name);
GType vala_value_type_get_type (void) G_GNUC_CONST;
GType vala_integer_type_get_type (void) G_GNUC_CONST;
void vala_variable_set_variable_type (ValaVariable* self, ValaDataType* value);
ValaArrayResizeMethod* vala_array_resize_method_new (ValaSourceReference* source_reference);
ValaArrayResizeMethod* vala_array_resize_method_construct (GType object_type, ValaSourceReference* source_reference);
ValaVoidType* vala_void_type_new (ValaSourceReference* source_reference);
ValaVoidType* vala_void_type_construct (GType object_type, ValaSourceReference* source_reference);
GType vala_void_type_get_type (void) G_GNUC_CONST;
void vala_method_set_return_type (ValaMethod* self, ValaDataType* value);
void vala_method_set_cname (ValaMethod* self, const gchar* cname);
void vala_method_add_parameter (ValaMethod* self, ValaFormalParameter* param);
ValaFormalParameter* vala_formal_parameter_new (const gchar* name, ValaDataType* variable_type, ValaSourceReference* source_reference);
ValaFormalParameter* vala_formal_parameter_construct (GType object_type, const gchar* name, ValaDataType* variable_type, ValaSourceReference* source_reference);
void vala_method_set_returns_modified_pointer (ValaMethod* self, gboolean value);
ValaArrayMoveMethod* vala_array_move_method_new (ValaSourceReference* source_reference);
ValaArrayMoveMethod* vala_array_move_method_construct (GType object_type, ValaSourceReference* source_reference);
static ValaDataType* vala_array_type_real_copy (ValaDataType* base);
ValaDataType* vala_array_type_get_element_type (ValaArrayType* self);
ValaDataType* vala_data_type_copy (ValaDataType* self);
gboolean vala_data_type_get_value_owned (ValaDataType* self);
void vala_data_type_set_value_owned (ValaDataType* self, gboolean value);
gboolean vala_data_type_get_nullable (ValaDataType* self);
void vala_data_type_set_nullable (ValaDataType* self, gboolean value);
gboolean vala_data_type_get_floating_reference (ValaDataType* self);
void vala_data_type_set_floating_reference (ValaDataType* self, gboolean value);
gboolean vala_array_type_get_inline_allocated (ValaArrayType* self);
void vala_array_type_set_inline_allocated (ValaArrayType* self, gboolean value);
gboolean vala_array_type_get_fixed_length (ValaArrayType* self);
void vala_array_type_set_fixed_length (ValaArrayType* self, gboolean value);
gint vala_array_type_get_length (ValaArrayType* self);
void vala_array_type_set_length (ValaArrayType* self, gint value);
static gchar* vala_array_type_real_get_cname (ValaDataType* base);
gchar* vala_data_type_get_cname (ValaDataType* self);
static gchar* vala_array_type_real_get_cdeclarator_suffix (ValaDataType* base);
static gboolean vala_array_type_real_is_array (ValaDataType* base);
static gchar* vala_array_type_real_to_qualified_string (ValaDataType* base, ValaScope* scope);
gchar* vala_data_type_to_qualified_string (ValaDataType* self, ValaScope* scope);
static gboolean vala_array_type_real_compatible (ValaDataType* base, ValaDataType* target_type);
gchar* vala_data_type_get_type_id (ValaDataType* self);
ValaTypeSymbol* vala_data_type_get_data_type (ValaDataType* self);
GType vala_pointer_type_get_type (void) G_GNUC_CONST;
ValaAttribute* vala_code_node_get_attribute (ValaCodeNode* self, const gchar* name);
GType vala_typeparameter_get_type (void) G_GNUC_CONST;
ValaTypeParameter* vala_data_type_get_type_parameter (ValaDataType* self);
gboolean vala_data_type_compatible (ValaDataType* self, ValaDataType* target_type);
static gboolean vala_array_type_real_is_reference_type_or_type_parameter (ValaDataType* base);
static void vala_array_type_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
void vala_code_node_accept (ValaCodeNode* self, ValaCodeVisitor* visitor);
static void vala_array_type_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type);
static gboolean vala_array_type_real_is_accessible (ValaDataType* base, ValaSymbol* sym);
gboolean vala_data_type_is_accessible (ValaDataType* self, ValaSymbol* sym);
static gboolean vala_array_type_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer);
gboolean vala_array_type_get_invalid_syntax (ValaArrayType* self);
void vala_report_error (ValaSourceReference* source, const gchar* message);
void vala_code_node_set_error (ValaCodeNode* self, gboolean value);
gboolean vala_code_node_check (ValaCodeNode* self, ValaSemanticAnalyzer* analyzer);
static gchar* vala_array_type_real_get_type_id (ValaDataType* base);
static ValaDataType* vala_array_type_real_get_actual_type (ValaDataType* base, ValaDataType* derived_instance_type, ValaMemberAccess* method_access, ValaCodeNode* node_reference);
GType vala_generic_type_get_type (void) G_GNUC_CONST;
gboolean vala_data_type_has_type_arguments (ValaDataType* self);
ValaDataType* vala_data_type_get_actual_type (ValaDataType* self, ValaDataType* derived_instance_type, ValaMemberAccess* method_access, ValaCodeNode* node_reference);
static gboolean vala_array_type_real_is_disposable (ValaDataType* base);
gboolean vala_data_type_is_disposable (ValaDataType* self);
void vala_code_node_set_parent_node (ValaCodeNode* self, ValaCodeNode* value);
void vala_array_type_set_invalid_syntax (ValaArrayType* self, gboolean value);
static void vala_array_type_finalize (ValaCodeNode* obj);


ValaArrayType* vala_array_type_construct (GType object_type, ValaDataType* element_type, gint rank, ValaSourceReference* source_reference) {
	ValaArrayType* self = NULL;
	g_return_val_if_fail (element_type != NULL, NULL);
	self = (ValaArrayType*) vala_reference_type_construct (object_type);
	vala_array_type_set_element_type (self, element_type);
	vala_array_type_set_rank (self, rank);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}


ValaArrayType* vala_array_type_new (ValaDataType* element_type, gint rank, ValaSourceReference* source_reference) {
	return vala_array_type_construct (VALA_TYPE_ARRAY_TYPE, element_type, rank, source_reference);
}


static ValaSymbol* vala_array_type_real_get_member (ValaDataType* base, const gchar* member_name) {
	ValaArrayType * self;
	ValaSymbol* result = NULL;
	ValaCodeContext* _tmp0_ = NULL;
	ValaCodeContext* _tmp1_;
	ValaProfile _tmp2_;
	gboolean _tmp3_;
	self = (ValaArrayType*) base;
	g_return_val_if_fail (member_name != NULL, NULL);
	_tmp0_ = vala_code_context_get ();
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_code_context_get_profile (_tmp1_);
	if ((_tmp3_ = _tmp2_ == VALA_PROFILE_DOVA, _vala_code_context_unref0 (_tmp1_), _tmp3_)) {
		ValaCodeContext* _tmp4_ = NULL;
		ValaCodeContext* _tmp5_;
		ValaNamespace* _tmp6_ = NULL;
		ValaScope* _tmp7_ = NULL;
		ValaSymbol* _tmp8_ = NULL;
		ValaSymbol* _tmp9_;
		ValaScope* _tmp10_ = NULL;
		ValaSymbol* _tmp11_ = NULL;
		ValaSymbol* _tmp12_;
		ValaSymbol* _tmp13_ = NULL;
		ValaSymbol* _tmp14_;
		_tmp4_ = vala_code_context_get ();
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_code_context_get_root (_tmp5_);
		_tmp7_ = vala_symbol_get_scope ((ValaSymbol*) _tmp6_);
		_tmp8_ = vala_scope_lookup (_tmp7_, "Dova");
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_symbol_get_scope (_tmp9_);
		_tmp11_ = vala_scope_lookup (_tmp10_, "Array");
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_semantic_analyzer_symbol_lookup_inherited (_tmp12_, member_name);
		result = (_tmp14_ = _tmp13_, _vala_code_node_unref0 (_tmp12_), _vala_code_node_unref0 (_tmp9_), _vala_code_context_unref0 (_tmp5_), _tmp14_);
		return result;
	} else {
		if (g_strcmp0 (member_name, "length") == 0) {
			ValaArrayLengthField* _tmp15_ = NULL;
			_tmp15_ = vala_array_type_get_length_field (self);
			result = (ValaSymbol*) _tmp15_;
			return result;
		} else {
			if (g_strcmp0 (member_name, "move") == 0) {
				ValaArrayMoveMethod* _tmp16_ = NULL;
				_tmp16_ = vala_array_type_get_move_method (self);
				result = (ValaSymbol*) _tmp16_;
				return result;
			} else {
				if (g_strcmp0 (member_name, "resize") == 0) {
					ValaArrayResizeMethod* _tmp17_ = NULL;
					_tmp17_ = vala_array_type_get_resize_method (self);
					result = (ValaSymbol*) _tmp17_;
					return result;
				}
			}
		}
	}
	result = NULL;
	return result;
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


static ValaArrayLengthField* vala_array_type_get_length_field (ValaArrayType* self) {
	ValaArrayLengthField* result = NULL;
	ValaArrayLengthField* _tmp21_;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->length_field == NULL) {
		ValaSourceReference* _tmp0_ = NULL;
		ValaArrayLengthField* _tmp1_ = NULL;
		ValaArrayLengthField* _tmp2_;
		ValaSourceReference* _tmp3_ = NULL;
		ValaSourceFile* _tmp4_ = NULL;
		ValaCodeContext* _tmp5_ = NULL;
		ValaNamespace* _tmp6_ = NULL;
		ValaNamespace* _tmp7_;
		ValaNamespace* root_symbol;
		_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp1_ = vala_array_length_field_new (_tmp0_);
		_tmp2_ = _tmp1_;
		_vala_code_node_unref0 (self->priv->length_field);
		self->priv->length_field = _tmp2_;
		vala_symbol_set_access ((ValaSymbol*) self->priv->length_field, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp3_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp4_ = vala_source_reference_get_file (_tmp3_);
		_tmp5_ = vala_source_file_get_context (_tmp4_);
		_tmp6_ = vala_code_context_get_root (_tmp5_);
		_tmp7_ = _vala_code_node_ref0 (_tmp6_);
		root_symbol = _tmp7_;
		if (self->priv->_rank > 1) {
			ValaScope* _tmp8_ = NULL;
			ValaSymbol* _tmp9_ = NULL;
			ValaStruct* _tmp10_;
			ValaIntegerType* _tmp11_ = NULL;
			ValaValueType* _tmp12_;
			ValaValueType* integer;
			ValaSourceReference* _tmp13_ = NULL;
			ValaArrayType* _tmp14_ = NULL;
			ValaArrayType* _tmp15_;
			_tmp8_ = vala_symbol_get_scope ((ValaSymbol*) root_symbol);
			_tmp9_ = vala_scope_lookup (_tmp8_, "int");
			_tmp10_ = VALA_STRUCT (_tmp9_);
			_tmp11_ = vala_integer_type_new (_tmp10_, NULL, NULL);
			integer = (_tmp12_ = (ValaValueType*) _tmp11_, _vala_code_node_unref0 (_tmp10_), _tmp12_);
			_tmp13_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp14_ = vala_array_type_new ((ValaDataType*) integer, 1, _tmp13_);
			_tmp15_ = _tmp14_;
			vala_variable_set_variable_type ((ValaVariable*) self->priv->length_field, (ValaDataType*) _tmp15_);
			_vala_code_node_unref0 (_tmp15_);
			_vala_code_node_unref0 (integer);
		} else {
			ValaScope* _tmp16_ = NULL;
			ValaSymbol* _tmp17_ = NULL;
			ValaStruct* _tmp18_;
			ValaIntegerType* _tmp19_ = NULL;
			ValaIntegerType* _tmp20_;
			_tmp16_ = vala_symbol_get_scope ((ValaSymbol*) root_symbol);
			_tmp17_ = vala_scope_lookup (_tmp16_, "int");
			_tmp18_ = VALA_STRUCT (_tmp17_);
			_tmp19_ = vala_integer_type_new (_tmp18_, NULL, NULL);
			_tmp20_ = _tmp19_;
			vala_variable_set_variable_type ((ValaVariable*) self->priv->length_field, (ValaDataType*) _tmp20_);
			_vala_code_node_unref0 (_tmp20_);
			_vala_code_node_unref0 (_tmp18_);
		}
		_vala_code_node_unref0 (root_symbol);
	}
	_tmp21_ = _vala_code_node_ref0 (self->priv->length_field);
	result = _tmp21_;
	return result;
}


static ValaArrayResizeMethod* vala_array_type_get_resize_method (ValaArrayType* self) {
	ValaArrayResizeMethod* result = NULL;
	ValaArrayResizeMethod* _tmp17_;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->resize_method == NULL) {
		ValaSourceReference* _tmp0_ = NULL;
		ValaArrayResizeMethod* _tmp1_ = NULL;
		ValaArrayResizeMethod* _tmp2_;
		ValaVoidType* _tmp3_ = NULL;
		ValaVoidType* _tmp4_;
		ValaSourceReference* _tmp5_ = NULL;
		ValaSourceFile* _tmp6_ = NULL;
		ValaCodeContext* _tmp7_ = NULL;
		ValaNamespace* _tmp8_ = NULL;
		ValaNamespace* _tmp9_;
		ValaNamespace* root_symbol;
		ValaScope* _tmp10_ = NULL;
		ValaSymbol* _tmp11_ = NULL;
		ValaStruct* _tmp12_;
		ValaIntegerType* _tmp13_ = NULL;
		ValaIntegerType* _tmp14_;
		ValaIntegerType* int_type;
		ValaFormalParameter* _tmp15_ = NULL;
		ValaFormalParameter* _tmp16_;
		_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp1_ = vala_array_resize_method_new (_tmp0_);
		_tmp2_ = _tmp1_;
		_vala_code_node_unref0 (self->priv->resize_method);
		self->priv->resize_method = _tmp2_;
		_tmp3_ = vala_void_type_new (NULL);
		_tmp4_ = _tmp3_;
		vala_method_set_return_type ((ValaMethod*) self->priv->resize_method, (ValaDataType*) _tmp4_);
		_vala_code_node_unref0 (_tmp4_);
		vala_symbol_set_access ((ValaSymbol*) self->priv->resize_method, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		vala_method_set_cname ((ValaMethod*) self->priv->resize_method, "g_renew");
		_tmp5_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp6_ = vala_source_reference_get_file (_tmp5_);
		_tmp7_ = vala_source_file_get_context (_tmp6_);
		_tmp8_ = vala_code_context_get_root (_tmp7_);
		_tmp9_ = _vala_code_node_ref0 (_tmp8_);
		root_symbol = _tmp9_;
		_tmp10_ = vala_symbol_get_scope ((ValaSymbol*) root_symbol);
		_tmp11_ = vala_scope_lookup (_tmp10_, "int");
		_tmp12_ = VALA_STRUCT (_tmp11_);
		_tmp13_ = vala_integer_type_new (_tmp12_, NULL, NULL);
		int_type = (_tmp14_ = _tmp13_, _vala_code_node_unref0 (_tmp12_), _tmp14_);
		_tmp15_ = vala_formal_parameter_new ("length", (ValaDataType*) int_type, NULL);
		_tmp16_ = _tmp15_;
		vala_method_add_parameter ((ValaMethod*) self->priv->resize_method, _tmp16_);
		_vala_code_node_unref0 (_tmp16_);
		vala_method_set_returns_modified_pointer ((ValaMethod*) self->priv->resize_method, TRUE);
		_vala_code_node_unref0 (int_type);
		_vala_code_node_unref0 (root_symbol);
	}
	_tmp17_ = _vala_code_node_ref0 (self->priv->resize_method);
	result = _tmp17_;
	return result;
}


static ValaArrayMoveMethod* vala_array_type_get_move_method (ValaArrayType* self) {
	ValaArrayMoveMethod* result = NULL;
	ValaArrayMoveMethod* _tmp21_;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->move_method == NULL) {
		ValaSourceReference* _tmp0_ = NULL;
		ValaArrayMoveMethod* _tmp1_ = NULL;
		ValaArrayMoveMethod* _tmp2_;
		ValaVoidType* _tmp3_ = NULL;
		ValaVoidType* _tmp4_;
		ValaSourceReference* _tmp5_ = NULL;
		ValaSourceFile* _tmp6_ = NULL;
		ValaCodeContext* _tmp7_ = NULL;
		ValaNamespace* _tmp8_ = NULL;
		ValaNamespace* _tmp9_;
		ValaNamespace* root_symbol;
		ValaScope* _tmp10_ = NULL;
		ValaSymbol* _tmp11_ = NULL;
		ValaStruct* _tmp12_;
		ValaIntegerType* _tmp13_ = NULL;
		ValaIntegerType* _tmp14_;
		ValaIntegerType* int_type;
		ValaFormalParameter* _tmp15_ = NULL;
		ValaFormalParameter* _tmp16_;
		ValaFormalParameter* _tmp17_ = NULL;
		ValaFormalParameter* _tmp18_;
		ValaFormalParameter* _tmp19_ = NULL;
		ValaFormalParameter* _tmp20_;
		_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp1_ = vala_array_move_method_new (_tmp0_);
		_tmp2_ = _tmp1_;
		_vala_code_node_unref0 (self->priv->move_method);
		self->priv->move_method = _tmp2_;
		_tmp3_ = vala_void_type_new (NULL);
		_tmp4_ = _tmp3_;
		vala_method_set_return_type ((ValaMethod*) self->priv->move_method, (ValaDataType*) _tmp4_);
		_vala_code_node_unref0 (_tmp4_);
		vala_symbol_set_access ((ValaSymbol*) self->priv->move_method, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		vala_method_set_cname ((ValaMethod*) self->priv->move_method, "_vala_array_move");
		_tmp5_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp6_ = vala_source_reference_get_file (_tmp5_);
		_tmp7_ = vala_source_file_get_context (_tmp6_);
		_tmp8_ = vala_code_context_get_root (_tmp7_);
		_tmp9_ = _vala_code_node_ref0 (_tmp8_);
		root_symbol = _tmp9_;
		_tmp10_ = vala_symbol_get_scope ((ValaSymbol*) root_symbol);
		_tmp11_ = vala_scope_lookup (_tmp10_, "int");
		_tmp12_ = VALA_STRUCT (_tmp11_);
		_tmp13_ = vala_integer_type_new (_tmp12_, NULL, NULL);
		int_type = (_tmp14_ = _tmp13_, _vala_code_node_unref0 (_tmp12_), _tmp14_);
		_tmp15_ = vala_formal_parameter_new ("src", (ValaDataType*) int_type, NULL);
		_tmp16_ = _tmp15_;
		vala_method_add_parameter ((ValaMethod*) self->priv->move_method, _tmp16_);
		_vala_code_node_unref0 (_tmp16_);
		_tmp17_ = vala_formal_parameter_new ("dest", (ValaDataType*) int_type, NULL);
		_tmp18_ = _tmp17_;
		vala_method_add_parameter ((ValaMethod*) self->priv->move_method, _tmp18_);
		_vala_code_node_unref0 (_tmp18_);
		_tmp19_ = vala_formal_parameter_new ("length", (ValaDataType*) int_type, NULL);
		_tmp20_ = _tmp19_;
		vala_method_add_parameter ((ValaMethod*) self->priv->move_method, _tmp20_);
		_vala_code_node_unref0 (_tmp20_);
		_vala_code_node_unref0 (int_type);
		_vala_code_node_unref0 (root_symbol);
	}
	_tmp21_ = _vala_code_node_ref0 (self->priv->move_method);
	result = _tmp21_;
	return result;
}


static ValaDataType* vala_array_type_real_copy (ValaDataType* base) {
	ValaArrayType * self;
	ValaDataType* result = NULL;
	ValaDataType* _tmp0_ = NULL;
	ValaDataType* _tmp1_ = NULL;
	ValaDataType* _tmp2_;
	ValaSourceReference* _tmp3_ = NULL;
	ValaArrayType* _tmp4_ = NULL;
	ValaArrayType* _tmp5_;
	ValaArrayType* _result_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	self = (ValaArrayType*) base;
	_tmp0_ = vala_array_type_get_element_type (self);
	_tmp1_ = vala_data_type_copy (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp4_ = vala_array_type_new (_tmp2_, self->priv->_rank, _tmp3_);
	_result_ = (_tmp5_ = _tmp4_, _vala_code_node_unref0 (_tmp2_), _tmp5_);
	_tmp6_ = vala_data_type_get_value_owned ((ValaDataType*) self);
	vala_data_type_set_value_owned ((ValaDataType*) _result_, _tmp6_);
	_tmp7_ = vala_data_type_get_nullable ((ValaDataType*) self);
	vala_data_type_set_nullable ((ValaDataType*) _result_, _tmp7_);
	_tmp8_ = vala_data_type_get_floating_reference ((ValaDataType*) self);
	vala_data_type_set_floating_reference ((ValaDataType*) _result_, _tmp8_);
	vala_array_type_set_inline_allocated (_result_, self->priv->_inline_allocated);
	if (self->priv->_fixed_length) {
		vala_array_type_set_fixed_length (_result_, TRUE);
		vala_array_type_set_length (_result_, self->priv->_length);
	}
	result = (ValaDataType*) _result_;
	return result;
}


static gchar* vala_array_type_real_get_cname (ValaDataType* base) {
	ValaArrayType * self;
	gchar* result = NULL;
	self = (ValaArrayType*) base;
	if (self->priv->_inline_allocated) {
		ValaDataType* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		_tmp0_ = vala_array_type_get_element_type (self);
		_tmp1_ = vala_data_type_get_cname (_tmp0_);
		result = _tmp1_;
		return result;
	} else {
		ValaCodeContext* _tmp2_ = NULL;
		ValaCodeContext* _tmp3_;
		ValaProfile _tmp4_;
		gboolean _tmp5_;
		_tmp2_ = vala_code_context_get ();
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_code_context_get_profile (_tmp3_);
		if ((_tmp5_ = _tmp4_ == VALA_PROFILE_DOVA, _vala_code_context_unref0 (_tmp3_), _tmp5_)) {
			gchar* _tmp6_;
			_tmp6_ = g_strdup ("DovaArray*");
			result = _tmp6_;
			return result;
		} else {
			ValaDataType* _tmp7_ = NULL;
			gchar* _tmp8_ = NULL;
			gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp7_ = vala_array_type_get_element_type (self);
			_tmp8_ = vala_data_type_get_cname (_tmp7_);
			_tmp9_ = _tmp8_;
			result = (_tmp10_ = g_strconcat (_tmp9_, "*", NULL), _g_free0 (_tmp9_), _tmp10_);
			return result;
		}
	}
}


static gchar* vala_array_type_real_get_cdeclarator_suffix (ValaDataType* base) {
	ValaArrayType * self;
	gchar* result = NULL;
	self = (ValaArrayType*) base;
	if (self->priv->_fixed_length) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup_printf ("[%d]", self->priv->_length);
		result = _tmp0_;
		return result;
	} else {
		if (self->priv->_inline_allocated) {
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("[]");
			result = _tmp1_;
			return result;
		} else {
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("");
			result = _tmp2_;
			return result;
		}
	}
}


static gboolean vala_array_type_real_is_array (ValaDataType* base) {
	ValaArrayType * self;
	gboolean result = FALSE;
	self = (ValaArrayType*) base;
	result = TRUE;
	return result;
}


static gchar* vala_array_type_real_to_qualified_string (ValaDataType* base, ValaScope* scope) {
	ValaArrayType * self;
	gchar* result = NULL;
	const gchar* _tmp0_;
	gboolean _tmp1_;
	ValaDataType* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	self = (ValaArrayType*) base;
	_tmp0_ = NULL;
	_tmp1_ = vala_data_type_get_nullable ((ValaDataType*) self);
	if (_tmp1_) {
		_tmp0_ = "?";
	} else {
		_tmp0_ = "";
	}
	_tmp2_ = vala_array_type_get_element_type (self);
	_tmp3_ = vala_data_type_to_qualified_string (_tmp2_, scope);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strnfill ((gsize) (self->priv->_rank - 1), ',');
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strdup_printf ("%s[%s]%s", _tmp4_, _tmp6_, _tmp0_);
	result = (_tmp8_ = _tmp7_, _g_free0 (_tmp6_), _g_free0 (_tmp4_), _tmp8_);
	return result;
}


static gboolean vala_array_type_real_compatible (ValaDataType* base, ValaDataType* target_type) {
	ValaArrayType * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gboolean _tmp3_;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_ = FALSE;
	ValaTypeParameter* _tmp21_ = NULL;
	ValaDataType* _tmp22_;
	ValaArrayType* _tmp23_;
	ValaArrayType* target_array_type;
	gboolean _tmp24_ = FALSE;
	ValaDataType* _tmp25_ = NULL;
	ValaDataType* _tmp26_ = NULL;
	gboolean _tmp27_;
	self = (ValaArrayType*) base;
	g_return_val_if_fail (target_type != NULL, FALSE);
	_tmp1_ = vala_data_type_get_type_id (target_type);
	_tmp2_ = _tmp1_;
	if ((_tmp3_ = g_strcmp0 (_tmp2_, "G_TYPE_VALUE") == 0, _g_free0 (_tmp2_), _tmp3_)) {
		ValaDataType* _tmp4_ = NULL;
		ValaTypeSymbol* _tmp5_ = NULL;
		ValaCodeContext* _tmp6_ = NULL;
		ValaCodeContext* _tmp7_;
		ValaNamespace* _tmp8_ = NULL;
		ValaScope* _tmp9_ = NULL;
		ValaSymbol* _tmp10_ = NULL;
		ValaSymbol* _tmp11_;
		_tmp4_ = vala_array_type_get_element_type (self);
		_tmp5_ = vala_data_type_get_data_type (_tmp4_);
		_tmp6_ = vala_code_context_get ();
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_code_context_get_root (_tmp7_);
		_tmp9_ = vala_symbol_get_scope ((ValaSymbol*) _tmp8_);
		_tmp10_ = vala_scope_lookup (_tmp9_, "string");
		_tmp11_ = _tmp10_;
		_tmp0_ = VALA_SYMBOL (_tmp5_) == _tmp11_;
		_vala_code_node_unref0 (_tmp11_);
		_vala_code_context_unref0 (_tmp7_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	_tmp12_ = vala_data_type_get_type_id (target_type);
	_tmp13_ = _tmp12_;
	if ((_tmp14_ = g_strcmp0 (_tmp13_, "G_TYPE_VARIANT") == 0, _g_free0 (_tmp13_), _tmp14_)) {
		result = TRUE;
		return result;
	}
	if (VALA_IS_POINTER_TYPE (target_type)) {
		_tmp15_ = TRUE;
	} else {
		gboolean _tmp16_ = FALSE;
		ValaTypeSymbol* _tmp17_ = NULL;
		_tmp17_ = vala_data_type_get_data_type (target_type);
		if (_tmp17_ != NULL) {
			ValaTypeSymbol* _tmp18_ = NULL;
			ValaAttribute* _tmp19_ = NULL;
			ValaAttribute* _tmp20_;
			_tmp18_ = vala_data_type_get_data_type (target_type);
			_tmp19_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp18_, "PointerType");
			_tmp20_ = _tmp19_;
			_tmp16_ = _tmp20_ != NULL;
			_vala_code_node_unref0 (_tmp20_);
		} else {
			_tmp16_ = FALSE;
		}
		_tmp15_ = _tmp16_;
	}
	if (_tmp15_) {
		result = TRUE;
		return result;
	}
	_tmp21_ = vala_data_type_get_type_parameter (target_type);
	if (_tmp21_ != NULL) {
		result = TRUE;
		return result;
	}
	_tmp23_ = _vala_code_node_ref0 ((_tmp22_ = target_type, VALA_IS_ARRAY_TYPE (_tmp22_) ? ((ValaArrayType*) _tmp22_) : NULL));
	target_array_type = _tmp23_;
	if (target_array_type == NULL) {
		result = FALSE;
		_vala_code_node_unref0 (target_array_type);
		return result;
	}
	if (target_array_type->priv->_rank != self->priv->_rank) {
		result = FALSE;
		_vala_code_node_unref0 (target_array_type);
		return result;
	}
	_tmp25_ = vala_array_type_get_element_type (self);
	_tmp26_ = vala_array_type_get_element_type (target_array_type);
	_tmp27_ = vala_data_type_compatible (_tmp25_, _tmp26_);
	if (_tmp27_) {
		ValaDataType* _tmp28_ = NULL;
		ValaDataType* _tmp29_ = NULL;
		gboolean _tmp30_;
		_tmp28_ = vala_array_type_get_element_type (target_array_type);
		_tmp29_ = vala_array_type_get_element_type (self);
		_tmp30_ = vala_data_type_compatible (_tmp28_, _tmp29_);
		_tmp24_ = _tmp30_;
	} else {
		_tmp24_ = FALSE;
	}
	if (_tmp24_) {
		result = TRUE;
		_vala_code_node_unref0 (target_array_type);
		return result;
	}
	result = FALSE;
	_vala_code_node_unref0 (target_array_type);
	return result;
}


static gboolean vala_array_type_real_is_reference_type_or_type_parameter (ValaDataType* base) {
	ValaArrayType * self;
	gboolean result = FALSE;
	self = (ValaArrayType*) base;
	result = TRUE;
	return result;
}


static void vala_array_type_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaArrayType * self;
	ValaDataType* _tmp0_ = NULL;
	self = (ValaArrayType*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_array_type_get_element_type (self);
	vala_code_node_accept ((ValaCodeNode*) _tmp0_, visitor);
}


static void vala_array_type_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type) {
	ValaArrayType * self;
	ValaDataType* _tmp0_ = NULL;
	self = (ValaArrayType*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_array_type_get_element_type (self);
	if (_tmp0_ == old_type) {
		vala_array_type_set_element_type (self, new_type);
	}
}


static gboolean vala_array_type_real_is_accessible (ValaDataType* base, ValaSymbol* sym) {
	ValaArrayType * self;
	gboolean result = FALSE;
	ValaDataType* _tmp0_ = NULL;
	gboolean _tmp1_;
	self = (ValaArrayType*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp0_ = vala_array_type_get_element_type (self);
	_tmp1_ = vala_data_type_is_accessible (_tmp0_, sym);
	result = _tmp1_;
	return result;
}


static gboolean vala_array_type_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer) {
	ValaArrayType * self;
	gboolean result = FALSE;
	ValaDataType* _tmp1_ = NULL;
	gboolean _tmp2_;
	self = (ValaArrayType*) base;
	g_return_val_if_fail (analyzer != NULL, FALSE);
	if (self->priv->_invalid_syntax) {
		ValaSourceReference* _tmp0_ = NULL;
		_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		vala_report_error (_tmp0_, "syntax error, no expression allowed between array brackets");
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp1_ = vala_array_type_get_element_type (self);
	_tmp2_ = vala_code_node_check ((ValaCodeNode*) _tmp1_, analyzer);
	result = _tmp2_;
	return result;
}


static gchar* vala_array_type_real_get_type_id (ValaDataType* base) {
	ValaArrayType * self;
	gchar* result = NULL;
	ValaDataType* _tmp0_ = NULL;
	ValaTypeSymbol* _tmp1_ = NULL;
	ValaCodeContext* _tmp2_ = NULL;
	ValaCodeContext* _tmp3_;
	ValaNamespace* _tmp4_ = NULL;
	ValaScope* _tmp5_ = NULL;
	ValaSymbol* _tmp6_ = NULL;
	ValaSymbol* _tmp7_;
	gboolean _tmp8_;
	self = (ValaArrayType*) base;
	_tmp0_ = vala_array_type_get_element_type (self);
	_tmp1_ = vala_data_type_get_data_type (_tmp0_);
	_tmp2_ = vala_code_context_get ();
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_code_context_get_root (_tmp3_);
	_tmp5_ = vala_symbol_get_scope ((ValaSymbol*) _tmp4_);
	_tmp6_ = vala_scope_lookup (_tmp5_, "string");
	_tmp7_ = _tmp6_;
	if ((_tmp8_ = VALA_SYMBOL (_tmp1_) == _tmp7_, _vala_code_node_unref0 (_tmp7_), _vala_code_context_unref0 (_tmp3_), _tmp8_)) {
		gchar* _tmp9_;
		_tmp9_ = g_strdup ("G_TYPE_STRV");
		result = _tmp9_;
		return result;
	} else {
		result = NULL;
		return result;
	}
}


static ValaDataType* vala_array_type_real_get_actual_type (ValaDataType* base, ValaDataType* derived_instance_type, ValaMemberAccess* method_access, ValaCodeNode* node_reference) {
	ValaArrayType * self;
	ValaDataType* result = NULL;
	gboolean _tmp0_ = FALSE;
	ValaArrayType* _tmp2_;
	ValaArrayType* _result_;
	gboolean _tmp3_ = FALSE;
	ValaDataType* _tmp4_ = NULL;
	self = (ValaArrayType*) base;
	g_return_val_if_fail (node_reference != NULL, NULL);
	if (derived_instance_type == NULL) {
		_tmp0_ = method_access == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ValaDataType* _tmp1_;
		_tmp1_ = _vala_code_node_ref0 ((ValaDataType*) self);
		result = _tmp1_;
		return result;
	}
	_tmp2_ = _vala_code_node_ref0 (self);
	_result_ = _tmp2_;
	_tmp4_ = vala_array_type_get_element_type (self);
	if (VALA_IS_GENERIC_TYPE (_tmp4_)) {
		_tmp3_ = TRUE;
	} else {
		ValaDataType* _tmp5_ = NULL;
		gboolean _tmp6_;
		_tmp5_ = vala_array_type_get_element_type (self);
		_tmp6_ = vala_data_type_has_type_arguments (_tmp5_);
		_tmp3_ = _tmp6_;
	}
	if (_tmp3_) {
		ValaDataType* _tmp7_ = NULL;
		ValaArrayType* _tmp8_;
		ValaDataType* _tmp9_ = NULL;
		ValaDataType* _tmp10_ = NULL;
		ValaDataType* _tmp11_;
		_tmp7_ = vala_data_type_copy ((ValaDataType*) _result_);
		_tmp8_ = VALA_ARRAY_TYPE (_tmp7_);
		_vala_code_node_unref0 (_result_);
		_result_ = _tmp8_;
		_tmp9_ = vala_array_type_get_element_type (_result_);
		_tmp10_ = vala_data_type_get_actual_type (_tmp9_, derived_instance_type, method_access, node_reference);
		_tmp11_ = _tmp10_;
		vala_array_type_set_element_type (_result_, _tmp11_);
		_vala_code_node_unref0 (_tmp11_);
	}
	result = (ValaDataType*) _result_;
	return result;
}


static gboolean vala_array_type_real_is_disposable (ValaDataType* base) {
	ValaArrayType * self;
	gboolean result = FALSE;
	self = (ValaArrayType*) base;
	if (self->priv->_fixed_length) {
		ValaDataType* _tmp0_ = NULL;
		gboolean _tmp1_;
		_tmp0_ = vala_array_type_get_element_type (self);
		_tmp1_ = vala_data_type_is_disposable (_tmp0_);
		result = _tmp1_;
		return result;
	} else {
		gboolean _tmp2_;
		_tmp2_ = VALA_DATA_TYPE_CLASS (vala_array_type_parent_class)->is_disposable ((ValaDataType*) VALA_REFERENCE_TYPE (self));
		result = _tmp2_;
		return result;
	}
}


ValaDataType* vala_array_type_get_element_type (ValaArrayType* self) {
	ValaDataType* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_element_type;
	return result;
}


void vala_array_type_set_element_type (ValaArrayType* self, ValaDataType* value) {
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_tmp1_ = _tmp0_;
	_vala_code_node_unref0 (self->priv->_element_type);
	self->priv->_element_type = _tmp1_;
	vala_code_node_set_parent_node ((ValaCodeNode*) self->priv->_element_type, (ValaCodeNode*) self);
}


gboolean vala_array_type_get_invalid_syntax (ValaArrayType* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_invalid_syntax;
	return result;
}


void vala_array_type_set_invalid_syntax (ValaArrayType* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_invalid_syntax = value;
}


gboolean vala_array_type_get_inline_allocated (ValaArrayType* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_inline_allocated;
	return result;
}


void vala_array_type_set_inline_allocated (ValaArrayType* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_inline_allocated = value;
}


gboolean vala_array_type_get_fixed_length (ValaArrayType* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_fixed_length;
	return result;
}


void vala_array_type_set_fixed_length (ValaArrayType* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_fixed_length = value;
}


gint vala_array_type_get_length (ValaArrayType* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_length;
	return result;
}


void vala_array_type_set_length (ValaArrayType* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_length = value;
}


gint vala_array_type_get_rank (ValaArrayType* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_rank;
	return result;
}


void vala_array_type_set_rank (ValaArrayType* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_rank = value;
}


static void vala_array_type_class_init (ValaArrayTypeClass * klass) {
	vala_array_type_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_array_type_finalize;
	g_type_class_add_private (klass, sizeof (ValaArrayTypePrivate));
	VALA_DATA_TYPE_CLASS (klass)->get_member = vala_array_type_real_get_member;
	VALA_DATA_TYPE_CLASS (klass)->copy = vala_array_type_real_copy;
	VALA_DATA_TYPE_CLASS (klass)->get_cname = vala_array_type_real_get_cname;
	VALA_DATA_TYPE_CLASS (klass)->get_cdeclarator_suffix = vala_array_type_real_get_cdeclarator_suffix;
	VALA_DATA_TYPE_CLASS (klass)->is_array = vala_array_type_real_is_array;
	VALA_DATA_TYPE_CLASS (klass)->to_qualified_string = vala_array_type_real_to_qualified_string;
	VALA_DATA_TYPE_CLASS (klass)->compatible = vala_array_type_real_compatible;
	VALA_DATA_TYPE_CLASS (klass)->is_reference_type_or_type_parameter = vala_array_type_real_is_reference_type_or_type_parameter;
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_array_type_real_accept_children;
	VALA_CODE_NODE_CLASS (klass)->replace_type = vala_array_type_real_replace_type;
	VALA_DATA_TYPE_CLASS (klass)->is_accessible = vala_array_type_real_is_accessible;
	VALA_CODE_NODE_CLASS (klass)->check = vala_array_type_real_check;
	VALA_DATA_TYPE_CLASS (klass)->get_type_id = vala_array_type_real_get_type_id;
	VALA_DATA_TYPE_CLASS (klass)->get_actual_type = vala_array_type_real_get_actual_type;
	VALA_DATA_TYPE_CLASS (klass)->is_disposable = vala_array_type_real_is_disposable;
}


static void vala_array_type_instance_init (ValaArrayType * self) {
	self->priv = VALA_ARRAY_TYPE_GET_PRIVATE (self);
}


static void vala_array_type_finalize (ValaCodeNode* obj) {
	ValaArrayType * self;
	self = VALA_ARRAY_TYPE (obj);
	_vala_code_node_unref0 (self->priv->_element_type);
	_vala_code_node_unref0 (self->priv->length_field);
	_vala_code_node_unref0 (self->priv->resize_method);
	_vala_code_node_unref0 (self->priv->move_method);
	VALA_CODE_NODE_CLASS (vala_array_type_parent_class)->finalize (obj);
}


/**
 * An array type.
 */
GType vala_array_type_get_type (void) {
	static volatile gsize vala_array_type_type_id__volatile = 0;
	if (g_once_init_enter (&vala_array_type_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaArrayTypeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_array_type_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaArrayType), 0, (GInstanceInitFunc) vala_array_type_instance_init, NULL };
		GType vala_array_type_type_id;
		vala_array_type_type_id = g_type_register_static (VALA_TYPE_REFERENCE_TYPE, "ValaArrayType", &g_define_type_info, 0);
		g_once_init_leave (&vala_array_type_type_id__volatile, vala_array_type_type_id);
	}
	return vala_array_type_type_id__volatile;
}



