/* valaccodecompiler.c generated by valac, the Vala compiler
 * generated from valaccodecompiler.vala, do not modify */

/* valaccodecompiler.vala
 *
 * Copyright (C) 2007-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <vala.h>
#include <valagee.h>
#include <stdio.h>
#include <glib/gstdio.h>
#include <gobject/gvaluecollector.h>


#define VALA_TYPE_CCODE_COMPILER (vala_ccode_compiler_get_type ())
#define VALA_CCODE_COMPILER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_COMPILER, ValaCCodeCompiler))
#define VALA_CCODE_COMPILER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_COMPILER, ValaCCodeCompilerClass))
#define VALA_IS_CCODE_COMPILER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_COMPILER))
#define VALA_IS_CCODE_COMPILER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_COMPILER))
#define VALA_CCODE_COMPILER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_COMPILER, ValaCCodeCompilerClass))

typedef struct _ValaCCodeCompiler ValaCCodeCompiler;
typedef struct _ValaCCodeCompilerClass ValaCCodeCompilerClass;
typedef struct _ValaCCodeCompilerPrivate ValaCCodeCompilerPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
typedef struct _ValaParamSpecCCodeCompiler ValaParamSpecCCodeCompiler;

struct _ValaCCodeCompiler {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCCodeCompilerPrivate * priv;
};

struct _ValaCCodeCompilerClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCCodeCompiler *self);
};

struct _ValaParamSpecCCodeCompiler {
	GParamSpec parent_instance;
};


static gpointer vala_ccode_compiler_parent_class = NULL;

gpointer vala_ccode_compiler_ref (gpointer instance);
void vala_ccode_compiler_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_compiler (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_compiler (GValue* value, gpointer v_object);
void vala_value_take_ccode_compiler (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_compiler (const GValue* value);
GType vala_ccode_compiler_get_type (void) G_GNUC_CONST;
enum  {
	VALA_CCODE_COMPILER_DUMMY_PROPERTY
};
ValaCCodeCompiler* vala_ccode_compiler_new (void);
ValaCCodeCompiler* vala_ccode_compiler_construct (GType object_type);
static gboolean vala_ccode_compiler_package_exists (const gchar* package_name);
void vala_ccode_compiler_compile (ValaCCodeCompiler* self, ValaCodeContext* context, const gchar* cc_command, gchar** cc_options, int cc_options_length1);
static void vala_ccode_compiler_finalize (ValaCCodeCompiler* obj);


ValaCCodeCompiler* vala_ccode_compiler_construct (GType object_type) {
	ValaCCodeCompiler* self = NULL;
	self = (ValaCCodeCompiler*) g_type_create_instance (object_type);
	return self;
}


ValaCCodeCompiler* vala_ccode_compiler_new (void) {
	return vala_ccode_compiler_construct (VALA_TYPE_CCODE_COMPILER);
}


static gboolean vala_ccode_compiler_package_exists (const gchar* package_name) {
	gboolean result = FALSE;
	gchar* pc;
	gint exit_status = 0;
	gint _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (package_name != NULL, FALSE);
	pc = g_strconcat ("pkg-config --exists ", package_name, NULL);
	g_spawn_command_line_sync (pc, NULL, NULL, &_tmp0_, &_inner_error_);
	exit_status = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_SPAWN_ERROR) {
			goto __catch1_g_spawn_error;
		}
		_g_free0 (pc);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = 0 == exit_status;
	_g_free0 (pc);
	return result;
	goto __finally1;
	__catch1_g_spawn_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		vala_report_error (NULL, e->message);
		result = FALSE;
		_g_error_free0 (e);
		_g_free0 (pc);
		return result;
	}
	__finally1:
	_g_free0 (pc);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return FALSE;
}


/**
 * Compile generated C code to object code and optionally link object
 * files.
 *
 * @param context a code context
 */
static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}


void vala_ccode_compiler_compile (ValaCCodeCompiler* self, ValaCodeContext* context, const gchar* cc_command, gchar** cc_options, int cc_options_length1) {
	gboolean use_pkgconfig;
	gchar* _tmp0_;
	gchar* pc;
	gboolean _tmp1_;
	ValaProfile _tmp3_;
	gchar* _tmp13_;
	gchar* pkgflags;
	gchar* _tmp18_;
	gchar* cmdline;
	gboolean _tmp19_;
	gboolean _tmp21_;
	ValaList* _tmp40_ = NULL;
	ValaList* source_files;
	ValaList* _tmp51_ = NULL;
	ValaList* c_source_files;
	gchar* _tmp59_ = NULL;
	gchar* _tmp60_;
	gchar* _tmp61_;
	gchar* _tmp62_;
	gboolean _tmp68_;
	gint exit_status = 0;
	gint _tmp69_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	use_pkgconfig = FALSE;
	_tmp0_ = g_strdup ("pkg-config --cflags");
	pc = _tmp0_;
	_tmp1_ = vala_code_context_get_compile_only (context);
	if (!_tmp1_) {
		gchar* _tmp2_;
		_tmp2_ = g_strconcat (pc, " --libs", NULL);
		_g_free0 (pc);
		pc = _tmp2_;
	}
	_tmp3_ = vala_code_context_get_profile (context);
	if (_tmp3_ == VALA_PROFILE_GOBJECT) {
		gchar* _tmp4_;
		gboolean _tmp5_;
		use_pkgconfig = TRUE;
		_tmp4_ = g_strconcat (pc, " gobject-2.0", NULL);
		_g_free0 (pc);
		pc = _tmp4_;
		_tmp5_ = vala_code_context_get_thread (context);
		if (_tmp5_) {
			gchar* _tmp6_;
			_tmp6_ = g_strconcat (pc, " gthread-2.0", NULL);
			_g_free0 (pc);
			pc = _tmp6_;
		}
	}
	{
		ValaList* _tmp7_ = NULL;
		ValaList* _pkg_list;
		gint _tmp8_;
		gint _pkg_size;
		gint _pkg_index;
		_tmp7_ = vala_code_context_get_packages (context);
		_pkg_list = _tmp7_;
		_tmp8_ = vala_collection_get_size ((ValaCollection*) _pkg_list);
		_pkg_size = _tmp8_;
		_pkg_index = -1;
		while (TRUE) {
			gpointer _tmp9_ = NULL;
			gchar* pkg;
			gboolean _tmp10_;
			_pkg_index = _pkg_index + 1;
			if (!(_pkg_index < _pkg_size)) {
				break;
			}
			_tmp9_ = vala_list_get (_pkg_list, _pkg_index);
			pkg = (gchar*) _tmp9_;
			_tmp10_ = vala_ccode_compiler_package_exists (pkg);
			if (_tmp10_) {
				gchar* _tmp11_;
				gchar* _tmp12_;
				use_pkgconfig = TRUE;
				_tmp11_ = g_strconcat (" ", pkg, NULL);
				_tmp12_ = g_strconcat (pc, _tmp11_, NULL);
				_g_free0 (pc);
				pc = _tmp12_;
				_g_free0 (_tmp11_);
			}
			_g_free0 (pkg);
		}
		_vala_iterable_unref0 (_pkg_list);
	}
	_tmp13_ = g_strdup ("");
	pkgflags = _tmp13_;
	if (use_pkgconfig) {
		gint exit_status = 0;
		gchar* _tmp14_ = NULL;
		gint _tmp15_;
		g_spawn_command_line_sync (pc, &_tmp14_, NULL, &_tmp15_, &_inner_error_);
		_g_free0 (pkgflags);
		pkgflags = _tmp14_;
		exit_status = _tmp15_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch2_g_spawn_error;
			}
			_g_free0 (pkgflags);
			_g_free0 (pc);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		if (exit_status != 0) {
			gchar* _tmp16_ = NULL;
			gchar* _tmp17_;
			_tmp16_ = g_strdup_printf ("pkg-config exited with status %d", exit_status);
			_tmp17_ = _tmp16_;
			vala_report_error (NULL, _tmp17_);
			_g_free0 (_tmp17_);
			_g_free0 (pkgflags);
			_g_free0 (pc);
			return;
		}
		goto __finally2;
		__catch2_g_spawn_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			vala_report_error (NULL, e->message);
			_g_error_free0 (e);
			_g_free0 (pkgflags);
			_g_free0 (pc);
			return;
		}
		__finally2:
		if (_inner_error_ != NULL) {
			_g_free0 (pkgflags);
			_g_free0 (pc);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (cc_command == NULL) {
		cc_command = "cc";
	}
	_tmp18_ = g_strdup (cc_command);
	cmdline = _tmp18_;
	_tmp19_ = vala_code_context_get_debug (context);
	if (_tmp19_) {
		gchar* _tmp20_;
		_tmp20_ = g_strconcat (cmdline, " -g", NULL);
		_g_free0 (cmdline);
		cmdline = _tmp20_;
	}
	_tmp21_ = vala_code_context_get_compile_only (context);
	if (_tmp21_) {
		gchar* _tmp22_;
		_tmp22_ = g_strconcat (cmdline, " -c", NULL);
		_g_free0 (cmdline);
		cmdline = _tmp22_;
	} else {
		const gchar* _tmp23_ = NULL;
		_tmp23_ = vala_code_context_get_output (context);
		if (_tmp23_ != NULL) {
			const gchar* _tmp24_ = NULL;
			gchar* _tmp25_;
			gchar* output;
			gboolean _tmp26_ = FALSE;
			gboolean _tmp27_ = FALSE;
			const gchar* _tmp28_ = NULL;
			gchar* _tmp36_ = NULL;
			gchar* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			_tmp24_ = vala_code_context_get_output (context);
			_tmp25_ = g_strdup (_tmp24_);
			output = _tmp25_;
			_tmp28_ = vala_code_context_get_directory (context);
			if (_tmp28_ != NULL) {
				const gchar* _tmp29_ = NULL;
				_tmp29_ = vala_code_context_get_directory (context);
				_tmp27_ = g_strcmp0 (_tmp29_, "") != 0;
			} else {
				_tmp27_ = FALSE;
			}
			if (_tmp27_) {
				const gchar* _tmp30_ = NULL;
				gboolean _tmp31_;
				_tmp30_ = vala_code_context_get_output (context);
				_tmp31_ = g_path_is_absolute (_tmp30_);
				_tmp26_ = !_tmp31_;
			} else {
				_tmp26_ = FALSE;
			}
			if (_tmp26_) {
				const gchar* _tmp32_ = NULL;
				const gchar* _tmp33_ = NULL;
				gchar* _tmp34_ = NULL;
				gchar* _tmp35_;
				_tmp32_ = vala_code_context_get_directory (context);
				_tmp33_ = vala_code_context_get_output (context);
				_tmp34_ = g_strdup_printf ("%s%c%s", _tmp32_, (gint) G_DIR_SEPARATOR, _tmp33_);
				_tmp35_ = _tmp34_;
				_g_free0 (output);
				output = _tmp35_;
			}
			_tmp36_ = g_shell_quote (output);
			_tmp37_ = _tmp36_;
			_tmp38_ = g_strconcat (" -o ", _tmp37_, NULL);
			_tmp39_ = g_strconcat (cmdline, _tmp38_, NULL);
			_g_free0 (cmdline);
			cmdline = _tmp39_;
			_g_free0 (_tmp38_);
			_g_free0 (_tmp37_);
			_g_free0 (output);
		}
	}
	_tmp40_ = vala_code_context_get_source_files (context);
	source_files = _tmp40_;
	{
		ValaList* _tmp41_;
		ValaList* _file_list;
		gint _tmp42_;
		gint _file_size;
		gint _file_index;
		_tmp41_ = _vala_iterable_ref0 (source_files);
		_file_list = _tmp41_;
		_tmp42_ = vala_collection_get_size ((ValaCollection*) _file_list);
		_file_size = _tmp42_;
		_file_index = -1;
		while (TRUE) {
			gpointer _tmp43_ = NULL;
			ValaSourceFile* file;
			ValaSourceFileType _tmp44_;
			_file_index = _file_index + 1;
			if (!(_file_index < _file_size)) {
				break;
			}
			_tmp43_ = vala_list_get (_file_list, _file_index);
			file = (ValaSourceFile*) _tmp43_;
			_tmp44_ = vala_source_file_get_file_type (file);
			if (_tmp44_ == VALA_SOURCE_FILE_TYPE_SOURCE) {
				gchar* _tmp45_ = NULL;
				gchar* _tmp46_;
				gchar* _tmp47_ = NULL;
				gchar* _tmp48_;
				gchar* _tmp49_;
				gchar* _tmp50_;
				_tmp45_ = vala_source_file_get_csource_filename (file);
				_tmp46_ = _tmp45_;
				_tmp47_ = g_shell_quote (_tmp46_);
				_tmp48_ = _tmp47_;
				_tmp49_ = g_strconcat (" ", _tmp48_, NULL);
				_tmp50_ = g_strconcat (cmdline, _tmp49_, NULL);
				_g_free0 (cmdline);
				cmdline = _tmp50_;
				_g_free0 (_tmp49_);
				_g_free0 (_tmp48_);
				_g_free0 (_tmp46_);
			}
			_vala_source_file_unref0 (file);
		}
		_vala_iterable_unref0 (_file_list);
	}
	_tmp51_ = vala_code_context_get_c_source_files (context);
	c_source_files = _tmp51_;
	{
		ValaList* _tmp52_;
		ValaList* _file_list;
		gint _tmp53_;
		gint _file_size;
		gint _file_index;
		_tmp52_ = _vala_iterable_ref0 (c_source_files);
		_file_list = _tmp52_;
		_tmp53_ = vala_collection_get_size ((ValaCollection*) _file_list);
		_file_size = _tmp53_;
		_file_index = -1;
		while (TRUE) {
			gpointer _tmp54_ = NULL;
			gchar* file;
			gchar* _tmp55_ = NULL;
			gchar* _tmp56_;
			gchar* _tmp57_;
			gchar* _tmp58_;
			_file_index = _file_index + 1;
			if (!(_file_index < _file_size)) {
				break;
			}
			_tmp54_ = vala_list_get (_file_list, _file_index);
			file = (gchar*) _tmp54_;
			_tmp55_ = g_shell_quote (file);
			_tmp56_ = _tmp55_;
			_tmp57_ = g_strconcat (" ", _tmp56_, NULL);
			_tmp58_ = g_strconcat (cmdline, _tmp57_, NULL);
			_g_free0 (cmdline);
			cmdline = _tmp58_;
			_g_free0 (_tmp57_);
			_g_free0 (_tmp56_);
			_g_free0 (file);
		}
		_vala_iterable_unref0 (_file_list);
	}
	_tmp59_ = string_strip (pkgflags);
	_tmp60_ = _tmp59_;
	_tmp61_ = g_strconcat (" ", _tmp60_, NULL);
	_tmp62_ = g_strconcat (cmdline, _tmp61_, NULL);
	_g_free0 (cmdline);
	cmdline = _tmp62_;
	_g_free0 (_tmp61_);
	_g_free0 (_tmp60_);
	{
		gchar** cc_option_collection;
		int cc_option_collection_length1;
		int cc_option_it;
		cc_option_collection = cc_options;
		cc_option_collection_length1 = cc_options_length1;
		for (cc_option_it = 0; cc_option_it < cc_options_length1; cc_option_it = cc_option_it + 1) {
			gchar* _tmp63_;
			gchar* cc_option;
			_tmp63_ = g_strdup (cc_option_collection[cc_option_it]);
			cc_option = _tmp63_;
			{
				gchar* _tmp64_ = NULL;
				gchar* _tmp65_;
				gchar* _tmp66_;
				gchar* _tmp67_;
				_tmp64_ = g_shell_quote (cc_option);
				_tmp65_ = _tmp64_;
				_tmp66_ = g_strconcat (" ", _tmp65_, NULL);
				_tmp67_ = g_strconcat (cmdline, _tmp66_, NULL);
				_g_free0 (cmdline);
				cmdline = _tmp67_;
				_g_free0 (_tmp66_);
				_g_free0 (_tmp65_);
				_g_free0 (cc_option);
			}
		}
	}
	_tmp68_ = vala_code_context_get_verbose_mode (context);
	if (_tmp68_) {
		fprintf (stdout, "%s\n", cmdline);
	}
	g_spawn_command_line_sync (cmdline, NULL, NULL, &_tmp69_, &_inner_error_);
	exit_status = _tmp69_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_SPAWN_ERROR) {
			goto __catch3_g_spawn_error;
		}
		_vala_iterable_unref0 (c_source_files);
		_vala_iterable_unref0 (source_files);
		_g_free0 (cmdline);
		_g_free0 (pkgflags);
		_g_free0 (pc);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	if (exit_status != 0) {
		gchar* _tmp70_ = NULL;
		gchar* _tmp71_;
		_tmp70_ = g_strdup_printf ("cc exited with status %d", exit_status);
		_tmp71_ = _tmp70_;
		vala_report_error (NULL, _tmp71_);
		_g_free0 (_tmp71_);
	}
	goto __finally3;
	__catch3_g_spawn_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		vala_report_error (NULL, e->message);
		_g_error_free0 (e);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		_vala_iterable_unref0 (c_source_files);
		_vala_iterable_unref0 (source_files);
		_g_free0 (cmdline);
		_g_free0 (pkgflags);
		_g_free0 (pc);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	{
		ValaList* _tmp72_;
		ValaList* _file_list;
		gint _tmp73_;
		gint _file_size;
		gint _file_index;
		_tmp72_ = _vala_iterable_ref0 (source_files);
		_file_list = _tmp72_;
		_tmp73_ = vala_collection_get_size ((ValaCollection*) _file_list);
		_file_size = _tmp73_;
		_file_index = -1;
		while (TRUE) {
			gpointer _tmp74_ = NULL;
			ValaSourceFile* file;
			ValaSourceFileType _tmp75_;
			_file_index = _file_index + 1;
			if (!(_file_index < _file_size)) {
				break;
			}
			_tmp74_ = vala_list_get (_file_list, _file_index);
			file = (ValaSourceFile*) _tmp74_;
			_tmp75_ = vala_source_file_get_file_type (file);
			if (_tmp75_ == VALA_SOURCE_FILE_TYPE_SOURCE) {
				gboolean _tmp76_;
				_tmp76_ = vala_code_context_get_save_csources (context);
				if (!_tmp76_) {
					gchar* _tmp77_ = NULL;
					gchar* _tmp78_;
					_tmp77_ = vala_source_file_get_csource_filename (file);
					_tmp78_ = _tmp77_;
					g_unlink (_tmp78_);
					_g_free0 (_tmp78_);
				}
			}
			_vala_source_file_unref0 (file);
		}
		_vala_iterable_unref0 (_file_list);
	}
	_vala_iterable_unref0 (c_source_files);
	_vala_iterable_unref0 (source_files);
	_g_free0 (cmdline);
	_g_free0 (pkgflags);
	_g_free0 (pc);
}


static void vala_value_ccode_compiler_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void vala_value_ccode_compiler_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		vala_ccode_compiler_unref (value->data[0].v_pointer);
	}
}


static void vala_value_ccode_compiler_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_ccode_compiler_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer vala_value_ccode_compiler_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* vala_value_ccode_compiler_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ValaCCodeCompiler* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_ccode_compiler_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* vala_value_ccode_compiler_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ValaCCodeCompiler** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_ccode_compiler_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* vala_param_spec_ccode_compiler (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ValaParamSpecCCodeCompiler* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_CCODE_COMPILER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer vala_value_get_ccode_compiler (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CCODE_COMPILER), NULL);
	return value->data[0].v_pointer;
}


void vala_value_set_ccode_compiler (GValue* value, gpointer v_object) {
	ValaCCodeCompiler* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CCODE_COMPILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_CCODE_COMPILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_ccode_compiler_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_ccode_compiler_unref (old);
	}
}


void vala_value_take_ccode_compiler (GValue* value, gpointer v_object) {
	ValaCCodeCompiler* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CCODE_COMPILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_CCODE_COMPILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_ccode_compiler_unref (old);
	}
}


static void vala_ccode_compiler_class_init (ValaCCodeCompilerClass * klass) {
	vala_ccode_compiler_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_COMPILER_CLASS (klass)->finalize = vala_ccode_compiler_finalize;
}


static void vala_ccode_compiler_instance_init (ValaCCodeCompiler * self) {
	self->ref_count = 1;
}


static void vala_ccode_compiler_finalize (ValaCCodeCompiler* obj) {
	ValaCCodeCompiler * self;
	self = VALA_CCODE_COMPILER (obj);
}


/**
 * Interface to the C compiler.
 */
GType vala_ccode_compiler_get_type (void) {
	static volatile gsize vala_ccode_compiler_type_id__volatile = 0;
	if (g_once_init_enter (&vala_ccode_compiler_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_ccode_compiler_init, vala_value_ccode_compiler_free_value, vala_value_ccode_compiler_copy_value, vala_value_ccode_compiler_peek_pointer, "p", vala_value_ccode_compiler_collect_value, "p", vala_value_ccode_compiler_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeCompilerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_compiler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeCompiler), 0, (GInstanceInitFunc) vala_ccode_compiler_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_ccode_compiler_type_id;
		vala_ccode_compiler_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaCCodeCompiler", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_ccode_compiler_type_id__volatile, vala_ccode_compiler_type_id);
	}
	return vala_ccode_compiler_type_id__volatile;
}


gpointer vala_ccode_compiler_ref (gpointer instance) {
	ValaCCodeCompiler* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void vala_ccode_compiler_unref (gpointer instance) {
	ValaCCodeCompiler* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_CCODE_COMPILER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



