/* clutter-1.0.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Clutter", lower_case_cprefix = "clutter_", gir_namespace = "Clutter", gir_version = "1.0")]
namespace Clutter {
	[CCode (cprefix = "ClutterFrameSource", lower_case_cprefix = "clutter_frame_source_")]
	namespace FrameSource {
		[CCode (cheader_filename = "clutter/clutter.h")]
		public static uint add (uint fps, GLib.SourceFunc func);
		[CCode (cheader_filename = "clutter/clutter.h")]
		public static uint add_full (int priority, uint fps, owned GLib.SourceFunc func);
	}
	[CCode (cprefix = "ClutterThreads", lower_case_cprefix = "clutter_threads_")]
	namespace Threads {
		[CCode (cprefix = "ClutterThreadsFrameSource", lower_case_cprefix = "clutter_threads_frame_source_")]
		namespace FrameSource {
			[CCode (cname = "clutter_threads_add_frame_source", cheader_filename = "clutter/clutter.h")]
			public static uint add (uint fps, GLib.SourceFunc func);
			[CCode (cname = "clutter_threads_add_frame_source_full", cheader_filename = "clutter/clutter.h")]
			public static uint add_full (int priority, uint fps, owned GLib.SourceFunc func);
		}
		[CCode (cprefix = "ClutterThreadsIdle", lower_case_cprefix = "clutter_threads_idle_")]
		namespace Idle {
			[CCode (cname = "clutter_threads_add_idle", cheader_filename = "clutter/clutter.h")]
			public static uint add (GLib.SourceFunc func);
			[CCode (cname = "clutter_threads_add_idle_full", cheader_filename = "clutter/clutter.h")]
			public static uint add_full (int priority, owned GLib.SourceFunc func);
		}
		[CCode (cprefix = "ClutterThreadsTimeout", lower_case_cprefix = "clutter_threads_timeout_")]
		namespace Timeout {
			[CCode (cname = "clutter_threads_add_timeout", cheader_filename = "clutter/clutter.h")]
			public static uint add (uint interval, GLib.SourceFunc func);
			[CCode (cname = "clutter_threads_add_timeout_full", cheader_filename = "clutter/clutter.h")]
			public static uint add_full (int priority, uint interval, owned GLib.SourceFunc func);
		}
		[CCode (cheader_filename = "clutter/clutter.h")]
		public static void enter ();
		[CCode (cheader_filename = "clutter/clutter.h")]
		public static void init ();
		[CCode (cheader_filename = "clutter/clutter.h")]
		public static void leave ();
		[CCode (cheader_filename = "clutter/clutter.h")]
		public static void set_lock_functions (GLib.Callback enter_fn, GLib.Callback leave_fn);
	}
	[CCode (cprefix = "ClutterUtil", lower_case_cprefix = "clutter_util_")]
	namespace Util {
		[CCode (cname = "clutter_util_next_p2", cheader_filename = "clutter/clutter.h")]
		public static int next_power_of_2 (int a);
	}
	[CCode (cprefix = "clutter_value_", lower_case_cprefix = "clutter_value_")]
	namespace Value {
		[CCode (cheader_filename = "clutter/clutter.h")]
		public static unowned Clutter.Color? get_color (GLib.Value value);
		[CCode (cheader_filename = "clutter/clutter.h")]
		public static unowned Cogl.Fixed? get_fixed (GLib.Value value);
		[CCode (cheader_filename = "clutter/clutter.h")]
		public static unowned float[] get_shader_float (GLib.Value value);
		[CCode (cheader_filename = "clutter/clutter.h")]
		public static unowned int[] get_shader_int (GLib.Value value);
		[CCode (cheader_filename = "clutter/clutter.h")]
		public static unowned float[] get_shader_matrix (GLib.Value value);
		[CCode (cheader_filename = "clutter/clutter.h")]
		public static Clutter.Units get_units (GLib.Value value);
		[CCode (cheader_filename = "clutter/clutter.h")]
		public static void set_color (GLib.Value value, Clutter.Color color);
		[CCode (cheader_filename = "clutter/clutter.h")]
		public static void set_fixed (GLib.Value value, Cogl.Fixed fixed_);
		[CCode (cheader_filename = "clutter/clutter.h")]
		public static void set_shader_float (GLib.Value value, [CCode (array_length_pos = 1.9)] float[] floats);
		[CCode (cheader_filename = "clutter/clutter.h")]
		public static void set_shader_int (GLib.Value value, [CCode (array_length_pos = 1.9)] int[] ints);
		[CCode (cheader_filename = "clutter/clutter.h")]
		public static void set_shader_matrix (GLib.Value value, [CCode (array_length_pos = 1.9)] float[] matrix);
		[CCode (cheader_filename = "clutter/clutter.h")]
		public static void set_units (GLib.Value value, Clutter.Units units);
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class Actor : GLib.InitiallyUnowned, Clutter.Scriptable {
		public uint32 flags;
		[CCode (has_construct_function = false)]
		protected Actor ();
		public virtual void allocate (Clutter.ActorBox box, Clutter.AllocationFlags flags);
		public void allocate_available_size (float x, float y, float available_width, float available_height, Clutter.AllocationFlags flags);
		public void allocate_preferred_size (Clutter.AllocationFlags flags);
		public unowned Clutter.Animation animate (ulong mode, uint duration, ...);
		public unowned Clutter.Animation animate_with_alpha (Clutter.Alpha alpha, ...);
		public unowned Clutter.Animation animate_with_alphav (Clutter.Alpha alpha, [CCode (array_length_pos = 1.9)] string[] properties, [CCode (array_length_pos = 1.9)] GLib.Value[] values);
		public unowned Clutter.Animation animate_with_timeline (ulong mode, Clutter.Timeline timeline, ...);
		public unowned Clutter.Animation animate_with_timelinev (ulong mode, Clutter.Timeline timeline, [CCode (array_length_pos = 2.9)] string[] properties, [CCode (array_length_pos = 2.9)] GLib.Value[] values);
		public unowned Clutter.Animation animatev (ulong mode, uint duration, [CCode (array_length_pos = 2.9)] string[] properties, [CCode (array_length_pos = 2.9)] GLib.Value[] values);
		public void apply_relative_transform_to_point (Clutter.Actor? ancestor, Clutter.Vertex point, out Clutter.Vertex vertex);
		[NoWrapper]
		public virtual void apply_transform (Cogl.Matrix matrix);
		public void apply_transform_to_point (Clutter.Vertex point, out Clutter.Vertex vertex);
		public unowned Pango.Context create_pango_context ();
		public unowned Pango.Layout create_pango_layout (string text);
		public void get_abs_allocation_vertices ([CCode (array_length = false)] Clutter.Vertex[] verts);
		public void get_allocation_box (out Clutter.ActorBox box);
		public void get_allocation_geometry (out Clutter.Geometry geom);
		public void get_allocation_vertices (Clutter.Actor ancestor, Clutter.Vertex[] verts);
		public void get_anchor_point (out float anchor_x, out float anchor_y);
		public Clutter.Gravity get_anchor_point_gravity ();
		public unowned Clutter.Animation get_animation ();
		[CCode (cname = "clutter_get_actor_by_gid")]
		public static unowned Clutter.Actor get_by_gid (uint32 id);
		public void get_clip (out float xoff, out float yoff, out float width, out float height);
		public Clutter.ActorFlags get_flags ();
		public void get_geometry (Clutter.Geometry geometry);
		public uint32 get_gid ();
		[CCode (cname = "clutter_actor_has_pointer")]
		public bool get_has_pointer ();
		public uchar get_paint_opacity ();
		public bool get_paint_visibility ();
		public unowned Pango.Context get_pango_context ();
		public unowned Clutter.Actor? get_parent ();
		public void get_position (out float x, out float y);
		public virtual void get_preferred_height (float for_width, out float min_height_p, out float natural_height_p);
		public void get_preferred_size (out unowned float? min_width_p, out unowned float? min_height_p, out unowned float? natural_width_p, out unowned float? natural_height_p);
		public virtual void get_preferred_width (float for_height, out float min_width_p, out float natural_width_p);
		public Clutter.RequestMode get_request_mode ();
		public double get_rotation (out Clutter.RotateAxis axis, out float x, out float y, out float z);
		public void get_scale (out double scale_x, out double scale_y);
		public void get_scale_center (out float center_x, out float center_y);
		public unowned Clutter.Shader get_shader ();
		public void get_size (out float width, out float height);
		public unowned Clutter.Stage get_stage ();
		public Clutter.TextDirection get_text_direction ();
		public void get_transformation_matrix (Cogl.Matrix matrix);
		public void get_transformed_position (out float x, out float y);
		public void get_transformed_size (out float width, out float height);
		public Clutter.Gravity get_z_rotation_gravity ();
		public void grab_key_focus ();
		public virtual void hide_all ();
		public bool is_in_clone_paint ();
		public bool is_rotated ();
		public bool is_scaled ();
		public void lower (Clutter.Actor above);
		public void lower_bottom ();
		public virtual void map ();
		public void move_anchor_point (float anchor_x, float anchor_y);
		public void move_anchor_point_from_gravity (Clutter.Gravity gravity);
		public void move_by (float dx, float dy);
		public void pop_internal ();
		public void push_internal ();
		public void queue_redraw ();
		public void raise (Clutter.Actor below);
		public void raise_top ();
		public void remove_clip ();
		public void reparent (Clutter.Actor new_parent);
		public void set_anchor_point (float anchor_x, float anchor_y);
		public void set_anchor_point_from_gravity (Clutter.Gravity gravity);
		public void set_clip (float xoff, float yoff, float width, float height);
		public void set_fixed_position_set (bool is_set);
		public void set_flags (Clutter.ActorFlags flags);
		public void set_geometry (Clutter.Geometry geometry);
		public void set_parent (Clutter.Actor parent);
		public void set_position (float x, float y);
		public void set_request_mode (Clutter.RequestMode mode);
		public void set_rotation (Clutter.RotateAxis axis, double angle, float x, float y, float z);
		public void set_scale (double scale_x, double scale_y);
		public void set_scale_full (double scale_x, double scale_y, float center_x, float center_y);
		public void set_scale_with_gravity (double scale_x, double scale_y, Clutter.Gravity gravity);
		public bool set_shader (Clutter.Shader shader);
		public void set_shader_param (string param, GLib.Value value);
		public void set_shader_param_float (string param, float value);
		public void set_shader_param_int (string param, int value);
		public void set_size (float width, float height);
		public void set_text_direction (Clutter.TextDirection text_dir);
		public void set_z_rotation_from_gravity (double angle, Clutter.Gravity gravity);
		public bool should_pick_paint ();
		public virtual void show_all ();
		public bool transform_stage_point (float x, float y, out float x_out, out float y_out);
		public virtual void unmap ();
		public void unparent ();
		public void unset_flags (Clutter.ActorFlags flags);
		[NoAccessorMethod]
		public Clutter.ActorBox allocation { get; }
		[NoAccessorMethod]
		public Clutter.Gravity anchor_gravity { get; set; }
		[NoAccessorMethod]
		public float anchor_x { get; set; }
		[NoAccessorMethod]
		public float anchor_y { get; set; }
		[NoAccessorMethod]
		public Clutter.Geometry clip { get; set; }
		[NoAccessorMethod]
		public bool clip_to_allocation { get; set; }
		public float depth { get; set; }
		public bool fixed_position_set { get; set; }
		[NoAccessorMethod]
		public float fixed_x { get; set; }
		[NoAccessorMethod]
		public float fixed_y { get; set; }
		[NoAccessorMethod]
		public bool has_clip { get; }
		[NoAccessorMethod]
		public bool has_pointer { get; }
		public float height { get; set; }
		[NoAccessorMethod]
		public bool mapped { get; }
		[NoAccessorMethod]
		public float min_height { get; set; }
		[NoAccessorMethod]
		public bool min_height_set { get; set; }
		[NoAccessorMethod]
		public float min_width { get; set; }
		[NoAccessorMethod]
		public bool min_width_set { get; set; }
		public string name { get; set; }
		[NoAccessorMethod]
		public float natural_height { get; set; }
		[NoAccessorMethod]
		public bool natural_height_set { get; set; }
		[NoAccessorMethod]
		public float natural_width { get; set; }
		[NoAccessorMethod]
		public bool natural_width_set { get; set; }
		public uint opacity { get; set; }
		public bool reactive { get; set; }
		[NoAccessorMethod]
		public bool realized { get; }
		public Clutter.RequestMode request_mode { get; set; }
		[NoAccessorMethod]
		public double rotation_angle_x { get; set; }
		[NoAccessorMethod]
		public double rotation_angle_y { get; set; }
		[NoAccessorMethod]
		public double rotation_angle_z { get; set; }
		[NoAccessorMethod]
		public Clutter.Vertex rotation_center_x { get; set; }
		[NoAccessorMethod]
		public Clutter.Vertex rotation_center_y { get; set; }
		[NoAccessorMethod]
		public Clutter.Vertex rotation_center_z { get; set; }
		[NoAccessorMethod]
		public Clutter.Gravity rotation_center_z_gravity { get; set; }
		[NoAccessorMethod]
		public float scale_center_x { get; set; }
		[NoAccessorMethod]
		public float scale_center_y { get; set; }
		[NoAccessorMethod]
		public Clutter.Gravity scale_gravity { get; set; }
		[NoAccessorMethod]
		public double scale_x { get; set; }
		[NoAccessorMethod]
		public double scale_y { get; set; }
		[NoAccessorMethod]
		public bool show_on_set_parent { get; set; }
		public Clutter.TextDirection text_direction { get; set; }
		[NoAccessorMethod]
		public bool visible { get; set; }
		public float width { get; set; }
		public float x { get; set; }
		public float y { get; set; }
		public virtual signal void allocation_changed (Clutter.ActorBox p0, Clutter.AllocationFlags p1);
		public virtual signal bool button_press_event (Clutter.ButtonEvent event);
		public virtual signal bool button_release_event (Clutter.ButtonEvent event);
		public virtual signal bool captured_event (Clutter.Event event);
		[HasEmitter]
		public virtual signal void destroy ();
		public virtual signal bool enter_event (Clutter.CrossingEvent event);
		[HasEmitter]
		public virtual signal bool event (Clutter.Event event);
		[HasEmitter]
		public virtual signal void hide ();
		public virtual signal void key_focus_in ();
		public virtual signal void key_focus_out ();
		public virtual signal bool key_press_event (Clutter.KeyEvent event);
		public virtual signal bool key_release_event (Clutter.KeyEvent event);
		public virtual signal bool leave_event (Clutter.CrossingEvent event);
		public virtual signal bool motion_event (Clutter.MotionEvent event);
		[HasEmitter]
		public virtual signal void paint ();
		public virtual signal void parent_set (Clutter.Actor? old_parent);
		[HasEmitter]
		public virtual signal void pick (Clutter.Color color);
		[HasEmitter]
		public virtual signal void queue_relayout ();
		[HasEmitter]
		public virtual signal void realize ();
		public virtual signal bool scroll_event (Clutter.ScrollEvent event);
		[HasEmitter]
		public virtual signal void show ();
		[HasEmitter]
		public virtual signal void unrealize ();
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class Alpha : GLib.InitiallyUnowned, Clutter.Scriptable {
		[CCode (has_construct_function = false)]
		public Alpha ();
		[CCode (has_construct_function = false)]
		public Alpha.full (Clutter.Timeline timeline, ulong mode);
		public static ulong register_closure (GLib.Closure closure);
		public static ulong register_func (Clutter.AlphaFunc func);
		public void set_closure (GLib.Closure closure);
		public void set_func (owned Clutter.AlphaFunc func);
		[CCode (has_construct_function = false)]
		public Alpha.with_func (Clutter.Timeline timeline, owned Clutter.AlphaFunc func);
		public double alpha { get; }
		public ulong mode { get; set construct; }
		public Clutter.Timeline timeline { get; set; }
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class Animation : GLib.Object, Clutter.Scriptable {
		[CCode (has_construct_function = false)]
		public Animation ();
		public unowned Clutter.Animation bind (string property_name, GLib.Value final);
		public unowned Clutter.Animation bind_interval (string property_name, Clutter.Interval interval);
		public unowned Clutter.Interval get_interval (string property_name);
		public bool has_property (string property_name);
		public void unbind_property (string property_name);
		public unowned Clutter.Animation update (string property_name, GLib.Value final);
		public void update_interval (string property_name, Clutter.Interval interval);
		public Clutter.Alpha alpha { get; set; }
		public uint duration { get; set; }
		public bool loop { get; set; }
		public ulong mode { get; set; }
		public GLib.Object object { get; set; }
		public Clutter.Timeline timeline { get; set; }
		[HasEmitter]
		public virtual signal void completed ();
		public virtual signal void started ();
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class Animator : GLib.Object, Clutter.Scriptable {
		[CCode (has_construct_function = false)]
		public Animator ();
		public bool compute_value (GLib.Object object, string property_name, double progress, GLib.Value value);
		public uint get_duration ();
		public GLib.List<weak Clutter.AnimatorKey> get_keys (GLib.Object object, string property_name, double progress);
		public unowned Clutter.Timeline get_timeline ();
		public bool property_get_ease_in (GLib.Object object, string property_name);
		public Clutter.Interpolation property_get_interpolation (GLib.Object object, string property_name);
		public void property_set_ease_in (GLib.Object object, string property_name, bool ease_in);
		public void property_set_interpolation (GLib.Object object, string property_name, Clutter.Interpolation interpolation);
		public void remove_key (GLib.Object object, string property_name, double progress);
		public void @set (void* first_object, string first_property_name, uint first_mode, ...);
		public void set_duration (uint duration);
		public unowned Clutter.Animator set_key (GLib.Object object, string property_name, uint mode, double progress, GLib.Value value);
		public void set_timeline (Clutter.Timeline timeline);
		public unowned Clutter.Timeline start ();
		public uint duration { get; set; }
		public Clutter.Timeline timeline { get; set; }
	}
	[Compact]
	[CCode (type_id = "CLUTTER_TYPE_ANIMATOR_KEY", cheader_filename = "clutter/clutter.h")]
	public class AnimatorKey {
		public ulong get_mode ();
		public unowned GLib.Object get_object ();
		public double get_progress ();
		public unowned string get_property_name ();
		public GLib.Type get_property_type ();
		public bool get_value (GLib.Value value);
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class Backend : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Backend ();
		[NoWrapper]
		public virtual void add_options (GLib.OptionGroup group);
		[NoWrapper]
		public virtual bool create_context () throws GLib.Error;
		[NoWrapper]
		public virtual unowned Clutter.StageWindow create_stage (Clutter.Stage wrapper) throws GLib.Error;
		[NoWrapper]
		public virtual void ensure_context (Clutter.Stage stage);
		[NoWrapper]
		public virtual unowned Clutter.DeviceManager get_device_manager ();
		public uint get_double_click_distance ();
		public uint get_double_click_time ();
		[NoWrapper]
		public virtual Clutter.FeatureFlags get_features ();
		public unowned string get_font_name ();
		public unowned Cairo.FontOptions get_font_options ();
		public double get_resolution ();
		[NoWrapper]
		public virtual void init_events ();
		[NoWrapper]
		public virtual void init_features ();
		[NoWrapper]
		public virtual bool post_parse () throws GLib.Error;
		[NoWrapper]
		public virtual bool pre_parse () throws GLib.Error;
		[NoWrapper]
		public virtual void redraw (Clutter.Stage stage);
		public void set_double_click_distance (uint distance);
		public void set_double_click_time (uint msec);
		public void set_font_name (string font_name);
		public void set_font_options (Cairo.FontOptions options);
		public void set_resolution (double dpi);
		public virtual signal void font_changed ();
		public virtual signal void resolution_changed ();
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class Behaviour : GLib.Object, Clutter.Scriptable {
		[CCode (has_construct_function = false)]
		protected Behaviour ();
		public void actors_foreach (Clutter.BehaviourForeachFunc func);
		[NoWrapper]
		public virtual void alpha_notify (double alpha_value);
		public void apply (Clutter.Actor actor);
		public unowned GLib.SList<Clutter.Actor> get_actors ();
		public int get_n_actors ();
		public unowned Clutter.Actor get_nth_actor (int index_);
		public bool is_applied (Clutter.Actor actor);
		public void remove (Clutter.Actor actor);
		public void remove_all ();
		public Clutter.Alpha alpha { get; set; }
		public virtual signal void applied (Clutter.Actor actor);
		public virtual signal void removed (Clutter.Actor actor);
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class BehaviourDepth : Clutter.Behaviour, Clutter.Scriptable {
		[CCode (type = "ClutterBehaviour*", has_construct_function = false)]
		public BehaviourDepth (Clutter.Alpha alpha, int depth_start, int depth_end);
		public void get_bounds (out int depth_start, out int depth_end);
		public void set_bounds (int depth_start, int depth_end);
		[NoAccessorMethod]
		public int depth_end { get; set; }
		[NoAccessorMethod]
		public int depth_start { get; set; }
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class BehaviourEllipse : Clutter.Behaviour, Clutter.Scriptable {
		[CCode (type = "ClutterBehaviour*", has_construct_function = false)]
		public BehaviourEllipse (Clutter.Alpha alpha, int x, int y, int width, int height, Clutter.RotateDirection direction, double start, double end);
		public double get_angle_tilt (Clutter.RotateAxis axis);
		public void get_center (out int x, out int y);
		public void get_tilt (out double angle_tilt_x, out double angle_tilt_y, out double angle_tilt_z);
		public void set_angle_tilt (Clutter.RotateAxis axis, double angle_tilt);
		public void set_center (int x, int y);
		public void set_tilt (double angle_tilt_x, double angle_tilt_y, double angle_tilt_z);
		public double angle_end { get; set; }
		public double angle_start { get; set; }
		[NoAccessorMethod]
		public double angle_tilt_x { get; set; }
		[NoAccessorMethod]
		public double angle_tilt_y { get; set; }
		[NoAccessorMethod]
		public double angle_tilt_z { get; set; }
		[NoAccessorMethod]
		public Clutter.Knot center { get; set; }
		public Clutter.RotateDirection direction { get; set; }
		public int height { get; set; }
		public int width { get; set; }
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class BehaviourOpacity : Clutter.Behaviour, Clutter.Scriptable {
		[CCode (type = "ClutterBehaviour*", has_construct_function = false)]
		public BehaviourOpacity (Clutter.Alpha alpha, uchar opacity_start, uchar opacity_end);
		public void get_bounds (out uchar opacity_start, out uchar opacity_end);
		public void set_bounds (uchar opacity_start, uchar opacity_end);
		[NoAccessorMethod]
		public uint opacity_end { get; set; }
		[NoAccessorMethod]
		public uint opacity_start { get; set; }
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class BehaviourPath : Clutter.Behaviour, Clutter.Scriptable {
		[CCode (type = "ClutterBehaviour*", has_construct_function = false)]
		public BehaviourPath (Clutter.Alpha alpha, Clutter.Path path);
		[CCode (type = "ClutterBehaviour*", has_construct_function = false)]
		public BehaviourPath.with_description (Clutter.Alpha alpha, string desc);
		[CCode (type = "ClutterBehaviour*", has_construct_function = false)]
		public BehaviourPath.with_knots (Clutter.Alpha alpha, Clutter.Knot[] knots);
		public Clutter.Path path { get; set; }
		public virtual signal void knot_reached (uint knot_num);
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class BehaviourRotate : Clutter.Behaviour, Clutter.Scriptable {
		[CCode (type = "ClutterBehaviour*", has_construct_function = false)]
		public BehaviourRotate (Clutter.Alpha alpha, Clutter.RotateAxis axis, Clutter.RotateDirection direction, double angle_start, double angle_end);
		public void get_bounds (out double angle_start, out double angle_end);
		public void get_center (out int x, out int y, out int z);
		public void set_bounds (double angle_start, double angle_end);
		public void set_center (int x, int y, int z);
		[NoAccessorMethod]
		public double angle_end { get; set; }
		[NoAccessorMethod]
		public double angle_start { get; set; }
		public Clutter.RotateAxis axis { get; set; }
		[NoAccessorMethod]
		public int center_x { get; set; }
		[NoAccessorMethod]
		public int center_y { get; set; }
		[NoAccessorMethod]
		public int center_z { get; set; }
		public Clutter.RotateDirection direction { get; set; }
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class BehaviourScale : Clutter.Behaviour, Clutter.Scriptable {
		[CCode (type = "ClutterBehaviour*", has_construct_function = false)]
		public BehaviourScale (Clutter.Alpha alpha, double x_scale_start, double y_scale_start, double x_scale_end, double y_scale_end);
		public void get_bounds (out double x_scale_start, out double y_scale_start, out double x_scale_end, out double y_scale_end);
		public void set_bounds (double x_scale_start, double y_scale_start, double x_scale_end, double y_scale_end);
		[NoAccessorMethod]
		public double x_scale_end { get; set; }
		[NoAccessorMethod]
		public double x_scale_start { get; set; }
		[NoAccessorMethod]
		public double y_scale_end { get; set; }
		[NoAccessorMethod]
		public double y_scale_start { get; set; }
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class BinLayout : Clutter.LayoutManager {
		[CCode (type = "ClutterLayoutManager*", has_construct_function = false)]
		public BinLayout (Clutter.BinAlignment x_align, Clutter.BinAlignment y_align);
		public void add (Clutter.Actor child, Clutter.BinAlignment x_align, Clutter.BinAlignment y_align);
		public void get_alignment (Clutter.Actor child, Clutter.BinAlignment x_align, Clutter.BinAlignment y_align);
		public void set_alignment (Clutter.Actor child, Clutter.BinAlignment x_align, Clutter.BinAlignment y_align);
		[NoAccessorMethod]
		public Clutter.BinAlignment x_align { get; set; }
		[NoAccessorMethod]
		public Clutter.BinAlignment y_align { get; set; }
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class BindingPool : GLib.Object {
		[CCode (has_construct_function = false)]
		public BindingPool (string name);
		public bool activate (uint key_val, Clutter.ModifierType modifiers, GLib.Object gobject);
		public void block_action (string action_name);
		public static unowned Clutter.BindingPool find (string name);
		public unowned string find_action (uint key_val, Clutter.ModifierType modifiers);
		public static unowned Clutter.BindingPool get_for_class (void* klass);
		public void install_action (string action_name, uint key_val, Clutter.ModifierType modifiers, [CCode (type = "GCallback")] owned Clutter.BindingActionFunc callback);
		public void install_closure (string action_name, uint key_val, Clutter.ModifierType modifiers, [CCode (type = "GClosure*")] owned Clutter.BindingActionFunc closure);
		public void override_action (uint key_val, Clutter.ModifierType modifiers, owned GLib.Callback callback);
		public void override_closure (uint key_val, Clutter.ModifierType modifiers, GLib.Closure closure);
		public void remove_action (uint key_val, Clutter.ModifierType modifiers);
		public void unblock_action (string action_name);
		[NoAccessorMethod]
		public string name { owned get; construct; }
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class Box : Clutter.Actor, Clutter.Scriptable, Clutter.Container {
		[CCode (type = "ClutterActor*", has_construct_function = false)]
		public Box (Clutter.LayoutManager manager);
		public void get_color (Clutter.Color color);
		public unowned Clutter.LayoutManager get_layout_manager ();
		public void pack (Clutter.Actor actor, ...);
		public void pack_after (Clutter.Actor actor, Clutter.Actor sibling, ...);
		public void pack_at (Clutter.Actor actor, int position, ...);
		public void pack_before (Clutter.Actor actor, Clutter.Actor sibling, ...);
		public void packv (Clutter.Actor actor, uint n_properties, string[] properties, GLib.Value values);
		public void set_color (Clutter.Color color);
		public void set_layout_manager (Clutter.LayoutManager manager);
		public Clutter.Color color { get; set; }
		[NoAccessorMethod]
		public bool color_set { get; set; }
		public Clutter.LayoutManager layout_manager { get; set construct; }
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class BoxLayout : Clutter.LayoutManager {
		[CCode (type = "ClutterLayoutManager*", has_construct_function = false)]
		public BoxLayout ();
		public void get_alignment (Clutter.Actor actor, Clutter.BoxAlignment x_align, Clutter.BoxAlignment y_align);
		public uint get_easing_duration ();
		public ulong get_easing_mode ();
		public bool get_expand (Clutter.Actor actor);
		public void get_fill (Clutter.Actor actor, bool x_fill, bool y_fill);
		public bool get_pack_start ();
		public uint get_spacing ();
		public bool get_use_animations ();
		public bool get_vertical ();
		public void pack (Clutter.Actor actor, bool expand, bool x_fill, bool y_fill, Clutter.BoxAlignment x_align, Clutter.BoxAlignment y_align);
		public void set_alignment (Clutter.Actor actor, Clutter.BoxAlignment x_align, Clutter.BoxAlignment y_align);
		public void set_easing_duration (uint msecs);
		public void set_easing_mode (ulong mode);
		public void set_expand (Clutter.Actor actor, bool expand);
		public void set_fill (Clutter.Actor actor, bool x_fill, bool y_fill);
		public void set_pack_start (bool pack_start);
		public void set_spacing (uint spacing);
		public void set_use_animations (bool animate);
		public void set_vertical (bool vertical);
		public uint easing_duration { get; set; }
		public ulong easing_mode { get; set; }
		public bool pack_start { get; set; }
		public uint spacing { get; set; }
		public bool use_animations { get; set; }
		public bool vertical { get; set; }
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class CairoTexture : Clutter.Texture, Clutter.Scriptable {
		[CCode (type = "ClutterActor*", has_construct_function = false)]
		public CairoTexture (uint width, uint height);
		public void clear ();
		public Cairo.Context create ();
		public Cairo.Context create_region (int x_offset, int y_offset, int width, int height);
		public void get_surface_size (out uint width, out uint height);
		public void set_surface_size (uint width, uint height);
		[NoAccessorMethod]
		public uint surface_height { get; set; }
		[NoAccessorMethod]
		public uint surface_width { get; set; }
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class ChildMeta : GLib.Object {
		[CCode (has_construct_function = false)]
		protected ChildMeta ();
		public Clutter.Actor actor { get; construct; }
		public Clutter.Container container { get; construct; }
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class Clone : Clutter.Actor, Clutter.Scriptable {
		[CCode (type = "ClutterActor*", has_construct_function = false)]
		public Clone (Clutter.Actor source);
		public Clutter.Actor source { get; set construct; }
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class DeviceManager : GLib.Object {
		[CCode (has_construct_function = false)]
		protected DeviceManager ();
		[NoWrapper]
		public virtual void add_device (Clutter.InputDevice device);
		public virtual unowned Clutter.InputDevice get_core_device (Clutter.InputDeviceType device_type);
		public static unowned Clutter.DeviceManager get_default ();
		public virtual unowned Clutter.InputDevice get_device (int device_id);
		[NoWrapper]
		public virtual unowned GLib.SList<Clutter.InputDevice> get_devices ();
		public GLib.SList<weak Clutter.InputDevice> list_devices ();
		public unowned GLib.SList<Clutter.InputDevice> peek_devices ();
		[NoWrapper]
		public virtual void remove_device (Clutter.InputDevice device);
		[NoAccessorMethod]
		public Clutter.Backend backend { owned get; construct; }
		public virtual signal void device_added (Clutter.InputDevice p0);
		public virtual signal void device_removed (Clutter.InputDevice p0);
	}
	[Compact]
	[CCode (copy_function = "clutter_event_copy", type_id = "CLUTTER_TYPE_EVENT", cheader_filename = "clutter/clutter.h")]
	public class Event {
		public Clutter.AnyEvent any;
		public Clutter.ButtonEvent button;
		public Clutter.CrossingEvent crossing;
		public Clutter.KeyEvent key;
		public Clutter.MotionEvent motion;
		public Clutter.ScrollEvent scroll;
		public Clutter.StageStateEvent stage_state;
		public Clutter.EventType type;
		[CCode (has_construct_function = false)]
		public Event (Clutter.EventType type);
		public unowned Clutter.Event copy ();
		public static unowned Clutter.Event @get ();
		public uint32 get_button ();
		public uint get_click_count ();
		public void get_coords (float x, float y);
		public unowned Clutter.InputDevice get_device ();
		public int get_device_id ();
		public Clutter.InputDeviceType get_device_type ();
		public Clutter.EventFlags get_flags ();
		public uint16 get_key_code ();
		public uint get_key_symbol ();
		public uint32 get_key_unicode ();
		public unowned Clutter.Actor get_related ();
		public Clutter.ScrollDirection get_scroll_direction ();
		public unowned Clutter.Actor get_source ();
		public unowned Clutter.Stage get_stage ();
		public Clutter.ModifierType get_state ();
		public uint32 get_time ();
		[CCode (cname = "clutter_event_type")]
		public Clutter.EventType get_type ();
		public static unowned Clutter.Event peek ();
		public void put ();
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class FixedLayout : Clutter.LayoutManager {
		[CCode (type = "ClutterLayoutManager*", has_construct_function = false)]
		public FixedLayout ();
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class FlowLayout : Clutter.LayoutManager {
		[CCode (type = "ClutterLayoutManager*", has_construct_function = false)]
		public FlowLayout (Clutter.FlowOrientation orientation);
		public float get_column_spacing ();
		public void get_column_width (float min_width, float max_width);
		public bool get_homogeneous ();
		public Clutter.FlowOrientation get_orientation ();
		public void get_row_height (float min_height, float max_height);
		public float get_row_spacing ();
		public void set_column_spacing (float spacing);
		public void set_column_width (float min_width, float max_width);
		public void set_homogeneous (bool homogeneous);
		public void set_orientation (Clutter.FlowOrientation orientation);
		public void set_row_height (float min_height, float max_height);
		public void set_row_spacing (float spacing);
		public float column_spacing { get; set; }
		public bool homogeneous { get; set; }
		[NoAccessorMethod]
		public float max_column_width { get; set; }
		[NoAccessorMethod]
		public float max_row_height { get; set; }
		[NoAccessorMethod]
		public float min_column_width { get; set; }
		[NoAccessorMethod]
		public float min_row_height { get; set; }
		public Clutter.FlowOrientation orientation { get; set construct; }
		public float row_spacing { get; set; }
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class Group : Clutter.Actor, Clutter.Scriptable, Clutter.Container {
		[CCode (type = "ClutterActor*", has_construct_function = false)]
		public Group ();
		public int get_n_children ();
		public unowned Clutter.Actor get_nth_child (int index_);
		public void remove_all ();
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class InputDevice : GLib.Object {
		[CCode (has_construct_function = false)]
		protected InputDevice ();
		public void get_device_coords (int x, int y);
		public int get_device_id ();
		public unowned string get_device_name ();
		public Clutter.InputDeviceType get_device_type ();
		[CCode (cname = "clutter_get_input_device_for_id")]
		public static unowned Clutter.InputDevice get_for_id (int id);
		public unowned Clutter.Actor get_pointer_actor ();
		public unowned Clutter.Stage get_pointer_stage ();
		public void update_from_event (Clutter.Event event, bool update_stage);
		public Clutter.InputDeviceType device_type { get; construct; }
		[NoAccessorMethod]
		public int id { get; construct; }
		[NoAccessorMethod]
		public string name { owned get; construct; }
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class Interval : GLib.InitiallyUnowned {
		[CCode (has_construct_function = false)]
		public Interval (GLib.Type gtype);
		public unowned Clutter.Interval clone ();
		public virtual bool compute_value (double factor, out GLib.Value value);
		public void get_final_value (out GLib.Value value);
		public void get_initial_value (out GLib.Value value);
		public void get_interval (...);
		public GLib.Value peek_final_value ();
		public GLib.Value peek_initial_value ();
		public static void register_progress_func (GLib.Type value_type, Clutter.ProgressFunc func);
		public void set_final_value (GLib.Value value);
		public void set_initial_value (GLib.Value value);
		public void set_interval ();
		public virtual bool validate (Clutter.ParamSpecColor pspec);
		[CCode (has_construct_function = false)]
		public Interval.with_values (GLib.Type gtype, GLib.Value initial, GLib.Value final);
		public GLib.Type value_type { get; construct; }
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class LayoutManager : GLib.InitiallyUnowned {
		public void* dummy;
		[CCode (has_construct_function = false)]
		protected LayoutManager ();
		public virtual void allocate (Clutter.Container container, Clutter.ActorBox allocation, Clutter.AllocationFlags flags);
		public virtual unowned Clutter.Alpha begin_animation (uint duration, ulong mode);
		public void child_get (Clutter.Container container, Clutter.Actor actor, ...);
		public void child_get_property (Clutter.Container container, Clutter.Actor actor, string property_name, GLib.Value value);
		public void child_set (Clutter.Container container, Clutter.Actor actor, ...);
		public void child_set_property (Clutter.Container container, Clutter.Actor actor, string property_name, GLib.Value value);
		[NoWrapper]
		public virtual unowned Clutter.LayoutMeta create_child_meta (Clutter.Container container, Clutter.Actor actor);
		public virtual void end_animation ();
		public unowned Clutter.ParamSpecColor find_child_property (string name);
		public virtual double get_animation_progress ();
		public unowned Clutter.LayoutMeta get_child_meta (Clutter.Container container, Clutter.Actor actor);
		[NoWrapper]
		public virtual GLib.Type get_child_meta_type ();
		public virtual void get_preferred_height (Clutter.Container container, float for_width, out float min_height_p, out float nat_height_p);
		public virtual void get_preferred_width (Clutter.Container container, float for_height, out float min_width_p, out float nat_width_p);
		public unowned Clutter.ParamSpecColor list_child_properties (uint n_pspecs);
		public virtual void set_container (Clutter.Container container);
		[HasEmitter]
		public virtual signal void layout_changed ();
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class LayoutMeta : Clutter.ChildMeta {
		public int32 dummy0;
		public void* dummy1;
		[CCode (has_construct_function = false)]
		protected LayoutMeta ();
		public unowned Clutter.LayoutManager get_manager ();
		public Clutter.LayoutManager manager { get; construct; }
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class ListModel : Clutter.Model, Clutter.Scriptable {
		[CCode (type = "ClutterModel*", has_construct_function = false)]
		public ListModel (uint n_columns);
		[CCode (cname = "clutter_list_model_newv", type = "ClutterModel*", has_construct_function = false)]
		public ListModel.newv ([CCode (array_length_pos = 0.9)] GLib.Type[] types, [CCode (array_length_pos = 0.9)] string[] names);
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class Model : GLib.Object, Clutter.Scriptable {
		[CCode (has_construct_function = false)]
		protected Model ();
		public void append (...);
		public void appendv ([CCode (array_length_pos = 0.9)] uint[] columns, [CCode (array_length_pos = 0.9)] GLib.Value[] values);
		public bool filter_iter (Clutter.ModelIter iter);
		public bool filter_row (uint row);
		public void @foreach (Clutter.ModelForeachFunc func);
		public virtual unowned string get_column_name (uint column);
		public virtual GLib.Type get_column_type (uint column);
		public bool get_filter_set ();
		public unowned Clutter.ModelIter get_first_iter ();
		public virtual unowned Clutter.ModelIter get_iter_at_row (uint row);
		public unowned Clutter.ModelIter get_last_iter ();
		public virtual uint get_n_columns ();
		public virtual uint get_n_rows ();
		public int get_sorting_column ();
		public void insert (uint row);
		[NoWrapper]
		public virtual unowned Clutter.ModelIter insert_row (int index_);
		public void insert_value (uint row, uint column, GLib.Value value);
		public void insertv (uint row, [CCode (array_length_pos = 1.9)] uint[] columns, [CCode (array_length_pos = 1.9)] GLib.Value[] values);
		public void prepend ();
		public void prependv (uint n_columns, uint columns, GLib.Value values);
		public void remove (uint row);
		[NoWrapper]
		public virtual void remove_row (uint row);
		public virtual void resort ();
		public void set_filter (owned Clutter.ModelFilterFunc func);
		public void set_names ([CCode (array_length_pos = 0.9)] string[] names);
		public void set_sort (uint column, owned Clutter.ModelSortFunc func);
		public void set_sorting_column (int column);
		public void set_types ([CCode (array_length_pos = 0.9)] GLib.Type[] types);
		public bool filter_set { get; }
		public virtual signal void filter_changed ();
		public virtual signal void row_added (Clutter.ModelIter iter);
		public virtual signal void row_changed (Clutter.ModelIter iter);
		public virtual signal void row_removed (Clutter.ModelIter iter);
		public virtual signal void sort_changed ();
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class ModelIter : GLib.Object {
		[CCode (has_construct_function = false)]
		protected ModelIter ();
		public virtual unowned Clutter.ModelIter copy ();
		public void @get (...);
		public virtual unowned Clutter.Model get_model ();
		public virtual uint get_row ();
		public virtual void get_value (uint column, out GLib.Value value);
		public virtual bool is_first ();
		public virtual bool is_last ();
		public virtual unowned Clutter.ModelIter next ();
		public virtual unowned Clutter.ModelIter prev ();
		public void @set (...);
		public virtual void set_value (uint column, GLib.Value value);
		[NoAccessorMethod]
		public Clutter.Model model { owned get; set; }
		[NoAccessorMethod]
		public uint row { get; set; }
	}
	[CCode (cname = "GParamSpec", cheader_filename = "clutter/clutter.h")]
	public class ParamSpecColor : GLib.ParamSpec {
		public Clutter.Color default_value;
		public weak Clutter.ParamSpecColor parent_instance;
		[CCode (cname = "clutter_param_spec_color")]
		public ParamSpecColor (string name, string nick, string blurb, Clutter.Color default_value, GLib.ParamFlags flags);
	}
	[CCode (cname = "GParamSpec", cheader_filename = "clutter/clutter.h")]
	public class ParamSpecFixed : GLib.ParamSpec {
		public Cogl.Fixed default_value;
		public Cogl.Fixed maximum;
		public Cogl.Fixed minimum;
		public weak Clutter.ParamSpecColor parent_instance;
		[CCode (cname = "clutter_param_spec_fixed")]
		public ParamSpecFixed (string name, string nick, string blurb, Cogl.Fixed minimum, Cogl.Fixed maximum, Cogl.Fixed default_value, GLib.ParamFlags flags);
	}
	[CCode (cname = "GParamSpec", cheader_filename = "clutter/clutter.h")]
	public class ParamSpecUnits : GLib.ParamSpec {
		public Clutter.UnitType default_type;
		public float default_value;
		public float maximum;
		public float minimum;
		public weak Clutter.ParamSpecColor parent_instance;
		[CCode (cname = "clutter_param_spec_units")]
		public ParamSpecUnits (string name, string nick, string blurb, Clutter.Units minimum, Clutter.Units maximum, Clutter.Units default_value, GLib.ParamFlags flags);
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class Path : GLib.InitiallyUnowned {
		[CCode (has_construct_function = false)]
		public Path ();
		public void add_cairo_path (Cairo.Path cpath);
		public void add_close ();
		public void add_curve_to (int x_1, int y_1, int x_2, int y_2, int x_3, int y_3);
		public void add_line_to (int x, int y);
		public void add_move_to (int x, int y);
		public void add_node (Clutter.PathNode node);
		public void add_rel_curve_to (int x_1, int y_1, int x_2, int y_2, int x_3, int y_3);
		public void add_rel_line_to (int x, int y);
		public void add_rel_move_to (int x, int y);
		public bool add_string (string str);
		public void clear ();
		public void @foreach (Clutter.PathCallback callback);
		public uint get_n_nodes ();
		public void get_node (uint index_, Clutter.PathNode node);
		public GLib.SList<weak Clutter.PathNode> get_nodes ();
		public uint get_position (double progress, Clutter.Knot position);
		public void insert_node (int index_, Clutter.PathNode node);
		public void remove_node (uint index_);
		public void replace_node (uint index_, Clutter.PathNode node);
		public bool set_description (string str);
		public void to_cairo_path (Cairo.Context cr);
		[CCode (has_construct_function = false)]
		public Path.with_description (string desc);
		public string description { get; set; }
		public uint length { get; }
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class Rectangle : Clutter.Actor, Clutter.Scriptable {
		[CCode (type = "ClutterActor*", has_construct_function = false)]
		public Rectangle ();
		[CCode (type = "ClutterActor*", has_construct_function = false)]
		public Rectangle.with_color (Clutter.Color color);
		public Clutter.Color border_color { get; set; }
		public uint border_width { get; set; }
		public Clutter.Color color { get; set; }
		[NoAccessorMethod]
		public bool has_border { get; set; }
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class Score : GLib.Object {
		[CCode (has_construct_function = false)]
		public Score ();
		public ulong append (Clutter.Timeline? parent, Clutter.Timeline timeline);
		public ulong append_at_marker (Clutter.Timeline parent, string marker_name, Clutter.Timeline timeline);
		public bool get_loop ();
		public unowned Clutter.Timeline get_timeline (ulong id);
		public bool is_playing ();
		public GLib.SList<weak Clutter.Timeline> list_timelines ();
		public void pause ();
		public void remove (ulong id);
		public void remove_all ();
		public void rewind ();
		public void set_loop (bool loop);
		public void start ();
		public void stop ();
		public bool loop { get; set; }
		public virtual signal void completed ();
		public virtual signal void paused ();
		public virtual signal void started ();
		public virtual signal void timeline_completed (Clutter.Timeline timeline);
		public virtual signal void timeline_started (Clutter.Timeline timeline);
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class Script : GLib.Object {
		[CCode (has_construct_function = false)]
		public Script ();
		public void add_search_paths (string[] paths);
		public void connect_signals (void* user_data);
		public void connect_signals_full (Clutter.ScriptConnectFunc func);
		public void ensure_objects ();
		public static GLib.Quark error_quark ();
		public unowned GLib.Object get_object (string name);
		public int get_objects (...);
		public virtual GLib.Type get_type_from_name (string type_name);
		public GLib.List<weak GLib.Object> list_objects ();
		public uint load_from_data (string data, ssize_t length) throws GLib.Error;
		public uint load_from_file (string filename) throws GLib.Error;
		public unowned string lookup_filename (string filename);
		public void unmerge_objects (uint merge_id);
		[NoAccessorMethod]
		public string filename { owned get; }
		[NoAccessorMethod]
		public bool filename_set { get; }
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class Shader : GLib.Object {
		[CCode (has_construct_function = false)]
		public Shader ();
		public bool compile () throws GLib.Error;
		public static GLib.Quark error_quark ();
		public Cogl.Shader get_cogl_fragment_shader ();
		public Cogl.Program get_cogl_program ();
		public Cogl.Shader get_cogl_vertex_shader ();
		public unowned string get_fragment_source ();
		public bool get_is_enabled ();
		public unowned string get_vertex_source ();
		public bool is_compiled ();
		public void release ();
		public void set_fragment_source (string data, ssize_t length);
		public void set_is_enabled (bool enabled);
		public void set_uniform (string name, GLib.Value value);
		public void set_vertex_source (string data, ssize_t length);
		[NoAccessorMethod]
		public bool compiled { get; }
		[NoAccessorMethod]
		public bool enabled { get; set; }
		public string fragment_source { get; set; }
		public string vertex_source { get; set; }
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class Stage : Clutter.Group, Clutter.Scriptable, Clutter.Container {
		[CCode (type = "ClutterActor*", has_construct_function = false)]
		public Stage ();
		[CCode (cname = "clutter_stage_event")]
		public bool emit_event (Clutter.Event event);
		public void ensure_current ();
		public void ensure_redraw ();
		public void ensure_viewport ();
		public unowned Clutter.Actor get_actor_at_pos (Clutter.PickMode pick_mode, int x, int y);
		public static unowned Clutter.Stage get_default ();
		public bool get_fullscreen ();
		public unowned Clutter.Actor get_key_focus ();
		public void get_minimum_size (uint width, uint height);
		public void get_perspective (out Clutter.Perspective perspective);
		public bool get_throttle_motion_events ();
		public bool get_use_alpha ();
		public void hide_cursor ();
		public bool is_default ();
		public void queue_redraw ();
		[CCode (array_length = false)]
		public uchar[] read_pixels (int x, int y, int width = -1, int height = -1);
		[CCode (cname = "clutter_redraw")]
		public void redraw ();
		public void set_fullscreen (bool fullscreen);
		public void set_key_focus (Clutter.Actor? actor);
		public void set_minimum_size (uint width, uint height);
		public void set_perspective (Clutter.Perspective perspective);
		public void set_throttle_motion_events (bool throttle);
		public void set_use_alpha (bool use_alpha);
		public void show_cursor ();
		public Clutter.Color color { get; set; }
		[NoAccessorMethod]
		public bool cursor_visible { get; set; }
		public Clutter.Fog fog { get; set; }
		[NoAccessorMethod]
		public bool fullscreen_set { get; }
		public Clutter.Actor key_focus { get; set; }
		[NoAccessorMethod]
		public bool offscreen { get; set; }
		[NoAccessorMethod]
		public Clutter.Perspective perspective { get; set; }
		public string title { get; set; }
		public bool use_alpha { get; set; }
		public bool use_fog { get; set; }
		public bool user_resizable { get; set; }
		public virtual signal void activate ();
		public virtual signal void deactivate ();
		public virtual signal bool delete_event (Clutter.Event event);
		[HasEmitter]
		public virtual signal void fullscreen ();
		[HasEmitter]
		public virtual signal void unfullscreen ();
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class StageManager : GLib.Object {
		[CCode (has_construct_function = false)]
		protected StageManager ();
		public static unowned Clutter.StageManager get_default ();
		public unowned GLib.SList<Clutter.Stage> list_stages ();
		public unowned GLib.SList<Clutter.Stage> peek_stages ();
		public Clutter.Stage default_stage { get; }
		public virtual signal void stage_added (Clutter.Stage stage);
		public virtual signal void stage_removed (Clutter.Stage stage);
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class Text : Clutter.Actor, Clutter.Scriptable {
		[CCode (type = "ClutterActor*", has_construct_function = false)]
		public Text ();
		public void delete_chars (uint n_chars);
		public bool delete_selection ();
		[CCode (type = "ClutterActor*", has_construct_function = false)]
		public Text.full (string font_name, string text, Clutter.Color color);
		public unowned Pango.AttrList get_attributes ();
		public unowned string get_chars (ssize_t start_pos, ssize_t end_pos);
		public int get_cursor_position ();
		public unowned Pango.FontDescription get_font_description ();
		public unowned Pango.Layout get_layout ();
		public unowned string get_selection ();
		public void insert_text (string text, ssize_t position);
		public void insert_unichar (unichar wc);
		public bool position_to_coords (int position, out float? x = null, out float? y = null, out float? line_height = null);
		public void set_attributes (Pango.AttrList attrs);
		public void set_cursor_position (int position);
		public void set_font_description (Pango.FontDescription font_desc);
		public void set_markup (string markup);
		public void set_preedit_string (string preedit_str, Pango.AttrList preedit_attrs, uint cursor_pos);
		public void set_selection (ssize_t start_pos, ssize_t end_pos);
		[CCode (type = "ClutterActor*", has_construct_function = false)]
		public Text.with_text (string? font_name, string text);
		public bool activatable { get; set; }
		public Pango.AttrList attributes { get; set; }
		public Clutter.Color color { get; set; }
		public Clutter.Color cursor_color { get; set; }
		[NoAccessorMethod]
		public bool cursor_color_set { get; }
		public int cursor_size { get; set; }
		public bool cursor_visible { get; set; }
		public bool editable { get; set; }
		public Pango.EllipsizeMode ellipsize { get; set; }
		public Pango.FontDescription font_description { get; set; }
		public string font_name { get; set; }
		public bool justify { get; set; }
		public Pango.Alignment line_alignment { get; set; }
		public bool line_wrap { get; set; }
		public Pango.WrapMode line_wrap_mode { get; set; }
		public int max_length { get; set; }
		public uint password_char { get; set; }
		[NoAccessorMethod]
		public int position { get; set; }
		public bool selectable { get; set; }
		public int selection_bound { get; set; }
		public Clutter.Color selection_color { get; set; }
		[NoAccessorMethod]
		public bool selection_color_set { get; }
		public bool single_line_mode { get; set; }
		public string text { get; set; }
		public bool use_markup { get; set; }
		[HasEmitter]
		public virtual signal void activate ();
		public virtual signal void cursor_event (Clutter.Geometry geometry);
		[HasEmitter]
		public virtual signal void delete_text (int p0, int p1);
		public virtual signal void text_changed ();
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class Texture : Clutter.Actor, Clutter.Scriptable {
		[CCode (type = "ClutterActor*", has_construct_function = false)]
		public Texture ();
		public static GLib.Quark error_quark ();
		[CCode (type = "ClutterActor*", has_construct_function = false)]
		public Texture.from_actor (Clutter.Actor actor);
		[CCode (has_construct_function = false)]
		public Texture.from_file (string filename) throws Clutter.TextureError;
		public void get_base_size (out int width, out int height);
		public void get_repeat (out bool repeat_x, out bool repeat_y);
		public bool set_area_from_rgb_data (uchar[] data, bool has_alpha, int x, int y, int width, int height, int rowstride, int bpp, Clutter.TextureFlags flags) throws GLib.Error;
		public bool set_from_file (string filename) throws GLib.Error;
		public bool set_from_rgb_data ([CCode (array_length = false)] uchar[] data, bool has_alpha, int width, int height, int rowstride, int bpp, Clutter.TextureFlags flags) throws GLib.Error;
		public bool set_from_yuv_data ([CCode (array_length = false)] uchar[] data, int width, int height, Clutter.TextureFlags flags) throws GLib.Error;
		public void set_repeat (bool repeat_x, bool repeat_y);
		public Cogl.Material cogl_material { get; set; }
		public Cogl.Texture cogl_texture { get; set; }
		[NoAccessorMethod]
		public bool disable_slicing { get; construct; }
		[NoAccessorMethod]
		public string filename { set; }
		public Clutter.TextureQuality filter_quality { get; set construct; }
		public bool keep_aspect_ratio { get; set; }
		public bool load_async { set; }
		public bool load_data_async { set; }
		public Cogl.PixelFormat pixel_format { get; }
		[NoAccessorMethod]
		public bool repeat_x { get; set; }
		[NoAccessorMethod]
		public bool repeat_y { get; set; }
		public bool sync_size { get; set; }
		[NoAccessorMethod]
		public int tile_waste { get; }
		public virtual signal void load_finished (void* error);
		public virtual signal void pixbuf_change ();
		public virtual signal void size_change (int width, int height);
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class Timeline : GLib.Object {
		[CCode (has_construct_function = false)]
		public Timeline (uint msecs);
		public void add_marker_at_time (string marker_name, uint msecs);
		public void advance (uint msecs);
		public void advance_to_marker (string marker_name);
		public unowned Clutter.Timeline clone ();
		public void do_tick (GLib.TimeVal tick_time);
		public uint get_elapsed_time ();
		public double get_progress ();
		public bool has_marker (string marker_name);
		public bool is_playing ();
		public unowned string list_markers (int msecs, size_t n_markers);
		public void pause ();
		public void remove_marker (string marker_name);
		public void rewind ();
		public void skip (uint msecs);
		public void start ();
		public void stop ();
		public uint delay { get; set; }
		public Clutter.TimelineDirection direction { get; set; }
		public uint duration { get; set; }
		public bool loop { get; set; }
		public virtual signal void completed ();
		public virtual signal void marker_reached (string marker_name, int frame_num);
		public virtual signal void new_frame (int frame_num);
		public virtual signal void paused ();
		public virtual signal void started ();
	}
	[Compact]
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class TimeoutPool {
		[CCode (has_construct_function = false)]
		public TimeoutPool (int priority);
		public uint add (uint fps, GLib.SourceFunc func, void* data, GLib.DestroyNotify notify);
		public void remove (uint id);
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public interface Animatable {
		public abstract bool animate_property (Clutter.Animation animation, string property_name, GLib.Value initial_value, GLib.Value final_value, double progress, GLib.Value value);
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public interface Container : GLib.Object {
		public void add (params Clutter.Actor[] actors);
		[CCode (vfunc_name = "add")]
		public abstract void add_actor (Clutter.Actor actor);
		public void add_valist (Clutter.Actor first_actor, void* var_args);
		public void child_get (Clutter.Actor actor, ...);
		public void child_get_property (Clutter.Actor child, string property, GLib.Value value);
		public void child_set (Clutter.Actor actor, ...);
		public void child_set_property (Clutter.Actor child, string property, GLib.Value value);
		[NoWrapper]
		public virtual void create_child_meta (Clutter.Actor actor);
		[NoWrapper]
		public virtual void destroy_child_meta (Clutter.Actor actor);
		public unowned Clutter.Actor find_child_by_name (string child_name);
		[CCode (cname = "clutter_container_class_find_child_property")]
		public class unowned Clutter.ParamSpecColor find_child_property (string property_name);
		public abstract void @foreach (Clutter.Callback callback);
		public virtual void foreach_with_internals (Clutter.Callback callback);
		public virtual unowned Clutter.ChildMeta get_child_meta (Clutter.Actor actor);
		public GLib.List<weak Clutter.Actor> get_children ();
		[CCode (cname = "clutter_container_class_list_child_properties")]
		public class unowned Clutter.ParamSpecColor list_child_properties (uint n_properties);
		[CCode (vfunc_name = "lower")]
		public virtual void lower_child (Clutter.Actor actor, Clutter.Actor? sibling = null);
		[CCode (vfunc_name = "raise")]
		public virtual void raise_child (Clutter.Actor actor, Clutter.Actor? sibling = null);
		public void remove (params Clutter.Actor[] actors);
		[CCode (vfunc_name = "remove")]
		public abstract void remove_actor (Clutter.Actor actor);
		public void remove_valist (Clutter.Actor first_actor, void* var_args);
		public virtual void sort_depth_order ();
		public signal void actor_added (Clutter.Actor actor);
		public signal void actor_removed (Clutter.Actor actor);
		public signal void child_notify (Clutter.Actor actor, Clutter.ParamSpecColor pspec);
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public interface Media {
		public double get_audio_volume ();
		public double get_buffer_fill ();
		public bool get_can_seek ();
		public double get_duration ();
		public bool get_playing ();
		public double get_progress ();
		public unowned string get_subtitle_font_name ();
		public unowned string get_subtitle_uri ();
		public unowned string get_uri ();
		public void set_audio_volume (double volume);
		public void set_filename (string filename);
		public void set_playing (bool playing);
		public void set_progress (double progress);
		public void set_subtitle_font_name (string font_name);
		public void set_subtitle_uri (string uri);
		public void set_uri (string uri);
		public signal void eos ();
		public signal void error (void* error);
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public interface Scriptable {
		public abstract unowned string get_id ();
		public abstract void set_custom_property (Clutter.Script script, string name, GLib.Value value);
		public abstract void set_id (string id);
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public interface StageWindow : GLib.Object {
		[NoWrapper]
		public abstract void add_redraw_clip (Clutter.Geometry stage_rectangle);
		[NoWrapper]
		public abstract void get_geometry (Clutter.Geometry geometry);
		[NoWrapper]
		public abstract int get_pending_swaps ();
		[NoWrapper]
		public abstract unowned Clutter.Actor get_wrapper ();
		[NoWrapper]
		public abstract bool has_redraw_clips ();
		[NoWrapper]
		public abstract void hide ();
		[NoWrapper]
		public abstract bool ignoring_redraw_clips ();
		[NoWrapper]
		public abstract bool realize ();
		[NoWrapper]
		public abstract void resize (int width, int height);
		[NoWrapper]
		public abstract void set_cursor_visible (bool cursor_visible);
		[NoWrapper]
		public abstract void set_fullscreen (bool is_fullscreen);
		[NoWrapper]
		public abstract void set_title (string title);
		[NoWrapper]
		public abstract void set_user_resizable (bool is_resizable);
		[NoWrapper]
		public abstract void show (bool do_raise);
		[NoWrapper]
		public abstract void unrealize ();
	}
	[CCode (type_id = "CLUTTER_TYPE_ACTOR_BOX", cheader_filename = "clutter/clutter.h")]
	public struct ActorBox {
		public float x1;
		public float y1;
		public float x2;
		public float y2;
		public void clamp_to_pixel ();
		public bool contains (float x, float y);
		public bool equal (Clutter.ActorBox box_b);
		[CCode (cname = "clutter_actor_box_from_vertices")]
		public ActorBox.from_vertices (Clutter.Vertex[] verts);
		public float get_area ();
		public float get_height ();
		public void get_origin (out float x, out float y);
		public void get_size (out float width, out float height);
		public float get_width ();
		public float get_x ();
		public float get_y ();
		public void interpolate (Clutter.ActorBox final, double progress, Clutter.ActorBox _result);
	}
	[CCode (type_id = "CLUTTER_TYPE_ANY_EVENT", cheader_filename = "clutter/clutter.h")]
	public struct AnyEvent {
		public Clutter.EventType type;
		public uint32 time;
		public Clutter.EventFlags flags;
		public weak Clutter.Stage stage;
		public weak Clutter.Actor source;
	}
	[CCode (type_id = "CLUTTER_TYPE_BUTTON_EVENT", cheader_filename = "clutter/clutter.h")]
	public struct ButtonEvent {
		public Clutter.EventType type;
		public uint32 time;
		public Clutter.EventFlags flags;
		public weak Clutter.Stage stage;
		public weak Clutter.Actor source;
		public float x;
		public float y;
		public Clutter.ModifierType modifier_state;
		public uint32 button;
		public uint click_count;
		public double axes;
		public weak Clutter.InputDevice device;
	}
	[CCode (type_id = "CLUTTER_TYPE_COLOR", cheader_filename = "clutter/clutter.h")]
	public struct Color {
		public static GLib.HashFunc hash;
		public static GLib.EqualFunc equal;
		public uchar red;
		public uchar green;
		public uchar blue;
		public uchar alpha;
		public void add (Clutter.Color b, out Clutter.Color _result);
		public void darken (out Clutter.Color _result);
		[CCode (cname = "clutter_color_from_hls")]
		public Color.from_hls (float hue, float luminance, float saturation);
		[CCode (cname = "clutter_color_from_pixel")]
		public Color.from_pixel (uint32 pixel);
		[CCode (cname = "clutter_color_from_string")]
		public Color.from_string (string str);
		public void lighten (out Clutter.Color _result);
		[CCode (cname = "clutter_color_from_string")]
		public bool parse_string (string str);
		public void shade (double factor, out Clutter.Color _result);
		public void subtract (Clutter.Color b, out Clutter.Color _result);
		public void to_hls (out float hue, out float luminance, out float saturation);
		public uint32 to_pixel ();
		public string to_string ();
	}
	[CCode (type_id = "CLUTTER_TYPE_CROSSING_EVENT", cheader_filename = "clutter/clutter.h")]
	public struct CrossingEvent {
		public Clutter.EventType type;
		public uint32 time;
		public Clutter.EventFlags flags;
		public weak Clutter.Stage stage;
		public weak Clutter.Actor source;
		public float x;
		public float y;
		public weak Clutter.InputDevice device;
		public weak Clutter.Actor related;
	}
	[CCode (type_id = "CLUTTER_TYPE_FOG", cheader_filename = "clutter/clutter.h")]
	public struct Fog {
		public float z_near;
		public float z_far;
	}
	[CCode (type_id = "CLUTTER_TYPE_GEOMETRY", cheader_filename = "clutter/clutter.h")]
	public struct Geometry {
		public int x;
		public int y;
		public uint width;
		public uint height;
	}
	[CCode (type_id = "CLUTTER_TYPE_KEY_EVENT", cheader_filename = "clutter/clutter.h")]
	public struct KeyEvent {
		public Clutter.EventType type;
		public uint32 time;
		public Clutter.EventFlags flags;
		public weak Clutter.Stage stage;
		public weak Clutter.Actor source;
		public Clutter.ModifierType modifier_state;
		public uint keyval;
		public uint16 hardware_keycode;
		public unichar unicode_value;
		public weak Clutter.InputDevice device;
	}
	[CCode (type_id = "CLUTTER_TYPE_KNOT", cheader_filename = "clutter/clutter.h")]
	public struct Knot {
		public int x;
		public int y;
		public Clutter.Knot copy ();
		public bool equal (Clutter.Knot knot_b);
		public void free ();
	}
	[CCode (type_id = "CLUTTER_TYPE_MOTION_EVENT", cheader_filename = "clutter/clutter.h")]
	public struct MotionEvent {
		public Clutter.EventType type;
		public uint32 time;
		public Clutter.EventFlags flags;
		public weak Clutter.Stage stage;
		public weak Clutter.Actor source;
		public float x;
		public float y;
		public Clutter.ModifierType modifier_state;
		public double axes;
		public weak Clutter.InputDevice device;
	}
	[CCode (type_id = "CLUTTER_TYPE_PATH_NODE", cheader_filename = "clutter/clutter.h")]
	public struct PathNode {
		public Clutter.PathNodeType type;
		[CCode (array_length = false)]
		public weak Clutter.Knot[] points;
		public Clutter.PathNode copy ();
		public bool equal (Clutter.PathNode node_b);
		public void free ();
	}
	[CCode (type_id = "CLUTTER_TYPE_PERSPECTIVE", cheader_filename = "clutter/clutter.h")]
	public struct Perspective {
		public float fovy;
		public float aspect;
		public float z_near;
		public float z_far;
	}
	[CCode (type_id = "CLUTTER_TYPE_SCROLL_EVENT", cheader_filename = "clutter/clutter.h")]
	public struct ScrollEvent {
		public Clutter.EventType type;
		public uint32 time;
		public Clutter.EventFlags flags;
		public weak Clutter.Stage stage;
		public weak Clutter.Actor source;
		public float x;
		public float y;
		public Clutter.ScrollDirection direction;
		public Clutter.ModifierType modifier_state;
		public double axes;
		public weak Clutter.InputDevice device;
	}
	[CCode (type_id = "CLUTTER_TYPE_STAGE_STATE_EVENT", cheader_filename = "clutter/clutter.h")]
	public struct StageStateEvent {
		public Clutter.EventType type;
		public uint32 time;
		public Clutter.EventFlags flags;
		public weak Clutter.Stage stage;
		public weak Clutter.Actor source;
		public Clutter.StageState changed_mask;
		public Clutter.StageState new_state;
	}
	[CCode (type_id = "CLUTTER_TYPE_UNITS", cheader_filename = "clutter/clutter.h")]
	public struct Units {
		public Clutter.UnitType unit_type;
		public float value;
		public float pixels;
		public uint pixels_set;
		[CCode (cname = "clutter_units_from_em")]
		public Units.from_em (float em);
		[CCode (cname = "clutter_units_from_em_for_font")]
		public Units.from_em_for_font (string font_name, float em);
		[CCode (cname = "clutter_units_from_mm")]
		public Units.from_mm (float mm);
		[CCode (cname = "clutter_units_from_pixels")]
		public Units.from_pixels (int px);
		[CCode (cname = "clutter_units_from_pt")]
		public Units.from_pt (float pt);
		[CCode (cname = "clutter_units_from_string")]
		public Units.from_string (string str);
		public Clutter.UnitType get_unit_type ();
		public float get_unit_value ();
		public float to_pixels ();
		public unowned string to_string ();
	}
	[CCode (type_id = "CLUTTER_TYPE_VERTEX", cheader_filename = "clutter/clutter.h")]
	public struct Vertex {
		public float x;
		public float y;
		public float z;
		public bool equal (Clutter.Vertex vertex_b);
	}
	[CCode (cprefix = "CLUTTER_ACTOR_", cheader_filename = "clutter/clutter.h")]
	[Flags]
	public enum ActorFlags {
		MAPPED,
		REALIZED,
		REACTIVE,
		VISIBLE,
		NO_LAYOUT
	}
	[CCode (cprefix = "CLUTTER_", cheader_filename = "clutter/clutter.h")]
	[Flags]
	public enum AllocationFlags {
		ALLOCATION_NONE,
		ABSOLUTE_ORIGIN_CHANGED
	}
	[CCode (cprefix = "CLUTTER_", cheader_filename = "clutter/clutter.h")]
	public enum AnimationMode {
		CUSTOM_MODE,
		LINEAR,
		EASE_IN_QUAD,
		EASE_OUT_QUAD,
		EASE_IN_OUT_QUAD,
		EASE_IN_CUBIC,
		EASE_OUT_CUBIC,
		EASE_IN_OUT_CUBIC,
		EASE_IN_QUART,
		EASE_OUT_QUART,
		EASE_IN_OUT_QUART,
		EASE_IN_QUINT,
		EASE_OUT_QUINT,
		EASE_IN_OUT_QUINT,
		EASE_IN_SINE,
		EASE_OUT_SINE,
		EASE_IN_OUT_SINE,
		EASE_IN_EXPO,
		EASE_OUT_EXPO,
		EASE_IN_OUT_EXPO,
		EASE_IN_CIRC,
		EASE_OUT_CIRC,
		EASE_IN_OUT_CIRC,
		EASE_IN_ELASTIC,
		EASE_OUT_ELASTIC,
		EASE_IN_OUT_ELASTIC,
		EASE_IN_BACK,
		EASE_OUT_BACK,
		EASE_IN_OUT_BACK,
		EASE_IN_BOUNCE,
		EASE_OUT_BOUNCE,
		EASE_IN_OUT_BOUNCE,
		ANIMATION_LAST
	}
	[CCode (cprefix = "CLUTTER_BIN_ALIGNMENT_", cheader_filename = "clutter/clutter.h")]
	public enum BinAlignment {
		FIXED,
		FILL,
		START,
		END,
		CENTER
	}
	[CCode (cprefix = "CLUTTER_BOX_ALIGNMENT_", cheader_filename = "clutter/clutter.h")]
	public enum BoxAlignment {
		START,
		END,
		CENTER
	}
	[CCode (cprefix = "CLUTTER_EVENT_", cheader_filename = "clutter/clutter.h")]
	[Flags]
	public enum EventFlags {
		NONE,
		FLAG_SYNTHETIC
	}
	[CCode (cprefix = "CLUTTER_", cheader_filename = "clutter/clutter.h")]
	public enum EventType {
		NOTHING,
		KEY_PRESS,
		KEY_RELEASE,
		MOTION,
		ENTER,
		LEAVE,
		BUTTON_PRESS,
		BUTTON_RELEASE,
		SCROLL,
		STAGE_STATE,
		DESTROY_NOTIFY,
		CLIENT_MESSAGE,
		DELETE
	}
	[CCode (cprefix = "CLUTTER_FEATURE_", cheader_filename = "clutter/clutter.h")]
	[Flags]
	public enum FeatureFlags {
		TEXTURE_NPOT,
		SYNC_TO_VBLANK,
		TEXTURE_YUV,
		TEXTURE_READ_PIXELS,
		STAGE_STATIC,
		STAGE_USER_RESIZE,
		STAGE_CURSOR,
		SHADERS_GLSL,
		OFFSCREEN,
		STAGE_MULTIPLE;
		[CCode (cname = "clutter_feature_available")]
		public bool is_available ();
		[CCode (cname = "clutter_feature_get_all")]
		public static Clutter.FeatureFlags @get ();
	}
	[CCode (cprefix = "CLUTTER_FLOW_", cheader_filename = "clutter/clutter.h")]
	public enum FlowOrientation {
		HORIZONTAL,
		VERTICAL
	}
	[CCode (cprefix = "CLUTTER_FONT_", cheader_filename = "clutter/clutter.h")]
	[Flags]
	public enum FontFlags {
		MIPMAPPING,
		HINTING
	}
	[CCode (cprefix = "CLUTTER_GRAVITY_", cheader_filename = "clutter/clutter.h")]
	public enum Gravity {
		NONE,
		NORTH,
		NORTH_EAST,
		EAST,
		SOUTH_EAST,
		SOUTH,
		SOUTH_WEST,
		WEST,
		NORTH_WEST,
		CENTER
	}
	[CCode (cprefix = "CLUTTER_INIT_", cheader_filename = "clutter/clutter.h")]
	public enum InitError {
		SUCCESS,
		ERROR_UNKNOWN,
		ERROR_THREADS,
		ERROR_BACKEND,
		ERROR_INTERNAL
	}
	[CCode (cprefix = "CLUTTER_", cheader_filename = "clutter/clutter.h")]
	public enum InputDeviceType {
		POINTER_DEVICE,
		KEYBOARD_DEVICE,
		EXTENSION_DEVICE,
		N_DEVICE_TYPES
	}
	[CCode (cprefix = "CLUTTER_INTERPOLATION_", cheader_filename = "clutter/clutter.h")]
	public enum Interpolation {
		LINEAR,
		CUBIC
	}
	[CCode (cprefix = "CLUTTER_", cheader_filename = "clutter/clutter.h")]
	[Flags]
	public enum ModifierType {
		SHIFT_MASK,
		LOCK_MASK,
		CONTROL_MASK,
		MOD1_MASK,
		MOD2_MASK,
		MOD3_MASK,
		MOD4_MASK,
		MOD5_MASK,
		BUTTON1_MASK,
		BUTTON2_MASK,
		BUTTON3_MASK,
		BUTTON4_MASK,
		BUTTON5_MASK,
		SUPER_MASK,
		HYPER_MASK,
		META_MASK,
		RELEASE_MASK,
		MODIFIER_MASK
	}
	[CCode (cprefix = "CLUTTER_PATH_", cheader_filename = "clutter/clutter.h")]
	public enum PathNodeType {
		MOVE_TO,
		LINE_TO,
		CURVE_TO,
		CLOSE,
		REL_MOVE_TO,
		REL_LINE_TO,
		REL_CURVE_TO
	}
	[CCode (cprefix = "CLUTTER_PICK_", cheader_filename = "clutter/clutter.h")]
	public enum PickMode {
		NONE,
		REACTIVE,
		ALL
	}
	[CCode (cprefix = "CLUTTER_REDRAW_CLIPPED_TO_", cheader_filename = "clutter/clutter.h")]
	[Flags]
	public enum RedrawFlags {
		BOX,
		ALLOCATION
	}
	[CCode (cprefix = "CLUTTER_REQUEST_", cheader_filename = "clutter/clutter.h")]
	public enum RequestMode {
		HEIGHT_FOR_WIDTH,
		WIDTH_FOR_HEIGHT
	}
	[CCode (cprefix = "CLUTTER_", cheader_filename = "clutter/clutter.h")]
	public enum RotateAxis {
		X_AXIS,
		Y_AXIS,
		Z_AXIS
	}
	[CCode (cprefix = "CLUTTER_ROTATE_", cheader_filename = "clutter/clutter.h")]
	public enum RotateDirection {
		CW,
		CCW
	}
	[CCode (cprefix = "CLUTTER_SCRIPT_ERROR_INVALID_", cheader_filename = "clutter/clutter.h")]
	public enum ScriptError {
		TYPE_FUNCTION,
		PROPERTY,
		VALUE
	}
	[CCode (cprefix = "CLUTTER_SCROLL_", cheader_filename = "clutter/clutter.h")]
	public enum ScrollDirection {
		UP,
		DOWN,
		LEFT,
		RIGHT
	}
	[CCode (cprefix = "CLUTTER_STAGE_STATE_", cheader_filename = "clutter/clutter.h")]
	[Flags]
	public enum StageState {
		FULLSCREEN,
		OFFSCREEN,
		ACTIVATED
	}
	[CCode (cprefix = "CLUTTER_TEXT_DIRECTION_", cheader_filename = "clutter/clutter.h")]
	public enum TextDirection {
		DEFAULT,
		LTR,
		RTL
	}
	[CCode (cprefix = "CLUTTER_TEXTURE_", cheader_filename = "clutter/clutter.h")]
	[Flags]
	public enum TextureFlags {
		NONE,
		RGB_FLAG_BGR,
		RGB_FLAG_PREMULT,
		YUV_FLAG_YUV2
	}
	[CCode (cprefix = "CLUTTER_TEXTURE_QUALITY_", cheader_filename = "clutter/clutter.h")]
	public enum TextureQuality {
		LOW,
		MEDIUM,
		HIGH
	}
	[CCode (cprefix = "CLUTTER_TIMELINE_", cheader_filename = "clutter/clutter.h")]
	public enum TimelineDirection {
		FORWARD,
		BACKWARD
	}
	[CCode (cprefix = "CLUTTER_UNIT_", cheader_filename = "clutter/clutter.h")]
	public enum UnitType {
		PIXEL,
		EM,
		MM,
		POINT,
		CM
	}
	[CCode (cprefix = "CLUTTER_X11_FILTER_", cheader_filename = "clutter/clutter.h")]
	public enum X11FilterReturn {
		CONTINUE,
		TRANSLATE,
		REMOVE
	}
	[CCode (cprefix = "CLUTTER_X11_XINPUT_", cheader_filename = "clutter/clutter.h")]
	public enum X11XInputEventTypes {
		KEY_PRESS_EVENT,
		KEY_RELEASE_EVENT,
		BUTTON_PRESS_EVENT,
		BUTTON_RELEASE_EVENT,
		MOTION_NOTIFY_EVENT,
		LAST_EVENT
	}
	[CCode (cprefix = "CLUTTER_SHADER_ERROR_", cheader_filename = "clutter/clutter.h")]
	public errordomain ShaderError {
		NO_ASM,
		NO_GLSL,
		COMPILE,
	}
	[CCode (cprefix = "CLUTTER_TEXTURE_ERROR_", cheader_filename = "clutter/clutter.h")]
	public errordomain TextureError {
		OUT_OF_MEMORY,
		NO_YUV,
		BAD_FORMAT,
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public delegate double AlphaFunc (Clutter.Alpha alpha);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public delegate void BehaviourForeachFunc (Clutter.Behaviour behaviour, Clutter.Actor actor);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public delegate bool BindingActionFunc (GLib.Object gobject, string action_name, uint key_val, Clutter.ModifierType modifiers);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public delegate void Callback (Clutter.Actor actor);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public delegate bool ModelFilterFunc (Clutter.Model model, Clutter.ModelIter iter);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public delegate bool ModelForeachFunc (Clutter.Model model, Clutter.ModelIter iter);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public delegate int ModelSortFunc (Clutter.Model model, GLib.Value a, GLib.Value b);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public delegate void PathCallback (Clutter.PathNode node);
	[CCode (cheader_filename = "clutter/clutter.h", has_target = false)]
	public delegate bool ProgressFunc (GLib.Value a, GLib.Value b, double progress, GLib.Value retval);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public delegate void ScriptConnectFunc (Clutter.Script script, GLib.Object object, string signal_name, string handler_name, GLib.Object connect_object, GLib.ConnectFlags flags);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const string COGL;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int CURRENT_TIME;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const string FLAVOUR;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int MAJOR_VERSION;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int MICRO_VERSION;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int MINOR_VERSION;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int PATH_RELATIVE;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int PRIORITY_REDRAW;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int VERSION_HEX;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const string VERSION_S;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static void base_init ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static void cairo_set_source_color (Cairo.Context cr, Clutter.Color color);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static bool check_version (uint major, uint minor, uint micro);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static void clear_glyph_cache ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static void do_event (Clutter.Event event);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static bool events_pending ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static unowned Clutter.Event get_current_event ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static uint32 get_current_event_time ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static bool get_debug_enabled ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static unowned Clutter.Backend get_default_backend ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static uint get_default_frame_rate ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static Clutter.TextDirection get_default_text_direction ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static Clutter.FontFlags get_font_flags ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static unowned Pango.FontMap get_font_map ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static unowned Clutter.Actor get_keyboard_grab ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static bool get_motion_events_enabled ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static GLib.OptionGroup get_option_group ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static GLib.OptionGroup get_option_group_without_init ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static unowned Clutter.Actor get_pointer_grab ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static unowned string get_script_id (GLib.Object gobject);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static bool get_show_fps ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static ulong get_timestamp ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static void grab_keyboard (Clutter.Actor actor);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static void grab_pointer (Clutter.Actor actor);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static void grab_pointer_for_device (Clutter.Actor actor, int id);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static Clutter.InitError init ([CCode (array_length_pos = 0.9)] ref unowned string[] argv);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static GLib.Quark init_error_quark ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static Clutter.InitError init_with_args ([CCode (array_length_pos = 0.9)] ref unowned string[] argv, string parameter_string, GLib.OptionEntry entries, string translation_domain) throws GLib.Error;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static uint32 keysym_to_unicode (uint keyval);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static void main ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static int main_level ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static void main_quit ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static GLib.Type param_units_get_type ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static void set_default_frame_rate (uint frames_per_sec);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static void set_font_flags (Clutter.FontFlags flags);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static void set_motion_events_enabled (bool enable);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static uint threads_add_repaint_func (GLib.SourceFunc func, void* data, GLib.DestroyNotify notify);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static void threads_remove_repaint_func (uint handle_id);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static void ungrab_keyboard ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static void ungrab_pointer ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static void ungrab_pointer_for_device (int id);
}
