/* valagsignalmodule.c generated by valac, the Vala compiler
 * generated from valagsignalmodule.vala, do not modify */

/* valagsignalmodule.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <valaccode.h>
#include <valagee.h>
#include <stdlib.h>
#include <string.h>


#define VALA_TYPE_CCODE_BASE_MODULE (vala_ccode_base_module_get_type ())
#define VALA_CCODE_BASE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModule))
#define VALA_CCODE_BASE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModuleClass))
#define VALA_IS_CCODE_BASE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_BASE_MODULE))
#define VALA_IS_CCODE_BASE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_BASE_MODULE))
#define VALA_CCODE_BASE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModuleClass))

typedef struct _ValaCCodeBaseModule ValaCCodeBaseModule;
typedef struct _ValaCCodeBaseModuleClass ValaCCodeBaseModuleClass;
typedef struct _ValaCCodeBaseModulePrivate ValaCCodeBaseModulePrivate;

#define VALA_CCODE_BASE_MODULE_TYPE_EMIT_CONTEXT (vala_ccode_base_module_emit_context_get_type ())
#define VALA_CCODE_BASE_MODULE_EMIT_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_CCODE_BASE_MODULE_TYPE_EMIT_CONTEXT, ValaCCodeBaseModuleEmitContext))
#define VALA_CCODE_BASE_MODULE_EMIT_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_CCODE_BASE_MODULE_TYPE_EMIT_CONTEXT, ValaCCodeBaseModuleEmitContextClass))
#define VALA_CCODE_BASE_MODULE_IS_EMIT_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_CCODE_BASE_MODULE_TYPE_EMIT_CONTEXT))
#define VALA_CCODE_BASE_MODULE_IS_EMIT_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_CCODE_BASE_MODULE_TYPE_EMIT_CONTEXT))
#define VALA_CCODE_BASE_MODULE_EMIT_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_CCODE_BASE_MODULE_TYPE_EMIT_CONTEXT, ValaCCodeBaseModuleEmitContextClass))

typedef struct _ValaCCodeBaseModuleEmitContext ValaCCodeBaseModuleEmitContext;
typedef struct _ValaCCodeBaseModuleEmitContextClass ValaCCodeBaseModuleEmitContextClass;

#define VALA_TYPE_CCODE_STRUCT_MODULE (vala_ccode_struct_module_get_type ())
#define VALA_CCODE_STRUCT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModule))
#define VALA_CCODE_STRUCT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModuleClass))
#define VALA_IS_CCODE_STRUCT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_STRUCT_MODULE))
#define VALA_IS_CCODE_STRUCT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_STRUCT_MODULE))
#define VALA_CCODE_STRUCT_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModuleClass))

typedef struct _ValaCCodeStructModule ValaCCodeStructModule;
typedef struct _ValaCCodeStructModuleClass ValaCCodeStructModuleClass;
typedef struct _ValaCCodeStructModulePrivate ValaCCodeStructModulePrivate;

#define VALA_TYPE_CCODE_METHOD_MODULE (vala_ccode_method_module_get_type ())
#define VALA_CCODE_METHOD_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModule))
#define VALA_CCODE_METHOD_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModuleClass))
#define VALA_IS_CCODE_METHOD_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_METHOD_MODULE))
#define VALA_IS_CCODE_METHOD_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_METHOD_MODULE))
#define VALA_CCODE_METHOD_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModuleClass))

typedef struct _ValaCCodeMethodModule ValaCCodeMethodModule;
typedef struct _ValaCCodeMethodModuleClass ValaCCodeMethodModuleClass;
typedef struct _ValaCCodeMethodModulePrivate ValaCCodeMethodModulePrivate;

#define VALA_TYPE_CCODE_CONTROL_FLOW_MODULE (vala_ccode_control_flow_module_get_type ())
#define VALA_CCODE_CONTROL_FLOW_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModule))
#define VALA_CCODE_CONTROL_FLOW_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModuleClass))
#define VALA_IS_CCODE_CONTROL_FLOW_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE))
#define VALA_IS_CCODE_CONTROL_FLOW_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE))
#define VALA_CCODE_CONTROL_FLOW_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModuleClass))

typedef struct _ValaCCodeControlFlowModule ValaCCodeControlFlowModule;
typedef struct _ValaCCodeControlFlowModuleClass ValaCCodeControlFlowModuleClass;
typedef struct _ValaCCodeControlFlowModulePrivate ValaCCodeControlFlowModulePrivate;

#define VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE (vala_ccode_member_access_module_get_type ())
#define VALA_CCODE_MEMBER_ACCESS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModule))
#define VALA_CCODE_MEMBER_ACCESS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModuleClass))
#define VALA_IS_CCODE_MEMBER_ACCESS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE))
#define VALA_IS_CCODE_MEMBER_ACCESS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE))
#define VALA_CCODE_MEMBER_ACCESS_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModuleClass))

typedef struct _ValaCCodeMemberAccessModule ValaCCodeMemberAccessModule;
typedef struct _ValaCCodeMemberAccessModuleClass ValaCCodeMemberAccessModuleClass;
typedef struct _ValaCCodeMemberAccessModulePrivate ValaCCodeMemberAccessModulePrivate;

#define VALA_TYPE_CCODE_ASSIGNMENT_MODULE (vala_ccode_assignment_module_get_type ())
#define VALA_CCODE_ASSIGNMENT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_ASSIGNMENT_MODULE, ValaCCodeAssignmentModule))
#define VALA_CCODE_ASSIGNMENT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_ASSIGNMENT_MODULE, ValaCCodeAssignmentModuleClass))
#define VALA_IS_CCODE_ASSIGNMENT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_ASSIGNMENT_MODULE))
#define VALA_IS_CCODE_ASSIGNMENT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_ASSIGNMENT_MODULE))
#define VALA_CCODE_ASSIGNMENT_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_ASSIGNMENT_MODULE, ValaCCodeAssignmentModuleClass))

typedef struct _ValaCCodeAssignmentModule ValaCCodeAssignmentModule;
typedef struct _ValaCCodeAssignmentModuleClass ValaCCodeAssignmentModuleClass;
typedef struct _ValaCCodeAssignmentModulePrivate ValaCCodeAssignmentModulePrivate;

#define VALA_TYPE_CCODE_METHOD_CALL_MODULE (vala_ccode_method_call_module_get_type ())
#define VALA_CCODE_METHOD_CALL_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModule))
#define VALA_CCODE_METHOD_CALL_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModuleClass))
#define VALA_IS_CCODE_METHOD_CALL_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_METHOD_CALL_MODULE))
#define VALA_IS_CCODE_METHOD_CALL_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_METHOD_CALL_MODULE))
#define VALA_CCODE_METHOD_CALL_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModuleClass))

typedef struct _ValaCCodeMethodCallModule ValaCCodeMethodCallModule;
typedef struct _ValaCCodeMethodCallModuleClass ValaCCodeMethodCallModuleClass;
typedef struct _ValaCCodeMethodCallModulePrivate ValaCCodeMethodCallModulePrivate;

#define VALA_TYPE_CCODE_ARRAY_MODULE (vala_ccode_array_module_get_type ())
#define VALA_CCODE_ARRAY_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_ARRAY_MODULE, ValaCCodeArrayModule))
#define VALA_CCODE_ARRAY_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_ARRAY_MODULE, ValaCCodeArrayModuleClass))
#define VALA_IS_CCODE_ARRAY_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_ARRAY_MODULE))
#define VALA_IS_CCODE_ARRAY_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_ARRAY_MODULE))
#define VALA_CCODE_ARRAY_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_ARRAY_MODULE, ValaCCodeArrayModuleClass))

typedef struct _ValaCCodeArrayModule ValaCCodeArrayModule;
typedef struct _ValaCCodeArrayModuleClass ValaCCodeArrayModuleClass;
typedef struct _ValaCCodeArrayModulePrivate ValaCCodeArrayModulePrivate;

#define VALA_TYPE_CCODE_DELEGATE_MODULE (vala_ccode_delegate_module_get_type ())
#define VALA_CCODE_DELEGATE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_DELEGATE_MODULE, ValaCCodeDelegateModule))
#define VALA_CCODE_DELEGATE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_DELEGATE_MODULE, ValaCCodeDelegateModuleClass))
#define VALA_IS_CCODE_DELEGATE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_DELEGATE_MODULE))
#define VALA_IS_CCODE_DELEGATE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_DELEGATE_MODULE))
#define VALA_CCODE_DELEGATE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_DELEGATE_MODULE, ValaCCodeDelegateModuleClass))

typedef struct _ValaCCodeDelegateModule ValaCCodeDelegateModule;
typedef struct _ValaCCodeDelegateModuleClass ValaCCodeDelegateModuleClass;
typedef struct _ValaCCodeDelegateModulePrivate ValaCCodeDelegateModulePrivate;

#define VALA_TYPE_GERROR_MODULE (vala_gerror_module_get_type ())
#define VALA_GERROR_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GERROR_MODULE, ValaGErrorModule))
#define VALA_GERROR_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GERROR_MODULE, ValaGErrorModuleClass))
#define VALA_IS_GERROR_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GERROR_MODULE))
#define VALA_IS_GERROR_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GERROR_MODULE))
#define VALA_GERROR_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GERROR_MODULE, ValaGErrorModuleClass))

typedef struct _ValaGErrorModule ValaGErrorModule;
typedef struct _ValaGErrorModuleClass ValaGErrorModuleClass;
typedef struct _ValaGErrorModulePrivate ValaGErrorModulePrivate;

#define VALA_TYPE_GTYPE_MODULE (vala_gtype_module_get_type ())
#define VALA_GTYPE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GTYPE_MODULE, ValaGTypeModule))
#define VALA_GTYPE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GTYPE_MODULE, ValaGTypeModuleClass))
#define VALA_IS_GTYPE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GTYPE_MODULE))
#define VALA_IS_GTYPE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GTYPE_MODULE))
#define VALA_GTYPE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GTYPE_MODULE, ValaGTypeModuleClass))

typedef struct _ValaGTypeModule ValaGTypeModule;
typedef struct _ValaGTypeModuleClass ValaGTypeModuleClass;
typedef struct _ValaGTypeModulePrivate ValaGTypeModulePrivate;

#define VALA_TYPE_TYPEREGISTER_FUNCTION (vala_typeregister_function_get_type ())
#define VALA_TYPEREGISTER_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPEREGISTER_FUNCTION, ValaTypeRegisterFunction))
#define VALA_TYPEREGISTER_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPEREGISTER_FUNCTION, ValaTypeRegisterFunctionClass))
#define VALA_IS_TYPEREGISTER_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPEREGISTER_FUNCTION))
#define VALA_IS_TYPEREGISTER_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPEREGISTER_FUNCTION))
#define VALA_TYPEREGISTER_FUNCTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPEREGISTER_FUNCTION, ValaTypeRegisterFunctionClass))

typedef struct _ValaTypeRegisterFunction ValaTypeRegisterFunction;
typedef struct _ValaTypeRegisterFunctionClass ValaTypeRegisterFunctionClass;

#define VALA_TYPE_GOBJECT_MODULE (vala_gobject_module_get_type ())
#define VALA_GOBJECT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GOBJECT_MODULE, ValaGObjectModule))
#define VALA_GOBJECT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GOBJECT_MODULE, ValaGObjectModuleClass))
#define VALA_IS_GOBJECT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GOBJECT_MODULE))
#define VALA_IS_GOBJECT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GOBJECT_MODULE))
#define VALA_GOBJECT_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GOBJECT_MODULE, ValaGObjectModuleClass))

typedef struct _ValaGObjectModule ValaGObjectModule;
typedef struct _ValaGObjectModuleClass ValaGObjectModuleClass;
typedef struct _ValaGObjectModulePrivate ValaGObjectModulePrivate;

#define VALA_TYPE_GSIGNAL_MODULE (vala_gsignal_module_get_type ())
#define VALA_GSIGNAL_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GSIGNAL_MODULE, ValaGSignalModule))
#define VALA_GSIGNAL_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GSIGNAL_MODULE, ValaGSignalModuleClass))
#define VALA_IS_GSIGNAL_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GSIGNAL_MODULE))
#define VALA_IS_GSIGNAL_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GSIGNAL_MODULE))
#define VALA_GSIGNAL_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GSIGNAL_MODULE, ValaGSignalModuleClass))

typedef struct _ValaGSignalModule ValaGSignalModule;
typedef struct _ValaGSignalModuleClass ValaGSignalModuleClass;
typedef struct _ValaGSignalModulePrivate ValaGSignalModulePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))

struct _ValaCCodeBaseModule {
	ValaCodeGenerator parent_instance;
	ValaCCodeBaseModulePrivate * priv;
	ValaSymbol* root_symbol;
	ValaCCodeBaseModuleEmitContext* emit_context;
	ValaCCodeFile* header_file;
	ValaCCodeFile* internal_header_file;
	ValaCCodeFile* cfile;
	ValaCCodeBaseModuleEmitContext* class_init_context;
	ValaCCodeBaseModuleEmitContext* base_init_context;
	ValaCCodeBaseModuleEmitContext* class_finalize_context;
	ValaCCodeBaseModuleEmitContext* base_finalize_context;
	ValaCCodeBaseModuleEmitContext* instance_init_context;
	ValaCCodeBaseModuleEmitContext* instance_finalize_context;
	ValaCCodeStruct* param_spec_struct;
	ValaCCodeStruct* closure_struct;
	ValaCCodeEnum* prop_enum;
	ValaSet* user_marshal_set;
	ValaSet* predefined_marshal_set;
	gint next_regex_id;
	gboolean in_constructor;
	gboolean in_static_or_class_context;
	gint next_coroutine_state;
	ValaDataType* void_type;
	ValaDataType* bool_type;
	ValaDataType* char_type;
	ValaDataType* uchar_type;
	ValaDataType* unichar_type;
	ValaDataType* short_type;
	ValaDataType* ushort_type;
	ValaDataType* int_type;
	ValaDataType* uint_type;
	ValaDataType* long_type;
	ValaDataType* ulong_type;
	ValaDataType* int8_type;
	ValaDataType* uint8_type;
	ValaDataType* int16_type;
	ValaDataType* uint16_type;
	ValaDataType* int32_type;
	ValaDataType* uint32_type;
	ValaDataType* int64_type;
	ValaDataType* uint64_type;
	ValaDataType* string_type;
	ValaDataType* regex_type;
	ValaDataType* float_type;
	ValaDataType* double_type;
	ValaTypeSymbol* gtype_type;
	ValaTypeSymbol* gobject_type;
	ValaErrorType* gerror_type;
	ValaClass* glist_type;
	ValaClass* gslist_type;
	ValaClass* gnode_type;
	ValaClass* gvaluearray_type;
	ValaTypeSymbol* gstringbuilder_type;
	ValaTypeSymbol* garray_type;
	ValaTypeSymbol* gbytearray_type;
	ValaTypeSymbol* gptrarray_type;
	ValaTypeSymbol* gthreadpool_type;
	ValaDataType* gquark_type;
	ValaStruct* gvalue_type;
	ValaClass* gvariant_type;
	ValaStruct* mutex_type;
	ValaTypeSymbol* type_module_type;
	ValaTypeSymbol* dbus_proxy_type;
	ValaTypeSymbol* dbus_object_type;
	gboolean in_plugin;
	gchar* module_init_param_name;
	gboolean gvaluecollector_h_needed;
	gboolean requires_array_free;
	gboolean requires_array_move;
	gboolean requires_array_length;
	ValaSet* wrappers;
};

struct _ValaCCodeBaseModuleClass {
	ValaCodeGeneratorClass parent_class;
	void (*append_vala_array_free) (ValaCCodeBaseModule* self);
	void (*append_vala_array_move) (ValaCCodeBaseModule* self);
	void (*append_vala_array_length) (ValaCCodeBaseModule* self);
	gboolean (*generate_enum_declaration) (ValaCCodeBaseModule* self, ValaEnum* en, ValaCCodeFile* decl_space);
	void (*generate_class_struct_declaration) (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeFile* decl_space);
	void (*generate_struct_declaration) (ValaCCodeBaseModule* self, ValaStruct* st, ValaCCodeFile* decl_space);
	void (*generate_delegate_declaration) (ValaCCodeBaseModule* self, ValaDelegate* d, ValaCCodeFile* decl_space);
	void (*generate_cparameters) (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeFile* decl_space, ValaMap* cparam_map, ValaCCodeFunction* func, ValaCCodeFunctionDeclarator* vdeclarator, ValaMap* carg_map, ValaCCodeFunctionCall* vcall, gint direction);
	ValaCCodeExpression* (*get_dup_func_expression) (ValaCCodeBaseModule* self, ValaDataType* type, ValaSourceReference* source_reference, gboolean is_chainup);
	gchar* (*append_struct_array_free) (ValaCCodeBaseModule* self, ValaStruct* st);
	ValaCCodeExpression* (*destroy_value) (ValaCCodeBaseModule* self, ValaTargetValue* value, gboolean is_macro_definition);
	void (*append_local_free) (ValaCCodeBaseModule* self, ValaSymbol* sym, gboolean stop_at_loop);
	gchar* (*get_delegate_target_cname) (ValaCCodeBaseModule* self, const gchar* delegate_cname);
	ValaCCodeExpression* (*get_delegate_target_cexpression) (ValaCCodeBaseModule* self, ValaExpression* delegate_expr, ValaCCodeExpression** delegate_target_destroy_notify);
	ValaCCodeExpression* (*get_delegate_target_cvalue) (ValaCCodeBaseModule* self, ValaTargetValue* value);
	ValaCCodeExpression* (*get_delegate_target_destroy_notify_cvalue) (ValaCCodeBaseModule* self, ValaTargetValue* value);
	gchar* (*get_delegate_target_destroy_notify_cname) (ValaCCodeBaseModule* self, const gchar* delegate_cname);
	ValaCCodeExpression* (*get_ref_cexpression) (ValaCCodeBaseModule* self, ValaDataType* expression_type, ValaCCodeExpression* cexpr, ValaExpression* expr, ValaCodeNode* node);
	void (*generate_class_declaration) (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeFile* decl_space);
	void (*generate_interface_declaration) (ValaCCodeBaseModule* self, ValaInterface* iface, ValaCCodeFile* decl_space);
	void (*generate_method_declaration) (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeFile* decl_space);
	void (*generate_error_domain_declaration) (ValaCCodeBaseModule* self, ValaErrorDomain* edomain, ValaCCodeFile* decl_space);
	ValaCCodeExpression* (*deserialize_expression) (ValaCCodeBaseModule* self, ValaDataType* type, ValaCCodeExpression* variant_expr, ValaCCodeExpression* expr);
	ValaCCodeExpression* (*serialize_expression) (ValaCCodeBaseModule* self, ValaDataType* type, ValaCCodeExpression* expr);
	ValaCCodeExpression* (*get_implicit_cast_expression) (ValaCCodeBaseModule* self, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr);
	gboolean (*is_gobject_property) (ValaCCodeBaseModule* self, ValaProperty* prop);
	gchar* (*get_custom_creturn_type) (ValaCCodeBaseModule* self, ValaMethod* m);
	void (*generate_dynamic_method_wrapper) (ValaCCodeBaseModule* self, ValaDynamicMethod* method);
	gboolean (*method_has_wrapper) (ValaCCodeBaseModule* self, ValaMethod* method);
	ValaCCodeFunctionCall* (*get_param_spec) (ValaCCodeBaseModule* self, ValaProperty* prop);
	ValaCCodeFunctionCall* (*get_signal_creation) (ValaCCodeBaseModule* self, ValaSignal* sig, ValaTypeSymbol* type);
	void (*register_dbus_info) (ValaCCodeBaseModule* self, ValaObjectTypeSymbol* bindable);
	gchar* (*get_dynamic_property_getter_cname) (ValaCCodeBaseModule* self, ValaDynamicProperty* node);
	gchar* (*get_dynamic_property_setter_cname) (ValaCCodeBaseModule* self, ValaDynamicProperty* node);
	gchar* (*get_dynamic_signal_cname) (ValaCCodeBaseModule* self, ValaDynamicSignal* node);
	gchar* (*get_dynamic_signal_connect_wrapper_name) (ValaCCodeBaseModule* self, ValaDynamicSignal* node);
	gchar* (*get_dynamic_signal_connect_after_wrapper_name) (ValaCCodeBaseModule* self, ValaDynamicSignal* node);
	gchar* (*get_dynamic_signal_disconnect_wrapper_name) (ValaCCodeBaseModule* self, ValaDynamicSignal* node);
	void (*generate_marshaller) (ValaCCodeBaseModule* self, ValaList* params, ValaDataType* return_type, gboolean dbus);
	gchar* (*get_marshaller_function) (ValaCCodeBaseModule* self, ValaList* params, ValaDataType* return_type, const gchar* prefix, gboolean dbus);
	gchar* (*get_array_length_cname) (ValaCCodeBaseModule* self, const gchar* array_cname, gint dim);
	gchar* (*get_parameter_array_length_cname) (ValaCCodeBaseModule* self, ValaParameter* param, gint dim);
	ValaCCodeExpression* (*get_array_length_cexpression) (ValaCCodeBaseModule* self, ValaExpression* array_expr, gint dim);
	ValaCCodeExpression* (*get_array_length_cvalue) (ValaCCodeBaseModule* self, ValaTargetValue* value, gint dim);
	gchar* (*get_array_size_cname) (ValaCCodeBaseModule* self, const gchar* array_cname);
	void (*add_simple_check) (ValaCCodeBaseModule* self, ValaCodeNode* node, gboolean always_fails);
	gchar* (*generate_ready_function) (ValaCCodeBaseModule* self, ValaMethod* m);
};

struct _ValaCCodeStructModule {
	ValaCCodeBaseModule parent_instance;
	ValaCCodeStructModulePrivate * priv;
};

struct _ValaCCodeStructModuleClass {
	ValaCCodeBaseModuleClass parent_class;
};

struct _ValaCCodeMethodModule {
	ValaCCodeStructModule parent_instance;
	ValaCCodeMethodModulePrivate * priv;
};

struct _ValaCCodeMethodModuleClass {
	ValaCCodeStructModuleClass parent_class;
	void (*generate_method_result_declaration) (ValaCCodeMethodModule* self, ValaMethod* m, ValaCCodeFile* decl_space, ValaCCodeFunction* cfunc, ValaMap* cparam_map, ValaMap* carg_map);
	ValaCCodeParameter* (*generate_parameter) (ValaCCodeMethodModule* self, ValaParameter* param, ValaCCodeFile* decl_space, ValaMap* cparam_map, ValaMap* carg_map);
};

struct _ValaCCodeControlFlowModule {
	ValaCCodeMethodModule parent_instance;
	ValaCCodeControlFlowModulePrivate * priv;
};

struct _ValaCCodeControlFlowModuleClass {
	ValaCCodeMethodModuleClass parent_class;
};

struct _ValaCCodeMemberAccessModule {
	ValaCCodeControlFlowModule parent_instance;
	ValaCCodeMemberAccessModulePrivate * priv;
};

struct _ValaCCodeMemberAccessModuleClass {
	ValaCCodeControlFlowModuleClass parent_class;
};

struct _ValaCCodeAssignmentModule {
	ValaCCodeMemberAccessModule parent_instance;
	ValaCCodeAssignmentModulePrivate * priv;
};

struct _ValaCCodeAssignmentModuleClass {
	ValaCCodeMemberAccessModuleClass parent_class;
};

struct _ValaCCodeMethodCallModule {
	ValaCCodeAssignmentModule parent_instance;
	ValaCCodeMethodCallModulePrivate * priv;
};

struct _ValaCCodeMethodCallModuleClass {
	ValaCCodeAssignmentModuleClass parent_class;
};

struct _ValaCCodeArrayModule {
	ValaCCodeMethodCallModule parent_instance;
	ValaCCodeArrayModulePrivate * priv;
};

struct _ValaCCodeArrayModuleClass {
	ValaCCodeMethodCallModuleClass parent_class;
};

struct _ValaCCodeDelegateModule {
	ValaCCodeArrayModule parent_instance;
	ValaCCodeDelegateModulePrivate * priv;
};

struct _ValaCCodeDelegateModuleClass {
	ValaCCodeArrayModuleClass parent_class;
};

struct _ValaGErrorModule {
	ValaCCodeDelegateModule parent_instance;
	ValaGErrorModulePrivate * priv;
};

struct _ValaGErrorModuleClass {
	ValaCCodeDelegateModuleClass parent_class;
	void (*return_with_exception) (ValaGErrorModule* self, ValaCCodeExpression* error_expr);
};

struct _ValaGTypeModule {
	ValaGErrorModule parent_instance;
	ValaGTypeModulePrivate * priv;
};

struct _ValaGTypeModuleClass {
	ValaGErrorModuleClass parent_class;
	void (*generate_virtual_method_declaration) (ValaGTypeModule* self, ValaMethod* m, ValaCCodeFile* decl_space, ValaCCodeStruct* type_struct);
	void (*generate_class_init) (ValaGTypeModule* self, ValaClass* cl);
	ValaTypeRegisterFunction* (*create_interface_register_function) (ValaGTypeModule* self, ValaInterface* iface);
};

struct _ValaGObjectModule {
	ValaGTypeModule parent_instance;
	ValaGObjectModulePrivate * priv;
};

struct _ValaGObjectModuleClass {
	ValaGTypeModuleClass parent_class;
};

struct _ValaGSignalModule {
	ValaGObjectModule parent_instance;
	ValaGSignalModulePrivate * priv;
};

struct _ValaGSignalModuleClass {
	ValaGObjectModuleClass parent_class;
	ValaCCodeExpression* (*get_dbus_g_type) (ValaGSignalModule* self, ValaDataType* data_type);
};


static gpointer vala_gsignal_module_parent_class = NULL;

GType vala_ccode_base_module_get_type (void) G_GNUC_CONST;
gpointer vala_ccode_base_module_emit_context_ref (gpointer instance);
void vala_ccode_base_module_emit_context_unref (gpointer instance);
GParamSpec* vala_ccode_base_module_param_spec_emit_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_ccode_base_module_value_set_emit_context (GValue* value, gpointer v_object);
void vala_ccode_base_module_value_take_emit_context (GValue* value, gpointer v_object);
gpointer vala_ccode_base_module_value_get_emit_context (const GValue* value);
GType vala_ccode_base_module_emit_context_get_type (void) G_GNUC_CONST;
GType vala_ccode_struct_module_get_type (void) G_GNUC_CONST;
GType vala_ccode_method_module_get_type (void) G_GNUC_CONST;
GType vala_ccode_control_flow_module_get_type (void) G_GNUC_CONST;
GType vala_ccode_member_access_module_get_type (void) G_GNUC_CONST;
GType vala_ccode_assignment_module_get_type (void) G_GNUC_CONST;
GType vala_ccode_method_call_module_get_type (void) G_GNUC_CONST;
GType vala_ccode_array_module_get_type (void) G_GNUC_CONST;
GType vala_ccode_delegate_module_get_type (void) G_GNUC_CONST;
GType vala_gerror_module_get_type (void) G_GNUC_CONST;
GType vala_gtype_module_get_type (void) G_GNUC_CONST;
gpointer vala_typeregister_function_ref (gpointer instance);
void vala_typeregister_function_unref (gpointer instance);
GParamSpec* vala_param_spec_typeregister_function (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_typeregister_function (GValue* value, gpointer v_object);
void vala_value_take_typeregister_function (GValue* value, gpointer v_object);
gpointer vala_value_get_typeregister_function (const GValue* value);
GType vala_typeregister_function_get_type (void) G_GNUC_CONST;
GType vala_gobject_module_get_type (void) G_GNUC_CONST;
GType vala_gsignal_module_get_type (void) G_GNUC_CONST;
enum  {
	VALA_GSIGNAL_MODULE_DUMMY_PROPERTY
};
static gchar* vala_gsignal_module_get_marshaller_type_name (ValaGSignalModule* self, ValaDataType* t, gboolean dbus);
gchar* vala_dbus_module_get_type_signature (ValaDataType* datatype);
static gchar* vala_gsignal_module_get_marshaller_type_name_for_parameter (ValaGSignalModule* self, ValaParameter* param, gboolean dbus);
static gchar* vala_gsignal_module_real_get_marshaller_function (ValaCCodeBaseModule* base, ValaList* params, ValaDataType* return_type, const gchar* prefix, gboolean dbus);
static gchar* vala_gsignal_module_get_marshaller_signature (ValaGSignalModule* self, ValaList* params, ValaDataType* return_type, gboolean dbus);
static gchar* vala_gsignal_module_get_value_type_name_from_type_reference (ValaGSignalModule* self, ValaDataType* t);
static gchar* vala_gsignal_module_get_value_type_name_from_parameter (ValaGSignalModule* self, ValaParameter* p);
static ValaCCodeExpression* vala_gsignal_module_get_signal_name_cexpression (ValaGSignalModule* self, ValaSignal* sig, ValaExpression* detail_expr, ValaCodeNode* node);
ValaLocalVariable* vala_ccode_base_module_get_temp_variable (ValaCCodeBaseModule* self, ValaDataType* type, gboolean value_owned, ValaCodeNode* node_reference, gboolean init);
void vala_ccode_base_module_emit_temp_var (ValaCCodeBaseModule* self, ValaLocalVariable* local);
ValaArrayList* vala_ccode_base_module_get_temp_ref_vars (ValaCCodeBaseModule* self);
ValaCCodeExpression* vala_ccode_base_module_get_cvalue (ValaCCodeBaseModule* self, ValaExpression* expr);
ValaCCodeExpression* vala_ccode_base_module_get_variable_cexpression (ValaCCodeBaseModule* self, const gchar* name);
static void vala_gsignal_module_real_visit_signal (ValaCodeVisitor* base, ValaSignal* sig);
ValaCCodeParameter* vala_ccode_method_module_generate_parameter (ValaCCodeMethodModule* self, ValaParameter* param, ValaCCodeFile* decl_space, ValaMap* cparam_map, ValaMap* carg_map);
void vala_ccode_base_module_generate_marshaller (ValaCCodeBaseModule* self, ValaList* params, ValaDataType* return_type, gboolean dbus);
static void vala_gsignal_module_real_generate_marshaller (ValaCCodeBaseModule* base, ValaList* params, ValaDataType* return_type, gboolean dbus);
gchar* vala_ccode_base_module_get_marshaller_function (ValaCCodeBaseModule* self, ValaList* params, ValaDataType* return_type, const gchar* prefix, gboolean dbus);
static ValaCCodeFunctionCall* vala_gsignal_module_real_get_signal_creation (ValaCCodeBaseModule* base, ValaSignal* sig, ValaTypeSymbol* type);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add4 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add5 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add6 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add7 (gchar*** array, int* length, int* size, gchar* value);
ValaCCodeExpression* vala_gsignal_module_get_dbus_g_type (ValaGSignalModule* self, ValaDataType* data_type);
static ValaCCodeExpression* vala_gsignal_module_real_get_dbus_g_type (ValaGSignalModule* self, ValaDataType* data_type);
static void vala_gsignal_module_real_visit_element_access (ValaCodeVisitor* base, ValaElementAccess* expr);
void vala_ccode_base_module_set_cvalue (ValaCCodeBaseModule* self, ValaExpression* expr, ValaCCodeExpression* cvalue);
static gboolean vala_gsignal_module_in_gobject_instance (ValaGSignalModule* self, ValaMethod* m);
static void vala_gsignal_module_emit_signal_assignment (ValaGSignalModule* self, ValaAssignment* assignment);
static ValaCCodeExpression* vala_gsignal_module_connect_signal (ValaGSignalModule* self, ValaSignal* sig, ValaExpression* signal_access, ValaExpression* handler, gboolean disconnect, gboolean after, ValaCodeNode* expr);
static void vala_gsignal_module_real_visit_assignment (ValaCodeVisitor* base, ValaAssignment* assignment);
static void vala_gsignal_module_real_visit_member_access (ValaCodeVisitor* base, ValaMemberAccess* expr);
ValaClass* vala_ccode_base_module_get_current_class (ValaCCodeBaseModule* self);
static void vala_gsignal_module_real_visit_method_call (ValaCodeVisitor* base, ValaMethodCall* expr);
gchar* vala_ccode_base_module_get_dynamic_signal_connect_wrapper_name (ValaCCodeBaseModule* self, ValaDynamicSignal* node);
gchar* vala_ccode_base_module_get_dynamic_signal_connect_after_wrapper_name (ValaCCodeBaseModule* self, ValaDynamicSignal* node);
gchar* vala_ccode_base_module_get_dynamic_signal_disconnect_wrapper_name (ValaCCodeBaseModule* self, ValaDynamicSignal* node);
ValaCCodeExpression* vala_ccode_base_module_get_ccodenode (ValaCCodeBaseModule* self, ValaExpression* node);
ValaCCodeExpression* vala_ccode_base_module_get_result_cexpression (ValaCCodeBaseModule* self, const gchar* cname);
ValaCCodeFunction* vala_ccode_base_module_get_ccode (ValaCCodeBaseModule* self);
ValaCCodeExpression* vala_ccode_base_module_get_delegate_target_cexpression (ValaCCodeBaseModule* self, ValaExpression* delegate_expr, ValaCCodeExpression** delegate_target_destroy_notify);
ValaGSignalModule* vala_gsignal_module_new (void);
ValaGSignalModule* vala_gsignal_module_construct (GType object_type);
ValaGObjectModule* vala_gobject_module_new (void);
ValaGObjectModule* vala_gobject_module_construct (GType object_type);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


static gchar* vala_gsignal_module_get_marshaller_type_name (ValaGSignalModule* self, ValaDataType* t, gboolean dbus) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (t != NULL, NULL);
	if (VALA_IS_POINTER_TYPE (t)) {
		_tmp0_ = TRUE;
	} else {
		ValaTypeParameter* _tmp1_ = NULL;
		_tmp1_ = vala_data_type_get_type_parameter (t);
		_tmp0_ = _tmp1_ != NULL;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("POINTER");
		result = _tmp2_;
		return result;
	} else {
		if (VALA_IS_ERROR_TYPE (t)) {
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("POINTER");
			result = _tmp3_;
			return result;
		} else {
			if (VALA_IS_ARRAY_TYPE (t)) {
				if (dbus) {
					gchar* _tmp4_;
					_tmp4_ = g_strdup ("BOXED");
					result = _tmp4_;
					return result;
				} else {
					ValaDataType* _tmp5_ = NULL;
					ValaTypeSymbol* _tmp6_ = NULL;
					ValaTypeSymbol* _tmp7_ = NULL;
					_tmp5_ = vala_array_type_get_element_type (VALA_ARRAY_TYPE (t));
					_tmp6_ = vala_data_type_get_data_type (_tmp5_);
					_tmp7_ = vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->string_type);
					if (_tmp6_ == _tmp7_) {
						gchar* _tmp8_;
						_tmp8_ = g_strdup ("BOXED,INT");
						result = _tmp8_;
						return result;
					} else {
						gchar* _tmp9_;
						_tmp9_ = g_strdup ("POINTER,INT");
						result = _tmp9_;
						return result;
					}
				}
			} else {
				if (VALA_IS_VOID_TYPE (t)) {
					gchar* _tmp10_;
					_tmp10_ = g_strdup ("VOID");
					result = _tmp10_;
					return result;
				} else {
					gboolean _tmp11_ = FALSE;
					if (dbus) {
						gchar* _tmp12_ = NULL;
						gchar* _tmp13_;
						gboolean _tmp14_;
						_tmp12_ = vala_dbus_module_get_type_signature (t);
						_tmp13_ = _tmp12_;
						_tmp14_ = g_str_has_prefix (_tmp13_, "(");
						_tmp11_ = _tmp14_;
						_g_free0 (_tmp13_);
					} else {
						_tmp11_ = FALSE;
					}
					if (_tmp11_) {
						gchar* _tmp15_;
						_tmp15_ = g_strdup ("BOXED");
						result = _tmp15_;
						return result;
					} else {
						ValaTypeSymbol* _tmp16_ = NULL;
						_tmp16_ = vala_data_type_get_data_type (t);
						if (VALA_IS_ENUM (_tmp16_)) {
							ValaTypeSymbol* _tmp17_ = NULL;
							ValaEnum* _tmp18_;
							ValaEnum* en;
							_tmp17_ = vala_data_type_get_data_type (t);
							_tmp18_ = _vala_code_node_ref0 (VALA_ENUM (_tmp17_));
							en = _tmp18_;
							if (dbus) {
								gboolean _tmp19_;
								_tmp19_ = vala_enum_get_is_flags (en);
								if (_tmp19_) {
									gchar* _tmp20_;
									_tmp20_ = g_strdup ("UINT");
									result = _tmp20_;
									_vala_code_node_unref0 (en);
									return result;
								} else {
									gchar* _tmp21_;
									_tmp21_ = g_strdup ("INT");
									result = _tmp21_;
									_vala_code_node_unref0 (en);
									return result;
								}
							} else {
								gchar* _tmp22_ = NULL;
								_tmp22_ = vala_typesymbol_get_marshaller_type_name ((ValaTypeSymbol*) en);
								result = _tmp22_;
								_vala_code_node_unref0 (en);
								return result;
							}
							_vala_code_node_unref0 (en);
						} else {
							ValaTypeSymbol* _tmp23_ = NULL;
							gchar* _tmp24_ = NULL;
							_tmp23_ = vala_data_type_get_data_type (t);
							_tmp24_ = vala_typesymbol_get_marshaller_type_name (_tmp23_);
							result = _tmp24_;
							return result;
						}
					}
				}
			}
		}
	}
}


static gchar* vala_gsignal_module_get_marshaller_type_name_for_parameter (ValaGSignalModule* self, ValaParameter* param, gboolean dbus) {
	gchar* result = NULL;
	ValaParameterDirection _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (param != NULL, NULL);
	_tmp0_ = vala_parameter_get_direction (param);
	if (_tmp0_ != VALA_PARAMETER_DIRECTION_IN) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("POINTER");
		result = _tmp1_;
		return result;
	} else {
		ValaDataType* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		_tmp2_ = vala_variable_get_variable_type ((ValaVariable*) param);
		_tmp3_ = vala_gsignal_module_get_marshaller_type_name (self, _tmp2_, dbus);
		result = _tmp3_;
		return result;
	}
}


static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GRegex* _tmp2_ = NULL;
	GRegex* _tmp3_;
	GRegex* regex;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	_tmp0_ = g_regex_escape_string (old, -1);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_regex_new (_tmp1_, 0, 0, &_inner_error_);
	regex = (_tmp3_ = _tmp2_, _g_free0 (_tmp1_), _tmp3_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch4_g_regex_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp4_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
	_tmp5_ = _tmp4_;
	if (_inner_error_ != NULL) {
		_g_regex_unref0 (regex);
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch4_g_regex_error;
		}
		_g_regex_unref0 (regex);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = _tmp5_;
	_g_regex_unref0 (regex);
	return result;
	_g_regex_unref0 (regex);
	goto __finally4;
	__catch4_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally4:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gchar* vala_gsignal_module_real_get_marshaller_function (ValaCCodeBaseModule* base, ValaList* params, ValaDataType* return_type, const gchar* prefix, gboolean dbus) {
	ValaGSignalModule * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* signature;
	gchar* ret;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gboolean _tmp6_ = FALSE;
	self = (ValaGSignalModule*) base;
	g_return_val_if_fail (params != NULL, NULL);
	g_return_val_if_fail (return_type != NULL, NULL);
	_tmp0_ = vala_gsignal_module_get_marshaller_signature (self, params, return_type, dbus);
	signature = _tmp0_;
	ret = NULL;
	if (prefix == NULL) {
		gboolean _tmp1_;
		_tmp1_ = vala_collection_contains ((ValaCollection*) ((ValaCCodeBaseModule*) self)->predefined_marshal_set, signature);
		if (_tmp1_) {
			prefix = "g_cclosure_marshal";
		} else {
			prefix = "g_cclosure_user_marshal";
		}
	}
	_tmp2_ = vala_gsignal_module_get_marshaller_type_name (self, return_type, dbus);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("%s_%s_", prefix, _tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (ret);
	ret = _tmp5_;
	_g_free0 (_tmp3_);
	if (params == NULL) {
		_tmp6_ = TRUE;
	} else {
		gint _tmp7_;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) params);
		_tmp6_ = _tmp7_ == 0;
	}
	if (_tmp6_) {
		gchar* _tmp8_;
		_tmp8_ = g_strconcat (ret, "_VOID", NULL);
		_g_free0 (ret);
		ret = _tmp8_;
	} else {
		{
			ValaList* _tmp9_;
			ValaList* _p_list;
			gint _tmp10_;
			gint _p_size;
			gint _p_index;
			_tmp9_ = _vala_iterable_ref0 (params);
			_p_list = _tmp9_;
			_tmp10_ = vala_collection_get_size ((ValaCollection*) _p_list);
			_p_size = _tmp10_;
			_p_index = -1;
			while (TRUE) {
				gpointer _tmp11_ = NULL;
				ValaParameter* p;
				gchar* _tmp12_ = NULL;
				gchar* _tmp13_;
				gchar* _tmp14_ = NULL;
				gchar* _tmp15_;
				gchar* _tmp16_ = NULL;
				gchar* _tmp17_;
				_p_index = _p_index + 1;
				if (!(_p_index < _p_size)) {
					break;
				}
				_tmp11_ = vala_list_get (_p_list, _p_index);
				p = (ValaParameter*) _tmp11_;
				_tmp12_ = vala_gsignal_module_get_marshaller_type_name_for_parameter (self, p, dbus);
				_tmp13_ = _tmp12_;
				_tmp14_ = string_replace (_tmp13_, ",", "_");
				_tmp15_ = _tmp14_;
				_tmp16_ = g_strdup_printf ("%s_%s", ret, _tmp15_);
				_tmp17_ = _tmp16_;
				_g_free0 (ret);
				ret = _tmp17_;
				_g_free0 (_tmp15_);
				_g_free0 (_tmp13_);
				_vala_code_node_unref0 (p);
			}
			_vala_iterable_unref0 (_p_list);
		}
	}
	result = ret;
	_g_free0 (signature);
	return result;
}


static gchar* vala_gsignal_module_get_value_type_name_from_type_reference (ValaGSignalModule* self, ValaDataType* t) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (t != NULL, NULL);
	if (VALA_IS_POINTER_TYPE (t)) {
		_tmp0_ = TRUE;
	} else {
		ValaTypeParameter* _tmp1_ = NULL;
		_tmp1_ = vala_data_type_get_type_parameter (t);
		_tmp0_ = _tmp1_ != NULL;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("gpointer");
		result = _tmp2_;
		return result;
	} else {
		if (VALA_IS_VOID_TYPE (t)) {
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("void");
			result = _tmp3_;
			return result;
		} else {
			ValaTypeSymbol* _tmp4_ = NULL;
			ValaTypeSymbol* _tmp5_ = NULL;
			_tmp4_ = vala_data_type_get_data_type (t);
			_tmp5_ = vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->string_type);
			if (_tmp4_ == _tmp5_) {
				gchar* _tmp6_;
				_tmp6_ = g_strdup ("const char*");
				result = _tmp6_;
				return result;
			} else {
				gboolean _tmp7_ = FALSE;
				ValaTypeSymbol* _tmp8_ = NULL;
				_tmp8_ = vala_data_type_get_data_type (t);
				if (VALA_IS_CLASS (_tmp8_)) {
					_tmp7_ = TRUE;
				} else {
					ValaTypeSymbol* _tmp9_ = NULL;
					_tmp9_ = vala_data_type_get_data_type (t);
					_tmp7_ = VALA_IS_INTERFACE (_tmp9_);
				}
				if (_tmp7_) {
					gchar* _tmp10_;
					_tmp10_ = g_strdup ("gpointer");
					result = _tmp10_;
					return result;
				} else {
					ValaTypeSymbol* _tmp11_ = NULL;
					_tmp11_ = vala_data_type_get_data_type (t);
					if (VALA_IS_STRUCT (_tmp11_)) {
						ValaTypeSymbol* _tmp12_ = NULL;
						ValaStruct* _tmp13_;
						ValaStruct* st;
						gboolean _tmp14_;
						_tmp12_ = vala_data_type_get_data_type (t);
						_tmp13_ = _vala_code_node_ref0 (VALA_STRUCT (_tmp12_));
						st = _tmp13_;
						_tmp14_ = vala_struct_is_simple_type (st);
						if (_tmp14_) {
							ValaTypeSymbol* _tmp15_ = NULL;
							gchar* _tmp16_ = NULL;
							_tmp15_ = vala_data_type_get_data_type (t);
							_tmp16_ = vala_typesymbol_get_cname (_tmp15_, FALSE);
							result = _tmp16_;
							_vala_code_node_unref0 (st);
							return result;
						} else {
							gchar* _tmp17_;
							_tmp17_ = g_strdup ("gpointer");
							result = _tmp17_;
							_vala_code_node_unref0 (st);
							return result;
						}
						_vala_code_node_unref0 (st);
					} else {
						ValaTypeSymbol* _tmp18_ = NULL;
						_tmp18_ = vala_data_type_get_data_type (t);
						if (VALA_IS_ENUM (_tmp18_)) {
							gchar* _tmp19_;
							_tmp19_ = g_strdup ("gint");
							result = _tmp19_;
							return result;
						} else {
							if (VALA_IS_ARRAY_TYPE (t)) {
								gchar* _tmp20_;
								_tmp20_ = g_strdup ("gpointer");
								result = _tmp20_;
								return result;
							} else {
								if (VALA_IS_ERROR_TYPE (t)) {
									gchar* _tmp21_;
									_tmp21_ = g_strdup ("gpointer");
									result = _tmp21_;
									return result;
								}
							}
						}
					}
				}
			}
		}
	}
	result = NULL;
	return result;
}


static gchar* vala_gsignal_module_get_value_type_name_from_parameter (ValaGSignalModule* self, ValaParameter* p) {
	gchar* result = NULL;
	ValaParameterDirection _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (p != NULL, NULL);
	_tmp0_ = vala_parameter_get_direction (p);
	if (_tmp0_ != VALA_PARAMETER_DIRECTION_IN) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("gpointer");
		result = _tmp1_;
		return result;
	} else {
		ValaDataType* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		_tmp2_ = vala_variable_get_variable_type ((ValaVariable*) p);
		_tmp3_ = vala_gsignal_module_get_value_type_name_from_type_reference (self, _tmp2_);
		result = _tmp3_;
		return result;
	}
}


static gchar* vala_gsignal_module_get_marshaller_signature (ValaGSignalModule* self, ValaList* params, ValaDataType* return_type, gboolean dbus) {
	gchar* result = NULL;
	gchar* signature;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (params != NULL, NULL);
	g_return_val_if_fail (return_type != NULL, NULL);
	signature = NULL;
	_tmp0_ = vala_gsignal_module_get_marshaller_type_name (self, return_type, dbus);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("%s:", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (signature);
	signature = _tmp3_;
	_g_free0 (_tmp1_);
	if (params == NULL) {
		_tmp4_ = TRUE;
	} else {
		gint _tmp5_;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) params);
		_tmp4_ = _tmp5_ == 0;
	}
	if (_tmp4_) {
		gchar* _tmp6_;
		_tmp6_ = g_strconcat (signature, "VOID", NULL);
		_g_free0 (signature);
		signature = _tmp6_;
	} else {
		gboolean first;
		first = TRUE;
		{
			ValaList* _tmp7_;
			ValaList* _p_list;
			gint _tmp8_;
			gint _p_size;
			gint _p_index;
			_tmp7_ = _vala_iterable_ref0 (params);
			_p_list = _tmp7_;
			_tmp8_ = vala_collection_get_size ((ValaCollection*) _p_list);
			_p_size = _tmp8_;
			_p_index = -1;
			while (TRUE) {
				gpointer _tmp9_ = NULL;
				ValaParameter* p;
				_p_index = _p_index + 1;
				if (!(_p_index < _p_size)) {
					break;
				}
				_tmp9_ = vala_list_get (_p_list, _p_index);
				p = (ValaParameter*) _tmp9_;
				if (first) {
					gchar* _tmp10_ = NULL;
					gchar* _tmp11_;
					gchar* _tmp12_;
					_tmp10_ = vala_gsignal_module_get_marshaller_type_name_for_parameter (self, p, dbus);
					_tmp11_ = _tmp10_;
					_tmp12_ = g_strconcat (signature, _tmp11_, NULL);
					_g_free0 (signature);
					signature = _tmp12_;
					_g_free0 (_tmp11_);
					first = FALSE;
				} else {
					gchar* _tmp13_ = NULL;
					gchar* _tmp14_;
					gchar* _tmp15_ = NULL;
					gchar* _tmp16_;
					_tmp13_ = vala_gsignal_module_get_marshaller_type_name_for_parameter (self, p, dbus);
					_tmp14_ = _tmp13_;
					_tmp15_ = g_strdup_printf ("%s,%s", signature, _tmp14_);
					_tmp16_ = _tmp15_;
					_g_free0 (signature);
					signature = _tmp16_;
					_g_free0 (_tmp14_);
				}
				_vala_code_node_unref0 (p);
			}
			_vala_iterable_unref0 (_p_list);
		}
	}
	result = signature;
	return result;
}


static ValaCCodeExpression* vala_gsignal_module_get_signal_name_cexpression (ValaGSignalModule* self, ValaSignal* sig, ValaExpression* detail_expr, ValaCodeNode* node) {
	ValaCCodeExpression* result = NULL;
	gboolean _tmp1_ = FALSE;
	ValaDataType* _tmp2_ = NULL;
	ValaDataType* _tmp10_ = NULL;
	ValaLocalVariable* _tmp11_ = NULL;
	ValaLocalVariable* detail_decl;
	ValaArrayList* _tmp12_ = NULL;
	ValaCCodeIdentifier* _tmp13_ = NULL;
	ValaCCodeIdentifier* _tmp14_;
	ValaCCodeFunctionCall* _tmp15_ = NULL;
	ValaCCodeFunctionCall* _tmp16_;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeConstant* _tmp17_ = NULL;
	ValaCCodeConstant* _tmp18_;
	ValaCCodeExpression* _tmp19_ = NULL;
	ValaCCodeExpression* _tmp20_;
	ValaCCodeConstant* _tmp21_ = NULL;
	ValaCCodeConstant* _tmp22_;
	ValaCCodeCommaExpression* _tmp23_ = NULL;
	ValaCCodeCommaExpression* ccomma;
	const gchar* _tmp24_ = NULL;
	ValaCCodeExpression* _tmp25_ = NULL;
	ValaCCodeExpression* _tmp26_;
	ValaCCodeAssignment* _tmp27_ = NULL;
	ValaCCodeAssignment* _tmp28_;
	const gchar* _tmp29_ = NULL;
	ValaCCodeExpression* _tmp30_ = NULL;
	ValaCCodeExpression* _tmp31_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sig != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	if (detail_expr == NULL) {
		ValaCCodeConstant* _tmp0_ = NULL;
		_tmp0_ = vala_signal_get_canonical_cconstant (sig, NULL);
		result = (ValaCCodeExpression*) _tmp0_;
		return result;
	}
	_tmp2_ = vala_expression_get_value_type (detail_expr);
	if (VALA_IS_NULL_TYPE (_tmp2_)) {
		_tmp1_ = TRUE;
	} else {
		ValaDataType* _tmp3_ = NULL;
		gboolean _tmp4_;
		_tmp3_ = vala_expression_get_value_type (detail_expr);
		_tmp4_ = vala_data_type_compatible (_tmp3_, ((ValaCCodeBaseModule*) self)->string_type);
		_tmp1_ = !_tmp4_;
	}
	if (_tmp1_) {
		ValaSourceReference* _tmp5_ = NULL;
		vala_code_node_set_error (node, TRUE);
		_tmp5_ = vala_code_node_get_source_reference ((ValaCodeNode*) detail_expr);
		vala_report_error (_tmp5_, "only string details are supported");
		result = NULL;
		return result;
	}
	if (VALA_IS_STRING_LITERAL (detail_expr)) {
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		ValaCCodeConstant* _tmp8_ = NULL;
		ValaCCodeExpression* _tmp9_;
		_tmp6_ = vala_string_literal_eval (VALA_STRING_LITERAL (detail_expr));
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_signal_get_canonical_cconstant (sig, _tmp7_);
		result = (_tmp9_ = (ValaCCodeExpression*) _tmp8_, _g_free0 (_tmp7_), _tmp9_);
		return result;
	}
	_tmp10_ = vala_expression_get_value_type (detail_expr);
	_tmp11_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp10_, TRUE, node, TRUE);
	detail_decl = _tmp11_;
	vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, detail_decl);
	_tmp12_ = vala_ccode_base_module_get_temp_ref_vars ((ValaCCodeBaseModule*) self);
	vala_list_insert ((ValaList*) _tmp12_, 0, detail_decl);
	_tmp13_ = vala_ccode_identifier_new ("g_strconcat");
	_tmp14_ = _tmp13_;
	_tmp15_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp14_);
	ccall = (_tmp16_ = _tmp15_, _vala_ccode_node_unref0 (_tmp14_), _tmp16_);
	_tmp17_ = vala_signal_get_canonical_cconstant (sig, "");
	_tmp18_ = _tmp17_;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) _tmp18_);
	_vala_ccode_node_unref0 (_tmp18_);
	_tmp19_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, detail_expr);
	_tmp20_ = _tmp19_;
	vala_ccode_function_call_add_argument (ccall, _tmp20_);
	_vala_ccode_node_unref0 (_tmp20_);
	_tmp21_ = vala_ccode_constant_new ("NULL");
	_tmp22_ = _tmp21_;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) _tmp22_);
	_vala_ccode_node_unref0 (_tmp22_);
	_tmp23_ = vala_ccode_comma_expression_new ();
	ccomma = _tmp23_;
	_tmp24_ = vala_symbol_get_name ((ValaSymbol*) detail_decl);
	_tmp25_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = vala_ccode_assignment_new (_tmp26_, (ValaCCodeExpression*) ccall, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
	_tmp28_ = _tmp27_;
	vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) _tmp28_);
	_vala_ccode_node_unref0 (_tmp28_);
	_vala_ccode_node_unref0 (_tmp26_);
	_tmp29_ = vala_symbol_get_name ((ValaSymbol*) detail_decl);
	_tmp30_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp29_);
	_tmp31_ = _tmp30_;
	vala_ccode_comma_expression_append_expression (ccomma, _tmp31_);
	_vala_ccode_node_unref0 (_tmp31_);
	result = (ValaCCodeExpression*) ccomma;
	_vala_ccode_node_unref0 (ccall);
	_vala_code_node_unref0 (detail_decl);
	return result;
}


static void vala_gsignal_module_real_visit_signal (ValaCodeVisitor* base, ValaSignal* sig) {
	ValaGSignalModule * self;
	ValaSymbol* _tmp0_ = NULL;
	ValaSymbol* _tmp1_;
	ValaClass* _tmp2_;
	ValaClass* cl;
	gboolean _tmp3_ = FALSE;
	ValaList* _tmp22_ = NULL;
	ValaList* _tmp23_;
	ValaDataType* _tmp24_ = NULL;
	self = (ValaGSignalModule*) base;
	g_return_if_fail (sig != NULL);
	_tmp0_ = vala_symbol_get_parent_symbol ((ValaSymbol*) sig);
	_tmp2_ = _vala_code_node_ref0 ((_tmp1_ = _tmp0_, VALA_IS_CLASS (_tmp1_) ? ((ValaClass*) _tmp1_) : NULL));
	cl = _tmp2_;
	if (cl != NULL) {
		gboolean _tmp4_;
		_tmp4_ = vala_class_get_is_compact (cl);
		_tmp3_ = _tmp4_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		ValaSourceReference* _tmp5_ = NULL;
		vala_code_node_set_error ((ValaCodeNode*) sig, TRUE);
		_tmp5_ = vala_code_node_get_source_reference ((ValaCodeNode*) sig);
		vala_report_error (_tmp5_, "Signals are not supported in compact classes");
		_vala_code_node_unref0 (cl);
		return;
	}
	if (cl != NULL) {
		{
			ValaList* _tmp6_ = NULL;
			ValaList* _base_type_list;
			gint _tmp7_;
			gint _base_type_size;
			gint _base_type_index;
			_tmp6_ = vala_class_get_base_types (cl);
			_base_type_list = _tmp6_;
			_tmp7_ = vala_collection_get_size ((ValaCollection*) _base_type_list);
			_base_type_size = _tmp7_;
			_base_type_index = -1;
			while (TRUE) {
				gpointer _tmp8_ = NULL;
				ValaDataType* base_type;
				ValaTypeSymbol* _tmp9_ = NULL;
				const gchar* _tmp10_ = NULL;
				ValaSymbol* _tmp11_ = NULL;
				ValaSymbol* _tmp12_;
				gboolean _tmp13_;
				_base_type_index = _base_type_index + 1;
				if (!(_base_type_index < _base_type_size)) {
					break;
				}
				_tmp8_ = vala_list_get (_base_type_list, _base_type_index);
				base_type = (ValaDataType*) _tmp8_;
				_tmp9_ = vala_data_type_get_data_type (base_type);
				_tmp10_ = vala_symbol_get_name ((ValaSymbol*) sig);
				_tmp11_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) _tmp9_, _tmp10_);
				_tmp12_ = _tmp11_;
				if ((_tmp13_ = VALA_IS_SIGNAL (_tmp12_), _vala_code_node_unref0 (_tmp12_), _tmp13_)) {
					ValaSourceReference* _tmp14_ = NULL;
					vala_code_node_set_error ((ValaCodeNode*) sig, TRUE);
					_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) sig);
					vala_report_error (_tmp14_, "Signals with the same name as a signal in a base type are not supporte" \
"d");
					_vala_code_node_unref0 (base_type);
					_vala_iterable_unref0 (_base_type_list);
					_vala_code_node_unref0 (cl);
					return;
				}
				_vala_code_node_unref0 (base_type);
			}
			_vala_iterable_unref0 (_base_type_list);
		}
	}
	vala_code_node_accept_children ((ValaCodeNode*) sig, (ValaCodeVisitor*) self);
	{
		ValaList* _tmp15_ = NULL;
		ValaList* _p_list;
		gint _tmp16_;
		gint _p_size;
		gint _p_index;
		_tmp15_ = vala_signal_get_parameters (sig);
		_p_list = _tmp15_;
		_tmp16_ = vala_collection_get_size ((ValaCollection*) _p_list);
		_p_size = _tmp16_;
		_p_index = -1;
		while (TRUE) {
			gpointer _tmp17_ = NULL;
			ValaParameter* p;
			ValaHashMap* _tmp18_ = NULL;
			ValaHashMap* _tmp19_;
			ValaCCodeParameter* _tmp20_ = NULL;
			ValaCCodeParameter* _tmp21_;
			_p_index = _p_index + 1;
			if (!(_p_index < _p_size)) {
				break;
			}
			_tmp17_ = vala_list_get (_p_list, _p_index);
			p = (ValaParameter*) _tmp17_;
			_tmp18_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_PARAMETER, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
			_tmp19_ = _tmp18_;
			_tmp20_ = vala_ccode_method_module_generate_parameter ((ValaCCodeMethodModule*) self, p, ((ValaCCodeBaseModule*) self)->cfile, (ValaMap*) _tmp19_, NULL);
			_tmp21_ = _tmp20_;
			_vala_ccode_node_unref0 (_tmp21_);
			_vala_map_unref0 (_tmp19_);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	_tmp22_ = vala_signal_get_parameters (sig);
	_tmp23_ = _tmp22_;
	_tmp24_ = vala_signal_get_return_type (sig);
	vala_ccode_base_module_generate_marshaller ((ValaCCodeBaseModule*) self, _tmp23_, _tmp24_, FALSE);
	_vala_iterable_unref0 (_tmp23_);
	_vala_code_node_unref0 (cl);
}


static void vala_gsignal_module_real_generate_marshaller (ValaCCodeBaseModule* base, ValaList* params, ValaDataType* return_type, gboolean dbus) {
	ValaGSignalModule * self;
	gchar* signature;
	gint n_params = 0;
	gint i = 0;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	ValaCCodeFunction* _tmp7_ = NULL;
	ValaCCodeFunction* _tmp8_;
	ValaCCodeFunction* signal_marshaller;
	ValaCCodeParameter* _tmp9_ = NULL;
	ValaCCodeParameter* _tmp10_;
	ValaCCodeParameter* _tmp11_ = NULL;
	ValaCCodeParameter* _tmp12_;
	ValaCCodeParameter* _tmp13_ = NULL;
	ValaCCodeParameter* _tmp14_;
	ValaCCodeParameter* _tmp15_ = NULL;
	ValaCCodeParameter* _tmp16_;
	ValaCCodeParameter* _tmp17_ = NULL;
	ValaCCodeParameter* _tmp18_;
	ValaCCodeParameter* _tmp19_ = NULL;
	ValaCCodeParameter* _tmp20_;
	ValaCCodeBlock* _tmp21_ = NULL;
	ValaCCodeBlock* marshaller_body;
	gchar* _tmp22_ = NULL;
	gchar* _tmp23_;
	ValaCCodeFunctionDeclarator* _tmp24_ = NULL;
	ValaCCodeFunctionDeclarator* _tmp25_;
	ValaCCodeFunctionDeclarator* callback_decl;
	ValaCCodeParameter* _tmp26_ = NULL;
	ValaCCodeParameter* _tmp27_;
	ValaCCodeParameter* _tmp44_ = NULL;
	ValaCCodeParameter* _tmp45_;
	gchar* _tmp46_ = NULL;
	gchar* _tmp47_;
	ValaCCodeTypeDefinition* _tmp48_ = NULL;
	ValaCCodeTypeDefinition* _tmp49_;
	gchar* _tmp50_ = NULL;
	gchar* _tmp51_;
	ValaCCodeDeclaration* _tmp52_ = NULL;
	ValaCCodeDeclaration* _tmp53_;
	ValaCCodeDeclaration* var_decl;
	ValaCCodeVariableDeclarator* _tmp54_ = NULL;
	ValaCCodeVariableDeclarator* _tmp55_;
	ValaCCodeDeclaration* _tmp56_ = NULL;
	ValaCCodeDeclaration* _tmp57_;
	ValaCCodeIdentifier* _tmp58_ = NULL;
	ValaCCodeIdentifier* _tmp59_;
	ValaCCodeCastExpression* _tmp60_ = NULL;
	ValaCCodeCastExpression* _tmp61_;
	ValaCCodeVariableDeclarator* _tmp62_ = NULL;
	ValaCCodeVariableDeclarator* _tmp63_;
	ValaCCodeDeclaration* _tmp64_ = NULL;
	ValaCCodeDeclaration* _tmp65_;
	ValaCCodeVariableDeclarator* _tmp66_ = NULL;
	ValaCCodeVariableDeclarator* _tmp67_;
	ValaCCodeVariableDeclarator* _tmp68_ = NULL;
	ValaCCodeVariableDeclarator* _tmp69_;
	ValaCCodeFunctionCall* fc;
	gboolean _tmp70_ = FALSE;
	ValaTypeSymbol* _tmp71_ = NULL;
	ValaCCodeIdentifier* _tmp91_ = NULL;
	ValaCCodeIdentifier* _tmp92_;
	ValaCCodeFunctionCall* _tmp93_ = NULL;
	ValaCCodeFunctionCall* _tmp94_;
	ValaCCodeIdentifier* _tmp95_ = NULL;
	ValaCCodeIdentifier* _tmp96_;
	gchar* _tmp97_ = NULL;
	gchar* _tmp98_;
	ValaCCodeConstant* _tmp99_ = NULL;
	ValaCCodeConstant* _tmp100_;
	ValaCCodeBinaryExpression* _tmp101_ = NULL;
	ValaCCodeBinaryExpression* _tmp102_;
	ValaCCodeExpressionStatement* _tmp103_ = NULL;
	ValaCCodeExpressionStatement* _tmp104_;
	ValaCCodeIdentifier* _tmp105_ = NULL;
	ValaCCodeIdentifier* _tmp106_;
	ValaCCodeMemberAccess* _tmp107_ = NULL;
	ValaCCodeMemberAccess* _tmp108_;
	ValaCCodeMemberAccess* data;
	ValaCCodeIdentifier* _tmp109_ = NULL;
	ValaCCodeIdentifier* _tmp110_;
	ValaCCodeMemberAccess* _tmp111_ = NULL;
	ValaCCodeMemberAccess* _tmp112_;
	ValaCCodeMemberAccess* _tmp113_ = NULL;
	ValaCCodeMemberAccess* _tmp114_;
	ValaCCodeMemberAccess* param;
	ValaCCodeConstant* _tmp115_ = NULL;
	ValaCCodeConstant* _tmp116_;
	ValaCCodeFunctionCall* _tmp117_ = NULL;
	ValaCCodeFunctionCall* _tmp118_;
	ValaCCodeFunctionCall* cond;
	ValaCCodeIdentifier* _tmp119_ = NULL;
	ValaCCodeIdentifier* _tmp120_;
	ValaCCodeBlock* _tmp121_ = NULL;
	ValaCCodeBlock* true_block;
	ValaCCodeIdentifier* _tmp122_ = NULL;
	ValaCCodeIdentifier* _tmp123_;
	ValaCCodeAssignment* _tmp124_ = NULL;
	ValaCCodeAssignment* _tmp125_;
	ValaCCodeExpressionStatement* _tmp126_ = NULL;
	ValaCCodeExpressionStatement* _tmp127_;
	ValaCCodeIdentifier* _tmp128_ = NULL;
	ValaCCodeIdentifier* _tmp129_;
	ValaCCodeAssignment* _tmp130_ = NULL;
	ValaCCodeAssignment* _tmp131_;
	ValaCCodeExpressionStatement* _tmp132_ = NULL;
	ValaCCodeExpressionStatement* _tmp133_;
	ValaCCodeBlock* _tmp134_ = NULL;
	ValaCCodeBlock* false_block;
	ValaCCodeIdentifier* _tmp135_ = NULL;
	ValaCCodeIdentifier* _tmp136_;
	ValaCCodeAssignment* _tmp137_ = NULL;
	ValaCCodeAssignment* _tmp138_;
	ValaCCodeExpressionStatement* _tmp139_ = NULL;
	ValaCCodeExpressionStatement* _tmp140_;
	ValaCCodeIdentifier* _tmp141_ = NULL;
	ValaCCodeIdentifier* _tmp142_;
	ValaCCodeAssignment* _tmp143_ = NULL;
	ValaCCodeAssignment* _tmp144_;
	ValaCCodeExpressionStatement* _tmp145_ = NULL;
	ValaCCodeExpressionStatement* _tmp146_;
	ValaCCodeIfStatement* _tmp147_ = NULL;
	ValaCCodeIfStatement* _tmp148_;
	ValaCCodeIdentifier* _tmp149_ = NULL;
	ValaCCodeIdentifier* _tmp150_;
	ValaCCodeIdentifier* _tmp151_ = NULL;
	ValaCCodeIdentifier* _tmp152_;
	ValaCCodeIdentifier* _tmp153_ = NULL;
	ValaCCodeIdentifier* _tmp154_;
	ValaCCodeIdentifier* _tmp155_ = NULL;
	ValaCCodeIdentifier* _tmp156_;
	ValaCCodeMemberAccess* _tmp157_ = NULL;
	ValaCCodeMemberAccess* _tmp158_;
	ValaCCodeConditionalExpression* _tmp159_ = NULL;
	ValaCCodeConditionalExpression* _tmp160_;
	gchar* _tmp161_ = NULL;
	gchar* _tmp162_;
	ValaCCodeCastExpression* _tmp163_ = NULL;
	ValaCCodeCastExpression* _tmp164_;
	ValaCCodeAssignment* _tmp165_ = NULL;
	ValaCCodeAssignment* _tmp166_;
	ValaCCodeAssignment* c_assign;
	ValaCCodeExpressionStatement* _tmp167_ = NULL;
	ValaCCodeExpressionStatement* _tmp168_;
	ValaCCodeIdentifier* _tmp169_ = NULL;
	ValaCCodeIdentifier* _tmp170_;
	ValaCCodeFunctionCall* _tmp171_ = NULL;
	ValaCCodeFunctionCall* _tmp172_;
	ValaCCodeIdentifier* _tmp173_ = NULL;
	ValaCCodeIdentifier* _tmp174_;
	ValaCCodeIdentifier* _tmp249_ = NULL;
	ValaCCodeIdentifier* _tmp250_;
	gboolean _tmp251_ = FALSE;
	ValaTypeSymbol* _tmp252_ = NULL;
	self = (ValaGSignalModule*) base;
	g_return_if_fail (params != NULL);
	g_return_if_fail (return_type != NULL);
	signature = NULL;
	_tmp0_ = vala_gsignal_module_get_marshaller_signature (self, params, return_type, dbus);
	_tmp1_ = _tmp0_;
	_g_free0 (signature);
	signature = _tmp1_;
	_tmp3_ = vala_collection_contains ((ValaCollection*) ((ValaCCodeBaseModule*) self)->predefined_marshal_set, signature);
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		gboolean _tmp4_;
		_tmp4_ = vala_collection_contains ((ValaCollection*) ((ValaCCodeBaseModule*) self)->user_marshal_set, signature);
		_tmp2_ = _tmp4_;
	}
	if (_tmp2_) {
		_g_free0 (signature);
		return;
	}
	_tmp5_ = vala_ccode_base_module_get_marshaller_function ((ValaCCodeBaseModule*) self, params, return_type, NULL, dbus);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_ccode_function_new (_tmp6_, "void");
	signal_marshaller = (_tmp8_ = _tmp7_, _g_free0 (_tmp6_), _tmp8_);
	vala_ccode_function_set_modifiers (signal_marshaller, VALA_CCODE_MODIFIERS_STATIC);
	_tmp9_ = vala_ccode_parameter_new ("closure", "GClosure *");
	_tmp10_ = _tmp9_;
	vala_ccode_function_add_parameter (signal_marshaller, _tmp10_);
	_vala_ccode_node_unref0 (_tmp10_);
	_tmp11_ = vala_ccode_parameter_new ("return_value", "GValue *");
	_tmp12_ = _tmp11_;
	vala_ccode_function_add_parameter (signal_marshaller, _tmp12_);
	_vala_ccode_node_unref0 (_tmp12_);
	_tmp13_ = vala_ccode_parameter_new ("n_param_values", "guint");
	_tmp14_ = _tmp13_;
	vala_ccode_function_add_parameter (signal_marshaller, _tmp14_);
	_vala_ccode_node_unref0 (_tmp14_);
	_tmp15_ = vala_ccode_parameter_new ("param_values", "const GValue *");
	_tmp16_ = _tmp15_;
	vala_ccode_function_add_parameter (signal_marshaller, _tmp16_);
	_vala_ccode_node_unref0 (_tmp16_);
	_tmp17_ = vala_ccode_parameter_new ("invocation_hint", "gpointer");
	_tmp18_ = _tmp17_;
	vala_ccode_function_add_parameter (signal_marshaller, _tmp18_);
	_vala_ccode_node_unref0 (_tmp18_);
	_tmp19_ = vala_ccode_parameter_new ("marshal_data", "gpointer");
	_tmp20_ = _tmp19_;
	vala_ccode_function_add_parameter (signal_marshaller, _tmp20_);
	_vala_ccode_node_unref0 (_tmp20_);
	vala_ccode_file_add_function_declaration (((ValaCCodeBaseModule*) self)->cfile, signal_marshaller);
	_tmp21_ = vala_ccode_block_new ();
	marshaller_body = _tmp21_;
	_tmp22_ = vala_ccode_base_module_get_marshaller_function ((ValaCCodeBaseModule*) self, params, return_type, "GMarshalFunc", dbus);
	_tmp23_ = _tmp22_;
	_tmp24_ = vala_ccode_function_declarator_new (_tmp23_);
	callback_decl = (_tmp25_ = _tmp24_, _g_free0 (_tmp23_), _tmp25_);
	_tmp26_ = vala_ccode_parameter_new ("data1", "gpointer");
	_tmp27_ = _tmp26_;
	vala_ccode_function_declarator_add_parameter (callback_decl, _tmp27_);
	_vala_ccode_node_unref0 (_tmp27_);
	n_params = 1;
	{
		ValaList* _tmp28_;
		ValaList* _p_list;
		gint _tmp29_;
		gint _p_size;
		gint _p_index;
		_tmp28_ = _vala_iterable_ref0 (params);
		_p_list = _tmp28_;
		_tmp29_ = vala_collection_get_size ((ValaCollection*) _p_list);
		_p_size = _tmp29_;
		_p_index = -1;
		while (TRUE) {
			gpointer _tmp30_ = NULL;
			ValaParameter* p;
			gchar* _tmp31_ = NULL;
			gchar* _tmp32_;
			gchar* _tmp33_ = NULL;
			gchar* _tmp34_;
			ValaCCodeParameter* _tmp35_ = NULL;
			ValaCCodeParameter* _tmp36_;
			gboolean _tmp37_ = FALSE;
			ValaDataType* _tmp38_ = NULL;
			gboolean _tmp39_;
			_p_index = _p_index + 1;
			if (!(_p_index < _p_size)) {
				break;
			}
			_tmp30_ = vala_list_get (_p_list, _p_index);
			p = (ValaParameter*) _tmp30_;
			_tmp31_ = g_strdup_printf ("arg_%d", n_params);
			_tmp32_ = _tmp31_;
			_tmp33_ = vala_gsignal_module_get_value_type_name_from_parameter (self, p);
			_tmp34_ = _tmp33_;
			_tmp35_ = vala_ccode_parameter_new (_tmp32_, _tmp34_);
			_tmp36_ = _tmp35_;
			vala_ccode_function_declarator_add_parameter (callback_decl, _tmp36_);
			_vala_ccode_node_unref0 (_tmp36_);
			_g_free0 (_tmp34_);
			_g_free0 (_tmp32_);
			n_params++;
			_tmp38_ = vala_variable_get_variable_type ((ValaVariable*) p);
			_tmp39_ = vala_data_type_is_array (_tmp38_);
			if (_tmp39_) {
				_tmp37_ = !dbus;
			} else {
				_tmp37_ = FALSE;
			}
			if (_tmp37_) {
				gchar* _tmp40_ = NULL;
				gchar* _tmp41_;
				ValaCCodeParameter* _tmp42_ = NULL;
				ValaCCodeParameter* _tmp43_;
				_tmp40_ = g_strdup_printf ("arg_%d", n_params);
				_tmp41_ = _tmp40_;
				_tmp42_ = vala_ccode_parameter_new (_tmp41_, "gint");
				_tmp43_ = _tmp42_;
				vala_ccode_function_declarator_add_parameter (callback_decl, _tmp43_);
				_vala_ccode_node_unref0 (_tmp43_);
				_g_free0 (_tmp41_);
				n_params++;
			}
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	_tmp44_ = vala_ccode_parameter_new ("data2", "gpointer");
	_tmp45_ = _tmp44_;
	vala_ccode_function_declarator_add_parameter (callback_decl, _tmp45_);
	_vala_ccode_node_unref0 (_tmp45_);
	_tmp46_ = vala_gsignal_module_get_value_type_name_from_type_reference (self, return_type);
	_tmp47_ = _tmp46_;
	_tmp48_ = vala_ccode_type_definition_new (_tmp47_, (ValaCCodeDeclarator*) callback_decl);
	_tmp49_ = _tmp48_;
	vala_ccode_block_add_statement (marshaller_body, (ValaCCodeNode*) _tmp49_);
	_vala_ccode_node_unref0 (_tmp49_);
	_g_free0 (_tmp47_);
	_tmp50_ = vala_ccode_base_module_get_marshaller_function ((ValaCCodeBaseModule*) self, params, return_type, "GMarshalFunc", dbus);
	_tmp51_ = _tmp50_;
	_tmp52_ = vala_ccode_declaration_new (_tmp51_);
	var_decl = (_tmp53_ = _tmp52_, _g_free0 (_tmp51_), _tmp53_);
	vala_ccode_declaration_set_modifiers (var_decl, VALA_CCODE_MODIFIERS_REGISTER);
	_tmp54_ = vala_ccode_variable_declarator_new ("callback", NULL, NULL);
	_tmp55_ = _tmp54_;
	vala_ccode_declaration_add_declarator (var_decl, (ValaCCodeDeclarator*) _tmp55_);
	_vala_ccode_node_unref0 (_tmp55_);
	vala_ccode_block_add_statement (marshaller_body, (ValaCCodeNode*) var_decl);
	_tmp56_ = vala_ccode_declaration_new ("GCClosure *");
	_tmp57_ = _tmp56_;
	_vala_ccode_node_unref0 (var_decl);
	var_decl = _tmp57_;
	vala_ccode_declaration_set_modifiers (var_decl, VALA_CCODE_MODIFIERS_REGISTER);
	_tmp58_ = vala_ccode_identifier_new ("closure");
	_tmp59_ = _tmp58_;
	_tmp60_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp59_, "GCClosure *");
	_tmp61_ = _tmp60_;
	_tmp62_ = vala_ccode_variable_declarator_new ("cc", (ValaCCodeExpression*) _tmp61_, NULL);
	_tmp63_ = _tmp62_;
	vala_ccode_declaration_add_declarator (var_decl, (ValaCCodeDeclarator*) _tmp63_);
	_vala_ccode_node_unref0 (_tmp63_);
	_vala_ccode_node_unref0 (_tmp61_);
	_vala_ccode_node_unref0 (_tmp59_);
	vala_ccode_block_add_statement (marshaller_body, (ValaCCodeNode*) var_decl);
	_tmp64_ = vala_ccode_declaration_new ("gpointer");
	_tmp65_ = _tmp64_;
	_vala_ccode_node_unref0 (var_decl);
	var_decl = _tmp65_;
	vala_ccode_declaration_set_modifiers (var_decl, VALA_CCODE_MODIFIERS_REGISTER);
	_tmp66_ = vala_ccode_variable_declarator_new ("data1", NULL, NULL);
	_tmp67_ = _tmp66_;
	vala_ccode_declaration_add_declarator (var_decl, (ValaCCodeDeclarator*) _tmp67_);
	_vala_ccode_node_unref0 (_tmp67_);
	_tmp68_ = vala_ccode_variable_declarator_new ("data2", NULL, NULL);
	_tmp69_ = _tmp68_;
	vala_ccode_declaration_add_declarator (var_decl, (ValaCCodeDeclarator*) _tmp69_);
	_vala_ccode_node_unref0 (_tmp69_);
	vala_ccode_block_add_statement (marshaller_body, (ValaCCodeNode*) var_decl);
	fc = NULL;
	_tmp71_ = vala_data_type_get_data_type (return_type);
	if (_tmp71_ != NULL) {
		_tmp70_ = TRUE;
	} else {
		gboolean _tmp72_;
		_tmp72_ = vala_data_type_is_array (return_type);
		_tmp70_ = _tmp72_;
	}
	if (_tmp70_) {
		gchar* _tmp73_ = NULL;
		gchar* _tmp74_;
		ValaCCodeDeclaration* _tmp75_ = NULL;
		ValaCCodeDeclaration* _tmp76_;
		ValaCCodeVariableDeclarator* _tmp77_ = NULL;
		ValaCCodeVariableDeclarator* _tmp78_;
		ValaCCodeIdentifier* _tmp79_ = NULL;
		ValaCCodeIdentifier* _tmp80_;
		ValaCCodeFunctionCall* _tmp81_ = NULL;
		ValaCCodeFunctionCall* _tmp82_;
		ValaCCodeIdentifier* _tmp83_ = NULL;
		ValaCCodeIdentifier* _tmp84_;
		ValaCCodeConstant* _tmp85_ = NULL;
		ValaCCodeConstant* _tmp86_;
		ValaCCodeBinaryExpression* _tmp87_ = NULL;
		ValaCCodeBinaryExpression* _tmp88_;
		ValaCCodeExpressionStatement* _tmp89_ = NULL;
		ValaCCodeExpressionStatement* _tmp90_;
		_tmp73_ = vala_gsignal_module_get_value_type_name_from_type_reference (self, return_type);
		_tmp74_ = _tmp73_;
		_tmp75_ = vala_ccode_declaration_new (_tmp74_);
		_tmp76_ = _tmp75_;
		_vala_ccode_node_unref0 (var_decl);
		var_decl = _tmp76_;
		_g_free0 (_tmp74_);
		_tmp77_ = vala_ccode_variable_declarator_new ("v_return", NULL, NULL);
		_tmp78_ = _tmp77_;
		vala_ccode_declaration_add_declarator (var_decl, (ValaCCodeDeclarator*) _tmp78_);
		_vala_ccode_node_unref0 (_tmp78_);
		vala_ccode_block_add_statement (marshaller_body, (ValaCCodeNode*) var_decl);
		_tmp79_ = vala_ccode_identifier_new ("g_return_if_fail");
		_tmp80_ = _tmp79_;
		_tmp81_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp80_);
		_tmp82_ = _tmp81_;
		_vala_ccode_node_unref0 (fc);
		fc = _tmp82_;
		_vala_ccode_node_unref0 (_tmp80_);
		_tmp83_ = vala_ccode_identifier_new ("return_value");
		_tmp84_ = _tmp83_;
		_tmp85_ = vala_ccode_constant_new ("NULL");
		_tmp86_ = _tmp85_;
		_tmp87_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, (ValaCCodeExpression*) _tmp84_, (ValaCCodeExpression*) _tmp86_);
		_tmp88_ = _tmp87_;
		vala_ccode_function_call_add_argument (fc, (ValaCCodeExpression*) _tmp88_);
		_vala_ccode_node_unref0 (_tmp88_);
		_vala_ccode_node_unref0 (_tmp86_);
		_vala_ccode_node_unref0 (_tmp84_);
		_tmp89_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) fc);
		_tmp90_ = _tmp89_;
		vala_ccode_block_add_statement (marshaller_body, (ValaCCodeNode*) _tmp90_);
		_vala_ccode_node_unref0 (_tmp90_);
	}
	_tmp91_ = vala_ccode_identifier_new ("g_return_if_fail");
	_tmp92_ = _tmp91_;
	_tmp93_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp92_);
	_tmp94_ = _tmp93_;
	_vala_ccode_node_unref0 (fc);
	fc = _tmp94_;
	_vala_ccode_node_unref0 (_tmp92_);
	_tmp95_ = vala_ccode_identifier_new ("n_param_values");
	_tmp96_ = _tmp95_;
	_tmp97_ = g_strdup_printf ("%i", n_params);
	_tmp98_ = _tmp97_;
	_tmp99_ = vala_ccode_constant_new (_tmp98_);
	_tmp100_ = _tmp99_;
	_tmp101_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) _tmp96_, (ValaCCodeExpression*) _tmp100_);
	_tmp102_ = _tmp101_;
	vala_ccode_function_call_add_argument (fc, (ValaCCodeExpression*) _tmp102_);
	_vala_ccode_node_unref0 (_tmp102_);
	_vala_ccode_node_unref0 (_tmp100_);
	_g_free0 (_tmp98_);
	_vala_ccode_node_unref0 (_tmp96_);
	_tmp103_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) fc);
	_tmp104_ = _tmp103_;
	vala_ccode_block_add_statement (marshaller_body, (ValaCCodeNode*) _tmp104_);
	_vala_ccode_node_unref0 (_tmp104_);
	_tmp105_ = vala_ccode_identifier_new ("closure");
	_tmp106_ = _tmp105_;
	_tmp107_ = vala_ccode_member_access_new ((ValaCCodeExpression*) _tmp106_, "data", TRUE);
	data = (_tmp108_ = _tmp107_, _vala_ccode_node_unref0 (_tmp106_), _tmp108_);
	_tmp109_ = vala_ccode_identifier_new ("param_values");
	_tmp110_ = _tmp109_;
	_tmp111_ = vala_ccode_member_access_new ((ValaCCodeExpression*) _tmp110_, "data[0]", TRUE);
	_tmp112_ = _tmp111_;
	_tmp113_ = vala_ccode_member_access_new ((ValaCCodeExpression*) _tmp112_, "v_pointer", FALSE);
	param = (_tmp114_ = _tmp113_, _vala_ccode_node_unref0 (_tmp112_), _vala_ccode_node_unref0 (_tmp110_), _tmp114_);
	_tmp115_ = vala_ccode_constant_new ("G_CCLOSURE_SWAP_DATA");
	_tmp116_ = _tmp115_;
	_tmp117_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp116_);
	cond = (_tmp118_ = _tmp117_, _vala_ccode_node_unref0 (_tmp116_), _tmp118_);
	_tmp119_ = vala_ccode_identifier_new ("closure");
	_tmp120_ = _tmp119_;
	vala_ccode_function_call_add_argument (cond, (ValaCCodeExpression*) _tmp120_);
	_vala_ccode_node_unref0 (_tmp120_);
	_tmp121_ = vala_ccode_block_new ();
	true_block = _tmp121_;
	_tmp122_ = vala_ccode_identifier_new ("data1");
	_tmp123_ = _tmp122_;
	_tmp124_ = vala_ccode_assignment_new ((ValaCCodeExpression*) _tmp123_, (ValaCCodeExpression*) data, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
	_tmp125_ = _tmp124_;
	_tmp126_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) _tmp125_);
	_tmp127_ = _tmp126_;
	vala_ccode_block_add_statement (true_block, (ValaCCodeNode*) _tmp127_);
	_vala_ccode_node_unref0 (_tmp127_);
	_vala_ccode_node_unref0 (_tmp125_);
	_vala_ccode_node_unref0 (_tmp123_);
	_tmp128_ = vala_ccode_identifier_new ("data2");
	_tmp129_ = _tmp128_;
	_tmp130_ = vala_ccode_assignment_new ((ValaCCodeExpression*) _tmp129_, (ValaCCodeExpression*) param, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
	_tmp131_ = _tmp130_;
	_tmp132_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) _tmp131_);
	_tmp133_ = _tmp132_;
	vala_ccode_block_add_statement (true_block, (ValaCCodeNode*) _tmp133_);
	_vala_ccode_node_unref0 (_tmp133_);
	_vala_ccode_node_unref0 (_tmp131_);
	_vala_ccode_node_unref0 (_tmp129_);
	_tmp134_ = vala_ccode_block_new ();
	false_block = _tmp134_;
	_tmp135_ = vala_ccode_identifier_new ("data1");
	_tmp136_ = _tmp135_;
	_tmp137_ = vala_ccode_assignment_new ((ValaCCodeExpression*) _tmp136_, (ValaCCodeExpression*) param, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
	_tmp138_ = _tmp137_;
	_tmp139_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) _tmp138_);
	_tmp140_ = _tmp139_;
	vala_ccode_block_add_statement (false_block, (ValaCCodeNode*) _tmp140_);
	_vala_ccode_node_unref0 (_tmp140_);
	_vala_ccode_node_unref0 (_tmp138_);
	_vala_ccode_node_unref0 (_tmp136_);
	_tmp141_ = vala_ccode_identifier_new ("data2");
	_tmp142_ = _tmp141_;
	_tmp143_ = vala_ccode_assignment_new ((ValaCCodeExpression*) _tmp142_, (ValaCCodeExpression*) data, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
	_tmp144_ = _tmp143_;
	_tmp145_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) _tmp144_);
	_tmp146_ = _tmp145_;
	vala_ccode_block_add_statement (false_block, (ValaCCodeNode*) _tmp146_);
	_vala_ccode_node_unref0 (_tmp146_);
	_vala_ccode_node_unref0 (_tmp144_);
	_vala_ccode_node_unref0 (_tmp142_);
	_tmp147_ = vala_ccode_if_statement_new ((ValaCCodeExpression*) cond, (ValaCCodeStatement*) true_block, (ValaCCodeStatement*) false_block);
	_tmp148_ = _tmp147_;
	vala_ccode_block_add_statement (marshaller_body, (ValaCCodeNode*) _tmp148_);
	_vala_ccode_node_unref0 (_tmp148_);
	_tmp149_ = vala_ccode_identifier_new ("callback");
	_tmp150_ = _tmp149_;
	_tmp151_ = vala_ccode_identifier_new ("marshal_data");
	_tmp152_ = _tmp151_;
	_tmp153_ = vala_ccode_identifier_new ("marshal_data");
	_tmp154_ = _tmp153_;
	_tmp155_ = vala_ccode_identifier_new ("cc");
	_tmp156_ = _tmp155_;
	_tmp157_ = vala_ccode_member_access_new ((ValaCCodeExpression*) _tmp156_, "callback", TRUE);
	_tmp158_ = _tmp157_;
	_tmp159_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp152_, (ValaCCodeExpression*) _tmp154_, (ValaCCodeExpression*) _tmp158_);
	_tmp160_ = _tmp159_;
	_tmp161_ = vala_ccode_base_module_get_marshaller_function ((ValaCCodeBaseModule*) self, params, return_type, "GMarshalFunc", dbus);
	_tmp162_ = _tmp161_;
	_tmp163_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp160_, _tmp162_);
	_tmp164_ = _tmp163_;
	_tmp165_ = vala_ccode_assignment_new ((ValaCCodeExpression*) _tmp150_, (ValaCCodeExpression*) _tmp164_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
	c_assign = (_tmp166_ = _tmp165_, _vala_ccode_node_unref0 (_tmp164_), _g_free0 (_tmp162_), _vala_ccode_node_unref0 (_tmp160_), _vala_ccode_node_unref0 (_tmp158_), _vala_ccode_node_unref0 (_tmp156_), _vala_ccode_node_unref0 (_tmp154_), _vala_ccode_node_unref0 (_tmp152_), _vala_ccode_node_unref0 (_tmp150_), _tmp166_);
	_tmp167_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) c_assign);
	_tmp168_ = _tmp167_;
	vala_ccode_block_add_statement (marshaller_body, (ValaCCodeNode*) _tmp168_);
	_vala_ccode_node_unref0 (_tmp168_);
	_tmp169_ = vala_ccode_identifier_new ("callback");
	_tmp170_ = _tmp169_;
	_tmp171_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp170_);
	_tmp172_ = _tmp171_;
	_vala_ccode_node_unref0 (fc);
	fc = _tmp172_;
	_vala_ccode_node_unref0 (_tmp170_);
	_tmp173_ = vala_ccode_identifier_new ("data1");
	_tmp174_ = _tmp173_;
	vala_ccode_function_call_add_argument (fc, (ValaCCodeExpression*) _tmp174_);
	_vala_ccode_node_unref0 (_tmp174_);
	i = 1;
	{
		ValaList* _tmp175_;
		ValaList* _p_list;
		gint _tmp176_;
		gint _p_size;
		gint _p_index;
		_tmp175_ = _vala_iterable_ref0 (params);
		_p_list = _tmp175_;
		_tmp176_ = vala_collection_get_size ((ValaCollection*) _p_list);
		_p_size = _tmp176_;
		_p_index = -1;
		while (TRUE) {
			gpointer _tmp177_ = NULL;
			ValaParameter* p;
			gchar* get_value_function;
			ValaDataType* _tmp178_ = NULL;
			gboolean _tmp179_;
			gboolean is_array;
			ValaParameterDirection _tmp180_;
			ValaCCodeIdentifier* _tmp224_ = NULL;
			ValaCCodeIdentifier* _tmp225_;
			ValaCCodeFunctionCall* _tmp226_ = NULL;
			ValaCCodeFunctionCall* _tmp227_;
			ValaCCodeFunctionCall* inner_fc;
			ValaCCodeIdentifier* _tmp228_ = NULL;
			ValaCCodeIdentifier* _tmp229_;
			gchar* _tmp230_ = NULL;
			gchar* _tmp231_;
			ValaCCodeIdentifier* _tmp232_ = NULL;
			ValaCCodeIdentifier* _tmp233_;
			ValaCCodeBinaryExpression* _tmp234_ = NULL;
			ValaCCodeBinaryExpression* _tmp235_;
			gboolean _tmp236_ = FALSE;
			_p_index = _p_index + 1;
			if (!(_p_index < _p_size)) {
				break;
			}
			_tmp177_ = vala_list_get (_p_list, _p_index);
			p = (ValaParameter*) _tmp177_;
			get_value_function = NULL;
			_tmp178_ = vala_variable_get_variable_type ((ValaVariable*) p);
			_tmp179_ = vala_data_type_is_array (_tmp178_);
			is_array = _tmp179_;
			_tmp180_ = vala_parameter_get_direction (p);
			if (_tmp180_ != VALA_PARAMETER_DIRECTION_IN) {
				gchar* _tmp181_;
				gchar* _tmp182_;
				_tmp181_ = g_strdup ("g_value_get_pointer");
				_tmp182_ = _tmp181_;
				_g_free0 (get_value_function);
				get_value_function = _tmp182_;
			} else {
				if (is_array) {
					if (dbus) {
						gchar* _tmp183_;
						gchar* _tmp184_;
						_tmp183_ = g_strdup ("g_value_get_boxed");
						_tmp184_ = _tmp183_;
						_g_free0 (get_value_function);
						get_value_function = _tmp184_;
					} else {
						ValaDataType* _tmp185_ = NULL;
						ValaDataType* _tmp186_ = NULL;
						ValaTypeSymbol* _tmp187_ = NULL;
						ValaTypeSymbol* _tmp188_ = NULL;
						_tmp185_ = vala_variable_get_variable_type ((ValaVariable*) p);
						_tmp186_ = vala_array_type_get_element_type (VALA_ARRAY_TYPE (_tmp185_));
						_tmp187_ = vala_data_type_get_data_type (_tmp186_);
						_tmp188_ = vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->string_type);
						if (_tmp187_ == _tmp188_) {
							gchar* _tmp189_;
							gchar* _tmp190_;
							_tmp189_ = g_strdup ("g_value_get_boxed");
							_tmp190_ = _tmp189_;
							_g_free0 (get_value_function);
							get_value_function = _tmp190_;
						} else {
							gchar* _tmp191_;
							gchar* _tmp192_;
							_tmp191_ = g_strdup ("g_value_get_pointer");
							_tmp192_ = _tmp191_;
							_g_free0 (get_value_function);
							get_value_function = _tmp192_;
						}
					}
				} else {
					gboolean _tmp193_ = FALSE;
					ValaDataType* _tmp194_ = NULL;
					_tmp194_ = vala_variable_get_variable_type ((ValaVariable*) p);
					if (VALA_IS_POINTER_TYPE (_tmp194_)) {
						_tmp193_ = TRUE;
					} else {
						ValaDataType* _tmp195_ = NULL;
						ValaTypeParameter* _tmp196_ = NULL;
						_tmp195_ = vala_variable_get_variable_type ((ValaVariable*) p);
						_tmp196_ = vala_data_type_get_type_parameter (_tmp195_);
						_tmp193_ = _tmp196_ != NULL;
					}
					if (_tmp193_) {
						gchar* _tmp197_;
						gchar* _tmp198_;
						_tmp197_ = g_strdup ("g_value_get_pointer");
						_tmp198_ = _tmp197_;
						_g_free0 (get_value_function);
						get_value_function = _tmp198_;
					} else {
						ValaDataType* _tmp199_ = NULL;
						_tmp199_ = vala_variable_get_variable_type ((ValaVariable*) p);
						if (VALA_IS_ERROR_TYPE (_tmp199_)) {
							gchar* _tmp200_;
							gchar* _tmp201_;
							_tmp200_ = g_strdup ("g_value_get_pointer");
							_tmp201_ = _tmp200_;
							_g_free0 (get_value_function);
							get_value_function = _tmp201_;
						} else {
							gboolean _tmp202_ = FALSE;
							if (dbus) {
								ValaDataType* _tmp203_ = NULL;
								gchar* _tmp204_ = NULL;
								gchar* _tmp205_;
								gboolean _tmp206_;
								_tmp203_ = vala_variable_get_variable_type ((ValaVariable*) p);
								_tmp204_ = vala_dbus_module_get_type_signature (_tmp203_);
								_tmp205_ = _tmp204_;
								_tmp206_ = g_str_has_prefix (_tmp205_, "(");
								_tmp202_ = _tmp206_;
								_g_free0 (_tmp205_);
							} else {
								_tmp202_ = FALSE;
							}
							if (_tmp202_) {
								gchar* _tmp207_;
								gchar* _tmp208_;
								_tmp207_ = g_strdup ("g_value_get_boxed");
								_tmp208_ = _tmp207_;
								_g_free0 (get_value_function);
								get_value_function = _tmp208_;
							} else {
								gboolean _tmp209_ = FALSE;
								if (dbus) {
									ValaDataType* _tmp210_ = NULL;
									ValaTypeSymbol* _tmp211_ = NULL;
									_tmp210_ = vala_variable_get_variable_type ((ValaVariable*) p);
									_tmp211_ = vala_data_type_get_data_type (_tmp210_);
									_tmp209_ = VALA_IS_ENUM (_tmp211_);
								} else {
									_tmp209_ = FALSE;
								}
								if (_tmp209_) {
									ValaDataType* _tmp212_ = NULL;
									ValaTypeSymbol* _tmp213_ = NULL;
									ValaEnum* _tmp214_;
									ValaEnum* en;
									gboolean _tmp215_;
									_tmp212_ = vala_variable_get_variable_type ((ValaVariable*) p);
									_tmp213_ = vala_data_type_get_data_type (_tmp212_);
									_tmp214_ = _vala_code_node_ref0 (VALA_ENUM (_tmp213_));
									en = _tmp214_;
									_tmp215_ = vala_enum_get_is_flags (en);
									if (_tmp215_) {
										gchar* _tmp216_;
										gchar* _tmp217_;
										_tmp216_ = g_strdup ("g_value_get_uint");
										_tmp217_ = _tmp216_;
										_g_free0 (get_value_function);
										get_value_function = _tmp217_;
									} else {
										gchar* _tmp218_;
										gchar* _tmp219_;
										_tmp218_ = g_strdup ("g_value_get_int");
										_tmp219_ = _tmp218_;
										_g_free0 (get_value_function);
										get_value_function = _tmp219_;
									}
									_vala_code_node_unref0 (en);
								} else {
									ValaDataType* _tmp220_ = NULL;
									ValaTypeSymbol* _tmp221_ = NULL;
									gchar* _tmp222_ = NULL;
									gchar* _tmp223_;
									_tmp220_ = vala_variable_get_variable_type ((ValaVariable*) p);
									_tmp221_ = vala_data_type_get_data_type (_tmp220_);
									_tmp222_ = vala_typesymbol_get_get_value_function (_tmp221_);
									_tmp223_ = _tmp222_;
									_g_free0 (get_value_function);
									get_value_function = _tmp223_;
								}
							}
						}
					}
				}
			}
			_tmp224_ = vala_ccode_identifier_new (get_value_function);
			_tmp225_ = _tmp224_;
			_tmp226_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp225_);
			inner_fc = (_tmp227_ = _tmp226_, _vala_ccode_node_unref0 (_tmp225_), _tmp227_);
			_tmp228_ = vala_ccode_identifier_new ("param_values");
			_tmp229_ = _tmp228_;
			_tmp230_ = g_strdup_printf ("%i", i);
			_tmp231_ = _tmp230_;
			_tmp232_ = vala_ccode_identifier_new (_tmp231_);
			_tmp233_ = _tmp232_;
			_tmp234_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) _tmp229_, (ValaCCodeExpression*) _tmp233_);
			_tmp235_ = _tmp234_;
			vala_ccode_function_call_add_argument (inner_fc, (ValaCCodeExpression*) _tmp235_);
			_vala_ccode_node_unref0 (_tmp235_);
			_vala_ccode_node_unref0 (_tmp233_);
			_g_free0 (_tmp231_);
			_vala_ccode_node_unref0 (_tmp229_);
			vala_ccode_function_call_add_argument (fc, (ValaCCodeExpression*) inner_fc);
			i++;
			if (is_array) {
				_tmp236_ = !dbus;
			} else {
				_tmp236_ = FALSE;
			}
			if (_tmp236_) {
				ValaCCodeIdentifier* _tmp237_ = NULL;
				ValaCCodeIdentifier* _tmp238_;
				ValaCCodeFunctionCall* _tmp239_ = NULL;
				ValaCCodeFunctionCall* _tmp240_;
				ValaCCodeIdentifier* _tmp241_ = NULL;
				ValaCCodeIdentifier* _tmp242_;
				gchar* _tmp243_ = NULL;
				gchar* _tmp244_;
				ValaCCodeIdentifier* _tmp245_ = NULL;
				ValaCCodeIdentifier* _tmp246_;
				ValaCCodeBinaryExpression* _tmp247_ = NULL;
				ValaCCodeBinaryExpression* _tmp248_;
				_tmp237_ = vala_ccode_identifier_new ("g_value_get_int");
				_tmp238_ = _tmp237_;
				_tmp239_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp238_);
				_tmp240_ = _tmp239_;
				_vala_ccode_node_unref0 (inner_fc);
				inner_fc = _tmp240_;
				_vala_ccode_node_unref0 (_tmp238_);
				_tmp241_ = vala_ccode_identifier_new ("param_values");
				_tmp242_ = _tmp241_;
				_tmp243_ = g_strdup_printf ("%i", i);
				_tmp244_ = _tmp243_;
				_tmp245_ = vala_ccode_identifier_new (_tmp244_);
				_tmp246_ = _tmp245_;
				_tmp247_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) _tmp242_, (ValaCCodeExpression*) _tmp246_);
				_tmp248_ = _tmp247_;
				vala_ccode_function_call_add_argument (inner_fc, (ValaCCodeExpression*) _tmp248_);
				_vala_ccode_node_unref0 (_tmp248_);
				_vala_ccode_node_unref0 (_tmp246_);
				_g_free0 (_tmp244_);
				_vala_ccode_node_unref0 (_tmp242_);
				vala_ccode_function_call_add_argument (fc, (ValaCCodeExpression*) inner_fc);
				i++;
			}
			_vala_ccode_node_unref0 (inner_fc);
			_g_free0 (get_value_function);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	_tmp249_ = vala_ccode_identifier_new ("data2");
	_tmp250_ = _tmp249_;
	vala_ccode_function_call_add_argument (fc, (ValaCCodeExpression*) _tmp250_);
	_vala_ccode_node_unref0 (_tmp250_);
	_tmp252_ = vala_data_type_get_data_type (return_type);
	if (_tmp252_ != NULL) {
		_tmp251_ = TRUE;
	} else {
		gboolean _tmp253_;
		_tmp253_ = vala_data_type_is_array (return_type);
		_tmp251_ = _tmp253_;
	}
	if (_tmp251_) {
		ValaCCodeIdentifier* _tmp254_ = NULL;
		ValaCCodeIdentifier* _tmp255_;
		ValaCCodeAssignment* _tmp256_ = NULL;
		ValaCCodeAssignment* _tmp257_;
		ValaCCodeExpressionStatement* _tmp258_ = NULL;
		ValaCCodeExpressionStatement* _tmp259_;
		ValaCCodeFunctionCall* set_fc;
		gboolean _tmp260_;
		ValaCCodeIdentifier* _tmp326_ = NULL;
		ValaCCodeIdentifier* _tmp327_;
		ValaCCodeIdentifier* _tmp328_ = NULL;
		ValaCCodeIdentifier* _tmp329_;
		ValaCCodeExpressionStatement* _tmp330_ = NULL;
		ValaCCodeExpressionStatement* _tmp331_;
		_tmp254_ = vala_ccode_identifier_new ("v_return");
		_tmp255_ = _tmp254_;
		_tmp256_ = vala_ccode_assignment_new ((ValaCCodeExpression*) _tmp255_, (ValaCCodeExpression*) fc, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
		_tmp257_ = _tmp256_;
		_tmp258_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) _tmp257_);
		_tmp259_ = _tmp258_;
		vala_ccode_block_add_statement (marshaller_body, (ValaCCodeNode*) _tmp259_);
		_vala_ccode_node_unref0 (_tmp259_);
		_vala_ccode_node_unref0 (_tmp257_);
		_vala_ccode_node_unref0 (_tmp255_);
		set_fc = NULL;
		_tmp260_ = vala_data_type_is_array (return_type);
		if (_tmp260_) {
			if (dbus) {
				ValaCCodeIdentifier* _tmp261_ = NULL;
				ValaCCodeIdentifier* _tmp262_;
				ValaCCodeFunctionCall* _tmp263_ = NULL;
				ValaCCodeFunctionCall* _tmp264_;
				_tmp261_ = vala_ccode_identifier_new ("g_value_take_boxed");
				_tmp262_ = _tmp261_;
				_tmp263_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp262_);
				_tmp264_ = _tmp263_;
				_vala_ccode_node_unref0 (set_fc);
				set_fc = _tmp264_;
				_vala_ccode_node_unref0 (_tmp262_);
			} else {
				ValaDataType* _tmp265_ = NULL;
				ValaTypeSymbol* _tmp266_ = NULL;
				ValaTypeSymbol* _tmp267_ = NULL;
				_tmp265_ = vala_array_type_get_element_type (VALA_ARRAY_TYPE (return_type));
				_tmp266_ = vala_data_type_get_data_type (_tmp265_);
				_tmp267_ = vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->string_type);
				if (_tmp266_ == _tmp267_) {
					ValaCCodeIdentifier* _tmp268_ = NULL;
					ValaCCodeIdentifier* _tmp269_;
					ValaCCodeFunctionCall* _tmp270_ = NULL;
					ValaCCodeFunctionCall* _tmp271_;
					_tmp268_ = vala_ccode_identifier_new ("g_value_take_boxed");
					_tmp269_ = _tmp268_;
					_tmp270_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp269_);
					_tmp271_ = _tmp270_;
					_vala_ccode_node_unref0 (set_fc);
					set_fc = _tmp271_;
					_vala_ccode_node_unref0 (_tmp269_);
				} else {
					ValaCCodeIdentifier* _tmp272_ = NULL;
					ValaCCodeIdentifier* _tmp273_;
					ValaCCodeFunctionCall* _tmp274_ = NULL;
					ValaCCodeFunctionCall* _tmp275_;
					_tmp272_ = vala_ccode_identifier_new ("g_value_set_pointer");
					_tmp273_ = _tmp272_;
					_tmp274_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp273_);
					_tmp275_ = _tmp274_;
					_vala_ccode_node_unref0 (set_fc);
					set_fc = _tmp275_;
					_vala_ccode_node_unref0 (_tmp273_);
				}
			}
		} else {
			ValaTypeParameter* _tmp276_ = NULL;
			_tmp276_ = vala_data_type_get_type_parameter (return_type);
			if (_tmp276_ != NULL) {
				ValaCCodeIdentifier* _tmp277_ = NULL;
				ValaCCodeIdentifier* _tmp278_;
				ValaCCodeFunctionCall* _tmp279_ = NULL;
				ValaCCodeFunctionCall* _tmp280_;
				_tmp277_ = vala_ccode_identifier_new ("g_value_set_pointer");
				_tmp278_ = _tmp277_;
				_tmp279_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp278_);
				_tmp280_ = _tmp279_;
				_vala_ccode_node_unref0 (set_fc);
				set_fc = _tmp280_;
				_vala_ccode_node_unref0 (_tmp278_);
			} else {
				if (VALA_IS_ERROR_TYPE (return_type)) {
					ValaCCodeIdentifier* _tmp281_ = NULL;
					ValaCCodeIdentifier* _tmp282_;
					ValaCCodeFunctionCall* _tmp283_ = NULL;
					ValaCCodeFunctionCall* _tmp284_;
					_tmp281_ = vala_ccode_identifier_new ("g_value_set_pointer");
					_tmp282_ = _tmp281_;
					_tmp283_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp282_);
					_tmp284_ = _tmp283_;
					_vala_ccode_node_unref0 (set_fc);
					set_fc = _tmp284_;
					_vala_ccode_node_unref0 (_tmp282_);
				} else {
					ValaTypeSymbol* _tmp285_ = NULL;
					ValaTypeSymbol* _tmp286_ = NULL;
					_tmp285_ = vala_data_type_get_data_type (return_type);
					_tmp286_ = vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->string_type);
					if (_tmp285_ == _tmp286_) {
						ValaCCodeIdentifier* _tmp287_ = NULL;
						ValaCCodeIdentifier* _tmp288_;
						ValaCCodeFunctionCall* _tmp289_ = NULL;
						ValaCCodeFunctionCall* _tmp290_;
						_tmp287_ = vala_ccode_identifier_new ("g_value_take_string");
						_tmp288_ = _tmp287_;
						_tmp289_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp288_);
						_tmp290_ = _tmp289_;
						_vala_ccode_node_unref0 (set_fc);
						set_fc = _tmp290_;
						_vala_ccode_node_unref0 (_tmp288_);
					} else {
						gboolean _tmp291_ = FALSE;
						ValaTypeSymbol* _tmp292_ = NULL;
						_tmp292_ = vala_data_type_get_data_type (return_type);
						if (VALA_IS_CLASS (_tmp292_)) {
							_tmp291_ = TRUE;
						} else {
							ValaTypeSymbol* _tmp293_ = NULL;
							_tmp293_ = vala_data_type_get_data_type (return_type);
							_tmp291_ = VALA_IS_INTERFACE (_tmp293_);
						}
						if (_tmp291_) {
							ValaCCodeIdentifier* _tmp294_ = NULL;
							ValaCCodeIdentifier* _tmp295_;
							ValaCCodeFunctionCall* _tmp296_ = NULL;
							ValaCCodeFunctionCall* _tmp297_;
							_tmp294_ = vala_ccode_identifier_new ("g_value_take_object");
							_tmp295_ = _tmp294_;
							_tmp296_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp295_);
							_tmp297_ = _tmp296_;
							_vala_ccode_node_unref0 (set_fc);
							set_fc = _tmp297_;
							_vala_ccode_node_unref0 (_tmp295_);
						} else {
							gboolean _tmp298_ = FALSE;
							if (dbus) {
								gchar* _tmp299_ = NULL;
								gchar* _tmp300_;
								gboolean _tmp301_;
								_tmp299_ = vala_dbus_module_get_type_signature (return_type);
								_tmp300_ = _tmp299_;
								_tmp301_ = g_str_has_prefix (_tmp300_, "(");
								_tmp298_ = _tmp301_;
								_g_free0 (_tmp300_);
							} else {
								_tmp298_ = FALSE;
							}
							if (_tmp298_) {
								ValaCCodeIdentifier* _tmp302_ = NULL;
								ValaCCodeIdentifier* _tmp303_;
								ValaCCodeFunctionCall* _tmp304_ = NULL;
								ValaCCodeFunctionCall* _tmp305_;
								_tmp302_ = vala_ccode_identifier_new ("g_value_take_boxed");
								_tmp303_ = _tmp302_;
								_tmp304_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp303_);
								_tmp305_ = _tmp304_;
								_vala_ccode_node_unref0 (set_fc);
								set_fc = _tmp305_;
								_vala_ccode_node_unref0 (_tmp303_);
							} else {
								gboolean _tmp306_ = FALSE;
								if (dbus) {
									ValaTypeSymbol* _tmp307_ = NULL;
									_tmp307_ = vala_data_type_get_data_type (return_type);
									_tmp306_ = VALA_IS_ENUM (_tmp307_);
								} else {
									_tmp306_ = FALSE;
								}
								if (_tmp306_) {
									ValaTypeSymbol* _tmp308_ = NULL;
									ValaEnum* _tmp309_;
									ValaEnum* en;
									gboolean _tmp310_;
									_tmp308_ = vala_data_type_get_data_type (return_type);
									_tmp309_ = _vala_code_node_ref0 (VALA_ENUM (_tmp308_));
									en = _tmp309_;
									_tmp310_ = vala_enum_get_is_flags (en);
									if (_tmp310_) {
										ValaCCodeIdentifier* _tmp311_ = NULL;
										ValaCCodeIdentifier* _tmp312_;
										ValaCCodeFunctionCall* _tmp313_ = NULL;
										ValaCCodeFunctionCall* _tmp314_;
										_tmp311_ = vala_ccode_identifier_new ("g_value_set_uint");
										_tmp312_ = _tmp311_;
										_tmp313_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp312_);
										_tmp314_ = _tmp313_;
										_vala_ccode_node_unref0 (set_fc);
										set_fc = _tmp314_;
										_vala_ccode_node_unref0 (_tmp312_);
									} else {
										ValaCCodeIdentifier* _tmp315_ = NULL;
										ValaCCodeIdentifier* _tmp316_;
										ValaCCodeFunctionCall* _tmp317_ = NULL;
										ValaCCodeFunctionCall* _tmp318_;
										_tmp315_ = vala_ccode_identifier_new ("g_value_set_int");
										_tmp316_ = _tmp315_;
										_tmp317_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp316_);
										_tmp318_ = _tmp317_;
										_vala_ccode_node_unref0 (set_fc);
										set_fc = _tmp318_;
										_vala_ccode_node_unref0 (_tmp316_);
									}
									_vala_code_node_unref0 (en);
								} else {
									ValaTypeSymbol* _tmp319_ = NULL;
									gchar* _tmp320_ = NULL;
									gchar* _tmp321_;
									ValaCCodeIdentifier* _tmp322_ = NULL;
									ValaCCodeIdentifier* _tmp323_;
									ValaCCodeFunctionCall* _tmp324_ = NULL;
									ValaCCodeFunctionCall* _tmp325_;
									_tmp319_ = vala_data_type_get_data_type (return_type);
									_tmp320_ = vala_typesymbol_get_set_value_function (_tmp319_);
									_tmp321_ = _tmp320_;
									_tmp322_ = vala_ccode_identifier_new (_tmp321_);
									_tmp323_ = _tmp322_;
									_tmp324_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp323_);
									_tmp325_ = _tmp324_;
									_vala_ccode_node_unref0 (set_fc);
									set_fc = _tmp325_;
									_vala_ccode_node_unref0 (_tmp323_);
									_g_free0 (_tmp321_);
								}
							}
						}
					}
				}
			}
		}
		_tmp326_ = vala_ccode_identifier_new ("return_value");
		_tmp327_ = _tmp326_;
		vala_ccode_function_call_add_argument (set_fc, (ValaCCodeExpression*) _tmp327_);
		_vala_ccode_node_unref0 (_tmp327_);
		_tmp328_ = vala_ccode_identifier_new ("v_return");
		_tmp329_ = _tmp328_;
		vala_ccode_function_call_add_argument (set_fc, (ValaCCodeExpression*) _tmp329_);
		_vala_ccode_node_unref0 (_tmp329_);
		_tmp330_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) set_fc);
		_tmp331_ = _tmp330_;
		vala_ccode_block_add_statement (marshaller_body, (ValaCCodeNode*) _tmp331_);
		_vala_ccode_node_unref0 (_tmp331_);
		_vala_ccode_node_unref0 (set_fc);
	} else {
		ValaCCodeExpressionStatement* _tmp332_ = NULL;
		ValaCCodeExpressionStatement* _tmp333_;
		_tmp332_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) fc);
		_tmp333_ = _tmp332_;
		vala_ccode_block_add_statement (marshaller_body, (ValaCCodeNode*) _tmp333_);
		_vala_ccode_node_unref0 (_tmp333_);
	}
	vala_ccode_function_set_block (signal_marshaller, marshaller_body);
	vala_ccode_file_add_function (((ValaCCodeBaseModule*) self)->cfile, signal_marshaller);
	vala_collection_add ((ValaCollection*) ((ValaCCodeBaseModule*) self)->user_marshal_set, signature);
	_vala_ccode_node_unref0 (c_assign);
	_vala_ccode_node_unref0 (false_block);
	_vala_ccode_node_unref0 (true_block);
	_vala_ccode_node_unref0 (cond);
	_vala_ccode_node_unref0 (param);
	_vala_ccode_node_unref0 (data);
	_vala_ccode_node_unref0 (fc);
	_vala_ccode_node_unref0 (var_decl);
	_vala_ccode_node_unref0 (callback_decl);
	_vala_ccode_node_unref0 (marshaller_body);
	_vala_ccode_node_unref0 (signal_marshaller);
	_g_free0 (signature);
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add4 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add5 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add6 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add7 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static ValaCCodeFunctionCall* vala_gsignal_module_real_get_signal_creation (ValaCCodeBaseModule* base, ValaSignal* sig, ValaTypeSymbol* type) {
	ValaGSignalModule * self;
	ValaCCodeFunctionCall* result = NULL;
	ValaCCodeIdentifier* _tmp0_ = NULL;
	ValaCCodeIdentifier* _tmp1_;
	ValaCCodeFunctionCall* _tmp2_ = NULL;
	ValaCCodeFunctionCall* _tmp3_;
	ValaCCodeFunctionCall* csignew;
	ValaSymbol* _tmp4_ = NULL;
	ValaSymbol* _tmp5_;
	ValaClass* _tmp6_;
	ValaClass* cl;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	ValaCCodeConstant* _tmp11_ = NULL;
	ValaCCodeConstant* _tmp12_;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_;
	ValaCCodeIdentifier* _tmp15_ = NULL;
	ValaCCodeIdentifier* _tmp16_;
	gchar** _tmp17_ = NULL;
	gint flags_length1;
	gint _flags_size_;
	gchar** _tmp18_;
	gchar** flags;
	const gchar* _tmp19_ = NULL;
	gboolean _tmp24_;
	gboolean _tmp26_;
	gboolean _tmp28_;
	gboolean _tmp30_;
	gchar* _tmp32_ = NULL;
	gchar* _tmp33_;
	ValaCCodeConstant* _tmp34_ = NULL;
	ValaCCodeConstant* _tmp35_;
	ValaMethod* _tmp36_ = NULL;
	ValaCCodeConstant* _tmp53_ = NULL;
	ValaCCodeConstant* _tmp54_;
	ValaCCodeConstant* _tmp55_ = NULL;
	ValaCCodeConstant* _tmp56_;
	ValaList* _tmp57_ = NULL;
	ValaList* _tmp58_;
	ValaDataType* _tmp59_ = NULL;
	gchar* _tmp60_ = NULL;
	gchar* _tmp61_;
	gchar* marshaller;
	ValaCCodeIdentifier* _tmp62_ = NULL;
	ValaCCodeIdentifier* marshal_arg;
	ValaList* _tmp63_ = NULL;
	ValaList* params;
	gboolean _tmp64_ = FALSE;
	ValaDataType* _tmp65_ = NULL;
	gint params_len;
	gchar* _tmp88_ = NULL;
	gchar* _tmp89_;
	ValaCCodeConstant* _tmp90_ = NULL;
	ValaCCodeConstant* _tmp91_;
	self = (ValaGSignalModule*) base;
	g_return_val_if_fail (sig != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	_tmp0_ = vala_ccode_identifier_new ("g_signal_new");
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1_);
	csignew = (_tmp3_ = _tmp2_, _vala_ccode_node_unref0 (_tmp1_), _tmp3_);
	_tmp4_ = vala_symbol_get_parent_symbol ((ValaSymbol*) sig);
	_tmp6_ = _vala_code_node_ref0 ((_tmp5_ = _tmp4_, VALA_IS_CLASS (_tmp5_) ? ((ValaClass*) _tmp5_) : NULL));
	cl = _tmp6_;
	_tmp7_ = vala_signal_get_cname (sig);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strdup_printf ("\"%s\"", _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_ccode_constant_new (_tmp10_);
	_tmp12_ = _tmp11_;
	vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) _tmp12_);
	_vala_ccode_node_unref0 (_tmp12_);
	_g_free0 (_tmp10_);
	_g_free0 (_tmp8_);
	_tmp13_ = vala_typesymbol_get_type_id (type);
	_tmp14_ = _tmp13_;
	_tmp15_ = vala_ccode_identifier_new (_tmp14_);
	_tmp16_ = _tmp15_;
	vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) _tmp16_);
	_vala_ccode_node_unref0 (_tmp16_);
	_g_free0 (_tmp14_);
	_tmp17_ = g_new0 (gchar*, 0 + 1);
	_tmp18_ = _tmp17_;
	flags_length1 = 0;
	_flags_size_ = flags_length1;
	flags = _tmp18_;
	_tmp19_ = vala_signal_get_run_type (sig);
	if (g_strcmp0 (_tmp19_, "first") == 0) {
		gchar* _tmp20_;
		_tmp20_ = g_strdup ("G_SIGNAL_RUN_FIRST");
		_vala_array_add1 (&flags, &flags_length1, &_flags_size_, _tmp20_);
	} else {
		const gchar* _tmp21_ = NULL;
		_tmp21_ = vala_signal_get_run_type (sig);
		if (g_strcmp0 (_tmp21_, "cleanup") == 0) {
			gchar* _tmp22_;
			_tmp22_ = g_strdup ("G_SIGNAL_RUN_CLEANUP");
			_vala_array_add2 (&flags, &flags_length1, &_flags_size_, _tmp22_);
		} else {
			gchar* _tmp23_;
			_tmp23_ = g_strdup ("G_SIGNAL_RUN_LAST");
			_vala_array_add3 (&flags, &flags_length1, &_flags_size_, _tmp23_);
		}
	}
	_tmp24_ = vala_signal_get_is_detailed (sig);
	if (_tmp24_) {
		gchar* _tmp25_;
		_tmp25_ = g_strdup ("G_SIGNAL_DETAILED");
		_vala_array_add4 (&flags, &flags_length1, &_flags_size_, _tmp25_);
	}
	_tmp26_ = vala_signal_get_no_recurse (sig);
	if (_tmp26_) {
		gchar* _tmp27_;
		_tmp27_ = g_strdup ("G_SIGNAL_NO_RECURSE");
		_vala_array_add5 (&flags, &flags_length1, &_flags_size_, _tmp27_);
	}
	_tmp28_ = vala_signal_get_is_action (sig);
	if (_tmp28_) {
		gchar* _tmp29_;
		_tmp29_ = g_strdup ("G_SIGNAL_ACTION");
		_vala_array_add6 (&flags, &flags_length1, &_flags_size_, _tmp29_);
	}
	_tmp30_ = vala_signal_get_no_hooks (sig);
	if (_tmp30_) {
		gchar* _tmp31_;
		_tmp31_ = g_strdup ("G_SIGNAL_NO_HOOKS");
		_vala_array_add7 (&flags, &flags_length1, &_flags_size_, _tmp31_);
	}
	_tmp32_ = g_strjoinv (" | ", flags);
	_tmp33_ = _tmp32_;
	_tmp34_ = vala_ccode_constant_new (_tmp33_);
	_tmp35_ = _tmp34_;
	vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) _tmp35_);
	_vala_ccode_node_unref0 (_tmp35_);
	_g_free0 (_tmp33_);
	_tmp36_ = vala_signal_get_default_handler (sig);
	if (_tmp36_ == NULL) {
		ValaCCodeConstant* _tmp37_ = NULL;
		ValaCCodeConstant* _tmp38_;
		_tmp37_ = vala_ccode_constant_new ("0");
		_tmp38_ = _tmp37_;
		vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) _tmp38_);
		_vala_ccode_node_unref0 (_tmp38_);
	} else {
		ValaCCodeIdentifier* _tmp39_ = NULL;
		ValaCCodeIdentifier* _tmp40_;
		ValaCCodeFunctionCall* _tmp41_ = NULL;
		ValaCCodeFunctionCall* _tmp42_;
		ValaCCodeFunctionCall* struct_offset;
		gchar* _tmp43_ = NULL;
		gchar* _tmp44_;
		gchar* _tmp45_ = NULL;
		gchar* _tmp46_;
		ValaCCodeIdentifier* _tmp47_ = NULL;
		ValaCCodeIdentifier* _tmp48_;
		ValaMethod* _tmp49_ = NULL;
		const gchar* _tmp50_ = NULL;
		ValaCCodeIdentifier* _tmp51_ = NULL;
		ValaCCodeIdentifier* _tmp52_;
		_tmp39_ = vala_ccode_identifier_new ("G_STRUCT_OFFSET");
		_tmp40_ = _tmp39_;
		_tmp41_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp40_);
		struct_offset = (_tmp42_ = _tmp41_, _vala_ccode_node_unref0 (_tmp40_), _tmp42_);
		_tmp43_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE);
		_tmp44_ = _tmp43_;
		_tmp45_ = g_strdup_printf ("%sClass", _tmp44_);
		_tmp46_ = _tmp45_;
		_tmp47_ = vala_ccode_identifier_new (_tmp46_);
		_tmp48_ = _tmp47_;
		vala_ccode_function_call_add_argument (struct_offset, (ValaCCodeExpression*) _tmp48_);
		_vala_ccode_node_unref0 (_tmp48_);
		_g_free0 (_tmp46_);
		_g_free0 (_tmp44_);
		_tmp49_ = vala_signal_get_default_handler (sig);
		_tmp50_ = vala_method_get_vfunc_name (_tmp49_);
		_tmp51_ = vala_ccode_identifier_new (_tmp50_);
		_tmp52_ = _tmp51_;
		vala_ccode_function_call_add_argument (struct_offset, (ValaCCodeExpression*) _tmp52_);
		_vala_ccode_node_unref0 (_tmp52_);
		vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) struct_offset);
		_vala_ccode_node_unref0 (struct_offset);
	}
	_tmp53_ = vala_ccode_constant_new ("NULL");
	_tmp54_ = _tmp53_;
	vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) _tmp54_);
	_vala_ccode_node_unref0 (_tmp54_);
	_tmp55_ = vala_ccode_constant_new ("NULL");
	_tmp56_ = _tmp55_;
	vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) _tmp56_);
	_vala_ccode_node_unref0 (_tmp56_);
	_tmp57_ = vala_signal_get_parameters (sig);
	_tmp58_ = _tmp57_;
	_tmp59_ = vala_signal_get_return_type (sig);
	_tmp60_ = vala_ccode_base_module_get_marshaller_function ((ValaCCodeBaseModule*) self, _tmp58_, _tmp59_, NULL, FALSE);
	marshaller = (_tmp61_ = _tmp60_, _vala_iterable_unref0 (_tmp58_), _tmp61_);
	_tmp62_ = vala_ccode_identifier_new (marshaller);
	marshal_arg = _tmp62_;
	vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) marshal_arg);
	_tmp63_ = vala_signal_get_parameters (sig);
	params = _tmp63_;
	_tmp65_ = vala_signal_get_return_type (sig);
	if (VALA_IS_POINTER_TYPE (_tmp65_)) {
		_tmp64_ = TRUE;
	} else {
		ValaDataType* _tmp66_ = NULL;
		ValaTypeParameter* _tmp67_ = NULL;
		_tmp66_ = vala_signal_get_return_type (sig);
		_tmp67_ = vala_data_type_get_type_parameter (_tmp66_);
		_tmp64_ = _tmp67_ != NULL;
	}
	if (_tmp64_) {
		ValaCCodeConstant* _tmp68_ = NULL;
		ValaCCodeConstant* _tmp69_;
		_tmp68_ = vala_ccode_constant_new ("G_TYPE_POINTER");
		_tmp69_ = _tmp68_;
		vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) _tmp69_);
		_vala_ccode_node_unref0 (_tmp69_);
	} else {
		ValaDataType* _tmp70_ = NULL;
		_tmp70_ = vala_signal_get_return_type (sig);
		if (VALA_IS_ERROR_TYPE (_tmp70_)) {
			ValaCCodeConstant* _tmp71_ = NULL;
			ValaCCodeConstant* _tmp72_;
			_tmp71_ = vala_ccode_constant_new ("G_TYPE_POINTER");
			_tmp72_ = _tmp71_;
			vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) _tmp72_);
			_vala_ccode_node_unref0 (_tmp72_);
		} else {
			ValaDataType* _tmp73_ = NULL;
			ValaTypeSymbol* _tmp74_ = NULL;
			_tmp73_ = vala_signal_get_return_type (sig);
			_tmp74_ = vala_data_type_get_data_type (_tmp73_);
			if (_tmp74_ == NULL) {
				ValaCCodeConstant* _tmp75_ = NULL;
				ValaCCodeConstant* _tmp76_;
				_tmp75_ = vala_ccode_constant_new ("G_TYPE_NONE");
				_tmp76_ = _tmp75_;
				vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) _tmp76_);
				_vala_ccode_node_unref0 (_tmp76_);
			} else {
				ValaDataType* _tmp77_ = NULL;
				ValaTypeSymbol* _tmp78_ = NULL;
				gchar* _tmp79_ = NULL;
				gchar* _tmp80_;
				ValaCCodeConstant* _tmp81_ = NULL;
				ValaCCodeConstant* _tmp82_;
				_tmp77_ = vala_signal_get_return_type (sig);
				_tmp78_ = vala_data_type_get_data_type (_tmp77_);
				_tmp79_ = vala_typesymbol_get_type_id (_tmp78_);
				_tmp80_ = _tmp79_;
				_tmp81_ = vala_ccode_constant_new (_tmp80_);
				_tmp82_ = _tmp81_;
				vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) _tmp82_);
				_vala_ccode_node_unref0 (_tmp82_);
				_g_free0 (_tmp80_);
			}
		}
	}
	params_len = 0;
	{
		ValaList* _tmp83_;
		ValaList* _param_list;
		gint _tmp84_;
		gint _param_size;
		gint _param_index;
		_tmp83_ = _vala_iterable_ref0 (params);
		_param_list = _tmp83_;
		_tmp84_ = vala_collection_get_size ((ValaCollection*) _param_list);
		_param_size = _tmp84_;
		_param_index = -1;
		while (TRUE) {
			gpointer _tmp85_ = NULL;
			ValaParameter* param;
			ValaDataType* _tmp86_ = NULL;
			gboolean _tmp87_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp85_ = vala_list_get (_param_list, _param_index);
			param = (ValaParameter*) _tmp85_;
			params_len++;
			_tmp86_ = vala_variable_get_variable_type ((ValaVariable*) param);
			_tmp87_ = vala_data_type_is_array (_tmp86_);
			if (_tmp87_) {
				params_len++;
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp88_ = g_strdup_printf ("%d", params_len);
	_tmp89_ = _tmp88_;
	_tmp90_ = vala_ccode_constant_new (_tmp89_);
	_tmp91_ = _tmp90_;
	vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) _tmp91_);
	_vala_ccode_node_unref0 (_tmp91_);
	_g_free0 (_tmp89_);
	{
		ValaList* _tmp92_;
		ValaList* _param_list;
		gint _tmp93_;
		gint _param_size;
		gint _param_index;
		_tmp92_ = _vala_iterable_ref0 (params);
		_param_list = _tmp92_;
		_tmp93_ = vala_collection_get_size ((ValaCollection*) _param_list);
		_param_size = _tmp93_;
		_param_index = -1;
		while (TRUE) {
			gpointer _tmp94_ = NULL;
			ValaParameter* param;
			ValaDataType* _tmp95_ = NULL;
			gboolean _tmp96_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp94_ = vala_list_get (_param_list, _param_index);
			param = (ValaParameter*) _tmp94_;
			_tmp95_ = vala_variable_get_variable_type ((ValaVariable*) param);
			_tmp96_ = vala_data_type_is_array (_tmp95_);
			if (_tmp96_) {
				ValaDataType* _tmp97_ = NULL;
				ValaDataType* _tmp98_ = NULL;
				ValaTypeSymbol* _tmp99_ = NULL;
				ValaTypeSymbol* _tmp100_ = NULL;
				ValaCCodeConstant* _tmp105_ = NULL;
				ValaCCodeConstant* _tmp106_;
				_tmp97_ = vala_variable_get_variable_type ((ValaVariable*) param);
				_tmp98_ = vala_array_type_get_element_type (VALA_ARRAY_TYPE (_tmp97_));
				_tmp99_ = vala_data_type_get_data_type (_tmp98_);
				_tmp100_ = vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->string_type);
				if (_tmp99_ == _tmp100_) {
					ValaCCodeConstant* _tmp101_ = NULL;
					ValaCCodeConstant* _tmp102_;
					_tmp101_ = vala_ccode_constant_new ("G_TYPE_STRV");
					_tmp102_ = _tmp101_;
					vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) _tmp102_);
					_vala_ccode_node_unref0 (_tmp102_);
				} else {
					ValaCCodeConstant* _tmp103_ = NULL;
					ValaCCodeConstant* _tmp104_;
					_tmp103_ = vala_ccode_constant_new ("G_TYPE_POINTER");
					_tmp104_ = _tmp103_;
					vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) _tmp104_);
					_vala_ccode_node_unref0 (_tmp104_);
				}
				_tmp105_ = vala_ccode_constant_new ("G_TYPE_INT");
				_tmp106_ = _tmp105_;
				vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) _tmp106_);
				_vala_ccode_node_unref0 (_tmp106_);
			} else {
				gboolean _tmp107_ = FALSE;
				gboolean _tmp108_ = FALSE;
				ValaDataType* _tmp109_ = NULL;
				_tmp109_ = vala_variable_get_variable_type ((ValaVariable*) param);
				if (VALA_IS_POINTER_TYPE (_tmp109_)) {
					_tmp108_ = TRUE;
				} else {
					ValaDataType* _tmp110_ = NULL;
					ValaTypeParameter* _tmp111_ = NULL;
					_tmp110_ = vala_variable_get_variable_type ((ValaVariable*) param);
					_tmp111_ = vala_data_type_get_type_parameter (_tmp110_);
					_tmp108_ = _tmp111_ != NULL;
				}
				if (_tmp108_) {
					_tmp107_ = TRUE;
				} else {
					ValaParameterDirection _tmp112_;
					_tmp112_ = vala_parameter_get_direction (param);
					_tmp107_ = _tmp112_ != VALA_PARAMETER_DIRECTION_IN;
				}
				if (_tmp107_) {
					ValaCCodeConstant* _tmp113_ = NULL;
					ValaCCodeConstant* _tmp114_;
					_tmp113_ = vala_ccode_constant_new ("G_TYPE_POINTER");
					_tmp114_ = _tmp113_;
					vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) _tmp114_);
					_vala_ccode_node_unref0 (_tmp114_);
				} else {
					ValaDataType* _tmp115_ = NULL;
					_tmp115_ = vala_variable_get_variable_type ((ValaVariable*) param);
					if (VALA_IS_ERROR_TYPE (_tmp115_)) {
						ValaCCodeConstant* _tmp116_ = NULL;
						ValaCCodeConstant* _tmp117_;
						_tmp116_ = vala_ccode_constant_new ("G_TYPE_POINTER");
						_tmp117_ = _tmp116_;
						vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) _tmp117_);
						_vala_ccode_node_unref0 (_tmp117_);
					} else {
						ValaDataType* _tmp118_ = NULL;
						ValaTypeSymbol* _tmp119_ = NULL;
						gchar* _tmp120_ = NULL;
						gchar* _tmp121_;
						ValaCCodeConstant* _tmp122_ = NULL;
						ValaCCodeConstant* _tmp123_;
						_tmp118_ = vala_variable_get_variable_type ((ValaVariable*) param);
						_tmp119_ = vala_data_type_get_data_type (_tmp118_);
						_tmp120_ = vala_typesymbol_get_type_id (_tmp119_);
						_tmp121_ = _tmp120_;
						_tmp122_ = vala_ccode_constant_new (_tmp121_);
						_tmp123_ = _tmp122_;
						vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) _tmp123_);
						_vala_ccode_node_unref0 (_tmp123_);
						_g_free0 (_tmp121_);
					}
				}
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	vala_ccode_identifier_set_name (marshal_arg, marshaller);
	result = csignew;
	_vala_iterable_unref0 (params);
	_vala_ccode_node_unref0 (marshal_arg);
	_g_free0 (marshaller);
	flags = (_vala_array_free (flags, flags_length1, (GDestroyNotify) g_free), NULL);
	_vala_code_node_unref0 (cl);
	return result;
}


static ValaCCodeExpression* vala_gsignal_module_real_get_dbus_g_type (ValaGSignalModule* self, ValaDataType* data_type) {
	ValaCCodeExpression* result = NULL;
	ValaTypeSymbol* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	ValaCCodeConstant* _tmp3_ = NULL;
	ValaCCodeExpression* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (data_type != NULL, NULL);
	_tmp0_ = vala_data_type_get_data_type (data_type);
	_tmp1_ = vala_typesymbol_get_type_id (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_ccode_constant_new (_tmp2_);
	result = (_tmp4_ = (ValaCCodeExpression*) _tmp3_, _g_free0 (_tmp2_), _tmp4_);
	return result;
}


ValaCCodeExpression* vala_gsignal_module_get_dbus_g_type (ValaGSignalModule* self, ValaDataType* data_type) {
	return VALA_GSIGNAL_MODULE_GET_CLASS (self)->get_dbus_g_type (self, data_type);
}


static void vala_gsignal_module_real_visit_element_access (ValaCodeVisitor* base, ValaElementAccess* expr) {
	ValaGSignalModule * self;
	gboolean _tmp0_ = FALSE;
	ValaExpression* _tmp1_ = NULL;
	self = (ValaGSignalModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp1_ = vala_element_access_get_container (expr);
	if (VALA_IS_MEMBER_ACCESS (_tmp1_)) {
		ValaExpression* _tmp2_ = NULL;
		ValaSymbol* _tmp3_ = NULL;
		_tmp2_ = vala_element_access_get_container (expr);
		_tmp3_ = vala_expression_get_symbol_reference (_tmp2_);
		_tmp0_ = VALA_IS_SIGNAL (_tmp3_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ValaSymbol* _tmp4_ = NULL;
		ValaSignal* _tmp5_;
		ValaSignal* sig;
		ValaExpression* _tmp6_ = NULL;
		ValaMemberAccess* _tmp7_;
		ValaMemberAccess* ma;
		ValaList* _tmp8_ = NULL;
		ValaList* _tmp9_;
		gpointer _tmp10_ = NULL;
		ValaExpression* _tmp11_;
		ValaExpression* detail_expr;
		ValaCCodeExpression* _tmp12_ = NULL;
		ValaCCodeExpression* signal_name_cexpr;
		ValaCCodeIdentifier* _tmp13_ = NULL;
		ValaCCodeIdentifier* _tmp14_;
		ValaCCodeFunctionCall* _tmp15_ = NULL;
		ValaCCodeFunctionCall* _tmp16_;
		ValaCCodeFunctionCall* ccall;
		ValaExpression* _tmp17_ = NULL;
		ValaCCodeExpression* _tmp18_ = NULL;
		ValaCCodeExpression* _tmp19_;
		_tmp4_ = vala_expression_get_symbol_reference ((ValaExpression*) expr);
		_tmp5_ = _vala_code_node_ref0 (VALA_SIGNAL (_tmp4_));
		sig = _tmp5_;
		_tmp6_ = vala_element_access_get_container (expr);
		_tmp7_ = _vala_code_node_ref0 (VALA_MEMBER_ACCESS (_tmp6_));
		ma = _tmp7_;
		_tmp8_ = vala_element_access_get_indices (expr);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_list_get (_tmp9_, 0);
		detail_expr = (_tmp11_ = (ValaExpression*) _tmp10_, _vala_iterable_unref0 (_tmp9_), _tmp11_);
		_tmp12_ = vala_gsignal_module_get_signal_name_cexpression (self, sig, detail_expr, (ValaCodeNode*) expr);
		signal_name_cexpr = _tmp12_;
		_tmp13_ = vala_ccode_identifier_new ("g_signal_emit_by_name");
		_tmp14_ = _tmp13_;
		_tmp15_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp14_);
		ccall = (_tmp16_ = _tmp15_, _vala_ccode_node_unref0 (_tmp14_), _tmp16_);
		_tmp17_ = vala_member_access_get_inner (ma);
		_tmp18_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp17_);
		_tmp19_ = _tmp18_;
		vala_ccode_function_call_add_argument (ccall, _tmp19_);
		_vala_ccode_node_unref0 (_tmp19_);
		if (signal_name_cexpr != NULL) {
			vala_ccode_function_call_add_argument (ccall, signal_name_cexpr);
		}
		vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) ccall);
		_vala_ccode_node_unref0 (ccall);
		_vala_ccode_node_unref0 (signal_name_cexpr);
		_vala_code_node_unref0 (detail_expr);
		_vala_code_node_unref0 (ma);
		_vala_code_node_unref0 (sig);
	} else {
		VALA_CODE_VISITOR_CLASS (vala_gsignal_module_parent_class)->visit_element_access ((ValaCodeVisitor*) VALA_GOBJECT_MODULE (self), expr);
	}
}


static gboolean vala_gsignal_module_in_gobject_instance (ValaGSignalModule* self, ValaMethod* m) {
	gboolean result = FALSE;
	gboolean _result_;
	ValaMemberBinding _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (m != NULL, FALSE);
	_result_ = FALSE;
	_tmp0_ = vala_method_get_binding (m);
	if (_tmp0_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaParameter* _tmp1_ = NULL;
		ValaDataType* _tmp2_ = NULL;
		ValaTypeSymbol* _tmp3_ = NULL;
		gboolean _tmp4_;
		_tmp1_ = vala_method_get_this_parameter (m);
		_tmp2_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1_);
		_tmp3_ = vala_data_type_get_data_type (_tmp2_);
		_tmp4_ = vala_typesymbol_is_subtype_of (_tmp3_, ((ValaCCodeBaseModule*) self)->gobject_type);
		_result_ = _tmp4_;
	}
	result = _result_;
	return result;
}


static void vala_gsignal_module_emit_signal_assignment (ValaGSignalModule* self, ValaAssignment* assignment) {
	ValaExpression* _tmp0_ = NULL;
	ValaSymbol* _tmp1_ = NULL;
	ValaSignal* _tmp2_;
	ValaSignal* sig;
	gboolean disconnect;
	ValaAssignmentOperator _tmp3_;
	ValaExpression* _tmp6_ = NULL;
	ValaExpression* _tmp7_ = NULL;
	ValaCCodeExpression* _tmp8_ = NULL;
	ValaCCodeExpression* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (assignment != NULL);
	_tmp0_ = vala_assignment_get_left (assignment);
	_tmp1_ = vala_expression_get_symbol_reference (_tmp0_);
	_tmp2_ = _vala_code_node_ref0 (VALA_SIGNAL (_tmp1_));
	sig = _tmp2_;
	disconnect = FALSE;
	_tmp3_ = vala_assignment_get_operator (assignment);
	if (_tmp3_ == VALA_ASSIGNMENT_OPERATOR_ADD) {
	} else {
		ValaAssignmentOperator _tmp4_;
		_tmp4_ = vala_assignment_get_operator (assignment);
		if (_tmp4_ == VALA_ASSIGNMENT_OPERATOR_SUB) {
			disconnect = TRUE;
		} else {
			ValaSourceReference* _tmp5_ = NULL;
			vala_code_node_set_error ((ValaCodeNode*) assignment, TRUE);
			_tmp5_ = vala_code_node_get_source_reference ((ValaCodeNode*) assignment);
			vala_report_error (_tmp5_, "Specified compound assignment type for signals not supported.");
			_vala_code_node_unref0 (sig);
			return;
		}
	}
	_tmp6_ = vala_assignment_get_left (assignment);
	_tmp7_ = vala_assignment_get_right (assignment);
	_tmp8_ = vala_gsignal_module_connect_signal (self, sig, _tmp6_, _tmp7_, disconnect, FALSE, (ValaCodeNode*) assignment);
	_tmp9_ = _tmp8_;
	_vala_ccode_node_unref0 (_tmp9_);
	_vala_code_node_unref0 (sig);
}


static void vala_gsignal_module_real_visit_assignment (ValaCodeVisitor* base, ValaAssignment* assignment) {
	ValaGSignalModule * self;
	ValaExpression* _tmp0_ = NULL;
	ValaSymbol* _tmp1_ = NULL;
	self = (ValaGSignalModule*) base;
	g_return_if_fail (assignment != NULL);
	_tmp0_ = vala_assignment_get_left (assignment);
	_tmp1_ = vala_expression_get_symbol_reference (_tmp0_);
	if (VALA_IS_SIGNAL (_tmp1_)) {
		gboolean _tmp2_ = FALSE;
		ValaExpression* _tmp3_ = NULL;
		gboolean _tmp4_;
		_tmp3_ = vala_assignment_get_left (assignment);
		_tmp4_ = vala_code_node_get_error ((ValaCodeNode*) _tmp3_);
		if (_tmp4_) {
			_tmp2_ = TRUE;
		} else {
			ValaExpression* _tmp5_ = NULL;
			gboolean _tmp6_;
			_tmp5_ = vala_assignment_get_right (assignment);
			_tmp6_ = vala_code_node_get_error ((ValaCodeNode*) _tmp5_);
			_tmp2_ = _tmp6_;
		}
		if (_tmp2_) {
			vala_code_node_set_error ((ValaCodeNode*) assignment, TRUE);
			return;
		}
		vala_gsignal_module_emit_signal_assignment (self, assignment);
	} else {
		VALA_CODE_VISITOR_CLASS (vala_gsignal_module_parent_class)->visit_assignment ((ValaCodeVisitor*) VALA_GOBJECT_MODULE (self), assignment);
	}
}


static void vala_gsignal_module_real_visit_member_access (ValaCodeVisitor* base, ValaMemberAccess* expr) {
	ValaGSignalModule * self;
	ValaSymbol* _tmp0_ = NULL;
	self = (ValaGSignalModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) expr);
	if (VALA_IS_SIGNAL (_tmp0_)) {
		ValaCCodeExpression* pub_inst;
		ValaExpression* _tmp1_ = NULL;
		ValaSymbol* _tmp5_ = NULL;
		ValaSignal* _tmp6_;
		ValaSignal* sig;
		ValaSymbol* _tmp7_ = NULL;
		ValaTypeSymbol* _tmp8_;
		ValaTypeSymbol* cl;
		gboolean _tmp9_ = FALSE;
		ValaExpression* _tmp10_ = NULL;
		gboolean _tmp34_;
		pub_inst = NULL;
		_tmp1_ = vala_member_access_get_inner (expr);
		if (_tmp1_ != NULL) {
			ValaExpression* _tmp2_ = NULL;
			ValaCCodeExpression* _tmp3_ = NULL;
			ValaCCodeExpression* _tmp4_;
			_tmp2_ = vala_member_access_get_inner (expr);
			_tmp3_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp2_);
			_tmp4_ = _tmp3_;
			_vala_ccode_node_unref0 (pub_inst);
			pub_inst = _tmp4_;
		}
		_tmp5_ = vala_expression_get_symbol_reference ((ValaExpression*) expr);
		_tmp6_ = _vala_code_node_ref0 (VALA_SIGNAL (_tmp5_));
		sig = _tmp6_;
		_tmp7_ = vala_symbol_get_parent_symbol ((ValaSymbol*) sig);
		_tmp8_ = _vala_code_node_ref0 (VALA_TYPESYMBOL (_tmp7_));
		cl = _tmp8_;
		_tmp10_ = vala_member_access_get_inner (expr);
		if (VALA_IS_BASE_ACCESS (_tmp10_)) {
			gboolean _tmp11_;
			_tmp11_ = vala_signal_get_is_virtual (sig);
			_tmp9_ = _tmp11_;
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			ValaMethod* _tmp12_ = NULL;
			ValaMethod* _tmp13_;
			ValaMethod* m;
			ValaSymbol* _tmp14_ = NULL;
			ValaClass* _tmp15_;
			ValaClass* base_class;
			gchar* _tmp16_ = NULL;
			gchar* _tmp17_;
			gchar* _tmp18_ = NULL;
			gchar* _tmp19_;
			ValaCCodeIdentifier* _tmp20_ = NULL;
			ValaCCodeIdentifier* _tmp21_;
			ValaCCodeFunctionCall* _tmp22_ = NULL;
			ValaCCodeFunctionCall* _tmp23_;
			ValaCCodeFunctionCall* vcast;
			ValaClass* _tmp24_ = NULL;
			gchar* _tmp25_ = NULL;
			gchar* _tmp26_;
			gchar* _tmp27_ = NULL;
			gchar* _tmp28_;
			ValaCCodeIdentifier* _tmp29_ = NULL;
			ValaCCodeIdentifier* _tmp30_;
			const gchar* _tmp31_ = NULL;
			ValaCCodeMemberAccess* _tmp32_ = NULL;
			ValaCCodeMemberAccess* _tmp33_;
			_tmp12_ = vala_signal_get_default_handler (sig);
			_tmp13_ = _vala_code_node_ref0 (_tmp12_);
			m = _tmp13_;
			_tmp14_ = vala_symbol_get_parent_symbol ((ValaSymbol*) m);
			_tmp15_ = _vala_code_node_ref0 (VALA_CLASS (_tmp14_));
			base_class = _tmp15_;
			_tmp16_ = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) base_class, NULL);
			_tmp17_ = _tmp16_;
			_tmp18_ = g_strdup_printf ("%s_CLASS", _tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = vala_ccode_identifier_new (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp21_);
			vcast = (_tmp23_ = _tmp22_, _vala_ccode_node_unref0 (_tmp21_), _g_free0 (_tmp19_), _g_free0 (_tmp17_), _tmp23_);
			_tmp24_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp25_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) _tmp24_, NULL);
			_tmp26_ = _tmp25_;
			_tmp27_ = g_strdup_printf ("%s_parent_class", _tmp26_);
			_tmp28_ = _tmp27_;
			_tmp29_ = vala_ccode_identifier_new (_tmp28_);
			_tmp30_ = _tmp29_;
			vala_ccode_function_call_add_argument (vcast, (ValaCCodeExpression*) _tmp30_);
			_vala_ccode_node_unref0 (_tmp30_);
			_g_free0 (_tmp28_);
			_g_free0 (_tmp26_);
			_tmp31_ = vala_symbol_get_name ((ValaSymbol*) m);
			_tmp32_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) vcast, _tmp31_);
			_tmp33_ = _tmp32_;
			vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp33_);
			_vala_ccode_node_unref0 (_tmp33_);
			_vala_ccode_node_unref0 (vcast);
			_vala_code_node_unref0 (base_class);
			_vala_code_node_unref0 (m);
			_vala_code_node_unref0 (cl);
			_vala_code_node_unref0 (sig);
			_vala_ccode_node_unref0 (pub_inst);
			return;
		}
		_tmp34_ = vala_signal_get_has_emitter (sig);
		if (_tmp34_) {
			gchar* _tmp35_ = NULL;
			gchar* _tmp36_;
			const gchar* _tmp37_ = NULL;
			gchar* _tmp38_ = NULL;
			gchar* _tmp39_;
			ValaCCodeIdentifier* _tmp40_ = NULL;
			ValaCCodeIdentifier* _tmp41_;
			ValaCCodeFunctionCall* _tmp42_ = NULL;
			ValaCCodeFunctionCall* _tmp43_;
			ValaCCodeFunctionCall* ccall;
			_tmp35_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL);
			_tmp36_ = _tmp35_;
			_tmp37_ = vala_symbol_get_name ((ValaSymbol*) sig);
			_tmp38_ = g_strdup_printf ("%s_%s", _tmp36_, _tmp37_);
			_tmp39_ = _tmp38_;
			_tmp40_ = vala_ccode_identifier_new (_tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp41_);
			ccall = (_tmp43_ = _tmp42_, _vala_ccode_node_unref0 (_tmp41_), _g_free0 (_tmp39_), _g_free0 (_tmp36_), _tmp43_);
			vala_ccode_function_call_add_argument (ccall, pub_inst);
			vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) ccall);
			_vala_ccode_node_unref0 (ccall);
		} else {
			ValaCCodeIdentifier* _tmp44_ = NULL;
			ValaCCodeIdentifier* _tmp45_;
			ValaCCodeFunctionCall* _tmp46_ = NULL;
			ValaCCodeFunctionCall* _tmp47_;
			ValaCCodeFunctionCall* ccall;
			ValaCCodeConstant* _tmp48_ = NULL;
			ValaCCodeConstant* _tmp49_;
			_tmp44_ = vala_ccode_identifier_new ("g_signal_emit_by_name");
			_tmp45_ = _tmp44_;
			_tmp46_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp45_);
			ccall = (_tmp47_ = _tmp46_, _vala_ccode_node_unref0 (_tmp45_), _tmp47_);
			vala_ccode_function_call_add_argument (ccall, pub_inst);
			_tmp48_ = vala_signal_get_canonical_cconstant (sig, NULL);
			_tmp49_ = _tmp48_;
			vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) _tmp49_);
			_vala_ccode_node_unref0 (_tmp49_);
			vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) ccall);
			_vala_ccode_node_unref0 (ccall);
		}
		_vala_code_node_unref0 (cl);
		_vala_code_node_unref0 (sig);
		_vala_ccode_node_unref0 (pub_inst);
	} else {
		VALA_CODE_VISITOR_CLASS (vala_gsignal_module_parent_class)->visit_member_access ((ValaCodeVisitor*) VALA_GOBJECT_MODULE (self), expr);
	}
}


static void vala_gsignal_module_real_visit_method_call (ValaCodeVisitor* base, ValaMethodCall* expr) {
	ValaGSignalModule * self;
	ValaExpression* _tmp0_ = NULL;
	ValaDataType* _tmp1_ = NULL;
	ValaDataType* _tmp2_;
	ValaMethodType* _tmp3_;
	ValaMethodType* method_type;
	gboolean _tmp4_ = FALSE;
	ValaMethod* _tmp7_ = NULL;
	ValaSymbol* _tmp8_ = NULL;
	ValaSignal* _tmp9_;
	ValaSignal* sig;
	ValaExpression* _tmp10_ = NULL;
	ValaExpression* _tmp11_ = NULL;
	ValaExpression* _tmp12_;
	ValaExpression* signal_access;
	ValaList* _tmp13_ = NULL;
	ValaList* _tmp14_;
	gpointer _tmp15_ = NULL;
	ValaExpression* _tmp16_;
	ValaExpression* handler;
	ValaMethod* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	gboolean disconnect;
	ValaMethod* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	gboolean after;
	ValaCCodeExpression* _tmp21_ = NULL;
	ValaCCodeExpression* cexpr;
	self = (ValaGSignalModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_method_call_get_call (expr);
	_tmp1_ = vala_expression_get_value_type (_tmp0_);
	_tmp3_ = _vala_code_node_ref0 ((_tmp2_ = _tmp1_, VALA_IS_METHOD_TYPE (_tmp2_) ? ((ValaMethodType*) _tmp2_) : NULL));
	method_type = _tmp3_;
	if (method_type == NULL) {
		_tmp4_ = TRUE;
	} else {
		ValaMethod* _tmp5_ = NULL;
		ValaSymbol* _tmp6_ = NULL;
		_tmp5_ = vala_method_type_get_method_symbol (method_type);
		_tmp6_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp5_);
		_tmp4_ = !VALA_IS_SIGNAL (_tmp6_);
	}
	if (_tmp4_) {
		VALA_CODE_VISITOR_CLASS (vala_gsignal_module_parent_class)->visit_method_call ((ValaCodeVisitor*) VALA_GOBJECT_MODULE (self), expr);
		_vala_code_node_unref0 (method_type);
		return;
	}
	_tmp7_ = vala_method_type_get_method_symbol (method_type);
	_tmp8_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp7_);
	_tmp9_ = _vala_code_node_ref0 (VALA_SIGNAL (_tmp8_));
	sig = _tmp9_;
	_tmp10_ = vala_method_call_get_call (expr);
	_tmp11_ = vala_member_access_get_inner (VALA_MEMBER_ACCESS (_tmp10_));
	_tmp12_ = _vala_code_node_ref0 (_tmp11_);
	signal_access = _tmp12_;
	_tmp13_ = vala_method_call_get_argument_list (expr);
	_tmp14_ = _tmp13_;
	_tmp15_ = vala_list_get (_tmp14_, 0);
	handler = (_tmp16_ = (ValaExpression*) _tmp15_, _vala_iterable_unref0 (_tmp14_), _tmp16_);
	_tmp17_ = vala_method_type_get_method_symbol (method_type);
	_tmp18_ = vala_symbol_get_name ((ValaSymbol*) _tmp17_);
	disconnect = g_strcmp0 (_tmp18_, "disconnect") == 0;
	_tmp19_ = vala_method_type_get_method_symbol (method_type);
	_tmp20_ = vala_symbol_get_name ((ValaSymbol*) _tmp19_);
	after = g_strcmp0 (_tmp20_, "connect_after") == 0;
	_tmp21_ = vala_gsignal_module_connect_signal (self, sig, signal_access, handler, disconnect, after, (ValaCodeNode*) expr);
	cexpr = _tmp21_;
	vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, cexpr);
	_vala_ccode_node_unref0 (cexpr);
	_vala_code_node_unref0 (handler);
	_vala_code_node_unref0 (signal_access);
	_vala_code_node_unref0 (sig);
	_vala_code_node_unref0 (method_type);
}


static ValaCCodeExpression* vala_gsignal_module_connect_signal (ValaGSignalModule* self, ValaSignal* sig, ValaExpression* signal_access, ValaExpression* handler, gboolean disconnect, gboolean after, ValaCodeNode* expr) {
	ValaCCodeExpression* result = NULL;
	gchar* connect_func;
	ValaSymbol* _tmp0_ = NULL;
	ValaMethod* _tmp1_;
	ValaMethod* m;
	ValaCCodeIdentifier* _tmp21_ = NULL;
	ValaCCodeIdentifier* _tmp22_;
	ValaCCodeFunctionCall* _tmp23_ = NULL;
	ValaCCodeFunctionCall* _tmp24_;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeExpression* signal_name_cexpr;
	ValaMemberAccess* ma;
	ValaExpression* _tmp39_ = NULL;
	ValaCCodeExpression* _tmp94_ = NULL;
	ValaCCodeExpression* _tmp95_;
	ValaCCodeCastExpression* _tmp96_ = NULL;
	ValaCCodeCastExpression* _tmp97_;
	gboolean _tmp98_;
	gboolean _tmp127_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sig != NULL, NULL);
	g_return_val_if_fail (signal_access != NULL, NULL);
	g_return_val_if_fail (handler != NULL, NULL);
	g_return_val_if_fail (expr != NULL, NULL);
	connect_func = NULL;
	_tmp0_ = vala_expression_get_symbol_reference (handler);
	_tmp1_ = _vala_code_node_ref0 (VALA_METHOD (_tmp0_));
	m = _tmp1_;
	if (!disconnect) {
		if (VALA_IS_DYNAMIC_SIGNAL (sig)) {
			if (!after) {
				gchar* _tmp2_ = NULL;
				gchar* _tmp3_;
				_tmp2_ = vala_ccode_base_module_get_dynamic_signal_connect_wrapper_name ((ValaCCodeBaseModule*) self, VALA_DYNAMIC_SIGNAL (sig));
				_tmp3_ = _tmp2_;
				_g_free0 (connect_func);
				connect_func = _tmp3_;
			} else {
				gchar* _tmp4_ = NULL;
				gchar* _tmp5_;
				_tmp4_ = vala_ccode_base_module_get_dynamic_signal_connect_after_wrapper_name ((ValaCCodeBaseModule*) self, VALA_DYNAMIC_SIGNAL (sig));
				_tmp5_ = _tmp4_;
				_g_free0 (connect_func);
				connect_func = _tmp5_;
			}
		} else {
			gboolean _tmp6_;
			_tmp6_ = vala_method_get_closure (m);
			if (_tmp6_) {
				gchar* _tmp7_;
				gchar* _tmp8_;
				_tmp7_ = g_strdup ("g_signal_connect_data");
				_tmp8_ = _tmp7_;
				_g_free0 (connect_func);
				connect_func = _tmp8_;
			} else {
				gboolean _tmp9_;
				_tmp9_ = vala_gsignal_module_in_gobject_instance (self, m);
				if (_tmp9_) {
					gchar* _tmp10_;
					gchar* _tmp11_;
					_tmp10_ = g_strdup ("g_signal_connect_object");
					_tmp11_ = _tmp10_;
					_g_free0 (connect_func);
					connect_func = _tmp11_;
				} else {
					if (!after) {
						gchar* _tmp12_;
						gchar* _tmp13_;
						_tmp12_ = g_strdup ("g_signal_connect");
						_tmp13_ = _tmp12_;
						_g_free0 (connect_func);
						connect_func = _tmp13_;
					} else {
						gchar* _tmp14_;
						gchar* _tmp15_;
						_tmp14_ = g_strdup ("g_signal_connect_after");
						_tmp15_ = _tmp14_;
						_g_free0 (connect_func);
						connect_func = _tmp15_;
					}
				}
			}
		}
	} else {
		if (VALA_IS_LAMBDA_EXPRESSION (handler)) {
			ValaSourceReference* _tmp16_ = NULL;
			_tmp16_ = vala_code_node_get_source_reference ((ValaCodeNode*) handler);
			vala_report_error (_tmp16_, "Cannot disconnect lambda expression from signal. Use Object.disconnect" \
".");
		}
		if (VALA_IS_DYNAMIC_SIGNAL (sig)) {
			gchar* _tmp17_ = NULL;
			gchar* _tmp18_;
			_tmp17_ = vala_ccode_base_module_get_dynamic_signal_disconnect_wrapper_name ((ValaCCodeBaseModule*) self, VALA_DYNAMIC_SIGNAL (sig));
			_tmp18_ = _tmp17_;
			_g_free0 (connect_func);
			connect_func = _tmp18_;
		} else {
			gchar* _tmp19_;
			gchar* _tmp20_;
			_tmp19_ = g_strdup ("g_signal_handlers_disconnect_matched");
			_tmp20_ = _tmp19_;
			_g_free0 (connect_func);
			connect_func = _tmp20_;
		}
	}
	_tmp21_ = vala_ccode_identifier_new (connect_func);
	_tmp22_ = _tmp21_;
	_tmp23_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp22_);
	ccall = (_tmp24_ = _tmp23_, _vala_ccode_node_unref0 (_tmp22_), _tmp24_);
	signal_name_cexpr = NULL;
	ma = NULL;
	if (VALA_IS_ELEMENT_ACCESS (signal_access)) {
		ValaElementAccess* _tmp25_;
		ValaElementAccess* ea;
		ValaExpression* _tmp26_ = NULL;
		ValaMemberAccess* _tmp27_;
		ValaMemberAccess* _tmp28_;
		ValaList* _tmp29_ = NULL;
		ValaList* _tmp30_;
		gpointer _tmp31_ = NULL;
		ValaExpression* _tmp32_;
		ValaExpression* detail_expr;
		ValaCCodeExpression* _tmp33_ = NULL;
		ValaCCodeExpression* _tmp34_;
		_tmp25_ = _vala_code_node_ref0 (VALA_ELEMENT_ACCESS (signal_access));
		ea = _tmp25_;
		_tmp26_ = vala_element_access_get_container (ea);
		_tmp27_ = _vala_code_node_ref0 (VALA_MEMBER_ACCESS (_tmp26_));
		_tmp28_ = _tmp27_;
		_vala_code_node_unref0 (ma);
		ma = _tmp28_;
		_tmp29_ = vala_element_access_get_indices (ea);
		_tmp30_ = _tmp29_;
		_tmp31_ = vala_list_get (_tmp30_, 0);
		detail_expr = (_tmp32_ = (ValaExpression*) _tmp31_, _vala_iterable_unref0 (_tmp30_), _tmp32_);
		_tmp33_ = vala_gsignal_module_get_signal_name_cexpression (self, sig, detail_expr, expr);
		_tmp34_ = _tmp33_;
		_vala_ccode_node_unref0 (signal_name_cexpr);
		signal_name_cexpr = _tmp34_;
		if (signal_name_cexpr == NULL) {
			result = NULL;
			_vala_code_node_unref0 (detail_expr);
			_vala_code_node_unref0 (ea);
			_vala_code_node_unref0 (ma);
			_vala_ccode_node_unref0 (signal_name_cexpr);
			_vala_ccode_node_unref0 (ccall);
			_vala_code_node_unref0 (m);
			_g_free0 (connect_func);
			return result;
		}
		_vala_code_node_unref0 (detail_expr);
		_vala_code_node_unref0 (ea);
	} else {
		ValaMemberAccess* _tmp35_;
		ValaMemberAccess* _tmp36_;
		ValaCCodeExpression* _tmp37_ = NULL;
		ValaCCodeExpression* _tmp38_;
		_tmp35_ = _vala_code_node_ref0 (VALA_MEMBER_ACCESS (signal_access));
		_tmp36_ = _tmp35_;
		_vala_code_node_unref0 (ma);
		ma = _tmp36_;
		_tmp37_ = vala_gsignal_module_get_signal_name_cexpression (self, sig, NULL, expr);
		_tmp38_ = _tmp37_;
		_vala_ccode_node_unref0 (signal_name_cexpr);
		signal_name_cexpr = _tmp38_;
	}
	_tmp39_ = vala_member_access_get_inner (ma);
	if (_tmp39_ != NULL) {
		ValaExpression* _tmp40_ = NULL;
		ValaCCodeExpression* _tmp41_ = NULL;
		ValaCCodeExpression* _tmp42_;
		_tmp40_ = vala_member_access_get_inner (ma);
		_tmp41_ = vala_ccode_base_module_get_ccodenode ((ValaCCodeBaseModule*) self, _tmp40_);
		_tmp42_ = VALA_CCODE_EXPRESSION (_tmp41_);
		vala_ccode_function_call_add_argument (ccall, _tmp42_);
		_vala_ccode_node_unref0 (_tmp42_);
	} else {
		ValaCCodeExpression* _tmp43_ = NULL;
		ValaCCodeExpression* _tmp44_;
		_tmp43_ = vala_ccode_base_module_get_result_cexpression ((ValaCCodeBaseModule*) self, "self");
		_tmp44_ = _tmp43_;
		vala_ccode_function_call_add_argument (ccall, _tmp44_);
		_vala_ccode_node_unref0 (_tmp44_);
	}
	if (VALA_IS_DYNAMIC_SIGNAL (sig)) {
		const gchar* _tmp45_ = NULL;
		gchar* _tmp46_ = NULL;
		gchar* _tmp47_;
		ValaCCodeConstant* _tmp48_ = NULL;
		ValaCCodeConstant* _tmp49_;
		_tmp45_ = vala_symbol_get_name ((ValaSymbol*) sig);
		_tmp46_ = g_strdup_printf ("\"%s\"", _tmp45_);
		_tmp47_ = _tmp46_;
		_tmp48_ = vala_ccode_constant_new (_tmp47_);
		_tmp49_ = _tmp48_;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) _tmp49_);
		_vala_ccode_node_unref0 (_tmp49_);
		_g_free0 (_tmp47_);
	} else {
		if (!disconnect) {
			vala_ccode_function_call_add_argument (ccall, signal_name_cexpr);
		} else {
			ValaLocalVariable* _tmp54_ = NULL;
			ValaLocalVariable* temp_decl;
			ValaCCodeIdentifier* _tmp55_ = NULL;
			ValaCCodeIdentifier* _tmp56_;
			ValaCCodeFunctionCall* _tmp57_ = NULL;
			ValaCCodeFunctionCall* _tmp58_;
			ValaCCodeFunctionCall* parse_call;
			ValaSymbol* _tmp59_ = NULL;
			ValaTypeSymbol* _tmp60_;
			ValaTypeSymbol* decl_type;
			gchar* _tmp61_ = NULL;
			gchar* _tmp62_;
			ValaCCodeIdentifier* _tmp63_ = NULL;
			ValaCCodeIdentifier* _tmp64_;
			const gchar* _tmp65_ = NULL;
			ValaCCodeExpression* _tmp66_ = NULL;
			ValaCCodeExpression* _tmp67_;
			ValaCCodeUnaryExpression* _tmp68_ = NULL;
			ValaCCodeUnaryExpression* _tmp69_;
			ValaLocalVariable* detail_temp_decl;
			ValaCCodeFunction* _tmp83_ = NULL;
			const gchar* _tmp84_ = NULL;
			ValaCCodeExpression* _tmp85_ = NULL;
			ValaCCodeExpression* _tmp86_;
			ValaCCodeConstant* _tmp92_ = NULL;
			ValaCCodeConstant* _tmp93_;
			if (!VALA_IS_ELEMENT_ACCESS (signal_access)) {
				ValaCCodeConstant* _tmp50_ = NULL;
				ValaCCodeConstant* _tmp51_;
				_tmp50_ = vala_ccode_constant_new ("G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA");
				_tmp51_ = _tmp50_;
				vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) _tmp51_);
				_vala_ccode_node_unref0 (_tmp51_);
			} else {
				ValaCCodeConstant* _tmp52_ = NULL;
				ValaCCodeConstant* _tmp53_;
				_tmp52_ = vala_ccode_constant_new ("G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SI" \
"GNAL_MATCH_DATA");
				_tmp53_ = _tmp52_;
				vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) _tmp53_);
				_vala_ccode_node_unref0 (_tmp53_);
			}
			_tmp54_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, ((ValaCCodeBaseModule*) self)->uint_type, TRUE, NULL, TRUE);
			temp_decl = _tmp54_;
			vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, temp_decl);
			_tmp55_ = vala_ccode_identifier_new ("g_signal_parse_name");
			_tmp56_ = _tmp55_;
			_tmp57_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp56_);
			parse_call = (_tmp58_ = _tmp57_, _vala_ccode_node_unref0 (_tmp56_), _tmp58_);
			vala_ccode_function_call_add_argument (parse_call, signal_name_cexpr);
			_tmp59_ = vala_symbol_get_parent_symbol ((ValaSymbol*) sig);
			_tmp60_ = _vala_code_node_ref0 (VALA_TYPESYMBOL (_tmp59_));
			decl_type = _tmp60_;
			_tmp61_ = vala_typesymbol_get_type_id (decl_type);
			_tmp62_ = _tmp61_;
			_tmp63_ = vala_ccode_identifier_new (_tmp62_);
			_tmp64_ = _tmp63_;
			vala_ccode_function_call_add_argument (parse_call, (ValaCCodeExpression*) _tmp64_);
			_vala_ccode_node_unref0 (_tmp64_);
			_g_free0 (_tmp62_);
			_tmp65_ = vala_symbol_get_name ((ValaSymbol*) temp_decl);
			_tmp66_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp65_);
			_tmp67_ = _tmp66_;
			_tmp68_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp67_);
			_tmp69_ = _tmp68_;
			vala_ccode_function_call_add_argument (parse_call, (ValaCCodeExpression*) _tmp69_);
			_vala_ccode_node_unref0 (_tmp69_);
			_vala_ccode_node_unref0 (_tmp67_);
			detail_temp_decl = NULL;
			if (!VALA_IS_ELEMENT_ACCESS (signal_access)) {
				ValaCCodeConstant* _tmp70_ = NULL;
				ValaCCodeConstant* _tmp71_;
				ValaCCodeConstant* _tmp72_ = NULL;
				ValaCCodeConstant* _tmp73_;
				_tmp70_ = vala_ccode_constant_new ("NULL");
				_tmp71_ = _tmp70_;
				vala_ccode_function_call_add_argument (parse_call, (ValaCCodeExpression*) _tmp71_);
				_vala_ccode_node_unref0 (_tmp71_);
				_tmp72_ = vala_ccode_constant_new ("FALSE");
				_tmp73_ = _tmp72_;
				vala_ccode_function_call_add_argument (parse_call, (ValaCCodeExpression*) _tmp73_);
				_vala_ccode_node_unref0 (_tmp73_);
			} else {
				ValaLocalVariable* _tmp74_ = NULL;
				ValaLocalVariable* _tmp75_;
				const gchar* _tmp76_ = NULL;
				ValaCCodeIdentifier* _tmp77_ = NULL;
				ValaCCodeIdentifier* _tmp78_;
				ValaCCodeUnaryExpression* _tmp79_ = NULL;
				ValaCCodeUnaryExpression* _tmp80_;
				ValaCCodeConstant* _tmp81_ = NULL;
				ValaCCodeConstant* _tmp82_;
				_tmp74_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, ((ValaCCodeBaseModule*) self)->gquark_type, TRUE, NULL, TRUE);
				_tmp75_ = _tmp74_;
				_vala_code_node_unref0 (detail_temp_decl);
				detail_temp_decl = _tmp75_;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, detail_temp_decl);
				_tmp76_ = vala_symbol_get_name ((ValaSymbol*) detail_temp_decl);
				_tmp77_ = vala_ccode_identifier_new (_tmp76_);
				_tmp78_ = _tmp77_;
				_tmp79_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp78_);
				_tmp80_ = _tmp79_;
				vala_ccode_function_call_add_argument (parse_call, (ValaCCodeExpression*) _tmp80_);
				_vala_ccode_node_unref0 (_tmp80_);
				_vala_ccode_node_unref0 (_tmp78_);
				_tmp81_ = vala_ccode_constant_new ("TRUE");
				_tmp82_ = _tmp81_;
				vala_ccode_function_call_add_argument (parse_call, (ValaCCodeExpression*) _tmp82_);
				_vala_ccode_node_unref0 (_tmp82_);
			}
			_tmp83_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			vala_ccode_function_add_expression (_tmp83_, (ValaCCodeExpression*) parse_call);
			_tmp84_ = vala_symbol_get_name ((ValaSymbol*) temp_decl);
			_tmp85_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp84_);
			_tmp86_ = _tmp85_;
			vala_ccode_function_call_add_argument (ccall, _tmp86_);
			_vala_ccode_node_unref0 (_tmp86_);
			if (detail_temp_decl == NULL) {
				ValaCCodeConstant* _tmp87_ = NULL;
				ValaCCodeConstant* _tmp88_;
				_tmp87_ = vala_ccode_constant_new ("0");
				_tmp88_ = _tmp87_;
				vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) _tmp88_);
				_vala_ccode_node_unref0 (_tmp88_);
			} else {
				const gchar* _tmp89_ = NULL;
				ValaCCodeExpression* _tmp90_ = NULL;
				ValaCCodeExpression* _tmp91_;
				_tmp89_ = vala_symbol_get_name ((ValaSymbol*) detail_temp_decl);
				_tmp90_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp89_);
				_tmp91_ = _tmp90_;
				vala_ccode_function_call_add_argument (ccall, _tmp91_);
				_vala_ccode_node_unref0 (_tmp91_);
			}
			_tmp92_ = vala_ccode_constant_new ("NULL");
			_tmp93_ = _tmp92_;
			vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) _tmp93_);
			_vala_ccode_node_unref0 (_tmp93_);
			_vala_code_node_unref0 (detail_temp_decl);
			_vala_code_node_unref0 (decl_type);
			_vala_ccode_node_unref0 (parse_call);
			_vala_code_node_unref0 (temp_decl);
		}
	}
	_tmp94_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, handler);
	_tmp95_ = _tmp94_;
	_tmp96_ = vala_ccode_cast_expression_new (_tmp95_, "GCallback");
	_tmp97_ = _tmp96_;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) _tmp97_);
	_vala_ccode_node_unref0 (_tmp97_);
	_vala_ccode_node_unref0 (_tmp95_);
	_tmp98_ = vala_method_get_closure (m);
	if (_tmp98_) {
		ValaCCodeExpression* handler_destroy_notify;
		ValaCCodeExpression* _tmp99_ = NULL;
		ValaCCodeExpression* _tmp100_ = NULL;
		ValaCCodeExpression* _tmp101_;
		ValaCCodeCastExpression* _tmp102_ = NULL;
		ValaCCodeCastExpression* _tmp103_;
		handler_destroy_notify = NULL;
		_tmp100_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, handler, &_tmp99_);
		_vala_ccode_node_unref0 (handler_destroy_notify);
		handler_destroy_notify = _tmp99_;
		_tmp101_ = _tmp100_;
		vala_ccode_function_call_add_argument (ccall, _tmp101_);
		_vala_ccode_node_unref0 (_tmp101_);
		_tmp102_ = vala_ccode_cast_expression_new (handler_destroy_notify, "GClosureNotify");
		_tmp103_ = _tmp102_;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) _tmp103_);
		_vala_ccode_node_unref0 (_tmp103_);
		if (!after) {
			ValaCCodeConstant* _tmp104_ = NULL;
			ValaCCodeConstant* _tmp105_;
			_tmp104_ = vala_ccode_constant_new ("0");
			_tmp105_ = _tmp104_;
			vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) _tmp105_);
			_vala_ccode_node_unref0 (_tmp105_);
		} else {
			ValaCCodeConstant* _tmp106_ = NULL;
			ValaCCodeConstant* _tmp107_;
			_tmp106_ = vala_ccode_constant_new ("G_CONNECT_AFTER");
			_tmp107_ = _tmp106_;
			vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) _tmp107_);
			_vala_ccode_node_unref0 (_tmp107_);
		}
		_vala_ccode_node_unref0 (handler_destroy_notify);
	} else {
		ValaMemberBinding _tmp108_;
		_tmp108_ = vala_method_get_binding (m);
		if (_tmp108_ == VALA_MEMBER_BINDING_INSTANCE) {
			gboolean _tmp118_ = FALSE;
			gboolean _tmp119_ = FALSE;
			if (VALA_IS_MEMBER_ACCESS (handler)) {
				ValaMemberAccess* _tmp109_;
				ValaMemberAccess* right_ma;
				ValaExpression* _tmp110_ = NULL;
				_tmp109_ = _vala_code_node_ref0 (VALA_MEMBER_ACCESS (handler));
				right_ma = _tmp109_;
				_tmp110_ = vala_member_access_get_inner (right_ma);
				if (_tmp110_ != NULL) {
					ValaExpression* _tmp111_ = NULL;
					ValaCCodeExpression* _tmp112_ = NULL;
					ValaCCodeExpression* _tmp113_;
					_tmp111_ = vala_member_access_get_inner (right_ma);
					_tmp112_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp111_);
					_tmp113_ = _tmp112_;
					vala_ccode_function_call_add_argument (ccall, _tmp113_);
					_vala_ccode_node_unref0 (_tmp113_);
				} else {
					ValaCCodeExpression* _tmp114_ = NULL;
					ValaCCodeExpression* _tmp115_;
					_tmp114_ = vala_ccode_base_module_get_result_cexpression ((ValaCCodeBaseModule*) self, "self");
					_tmp115_ = _tmp114_;
					vala_ccode_function_call_add_argument (ccall, _tmp115_);
					_vala_ccode_node_unref0 (_tmp115_);
				}
				_vala_code_node_unref0 (right_ma);
			} else {
				if (VALA_IS_LAMBDA_EXPRESSION (handler)) {
					ValaCCodeExpression* _tmp116_ = NULL;
					ValaCCodeExpression* _tmp117_;
					_tmp116_ = vala_ccode_base_module_get_result_cexpression ((ValaCCodeBaseModule*) self, "self");
					_tmp117_ = _tmp116_;
					vala_ccode_function_call_add_argument (ccall, _tmp117_);
					_vala_ccode_node_unref0 (_tmp117_);
				}
			}
			if (!disconnect) {
				_tmp119_ = !VALA_IS_DYNAMIC_SIGNAL (sig);
			} else {
				_tmp119_ = FALSE;
			}
			if (_tmp119_) {
				gboolean _tmp120_;
				_tmp120_ = vala_gsignal_module_in_gobject_instance (self, m);
				_tmp118_ = _tmp120_;
			} else {
				_tmp118_ = FALSE;
			}
			if (_tmp118_) {
				if (!after) {
					ValaCCodeConstant* _tmp121_ = NULL;
					ValaCCodeConstant* _tmp122_;
					_tmp121_ = vala_ccode_constant_new ("0");
					_tmp122_ = _tmp121_;
					vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) _tmp122_);
					_vala_ccode_node_unref0 (_tmp122_);
				} else {
					ValaCCodeConstant* _tmp123_ = NULL;
					ValaCCodeConstant* _tmp124_;
					_tmp123_ = vala_ccode_constant_new ("G_CONNECT_AFTER");
					_tmp124_ = _tmp123_;
					vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) _tmp124_);
					_vala_ccode_node_unref0 (_tmp124_);
				}
			}
		} else {
			ValaCCodeConstant* _tmp125_ = NULL;
			ValaCCodeConstant* _tmp126_;
			_tmp125_ = vala_ccode_constant_new ("NULL");
			_tmp126_ = _tmp125_;
			vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) _tmp126_);
			_vala_ccode_node_unref0 (_tmp126_);
		}
	}
	if (disconnect) {
		_tmp127_ = TRUE;
	} else {
		ValaCodeNode* _tmp128_ = NULL;
		_tmp128_ = vala_code_node_get_parent_node (expr);
		_tmp127_ = VALA_IS_EXPRESSION_STATEMENT (_tmp128_);
	}
	if (_tmp127_) {
		ValaCCodeFunction* _tmp129_ = NULL;
		_tmp129_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		vala_ccode_function_add_expression (_tmp129_, (ValaCCodeExpression*) ccall);
		result = NULL;
		_vala_code_node_unref0 (ma);
		_vala_ccode_node_unref0 (signal_name_cexpr);
		_vala_ccode_node_unref0 (ccall);
		_vala_code_node_unref0 (m);
		_g_free0 (connect_func);
		return result;
	} else {
		ValaLocalVariable* _tmp130_ = NULL;
		ValaLocalVariable* temp_var;
		const gchar* _tmp131_ = NULL;
		ValaCCodeExpression* _tmp132_ = NULL;
		ValaCCodeExpression* temp_ref;
		ValaCCodeFunction* _tmp133_ = NULL;
		ValaCCodeAssignment* _tmp134_ = NULL;
		ValaCCodeAssignment* _tmp135_;
		_tmp130_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, ((ValaCCodeBaseModule*) self)->ulong_type, TRUE, NULL, TRUE);
		temp_var = _tmp130_;
		_tmp131_ = vala_symbol_get_name ((ValaSymbol*) temp_var);
		_tmp132_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp131_);
		temp_ref = _tmp132_;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, temp_var);
		_tmp133_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp134_ = vala_ccode_assignment_new (temp_ref, (ValaCCodeExpression*) ccall, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
		_tmp135_ = _tmp134_;
		vala_ccode_function_add_expression (_tmp133_, (ValaCCodeExpression*) _tmp135_);
		_vala_ccode_node_unref0 (_tmp135_);
		result = temp_ref;
		_vala_code_node_unref0 (temp_var);
		_vala_code_node_unref0 (ma);
		_vala_ccode_node_unref0 (signal_name_cexpr);
		_vala_ccode_node_unref0 (ccall);
		_vala_code_node_unref0 (m);
		_g_free0 (connect_func);
		return result;
	}
	_vala_code_node_unref0 (ma);
	_vala_ccode_node_unref0 (signal_name_cexpr);
	_vala_ccode_node_unref0 (ccall);
	_vala_code_node_unref0 (m);
	_g_free0 (connect_func);
}


ValaGSignalModule* vala_gsignal_module_construct (GType object_type) {
	ValaGSignalModule* self = NULL;
	self = (ValaGSignalModule*) vala_gobject_module_construct (object_type);
	return self;
}


ValaGSignalModule* vala_gsignal_module_new (void) {
	return vala_gsignal_module_construct (VALA_TYPE_GSIGNAL_MODULE);
}


static void vala_gsignal_module_class_init (ValaGSignalModuleClass * klass) {
	vala_gsignal_module_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_BASE_MODULE_CLASS (klass)->get_marshaller_function = vala_gsignal_module_real_get_marshaller_function;
	VALA_CODE_VISITOR_CLASS (klass)->visit_signal = vala_gsignal_module_real_visit_signal;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->generate_marshaller = vala_gsignal_module_real_generate_marshaller;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->get_signal_creation = vala_gsignal_module_real_get_signal_creation;
	VALA_GSIGNAL_MODULE_CLASS (klass)->get_dbus_g_type = vala_gsignal_module_real_get_dbus_g_type;
	VALA_CODE_VISITOR_CLASS (klass)->visit_element_access = vala_gsignal_module_real_visit_element_access;
	VALA_CODE_VISITOR_CLASS (klass)->visit_assignment = vala_gsignal_module_real_visit_assignment;
	VALA_CODE_VISITOR_CLASS (klass)->visit_member_access = vala_gsignal_module_real_visit_member_access;
	VALA_CODE_VISITOR_CLASS (klass)->visit_method_call = vala_gsignal_module_real_visit_method_call;
}


static void vala_gsignal_module_instance_init (ValaGSignalModule * self) {
}


GType vala_gsignal_module_get_type (void) {
	static volatile gsize vala_gsignal_module_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gsignal_module_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaGSignalModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gsignal_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGSignalModule), 0, (GInstanceInitFunc) vala_gsignal_module_instance_init, NULL };
		GType vala_gsignal_module_type_id;
		vala_gsignal_module_type_id = g_type_register_static (VALA_TYPE_GOBJECT_MODULE, "ValaGSignalModule", &g_define_type_info, 0);
		g_once_init_leave (&vala_gsignal_module_type_id__volatile, vala_gsignal_module_type_id);
	}
	return vala_gsignal_module_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



