/* valagidlparser.c generated by valac, the Vala compiler
 * generated from valagidlparser.vala, do not modify */

/* valagidlparser.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <valagee.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <gidlparser.h>
#include <gidlmodule.h>
#include <gidlnode.h>
#include <gmetadata.h>
#include <stdio.h>
#include <float.h>
#include <math.h>


#define VALA_TYPE_GIDL_PARSER (vala_gidl_parser_get_type ())
#define VALA_GIDL_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GIDL_PARSER, ValaGIdlParser))
#define VALA_GIDL_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GIDL_PARSER, ValaGIdlParserClass))
#define VALA_IS_GIDL_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GIDL_PARSER))
#define VALA_IS_GIDL_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GIDL_PARSER))
#define VALA_GIDL_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GIDL_PARSER, ValaGIdlParserClass))

typedef struct _ValaGIdlParser ValaGIdlParser;
typedef struct _ValaGIdlParserClass ValaGIdlParserClass;
typedef struct _ValaGIdlParserPrivate ValaGIdlParserPrivate;
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_source_reference_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_reference_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __g_list_free__g_idl_module_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_idl_module_free0_ (var), NULL)))
#define __g_list_free__vala_code_node_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__vala_code_node_unref0_ (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_match_info_free0(var) ((var == NULL) ? NULL : (var = (g_match_info_free (var), NULL)))
#define __g_slist_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__g_free0_ (var), NULL)))

struct _ValaGIdlParser {
	ValaCodeVisitor parent_instance;
	ValaGIdlParserPrivate * priv;
};

struct _ValaGIdlParserClass {
	ValaCodeVisitorClass parent_class;
};

struct _ValaGIdlParserPrivate {
	ValaCodeContext* context;
	ValaSourceFile* current_source_file;
	ValaSourceReference* current_source_reference;
	ValaNamespace* current_namespace;
	ValaTypeSymbol* current_data_type;
	ValaMap* codenode_attributes_map;
	ValaMap* codenode_attributes_patterns;
	ValaSet* current_type_symbol_set;
	ValaMap* cname_type_map;
};


static gpointer vala_gidl_parser_parent_class = NULL;
static GRegex* vala_gidl_parser_type_from_string_regex;
static GRegex* vala_gidl_parser_type_from_string_regex = NULL;

GType vala_gidl_parser_get_type (void) G_GNUC_CONST;
#define VALA_GIDL_PARSER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_GIDL_PARSER, ValaGIdlParserPrivate))
enum  {
	VALA_GIDL_PARSER_DUMMY_PROPERTY
};
void vala_gidl_parser_parse (ValaGIdlParser* self, ValaCodeContext* context);
static void vala_gidl_parser_real_visit_namespace (ValaCodeVisitor* base, ValaNamespace* ns);
static void vala_gidl_parser_real_visit_class (ValaCodeVisitor* base, ValaClass* cl);
static void vala_gidl_parser_visit_type (ValaGIdlParser* self, ValaTypeSymbol* t);
static void vala_gidl_parser_real_visit_struct (ValaCodeVisitor* base, ValaStruct* st);
static void vala_gidl_parser_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface);
static void vala_gidl_parser_real_visit_enum (ValaCodeVisitor* base, ValaEnum* en);
static void vala_gidl_parser_real_visit_error_domain (ValaCodeVisitor* base, ValaErrorDomain* ed);
static void vala_gidl_parser_real_visit_delegate (ValaCodeVisitor* base, ValaDelegate* d);
static void vala_gidl_parser_real_visit_source_file (ValaCodeVisitor* base, ValaSourceFile* source_file);
static void vala_gidl_parser_parse_file (ValaGIdlParser* self, ValaSourceFile* source_file);
static ValaNamespace* vala_gidl_parser_parse_module (ValaGIdlParser* self, GIdlModule* module);
static void _g_idl_module_free0_ (gpointer var);
static void _g_list_free__g_idl_module_free0_ (GList* self);
static gchar* vala_gidl_parser_fix_type_name (ValaGIdlParser* self, const gchar* type_name, ValaSymbol* container);
static gchar** vala_gidl_parser_get_attributes (ValaGIdlParser* self, const gchar* codenode, int* result_length1);
static gchar* vala_gidl_parser_eval (ValaGIdlParser* self, const gchar* s);
static gchar* vala_gidl_parser_fix_const_name (ValaGIdlParser* self, const gchar* const_name, ValaSymbol* container);
static gchar** vala_gidl_parser_get_attributes_for_node (ValaGIdlParser* self, GIdlNode* node, int* result_length1);
static void vala_gidl_parser_add_symbol_to_container (ValaGIdlParser* self, ValaSymbol* container, ValaSymbol* sym);
static void vala_gidl_parser_parse_node (ValaGIdlParser* self, GIdlNode* node, GIdlModule* module, ValaSymbol* container);
static ValaDelegate* vala_gidl_parser_parse_delegate (ValaGIdlParser* self, GIdlNodeFunction* f_node);
static void vala_gidl_parser_parse_struct (ValaGIdlParser* self, GIdlNodeStruct* st_node, ValaSymbol* container, GIdlModule* module);
static void vala_gidl_parser_parse_union (ValaGIdlParser* self, GIdlNodeUnion* un_node, ValaSymbol* container, GIdlModule* module);
static void vala_gidl_parser_parse_boxed (ValaGIdlParser* self, GIdlNodeBoxed* boxed_node, ValaSymbol* container, GIdlModule* module);
static void vala_gidl_parser_parse_enum (ValaGIdlParser* self, GIdlNodeEnum* en_node, ValaSymbol* container, GIdlModule* module, gboolean is_flags);
static void vala_gidl_parser_parse_object (ValaGIdlParser* self, GIdlNodeInterface* node, ValaSymbol* container, GIdlModule* module);
static void vala_gidl_parser_parse_interface (ValaGIdlParser* self, GIdlNodeInterface* node, ValaSymbol* container, GIdlModule* module);
static ValaConstant* vala_gidl_parser_parse_constant (ValaGIdlParser* self, GIdlNodeConstant* const_node);
static ValaMethod* vala_gidl_parser_parse_function (ValaGIdlParser* self, GIdlNodeFunction* f, gboolean is_interface);
static ValaSymbol* vala_gidl_parser_get_container_from_name (ValaGIdlParser* self, const gchar* name);
static void _vala_code_node_unref0_ (gpointer var);
static void _g_list_free__vala_code_node_unref0_ (GList* self);
static ValaDataType* vala_gidl_parser_parse_param (ValaGIdlParser* self, GIdlNodeParam* param, ValaParameterDirection* direction);
static gboolean vala_gidl_parser_parse_type_arguments_from_string (ValaGIdlParser* self, ValaDataType* parent_type, const gchar* type_arguments, ValaSourceReference* source_reference);
static ValaDataType* vala_gidl_parser_parse_type_from_string (ValaGIdlParser* self, const gchar* type_string, gboolean owned_by_default, ValaSourceReference* source_reference);
static gboolean vala_gidl_parser_is_reference_type (ValaGIdlParser* self, const gchar* cname);
static ValaDataType* vala_gidl_parser_parse_type_string (ValaGIdlParser* self, const gchar* n);
static ValaField* vala_gidl_parser_parse_field (ValaGIdlParser* self, GIdlNodeField* field_node);
static ValaDataType* vala_gidl_parser_parse_type (ValaGIdlParser* self, GIdlNodeType* type_node, ValaParameterDirection* direction);
static ValaMethod* vala_gidl_parser_parse_virtual (ValaGIdlParser* self, GIdlNodeVFunc* v, GIdlNodeFunction* func, gboolean is_interface);
static ValaProperty* vala_gidl_parser_parse_property (ValaGIdlParser* self, GIdlNodeProperty* prop_node);
static ValaSignal* vala_gidl_parser_parse_signal (ValaGIdlParser* self, GIdlNodeSignal* sig_node);
static void vala_gidl_parser_handle_async_methods (ValaGIdlParser* self, ValaObjectTypeSymbol* type_symbol);
static gboolean vala_gidl_parser_is_simple_type (ValaGIdlParser* self, const gchar* type_name);
static ValaUnresolvedSymbol* vala_gidl_parser_parse_symbol_from_string (ValaGIdlParser* self, const gchar* symbol_string, ValaSourceReference* source_reference);
static ValaMethod* vala_gidl_parser_create_method (ValaGIdlParser* self, const gchar* name, const gchar* symbol, GIdlNodeParam* res, GList* parameters, gboolean is_constructor, gboolean is_interface);
static gboolean vala_gidl_parser_param_is_exception (ValaGIdlParser* self, GIdlNodeParam* param);
static gchar* vala_gidl_parser_fix_prop_name (ValaGIdlParser* self, const gchar* name);
static void _g_free0_ (gpointer var);
static void _g_slist_free__g_free0_ (GSList* self);
ValaGIdlParser* vala_gidl_parser_new (void);
ValaGIdlParser* vala_gidl_parser_construct (GType object_type);
static void vala_gidl_parser_finalize (ValaCodeVisitor* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


/**
 * Parse all source files in the specified code context and build a
 * code tree.
 *
 * @param context a code context
 */
static gpointer _vala_code_context_ref0 (gpointer self) {
	return self ? vala_code_context_ref (self) : NULL;
}


void vala_gidl_parser_parse (ValaGIdlParser* self, ValaCodeContext* context) {
	ValaHashMap* _tmp0_ = NULL;
	ValaMap* _tmp1_;
	ValaCodeContext* _tmp2_;
	ValaCodeContext* _tmp3_;
	ValaMap* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, VALA_TYPE_TYPESYMBOL, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_str_hash, g_str_equal, g_direct_equal);
	_tmp1_ = (ValaMap*) _tmp0_;
	_vala_map_unref0 (self->priv->cname_type_map);
	self->priv->cname_type_map = _tmp1_;
	_tmp2_ = _vala_code_context_ref0 (context);
	_tmp3_ = _tmp2_;
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = _tmp3_;
	vala_code_context_accept (context, (ValaCodeVisitor*) self);
	_tmp4_ = NULL;
	_vala_map_unref0 (self->priv->cname_type_map);
	self->priv->cname_type_map = _tmp4_;
}


static void vala_gidl_parser_real_visit_namespace (ValaCodeVisitor* base, ValaNamespace* ns) {
	ValaGIdlParser * self;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (ns != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) ns, (ValaCodeVisitor*) self);
}


static void vala_gidl_parser_real_visit_class (ValaCodeVisitor* base, ValaClass* cl) {
	ValaGIdlParser * self;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (cl != NULL);
	vala_gidl_parser_visit_type (self, (ValaTypeSymbol*) cl);
}


static void vala_gidl_parser_real_visit_struct (ValaCodeVisitor* base, ValaStruct* st) {
	ValaGIdlParser * self;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (st != NULL);
	vala_gidl_parser_visit_type (self, (ValaTypeSymbol*) st);
}


static void vala_gidl_parser_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface) {
	ValaGIdlParser * self;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (iface != NULL);
	vala_gidl_parser_visit_type (self, (ValaTypeSymbol*) iface);
}


static void vala_gidl_parser_real_visit_enum (ValaCodeVisitor* base, ValaEnum* en) {
	ValaGIdlParser * self;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (en != NULL);
	vala_gidl_parser_visit_type (self, (ValaTypeSymbol*) en);
}


static void vala_gidl_parser_real_visit_error_domain (ValaCodeVisitor* base, ValaErrorDomain* ed) {
	ValaGIdlParser * self;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (ed != NULL);
	vala_gidl_parser_visit_type (self, (ValaTypeSymbol*) ed);
}


static void vala_gidl_parser_real_visit_delegate (ValaCodeVisitor* base, ValaDelegate* d) {
	ValaGIdlParser * self;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (d != NULL);
	vala_gidl_parser_visit_type (self, (ValaTypeSymbol*) d);
}


static void vala_gidl_parser_visit_type (ValaGIdlParser* self, ValaTypeSymbol* t) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (t != NULL);
	_tmp0_ = vala_typesymbol_get_cname (t, FALSE);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_map_contains (self->priv->cname_type_map, _tmp1_);
	if ((_tmp3_ = !_tmp2_, _g_free0 (_tmp1_), _tmp3_)) {
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		_tmp4_ = vala_typesymbol_get_cname (t, FALSE);
		_tmp5_ = _tmp4_;
		vala_map_set (self->priv->cname_type_map, _tmp5_, t);
		_g_free0 (_tmp5_);
	}
}


static void vala_gidl_parser_real_visit_source_file (ValaCodeVisitor* base, ValaSourceFile* source_file) {
	ValaGIdlParser * self;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (source_file != NULL);
	_tmp0_ = vala_source_file_get_filename (source_file);
	_tmp1_ = g_str_has_suffix (_tmp0_, ".gi");
	if (_tmp1_) {
		vala_gidl_parser_parse_file (self, source_file);
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	gint _tmp0_;
	glong string_length;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	string_length = (glong) _tmp0_;
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp1_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp1_;
	return result;
}


static gpointer _vala_source_file_ref0 (gpointer self) {
	return self ? vala_source_file_ref (self) : NULL;
}


static gint string_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strchr (((gchar*) self) + start_index, (gssize) (-1), c);
	_result_ = _tmp0_;
	if (_result_ != NULL) {
		result = (gint) (_result_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static void _g_idl_module_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_idl_module_free (var), NULL));
}


static void _g_list_free__g_idl_module_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_idl_module_free0_, NULL);
	g_list_free (self);
}


static void vala_gidl_parser_parse_file (ValaGIdlParser* self, ValaSourceFile* source_file) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_;
	gint _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* metadata_filename;
	ValaSourceFile* _tmp8_;
	ValaSourceFile* _tmp9_;
	ValaHashMap* _tmp10_ = NULL;
	ValaMap* _tmp11_;
	ValaHashMap* _tmp12_ = NULL;
	ValaMap* _tmp13_;
	gboolean _tmp14_;
	const gchar* _tmp27_ = NULL;
	GList* _tmp28_ = NULL;
	GList* modules;
	ValaSourceReference* _tmp29_ = NULL;
	ValaSourceReference* _tmp30_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source_file != NULL);
	_tmp0_ = vala_source_file_get_filename (source_file);
	_tmp1_ = vala_source_file_get_filename (source_file);
	_tmp2_ = strlen (_tmp1_);
	_tmp3_ = strlen (".gi");
	_tmp4_ = string_substring (_tmp0_, (glong) 0, (glong) (_tmp2_ - _tmp3_));
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup_printf ("%s.metadata", _tmp5_);
	metadata_filename = (_tmp7_ = _tmp6_, _g_free0 (_tmp5_), _tmp7_);
	_tmp8_ = _vala_source_file_ref0 (source_file);
	_tmp9_ = _tmp8_;
	_vala_source_file_unref0 (self->priv->current_source_file);
	self->priv->current_source_file = _tmp9_;
	_tmp10_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal, g_direct_equal);
	_tmp11_ = (ValaMap*) _tmp10_;
	_vala_map_unref0 (self->priv->codenode_attributes_map);
	self->priv->codenode_attributes_map = _tmp11_;
	_tmp12_ = vala_hash_map_new (G_TYPE_POINTER, NULL, NULL, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_direct_hash, (GEqualFunc) g_pattern_spec_equal, g_direct_equal);
	_tmp13_ = (ValaMap*) _tmp12_;
	_vala_map_unref0 (self->priv->codenode_attributes_patterns);
	self->priv->codenode_attributes_patterns = _tmp13_;
	_tmp14_ = g_file_test (metadata_filename, G_FILE_TEST_EXISTS);
	if (_tmp14_) {
		gchar* metadata;
		gchar* _tmp15_ = NULL;
		gchar** _tmp16_;
		gchar** _tmp17_ = NULL;
		metadata = NULL;
		g_file_get_contents (metadata_filename, &_tmp15_, NULL, &_inner_error_);
		_g_free0 (metadata);
		metadata = _tmp15_;
		if (_inner_error_ != NULL) {
			_g_free0 (metadata);
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			_g_free0 (metadata);
			_g_free0 (metadata_filename);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp17_ = _tmp16_ = g_strsplit (metadata, "\n", 0);
		{
			gchar** line_collection;
			int line_collection_length1;
			int line_it;
			line_collection = _tmp17_;
			line_collection_length1 = _vala_array_length (_tmp16_);
			for (line_it = 0; line_it < _vala_array_length (_tmp16_); line_it = line_it + 1) {
				gchar* _tmp18_;
				gchar* line;
				_tmp18_ = g_strdup (line_collection[line_it]);
				line = _tmp18_;
				{
					gboolean _tmp19_;
					gchar** _tmp20_;
					gchar** _tmp21_ = NULL;
					gint tokens_length1;
					gint _tokens_size_;
					gchar** _tmp22_;
					gchar** tokens;
					gint _tmp23_;
					_tmp19_ = g_str_has_prefix (line, "#");
					if (_tmp19_) {
						_g_free0 (line);
						continue;
					}
					_tmp21_ = _tmp20_ = g_strsplit (line, " ", 2);
					_tmp22_ = _tmp21_;
					tokens_length1 = _vala_array_length (_tmp20_);
					_tokens_size_ = tokens_length1;
					tokens = _tmp22_;
					if (NULL == tokens[0]) {
						tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (line);
						continue;
					}
					_tmp23_ = string_index_of_char (tokens[0], (gunichar) '*', 0);
					if ((-1) != _tmp23_) {
						GPatternSpec* _tmp24_ = NULL;
						GPatternSpec* pattern;
						_tmp24_ = g_pattern_spec_new (tokens[0]);
						pattern = _tmp24_;
						vala_map_set (self->priv->codenode_attributes_patterns, pattern, tokens[0]);
					}
					vala_map_set (self->priv->codenode_attributes_map, tokens[0], tokens[1]);
					tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (line);
				}
			}
			line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
		}
		_g_free0 (metadata);
		goto __finally0;
		__catch0_g_file_error:
		{
			GError * e;
			gchar* _tmp25_ = NULL;
			gchar* _tmp26_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp25_ = g_strdup_printf ("Unable to read metadata file: %s", e->message);
			_tmp26_ = _tmp25_;
			vala_report_error (NULL, _tmp26_);
			_g_free0 (_tmp26_);
			_g_error_free0 (e);
		}
		__finally0:
		if (_inner_error_ != NULL) {
			_g_free0 (metadata_filename);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp27_ = vala_source_file_get_filename (source_file);
	_tmp28_ = g_idl_parse_file (_tmp27_, &_inner_error_);
	modules = _tmp28_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_MARKUP_ERROR) {
			goto __catch1_g_markup_error;
		}
		_g_free0 (metadata_filename);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp29_ = vala_source_reference_new (source_file, 0, 0, 0, 0);
	_tmp30_ = _tmp29_;
	_vala_source_reference_unref0 (self->priv->current_source_reference);
	self->priv->current_source_reference = _tmp30_;
	{
		GList* module_collection;
		GList* module_it;
		module_collection = modules;
		for (module_it = module_collection; module_it != NULL; module_it = module_it->next) {
			GIdlModule* module;
			module = (GIdlModule*) module_it->data;
			{
				ValaNamespace* _tmp31_ = NULL;
				ValaNamespace* ns;
				_tmp31_ = vala_gidl_parser_parse_module (self, module);
				ns = _tmp31_;
				if (ns != NULL) {
					ValaNamespace* _tmp32_ = NULL;
					_tmp32_ = vala_code_context_get_root (self->priv->context);
					vala_symbol_add_namespace ((ValaSymbol*) _tmp32_, ns);
				}
				_vala_code_node_unref0 (ns);
			}
		}
	}
	__g_list_free__g_idl_module_free0_0 (modules);
	goto __finally1;
	__catch1_g_markup_error:
	{
		GError * e;
		gchar* _tmp33_ = NULL;
		gchar* _tmp34_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp33_ = g_strdup_printf ("Unable to parse GIDL file: %s", e->message);
		_tmp34_ = _tmp33_;
		vala_report_error (NULL, _tmp34_);
		_g_free0 (_tmp34_);
		_g_error_free0 (e);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		_g_free0 (metadata_filename);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (metadata_filename);
}


static gchar* vala_gidl_parser_fix_type_name (ValaGIdlParser* self, const gchar* type_name, ValaSymbol* container) {
	gchar* result = NULL;
	gint _tmp0_;
	gchar** _tmp1_ = NULL;
	gint attributes_length1;
	gint _attributes_size_;
	gchar** _tmp2_;
	gchar** attributes;
	const gchar* _tmp8_ = NULL;
	gboolean _tmp9_;
	gchar* _tmp30_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type_name != NULL, NULL);
	g_return_val_if_fail (container != NULL, NULL);
	_tmp1_ = vala_gidl_parser_get_attributes (self, type_name, &_tmp0_);
	_tmp2_ = _tmp1_;
	attributes_length1 = _tmp0_;
	_attributes_size_ = attributes_length1;
	attributes = _tmp2_;
	if (attributes != NULL) {
		{
			gchar** attr_collection;
			int attr_collection_length1;
			int attr_it;
			attr_collection = attributes;
			attr_collection_length1 = attributes_length1;
			for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
				gchar* _tmp3_;
				gchar* attr;
				_tmp3_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp3_;
				{
					gchar** _tmp4_;
					gchar** _tmp5_ = NULL;
					gint nv_length1;
					gint _nv_size_;
					gchar** _tmp6_;
					gchar** nv;
					_tmp5_ = _tmp4_ = g_strsplit (attr, "=", 2);
					_tmp6_ = _tmp5_;
					nv_length1 = _vala_array_length (_tmp4_);
					_nv_size_ = nv_length1;
					nv = _tmp6_;
					if (g_strcmp0 (nv[0], "name") == 0) {
						gchar* _tmp7_ = NULL;
						_tmp7_ = vala_gidl_parser_eval (self, nv[1]);
						result = _tmp7_;
						nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (attr);
						attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
						return result;
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	_tmp8_ = vala_symbol_get_name (container);
	_tmp9_ = g_str_has_prefix (type_name, _tmp8_);
	if (_tmp9_) {
		const gchar* _tmp10_ = NULL;
		gint _tmp11_;
		gchar* _tmp12_ = NULL;
		_tmp10_ = vala_symbol_get_name (container);
		_tmp11_ = strlen (_tmp10_);
		_tmp12_ = string_substring (type_name, (glong) _tmp11_, (glong) (-1));
		result = _tmp12_;
		attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
		return result;
	} else {
		gboolean _tmp13_ = FALSE;
		const gchar* _tmp14_ = NULL;
		_tmp14_ = vala_symbol_get_name (container);
		if (g_strcmp0 (_tmp14_, "GLib") == 0) {
			gboolean _tmp15_;
			_tmp15_ = g_str_has_prefix (type_name, "G");
			_tmp13_ = _tmp15_;
		} else {
			_tmp13_ = FALSE;
		}
		if (_tmp13_) {
			gchar* _tmp16_ = NULL;
			_tmp16_ = string_substring (type_name, (glong) 1, (glong) (-1));
			result = _tmp16_;
			attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
			return result;
		} else {
			gchar* best_match;
			best_match = NULL;
			if (VALA_IS_NAMESPACE (container)) {
				{
					ValaList* _tmp17_ = NULL;
					ValaList* _cprefix_list;
					gint _tmp18_;
					gint _cprefix_size;
					gint _cprefix_index;
					_tmp17_ = vala_namespace_get_cprefixes (VALA_NAMESPACE (container));
					_cprefix_list = _tmp17_;
					_tmp18_ = vala_collection_get_size ((ValaCollection*) _cprefix_list);
					_cprefix_size = _tmp18_;
					_cprefix_index = -1;
					while (TRUE) {
						gpointer _tmp19_ = NULL;
						gchar* cprefix;
						gboolean _tmp20_;
						_cprefix_index = _cprefix_index + 1;
						if (!(_cprefix_index < _cprefix_size)) {
							break;
						}
						_tmp19_ = vala_list_get (_cprefix_list, _cprefix_index);
						cprefix = (gchar*) _tmp19_;
						_tmp20_ = g_str_has_prefix (type_name, cprefix);
						if (_tmp20_) {
							gboolean _tmp21_ = FALSE;
							if (best_match == NULL) {
								_tmp21_ = TRUE;
							} else {
								gint _tmp22_;
								gint _tmp23_;
								_tmp22_ = strlen (cprefix);
								_tmp23_ = strlen (best_match);
								_tmp21_ = _tmp22_ > _tmp23_;
							}
							if (_tmp21_) {
								gchar* _tmp24_;
								gchar* _tmp25_;
								_tmp24_ = g_strdup (cprefix);
								_tmp25_ = _tmp24_;
								_g_free0 (best_match);
								best_match = _tmp25_;
							}
						}
						_g_free0 (cprefix);
					}
					_vala_iterable_unref0 (_cprefix_list);
				}
			} else {
				gchar* _tmp26_ = NULL;
				gchar* _tmp27_;
				_tmp26_ = vala_symbol_get_cprefix (container);
				_tmp27_ = _tmp26_;
				_g_free0 (best_match);
				best_match = _tmp27_;
			}
			if (best_match != NULL) {
				gint _tmp28_;
				gchar* _tmp29_ = NULL;
				_tmp28_ = strlen (best_match);
				_tmp29_ = string_substring (type_name, (glong) _tmp28_, (glong) (-1));
				result = _tmp29_;
				_g_free0 (best_match);
				attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
				return result;
			}
			_g_free0 (best_match);
		}
	}
	_tmp30_ = g_strdup (type_name);
	result = _tmp30_;
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static gchar* vala_gidl_parser_fix_const_name (ValaGIdlParser* self, const gchar* const_name, ValaSymbol* container) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* pref;
	gboolean _tmp4_;
	gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (const_name != NULL, NULL);
	g_return_val_if_fail (container != NULL, NULL);
	_tmp0_ = vala_symbol_get_lower_case_cprefix (container);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_utf8_strup (_tmp1_, (gssize) (-1));
	pref = (_tmp3_ = _tmp2_, _g_free0 (_tmp1_), _tmp3_);
	_tmp4_ = g_str_has_prefix (const_name, pref);
	if (_tmp4_) {
		gint _tmp5_;
		gchar* _tmp6_ = NULL;
		_tmp5_ = strlen (pref);
		_tmp6_ = string_substring (const_name, (glong) _tmp5_, (glong) (-1));
		result = _tmp6_;
		_g_free0 (pref);
		return result;
	}
	_tmp7_ = g_strdup (const_name);
	result = _tmp7_;
	_g_free0 (pref);
	return result;
}


static gchar** vala_gidl_parser_get_attributes_for_node (ValaGIdlParser* self, GIdlNode* node, int* result_length1) {
	gchar** result = NULL;
	gchar* name;
	gint _tmp16_;
	gchar** _tmp17_ = NULL;
	gchar** _tmp18_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	name = NULL;
	if (node->type == G_IDL_NODE_FUNCTION) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = g_strdup (((GIdlNodeFunction*) node)->symbol);
		_tmp1_ = _tmp0_;
		_g_free0 (name);
		name = _tmp1_;
	} else {
		if (node->type == G_IDL_NODE_SIGNAL) {
			gchar* _tmp2_ = NULL;
			gchar* _tmp3_;
			gchar* _tmp4_ = NULL;
			gchar* _tmp5_;
			_tmp2_ = vala_typesymbol_get_cname (self->priv->current_data_type, FALSE);
			_tmp3_ = _tmp2_;
			_tmp4_ = g_strdup_printf ("%s::%s", _tmp3_, node->name);
			_tmp5_ = _tmp4_;
			_g_free0 (name);
			name = _tmp5_;
			_g_free0 (_tmp3_);
		} else {
			if (node->type == G_IDL_NODE_PROPERTY) {
				gchar* _tmp6_ = NULL;
				gchar* _tmp7_;
				gchar* _tmp8_ = NULL;
				gchar* _tmp9_;
				_tmp6_ = vala_typesymbol_get_cname (self->priv->current_data_type, FALSE);
				_tmp7_ = _tmp6_;
				_tmp8_ = g_strdup_printf ("%s:%s", _tmp7_, node->name);
				_tmp9_ = _tmp8_;
				_g_free0 (name);
				name = _tmp9_;
				_g_free0 (_tmp7_);
			} else {
				if (node->type == G_IDL_NODE_FIELD) {
					gchar* _tmp10_ = NULL;
					gchar* _tmp11_;
					gchar* _tmp12_ = NULL;
					gchar* _tmp13_;
					_tmp10_ = vala_typesymbol_get_cname (self->priv->current_data_type, FALSE);
					_tmp11_ = _tmp10_;
					_tmp12_ = g_strdup_printf ("%s.%s", _tmp11_, node->name);
					_tmp13_ = _tmp12_;
					_g_free0 (name);
					name = _tmp13_;
					_g_free0 (_tmp11_);
				} else {
					gchar* _tmp14_;
					gchar* _tmp15_;
					_tmp14_ = g_strdup (node->name);
					_tmp15_ = _tmp14_;
					_g_free0 (name);
					name = _tmp15_;
				}
			}
		}
	}
	_tmp17_ = vala_gidl_parser_get_attributes (self, name, &_tmp16_);
	_tmp18_ = _tmp17_;
	*result_length1 = _tmp16_;
	result = _tmp18_;
	_g_free0 (name);
	return result;
}


static void vala_gidl_parser_add_symbol_to_container (ValaGIdlParser* self, ValaSymbol* container, ValaSymbol* sym) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (sym != NULL);
	if (VALA_IS_CLASS (container)) {
		ValaClass* cl;
		cl = VALA_CLASS (container);
		if (VALA_IS_CLASS (sym)) {
			vala_symbol_add_class ((ValaSymbol*) cl, VALA_CLASS (sym));
		} else {
			if (VALA_IS_CONSTANT (sym)) {
				vala_symbol_add_constant ((ValaSymbol*) cl, VALA_CONSTANT (sym));
			} else {
				if (VALA_IS_ENUM (sym)) {
					vala_symbol_add_enum ((ValaSymbol*) cl, VALA_ENUM (sym));
				} else {
					if (VALA_IS_FIELD (sym)) {
						vala_symbol_add_field ((ValaSymbol*) cl, VALA_FIELD (sym));
					} else {
						if (VALA_IS_METHOD (sym)) {
							vala_symbol_add_method ((ValaSymbol*) cl, VALA_METHOD (sym));
						} else {
							if (VALA_IS_PROPERTY (sym)) {
								vala_symbol_add_property ((ValaSymbol*) cl, VALA_PROPERTY (sym));
							} else {
								if (VALA_IS_SIGNAL (sym)) {
									vala_symbol_add_signal ((ValaSymbol*) cl, VALA_SIGNAL (sym));
								} else {
									if (VALA_IS_STRUCT (sym)) {
										vala_symbol_add_struct ((ValaSymbol*) cl, VALA_STRUCT (sym));
									}
								}
							}
						}
					}
				}
			}
		}
	} else {
		if (VALA_IS_ENUM (container)) {
			ValaEnum* en;
			en = VALA_ENUM (container);
			if (VALA_IS_ENUM_VALUE (sym)) {
				vala_enum_add_value (en, VALA_ENUM_VALUE (sym));
			} else {
				if (VALA_IS_CONSTANT (sym)) {
					vala_symbol_add_constant ((ValaSymbol*) en, VALA_CONSTANT (sym));
				} else {
					if (VALA_IS_METHOD (sym)) {
						vala_symbol_add_method ((ValaSymbol*) en, VALA_METHOD (sym));
					}
				}
			}
		} else {
			if (VALA_IS_INTERFACE (container)) {
				ValaInterface* iface;
				iface = VALA_INTERFACE (container);
				if (VALA_IS_CLASS (sym)) {
					vala_symbol_add_class ((ValaSymbol*) iface, VALA_CLASS (sym));
				} else {
					if (VALA_IS_CONSTANT (sym)) {
						vala_symbol_add_constant ((ValaSymbol*) iface, VALA_CONSTANT (sym));
					} else {
						if (VALA_IS_ENUM (sym)) {
							vala_symbol_add_enum ((ValaSymbol*) iface, VALA_ENUM (sym));
						} else {
							if (VALA_IS_FIELD (sym)) {
								vala_symbol_add_field ((ValaSymbol*) iface, VALA_FIELD (sym));
							} else {
								if (VALA_IS_METHOD (sym)) {
									vala_symbol_add_method ((ValaSymbol*) iface, VALA_METHOD (sym));
								} else {
									if (VALA_IS_PROPERTY (sym)) {
										vala_symbol_add_property ((ValaSymbol*) iface, VALA_PROPERTY (sym));
									} else {
										if (VALA_IS_SIGNAL (sym)) {
											vala_symbol_add_signal ((ValaSymbol*) iface, VALA_SIGNAL (sym));
										} else {
											if (VALA_IS_STRUCT (sym)) {
												vala_symbol_add_struct ((ValaSymbol*) iface, VALA_STRUCT (sym));
											}
										}
									}
								}
							}
						}
					}
				}
			} else {
				if (VALA_IS_NAMESPACE (container)) {
					ValaNamespace* ns;
					ns = VALA_NAMESPACE (container);
					if (VALA_IS_NAMESPACE (sym)) {
						vala_symbol_add_namespace ((ValaSymbol*) ns, VALA_NAMESPACE (sym));
					} else {
						if (VALA_IS_CLASS (sym)) {
							vala_symbol_add_class ((ValaSymbol*) ns, VALA_CLASS (sym));
						} else {
							if (VALA_IS_CONSTANT (sym)) {
								vala_symbol_add_constant ((ValaSymbol*) ns, VALA_CONSTANT (sym));
							} else {
								if (VALA_IS_DELEGATE (sym)) {
									vala_symbol_add_delegate ((ValaSymbol*) ns, VALA_DELEGATE (sym));
								} else {
									if (VALA_IS_ENUM (sym)) {
										vala_symbol_add_enum ((ValaSymbol*) ns, VALA_ENUM (sym));
									} else {
										if (VALA_IS_ERROR_DOMAIN (sym)) {
											vala_symbol_add_error_domain ((ValaSymbol*) ns, VALA_ERROR_DOMAIN (sym));
										} else {
											if (VALA_IS_FIELD (sym)) {
												vala_symbol_add_field ((ValaSymbol*) ns, VALA_FIELD (sym));
											} else {
												if (VALA_IS_INTERFACE (sym)) {
													vala_symbol_add_interface ((ValaSymbol*) ns, VALA_INTERFACE (sym));
												} else {
													if (VALA_IS_METHOD (sym)) {
														vala_symbol_add_method ((ValaSymbol*) ns, VALA_METHOD (sym));
													} else {
														if (VALA_IS_NAMESPACE (sym)) {
															vala_symbol_add_namespace ((ValaSymbol*) ns, VALA_NAMESPACE (sym));
														} else {
															if (VALA_IS_STRUCT (sym)) {
																vala_symbol_add_struct ((ValaSymbol*) ns, VALA_STRUCT (sym));
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				} else {
					if (VALA_IS_STRUCT (container)) {
						ValaStruct* st;
						st = VALA_STRUCT (container);
						if (VALA_IS_CONSTANT (sym)) {
							vala_symbol_add_constant ((ValaSymbol*) st, VALA_CONSTANT (sym));
						} else {
							if (VALA_IS_FIELD (sym)) {
								vala_symbol_add_field ((ValaSymbol*) st, VALA_FIELD (sym));
							} else {
								if (VALA_IS_METHOD (sym)) {
									vala_symbol_add_method ((ValaSymbol*) st, VALA_METHOD (sym));
								} else {
									if (VALA_IS_PROPERTY (sym)) {
										vala_symbol_add_property ((ValaSymbol*) st, VALA_PROPERTY (sym));
									}
								}
							}
						}
					}
				}
			}
		}
	}
}


static void vala_gidl_parser_parse_node (ValaGIdlParser* self, GIdlNode* node, GIdlModule* module, ValaSymbol* container) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (module != NULL);
	g_return_if_fail (container != NULL);
	if (node->type == G_IDL_NODE_CALLBACK) {
		ValaDelegate* _tmp0_ = NULL;
		ValaDelegate* cb;
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		_tmp0_ = vala_gidl_parser_parse_delegate (self, (GIdlNodeFunction*) node);
		cb = _tmp0_;
		if (cb == NULL) {
			_vala_code_node_unref0 (cb);
			return;
		}
		_tmp1_ = vala_symbol_get_name ((ValaSymbol*) cb);
		_tmp2_ = vala_gidl_parser_fix_type_name (self, _tmp1_, container);
		_tmp3_ = _tmp2_;
		vala_symbol_set_name ((ValaSymbol*) cb, _tmp3_);
		_g_free0 (_tmp3_);
		vala_gidl_parser_add_symbol_to_container (self, container, (ValaSymbol*) cb);
		vala_source_file_add_node (self->priv->current_source_file, (ValaCodeNode*) cb);
		_vala_code_node_unref0 (cb);
	} else {
		if (node->type == G_IDL_NODE_STRUCT) {
			vala_gidl_parser_parse_struct (self, (GIdlNodeStruct*) node, container, module);
		} else {
			if (node->type == G_IDL_NODE_UNION) {
				vala_gidl_parser_parse_union (self, (GIdlNodeUnion*) node, container, module);
			} else {
				if (node->type == G_IDL_NODE_BOXED) {
					vala_gidl_parser_parse_boxed (self, (GIdlNodeBoxed*) node, container, module);
				} else {
					if (node->type == G_IDL_NODE_ENUM) {
						vala_gidl_parser_parse_enum (self, (GIdlNodeEnum*) node, container, module, FALSE);
					} else {
						if (node->type == G_IDL_NODE_FLAGS) {
							vala_gidl_parser_parse_enum (self, (GIdlNodeEnum*) node, container, module, TRUE);
						} else {
							if (node->type == G_IDL_NODE_OBJECT) {
								vala_gidl_parser_parse_object (self, (GIdlNodeInterface*) node, container, module);
							} else {
								if (node->type == G_IDL_NODE_INTERFACE) {
									vala_gidl_parser_parse_interface (self, (GIdlNodeInterface*) node, container, module);
								} else {
									if (node->type == G_IDL_NODE_CONSTANT) {
										ValaConstant* _tmp4_ = NULL;
										ValaConstant* c;
										_tmp4_ = vala_gidl_parser_parse_constant (self, (GIdlNodeConstant*) node);
										c = _tmp4_;
										if (c != NULL) {
											const gchar* _tmp5_ = NULL;
											gchar* _tmp6_ = NULL;
											gchar* _tmp7_;
											_tmp5_ = vala_symbol_get_name ((ValaSymbol*) c);
											_tmp6_ = vala_gidl_parser_fix_const_name (self, _tmp5_, container);
											_tmp7_ = _tmp6_;
											vala_symbol_set_name ((ValaSymbol*) c, _tmp7_);
											_g_free0 (_tmp7_);
											vala_gidl_parser_add_symbol_to_container (self, container, (ValaSymbol*) c);
											vala_source_file_add_node (self->priv->current_source_file, (ValaCodeNode*) c);
										}
										_vala_code_node_unref0 (c);
									} else {
										if (node->type == G_IDL_NODE_FUNCTION) {
											ValaMethod* _tmp8_ = NULL;
											ValaMethod* m;
											_tmp8_ = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) node, FALSE);
											m = _tmp8_;
											if (m != NULL) {
												vala_method_set_binding (m, VALA_MEMBER_BINDING_STATIC);
												vala_gidl_parser_add_symbol_to_container (self, container, (ValaSymbol*) m);
												vala_source_file_add_node (self->priv->current_source_file, (ValaCodeNode*) m);
											}
											_vala_code_node_unref0 (m);
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


static ValaSymbol* vala_gidl_parser_get_container_from_name (ValaGIdlParser* self, const gchar* name) {
	ValaSymbol* result = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_ = NULL;
	gint path_length1;
	gint _path_size_;
	gchar** _tmp2_;
	gchar** path;
	ValaSymbol* _tmp3_;
	ValaSymbol* cp;
	ValaSymbol* cc;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp1_ = _tmp0_ = g_strsplit (name, ".", 0);
	_tmp2_ = _tmp1_;
	path_length1 = _vala_array_length (_tmp0_);
	_path_size_ = path_length1;
	path = _tmp2_;
	_tmp3_ = _vala_code_node_ref0 ((ValaSymbol*) self->priv->current_namespace);
	cp = _tmp3_;
	cc = NULL;
	{
		gchar** tok_collection;
		int tok_collection_length1;
		int tok_it;
		tok_collection = path;
		tok_collection_length1 = path_length1;
		for (tok_it = 0; tok_it < path_length1; tok_it = tok_it + 1) {
			const gchar* tok;
			tok = tok_collection[tok_it];
			{
				ValaScope* _tmp4_ = NULL;
				ValaSymbol* _tmp5_ = NULL;
				ValaSymbol* _tmp6_;
				ValaSymbol* _tmp7_;
				ValaSymbol* _tmp13_;
				ValaSymbol* _tmp14_;
				_tmp4_ = vala_symbol_get_scope (cp);
				_tmp5_ = vala_scope_lookup (_tmp4_, tok);
				_tmp7_ = (_tmp6_ = _tmp5_, VALA_IS_SYMBOL (_tmp6_) ? ((ValaSymbol*) _tmp6_) : NULL);
				_vala_code_node_unref0 (cc);
				cc = _tmp7_;
				if (cc == NULL) {
					ValaNamespace* _tmp8_ = NULL;
					ValaSymbol* _tmp9_;
					gchar* _tmp10_ = NULL;
					gchar* _tmp11_;
					gchar* _tmp12_;
					_tmp8_ = vala_namespace_new (tok, self->priv->current_source_reference);
					_tmp9_ = (ValaSymbol*) _tmp8_;
					_vala_code_node_unref0 (cc);
					cc = _tmp9_;
					_tmp10_ = vala_symbol_get_cprefix (cp);
					_tmp11_ = _tmp10_;
					_tmp12_ = g_strconcat (_tmp11_, tok, NULL);
					vala_namespace_add_cprefix (VALA_NAMESPACE (cc), _tmp12_);
					_g_free0 (_tmp12_);
					_g_free0 (_tmp11_);
					vala_gidl_parser_add_symbol_to_container (self, cp, cc);
				}
				_tmp13_ = _vala_code_node_ref0 (cc);
				_tmp14_ = _tmp13_;
				_vala_code_node_unref0 (cp);
				cp = _tmp14_;
			}
		}
	}
	result = cc;
	_vala_code_node_unref0 (cp);
	path = (_vala_array_free (path, path_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static void _vala_code_node_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL));
}


static void _g_list_free__vala_code_node_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _vala_code_node_unref0_, NULL);
	g_list_free (self);
}


static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


static ValaNamespace* vala_gidl_parser_parse_module (ValaGIdlParser* self, GIdlModule* module) {
	ValaNamespace* result = NULL;
	ValaNamespace* _tmp0_ = NULL;
	ValaScope* _tmp1_ = NULL;
	ValaSymbol* _tmp2_ = NULL;
	ValaSymbol* sym;
	ValaNamespace* ns;
	ValaNamespace* _tmp9_;
	ValaNamespace* _tmp10_;
	const gchar* _tmp11_ = NULL;
	gint _tmp12_;
	gchar** _tmp13_ = NULL;
	gint attributes_length1;
	gint _attributes_size_;
	gchar** _tmp14_;
	gchar** attributes;
	ValaArrayList* _tmp38_ = NULL;
	ValaArrayList* deferred;
	ValaNamespace* _tmp59_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (module != NULL, NULL);
	_tmp0_ = vala_code_context_get_root (self->priv->context);
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) _tmp0_);
	_tmp2_ = vala_scope_lookup (_tmp1_, module->name);
	sym = _tmp2_;
	ns = NULL;
	if (VALA_IS_NAMESPACE (sym)) {
		ValaNamespace* _tmp3_;
		ValaNamespace* _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = _vala_code_node_ref0 (VALA_NAMESPACE (sym));
		_tmp4_ = _tmp3_;
		_vala_code_node_unref0 (ns);
		ns = _tmp4_;
		_tmp5_ = vala_symbol_get_external_package ((ValaSymbol*) ns);
		if (_tmp5_) {
			GList* _tmp6_;
			_tmp6_ = NULL;
			__g_list_free__vala_code_node_unref0_0 (((ValaCodeNode*) ns)->attributes);
			((ValaCodeNode*) ns)->attributes = _tmp6_;
			vala_code_node_set_source_reference ((ValaCodeNode*) ns, self->priv->current_source_reference);
		}
	} else {
		ValaNamespace* _tmp7_ = NULL;
		ValaNamespace* _tmp8_;
		_tmp7_ = vala_namespace_new (module->name, self->priv->current_source_reference);
		_tmp8_ = _tmp7_;
		_vala_code_node_unref0 (ns);
		ns = _tmp8_;
	}
	_tmp9_ = _vala_code_node_ref0 (ns);
	_tmp10_ = _tmp9_;
	_vala_code_node_unref0 (self->priv->current_namespace);
	self->priv->current_namespace = _tmp10_;
	_tmp11_ = vala_symbol_get_name ((ValaSymbol*) ns);
	_tmp13_ = vala_gidl_parser_get_attributes (self, _tmp11_, &_tmp12_);
	_tmp14_ = _tmp13_;
	attributes_length1 = _tmp12_;
	_attributes_size_ = attributes_length1;
	attributes = _tmp14_;
	if (attributes != NULL) {
		{
			gchar** attr_collection;
			int attr_collection_length1;
			int attr_it;
			attr_collection = attributes;
			attr_collection_length1 = attributes_length1;
			for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
				gchar* _tmp15_;
				gchar* attr;
				_tmp15_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp15_;
				{
					gchar** _tmp16_;
					gchar** _tmp17_ = NULL;
					gint nv_length1;
					gint _nv_size_;
					gchar** _tmp18_;
					gchar** nv;
					_tmp17_ = _tmp16_ = g_strsplit (attr, "=", 2);
					_tmp18_ = _tmp17_;
					nv_length1 = _vala_array_length (_tmp16_);
					_nv_size_ = nv_length1;
					nv = _tmp18_;
					if (g_strcmp0 (nv[0], "cheader_filename") == 0) {
						gchar* _tmp19_ = NULL;
						gchar* _tmp20_;
						_tmp19_ = vala_gidl_parser_eval (self, nv[1]);
						_tmp20_ = _tmp19_;
						vala_symbol_set_cheader_filename ((ValaSymbol*) ns, _tmp20_);
						_g_free0 (_tmp20_);
					} else {
						if (g_strcmp0 (nv[0], "cprefix") == 0) {
							gchar* _tmp21_ = NULL;
							gchar* _tmp22_;
							gchar** _tmp23_;
							gchar** _tmp24_ = NULL;
							gchar** _tmp25_;
							gint cprefixes_length1;
							gint _cprefixes_size_;
							gchar** _tmp26_;
							gchar** cprefixes;
							_tmp21_ = vala_gidl_parser_eval (self, nv[1]);
							_tmp22_ = _tmp21_;
							_tmp24_ = _tmp23_ = g_strsplit (_tmp22_, ",", 0);
							_tmp26_ = (_tmp25_ = _tmp24_, _g_free0 (_tmp22_), _tmp25_);
							cprefixes_length1 = _vala_array_length (_tmp23_);
							_cprefixes_size_ = cprefixes_length1;
							cprefixes = _tmp26_;
							{
								gchar** name_collection;
								int name_collection_length1;
								int name_it;
								name_collection = cprefixes;
								name_collection_length1 = cprefixes_length1;
								for (name_it = 0; name_it < cprefixes_length1; name_it = name_it + 1) {
									gchar* _tmp27_;
									gchar* name;
									_tmp27_ = g_strdup (name_collection[name_it]);
									name = _tmp27_;
									{
										vala_namespace_add_cprefix (ns, name);
										_g_free0 (name);
									}
								}
							}
							cprefixes = (_vala_array_free (cprefixes, cprefixes_length1, (GDestroyNotify) g_free), NULL);
						} else {
							if (g_strcmp0 (nv[0], "lower_case_cprefix") == 0) {
								gchar* _tmp28_ = NULL;
								gchar* _tmp29_;
								_tmp28_ = vala_gidl_parser_eval (self, nv[1]);
								_tmp29_ = _tmp28_;
								vala_namespace_set_lower_case_cprefix (ns, _tmp29_);
								_g_free0 (_tmp29_);
							} else {
								if (g_strcmp0 (nv[0], "gir_namespace") == 0) {
									ValaSourceReference* _tmp30_ = NULL;
									ValaSourceFile* _tmp31_ = NULL;
									gchar* _tmp32_ = NULL;
									gchar* _tmp33_;
									_tmp30_ = vala_code_node_get_source_reference ((ValaCodeNode*) ns);
									_tmp31_ = vala_source_reference_get_file (_tmp30_);
									_tmp32_ = vala_gidl_parser_eval (self, nv[1]);
									_tmp33_ = _tmp32_;
									vala_source_file_set_gir_namespace (_tmp31_, _tmp33_);
									_g_free0 (_tmp33_);
								} else {
									if (g_strcmp0 (nv[0], "gir_version") == 0) {
										ValaSourceReference* _tmp34_ = NULL;
										ValaSourceFile* _tmp35_ = NULL;
										gchar* _tmp36_ = NULL;
										gchar* _tmp37_;
										_tmp34_ = vala_code_node_get_source_reference ((ValaCodeNode*) ns);
										_tmp35_ = vala_source_reference_get_file (_tmp34_);
										_tmp36_ = vala_gidl_parser_eval (self, nv[1]);
										_tmp37_ = _tmp36_;
										vala_source_file_set_gir_version (_tmp35_, _tmp37_);
										_g_free0 (_tmp37_);
									}
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	_tmp38_ = vala_array_list_new (G_TYPE_POINTER, NULL, NULL, g_direct_equal);
	deferred = _tmp38_;
	{
		GList* node_collection;
		GList* node_it;
		node_collection = module->entries;
		for (node_it = node_collection; node_it != NULL; node_it = node_it->next) {
			GIdlNode* node;
			node = (GIdlNode*) node_it->data;
			{
				gboolean is_deferred;
				gint _tmp39_;
				gchar** _tmp40_ = NULL;
				gint child_attributes_length1;
				gint _child_attributes_size_;
				gchar** _tmp41_;
				gchar** child_attributes;
				is_deferred = FALSE;
				_tmp40_ = vala_gidl_parser_get_attributes_for_node (self, node, &_tmp39_);
				_tmp41_ = _tmp40_;
				child_attributes_length1 = _tmp39_;
				_child_attributes_size_ = child_attributes_length1;
				child_attributes = _tmp41_;
				if (child_attributes != NULL) {
					{
						gchar** attr_collection;
						int attr_collection_length1;
						int attr_it;
						attr_collection = child_attributes;
						attr_collection_length1 = child_attributes_length1;
						for (attr_it = 0; attr_it < child_attributes_length1; attr_it = attr_it + 1) {
							const gchar* attr;
							attr = attr_collection[attr_it];
							{
								gchar** _tmp42_;
								gchar** _tmp43_ = NULL;
								gint nv_length1;
								gint _nv_size_;
								gchar** _tmp44_;
								gchar** nv;
								_tmp43_ = _tmp42_ = g_strsplit (attr, "=", 2);
								_tmp44_ = _tmp43_;
								nv_length1 = _vala_array_length (_tmp42_);
								_nv_size_ = nv_length1;
								nv = _tmp44_;
								if (g_strcmp0 (nv[0], "parent") == 0) {
									vala_collection_add ((ValaCollection*) deferred, node);
									is_deferred = TRUE;
								}
								nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							}
						}
					}
				}
				if (!is_deferred) {
					vala_gidl_parser_parse_node (self, node, module, (ValaSymbol*) ns);
				}
				child_attributes = (_vala_array_free (child_attributes, child_attributes_length1, (GDestroyNotify) g_free), NULL);
			}
		}
	}
	{
		ValaArrayList* _tmp45_;
		ValaArrayList* _node_list;
		gint _tmp46_;
		gint _node_size;
		gint _node_index;
		_tmp45_ = _vala_iterable_ref0 (deferred);
		_node_list = _tmp45_;
		_tmp46_ = vala_collection_get_size ((ValaCollection*) _node_list);
		_node_size = _tmp46_;
		_node_index = -1;
		while (TRUE) {
			gpointer _tmp47_ = NULL;
			GIdlNode* node;
			ValaSymbol* _tmp48_;
			ValaSymbol* container;
			gint _tmp49_;
			gchar** _tmp50_ = NULL;
			gint child_attributes_length1;
			gint _child_attributes_size_;
			gchar** _tmp51_;
			gchar** child_attributes;
			_node_index = _node_index + 1;
			if (!(_node_index < _node_size)) {
				break;
			}
			_tmp47_ = vala_list_get ((ValaList*) _node_list, _node_index);
			node = (GIdlNode*) _tmp47_;
			_tmp48_ = _vala_code_node_ref0 ((ValaSymbol*) ns);
			container = _tmp48_;
			_tmp50_ = vala_gidl_parser_get_attributes_for_node (self, node, &_tmp49_);
			_tmp51_ = _tmp50_;
			child_attributes_length1 = _tmp49_;
			_child_attributes_size_ = child_attributes_length1;
			child_attributes = _tmp51_;
			if (child_attributes != NULL) {
				{
					gchar** attr_collection;
					int attr_collection_length1;
					int attr_it;
					attr_collection = child_attributes;
					attr_collection_length1 = child_attributes_length1;
					for (attr_it = 0; attr_it < child_attributes_length1; attr_it = attr_it + 1) {
						const gchar* attr;
						attr = attr_collection[attr_it];
						{
							gchar** _tmp52_;
							gchar** _tmp53_ = NULL;
							gint nv_length1;
							gint _nv_size_;
							gchar** _tmp54_;
							gchar** nv;
							_tmp53_ = _tmp52_ = g_strsplit (attr, "=", 2);
							_tmp54_ = _tmp53_;
							nv_length1 = _vala_array_length (_tmp52_);
							_nv_size_ = nv_length1;
							nv = _tmp54_;
							if (g_strcmp0 (nv[0], "parent") == 0) {
								gchar* _tmp55_ = NULL;
								gchar* _tmp56_;
								ValaSymbol* _tmp57_ = NULL;
								ValaSymbol* _tmp58_;
								_tmp55_ = vala_gidl_parser_eval (self, nv[1]);
								_tmp56_ = _tmp55_;
								_tmp57_ = vala_gidl_parser_get_container_from_name (self, _tmp56_);
								_tmp58_ = _tmp57_;
								_vala_code_node_unref0 (container);
								container = _tmp58_;
								_g_free0 (_tmp56_);
							}
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						}
					}
				}
			}
			vala_gidl_parser_parse_node (self, node, module, container);
			child_attributes = (_vala_array_free (child_attributes, child_attributes_length1, (GDestroyNotify) g_free), NULL);
			_vala_code_node_unref0 (container);
		}
		_vala_iterable_unref0 (_node_list);
	}
	_tmp59_ = NULL;
	_vala_code_node_unref0 (self->priv->current_namespace);
	self->priv->current_namespace = _tmp59_;
	if (VALA_IS_NAMESPACE (sym)) {
		result = NULL;
		_vala_iterable_unref0 (deferred);
		attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
		_vala_code_node_unref0 (ns);
		_vala_code_node_unref0 (sym);
		return result;
	}
	result = ns;
	_vala_iterable_unref0 (deferred);
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	_vala_code_node_unref0 (sym);
	return result;
}


static ValaDelegate* vala_gidl_parser_parse_delegate (ValaGIdlParser* self, GIdlNodeFunction* f_node) {
	ValaDelegate* result = NULL;
	GIdlNode* node;
	ValaDataType* _tmp0_ = NULL;
	ValaDataType* return_type;
	ValaDelegate* _tmp1_ = NULL;
	ValaDelegate* cb;
	gboolean check_has_target;
	gint _tmp2_;
	gchar** _tmp3_ = NULL;
	gint attributes_length1;
	gint _attributes_size_;
	gchar** _tmp4_;
	gchar** attributes;
	guint _tmp43_;
	guint remaining_params;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (f_node != NULL, NULL);
	node = (GIdlNode*) f_node;
	_tmp0_ = vala_gidl_parser_parse_param (self, f_node->result, NULL);
	return_type = _tmp0_;
	_tmp1_ = vala_delegate_new (node->name, return_type, self->priv->current_source_reference, NULL);
	cb = _tmp1_;
	vala_symbol_set_access ((ValaSymbol*) cb, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	check_has_target = TRUE;
	_tmp3_ = vala_gidl_parser_get_attributes (self, node->name, &_tmp2_);
	_tmp4_ = _tmp3_;
	attributes_length1 = _tmp2_;
	_attributes_size_ = attributes_length1;
	attributes = _tmp4_;
	if (attributes != NULL) {
		{
			gchar** attr_collection;
			int attr_collection_length1;
			int attr_it;
			attr_collection = attributes;
			attr_collection_length1 = attributes_length1;
			for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
				gchar* _tmp5_;
				gchar* attr;
				_tmp5_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp5_;
				{
					gchar** _tmp6_;
					gchar** _tmp7_ = NULL;
					gint nv_length1;
					gint _nv_size_;
					gchar** _tmp8_;
					gchar** nv;
					_tmp7_ = _tmp6_ = g_strsplit (attr, "=", 2);
					_tmp8_ = _tmp7_;
					nv_length1 = _vala_array_length (_tmp6_);
					_nv_size_ = nv_length1;
					nv = _tmp8_;
					if (g_strcmp0 (nv[0], "hidden") == 0) {
						gchar* _tmp9_ = NULL;
						gchar* _tmp10_;
						gboolean _tmp11_;
						_tmp9_ = vala_gidl_parser_eval (self, nv[1]);
						_tmp10_ = _tmp9_;
						if ((_tmp11_ = g_strcmp0 (_tmp10_, "1") == 0, _g_free0 (_tmp10_), _tmp11_)) {
							result = NULL;
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
							attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
							_vala_code_node_unref0 (cb);
							_vala_code_node_unref0 (return_type);
							return result;
						}
					} else {
						if (g_strcmp0 (nv[0], "cheader_filename") == 0) {
							gchar* _tmp12_ = NULL;
							gchar* _tmp13_;
							_tmp12_ = vala_gidl_parser_eval (self, nv[1]);
							_tmp13_ = _tmp12_;
							vala_symbol_add_cheader_filename ((ValaSymbol*) cb, _tmp13_);
							_g_free0 (_tmp13_);
						} else {
							if (g_strcmp0 (nv[0], "has_target") == 0) {
								gchar* _tmp14_ = NULL;
								gchar* _tmp15_;
								gboolean _tmp16_;
								_tmp14_ = vala_gidl_parser_eval (self, nv[1]);
								_tmp15_ = _tmp14_;
								if ((_tmp16_ = g_strcmp0 (_tmp15_, "0") == 0, _g_free0 (_tmp15_), _tmp16_)) {
									check_has_target = FALSE;
								} else {
									gchar* _tmp17_ = NULL;
									gchar* _tmp18_;
									gboolean _tmp19_;
									_tmp17_ = vala_gidl_parser_eval (self, nv[1]);
									_tmp18_ = _tmp17_;
									if ((_tmp19_ = g_strcmp0 (_tmp18_, "1") == 0, _g_free0 (_tmp18_), _tmp19_)) {
										vala_delegate_set_has_target (cb, TRUE);
									}
								}
							} else {
								if (g_strcmp0 (nv[0], "transfer_ownership") == 0) {
									gchar* _tmp20_ = NULL;
									gchar* _tmp21_;
									gboolean _tmp22_;
									_tmp20_ = vala_gidl_parser_eval (self, nv[1]);
									_tmp21_ = _tmp20_;
									if ((_tmp22_ = g_strcmp0 (_tmp21_, "1") == 0, _g_free0 (_tmp21_), _tmp22_)) {
										vala_data_type_set_value_owned (return_type, TRUE);
									}
								} else {
									if (g_strcmp0 (nv[0], "deprecated") == 0) {
										gchar* _tmp23_ = NULL;
										gchar* _tmp24_;
										gboolean _tmp25_;
										_tmp23_ = vala_gidl_parser_eval (self, nv[1]);
										_tmp24_ = _tmp23_;
										if ((_tmp25_ = g_strcmp0 (_tmp24_, "1") == 0, _g_free0 (_tmp24_), _tmp25_)) {
											vala_symbol_set_deprecated ((ValaSymbol*) cb, TRUE);
										}
									} else {
										if (g_strcmp0 (nv[0], "replacement") == 0) {
											gchar* _tmp26_ = NULL;
											gchar* _tmp27_;
											_tmp26_ = vala_gidl_parser_eval (self, nv[1]);
											_tmp27_ = _tmp26_;
											vala_symbol_set_replacement ((ValaSymbol*) cb, _tmp27_);
											_g_free0 (_tmp27_);
										} else {
											if (g_strcmp0 (nv[0], "deprecated_since") == 0) {
												gchar* _tmp28_ = NULL;
												gchar* _tmp29_;
												_tmp28_ = vala_gidl_parser_eval (self, nv[1]);
												_tmp29_ = _tmp28_;
												vala_symbol_set_deprecated_since ((ValaSymbol*) cb, _tmp29_);
												_g_free0 (_tmp29_);
											} else {
												if (g_strcmp0 (nv[0], "type_arguments") == 0) {
													gchar* _tmp30_ = NULL;
													gchar* _tmp31_;
													_tmp30_ = vala_gidl_parser_eval (self, nv[1]);
													_tmp31_ = _tmp30_;
													vala_gidl_parser_parse_type_arguments_from_string (self, return_type, _tmp31_, NULL);
													_g_free0 (_tmp31_);
												} else {
													if (g_strcmp0 (nv[0], "instance_pos") == 0) {
														gchar* _tmp32_ = NULL;
														gchar* _tmp33_;
														gdouble _tmp34_;
														_tmp32_ = vala_gidl_parser_eval (self, nv[1]);
														_tmp33_ = _tmp32_;
														_tmp34_ = g_ascii_strtod (_tmp33_, NULL);
														vala_delegate_set_cinstance_parameter_position (cb, _tmp34_);
														_g_free0 (_tmp33_);
													} else {
														if (g_strcmp0 (nv[0], "type_parameters") == 0) {
															gchar* _tmp35_ = NULL;
															gchar* _tmp36_;
															gchar** _tmp37_;
															gchar** _tmp38_ = NULL;
															gchar** _tmp39_;
															_tmp35_ = vala_gidl_parser_eval (self, nv[1]);
															_tmp36_ = _tmp35_;
															_tmp38_ = _tmp37_ = g_strsplit (_tmp36_, ",", 0);
															{
																gchar** type_param_name_collection;
																int type_param_name_collection_length1;
																int type_param_name_it;
																type_param_name_collection = (_tmp39_ = _tmp38_, _g_free0 (_tmp36_), _tmp39_);
																type_param_name_collection_length1 = _vala_array_length (_tmp37_);
																for (type_param_name_it = 0; type_param_name_it < _vala_array_length (_tmp37_); type_param_name_it = type_param_name_it + 1) {
																	gchar* _tmp40_;
																	gchar* type_param_name;
																	_tmp40_ = g_strdup (type_param_name_collection[type_param_name_it]);
																	type_param_name = _tmp40_;
																	{
																		ValaTypeParameter* _tmp41_ = NULL;
																		ValaTypeParameter* _tmp42_;
																		_tmp41_ = vala_typeparameter_new (type_param_name, self->priv->current_source_reference);
																		_tmp42_ = _tmp41_;
																		vala_delegate_add_type_parameter (cb, _tmp42_);
																		_vala_code_node_unref0 (_tmp42_);
																		_g_free0 (type_param_name);
																	}
																}
																type_param_name_collection = (_vala_array_free (type_param_name_collection, type_param_name_collection_length1, (GDestroyNotify) g_free), NULL);
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	_tmp43_ = g_list_length (f_node->parameters);
	remaining_params = _tmp43_;
	{
		GList* param_collection;
		GList* param_it;
		param_collection = f_node->parameters;
		for (param_it = param_collection; param_it != NULL; param_it = param_it->next) {
			GIdlNodeParam* param;
			param = (GIdlNodeParam*) param_it->data;
			{
				GIdlNode* param_node;
				gboolean _tmp44_ = FALSE;
				gboolean _tmp45_ = FALSE;
				param_node = (GIdlNode*) param;
				if (check_has_target) {
					_tmp45_ = remaining_params == 1;
				} else {
					_tmp45_ = FALSE;
				}
				if (_tmp45_) {
					gboolean _tmp46_ = FALSE;
					if (g_strcmp0 (param_node->name, "user_data") == 0) {
						_tmp46_ = TRUE;
					} else {
						_tmp46_ = g_strcmp0 (param_node->name, "data") == 0;
					}
					_tmp44_ = _tmp46_;
				} else {
					_tmp44_ = FALSE;
				}
				if (_tmp44_) {
					vala_delegate_set_has_target (cb, TRUE);
				} else {
					gchar* _tmp47_;
					gchar* param_name;
					ValaParameterDirection direction = 0;
					ValaParameterDirection _tmp52_;
					ValaDataType* _tmp53_ = NULL;
					ValaDataType* param_type;
					ValaParameter* _tmp54_ = NULL;
					ValaParameter* p;
					gboolean hide_param;
					gboolean show_param;
					gboolean array_requested;
					gboolean out_requested;
					gchar* _tmp55_ = NULL;
					gchar* _tmp56_;
					gint _tmp57_;
					gchar** _tmp58_ = NULL;
					gchar** _tmp59_;
					gboolean _tmp107_ = FALSE;
					_tmp47_ = g_strdup (param_node->name);
					param_name = _tmp47_;
					if (g_strcmp0 (param_name, "string") == 0) {
						gchar* _tmp48_;
						gchar* _tmp49_;
						_tmp48_ = g_strdup ("str");
						_tmp49_ = _tmp48_;
						_g_free0 (param_name);
						param_name = _tmp49_;
					} else {
						if (g_strcmp0 (param_name, "self") == 0) {
							gchar* _tmp50_;
							gchar* _tmp51_;
							_tmp50_ = g_strdup ("_self");
							_tmp51_ = _tmp50_;
							_g_free0 (param_name);
							param_name = _tmp51_;
						}
					}
					_tmp53_ = vala_gidl_parser_parse_param (self, param, &_tmp52_);
					direction = _tmp52_;
					param_type = _tmp53_;
					_tmp54_ = vala_parameter_new (param_name, param_type, NULL);
					p = _tmp54_;
					vala_parameter_set_direction (p, direction);
					hide_param = FALSE;
					show_param = FALSE;
					array_requested = FALSE;
					out_requested = FALSE;
					_tmp55_ = g_strdup_printf ("%s.%s", node->name, param_node->name);
					_tmp56_ = _tmp55_;
					_tmp58_ = vala_gidl_parser_get_attributes (self, _tmp56_, &_tmp57_);
					_tmp59_ = _tmp58_;
					attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
					attributes_length1 = _tmp57_;
					_attributes_size_ = attributes_length1;
					attributes = _tmp59_;
					_g_free0 (_tmp56_);
					if (attributes != NULL) {
						{
							gchar** attr_collection;
							int attr_collection_length1;
							int attr_it;
							attr_collection = attributes;
							attr_collection_length1 = attributes_length1;
							for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
								gchar* _tmp60_;
								gchar* attr;
								_tmp60_ = g_strdup (attr_collection[attr_it]);
								attr = _tmp60_;
								{
									gchar** _tmp61_;
									gchar** _tmp62_ = NULL;
									gint nv_length1;
									gint _nv_size_;
									gchar** _tmp63_;
									gchar** nv;
									_tmp62_ = _tmp61_ = g_strsplit (attr, "=", 2);
									_tmp63_ = _tmp62_;
									nv_length1 = _vala_array_length (_tmp61_);
									_nv_size_ = nv_length1;
									nv = _tmp63_;
									if (g_strcmp0 (nv[0], "hidden") == 0) {
										gchar* _tmp64_ = NULL;
										gchar* _tmp65_;
										gboolean _tmp66_;
										_tmp64_ = vala_gidl_parser_eval (self, nv[1]);
										_tmp65_ = _tmp64_;
										if ((_tmp66_ = g_strcmp0 (_tmp65_, "1") == 0, _g_free0 (_tmp65_), _tmp66_)) {
											hide_param = TRUE;
										} else {
											gchar* _tmp67_ = NULL;
											gchar* _tmp68_;
											gboolean _tmp69_;
											_tmp67_ = vala_gidl_parser_eval (self, nv[1]);
											_tmp68_ = _tmp67_;
											if ((_tmp69_ = g_strcmp0 (_tmp68_, "0") == 0, _g_free0 (_tmp68_), _tmp69_)) {
												show_param = TRUE;
											}
										}
									} else {
										if (g_strcmp0 (nv[0], "is_array") == 0) {
											gchar* _tmp70_ = NULL;
											gchar* _tmp71_;
											gboolean _tmp72_;
											_tmp70_ = vala_gidl_parser_eval (self, nv[1]);
											_tmp71_ = _tmp70_;
											if ((_tmp72_ = g_strcmp0 (_tmp71_, "1") == 0, _g_free0 (_tmp71_), _tmp72_)) {
												ValaSourceReference* _tmp73_ = NULL;
												ValaArrayType* _tmp74_ = NULL;
												ValaDataType* _tmp75_;
												_tmp73_ = vala_code_node_get_source_reference ((ValaCodeNode*) param_type);
												_tmp74_ = vala_array_type_new (param_type, 1, _tmp73_);
												_tmp75_ = (ValaDataType*) _tmp74_;
												_vala_code_node_unref0 (param_type);
												param_type = _tmp75_;
												vala_variable_set_variable_type ((ValaVariable*) p, param_type);
												if (!out_requested) {
													vala_parameter_set_direction (p, VALA_PARAMETER_DIRECTION_IN);
												}
												array_requested = TRUE;
											}
										} else {
											if (g_strcmp0 (nv[0], "is_out") == 0) {
												gchar* _tmp76_ = NULL;
												gchar* _tmp77_;
												gboolean _tmp78_;
												_tmp76_ = vala_gidl_parser_eval (self, nv[1]);
												_tmp77_ = _tmp76_;
												if ((_tmp78_ = g_strcmp0 (_tmp77_, "1") == 0, _g_free0 (_tmp77_), _tmp78_)) {
													gboolean _tmp79_ = FALSE;
													vala_parameter_set_direction (p, VALA_PARAMETER_DIRECTION_OUT);
													out_requested = TRUE;
													if (!array_requested) {
														_tmp79_ = VALA_IS_ARRAY_TYPE (param_type);
													} else {
														_tmp79_ = FALSE;
													}
													if (_tmp79_) {
														ValaArrayType* _tmp80_;
														ValaArrayType* array_type;
														ValaDataType* _tmp81_ = NULL;
														ValaDataType* _tmp82_;
														ValaDataType* _tmp83_;
														_tmp80_ = _vala_code_node_ref0 (VALA_ARRAY_TYPE (param_type));
														array_type = _tmp80_;
														_tmp81_ = vala_array_type_get_element_type (array_type);
														_tmp82_ = _vala_code_node_ref0 (_tmp81_);
														_tmp83_ = _tmp82_;
														_vala_code_node_unref0 (param_type);
														param_type = _tmp83_;
														vala_variable_set_variable_type ((ValaVariable*) p, param_type);
														_vala_code_node_unref0 (array_type);
													}
												}
											} else {
												if (g_strcmp0 (nv[0], "is_ref") == 0) {
													gchar* _tmp84_ = NULL;
													gchar* _tmp85_;
													gboolean _tmp86_;
													_tmp84_ = vala_gidl_parser_eval (self, nv[1]);
													_tmp85_ = _tmp84_;
													if ((_tmp86_ = g_strcmp0 (_tmp85_, "1") == 0, _g_free0 (_tmp85_), _tmp86_)) {
														gboolean _tmp87_ = FALSE;
														vala_parameter_set_direction (p, VALA_PARAMETER_DIRECTION_REF);
														if (!array_requested) {
															_tmp87_ = VALA_IS_ARRAY_TYPE (param_type);
														} else {
															_tmp87_ = FALSE;
														}
														if (_tmp87_) {
															ValaArrayType* _tmp88_;
															ValaArrayType* array_type;
															ValaDataType* _tmp89_ = NULL;
															ValaDataType* _tmp90_;
															ValaDataType* _tmp91_;
															_tmp88_ = _vala_code_node_ref0 (VALA_ARRAY_TYPE (param_type));
															array_type = _tmp88_;
															_tmp89_ = vala_array_type_get_element_type (array_type);
															_tmp90_ = _vala_code_node_ref0 (_tmp89_);
															_tmp91_ = _tmp90_;
															_vala_code_node_unref0 (param_type);
															param_type = _tmp91_;
															vala_variable_set_variable_type ((ValaVariable*) p, param_type);
															_vala_code_node_unref0 (array_type);
														}
													}
												} else {
													if (g_strcmp0 (nv[0], "takes_ownership") == 0) {
														gchar* _tmp92_ = NULL;
														gchar* _tmp93_;
														gboolean _tmp94_;
														_tmp92_ = vala_gidl_parser_eval (self, nv[1]);
														_tmp93_ = _tmp92_;
														if ((_tmp94_ = g_strcmp0 (_tmp93_, "1") == 0, _g_free0 (_tmp93_), _tmp94_)) {
															vala_data_type_set_value_owned (param_type, TRUE);
														}
													} else {
														if (g_strcmp0 (nv[0], "nullable") == 0) {
															gchar* _tmp95_ = NULL;
															gchar* _tmp96_;
															gboolean _tmp97_;
															_tmp95_ = vala_gidl_parser_eval (self, nv[1]);
															_tmp96_ = _tmp95_;
															if ((_tmp97_ = g_strcmp0 (_tmp96_, "1") == 0, _g_free0 (_tmp96_), _tmp97_)) {
																vala_data_type_set_nullable (param_type, TRUE);
															}
														} else {
															if (g_strcmp0 (nv[0], "type_arguments") == 0) {
																gchar* _tmp98_ = NULL;
																gchar* _tmp99_;
																_tmp98_ = vala_gidl_parser_eval (self, nv[1]);
																_tmp99_ = _tmp98_;
																vala_gidl_parser_parse_type_arguments_from_string (self, param_type, _tmp99_, NULL);
																_g_free0 (_tmp99_);
															} else {
																if (g_strcmp0 (nv[0], "no_array_length") == 0) {
																	gchar* _tmp100_ = NULL;
																	gchar* _tmp101_;
																	gboolean _tmp102_;
																	_tmp100_ = vala_gidl_parser_eval (self, nv[1]);
																	_tmp101_ = _tmp100_;
																	if ((_tmp102_ = g_strcmp0 (_tmp101_, "1") == 0, _g_free0 (_tmp101_), _tmp102_)) {
																		vala_parameter_set_no_array_length (p, TRUE);
																	}
																} else {
																	if (g_strcmp0 (nv[0], "type_name") == 0) {
																		gchar* _tmp103_ = NULL;
																		gchar* _tmp104_;
																		ValaDataType* _tmp105_ = NULL;
																		ValaDataType* _tmp106_;
																		_tmp103_ = vala_gidl_parser_eval (self, nv[1]);
																		_tmp104_ = _tmp103_;
																		_tmp105_ = vala_gidl_parser_parse_type_from_string (self, _tmp104_, FALSE, NULL);
																		_tmp106_ = _tmp105_;
																		_vala_code_node_unref0 (param_type);
																		param_type = _tmp106_;
																		vala_variable_set_variable_type ((ValaVariable*) p, param_type);
																		_g_free0 (_tmp104_);
																	}
																}
															}
														}
													}
												}
											}
										}
									}
									nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
									_g_free0 (attr);
								}
							}
						}
					}
					if (show_param) {
						_tmp107_ = TRUE;
					} else {
						_tmp107_ = !hide_param;
					}
					if (_tmp107_) {
						vala_delegate_add_parameter (cb, p);
					}
					_vala_code_node_unref0 (p);
					_vala_code_node_unref0 (param_type);
					_g_free0 (param_name);
				}
				remaining_params--;
			}
		}
	}
	result = cb;
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	_vala_code_node_unref0 (return_type);
	return result;
}


static gboolean vala_gidl_parser_is_reference_type (ValaGIdlParser* self, const gchar* cname) {
	gboolean result = FALSE;
	gint _tmp0_;
	gchar** _tmp1_ = NULL;
	gint st_attributes_length1;
	gint _st_attributes_size_;
	gchar** _tmp2_;
	gchar** st_attributes;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (cname != NULL, FALSE);
	_tmp1_ = vala_gidl_parser_get_attributes (self, cname, &_tmp0_);
	_tmp2_ = _tmp1_;
	st_attributes_length1 = _tmp0_;
	_st_attributes_size_ = st_attributes_length1;
	st_attributes = _tmp2_;
	if (st_attributes != NULL) {
		{
			gchar** attr_collection;
			int attr_collection_length1;
			int attr_it;
			attr_collection = st_attributes;
			attr_collection_length1 = st_attributes_length1;
			for (attr_it = 0; attr_it < st_attributes_length1; attr_it = attr_it + 1) {
				gchar* _tmp3_;
				gchar* attr;
				_tmp3_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp3_;
				{
					gchar** _tmp4_;
					gchar** _tmp5_ = NULL;
					gint nv_length1;
					gint _nv_size_;
					gchar** _tmp6_;
					gchar** nv;
					gboolean _tmp7_ = FALSE;
					_tmp5_ = _tmp4_ = g_strsplit (attr, "=", 2);
					_tmp6_ = _tmp5_;
					nv_length1 = _vala_array_length (_tmp4_);
					_nv_size_ = nv_length1;
					nv = _tmp6_;
					if (g_strcmp0 (nv[0], "is_value_type") == 0) {
						gchar* _tmp8_ = NULL;
						gchar* _tmp9_;
						_tmp8_ = vala_gidl_parser_eval (self, nv[1]);
						_tmp9_ = _tmp8_;
						_tmp7_ = g_strcmp0 (_tmp9_, "1") == 0;
						_g_free0 (_tmp9_);
					} else {
						_tmp7_ = FALSE;
					}
					if (_tmp7_) {
						result = FALSE;
						nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (attr);
						st_attributes = (_vala_array_free (st_attributes, st_attributes_length1, (GDestroyNotify) g_free), NULL);
						return result;
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	result = TRUE;
	st_attributes = (_vala_array_free (st_attributes, st_attributes_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static void vala_gidl_parser_parse_struct (ValaGIdlParser* self, GIdlNodeStruct* st_node, ValaSymbol* container, GIdlModule* module) {
	GIdlNode* node;
	gchar* _tmp0_ = NULL;
	gchar* name;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (st_node != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (module != NULL);
	node = (GIdlNode*) st_node;
	if (st_node->deprecated) {
		return;
	}
	_tmp0_ = vala_gidl_parser_fix_type_name (self, node->name, container);
	name = _tmp0_;
	_tmp1_ = vala_gidl_parser_is_reference_type (self, node->name);
	if (!_tmp1_) {
		ValaScope* _tmp2_ = NULL;
		ValaSymbol* _tmp3_ = NULL;
		ValaSymbol* _tmp4_;
		ValaStruct* st;
		ValaTypeSymbol* _tmp50_;
		ValaTypeSymbol* _tmp51_;
		ValaTypeSymbol* _tmp54_;
		_tmp2_ = vala_symbol_get_scope (container);
		_tmp3_ = vala_scope_lookup (_tmp2_, name);
		st = (_tmp4_ = _tmp3_, VALA_IS_STRUCT (_tmp4_) ? ((ValaStruct*) _tmp4_) : NULL);
		if (st == NULL) {
			ValaStruct* _tmp5_ = NULL;
			ValaStruct* _tmp6_;
			gint _tmp7_;
			gchar** _tmp8_ = NULL;
			gint st_attributes_length1;
			gint _st_attributes_size_;
			gchar** _tmp9_;
			gchar** st_attributes;
			_tmp5_ = vala_struct_new (name, self->priv->current_source_reference, NULL);
			_tmp6_ = _tmp5_;
			_vala_code_node_unref0 (st);
			st = _tmp6_;
			vala_symbol_set_access ((ValaSymbol*) st, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
			_tmp8_ = vala_gidl_parser_get_attributes (self, node->name, &_tmp7_);
			_tmp9_ = _tmp8_;
			st_attributes_length1 = _tmp7_;
			_st_attributes_size_ = st_attributes_length1;
			st_attributes = _tmp9_;
			if (st_attributes != NULL) {
				{
					gchar** attr_collection;
					int attr_collection_length1;
					int attr_it;
					attr_collection = st_attributes;
					attr_collection_length1 = st_attributes_length1;
					for (attr_it = 0; attr_it < st_attributes_length1; attr_it = attr_it + 1) {
						gchar* _tmp10_;
						gchar* attr;
						_tmp10_ = g_strdup (attr_collection[attr_it]);
						attr = _tmp10_;
						{
							gchar** _tmp11_;
							gchar** _tmp12_ = NULL;
							gint nv_length1;
							gint _nv_size_;
							gchar** _tmp13_;
							gchar** nv;
							_tmp12_ = _tmp11_ = g_strsplit (attr, "=", 2);
							_tmp13_ = _tmp12_;
							nv_length1 = _vala_array_length (_tmp11_);
							_nv_size_ = nv_length1;
							nv = _tmp13_;
							if (g_strcmp0 (nv[0], "cheader_filename") == 0) {
								gchar* _tmp14_ = NULL;
								gchar* _tmp15_;
								_tmp14_ = vala_gidl_parser_eval (self, nv[1]);
								_tmp15_ = _tmp14_;
								vala_symbol_add_cheader_filename ((ValaSymbol*) st, _tmp15_);
								_g_free0 (_tmp15_);
							} else {
								if (g_strcmp0 (nv[0], "hidden") == 0) {
									gchar* _tmp16_ = NULL;
									gchar* _tmp17_;
									gboolean _tmp18_;
									_tmp16_ = vala_gidl_parser_eval (self, nv[1]);
									_tmp17_ = _tmp16_;
									if ((_tmp18_ = g_strcmp0 (_tmp17_, "1") == 0, _g_free0 (_tmp17_), _tmp18_)) {
										nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
										_g_free0 (attr);
										st_attributes = (_vala_array_free (st_attributes, st_attributes_length1, (GDestroyNotify) g_free), NULL);
										_vala_code_node_unref0 (st);
										_g_free0 (name);
										return;
									}
								} else {
									if (g_strcmp0 (nv[0], "base_type") == 0) {
										gchar* _tmp19_ = NULL;
										gchar* _tmp20_;
										ValaDataType* _tmp21_ = NULL;
										ValaDataType* _tmp22_;
										_tmp19_ = vala_gidl_parser_eval (self, nv[1]);
										_tmp20_ = _tmp19_;
										_tmp21_ = vala_gidl_parser_parse_type_string (self, _tmp20_);
										_tmp22_ = _tmp21_;
										vala_struct_set_base_type (st, _tmp22_);
										_vala_code_node_unref0 (_tmp22_);
										_g_free0 (_tmp20_);
									} else {
										if (g_strcmp0 (nv[0], "rank") == 0) {
											gchar* _tmp23_ = NULL;
											gchar* _tmp24_;
											gint _tmp25_;
											_tmp23_ = vala_gidl_parser_eval (self, nv[1]);
											_tmp24_ = _tmp23_;
											_tmp25_ = atoi (_tmp24_);
											vala_struct_set_rank (st, _tmp25_);
											_g_free0 (_tmp24_);
										} else {
											if (g_strcmp0 (nv[0], "simple_type") == 0) {
												gchar* _tmp26_ = NULL;
												gchar* _tmp27_;
												gboolean _tmp28_;
												_tmp26_ = vala_gidl_parser_eval (self, nv[1]);
												_tmp27_ = _tmp26_;
												if ((_tmp28_ = g_strcmp0 (_tmp27_, "1") == 0, _g_free0 (_tmp27_), _tmp28_)) {
													vala_struct_set_simple_type (st, TRUE);
												}
											} else {
												if (g_strcmp0 (nv[0], "immutable") == 0) {
													gchar* _tmp29_ = NULL;
													gchar* _tmp30_;
													gboolean _tmp31_;
													_tmp29_ = vala_gidl_parser_eval (self, nv[1]);
													_tmp30_ = _tmp29_;
													if ((_tmp31_ = g_strcmp0 (_tmp30_, "1") == 0, _g_free0 (_tmp30_), _tmp31_)) {
														vala_struct_set_is_immutable (st, TRUE);
													}
												} else {
													if (g_strcmp0 (nv[0], "has_type_id") == 0) {
														gchar* _tmp32_ = NULL;
														gchar* _tmp33_;
														gboolean _tmp34_;
														_tmp32_ = vala_gidl_parser_eval (self, nv[1]);
														_tmp33_ = _tmp32_;
														if ((_tmp34_ = g_strcmp0 (_tmp33_, "0") == 0, _g_free0 (_tmp33_), _tmp34_)) {
															vala_struct_set_has_type_id (st, FALSE);
														}
													} else {
														if (g_strcmp0 (nv[0], "type_id") == 0) {
															gchar* _tmp35_ = NULL;
															gchar* _tmp36_;
															_tmp35_ = vala_gidl_parser_eval (self, nv[1]);
															_tmp36_ = _tmp35_;
															vala_struct_set_type_id (st, _tmp36_);
															_g_free0 (_tmp36_);
														} else {
															if (g_strcmp0 (nv[0], "has_copy_function") == 0) {
																gchar* _tmp37_ = NULL;
																gchar* _tmp38_;
																gboolean _tmp39_;
																_tmp37_ = vala_gidl_parser_eval (self, nv[1]);
																_tmp38_ = _tmp37_;
																if ((_tmp39_ = g_strcmp0 (_tmp38_, "0") == 0, _g_free0 (_tmp38_), _tmp39_)) {
																	vala_struct_set_has_copy_function (st, FALSE);
																}
															} else {
																if (g_strcmp0 (nv[0], "deprecated") == 0) {
																	gchar* _tmp40_ = NULL;
																	gchar* _tmp41_;
																	gboolean _tmp42_;
																	_tmp40_ = vala_gidl_parser_eval (self, nv[1]);
																	_tmp41_ = _tmp40_;
																	if ((_tmp42_ = g_strcmp0 (_tmp41_, "1") == 0, _g_free0 (_tmp41_), _tmp42_)) {
																		vala_symbol_set_deprecated ((ValaSymbol*) st, TRUE);
																	}
																} else {
																	if (g_strcmp0 (nv[0], "replacement") == 0) {
																		gchar* _tmp43_ = NULL;
																		gchar* _tmp44_;
																		_tmp43_ = vala_gidl_parser_eval (self, nv[1]);
																		_tmp44_ = _tmp43_;
																		vala_symbol_set_replacement ((ValaSymbol*) st, _tmp44_);
																		_g_free0 (_tmp44_);
																	} else {
																		if (g_strcmp0 (nv[0], "deprecated_since") == 0) {
																			gchar* _tmp45_ = NULL;
																			gchar* _tmp46_;
																			_tmp45_ = vala_gidl_parser_eval (self, nv[1]);
																			_tmp46_ = _tmp45_;
																			vala_symbol_set_deprecated_since ((ValaSymbol*) st, _tmp46_);
																			_g_free0 (_tmp46_);
																		} else {
																			if (g_strcmp0 (nv[0], "has_destroy_function") == 0) {
																				gchar* _tmp47_ = NULL;
																				gchar* _tmp48_;
																				gboolean _tmp49_;
																				_tmp47_ = vala_gidl_parser_eval (self, nv[1]);
																				_tmp48_ = _tmp47_;
																				if ((_tmp49_ = g_strcmp0 (_tmp48_, "0") == 0, _g_free0 (_tmp48_), _tmp49_)) {
																					vala_struct_set_has_destroy_function (st, FALSE);
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
						}
					}
				}
			}
			vala_gidl_parser_add_symbol_to_container (self, container, (ValaSymbol*) st);
			vala_source_file_add_node (self->priv->current_source_file, (ValaCodeNode*) st);
			st_attributes = (_vala_array_free (st_attributes, st_attributes_length1, (GDestroyNotify) g_free), NULL);
		}
		_tmp50_ = _vala_code_node_ref0 ((ValaTypeSymbol*) st);
		_tmp51_ = _tmp50_;
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = _tmp51_;
		{
			GList* member_collection;
			GList* member_it;
			member_collection = st_node->members;
			for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
				GIdlNode* member;
				member = (GIdlNode*) member_it->data;
				{
					if (member->type == G_IDL_NODE_FUNCTION) {
						ValaMethod* _tmp52_ = NULL;
						ValaMethod* m;
						_tmp52_ = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) member, FALSE);
						m = _tmp52_;
						if (m != NULL) {
							vala_symbol_add_method ((ValaSymbol*) st, m);
						}
						_vala_code_node_unref0 (m);
					} else {
						if (member->type == G_IDL_NODE_FIELD) {
							ValaField* _tmp53_ = NULL;
							ValaField* f;
							_tmp53_ = vala_gidl_parser_parse_field (self, (GIdlNodeField*) member);
							f = _tmp53_;
							if (f != NULL) {
								vala_symbol_add_field ((ValaSymbol*) st, f);
							}
							_vala_code_node_unref0 (f);
						}
					}
				}
			}
		}
		_tmp54_ = NULL;
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = _tmp54_;
		_vala_code_node_unref0 (st);
	} else {
		gboolean ref_function_void;
		gchar* ref_function;
		gchar* unref_function;
		gchar* copy_function;
		gchar* free_function;
		ValaScope* _tmp55_ = NULL;
		ValaSymbol* _tmp56_ = NULL;
		ValaSymbol* _tmp57_;
		ValaClass* cl;
		ValaTypeSymbol* _tmp113_;
		ValaTypeSymbol* _tmp114_;
		ValaTypeSymbol* _tmp132_;
		ref_function_void = FALSE;
		ref_function = NULL;
		unref_function = NULL;
		copy_function = NULL;
		free_function = NULL;
		_tmp55_ = vala_symbol_get_scope (container);
		_tmp56_ = vala_scope_lookup (_tmp55_, name);
		cl = (_tmp57_ = _tmp56_, VALA_IS_CLASS (_tmp57_) ? ((ValaClass*) _tmp57_) : NULL);
		if (cl == NULL) {
			gchar* base_class;
			ValaClass* _tmp58_ = NULL;
			ValaClass* _tmp59_;
			gint _tmp60_;
			gchar** _tmp61_ = NULL;
			gint cl_attributes_length1;
			gint _cl_attributes_size_;
			gchar** _tmp62_;
			gchar** cl_attributes;
			base_class = NULL;
			_tmp58_ = vala_class_new (name, self->priv->current_source_reference, NULL);
			_tmp59_ = _tmp58_;
			_vala_code_node_unref0 (cl);
			cl = _tmp59_;
			vala_symbol_set_access ((ValaSymbol*) cl, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
			vala_class_set_is_compact (cl, TRUE);
			_tmp61_ = vala_gidl_parser_get_attributes (self, node->name, &_tmp60_);
			_tmp62_ = _tmp61_;
			cl_attributes_length1 = _tmp60_;
			_cl_attributes_size_ = cl_attributes_length1;
			cl_attributes = _tmp62_;
			if (cl_attributes != NULL) {
				{
					gchar** attr_collection;
					int attr_collection_length1;
					int attr_it;
					attr_collection = cl_attributes;
					attr_collection_length1 = cl_attributes_length1;
					for (attr_it = 0; attr_it < cl_attributes_length1; attr_it = attr_it + 1) {
						gchar* _tmp63_;
						gchar* attr;
						_tmp63_ = g_strdup (attr_collection[attr_it]);
						attr = _tmp63_;
						{
							gchar** _tmp64_;
							gchar** _tmp65_ = NULL;
							gint nv_length1;
							gint _nv_size_;
							gchar** _tmp66_;
							gchar** nv;
							_tmp65_ = _tmp64_ = g_strsplit (attr, "=", 2);
							_tmp66_ = _tmp65_;
							nv_length1 = _vala_array_length (_tmp64_);
							_nv_size_ = nv_length1;
							nv = _tmp66_;
							if (g_strcmp0 (nv[0], "cheader_filename") == 0) {
								gchar* _tmp67_ = NULL;
								gchar* _tmp68_;
								_tmp67_ = vala_gidl_parser_eval (self, nv[1]);
								_tmp68_ = _tmp67_;
								vala_symbol_add_cheader_filename ((ValaSymbol*) cl, _tmp68_);
								_g_free0 (_tmp68_);
							} else {
								if (g_strcmp0 (nv[0], "base_class") == 0) {
									gchar* _tmp69_ = NULL;
									gchar* _tmp70_;
									_tmp69_ = vala_gidl_parser_eval (self, nv[1]);
									_tmp70_ = _tmp69_;
									_g_free0 (base_class);
									base_class = _tmp70_;
								} else {
									if (g_strcmp0 (nv[0], "hidden") == 0) {
										gchar* _tmp71_ = NULL;
										gchar* _tmp72_;
										gboolean _tmp73_;
										_tmp71_ = vala_gidl_parser_eval (self, nv[1]);
										_tmp72_ = _tmp71_;
										if ((_tmp73_ = g_strcmp0 (_tmp72_, "1") == 0, _g_free0 (_tmp72_), _tmp73_)) {
											nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
											_g_free0 (attr);
											cl_attributes = (_vala_array_free (cl_attributes, cl_attributes_length1, (GDestroyNotify) g_free), NULL);
											_g_free0 (base_class);
											_vala_code_node_unref0 (cl);
											_g_free0 (free_function);
											_g_free0 (copy_function);
											_g_free0 (unref_function);
											_g_free0 (ref_function);
											_g_free0 (name);
											return;
										}
									} else {
										if (g_strcmp0 (nv[0], "is_immutable") == 0) {
											gchar* _tmp74_ = NULL;
											gchar* _tmp75_;
											gboolean _tmp76_;
											_tmp74_ = vala_gidl_parser_eval (self, nv[1]);
											_tmp75_ = _tmp74_;
											if ((_tmp76_ = g_strcmp0 (_tmp75_, "1") == 0, _g_free0 (_tmp75_), _tmp76_)) {
												vala_class_set_is_immutable (cl, TRUE);
											}
										} else {
											if (g_strcmp0 (nv[0], "const_cname") == 0) {
												gchar* _tmp77_ = NULL;
												gchar* _tmp78_;
												_tmp77_ = vala_gidl_parser_eval (self, nv[1]);
												_tmp78_ = _tmp77_;
												vala_class_set_const_cname (cl, _tmp78_);
												_g_free0 (_tmp78_);
											} else {
												if (g_strcmp0 (nv[0], "is_fundamental") == 0) {
													gchar* _tmp79_ = NULL;
													gchar* _tmp80_;
													gboolean _tmp81_;
													_tmp79_ = vala_gidl_parser_eval (self, nv[1]);
													_tmp80_ = _tmp79_;
													if ((_tmp81_ = g_strcmp0 (_tmp80_, "1") == 0, _g_free0 (_tmp80_), _tmp81_)) {
														vala_class_set_is_compact (cl, FALSE);
													}
												} else {
													gboolean _tmp82_ = FALSE;
													if (g_strcmp0 (nv[0], "abstract") == 0) {
														_tmp82_ = base_class != NULL;
													} else {
														_tmp82_ = FALSE;
													}
													if (_tmp82_) {
														gchar* _tmp83_ = NULL;
														gchar* _tmp84_;
														gboolean _tmp85_;
														_tmp83_ = vala_gidl_parser_eval (self, nv[1]);
														_tmp84_ = _tmp83_;
														if ((_tmp85_ = g_strcmp0 (_tmp84_, "1") == 0, _g_free0 (_tmp84_), _tmp85_)) {
															vala_class_set_is_abstract (cl, TRUE);
														}
													} else {
														if (g_strcmp0 (nv[0], "free_function") == 0) {
															gchar* _tmp86_ = NULL;
															gchar* _tmp87_;
															_tmp86_ = vala_gidl_parser_eval (self, nv[1]);
															_tmp87_ = _tmp86_;
															_g_free0 (free_function);
															free_function = _tmp87_;
														} else {
															if (g_strcmp0 (nv[0], "ref_function") == 0) {
																gchar* _tmp88_ = NULL;
																gchar* _tmp89_;
																_tmp88_ = vala_gidl_parser_eval (self, nv[1]);
																_tmp89_ = _tmp88_;
																_g_free0 (ref_function);
																ref_function = _tmp89_;
															} else {
																if (g_strcmp0 (nv[0], "unref_function") == 0) {
																	gchar* _tmp90_ = NULL;
																	gchar* _tmp91_;
																	_tmp90_ = vala_gidl_parser_eval (self, nv[1]);
																	_tmp91_ = _tmp90_;
																	_g_free0 (unref_function);
																	unref_function = _tmp91_;
																} else {
																	if (g_strcmp0 (nv[0], "copy_function") == 0) {
																		gchar* _tmp92_ = NULL;
																		gchar* _tmp93_;
																		_tmp92_ = vala_gidl_parser_eval (self, nv[1]);
																		_tmp93_ = _tmp92_;
																		_g_free0 (copy_function);
																		copy_function = _tmp93_;
																	} else {
																		if (g_strcmp0 (nv[0], "ref_function_void") == 0) {
																			gchar* _tmp94_ = NULL;
																			gchar* _tmp95_;
																			gboolean _tmp96_;
																			_tmp94_ = vala_gidl_parser_eval (self, nv[1]);
																			_tmp95_ = _tmp94_;
																			if ((_tmp96_ = g_strcmp0 (_tmp95_, "1") == 0, _g_free0 (_tmp95_), _tmp96_)) {
																				ref_function_void = TRUE;
																			}
																		} else {
																			if (g_strcmp0 (nv[0], "deprecated") == 0) {
																				gchar* _tmp97_ = NULL;
																				gchar* _tmp98_;
																				gboolean _tmp99_;
																				_tmp97_ = vala_gidl_parser_eval (self, nv[1]);
																				_tmp98_ = _tmp97_;
																				if ((_tmp99_ = g_strcmp0 (_tmp98_, "1") == 0, _g_free0 (_tmp98_), _tmp99_)) {
																					vala_symbol_set_deprecated ((ValaSymbol*) cl, TRUE);
																				}
																			} else {
																				if (g_strcmp0 (nv[0], "replacement") == 0) {
																					gchar* _tmp100_ = NULL;
																					gchar* _tmp101_;
																					_tmp100_ = vala_gidl_parser_eval (self, nv[1]);
																					_tmp101_ = _tmp100_;
																					vala_symbol_set_replacement ((ValaSymbol*) cl, _tmp101_);
																					_g_free0 (_tmp101_);
																				} else {
																					if (g_strcmp0 (nv[0], "deprecated_since") == 0) {
																						gchar* _tmp102_ = NULL;
																						gchar* _tmp103_;
																						_tmp102_ = vala_gidl_parser_eval (self, nv[1]);
																						_tmp103_ = _tmp102_;
																						vala_symbol_set_deprecated_since ((ValaSymbol*) cl, _tmp103_);
																						_g_free0 (_tmp103_);
																					} else {
																						if (g_strcmp0 (nv[0], "type_parameters") == 0) {
																							gchar* _tmp104_ = NULL;
																							gchar* _tmp105_;
																							gchar** _tmp106_;
																							gchar** _tmp107_ = NULL;
																							gchar** _tmp108_;
																							_tmp104_ = vala_gidl_parser_eval (self, nv[1]);
																							_tmp105_ = _tmp104_;
																							_tmp107_ = _tmp106_ = g_strsplit (_tmp105_, ",", 0);
																							{
																								gchar** type_param_name_collection;
																								int type_param_name_collection_length1;
																								int type_param_name_it;
																								type_param_name_collection = (_tmp108_ = _tmp107_, _g_free0 (_tmp105_), _tmp108_);
																								type_param_name_collection_length1 = _vala_array_length (_tmp106_);
																								for (type_param_name_it = 0; type_param_name_it < _vala_array_length (_tmp106_); type_param_name_it = type_param_name_it + 1) {
																									gchar* _tmp109_;
																									gchar* type_param_name;
																									_tmp109_ = g_strdup (type_param_name_collection[type_param_name_it]);
																									type_param_name = _tmp109_;
																									{
																										ValaTypeParameter* _tmp110_ = NULL;
																										ValaTypeParameter* _tmp111_;
																										_tmp110_ = vala_typeparameter_new (type_param_name, self->priv->current_source_reference);
																										_tmp111_ = _tmp110_;
																										vala_object_type_symbol_add_type_parameter ((ValaObjectTypeSymbol*) cl, _tmp111_);
																										_vala_code_node_unref0 (_tmp111_);
																										_g_free0 (type_param_name);
																									}
																								}
																								type_param_name_collection = (_vala_array_free (type_param_name_collection, type_param_name_collection_length1, (GDestroyNotify) g_free), NULL);
																							}
																						}
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
						}
					}
				}
			}
			vala_gidl_parser_add_symbol_to_container (self, container, (ValaSymbol*) cl);
			vala_source_file_add_node (self->priv->current_source_file, (ValaCodeNode*) cl);
			if (base_class != NULL) {
				ValaDataType* _tmp112_ = NULL;
				ValaDataType* parent;
				_tmp112_ = vala_gidl_parser_parse_type_string (self, base_class);
				parent = _tmp112_;
				vala_class_add_base_type (cl, parent);
				_vala_code_node_unref0 (parent);
			}
			cl_attributes = (_vala_array_free (cl_attributes, cl_attributes_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (base_class);
		}
		_tmp113_ = _vala_code_node_ref0 ((ValaTypeSymbol*) cl);
		_tmp114_ = _tmp113_;
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = _tmp114_;
		{
			GList* member_collection;
			GList* member_it;
			member_collection = st_node->members;
			for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
				GIdlNode* member;
				member = (GIdlNode*) member_it->data;
				{
					if (member->type == G_IDL_NODE_FUNCTION) {
						gboolean _tmp115_ = FALSE;
						if (ref_function == NULL) {
							_tmp115_ = g_strcmp0 (member->name, "ref") == 0;
						} else {
							_tmp115_ = FALSE;
						}
						if (_tmp115_) {
							gchar* _tmp116_;
							gchar* _tmp117_;
							ValaDataType* _tmp118_ = NULL;
							ValaDataType* _tmp119_;
							_tmp116_ = g_strdup (((GIdlNodeFunction*) member)->symbol);
							_tmp117_ = _tmp116_;
							_g_free0 (ref_function);
							ref_function = _tmp117_;
							_tmp118_ = vala_gidl_parser_parse_type (self, ((GIdlNodeFunction*) member)->result->type, NULL);
							_tmp119_ = _tmp118_;
							ref_function_void = VALA_IS_VOID_TYPE (_tmp119_);
							_vala_code_node_unref0 (_tmp119_);
						} else {
							gboolean _tmp120_ = FALSE;
							if (unref_function == NULL) {
								_tmp120_ = g_strcmp0 (member->name, "unref") == 0;
							} else {
								_tmp120_ = FALSE;
							}
							if (_tmp120_) {
								gchar* _tmp121_;
								gchar* _tmp122_;
								_tmp121_ = g_strdup (((GIdlNodeFunction*) member)->symbol);
								_tmp122_ = _tmp121_;
								_g_free0 (unref_function);
								unref_function = _tmp122_;
							} else {
								gboolean _tmp123_ = FALSE;
								if (free_function == NULL) {
									gboolean _tmp124_ = FALSE;
									if (g_strcmp0 (member->name, "free") == 0) {
										_tmp124_ = TRUE;
									} else {
										_tmp124_ = g_strcmp0 (member->name, "destroy") == 0;
									}
									_tmp123_ = _tmp124_;
								} else {
									_tmp123_ = FALSE;
								}
								if (_tmp123_) {
									gchar* _tmp125_;
									gchar* _tmp126_;
									_tmp125_ = g_strdup (((GIdlNodeFunction*) member)->symbol);
									_tmp126_ = _tmp125_;
									_g_free0 (free_function);
									free_function = _tmp126_;
								} else {
									gboolean _tmp127_ = FALSE;
									ValaMethod* _tmp130_ = NULL;
									ValaMethod* m;
									if (copy_function == NULL) {
										_tmp127_ = g_strcmp0 (member->name, "copy") == 0;
									} else {
										_tmp127_ = FALSE;
									}
									if (_tmp127_) {
										gchar* _tmp128_;
										gchar* _tmp129_;
										_tmp128_ = g_strdup (((GIdlNodeFunction*) member)->symbol);
										_tmp129_ = _tmp128_;
										_g_free0 (copy_function);
										copy_function = _tmp129_;
									}
									_tmp130_ = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) member, FALSE);
									m = _tmp130_;
									if (m != NULL) {
										vala_symbol_add_method ((ValaSymbol*) cl, m);
									}
									_vala_code_node_unref0 (m);
								}
							}
						}
					} else {
						if (member->type == G_IDL_NODE_FIELD) {
							ValaField* _tmp131_ = NULL;
							ValaField* f;
							_tmp131_ = vala_gidl_parser_parse_field (self, (GIdlNodeField*) member);
							f = _tmp131_;
							if (f != NULL) {
								vala_symbol_add_field ((ValaSymbol*) cl, f);
							}
							_vala_code_node_unref0 (f);
						}
					}
				}
			}
		}
		if (ref_function != NULL) {
			vala_class_set_ref_function (cl, ref_function);
			vala_class_set_ref_function_void (cl, ref_function_void);
		}
		if (copy_function != NULL) {
			vala_class_set_dup_function (cl, copy_function);
		}
		if (unref_function != NULL) {
			vala_class_set_unref_function (cl, unref_function);
		} else {
			if (free_function != NULL) {
				vala_class_set_free_function (cl, free_function);
			}
		}
		_tmp132_ = NULL;
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = _tmp132_;
		_vala_code_node_unref0 (cl);
		_g_free0 (free_function);
		_g_free0 (copy_function);
		_g_free0 (unref_function);
		_g_free0 (ref_function);
	}
	_g_free0 (name);
}


static void vala_gidl_parser_parse_union (ValaGIdlParser* self, GIdlNodeUnion* un_node, ValaSymbol* container, GIdlModule* module) {
	GIdlNode* node;
	gchar* _tmp0_ = NULL;
	gchar* name;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (un_node != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (module != NULL);
	node = (GIdlNode*) un_node;
	if (un_node->deprecated) {
		return;
	}
	_tmp0_ = vala_gidl_parser_fix_type_name (self, node->name, container);
	name = _tmp0_;
	_tmp1_ = vala_gidl_parser_is_reference_type (self, node->name);
	if (!_tmp1_) {
		ValaScope* _tmp2_ = NULL;
		ValaSymbol* _tmp3_ = NULL;
		ValaSymbol* _tmp4_;
		ValaStruct* st;
		ValaTypeSymbol* _tmp26_;
		ValaTypeSymbol* _tmp27_;
		ValaTypeSymbol* _tmp30_;
		_tmp2_ = vala_symbol_get_scope (container);
		_tmp3_ = vala_scope_lookup (_tmp2_, name);
		st = (_tmp4_ = _tmp3_, VALA_IS_STRUCT (_tmp4_) ? ((ValaStruct*) _tmp4_) : NULL);
		if (st == NULL) {
			ValaStruct* _tmp5_ = NULL;
			ValaStruct* _tmp6_;
			gint _tmp7_;
			gchar** _tmp8_ = NULL;
			gint st_attributes_length1;
			gint _st_attributes_size_;
			gchar** _tmp9_;
			gchar** st_attributes;
			_tmp5_ = vala_struct_new (name, self->priv->current_source_reference, NULL);
			_tmp6_ = _tmp5_;
			_vala_code_node_unref0 (st);
			st = _tmp6_;
			vala_symbol_set_access ((ValaSymbol*) st, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
			_tmp8_ = vala_gidl_parser_get_attributes (self, node->name, &_tmp7_);
			_tmp9_ = _tmp8_;
			st_attributes_length1 = _tmp7_;
			_st_attributes_size_ = st_attributes_length1;
			st_attributes = _tmp9_;
			if (st_attributes != NULL) {
				{
					gchar** attr_collection;
					int attr_collection_length1;
					int attr_it;
					attr_collection = st_attributes;
					attr_collection_length1 = st_attributes_length1;
					for (attr_it = 0; attr_it < st_attributes_length1; attr_it = attr_it + 1) {
						gchar* _tmp10_;
						gchar* attr;
						_tmp10_ = g_strdup (attr_collection[attr_it]);
						attr = _tmp10_;
						{
							gchar** _tmp11_;
							gchar** _tmp12_ = NULL;
							gint nv_length1;
							gint _nv_size_;
							gchar** _tmp13_;
							gchar** nv;
							_tmp12_ = _tmp11_ = g_strsplit (attr, "=", 2);
							_tmp13_ = _tmp12_;
							nv_length1 = _vala_array_length (_tmp11_);
							_nv_size_ = nv_length1;
							nv = _tmp13_;
							if (g_strcmp0 (nv[0], "cheader_filename") == 0) {
								gchar* _tmp14_ = NULL;
								gchar* _tmp15_;
								_tmp14_ = vala_gidl_parser_eval (self, nv[1]);
								_tmp15_ = _tmp14_;
								vala_symbol_add_cheader_filename ((ValaSymbol*) st, _tmp15_);
								_g_free0 (_tmp15_);
							} else {
								if (g_strcmp0 (nv[0], "deprecated") == 0) {
									gchar* _tmp16_ = NULL;
									gchar* _tmp17_;
									gboolean _tmp18_;
									_tmp16_ = vala_gidl_parser_eval (self, nv[1]);
									_tmp17_ = _tmp16_;
									if ((_tmp18_ = g_strcmp0 (_tmp17_, "1") == 0, _g_free0 (_tmp17_), _tmp18_)) {
										vala_symbol_set_deprecated ((ValaSymbol*) st, TRUE);
									}
								} else {
									if (g_strcmp0 (nv[0], "replacement") == 0) {
										gchar* _tmp19_ = NULL;
										gchar* _tmp20_;
										_tmp19_ = vala_gidl_parser_eval (self, nv[1]);
										_tmp20_ = _tmp19_;
										vala_symbol_set_replacement ((ValaSymbol*) st, _tmp20_);
										_g_free0 (_tmp20_);
									} else {
										if (g_strcmp0 (nv[0], "deprecated_since") == 0) {
											gchar* _tmp21_ = NULL;
											gchar* _tmp22_;
											_tmp21_ = vala_gidl_parser_eval (self, nv[1]);
											_tmp22_ = _tmp21_;
											vala_symbol_set_deprecated_since ((ValaSymbol*) st, _tmp22_);
											_g_free0 (_tmp22_);
										} else {
											if (g_strcmp0 (nv[0], "hidden") == 0) {
												gchar* _tmp23_ = NULL;
												gchar* _tmp24_;
												gboolean _tmp25_;
												_tmp23_ = vala_gidl_parser_eval (self, nv[1]);
												_tmp24_ = _tmp23_;
												if ((_tmp25_ = g_strcmp0 (_tmp24_, "1") == 0, _g_free0 (_tmp24_), _tmp25_)) {
													nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
													_g_free0 (attr);
													st_attributes = (_vala_array_free (st_attributes, st_attributes_length1, (GDestroyNotify) g_free), NULL);
													_vala_code_node_unref0 (st);
													_g_free0 (name);
													return;
												}
											}
										}
									}
								}
							}
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
						}
					}
				}
			}
			vala_gidl_parser_add_symbol_to_container (self, container, (ValaSymbol*) st);
			vala_source_file_add_node (self->priv->current_source_file, (ValaCodeNode*) st);
			st_attributes = (_vala_array_free (st_attributes, st_attributes_length1, (GDestroyNotify) g_free), NULL);
		}
		_tmp26_ = _vala_code_node_ref0 ((ValaTypeSymbol*) st);
		_tmp27_ = _tmp26_;
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = _tmp27_;
		{
			GList* member_collection;
			GList* member_it;
			member_collection = un_node->members;
			for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
				GIdlNode* member;
				member = (GIdlNode*) member_it->data;
				{
					if (member->type == G_IDL_NODE_FUNCTION) {
						ValaMethod* _tmp28_ = NULL;
						ValaMethod* m;
						_tmp28_ = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) member, FALSE);
						m = _tmp28_;
						if (m != NULL) {
							vala_symbol_add_method ((ValaSymbol*) st, m);
						}
						_vala_code_node_unref0 (m);
					} else {
						if (member->type == G_IDL_NODE_FIELD) {
							ValaField* _tmp29_ = NULL;
							ValaField* f;
							_tmp29_ = vala_gidl_parser_parse_field (self, (GIdlNodeField*) member);
							f = _tmp29_;
							if (f != NULL) {
								vala_symbol_add_field ((ValaSymbol*) st, f);
							}
							_vala_code_node_unref0 (f);
						}
					}
				}
			}
		}
		_tmp30_ = NULL;
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = _tmp30_;
		_vala_code_node_unref0 (st);
	} else {
		ValaScope* _tmp31_ = NULL;
		ValaSymbol* _tmp32_ = NULL;
		ValaSymbol* _tmp33_;
		ValaClass* cl;
		ValaTypeSymbol* _tmp48_;
		ValaTypeSymbol* _tmp49_;
		gboolean ref_function_void;
		gchar* ref_function;
		gchar* unref_function;
		gchar* copy_function;
		gchar* free_function;
		ValaTypeSymbol* _tmp63_;
		_tmp31_ = vala_symbol_get_scope (container);
		_tmp32_ = vala_scope_lookup (_tmp31_, name);
		cl = (_tmp33_ = _tmp32_, VALA_IS_CLASS (_tmp33_) ? ((ValaClass*) _tmp33_) : NULL);
		if (cl == NULL) {
			ValaClass* _tmp34_ = NULL;
			ValaClass* _tmp35_;
			gint _tmp36_;
			gchar** _tmp37_ = NULL;
			gint cl_attributes_length1;
			gint _cl_attributes_size_;
			gchar** _tmp38_;
			gchar** cl_attributes;
			_tmp34_ = vala_class_new (name, self->priv->current_source_reference, NULL);
			_tmp35_ = _tmp34_;
			_vala_code_node_unref0 (cl);
			cl = _tmp35_;
			vala_symbol_set_access ((ValaSymbol*) cl, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
			vala_class_set_is_compact (cl, TRUE);
			_tmp37_ = vala_gidl_parser_get_attributes (self, node->name, &_tmp36_);
			_tmp38_ = _tmp37_;
			cl_attributes_length1 = _tmp36_;
			_cl_attributes_size_ = cl_attributes_length1;
			cl_attributes = _tmp38_;
			if (cl_attributes != NULL) {
				{
					gchar** attr_collection;
					int attr_collection_length1;
					int attr_it;
					attr_collection = cl_attributes;
					attr_collection_length1 = cl_attributes_length1;
					for (attr_it = 0; attr_it < cl_attributes_length1; attr_it = attr_it + 1) {
						gchar* _tmp39_;
						gchar* attr;
						_tmp39_ = g_strdup (attr_collection[attr_it]);
						attr = _tmp39_;
						{
							gchar** _tmp40_;
							gchar** _tmp41_ = NULL;
							gint nv_length1;
							gint _nv_size_;
							gchar** _tmp42_;
							gchar** nv;
							_tmp41_ = _tmp40_ = g_strsplit (attr, "=", 2);
							_tmp42_ = _tmp41_;
							nv_length1 = _vala_array_length (_tmp40_);
							_nv_size_ = nv_length1;
							nv = _tmp42_;
							if (g_strcmp0 (nv[0], "cheader_filename") == 0) {
								gchar* _tmp43_ = NULL;
								gchar* _tmp44_;
								_tmp43_ = vala_gidl_parser_eval (self, nv[1]);
								_tmp44_ = _tmp43_;
								vala_symbol_add_cheader_filename ((ValaSymbol*) cl, _tmp44_);
								_g_free0 (_tmp44_);
							} else {
								if (g_strcmp0 (nv[0], "hidden") == 0) {
									gchar* _tmp45_ = NULL;
									gchar* _tmp46_;
									gboolean _tmp47_;
									_tmp45_ = vala_gidl_parser_eval (self, nv[1]);
									_tmp46_ = _tmp45_;
									if ((_tmp47_ = g_strcmp0 (_tmp46_, "1") == 0, _g_free0 (_tmp46_), _tmp47_)) {
										nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
										_g_free0 (attr);
										cl_attributes = (_vala_array_free (cl_attributes, cl_attributes_length1, (GDestroyNotify) g_free), NULL);
										_vala_code_node_unref0 (cl);
										_g_free0 (name);
										return;
									}
								}
							}
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
						}
					}
				}
			}
			vala_gidl_parser_add_symbol_to_container (self, container, (ValaSymbol*) cl);
			vala_source_file_add_node (self->priv->current_source_file, (ValaCodeNode*) cl);
			cl_attributes = (_vala_array_free (cl_attributes, cl_attributes_length1, (GDestroyNotify) g_free), NULL);
		}
		_tmp48_ = _vala_code_node_ref0 ((ValaTypeSymbol*) cl);
		_tmp49_ = _tmp48_;
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = _tmp49_;
		ref_function_void = FALSE;
		ref_function = NULL;
		unref_function = NULL;
		copy_function = NULL;
		free_function = NULL;
		{
			GList* member_collection;
			GList* member_it;
			member_collection = un_node->members;
			for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
				GIdlNode* member;
				member = (GIdlNode*) member_it->data;
				{
					if (member->type == G_IDL_NODE_FUNCTION) {
						if (g_strcmp0 (member->name, "ref") == 0) {
							gchar* _tmp50_;
							gchar* _tmp51_;
							ValaDataType* _tmp52_ = NULL;
							ValaDataType* _tmp53_;
							_tmp50_ = g_strdup (((GIdlNodeFunction*) member)->symbol);
							_tmp51_ = _tmp50_;
							_g_free0 (ref_function);
							ref_function = _tmp51_;
							_tmp52_ = vala_gidl_parser_parse_type (self, ((GIdlNodeFunction*) member)->result->type, NULL);
							_tmp53_ = _tmp52_;
							ref_function_void = VALA_IS_VOID_TYPE (_tmp53_);
							_vala_code_node_unref0 (_tmp53_);
						} else {
							if (g_strcmp0 (member->name, "unref") == 0) {
								gchar* _tmp54_;
								gchar* _tmp55_;
								_tmp54_ = g_strdup (((GIdlNodeFunction*) member)->symbol);
								_tmp55_ = _tmp54_;
								_g_free0 (unref_function);
								unref_function = _tmp55_;
							} else {
								gboolean _tmp56_ = FALSE;
								if (g_strcmp0 (member->name, "free") == 0) {
									_tmp56_ = TRUE;
								} else {
									_tmp56_ = g_strcmp0 (member->name, "destroy") == 0;
								}
								if (_tmp56_) {
									gchar* _tmp57_;
									gchar* _tmp58_;
									_tmp57_ = g_strdup (((GIdlNodeFunction*) member)->symbol);
									_tmp58_ = _tmp57_;
									_g_free0 (free_function);
									free_function = _tmp58_;
								} else {
									ValaMethod* _tmp61_ = NULL;
									ValaMethod* m;
									if (g_strcmp0 (member->name, "copy") == 0) {
										gchar* _tmp59_;
										gchar* _tmp60_;
										_tmp59_ = g_strdup (((GIdlNodeFunction*) member)->symbol);
										_tmp60_ = _tmp59_;
										_g_free0 (copy_function);
										copy_function = _tmp60_;
									}
									_tmp61_ = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) member, FALSE);
									m = _tmp61_;
									if (m != NULL) {
										vala_symbol_add_method ((ValaSymbol*) cl, m);
									}
									_vala_code_node_unref0 (m);
								}
							}
						}
					} else {
						if (member->type == G_IDL_NODE_FIELD) {
							ValaField* _tmp62_ = NULL;
							ValaField* f;
							_tmp62_ = vala_gidl_parser_parse_field (self, (GIdlNodeField*) member);
							f = _tmp62_;
							if (f != NULL) {
								vala_symbol_add_field ((ValaSymbol*) cl, f);
							}
							_vala_code_node_unref0 (f);
						}
					}
				}
			}
		}
		if (ref_function != NULL) {
			vala_class_set_ref_function (cl, ref_function);
			vala_class_set_ref_function_void (cl, ref_function_void);
		}
		if (copy_function != NULL) {
			vala_class_set_dup_function (cl, copy_function);
		}
		if (unref_function != NULL) {
			vala_class_set_unref_function (cl, unref_function);
		} else {
			if (free_function != NULL) {
				vala_class_set_free_function (cl, free_function);
			}
		}
		_tmp63_ = NULL;
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = _tmp63_;
		_g_free0 (free_function);
		_g_free0 (copy_function);
		_g_free0 (unref_function);
		_g_free0 (ref_function);
		_vala_code_node_unref0 (cl);
	}
	_g_free0 (name);
}


static void vala_gidl_parser_parse_boxed (ValaGIdlParser* self, GIdlNodeBoxed* boxed_node, ValaSymbol* container, GIdlModule* module) {
	GIdlNode* node;
	gchar* _tmp0_ = NULL;
	gchar* name;
	gint _tmp1_;
	gchar** _tmp2_ = NULL;
	gint node_attributes_length1;
	gint _node_attributes_size_;
	gchar** _tmp3_;
	gchar** node_attributes;
	gboolean _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (boxed_node != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (module != NULL);
	node = (GIdlNode*) boxed_node;
	_tmp0_ = vala_gidl_parser_fix_type_name (self, node->name, container);
	name = _tmp0_;
	_tmp2_ = vala_gidl_parser_get_attributes (self, node->name, &_tmp1_);
	_tmp3_ = _tmp2_;
	node_attributes_length1 = _tmp1_;
	_node_attributes_size_ = node_attributes_length1;
	node_attributes = _tmp3_;
	if (node_attributes != NULL) {
		{
			gchar** attr_collection;
			int attr_collection_length1;
			int attr_it;
			attr_collection = node_attributes;
			attr_collection_length1 = node_attributes_length1;
			for (attr_it = 0; attr_it < node_attributes_length1; attr_it = attr_it + 1) {
				gchar* _tmp4_;
				gchar* attr;
				_tmp4_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp4_;
				{
					gchar** _tmp5_;
					gchar** _tmp6_ = NULL;
					gint nv_length1;
					gint _nv_size_;
					gchar** _tmp7_;
					gchar** nv;
					_tmp6_ = _tmp5_ = g_strsplit (attr, "=", 2);
					_tmp7_ = _tmp6_;
					nv_length1 = _vala_array_length (_tmp5_);
					_nv_size_ = nv_length1;
					nv = _tmp7_;
					if (g_strcmp0 (nv[0], "hidden") == 0) {
						nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (attr);
						node_attributes = (_vala_array_free (node_attributes, node_attributes_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (name);
						return;
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	_tmp8_ = vala_gidl_parser_is_reference_type (self, node->name);
	if (!_tmp8_) {
		ValaScope* _tmp9_ = NULL;
		ValaSymbol* _tmp10_ = NULL;
		ValaSymbol* _tmp11_;
		ValaStruct* st;
		ValaTypeSymbol* _tmp41_;
		ValaTypeSymbol* _tmp42_;
		ValaTypeSymbol* _tmp45_;
		_tmp9_ = vala_symbol_get_scope (container);
		_tmp10_ = vala_scope_lookup (_tmp9_, name);
		st = (_tmp11_ = _tmp10_, VALA_IS_STRUCT (_tmp11_) ? ((ValaStruct*) _tmp11_) : NULL);
		if (st == NULL) {
			ValaStruct* _tmp12_ = NULL;
			ValaStruct* _tmp13_;
			gint _tmp14_;
			gchar** _tmp15_ = NULL;
			gint st_attributes_length1;
			gint _st_attributes_size_;
			gchar** _tmp16_;
			gchar** st_attributes;
			gchar* _tmp39_ = NULL;
			gchar* _tmp40_;
			_tmp12_ = vala_struct_new (name, self->priv->current_source_reference, NULL);
			_tmp13_ = _tmp12_;
			_vala_code_node_unref0 (st);
			st = _tmp13_;
			vala_symbol_set_access ((ValaSymbol*) st, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
			_tmp15_ = vala_gidl_parser_get_attributes (self, node->name, &_tmp14_);
			_tmp16_ = _tmp15_;
			st_attributes_length1 = _tmp14_;
			_st_attributes_size_ = st_attributes_length1;
			st_attributes = _tmp16_;
			if (st_attributes != NULL) {
				{
					gchar** attr_collection;
					int attr_collection_length1;
					int attr_it;
					attr_collection = st_attributes;
					attr_collection_length1 = st_attributes_length1;
					for (attr_it = 0; attr_it < st_attributes_length1; attr_it = attr_it + 1) {
						gchar* _tmp17_;
						gchar* attr;
						_tmp17_ = g_strdup (attr_collection[attr_it]);
						attr = _tmp17_;
						{
							gchar** _tmp18_;
							gchar** _tmp19_ = NULL;
							gint nv_length1;
							gint _nv_size_;
							gchar** _tmp20_;
							gchar** nv;
							_tmp19_ = _tmp18_ = g_strsplit (attr, "=", 2);
							_tmp20_ = _tmp19_;
							nv_length1 = _vala_array_length (_tmp18_);
							_nv_size_ = nv_length1;
							nv = _tmp20_;
							if (g_strcmp0 (nv[0], "cheader_filename") == 0) {
								gchar* _tmp21_ = NULL;
								gchar* _tmp22_;
								_tmp21_ = vala_gidl_parser_eval (self, nv[1]);
								_tmp22_ = _tmp21_;
								vala_symbol_add_cheader_filename ((ValaSymbol*) st, _tmp22_);
								_g_free0 (_tmp22_);
							} else {
								if (g_strcmp0 (nv[0], "deprecated") == 0) {
									gchar* _tmp23_ = NULL;
									gchar* _tmp24_;
									gboolean _tmp25_;
									_tmp23_ = vala_gidl_parser_eval (self, nv[1]);
									_tmp24_ = _tmp23_;
									if ((_tmp25_ = g_strcmp0 (_tmp24_, "1") == 0, _g_free0 (_tmp24_), _tmp25_)) {
										vala_symbol_set_deprecated ((ValaSymbol*) st, TRUE);
									}
								} else {
									if (g_strcmp0 (nv[0], "replacement") == 0) {
										gchar* _tmp26_ = NULL;
										gchar* _tmp27_;
										_tmp26_ = vala_gidl_parser_eval (self, nv[1]);
										_tmp27_ = _tmp26_;
										vala_symbol_set_replacement ((ValaSymbol*) st, _tmp27_);
										_g_free0 (_tmp27_);
									} else {
										if (g_strcmp0 (nv[0], "deprecated_since") == 0) {
											gchar* _tmp28_ = NULL;
											gchar* _tmp29_;
											_tmp28_ = vala_gidl_parser_eval (self, nv[1]);
											_tmp29_ = _tmp28_;
											vala_symbol_set_deprecated_since ((ValaSymbol*) st, _tmp29_);
											_g_free0 (_tmp29_);
										} else {
											if (g_strcmp0 (nv[0], "immutable") == 0) {
												gchar* _tmp30_ = NULL;
												gchar* _tmp31_;
												gboolean _tmp32_;
												_tmp30_ = vala_gidl_parser_eval (self, nv[1]);
												_tmp31_ = _tmp30_;
												if ((_tmp32_ = g_strcmp0 (_tmp31_, "1") == 0, _g_free0 (_tmp31_), _tmp32_)) {
													vala_struct_set_is_immutable (st, TRUE);
												}
											} else {
												if (g_strcmp0 (nv[0], "has_copy_function") == 0) {
													gchar* _tmp33_ = NULL;
													gchar* _tmp34_;
													gboolean _tmp35_;
													_tmp33_ = vala_gidl_parser_eval (self, nv[1]);
													_tmp34_ = _tmp33_;
													if ((_tmp35_ = g_strcmp0 (_tmp34_, "0") == 0, _g_free0 (_tmp34_), _tmp35_)) {
														vala_struct_set_has_copy_function (st, FALSE);
													}
												} else {
													if (g_strcmp0 (nv[0], "has_destroy_function") == 0) {
														gchar* _tmp36_ = NULL;
														gchar* _tmp37_;
														gboolean _tmp38_;
														_tmp36_ = vala_gidl_parser_eval (self, nv[1]);
														_tmp37_ = _tmp36_;
														if ((_tmp38_ = g_strcmp0 (_tmp37_, "0") == 0, _g_free0 (_tmp37_), _tmp38_)) {
															vala_struct_set_has_destroy_function (st, FALSE);
														}
													}
												}
											}
										}
									}
								}
							}
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
						}
					}
				}
			}
			vala_gidl_parser_add_symbol_to_container (self, container, (ValaSymbol*) st);
			_tmp39_ = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) st, "TYPE_");
			_tmp40_ = _tmp39_;
			vala_struct_set_type_id (st, _tmp40_);
			_g_free0 (_tmp40_);
			vala_source_file_add_node (self->priv->current_source_file, (ValaCodeNode*) st);
			st_attributes = (_vala_array_free (st_attributes, st_attributes_length1, (GDestroyNotify) g_free), NULL);
		}
		_tmp41_ = _vala_code_node_ref0 ((ValaTypeSymbol*) st);
		_tmp42_ = _tmp41_;
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = _tmp42_;
		{
			GList* member_collection;
			GList* member_it;
			member_collection = boxed_node->members;
			for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
				GIdlNode* member;
				member = (GIdlNode*) member_it->data;
				{
					if (member->type == G_IDL_NODE_FUNCTION) {
						ValaMethod* _tmp43_ = NULL;
						ValaMethod* m;
						_tmp43_ = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) member, FALSE);
						m = _tmp43_;
						if (m != NULL) {
							vala_symbol_add_method ((ValaSymbol*) st, m);
						}
						_vala_code_node_unref0 (m);
					} else {
						if (member->type == G_IDL_NODE_FIELD) {
							ValaField* _tmp44_ = NULL;
							ValaField* f;
							_tmp44_ = vala_gidl_parser_parse_field (self, (GIdlNodeField*) member);
							f = _tmp44_;
							if (f != NULL) {
								vala_symbol_add_field ((ValaSymbol*) st, f);
							}
							_vala_code_node_unref0 (f);
						}
					}
				}
			}
		}
		_tmp45_ = NULL;
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = _tmp45_;
		_vala_code_node_unref0 (st);
	} else {
		gboolean ref_function_void;
		gchar* ref_function;
		gchar* unref_function;
		gchar* copy_function;
		gchar* free_function;
		ValaScope* _tmp46_ = NULL;
		ValaSymbol* _tmp47_ = NULL;
		ValaSymbol* _tmp48_;
		ValaClass* cl;
		ValaTypeSymbol* _tmp88_;
		ValaTypeSymbol* _tmp89_;
		ValaTypeSymbol* _tmp103_;
		ref_function_void = FALSE;
		ref_function = NULL;
		unref_function = NULL;
		copy_function = NULL;
		free_function = NULL;
		_tmp46_ = vala_symbol_get_scope (container);
		_tmp47_ = vala_scope_lookup (_tmp46_, name);
		cl = (_tmp48_ = _tmp47_, VALA_IS_CLASS (_tmp48_) ? ((ValaClass*) _tmp48_) : NULL);
		if (cl == NULL) {
			gchar* base_class;
			ValaClass* _tmp49_ = NULL;
			ValaClass* _tmp50_;
			gint _tmp51_;
			gchar** _tmp52_ = NULL;
			gint cl_attributes_length1;
			gint _cl_attributes_size_;
			gchar** _tmp53_;
			gchar** cl_attributes;
			gchar* _tmp85_ = NULL;
			gchar* _tmp86_;
			base_class = NULL;
			_tmp49_ = vala_class_new (name, self->priv->current_source_reference, NULL);
			_tmp50_ = _tmp49_;
			_vala_code_node_unref0 (cl);
			cl = _tmp50_;
			vala_symbol_set_access ((ValaSymbol*) cl, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
			vala_class_set_is_compact (cl, TRUE);
			_tmp52_ = vala_gidl_parser_get_attributes (self, node->name, &_tmp51_);
			_tmp53_ = _tmp52_;
			cl_attributes_length1 = _tmp51_;
			_cl_attributes_size_ = cl_attributes_length1;
			cl_attributes = _tmp53_;
			if (cl_attributes != NULL) {
				{
					gchar** attr_collection;
					int attr_collection_length1;
					int attr_it;
					attr_collection = cl_attributes;
					attr_collection_length1 = cl_attributes_length1;
					for (attr_it = 0; attr_it < cl_attributes_length1; attr_it = attr_it + 1) {
						gchar* _tmp54_;
						gchar* attr;
						_tmp54_ = g_strdup (attr_collection[attr_it]);
						attr = _tmp54_;
						{
							gchar** _tmp55_;
							gchar** _tmp56_ = NULL;
							gint nv_length1;
							gint _nv_size_;
							gchar** _tmp57_;
							gchar** nv;
							_tmp56_ = _tmp55_ = g_strsplit (attr, "=", 2);
							_tmp57_ = _tmp56_;
							nv_length1 = _vala_array_length (_tmp55_);
							_nv_size_ = nv_length1;
							nv = _tmp57_;
							if (g_strcmp0 (nv[0], "cheader_filename") == 0) {
								gchar* _tmp58_ = NULL;
								gchar* _tmp59_;
								_tmp58_ = vala_gidl_parser_eval (self, nv[1]);
								_tmp59_ = _tmp58_;
								vala_symbol_add_cheader_filename ((ValaSymbol*) cl, _tmp59_);
								_g_free0 (_tmp59_);
							} else {
								if (g_strcmp0 (nv[0], "base_class") == 0) {
									gchar* _tmp60_ = NULL;
									gchar* _tmp61_;
									_tmp60_ = vala_gidl_parser_eval (self, nv[1]);
									_tmp61_ = _tmp60_;
									_g_free0 (base_class);
									base_class = _tmp61_;
								} else {
									if (g_strcmp0 (nv[0], "is_immutable") == 0) {
										gchar* _tmp62_ = NULL;
										gchar* _tmp63_;
										gboolean _tmp64_;
										_tmp62_ = vala_gidl_parser_eval (self, nv[1]);
										_tmp63_ = _tmp62_;
										if ((_tmp64_ = g_strcmp0 (_tmp63_, "1") == 0, _g_free0 (_tmp63_), _tmp64_)) {
											vala_class_set_is_immutable (cl, TRUE);
										}
									} else {
										if (g_strcmp0 (nv[0], "deprecated") == 0) {
											gchar* _tmp65_ = NULL;
											gchar* _tmp66_;
											gboolean _tmp67_;
											_tmp65_ = vala_gidl_parser_eval (self, nv[1]);
											_tmp66_ = _tmp65_;
											if ((_tmp67_ = g_strcmp0 (_tmp66_, "1") == 0, _g_free0 (_tmp66_), _tmp67_)) {
												vala_symbol_set_deprecated ((ValaSymbol*) cl, TRUE);
											}
										} else {
											if (g_strcmp0 (nv[0], "replacement") == 0) {
												gchar* _tmp68_ = NULL;
												gchar* _tmp69_;
												_tmp68_ = vala_gidl_parser_eval (self, nv[1]);
												_tmp69_ = _tmp68_;
												vala_symbol_set_replacement ((ValaSymbol*) cl, _tmp69_);
												_g_free0 (_tmp69_);
											} else {
												if (g_strcmp0 (nv[0], "deprecated_since") == 0) {
													gchar* _tmp70_ = NULL;
													gchar* _tmp71_;
													_tmp70_ = vala_gidl_parser_eval (self, nv[1]);
													_tmp71_ = _tmp70_;
													vala_symbol_set_deprecated_since ((ValaSymbol*) cl, _tmp71_);
													_g_free0 (_tmp71_);
												} else {
													if (g_strcmp0 (nv[0], "const_cname") == 0) {
														gchar* _tmp72_ = NULL;
														gchar* _tmp73_;
														_tmp72_ = vala_gidl_parser_eval (self, nv[1]);
														_tmp73_ = _tmp72_;
														vala_class_set_const_cname (cl, _tmp73_);
														_g_free0 (_tmp73_);
													} else {
														if (g_strcmp0 (nv[0], "free_function") == 0) {
															gchar* _tmp74_ = NULL;
															gchar* _tmp75_;
															_tmp74_ = vala_gidl_parser_eval (self, nv[1]);
															_tmp75_ = _tmp74_;
															_g_free0 (free_function);
															free_function = _tmp75_;
														} else {
															if (g_strcmp0 (nv[0], "ref_function") == 0) {
																gchar* _tmp76_ = NULL;
																gchar* _tmp77_;
																_tmp76_ = vala_gidl_parser_eval (self, nv[1]);
																_tmp77_ = _tmp76_;
																_g_free0 (ref_function);
																ref_function = _tmp77_;
															} else {
																if (g_strcmp0 (nv[0], "unref_function") == 0) {
																	gchar* _tmp78_ = NULL;
																	gchar* _tmp79_;
																	_tmp78_ = vala_gidl_parser_eval (self, nv[1]);
																	_tmp79_ = _tmp78_;
																	_g_free0 (unref_function);
																	unref_function = _tmp79_;
																} else {
																	if (g_strcmp0 (nv[0], "copy_function") == 0) {
																		gchar* _tmp80_ = NULL;
																		gchar* _tmp81_;
																		_tmp80_ = vala_gidl_parser_eval (self, nv[1]);
																		_tmp81_ = _tmp80_;
																		_g_free0 (copy_function);
																		copy_function = _tmp81_;
																	} else {
																		if (g_strcmp0 (nv[0], "ref_function_void") == 0) {
																			gchar* _tmp82_ = NULL;
																			gchar* _tmp83_;
																			gboolean _tmp84_;
																			_tmp82_ = vala_gidl_parser_eval (self, nv[1]);
																			_tmp83_ = _tmp82_;
																			if ((_tmp84_ = g_strcmp0 (_tmp83_, "1") == 0, _g_free0 (_tmp83_), _tmp84_)) {
																				ref_function_void = TRUE;
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
						}
					}
				}
			}
			vala_gidl_parser_add_symbol_to_container (self, container, (ValaSymbol*) cl);
			_tmp85_ = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) cl, "TYPE_");
			_tmp86_ = _tmp85_;
			vala_class_set_type_id (cl, _tmp86_);
			_g_free0 (_tmp86_);
			vala_source_file_add_node (self->priv->current_source_file, (ValaCodeNode*) cl);
			if (base_class != NULL) {
				ValaDataType* _tmp87_ = NULL;
				ValaDataType* parent;
				_tmp87_ = vala_gidl_parser_parse_type_string (self, base_class);
				parent = _tmp87_;
				vala_class_add_base_type (cl, parent);
				_vala_code_node_unref0 (parent);
			}
			cl_attributes = (_vala_array_free (cl_attributes, cl_attributes_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (base_class);
		}
		_tmp88_ = _vala_code_node_ref0 ((ValaTypeSymbol*) cl);
		_tmp89_ = _tmp88_;
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = _tmp89_;
		{
			GList* member_collection;
			GList* member_it;
			member_collection = boxed_node->members;
			for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
				GIdlNode* member;
				member = (GIdlNode*) member_it->data;
				{
					if (member->type == G_IDL_NODE_FUNCTION) {
						if (g_strcmp0 (member->name, "ref") == 0) {
							gchar* _tmp90_;
							gchar* _tmp91_;
							ValaDataType* _tmp92_ = NULL;
							ValaDataType* _tmp93_;
							_tmp90_ = g_strdup (((GIdlNodeFunction*) member)->symbol);
							_tmp91_ = _tmp90_;
							_g_free0 (ref_function);
							ref_function = _tmp91_;
							_tmp92_ = vala_gidl_parser_parse_type (self, ((GIdlNodeFunction*) member)->result->type, NULL);
							_tmp93_ = _tmp92_;
							ref_function_void = VALA_IS_VOID_TYPE (_tmp93_);
							_vala_code_node_unref0 (_tmp93_);
						} else {
							if (g_strcmp0 (member->name, "unref") == 0) {
								gchar* _tmp94_;
								gchar* _tmp95_;
								_tmp94_ = g_strdup (((GIdlNodeFunction*) member)->symbol);
								_tmp95_ = _tmp94_;
								_g_free0 (unref_function);
								unref_function = _tmp95_;
							} else {
								gboolean _tmp96_ = FALSE;
								if (g_strcmp0 (member->name, "free") == 0) {
									_tmp96_ = TRUE;
								} else {
									_tmp96_ = g_strcmp0 (member->name, "destroy") == 0;
								}
								if (_tmp96_) {
									gchar* _tmp97_;
									gchar* _tmp98_;
									_tmp97_ = g_strdup (((GIdlNodeFunction*) member)->symbol);
									_tmp98_ = _tmp97_;
									_g_free0 (free_function);
									free_function = _tmp98_;
								} else {
									ValaMethod* _tmp101_ = NULL;
									ValaMethod* m;
									if (g_strcmp0 (member->name, "copy") == 0) {
										gchar* _tmp99_;
										gchar* _tmp100_;
										_tmp99_ = g_strdup (((GIdlNodeFunction*) member)->symbol);
										_tmp100_ = _tmp99_;
										_g_free0 (copy_function);
										copy_function = _tmp100_;
									}
									_tmp101_ = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) member, FALSE);
									m = _tmp101_;
									if (m != NULL) {
										vala_symbol_add_method ((ValaSymbol*) cl, m);
									}
									_vala_code_node_unref0 (m);
								}
							}
						}
					} else {
						if (member->type == G_IDL_NODE_FIELD) {
							ValaField* _tmp102_ = NULL;
							ValaField* f;
							_tmp102_ = vala_gidl_parser_parse_field (self, (GIdlNodeField*) member);
							f = _tmp102_;
							if (f != NULL) {
								vala_symbol_add_field ((ValaSymbol*) cl, f);
							}
							_vala_code_node_unref0 (f);
						}
					}
				}
			}
		}
		if (ref_function != NULL) {
			vala_class_set_ref_function (cl, ref_function);
			vala_class_set_ref_function_void (cl, ref_function_void);
		}
		if (copy_function != NULL) {
			vala_class_set_dup_function (cl, copy_function);
		}
		if (unref_function != NULL) {
			vala_class_set_unref_function (cl, unref_function);
		} else {
			if (free_function != NULL) {
				vala_class_set_free_function (cl, free_function);
			}
		}
		_tmp103_ = NULL;
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = _tmp103_;
		_vala_code_node_unref0 (cl);
		_g_free0 (free_function);
		_g_free0 (copy_function);
		_g_free0 (unref_function);
		_g_free0 (ref_function);
	}
	node_attributes = (_vala_array_free (node_attributes, node_attributes_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (name);
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	gunichar _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = g_utf8_get_char (((gchar*) self) + index);
	result = _tmp0_;
	return result;
}


static void vala_gidl_parser_parse_enum (ValaGIdlParser* self, GIdlNodeEnum* en_node, ValaSymbol* container, GIdlModule* module, gboolean is_flags) {
	GIdlNode* node;
	gchar* _tmp0_ = NULL;
	gchar* name;
	gboolean existing;
	ValaScope* _tmp1_ = NULL;
	ValaSymbol* _tmp2_ = NULL;
	ValaSymbol* _tmp3_;
	ValaEnum* en;
	gboolean _tmp11_ = FALSE;
	gchar* common_prefix;
	gboolean is_errordomain;
	ValaArrayList* _tmp47_ = NULL;
	ValaArrayList* cheader_filenames;
	gint _tmp48_;
	gchar** _tmp49_ = NULL;
	gint en_attributes_length1;
	gint _en_attributes_size_;
	gchar** _tmp50_;
	gchar** en_attributes;
	g_return_if_fail (self != NULL);
	g_return_if_fail (en_node != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (module != NULL);
	node = (GIdlNode*) en_node;
	_tmp0_ = vala_gidl_parser_fix_type_name (self, node->name, container);
	name = _tmp0_;
	existing = TRUE;
	_tmp1_ = vala_symbol_get_scope (container);
	_tmp2_ = vala_scope_lookup (_tmp1_, name);
	en = (_tmp3_ = _tmp2_, VALA_IS_ENUM (_tmp3_) ? ((ValaEnum*) _tmp3_) : NULL);
	if (en == NULL) {
		ValaEnum* _tmp4_ = NULL;
		ValaEnum* _tmp5_;
		_tmp4_ = vala_enum_new (name, self->priv->current_source_reference, NULL);
		_tmp5_ = _tmp4_;
		_vala_code_node_unref0 (en);
		en = _tmp5_;
		vala_symbol_set_access ((ValaSymbol*) en, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		existing = FALSE;
	} else {
		ValaScope* _tmp6_ = NULL;
		ValaSymbol* _tmp7_ = NULL;
		ValaEnumValue* dummy;
		_tmp6_ = vala_symbol_get_scope ((ValaSymbol*) en);
		_tmp7_ = vala_scope_lookup (_tmp6_, "__DUMMY__");
		dummy = VALA_ENUM_VALUE (_tmp7_);
		if (dummy != NULL) {
			ValaList* _tmp8_ = NULL;
			ValaList* _tmp9_;
			ValaScope* _tmp10_ = NULL;
			_tmp8_ = vala_enum_get_values (en);
			_tmp9_ = _tmp8_;
			vala_collection_remove ((ValaCollection*) _tmp9_, dummy);
			_vala_iterable_unref0 (_tmp9_);
			_tmp10_ = vala_symbol_get_scope ((ValaSymbol*) en);
			vala_scope_remove (_tmp10_, "__DUMMY__");
		}
		_vala_code_node_unref0 (dummy);
	}
	if (en_node->gtype_name != NULL) {
		_tmp11_ = g_strcmp0 (en_node->gtype_name, "") != 0;
	} else {
		_tmp11_ = FALSE;
	}
	vala_enum_set_has_type_id (en, _tmp11_);
	common_prefix = NULL;
	{
		GList* value_collection;
		GList* value_it;
		value_collection = en_node->values;
		for (value_it = value_collection; value_it != NULL; value_it = value_it->next) {
			GIdlNode* value;
			value = (GIdlNode*) value_it->data;
			{
				gint _tmp12_;
				gchar** _tmp13_ = NULL;
				gint val_attributes_length1;
				gint _val_attributes_size_;
				gchar** _tmp14_;
				gchar** val_attributes;
				gboolean is_hidden;
				_tmp13_ = vala_gidl_parser_get_attributes (self, value->name, &_tmp12_);
				_tmp14_ = _tmp13_;
				val_attributes_length1 = _tmp12_;
				_val_attributes_size_ = val_attributes_length1;
				val_attributes = _tmp14_;
				is_hidden = FALSE;
				if (val_attributes != NULL) {
					{
						gchar** attr_collection;
						int attr_collection_length1;
						int attr_it;
						attr_collection = val_attributes;
						attr_collection_length1 = val_attributes_length1;
						for (attr_it = 0; attr_it < val_attributes_length1; attr_it = attr_it + 1) {
							gchar* _tmp15_;
							gchar* attr;
							_tmp15_ = g_strdup (attr_collection[attr_it]);
							attr = _tmp15_;
							{
								gchar** _tmp16_;
								gchar** _tmp17_ = NULL;
								gint nv_length1;
								gint _nv_size_;
								gchar** _tmp18_;
								gchar** nv;
								gboolean _tmp19_ = FALSE;
								_tmp17_ = _tmp16_ = g_strsplit (attr, "=", 2);
								_tmp18_ = _tmp17_;
								nv_length1 = _vala_array_length (_tmp16_);
								_nv_size_ = nv_length1;
								nv = _tmp18_;
								if (g_strcmp0 (nv[0], "hidden") == 0) {
									gchar* _tmp20_ = NULL;
									gchar* _tmp21_;
									_tmp20_ = vala_gidl_parser_eval (self, nv[1]);
									_tmp21_ = _tmp20_;
									_tmp19_ = g_strcmp0 (_tmp21_, "1") == 0;
									_g_free0 (_tmp21_);
								} else {
									_tmp19_ = FALSE;
								}
								if (_tmp19_) {
									is_hidden = TRUE;
								}
								nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (attr);
							}
						}
					}
				}
				if (is_hidden) {
					val_attributes = (_vala_array_free (val_attributes, val_attributes_length1, (GDestroyNotify) g_free), NULL);
					continue;
				}
				if (common_prefix == NULL) {
					gchar* _tmp22_;
					gchar* _tmp23_;
					_tmp22_ = g_strdup (value->name);
					_tmp23_ = _tmp22_;
					_g_free0 (common_prefix);
					common_prefix = _tmp23_;
					while (TRUE) {
						gboolean _tmp24_ = FALSE;
						gint _tmp25_;
						gint _tmp27_;
						gchar* _tmp28_ = NULL;
						gchar* _tmp29_;
						_tmp25_ = strlen (common_prefix);
						if (_tmp25_ > 0) {
							gboolean _tmp26_;
							_tmp26_ = g_str_has_suffix (common_prefix, "_");
							_tmp24_ = !_tmp26_;
						} else {
							_tmp24_ = FALSE;
						}
						if (!_tmp24_) {
							break;
						}
						_tmp27_ = strlen (common_prefix);
						_tmp28_ = string_substring (common_prefix, (glong) 0, (glong) (_tmp27_ - 1));
						_tmp29_ = _tmp28_;
						_g_free0 (common_prefix);
						common_prefix = _tmp29_;
					}
				} else {
					while (TRUE) {
						gboolean _tmp30_;
						gint _tmp31_;
						gchar* _tmp32_ = NULL;
						gchar* _tmp33_;
						_tmp30_ = g_str_has_prefix (value->name, common_prefix);
						if (!(!_tmp30_)) {
							break;
						}
						_tmp31_ = strlen (common_prefix);
						_tmp32_ = string_substring (common_prefix, (glong) 0, (glong) (_tmp31_ - 1));
						_tmp33_ = _tmp32_;
						_g_free0 (common_prefix);
						common_prefix = _tmp33_;
					}
				}
				while (TRUE) {
					gboolean _tmp34_ = FALSE;
					gint _tmp35_;
					gint _tmp44_;
					gchar* _tmp45_ = NULL;
					gchar* _tmp46_;
					_tmp35_ = strlen (common_prefix);
					if (_tmp35_ > 0) {
						gboolean _tmp36_ = FALSE;
						gboolean _tmp37_;
						_tmp37_ = g_str_has_suffix (common_prefix, "_");
						if (!_tmp37_) {
							_tmp36_ = TRUE;
						} else {
							gboolean _tmp38_ = FALSE;
							gint _tmp39_;
							gunichar _tmp40_;
							gboolean _tmp41_;
							_tmp39_ = strlen (common_prefix);
							_tmp40_ = string_get_char (value->name, (glong) _tmp39_);
							_tmp41_ = g_unichar_isdigit (_tmp40_);
							if (_tmp41_) {
								gint _tmp42_;
								gint _tmp43_;
								_tmp42_ = strlen (value->name);
								_tmp43_ = strlen (common_prefix);
								_tmp38_ = (_tmp42_ - _tmp43_) <= 1;
							} else {
								_tmp38_ = FALSE;
							}
							_tmp36_ = _tmp38_;
						}
						_tmp34_ = _tmp36_;
					} else {
						_tmp34_ = FALSE;
					}
					if (!_tmp34_) {
						break;
					}
					_tmp44_ = strlen (common_prefix);
					_tmp45_ = string_substring (common_prefix, (glong) 0, (glong) (_tmp44_ - 1));
					_tmp46_ = _tmp45_;
					_g_free0 (common_prefix);
					common_prefix = _tmp46_;
				}
				val_attributes = (_vala_array_free (val_attributes, val_attributes_length1, (GDestroyNotify) g_free), NULL);
			}
		}
	}
	is_errordomain = FALSE;
	_tmp47_ = vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_direct_equal);
	cheader_filenames = _tmp47_;
	_tmp49_ = vala_gidl_parser_get_attributes (self, node->name, &_tmp48_);
	_tmp50_ = _tmp49_;
	en_attributes_length1 = _tmp48_;
	_en_attributes_size_ = en_attributes_length1;
	en_attributes = _tmp50_;
	if (en_attributes != NULL) {
		{
			gchar** attr_collection;
			int attr_collection_length1;
			int attr_it;
			attr_collection = en_attributes;
			attr_collection_length1 = en_attributes_length1;
			for (attr_it = 0; attr_it < en_attributes_length1; attr_it = attr_it + 1) {
				gchar* _tmp51_;
				gchar* attr;
				_tmp51_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp51_;
				{
					gchar** _tmp52_;
					gchar** _tmp53_ = NULL;
					gint nv_length1;
					gint _nv_size_;
					gchar** _tmp54_;
					gchar** nv;
					_tmp53_ = _tmp52_ = g_strsplit (attr, "=", 2);
					_tmp54_ = _tmp53_;
					nv_length1 = _vala_array_length (_tmp52_);
					_nv_size_ = nv_length1;
					nv = _tmp54_;
					if (g_strcmp0 (nv[0], "common_prefix") == 0) {
						gchar* _tmp55_ = NULL;
						gchar* _tmp56_;
						_tmp55_ = vala_gidl_parser_eval (self, nv[1]);
						_tmp56_ = _tmp55_;
						_g_free0 (common_prefix);
						common_prefix = _tmp56_;
					} else {
						if (g_strcmp0 (nv[0], "cheader_filename") == 0) {
							gchar* _tmp57_ = NULL;
							gchar* _tmp58_;
							gchar* _tmp59_ = NULL;
							gchar* _tmp60_;
							_tmp57_ = vala_gidl_parser_eval (self, nv[1]);
							_tmp58_ = _tmp57_;
							vala_collection_add ((ValaCollection*) cheader_filenames, _tmp58_);
							_g_free0 (_tmp58_);
							_tmp59_ = vala_gidl_parser_eval (self, nv[1]);
							_tmp60_ = _tmp59_;
							vala_symbol_add_cheader_filename ((ValaSymbol*) en, _tmp60_);
							_g_free0 (_tmp60_);
						} else {
							if (g_strcmp0 (nv[0], "hidden") == 0) {
								gchar* _tmp61_ = NULL;
								gchar* _tmp62_;
								gboolean _tmp63_;
								_tmp61_ = vala_gidl_parser_eval (self, nv[1]);
								_tmp62_ = _tmp61_;
								if ((_tmp63_ = g_strcmp0 (_tmp62_, "1") == 0, _g_free0 (_tmp62_), _tmp63_)) {
									nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
									_g_free0 (attr);
									en_attributes = (_vala_array_free (en_attributes, en_attributes_length1, (GDestroyNotify) g_free), NULL);
									_vala_iterable_unref0 (cheader_filenames);
									_g_free0 (common_prefix);
									_vala_code_node_unref0 (en);
									_g_free0 (name);
									return;
								}
							} else {
								if (g_strcmp0 (nv[0], "deprecated") == 0) {
									gchar* _tmp64_ = NULL;
									gchar* _tmp65_;
									gboolean _tmp66_;
									_tmp64_ = vala_gidl_parser_eval (self, nv[1]);
									_tmp65_ = _tmp64_;
									if ((_tmp66_ = g_strcmp0 (_tmp65_, "1") == 0, _g_free0 (_tmp65_), _tmp66_)) {
										vala_symbol_set_deprecated ((ValaSymbol*) en, TRUE);
									}
								} else {
									if (g_strcmp0 (nv[0], "replacement") == 0) {
										gchar* _tmp67_ = NULL;
										gchar* _tmp68_;
										_tmp67_ = vala_gidl_parser_eval (self, nv[1]);
										_tmp68_ = _tmp67_;
										vala_symbol_set_replacement ((ValaSymbol*) en, _tmp68_);
										_g_free0 (_tmp68_);
									} else {
										if (g_strcmp0 (nv[0], "deprecated_since") == 0) {
											gchar* _tmp69_ = NULL;
											gchar* _tmp70_;
											_tmp69_ = vala_gidl_parser_eval (self, nv[1]);
											_tmp70_ = _tmp69_;
											vala_symbol_set_deprecated_since ((ValaSymbol*) en, _tmp70_);
											_g_free0 (_tmp70_);
										} else {
											if (g_strcmp0 (nv[0], "rename_to") == 0) {
												gchar* _tmp71_ = NULL;
												gchar* _tmp72_;
												_tmp71_ = vala_gidl_parser_eval (self, nv[1]);
												_tmp72_ = _tmp71_;
												vala_symbol_set_name ((ValaSymbol*) en, _tmp72_);
												_g_free0 (_tmp72_);
											} else {
												if (g_strcmp0 (nv[0], "errordomain") == 0) {
													gchar* _tmp73_ = NULL;
													gchar* _tmp74_;
													gboolean _tmp75_;
													_tmp73_ = vala_gidl_parser_eval (self, nv[1]);
													_tmp74_ = _tmp73_;
													if ((_tmp75_ = g_strcmp0 (_tmp74_, "1") == 0, _g_free0 (_tmp74_), _tmp75_)) {
														is_errordomain = TRUE;
													}
												} else {
													if (g_strcmp0 (nv[0], "to_string") == 0) {
														ValaUnresolvedType* _tmp76_ = NULL;
														ValaUnresolvedType* return_type;
														ValaUnresolvedSymbol* _tmp77_ = NULL;
														ValaUnresolvedSymbol* _tmp78_;
														ValaMethod* _tmp79_ = NULL;
														ValaMethod* m;
														gchar* _tmp80_ = NULL;
														gchar* _tmp81_;
														_tmp76_ = vala_unresolved_type_new ();
														return_type = _tmp76_;
														_tmp77_ = vala_unresolved_symbol_new (NULL, "string", NULL);
														_tmp78_ = _tmp77_;
														vala_unresolved_type_set_unresolved_symbol (return_type, _tmp78_);
														_vala_code_node_unref0 (_tmp78_);
														vala_data_type_set_value_owned ((ValaDataType*) return_type, FALSE);
														_tmp79_ = vala_method_new ("to_string", (ValaDataType*) return_type, self->priv->current_source_reference, NULL);
														m = _tmp79_;
														vala_symbol_set_access ((ValaSymbol*) m, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
														_tmp80_ = vala_gidl_parser_eval (self, nv[1]);
														_tmp81_ = _tmp80_;
														vala_method_set_cname (m, _tmp81_);
														_g_free0 (_tmp81_);
														vala_symbol_add_method ((ValaSymbol*) en, m);
														_vala_code_node_unref0 (m);
														_vala_code_node_unref0 (return_type);
													}
												}
											}
										}
									}
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	vala_enum_set_cprefix (en, common_prefix);
	{
		GList* value2_collection;
		GList* value2_it;
		value2_collection = en_node->values;
		for (value2_it = value2_collection; value2_it != NULL; value2_it = value2_it->next) {
			GIdlNode* value2;
			value2 = (GIdlNode*) value2_it->data;
			{
				gint _tmp82_;
				gchar** _tmp83_ = NULL;
				gint val_attributes_length1;
				gint _val_attributes_size_;
				gchar** _tmp84_;
				gchar** val_attributes;
				gboolean is_hidden;
				_tmp83_ = vala_gidl_parser_get_attributes (self, value2->name, &_tmp82_);
				_tmp84_ = _tmp83_;
				val_attributes_length1 = _tmp82_;
				_val_attributes_size_ = val_attributes_length1;
				val_attributes = _tmp84_;
				is_hidden = FALSE;
				if (val_attributes != NULL) {
					{
						gchar** attr_collection;
						int attr_collection_length1;
						int attr_it;
						attr_collection = val_attributes;
						attr_collection_length1 = val_attributes_length1;
						for (attr_it = 0; attr_it < val_attributes_length1; attr_it = attr_it + 1) {
							gchar* _tmp85_;
							gchar* attr;
							_tmp85_ = g_strdup (attr_collection[attr_it]);
							attr = _tmp85_;
							{
								gchar** _tmp86_;
								gchar** _tmp87_ = NULL;
								gint nv_length1;
								gint _nv_size_;
								gchar** _tmp88_;
								gchar** nv;
								gboolean _tmp89_ = FALSE;
								_tmp87_ = _tmp86_ = g_strsplit (attr, "=", 2);
								_tmp88_ = _tmp87_;
								nv_length1 = _vala_array_length (_tmp86_);
								_nv_size_ = nv_length1;
								nv = _tmp88_;
								if (g_strcmp0 (nv[0], "hidden") == 0) {
									gchar* _tmp90_ = NULL;
									gchar* _tmp91_;
									_tmp90_ = vala_gidl_parser_eval (self, nv[1]);
									_tmp91_ = _tmp90_;
									_tmp89_ = g_strcmp0 (_tmp91_, "1") == 0;
									_g_free0 (_tmp91_);
								} else {
									_tmp89_ = FALSE;
								}
								if (_tmp89_) {
									is_hidden = TRUE;
								}
								nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (attr);
							}
						}
					}
				}
				if (!is_hidden) {
					gint _tmp92_;
					gchar* _tmp93_ = NULL;
					gchar* _tmp94_;
					ValaEnumValue* _tmp95_ = NULL;
					ValaEnumValue* _tmp96_;
					ValaEnumValue* ev;
					_tmp92_ = strlen (common_prefix);
					_tmp93_ = string_substring (value2->name, (glong) _tmp92_, (glong) (-1));
					_tmp94_ = _tmp93_;
					_tmp95_ = vala_enum_value_new (_tmp94_, NULL, NULL, NULL);
					ev = (_tmp96_ = _tmp95_, _g_free0 (_tmp94_), _tmp96_);
					vala_enum_add_value (en, ev);
					_vala_code_node_unref0 (ev);
				}
				val_attributes = (_vala_array_free (val_attributes, val_attributes_length1, (GDestroyNotify) g_free), NULL);
			}
		}
	}
	if (is_errordomain) {
		const gchar* _tmp97_ = NULL;
		ValaErrorDomain* _tmp98_ = NULL;
		ValaErrorDomain* ed;
		_tmp97_ = vala_symbol_get_name ((ValaSymbol*) en);
		_tmp98_ = vala_error_domain_new (_tmp97_, self->priv->current_source_reference, NULL);
		ed = _tmp98_;
		vala_symbol_set_access ((ValaSymbol*) ed, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		vala_error_domain_set_cprefix (ed, common_prefix);
		{
			ValaArrayList* _tmp99_;
			ValaArrayList* _filename_list;
			gint _tmp100_;
			gint _filename_size;
			gint _filename_index;
			_tmp99_ = _vala_iterable_ref0 (cheader_filenames);
			_filename_list = _tmp99_;
			_tmp100_ = vala_collection_get_size ((ValaCollection*) _filename_list);
			_filename_size = _tmp100_;
			_filename_index = -1;
			while (TRUE) {
				gpointer _tmp101_ = NULL;
				gchar* filename;
				_filename_index = _filename_index + 1;
				if (!(_filename_index < _filename_size)) {
					break;
				}
				_tmp101_ = vala_list_get ((ValaList*) _filename_list, _filename_index);
				filename = (gchar*) _tmp101_;
				vala_symbol_add_cheader_filename ((ValaSymbol*) ed, filename);
				_g_free0 (filename);
			}
			_vala_iterable_unref0 (_filename_list);
		}
		{
			ValaList* _tmp102_ = NULL;
			ValaList* _ev_list;
			gint _tmp103_;
			gint _ev_size;
			gint _ev_index;
			_tmp102_ = vala_enum_get_values (en);
			_ev_list = _tmp102_;
			_tmp103_ = vala_collection_get_size ((ValaCollection*) _ev_list);
			_ev_size = _tmp103_;
			_ev_index = -1;
			while (TRUE) {
				gpointer _tmp104_ = NULL;
				ValaEnumValue* ev;
				const gchar* _tmp105_ = NULL;
				ValaErrorCode* _tmp106_ = NULL;
				ValaErrorCode* _tmp107_;
				_ev_index = _ev_index + 1;
				if (!(_ev_index < _ev_size)) {
					break;
				}
				_tmp104_ = vala_list_get (_ev_list, _ev_index);
				ev = (ValaEnumValue*) _tmp104_;
				_tmp105_ = vala_symbol_get_name ((ValaSymbol*) ev);
				_tmp106_ = vala_error_code_new (_tmp105_, NULL, NULL);
				_tmp107_ = _tmp106_;
				vala_error_domain_add_code (ed, _tmp107_);
				_vala_code_node_unref0 (_tmp107_);
				_vala_code_node_unref0 (ev);
			}
			_vala_iterable_unref0 (_ev_list);
		}
		vala_source_file_add_node (self->priv->current_source_file, (ValaCodeNode*) ed);
		if (!existing) {
			vala_gidl_parser_add_symbol_to_container (self, container, (ValaSymbol*) ed);
		}
		_vala_code_node_unref0 (ed);
	} else {
		vala_enum_set_is_flags (en, is_flags);
		vala_source_file_add_node (self->priv->current_source_file, (ValaCodeNode*) en);
		if (!existing) {
			vala_gidl_parser_add_symbol_to_container (self, container, (ValaSymbol*) en);
		}
	}
	en_attributes = (_vala_array_free (en_attributes, en_attributes_length1, (GDestroyNotify) g_free), NULL);
	_vala_iterable_unref0 (cheader_filenames);
	_g_free0 (common_prefix);
	_vala_code_node_unref0 (en);
	_g_free0 (name);
}


static void vala_gidl_parser_parse_object (ValaGIdlParser* self, GIdlNodeInterface* node, ValaSymbol* container, GIdlModule* module) {
	gchar* _tmp0_ = NULL;
	gchar* name;
	gchar* base_class;
	ValaScope* _tmp1_ = NULL;
	ValaSymbol* _tmp2_ = NULL;
	ValaSymbol* _tmp3_;
	ValaClass* cl;
	ValaTypeSymbol* _tmp54_;
	ValaTypeSymbol* _tmp55_;
	ValaHashSet* _tmp56_ = NULL;
	ValaSet* _tmp57_;
	ValaHashMap* _tmp58_ = NULL;
	ValaHashMap* current_type_func_map;
	ValaHashMap* _tmp59_ = NULL;
	ValaHashMap* current_type_vfunc_map;
	ValaMethod* _tmp89_ = NULL;
	ValaTypeSymbol* _tmp92_;
	ValaSet* _tmp93_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (module != NULL);
	_tmp0_ = vala_gidl_parser_fix_type_name (self, ((GIdlNode*) node)->name, container);
	name = _tmp0_;
	base_class = NULL;
	_tmp1_ = vala_symbol_get_scope (container);
	_tmp2_ = vala_scope_lookup (_tmp1_, name);
	cl = (_tmp3_ = _tmp2_, VALA_IS_CLASS (_tmp3_) ? ((ValaClass*) _tmp3_) : NULL);
	if (cl == NULL) {
		ValaClass* _tmp4_ = NULL;
		ValaClass* _tmp5_;
		gint _tmp6_;
		gchar** _tmp7_ = NULL;
		gint attributes_length1;
		gint _attributes_size_;
		gchar** _tmp8_;
		gchar** attributes;
		_tmp4_ = vala_class_new (name, self->priv->current_source_reference, NULL);
		_tmp5_ = _tmp4_;
		_vala_code_node_unref0 (cl);
		cl = _tmp5_;
		vala_symbol_set_access ((ValaSymbol*) cl, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp7_ = vala_gidl_parser_get_attributes (self, node->gtype_name, &_tmp6_);
		_tmp8_ = _tmp7_;
		attributes_length1 = _tmp6_;
		_attributes_size_ = attributes_length1;
		attributes = _tmp8_;
		if (attributes != NULL) {
			{
				gchar** attr_collection;
				int attr_collection_length1;
				int attr_it;
				attr_collection = attributes;
				attr_collection_length1 = attributes_length1;
				for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
					gchar* _tmp9_;
					gchar* attr;
					_tmp9_ = g_strdup (attr_collection[attr_it]);
					attr = _tmp9_;
					{
						gchar** _tmp10_;
						gchar** _tmp11_ = NULL;
						gint nv_length1;
						gint _nv_size_;
						gchar** _tmp12_;
						gchar** nv;
						_tmp11_ = _tmp10_ = g_strsplit (attr, "=", 2);
						_tmp12_ = _tmp11_;
						nv_length1 = _vala_array_length (_tmp10_);
						_nv_size_ = nv_length1;
						nv = _tmp12_;
						if (g_strcmp0 (nv[0], "cheader_filename") == 0) {
							gchar* _tmp13_ = NULL;
							gchar* _tmp14_;
							_tmp13_ = vala_gidl_parser_eval (self, nv[1]);
							_tmp14_ = _tmp13_;
							vala_symbol_add_cheader_filename ((ValaSymbol*) cl, _tmp14_);
							_g_free0 (_tmp14_);
						} else {
							if (g_strcmp0 (nv[0], "base_class") == 0) {
								gchar* _tmp15_ = NULL;
								gchar* _tmp16_;
								_tmp15_ = vala_gidl_parser_eval (self, nv[1]);
								_tmp16_ = _tmp15_;
								_g_free0 (base_class);
								base_class = _tmp16_;
							} else {
								if (g_strcmp0 (nv[0], "hidden") == 0) {
									gchar* _tmp17_ = NULL;
									gchar* _tmp18_;
									gboolean _tmp19_;
									_tmp17_ = vala_gidl_parser_eval (self, nv[1]);
									_tmp18_ = _tmp17_;
									if ((_tmp19_ = g_strcmp0 (_tmp18_, "1") == 0, _g_free0 (_tmp18_), _tmp19_)) {
										nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
										_g_free0 (attr);
										attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
										_vala_code_node_unref0 (cl);
										_g_free0 (base_class);
										_g_free0 (name);
										return;
									}
								} else {
									if (g_strcmp0 (nv[0], "type_check_function") == 0) {
										gchar* _tmp20_ = NULL;
										gchar* _tmp21_;
										_tmp20_ = vala_gidl_parser_eval (self, nv[1]);
										_tmp21_ = _tmp20_;
										vala_class_set_type_check_function (cl, _tmp21_);
										_g_free0 (_tmp21_);
									} else {
										if (g_strcmp0 (nv[0], "deprecated") == 0) {
											gchar* _tmp22_ = NULL;
											gchar* _tmp23_;
											gboolean _tmp24_;
											_tmp22_ = vala_gidl_parser_eval (self, nv[1]);
											_tmp23_ = _tmp22_;
											if ((_tmp24_ = g_strcmp0 (_tmp23_, "1") == 0, _g_free0 (_tmp23_), _tmp24_)) {
												vala_symbol_set_deprecated ((ValaSymbol*) cl, TRUE);
											}
										} else {
											if (g_strcmp0 (nv[0], "replacement") == 0) {
												gchar* _tmp25_ = NULL;
												gchar* _tmp26_;
												_tmp25_ = vala_gidl_parser_eval (self, nv[1]);
												_tmp26_ = _tmp25_;
												vala_symbol_set_replacement ((ValaSymbol*) cl, _tmp26_);
												_g_free0 (_tmp26_);
											} else {
												if (g_strcmp0 (nv[0], "deprecated_since") == 0) {
													gchar* _tmp27_ = NULL;
													gchar* _tmp28_;
													_tmp27_ = vala_gidl_parser_eval (self, nv[1]);
													_tmp28_ = _tmp27_;
													vala_symbol_set_deprecated_since ((ValaSymbol*) cl, _tmp28_);
													_g_free0 (_tmp28_);
												} else {
													if (g_strcmp0 (nv[0], "type_id") == 0) {
														gchar* _tmp29_ = NULL;
														gchar* _tmp30_;
														_tmp29_ = vala_gidl_parser_eval (self, nv[1]);
														_tmp30_ = _tmp29_;
														vala_class_set_type_id (cl, _tmp30_);
														_g_free0 (_tmp30_);
													} else {
														if (g_strcmp0 (nv[0], "abstract") == 0) {
															gchar* _tmp31_ = NULL;
															gchar* _tmp32_;
															gboolean _tmp33_;
															_tmp31_ = vala_gidl_parser_eval (self, nv[1]);
															_tmp32_ = _tmp31_;
															if ((_tmp33_ = g_strcmp0 (_tmp32_, "1") == 0, _g_free0 (_tmp32_), _tmp33_)) {
																vala_class_set_is_abstract (cl, TRUE);
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
						nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (attr);
					}
				}
			}
		}
		vala_gidl_parser_add_symbol_to_container (self, container, (ValaSymbol*) cl);
		vala_source_file_add_node (self->priv->current_source_file, (ValaCodeNode*) cl);
		attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	}
	if (base_class != NULL) {
		ValaDataType* _tmp34_ = NULL;
		ValaDataType* parent;
		_tmp34_ = vala_gidl_parser_parse_type_string (self, base_class);
		parent = _tmp34_;
		vala_class_add_base_type (cl, parent);
		_vala_code_node_unref0 (parent);
	} else {
		if (node->parent != NULL) {
			ValaDataType* _tmp35_ = NULL;
			ValaDataType* parent;
			_tmp35_ = vala_gidl_parser_parse_type_string (self, node->parent);
			parent = _tmp35_;
			vala_class_add_base_type (cl, parent);
			_vala_code_node_unref0 (parent);
		} else {
			ValaUnresolvedSymbol* _tmp36_ = NULL;
			ValaUnresolvedSymbol* _tmp37_;
			ValaUnresolvedSymbol* _tmp38_ = NULL;
			ValaUnresolvedSymbol* _tmp39_;
			ValaUnresolvedSymbol* gobject_symbol;
			ValaUnresolvedType* _tmp40_ = NULL;
			ValaUnresolvedType* _tmp41_;
			_tmp36_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
			_tmp37_ = _tmp36_;
			_tmp38_ = vala_unresolved_symbol_new (_tmp37_, "Object", NULL);
			gobject_symbol = (_tmp39_ = _tmp38_, _vala_code_node_unref0 (_tmp37_), _tmp39_);
			_tmp40_ = vala_unresolved_type_new_from_symbol (gobject_symbol, NULL);
			_tmp41_ = _tmp40_;
			vala_class_add_base_type (cl, (ValaDataType*) _tmp41_);
			_vala_code_node_unref0 (_tmp41_);
			_vala_code_node_unref0 (gobject_symbol);
		}
	}
	{
		GList* iface_name_collection;
		GList* iface_name_it;
		iface_name_collection = node->interfaces;
		for (iface_name_it = iface_name_collection; iface_name_it != NULL; iface_name_it = iface_name_it->next) {
			gchar* _tmp42_;
			gchar* iface_name;
			_tmp42_ = g_strdup ((const gchar*) iface_name_it->data);
			iface_name = _tmp42_;
			{
				gboolean skip_iface;
				gint _tmp43_;
				gchar** _tmp44_ = NULL;
				gint attributes_length1;
				gint _attributes_size_;
				gchar** _tmp45_;
				gchar** attributes;
				ValaDataType* _tmp53_ = NULL;
				ValaDataType* iface;
				skip_iface = FALSE;
				_tmp44_ = vala_gidl_parser_get_attributes (self, iface_name, &_tmp43_);
				_tmp45_ = _tmp44_;
				attributes_length1 = _tmp43_;
				_attributes_size_ = attributes_length1;
				attributes = _tmp45_;
				if (attributes != NULL) {
					{
						gchar** attr_collection;
						int attr_collection_length1;
						int attr_it;
						attr_collection = attributes;
						attr_collection_length1 = attributes_length1;
						for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
							gchar* _tmp46_;
							gchar* attr;
							_tmp46_ = g_strdup (attr_collection[attr_it]);
							attr = _tmp46_;
							{
								gchar** _tmp47_;
								gchar** _tmp48_ = NULL;
								gint nv_length1;
								gint _nv_size_;
								gchar** _tmp49_;
								gchar** nv;
								_tmp48_ = _tmp47_ = g_strsplit (attr, "=", 2);
								_tmp49_ = _tmp48_;
								nv_length1 = _vala_array_length (_tmp47_);
								_nv_size_ = nv_length1;
								nv = _tmp49_;
								if (g_strcmp0 (nv[0], "hidden") == 0) {
									gchar* _tmp50_ = NULL;
									gchar* _tmp51_;
									gboolean _tmp52_;
									_tmp50_ = vala_gidl_parser_eval (self, nv[1]);
									_tmp51_ = _tmp50_;
									if ((_tmp52_ = g_strcmp0 (_tmp51_, "1") == 0, _g_free0 (_tmp51_), _tmp52_)) {
										skip_iface = TRUE;
									}
								}
								nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (attr);
							}
						}
					}
				}
				if (skip_iface) {
					attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (iface_name);
					continue;
				}
				_tmp53_ = vala_gidl_parser_parse_type_string (self, iface_name);
				iface = _tmp53_;
				vala_class_add_base_type (cl, iface);
				_vala_code_node_unref0 (iface);
				attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (iface_name);
			}
		}
	}
	_tmp54_ = _vala_code_node_ref0 ((ValaTypeSymbol*) cl);
	_tmp55_ = _tmp54_;
	_vala_code_node_unref0 (self->priv->current_data_type);
	self->priv->current_data_type = _tmp55_;
	_tmp56_ = vala_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal);
	_tmp57_ = (ValaSet*) _tmp56_;
	_vala_iterable_unref0 (self->priv->current_type_symbol_set);
	self->priv->current_type_symbol_set = _tmp57_;
	_tmp58_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_POINTER, NULL, NULL, g_str_hash, g_str_equal, g_direct_equal);
	current_type_func_map = _tmp58_;
	_tmp59_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal, g_direct_equal);
	current_type_vfunc_map = _tmp59_;
	{
		GList* member_collection;
		GList* member_it;
		member_collection = node->members;
		for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
			GIdlNode* member;
			member = (GIdlNode*) member_it->data;
			{
				if (member->type == G_IDL_NODE_FUNCTION) {
					vala_map_set ((ValaMap*) current_type_func_map, member->name, (GIdlNodeFunction*) member);
				}
				if (member->type == G_IDL_NODE_VFUNC) {
					vala_map_set ((ValaMap*) current_type_vfunc_map, member->name, "1");
				}
			}
		}
	}
	{
		GList* member_collection;
		GList* member_it;
		member_collection = node->members;
		for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
			GIdlNode* member;
			member = (GIdlNode*) member_it->data;
			{
				if (member->type == G_IDL_NODE_FUNCTION) {
					gboolean _tmp60_;
					_tmp60_ = vala_map_contains ((ValaMap*) current_type_vfunc_map, member->name);
					if (!_tmp60_) {
						ValaMethod* _tmp61_ = NULL;
						ValaMethod* m;
						_tmp61_ = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) member, FALSE);
						m = _tmp61_;
						if (m != NULL) {
							vala_symbol_add_method ((ValaSymbol*) cl, m);
						}
						_vala_code_node_unref0 (m);
					}
				} else {
					if (member->type == G_IDL_NODE_VFUNC) {
						gpointer _tmp62_ = NULL;
						ValaMethod* _tmp63_ = NULL;
						ValaMethod* m;
						_tmp62_ = vala_map_get ((ValaMap*) current_type_func_map, member->name);
						_tmp63_ = vala_gidl_parser_parse_virtual (self, (GIdlNodeVFunc*) member, (GIdlNodeFunction*) _tmp62_, FALSE);
						m = _tmp63_;
						if (m != NULL) {
							vala_symbol_add_method ((ValaSymbol*) cl, m);
						}
						_vala_code_node_unref0 (m);
					} else {
						if (member->type == G_IDL_NODE_PROPERTY) {
							ValaProperty* _tmp64_ = NULL;
							ValaProperty* prop;
							_tmp64_ = vala_gidl_parser_parse_property (self, (GIdlNodeProperty*) member);
							prop = _tmp64_;
							if (prop != NULL) {
								vala_symbol_add_property ((ValaSymbol*) cl, prop);
							}
							_vala_code_node_unref0 (prop);
						} else {
							if (member->type == G_IDL_NODE_SIGNAL) {
								ValaSignal* _tmp65_ = NULL;
								ValaSignal* sig;
								_tmp65_ = vala_gidl_parser_parse_signal (self, (GIdlNodeSignal*) member);
								sig = _tmp65_;
								if (sig != NULL) {
									vala_symbol_add_signal ((ValaSymbol*) cl, sig);
								}
								_vala_code_node_unref0 (sig);
							}
						}
					}
				}
			}
		}
	}
	{
		GList* member_collection;
		GList* member_it;
		member_collection = node->members;
		for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
			GIdlNode* member;
			member = (GIdlNode*) member_it->data;
			{
				if (member->type == G_IDL_NODE_FIELD) {
					gboolean _tmp66_;
					_tmp66_ = vala_collection_contains ((ValaCollection*) self->priv->current_type_symbol_set, member->name);
					if (!_tmp66_) {
						ValaField* _tmp67_ = NULL;
						ValaField* f;
						_tmp67_ = vala_gidl_parser_parse_field (self, (GIdlNodeField*) member);
						f = _tmp67_;
						if (f != NULL) {
							vala_symbol_add_field ((ValaSymbol*) cl, f);
						}
						_vala_code_node_unref0 (f);
					}
				}
			}
		}
	}
	{
		ValaList* _tmp68_ = NULL;
		ValaList* _prop_list;
		gint _tmp69_;
		gint _prop_size;
		gint _prop_index;
		_tmp68_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) cl);
		_prop_list = _tmp68_;
		_tmp69_ = vala_collection_get_size ((ValaCollection*) _prop_list);
		_prop_size = _tmp69_;
		_prop_index = -1;
		while (TRUE) {
			gpointer _tmp70_ = NULL;
			ValaProperty* prop;
			const gchar* _tmp71_ = NULL;
			gchar* _tmp72_ = NULL;
			gchar* getter;
			gboolean _tmp73_ = FALSE;
			ValaPropertyAccessor* _tmp74_ = NULL;
			const gchar* _tmp76_ = NULL;
			gchar* _tmp77_ = NULL;
			gchar* setter;
			gboolean _tmp78_ = FALSE;
			gboolean _tmp79_ = FALSE;
			ValaPropertyAccessor* _tmp80_ = NULL;
			gboolean _tmp84_ = FALSE;
			gboolean _tmp85_;
			_prop_index = _prop_index + 1;
			if (!(_prop_index < _prop_size)) {
				break;
			}
			_tmp70_ = vala_list_get (_prop_list, _prop_index);
			prop = (ValaProperty*) _tmp70_;
			_tmp71_ = vala_symbol_get_name ((ValaSymbol*) prop);
			_tmp72_ = g_strdup_printf ("get_%s", _tmp71_);
			getter = _tmp72_;
			_tmp74_ = vala_property_get_get_accessor (prop);
			if (_tmp74_ != NULL) {
				gboolean _tmp75_;
				_tmp75_ = vala_collection_contains ((ValaCollection*) self->priv->current_type_symbol_set, getter);
				_tmp73_ = !_tmp75_;
			} else {
				_tmp73_ = FALSE;
			}
			if (_tmp73_) {
				vala_property_set_no_accessor_method (prop, TRUE);
			}
			_tmp76_ = vala_symbol_get_name ((ValaSymbol*) prop);
			_tmp77_ = g_strdup_printf ("set_%s", _tmp76_);
			setter = _tmp77_;
			_tmp80_ = vala_property_get_set_accessor (prop);
			if (_tmp80_ != NULL) {
				ValaPropertyAccessor* _tmp81_ = NULL;
				gboolean _tmp82_;
				_tmp81_ = vala_property_get_set_accessor (prop);
				_tmp82_ = vala_property_accessor_get_writable (_tmp81_);
				_tmp79_ = _tmp82_;
			} else {
				_tmp79_ = FALSE;
			}
			if (_tmp79_) {
				gboolean _tmp83_;
				_tmp83_ = vala_collection_contains ((ValaCollection*) self->priv->current_type_symbol_set, setter);
				_tmp78_ = !_tmp83_;
			} else {
				_tmp78_ = FALSE;
			}
			if (_tmp78_) {
				vala_property_set_no_accessor_method (prop, TRUE);
			}
			_tmp85_ = vala_property_get_no_accessor_method (prop);
			if (_tmp85_) {
				ValaPropertyAccessor* _tmp86_ = NULL;
				_tmp86_ = vala_property_get_get_accessor (prop);
				_tmp84_ = _tmp86_ != NULL;
			} else {
				_tmp84_ = FALSE;
			}
			if (_tmp84_) {
				ValaPropertyAccessor* _tmp87_ = NULL;
				ValaDataType* _tmp88_ = NULL;
				_tmp87_ = vala_property_get_get_accessor (prop);
				_tmp88_ = vala_property_accessor_get_value_type (_tmp87_);
				vala_data_type_set_value_owned (_tmp88_, TRUE);
			}
			_g_free0 (setter);
			_g_free0 (getter);
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	vala_gidl_parser_handle_async_methods (self, (ValaObjectTypeSymbol*) cl);
	_tmp89_ = vala_class_get_default_construction_method (cl);
	if (_tmp89_ == NULL) {
		ValaSourceReference* _tmp90_ = NULL;
		ValaCreationMethod* _tmp91_ = NULL;
		ValaCreationMethod* cm;
		_tmp90_ = vala_code_node_get_source_reference ((ValaCodeNode*) cl);
		_tmp91_ = vala_creation_method_new (NULL, NULL, _tmp90_, NULL);
		cm = _tmp91_;
		vala_method_set_has_construct_function ((ValaMethod*) cm, FALSE);
		vala_symbol_set_access ((ValaSymbol*) cm, VALA_SYMBOL_ACCESSIBILITY_PROTECTED);
		vala_symbol_add_method ((ValaSymbol*) cl, (ValaMethod*) cm);
		_vala_code_node_unref0 (cm);
	}
	_tmp92_ = NULL;
	_vala_code_node_unref0 (self->priv->current_data_type);
	self->priv->current_data_type = _tmp92_;
	_tmp93_ = NULL;
	_vala_iterable_unref0 (self->priv->current_type_symbol_set);
	self->priv->current_type_symbol_set = _tmp93_;
	_vala_map_unref0 (current_type_vfunc_map);
	_vala_map_unref0 (current_type_func_map);
	_vala_code_node_unref0 (cl);
	_g_free0 (base_class);
	_g_free0 (name);
}


static void vala_gidl_parser_parse_interface (ValaGIdlParser* self, GIdlNodeInterface* node, ValaSymbol* container, GIdlModule* module) {
	gchar* _tmp0_ = NULL;
	gchar* name;
	ValaScope* _tmp1_ = NULL;
	ValaSymbol* _tmp2_ = NULL;
	ValaSymbol* _tmp3_;
	ValaInterface* iface;
	ValaTypeSymbol* _tmp19_;
	ValaTypeSymbol* _tmp20_;
	ValaHashMap* _tmp21_ = NULL;
	ValaHashMap* current_type_func_map;
	ValaHashMap* _tmp22_ = NULL;
	ValaHashMap* current_type_vfunc_map;
	ValaTypeSymbol* _tmp29_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (module != NULL);
	_tmp0_ = vala_gidl_parser_fix_type_name (self, node->gtype_name, container);
	name = _tmp0_;
	_tmp1_ = vala_symbol_get_scope (container);
	_tmp2_ = vala_scope_lookup (_tmp1_, name);
	iface = (_tmp3_ = _tmp2_, VALA_IS_INTERFACE (_tmp3_) ? ((ValaInterface*) _tmp3_) : NULL);
	if (iface == NULL) {
		ValaInterface* _tmp4_ = NULL;
		ValaInterface* _tmp5_;
		gint _tmp6_;
		gchar** _tmp7_ = NULL;
		gint attributes_length1;
		gint _attributes_size_;
		gchar** _tmp8_;
		gchar** attributes;
		_tmp4_ = vala_interface_new (name, self->priv->current_source_reference, NULL);
		_tmp5_ = _tmp4_;
		_vala_code_node_unref0 (iface);
		iface = _tmp5_;
		vala_symbol_set_access ((ValaSymbol*) iface, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp7_ = vala_gidl_parser_get_attributes (self, node->gtype_name, &_tmp6_);
		_tmp8_ = _tmp7_;
		attributes_length1 = _tmp6_;
		_attributes_size_ = attributes_length1;
		attributes = _tmp8_;
		if (attributes != NULL) {
			{
				gchar** attr_collection;
				int attr_collection_length1;
				int attr_it;
				attr_collection = attributes;
				attr_collection_length1 = attributes_length1;
				for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
					gchar* _tmp9_;
					gchar* attr;
					_tmp9_ = g_strdup (attr_collection[attr_it]);
					attr = _tmp9_;
					{
						gchar** _tmp10_;
						gchar** _tmp11_ = NULL;
						gint nv_length1;
						gint _nv_size_;
						gchar** _tmp12_;
						gchar** nv;
						_tmp11_ = _tmp10_ = g_strsplit (attr, "=", 2);
						_tmp12_ = _tmp11_;
						nv_length1 = _vala_array_length (_tmp10_);
						_nv_size_ = nv_length1;
						nv = _tmp12_;
						if (g_strcmp0 (nv[0], "cheader_filename") == 0) {
							gchar* _tmp13_ = NULL;
							gchar* _tmp14_;
							_tmp13_ = vala_gidl_parser_eval (self, nv[1]);
							_tmp14_ = _tmp13_;
							vala_symbol_add_cheader_filename ((ValaSymbol*) iface, _tmp14_);
							_g_free0 (_tmp14_);
						} else {
							if (g_strcmp0 (nv[0], "lower_case_csuffix") == 0) {
								gchar* _tmp15_ = NULL;
								gchar* _tmp16_;
								_tmp15_ = vala_gidl_parser_eval (self, nv[1]);
								_tmp16_ = _tmp15_;
								vala_interface_set_lower_case_csuffix (iface, _tmp16_);
								_g_free0 (_tmp16_);
							}
						}
						nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (attr);
					}
				}
			}
		}
		{
			GList* prereq_name_collection;
			GList* prereq_name_it;
			prereq_name_collection = node->prerequisites;
			for (prereq_name_it = prereq_name_collection; prereq_name_it != NULL; prereq_name_it = prereq_name_it->next) {
				gchar* _tmp17_;
				gchar* prereq_name;
				_tmp17_ = g_strdup ((const gchar*) prereq_name_it->data);
				prereq_name = _tmp17_;
				{
					ValaDataType* _tmp18_ = NULL;
					ValaDataType* prereq;
					_tmp18_ = vala_gidl_parser_parse_type_string (self, prereq_name);
					prereq = _tmp18_;
					vala_interface_add_prerequisite (iface, prereq);
					_vala_code_node_unref0 (prereq);
					_g_free0 (prereq_name);
				}
			}
		}
		vala_gidl_parser_add_symbol_to_container (self, container, (ValaSymbol*) iface);
		vala_source_file_add_node (self->priv->current_source_file, (ValaCodeNode*) iface);
		attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp19_ = _vala_code_node_ref0 ((ValaTypeSymbol*) iface);
	_tmp20_ = _tmp19_;
	_vala_code_node_unref0 (self->priv->current_data_type);
	self->priv->current_data_type = _tmp20_;
	_tmp21_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_POINTER, NULL, NULL, g_str_hash, g_str_equal, g_direct_equal);
	current_type_func_map = _tmp21_;
	_tmp22_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal, g_direct_equal);
	current_type_vfunc_map = _tmp22_;
	{
		GList* member_collection;
		GList* member_it;
		member_collection = node->members;
		for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
			GIdlNode* member;
			member = (GIdlNode*) member_it->data;
			{
				if (member->type == G_IDL_NODE_FUNCTION) {
					vala_map_set ((ValaMap*) current_type_func_map, member->name, (GIdlNodeFunction*) member);
				}
				if (member->type == G_IDL_NODE_VFUNC) {
					vala_map_set ((ValaMap*) current_type_vfunc_map, member->name, "1");
				}
			}
		}
	}
	{
		GList* member_collection;
		GList* member_it;
		member_collection = node->members;
		for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
			GIdlNode* member;
			member = (GIdlNode*) member_it->data;
			{
				if (member->type == G_IDL_NODE_FUNCTION) {
					gboolean _tmp23_;
					_tmp23_ = vala_map_contains ((ValaMap*) current_type_vfunc_map, member->name);
					if (!_tmp23_) {
						ValaMethod* _tmp24_ = NULL;
						ValaMethod* m;
						_tmp24_ = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) member, TRUE);
						m = _tmp24_;
						if (m != NULL) {
							vala_symbol_add_method ((ValaSymbol*) iface, m);
						}
						_vala_code_node_unref0 (m);
					}
				} else {
					if (member->type == G_IDL_NODE_VFUNC) {
						gpointer _tmp25_ = NULL;
						ValaMethod* _tmp26_ = NULL;
						ValaMethod* m;
						_tmp25_ = vala_map_get ((ValaMap*) current_type_func_map, member->name);
						_tmp26_ = vala_gidl_parser_parse_virtual (self, (GIdlNodeVFunc*) member, (GIdlNodeFunction*) _tmp25_, TRUE);
						m = _tmp26_;
						if (m != NULL) {
							vala_symbol_add_method ((ValaSymbol*) iface, m);
						}
						_vala_code_node_unref0 (m);
					} else {
						if (member->type == G_IDL_NODE_PROPERTY) {
							ValaProperty* _tmp27_ = NULL;
							ValaProperty* prop;
							_tmp27_ = vala_gidl_parser_parse_property (self, (GIdlNodeProperty*) member);
							prop = _tmp27_;
							if (prop != NULL) {
								vala_symbol_add_property ((ValaSymbol*) iface, prop);
							}
							_vala_code_node_unref0 (prop);
						} else {
							if (member->type == G_IDL_NODE_SIGNAL) {
								ValaSignal* _tmp28_ = NULL;
								ValaSignal* sig;
								_tmp28_ = vala_gidl_parser_parse_signal (self, (GIdlNodeSignal*) member);
								sig = _tmp28_;
								if (sig != NULL) {
									vala_symbol_add_signal ((ValaSymbol*) iface, sig);
									vala_signal_set_is_virtual (sig, FALSE);
								}
								_vala_code_node_unref0 (sig);
							}
						}
					}
				}
			}
		}
	}
	vala_gidl_parser_handle_async_methods (self, (ValaObjectTypeSymbol*) iface);
	_tmp29_ = NULL;
	_vala_code_node_unref0 (self->priv->current_data_type);
	self->priv->current_data_type = _tmp29_;
	_vala_map_unref0 (current_type_vfunc_map);
	_vala_map_unref0 (current_type_func_map);
	_vala_code_node_unref0 (iface);
	_g_free0 (name);
}


static void vala_gidl_parser_handle_async_methods (ValaGIdlParser* self, ValaObjectTypeSymbol* type_symbol) {
	ValaHashSet* _tmp0_ = NULL;
	ValaSet* finish_methods;
	ValaList* _tmp1_ = NULL;
	ValaList* methods;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type_symbol != NULL);
	_tmp0_ = vala_hash_set_new (VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_hash, g_direct_equal);
	finish_methods = (ValaSet*) _tmp0_;
	_tmp1_ = vala_object_type_symbol_get_methods (type_symbol);
	methods = _tmp1_;
	{
		ValaList* _tmp2_;
		ValaList* _m_list;
		gint _tmp3_;
		gint _m_size;
		gint _m_index;
		_tmp2_ = _vala_iterable_ref0 (methods);
		_m_list = _tmp2_;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _m_list);
		_m_size = _tmp3_;
		_m_index = -1;
		while (TRUE) {
			gpointer _tmp4_ = NULL;
			ValaMethod* m;
			gboolean _tmp5_;
			_m_index = _m_index + 1;
			if (!(_m_index < _m_size)) {
				break;
			}
			_tmp4_ = vala_list_get (_m_list, _m_index);
			m = (ValaMethod*) _tmp4_;
			_tmp5_ = vala_method_get_coroutine (m);
			if (_tmp5_) {
				gchar* finish_method_base;
				const gchar* _tmp6_ = NULL;
				gboolean _tmp7_;
				ValaScope* _tmp17_ = NULL;
				gchar* _tmp18_;
				ValaSymbol* _tmp19_ = NULL;
				ValaSymbol* _tmp20_;
				ValaMethod* _tmp21_;
				ValaMethod* finish_method;
				finish_method_base = NULL;
				_tmp6_ = vala_symbol_get_name ((ValaSymbol*) m);
				_tmp7_ = g_str_has_suffix (_tmp6_, "_async");
				if (_tmp7_) {
					const gchar* _tmp8_ = NULL;
					const gchar* _tmp9_ = NULL;
					gint _tmp10_;
					gint _tmp11_;
					gchar* _tmp12_ = NULL;
					gchar* _tmp13_;
					_tmp8_ = vala_symbol_get_name ((ValaSymbol*) m);
					_tmp9_ = vala_symbol_get_name ((ValaSymbol*) m);
					_tmp10_ = strlen (_tmp9_);
					_tmp11_ = strlen ("_async");
					_tmp12_ = string_substring (_tmp8_, (glong) 0, (glong) (_tmp10_ - _tmp11_));
					_tmp13_ = _tmp12_;
					_g_free0 (finish_method_base);
					finish_method_base = _tmp13_;
				} else {
					const gchar* _tmp14_ = NULL;
					gchar* _tmp15_;
					gchar* _tmp16_;
					_tmp14_ = vala_symbol_get_name ((ValaSymbol*) m);
					_tmp15_ = g_strdup (_tmp14_);
					_tmp16_ = _tmp15_;
					_g_free0 (finish_method_base);
					finish_method_base = _tmp16_;
				}
				_tmp17_ = vala_symbol_get_scope ((ValaSymbol*) type_symbol);
				_tmp18_ = g_strconcat (finish_method_base, "_finish", NULL);
				_tmp19_ = vala_scope_lookup (_tmp17_, _tmp18_);
				finish_method = (_tmp21_ = (_tmp20_ = _tmp19_, VALA_IS_METHOD (_tmp20_) ? ((ValaMethod*) _tmp20_) : NULL), _g_free0 (_tmp18_), _tmp21_);
				if (finish_method == NULL) {
					gchar* _tmp22_ = NULL;
					gchar* method_cname;
					_tmp22_ = vala_method_get_finish_cname (m);
					method_cname = _tmp22_;
					{
						ValaList* _tmp23_ = NULL;
						ValaList* _method_list;
						gint _tmp24_;
						gint _method_size;
						gint _method_index;
						_tmp23_ = vala_object_type_symbol_get_methods (type_symbol);
						_method_list = _tmp23_;
						_tmp24_ = vala_collection_get_size ((ValaCollection*) _method_list);
						_method_size = _tmp24_;
						_method_index = -1;
						while (TRUE) {
							gpointer _tmp25_ = NULL;
							ValaMethod* method;
							gchar* _tmp26_ = NULL;
							gchar* _tmp27_;
							gboolean _tmp28_;
							_method_index = _method_index + 1;
							if (!(_method_index < _method_size)) {
								break;
							}
							_tmp25_ = vala_list_get (_method_list, _method_index);
							method = (ValaMethod*) _tmp25_;
							_tmp26_ = vala_method_get_cname (method);
							_tmp27_ = _tmp26_;
							if ((_tmp28_ = g_strcmp0 (_tmp27_, method_cname) == 0, _g_free0 (_tmp27_), _tmp28_)) {
								ValaMethod* _tmp29_;
								ValaMethod* _tmp30_;
								_tmp29_ = _vala_code_node_ref0 (method);
								_tmp30_ = _tmp29_;
								_vala_code_node_unref0 (finish_method);
								finish_method = _tmp30_;
								_vala_code_node_unref0 (method);
								break;
							}
							_vala_code_node_unref0 (method);
						}
						_vala_iterable_unref0 (_method_list);
					}
					_g_free0 (method_cname);
				}
				if (finish_method != NULL) {
					ValaDataType* _tmp31_ = NULL;
					ValaDataType* _tmp32_ = NULL;
					ValaDataType* _tmp33_;
					gboolean _tmp34_;
					gboolean _tmp35_;
					_tmp31_ = vala_method_get_return_type (finish_method);
					_tmp32_ = vala_data_type_copy (_tmp31_);
					_tmp33_ = _tmp32_;
					vala_method_set_return_type (m, _tmp33_);
					_vala_code_node_unref0 (_tmp33_);
					_tmp34_ = vala_method_get_no_array_length (finish_method);
					vala_method_set_no_array_length (m, _tmp34_);
					_tmp35_ = vala_method_get_array_null_terminated (finish_method);
					vala_method_set_array_null_terminated (m, _tmp35_);
					{
						ValaList* _tmp36_ = NULL;
						ValaList* _param_list;
						gint _tmp37_;
						gint _param_size;
						gint _param_index;
						_tmp36_ = vala_method_get_parameters (finish_method);
						_param_list = _tmp36_;
						_tmp37_ = vala_collection_get_size ((ValaCollection*) _param_list);
						_param_size = _tmp37_;
						_param_index = -1;
						while (TRUE) {
							gpointer _tmp38_ = NULL;
							ValaParameter* param;
							ValaParameterDirection _tmp39_;
							_param_index = _param_index + 1;
							if (!(_param_index < _param_size)) {
								break;
							}
							_tmp38_ = vala_list_get (_param_list, _param_index);
							param = (ValaParameter*) _tmp38_;
							_tmp39_ = vala_parameter_get_direction (param);
							if (_tmp39_ == VALA_PARAMETER_DIRECTION_OUT) {
								ValaParameter* _tmp40_ = NULL;
								ValaParameter* async_param;
								ValaScope* _tmp41_ = NULL;
								const gchar* _tmp42_ = NULL;
								ValaSymbol* _tmp43_ = NULL;
								ValaSymbol* _tmp44_;
								gboolean _tmp45_;
								_tmp40_ = vala_parameter_copy (param);
								async_param = _tmp40_;
								_tmp41_ = vala_symbol_get_scope ((ValaSymbol*) m);
								_tmp42_ = vala_symbol_get_name ((ValaSymbol*) param);
								_tmp43_ = vala_scope_lookup (_tmp41_, _tmp42_);
								_tmp44_ = _tmp43_;
								if ((_tmp45_ = _tmp44_ != NULL, _vala_code_node_unref0 (_tmp44_), _tmp45_)) {
									const gchar* _tmp46_ = NULL;
									gchar* _tmp47_;
									_tmp46_ = vala_symbol_get_name ((ValaSymbol*) async_param);
									_tmp47_ = g_strconcat (_tmp46_, "_out", NULL);
									vala_symbol_set_name ((ValaSymbol*) async_param, _tmp47_);
									_g_free0 (_tmp47_);
								}
								vala_method_add_parameter (m, async_param);
								_vala_code_node_unref0 (async_param);
							}
							_vala_code_node_unref0 (param);
						}
						_vala_iterable_unref0 (_param_list);
					}
					{
						ValaList* _tmp48_ = NULL;
						ValaList* _error_type_list;
						gint _tmp49_;
						gint _error_type_size;
						gint _error_type_index;
						_tmp48_ = vala_code_node_get_error_types ((ValaCodeNode*) finish_method);
						_error_type_list = _tmp48_;
						_tmp49_ = vala_collection_get_size ((ValaCollection*) _error_type_list);
						_error_type_size = _tmp49_;
						_error_type_index = -1;
						while (TRUE) {
							gpointer _tmp50_ = NULL;
							ValaDataType* error_type;
							ValaDataType* _tmp51_ = NULL;
							ValaDataType* _tmp52_;
							_error_type_index = _error_type_index + 1;
							if (!(_error_type_index < _error_type_size)) {
								break;
							}
							_tmp50_ = vala_list_get (_error_type_list, _error_type_index);
							error_type = (ValaDataType*) _tmp50_;
							_tmp51_ = vala_data_type_copy (error_type);
							_tmp52_ = _tmp51_;
							vala_code_node_add_error_type ((ValaCodeNode*) m, _tmp52_);
							_vala_code_node_unref0 (_tmp52_);
							_vala_code_node_unref0 (error_type);
						}
						_vala_iterable_unref0 (_error_type_list);
					}
					vala_collection_add ((ValaCollection*) finish_methods, finish_method);
				}
				_vala_code_node_unref0 (finish_method);
				_g_free0 (finish_method_base);
			}
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	{
		ValaIterator* _tmp53_ = NULL;
		ValaIterator* _m_it;
		_tmp53_ = vala_iterable_iterator ((ValaIterable*) finish_methods);
		_m_it = _tmp53_;
		while (TRUE) {
			gboolean _tmp54_;
			gpointer _tmp55_ = NULL;
			ValaMethod* m;
			ValaScope* _tmp56_ = NULL;
			const gchar* _tmp57_ = NULL;
			_tmp54_ = vala_iterator_next (_m_it);
			if (!_tmp54_) {
				break;
			}
			_tmp55_ = vala_iterator_get (_m_it);
			m = (ValaMethod*) _tmp55_;
			_tmp56_ = vala_symbol_get_scope ((ValaSymbol*) type_symbol);
			_tmp57_ = vala_symbol_get_name ((ValaSymbol*) m);
			vala_scope_remove (_tmp56_, _tmp57_);
			vala_collection_remove ((ValaCollection*) methods, m);
			_vala_code_node_unref0 (m);
		}
		_vala_iterator_unref0 (_m_it);
	}
	_vala_iterable_unref0 (methods);
	_vala_iterable_unref0 (finish_methods);
}


static ValaDataType* vala_gidl_parser_parse_type (ValaGIdlParser* self, GIdlNodeType* type_node, ValaParameterDirection* direction) {
	ValaParameterDirection _direction = 0;
	ValaDataType* result = NULL;
	ValaParameterDirection dir;
	ValaUnresolvedType* _tmp0_ = NULL;
	ValaUnresolvedType* type;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type_node != NULL, NULL);
	dir = VALA_PARAMETER_DIRECTION_IN;
	_tmp0_ = vala_unresolved_type_new ();
	type = _tmp0_;
	if (type_node->tag == TYPE_TAG_VOID) {
		if (type_node->is_pointer) {
			ValaVoidType* _tmp1_ = NULL;
			ValaVoidType* _tmp2_;
			ValaPointerType* _tmp3_ = NULL;
			ValaDataType* _tmp4_;
			_tmp1_ = vala_void_type_new (NULL);
			_tmp2_ = _tmp1_;
			_tmp3_ = vala_pointer_type_new ((ValaDataType*) _tmp2_, NULL);
			result = (_tmp4_ = (ValaDataType*) _tmp3_, _vala_code_node_unref0 (_tmp2_), _tmp4_);
			_vala_code_node_unref0 (type);
			if (direction) {
				*direction = _direction;
			}
			return result;
		} else {
			ValaVoidType* _tmp5_ = NULL;
			_tmp5_ = vala_void_type_new (NULL);
			result = (ValaDataType*) _tmp5_;
			_vala_code_node_unref0 (type);
			if (direction) {
				*direction = _direction;
			}
			return result;
		}
	} else {
		if (type_node->tag == TYPE_TAG_BOOLEAN) {
			ValaUnresolvedSymbol* _tmp6_ = NULL;
			ValaUnresolvedSymbol* _tmp7_;
			_tmp6_ = vala_unresolved_symbol_new (NULL, "bool", NULL);
			_tmp7_ = _tmp6_;
			vala_unresolved_type_set_unresolved_symbol (type, _tmp7_);
			_vala_code_node_unref0 (_tmp7_);
		} else {
			if (type_node->tag == TYPE_TAG_INT8) {
				ValaUnresolvedSymbol* _tmp8_ = NULL;
				ValaUnresolvedSymbol* _tmp9_;
				_tmp8_ = vala_unresolved_symbol_new (NULL, "char", NULL);
				_tmp9_ = _tmp8_;
				vala_unresolved_type_set_unresolved_symbol (type, _tmp9_);
				_vala_code_node_unref0 (_tmp9_);
			} else {
				if (type_node->tag == TYPE_TAG_UINT8) {
					ValaUnresolvedSymbol* _tmp10_ = NULL;
					ValaUnresolvedSymbol* _tmp11_;
					_tmp10_ = vala_unresolved_symbol_new (NULL, "uchar", NULL);
					_tmp11_ = _tmp10_;
					vala_unresolved_type_set_unresolved_symbol (type, _tmp11_);
					_vala_code_node_unref0 (_tmp11_);
				} else {
					if (type_node->tag == TYPE_TAG_INT16) {
						ValaUnresolvedSymbol* _tmp12_ = NULL;
						ValaUnresolvedSymbol* _tmp13_;
						_tmp12_ = vala_unresolved_symbol_new (NULL, "int16", NULL);
						_tmp13_ = _tmp12_;
						vala_unresolved_type_set_unresolved_symbol (type, _tmp13_);
						_vala_code_node_unref0 (_tmp13_);
					} else {
						if (type_node->tag == TYPE_TAG_UINT16) {
							ValaUnresolvedSymbol* _tmp14_ = NULL;
							ValaUnresolvedSymbol* _tmp15_;
							_tmp14_ = vala_unresolved_symbol_new (NULL, "uint16", NULL);
							_tmp15_ = _tmp14_;
							vala_unresolved_type_set_unresolved_symbol (type, _tmp15_);
							_vala_code_node_unref0 (_tmp15_);
						} else {
							if (type_node->tag == TYPE_TAG_INT32) {
								ValaUnresolvedSymbol* _tmp16_ = NULL;
								ValaUnresolvedSymbol* _tmp17_;
								_tmp16_ = vala_unresolved_symbol_new (NULL, "int32", NULL);
								_tmp17_ = _tmp16_;
								vala_unresolved_type_set_unresolved_symbol (type, _tmp17_);
								_vala_code_node_unref0 (_tmp17_);
							} else {
								if (type_node->tag == TYPE_TAG_UINT32) {
									ValaUnresolvedSymbol* _tmp18_ = NULL;
									ValaUnresolvedSymbol* _tmp19_;
									_tmp18_ = vala_unresolved_symbol_new (NULL, "uint32", NULL);
									_tmp19_ = _tmp18_;
									vala_unresolved_type_set_unresolved_symbol (type, _tmp19_);
									_vala_code_node_unref0 (_tmp19_);
								} else {
									if (type_node->tag == TYPE_TAG_INT64) {
										ValaUnresolvedSymbol* _tmp20_ = NULL;
										ValaUnresolvedSymbol* _tmp21_;
										_tmp20_ = vala_unresolved_symbol_new (NULL, "int64", NULL);
										_tmp21_ = _tmp20_;
										vala_unresolved_type_set_unresolved_symbol (type, _tmp21_);
										_vala_code_node_unref0 (_tmp21_);
									} else {
										if (type_node->tag == TYPE_TAG_UINT64) {
											ValaUnresolvedSymbol* _tmp22_ = NULL;
											ValaUnresolvedSymbol* _tmp23_;
											_tmp22_ = vala_unresolved_symbol_new (NULL, "uint64", NULL);
											_tmp23_ = _tmp22_;
											vala_unresolved_type_set_unresolved_symbol (type, _tmp23_);
											_vala_code_node_unref0 (_tmp23_);
										} else {
											if (type_node->tag == TYPE_TAG_INT) {
												ValaUnresolvedSymbol* _tmp24_ = NULL;
												ValaUnresolvedSymbol* _tmp25_;
												_tmp24_ = vala_unresolved_symbol_new (NULL, "int", NULL);
												_tmp25_ = _tmp24_;
												vala_unresolved_type_set_unresolved_symbol (type, _tmp25_);
												_vala_code_node_unref0 (_tmp25_);
											} else {
												if (type_node->tag == TYPE_TAG_UINT) {
													ValaUnresolvedSymbol* _tmp26_ = NULL;
													ValaUnresolvedSymbol* _tmp27_;
													_tmp26_ = vala_unresolved_symbol_new (NULL, "uint", NULL);
													_tmp27_ = _tmp26_;
													vala_unresolved_type_set_unresolved_symbol (type, _tmp27_);
													_vala_code_node_unref0 (_tmp27_);
												} else {
													if (type_node->tag == TYPE_TAG_LONG) {
														ValaUnresolvedSymbol* _tmp28_ = NULL;
														ValaUnresolvedSymbol* _tmp29_;
														_tmp28_ = vala_unresolved_symbol_new (NULL, "long", NULL);
														_tmp29_ = _tmp28_;
														vala_unresolved_type_set_unresolved_symbol (type, _tmp29_);
														_vala_code_node_unref0 (_tmp29_);
													} else {
														if (type_node->tag == TYPE_TAG_ULONG) {
															ValaUnresolvedSymbol* _tmp30_ = NULL;
															ValaUnresolvedSymbol* _tmp31_;
															_tmp30_ = vala_unresolved_symbol_new (NULL, "ulong", NULL);
															_tmp31_ = _tmp30_;
															vala_unresolved_type_set_unresolved_symbol (type, _tmp31_);
															_vala_code_node_unref0 (_tmp31_);
														} else {
															if (type_node->tag == TYPE_TAG_SSIZE) {
																ValaUnresolvedSymbol* _tmp32_ = NULL;
																ValaUnresolvedSymbol* _tmp33_;
																_tmp32_ = vala_unresolved_symbol_new (NULL, "ssize_t", NULL);
																_tmp33_ = _tmp32_;
																vala_unresolved_type_set_unresolved_symbol (type, _tmp33_);
																_vala_code_node_unref0 (_tmp33_);
															} else {
																if (type_node->tag == TYPE_TAG_SIZE) {
																	ValaUnresolvedSymbol* _tmp34_ = NULL;
																	ValaUnresolvedSymbol* _tmp35_;
																	_tmp34_ = vala_unresolved_symbol_new (NULL, "size_t", NULL);
																	_tmp35_ = _tmp34_;
																	vala_unresolved_type_set_unresolved_symbol (type, _tmp35_);
																	_vala_code_node_unref0 (_tmp35_);
																} else {
																	if (type_node->tag == TYPE_TAG_FLOAT) {
																		ValaUnresolvedSymbol* _tmp36_ = NULL;
																		ValaUnresolvedSymbol* _tmp37_;
																		_tmp36_ = vala_unresolved_symbol_new (NULL, "float", NULL);
																		_tmp37_ = _tmp36_;
																		vala_unresolved_type_set_unresolved_symbol (type, _tmp37_);
																		_vala_code_node_unref0 (_tmp37_);
																	} else {
																		if (type_node->tag == TYPE_TAG_DOUBLE) {
																			ValaUnresolvedSymbol* _tmp38_ = NULL;
																			ValaUnresolvedSymbol* _tmp39_;
																			_tmp38_ = vala_unresolved_symbol_new (NULL, "double", NULL);
																			_tmp39_ = _tmp38_;
																			vala_unresolved_type_set_unresolved_symbol (type, _tmp39_);
																			_vala_code_node_unref0 (_tmp39_);
																		} else {
																			if (type_node->tag == TYPE_TAG_UTF8) {
																				ValaUnresolvedSymbol* _tmp40_ = NULL;
																				ValaUnresolvedSymbol* _tmp41_;
																				_tmp40_ = vala_unresolved_symbol_new (NULL, "string", NULL);
																				_tmp41_ = _tmp40_;
																				vala_unresolved_type_set_unresolved_symbol (type, _tmp41_);
																				_vala_code_node_unref0 (_tmp41_);
																			} else {
																				if (type_node->tag == TYPE_TAG_FILENAME) {
																					ValaUnresolvedSymbol* _tmp42_ = NULL;
																					ValaUnresolvedSymbol* _tmp43_;
																					_tmp42_ = vala_unresolved_symbol_new (NULL, "string", NULL);
																					_tmp43_ = _tmp42_;
																					vala_unresolved_type_set_unresolved_symbol (type, _tmp43_);
																					_vala_code_node_unref0 (_tmp43_);
																				} else {
																					if (type_node->tag == TYPE_TAG_ARRAY) {
																						ValaDataType* _tmp44_ = NULL;
																						ValaDataType* element_type;
																						ValaDataType* _tmp45_;
																						ValaUnresolvedType* _tmp46_;
																						ValaUnresolvedType* _tmp47_;
																						ValaSourceReference* _tmp48_ = NULL;
																						ValaArrayType* _tmp49_ = NULL;
																						_tmp44_ = vala_gidl_parser_parse_type (self, type_node->parameter_type1, NULL);
																						element_type = _tmp44_;
																						_tmp46_ = _vala_code_node_ref0 ((_tmp45_ = element_type, VALA_IS_UNRESOLVED_TYPE (_tmp45_) ? ((ValaUnresolvedType*) _tmp45_) : NULL));
																						_tmp47_ = _tmp46_;
																						_vala_code_node_unref0 (type);
																						type = _tmp47_;
																						if (type == NULL) {
																							result = element_type;
																							_vala_code_node_unref0 (type);
																							if (direction) {
																								*direction = _direction;
																							}
																							return result;
																						}
																						_tmp48_ = vala_code_node_get_source_reference ((ValaCodeNode*) element_type);
																						_tmp49_ = vala_array_type_new (element_type, 1, _tmp48_);
																						result = (ValaDataType*) _tmp49_;
																						_vala_code_node_unref0 (element_type);
																						_vala_code_node_unref0 (type);
																						if (direction) {
																							*direction = _direction;
																						}
																						return result;
																					} else {
																						if (type_node->tag == TYPE_TAG_LIST) {
																							ValaUnresolvedSymbol* _tmp50_ = NULL;
																							ValaUnresolvedSymbol* _tmp51_;
																							ValaUnresolvedSymbol* _tmp52_ = NULL;
																							ValaUnresolvedSymbol* _tmp53_;
																							_tmp50_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
																							_tmp51_ = _tmp50_;
																							_tmp52_ = vala_unresolved_symbol_new (_tmp51_, "List", NULL);
																							_tmp53_ = _tmp52_;
																							vala_unresolved_type_set_unresolved_symbol (type, _tmp53_);
																							_vala_code_node_unref0 (_tmp53_);
																							_vala_code_node_unref0 (_tmp51_);
																						} else {
																							if (type_node->tag == TYPE_TAG_SLIST) {
																								ValaUnresolvedSymbol* _tmp54_ = NULL;
																								ValaUnresolvedSymbol* _tmp55_;
																								ValaUnresolvedSymbol* _tmp56_ = NULL;
																								ValaUnresolvedSymbol* _tmp57_;
																								_tmp54_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
																								_tmp55_ = _tmp54_;
																								_tmp56_ = vala_unresolved_symbol_new (_tmp55_, "SList", NULL);
																								_tmp57_ = _tmp56_;
																								vala_unresolved_type_set_unresolved_symbol (type, _tmp57_);
																								_vala_code_node_unref0 (_tmp57_);
																								_vala_code_node_unref0 (_tmp55_);
																							} else {
																								if (type_node->tag == TYPE_TAG_HASH) {
																									ValaUnresolvedSymbol* _tmp58_ = NULL;
																									ValaUnresolvedSymbol* _tmp59_;
																									ValaUnresolvedSymbol* _tmp60_ = NULL;
																									ValaUnresolvedSymbol* _tmp61_;
																									_tmp58_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
																									_tmp59_ = _tmp58_;
																									_tmp60_ = vala_unresolved_symbol_new (_tmp59_, "HashTable", NULL);
																									_tmp61_ = _tmp60_;
																									vala_unresolved_type_set_unresolved_symbol (type, _tmp61_);
																									_vala_code_node_unref0 (_tmp61_);
																									_vala_code_node_unref0 (_tmp59_);
																								} else {
																									if (type_node->tag == TYPE_TAG_ERROR) {
																										ValaUnresolvedSymbol* _tmp62_ = NULL;
																										ValaUnresolvedSymbol* _tmp63_;
																										ValaUnresolvedSymbol* _tmp64_ = NULL;
																										ValaUnresolvedSymbol* _tmp65_;
																										_tmp62_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
																										_tmp63_ = _tmp62_;
																										_tmp64_ = vala_unresolved_symbol_new (_tmp63_, "Error", NULL);
																										_tmp65_ = _tmp64_;
																										vala_unresolved_type_set_unresolved_symbol (type, _tmp65_);
																										_vala_code_node_unref0 (_tmp65_);
																										_vala_code_node_unref0 (_tmp63_);
																									} else {
																										if (type_node->is_interface) {
																											gchar* _tmp66_;
																											gchar* n;
																											gboolean _tmp67_;
																											gboolean _tmp71_ = FALSE;
																											_tmp66_ = g_strdup (type_node->interface);
																											n = _tmp66_;
																											if (g_strcmp0 (n, "") == 0) {
																												result = NULL;
																												_g_free0 (n);
																												_vala_code_node_unref0 (type);
																												if (direction) {
																													*direction = _direction;
																												}
																												return result;
																											}
																											_tmp67_ = g_str_has_prefix (n, "const-");
																											if (_tmp67_) {
																												gint _tmp68_;
																												gchar* _tmp69_ = NULL;
																												gchar* _tmp70_;
																												_tmp68_ = strlen ("const-");
																												_tmp69_ = string_substring (n, (glong) _tmp68_, (glong) (-1));
																												_tmp70_ = _tmp69_;
																												_g_free0 (n);
																												n = _tmp70_;
																											}
																											if (type_node->is_pointer) {
																												gboolean _tmp72_ = FALSE;
																												if (g_strcmp0 (n, "gchar") == 0) {
																													_tmp72_ = TRUE;
																												} else {
																													_tmp72_ = g_strcmp0 (n, "char") == 0;
																												}
																												_tmp71_ = _tmp72_;
																											} else {
																												_tmp71_ = FALSE;
																											}
																											if (_tmp71_) {
																												ValaUnresolvedSymbol* _tmp73_ = NULL;
																												ValaUnresolvedSymbol* _tmp74_;
																												gboolean _tmp75_;
																												_tmp73_ = vala_unresolved_symbol_new (NULL, "string", NULL);
																												_tmp74_ = _tmp73_;
																												vala_unresolved_type_set_unresolved_symbol (type, _tmp74_);
																												_vala_code_node_unref0 (_tmp74_);
																												_tmp75_ = g_str_has_suffix (type_node->unparsed, "**");
																												if (_tmp75_) {
																													dir = VALA_PARAMETER_DIRECTION_OUT;
																												}
																											} else {
																												if (g_strcmp0 (n, "gunichar") == 0) {
																													ValaUnresolvedSymbol* _tmp76_ = NULL;
																													ValaUnresolvedSymbol* _tmp77_;
																													_tmp76_ = vala_unresolved_symbol_new (NULL, "unichar", NULL);
																													_tmp77_ = _tmp76_;
																													vala_unresolved_type_set_unresolved_symbol (type, _tmp77_);
																													_vala_code_node_unref0 (_tmp77_);
																												} else {
																													if (g_strcmp0 (n, "gchar") == 0) {
																														ValaUnresolvedSymbol* _tmp78_ = NULL;
																														ValaUnresolvedSymbol* _tmp79_;
																														_tmp78_ = vala_unresolved_symbol_new (NULL, "char", NULL);
																														_tmp79_ = _tmp78_;
																														vala_unresolved_type_set_unresolved_symbol (type, _tmp79_);
																														_vala_code_node_unref0 (_tmp79_);
																													} else {
																														gboolean _tmp80_ = FALSE;
																														if (g_strcmp0 (n, "guchar") == 0) {
																															_tmp80_ = TRUE;
																														} else {
																															_tmp80_ = g_strcmp0 (n, "guint8") == 0;
																														}
																														if (_tmp80_) {
																															ValaUnresolvedSymbol* _tmp81_ = NULL;
																															ValaUnresolvedSymbol* _tmp82_;
																															_tmp81_ = vala_unresolved_symbol_new (NULL, "uchar", NULL);
																															_tmp82_ = _tmp81_;
																															vala_unresolved_type_set_unresolved_symbol (type, _tmp82_);
																															_vala_code_node_unref0 (_tmp82_);
																															if (type_node->is_pointer) {
																																ValaSourceReference* _tmp83_ = NULL;
																																ValaArrayType* _tmp84_ = NULL;
																																_tmp83_ = vala_code_node_get_source_reference ((ValaCodeNode*) type);
																																_tmp84_ = vala_array_type_new ((ValaDataType*) type, 1, _tmp83_);
																																result = (ValaDataType*) _tmp84_;
																																_g_free0 (n);
																																_vala_code_node_unref0 (type);
																																if (direction) {
																																	*direction = _direction;
																																}
																																return result;
																															}
																														} else {
																															if (g_strcmp0 (n, "gushort") == 0) {
																																ValaUnresolvedSymbol* _tmp85_ = NULL;
																																ValaUnresolvedSymbol* _tmp86_;
																																_tmp85_ = vala_unresolved_symbol_new (NULL, "ushort", NULL);
																																_tmp86_ = _tmp85_;
																																vala_unresolved_type_set_unresolved_symbol (type, _tmp86_);
																																_vala_code_node_unref0 (_tmp86_);
																															} else {
																																if (g_strcmp0 (n, "gshort") == 0) {
																																	ValaUnresolvedSymbol* _tmp87_ = NULL;
																																	ValaUnresolvedSymbol* _tmp88_;
																																	_tmp87_ = vala_unresolved_symbol_new (NULL, "short", NULL);
																																	_tmp88_ = _tmp87_;
																																	vala_unresolved_type_set_unresolved_symbol (type, _tmp88_);
																																	_vala_code_node_unref0 (_tmp88_);
																																} else {
																																	gboolean _tmp89_ = FALSE;
																																	if (g_strcmp0 (n, "gconstpointer") == 0) {
																																		_tmp89_ = TRUE;
																																	} else {
																																		_tmp89_ = g_strcmp0 (n, "void") == 0;
																																	}
																																	if (_tmp89_) {
																																		ValaVoidType* _tmp90_ = NULL;
																																		ValaVoidType* _tmp91_;
																																		ValaPointerType* _tmp92_ = NULL;
																																		ValaDataType* _tmp93_;
																																		_tmp90_ = vala_void_type_new (NULL);
																																		_tmp91_ = _tmp90_;
																																		_tmp92_ = vala_pointer_type_new ((ValaDataType*) _tmp91_, NULL);
																																		result = (_tmp93_ = (ValaDataType*) _tmp92_, _vala_code_node_unref0 (_tmp91_), _tmp93_);
																																		_g_free0 (n);
																																		_vala_code_node_unref0 (type);
																																		if (direction) {
																																			*direction = _direction;
																																		}
																																		return result;
																																	} else {
																																		gboolean _tmp94_ = FALSE;
																																		if (g_strcmp0 (n, "goffset") == 0) {
																																			_tmp94_ = TRUE;
																																		} else {
																																			_tmp94_ = g_strcmp0 (n, "off_t") == 0;
																																		}
																																		if (_tmp94_) {
																																			ValaUnresolvedSymbol* _tmp95_ = NULL;
																																			ValaUnresolvedSymbol* _tmp96_;
																																			_tmp95_ = vala_unresolved_symbol_new (NULL, "int64", NULL);
																																			_tmp96_ = _tmp95_;
																																			vala_unresolved_type_set_unresolved_symbol (type, _tmp96_);
																																			_vala_code_node_unref0 (_tmp96_);
																																		} else {
																																			if (g_strcmp0 (n, "value_array") == 0) {
																																				ValaUnresolvedSymbol* _tmp97_ = NULL;
																																				ValaUnresolvedSymbol* _tmp98_;
																																				ValaUnresolvedSymbol* _tmp99_ = NULL;
																																				ValaUnresolvedSymbol* _tmp100_;
																																				_tmp97_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
																																				_tmp98_ = _tmp97_;
																																				_tmp99_ = vala_unresolved_symbol_new (_tmp98_, "ValueArray", NULL);
																																				_tmp100_ = _tmp99_;
																																				vala_unresolved_type_set_unresolved_symbol (type, _tmp100_);
																																				_vala_code_node_unref0 (_tmp100_);
																																				_vala_code_node_unref0 (_tmp98_);
																																			} else {
																																				if (g_strcmp0 (n, "time_t") == 0) {
																																					ValaUnresolvedSymbol* _tmp101_ = NULL;
																																					ValaUnresolvedSymbol* _tmp102_;
																																					_tmp101_ = vala_unresolved_symbol_new (NULL, "ulong", NULL);
																																					_tmp102_ = _tmp101_;
																																					vala_unresolved_type_set_unresolved_symbol (type, _tmp102_);
																																					_vala_code_node_unref0 (_tmp102_);
																																				} else {
																																					if (g_strcmp0 (n, "socklen_t") == 0) {
																																						ValaUnresolvedSymbol* _tmp103_ = NULL;
																																						ValaUnresolvedSymbol* _tmp104_;
																																						_tmp103_ = vala_unresolved_symbol_new (NULL, "uint32", NULL);
																																						_tmp104_ = _tmp103_;
																																						vala_unresolved_type_set_unresolved_symbol (type, _tmp104_);
																																						_vala_code_node_unref0 (_tmp104_);
																																					} else {
																																						if (g_strcmp0 (n, "mode_t") == 0) {
																																							ValaUnresolvedSymbol* _tmp105_ = NULL;
																																							ValaUnresolvedSymbol* _tmp106_;
																																							_tmp105_ = vala_unresolved_symbol_new (NULL, "uint", NULL);
																																							_tmp106_ = _tmp105_;
																																							vala_unresolved_type_set_unresolved_symbol (type, _tmp106_);
																																							_vala_code_node_unref0 (_tmp106_);
																																						} else {
																																							gboolean _tmp107_ = FALSE;
																																							if (g_strcmp0 (n, "gint") == 0) {
																																								_tmp107_ = TRUE;
																																							} else {
																																								_tmp107_ = g_strcmp0 (n, "pid_t") == 0;
																																							}
																																							if (_tmp107_) {
																																								ValaUnresolvedSymbol* _tmp108_ = NULL;
																																								ValaUnresolvedSymbol* _tmp109_;
																																								_tmp108_ = vala_unresolved_symbol_new (NULL, "int", NULL);
																																								_tmp109_ = _tmp108_;
																																								vala_unresolved_type_set_unresolved_symbol (type, _tmp109_);
																																								_vala_code_node_unref0 (_tmp109_);
																																							} else {
																																								gboolean _tmp110_ = FALSE;
																																								if (g_strcmp0 (n, "unsigned") == 0) {
																																									_tmp110_ = TRUE;
																																								} else {
																																									_tmp110_ = g_strcmp0 (n, "unsigned-int") == 0;
																																								}
																																								if (_tmp110_) {
																																									ValaUnresolvedSymbol* _tmp111_ = NULL;
																																									ValaUnresolvedSymbol* _tmp112_;
																																									_tmp111_ = vala_unresolved_symbol_new (NULL, "uint", NULL);
																																									_tmp112_ = _tmp111_;
																																									vala_unresolved_type_set_unresolved_symbol (type, _tmp112_);
																																									_vala_code_node_unref0 (_tmp112_);
																																								} else {
																																									if (g_strcmp0 (n, "FILE") == 0) {
																																										ValaUnresolvedSymbol* _tmp113_ = NULL;
																																										ValaUnresolvedSymbol* _tmp114_;
																																										ValaUnresolvedSymbol* _tmp115_ = NULL;
																																										ValaUnresolvedSymbol* _tmp116_;
																																										_tmp113_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
																																										_tmp114_ = _tmp113_;
																																										_tmp115_ = vala_unresolved_symbol_new (_tmp114_, "FileStream", NULL);
																																										_tmp116_ = _tmp115_;
																																										vala_unresolved_type_set_unresolved_symbol (type, _tmp116_);
																																										_vala_code_node_unref0 (_tmp116_);
																																										_vala_code_node_unref0 (_tmp114_);
																																									} else {
																																										if (g_strcmp0 (n, "struct") == 0) {
																																											ValaVoidType* _tmp117_ = NULL;
																																											ValaVoidType* _tmp118_;
																																											ValaPointerType* _tmp119_ = NULL;
																																											ValaDataType* _tmp120_;
																																											_tmp117_ = vala_void_type_new (NULL);
																																											_tmp118_ = _tmp117_;
																																											_tmp119_ = vala_pointer_type_new ((ValaDataType*) _tmp118_, NULL);
																																											result = (_tmp120_ = (ValaDataType*) _tmp119_, _vala_code_node_unref0 (_tmp118_), _tmp120_);
																																											_g_free0 (n);
																																											_vala_code_node_unref0 (type);
																																											if (direction) {
																																												*direction = _direction;
																																											}
																																											return result;
																																										} else {
																																											if (g_strcmp0 (n, "iconv_t") == 0) {
																																												ValaVoidType* _tmp121_ = NULL;
																																												ValaVoidType* _tmp122_;
																																												ValaPointerType* _tmp123_ = NULL;
																																												ValaDataType* _tmp124_;
																																												_tmp121_ = vala_void_type_new (NULL);
																																												_tmp122_ = _tmp121_;
																																												_tmp123_ = vala_pointer_type_new ((ValaDataType*) _tmp122_, NULL);
																																												result = (_tmp124_ = (ValaDataType*) _tmp123_, _vala_code_node_unref0 (_tmp122_), _tmp124_);
																																												_g_free0 (n);
																																												_vala_code_node_unref0 (type);
																																												if (direction) {
																																													*direction = _direction;
																																												}
																																												return result;
																																											} else {
																																												if (g_strcmp0 (n, "GType") == 0) {
																																													ValaUnresolvedSymbol* _tmp125_ = NULL;
																																													ValaUnresolvedSymbol* _tmp126_;
																																													ValaUnresolvedSymbol* _tmp127_ = NULL;
																																													ValaUnresolvedSymbol* _tmp128_;
																																													_tmp125_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
																																													_tmp126_ = _tmp125_;
																																													_tmp127_ = vala_unresolved_symbol_new (_tmp126_, "Type", NULL);
																																													_tmp128_ = _tmp127_;
																																													vala_unresolved_type_set_unresolved_symbol (type, _tmp128_);
																																													_vala_code_node_unref0 (_tmp128_);
																																													_vala_code_node_unref0 (_tmp126_);
																																													if (type_node->is_pointer) {
																																														ValaSourceReference* _tmp129_ = NULL;
																																														ValaArrayType* _tmp130_ = NULL;
																																														_tmp129_ = vala_code_node_get_source_reference ((ValaCodeNode*) type);
																																														_tmp130_ = vala_array_type_new ((ValaDataType*) type, 1, _tmp129_);
																																														result = (ValaDataType*) _tmp130_;
																																														_g_free0 (n);
																																														_vala_code_node_unref0 (type);
																																														if (direction) {
																																															*direction = _direction;
																																														}
																																														return result;
																																													}
																																												} else {
																																													if (g_strcmp0 (n, "GStrv") == 0) {
																																														ValaUnresolvedSymbol* _tmp131_ = NULL;
																																														ValaUnresolvedSymbol* _tmp132_;
																																														ValaSourceReference* _tmp133_ = NULL;
																																														ValaArrayType* _tmp134_ = NULL;
																																														_tmp131_ = vala_unresolved_symbol_new (NULL, "string", NULL);
																																														_tmp132_ = _tmp131_;
																																														vala_unresolved_type_set_unresolved_symbol (type, _tmp132_);
																																														_vala_code_node_unref0 (_tmp132_);
																																														_tmp133_ = vala_code_node_get_source_reference ((ValaCodeNode*) type);
																																														_tmp134_ = vala_array_type_new ((ValaDataType*) type, 1, _tmp133_);
																																														result = (ValaDataType*) _tmp134_;
																																														_g_free0 (n);
																																														_vala_code_node_unref0 (type);
																																														if (direction) {
																																															*direction = _direction;
																																														}
																																														return result;
																																													} else {
																																														ValaDataType* _tmp135_ = NULL;
																																														ValaDataType* named_type;
																																														ValaDataType* _tmp136_;
																																														ValaUnresolvedType* _tmp137_;
																																														ValaUnresolvedType* _tmp138_;
																																														gboolean _tmp139_;
																																														_tmp135_ = vala_gidl_parser_parse_type_string (self, n);
																																														named_type = _tmp135_;
																																														_tmp137_ = _vala_code_node_ref0 ((_tmp136_ = named_type, VALA_IS_UNRESOLVED_TYPE (_tmp136_) ? ((ValaUnresolvedType*) _tmp136_) : NULL));
																																														_tmp138_ = _tmp137_;
																																														_vala_code_node_unref0 (type);
																																														type = _tmp138_;
																																														if (type == NULL) {
																																															result = named_type;
																																															_g_free0 (n);
																																															_vala_code_node_unref0 (type);
																																															if (direction) {
																																																*direction = _direction;
																																															}
																																															return result;
																																														}
																																														_tmp139_ = vala_gidl_parser_is_simple_type (self, n);
																																														if (_tmp139_) {
																																															if (type_node->is_pointer) {
																																																dir = VALA_PARAMETER_DIRECTION_OUT;
																																															}
																																														} else {
																																															gboolean _tmp140_;
																																															_tmp140_ = g_str_has_suffix (type_node->unparsed, "**");
																																															if (_tmp140_) {
																																																dir = VALA_PARAMETER_DIRECTION_OUT;
																																															}
																																														}
																																														_vala_code_node_unref0 (named_type);
																																													}
																																												}
																																											}
																																										}
																																									}
																																								}
																																							}
																																						}
																																					}
																																				}
																																			}
																																		}
																																	}
																																}
																															}
																														}
																													}
																												}
																											}
																											_g_free0 (n);
																										} else {
																											fprintf (stdout, "%d\n", (gint) type_node->tag);
																										}
																									}
																								}
																							}
																						}
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	if ((&_direction) != NULL) {
		_direction = dir;
	}
	result = (ValaDataType*) type;
	if (direction) {
		*direction = _direction;
	}
	return result;
}


static gboolean vala_gidl_parser_is_simple_type (ValaGIdlParser* self, const gchar* type_name) {
	gboolean result = FALSE;
	gpointer _tmp0_ = NULL;
	ValaTypeSymbol* _tmp1_;
	ValaStruct* st;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type_name != NULL, FALSE);
	_tmp0_ = vala_map_get (self->priv->cname_type_map, type_name);
	st = (_tmp1_ = (ValaTypeSymbol*) _tmp0_, VALA_IS_STRUCT (_tmp1_) ? ((ValaStruct*) _tmp1_) : NULL);
	if (st != NULL) {
		gboolean _tmp3_;
		_tmp3_ = vala_struct_is_simple_type (st);
		_tmp2_ = _tmp3_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		result = TRUE;
		_vala_code_node_unref0 (st);
		return result;
	}
	result = FALSE;
	_vala_code_node_unref0 (st);
	return result;
}


static ValaDataType* vala_gidl_parser_parse_type_string (ValaGIdlParser* self, const gchar* n) {
	ValaDataType* result = NULL;
	ValaUnresolvedType* _tmp4_ = NULL;
	ValaUnresolvedType* type;
	gpointer _tmp5_ = NULL;
	ValaTypeSymbol* dt;
	gint _tmp15_;
	gchar** _tmp16_ = NULL;
	gint type_attributes_length1;
	gint _type_attributes_size_;
	gchar** _tmp17_;
	gchar** type_attributes;
	gchar* ns_name;
	ValaUnresolvedSymbol* _tmp39_ = NULL;
	const gchar* _tmp49_ = NULL;
	gboolean _tmp50_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (n != NULL, NULL);
	if (g_strcmp0 (n, "va_list") == 0) {
		ValaVoidType* _tmp0_ = NULL;
		ValaVoidType* _tmp1_;
		ValaPointerType* _tmp2_ = NULL;
		ValaDataType* _tmp3_;
		_tmp0_ = vala_void_type_new (NULL);
		_tmp1_ = _tmp0_;
		_tmp2_ = vala_pointer_type_new ((ValaDataType*) _tmp1_, NULL);
		result = (_tmp3_ = (ValaDataType*) _tmp2_, _vala_code_node_unref0 (_tmp1_), _tmp3_);
		return result;
	}
	_tmp4_ = vala_unresolved_type_new ();
	type = _tmp4_;
	_tmp5_ = vala_map_get (self->priv->cname_type_map, n);
	dt = (ValaTypeSymbol*) _tmp5_;
	if (dt != NULL) {
		ValaUnresolvedSymbol* parent_symbol;
		ValaSymbol* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp12_ = NULL;
		ValaUnresolvedSymbol* _tmp13_ = NULL;
		ValaUnresolvedSymbol* _tmp14_;
		parent_symbol = NULL;
		_tmp6_ = vala_symbol_get_parent_symbol ((ValaSymbol*) dt);
		_tmp7_ = vala_symbol_get_name (_tmp6_);
		if (_tmp7_ != NULL) {
			ValaSymbol* _tmp8_ = NULL;
			const gchar* _tmp9_ = NULL;
			ValaUnresolvedSymbol* _tmp10_ = NULL;
			ValaUnresolvedSymbol* _tmp11_;
			_tmp8_ = vala_symbol_get_parent_symbol ((ValaSymbol*) dt);
			_tmp9_ = vala_symbol_get_name (_tmp8_);
			_tmp10_ = vala_unresolved_symbol_new (NULL, _tmp9_, NULL);
			_tmp11_ = _tmp10_;
			_vala_code_node_unref0 (parent_symbol);
			parent_symbol = _tmp11_;
		}
		_tmp12_ = vala_symbol_get_name ((ValaSymbol*) dt);
		_tmp13_ = vala_unresolved_symbol_new (parent_symbol, _tmp12_, NULL);
		_tmp14_ = _tmp13_;
		vala_unresolved_type_set_unresolved_symbol (type, _tmp14_);
		_vala_code_node_unref0 (_tmp14_);
		result = (ValaDataType*) type;
		_vala_code_node_unref0 (parent_symbol);
		_vala_code_node_unref0 (dt);
		return result;
	}
	_tmp16_ = vala_gidl_parser_get_attributes (self, n, &_tmp15_);
	_tmp17_ = _tmp16_;
	type_attributes_length1 = _tmp15_;
	_type_attributes_size_ = type_attributes_length1;
	type_attributes = _tmp17_;
	ns_name = NULL;
	if (NULL != type_attributes) {
		{
			gchar** attr_collection;
			int attr_collection_length1;
			int attr_it;
			attr_collection = type_attributes;
			attr_collection_length1 = type_attributes_length1;
			for (attr_it = 0; attr_it < type_attributes_length1; attr_it = attr_it + 1) {
				gchar* _tmp18_;
				gchar* attr;
				_tmp18_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp18_;
				{
					gchar** _tmp19_;
					gchar** _tmp20_ = NULL;
					gint nv_length1;
					gint _nv_size_;
					gchar** _tmp21_;
					gchar** nv;
					_tmp20_ = _tmp19_ = g_strsplit (attr, "=", 2);
					_tmp21_ = _tmp20_;
					nv_length1 = _vala_array_length (_tmp19_);
					_nv_size_ = nv_length1;
					nv = _tmp21_;
					if (g_strcmp0 (nv[0], "cprefix") == 0) {
						gchar* _tmp22_ = NULL;
						gchar* _tmp23_;
						gint _tmp24_;
						gchar* _tmp25_ = NULL;
						gchar* _tmp26_;
						ValaUnresolvedSymbol* _tmp27_ = NULL;
						ValaUnresolvedSymbol* _tmp28_;
						_tmp22_ = vala_gidl_parser_eval (self, nv[1]);
						_tmp23_ = _tmp22_;
						_tmp24_ = strlen (_tmp23_);
						_tmp25_ = string_substring (n, (glong) _tmp24_, (glong) (-1));
						_tmp26_ = _tmp25_;
						_tmp27_ = vala_unresolved_symbol_new (NULL, _tmp26_, NULL);
						_tmp28_ = _tmp27_;
						vala_unresolved_type_set_unresolved_symbol (type, _tmp28_);
						_vala_code_node_unref0 (_tmp28_);
						_g_free0 (_tmp26_);
						_g_free0 (_tmp23_);
					} else {
						if (g_strcmp0 (nv[0], "name") == 0) {
							gchar* _tmp29_ = NULL;
							gchar* _tmp30_;
							ValaUnresolvedSymbol* _tmp31_ = NULL;
							ValaUnresolvedSymbol* _tmp32_;
							_tmp29_ = vala_gidl_parser_eval (self, nv[1]);
							_tmp30_ = _tmp29_;
							_tmp31_ = vala_unresolved_symbol_new (NULL, _tmp30_, NULL);
							_tmp32_ = _tmp31_;
							vala_unresolved_type_set_unresolved_symbol (type, _tmp32_);
							_vala_code_node_unref0 (_tmp32_);
							_g_free0 (_tmp30_);
						} else {
							if (g_strcmp0 (nv[0], "namespace") == 0) {
								gchar* _tmp33_ = NULL;
								gchar* _tmp34_;
								_tmp33_ = vala_gidl_parser_eval (self, nv[1]);
								_tmp34_ = _tmp33_;
								_g_free0 (ns_name);
								ns_name = _tmp34_;
							} else {
								if (g_strcmp0 (nv[0], "rename_to") == 0) {
									gchar* _tmp35_ = NULL;
									gchar* _tmp36_;
									ValaUnresolvedSymbol* _tmp37_ = NULL;
									ValaUnresolvedSymbol* _tmp38_;
									_tmp35_ = vala_gidl_parser_eval (self, nv[1]);
									_tmp36_ = _tmp35_;
									_tmp37_ = vala_unresolved_symbol_new (NULL, _tmp36_, NULL);
									_tmp38_ = _tmp37_;
									vala_unresolved_type_set_unresolved_symbol (type, _tmp38_);
									_vala_code_node_unref0 (_tmp38_);
									_g_free0 (_tmp36_);
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	_tmp39_ = vala_unresolved_type_get_unresolved_symbol (type);
	if (_tmp39_ != NULL) {
		ValaUnresolvedSymbol* _tmp40_ = NULL;
		const gchar* _tmp41_ = NULL;
		_tmp40_ = vala_unresolved_type_get_unresolved_symbol (type);
		_tmp41_ = vala_symbol_get_name ((ValaSymbol*) _tmp40_);
		if (g_strcmp0 (_tmp41_, "pointer") == 0) {
			ValaVoidType* _tmp42_ = NULL;
			ValaVoidType* _tmp43_;
			ValaPointerType* _tmp44_ = NULL;
			ValaDataType* _tmp45_;
			_tmp42_ = vala_void_type_new (NULL);
			_tmp43_ = _tmp42_;
			_tmp44_ = vala_pointer_type_new ((ValaDataType*) _tmp43_, NULL);
			result = (_tmp45_ = (ValaDataType*) _tmp44_, _vala_code_node_unref0 (_tmp43_), _tmp45_);
			_g_free0 (ns_name);
			type_attributes = (_vala_array_free (type_attributes, type_attributes_length1, (GDestroyNotify) g_free), NULL);
			_vala_code_node_unref0 (dt);
			_vala_code_node_unref0 (type);
			return result;
		}
		if (ns_name != NULL) {
			ValaUnresolvedSymbol* _tmp46_ = NULL;
			ValaUnresolvedSymbol* _tmp47_ = NULL;
			ValaUnresolvedSymbol* _tmp48_;
			_tmp46_ = vala_unresolved_type_get_unresolved_symbol (type);
			_tmp47_ = vala_unresolved_symbol_new (NULL, ns_name, NULL);
			_tmp48_ = _tmp47_;
			vala_unresolved_symbol_set_inner (_tmp46_, _tmp48_);
			_vala_code_node_unref0 (_tmp48_);
		}
		result = (ValaDataType*) type;
		_g_free0 (ns_name);
		type_attributes = (_vala_array_free (type_attributes, type_attributes_length1, (GDestroyNotify) g_free), NULL);
		_vala_code_node_unref0 (dt);
		return result;
	}
	_tmp49_ = vala_symbol_get_name ((ValaSymbol*) self->priv->current_namespace);
	_tmp50_ = g_str_has_prefix (n, _tmp49_);
	if (_tmp50_) {
		const gchar* _tmp51_ = NULL;
		ValaUnresolvedSymbol* _tmp52_ = NULL;
		ValaUnresolvedSymbol* _tmp53_;
		const gchar* _tmp54_ = NULL;
		gint _tmp55_;
		gchar* _tmp56_ = NULL;
		gchar* _tmp57_;
		ValaUnresolvedSymbol* _tmp58_ = NULL;
		ValaUnresolvedSymbol* _tmp59_;
		_tmp51_ = vala_symbol_get_name ((ValaSymbol*) self->priv->current_namespace);
		_tmp52_ = vala_unresolved_symbol_new (NULL, _tmp51_, NULL);
		_tmp53_ = _tmp52_;
		_tmp54_ = vala_symbol_get_name ((ValaSymbol*) self->priv->current_namespace);
		_tmp55_ = strlen (_tmp54_);
		_tmp56_ = string_substring (n, (glong) _tmp55_, (glong) (-1));
		_tmp57_ = _tmp56_;
		_tmp58_ = vala_unresolved_symbol_new (_tmp53_, _tmp57_, NULL);
		_tmp59_ = _tmp58_;
		vala_unresolved_type_set_unresolved_symbol (type, _tmp59_);
		_vala_code_node_unref0 (_tmp59_);
		_g_free0 (_tmp57_);
		_vala_code_node_unref0 (_tmp53_);
	} else {
		gboolean _tmp60_;
		_tmp60_ = g_str_has_prefix (n, "G");
		if (_tmp60_) {
			ValaUnresolvedSymbol* _tmp61_ = NULL;
			ValaUnresolvedSymbol* _tmp62_;
			gchar* _tmp63_ = NULL;
			gchar* _tmp64_;
			ValaUnresolvedSymbol* _tmp65_ = NULL;
			ValaUnresolvedSymbol* _tmp66_;
			_tmp61_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
			_tmp62_ = _tmp61_;
			_tmp63_ = string_substring (n, (glong) 1, (glong) (-1));
			_tmp64_ = _tmp63_;
			_tmp65_ = vala_unresolved_symbol_new (_tmp62_, _tmp64_, NULL);
			_tmp66_ = _tmp65_;
			vala_unresolved_type_set_unresolved_symbol (type, _tmp66_);
			_vala_code_node_unref0 (_tmp66_);
			_g_free0 (_tmp64_);
			_vala_code_node_unref0 (_tmp62_);
		} else {
			gchar** _tmp67_;
			gchar** _tmp68_ = NULL;
			gint name_parts_length1;
			gint _name_parts_size_;
			gchar** _tmp69_;
			gchar** name_parts;
			_tmp68_ = _tmp67_ = g_strsplit (n, ".", 2);
			_tmp69_ = _tmp68_;
			name_parts_length1 = _vala_array_length (_tmp67_);
			_name_parts_size_ = name_parts_length1;
			name_parts = _tmp69_;
			if (name_parts[1] == NULL) {
				ValaUnresolvedSymbol* _tmp70_ = NULL;
				ValaUnresolvedSymbol* _tmp71_;
				_tmp70_ = vala_unresolved_symbol_new (NULL, name_parts[0], NULL);
				_tmp71_ = _tmp70_;
				vala_unresolved_type_set_unresolved_symbol (type, _tmp71_);
				_vala_code_node_unref0 (_tmp71_);
			} else {
				ValaUnresolvedSymbol* _tmp72_ = NULL;
				ValaUnresolvedSymbol* _tmp73_;
				ValaUnresolvedSymbol* _tmp74_ = NULL;
				ValaUnresolvedSymbol* _tmp75_;
				_tmp72_ = vala_unresolved_symbol_new (NULL, name_parts[0], NULL);
				_tmp73_ = _tmp72_;
				_tmp74_ = vala_unresolved_symbol_new (_tmp73_, name_parts[1], NULL);
				_tmp75_ = _tmp74_;
				vala_unresolved_type_set_unresolved_symbol (type, _tmp75_);
				_vala_code_node_unref0 (_tmp75_);
				_vala_code_node_unref0 (_tmp73_);
			}
			name_parts = (_vala_array_free (name_parts, name_parts_length1, (GDestroyNotify) g_free), NULL);
		}
	}
	result = (ValaDataType*) type;
	_g_free0 (ns_name);
	type_attributes = (_vala_array_free (type_attributes, type_attributes_length1, (GDestroyNotify) g_free), NULL);
	_vala_code_node_unref0 (dt);
	return result;
}


static ValaDataType* vala_gidl_parser_parse_param (ValaGIdlParser* self, GIdlNodeParam* param, ValaParameterDirection* direction) {
	ValaParameterDirection _direction = 0;
	ValaDataType* result = NULL;
	ValaParameterDirection _tmp0_;
	ValaDataType* _tmp1_ = NULL;
	ValaDataType* type;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (param != NULL, NULL);
	_tmp1_ = vala_gidl_parser_parse_type (self, param->type, &_tmp0_);
	_direction = _tmp0_;
	type = _tmp1_;
	result = type;
	if (direction) {
		*direction = _direction;
	}
	return result;
}


static ValaUnresolvedSymbol* vala_gidl_parser_parse_symbol_from_string (ValaGIdlParser* self, const gchar* symbol_string, ValaSourceReference* source_reference) {
	ValaUnresolvedSymbol* result = NULL;
	ValaUnresolvedSymbol* sym;
	gchar** _tmp0_;
	gchar** _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (symbol_string != NULL, NULL);
	sym = NULL;
	_tmp1_ = _tmp0_ = g_strsplit (symbol_string, ".", 0);
	{
		gchar** s_collection;
		int s_collection_length1;
		int s_it;
		s_collection = _tmp1_;
		s_collection_length1 = _vala_array_length (_tmp0_);
		for (s_it = 0; s_it < _vala_array_length (_tmp0_); s_it = s_it + 1) {
			const gchar* s;
			s = s_collection[s_it];
			{
				ValaUnresolvedSymbol* _tmp2_ = NULL;
				ValaUnresolvedSymbol* _tmp3_;
				_tmp2_ = vala_unresolved_symbol_new (sym, s, source_reference);
				_tmp3_ = _tmp2_;
				_vala_code_node_unref0 (sym);
				sym = _tmp3_;
			}
		}
		s_collection = (_vala_array_free (s_collection, s_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	if (sym == NULL) {
		vala_report_error (source_reference, "a symbol must be specified");
	}
	result = sym;
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	result = ((gchar*) self)[index];
	return result;
}


static gboolean vala_gidl_parser_parse_type_arguments_from_string (ValaGIdlParser* self, ValaDataType* parent_type, const gchar* type_arguments, ValaSourceReference* source_reference) {
	gboolean result = FALSE;
	gint _tmp0_;
	gint type_arguments_length;
	GString* _tmp1_ = NULL;
	GString* current;
	gint depth;
	ValaDataType* _tmp15_ = NULL;
	ValaDataType* dt;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (parent_type != NULL, FALSE);
	g_return_val_if_fail (type_arguments != NULL, FALSE);
	_tmp0_ = strlen (type_arguments);
	type_arguments_length = (gint) _tmp0_;
	_tmp1_ = g_string_sized_new ((gsize) type_arguments_length);
	current = _tmp1_;
	depth = 0;
	{
		gint c;
		c = 0;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_ = FALSE;
				gchar _tmp4_;
				if (!_tmp2_) {
					c++;
				}
				_tmp2_ = FALSE;
				if (!(c < type_arguments_length)) {
					break;
				}
				_tmp4_ = string_get (type_arguments, (glong) c);
				if (_tmp4_ == '<') {
					_tmp3_ = TRUE;
				} else {
					gchar _tmp5_;
					_tmp5_ = string_get (type_arguments, (glong) c);
					_tmp3_ = _tmp5_ == '[';
				}
				if (_tmp3_) {
					gchar _tmp6_;
					depth++;
					_tmp6_ = string_get (type_arguments, (glong) c);
					g_string_append_unichar (current, (gunichar) _tmp6_);
				} else {
					gboolean _tmp7_ = FALSE;
					gchar _tmp8_;
					_tmp8_ = string_get (type_arguments, (glong) c);
					if (_tmp8_ == '>') {
						_tmp7_ = TRUE;
					} else {
						gchar _tmp9_;
						_tmp9_ = string_get (type_arguments, (glong) c);
						_tmp7_ = _tmp9_ == ']';
					}
					if (_tmp7_) {
						gchar _tmp10_;
						depth--;
						_tmp10_ = string_get (type_arguments, (glong) c);
						g_string_append_unichar (current, (gunichar) _tmp10_);
					} else {
						gchar _tmp11_;
						_tmp11_ = string_get (type_arguments, (glong) c);
						if (_tmp11_ == ',') {
							if (depth == 0) {
								ValaDataType* _tmp12_ = NULL;
								ValaDataType* dt;
								_tmp12_ = vala_gidl_parser_parse_type_from_string (self, current->str, TRUE, source_reference);
								dt = _tmp12_;
								if (dt == NULL) {
									result = FALSE;
									_vala_code_node_unref0 (dt);
									_g_string_free0 (current);
									return result;
								}
								vala_data_type_add_type_argument (parent_type, dt);
								g_string_truncate (current, (gsize) 0);
								_vala_code_node_unref0 (dt);
							} else {
								gchar _tmp13_;
								_tmp13_ = string_get (type_arguments, (glong) c);
								g_string_append_unichar (current, (gunichar) _tmp13_);
							}
						} else {
							gchar _tmp14_;
							_tmp14_ = string_get (type_arguments, (glong) c);
							g_string_append_unichar (current, (gunichar) _tmp14_);
						}
					}
				}
			}
		}
	}
	_tmp15_ = vala_gidl_parser_parse_type_from_string (self, current->str, TRUE, source_reference);
	dt = _tmp15_;
	if (dt == NULL) {
		result = FALSE;
		_vala_code_node_unref0 (dt);
		_g_string_free0 (current);
		return result;
	}
	vala_data_type_add_type_argument (parent_type, dt);
	result = TRUE;
	_vala_code_node_unref0 (dt);
	_g_string_free0 (current);
	return result;
}


static ValaDataType* vala_gidl_parser_parse_type_from_string (ValaGIdlParser* self, const gchar* type_string, gboolean owned_by_default, ValaSourceReference* source_reference) {
	ValaDataType* result = NULL;
	GMatchInfo* match;
	GMatchInfo* _tmp3_ = NULL;
	gboolean _tmp4_;
	ValaDataType* type;
	gchar* _tmp5_ = NULL;
	gchar* ownership_data;
	gchar* _tmp6_ = NULL;
	gchar* type_name;
	gchar* _tmp7_ = NULL;
	gchar* type_arguments_data;
	gchar* _tmp8_ = NULL;
	gchar* pointers_data;
	gchar* _tmp9_ = NULL;
	gchar* array_data;
	gchar* _tmp10_ = NULL;
	gchar* nullable_data;
	gboolean _tmp11_ = FALSE;
	gboolean nullable;
	gboolean _tmp13_ = FALSE;
	gboolean value_owned;
	ValaUnresolvedSymbol* _tmp21_ = NULL;
	ValaUnresolvedSymbol* sym;
	ValaUnresolvedType* _tmp22_ = NULL;
	ValaDataType* _tmp23_;
	gboolean _tmp24_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type_string != NULL, NULL);
	if (vala_gidl_parser_type_from_string_regex == NULL) {
		GRegex* _tmp0_ = NULL;
		GRegex* _tmp1_;
		GRegex* _tmp2_;
		_tmp0_ = g_regex_new ("^(?:(owned|unowned|weak) +)?([0-9a-zA-Z_\\.]+)(?:<(.+)>)?(\\*+)?(\\[(," \
"*)?\\])?(\\?)?$", (G_REGEX_ANCHORED | G_REGEX_DOLLAR_ENDONLY) | G_REGEX_OPTIMIZE, 0, &_inner_error_);
		_tmp1_ = _tmp0_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch2_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp2_ = _tmp1_;
		_g_regex_unref0 (vala_gidl_parser_type_from_string_regex);
		vala_gidl_parser_type_from_string_regex = _tmp2_;
		goto __finally2;
		__catch2_g_regex_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			g_error ("valagidlparser.vala:1851: Unable to compile regex: %s", e->message);
			_g_error_free0 (e);
		}
		__finally2:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	match = NULL;
	_tmp4_ = g_regex_match (vala_gidl_parser_type_from_string_regex, type_string, 0, &_tmp3_);
	_g_match_info_free0 (match);
	match = _tmp3_;
	if (!_tmp4_) {
		vala_report_error (source_reference, "unable to parse type");
		result = NULL;
		_g_match_info_free0 (match);
		return result;
	}
	type = NULL;
	_tmp5_ = g_match_info_fetch (match, 1);
	ownership_data = _tmp5_;
	_tmp6_ = g_match_info_fetch (match, 2);
	type_name = _tmp6_;
	_tmp7_ = g_match_info_fetch (match, 3);
	type_arguments_data = _tmp7_;
	_tmp8_ = g_match_info_fetch (match, 4);
	pointers_data = _tmp8_;
	_tmp9_ = g_match_info_fetch (match, 5);
	array_data = _tmp9_;
	_tmp10_ = g_match_info_fetch (match, 6);
	nullable_data = _tmp10_;
	if (nullable_data != NULL) {
		gint _tmp12_;
		_tmp12_ = strlen (nullable_data);
		_tmp11_ = _tmp12_ > 0;
	} else {
		_tmp11_ = FALSE;
	}
	nullable = _tmp11_;
	if (ownership_data == NULL) {
		_tmp13_ = g_strcmp0 (type_name, "void") == 0;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		gboolean _tmp14_ = FALSE;
		if (array_data == NULL) {
			_tmp14_ = !nullable;
		} else {
			_tmp14_ = FALSE;
		}
		if (_tmp14_) {
			ValaVoidType* _tmp15_ = NULL;
			ValaDataType* _tmp16_;
			_tmp15_ = vala_void_type_new (source_reference);
			_tmp16_ = (ValaDataType*) _tmp15_;
			_vala_code_node_unref0 (type);
			type = _tmp16_;
			if (pointers_data != NULL) {
				{
					gint i;
					i = 0;
					{
						gboolean _tmp17_;
						_tmp17_ = TRUE;
						while (TRUE) {
							gint _tmp18_;
							ValaPointerType* _tmp19_ = NULL;
							ValaDataType* _tmp20_;
							if (!_tmp17_) {
								i++;
							}
							_tmp17_ = FALSE;
							_tmp18_ = strlen (pointers_data);
							if (!(i < _tmp18_)) {
								break;
							}
							_tmp19_ = vala_pointer_type_new (type, NULL);
							_tmp20_ = (ValaDataType*) _tmp19_;
							_vala_code_node_unref0 (type);
							type = _tmp20_;
						}
					}
				}
			}
			result = type;
			_g_free0 (nullable_data);
			_g_free0 (array_data);
			_g_free0 (pointers_data);
			_g_free0 (type_arguments_data);
			_g_free0 (type_name);
			_g_free0 (ownership_data);
			_g_match_info_free0 (match);
			return result;
		} else {
			vala_report_error (source_reference, "invalid void type");
			result = NULL;
			_g_free0 (nullable_data);
			_g_free0 (array_data);
			_g_free0 (pointers_data);
			_g_free0 (type_arguments_data);
			_g_free0 (type_name);
			_g_free0 (ownership_data);
			_vala_code_node_unref0 (type);
			_g_match_info_free0 (match);
			return result;
		}
	}
	value_owned = owned_by_default;
	if (g_strcmp0 (ownership_data, "owned") == 0) {
		if (owned_by_default) {
			vala_report_error (source_reference, "unexpected `owned' keyword");
		} else {
			value_owned = TRUE;
		}
	} else {
		if (g_strcmp0 (ownership_data, "unowned") == 0) {
			if (owned_by_default) {
				value_owned = FALSE;
			} else {
				vala_report_error (source_reference, "unexpected `unowned' keyword");
				result = NULL;
				_g_free0 (nullable_data);
				_g_free0 (array_data);
				_g_free0 (pointers_data);
				_g_free0 (type_arguments_data);
				_g_free0 (type_name);
				_g_free0 (ownership_data);
				_vala_code_node_unref0 (type);
				_g_match_info_free0 (match);
				return result;
			}
		}
	}
	_tmp21_ = vala_gidl_parser_parse_symbol_from_string (self, type_name, source_reference);
	sym = _tmp21_;
	if (sym == NULL) {
		result = NULL;
		_vala_code_node_unref0 (sym);
		_g_free0 (nullable_data);
		_g_free0 (array_data);
		_g_free0 (pointers_data);
		_g_free0 (type_arguments_data);
		_g_free0 (type_name);
		_g_free0 (ownership_data);
		_vala_code_node_unref0 (type);
		_g_match_info_free0 (match);
		return result;
	}
	_tmp22_ = vala_unresolved_type_new_from_symbol (sym, source_reference);
	_tmp23_ = (ValaDataType*) _tmp22_;
	_vala_code_node_unref0 (type);
	type = _tmp23_;
	if (type_arguments_data != NULL) {
		gint _tmp25_;
		_tmp25_ = strlen (type_arguments_data);
		_tmp24_ = _tmp25_ > 0;
	} else {
		_tmp24_ = FALSE;
	}
	if (_tmp24_) {
		gboolean _tmp26_;
		_tmp26_ = vala_gidl_parser_parse_type_arguments_from_string (self, type, type_arguments_data, source_reference);
		if (!_tmp26_) {
			result = NULL;
			_vala_code_node_unref0 (sym);
			_g_free0 (nullable_data);
			_g_free0 (array_data);
			_g_free0 (pointers_data);
			_g_free0 (type_arguments_data);
			_g_free0 (type_name);
			_g_free0 (ownership_data);
			_vala_code_node_unref0 (type);
			_g_match_info_free0 (match);
			return result;
		}
	}
	if (pointers_data != NULL) {
		{
			gint i;
			i = 0;
			{
				gboolean _tmp27_;
				_tmp27_ = TRUE;
				while (TRUE) {
					gint _tmp28_;
					ValaPointerType* _tmp29_ = NULL;
					ValaDataType* _tmp30_;
					if (!_tmp27_) {
						i++;
					}
					_tmp27_ = FALSE;
					_tmp28_ = strlen (pointers_data);
					if (!(i < _tmp28_)) {
						break;
					}
					_tmp29_ = vala_pointer_type_new (type, NULL);
					_tmp30_ = (ValaDataType*) _tmp29_;
					_vala_code_node_unref0 (type);
					type = _tmp30_;
				}
			}
		}
	}
	if (array_data != NULL) {
		gint _tmp31_;
		ValaArrayType* _tmp32_ = NULL;
		ValaDataType* _tmp33_;
		_tmp31_ = strlen (array_data);
		_tmp32_ = vala_array_type_new (type, ((gint) _tmp31_) + 1, source_reference);
		_tmp33_ = (ValaDataType*) _tmp32_;
		_vala_code_node_unref0 (type);
		type = _tmp33_;
	}
	vala_data_type_set_nullable (type, nullable);
	vala_data_type_set_value_owned (type, value_owned);
	result = type;
	_vala_code_node_unref0 (sym);
	_g_free0 (nullable_data);
	_g_free0 (array_data);
	_g_free0 (pointers_data);
	_g_free0 (type_arguments_data);
	_g_free0 (type_name);
	_g_free0 (ownership_data);
	_g_match_info_free0 (match);
	return result;
}


static ValaMethod* vala_gidl_parser_create_method (ValaGIdlParser* self, const gchar* name, const gchar* symbol, GIdlNodeParam* res, GList* parameters, gboolean is_constructor, gboolean is_interface) {
	ValaMethod* result = NULL;
	ValaDataType* return_type;
	ValaMethod* m;
	gboolean _tmp2_ = FALSE;
	gboolean add_ellipsis;
	gboolean suppress_throws;
	gchar* error_types;
	gint _tmp37_;
	gchar** _tmp38_ = NULL;
	gint attributes_length1;
	gint _attributes_size_;
	gchar** _tmp39_;
	gchar** attributes;
	gboolean first;
	ValaParameter* last_param;
	ValaDataType* last_param_type;
	gboolean _tmp285_ = FALSE;
	gboolean _tmp295_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (symbol != NULL, NULL);
	return_type = NULL;
	if (res != NULL) {
		ValaDataType* _tmp0_ = NULL;
		ValaDataType* _tmp1_;
		_tmp0_ = vala_gidl_parser_parse_param (self, res, NULL);
		_tmp1_ = _tmp0_;
		_vala_code_node_unref0 (return_type);
		return_type = _tmp1_;
	}
	m = NULL;
	if (!is_interface) {
		gboolean _tmp3_ = FALSE;
		if (is_constructor) {
			_tmp3_ = TRUE;
		} else {
			gboolean _tmp4_;
			_tmp4_ = g_str_has_prefix (name, "new");
			_tmp3_ = _tmp4_;
		}
		_tmp2_ = _tmp3_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		ValaCreationMethod* _tmp5_ = NULL;
		ValaMethod* _tmp6_;
		const gchar* _tmp7_ = NULL;
		gboolean _tmp14_ = FALSE;
		_tmp5_ = vala_creation_method_new (NULL, name, self->priv->current_source_reference, NULL);
		_tmp6_ = (ValaMethod*) _tmp5_;
		_vala_code_node_unref0 (m);
		m = _tmp6_;
		vala_method_set_has_construct_function (m, FALSE);
		_tmp7_ = vala_symbol_get_name ((ValaSymbol*) m);
		if (g_strcmp0 (_tmp7_, "new") == 0) {
			vala_symbol_set_name ((ValaSymbol*) m, NULL);
		} else {
			const gchar* _tmp8_ = NULL;
			gboolean _tmp9_;
			_tmp8_ = vala_symbol_get_name ((ValaSymbol*) m);
			_tmp9_ = g_str_has_prefix (_tmp8_, "new_");
			if (_tmp9_) {
				const gchar* _tmp10_ = NULL;
				gint _tmp11_;
				gchar* _tmp12_ = NULL;
				gchar* _tmp13_;
				_tmp10_ = vala_symbol_get_name ((ValaSymbol*) m);
				_tmp11_ = strlen ("new_");
				_tmp12_ = string_substring (_tmp10_, (glong) _tmp11_, (glong) (-1));
				_tmp13_ = _tmp12_;
				vala_symbol_set_name ((ValaSymbol*) m, _tmp13_);
				_g_free0 (_tmp13_);
			}
		}
		if (VALA_IS_CLASS (self->priv->current_data_type)) {
			_tmp14_ = res != NULL;
		} else {
			_tmp14_ = FALSE;
		}
		if (_tmp14_) {
			gchar* _tmp15_ = NULL;
			gchar* _tmp16_;
			gchar* _tmp17_ = NULL;
			gchar* _tmp18_;
			gboolean _tmp19_;
			_tmp15_ = vala_typesymbol_get_cname (self->priv->current_data_type, FALSE);
			_tmp16_ = _tmp15_;
			_tmp17_ = g_strdup_printf ("%s*", _tmp16_);
			_tmp18_ = _tmp17_;
			if ((_tmp19_ = g_strcmp0 (_tmp18_, res->type->unparsed) != 0, _g_free0 (_tmp18_), _g_free0 (_tmp16_), _tmp19_)) {
				vala_creation_method_set_custom_return_type_cname (VALA_CREATION_METHOD (m), res->type->unparsed);
			}
		}
	} else {
		ValaMethod* _tmp20_ = NULL;
		ValaMethod* _tmp21_;
		_tmp20_ = vala_method_new (name, return_type, self->priv->current_source_reference, NULL);
		_tmp21_ = _tmp20_;
		_vala_code_node_unref0 (m);
		m = _tmp21_;
	}
	vala_symbol_set_access ((ValaSymbol*) m, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	if (self->priv->current_type_symbol_set != NULL) {
		vala_collection_add ((ValaCollection*) self->priv->current_type_symbol_set, name);
	}
	if (self->priv->current_data_type != NULL) {
		gchar* _tmp22_ = NULL;
		gchar* _tmp23_;
		gchar* _tmp24_ = NULL;
		gchar* _tmp25_;
		gint _tmp26_;
		gchar** _tmp27_ = NULL;
		gchar** _tmp28_;
		gint sig_attributes_length1;
		gint _sig_attributes_size_;
		gchar** _tmp29_;
		gchar** sig_attributes;
		_tmp22_ = vala_typesymbol_get_cname (self->priv->current_data_type, FALSE);
		_tmp23_ = _tmp22_;
		_tmp24_ = g_strdup_printf ("%s::%s", _tmp23_, name);
		_tmp25_ = _tmp24_;
		_tmp27_ = vala_gidl_parser_get_attributes (self, _tmp25_, &_tmp26_);
		_tmp29_ = (_tmp28_ = _tmp27_, _g_free0 (_tmp25_), _g_free0 (_tmp23_), _tmp28_);
		sig_attributes_length1 = _tmp26_;
		_sig_attributes_size_ = sig_attributes_length1;
		sig_attributes = _tmp29_;
		if (sig_attributes != NULL) {
			{
				gchar** attr_collection;
				int attr_collection_length1;
				int attr_it;
				attr_collection = sig_attributes;
				attr_collection_length1 = sig_attributes_length1;
				for (attr_it = 0; attr_it < sig_attributes_length1; attr_it = attr_it + 1) {
					gchar* _tmp30_;
					gchar* attr;
					_tmp30_ = g_strdup (attr_collection[attr_it]);
					attr = _tmp30_;
					{
						gchar** _tmp31_;
						gchar** _tmp32_ = NULL;
						gint nv_length1;
						gint _nv_size_;
						gchar** _tmp33_;
						gchar** nv;
						gboolean _tmp34_ = FALSE;
						_tmp32_ = _tmp31_ = g_strsplit (attr, "=", 2);
						_tmp33_ = _tmp32_;
						nv_length1 = _vala_array_length (_tmp31_);
						_nv_size_ = nv_length1;
						nv = _tmp33_;
						if (g_strcmp0 (nv[0], "has_emitter") == 0) {
							gchar* _tmp35_ = NULL;
							gchar* _tmp36_;
							_tmp35_ = vala_gidl_parser_eval (self, nv[1]);
							_tmp36_ = _tmp35_;
							_tmp34_ = g_strcmp0 (_tmp36_, "1") == 0;
							_g_free0 (_tmp36_);
						} else {
							_tmp34_ = FALSE;
						}
						if (_tmp34_) {
							result = NULL;
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
							sig_attributes = (_vala_array_free (sig_attributes, sig_attributes_length1, (GDestroyNotify) g_free), NULL);
							_vala_code_node_unref0 (m);
							_vala_code_node_unref0 (return_type);
							return result;
						}
						nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (attr);
					}
				}
			}
		}
		sig_attributes = (_vala_array_free (sig_attributes, sig_attributes_length1, (GDestroyNotify) g_free), NULL);
	}
	add_ellipsis = FALSE;
	suppress_throws = FALSE;
	error_types = NULL;
	_tmp38_ = vala_gidl_parser_get_attributes (self, symbol, &_tmp37_);
	_tmp39_ = _tmp38_;
	attributes_length1 = _tmp37_;
	_attributes_size_ = attributes_length1;
	attributes = _tmp39_;
	if (attributes != NULL) {
		{
			gchar** attr_collection;
			int attr_collection_length1;
			int attr_it;
			attr_collection = attributes;
			attr_collection_length1 = attributes_length1;
			for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
				gchar* _tmp40_;
				gchar* attr;
				_tmp40_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp40_;
				{
					gchar** _tmp41_;
					gchar** _tmp42_ = NULL;
					gint nv_length1;
					gint _nv_size_;
					gchar** _tmp43_;
					gchar** nv;
					_tmp42_ = _tmp41_ = g_strsplit (attr, "=", 2);
					_tmp43_ = _tmp42_;
					nv_length1 = _vala_array_length (_tmp41_);
					_nv_size_ = nv_length1;
					nv = _tmp43_;
					if (g_strcmp0 (nv[0], "name") == 0) {
						const gchar* _tmp44_ = NULL;
						gchar* _tmp45_ = NULL;
						gchar* _tmp46_;
						_tmp44_ = vala_symbol_get_name ((ValaSymbol*) m);
						vala_method_set_cname (m, _tmp44_);
						_tmp45_ = vala_gidl_parser_eval (self, nv[1]);
						_tmp46_ = _tmp45_;
						vala_symbol_set_name ((ValaSymbol*) m, _tmp46_);
						_g_free0 (_tmp46_);
					} else {
						if (g_strcmp0 (nv[0], "hidden") == 0) {
							gchar* _tmp47_ = NULL;
							gchar* _tmp48_;
							gboolean _tmp49_;
							_tmp47_ = vala_gidl_parser_eval (self, nv[1]);
							_tmp48_ = _tmp47_;
							if ((_tmp49_ = g_strcmp0 (_tmp48_, "1") == 0, _g_free0 (_tmp48_), _tmp49_)) {
								result = NULL;
								nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (attr);
								attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (error_types);
								_vala_code_node_unref0 (m);
								_vala_code_node_unref0 (return_type);
								return result;
							}
						} else {
							if (g_strcmp0 (nv[0], "ellipsis") == 0) {
								gchar* _tmp50_ = NULL;
								gchar* _tmp51_;
								gboolean _tmp52_;
								_tmp50_ = vala_gidl_parser_eval (self, nv[1]);
								_tmp51_ = _tmp50_;
								if ((_tmp52_ = g_strcmp0 (_tmp51_, "1") == 0, _g_free0 (_tmp51_), _tmp52_)) {
									add_ellipsis = TRUE;
								}
							} else {
								if (g_strcmp0 (nv[0], "printf_format") == 0) {
									gchar* _tmp53_ = NULL;
									gchar* _tmp54_;
									gboolean _tmp55_;
									_tmp53_ = vala_gidl_parser_eval (self, nv[1]);
									_tmp54_ = _tmp53_;
									if ((_tmp55_ = g_strcmp0 (_tmp54_, "1") == 0, _g_free0 (_tmp54_), _tmp55_)) {
										vala_method_set_printf_format (m, TRUE);
									}
								} else {
									if (g_strcmp0 (nv[0], "transfer_ownership") == 0) {
										gchar* _tmp56_ = NULL;
										gchar* _tmp57_;
										gboolean _tmp58_;
										_tmp56_ = vala_gidl_parser_eval (self, nv[1]);
										_tmp57_ = _tmp56_;
										if ((_tmp58_ = g_strcmp0 (_tmp57_, "1") == 0, _g_free0 (_tmp57_), _tmp58_)) {
											vala_data_type_set_value_owned (return_type, TRUE);
										}
									} else {
										if (g_strcmp0 (nv[0], "nullable") == 0) {
											gchar* _tmp59_ = NULL;
											gchar* _tmp60_;
											gboolean _tmp61_;
											_tmp59_ = vala_gidl_parser_eval (self, nv[1]);
											_tmp60_ = _tmp59_;
											if ((_tmp61_ = g_strcmp0 (_tmp60_, "1") == 0, _g_free0 (_tmp60_), _tmp61_)) {
												vala_data_type_set_nullable (return_type, TRUE);
											}
										} else {
											if (g_strcmp0 (nv[0], "sentinel") == 0) {
												gchar* _tmp62_ = NULL;
												gchar* _tmp63_;
												_tmp62_ = vala_gidl_parser_eval (self, nv[1]);
												_tmp63_ = _tmp62_;
												vala_method_set_sentinel (m, _tmp63_);
												_g_free0 (_tmp63_);
											} else {
												if (g_strcmp0 (nv[0], "is_array") == 0) {
													gchar* _tmp64_ = NULL;
													gchar* _tmp65_;
													gboolean _tmp66_;
													_tmp64_ = vala_gidl_parser_eval (self, nv[1]);
													_tmp65_ = _tmp64_;
													if ((_tmp66_ = g_strcmp0 (_tmp65_, "1") == 0, _g_free0 (_tmp65_), _tmp66_)) {
														ValaSourceReference* _tmp67_ = NULL;
														ValaArrayType* _tmp68_ = NULL;
														ValaDataType* _tmp69_;
														_tmp67_ = vala_code_node_get_source_reference ((ValaCodeNode*) return_type);
														_tmp68_ = vala_array_type_new (return_type, 1, _tmp67_);
														_tmp69_ = (ValaDataType*) _tmp68_;
														_vala_code_node_unref0 (return_type);
														return_type = _tmp69_;
														vala_method_set_return_type (m, return_type);
													}
												} else {
													if (g_strcmp0 (nv[0], "throws") == 0) {
														gchar* _tmp70_ = NULL;
														gchar* _tmp71_;
														gboolean _tmp72_;
														_tmp70_ = vala_gidl_parser_eval (self, nv[1]);
														_tmp71_ = _tmp70_;
														if ((_tmp72_ = g_strcmp0 (_tmp71_, "0") == 0, _g_free0 (_tmp71_), _tmp72_)) {
															suppress_throws = TRUE;
														}
													} else {
														if (g_strcmp0 (nv[0], "error_types") == 0) {
															gchar* _tmp73_ = NULL;
															gchar* _tmp74_;
															_tmp73_ = vala_gidl_parser_eval (self, nv[1]);
															_tmp74_ = _tmp73_;
															_g_free0 (error_types);
															error_types = _tmp74_;
														} else {
															if (g_strcmp0 (nv[0], "no_array_length") == 0) {
																gchar* _tmp75_ = NULL;
																gchar* _tmp76_;
																gboolean _tmp77_;
																_tmp75_ = vala_gidl_parser_eval (self, nv[1]);
																_tmp76_ = _tmp75_;
																if ((_tmp77_ = g_strcmp0 (_tmp76_, "1") == 0, _g_free0 (_tmp76_), _tmp77_)) {
																	vala_method_set_no_array_length (m, TRUE);
																}
															} else {
																if (g_strcmp0 (nv[0], "array_null_terminated") == 0) {
																	gchar* _tmp78_ = NULL;
																	gchar* _tmp79_;
																	gboolean _tmp80_;
																	_tmp78_ = vala_gidl_parser_eval (self, nv[1]);
																	_tmp79_ = _tmp78_;
																	if ((_tmp80_ = g_strcmp0 (_tmp79_, "1") == 0, _g_free0 (_tmp79_), _tmp80_)) {
																		vala_method_set_no_array_length (m, TRUE);
																		vala_method_set_array_null_terminated (m, TRUE);
																	}
																} else {
																	if (g_strcmp0 (nv[0], "array_length_type") == 0) {
																		gchar* _tmp81_ = NULL;
																		gchar* _tmp82_;
																		_tmp81_ = vala_gidl_parser_eval (self, nv[1]);
																		_tmp82_ = _tmp81_;
																		vala_method_set_array_length_type (m, _tmp82_);
																		_g_free0 (_tmp82_);
																	} else {
																		if (g_strcmp0 (nv[0], "type_name") == 0) {
																			gchar* _tmp83_ = NULL;
																			gchar* _tmp84_;
																			ValaDataType* _tmp85_ = NULL;
																			ValaDataType* _tmp86_;
																			_tmp83_ = vala_gidl_parser_eval (self, nv[1]);
																			_tmp84_ = _tmp83_;
																			_tmp85_ = vala_gidl_parser_parse_type_from_string (self, _tmp84_, FALSE, NULL);
																			_tmp86_ = _tmp85_;
																			_vala_code_node_unref0 (return_type);
																			return_type = _tmp86_;
																			vala_method_set_return_type (m, return_type);
																			_g_free0 (_tmp84_);
																		} else {
																			if (g_strcmp0 (nv[0], "type_arguments") == 0) {
																				gchar* _tmp87_ = NULL;
																				gchar* _tmp88_;
																				_tmp87_ = vala_gidl_parser_eval (self, nv[1]);
																				_tmp88_ = _tmp87_;
																				vala_gidl_parser_parse_type_arguments_from_string (self, return_type, _tmp88_, NULL);
																				_g_free0 (_tmp88_);
																			} else {
																				if (g_strcmp0 (nv[0], "deprecated") == 0) {
																					gchar* _tmp89_ = NULL;
																					gchar* _tmp90_;
																					gboolean _tmp91_;
																					_tmp89_ = vala_gidl_parser_eval (self, nv[1]);
																					_tmp90_ = _tmp89_;
																					if ((_tmp91_ = g_strcmp0 (_tmp90_, "1") == 0, _g_free0 (_tmp90_), _tmp91_)) {
																						vala_symbol_set_deprecated ((ValaSymbol*) m, TRUE);
																					}
																				} else {
																					if (g_strcmp0 (nv[0], "replacement") == 0) {
																						gchar* _tmp92_ = NULL;
																						gchar* _tmp93_;
																						_tmp92_ = vala_gidl_parser_eval (self, nv[1]);
																						_tmp93_ = _tmp92_;
																						vala_symbol_set_replacement ((ValaSymbol*) m, _tmp93_);
																						_g_free0 (_tmp93_);
																					} else {
																						if (g_strcmp0 (nv[0], "deprecated_since") == 0) {
																							gchar* _tmp94_ = NULL;
																							gchar* _tmp95_;
																							_tmp94_ = vala_gidl_parser_eval (self, nv[1]);
																							_tmp95_ = _tmp94_;
																							vala_symbol_set_deprecated_since ((ValaSymbol*) m, _tmp95_);
																							_g_free0 (_tmp95_);
																						} else {
																							if (g_strcmp0 (nv[0], "cheader_filename") == 0) {
																								gchar* _tmp96_ = NULL;
																								gchar* _tmp97_;
																								_tmp96_ = vala_gidl_parser_eval (self, nv[1]);
																								_tmp97_ = _tmp96_;
																								vala_symbol_add_cheader_filename ((ValaSymbol*) m, _tmp97_);
																								_g_free0 (_tmp97_);
																							} else {
																								if (g_strcmp0 (nv[0], "abstract") == 0) {
																									gchar* _tmp98_ = NULL;
																									gchar* _tmp99_;
																									gboolean _tmp100_;
																									_tmp98_ = vala_gidl_parser_eval (self, nv[1]);
																									_tmp99_ = _tmp98_;
																									if ((_tmp100_ = g_strcmp0 (_tmp99_, "1") == 0, _g_free0 (_tmp99_), _tmp100_)) {
																										vala_method_set_is_abstract (m, TRUE);
																									}
																								} else {
																									if (g_strcmp0 (nv[0], "virtual") == 0) {
																										gchar* _tmp101_ = NULL;
																										gchar* _tmp102_;
																										gboolean _tmp103_;
																										_tmp101_ = vala_gidl_parser_eval (self, nv[1]);
																										_tmp102_ = _tmp101_;
																										if ((_tmp103_ = g_strcmp0 (_tmp102_, "1") == 0, _g_free0 (_tmp102_), _tmp103_)) {
																											vala_method_set_is_virtual (m, TRUE);
																										}
																									} else {
																										if (g_strcmp0 (nv[0], "vfunc_name") == 0) {
																											gchar* _tmp104_ = NULL;
																											gchar* _tmp105_;
																											_tmp104_ = vala_gidl_parser_eval (self, nv[1]);
																											_tmp105_ = _tmp104_;
																											vala_method_set_vfunc_name (m, _tmp105_);
																											_g_free0 (_tmp105_);
																										} else {
																											if (g_strcmp0 (nv[0], "finish_name") == 0) {
																												gchar* _tmp106_ = NULL;
																												gchar* _tmp107_;
																												_tmp106_ = vala_gidl_parser_eval (self, nv[1]);
																												_tmp107_ = _tmp106_;
																												vala_method_set_finish_cname (m, _tmp107_);
																												_g_free0 (_tmp107_);
																											} else {
																												if (g_strcmp0 (nv[0], "async") == 0) {
																													gchar* _tmp108_ = NULL;
																													gchar* _tmp109_;
																													gboolean _tmp110_;
																													_tmp108_ = vala_gidl_parser_eval (self, nv[1]);
																													_tmp109_ = _tmp108_;
																													if ((_tmp110_ = g_strcmp0 (_tmp109_, "1") == 0, _g_free0 (_tmp109_), _tmp110_)) {
																														vala_method_set_coroutine (m, TRUE);
																													}
																												} else {
																													if (g_strcmp0 (nv[0], "parent") == 0) {
																														gchar* _tmp111_ = NULL;
																														gchar* _tmp112_;
																														ValaSymbol* _tmp113_ = NULL;
																														ValaSymbol* _tmp114_;
																														ValaSymbol* container;
																														gchar* _tmp115_ = NULL;
																														gchar* prefix;
																														gboolean _tmp116_;
																														_tmp111_ = vala_gidl_parser_eval (self, nv[1]);
																														_tmp112_ = _tmp111_;
																														_tmp113_ = vala_gidl_parser_get_container_from_name (self, _tmp112_);
																														container = (_tmp114_ = _tmp113_, _g_free0 (_tmp112_), _tmp114_);
																														_tmp115_ = vala_symbol_get_lower_case_cprefix (container);
																														prefix = _tmp115_;
																														_tmp116_ = g_str_has_prefix (symbol, prefix);
																														if (_tmp116_) {
																															const gchar* _tmp117_ = NULL;
																															gint _tmp118_;
																															gchar* _tmp119_ = NULL;
																															gchar* _tmp120_;
																															_tmp117_ = vala_symbol_get_name ((ValaSymbol*) m);
																															vala_method_set_cname (m, _tmp117_);
																															_tmp118_ = strlen (prefix);
																															_tmp119_ = string_substring (symbol, (glong) _tmp118_, (glong) (-1));
																															_tmp120_ = _tmp119_;
																															vala_symbol_set_name ((ValaSymbol*) m, _tmp120_);
																															_g_free0 (_tmp120_);
																														}
																														_g_free0 (prefix);
																														_vala_code_node_unref0 (container);
																													}
																												}
																											}
																										}
																									}
																								}
																							}
																						}
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	vala_method_set_cname (m, symbol);
	first = TRUE;
	last_param = NULL;
	last_param_type = NULL;
	{
		GList* param_collection;
		GList* param_it;
		param_collection = parameters;
		for (param_it = param_collection; param_it != NULL; param_it = param_it->next) {
			GIdlNodeParam* param;
			param = (GIdlNodeParam*) param_it->data;
			{
				GIdlNode* param_node;
				gboolean _tmp146_ = FALSE;
				gboolean _tmp150_ = FALSE;
				gchar* _tmp154_;
				gchar* param_name;
				ValaParameterDirection direction = 0;
				ValaParameterDirection _tmp159_;
				ValaDataType* _tmp160_ = NULL;
				ValaDataType* param_type;
				ValaParameter* _tmp161_ = NULL;
				ValaParameter* p;
				gboolean hide_param;
				gboolean show_param;
				gboolean set_array_length_pos;
				gdouble array_length_pos;
				gboolean set_delegate_target_pos;
				gdouble delegate_target_pos;
				gboolean array_requested;
				gboolean out_requested;
				gchar* _tmp162_ = NULL;
				gchar* _tmp163_;
				gint _tmp164_;
				gchar** _tmp165_ = NULL;
				gchar** _tmp166_;
				gboolean _tmp271_ = FALSE;
				gboolean _tmp280_ = FALSE;
				ValaParameter* _tmp281_;
				ValaParameter* _tmp282_;
				ValaDataType* _tmp283_;
				ValaDataType* _tmp284_;
				param_node = (GIdlNode*) param;
				if (first) {
					gboolean _tmp121_ = FALSE;
					gboolean _tmp122_ = FALSE;
					gboolean _tmp123_ = FALSE;
					first = FALSE;
					if (!VALA_IS_CREATION_METHOD (m)) {
						_tmp123_ = self->priv->current_data_type != NULL;
					} else {
						_tmp123_ = FALSE;
					}
					if (_tmp123_) {
						_tmp122_ = param->type->is_interface;
					} else {
						_tmp122_ = FALSE;
					}
					if (_tmp122_) {
						gboolean _tmp124_ = FALSE;
						if (g_strcmp0 (param_node->name, "self") == 0) {
							_tmp124_ = TRUE;
						} else {
							gchar* _tmp125_ = NULL;
							gchar* _tmp126_;
							gboolean _tmp127_;
							_tmp125_ = vala_typesymbol_get_cname (self->priv->current_data_type, FALSE);
							_tmp126_ = _tmp125_;
							_tmp127_ = g_str_has_suffix (param->type->interface, _tmp126_);
							_tmp124_ = _tmp127_;
							_g_free0 (_tmp126_);
						}
						_tmp121_ = _tmp124_;
					} else {
						_tmp121_ = FALSE;
					}
					if (_tmp121_) {
						continue;
					} else {
						gboolean _tmp128_ = FALSE;
						gboolean _tmp129_ = FALSE;
						gboolean _tmp130_ = FALSE;
						if (!VALA_IS_CREATION_METHOD (m)) {
							_tmp130_ = self->priv->current_data_type != NULL;
						} else {
							_tmp130_ = FALSE;
						}
						if (_tmp130_) {
							_tmp129_ = param->type->is_interface;
						} else {
							_tmp129_ = FALSE;
						}
						if (_tmp129_) {
							gboolean _tmp131_ = FALSE;
							if (g_strcmp0 (param_node->name, "klass") == 0) {
								_tmp131_ = TRUE;
							} else {
								gchar* _tmp132_ = NULL;
								gchar* _tmp133_;
								gchar* _tmp134_ = NULL;
								gchar* _tmp135_;
								gboolean _tmp136_;
								_tmp132_ = vala_typesymbol_get_cname (self->priv->current_data_type, FALSE);
								_tmp133_ = _tmp132_;
								_tmp134_ = g_strdup_printf ("%sClass", _tmp133_);
								_tmp135_ = _tmp134_;
								_tmp136_ = g_str_has_suffix (param->type->interface, _tmp135_);
								_tmp131_ = _tmp136_;
								_g_free0 (_tmp135_);
								_g_free0 (_tmp133_);
							}
							_tmp128_ = _tmp131_;
						} else {
							_tmp128_ = FALSE;
						}
						if (_tmp128_) {
							const gchar* _tmp137_ = NULL;
							gboolean _tmp138_;
							vala_method_set_binding (m, VALA_MEMBER_BINDING_CLASS);
							_tmp137_ = vala_symbol_get_name ((ValaSymbol*) m);
							_tmp138_ = g_str_has_prefix (_tmp137_, "class_");
							if (_tmp138_) {
								const gchar* _tmp139_ = NULL;
								gint _tmp140_;
								const gchar* _tmp141_ = NULL;
								gint _tmp142_;
								gint _tmp143_;
								gchar* _tmp144_ = NULL;
								gchar* _tmp145_;
								_tmp139_ = vala_symbol_get_name ((ValaSymbol*) m);
								_tmp140_ = strlen ("class_");
								_tmp141_ = vala_symbol_get_name ((ValaSymbol*) m);
								_tmp142_ = strlen (_tmp141_);
								_tmp143_ = strlen ("class_");
								_tmp144_ = string_substring (_tmp139_, (glong) _tmp140_, (glong) (_tmp142_ - _tmp143_));
								_tmp145_ = _tmp144_;
								vala_symbol_set_name ((ValaSymbol*) m, _tmp145_);
								_g_free0 (_tmp145_);
							}
							continue;
						} else {
							vala_method_set_binding (m, VALA_MEMBER_BINDING_STATIC);
						}
					}
				}
				if (g_strcmp0 (param->type->interface, "GAsyncReadyCallback") == 0) {
					gboolean _tmp147_ = FALSE;
					gboolean _tmp148_;
					_tmp148_ = g_str_has_suffix (symbol, "_async");
					if (_tmp148_) {
						_tmp147_ = TRUE;
					} else {
						gboolean _tmp149_;
						_tmp149_ = vala_method_get_coroutine (m);
						_tmp147_ = _tmp149_;
					}
					_tmp146_ = _tmp147_;
				} else {
					_tmp146_ = FALSE;
				}
				if (_tmp146_) {
					vala_method_set_coroutine (m, TRUE);
					continue;
				}
				if (suppress_throws == FALSE) {
					gboolean _tmp151_;
					_tmp151_ = vala_gidl_parser_param_is_exception (self, param);
					_tmp150_ = _tmp151_;
				} else {
					_tmp150_ = FALSE;
				}
				if (_tmp150_) {
					if (error_types == NULL) {
						ValaDataType* _tmp152_ = NULL;
						ValaDataType* _tmp153_;
						_tmp152_ = vala_gidl_parser_parse_type (self, param->type, NULL);
						_tmp153_ = _tmp152_;
						vala_code_node_add_error_type ((ValaCodeNode*) m, _tmp153_);
						_vala_code_node_unref0 (_tmp153_);
					}
					continue;
				}
				_tmp154_ = g_strdup (param_node->name);
				param_name = _tmp154_;
				if (g_strcmp0 (param_name, "result") == 0) {
					gchar* _tmp155_;
					gchar* _tmp156_;
					_tmp155_ = g_strdup ("_result");
					_tmp156_ = _tmp155_;
					_g_free0 (param_name);
					param_name = _tmp156_;
				} else {
					if (g_strcmp0 (param_name, "string") == 0) {
						gchar* _tmp157_;
						gchar* _tmp158_;
						_tmp157_ = g_strdup ("str");
						_tmp158_ = _tmp157_;
						_g_free0 (param_name);
						param_name = _tmp158_;
					}
				}
				_tmp160_ = vala_gidl_parser_parse_param (self, param, &_tmp159_);
				direction = _tmp159_;
				param_type = _tmp160_;
				_tmp161_ = vala_parameter_new (param_name, param_type, NULL);
				p = _tmp161_;
				vala_parameter_set_direction (p, direction);
				hide_param = FALSE;
				show_param = FALSE;
				set_array_length_pos = FALSE;
				array_length_pos = (gdouble) 0;
				set_delegate_target_pos = FALSE;
				delegate_target_pos = (gdouble) 0;
				array_requested = FALSE;
				out_requested = FALSE;
				_tmp162_ = g_strdup_printf ("%s.%s", symbol, param_node->name);
				_tmp163_ = _tmp162_;
				_tmp165_ = vala_gidl_parser_get_attributes (self, _tmp163_, &_tmp164_);
				_tmp166_ = _tmp165_;
				attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
				attributes_length1 = _tmp164_;
				_attributes_size_ = attributes_length1;
				attributes = _tmp166_;
				_g_free0 (_tmp163_);
				if (attributes != NULL) {
					{
						gchar** attr_collection;
						int attr_collection_length1;
						int attr_it;
						attr_collection = attributes;
						attr_collection_length1 = attributes_length1;
						for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
							gchar* _tmp167_;
							gchar* attr;
							_tmp167_ = g_strdup (attr_collection[attr_it]);
							attr = _tmp167_;
							{
								gchar** _tmp168_;
								gchar** _tmp169_ = NULL;
								gint nv_length1;
								gint _nv_size_;
								gchar** _tmp170_;
								gchar** nv;
								_tmp169_ = _tmp168_ = g_strsplit (attr, "=", 2);
								_tmp170_ = _tmp169_;
								nv_length1 = _vala_array_length (_tmp168_);
								_nv_size_ = nv_length1;
								nv = _tmp170_;
								if (g_strcmp0 (nv[0], "is_array") == 0) {
									gchar* _tmp171_ = NULL;
									gchar* _tmp172_;
									gboolean _tmp173_;
									_tmp171_ = vala_gidl_parser_eval (self, nv[1]);
									_tmp172_ = _tmp171_;
									if ((_tmp173_ = g_strcmp0 (_tmp172_, "1") == 0, _g_free0 (_tmp172_), _tmp173_)) {
										ValaSourceReference* _tmp174_ = NULL;
										ValaArrayType* _tmp175_ = NULL;
										ValaDataType* _tmp176_;
										_tmp174_ = vala_code_node_get_source_reference ((ValaCodeNode*) param_type);
										_tmp175_ = vala_array_type_new (param_type, 1, _tmp174_);
										_tmp176_ = (ValaDataType*) _tmp175_;
										_vala_code_node_unref0 (param_type);
										param_type = _tmp176_;
										vala_variable_set_variable_type ((ValaVariable*) p, param_type);
										if (!out_requested) {
											vala_parameter_set_direction (p, VALA_PARAMETER_DIRECTION_IN);
										}
										array_requested = TRUE;
									}
								} else {
									if (g_strcmp0 (nv[0], "is_out") == 0) {
										gchar* _tmp177_ = NULL;
										gchar* _tmp178_;
										gboolean _tmp179_;
										_tmp177_ = vala_gidl_parser_eval (self, nv[1]);
										_tmp178_ = _tmp177_;
										if ((_tmp179_ = g_strcmp0 (_tmp178_, "1") == 0, _g_free0 (_tmp178_), _tmp179_)) {
											gboolean _tmp180_ = FALSE;
											vala_parameter_set_direction (p, VALA_PARAMETER_DIRECTION_OUT);
											out_requested = TRUE;
											if (!array_requested) {
												_tmp180_ = VALA_IS_ARRAY_TYPE (param_type);
											} else {
												_tmp180_ = FALSE;
											}
											if (_tmp180_) {
												ValaArrayType* _tmp181_;
												ValaArrayType* array_type;
												ValaDataType* _tmp182_ = NULL;
												ValaDataType* _tmp183_;
												ValaDataType* _tmp184_;
												_tmp181_ = _vala_code_node_ref0 (VALA_ARRAY_TYPE (param_type));
												array_type = _tmp181_;
												_tmp182_ = vala_array_type_get_element_type (array_type);
												_tmp183_ = _vala_code_node_ref0 (_tmp182_);
												_tmp184_ = _tmp183_;
												_vala_code_node_unref0 (param_type);
												param_type = _tmp184_;
												vala_variable_set_variable_type ((ValaVariable*) p, param_type);
												_vala_code_node_unref0 (array_type);
											}
										}
									} else {
										if (g_strcmp0 (nv[0], "is_ref") == 0) {
											gchar* _tmp185_ = NULL;
											gchar* _tmp186_;
											gboolean _tmp187_;
											_tmp185_ = vala_gidl_parser_eval (self, nv[1]);
											_tmp186_ = _tmp185_;
											if ((_tmp187_ = g_strcmp0 (_tmp186_, "1") == 0, _g_free0 (_tmp186_), _tmp187_)) {
												gboolean _tmp188_ = FALSE;
												vala_parameter_set_direction (p, VALA_PARAMETER_DIRECTION_REF);
												if (!array_requested) {
													_tmp188_ = VALA_IS_ARRAY_TYPE (param_type);
												} else {
													_tmp188_ = FALSE;
												}
												if (_tmp188_) {
													ValaArrayType* _tmp189_;
													ValaArrayType* array_type;
													ValaDataType* _tmp190_ = NULL;
													ValaDataType* _tmp191_;
													ValaDataType* _tmp192_;
													_tmp189_ = _vala_code_node_ref0 (VALA_ARRAY_TYPE (param_type));
													array_type = _tmp189_;
													_tmp190_ = vala_array_type_get_element_type (array_type);
													_tmp191_ = _vala_code_node_ref0 (_tmp190_);
													_tmp192_ = _tmp191_;
													_vala_code_node_unref0 (param_type);
													param_type = _tmp192_;
													vala_variable_set_variable_type ((ValaVariable*) p, param_type);
													_vala_code_node_unref0 (array_type);
												}
											}
										} else {
											if (g_strcmp0 (nv[0], "nullable") == 0) {
												gchar* _tmp193_ = NULL;
												gchar* _tmp194_;
												gboolean _tmp195_;
												_tmp193_ = vala_gidl_parser_eval (self, nv[1]);
												_tmp194_ = _tmp193_;
												if ((_tmp195_ = g_strcmp0 (_tmp194_, "1") == 0, _g_free0 (_tmp194_), _tmp195_)) {
													vala_data_type_set_nullable (param_type, TRUE);
												}
											} else {
												if (g_strcmp0 (nv[0], "transfer_ownership") == 0) {
													gchar* _tmp196_ = NULL;
													gchar* _tmp197_;
													gboolean _tmp198_;
													_tmp196_ = vala_gidl_parser_eval (self, nv[1]);
													_tmp197_ = _tmp196_;
													if ((_tmp198_ = g_strcmp0 (_tmp197_, "1") == 0, _g_free0 (_tmp197_), _tmp198_)) {
														vala_data_type_set_value_owned (param_type, TRUE);
													}
												} else {
													if (g_strcmp0 (nv[0], "takes_ownership") == 0) {
														gchar* _tmp199_ = NULL;
														gchar* _tmp200_;
														gboolean _tmp201_;
														_tmp199_ = vala_gidl_parser_eval (self, nv[1]);
														_tmp200_ = _tmp199_;
														if ((_tmp201_ = g_strcmp0 (_tmp200_, "1") == 0, _g_free0 (_tmp200_), _tmp201_)) {
															vala_data_type_set_value_owned (param_type, TRUE);
														}
													} else {
														if (g_strcmp0 (nv[0], "value_owned") == 0) {
															gchar* _tmp202_ = NULL;
															gchar* _tmp203_;
															gboolean _tmp204_;
															_tmp202_ = vala_gidl_parser_eval (self, nv[1]);
															_tmp203_ = _tmp202_;
															if ((_tmp204_ = g_strcmp0 (_tmp203_, "0") == 0, _g_free0 (_tmp203_), _tmp204_)) {
																vala_data_type_set_value_owned (param_type, FALSE);
															} else {
																gchar* _tmp205_ = NULL;
																gchar* _tmp206_;
																gboolean _tmp207_;
																_tmp205_ = vala_gidl_parser_eval (self, nv[1]);
																_tmp206_ = _tmp205_;
																if ((_tmp207_ = g_strcmp0 (_tmp206_, "1") == 0, _g_free0 (_tmp206_), _tmp207_)) {
																	vala_data_type_set_value_owned (param_type, TRUE);
																}
															}
														} else {
															if (g_strcmp0 (nv[0], "hidden") == 0) {
																gchar* _tmp208_ = NULL;
																gchar* _tmp209_;
																gboolean _tmp210_;
																_tmp208_ = vala_gidl_parser_eval (self, nv[1]);
																_tmp209_ = _tmp208_;
																if ((_tmp210_ = g_strcmp0 (_tmp209_, "1") == 0, _g_free0 (_tmp209_), _tmp210_)) {
																	hide_param = TRUE;
																} else {
																	gchar* _tmp211_ = NULL;
																	gchar* _tmp212_;
																	gboolean _tmp213_;
																	_tmp211_ = vala_gidl_parser_eval (self, nv[1]);
																	_tmp212_ = _tmp211_;
																	if ((_tmp213_ = g_strcmp0 (_tmp212_, "0") == 0, _g_free0 (_tmp212_), _tmp213_)) {
																		show_param = TRUE;
																	}
																}
															} else {
																if (g_strcmp0 (nv[0], "no_array_length") == 0) {
																	gchar* _tmp214_ = NULL;
																	gchar* _tmp215_;
																	gboolean _tmp216_;
																	_tmp214_ = vala_gidl_parser_eval (self, nv[1]);
																	_tmp215_ = _tmp214_;
																	if ((_tmp216_ = g_strcmp0 (_tmp215_, "1") == 0, _g_free0 (_tmp215_), _tmp216_)) {
																		vala_parameter_set_no_array_length (p, TRUE);
																	}
																} else {
																	if (g_strcmp0 (nv[0], "array_length_type") == 0) {
																		gchar* _tmp217_ = NULL;
																		gchar* _tmp218_;
																		_tmp217_ = vala_gidl_parser_eval (self, nv[1]);
																		_tmp218_ = _tmp217_;
																		vala_parameter_set_array_length_type (p, _tmp218_);
																		_g_free0 (_tmp218_);
																	} else {
																		if (g_strcmp0 (nv[0], "array_null_terminated") == 0) {
																			gchar* _tmp219_ = NULL;
																			gchar* _tmp220_;
																			gboolean _tmp221_;
																			_tmp219_ = vala_gidl_parser_eval (self, nv[1]);
																			_tmp220_ = _tmp219_;
																			if ((_tmp221_ = g_strcmp0 (_tmp220_, "1") == 0, _g_free0 (_tmp220_), _tmp221_)) {
																				vala_parameter_set_no_array_length (p, TRUE);
																				vala_parameter_set_array_null_terminated (p, TRUE);
																			}
																		} else {
																			if (g_strcmp0 (nv[0], "array_length_pos") == 0) {
																				gchar* _tmp222_ = NULL;
																				gchar* _tmp223_;
																				gdouble _tmp224_;
																				set_array_length_pos = TRUE;
																				_tmp222_ = vala_gidl_parser_eval (self, nv[1]);
																				_tmp223_ = _tmp222_;
																				_tmp224_ = g_ascii_strtod (_tmp223_, NULL);
																				array_length_pos = _tmp224_;
																				_g_free0 (_tmp223_);
																			} else {
																				if (g_strcmp0 (nv[0], "delegate_target_pos") == 0) {
																					gchar* _tmp225_ = NULL;
																					gchar* _tmp226_;
																					gdouble _tmp227_;
																					set_delegate_target_pos = TRUE;
																					_tmp225_ = vala_gidl_parser_eval (self, nv[1]);
																					_tmp226_ = _tmp225_;
																					_tmp227_ = g_ascii_strtod (_tmp226_, NULL);
																					delegate_target_pos = _tmp227_;
																					_g_free0 (_tmp226_);
																				} else {
																					if (g_strcmp0 (nv[0], "type_name") == 0) {
																						gchar* _tmp228_ = NULL;
																						gchar* _tmp229_;
																						ValaDataType* _tmp230_ = NULL;
																						ValaDataType* _tmp231_;
																						_tmp228_ = vala_gidl_parser_eval (self, nv[1]);
																						_tmp229_ = _tmp228_;
																						_tmp230_ = vala_gidl_parser_parse_type_from_string (self, _tmp229_, FALSE, NULL);
																						_tmp231_ = _tmp230_;
																						_vala_code_node_unref0 (param_type);
																						param_type = _tmp231_;
																						vala_variable_set_variable_type ((ValaVariable*) p, param_type);
																						_g_free0 (_tmp229_);
																					} else {
																						if (g_strcmp0 (nv[0], "ctype") == 0) {
																							gchar* _tmp232_ = NULL;
																							gchar* _tmp233_;
																							_tmp232_ = vala_gidl_parser_eval (self, nv[1]);
																							_tmp233_ = _tmp232_;
																							vala_parameter_set_ctype (p, _tmp233_);
																							_g_free0 (_tmp233_);
																						} else {
																							if (g_strcmp0 (nv[0], "type_arguments") == 0) {
																								gchar* _tmp234_ = NULL;
																								gchar* _tmp235_;
																								_tmp234_ = vala_gidl_parser_eval (self, nv[1]);
																								_tmp235_ = _tmp234_;
																								vala_gidl_parser_parse_type_arguments_from_string (self, param_type, _tmp235_, NULL);
																								_g_free0 (_tmp235_);
																							} else {
																								if (g_strcmp0 (nv[0], "default_value") == 0) {
																									gchar* _tmp236_ = NULL;
																									gchar* val;
																									_tmp236_ = vala_gidl_parser_eval (self, nv[1]);
																									val = _tmp236_;
																									if (g_strcmp0 (val, "null") == 0) {
																										ValaSourceReference* _tmp237_ = NULL;
																										ValaNullLiteral* _tmp238_ = NULL;
																										ValaNullLiteral* _tmp239_;
																										_tmp237_ = vala_code_node_get_source_reference ((ValaCodeNode*) param_type);
																										_tmp238_ = vala_null_literal_new (_tmp237_);
																										_tmp239_ = _tmp238_;
																										vala_variable_set_initializer ((ValaVariable*) p, (ValaExpression*) _tmp239_);
																										_vala_code_node_unref0 (_tmp239_);
																									} else {
																										if (g_strcmp0 (val, "true") == 0) {
																											ValaSourceReference* _tmp240_ = NULL;
																											ValaBooleanLiteral* _tmp241_ = NULL;
																											ValaBooleanLiteral* _tmp242_;
																											_tmp240_ = vala_code_node_get_source_reference ((ValaCodeNode*) param_type);
																											_tmp241_ = vala_boolean_literal_new (TRUE, _tmp240_);
																											_tmp242_ = _tmp241_;
																											vala_variable_set_initializer ((ValaVariable*) p, (ValaExpression*) _tmp242_);
																											_vala_code_node_unref0 (_tmp242_);
																										} else {
																											if (g_strcmp0 (val, "false") == 0) {
																												ValaSourceReference* _tmp243_ = NULL;
																												ValaBooleanLiteral* _tmp244_ = NULL;
																												ValaBooleanLiteral* _tmp245_;
																												_tmp243_ = vala_code_node_get_source_reference ((ValaCodeNode*) param_type);
																												_tmp244_ = vala_boolean_literal_new (FALSE, _tmp243_);
																												_tmp245_ = _tmp244_;
																												vala_variable_set_initializer ((ValaVariable*) p, (ValaExpression*) _tmp245_);
																												_vala_code_node_unref0 (_tmp245_);
																											} else {
																												if (g_strcmp0 (val, "") == 0) {
																													ValaSourceReference* _tmp246_ = NULL;
																													ValaStringLiteral* _tmp247_ = NULL;
																													ValaStringLiteral* _tmp248_;
																													_tmp246_ = vala_code_node_get_source_reference ((ValaCodeNode*) param_type);
																													_tmp247_ = vala_string_literal_new ("\"\"", _tmp246_);
																													_tmp248_ = _tmp247_;
																													vala_variable_set_initializer ((ValaVariable*) p, (ValaExpression*) _tmp248_);
																													_vala_code_node_unref0 (_tmp248_);
																												} else {
																													const gchar* endptr;
																													gint _tmp249_;
																													gchar* val_end;
																													const gchar* _tmp250_ = NULL;
																													endptr = NULL;
																													_tmp249_ = strlen (val);
																													val_end = ((gchar*) val) + _tmp249_;
																													strtol (val, &_tmp250_, 0);
																													endptr = _tmp250_;
																													if (((glong) endptr) == ((glong) val_end)) {
																														ValaSourceReference* _tmp251_ = NULL;
																														ValaIntegerLiteral* _tmp252_ = NULL;
																														ValaIntegerLiteral* _tmp253_;
																														_tmp251_ = vala_code_node_get_source_reference ((ValaCodeNode*) param_type);
																														_tmp252_ = vala_integer_literal_new (val, _tmp251_);
																														_tmp253_ = _tmp252_;
																														vala_variable_set_initializer ((ValaVariable*) p, (ValaExpression*) _tmp253_);
																														_vala_code_node_unref0 (_tmp253_);
																													} else {
																														const gchar* _tmp254_ = NULL;
																														g_ascii_strtod (val, &_tmp254_);
																														endptr = _tmp254_;
																														if (((glong) endptr) == ((glong) val_end)) {
																															ValaSourceReference* _tmp255_ = NULL;
																															ValaRealLiteral* _tmp256_ = NULL;
																															ValaRealLiteral* _tmp257_;
																															_tmp255_ = vala_code_node_get_source_reference ((ValaCodeNode*) param_type);
																															_tmp256_ = vala_real_literal_new (val, _tmp255_);
																															_tmp257_ = _tmp256_;
																															vala_variable_set_initializer ((ValaVariable*) p, (ValaExpression*) _tmp257_);
																															_vala_code_node_unref0 (_tmp257_);
																														} else {
																															gboolean _tmp258_ = FALSE;
																															gboolean _tmp259_;
																															_tmp259_ = g_str_has_prefix (val, "\"");
																															if (_tmp259_) {
																																gboolean _tmp260_;
																																_tmp260_ = g_str_has_suffix (val, "\"");
																																_tmp258_ = _tmp260_;
																															} else {
																																_tmp258_ = FALSE;
																															}
																															if (_tmp258_) {
																																ValaSourceReference* _tmp261_ = NULL;
																																ValaStringLiteral* _tmp262_ = NULL;
																																ValaStringLiteral* _tmp263_;
																																_tmp261_ = vala_code_node_get_source_reference ((ValaCodeNode*) param_type);
																																_tmp262_ = vala_string_literal_new (val, _tmp261_);
																																_tmp263_ = _tmp262_;
																																vala_variable_set_initializer ((ValaVariable*) p, (ValaExpression*) _tmp263_);
																																_vala_code_node_unref0 (_tmp263_);
																															} else {
																																gchar** _tmp264_;
																																gchar** _tmp265_ = NULL;
																																_tmp265_ = _tmp264_ = g_strsplit (val, ".", 0);
																																{
																																	gchar** member_collection;
																																	int member_collection_length1;
																																	int member_it;
																																	member_collection = _tmp265_;
																																	member_collection_length1 = _vala_array_length (_tmp264_);
																																	for (member_it = 0; member_it < _vala_array_length (_tmp264_); member_it = member_it + 1) {
																																		gchar* _tmp266_;
																																		gchar* member;
																																		_tmp266_ = g_strdup (member_collection[member_it]);
																																		member = _tmp266_;
																																		{
																																			ValaExpression* _tmp267_ = NULL;
																																			ValaSourceReference* _tmp268_ = NULL;
																																			ValaMemberAccess* _tmp269_ = NULL;
																																			ValaMemberAccess* _tmp270_;
																																			_tmp267_ = vala_variable_get_initializer ((ValaVariable*) p);
																																			_tmp268_ = vala_code_node_get_source_reference ((ValaCodeNode*) param_type);
																																			_tmp269_ = vala_member_access_new (_tmp267_, member, _tmp268_);
																																			_tmp270_ = _tmp269_;
																																			vala_variable_set_initializer ((ValaVariable*) p, (ValaExpression*) _tmp270_);
																																			_vala_code_node_unref0 (_tmp270_);
																																			_g_free0 (member);
																																		}
																																	}
																																	member_collection = (_vala_array_free (member_collection, member_collection_length1, (GDestroyNotify) g_free), NULL);
																																}
																															}
																														}
																													}
																												}
																											}
																										}
																									}
																									_g_free0 (val);
																								}
																							}
																						}
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
								nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (attr);
							}
						}
					}
				}
				if (last_param != NULL) {
					const gchar* _tmp272_ = NULL;
					const gchar* _tmp273_ = NULL;
					gchar* _tmp274_;
					_tmp272_ = vala_symbol_get_name ((ValaSymbol*) p);
					_tmp273_ = vala_symbol_get_name ((ValaSymbol*) last_param);
					_tmp274_ = g_strconcat ("n_", _tmp273_, NULL);
					_tmp271_ = g_strcmp0 (_tmp272_, _tmp274_) == 0;
					_g_free0 (_tmp274_);
				} else {
					_tmp271_ = FALSE;
				}
				if (_tmp271_) {
					if (!VALA_IS_ARRAY_TYPE (last_param_type)) {
						ValaSourceReference* _tmp275_ = NULL;
						ValaArrayType* _tmp276_ = NULL;
						ValaDataType* _tmp277_;
						_tmp275_ = vala_code_node_get_source_reference ((ValaCodeNode*) last_param_type);
						_tmp276_ = vala_array_type_new (last_param_type, 1, _tmp275_);
						_tmp277_ = (ValaDataType*) _tmp276_;
						_vala_code_node_unref0 (last_param_type);
						last_param_type = _tmp277_;
						vala_variable_set_variable_type ((ValaVariable*) last_param, last_param_type);
						vala_parameter_set_direction (last_param, VALA_PARAMETER_DIRECTION_IN);
					}
					hide_param = TRUE;
				} else {
					gboolean _tmp278_ = FALSE;
					if (last_param != NULL) {
						const gchar* _tmp279_ = NULL;
						_tmp279_ = vala_symbol_get_name ((ValaSymbol*) p);
						_tmp278_ = g_strcmp0 (_tmp279_, "user_data") == 0;
					} else {
						_tmp278_ = FALSE;
					}
					if (_tmp278_) {
						hide_param = TRUE;
					}
				}
				if (show_param) {
					_tmp280_ = TRUE;
				} else {
					_tmp280_ = !hide_param;
				}
				if (_tmp280_) {
					vala_method_add_parameter (m, p);
					if (set_array_length_pos) {
						vala_parameter_set_carray_length_parameter_position (p, array_length_pos);
					}
					if (set_delegate_target_pos) {
						vala_parameter_set_cdelegate_target_parameter_position (p, delegate_target_pos);
					}
				}
				_tmp281_ = _vala_code_node_ref0 (p);
				_tmp282_ = _tmp281_;
				_vala_code_node_unref0 (last_param);
				last_param = _tmp282_;
				_tmp283_ = _vala_code_node_ref0 (param_type);
				_tmp284_ = _tmp283_;
				_vala_code_node_unref0 (last_param_type);
				last_param_type = _tmp284_;
				_vala_code_node_unref0 (p);
				_vala_code_node_unref0 (param_type);
				_g_free0 (param_name);
			}
		}
	}
	if (suppress_throws == FALSE) {
		_tmp285_ = error_types != NULL;
	} else {
		_tmp285_ = FALSE;
	}
	if (_tmp285_) {
		gchar* _tmp286_ = NULL;
		gchar* _tmp287_;
		gchar** _tmp288_;
		gchar** _tmp289_ = NULL;
		gchar** _tmp290_;
		gint type_args_length1;
		gint _type_args_size_;
		gchar** _tmp291_;
		gchar** type_args;
		_tmp286_ = vala_gidl_parser_eval (self, error_types);
		_tmp287_ = _tmp286_;
		_tmp289_ = _tmp288_ = g_strsplit (_tmp287_, ",", 0);
		_tmp291_ = (_tmp290_ = _tmp289_, _g_free0 (_tmp287_), _tmp290_);
		type_args_length1 = _vala_array_length (_tmp288_);
		_type_args_size_ = type_args_length1;
		type_args = _tmp291_;
		{
			gchar** type_arg_collection;
			int type_arg_collection_length1;
			int type_arg_it;
			type_arg_collection = type_args;
			type_arg_collection_length1 = type_args_length1;
			for (type_arg_it = 0; type_arg_it < type_args_length1; type_arg_it = type_arg_it + 1) {
				gchar* _tmp292_;
				gchar* type_arg;
				_tmp292_ = g_strdup (type_arg_collection[type_arg_it]);
				type_arg = _tmp292_;
				{
					ValaDataType* _tmp293_ = NULL;
					ValaDataType* _tmp294_;
					_tmp293_ = vala_gidl_parser_parse_type_from_string (self, type_arg, TRUE, NULL);
					_tmp294_ = _tmp293_;
					vala_code_node_add_error_type ((ValaCodeNode*) m, _tmp294_);
					_vala_code_node_unref0 (_tmp294_);
					_g_free0 (type_arg);
				}
			}
		}
		type_args = (_vala_array_free (type_args, type_args_length1, (GDestroyNotify) g_free), NULL);
	}
	if (first) {
		vala_method_set_binding (m, VALA_MEMBER_BINDING_STATIC);
	}
	if (last_param != NULL) {
		const gchar* _tmp296_ = NULL;
		gboolean _tmp297_;
		_tmp296_ = vala_symbol_get_name ((ValaSymbol*) last_param);
		_tmp297_ = g_str_has_prefix (_tmp296_, "first_");
		_tmp295_ = _tmp297_;
	} else {
		_tmp295_ = FALSE;
	}
	if (_tmp295_) {
		vala_parameter_set_ellipsis (last_param, TRUE);
	} else {
		if (add_ellipsis) {
			ValaParameter* _tmp298_ = NULL;
			ValaParameter* _tmp299_;
			_tmp298_ = vala_parameter_new_with_ellipsis (NULL);
			_tmp299_ = _tmp298_;
			vala_method_add_parameter (m, _tmp299_);
			_vala_code_node_unref0 (_tmp299_);
		}
	}
	result = m;
	_vala_code_node_unref0 (last_param_type);
	_vala_code_node_unref0 (last_param);
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (error_types);
	_vala_code_node_unref0 (return_type);
	return result;
}


static gchar* string_chomp (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strchomp (_result_);
	result = _result_;
	return result;
}


static gboolean vala_gidl_parser_param_is_exception (ValaGIdlParser* self, GIdlNodeParam* param) {
	gboolean result = FALSE;
	gchar* _tmp0_ = NULL;
	gchar* s;
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (param != NULL, FALSE);
	if (!param->type->is_error) {
		result = FALSE;
		return result;
	}
	_tmp0_ = string_chomp (param->type->unparsed);
	s = _tmp0_;
	_tmp1_ = g_str_has_suffix (s, "**");
	if (_tmp1_) {
		result = TRUE;
		_g_free0 (s);
		return result;
	}
	result = FALSE;
	_g_free0 (s);
	return result;
}


static ValaMethod* vala_gidl_parser_parse_function (ValaGIdlParser* self, GIdlNodeFunction* f, gboolean is_interface) {
	ValaMethod* result = NULL;
	GIdlNode* node;
	ValaMethod* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (f != NULL, NULL);
	node = (GIdlNode*) f;
	if (f->deprecated) {
		result = NULL;
		return result;
	}
	_tmp0_ = vala_gidl_parser_create_method (self, node->name, f->symbol, f->result, f->parameters, f->is_constructor, is_interface);
	result = _tmp0_;
	return result;
}


static ValaMethod* vala_gidl_parser_parse_virtual (ValaGIdlParser* self, GIdlNodeVFunc* v, GIdlNodeFunction* func, gboolean is_interface) {
	ValaMethod* result = NULL;
	GIdlNode* node;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* symbol;
	GList* _tmp6_;
	ValaMethod* _tmp7_ = NULL;
	ValaMethod* m;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (v != NULL, NULL);
	node = (GIdlNode*) v;
	_tmp0_ = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) self->priv->current_data_type);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("%s%s", _tmp1_, node->name);
	symbol = (_tmp3_ = _tmp2_, _g_free0 (_tmp1_), _tmp3_);
	if (func != NULL) {
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = g_strdup (func->symbol);
		_tmp5_ = _tmp4_;
		_g_free0 (symbol);
		symbol = _tmp5_;
	}
	_tmp6_ = NULL;
	if (func != NULL) {
		_tmp6_ = func->parameters;
	} else {
		_tmp6_ = v->parameters;
	}
	_tmp7_ = vala_gidl_parser_create_method (self, node->name, symbol, v->result, _tmp6_, FALSE, is_interface);
	m = _tmp7_;
	if (m != NULL) {
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_;
		gint _tmp12_;
		gchar** _tmp13_ = NULL;
		gint attributes_length1;
		gint _attributes_size_;
		gchar** _tmp14_;
		gchar** attributes;
		vala_method_set_binding (m, VALA_MEMBER_BINDING_INSTANCE);
		_tmp9_ = vala_method_get_is_abstract (m);
		if (_tmp9_) {
			_tmp8_ = TRUE;
		} else {
			_tmp8_ = is_interface;
		}
		vala_method_set_is_virtual (m, !_tmp8_);
		_tmp11_ = vala_method_get_is_abstract (m);
		if (_tmp11_) {
			_tmp10_ = TRUE;
		} else {
			_tmp10_ = is_interface;
		}
		vala_method_set_is_abstract (m, _tmp10_);
		_tmp13_ = vala_gidl_parser_get_attributes (self, symbol, &_tmp12_);
		_tmp14_ = _tmp13_;
		attributes_length1 = _tmp12_;
		_attributes_size_ = attributes_length1;
		attributes = _tmp14_;
		if (attributes != NULL) {
			{
				gchar** attr_collection;
				int attr_collection_length1;
				int attr_it;
				attr_collection = attributes;
				attr_collection_length1 = attributes_length1;
				for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
					gchar* _tmp15_;
					gchar* attr;
					_tmp15_ = g_strdup (attr_collection[attr_it]);
					attr = _tmp15_;
					{
						gchar** _tmp16_;
						gchar** _tmp17_ = NULL;
						gint nv_length1;
						gint _nv_size_;
						gchar** _tmp18_;
						gchar** nv;
						_tmp17_ = _tmp16_ = g_strsplit (attr, "=", 2);
						_tmp18_ = _tmp17_;
						nv_length1 = _vala_array_length (_tmp16_);
						_nv_size_ = nv_length1;
						nv = _tmp18_;
						if (g_strcmp0 (nv[0], "virtual") == 0) {
							gchar* _tmp19_ = NULL;
							gchar* _tmp20_;
							gboolean _tmp21_;
							_tmp19_ = vala_gidl_parser_eval (self, nv[1]);
							_tmp20_ = _tmp19_;
							if ((_tmp21_ = g_strcmp0 (_tmp20_, "0") == 0, _g_free0 (_tmp20_), _tmp21_)) {
								vala_method_set_is_virtual (m, FALSE);
								vala_method_set_is_abstract (m, FALSE);
							} else {
								vala_method_set_is_virtual (m, TRUE);
								vala_method_set_is_abstract (m, FALSE);
							}
						}
						nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (attr);
					}
				}
			}
		}
		if (func == NULL) {
			ValaAttribute* _tmp22_ = NULL;
			_tmp22_ = vala_attribute_new ("NoWrapper", NULL);
			((ValaCodeNode*) m)->attributes = g_list_append (((ValaCodeNode*) m)->attributes, _tmp22_);
		}
		attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	}
	result = m;
	_g_free0 (symbol);
	return result;
}


static gchar* vala_gidl_parser_fix_prop_name (ValaGIdlParser* self, const gchar* name) {
	gchar* result = NULL;
	GString* _tmp0_ = NULL;
	GString* str;
	gchar* _tmp1_;
	gchar* i;
	gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = g_string_new ("");
	str = _tmp0_;
	_tmp1_ = g_strdup (name);
	i = _tmp1_;
	while (TRUE) {
		gint _tmp2_;
		gunichar _tmp3_;
		gunichar c;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp2_ = strlen (i);
		if (!(_tmp2_ > 0)) {
			break;
		}
		_tmp3_ = string_get_char (i, (glong) 0);
		c = _tmp3_;
		if (c == '-') {
			g_string_append_c (str, '_');
		} else {
			g_string_append_unichar (str, c);
		}
		_tmp4_ = g_utf8_next_char (i);
		_tmp5_ = g_strdup (_tmp4_);
		_tmp6_ = _tmp5_;
		_g_free0 (i);
		i = _tmp6_;
	}
	_tmp7_ = g_strdup (str->str);
	result = _tmp7_;
	_g_free0 (i);
	_g_string_free0 (str);
	return result;
}


static ValaProperty* vala_gidl_parser_parse_property (ValaGIdlParser* self, GIdlNodeProperty* prop_node) {
	ValaProperty* result = NULL;
	GIdlNode* node;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	ValaDataType* _tmp3_ = NULL;
	ValaDataType* _tmp4_;
	ValaProperty* _tmp5_ = NULL;
	ValaProperty* _tmp6_;
	ValaProperty* prop;
	gboolean _tmp7_ = FALSE;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_;
	gint _tmp25_;
	gchar** _tmp26_ = NULL;
	gchar** _tmp27_;
	gint attributes_length1;
	gint _attributes_size_;
	gchar** _tmp28_;
	gchar** attributes;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (prop_node != NULL, NULL);
	node = (GIdlNode*) prop_node;
	if (prop_node->deprecated) {
		result = NULL;
		return result;
	}
	if (!prop_node->readable) {
		_tmp0_ = !prop_node->writable;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		prop_node->readable = TRUE;
		prop_node->writable = TRUE;
	}
	_tmp1_ = vala_gidl_parser_fix_prop_name (self, node->name);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_gidl_parser_parse_type (self, prop_node->type, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = vala_property_new (_tmp2_, _tmp4_, NULL, NULL, self->priv->current_source_reference, NULL);
	prop = (_tmp6_ = _tmp5_, _vala_code_node_unref0 (_tmp4_), _g_free0 (_tmp2_), _tmp6_);
	vala_symbol_set_access ((ValaSymbol*) prop, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	vala_property_set_interface_only (prop, TRUE);
	if (prop_node->type->is_interface) {
		_tmp7_ = g_strcmp0 (prop_node->type->interface, "GStrv") == 0;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		vala_property_set_no_array_length (prop, TRUE);
		vala_property_set_array_null_terminated (prop, TRUE);
	}
	if (prop_node->readable) {
		ValaDataType* _tmp8_ = NULL;
		ValaDataType* _tmp9_ = NULL;
		ValaDataType* _tmp10_;
		ValaPropertyAccessor* _tmp11_ = NULL;
		ValaPropertyAccessor* _tmp12_;
		_tmp8_ = vala_property_get_property_type (prop);
		_tmp9_ = vala_data_type_copy (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_property_accessor_new (TRUE, FALSE, FALSE, _tmp10_, NULL, NULL, NULL);
		_tmp12_ = _tmp11_;
		vala_property_set_get_accessor (prop, _tmp12_);
		_vala_code_node_unref0 (_tmp12_);
		_vala_code_node_unref0 (_tmp10_);
	}
	if (prop_node->writable) {
		ValaDataType* _tmp13_ = NULL;
		ValaDataType* _tmp14_ = NULL;
		ValaDataType* _tmp15_;
		ValaPropertyAccessor* _tmp16_ = NULL;
		ValaPropertyAccessor* _tmp17_;
		_tmp13_ = vala_property_get_property_type (prop);
		_tmp14_ = vala_data_type_copy (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_property_accessor_new (FALSE, FALSE, FALSE, _tmp15_, NULL, NULL, NULL);
		_tmp17_ = _tmp16_;
		vala_property_set_set_accessor (prop, _tmp17_);
		_vala_code_node_unref0 (_tmp17_);
		_vala_code_node_unref0 (_tmp15_);
		if (prop_node->construct_only) {
			ValaPropertyAccessor* _tmp18_ = NULL;
			_tmp18_ = vala_property_get_set_accessor (prop);
			vala_property_accessor_set_construction (_tmp18_, TRUE);
		} else {
			ValaPropertyAccessor* _tmp19_ = NULL;
			ValaPropertyAccessor* _tmp20_ = NULL;
			_tmp19_ = vala_property_get_set_accessor (prop);
			vala_property_accessor_set_writable (_tmp19_, TRUE);
			_tmp20_ = vala_property_get_set_accessor (prop);
			vala_property_accessor_set_construction (_tmp20_, prop_node->construct);
		}
	}
	_tmp21_ = vala_typesymbol_get_cname (self->priv->current_data_type, FALSE);
	_tmp22_ = _tmp21_;
	_tmp23_ = g_strdup_printf ("%s:%s", _tmp22_, node->name);
	_tmp24_ = _tmp23_;
	_tmp26_ = vala_gidl_parser_get_attributes (self, _tmp24_, &_tmp25_);
	_tmp28_ = (_tmp27_ = _tmp26_, _g_free0 (_tmp24_), _g_free0 (_tmp22_), _tmp27_);
	attributes_length1 = _tmp25_;
	_attributes_size_ = attributes_length1;
	attributes = _tmp28_;
	if (attributes != NULL) {
		{
			gchar** attr_collection;
			int attr_collection_length1;
			int attr_it;
			attr_collection = attributes;
			attr_collection_length1 = attributes_length1;
			for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
				gchar* _tmp29_;
				gchar* attr;
				_tmp29_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp29_;
				{
					gchar** _tmp30_;
					gchar** _tmp31_ = NULL;
					gint nv_length1;
					gint _nv_size_;
					gchar** _tmp32_;
					gchar** nv;
					_tmp31_ = _tmp30_ = g_strsplit (attr, "=", 2);
					_tmp32_ = _tmp31_;
					nv_length1 = _vala_array_length (_tmp30_);
					_nv_size_ = nv_length1;
					nv = _tmp32_;
					if (g_strcmp0 (nv[0], "hidden") == 0) {
						gchar* _tmp33_ = NULL;
						gchar* _tmp34_;
						gboolean _tmp35_;
						_tmp33_ = vala_gidl_parser_eval (self, nv[1]);
						_tmp34_ = _tmp33_;
						if ((_tmp35_ = g_strcmp0 (_tmp34_, "1") == 0, _g_free0 (_tmp34_), _tmp35_)) {
							result = NULL;
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
							attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
							_vala_code_node_unref0 (prop);
							return result;
						}
					} else {
						if (g_strcmp0 (nv[0], "type_arguments") == 0) {
							ValaDataType* _tmp36_ = NULL;
							gchar* _tmp37_ = NULL;
							gchar* _tmp38_;
							_tmp36_ = vala_property_get_property_type (prop);
							_tmp37_ = vala_gidl_parser_eval (self, nv[1]);
							_tmp38_ = _tmp37_;
							vala_gidl_parser_parse_type_arguments_from_string (self, _tmp36_, _tmp38_, NULL);
							_g_free0 (_tmp38_);
						} else {
							if (g_strcmp0 (nv[0], "deprecated") == 0) {
								gchar* _tmp39_ = NULL;
								gchar* _tmp40_;
								gboolean _tmp41_;
								_tmp39_ = vala_gidl_parser_eval (self, nv[1]);
								_tmp40_ = _tmp39_;
								if ((_tmp41_ = g_strcmp0 (_tmp40_, "1") == 0, _g_free0 (_tmp40_), _tmp41_)) {
									vala_symbol_set_deprecated ((ValaSymbol*) prop, TRUE);
								}
							} else {
								if (g_strcmp0 (nv[0], "replacement") == 0) {
									gchar* _tmp42_ = NULL;
									gchar* _tmp43_;
									_tmp42_ = vala_gidl_parser_eval (self, nv[1]);
									_tmp43_ = _tmp42_;
									vala_symbol_set_replacement ((ValaSymbol*) prop, _tmp43_);
									_g_free0 (_tmp43_);
								} else {
									if (g_strcmp0 (nv[0], "deprecated_since") == 0) {
										gchar* _tmp44_ = NULL;
										gchar* _tmp45_;
										_tmp44_ = vala_gidl_parser_eval (self, nv[1]);
										_tmp45_ = _tmp44_;
										vala_symbol_set_deprecated_since ((ValaSymbol*) prop, _tmp45_);
										_g_free0 (_tmp45_);
									} else {
										if (g_strcmp0 (nv[0], "accessor_method") == 0) {
											gchar* _tmp46_ = NULL;
											gchar* _tmp47_;
											gboolean _tmp48_;
											_tmp46_ = vala_gidl_parser_eval (self, nv[1]);
											_tmp47_ = _tmp46_;
											if ((_tmp48_ = g_strcmp0 (_tmp47_, "0") == 0, _g_free0 (_tmp47_), _tmp48_)) {
												vala_property_set_no_accessor_method (prop, TRUE);
											}
										} else {
											if (g_strcmp0 (nv[0], "owned_get") == 0) {
												gchar* _tmp49_ = NULL;
												gchar* _tmp50_;
												gboolean _tmp51_;
												_tmp49_ = vala_gidl_parser_eval (self, nv[1]);
												_tmp50_ = _tmp49_;
												if ((_tmp51_ = g_strcmp0 (_tmp50_, "1") == 0, _g_free0 (_tmp50_), _tmp51_)) {
													ValaPropertyAccessor* _tmp52_ = NULL;
													ValaDataType* _tmp53_ = NULL;
													_tmp52_ = vala_property_get_get_accessor (prop);
													_tmp53_ = vala_property_accessor_get_value_type (_tmp52_);
													vala_data_type_set_value_owned (_tmp53_, TRUE);
												}
											} else {
												if (g_strcmp0 (nv[0], "type_name") == 0) {
													gchar* _tmp54_ = NULL;
													gchar* _tmp55_;
													ValaDataType* _tmp56_ = NULL;
													ValaDataType* _tmp57_;
													_tmp54_ = vala_gidl_parser_eval (self, nv[1]);
													_tmp55_ = _tmp54_;
													_tmp56_ = vala_gidl_parser_parse_type_from_string (self, _tmp55_, FALSE, NULL);
													_tmp57_ = _tmp56_;
													vala_property_set_property_type (prop, _tmp57_);
													_vala_code_node_unref0 (_tmp57_);
													_g_free0 (_tmp55_);
												}
											}
										}
									}
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	if (self->priv->current_type_symbol_set != NULL) {
		const gchar* _tmp58_ = NULL;
		_tmp58_ = vala_symbol_get_name ((ValaSymbol*) prop);
		vala_collection_add ((ValaCollection*) self->priv->current_type_symbol_set, _tmp58_);
	}
	result = prop;
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static ValaConstant* vala_gidl_parser_parse_constant (ValaGIdlParser* self, GIdlNodeConstant* const_node) {
	ValaConstant* result = NULL;
	GIdlNode* node;
	ValaDataType* _tmp0_ = NULL;
	ValaDataType* type;
	ValaConstant* _tmp1_ = NULL;
	ValaConstant* c;
	gint _tmp2_;
	gchar** _tmp3_ = NULL;
	gint attributes_length1;
	gint _attributes_size_;
	gchar** _tmp4_;
	gchar** attributes;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (const_node != NULL, NULL);
	node = (GIdlNode*) const_node;
	_tmp0_ = vala_gidl_parser_parse_type (self, const_node->type, NULL);
	type = _tmp0_;
	if (type == NULL) {
		result = NULL;
		_vala_code_node_unref0 (type);
		return result;
	}
	_tmp1_ = vala_constant_new (node->name, type, NULL, self->priv->current_source_reference, NULL);
	c = _tmp1_;
	vala_symbol_set_external ((ValaSymbol*) c, TRUE);
	_tmp3_ = vala_gidl_parser_get_attributes (self, node->name, &_tmp2_);
	_tmp4_ = _tmp3_;
	attributes_length1 = _tmp2_;
	_attributes_size_ = attributes_length1;
	attributes = _tmp4_;
	if (attributes != NULL) {
		{
			gchar** attr_collection;
			int attr_collection_length1;
			int attr_it;
			attr_collection = attributes;
			attr_collection_length1 = attributes_length1;
			for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
				gchar* _tmp5_;
				gchar* attr;
				_tmp5_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp5_;
				{
					gchar** _tmp6_;
					gchar** _tmp7_ = NULL;
					gint nv_length1;
					gint _nv_size_;
					gchar** _tmp8_;
					gchar** nv;
					_tmp7_ = _tmp6_ = g_strsplit (attr, "=", 2);
					_tmp8_ = _tmp7_;
					nv_length1 = _vala_array_length (_tmp6_);
					_nv_size_ = nv_length1;
					nv = _tmp8_;
					if (g_strcmp0 (nv[0], "cheader_filename") == 0) {
						gchar* _tmp9_ = NULL;
						gchar* _tmp10_;
						_tmp9_ = vala_gidl_parser_eval (self, nv[1]);
						_tmp10_ = _tmp9_;
						vala_symbol_add_cheader_filename ((ValaSymbol*) c, _tmp10_);
						_g_free0 (_tmp10_);
					} else {
						if (g_strcmp0 (nv[0], "deprecated") == 0) {
							gchar* _tmp11_ = NULL;
							gchar* _tmp12_;
							gboolean _tmp13_;
							_tmp11_ = vala_gidl_parser_eval (self, nv[1]);
							_tmp12_ = _tmp11_;
							if ((_tmp13_ = g_strcmp0 (_tmp12_, "1") == 0, _g_free0 (_tmp12_), _tmp13_)) {
								vala_symbol_set_deprecated ((ValaSymbol*) c, TRUE);
							}
						} else {
							if (g_strcmp0 (nv[0], "replacement") == 0) {
								gchar* _tmp14_ = NULL;
								gchar* _tmp15_;
								_tmp14_ = vala_gidl_parser_eval (self, nv[1]);
								_tmp15_ = _tmp14_;
								vala_symbol_set_replacement ((ValaSymbol*) c, _tmp15_);
								_g_free0 (_tmp15_);
							} else {
								if (g_strcmp0 (nv[0], "deprecated_since") == 0) {
									gchar* _tmp16_ = NULL;
									gchar* _tmp17_;
									_tmp16_ = vala_gidl_parser_eval (self, nv[1]);
									_tmp17_ = _tmp16_;
									vala_symbol_set_deprecated_since ((ValaSymbol*) c, _tmp17_);
									_g_free0 (_tmp17_);
								} else {
									if (g_strcmp0 (nv[0], "hidden") == 0) {
										gchar* _tmp18_ = NULL;
										gchar* _tmp19_;
										gboolean _tmp20_;
										_tmp18_ = vala_gidl_parser_eval (self, nv[1]);
										_tmp19_ = _tmp18_;
										if ((_tmp20_ = g_strcmp0 (_tmp19_, "1") == 0, _g_free0 (_tmp19_), _tmp20_)) {
											result = NULL;
											nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
											_g_free0 (attr);
											attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
											_vala_code_node_unref0 (c);
											_vala_code_node_unref0 (type);
											return result;
										}
									}
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	vala_symbol_set_access ((ValaSymbol*) c, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	result = c;
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	_vala_code_node_unref0 (type);
	return result;
}


static ValaField* vala_gidl_parser_parse_field (ValaGIdlParser* self, GIdlNodeField* field_node) {
	ValaField* result = NULL;
	GIdlNode* node;
	gboolean unhidden;
	ValaDataType* _tmp0_ = NULL;
	ValaDataType* type;
	gchar* cheader_filename;
	gchar* ctype;
	gchar* array_length_cname;
	gchar* array_length_type;
	gboolean array_null_terminated;
	gboolean deprecated;
	gchar* deprecated_since;
	gchar* replacement;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gint _tmp5_;
	gchar** _tmp6_ = NULL;
	gchar** _tmp7_;
	gint attributes_length1;
	gint _attributes_size_;
	gchar** _tmp8_;
	gchar** attributes;
	gboolean _tmp49_ = FALSE;
	gboolean _tmp50_;
	gchar* _tmp51_;
	gchar* field_name;
	ValaField* _tmp54_ = NULL;
	ValaField* field;
	gboolean _tmp55_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (field_node != NULL, NULL);
	node = (GIdlNode*) field_node;
	unhidden = FALSE;
	_tmp0_ = vala_gidl_parser_parse_type (self, field_node->type, NULL);
	type = _tmp0_;
	if (type == NULL) {
		result = NULL;
		_vala_code_node_unref0 (type);
		return result;
	}
	cheader_filename = NULL;
	ctype = NULL;
	array_length_cname = NULL;
	array_length_type = NULL;
	array_null_terminated = FALSE;
	deprecated = FALSE;
	deprecated_since = NULL;
	replacement = NULL;
	_tmp1_ = vala_typesymbol_get_cname (self->priv->current_data_type, FALSE);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf ("%s.%s", _tmp2_, node->name);
	_tmp4_ = _tmp3_;
	_tmp6_ = vala_gidl_parser_get_attributes (self, _tmp4_, &_tmp5_);
	_tmp8_ = (_tmp7_ = _tmp6_, _g_free0 (_tmp4_), _g_free0 (_tmp2_), _tmp7_);
	attributes_length1 = _tmp5_;
	_attributes_size_ = attributes_length1;
	attributes = _tmp8_;
	if (attributes != NULL) {
		{
			gchar** attr_collection;
			int attr_collection_length1;
			int attr_it;
			attr_collection = attributes;
			attr_collection_length1 = attributes_length1;
			for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
				gchar* _tmp9_;
				gchar* attr;
				_tmp9_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp9_;
				{
					gchar** _tmp10_;
					gchar** _tmp11_ = NULL;
					gint nv_length1;
					gint _nv_size_;
					gchar** _tmp12_;
					gchar** nv;
					_tmp11_ = _tmp10_ = g_strsplit (attr, "=", 2);
					_tmp12_ = _tmp11_;
					nv_length1 = _vala_array_length (_tmp10_);
					_nv_size_ = nv_length1;
					nv = _tmp12_;
					if (g_strcmp0 (nv[0], "hidden") == 0) {
						gchar* _tmp13_ = NULL;
						gchar* _tmp14_;
						gboolean _tmp15_;
						_tmp13_ = vala_gidl_parser_eval (self, nv[1]);
						_tmp14_ = _tmp13_;
						if ((_tmp15_ = g_strcmp0 (_tmp14_, "1") == 0, _g_free0 (_tmp14_), _tmp15_)) {
							result = NULL;
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
							attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (replacement);
							_g_free0 (deprecated_since);
							_g_free0 (array_length_type);
							_g_free0 (array_length_cname);
							_g_free0 (ctype);
							_g_free0 (cheader_filename);
							_vala_code_node_unref0 (type);
							return result;
						} else {
							unhidden = TRUE;
						}
					} else {
						if (g_strcmp0 (nv[0], "is_array") == 0) {
							gchar* _tmp16_ = NULL;
							gchar* _tmp17_;
							gboolean _tmp18_;
							_tmp16_ = vala_gidl_parser_eval (self, nv[1]);
							_tmp17_ = _tmp16_;
							if ((_tmp18_ = g_strcmp0 (_tmp17_, "1") == 0, _g_free0 (_tmp17_), _tmp18_)) {
								ValaSourceReference* _tmp19_ = NULL;
								ValaArrayType* _tmp20_ = NULL;
								ValaDataType* _tmp21_;
								_tmp19_ = vala_code_node_get_source_reference ((ValaCodeNode*) type);
								_tmp20_ = vala_array_type_new (type, 1, _tmp19_);
								_tmp21_ = (ValaDataType*) _tmp20_;
								_vala_code_node_unref0 (type);
								type = _tmp21_;
							}
						} else {
							if (g_strcmp0 (nv[0], "weak") == 0) {
								gchar* _tmp22_ = NULL;
								gchar* _tmp23_;
								gboolean _tmp24_;
								_tmp22_ = vala_gidl_parser_eval (self, nv[1]);
								_tmp23_ = _tmp22_;
								if ((_tmp24_ = g_strcmp0 (_tmp23_, "0") == 0, _g_free0 (_tmp23_), _tmp24_)) {
									vala_data_type_set_value_owned (type, TRUE);
								}
							} else {
								if (g_strcmp0 (nv[0], "type_name") == 0) {
									gchar* _tmp25_ = NULL;
									gchar* _tmp26_;
									ValaDataType* _tmp27_ = NULL;
									ValaDataType* _tmp28_;
									_tmp25_ = vala_gidl_parser_eval (self, nv[1]);
									_tmp26_ = _tmp25_;
									_tmp27_ = vala_gidl_parser_parse_type_from_string (self, _tmp26_, TRUE, NULL);
									_tmp28_ = _tmp27_;
									_vala_code_node_unref0 (type);
									type = _tmp28_;
									_g_free0 (_tmp26_);
								} else {
									if (g_strcmp0 (nv[0], "type_arguments") == 0) {
										gchar* _tmp29_ = NULL;
										gchar* _tmp30_;
										_tmp29_ = vala_gidl_parser_eval (self, nv[1]);
										_tmp30_ = _tmp29_;
										vala_gidl_parser_parse_type_arguments_from_string (self, type, _tmp30_, NULL);
										_g_free0 (_tmp30_);
									} else {
										if (g_strcmp0 (nv[0], "deprecated") == 0) {
											gchar* _tmp31_ = NULL;
											gchar* _tmp32_;
											gboolean _tmp33_;
											_tmp31_ = vala_gidl_parser_eval (self, nv[1]);
											_tmp32_ = _tmp31_;
											if ((_tmp33_ = g_strcmp0 (_tmp32_, "1") == 0, _g_free0 (_tmp32_), _tmp33_)) {
												deprecated = TRUE;
											}
										} else {
											if (g_strcmp0 (nv[0], "replacement") == 0) {
												gchar* _tmp34_ = NULL;
												gchar* _tmp35_;
												_tmp34_ = vala_gidl_parser_eval (self, nv[1]);
												_tmp35_ = _tmp34_;
												_g_free0 (replacement);
												replacement = _tmp35_;
											} else {
												if (g_strcmp0 (nv[0], "deprecated_since") == 0) {
													gchar* _tmp36_ = NULL;
													gchar* _tmp37_;
													_tmp36_ = vala_gidl_parser_eval (self, nv[1]);
													_tmp37_ = _tmp36_;
													_g_free0 (deprecated_since);
													deprecated_since = _tmp37_;
												} else {
													if (g_strcmp0 (nv[0], "cheader_filename") == 0) {
														gchar* _tmp38_ = NULL;
														gchar* _tmp39_;
														_tmp38_ = vala_gidl_parser_eval (self, nv[1]);
														_tmp39_ = _tmp38_;
														_g_free0 (cheader_filename);
														cheader_filename = _tmp39_;
													} else {
														if (g_strcmp0 (nv[0], "ctype") == 0) {
															gchar* _tmp40_ = NULL;
															gchar* _tmp41_;
															_tmp40_ = vala_gidl_parser_eval (self, nv[1]);
															_tmp41_ = _tmp40_;
															_g_free0 (ctype);
															ctype = _tmp41_;
														} else {
															if (g_strcmp0 (nv[0], "array_null_terminated") == 0) {
																gchar* _tmp42_ = NULL;
																gchar* _tmp43_;
																gboolean _tmp44_;
																_tmp42_ = vala_gidl_parser_eval (self, nv[1]);
																_tmp43_ = _tmp42_;
																if ((_tmp44_ = g_strcmp0 (_tmp43_, "1") == 0, _g_free0 (_tmp43_), _tmp44_)) {
																	array_null_terminated = TRUE;
																}
															} else {
																if (g_strcmp0 (nv[0], "array_length_cname") == 0) {
																	gchar* _tmp45_ = NULL;
																	gchar* _tmp46_;
																	_tmp45_ = vala_gidl_parser_eval (self, nv[1]);
																	_tmp46_ = _tmp45_;
																	_g_free0 (array_length_cname);
																	array_length_cname = _tmp46_;
																} else {
																	if (g_strcmp0 (nv[0], "array_length_type") == 0) {
																		gchar* _tmp47_ = NULL;
																		gchar* _tmp48_;
																		_tmp47_ = vala_gidl_parser_eval (self, nv[1]);
																		_tmp48_ = _tmp47_;
																		_g_free0 (array_length_type);
																		array_length_type = _tmp48_;
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	_tmp50_ = g_str_has_prefix (node->name, "_");
	if (_tmp50_) {
		_tmp49_ = !unhidden;
	} else {
		_tmp49_ = FALSE;
	}
	if (_tmp49_) {
		result = NULL;
		attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (replacement);
		_g_free0 (deprecated_since);
		_g_free0 (array_length_type);
		_g_free0 (array_length_cname);
		_g_free0 (ctype);
		_g_free0 (cheader_filename);
		_vala_code_node_unref0 (type);
		return result;
	}
	if (self->priv->current_type_symbol_set != NULL) {
		vala_collection_add ((ValaCollection*) self->priv->current_type_symbol_set, node->name);
	}
	_tmp51_ = g_strdup (node->name);
	field_name = _tmp51_;
	if (g_strcmp0 (field_name, "string") == 0) {
		gchar* _tmp52_;
		gchar* _tmp53_;
		_tmp52_ = g_strdup ("str");
		_tmp53_ = _tmp52_;
		_g_free0 (field_name);
		field_name = _tmp53_;
	}
	_tmp54_ = vala_field_new (field_name, type, NULL, self->priv->current_source_reference, NULL);
	field = _tmp54_;
	vala_symbol_set_access ((ValaSymbol*) field, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	if (g_strcmp0 (field_name, node->name) != 0) {
		vala_field_set_cname (field, node->name);
	}
	if (deprecated) {
		vala_symbol_set_deprecated ((ValaSymbol*) field, TRUE);
		if (deprecated_since != NULL) {
			vala_symbol_set_deprecated_since ((ValaSymbol*) field, deprecated_since);
		}
		if (replacement != NULL) {
			vala_symbol_set_replacement ((ValaSymbol*) field, replacement);
		}
	}
	if (ctype != NULL) {
		vala_field_set_ctype (field, ctype);
	}
	if (cheader_filename != NULL) {
		vala_symbol_add_cheader_filename ((ValaSymbol*) field, cheader_filename);
	}
	if (array_null_terminated) {
		vala_field_set_array_null_terminated (field, TRUE);
	}
	if (array_length_cname != NULL) {
		_tmp55_ = TRUE;
	} else {
		_tmp55_ = array_length_type != NULL;
	}
	if (_tmp55_) {
		if (array_length_cname != NULL) {
			vala_field_set_array_length_cname (field, array_length_cname);
		}
		if (array_length_type != NULL) {
			vala_field_set_array_length_type (field, array_length_type);
		}
	} else {
		vala_field_set_no_array_length (field, TRUE);
	}
	result = field;
	_g_free0 (field_name);
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (replacement);
	_g_free0 (deprecated_since);
	_g_free0 (array_length_type);
	_g_free0 (array_length_cname);
	_g_free0 (ctype);
	_g_free0 (cheader_filename);
	_vala_code_node_unref0 (type);
	return result;
}


static gint string_index_of_nth_char (const gchar* self, glong c) {
	gint result = 0;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_offset_to_pointer (self, c);
	result = (gint) (_tmp0_ - ((gchar*) self));
	return result;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_slist_free__g_free0_ (GSList* self) {
	g_slist_foreach (self, (GFunc) _g_free0_, NULL);
	g_slist_free (self);
}


static gchar** vala_gidl_parser_get_attributes (ValaGIdlParser* self, const gchar* codenode, int* result_length1) {
	gchar** result = NULL;
	gpointer _tmp0_ = NULL;
	gchar* attributes;
	GSList* attr_list;
	gint _tmp18_;
	GString* _tmp19_ = NULL;
	GString* attr;
	gint _tmp20_;
	gint attributes_len;
	const gchar* remaining;
	gboolean quoted;
	gboolean escaped;
	guint _tmp27_;
	gchar** _tmp28_ = NULL;
	gint attrs_length1;
	gint _attrs_size_;
	gchar** _tmp29_;
	gchar** attrs;
	GSList* attr_i;
	gchar** _tmp34_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (codenode != NULL, NULL);
	_tmp0_ = vala_map_get (self->priv->codenode_attributes_map, codenode);
	attributes = (gchar*) _tmp0_;
	if (attributes == NULL) {
		gint _tmp1_;
		gboolean dot_required;
		gint _tmp2_;
		gboolean colon_required;
		ValaSet* _tmp3_ = NULL;
		ValaSet* pattern_specs;
		_tmp1_ = string_index_of_char (codenode, (gunichar) '.', 0);
		dot_required = (-1) != _tmp1_;
		_tmp2_ = string_index_of_char (codenode, (gunichar) ':', 0);
		colon_required = (-1) != _tmp2_;
		_tmp3_ = vala_map_get_keys (self->priv->codenode_attributes_patterns);
		pattern_specs = _tmp3_;
		{
			ValaIterator* _tmp4_ = NULL;
			ValaIterator* _pattern_it;
			_tmp4_ = vala_iterable_iterator ((ValaIterable*) pattern_specs);
			_pattern_it = _tmp4_;
			while (TRUE) {
				gboolean _tmp5_;
				gpointer _tmp6_ = NULL;
				GPatternSpec* pattern;
				gpointer _tmp7_ = NULL;
				gchar* pspec;
				gboolean _tmp8_ = FALSE;
				gboolean _tmp9_ = FALSE;
				gboolean _tmp13_;
				_tmp5_ = vala_iterator_next (_pattern_it);
				if (!_tmp5_) {
					break;
				}
				_tmp6_ = vala_iterator_get (_pattern_it);
				pattern = _tmp6_;
				_tmp7_ = vala_map_get (self->priv->codenode_attributes_patterns, pattern);
				pspec = (gchar*) _tmp7_;
				if (dot_required) {
					gint _tmp10_;
					_tmp10_ = string_index_of_char (pspec, (gunichar) '.', 0);
					_tmp9_ = (-1) != _tmp10_;
				} else {
					_tmp9_ = FALSE;
				}
				if (_tmp9_) {
					_tmp8_ = TRUE;
				} else {
					gboolean _tmp11_ = FALSE;
					if (colon_required) {
						gint _tmp12_;
						_tmp12_ = string_index_of_char (pspec, (gunichar) ':', 0);
						_tmp11_ = (-1) != _tmp12_;
					} else {
						_tmp11_ = FALSE;
					}
					_tmp8_ = _tmp11_;
				}
				if (_tmp8_) {
					_g_free0 (pspec);
					continue;
				}
				_tmp13_ = g_pattern_match_string (pattern, codenode);
				if (_tmp13_) {
					gint _tmp14_;
					gchar** _tmp15_ = NULL;
					gchar** _tmp16_;
					_tmp15_ = vala_gidl_parser_get_attributes (self, pspec, &_tmp14_);
					_tmp16_ = _tmp15_;
					*result_length1 = _tmp14_;
					result = _tmp16_;
					_g_free0 (pspec);
					_vala_iterator_unref0 (_pattern_it);
					_vala_iterable_unref0 (pattern_specs);
					_g_free0 (attributes);
					return result;
				}
				_g_free0 (pspec);
			}
			_vala_iterator_unref0 (_pattern_it);
		}
		_vala_iterable_unref0 (pattern_specs);
	}
	if (attributes == NULL) {
		gpointer _tmp17_;
		_tmp17_ = NULL;
		*result_length1 = 0;
		result = _tmp17_;
		_g_free0 (attributes);
		return result;
	}
	attr_list = NULL;
	_tmp18_ = strlen (attributes);
	_tmp19_ = g_string_sized_new ((gsize) _tmp18_);
	attr = _tmp19_;
	_tmp20_ = strlen (attributes);
	attributes_len = _tmp20_;
	remaining = attributes;
	quoted = FALSE;
	escaped = FALSE;
	{
		gint b;
		b = 0;
		{
			gboolean _tmp21_;
			_tmp21_ = TRUE;
			while (TRUE) {
				gunichar _tmp22_;
				gunichar c;
				gint _tmp25_;
				if (!_tmp21_) {
					b++;
				}
				_tmp21_ = FALSE;
				if (!(b < attributes_len)) {
					break;
				}
				_tmp22_ = string_get_char (remaining, (glong) 0);
				c = _tmp22_;
				if (escaped) {
					escaped = FALSE;
					g_string_append_unichar (attr, c);
				} else {
					if (c == '"') {
						g_string_append_unichar (attr, c);
						quoted = !quoted;
					} else {
						if (c == '\\') {
							escaped = TRUE;
						} else {
							gboolean _tmp23_ = FALSE;
							if (!quoted) {
								_tmp23_ = c == ' ';
							} else {
								_tmp23_ = FALSE;
							}
							if (_tmp23_) {
								gchar* _tmp24_;
								_tmp24_ = g_strdup (attr->str);
								attr_list = g_slist_prepend (attr_list, _tmp24_);
								g_string_truncate (attr, (gsize) 0);
							} else {
								g_string_append_unichar (attr, c);
							}
						}
					}
				}
				_tmp25_ = string_index_of_nth_char (remaining, (glong) 1);
				remaining = (const gchar*) (((gchar*) remaining) + _tmp25_);
			}
		}
	}
	if (attr->len > 0) {
		gchar* _tmp26_;
		_tmp26_ = g_strdup (attr->str);
		attr_list = g_slist_prepend (attr_list, _tmp26_);
	}
	_tmp27_ = g_slist_length (attr_list);
	_tmp28_ = g_new0 (gchar*, _tmp27_ + 1);
	_tmp29_ = _tmp28_;
	attrs_length1 = _tmp27_;
	_attrs_size_ = attrs_length1;
	attrs = _tmp29_;
	attr_i = attr_list;
	{
		gint a;
		a = 0;
		{
			gboolean _tmp30_;
			_tmp30_ = TRUE;
			while (TRUE) {
				gchar* _tmp31_;
				gchar* *_tmp32_;
				gchar* _tmp33_;
				if (!_tmp30_) {
					a++;
					attr_i = attr_i->next;
				}
				_tmp30_ = FALSE;
				if (!(a < attrs_length1)) {
					break;
				}
				_tmp31_ = g_strdup ((const gchar*) attr_i->data);
				_tmp32_ = &attrs[(attrs_length1 - 1) - a];
				_tmp33_ = _tmp31_;
				_g_free0 ((*_tmp32_));
				(*_tmp32_) = _tmp33_;
			}
		}
	}
	_tmp34_ = attrs;
	*result_length1 = attrs_length1;
	result = _tmp34_;
	_g_string_free0 (attr);
	__g_slist_free__g_free0_0 (attr_list);
	_g_free0 (attributes);
	return result;
}


static gchar* vala_gidl_parser_eval (ValaGIdlParser* self, const gchar* s) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (s != NULL, NULL);
	_tmp0_ = NULL;
	_tmp3_ = strlen (s);
	if (_tmp3_ >= 2) {
		gboolean _tmp4_;
		_tmp4_ = g_str_has_prefix (s, "\"");
		_tmp2_ = _tmp4_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gboolean _tmp5_;
		_tmp5_ = g_str_has_suffix (s, "\"");
		_tmp1_ = _tmp5_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gint _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp6_ = strlen (s);
		_tmp7_ = string_substring (s, (glong) 1, (glong) (_tmp6_ - 2));
		_tmp8_ = _tmp7_;
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp8_;
	} else {
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp9_ = g_strdup (s);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp10_;
	}
	result = _tmp0_;
	return result;
}


static ValaSignal* vala_gidl_parser_parse_signal (ValaGIdlParser* self, GIdlNodeSignal* sig_node) {
	ValaSignal* result = NULL;
	GIdlNode* node;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	ValaDataType* _tmp3_ = NULL;
	ValaDataType* _tmp4_;
	ValaSignal* _tmp5_ = NULL;
	ValaSignal* _tmp6_;
	ValaSignal* sig;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	gint _tmp12_;
	gchar** _tmp13_ = NULL;
	gchar** _tmp14_;
	gint attributes_length1;
	gint _attributes_size_;
	gchar** _tmp15_;
	gchar** attributes;
	gboolean first;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sig_node != NULL, NULL);
	node = (GIdlNode*) sig_node;
	if (sig_node->deprecated) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = sig_node->result == NULL;
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	_tmp1_ = vala_gidl_parser_fix_prop_name (self, node->name);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_gidl_parser_parse_param (self, sig_node->result, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = vala_signal_new (_tmp2_, _tmp4_, self->priv->current_source_reference, NULL);
	sig = (_tmp6_ = _tmp5_, _vala_code_node_unref0 (_tmp4_), _g_free0 (_tmp2_), _tmp6_);
	vala_symbol_set_access ((ValaSymbol*) sig, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp7_ = vala_typesymbol_get_cname (self->priv->current_data_type, FALSE);
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_symbol_get_name ((ValaSymbol*) sig);
	_tmp10_ = g_strdup_printf ("%s::%s", _tmp8_, _tmp9_);
	_tmp11_ = _tmp10_;
	_tmp13_ = vala_gidl_parser_get_attributes (self, _tmp11_, &_tmp12_);
	_tmp15_ = (_tmp14_ = _tmp13_, _g_free0 (_tmp11_), _g_free0 (_tmp8_), _tmp14_);
	attributes_length1 = _tmp12_;
	_attributes_size_ = attributes_length1;
	attributes = _tmp15_;
	if (attributes != NULL) {
		gchar* ns_name;
		ns_name = NULL;
		{
			gchar** attr_collection;
			int attr_collection_length1;
			int attr_it;
			attr_collection = attributes;
			attr_collection_length1 = attributes_length1;
			for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
				gchar* _tmp16_;
				gchar* attr;
				_tmp16_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp16_;
				{
					gchar** _tmp17_;
					gchar** _tmp18_ = NULL;
					gint nv_length1;
					gint _nv_size_;
					gchar** _tmp19_;
					gchar** nv;
					_tmp18_ = _tmp17_ = g_strsplit (attr, "=", 2);
					_tmp19_ = _tmp18_;
					nv_length1 = _vala_array_length (_tmp17_);
					_nv_size_ = nv_length1;
					nv = _tmp19_;
					if (g_strcmp0 (nv[0], "name") == 0) {
						const gchar* _tmp20_ = NULL;
						gchar* _tmp21_ = NULL;
						gchar* _tmp22_;
						_tmp20_ = vala_symbol_get_name ((ValaSymbol*) sig);
						vala_signal_set_cname (sig, _tmp20_);
						_tmp21_ = vala_gidl_parser_eval (self, nv[1]);
						_tmp22_ = _tmp21_;
						vala_symbol_set_name ((ValaSymbol*) sig, _tmp22_);
						_g_free0 (_tmp22_);
					} else {
						gboolean _tmp23_ = FALSE;
						if (g_strcmp0 (nv[0], "has_emitter") == 0) {
							gchar* _tmp24_ = NULL;
							gchar* _tmp25_;
							_tmp24_ = vala_gidl_parser_eval (self, nv[1]);
							_tmp25_ = _tmp24_;
							_tmp23_ = g_strcmp0 (_tmp25_, "1") == 0;
							_g_free0 (_tmp25_);
						} else {
							_tmp23_ = FALSE;
						}
						if (_tmp23_) {
							vala_signal_set_has_emitter (sig, TRUE);
						} else {
							if (g_strcmp0 (nv[0], "hidden") == 0) {
								gchar* _tmp26_ = NULL;
								gchar* _tmp27_;
								gboolean _tmp28_;
								_tmp26_ = vala_gidl_parser_eval (self, nv[1]);
								_tmp27_ = _tmp26_;
								if ((_tmp28_ = g_strcmp0 (_tmp27_, "1") == 0, _g_free0 (_tmp27_), _tmp28_)) {
									result = NULL;
									nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
									_g_free0 (attr);
									_g_free0 (ns_name);
									attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
									_vala_code_node_unref0 (sig);
									return result;
								}
							} else {
								if (g_strcmp0 (nv[0], "deprecated") == 0) {
									gchar* _tmp29_ = NULL;
									gchar* _tmp30_;
									gboolean _tmp31_;
									_tmp29_ = vala_gidl_parser_eval (self, nv[1]);
									_tmp30_ = _tmp29_;
									if ((_tmp31_ = g_strcmp0 (_tmp30_, "1") == 0, _g_free0 (_tmp30_), _tmp31_)) {
										vala_symbol_set_deprecated ((ValaSymbol*) sig, TRUE);
									}
								} else {
									if (g_strcmp0 (nv[0], "replacement") == 0) {
										gchar* _tmp32_ = NULL;
										gchar* _tmp33_;
										_tmp32_ = vala_gidl_parser_eval (self, nv[1]);
										_tmp33_ = _tmp32_;
										vala_symbol_set_replacement ((ValaSymbol*) sig, _tmp33_);
										_g_free0 (_tmp33_);
									} else {
										if (g_strcmp0 (nv[0], "deprecated_since") == 0) {
											gchar* _tmp34_ = NULL;
											gchar* _tmp35_;
											_tmp34_ = vala_gidl_parser_eval (self, nv[1]);
											_tmp35_ = _tmp34_;
											vala_symbol_set_deprecated_since ((ValaSymbol*) sig, _tmp35_);
											_g_free0 (_tmp35_);
										} else {
											if (g_strcmp0 (nv[0], "transfer_ownership") == 0) {
												gchar* _tmp36_ = NULL;
												gchar* _tmp37_;
												gboolean _tmp38_;
												_tmp36_ = vala_gidl_parser_eval (self, nv[1]);
												_tmp37_ = _tmp36_;
												if ((_tmp38_ = g_strcmp0 (_tmp37_, "1") == 0, _g_free0 (_tmp37_), _tmp38_)) {
													ValaDataType* _tmp39_ = NULL;
													_tmp39_ = vala_signal_get_return_type (sig);
													vala_data_type_set_value_owned (_tmp39_, TRUE);
												}
											} else {
												if (g_strcmp0 (nv[0], "namespace_name") == 0) {
													gchar* _tmp40_ = NULL;
													gchar* _tmp41_;
													_tmp40_ = vala_gidl_parser_eval (self, nv[1]);
													_tmp41_ = _tmp40_;
													_g_free0 (ns_name);
													ns_name = _tmp41_;
												} else {
													if (g_strcmp0 (nv[0], "type_name") == 0) {
														gchar* _tmp42_ = NULL;
														gchar* _tmp43_;
														ValaDataType* _tmp44_ = NULL;
														ValaDataType* _tmp45_;
														_tmp42_ = vala_gidl_parser_eval (self, nv[1]);
														_tmp43_ = _tmp42_;
														_tmp44_ = vala_gidl_parser_parse_type_from_string (self, _tmp43_, FALSE, NULL);
														_tmp45_ = _tmp44_;
														vala_signal_set_return_type (sig, _tmp45_);
														_vala_code_node_unref0 (_tmp45_);
														_g_free0 (_tmp43_);
													} else {
														if (g_strcmp0 (nv[0], "type_arguments") == 0) {
															ValaDataType* _tmp46_ = NULL;
															gchar* _tmp47_ = NULL;
															gchar* _tmp48_;
															_tmp46_ = vala_signal_get_return_type (sig);
															_tmp47_ = vala_gidl_parser_eval (self, nv[1]);
															_tmp48_ = _tmp47_;
															vala_gidl_parser_parse_type_arguments_from_string (self, _tmp46_, _tmp48_, NULL);
															_g_free0 (_tmp48_);
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
		if (ns_name != NULL) {
			ValaDataType* _tmp49_ = NULL;
			ValaUnresolvedSymbol* _tmp50_ = NULL;
			ValaUnresolvedSymbol* _tmp51_ = NULL;
			ValaUnresolvedSymbol* _tmp52_;
			_tmp49_ = vala_signal_get_return_type (sig);
			_tmp50_ = vala_unresolved_type_get_unresolved_symbol (VALA_UNRESOLVED_TYPE (_tmp49_));
			_tmp51_ = vala_unresolved_symbol_new (NULL, ns_name, NULL);
			_tmp52_ = _tmp51_;
			vala_unresolved_symbol_set_inner (_tmp50_, _tmp52_);
			_vala_code_node_unref0 (_tmp52_);
		}
		_g_free0 (ns_name);
	}
	vala_signal_set_is_virtual (sig, TRUE);
	first = TRUE;
	{
		GList* param_collection;
		GList* param_it;
		param_collection = sig_node->parameters;
		for (param_it = param_collection; param_it != NULL; param_it = param_it->next) {
			GIdlNodeParam* param;
			param = (GIdlNodeParam*) param_it->data;
			{
				GIdlNode* param_node;
				ValaParameterDirection direction = 0;
				ValaParameterDirection _tmp53_;
				ValaDataType* _tmp54_ = NULL;
				ValaDataType* param_type;
				ValaParameter* _tmp55_ = NULL;
				ValaParameter* p;
				gboolean hide_param;
				gboolean show_param;
				gchar* _tmp56_ = NULL;
				gchar* _tmp57_;
				const gchar* _tmp58_ = NULL;
				gchar* _tmp59_ = NULL;
				gchar* _tmp60_;
				gint _tmp61_;
				gchar** _tmp62_ = NULL;
				gchar** _tmp63_;
				gboolean _tmp104_ = FALSE;
				if (first) {
					first = FALSE;
					continue;
				}
				param_node = (GIdlNode*) param;
				_tmp54_ = vala_gidl_parser_parse_param (self, param, &_tmp53_);
				direction = _tmp53_;
				param_type = _tmp54_;
				_tmp55_ = vala_parameter_new (param_node->name, param_type, NULL);
				p = _tmp55_;
				vala_parameter_set_direction (p, direction);
				hide_param = FALSE;
				show_param = FALSE;
				_tmp56_ = vala_typesymbol_get_cname (self->priv->current_data_type, FALSE);
				_tmp57_ = _tmp56_;
				_tmp58_ = vala_symbol_get_name ((ValaSymbol*) sig);
				_tmp59_ = g_strdup_printf ("%s::%s.%s", _tmp57_, _tmp58_, param_node->name);
				_tmp60_ = _tmp59_;
				_tmp62_ = vala_gidl_parser_get_attributes (self, _tmp60_, &_tmp61_);
				_tmp63_ = _tmp62_;
				attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
				attributes_length1 = _tmp61_;
				_attributes_size_ = attributes_length1;
				attributes = _tmp63_;
				_g_free0 (_tmp60_);
				_g_free0 (_tmp57_);
				if (attributes != NULL) {
					gchar* ns_name;
					ns_name = NULL;
					{
						gchar** attr_collection;
						int attr_collection_length1;
						int attr_it;
						attr_collection = attributes;
						attr_collection_length1 = attributes_length1;
						for (attr_it = 0; attr_it < attributes_length1; attr_it = attr_it + 1) {
							gchar* _tmp64_;
							gchar* attr;
							_tmp64_ = g_strdup (attr_collection[attr_it]);
							attr = _tmp64_;
							{
								gchar** _tmp65_;
								gchar** _tmp66_ = NULL;
								gint nv_length1;
								gint _nv_size_;
								gchar** _tmp67_;
								gchar** nv;
								_tmp66_ = _tmp65_ = g_strsplit (attr, "=", 2);
								_tmp67_ = _tmp66_;
								nv_length1 = _vala_array_length (_tmp65_);
								_nv_size_ = nv_length1;
								nv = _tmp67_;
								if (g_strcmp0 (nv[0], "hidden") == 0) {
									gchar* _tmp68_ = NULL;
									gchar* _tmp69_;
									gboolean _tmp70_;
									_tmp68_ = vala_gidl_parser_eval (self, nv[1]);
									_tmp69_ = _tmp68_;
									if ((_tmp70_ = g_strcmp0 (_tmp69_, "1") == 0, _g_free0 (_tmp69_), _tmp70_)) {
										hide_param = TRUE;
									} else {
										gchar* _tmp71_ = NULL;
										gchar* _tmp72_;
										gboolean _tmp73_;
										_tmp71_ = vala_gidl_parser_eval (self, nv[1]);
										_tmp72_ = _tmp71_;
										if ((_tmp73_ = g_strcmp0 (_tmp72_, "0") == 0, _g_free0 (_tmp72_), _tmp73_)) {
											show_param = TRUE;
										}
									}
								} else {
									if (g_strcmp0 (nv[0], "is_array") == 0) {
										gchar* _tmp74_ = NULL;
										gchar* _tmp75_;
										gboolean _tmp76_;
										_tmp74_ = vala_gidl_parser_eval (self, nv[1]);
										_tmp75_ = _tmp74_;
										if ((_tmp76_ = g_strcmp0 (_tmp75_, "1") == 0, _g_free0 (_tmp75_), _tmp76_)) {
											ValaSourceReference* _tmp77_ = NULL;
											ValaArrayType* _tmp78_ = NULL;
											ValaDataType* _tmp79_;
											_tmp77_ = vala_code_node_get_source_reference ((ValaCodeNode*) param_type);
											_tmp78_ = vala_array_type_new (param_type, 1, _tmp77_);
											_tmp79_ = (ValaDataType*) _tmp78_;
											_vala_code_node_unref0 (param_type);
											param_type = _tmp79_;
											vala_variable_set_variable_type ((ValaVariable*) p, param_type);
											vala_parameter_set_direction (p, VALA_PARAMETER_DIRECTION_IN);
										}
									} else {
										if (g_strcmp0 (nv[0], "is_out") == 0) {
											gchar* _tmp80_ = NULL;
											gchar* _tmp81_;
											gboolean _tmp82_;
											_tmp80_ = vala_gidl_parser_eval (self, nv[1]);
											_tmp81_ = _tmp80_;
											if ((_tmp82_ = g_strcmp0 (_tmp81_, "1") == 0, _g_free0 (_tmp81_), _tmp82_)) {
												vala_parameter_set_direction (p, VALA_PARAMETER_DIRECTION_OUT);
											}
										} else {
											if (g_strcmp0 (nv[0], "is_ref") == 0) {
												gchar* _tmp83_ = NULL;
												gchar* _tmp84_;
												gboolean _tmp85_;
												_tmp83_ = vala_gidl_parser_eval (self, nv[1]);
												_tmp84_ = _tmp83_;
												if ((_tmp85_ = g_strcmp0 (_tmp84_, "1") == 0, _g_free0 (_tmp84_), _tmp85_)) {
													vala_parameter_set_direction (p, VALA_PARAMETER_DIRECTION_REF);
												}
											} else {
												if (g_strcmp0 (nv[0], "nullable") == 0) {
													gchar* _tmp86_ = NULL;
													gchar* _tmp87_;
													gboolean _tmp88_;
													_tmp86_ = vala_gidl_parser_eval (self, nv[1]);
													_tmp87_ = _tmp86_;
													if ((_tmp88_ = g_strcmp0 (_tmp87_, "1") == 0, _g_free0 (_tmp87_), _tmp88_)) {
														vala_data_type_set_nullable (param_type, TRUE);
													}
												} else {
													if (g_strcmp0 (nv[0], "transfer_ownership") == 0) {
														gchar* _tmp89_ = NULL;
														gchar* _tmp90_;
														gboolean _tmp91_;
														_tmp89_ = vala_gidl_parser_eval (self, nv[1]);
														_tmp90_ = _tmp89_;
														if ((_tmp91_ = g_strcmp0 (_tmp90_, "1") == 0, _g_free0 (_tmp90_), _tmp91_)) {
															vala_data_type_set_value_owned (param_type, TRUE);
														}
													} else {
														if (g_strcmp0 (nv[0], "type_name") == 0) {
															gchar* _tmp92_ = NULL;
															gchar* _tmp93_;
															ValaDataType* _tmp94_ = NULL;
															ValaDataType* _tmp95_;
															_tmp92_ = vala_gidl_parser_eval (self, nv[1]);
															_tmp93_ = _tmp92_;
															_tmp94_ = vala_gidl_parser_parse_type_from_string (self, _tmp93_, FALSE, NULL);
															_tmp95_ = _tmp94_;
															_vala_code_node_unref0 (param_type);
															param_type = _tmp95_;
															vala_variable_set_variable_type ((ValaVariable*) p, param_type);
															_g_free0 (_tmp93_);
														} else {
															if (g_strcmp0 (nv[0], "type_arguments") == 0) {
																ValaDataType* _tmp96_ = NULL;
																gchar* _tmp97_ = NULL;
																gchar* _tmp98_;
																_tmp96_ = vala_variable_get_variable_type ((ValaVariable*) p);
																_tmp97_ = vala_gidl_parser_eval (self, nv[1]);
																_tmp98_ = _tmp97_;
																vala_gidl_parser_parse_type_arguments_from_string (self, _tmp96_, _tmp98_, NULL);
																_g_free0 (_tmp98_);
															} else {
																if (g_strcmp0 (nv[0], "namespace_name") == 0) {
																	gchar* _tmp99_ = NULL;
																	gchar* _tmp100_;
																	_tmp99_ = vala_gidl_parser_eval (self, nv[1]);
																	_tmp100_ = _tmp99_;
																	_g_free0 (ns_name);
																	ns_name = _tmp100_;
																}
															}
														}
													}
												}
											}
										}
									}
								}
								nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (attr);
							}
						}
					}
					if (ns_name != NULL) {
						ValaUnresolvedSymbol* _tmp101_ = NULL;
						ValaUnresolvedSymbol* _tmp102_ = NULL;
						ValaUnresolvedSymbol* _tmp103_;
						_tmp101_ = vala_unresolved_type_get_unresolved_symbol (VALA_UNRESOLVED_TYPE (param_type));
						_tmp102_ = vala_unresolved_symbol_new (NULL, ns_name, NULL);
						_tmp103_ = _tmp102_;
						vala_unresolved_symbol_set_inner (_tmp101_, _tmp103_);
						_vala_code_node_unref0 (_tmp103_);
					}
					_g_free0 (ns_name);
				}
				if (show_param) {
					_tmp104_ = TRUE;
				} else {
					_tmp104_ = !hide_param;
				}
				if (_tmp104_) {
					vala_signal_add_parameter (sig, p);
				}
				_vala_code_node_unref0 (p);
				_vala_code_node_unref0 (param_type);
			}
		}
	}
	result = sig;
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


ValaGIdlParser* vala_gidl_parser_construct (GType object_type) {
	ValaGIdlParser* self = NULL;
	self = (ValaGIdlParser*) vala_code_visitor_construct (object_type);
	return self;
}


ValaGIdlParser* vala_gidl_parser_new (void) {
	return vala_gidl_parser_construct (VALA_TYPE_GIDL_PARSER);
}


static void vala_gidl_parser_class_init (ValaGIdlParserClass * klass) {
	vala_gidl_parser_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_VISITOR_CLASS (klass)->finalize = vala_gidl_parser_finalize;
	g_type_class_add_private (klass, sizeof (ValaGIdlParserPrivate));
	VALA_CODE_VISITOR_CLASS (klass)->visit_namespace = vala_gidl_parser_real_visit_namespace;
	VALA_CODE_VISITOR_CLASS (klass)->visit_class = vala_gidl_parser_real_visit_class;
	VALA_CODE_VISITOR_CLASS (klass)->visit_struct = vala_gidl_parser_real_visit_struct;
	VALA_CODE_VISITOR_CLASS (klass)->visit_interface = vala_gidl_parser_real_visit_interface;
	VALA_CODE_VISITOR_CLASS (klass)->visit_enum = vala_gidl_parser_real_visit_enum;
	VALA_CODE_VISITOR_CLASS (klass)->visit_error_domain = vala_gidl_parser_real_visit_error_domain;
	VALA_CODE_VISITOR_CLASS (klass)->visit_delegate = vala_gidl_parser_real_visit_delegate;
	VALA_CODE_VISITOR_CLASS (klass)->visit_source_file = vala_gidl_parser_real_visit_source_file;
}


static void vala_gidl_parser_instance_init (ValaGIdlParser * self) {
	self->priv = VALA_GIDL_PARSER_GET_PRIVATE (self);
}


static void vala_gidl_parser_finalize (ValaCodeVisitor* obj) {
	ValaGIdlParser * self;
	self = VALA_GIDL_PARSER (obj);
	_vala_code_context_unref0 (self->priv->context);
	_vala_source_file_unref0 (self->priv->current_source_file);
	_vala_source_reference_unref0 (self->priv->current_source_reference);
	_vala_code_node_unref0 (self->priv->current_namespace);
	_vala_code_node_unref0 (self->priv->current_data_type);
	_vala_map_unref0 (self->priv->codenode_attributes_map);
	_vala_map_unref0 (self->priv->codenode_attributes_patterns);
	_vala_iterable_unref0 (self->priv->current_type_symbol_set);
	_vala_map_unref0 (self->priv->cname_type_map);
	VALA_CODE_VISITOR_CLASS (vala_gidl_parser_parent_class)->finalize (obj);
}


/**
 * Code visitor parsing all GIDL files.
 */
GType vala_gidl_parser_get_type (void) {
	static volatile gsize vala_gidl_parser_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gidl_parser_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaGIdlParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gidl_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGIdlParser), 0, (GInstanceInitFunc) vala_gidl_parser_instance_init, NULL };
		GType vala_gidl_parser_type_id;
		vala_gidl_parser_type_id = g_type_register_static (VALA_TYPE_CODE_VISITOR, "ValaGIdlParser", &g_define_type_info, 0);
		g_once_init_leave (&vala_gidl_parser_type_id__volatile, vala_gidl_parser_type_id);
	}
	return vala_gidl_parser_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



