/* mx-1.0.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Mx", lower_case_cprefix = "mx_")]
namespace Mx {
	[CCode (cheader_filename = "mx/mx.h")]
	public class Action : GLib.InitiallyUnowned {
		[CCode (has_construct_function = false)]
		public Action ();
		[CCode (has_construct_function = false)]
		public Action.full (string name, string display_name, GLib.Callback activated_cb);
		public bool get_active ();
		public unowned string get_display_name ();
		public unowned string get_icon ();
		public unowned string get_name ();
		public void set_active (bool active);
		public void set_display_name (string name);
		public void set_icon (string name);
		public void set_name (string name);
		public bool active { get; set; }
		public string display_name { get; set; }
		public string icon { get; set; }
		public string name { get; set; }
		public virtual signal void activated ();
	}
	[CCode (cheader_filename = "mx/mx.h")]
	public class Adjustment : GLib.Object {
		[CCode (has_construct_function = false)]
		public Adjustment ();
		public bool get_elastic ();
		public double get_lower ();
		public double get_page_increment ();
		public double get_page_size ();
		public double get_step_increment ();
		public double get_upper ();
		public double get_value ();
		public void get_values (double value, double lower, double upper, double step_increment, double page_increment, double page_size);
		public void interpolate (double value, uint duration, ulong mode);
		public void interpolate_relative (double offset, uint duration, ulong mode);
		public void set_elastic (bool elastic);
		public void set_lower (double lower);
		public void set_page_increment (double increment);
		public void set_page_size (double page_size);
		public void set_step_increment (double increment);
		public void set_upper (double upper);
		public void set_value (double value);
		public void set_values (double value, double lower, double upper, double step_increment, double page_increment, double page_size);
		[CCode (has_construct_function = false)]
		public Adjustment.with_values (double value, double lower, double upper, double step_increment, double page_increment, double page_size);
		public bool elastic { get; set construct; }
		public double lower { get; set construct; }
		public double page_increment { get; set construct; }
		public double page_size { get; set construct; }
		public double step_increment { get; set construct; }
		public double upper { get; set construct; }
		public double value { get; set construct; }
		public virtual signal void changed ();
	}
	[CCode (cheader_filename = "mx/mx.h")]
	public class Application : GLib.Object {
		[CCode (has_construct_function = false)]
		public Application ([CCode (array_length_pos = 0.9)] ref unowned string[] argv, string name, Mx.ApplicationFlags flags);
		public void add_action (Mx.Action action);
		public void add_window (Mx.Window window);
		public virtual unowned Mx.Window create_window ();
		public unowned GLib.List get_actions ();
		public Mx.ApplicationFlags get_flags ();
		public unowned GLib.List get_windows ();
		public void invoke_action (string name);
		public bool is_running ();
		public void quit ();
		[NoWrapper]
		public virtual void raise ();
		public void remove_action (string name);
		public void remove_window (Mx.Window window);
		public void run ();
		[NoAccessorMethod]
		public string application_name { owned get; construct; }
		public uint flags { get; construct; }
		public virtual signal void actions_changed ();
	}
	[CCode (cheader_filename = "mx/mx.h")]
	public class Bin : Mx.Widget, Clutter.Scriptable, Mx.Stylable, Clutter.Container, Mx.Focusable {
		[CCode (has_construct_function = false)]
		protected Bin ();
		public void allocate_child (Clutter.ActorBox box, Clutter.AllocationFlags flags);
		public void get_alignment (Mx.Align x_align, Mx.Align y_align);
		public unowned Clutter.Actor get_child ();
		public void get_fill (bool x_fill, bool y_fill);
		public void set_alignment (Mx.Align x_align, Mx.Align y_align);
		public void set_child (Clutter.Actor child);
		public void set_fill (bool x_fill, bool y_fill);
		public Clutter.Actor child { get; set; }
		[NoAccessorMethod]
		public Mx.Align x_align { get; set; }
		[NoAccessorMethod]
		public bool x_fill { get; set; }
		[NoAccessorMethod]
		public Mx.Align y_align { get; set; }
		[NoAccessorMethod]
		public bool y_fill { get; set; }
	}
	[Compact]
	[CCode (type_id = "MX_TYPE_BORDER_IMAGE", cheader_filename = "mx/mx.h")]
	public class BorderImage {
		public int bottom;
		public int left;
		public int right;
		public int top;
		public weak string uri;
		public static void set_from_string (GLib.Value value, string str, string filename);
	}
	[CCode (cheader_filename = "mx/mx.h")]
	public class BoxLayout : Mx.Widget, Clutter.Scriptable, Mx.Stylable, Clutter.Container, Mx.Scrollable, Mx.Focusable {
		[CCode (type = "ClutterActor*", has_construct_function = false)]
		public BoxLayout ();
		public void add_actor_with_properties (Clutter.Actor actor, int position, ...);
		public bool get_enable_animations ();
		public Mx.Orientation get_orientation ();
		public uint get_spacing ();
		public void set_enable_animations (bool enable_animations);
		public void set_orientation (Mx.Orientation orientation);
		public void set_spacing (uint spacing);
		public bool enable_animations { get; set; }
		public Mx.Orientation orientation { get; set; }
		public uint spacing { get; set; }
	}
	[CCode (cheader_filename = "mx/mx.h")]
	public class BoxLayoutChild : Clutter.ChildMeta {
		[CCode (has_construct_function = false)]
		protected BoxLayoutChild ();
		public static bool get_expand (Mx.BoxLayout box_layout, Clutter.Actor child);
		public static Mx.Align get_x_align (Mx.BoxLayout box_layout, Clutter.Actor child);
		public static bool get_x_fill (Mx.BoxLayout box_layout, Clutter.Actor child);
		public static Mx.Align get_y_align (Mx.BoxLayout box_layout, Clutter.Actor child);
		public static bool get_y_fill (Mx.BoxLayout box_layout, Clutter.Actor child);
		public static void set_expand (Mx.BoxLayout box_layout, Clutter.Actor child, bool expand);
		public static void set_x_align (Mx.BoxLayout box_layout, Clutter.Actor child, Mx.Align x_align);
		public static void set_x_fill (Mx.BoxLayout box_layout, Clutter.Actor child, bool x_fill);
		public static void set_y_align (Mx.BoxLayout box_layout, Clutter.Actor child, Mx.Align y_align);
		public static void set_y_fill (Mx.BoxLayout box_layout, Clutter.Actor child, bool y_fill);
		public bool expand { get; set; }
		public Mx.Align x_align { get; set; }
		public bool x_fill { get; set; }
		public Mx.Align y_align { get; set; }
		public bool y_fill { get; set; }
	}
	[CCode (cheader_filename = "mx/mx.h")]
	public class Button : Mx.Bin, Clutter.Scriptable, Mx.Stylable, Clutter.Container, Mx.Focusable {
		[CCode (type = "ClutterActor*", has_construct_function = false)]
		public Button ();
		public bool get_is_toggle ();
		public unowned string get_label ();
		public bool get_toggled ();
		public void set_is_toggle (bool toggle);
		public void set_label (string text);
		public void set_toggled (bool toggled);
		[CCode (type = "ClutterActor*", has_construct_function = false)]
		public Button.with_label (string text);
		public bool is_toggle { get; set; }
		public string label { get; set; }
		public bool toggled { get; set; }
		public virtual signal void clicked ();
	}
	[CCode (cheader_filename = "mx/mx.h")]
	public class ButtonGroup : GLib.InitiallyUnowned {
		[CCode (has_construct_function = false)]
		public ButtonGroup ();
		public void add (Mx.Button button);
		public void @foreach (Clutter.Callback callback);
		public unowned Mx.Button get_active_button ();
		public bool get_allow_no_active ();
		public unowned GLib.SList get_buttons ();
		public void remove (Mx.Button button);
		public void set_active_button (Mx.Button? button);
		public void set_allow_no_active (bool allow_no_active);
		public Mx.Button active_button { get; set; }
		public bool allow_no_active { get; set; }
	}
	[CCode (cheader_filename = "mx/mx.h")]
	public class Clipboard : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Clipboard ();
		public static unowned Mx.Clipboard get_default ();
		public void get_text (Mx.ClipboardCallbackFunc callback);
		public void set_text (string text);
	}
	[CCode (cheader_filename = "mx/mx.h")]
	public class ComboBox : Mx.Widget, Clutter.Scriptable, Mx.Stylable, Mx.Focusable {
		[CCode (type = "ClutterActor*", has_construct_function = false)]
		public ComboBox ();
		public void append_text (string text);
		public unowned string get_active_icon_name ();
		public unowned string get_active_text ();
		public int get_index ();
		public void insert_text (int position, string text);
		public void insert_text_with_icon (int position, string text, string icon);
		public void prepend_text (string text);
		public void remove_text (int position);
		public void set_active_icon_name (string icon_name);
		public void set_active_text (string text);
		public void set_index (int index);
		public string active_icon_name { get; set; }
		public string active_text { get; set; }
		public int index { get; set; }
	}
	[CCode (cheader_filename = "mx/mx.h")]
	public class DeformBowTie : Mx.DeformTexture, Clutter.Scriptable, Mx.Stylable {
		[CCode (type = "ClutterActor*", has_construct_function = false)]
		public DeformBowTie ();
		public bool get_flip_back ();
		public double get_period ();
		public void set_flip_back (bool flip_back);
		public void set_period (double period);
		public bool flip_back { get; set; }
		public double period { get; set; }
	}
	[CCode (cheader_filename = "mx/mx.h")]
	public class DeformPageTurn : Mx.DeformTexture, Clutter.Scriptable, Mx.Stylable {
		[CCode (type = "ClutterActor*", has_construct_function = false)]
		public DeformPageTurn ();
		public double get_angle ();
		public double get_period ();
		public double get_radius ();
		public void set_angle (double angle);
		public void set_period (double period);
		public void set_radius (double radius);
		public double angle { get; set; }
		public double period { get; set; }
		public double radius { get; set; }
	}
	[CCode (cheader_filename = "mx/mx.h")]
	public class DeformTexture : Mx.Widget, Clutter.Scriptable, Mx.Stylable {
		[CCode (has_construct_function = false)]
		protected DeformTexture ();
		[NoWrapper]
		public virtual void deform (Cogl.TextureVertex vertex, float width, float height);
		public void get_resolution (int tiles_x, int tiles_y);
		public void get_textures (out unowned Clutter.Texture front, out unowned Clutter.Texture back);
		public void invalidate ();
		public void set_resolution (int tiles_x, int tiles_y);
		public void set_textures (Clutter.Texture front, Clutter.Texture back);
		[NoAccessorMethod]
		public Clutter.Texture back { owned get; set; }
		[NoAccessorMethod]
		public Clutter.Texture front { owned get; set; }
		[NoAccessorMethod]
		public int tiles_x { get; set; }
		[NoAccessorMethod]
		public int tiles_y { get; set; }
	}
	[CCode (cheader_filename = "mx/mx.h")]
	public class DeformWaves : Mx.DeformTexture, Clutter.Scriptable, Mx.Stylable {
		[CCode (type = "ClutterActor*", has_construct_function = false)]
		public DeformWaves ();
		public double get_amplitude ();
		public double get_angle ();
		public double get_period ();
		public double get_radius ();
		public void set_amplitude (double amplitude);
		public void set_angle (double angle);
		public void set_period (double period);
		public void set_radius (double radius);
		public double amplitude { get; set; }
		public double angle { get; set; }
		public double period { get; set; }
		public double radius { get; set; }
	}
	[CCode (cheader_filename = "mx/mx.h")]
	public class Entry : Mx.Widget, Clutter.Scriptable, Mx.Stylable, Mx.Focusable {
		[CCode (type = "ClutterActor*", has_construct_function = false)]
		public Entry ();
		public unowned Clutter.Actor get_clutter_text ();
		public unowned string get_hint_text ();
		public unichar get_password_char ();
		public unowned string get_text ();
		public void set_hint_text (string text);
		public void set_password_char (unichar password_char);
		public void set_primary_icon_from_file (string filename);
		public void set_secondary_icon_from_file (string filename);
		public void set_text (string text);
		[CCode (type = "ClutterActor*", has_construct_function = false)]
		public Entry.with_text (string text);
		public Clutter.Text clutter_text { get; }
		public string hint_text { get; set; }
		public uint password_char { get; set; }
		public string text { get; set; }
		public virtual signal void primary_icon_clicked ();
		public virtual signal void secondary_icon_clicked ();
	}
	[CCode (cheader_filename = "mx/mx.h")]
	public class Expander : Mx.Bin, Clutter.Scriptable, Mx.Stylable, Clutter.Container, Mx.Focusable {
		[CCode (type = "ClutterActor*", has_construct_function = false)]
		public Expander ();
		public bool get_expanded ();
		public void set_expanded (bool expanded);
		public void set_label (string label);
		public bool expanded { get; set; }
		[NoAccessorMethod]
		public string label { owned get; set; }
		public virtual signal void expand_complete ();
	}
	[CCode (cheader_filename = "mx/mx.h")]
	public class FloatingWidget : Mx.Widget, Clutter.Scriptable, Mx.Stylable {
		[CCode (has_construct_function = false)]
		protected FloatingWidget ();
		[NoWrapper]
		public virtual void floating_paint (Clutter.Actor actor);
		[NoWrapper]
		public virtual void floating_pick (Clutter.Actor actor, Clutter.Color color);
	}
	[CCode (cheader_filename = "mx/mx.h")]
	public class FocusManager : GLib.Object {
		[CCode (has_construct_function = false)]
		protected FocusManager ();
		public unowned Mx.Focusable get_focused ();
		public static unowned Mx.FocusManager get_for_stage (Clutter.Stage stage);
		public unowned Clutter.Stage get_stage ();
		public void move_focus (Mx.FocusDirection direction);
		public void push_focus (Mx.Focusable focusable);
		public Clutter.Actor focused { get; }
		public Clutter.Stage stage { get; }
	}
	[CCode (cheader_filename = "mx/mx.h")]
	public class Frame : Mx.Bin, Clutter.Scriptable, Mx.Stylable, Clutter.Container, Mx.Focusable {
		[CCode (type = "ClutterActor*", has_construct_function = false)]
		public Frame ();
	}
	[CCode (cheader_filename = "mx/mx.h")]
	public class Grid : Mx.Widget, Clutter.Scriptable, Mx.Stylable, Clutter.Container, Mx.Scrollable, Mx.Focusable {
		[CCode (type = "ClutterActor*", has_construct_function = false)]
		public Grid ();
		public Mx.Align get_child_x_align ();
		public Mx.Align get_child_y_align ();
		public float get_column_spacing ();
		public bool get_homogenous_columns ();
		public bool get_homogenous_rows ();
		public bool get_line_alignment ();
		public int get_max_stride ();
		public Mx.Orientation get_orientation ();
		public float get_row_spacing ();
		public void set_child_x_align (Mx.Align value);
		public void set_child_y_align (Mx.Align value);
		public void set_column_spacing (float value);
		public void set_homogenous_columns (bool value);
		public void set_homogenous_rows (bool value);
		public void set_line_alignment (Mx.Align value);
		public void set_max_stride (int value);
		public void set_orientation (Mx.Orientation orientation);
		public void set_row_spacing (float value);
		public Mx.Align child_x_align { get; set construct; }
		public Mx.Align child_y_align { get; set construct; }
		public float column_spacing { get; set construct; }
		public bool homogenous_columns { get; set construct; }
		public bool homogenous_rows { get; set construct; }
		public Mx.Align line_alignment { get; set construct; }
		public int max_stride { get; set construct; }
		public Mx.Orientation orientation { get; set construct; }
		public float row_spacing { get; set construct; }
	}
	[CCode (cheader_filename = "mx/mx.h")]
	public class Icon : Mx.Widget, Clutter.Scriptable, Mx.Stylable {
		[CCode (type = "ClutterActor*", has_construct_function = false)]
		public Icon ();
		public unowned string get_icon_name ();
		public int get_icon_size ();
		public void set_icon_name (string icon_name);
		public void set_icon_size (int size);
		public string icon_name { get; set; }
		public int icon_size { get; set; }
	}
	[CCode (cheader_filename = "mx/mx.h")]
	public class IconTheme : GLib.Object {
		[CCode (has_construct_function = false)]
		public IconTheme ();
		public static unowned Mx.IconTheme get_default ();
		public unowned GLib.List get_search_paths ();
		public unowned string get_theme_name ();
		public bool has_icon (string icon_name);
		public unowned Cogl.Bitmap lookup (string icon_name, int size);
		public unowned Clutter.Texture lookup_texture (string icon_name, int size);
		public void set_search_paths (GLib.List paths);
		public void set_theme_name (string theme_name);
		public string theme_name { get; set; }
	}
	[CCode (cheader_filename = "mx/mx.h")]
	public class ItemView : Mx.Grid, Clutter.Scriptable, Mx.Stylable, Clutter.Container, Mx.Scrollable, Mx.Focusable {
		[CCode (type = "ClutterActor*", has_construct_function = false)]
		public ItemView ();
		public void add_attribute (string attribute, int column);
		public void freeze ();
		public unowned Mx.ItemFactory get_factory ();
		public GLib.Type get_item_type ();
		public unowned Clutter.Model get_model ();
		public void set_factory (Mx.ItemFactory factory);
		public void set_item_type (GLib.Type item_type);
		public void set_model (Clutter.Model model);
		public void thaw ();
		public GLib.Object factory { get; set; }
		public GLib.Type item_type { get; set; }
		public Clutter.Model model { get; set; }
	}
	[CCode (cheader_filename = "mx/mx.h")]
	public class Label : Mx.Widget, Clutter.Scriptable, Mx.Stylable {
		[CCode (type = "ClutterActor*", has_construct_function = false)]
		public Label ();
		public unowned Clutter.Actor get_clutter_text ();
		public unowned string get_text ();
		public Mx.Align get_x_align ();
		public Mx.Align get_y_align ();
		public void set_text (string text);
		public void set_x_align (Mx.Align align);
		public void set_y_align (Mx.Align align);
		[CCode (type = "ClutterActor*", has_construct_function = false)]
		public Label.with_text (string text);
		public Clutter.Text clutter_text { get; }
		public string text { get; set; }
		public Mx.Align x_align { get; set; }
		public Mx.Align y_align { get; set; }
	}
	[CCode (cheader_filename = "mx/mx.h")]
	public class ListView : Mx.BoxLayout, Clutter.Scriptable, Mx.Stylable, Clutter.Container, Mx.Scrollable, Mx.Focusable {
		[CCode (type = "ClutterActor*", has_construct_function = false)]
		public ListView ();
		public void add_attribute (string attribute, int column);
		public void freeze ();
		public unowned Mx.ItemFactory get_factory ();
		public GLib.Type get_item_type ();
		public unowned Clutter.Model get_model ();
		public void set_factory (Mx.ItemFactory factory);
		public void set_item_type (GLib.Type item_type);
		public void set_model (Clutter.Model model);
		public void thaw ();
		public GLib.Object factory { get; set; }
		public GLib.Type item_type { get; set; }
		public Clutter.Model model { get; set; }
	}
	[CCode (cheader_filename = "mx/mx.h")]
	public class Menu : Mx.FloatingWidget, Clutter.Scriptable, Mx.Stylable {
		[CCode (type = "ClutterActor*", has_construct_function = false)]
		public Menu ();
		public void add_action (Mx.Action action);
		public void remove_action (Mx.Action action);
		public void remove_all ();
		public void show_with_position (float x, float y);
		public virtual signal void action_activated (Mx.Action action);
	}
	[CCode (cheader_filename = "mx/mx.h")]
	public class Notebook : Mx.Widget, Clutter.Scriptable, Mx.Stylable, Clutter.Container {
		[CCode (type = "ClutterActor*", has_construct_function = false)]
		public Notebook ();
		public unowned Clutter.Actor get_current_page ();
		public bool get_enable_gestures ();
		public void set_current_page (Clutter.Actor page);
		public void set_enable_gestures (bool enabled);
		public Clutter.Actor current_page { get; set; }
		public bool enable_gestures { get; set; }
	}
	[CCode (cheader_filename = "mx/mx.h")]
	public class Offscreen : Clutter.Texture, Clutter.Scriptable, Clutter.Container {
		[CCode (type = "ClutterActor*", has_construct_function = false)]
		public Offscreen ();
		public bool get_auto_update ();
		public unowned Clutter.Actor get_child ();
		public bool get_pick_child ();
		[NoWrapper]
		public virtual void paint_child ();
		public void set_auto_update (bool auto_update);
		public void set_child (Clutter.Actor actor);
		public void set_pick_child (bool pick);
		public void update ();
		public bool auto_update { get; set; }
		public Clutter.Actor child { get; set; }
		public bool pick_child { get; set; }
	}
	[CCode (cheader_filename = "mx/mx.h")]
	public class PathBar : Mx.Widget, Clutter.Scriptable, Mx.Stylable, Mx.Focusable {
		[CCode (type = "ClutterActor*", has_construct_function = false)]
		public PathBar ();
		public void clear ();
		public bool get_clear_on_change ();
		public bool get_editable ();
		public unowned Mx.Entry get_entry ();
		public unowned string get_label (int level);
		public int get_level ();
		public unowned string get_text ();
		public int pop ();
		public int push (string name);
		public void set_clear_on_change (bool clear_on_change);
		public void set_editable (bool editable);
		public void set_label (int level, string label);
		public void set_text (string text);
		public bool clear_on_change { get; set; }
		public bool editable { get; set; }
		public Mx.Entry entry { get; }
		public int level { get; }
	}
	[CCode (cheader_filename = "mx/mx.h")]
	public class ProgressBar : Mx.Widget, Clutter.Scriptable, Mx.Stylable {
		[CCode (type = "ClutterActor*", has_construct_function = false)]
		public ProgressBar ();
		public double get_progress ();
		public void set_progress (double progress);
		public double progress { get; set; }
	}
	[CCode (cheader_filename = "mx/mx.h")]
	public class ScrollBar : Mx.Bin, Clutter.Scriptable, Mx.Stylable, Clutter.Container, Mx.Focusable {
		[CCode (type = "ClutterActor*", has_construct_function = false)]
		public ScrollBar ();
		public unowned Mx.Adjustment get_adjustment ();
		public Mx.Orientation get_orientation ();
		public void set_adjustment (Mx.Adjustment adjustment);
		public void set_orientation (Mx.Orientation orientation);
		[CCode (type = "ClutterActor*", has_construct_function = false)]
		public ScrollBar.with_adjustment (Mx.Adjustment adjustment);
		public Mx.Adjustment adjustment { get; set; }
		public Mx.Orientation orientation { get; set; }
		public virtual signal void scroll_start ();
		public virtual signal void scroll_stop ();
	}
	[CCode (cheader_filename = "mx/mx.h")]
	public class ScrollView : Mx.Bin, Clutter.Scriptable, Mx.Stylable, Clutter.Container, Mx.Focusable {
		[CCode (type = "ClutterActor*", has_construct_function = false)]
		public ScrollView ();
		public void ensure_visible (Clutter.Geometry geometry);
		public bool get_enable_gestures ();
		public bool get_enable_mouse_scrolling ();
		public Mx.ScrollPolicy get_scroll_policy ();
		public void set_enable_gestures (bool enabled);
		public void set_enable_mouse_scrolling (bool enabled);
		public void set_scroll_policy (Mx.ScrollPolicy policy);
		public bool enable_gestures { get; set; }
		public bool enable_mouse_scrolling { get; set; }
		public Mx.ScrollPolicy scroll_policy { get; set; }
	}
	[CCode (cheader_filename = "mx/mx.h")]
	public class Slider : Mx.Widget, Clutter.Scriptable, Mx.Stylable {
		[CCode (type = "ClutterActor*", has_construct_function = false)]
		public Slider ();
		public double get_value ();
		public void set_value (double value);
		public double value { get; set; }
	}
	[CCode (cheader_filename = "mx/mx.h")]
	public class Style : GLib.Object {
		[CCode (has_construct_function = false)]
		public Style ();
		public void @get (Mx.Stylable stylable, ...);
		public static unowned Mx.Style get_default ();
		public void get_property (Mx.Stylable stylable, Clutter.ParamSpecColor pspec, GLib.Value value);
		public void get_valist (Mx.Stylable stylable, string first_property_name, void* va_args);
		public bool load_from_file (string filename) throws GLib.Error;
		public virtual signal void changed ();
	}
	[CCode (cheader_filename = "mx/mx.h")]
	public class Table : Mx.Widget, Clutter.Scriptable, Mx.Stylable, Clutter.Container, Mx.Focusable {
		[CCode (type = "ClutterActor*", has_construct_function = false)]
		public Table ();
		public void add_actor_with_properties (Clutter.Actor actor, int row, int column, ...);
		public int get_column_count ();
		public int get_column_spacing ();
		public int get_row_count ();
		public int get_row_spacing ();
		public void set_column_spacing (int spacing);
		public void set_row_spacing (int spacing);
		public int column_count { get; }
		public int column_spacing { get; set; }
		public int row_count { get; }
		public int row_spacing { get; set; }
	}
	[CCode (cheader_filename = "mx/mx.h")]
	public class TableChild : Clutter.ChildMeta {
		[CCode (has_construct_function = false)]
		protected TableChild ();
		public static int get_column (Mx.Table table, Clutter.Actor child);
		public static int get_column_span (Mx.Table table, Clutter.Actor child);
		public static int get_row (Mx.Table table, Clutter.Actor child);
		public static int get_row_span (Mx.Table table, Clutter.Actor child);
		public static Mx.Align get_x_align (Mx.Table table, Clutter.Actor child);
		public static bool get_x_expand (Mx.Table table, Clutter.Actor child);
		public static bool get_x_fill (Mx.Table table, Clutter.Actor child);
		public static Mx.Align get_y_align (Mx.Table table, Clutter.Actor child);
		public static bool get_y_expand (Mx.Table table, Clutter.Actor child);
		public static bool get_y_fill (Mx.Table table, Clutter.Actor child);
		public static void set_column (Mx.Table table, Clutter.Actor child, int col);
		public static void set_column_span (Mx.Table table, Clutter.Actor child, int span);
		public static void set_row (Mx.Table table, Clutter.Actor child, int row);
		public static void set_row_span (Mx.Table table, Clutter.Actor child, int span);
		public static void set_x_align (Mx.Table table, Clutter.Actor child, Mx.Align align);
		public static void set_x_expand (Mx.Table table, Clutter.Actor child, bool expand);
		public static void set_x_fill (Mx.Table table, Clutter.Actor child, bool fill);
		public static void set_y_align (Mx.Table table, Clutter.Actor child, Mx.Align align);
		public static void set_y_expand (Mx.Table table, Clutter.Actor child, bool expand);
		public static void set_y_fill (Mx.Table table, Clutter.Actor child, bool fill);
		public int column { get; set; }
		public int column_span { get; set; }
		public int row { get; set; }
		public int row_span { get; set; }
		public Mx.Align x_align { get; set; }
		public bool x_expand { get; set; }
		public bool x_fill { get; set; }
		public Mx.Align y_align { get; set; }
		public bool y_expand { get; set; }
		public bool y_fill { get; set; }
	}
	[CCode (cheader_filename = "mx/mx.h")]
	public class TextureCache : GLib.Object {
		[CCode (has_construct_function = false)]
		protected TextureCache ();
		[NoWrapper]
		public virtual void error_loading (GLib.Error error);
		public unowned Clutter.Actor get_actor (string path);
		public unowned Cogl.Bitmap get_cogl_texture (string path);
		public static unowned Mx.TextureCache get_default ();
		public int get_size ();
		public unowned Clutter.Texture get_texture (string path);
		public void load_cache (string filename);
		[NoWrapper]
		public virtual void loaded (string path, Clutter.Texture texture);
	}
	[CCode (cheader_filename = "mx/mx.h")]
	public class TextureFrame : Clutter.Actor, Clutter.Scriptable {
		[CCode (type = "ClutterActor*", has_construct_function = false)]
		public TextureFrame (Clutter.Texture texture, float top, float right, float bottom, float left);
		public void get_border_values (float top, float right, float bottom, float left);
		public unowned Clutter.Texture get_parent_texture ();
		public void set_border_values (float top, float right, float bottom, float left);
		public void set_parent_texture (Clutter.Texture texture);
		[NoAccessorMethod]
		public float bottom { get; set construct; }
		[NoAccessorMethod]
		public float left { get; set construct; }
		public Clutter.Texture parent_texture { get; set construct; }
		[NoAccessorMethod]
		public float right { get; set construct; }
		[NoAccessorMethod]
		public float top { get; set construct; }
	}
	[CCode (cheader_filename = "mx/mx.h")]
	public class Toggle : Mx.Widget, Clutter.Scriptable, Mx.Stylable {
		[CCode (type = "ClutterActor*", has_construct_function = false)]
		public Toggle ();
		public bool get_active ();
		public void set_active (bool active);
		public bool active { get; set; }
	}
	[CCode (cheader_filename = "mx/mx.h")]
	public class Toolbar : Mx.Bin, Clutter.Scriptable, Mx.Stylable, Clutter.Container, Mx.Focusable {
		[CCode (type = "ClutterActor*", has_construct_function = false)]
		public Toolbar ();
		public bool get_has_close_button ();
		public void set_has_close_button (bool has_close_button);
		public bool has_close_button { get; set; }
		public virtual signal bool close_button_clicked ();
	}
	[CCode (cheader_filename = "mx/mx.h")]
	public class Tooltip : Mx.FloatingWidget, Clutter.Scriptable, Mx.Stylable {
		[CCode (has_construct_function = false)]
		protected Tooltip ();
		public unowned string get_text ();
		public Clutter.Geometry get_tip_area ();
		public void hide ();
		public void set_text (string text);
		public void set_tip_area (Clutter.Geometry area);
		public void show ();
		public string text { get; set; }
		public Clutter.Geometry tip_area { get; set; }
	}
	[CCode (cheader_filename = "mx/mx.h")]
	public class Viewport : Mx.Bin, Clutter.Scriptable, Mx.Stylable, Clutter.Container, Mx.Focusable, Mx.Scrollable {
		[CCode (type = "ClutterActor*", has_construct_function = false)]
		public Viewport ();
		public void get_origin (float x, float y, float z);
		public bool get_sync_adjustments ();
		public void set_origin (float x, float y, float z);
		public void set_sync_adjustments (bool sync);
		public bool sync_adjustments { get; set; }
		[NoAccessorMethod]
		public float x_origin { get; set; }
		[NoAccessorMethod]
		public float y_origin { get; set; }
		[NoAccessorMethod]
		public float z_origin { get; set; }
	}
	[CCode (cheader_filename = "mx/mx.h")]
	public class Widget : Clutter.Actor, Clutter.Scriptable, Mx.Stylable {
		[CCode (has_construct_function = false)]
		protected Widget ();
		public void get_available_area (Clutter.ActorBox allocation, Clutter.ActorBox area);
		public unowned Clutter.Actor get_background_image ();
		public unowned Clutter.Actor get_border_image ();
		public bool get_disabled ();
		public unowned Mx.Menu get_menu ();
		public void get_padding (Mx.Padding padding);
		public unowned string get_tooltip_text ();
		public void hide_tooltip ();
		public void long_press_cancel ();
		public void long_press_query (Clutter.ButtonEvent event);
		public virtual void paint_background ();
		public void set_disabled (bool disabled);
		public void set_menu (Mx.Menu menu);
		public void set_tooltip_text (string text);
		public void show_tooltip ();
		public bool disabled { get; set; }
		public Mx.Menu menu { get; set; }
		public string tooltip_text { get; set; }
		public virtual signal bool long_press (float action, float x, Mx.LongPressAction y);
	}
	[CCode (cheader_filename = "mx/mx.h")]
	public class Window : GLib.Object {
		[CCode (has_construct_function = false)]
		public Window ();
		public unowned Clutter.Actor get_child ();
		public unowned Clutter.Stage get_clutter_stage ();
		public static unowned Mx.Window get_for_stage (Clutter.Stage stage);
		public bool get_has_toolbar ();
		public unowned string get_icon_name ();
		public bool get_small_screen ();
		public unowned Mx.Toolbar get_toolbar ();
		public void get_window_position (int x, int y);
		public void set_child (Clutter.Actor actor);
		public void set_has_toolbar (bool toolbar);
		public void set_icon_from_cogl_texture (Cogl.Bitmap texture);
		public void set_icon_name (string icon_name);
		public void set_small_screen (bool small_screen);
		public void set_window_position (int x, int y);
		[CCode (has_construct_function = false)]
		public Window.with_clutter_stage (Clutter.Stage stage);
		public Clutter.Actor child { get; set; }
		public Clutter.Stage clutter_stage { get; construct; }
		public bool has_toolbar { get; set; }
		[NoAccessorMethod]
		public string icon_cogl_texture { set; }
		public string icon_name { get; set; }
		public bool small_screen { get; set; }
		public Mx.Toolbar toolbar { get; }
		public virtual signal void destroy ();
	}
	[CCode (cheader_filename = "mx/mx.h")]
	public interface Draggable : Clutter.Actor {
		public void disable ();
		public void enable ();
		public Mx.DragAxis get_axis ();
		public unowned Clutter.Actor get_drag_actor ();
		public uint get_drag_threshold ();
		public bool is_enabled ();
		public void set_axis (Mx.DragAxis axis);
		public void set_drag_actor (Clutter.Actor actor);
		public void set_drag_threshold (uint threshold);
		public Mx.DragAxis axis { get; set; }
		public Clutter.Actor drag_actor { get; set; }
		public bool drag_enabled { get; set; }
		public uint drag_threshold { get; set; }
		public signal void drag_begin (float event_x, float event_y, int event_button, Clutter.ModifierType modifiers);
		public signal void drag_end (float event_x, float event_y);
		public signal void drag_motion (float delta_x, float delta_y);
	}
	[CCode (cheader_filename = "mx/mx.h")]
	public interface Droppable : Clutter.Actor {
		public bool accept_drop (Mx.Draggable draggable);
		public void disable ();
		public void enable ();
		public bool is_enabled ();
		public bool drop_enabled { get; set; }
		public signal void drop (Clutter.Actor draggable, float event_x, float event_y, int button, Clutter.ModifierType modifiers);
		public signal void over_in (Clutter.Actor draggable);
		public signal void over_out (Clutter.Actor draggable);
	}
	[CCode (cheader_filename = "mx/mx.h")]
	public interface Focusable {
		public abstract unowned Mx.Focusable accept_focus (Mx.FocusHint hint);
		public abstract unowned Mx.Focusable move_focus (Mx.FocusDirection direction, Mx.Focusable from);
	}
	[CCode (cheader_filename = "mx/mx.h")]
	public interface ItemFactory {
		public abstract unowned Clutter.Actor create ();
	}
	[CCode (cheader_filename = "mx/mx.h")]
	public interface Scrollable {
		public abstract void get_adjustments (out unowned Mx.Adjustment hadjustment, out unowned Mx.Adjustment vadjustment);
		public abstract void set_adjustments (Mx.Adjustment hadjustment, Mx.Adjustment vadjustment);
	}
	[CCode (cheader_filename = "mx/mx.h")]
	public interface Stylable {
		public void apply_clutter_text_attributes (Clutter.Text text);
		public void connect_change_notifiers ();
		public unowned Clutter.ParamSpecColor find_property (string property_name);
		public void @get (...);
		public bool get_default_value (string property_name, GLib.Value value_out);
		public void get_property (string property_name, GLib.Value value);
		public abstract unowned Mx.Style get_style ();
		public abstract unowned string get_style_class ();
		public abstract unowned string get_style_pseudo_class ();
		public unowned Clutter.ParamSpecColor list_properties (uint n_props);
		public abstract void set_style (Mx.Style style);
		public abstract void set_style_class (string style_class);
		public abstract void set_style_pseudo_class (string pseudo_class);
		[HasEmitter]
		public signal void style_changed (Mx.StyleChangedFlags flags);
	}
	[CCode (type_id = "MX_TYPE_PADDING", cheader_filename = "mx/mx.h")]
	public struct Padding {
		public float top;
		public float right;
		public float bottom;
		public float left;
	}
	[CCode (cprefix = "MX_ALIGN_", cheader_filename = "mx/mx.h")]
	public enum Align {
		START,
		MIDDLE,
		END
	}
	[CCode (cprefix = "MX_APPLICATION_", cheader_filename = "mx/mx.h")]
	[Flags]
	public enum ApplicationFlags {
		SINGLE_INSTANCE,
		KEEP_ALIVE
	}
	[CCode (cprefix = "MX_DRAG_AXIS_", cheader_filename = "mx/mx.h")]
	public enum DragAxis {
		NONE,
		X,
		Y
	}
	[CCode (cprefix = "MX_FOCUS_DIRECTION_", cheader_filename = "mx/mx.h")]
	public enum FocusDirection {
		OUT,
		UP,
		DOWN,
		LEFT,
		RIGHT,
		NEXT,
		PREVIOUS
	}
	[CCode (cprefix = "MX_FOCUS_HINT_", cheader_filename = "mx/mx.h")]
	public enum FocusHint {
		FIRST,
		LAST,
		PRIOR
	}
	[CCode (cprefix = "MX_FONT_WEIGHT_", cheader_filename = "mx/mx.h")]
	public enum FontWeight {
		NORMAL,
		BOLD,
		BOLDER,
		LIGHTER
	}
	[CCode (cprefix = "MX_LONG_PRESS_", cheader_filename = "mx/mx.h")]
	public enum LongPressAction {
		QUERY,
		ACTION,
		CANCEL
	}
	[CCode (cprefix = "MX_ORIENTATION_", cheader_filename = "mx/mx.h")]
	public enum Orientation {
		HORIZONTAL,
		VERTICAL
	}
	[CCode (cprefix = "MX_SCROLL_POLICY_", cheader_filename = "mx/mx.h")]
	public enum ScrollPolicy {
		NONE,
		HORIZONTAL,
		VERTICAL,
		BOTH
	}
	[CCode (cprefix = "MX_STYLE_CHANGED_", cheader_filename = "mx/mx.h")]
	[Flags]
	public enum StyleChangedFlags {
		NONE,
		FORCE
	}
	[CCode (cprefix = "MX_STYLE_ERROR_INVALID_", cheader_filename = "mx/mx.h")]
	public enum StyleError {
		FILE
	}
	[CCode (cheader_filename = "mx/mx.h")]
	public delegate void ClipboardCallbackFunc (Mx.Clipboard clipboard, string text);
	[CCode (cheader_filename = "mx/mx.h")]
	public const int MAJOR_VERSION;
	[CCode (cheader_filename = "mx/mx.h")]
	public const int MICRO_VERSION;
	[CCode (cheader_filename = "mx/mx.h")]
	public const int MINOR_VERSION;
	[CCode (cheader_filename = "mx/mx.h")]
	public const int VERSION_HEX;
	[CCode (cheader_filename = "mx/mx.h")]
	public const string VERSION_S;
	[CCode (cheader_filename = "mx/mx.h")]
	public static void actor_box_clamp_to_pixels (Clutter.ActorBox box);
	[CCode (cheader_filename = "mx/mx.h")]
	public static void allocate_align_fill (Clutter.Actor child, Clutter.ActorBox childbox, Mx.Align x_alignment, Mx.Align y_alignment, bool x_fill, bool y_fill);
	[CCode (cheader_filename = "mx/mx.h")]
	public static void font_weight_set_from_string (GLib.Value value, string str);
	[CCode (cheader_filename = "mx/mx.h")]
	public static void set_locale ();
	[CCode (cheader_filename = "mx/mx.h")]
	public static unowned string utils_format_time (GLib.TimeVal time_);
}
