/* valaclass.c generated by valac, the Vala compiler
 * generated from valaclass.vala, do not modify */

/* valaclass.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>


#define VALA_TYPE_CODE_NODE (vala_code_node_get_type ())
#define VALA_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_NODE, ValaCodeNode))
#define VALA_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))
#define VALA_IS_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_NODE))
#define VALA_IS_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_NODE))
#define VALA_CODE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))

typedef struct _ValaCodeNode ValaCodeNode;
typedef struct _ValaCodeNodeClass ValaCodeNodeClass;
typedef struct _ValaCodeNodePrivate ValaCodeNodePrivate;

#define VALA_TYPE_CODE_VISITOR (vala_code_visitor_get_type ())
#define VALA_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitor))
#define VALA_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))
#define VALA_IS_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_VISITOR))
#define VALA_IS_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_VISITOR))
#define VALA_CODE_VISITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))

typedef struct _ValaCodeVisitor ValaCodeVisitor;
typedef struct _ValaCodeVisitorClass ValaCodeVisitorClass;

#define VALA_TYPE_CODE_CONTEXT (vala_code_context_get_type ())
#define VALA_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContext))
#define VALA_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))
#define VALA_IS_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_CONTEXT))
#define VALA_IS_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_CONTEXT))
#define VALA_CODE_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))

typedef struct _ValaCodeContext ValaCodeContext;
typedef struct _ValaCodeContextClass ValaCodeContextClass;

#define VALA_TYPE_CODE_GENERATOR (vala_code_generator_get_type ())
#define VALA_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGenerator))
#define VALA_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))
#define VALA_IS_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_GENERATOR))
#define VALA_IS_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_GENERATOR))
#define VALA_CODE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))

typedef struct _ValaCodeGenerator ValaCodeGenerator;
typedef struct _ValaCodeGeneratorClass ValaCodeGeneratorClass;

#define VALA_TYPE_DATA_TYPE (vala_data_type_get_type ())
#define VALA_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DATA_TYPE, ValaDataType))
#define VALA_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))
#define VALA_IS_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DATA_TYPE))
#define VALA_IS_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DATA_TYPE))
#define VALA_DATA_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))

typedef struct _ValaDataType ValaDataType;
typedef struct _ValaDataTypeClass ValaDataTypeClass;

#define VALA_TYPE_EXPRESSION (vala_expression_get_type ())
#define VALA_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_EXPRESSION, ValaExpression))
#define VALA_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_EXPRESSION, ValaExpressionClass))
#define VALA_IS_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_EXPRESSION))
#define VALA_IS_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_EXPRESSION))
#define VALA_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_EXPRESSION, ValaExpressionClass))

typedef struct _ValaExpression ValaExpression;
typedef struct _ValaExpressionClass ValaExpressionClass;

#define VALA_TYPE_SYMBOL (vala_symbol_get_type ())
#define VALA_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SYMBOL, ValaSymbol))
#define VALA_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SYMBOL, ValaSymbolClass))
#define VALA_IS_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SYMBOL))
#define VALA_IS_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SYMBOL))
#define VALA_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SYMBOL, ValaSymbolClass))

typedef struct _ValaSymbol ValaSymbol;
typedef struct _ValaSymbolClass ValaSymbolClass;

#define VALA_TYPE_VARIABLE (vala_variable_get_type ())
#define VALA_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VARIABLE, ValaVariable))
#define VALA_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VARIABLE, ValaVariableClass))
#define VALA_IS_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VARIABLE))
#define VALA_IS_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VARIABLE))
#define VALA_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VARIABLE, ValaVariableClass))

typedef struct _ValaVariable ValaVariable;
typedef struct _ValaVariableClass ValaVariableClass;

#define VALA_TYPE_LOCAL_VARIABLE (vala_local_variable_get_type ())
#define VALA_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable))
#define VALA_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))
#define VALA_IS_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_IS_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_LOCAL_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))

typedef struct _ValaLocalVariable ValaLocalVariable;
typedef struct _ValaLocalVariableClass ValaLocalVariableClass;

#define VALA_TYPE_ATTRIBUTE (vala_attribute_get_type ())
#define VALA_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ATTRIBUTE, ValaAttribute))
#define VALA_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))
#define VALA_IS_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ATTRIBUTE))
#define VALA_IS_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ATTRIBUTE))
#define VALA_ATTRIBUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))

typedef struct _ValaAttribute ValaAttribute;
typedef struct _ValaAttributeClass ValaAttributeClass;
typedef struct _ValaSymbolPrivate ValaSymbolPrivate;

#define VALA_TYPE_NAMESPACE (vala_namespace_get_type ())
#define VALA_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_NAMESPACE, ValaNamespace))
#define VALA_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_NAMESPACE, ValaNamespaceClass))
#define VALA_IS_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_NAMESPACE))
#define VALA_IS_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_NAMESPACE))
#define VALA_NAMESPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_NAMESPACE, ValaNamespaceClass))

typedef struct _ValaNamespace ValaNamespace;
typedef struct _ValaNamespaceClass ValaNamespaceClass;

#define VALA_TYPE_TYPESYMBOL (vala_typesymbol_get_type ())
#define VALA_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbol))
#define VALA_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))
#define VALA_IS_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPESYMBOL))
#define VALA_IS_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPESYMBOL))
#define VALA_TYPESYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))

typedef struct _ValaTypeSymbol ValaTypeSymbol;
typedef struct _ValaTypeSymbolClass ValaTypeSymbolClass;

#define VALA_TYPE_OBJECT_TYPE_SYMBOL (vala_object_type_symbol_get_type ())
#define VALA_OBJECT_TYPE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol))
#define VALA_OBJECT_TYPE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbolClass))
#define VALA_IS_OBJECT_TYPE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL))
#define VALA_IS_OBJECT_TYPE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_OBJECT_TYPE_SYMBOL))
#define VALA_OBJECT_TYPE_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbolClass))

typedef struct _ValaObjectTypeSymbol ValaObjectTypeSymbol;
typedef struct _ValaObjectTypeSymbolClass ValaObjectTypeSymbolClass;

#define VALA_TYPE_CLASS (vala_class_get_type ())
#define VALA_CLASS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CLASS, ValaClass))
#define VALA_CLASS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CLASS, ValaClassClass))
#define VALA_IS_CLASS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CLASS))
#define VALA_IS_CLASS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CLASS))
#define VALA_CLASS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CLASS, ValaClassClass))

typedef struct _ValaClass ValaClass;
typedef struct _ValaClassClass ValaClassClass;

#define VALA_TYPE_INTERFACE (vala_interface_get_type ())
#define VALA_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INTERFACE, ValaInterface))
#define VALA_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INTERFACE, ValaInterfaceClass))
#define VALA_IS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INTERFACE))
#define VALA_IS_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INTERFACE))
#define VALA_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INTERFACE, ValaInterfaceClass))

typedef struct _ValaInterface ValaInterface;
typedef struct _ValaInterfaceClass ValaInterfaceClass;

#define VALA_TYPE_STRUCT (vala_struct_get_type ())
#define VALA_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_STRUCT, ValaStruct))
#define VALA_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_STRUCT, ValaStructClass))
#define VALA_IS_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_STRUCT))
#define VALA_IS_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_STRUCT))
#define VALA_STRUCT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_STRUCT, ValaStructClass))

typedef struct _ValaStruct ValaStruct;
typedef struct _ValaStructClass ValaStructClass;

#define VALA_TYPE_ENUM (vala_enum_get_type ())
#define VALA_ENUM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ENUM, ValaEnum))
#define VALA_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ENUM, ValaEnumClass))
#define VALA_IS_ENUM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ENUM))
#define VALA_IS_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ENUM))
#define VALA_ENUM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ENUM, ValaEnumClass))

typedef struct _ValaEnum ValaEnum;
typedef struct _ValaEnumClass ValaEnumClass;

#define VALA_TYPE_ERROR_DOMAIN (vala_error_domain_get_type ())
#define VALA_ERROR_DOMAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain))
#define VALA_ERROR_DOMAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomainClass))
#define VALA_IS_ERROR_DOMAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ERROR_DOMAIN))
#define VALA_IS_ERROR_DOMAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ERROR_DOMAIN))
#define VALA_ERROR_DOMAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomainClass))

typedef struct _ValaErrorDomain ValaErrorDomain;
typedef struct _ValaErrorDomainClass ValaErrorDomainClass;

#define VALA_TYPE_DELEGATE (vala_delegate_get_type ())
#define VALA_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DELEGATE, ValaDelegate))
#define VALA_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DELEGATE, ValaDelegateClass))
#define VALA_IS_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DELEGATE))
#define VALA_IS_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DELEGATE))
#define VALA_DELEGATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DELEGATE, ValaDelegateClass))

typedef struct _ValaDelegate ValaDelegate;
typedef struct _ValaDelegateClass ValaDelegateClass;

#define VALA_TYPE_CONSTANT (vala_constant_get_type ())
#define VALA_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONSTANT, ValaConstant))
#define VALA_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONSTANT, ValaConstantClass))
#define VALA_IS_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONSTANT))
#define VALA_IS_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONSTANT))
#define VALA_CONSTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONSTANT, ValaConstantClass))

typedef struct _ValaConstant ValaConstant;
typedef struct _ValaConstantClass ValaConstantClass;

#define VALA_TYPE_FIELD (vala_field_get_type ())
#define VALA_FIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FIELD, ValaField))
#define VALA_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FIELD, ValaFieldClass))
#define VALA_IS_FIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FIELD))
#define VALA_IS_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FIELD))
#define VALA_FIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FIELD, ValaFieldClass))

typedef struct _ValaField ValaField;
typedef struct _ValaFieldClass ValaFieldClass;

#define VALA_TYPE_SUBROUTINE (vala_subroutine_get_type ())
#define VALA_SUBROUTINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SUBROUTINE, ValaSubroutine))
#define VALA_SUBROUTINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SUBROUTINE, ValaSubroutineClass))
#define VALA_IS_SUBROUTINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SUBROUTINE))
#define VALA_IS_SUBROUTINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SUBROUTINE))
#define VALA_SUBROUTINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SUBROUTINE, ValaSubroutineClass))

typedef struct _ValaSubroutine ValaSubroutine;
typedef struct _ValaSubroutineClass ValaSubroutineClass;

#define VALA_TYPE_METHOD (vala_method_get_type ())
#define VALA_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_METHOD, ValaMethod))
#define VALA_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_METHOD, ValaMethodClass))
#define VALA_IS_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_METHOD))
#define VALA_IS_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_METHOD))
#define VALA_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_METHOD, ValaMethodClass))

typedef struct _ValaMethod ValaMethod;
typedef struct _ValaMethodClass ValaMethodClass;

#define VALA_TYPE_PROPERTY (vala_property_get_type ())
#define VALA_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_PROPERTY, ValaProperty))
#define VALA_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_PROPERTY, ValaPropertyClass))
#define VALA_IS_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_PROPERTY))
#define VALA_IS_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_PROPERTY))
#define VALA_PROPERTY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_PROPERTY, ValaPropertyClass))

typedef struct _ValaProperty ValaProperty;
typedef struct _ValaPropertyClass ValaPropertyClass;

#define VALA_TYPE_SIGNAL (vala_signal_get_type ())
#define VALA_SIGNAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SIGNAL, ValaSignal))
#define VALA_SIGNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SIGNAL, ValaSignalClass))
#define VALA_IS_SIGNAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SIGNAL))
#define VALA_IS_SIGNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SIGNAL))
#define VALA_SIGNAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SIGNAL, ValaSignalClass))

typedef struct _ValaSignal ValaSignal;
typedef struct _ValaSignalClass ValaSignalClass;

#define VALA_TYPE_CONSTRUCTOR (vala_constructor_get_type ())
#define VALA_CONSTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONSTRUCTOR, ValaConstructor))
#define VALA_CONSTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONSTRUCTOR, ValaConstructorClass))
#define VALA_IS_CONSTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONSTRUCTOR))
#define VALA_IS_CONSTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONSTRUCTOR))
#define VALA_CONSTRUCTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONSTRUCTOR, ValaConstructorClass))

typedef struct _ValaConstructor ValaConstructor;
typedef struct _ValaConstructorClass ValaConstructorClass;

#define VALA_TYPE_DESTRUCTOR (vala_destructor_get_type ())
#define VALA_DESTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DESTRUCTOR, ValaDestructor))
#define VALA_DESTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DESTRUCTOR, ValaDestructorClass))
#define VALA_IS_DESTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DESTRUCTOR))
#define VALA_IS_DESTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DESTRUCTOR))
#define VALA_DESTRUCTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DESTRUCTOR, ValaDestructorClass))

typedef struct _ValaDestructor ValaDestructor;
typedef struct _ValaDestructorClass ValaDestructorClass;
typedef struct _ValaTypeSymbolPrivate ValaTypeSymbolPrivate;
typedef struct _ValaObjectTypeSymbolPrivate ValaObjectTypeSymbolPrivate;
typedef struct _ValaClassPrivate ValaClassPrivate;
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

#define VALA_TYPE_SOURCE_REFERENCE (vala_source_reference_get_type ())
#define VALA_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReference))
#define VALA_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))
#define VALA_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))

typedef struct _ValaSourceReference ValaSourceReference;
typedef struct _ValaSourceReferenceClass ValaSourceReferenceClass;

#define VALA_TYPE_COMMENT (vala_comment_get_type ())
#define VALA_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_COMMENT, ValaComment))
#define VALA_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_COMMENT, ValaCommentClass))
#define VALA_IS_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_COMMENT))
#define VALA_IS_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_COMMENT))
#define VALA_COMMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_COMMENT, ValaCommentClass))

typedef struct _ValaComment ValaComment;
typedef struct _ValaCommentClass ValaCommentClass;

#define VALA_TYPE_SCOPE (vala_scope_get_type ())
#define VALA_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SCOPE, ValaScope))
#define VALA_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SCOPE, ValaScopeClass))
#define VALA_IS_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SCOPE))
#define VALA_IS_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SCOPE))
#define VALA_SCOPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SCOPE, ValaScopeClass))

typedef struct _ValaScope ValaScope;
typedef struct _ValaScopeClass ValaScopeClass;

#define VALA_TYPE_PROFILE (vala_profile_get_type ())
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))

#define VALA_TYPE_MEMBER_BINDING (vala_member_binding_get_type ())

#define VALA_TYPE_SYMBOL_ACCESSIBILITY (vala_symbol_accessibility_get_type ())

#define VALA_TYPE_PROPERTY_ACCESSOR (vala_property_accessor_get_type ())
#define VALA_PROPERTY_ACCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_PROPERTY_ACCESSOR, ValaPropertyAccessor))
#define VALA_PROPERTY_ACCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_PROPERTY_ACCESSOR, ValaPropertyAccessorClass))
#define VALA_IS_PROPERTY_ACCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_PROPERTY_ACCESSOR))
#define VALA_IS_PROPERTY_ACCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_PROPERTY_ACCESSOR))
#define VALA_PROPERTY_ACCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_PROPERTY_ACCESSOR, ValaPropertyAccessorClass))

typedef struct _ValaPropertyAccessor ValaPropertyAccessor;
typedef struct _ValaPropertyAccessorClass ValaPropertyAccessorClass;

#define VALA_TYPE_BLOCK (vala_block_get_type ())
#define VALA_BLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_BLOCK, ValaBlock))
#define VALA_BLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_BLOCK, ValaBlockClass))
#define VALA_IS_BLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_BLOCK))
#define VALA_IS_BLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_BLOCK))
#define VALA_BLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_BLOCK, ValaBlockClass))

typedef struct _ValaBlock ValaBlock;
typedef struct _ValaBlockClass ValaBlockClass;

#define VALA_TYPE_CREATION_METHOD (vala_creation_method_get_type ())
#define VALA_CREATION_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CREATION_METHOD, ValaCreationMethod))
#define VALA_CREATION_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CREATION_METHOD, ValaCreationMethodClass))
#define VALA_IS_CREATION_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CREATION_METHOD))
#define VALA_IS_CREATION_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CREATION_METHOD))
#define VALA_CREATION_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CREATION_METHOD, ValaCreationMethodClass))

typedef struct _ValaCreationMethod ValaCreationMethod;
typedef struct _ValaCreationMethodClass ValaCreationMethodClass;

#define VALA_TYPE_PARAMETER (vala_parameter_get_type ())
#define VALA_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_PARAMETER, ValaParameter))
#define VALA_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_PARAMETER, ValaParameterClass))
#define VALA_IS_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_PARAMETER))
#define VALA_IS_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_PARAMETER))
#define VALA_PARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_PARAMETER, ValaParameterClass))

typedef struct _ValaParameter ValaParameter;
typedef struct _ValaParameterClass ValaParameterClass;

#define VALA_TYPE_REFERENCE_TYPE (vala_reference_type_get_type ())
#define VALA_REFERENCE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_REFERENCE_TYPE, ValaReferenceType))
#define VALA_REFERENCE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_REFERENCE_TYPE, ValaReferenceTypeClass))
#define VALA_IS_REFERENCE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_REFERENCE_TYPE))
#define VALA_IS_REFERENCE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_REFERENCE_TYPE))
#define VALA_REFERENCE_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_REFERENCE_TYPE, ValaReferenceTypeClass))

typedef struct _ValaReferenceType ValaReferenceType;
typedef struct _ValaReferenceTypeClass ValaReferenceTypeClass;

#define VALA_TYPE_OBJECT_TYPE (vala_object_type_get_type ())
#define VALA_OBJECT_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_OBJECT_TYPE, ValaObjectType))
#define VALA_OBJECT_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_OBJECT_TYPE, ValaObjectTypeClass))
#define VALA_IS_OBJECT_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_OBJECT_TYPE))
#define VALA_IS_OBJECT_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_OBJECT_TYPE))
#define VALA_OBJECT_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_OBJECT_TYPE, ValaObjectTypeClass))

typedef struct _ValaObjectType ValaObjectType;
typedef struct _ValaObjectTypeClass ValaObjectTypeClass;

#define VALA_TYPE_VOID_TYPE (vala_void_type_get_type ())
#define VALA_VOID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VOID_TYPE, ValaVoidType))
#define VALA_VOID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VOID_TYPE, ValaVoidTypeClass))
#define VALA_IS_VOID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VOID_TYPE))
#define VALA_IS_VOID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VOID_TYPE))
#define VALA_VOID_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VOID_TYPE, ValaVoidTypeClass))

typedef struct _ValaVoidType ValaVoidType;
typedef struct _ValaVoidTypeClass ValaVoidTypeClass;

#define VALA_TYPE_TYPEPARAMETER (vala_typeparameter_get_type ())
#define VALA_TYPEPARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPEPARAMETER, ValaTypeParameter))
#define VALA_TYPEPARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPEPARAMETER, ValaTypeParameterClass))
#define VALA_IS_TYPEPARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPEPARAMETER))
#define VALA_IS_TYPEPARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPEPARAMETER))
#define VALA_TYPEPARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPEPARAMETER, ValaTypeParameterClass))

typedef struct _ValaTypeParameter ValaTypeParameter;
typedef struct _ValaTypeParameterClass ValaTypeParameterClass;

#define VALA_TYPE_SEMANTIC_ANALYZER (vala_semantic_analyzer_get_type ())
#define VALA_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzer))
#define VALA_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))
#define VALA_IS_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_IS_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_SEMANTIC_ANALYZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))

typedef struct _ValaSemanticAnalyzer ValaSemanticAnalyzer;
typedef struct _ValaSemanticAnalyzerClass ValaSemanticAnalyzerClass;

#define VALA_TYPE_SOURCE_FILE (vala_source_file_get_type ())
#define VALA_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFile))
#define VALA_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))
#define VALA_IS_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_FILE))
#define VALA_IS_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_FILE))
#define VALA_SOURCE_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))

typedef struct _ValaSourceFile ValaSourceFile;
typedef struct _ValaSourceFileClass ValaSourceFileClass;
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))

#define VALA_TYPE_SOURCE_FILE_TYPE (vala_source_file_type_get_type ())

struct _ValaCodeNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCodeNodePrivate * priv;
	GList* attributes;
};

struct _ValaCodeNodeClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCodeNode *self);
	void (*accept) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	void (*accept_children) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	gboolean (*check) (ValaCodeNode* self, ValaCodeContext* context);
	void (*emit) (ValaCodeNode* self, ValaCodeGenerator* codegen);
	void (*replace_type) (ValaCodeNode* self, ValaDataType* old_type, ValaDataType* new_type);
	void (*replace_expression) (ValaCodeNode* self, ValaExpression* old_node, ValaExpression* new_node);
	gchar* (*to_string) (ValaCodeNode* self);
	void (*get_defined_variables) (ValaCodeNode* self, ValaCollection* collection);
	void (*get_used_variables) (ValaCodeNode* self, ValaCollection* collection);
};

struct _ValaSymbol {
	ValaCodeNode parent_instance;
	ValaSymbolPrivate * priv;
};

struct _ValaSymbolClass {
	ValaCodeNodeClass parent_class;
	gchar* (*get_cprefix) (ValaSymbol* self);
	gchar* (*get_lower_case_cname) (ValaSymbol* self, const gchar* infix);
	gchar* (*get_lower_case_cprefix) (ValaSymbol* self);
	ValaList* (*get_cheader_filenames) (ValaSymbol* self);
	gboolean (*is_instance_member) (ValaSymbol* self);
	gboolean (*is_class_member) (ValaSymbol* self);
	void (*process_deprecated_attribute) (ValaSymbol* self, ValaAttribute* attr);
	void (*process_experimental_attribute) (ValaSymbol* self, ValaAttribute* attr);
	void (*add_namespace) (ValaSymbol* self, ValaNamespace* ns);
	void (*add_class) (ValaSymbol* self, ValaClass* cl);
	void (*add_interface) (ValaSymbol* self, ValaInterface* iface);
	void (*add_struct) (ValaSymbol* self, ValaStruct* st);
	void (*add_enum) (ValaSymbol* self, ValaEnum* en);
	void (*add_error_domain) (ValaSymbol* self, ValaErrorDomain* edomain);
	void (*add_delegate) (ValaSymbol* self, ValaDelegate* d);
	void (*add_constant) (ValaSymbol* self, ValaConstant* constant);
	void (*add_field) (ValaSymbol* self, ValaField* f);
	void (*add_method) (ValaSymbol* self, ValaMethod* m);
	void (*add_property) (ValaSymbol* self, ValaProperty* prop);
	void (*add_signal) (ValaSymbol* self, ValaSignal* sig);
	void (*add_constructor) (ValaSymbol* self, ValaConstructor* c);
	void (*add_destructor) (ValaSymbol* self, ValaDestructor* d);
};

struct _ValaTypeSymbol {
	ValaSymbol parent_instance;
	ValaTypeSymbolPrivate * priv;
};

struct _ValaTypeSymbolClass {
	ValaSymbolClass parent_class;
	gchar* (*get_cname) (ValaTypeSymbol* self, gboolean const_type);
	gboolean (*is_reference_type) (ValaTypeSymbol* self);
	gchar* (*get_dup_function) (ValaTypeSymbol* self);
	gchar* (*get_free_function) (ValaTypeSymbol* self);
	gchar* (*get_copy_function) (ValaTypeSymbol* self);
	gchar* (*get_destroy_function) (ValaTypeSymbol* self);
	gboolean (*is_reference_counting) (ValaTypeSymbol* self);
	gchar* (*get_ref_function) (ValaTypeSymbol* self);
	gchar* (*get_unref_function) (ValaTypeSymbol* self);
	gchar* (*get_ref_sink_function) (ValaTypeSymbol* self);
	gchar* (*get_type_id) (ValaTypeSymbol* self);
	gchar* (*get_marshaller_type_name) (ValaTypeSymbol* self);
	gchar* (*get_param_spec_function) (ValaTypeSymbol* self);
	gchar* (*get_get_value_function) (ValaTypeSymbol* self);
	gchar* (*get_set_value_function) (ValaTypeSymbol* self);
	gchar* (*get_take_value_function) (ValaTypeSymbol* self);
	gchar* (*get_upper_case_cname) (ValaTypeSymbol* self, const gchar* infix);
	gchar* (*get_default_value) (ValaTypeSymbol* self);
	gboolean (*is_subtype_of) (ValaTypeSymbol* self, ValaTypeSymbol* t);
	gint (*get_type_parameter_index) (ValaTypeSymbol* self, const gchar* name);
};

struct _ValaObjectTypeSymbol {
	ValaTypeSymbol parent_instance;
	ValaObjectTypeSymbolPrivate * priv;
};

struct _ValaObjectTypeSymbolClass {
	ValaTypeSymbolClass parent_class;
	ValaList* (*get_methods) (ValaObjectTypeSymbol* self);
	ValaList* (*get_signals) (ValaObjectTypeSymbol* self);
	ValaList* (*get_properties) (ValaObjectTypeSymbol* self);
};

struct _ValaClass {
	ValaObjectTypeSymbol parent_instance;
	ValaClassPrivate * priv;
};

struct _ValaClassClass {
	ValaObjectTypeSymbolClass parent_class;
};

struct _ValaClassPrivate {
	ValaClass* _base_class;
	gboolean _is_abstract;
	gchar* _type_check_function;
	gboolean _has_private_fields;
	gboolean _has_class_private_fields;
	gboolean _free_function_address_of;
	gchar* cname;
	gchar* _const_cname;
	gchar* lower_case_cprefix;
	gchar* lower_case_csuffix;
	gchar* type_id;
	gchar* ref_function;
	gchar* unref_function;
	gboolean _ref_function_void;
	gchar* ref_sink_function;
	gchar* param_spec_function;
	gchar* copy_function;
	gchar* free_function;
	gchar* marshaller_type_name;
	gchar* get_value_function;
	gchar* set_value_function;
	gchar* take_value_function;
	gboolean _is_compact;
	gboolean _is_immutable;
	ValaList* base_types;
	ValaList* constants;
	ValaList* fields;
	ValaList* methods;
	ValaList* properties;
	ValaList* signals;
	ValaList* classes;
	ValaList* structs;
	ValaList* enums;
	ValaList* delegates;
	ValaMethod* _default_construction_method;
	ValaConstructor* _constructor;
	ValaConstructor* _class_constructor;
	ValaConstructor* _static_constructor;
	ValaDestructor* _static_destructor;
	ValaDestructor* _class_destructor;
	ValaDestructor* _destructor;
};

typedef enum  {
	VALA_PROFILE_POSIX,
	VALA_PROFILE_GOBJECT,
	VALA_PROFILE_DOVA
} ValaProfile;

typedef enum  {
	VALA_MEMBER_BINDING_INSTANCE,
	VALA_MEMBER_BINDING_CLASS,
	VALA_MEMBER_BINDING_STATIC
} ValaMemberBinding;

typedef enum  {
	VALA_SYMBOL_ACCESSIBILITY_PRIVATE,
	VALA_SYMBOL_ACCESSIBILITY_INTERNAL,
	VALA_SYMBOL_ACCESSIBILITY_PROTECTED,
	VALA_SYMBOL_ACCESSIBILITY_PUBLIC
} ValaSymbolAccessibility;

typedef enum  {
	VALA_SOURCE_FILE_TYPE_NONE,
	VALA_SOURCE_FILE_TYPE_SOURCE,
	VALA_SOURCE_FILE_TYPE_PACKAGE,
	VALA_SOURCE_FILE_TYPE_FAST
} ValaSourceFileType;


static gpointer vala_class_parent_class = NULL;

gpointer vala_code_node_ref (gpointer instance);
void vala_code_node_unref (gpointer instance);
GParamSpec* vala_param_spec_code_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_node (GValue* value, gpointer v_object);
void vala_value_take_code_node (GValue* value, gpointer v_object);
gpointer vala_value_get_code_node (const GValue* value);
GType vala_code_node_get_type (void) G_GNUC_CONST;
gpointer vala_code_visitor_ref (gpointer instance);
void vala_code_visitor_unref (gpointer instance);
GParamSpec* vala_param_spec_code_visitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_visitor (GValue* value, gpointer v_object);
void vala_value_take_code_visitor (GValue* value, gpointer v_object);
gpointer vala_value_get_code_visitor (const GValue* value);
GType vala_code_visitor_get_type (void) G_GNUC_CONST;
gpointer vala_code_context_ref (gpointer instance);
void vala_code_context_unref (gpointer instance);
GParamSpec* vala_param_spec_code_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_context (GValue* value, gpointer v_object);
void vala_value_take_code_context (GValue* value, gpointer v_object);
gpointer vala_value_get_code_context (const GValue* value);
GType vala_code_context_get_type (void) G_GNUC_CONST;
GType vala_code_generator_get_type (void) G_GNUC_CONST;
GType vala_data_type_get_type (void) G_GNUC_CONST;
GType vala_expression_get_type (void) G_GNUC_CONST;
GType vala_symbol_get_type (void) G_GNUC_CONST;
GType vala_variable_get_type (void) G_GNUC_CONST;
GType vala_local_variable_get_type (void) G_GNUC_CONST;
GType vala_attribute_get_type (void) G_GNUC_CONST;
GType vala_namespace_get_type (void) G_GNUC_CONST;
GType vala_typesymbol_get_type (void) G_GNUC_CONST;
GType vala_object_type_symbol_get_type (void) G_GNUC_CONST;
GType vala_class_get_type (void) G_GNUC_CONST;
GType vala_interface_get_type (void) G_GNUC_CONST;
GType vala_struct_get_type (void) G_GNUC_CONST;
GType vala_enum_get_type (void) G_GNUC_CONST;
GType vala_error_domain_get_type (void) G_GNUC_CONST;
GType vala_delegate_get_type (void) G_GNUC_CONST;
GType vala_constant_get_type (void) G_GNUC_CONST;
GType vala_field_get_type (void) G_GNUC_CONST;
GType vala_subroutine_get_type (void) G_GNUC_CONST;
GType vala_method_get_type (void) G_GNUC_CONST;
GType vala_property_get_type (void) G_GNUC_CONST;
GType vala_signal_get_type (void) G_GNUC_CONST;
GType vala_constructor_get_type (void) G_GNUC_CONST;
GType vala_destructor_get_type (void) G_GNUC_CONST;
#define VALA_CLASS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CLASS, ValaClassPrivate))
enum  {
	VALA_CLASS_DUMMY_PROPERTY
};
ValaList* vala_class_get_classes (ValaClass* self);
ValaList* vala_class_get_structs (ValaClass* self);
ValaList* vala_class_get_enums (ValaClass* self);
ValaList* vala_class_get_delegates (ValaClass* self);
gpointer vala_source_reference_ref (gpointer instance);
void vala_source_reference_unref (gpointer instance);
GParamSpec* vala_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_reference (GValue* value, gpointer v_object);
void vala_value_take_source_reference (GValue* value, gpointer v_object);
gpointer vala_value_get_source_reference (const GValue* value);
GType vala_source_reference_get_type (void) G_GNUC_CONST;
gpointer vala_comment_ref (gpointer instance);
void vala_comment_unref (gpointer instance);
GParamSpec* vala_param_spec_comment (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_comment (GValue* value, gpointer v_object);
void vala_value_take_comment (GValue* value, gpointer v_object);
gpointer vala_value_get_comment (const GValue* value);
GType vala_comment_get_type (void) G_GNUC_CONST;
ValaClass* vala_class_new (const gchar* name, ValaSourceReference* source_reference, ValaComment* comment);
ValaClass* vala_class_construct (GType object_type, const gchar* name, ValaSourceReference* source_reference, ValaComment* comment);
ValaObjectTypeSymbol* vala_object_type_symbol_construct (GType object_type, const gchar* name, ValaSourceReference* source_reference, ValaComment* comment);
void vala_class_add_base_type (ValaClass* self, ValaDataType* type);
void vala_code_node_set_parent_node (ValaCodeNode* self, ValaCodeNode* value);
ValaList* vala_class_get_base_types (ValaClass* self);
static void vala_class_real_add_constant (ValaSymbol* base, ValaConstant* c);
gpointer vala_scope_ref (gpointer instance);
void vala_scope_unref (gpointer instance);
GParamSpec* vala_param_spec_scope (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_scope (GValue* value, gpointer v_object);
void vala_value_take_scope (GValue* value, gpointer v_object);
gpointer vala_value_get_scope (const GValue* value);
GType vala_scope_get_type (void) G_GNUC_CONST;
ValaScope* vala_symbol_get_scope (ValaSymbol* self);
void vala_scope_add (ValaScope* self, const gchar* name, ValaSymbol* sym);
const gchar* vala_symbol_get_name (ValaSymbol* self);
static void vala_class_real_add_field (ValaSymbol* base, ValaField* f);
ValaCodeContext* vala_code_context_get (void);
GType vala_profile_get_type (void) G_GNUC_CONST;
ValaProfile vala_code_context_get_profile (ValaCodeContext* self);
GType vala_member_binding_get_type (void) G_GNUC_CONST;
ValaMemberBinding vala_field_get_binding (ValaField* self);
GType vala_symbol_accessibility_get_type (void) G_GNUC_CONST;
ValaSymbolAccessibility vala_symbol_get_access (ValaSymbol* self);
ValaDataType* vala_variable_get_variable_type (ValaVariable* self);
ValaDataType* vala_data_type_copy (ValaDataType* self);
ValaSourceReference* vala_code_node_get_source_reference (ValaCodeNode* self);
ValaComment* vala_symbol_get_comment (ValaSymbol* self);
GType vala_property_accessor_get_type (void) G_GNUC_CONST;
ValaProperty* vala_property_new (const gchar* name, ValaDataType* property_type, ValaPropertyAccessor* get_accessor, ValaPropertyAccessor* set_accessor, ValaSourceReference* source_reference, ValaComment* comment);
ValaProperty* vala_property_construct (GType object_type, const gchar* name, ValaDataType* property_type, ValaPropertyAccessor* get_accessor, ValaPropertyAccessor* set_accessor, ValaSourceReference* source_reference, ValaComment* comment);
void vala_symbol_set_access (ValaSymbol* self, ValaSymbolAccessibility value);
ValaDataType* vala_property_get_property_type (ValaProperty* self);
void vala_data_type_set_value_owned (ValaDataType* self, gboolean value);
GType vala_block_get_type (void) G_GNUC_CONST;
ValaPropertyAccessor* vala_property_accessor_new (gboolean readable, gboolean writable, gboolean construction, ValaDataType* value_type, ValaBlock* body, ValaSourceReference* source_reference, ValaComment* comment);
ValaPropertyAccessor* vala_property_accessor_construct (GType object_type, gboolean readable, gboolean writable, gboolean construction, ValaDataType* value_type, ValaBlock* body, ValaSourceReference* source_reference, ValaComment* comment);
void vala_property_set_get_accessor (ValaProperty* self, ValaPropertyAccessor* value);
void vala_property_set_set_accessor (ValaProperty* self, ValaPropertyAccessor* value);
void vala_symbol_set_name (ValaSymbol* self, const gchar* value);
void vala_property_set_field (ValaProperty* self, ValaField* value);
void vala_symbol_add_property (ValaSymbol* self, ValaProperty* prop);
void vala_class_set_has_private_fields (ValaClass* self, gboolean value);
static void vala_class_set_has_class_private_fields (ValaClass* self, gboolean value);
ValaList* vala_class_get_fields (ValaClass* self);
ValaList* vala_class_get_constants (ValaClass* self);
static void vala_class_real_add_method (ValaSymbol* base, ValaMethod* m);
ValaMemberBinding vala_method_get_binding (ValaMethod* self);
GType vala_creation_method_get_type (void) G_GNUC_CONST;
GType vala_parameter_get_type (void) G_GNUC_CONST;
ValaParameter* vala_method_get_this_parameter (ValaMethod* self);
void vala_scope_remove (ValaScope* self, const gchar* name);
GType vala_reference_type_get_type (void) G_GNUC_CONST;
GType vala_object_type_get_type (void) G_GNUC_CONST;
ValaObjectType* vala_object_type_symbol_get_this_type (ValaObjectTypeSymbol* self);
ValaParameter* vala_parameter_new (const gchar* name, ValaDataType* variable_type, ValaSourceReference* source_reference);
ValaParameter* vala_parameter_construct (GType object_type, const gchar* name, ValaDataType* variable_type, ValaSourceReference* source_reference);
void vala_method_set_this_parameter (ValaMethod* self, ValaParameter* value);
ValaDataType* vala_method_get_return_type (ValaMethod* self);
GType vala_void_type_get_type (void) G_GNUC_CONST;
ValaList* vala_method_get_postconditions (ValaMethod* self);
ValaLocalVariable* vala_subroutine_get_result_var (ValaSubroutine* self);
ValaLocalVariable* vala_local_variable_new (ValaDataType* variable_type, const gchar* name, ValaExpression* initializer, ValaSourceReference* source_reference);
ValaLocalVariable* vala_local_variable_construct (GType object_type, ValaDataType* variable_type, const gchar* name, ValaExpression* initializer, ValaSourceReference* source_reference);
void vala_subroutine_set_result_var (ValaSubroutine* self, ValaLocalVariable* value);
void vala_local_variable_set_is_result (ValaLocalVariable* self, gboolean value);
void vala_class_set_default_construction_method (ValaClass* self, ValaMethod* value);
const gchar* vala_creation_method_get_class_name (ValaCreationMethod* self);
void vala_report_error (ValaSourceReference* source, const gchar* message);
gchar* vala_symbol_get_full_name (ValaSymbol* self);
void vala_code_node_set_error (ValaCodeNode* self, gboolean value);
static ValaList* vala_class_real_get_methods (ValaObjectTypeSymbol* base);
static void vala_class_real_add_property (ValaSymbol* base, ValaProperty* prop);
void vala_property_set_this_parameter (ValaProperty* self, ValaParameter* value);
ValaParameter* vala_property_get_this_parameter (ValaProperty* self);
ValaField* vala_property_get_field (ValaProperty* self);
void vala_symbol_add_field (ValaSymbol* self, ValaField* f);
static ValaList* vala_class_real_get_properties (ValaObjectTypeSymbol* base);
static void vala_class_real_add_signal (ValaSymbol* base, ValaSignal* sig);
static ValaList* vala_class_real_get_signals (ValaObjectTypeSymbol* base);
static void vala_class_real_add_class (ValaSymbol* base, ValaClass* cl);
static void vala_class_real_add_struct (ValaSymbol* base, ValaStruct* st);
static void vala_class_real_add_enum (ValaSymbol* base, ValaEnum* en);
static void vala_class_real_add_delegate (ValaSymbol* base, ValaDelegate* d);
static void vala_class_real_add_constructor (ValaSymbol* base, ValaConstructor* c);
ValaMemberBinding vala_constructor_get_binding (ValaConstructor* self);
ValaConstructor* vala_class_get_constructor (ValaClass* self);
void vala_class_set_constructor (ValaClass* self, ValaConstructor* value);
ValaConstructor* vala_class_get_class_constructor (ValaClass* self);
void vala_class_set_class_constructor (ValaClass* self, ValaConstructor* value);
ValaConstructor* vala_class_get_static_constructor (ValaClass* self);
void vala_class_set_static_constructor (ValaClass* self, ValaConstructor* value);
static void vala_class_real_add_destructor (ValaSymbol* base, ValaDestructor* d);
ValaMemberBinding vala_destructor_get_binding (ValaDestructor* self);
ValaDestructor* vala_class_get_destructor (ValaClass* self);
void vala_class_set_destructor (ValaClass* self, ValaDestructor* value);
ValaDestructor* vala_class_get_class_destructor (ValaClass* self);
void vala_class_set_class_destructor (ValaClass* self, ValaDestructor* value);
ValaDestructor* vala_class_get_static_destructor (ValaClass* self);
void vala_class_set_static_destructor (ValaClass* self, ValaDestructor* value);
static void vala_class_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
void vala_code_visitor_visit_class (ValaCodeVisitor* self, ValaClass* cl);
static void vala_class_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
void vala_code_node_accept (ValaCodeNode* self, ValaCodeVisitor* visitor);
GType vala_typeparameter_get_type (void) G_GNUC_CONST;
ValaList* vala_object_type_symbol_get_type_parameters (ValaObjectTypeSymbol* self);
static gchar* vala_class_real_get_cprefix (ValaSymbol* base);
gchar* vala_typesymbol_get_cname (ValaTypeSymbol* self, gboolean const_type);
static gchar* vala_class_real_get_cname (ValaTypeSymbol* base, gboolean const_type);
const gchar* vala_class_get_const_cname (ValaClass* self);
gboolean vala_class_get_is_immutable (ValaClass* self);
ValaAttribute* vala_code_node_get_attribute (ValaCodeNode* self, const gchar* name);
gchar* vala_attribute_get_string (ValaAttribute* self, const gchar* name);
gchar* vala_class_get_default_cname (ValaClass* self);
ValaSymbol* vala_symbol_get_parent_symbol (ValaSymbol* self);
gchar* vala_symbol_get_cprefix (ValaSymbol* self);
void vala_class_set_cname (ValaClass* self, const gchar* cname);
static gchar* vala_class_get_lower_case_csuffix (ValaClass* self);
gchar* vala_symbol_camel_case_to_lower_case (const gchar* camel_case);
static gchar* vala_class_real_get_lower_case_cname (ValaSymbol* base, const gchar* infix);
gchar* vala_symbol_get_lower_case_cprefix (ValaSymbol* self);
static gchar* vala_class_real_get_lower_case_cprefix (ValaSymbol* base);
gchar* vala_symbol_get_lower_case_cname (ValaSymbol* self, const gchar* infix);
void vala_class_set_lower_case_cprefix (ValaClass* self, const gchar* cprefix);
static gchar* vala_class_real_get_upper_case_cname (ValaTypeSymbol* base, const gchar* infix);
static gboolean vala_class_real_is_reference_type (ValaTypeSymbol* base);
static void vala_class_process_gir_attribute (ValaClass* self, ValaAttribute* a);
gboolean vala_attribute_has_argument (ValaAttribute* self, const gchar* name);
void vala_symbol_set_gir_name (ValaSymbol* self, const gchar* value);
static void vala_class_process_ccode_attribute (ValaClass* self, ValaAttribute* a);
void vala_class_set_ref_function (ValaClass* self, const gchar* name);
gboolean vala_attribute_get_bool (ValaAttribute* self, const gchar* name);
void vala_class_set_ref_function_void (ValaClass* self, gboolean value);
void vala_class_set_unref_function (ValaClass* self, const gchar* name);
void vala_class_set_ref_sink_function (ValaClass* self, const gchar* name);
void vala_class_set_dup_function (ValaClass* self, const gchar* name);
void vala_class_set_free_function (ValaClass* self, const gchar* name);
static void vala_class_set_free_function_address_of (ValaClass* self, gboolean value);
void vala_class_set_const_cname (ValaClass* self, const gchar* value);
void vala_symbol_add_cheader_filename (ValaSymbol* self, const gchar* filename);
void vala_class_set_type_check_function (ValaClass* self, const gchar* value);
void vala_class_process_attributes (ValaClass* self);
const gchar* vala_attribute_get_name (ValaAttribute* self);
void vala_class_set_is_compact (ValaClass* self, gboolean value);
void vala_class_set_is_immutable (ValaClass* self, gboolean value);
void vala_symbol_process_deprecated_attribute (ValaSymbol* self, ValaAttribute* attr);
void vala_symbol_process_experimental_attribute (ValaSymbol* self, ValaAttribute* attr);
gchar* vala_class_get_default_type_id (ValaClass* self);
gboolean vala_class_get_is_compact (ValaClass* self);
gchar* vala_typesymbol_get_upper_case_cname (ValaTypeSymbol* self, const gchar* infix);
static gchar* vala_class_real_get_type_id (ValaTypeSymbol* base);
void vala_class_set_type_id (ValaClass* self, const gchar* type_id);
static gchar* vala_class_real_get_marshaller_type_name (ValaTypeSymbol* base);
ValaClass* vala_class_get_base_class (ValaClass* self);
gchar* vala_typesymbol_get_marshaller_type_name (ValaTypeSymbol* self);
gchar* vala_typesymbol_get_type_id (ValaTypeSymbol* self);
static gchar* vala_class_real_get_param_spec_function (ValaTypeSymbol* base);
gchar* vala_class_get_default_param_spec_function (ValaClass* self);
gboolean vala_class_is_fundamental (ValaClass* self);
gchar* vala_typesymbol_get_param_spec_function (ValaTypeSymbol* self);
static gchar* vala_class_real_get_get_value_function (ValaTypeSymbol* base);
gchar* vala_typesymbol_get_get_value_function (ValaTypeSymbol* self);
static gchar* vala_class_real_get_set_value_function (ValaTypeSymbol* base);
gchar* vala_typesymbol_get_set_value_function (ValaTypeSymbol* self);
static gchar* vala_class_real_get_take_value_function (ValaTypeSymbol* base);
gchar* vala_typesymbol_get_take_value_function (ValaTypeSymbol* self);
static gboolean vala_class_real_is_reference_counting (ValaTypeSymbol* base);
gchar* vala_typesymbol_get_ref_function (ValaTypeSymbol* self);
static gchar* vala_class_real_get_ref_function (ValaTypeSymbol* base);
static gchar* vala_class_real_get_unref_function (ValaTypeSymbol* base);
gchar* vala_typesymbol_get_unref_function (ValaTypeSymbol* self);
static gchar* vala_class_real_get_ref_sink_function (ValaTypeSymbol* base);
gchar* vala_typesymbol_get_ref_sink_function (ValaTypeSymbol* self);
static gchar* vala_class_real_get_dup_function (ValaTypeSymbol* base);
gchar* vala_class_get_default_free_function (ValaClass* self);
gchar* vala_typesymbol_get_free_function (ValaTypeSymbol* self);
static gchar* vala_class_real_get_free_function (ValaTypeSymbol* base);
static gboolean vala_class_real_is_subtype_of (ValaTypeSymbol* base, ValaTypeSymbol* t);
ValaTypeSymbol* vala_data_type_get_data_type (ValaDataType* self);
gboolean vala_typesymbol_is_subtype_of (ValaTypeSymbol* self, ValaTypeSymbol* t);
static void vala_class_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type);
static void vala_class_get_all_prerequisites (ValaClass* self, ValaInterface* iface, ValaList* list);
ValaList* vala_interface_get_prerequisites (ValaInterface* self);
static gboolean vala_class_class_is_a (ValaClass* self, ValaClass* cl, ValaTypeSymbol* t);
static gboolean vala_class_real_check (ValaCodeNode* base, ValaCodeContext* context);
gboolean vala_code_node_get_checked (ValaCodeNode* self);
gboolean vala_code_node_get_error (ValaCodeNode* self);
void vala_code_node_set_checked (ValaCodeNode* self, gboolean value);
GType vala_semantic_analyzer_get_type (void) G_GNUC_CONST;
ValaSemanticAnalyzer* vala_code_context_get_analyzer (ValaCodeContext* self);
gpointer vala_source_file_ref (gpointer instance);
void vala_source_file_unref (gpointer instance);
GParamSpec* vala_param_spec_source_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_file (GValue* value, gpointer v_object);
void vala_value_take_source_file (GValue* value, gpointer v_object);
gpointer vala_value_get_source_file (const GValue* value);
GType vala_source_file_get_type (void) G_GNUC_CONST;
ValaSourceFile* vala_semantic_analyzer_get_current_source_file (ValaSemanticAnalyzer* self);
ValaSymbol* vala_semantic_analyzer_get_current_symbol (ValaSemanticAnalyzer* self);
ValaSourceFile* vala_source_reference_get_file (ValaSourceReference* self);
void vala_semantic_analyzer_set_current_source_file (ValaSemanticAnalyzer* self, ValaSourceFile* value);
void vala_semantic_analyzer_set_current_symbol (ValaSemanticAnalyzer* self, ValaSymbol* value);
gboolean vala_code_node_check (ValaCodeNode* self, ValaCodeContext* context);
gchar* vala_code_node_to_string (ValaCodeNode* self);
gboolean vala_semantic_analyzer_is_type_accessible (ValaSemanticAnalyzer* self, ValaSymbol* sym, ValaDataType* type);
ValaList* vala_data_type_get_type_arguments (ValaDataType* self);
gboolean vala_symbol_get_external (ValaSymbol* self);
gboolean vala_symbol_get_external_package (ValaSymbol* self);
GType vala_source_file_type_get_type (void) G_GNUC_CONST;
ValaSourceFileType vala_symbol_get_source_type (ValaSymbol* self);
ValaList* vala_object_type_symbol_get_methods (ValaObjectTypeSymbol* self);
gboolean vala_method_get_is_abstract (ValaMethod* self);
ValaSymbol* vala_scope_lookup (ValaScope* self, const gchar* name);
gboolean vala_symbol_check_deprecated (ValaSymbol* self, ValaSourceReference* source_ref);
gboolean vala_symbol_check_experimental (ValaSymbol* self, ValaSourceReference* source_ref);
void vala_symbol_set_used (ValaSymbol* self, gboolean value);
ValaList* vala_object_type_symbol_get_properties (ValaObjectTypeSymbol* self);
gboolean vala_property_get_is_abstract (ValaProperty* self);
gboolean vala_class_get_is_abstract (ValaClass* self);
ValaSymbol* vala_semantic_analyzer_symbol_lookup_inherited (ValaSymbol* sym, const gchar* name);
gboolean vala_method_get_overrides (ValaMethod* self);
gboolean vala_property_get_overrides (ValaProperty* self);
void vala_class_set_base_class (ValaClass* self, ValaClass* value);
void vala_class_set_is_abstract (ValaClass* self, gboolean value);
gboolean vala_class_get_ref_function_void (ValaClass* self);
const gchar* vala_class_get_type_check_function (ValaClass* self);
gboolean vala_class_get_has_private_fields (ValaClass* self);
gboolean vala_class_get_has_class_private_fields (ValaClass* self);
gboolean vala_class_get_free_function_address_of (ValaClass* self);
gboolean vala_class_get_is_gboxed (ValaClass* self);
ValaMethod* vala_class_get_default_construction_method (ValaClass* self);
ValaParameter* vala_destructor_get_this_parameter (ValaDestructor* self);
void vala_destructor_set_this_parameter (ValaDestructor* self, ValaParameter* value);
gboolean vala_class_get_is_error_base (ValaClass* self);
static void vala_class_finalize (ValaCodeNode* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


/**
 * Returns a copy of the list of classes.
 *
 * @return list of classes
 */
static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList* vala_class_get_classes (ValaClass* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _vala_iterable_ref0 (self->priv->classes);
	result = _tmp0_;
	return result;
}


/**
 * Returns a copy of the list of structs.
 *
 * @return list of structs
 */
ValaList* vala_class_get_structs (ValaClass* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _vala_iterable_ref0 (self->priv->structs);
	result = _tmp0_;
	return result;
}


/**
 * Returns a copy of the list of enums.
 *
 * @return list of enums
 */
ValaList* vala_class_get_enums (ValaClass* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _vala_iterable_ref0 (self->priv->enums);
	result = _tmp0_;
	return result;
}


/**
 * Returns a copy of the list of delegates.
 *
 * @return list of delegates
 */
ValaList* vala_class_get_delegates (ValaClass* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _vala_iterable_ref0 (self->priv->delegates);
	result = _tmp0_;
	return result;
}


/**
 * Creates a new class.
 *
 * @param name   type name
 * @param source reference to source code
 * @param comment class documentation
 * @return       newly created class
 */
ValaClass* vala_class_construct (GType object_type, const gchar* name, ValaSourceReference* source_reference, ValaComment* comment) {
	ValaClass* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaClass*) vala_object_type_symbol_construct (object_type, name, source_reference, comment);
	return self;
}


ValaClass* vala_class_new (const gchar* name, ValaSourceReference* source_reference, ValaComment* comment) {
	return vala_class_construct (VALA_TYPE_CLASS, name, source_reference, comment);
}


/**
 * Adds the specified class or interface to the list of base types of
 * this class.
 *
 * @param type a class or interface reference
 */
void vala_class_add_base_type (ValaClass* self, ValaDataType* type) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	vala_collection_add ((ValaCollection*) self->priv->base_types, type);
	vala_code_node_set_parent_node ((ValaCodeNode*) type, (ValaCodeNode*) self);
}


/**
 * Returns a copy of the base type list.
 *
 * @return list of base types
 */
ValaList* vala_class_get_base_types (ValaClass* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _vala_iterable_ref0 (self->priv->base_types);
	result = _tmp0_;
	return result;
}


/**
 * Adds the specified constant as a member to this class.
 *
 * @param c a constant
 */
static void vala_class_real_add_constant (ValaSymbol* base, ValaConstant* c) {
	ValaClass * self;
	ValaScope* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	self = (ValaClass*) base;
	g_return_if_fail (c != NULL);
	vala_collection_add ((ValaCollection*) self->priv->constants, c);
	_tmp0_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp1_ = vala_symbol_get_name ((ValaSymbol*) c);
	vala_scope_add (_tmp0_, _tmp1_, (ValaSymbol*) c);
}


/**
 * Adds the specified field as a member to this class.
 *
 * @param f a field
 */
static void vala_class_real_add_field (ValaSymbol* base, ValaField* f) {
	ValaClass * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	ValaCodeContext* _tmp3_ = NULL;
	ValaCodeContext* _tmp4_;
	ValaProfile _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp35_ = FALSE;
	ValaSymbolAccessibility _tmp36_;
	ValaScope* _tmp41_ = NULL;
	const gchar* _tmp42_ = NULL;
	self = (ValaClass*) base;
	g_return_if_fail (f != NULL);
	_tmp3_ = vala_code_context_get ();
	_tmp4_ = _tmp3_;
	_tmp5_ = vala_code_context_get_profile (_tmp4_);
	_tmp6_ = _tmp5_ == VALA_PROFILE_DOVA;
	_vala_code_context_unref0 (_tmp4_);
	if (_tmp6_) {
		ValaMemberBinding _tmp7_;
		_tmp7_ = vala_field_get_binding (f);
		_tmp2_ = _tmp7_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gboolean _tmp8_ = FALSE;
		ValaSymbolAccessibility _tmp9_;
		_tmp9_ = vala_symbol_get_access ((ValaSymbol*) f);
		if (_tmp9_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
			_tmp8_ = TRUE;
		} else {
			ValaSymbolAccessibility _tmp10_;
			_tmp10_ = vala_symbol_get_access ((ValaSymbol*) f);
			_tmp8_ = _tmp10_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED;
		}
		_tmp1_ = _tmp8_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		const gchar* _tmp11_ = NULL;
		_tmp11_ = vala_symbol_get_name ((ValaSymbol*) self);
		_tmp0_ = g_strcmp0 (_tmp11_, "any") != 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		const gchar* _tmp12_ = NULL;
		ValaDataType* _tmp13_ = NULL;
		ValaDataType* _tmp14_ = NULL;
		ValaDataType* _tmp15_;
		ValaSourceReference* _tmp16_ = NULL;
		ValaComment* _tmp17_ = NULL;
		ValaProperty* _tmp18_ = NULL;
		ValaProperty* _tmp19_;
		ValaProperty* prop;
		ValaSymbolAccessibility _tmp20_;
		ValaDataType* _tmp21_ = NULL;
		ValaDataType* _tmp22_ = NULL;
		ValaDataType* get_type;
		ValaSourceReference* _tmp23_ = NULL;
		ValaPropertyAccessor* _tmp24_ = NULL;
		ValaPropertyAccessor* _tmp25_;
		ValaDataType* _tmp26_ = NULL;
		ValaDataType* _tmp27_ = NULL;
		ValaDataType* _tmp28_;
		ValaSourceReference* _tmp29_ = NULL;
		ValaPropertyAccessor* _tmp30_ = NULL;
		ValaPropertyAccessor* _tmp31_;
		const gchar* _tmp32_ = NULL;
		gchar* _tmp33_ = NULL;
		gchar* _tmp34_;
		_tmp12_ = vala_symbol_get_name ((ValaSymbol*) f);
		_tmp13_ = vala_variable_get_variable_type ((ValaVariable*) f);
		_tmp14_ = vala_data_type_copy (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_code_node_get_source_reference ((ValaCodeNode*) f);
		_tmp17_ = vala_symbol_get_comment ((ValaSymbol*) self);
		_tmp18_ = vala_property_new (_tmp12_, _tmp15_, NULL, NULL, _tmp16_, _tmp17_);
		_tmp19_ = _tmp18_;
		_vala_code_node_unref0 (_tmp15_);
		prop = _tmp19_;
		_tmp20_ = vala_symbol_get_access ((ValaSymbol*) self);
		vala_symbol_set_access ((ValaSymbol*) prop, _tmp20_);
		_tmp21_ = vala_property_get_property_type (prop);
		_tmp22_ = vala_data_type_copy (_tmp21_);
		get_type = _tmp22_;
		vala_data_type_set_value_owned (get_type, TRUE);
		_tmp23_ = vala_code_node_get_source_reference ((ValaCodeNode*) f);
		_tmp24_ = vala_property_accessor_new (TRUE, FALSE, FALSE, get_type, NULL, _tmp23_, NULL);
		_tmp25_ = _tmp24_;
		vala_property_set_get_accessor (prop, _tmp25_);
		_vala_code_node_unref0 (_tmp25_);
		_tmp26_ = vala_property_get_property_type (prop);
		_tmp27_ = vala_data_type_copy (_tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = vala_code_node_get_source_reference ((ValaCodeNode*) f);
		_tmp30_ = vala_property_accessor_new (FALSE, TRUE, FALSE, _tmp28_, NULL, _tmp29_, NULL);
		_tmp31_ = _tmp30_;
		vala_property_set_set_accessor (prop, _tmp31_);
		_vala_code_node_unref0 (_tmp31_);
		_vala_code_node_unref0 (_tmp28_);
		_tmp32_ = vala_symbol_get_name ((ValaSymbol*) f);
		_tmp33_ = g_strdup_printf ("_%s", _tmp32_);
		_tmp34_ = _tmp33_;
		vala_symbol_set_name ((ValaSymbol*) f, _tmp34_);
		_g_free0 (_tmp34_);
		vala_symbol_set_access ((ValaSymbol*) f, VALA_SYMBOL_ACCESSIBILITY_PRIVATE);
		vala_property_set_field (prop, f);
		vala_symbol_add_property ((ValaSymbol*) self, prop);
		_vala_code_node_unref0 (get_type);
		_vala_code_node_unref0 (prop);
		return;
	}
	vala_collection_add ((ValaCollection*) self->priv->fields, f);
	_tmp36_ = vala_symbol_get_access ((ValaSymbol*) f);
	if (_tmp36_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		ValaMemberBinding _tmp37_;
		_tmp37_ = vala_field_get_binding (f);
		_tmp35_ = _tmp37_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		vala_class_set_has_private_fields (self, TRUE);
	} else {
		gboolean _tmp38_ = FALSE;
		ValaSymbolAccessibility _tmp39_;
		_tmp39_ = vala_symbol_get_access ((ValaSymbol*) f);
		if (_tmp39_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaMemberBinding _tmp40_;
			_tmp40_ = vala_field_get_binding (f);
			_tmp38_ = _tmp40_ == VALA_MEMBER_BINDING_CLASS;
		} else {
			_tmp38_ = FALSE;
		}
		if (_tmp38_) {
			vala_class_set_has_class_private_fields (self, TRUE);
		}
	}
	_tmp41_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp42_ = vala_symbol_get_name ((ValaSymbol*) f);
	vala_scope_add (_tmp41_, _tmp42_, (ValaSymbol*) f);
}


/**
 * Returns a copy of the list of fields.
 *
 * @return list of fields
 */
ValaList* vala_class_get_fields (ValaClass* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _vala_iterable_ref0 (self->priv->fields);
	result = _tmp0_;
	return result;
}


/**
 * Returns a copy of the list of constants.
 *
 * @return list of constants
 */
ValaList* vala_class_get_constants (ValaClass* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _vala_iterable_ref0 (self->priv->constants);
	result = _tmp0_;
	return result;
}


/**
 * Adds the specified method as a member to this class.
 *
 * @param m a method
 */
static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


static void vala_class_real_add_method (ValaSymbol* base, ValaMethod* m) {
	ValaClass * self;
	gboolean _tmp0_ = FALSE;
	ValaMemberBinding _tmp1_;
	gboolean _tmp14_ = FALSE;
	ValaDataType* _tmp15_ = NULL;
	ValaScope* _tmp47_ = NULL;
	const gchar* _tmp48_ = NULL;
	self = (ValaClass*) base;
	g_return_if_fail (m != NULL);
	_tmp1_ = vala_method_get_binding (m);
	if (_tmp1_ == VALA_MEMBER_BINDING_INSTANCE) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = VALA_IS_CREATION_METHOD (m);
	}
	if (_tmp0_) {
		ValaParameter* _tmp2_ = NULL;
		ValaObjectType* _tmp6_ = NULL;
		ValaObjectType* _tmp7_;
		ValaParameter* _tmp8_ = NULL;
		ValaParameter* _tmp9_;
		ValaScope* _tmp10_ = NULL;
		ValaParameter* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		ValaParameter* _tmp13_ = NULL;
		_tmp2_ = vala_method_get_this_parameter (m);
		if (_tmp2_ != NULL) {
			ValaScope* _tmp3_ = NULL;
			ValaParameter* _tmp4_ = NULL;
			const gchar* _tmp5_ = NULL;
			_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) m);
			_tmp4_ = vala_method_get_this_parameter (m);
			_tmp5_ = vala_symbol_get_name ((ValaSymbol*) _tmp4_);
			vala_scope_remove (_tmp3_, _tmp5_);
		}
		_tmp6_ = vala_object_type_symbol_get_this_type ((ValaObjectTypeSymbol*) self);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_parameter_new ("this", (ValaDataType*) _tmp7_, NULL);
		_tmp9_ = _tmp8_;
		vala_method_set_this_parameter (m, _tmp9_);
		_vala_code_node_unref0 (_tmp9_);
		_vala_code_node_unref0 (_tmp7_);
		_tmp10_ = vala_symbol_get_scope ((ValaSymbol*) m);
		_tmp11_ = vala_method_get_this_parameter (m);
		_tmp12_ = vala_symbol_get_name ((ValaSymbol*) _tmp11_);
		_tmp13_ = vala_method_get_this_parameter (m);
		vala_scope_add (_tmp10_, _tmp12_, (ValaSymbol*) _tmp13_);
	}
	_tmp15_ = vala_method_get_return_type (m);
	if (!VALA_IS_VOID_TYPE (_tmp15_)) {
		gboolean _tmp16_ = FALSE;
		ValaCodeContext* _tmp17_ = NULL;
		ValaCodeContext* _tmp18_;
		ValaProfile _tmp19_;
		gboolean _tmp20_;
		_tmp17_ = vala_code_context_get ();
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_code_context_get_profile (_tmp18_);
		_tmp20_ = _tmp19_ == VALA_PROFILE_DOVA;
		_vala_code_context_unref0 (_tmp18_);
		if (_tmp20_) {
			_tmp16_ = TRUE;
		} else {
			ValaList* _tmp21_ = NULL;
			ValaList* _tmp22_;
			gint _tmp23_;
			_tmp21_ = vala_method_get_postconditions (m);
			_tmp22_ = _tmp21_;
			_tmp23_ = vala_collection_get_size ((ValaCollection*) _tmp22_);
			_tmp16_ = _tmp23_ > 0;
			_vala_iterable_unref0 (_tmp22_);
		}
		_tmp14_ = _tmp16_;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		ValaLocalVariable* _tmp24_ = NULL;
		ValaDataType* _tmp28_ = NULL;
		ValaDataType* _tmp29_ = NULL;
		ValaDataType* _tmp30_;
		ValaSourceReference* _tmp31_ = NULL;
		ValaLocalVariable* _tmp32_ = NULL;
		ValaLocalVariable* _tmp33_;
		ValaLocalVariable* _tmp34_ = NULL;
		_tmp24_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
		if (_tmp24_ != NULL) {
			ValaScope* _tmp25_ = NULL;
			ValaLocalVariable* _tmp26_ = NULL;
			const gchar* _tmp27_ = NULL;
			_tmp25_ = vala_symbol_get_scope ((ValaSymbol*) m);
			_tmp26_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
			_tmp27_ = vala_symbol_get_name ((ValaSymbol*) _tmp26_);
			vala_scope_remove (_tmp25_, _tmp27_);
		}
		_tmp28_ = vala_method_get_return_type (m);
		_tmp29_ = vala_data_type_copy (_tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp32_ = vala_local_variable_new (_tmp30_, "result", NULL, _tmp31_);
		_tmp33_ = _tmp32_;
		vala_subroutine_set_result_var ((ValaSubroutine*) m, _tmp33_);
		_vala_code_node_unref0 (_tmp33_);
		_vala_code_node_unref0 (_tmp30_);
		_tmp34_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
		vala_local_variable_set_is_result (_tmp34_, TRUE);
	}
	if (VALA_IS_CREATION_METHOD (m)) {
		const gchar* _tmp35_ = NULL;
		ValaCreationMethod* _tmp36_;
		ValaCreationMethod* cm;
		gboolean _tmp37_ = FALSE;
		const gchar* _tmp38_ = NULL;
		_tmp35_ = vala_symbol_get_name ((ValaSymbol*) m);
		if (_tmp35_ == NULL) {
			vala_class_set_default_construction_method (self, m);
			vala_symbol_set_name ((ValaSymbol*) m, ".new");
		}
		_tmp36_ = _vala_code_node_ref0 (VALA_CREATION_METHOD (m));
		cm = _tmp36_;
		_tmp38_ = vala_creation_method_get_class_name (cm);
		if (_tmp38_ != NULL) {
			const gchar* _tmp39_ = NULL;
			const gchar* _tmp40_ = NULL;
			_tmp39_ = vala_creation_method_get_class_name (cm);
			_tmp40_ = vala_symbol_get_name ((ValaSymbol*) self);
			_tmp37_ = g_strcmp0 (_tmp39_, _tmp40_) != 0;
		} else {
			_tmp37_ = FALSE;
		}
		if (_tmp37_) {
			ValaSourceReference* _tmp41_ = NULL;
			gchar* _tmp42_ = NULL;
			gchar* _tmp43_;
			const gchar* _tmp44_ = NULL;
			gchar* _tmp45_ = NULL;
			gchar* _tmp46_;
			_tmp41_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
			_tmp42_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp43_ = _tmp42_;
			_tmp44_ = vala_creation_method_get_class_name (cm);
			_tmp45_ = g_strdup_printf ("missing return type in method `%s.%s´", _tmp43_, _tmp44_);
			_tmp46_ = _tmp45_;
			vala_report_error (_tmp41_, _tmp46_);
			_g_free0 (_tmp46_);
			_g_free0 (_tmp43_);
			vala_code_node_set_error ((ValaCodeNode*) m, TRUE);
			_vala_code_node_unref0 (cm);
			return;
		}
		_vala_code_node_unref0 (cm);
	}
	vala_collection_add ((ValaCollection*) self->priv->methods, m);
	_tmp47_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp48_ = vala_symbol_get_name ((ValaSymbol*) m);
	vala_scope_add (_tmp47_, _tmp48_, (ValaSymbol*) m);
}


/**
 * Returns a copy of the list of methods.
 *
 * @return list of methods
 */
static ValaList* vala_class_real_get_methods (ValaObjectTypeSymbol* base) {
	ValaClass * self;
	ValaList* result = NULL;
	ValaList* _tmp0_;
	self = (ValaClass*) base;
	_tmp0_ = _vala_iterable_ref0 (self->priv->methods);
	result = _tmp0_;
	return result;
}


/**
 * Adds the specified property as a member to this class.
 *
 * @param prop a property
 */
static void vala_class_real_add_property (ValaSymbol* base, ValaProperty* prop) {
	ValaClass * self;
	ValaScope* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	ValaObjectType* _tmp2_ = NULL;
	ValaObjectType* _tmp3_;
	ValaParameter* _tmp4_ = NULL;
	ValaParameter* _tmp5_;
	ValaScope* _tmp6_ = NULL;
	ValaParameter* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	ValaParameter* _tmp9_ = NULL;
	ValaField* _tmp10_ = NULL;
	self = (ValaClass*) base;
	g_return_if_fail (prop != NULL);
	vala_collection_add ((ValaCollection*) self->priv->properties, prop);
	_tmp0_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp1_ = vala_symbol_get_name ((ValaSymbol*) prop);
	vala_scope_add (_tmp0_, _tmp1_, (ValaSymbol*) prop);
	_tmp2_ = vala_object_type_symbol_get_this_type ((ValaObjectTypeSymbol*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_parameter_new ("this", (ValaDataType*) _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	vala_property_set_this_parameter (prop, _tmp5_);
	_vala_code_node_unref0 (_tmp5_);
	_vala_code_node_unref0 (_tmp3_);
	_tmp6_ = vala_symbol_get_scope ((ValaSymbol*) prop);
	_tmp7_ = vala_property_get_this_parameter (prop);
	_tmp8_ = vala_symbol_get_name ((ValaSymbol*) _tmp7_);
	_tmp9_ = vala_property_get_this_parameter (prop);
	vala_scope_add (_tmp6_, _tmp8_, (ValaSymbol*) _tmp9_);
	_tmp10_ = vala_property_get_field (prop);
	if (_tmp10_ != NULL) {
		ValaField* _tmp11_ = NULL;
		_tmp11_ = vala_property_get_field (prop);
		vala_symbol_add_field ((ValaSymbol*) self, _tmp11_);
	}
}


/**
 * Returns a copy of the list of properties.
 *
 * @return list of properties
 */
static ValaList* vala_class_real_get_properties (ValaObjectTypeSymbol* base) {
	ValaClass * self;
	ValaList* result = NULL;
	ValaList* _tmp0_;
	self = (ValaClass*) base;
	_tmp0_ = _vala_iterable_ref0 (self->priv->properties);
	result = _tmp0_;
	return result;
}


/**
 * Adds the specified signal as a member to this class.
 *
 * @param sig a signal
 */
static void vala_class_real_add_signal (ValaSymbol* base, ValaSignal* sig) {
	ValaClass * self;
	ValaScope* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	self = (ValaClass*) base;
	g_return_if_fail (sig != NULL);
	vala_collection_add ((ValaCollection*) self->priv->signals, sig);
	_tmp0_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp1_ = vala_symbol_get_name ((ValaSymbol*) sig);
	vala_scope_add (_tmp0_, _tmp1_, (ValaSymbol*) sig);
}


/**
 * Returns a copy of the list of signals.
 *
 * @return list of signals
 */
static ValaList* vala_class_real_get_signals (ValaObjectTypeSymbol* base) {
	ValaClass * self;
	ValaList* result = NULL;
	ValaList* _tmp0_;
	self = (ValaClass*) base;
	_tmp0_ = _vala_iterable_ref0 (self->priv->signals);
	result = _tmp0_;
	return result;
}


/**
 * Adds the specified class as an inner class.
 *
 * @param cl a class
 */
static void vala_class_real_add_class (ValaSymbol* base, ValaClass* cl) {
	ValaClass * self;
	ValaScope* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	self = (ValaClass*) base;
	g_return_if_fail (cl != NULL);
	vala_collection_add ((ValaCollection*) self->priv->classes, cl);
	_tmp0_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp1_ = vala_symbol_get_name ((ValaSymbol*) cl);
	vala_scope_add (_tmp0_, _tmp1_, (ValaSymbol*) cl);
}


/**
 * Adds the specified struct as an inner struct.
 *
 * @param st a struct
 */
static void vala_class_real_add_struct (ValaSymbol* base, ValaStruct* st) {
	ValaClass * self;
	ValaScope* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	self = (ValaClass*) base;
	g_return_if_fail (st != NULL);
	vala_collection_add ((ValaCollection*) self->priv->structs, st);
	_tmp0_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp1_ = vala_symbol_get_name ((ValaSymbol*) st);
	vala_scope_add (_tmp0_, _tmp1_, (ValaSymbol*) st);
}


/**
 * Adds the specified enum as an inner enum.
 *
 * @param en an enum
 */
static void vala_class_real_add_enum (ValaSymbol* base, ValaEnum* en) {
	ValaClass * self;
	ValaScope* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	self = (ValaClass*) base;
	g_return_if_fail (en != NULL);
	vala_collection_add ((ValaCollection*) self->priv->enums, en);
	_tmp0_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp1_ = vala_symbol_get_name ((ValaSymbol*) en);
	vala_scope_add (_tmp0_, _tmp1_, (ValaSymbol*) en);
}


/**
 * Adds the specified delegate as an inner delegate.
 *
 * @param d a delegate
 */
static void vala_class_real_add_delegate (ValaSymbol* base, ValaDelegate* d) {
	ValaClass * self;
	ValaScope* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	self = (ValaClass*) base;
	g_return_if_fail (d != NULL);
	vala_collection_add ((ValaCollection*) self->priv->delegates, d);
	_tmp0_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp1_ = vala_symbol_get_name ((ValaSymbol*) d);
	vala_scope_add (_tmp0_, _tmp1_, (ValaSymbol*) d);
}


static void vala_class_real_add_constructor (ValaSymbol* base, ValaConstructor* c) {
	ValaClass * self;
	ValaMemberBinding _tmp0_;
	self = (ValaClass*) base;
	g_return_if_fail (c != NULL);
	_tmp0_ = vala_constructor_get_binding (c);
	if (_tmp0_ == VALA_MEMBER_BINDING_INSTANCE) {
		if (self->priv->_constructor != NULL) {
			ValaSourceReference* _tmp1_ = NULL;
			_tmp1_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
			vala_report_error (_tmp1_, "class already contains a constructor");
		}
		vala_class_set_constructor (self, c);
	} else {
		ValaMemberBinding _tmp2_;
		_tmp2_ = vala_constructor_get_binding (c);
		if (_tmp2_ == VALA_MEMBER_BINDING_CLASS) {
			if (self->priv->_class_constructor != NULL) {
				ValaSourceReference* _tmp3_ = NULL;
				_tmp3_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
				vala_report_error (_tmp3_, "class already contains a class constructor");
			}
			vala_class_set_class_constructor (self, c);
		} else {
			if (self->priv->_static_constructor != NULL) {
				ValaSourceReference* _tmp4_ = NULL;
				_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
				vala_report_error (_tmp4_, "class already contains a static constructor");
			}
			vala_class_set_static_constructor (self, c);
		}
	}
}


static void vala_class_real_add_destructor (ValaSymbol* base, ValaDestructor* d) {
	ValaClass * self;
	ValaMemberBinding _tmp0_;
	self = (ValaClass*) base;
	g_return_if_fail (d != NULL);
	_tmp0_ = vala_destructor_get_binding (d);
	if (_tmp0_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaDestructor* _tmp1_ = NULL;
		_tmp1_ = vala_class_get_destructor (self);
		if (_tmp1_ != NULL) {
			ValaSourceReference* _tmp2_ = NULL;
			_tmp2_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
			vala_report_error (_tmp2_, "class already contains a destructor");
		}
		vala_class_set_destructor (self, d);
	} else {
		ValaMemberBinding _tmp3_;
		_tmp3_ = vala_destructor_get_binding (d);
		if (_tmp3_ == VALA_MEMBER_BINDING_CLASS) {
			if (self->priv->_class_destructor != NULL) {
				ValaSourceReference* _tmp4_ = NULL;
				_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
				vala_report_error (_tmp4_, "class already contains a class destructor");
			}
			vala_class_set_class_destructor (self, d);
		} else {
			if (self->priv->_static_destructor != NULL) {
				ValaSourceReference* _tmp5_ = NULL;
				_tmp5_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
				vala_report_error (_tmp5_, "class already contains a static destructor");
			}
			vala_class_set_static_destructor (self, d);
		}
	}
}


static void vala_class_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaClass * self;
	self = (ValaClass*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_class (visitor, self);
}


static void vala_class_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaClass * self;
	ValaDestructor* _tmp24_ = NULL;
	self = (ValaClass*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _tmp0_;
		ValaList* _type_list;
		gint _tmp1_;
		gint _type_size;
		gint _type_index;
		_tmp0_ = _vala_iterable_ref0 (self->priv->base_types);
		_type_list = _tmp0_;
		_tmp1_ = vala_collection_get_size ((ValaCollection*) _type_list);
		_type_size = _tmp1_;
		_type_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			ValaDataType* type;
			_type_index = _type_index + 1;
			if (!(_type_index < _type_size)) {
				break;
			}
			_tmp2_ = vala_list_get (_type_list, _type_index);
			type = (ValaDataType*) _tmp2_;
			vala_code_node_accept ((ValaCodeNode*) type, visitor);
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	{
		ValaList* _tmp3_ = NULL;
		ValaList* _p_list;
		gint _tmp4_;
		gint _p_size;
		gint _p_index;
		_tmp3_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) self);
		_p_list = _tmp3_;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _p_list);
		_p_size = _tmp4_;
		_p_index = -1;
		while (TRUE) {
			gpointer _tmp5_ = NULL;
			ValaTypeParameter* p;
			_p_index = _p_index + 1;
			if (!(_p_index < _p_size)) {
				break;
			}
			_tmp5_ = vala_list_get (_p_list, _p_index);
			p = (ValaTypeParameter*) _tmp5_;
			vala_code_node_accept ((ValaCodeNode*) p, visitor);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	{
		ValaList* _tmp6_;
		ValaList* _en_list;
		gint _tmp7_;
		gint _en_size;
		gint _en_index;
		_tmp6_ = _vala_iterable_ref0 (self->priv->enums);
		_en_list = _tmp6_;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _en_list);
		_en_size = _tmp7_;
		_en_index = -1;
		while (TRUE) {
			gpointer _tmp8_ = NULL;
			ValaEnum* en;
			_en_index = _en_index + 1;
			if (!(_en_index < _en_size)) {
				break;
			}
			_tmp8_ = vala_list_get (_en_list, _en_index);
			en = (ValaEnum*) _tmp8_;
			vala_code_node_accept ((ValaCodeNode*) en, visitor);
			_vala_code_node_unref0 (en);
		}
		_vala_iterable_unref0 (_en_list);
	}
	{
		ValaList* _tmp9_;
		ValaList* _f_list;
		gint _tmp10_;
		gint _f_size;
		gint _f_index;
		_tmp9_ = _vala_iterable_ref0 (self->priv->fields);
		_f_list = _tmp9_;
		_tmp10_ = vala_collection_get_size ((ValaCollection*) _f_list);
		_f_size = _tmp10_;
		_f_index = -1;
		while (TRUE) {
			gpointer _tmp11_ = NULL;
			ValaField* f;
			_f_index = _f_index + 1;
			if (!(_f_index < _f_size)) {
				break;
			}
			_tmp11_ = vala_list_get (_f_list, _f_index);
			f = (ValaField*) _tmp11_;
			vala_code_node_accept ((ValaCodeNode*) f, visitor);
			_vala_code_node_unref0 (f);
		}
		_vala_iterable_unref0 (_f_list);
	}
	{
		ValaList* _tmp12_;
		ValaList* _c_list;
		gint _tmp13_;
		gint _c_size;
		gint _c_index;
		_tmp12_ = _vala_iterable_ref0 (self->priv->constants);
		_c_list = _tmp12_;
		_tmp13_ = vala_collection_get_size ((ValaCollection*) _c_list);
		_c_size = _tmp13_;
		_c_index = -1;
		while (TRUE) {
			gpointer _tmp14_ = NULL;
			ValaConstant* c;
			_c_index = _c_index + 1;
			if (!(_c_index < _c_size)) {
				break;
			}
			_tmp14_ = vala_list_get (_c_list, _c_index);
			c = (ValaConstant*) _tmp14_;
			vala_code_node_accept ((ValaCodeNode*) c, visitor);
			_vala_code_node_unref0 (c);
		}
		_vala_iterable_unref0 (_c_list);
	}
	{
		ValaList* _tmp15_;
		ValaList* _m_list;
		gint _tmp16_;
		gint _m_size;
		gint _m_index;
		_tmp15_ = _vala_iterable_ref0 (self->priv->methods);
		_m_list = _tmp15_;
		_tmp16_ = vala_collection_get_size ((ValaCollection*) _m_list);
		_m_size = _tmp16_;
		_m_index = -1;
		while (TRUE) {
			gpointer _tmp17_ = NULL;
			ValaMethod* m;
			_m_index = _m_index + 1;
			if (!(_m_index < _m_size)) {
				break;
			}
			_tmp17_ = vala_list_get (_m_list, _m_index);
			m = (ValaMethod*) _tmp17_;
			vala_code_node_accept ((ValaCodeNode*) m, visitor);
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	{
		ValaList* _tmp18_;
		ValaList* _prop_list;
		gint _tmp19_;
		gint _prop_size;
		gint _prop_index;
		_tmp18_ = _vala_iterable_ref0 (self->priv->properties);
		_prop_list = _tmp18_;
		_tmp19_ = vala_collection_get_size ((ValaCollection*) _prop_list);
		_prop_size = _tmp19_;
		_prop_index = -1;
		while (TRUE) {
			gpointer _tmp20_ = NULL;
			ValaProperty* prop;
			_prop_index = _prop_index + 1;
			if (!(_prop_index < _prop_size)) {
				break;
			}
			_tmp20_ = vala_list_get (_prop_list, _prop_index);
			prop = (ValaProperty*) _tmp20_;
			vala_code_node_accept ((ValaCodeNode*) prop, visitor);
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	{
		ValaList* _tmp21_;
		ValaList* _sig_list;
		gint _tmp22_;
		gint _sig_size;
		gint _sig_index;
		_tmp21_ = _vala_iterable_ref0 (self->priv->signals);
		_sig_list = _tmp21_;
		_tmp22_ = vala_collection_get_size ((ValaCollection*) _sig_list);
		_sig_size = _tmp22_;
		_sig_index = -1;
		while (TRUE) {
			gpointer _tmp23_ = NULL;
			ValaSignal* sig;
			_sig_index = _sig_index + 1;
			if (!(_sig_index < _sig_size)) {
				break;
			}
			_tmp23_ = vala_list_get (_sig_list, _sig_index);
			sig = (ValaSignal*) _tmp23_;
			vala_code_node_accept ((ValaCodeNode*) sig, visitor);
			_vala_code_node_unref0 (sig);
		}
		_vala_iterable_unref0 (_sig_list);
	}
	if (self->priv->_constructor != NULL) {
		vala_code_node_accept ((ValaCodeNode*) self->priv->_constructor, visitor);
	}
	if (self->priv->_class_constructor != NULL) {
		vala_code_node_accept ((ValaCodeNode*) self->priv->_class_constructor, visitor);
	}
	if (self->priv->_static_constructor != NULL) {
		vala_code_node_accept ((ValaCodeNode*) self->priv->_static_constructor, visitor);
	}
	_tmp24_ = vala_class_get_destructor (self);
	if (_tmp24_ != NULL) {
		ValaDestructor* _tmp25_ = NULL;
		_tmp25_ = vala_class_get_destructor (self);
		vala_code_node_accept ((ValaCodeNode*) _tmp25_, visitor);
	}
	if (self->priv->_static_destructor != NULL) {
		vala_code_node_accept ((ValaCodeNode*) self->priv->_static_destructor, visitor);
	}
	if (self->priv->_class_destructor != NULL) {
		vala_code_node_accept ((ValaCodeNode*) self->priv->_class_destructor, visitor);
	}
	{
		ValaList* _tmp26_;
		ValaList* _cl_list;
		gint _tmp27_;
		gint _cl_size;
		gint _cl_index;
		_tmp26_ = _vala_iterable_ref0 (self->priv->classes);
		_cl_list = _tmp26_;
		_tmp27_ = vala_collection_get_size ((ValaCollection*) _cl_list);
		_cl_size = _tmp27_;
		_cl_index = -1;
		while (TRUE) {
			gpointer _tmp28_ = NULL;
			ValaClass* cl;
			_cl_index = _cl_index + 1;
			if (!(_cl_index < _cl_size)) {
				break;
			}
			_tmp28_ = vala_list_get (_cl_list, _cl_index);
			cl = (ValaClass*) _tmp28_;
			vala_code_node_accept ((ValaCodeNode*) cl, visitor);
			_vala_code_node_unref0 (cl);
		}
		_vala_iterable_unref0 (_cl_list);
	}
	{
		ValaList* _tmp29_;
		ValaList* _st_list;
		gint _tmp30_;
		gint _st_size;
		gint _st_index;
		_tmp29_ = _vala_iterable_ref0 (self->priv->structs);
		_st_list = _tmp29_;
		_tmp30_ = vala_collection_get_size ((ValaCollection*) _st_list);
		_st_size = _tmp30_;
		_st_index = -1;
		while (TRUE) {
			gpointer _tmp31_ = NULL;
			ValaStruct* st;
			_st_index = _st_index + 1;
			if (!(_st_index < _st_size)) {
				break;
			}
			_tmp31_ = vala_list_get (_st_list, _st_index);
			st = (ValaStruct*) _tmp31_;
			vala_code_node_accept ((ValaCodeNode*) st, visitor);
			_vala_code_node_unref0 (st);
		}
		_vala_iterable_unref0 (_st_list);
	}
	{
		ValaList* _tmp32_;
		ValaList* _d_list;
		gint _tmp33_;
		gint _d_size;
		gint _d_index;
		_tmp32_ = _vala_iterable_ref0 (self->priv->delegates);
		_d_list = _tmp32_;
		_tmp33_ = vala_collection_get_size ((ValaCollection*) _d_list);
		_d_size = _tmp33_;
		_d_index = -1;
		while (TRUE) {
			gpointer _tmp34_ = NULL;
			ValaDelegate* d;
			_d_index = _d_index + 1;
			if (!(_d_index < _d_size)) {
				break;
			}
			_tmp34_ = vala_list_get (_d_list, _d_index);
			d = (ValaDelegate*) _tmp34_;
			vala_code_node_accept ((ValaCodeNode*) d, visitor);
			_vala_code_node_unref0 (d);
		}
		_vala_iterable_unref0 (_d_list);
	}
}


static gchar* vala_class_real_get_cprefix (ValaSymbol* base) {
	ValaClass * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	self = (ValaClass*) base;
	_tmp0_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) self, FALSE);
	result = _tmp0_;
	return result;
}


static gchar* vala_class_real_get_cname (ValaTypeSymbol* base, gboolean const_type) {
	ValaClass * self;
	gchar* result = NULL;
	gchar* _tmp9_;
	self = (ValaClass*) base;
	if (const_type) {
		if (self->priv->_const_cname != NULL) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self->priv->_const_cname);
			result = _tmp0_;
			return result;
		} else {
			gboolean _tmp1_;
			_tmp1_ = vala_class_get_is_immutable (self);
			if (_tmp1_) {
				gchar* _tmp2_ = NULL;
				gchar* _tmp3_;
				gchar* _tmp4_;
				gchar* _tmp5_;
				_tmp2_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) self, FALSE);
				_tmp3_ = _tmp2_;
				_tmp4_ = g_strconcat ("const ", _tmp3_, NULL);
				_tmp5_ = _tmp4_;
				_g_free0 (_tmp3_);
				result = _tmp5_;
				return result;
			}
		}
	}
	if (self->priv->cname == NULL) {
		ValaAttribute* _tmp6_ = NULL;
		ValaAttribute* attr;
		_tmp6_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "CCode");
		attr = _tmp6_;
		if (attr != NULL) {
			gchar* _tmp7_ = NULL;
			_tmp7_ = vala_attribute_get_string (attr, "cname");
			_g_free0 (self->priv->cname);
			self->priv->cname = _tmp7_;
		}
		if (self->priv->cname == NULL) {
			gchar* _tmp8_ = NULL;
			_tmp8_ = vala_class_get_default_cname (self);
			_g_free0 (self->priv->cname);
			self->priv->cname = _tmp8_;
		}
		_vala_code_node_unref0 (attr);
	}
	_tmp9_ = g_strdup (self->priv->cname);
	result = _tmp9_;
	return result;
}


/**
 * Returns the default name of this class as it is used in C code.
 *
 * @return the name to be used in C code by default
 */
gchar* vala_class_get_default_cname (ValaClass* self) {
	gchar* result = NULL;
	ValaSymbol* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp1_ = vala_symbol_get_cprefix (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) self);
	_tmp4_ = g_strdup_printf ("%s%s", _tmp2_, _tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp2_);
	result = _tmp5_;
	return result;
}


/**
 * Sets the name of this class as it is used in C code.
 *
 * @param cname the name to be used in C code
 */
void vala_class_set_cname (ValaClass* self, const gchar* cname) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cname != NULL);
	_tmp0_ = g_strdup (cname);
	_g_free0 (self->priv->cname);
	self->priv->cname = _tmp0_;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_ = NULL;
	gchar* end;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	if (end == NULL) {
		result = maxlen;
		return result;
	} else {
		result = (glong) (end - str);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp1_;
		_tmp1_ = string_strnlen ((gchar*) self, offset + len);
		string_length = _tmp1_;
	} else {
		gint _tmp2_;
		_tmp2_ = strlen (self);
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}


static gchar* vala_class_get_lower_case_csuffix (ValaClass* self) {
	gchar* result = NULL;
	gchar* _tmp18_;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->lower_case_csuffix == NULL) {
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gboolean _tmp2_;
		gboolean _tmp12_;
		_tmp0_ = vala_symbol_get_name ((ValaSymbol*) self);
		_tmp1_ = vala_symbol_camel_case_to_lower_case (_tmp0_);
		_g_free0 (self->priv->lower_case_csuffix);
		self->priv->lower_case_csuffix = _tmp1_;
		_tmp2_ = g_str_has_prefix (self->priv->lower_case_csuffix, "type_");
		if (_tmp2_) {
			gint _tmp3_;
			gchar* _tmp4_ = NULL;
			gchar* _tmp5_;
			gchar* _tmp6_;
			_tmp3_ = strlen ("type_");
			_tmp4_ = string_substring (self->priv->lower_case_csuffix, (glong) _tmp3_, (glong) (-1));
			_tmp5_ = _tmp4_;
			_tmp6_ = g_strconcat ("type", _tmp5_, NULL);
			_g_free0 (self->priv->lower_case_csuffix);
			self->priv->lower_case_csuffix = _tmp6_;
			_g_free0 (_tmp5_);
		} else {
			gboolean _tmp7_;
			_tmp7_ = g_str_has_prefix (self->priv->lower_case_csuffix, "is_");
			if (_tmp7_) {
				gint _tmp8_;
				gchar* _tmp9_ = NULL;
				gchar* _tmp10_;
				gchar* _tmp11_;
				_tmp8_ = strlen ("is_");
				_tmp9_ = string_substring (self->priv->lower_case_csuffix, (glong) _tmp8_, (glong) (-1));
				_tmp10_ = _tmp9_;
				_tmp11_ = g_strconcat ("is", _tmp10_, NULL);
				_g_free0 (self->priv->lower_case_csuffix);
				self->priv->lower_case_csuffix = _tmp11_;
				_g_free0 (_tmp10_);
			}
		}
		_tmp12_ = g_str_has_suffix (self->priv->lower_case_csuffix, "_class");
		if (_tmp12_) {
			gint _tmp13_;
			gint _tmp14_;
			gchar* _tmp15_ = NULL;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp13_ = strlen (self->priv->lower_case_csuffix);
			_tmp14_ = strlen ("_class");
			_tmp15_ = string_substring (self->priv->lower_case_csuffix, (glong) 0, (glong) (_tmp13_ - _tmp14_));
			_tmp16_ = _tmp15_;
			_tmp17_ = g_strconcat (_tmp16_, "class", NULL);
			_g_free0 (self->priv->lower_case_csuffix);
			self->priv->lower_case_csuffix = _tmp17_;
			_g_free0 (_tmp16_);
		}
	}
	_tmp18_ = g_strdup (self->priv->lower_case_csuffix);
	result = _tmp18_;
	return result;
}


static gchar* vala_class_real_get_lower_case_cname (ValaSymbol* base, const gchar* infix) {
	ValaClass * self;
	gchar* result = NULL;
	ValaSymbol* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	self = (ValaClass*) base;
	if (infix == NULL) {
		infix = "";
	}
	_tmp0_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp1_ = vala_symbol_get_lower_case_cprefix (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_class_get_lower_case_csuffix (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("%s%s%s", _tmp2_, infix, _tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	result = _tmp6_;
	return result;
}


static gchar* vala_class_real_get_lower_case_cprefix (ValaSymbol* base) {
	ValaClass * self;
	gchar* result = NULL;
	gchar* _tmp3_;
	self = (ValaClass*) base;
	if (self->priv->lower_case_cprefix == NULL) {
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		gchar* _tmp2_ = NULL;
		_tmp0_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) self, NULL);
		_tmp1_ = _tmp0_;
		_tmp2_ = g_strdup_printf ("%s_", _tmp1_);
		_g_free0 (self->priv->lower_case_cprefix);
		self->priv->lower_case_cprefix = _tmp2_;
		_g_free0 (_tmp1_);
	}
	_tmp3_ = g_strdup (self->priv->lower_case_cprefix);
	result = _tmp3_;
	return result;
}


void vala_class_set_lower_case_cprefix (ValaClass* self, const gchar* cprefix) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cprefix != NULL);
	_tmp0_ = g_strdup (cprefix);
	_g_free0 (self->priv->lower_case_cprefix);
	self->priv->lower_case_cprefix = _tmp0_;
}


static gchar* vala_class_real_get_upper_case_cname (ValaTypeSymbol* base, const gchar* infix) {
	ValaClass * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	self = (ValaClass*) base;
	_tmp0_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) self, infix);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_utf8_strup (_tmp1_, (gssize) (-1));
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}


static gboolean vala_class_real_is_reference_type (ValaTypeSymbol* base) {
	ValaClass * self;
	gboolean result = FALSE;
	self = (ValaClass*) base;
	result = TRUE;
	return result;
}


static void vala_class_process_gir_attribute (ValaClass* self, ValaAttribute* a) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (a != NULL);
	_tmp0_ = vala_attribute_has_argument (a, "name");
	if (_tmp0_) {
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		_tmp1_ = vala_attribute_get_string (a, "name");
		_tmp2_ = _tmp1_;
		vala_symbol_set_gir_name ((ValaSymbol*) self, _tmp2_);
		_g_free0 (_tmp2_);
	}
}


static void vala_class_process_ccode_attribute (ValaClass* self, ValaAttribute* a) {
	gboolean _tmp0_;
	gboolean _tmp3_;
	gboolean _tmp5_;
	gboolean _tmp8_;
	gboolean _tmp11_;
	gboolean _tmp14_;
	gboolean _tmp17_;
	gboolean _tmp19_;
	gboolean _tmp21_;
	gboolean _tmp23_;
	gboolean _tmp25_;
	gboolean _tmp27_;
	gboolean _tmp29_;
	gboolean _tmp32_;
	gboolean _tmp34_;
	gboolean _tmp36_;
	gboolean _tmp41_;
	gboolean _tmp44_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (a != NULL);
	_tmp0_ = vala_attribute_has_argument (a, "ref_function");
	if (_tmp0_) {
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		_tmp1_ = vala_attribute_get_string (a, "ref_function");
		_tmp2_ = _tmp1_;
		vala_class_set_ref_function (self, _tmp2_);
		_g_free0 (_tmp2_);
	}
	_tmp3_ = vala_attribute_has_argument (a, "ref_function_void");
	if (_tmp3_) {
		gboolean _tmp4_;
		_tmp4_ = vala_attribute_get_bool (a, "ref_function_void");
		vala_class_set_ref_function_void (self, _tmp4_);
	}
	_tmp5_ = vala_attribute_has_argument (a, "unref_function");
	if (_tmp5_) {
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		_tmp6_ = vala_attribute_get_string (a, "unref_function");
		_tmp7_ = _tmp6_;
		vala_class_set_unref_function (self, _tmp7_);
		_g_free0 (_tmp7_);
	}
	_tmp8_ = vala_attribute_has_argument (a, "ref_sink_function");
	if (_tmp8_) {
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_;
		_tmp9_ = vala_attribute_get_string (a, "ref_sink_function");
		_tmp10_ = _tmp9_;
		vala_class_set_ref_sink_function (self, _tmp10_);
		_g_free0 (_tmp10_);
	}
	_tmp11_ = vala_attribute_has_argument (a, "copy_function");
	if (_tmp11_) {
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_;
		_tmp12_ = vala_attribute_get_string (a, "copy_function");
		_tmp13_ = _tmp12_;
		vala_class_set_dup_function (self, _tmp13_);
		_g_free0 (_tmp13_);
	}
	_tmp14_ = vala_attribute_has_argument (a, "free_function");
	if (_tmp14_) {
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_;
		_tmp15_ = vala_attribute_get_string (a, "free_function");
		_tmp16_ = _tmp15_;
		vala_class_set_free_function (self, _tmp16_);
		_g_free0 (_tmp16_);
	}
	_tmp17_ = vala_attribute_has_argument (a, "free_function_address_of");
	if (_tmp17_) {
		gboolean _tmp18_;
		_tmp18_ = vala_attribute_get_bool (a, "free_function_address_of");
		vala_class_set_free_function_address_of (self, _tmp18_);
	}
	_tmp19_ = vala_attribute_has_argument (a, "type_id");
	if (_tmp19_) {
		gchar* _tmp20_ = NULL;
		_tmp20_ = vala_attribute_get_string (a, "type_id");
		_g_free0 (self->priv->type_id);
		self->priv->type_id = _tmp20_;
	}
	_tmp21_ = vala_attribute_has_argument (a, "marshaller_type_name");
	if (_tmp21_) {
		gchar* _tmp22_ = NULL;
		_tmp22_ = vala_attribute_get_string (a, "marshaller_type_name");
		_g_free0 (self->priv->marshaller_type_name);
		self->priv->marshaller_type_name = _tmp22_;
	}
	_tmp23_ = vala_attribute_has_argument (a, "get_value_function");
	if (_tmp23_) {
		gchar* _tmp24_ = NULL;
		_tmp24_ = vala_attribute_get_string (a, "get_value_function");
		_g_free0 (self->priv->get_value_function);
		self->priv->get_value_function = _tmp24_;
	}
	_tmp25_ = vala_attribute_has_argument (a, "set_value_function");
	if (_tmp25_) {
		gchar* _tmp26_ = NULL;
		_tmp26_ = vala_attribute_get_string (a, "set_value_function");
		_g_free0 (self->priv->set_value_function);
		self->priv->set_value_function = _tmp26_;
	}
	_tmp27_ = vala_attribute_has_argument (a, "take_value_function");
	if (_tmp27_) {
		gchar* _tmp28_ = NULL;
		_tmp28_ = vala_attribute_get_string (a, "take_value_function");
		_g_free0 (self->priv->take_value_function);
		self->priv->take_value_function = _tmp28_;
	}
	_tmp29_ = vala_attribute_has_argument (a, "const_cname");
	if (_tmp29_) {
		gchar* _tmp30_ = NULL;
		gchar* _tmp31_;
		_tmp30_ = vala_attribute_get_string (a, "const_cname");
		_tmp31_ = _tmp30_;
		vala_class_set_const_cname (self, _tmp31_);
		_g_free0 (_tmp31_);
	}
	_tmp32_ = vala_attribute_has_argument (a, "cprefix");
	if (_tmp32_) {
		gchar* _tmp33_ = NULL;
		_tmp33_ = vala_attribute_get_string (a, "cprefix");
		_g_free0 (self->priv->lower_case_cprefix);
		self->priv->lower_case_cprefix = _tmp33_;
	}
	_tmp34_ = vala_attribute_has_argument (a, "lower_case_csuffix");
	if (_tmp34_) {
		gchar* _tmp35_ = NULL;
		_tmp35_ = vala_attribute_get_string (a, "lower_case_csuffix");
		_g_free0 (self->priv->lower_case_csuffix);
		self->priv->lower_case_csuffix = _tmp35_;
	}
	_tmp36_ = vala_attribute_has_argument (a, "cheader_filename");
	if (_tmp36_) {
		gchar* _tmp37_ = NULL;
		gchar* val;
		gchar** _tmp38_;
		gchar** _tmp39_ = NULL;
		_tmp37_ = vala_attribute_get_string (a, "cheader_filename");
		val = _tmp37_;
		_tmp39_ = _tmp38_ = g_strsplit (val, ",", 0);
		{
			gchar** filename_collection = NULL;
			gint filename_collection_length1 = 0;
			gint _filename_collection_size_ = 0;
			gint filename_it;
			filename_collection = _tmp39_;
			filename_collection_length1 = _vala_array_length (_tmp38_);
			for (filename_it = 0; filename_it < _vala_array_length (_tmp38_); filename_it = filename_it + 1) {
				gchar* _tmp40_;
				gchar* filename = NULL;
				_tmp40_ = g_strdup (filename_collection[filename_it]);
				filename = _tmp40_;
				{
					vala_symbol_add_cheader_filename ((ValaSymbol*) self, filename);
					_g_free0 (filename);
				}
			}
			filename_collection = (_vala_array_free (filename_collection, filename_collection_length1, (GDestroyNotify) g_free), NULL);
		}
		_g_free0 (val);
	}
	_tmp41_ = vala_attribute_has_argument (a, "type_check_function");
	if (_tmp41_) {
		gchar* _tmp42_ = NULL;
		gchar* _tmp43_;
		_tmp42_ = vala_attribute_get_string (a, "type_check_function");
		_tmp43_ = _tmp42_;
		vala_class_set_type_check_function (self, _tmp43_);
		_g_free0 (_tmp43_);
	}
	_tmp44_ = vala_attribute_has_argument (a, "param_spec_function");
	if (_tmp44_) {
		gchar* _tmp45_ = NULL;
		_tmp45_ = vala_attribute_get_string (a, "param_spec_function");
		_g_free0 (self->priv->param_spec_function);
		self->priv->param_spec_function = _tmp45_;
	}
}


/**
 * Process all associated attributes.
 */
void vala_class_process_attributes (ValaClass* self) {
	g_return_if_fail (self != NULL);
	{
		GList* a_collection = NULL;
		GList* a_it = NULL;
		a_collection = ((ValaCodeNode*) self)->attributes;
		for (a_it = a_collection; a_it != NULL; a_it = a_it->next) {
			ValaAttribute* _tmp0_;
			ValaAttribute* a = NULL;
			_tmp0_ = _vala_code_node_ref0 ((ValaAttribute*) a_it->data);
			a = _tmp0_;
			{
				const gchar* _tmp1_ = NULL;
				_tmp1_ = vala_attribute_get_name (a);
				if (g_strcmp0 (_tmp1_, "CCode") == 0) {
					vala_class_process_ccode_attribute (self, a);
				} else {
					const gchar* _tmp2_ = NULL;
					_tmp2_ = vala_attribute_get_name (a);
					if (g_strcmp0 (_tmp2_, "Compact") == 0) {
						vala_class_set_is_compact (self, TRUE);
					} else {
						const gchar* _tmp3_ = NULL;
						_tmp3_ = vala_attribute_get_name (a);
						if (g_strcmp0 (_tmp3_, "Immutable") == 0) {
							vala_class_set_is_immutable (self, TRUE);
						} else {
							const gchar* _tmp4_ = NULL;
							_tmp4_ = vala_attribute_get_name (a);
							if (g_strcmp0 (_tmp4_, "Deprecated") == 0) {
								vala_symbol_process_deprecated_attribute ((ValaSymbol*) self, a);
							} else {
								const gchar* _tmp5_ = NULL;
								_tmp5_ = vala_attribute_get_name (a);
								if (g_strcmp0 (_tmp5_, "GIR") == 0) {
									vala_class_process_gir_attribute (self, a);
								} else {
									const gchar* _tmp6_ = NULL;
									_tmp6_ = vala_attribute_get_name (a);
									if (g_strcmp0 (_tmp6_, "Experimental") == 0) {
										vala_symbol_process_experimental_attribute ((ValaSymbol*) self, a);
									}
								}
							}
						}
					}
				}
				_vala_code_node_unref0 (a);
			}
		}
	}
}


gchar* vala_class_get_default_type_id (ValaClass* self) {
	gchar* result = NULL;
	gboolean _tmp0_;
	gchar* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_class_get_is_compact (self);
	if (_tmp0_) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("G_TYPE_POINTER");
		result = _tmp1_;
		return result;
	}
	_tmp2_ = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) self, "TYPE_");
	result = _tmp2_;
	return result;
}


static gchar* vala_class_real_get_type_id (ValaTypeSymbol* base) {
	ValaClass * self;
	gchar* result = NULL;
	gchar* _tmp1_;
	self = (ValaClass*) base;
	if (self->priv->type_id == NULL) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = vala_class_get_default_type_id (self);
		_g_free0 (self->priv->type_id);
		self->priv->type_id = _tmp0_;
	}
	_tmp1_ = g_strdup (self->priv->type_id);
	result = _tmp1_;
	return result;
}


void vala_class_set_type_id (ValaClass* self, const gchar* type_id) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type_id != NULL);
	_tmp0_ = g_strdup (type_id);
	_g_free0 (self->priv->type_id);
	self->priv->type_id = _tmp0_;
}


static gchar* vala_class_real_get_marshaller_type_name (ValaTypeSymbol* base) {
	ValaClass * self;
	gchar* result = NULL;
	gchar* _tmp8_;
	self = (ValaClass*) base;
	if (self->priv->marshaller_type_name == NULL) {
		if (self->priv->_base_class != NULL) {
			gchar* _tmp0_ = NULL;
			_tmp0_ = vala_typesymbol_get_marshaller_type_name ((ValaTypeSymbol*) self->priv->_base_class);
			_g_free0 (self->priv->marshaller_type_name);
			self->priv->marshaller_type_name = _tmp0_;
		} else {
			gboolean _tmp1_;
			_tmp1_ = vala_class_get_is_compact (self);
			if (!_tmp1_) {
				gchar* _tmp2_ = NULL;
				_tmp2_ = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) self, NULL);
				_g_free0 (self->priv->marshaller_type_name);
				self->priv->marshaller_type_name = _tmp2_;
			} else {
				gchar* _tmp3_ = NULL;
				gchar* _tmp4_;
				gboolean _tmp5_;
				_tmp3_ = vala_typesymbol_get_type_id ((ValaTypeSymbol*) self);
				_tmp4_ = _tmp3_;
				_tmp5_ = g_strcmp0 (_tmp4_, "G_TYPE_POINTER") == 0;
				_g_free0 (_tmp4_);
				if (_tmp5_) {
					gchar* _tmp6_;
					_tmp6_ = g_strdup ("POINTER");
					_g_free0 (self->priv->marshaller_type_name);
					self->priv->marshaller_type_name = _tmp6_;
				} else {
					gchar* _tmp7_;
					_tmp7_ = g_strdup ("BOXED");
					_g_free0 (self->priv->marshaller_type_name);
					self->priv->marshaller_type_name = _tmp7_;
				}
			}
		}
	}
	_tmp8_ = g_strdup (self->priv->marshaller_type_name);
	result = _tmp8_;
	return result;
}


static gchar* vala_class_real_get_param_spec_function (ValaTypeSymbol* base) {
	ValaClass * self;
	gchar* result = NULL;
	gchar* _tmp1_;
	self = (ValaClass*) base;
	if (self->priv->param_spec_function == NULL) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = vala_class_get_default_param_spec_function (self);
		_g_free0 (self->priv->param_spec_function);
		self->priv->param_spec_function = _tmp0_;
	}
	_tmp1_ = g_strdup (self->priv->param_spec_function);
	result = _tmp1_;
	return result;
}


gchar* vala_class_get_default_param_spec_function (ValaClass* self) {
	gchar* result = NULL;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_class_is_fundamental (self);
	if (_tmp0_) {
		gchar* _tmp1_ = NULL;
		_tmp1_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) self, "param_spec_");
		result = _tmp1_;
		return result;
	} else {
		if (self->priv->_base_class != NULL) {
			gchar* _tmp2_ = NULL;
			_tmp2_ = vala_typesymbol_get_param_spec_function ((ValaTypeSymbol*) self->priv->_base_class);
			result = _tmp2_;
			return result;
		} else {
			gchar* _tmp3_ = NULL;
			gchar* _tmp4_;
			gboolean _tmp5_;
			_tmp3_ = vala_typesymbol_get_type_id ((ValaTypeSymbol*) self);
			_tmp4_ = _tmp3_;
			_tmp5_ = g_strcmp0 (_tmp4_, "G_TYPE_POINTER") == 0;
			_g_free0 (_tmp4_);
			if (_tmp5_) {
				gchar* _tmp6_;
				_tmp6_ = g_strdup ("g_param_spec_pointer");
				result = _tmp6_;
				return result;
			} else {
				gchar* _tmp7_;
				_tmp7_ = g_strdup ("g_param_spec_boxed");
				result = _tmp7_;
				return result;
			}
		}
	}
}


static gchar* vala_class_real_get_get_value_function (ValaTypeSymbol* base) {
	ValaClass * self;
	gchar* result = NULL;
	gchar* _tmp8_;
	self = (ValaClass*) base;
	if (self->priv->get_value_function == NULL) {
		gboolean _tmp0_;
		_tmp0_ = vala_class_is_fundamental (self);
		if (_tmp0_) {
			gchar* _tmp1_ = NULL;
			_tmp1_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) self, "value_get_");
			_g_free0 (self->priv->get_value_function);
			self->priv->get_value_function = _tmp1_;
		} else {
			if (self->priv->_base_class != NULL) {
				gchar* _tmp2_ = NULL;
				_tmp2_ = vala_typesymbol_get_get_value_function ((ValaTypeSymbol*) self->priv->_base_class);
				_g_free0 (self->priv->get_value_function);
				self->priv->get_value_function = _tmp2_;
			} else {
				gchar* _tmp3_ = NULL;
				gchar* _tmp4_;
				gboolean _tmp5_;
				_tmp3_ = vala_typesymbol_get_type_id ((ValaTypeSymbol*) self);
				_tmp4_ = _tmp3_;
				_tmp5_ = g_strcmp0 (_tmp4_, "G_TYPE_POINTER") == 0;
				_g_free0 (_tmp4_);
				if (_tmp5_) {
					gchar* _tmp6_;
					_tmp6_ = g_strdup ("g_value_get_pointer");
					_g_free0 (self->priv->get_value_function);
					self->priv->get_value_function = _tmp6_;
				} else {
					gchar* _tmp7_;
					_tmp7_ = g_strdup ("g_value_get_boxed");
					_g_free0 (self->priv->get_value_function);
					self->priv->get_value_function = _tmp7_;
				}
			}
		}
	}
	_tmp8_ = g_strdup (self->priv->get_value_function);
	result = _tmp8_;
	return result;
}


static gchar* vala_class_real_get_set_value_function (ValaTypeSymbol* base) {
	ValaClass * self;
	gchar* result = NULL;
	gchar* _tmp8_;
	self = (ValaClass*) base;
	if (self->priv->set_value_function == NULL) {
		gboolean _tmp0_;
		_tmp0_ = vala_class_is_fundamental (self);
		if (_tmp0_) {
			gchar* _tmp1_ = NULL;
			_tmp1_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) self, "value_set_");
			_g_free0 (self->priv->set_value_function);
			self->priv->set_value_function = _tmp1_;
		} else {
			if (self->priv->_base_class != NULL) {
				gchar* _tmp2_ = NULL;
				_tmp2_ = vala_typesymbol_get_set_value_function ((ValaTypeSymbol*) self->priv->_base_class);
				_g_free0 (self->priv->set_value_function);
				self->priv->set_value_function = _tmp2_;
			} else {
				gchar* _tmp3_ = NULL;
				gchar* _tmp4_;
				gboolean _tmp5_;
				_tmp3_ = vala_typesymbol_get_type_id ((ValaTypeSymbol*) self);
				_tmp4_ = _tmp3_;
				_tmp5_ = g_strcmp0 (_tmp4_, "G_TYPE_POINTER") == 0;
				_g_free0 (_tmp4_);
				if (_tmp5_) {
					gchar* _tmp6_;
					_tmp6_ = g_strdup ("g_value_set_pointer");
					_g_free0 (self->priv->set_value_function);
					self->priv->set_value_function = _tmp6_;
				} else {
					gchar* _tmp7_;
					_tmp7_ = g_strdup ("g_value_set_boxed");
					_g_free0 (self->priv->set_value_function);
					self->priv->set_value_function = _tmp7_;
				}
			}
		}
	}
	_tmp8_ = g_strdup (self->priv->set_value_function);
	result = _tmp8_;
	return result;
}


static gchar* vala_class_real_get_take_value_function (ValaTypeSymbol* base) {
	ValaClass * self;
	gchar* result = NULL;
	gchar* _tmp8_;
	self = (ValaClass*) base;
	if (self->priv->take_value_function == NULL) {
		gboolean _tmp0_;
		_tmp0_ = vala_class_is_fundamental (self);
		if (_tmp0_) {
			gchar* _tmp1_ = NULL;
			_tmp1_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) self, "value_take_");
			_g_free0 (self->priv->take_value_function);
			self->priv->take_value_function = _tmp1_;
		} else {
			if (self->priv->_base_class != NULL) {
				gchar* _tmp2_ = NULL;
				_tmp2_ = vala_typesymbol_get_take_value_function ((ValaTypeSymbol*) self->priv->_base_class);
				_g_free0 (self->priv->take_value_function);
				self->priv->take_value_function = _tmp2_;
			} else {
				gchar* _tmp3_ = NULL;
				gchar* _tmp4_;
				gboolean _tmp5_;
				_tmp3_ = vala_typesymbol_get_type_id ((ValaTypeSymbol*) self);
				_tmp4_ = _tmp3_;
				_tmp5_ = g_strcmp0 (_tmp4_, "G_TYPE_POINTER") == 0;
				_g_free0 (_tmp4_);
				if (_tmp5_) {
					gchar* _tmp6_;
					_tmp6_ = g_strdup ("g_value_set_pointer");
					_g_free0 (self->priv->take_value_function);
					self->priv->take_value_function = _tmp6_;
				} else {
					gchar* _tmp7_;
					_tmp7_ = g_strdup ("g_value_take_boxed");
					_g_free0 (self->priv->take_value_function);
					self->priv->take_value_function = _tmp7_;
				}
			}
		}
	}
	_tmp8_ = g_strdup (self->priv->take_value_function);
	result = _tmp8_;
	return result;
}


static gboolean vala_class_real_is_reference_counting (ValaTypeSymbol* base) {
	ValaClass * self;
	gboolean result = FALSE;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gboolean _tmp2_;
	self = (ValaClass*) base;
	_tmp0_ = vala_typesymbol_get_ref_function ((ValaTypeSymbol*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ != NULL;
	_g_free0 (_tmp1_);
	result = _tmp2_;
	return result;
}


gboolean vala_class_is_fundamental (ValaClass* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = vala_class_get_is_compact (self);
	if (!_tmp1_) {
		_tmp0_ = self->priv->_base_class == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp2_ = FALSE;
		ValaCodeContext* _tmp3_ = NULL;
		ValaCodeContext* _tmp4_;
		ValaProfile _tmp5_;
		gboolean _tmp6_;
		_tmp3_ = vala_code_context_get ();
		_tmp4_ = _tmp3_;
		_tmp5_ = vala_code_context_get_profile (_tmp4_);
		_tmp6_ = _tmp5_ == VALA_PROFILE_DOVA;
		_vala_code_context_unref0 (_tmp4_);
		if (_tmp6_) {
			_tmp2_ = self->priv->_base_class->priv->_base_class == NULL;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			result = TRUE;
			return result;
		}
	}
	result = FALSE;
	return result;
}


static gchar* vala_class_real_get_ref_function (ValaTypeSymbol* base) {
	ValaClass * self;
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp5_ = FALSE;
	self = (ValaClass*) base;
	if (self->priv->ref_function == NULL) {
		gboolean _tmp1_;
		_tmp1_ = vala_class_is_fundamental (self);
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strconcat (_tmp3_, "ref", NULL);
		_g_free0 (self->priv->ref_function);
		self->priv->ref_function = _tmp4_;
		_g_free0 (_tmp3_);
	}
	if (self->priv->ref_function == NULL) {
		_tmp5_ = self->priv->_base_class != NULL;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		gchar* _tmp6_ = NULL;
		_tmp6_ = vala_typesymbol_get_ref_function ((ValaTypeSymbol*) self->priv->_base_class);
		result = _tmp6_;
		return result;
	} else {
		gchar* _tmp7_;
		_tmp7_ = g_strdup (self->priv->ref_function);
		result = _tmp7_;
		return result;
	}
}


void vala_class_set_ref_function (ValaClass* self, const gchar* name) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (name);
	_g_free0 (self->priv->ref_function);
	self->priv->ref_function = _tmp0_;
}


static gchar* vala_class_real_get_unref_function (ValaTypeSymbol* base) {
	ValaClass * self;
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp5_ = FALSE;
	self = (ValaClass*) base;
	if (self->priv->unref_function == NULL) {
		gboolean _tmp1_;
		_tmp1_ = vala_class_is_fundamental (self);
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strconcat (_tmp3_, "unref", NULL);
		_g_free0 (self->priv->unref_function);
		self->priv->unref_function = _tmp4_;
		_g_free0 (_tmp3_);
	}
	if (self->priv->unref_function == NULL) {
		_tmp5_ = self->priv->_base_class != NULL;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		gchar* _tmp6_ = NULL;
		_tmp6_ = vala_typesymbol_get_unref_function ((ValaTypeSymbol*) self->priv->_base_class);
		result = _tmp6_;
		return result;
	} else {
		gchar* _tmp7_;
		_tmp7_ = g_strdup (self->priv->unref_function);
		result = _tmp7_;
		return result;
	}
}


void vala_class_set_unref_function (ValaClass* self, const gchar* name) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (name);
	_g_free0 (self->priv->unref_function);
	self->priv->unref_function = _tmp0_;
}


static gchar* vala_class_real_get_ref_sink_function (ValaTypeSymbol* base) {
	ValaClass * self;
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	self = (ValaClass*) base;
	if (self->priv->ref_sink_function == NULL) {
		_tmp0_ = self->priv->_base_class != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* _tmp1_ = NULL;
		_tmp1_ = vala_typesymbol_get_ref_sink_function ((ValaTypeSymbol*) self->priv->_base_class);
		result = _tmp1_;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self->priv->ref_sink_function);
		result = _tmp2_;
		return result;
	}
}


void vala_class_set_ref_sink_function (ValaClass* self, const gchar* name) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (name);
	_g_free0 (self->priv->ref_sink_function);
	self->priv->ref_sink_function = _tmp0_;
}


static gchar* vala_class_real_get_dup_function (ValaTypeSymbol* base) {
	ValaClass * self;
	gchar* result = NULL;
	gchar* _tmp0_;
	self = (ValaClass*) base;
	_tmp0_ = g_strdup (self->priv->copy_function);
	result = _tmp0_;
	return result;
}


void vala_class_set_dup_function (ValaClass* self, const gchar* name) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (name);
	_g_free0 (self->priv->copy_function);
	self->priv->copy_function = _tmp0_;
}


gchar* vala_class_get_default_free_function (ValaClass* self) {
	gchar* result = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->_base_class != NULL) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = vala_typesymbol_get_free_function ((ValaTypeSymbol*) self->priv->_base_class);
		result = _tmp0_;
		return result;
	}
	_tmp1_ = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, "free", NULL);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	result = _tmp4_;
	return result;
}


static gchar* vala_class_real_get_free_function (ValaTypeSymbol* base) {
	ValaClass * self;
	gchar* result = NULL;
	gchar* _tmp1_;
	self = (ValaClass*) base;
	if (self->priv->free_function == NULL) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = vala_class_get_default_free_function (self);
		_g_free0 (self->priv->free_function);
		self->priv->free_function = _tmp0_;
	}
	_tmp1_ = g_strdup (self->priv->free_function);
	result = _tmp1_;
	return result;
}


void vala_class_set_free_function (ValaClass* self, const gchar* name) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = g_strdup (name);
	_g_free0 (self->priv->free_function);
	self->priv->free_function = _tmp0_;
}


static gboolean vala_class_real_is_subtype_of (ValaTypeSymbol* base, ValaTypeSymbol* t) {
	ValaClass * self;
	gboolean result = FALSE;
	self = (ValaClass*) base;
	g_return_val_if_fail (t != NULL, FALSE);
	if (VALA_TYPESYMBOL (self) == t) {
		result = TRUE;
		return result;
	}
	{
		ValaList* _tmp0_;
		ValaList* _base_type_list;
		gint _tmp1_;
		gint _base_type_size;
		gint _base_type_index;
		_tmp0_ = _vala_iterable_ref0 (self->priv->base_types);
		_base_type_list = _tmp0_;
		_tmp1_ = vala_collection_get_size ((ValaCollection*) _base_type_list);
		_base_type_size = _tmp1_;
		_base_type_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			ValaDataType* base_type;
			gboolean _tmp3_ = FALSE;
			ValaTypeSymbol* _tmp4_ = NULL;
			_base_type_index = _base_type_index + 1;
			if (!(_base_type_index < _base_type_size)) {
				break;
			}
			_tmp2_ = vala_list_get (_base_type_list, _base_type_index);
			base_type = (ValaDataType*) _tmp2_;
			_tmp4_ = vala_data_type_get_data_type (base_type);
			if (_tmp4_ != NULL) {
				ValaTypeSymbol* _tmp5_ = NULL;
				gboolean _tmp6_;
				_tmp5_ = vala_data_type_get_data_type (base_type);
				_tmp6_ = vala_typesymbol_is_subtype_of (_tmp5_, t);
				_tmp3_ = _tmp6_;
			} else {
				_tmp3_ = FALSE;
			}
			if (_tmp3_) {
				result = TRUE;
				_vala_code_node_unref0 (base_type);
				_vala_iterable_unref0 (_base_type_list);
				return result;
			}
			_vala_code_node_unref0 (base_type);
		}
		_vala_iterable_unref0 (_base_type_list);
	}
	result = FALSE;
	return result;
}


static void vala_class_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type) {
	ValaClass * self;
	self = (ValaClass*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp1_;
				gpointer _tmp2_ = NULL;
				ValaDataType* _tmp3_;
				gboolean _tmp4_;
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				_tmp1_ = vala_collection_get_size ((ValaCollection*) self->priv->base_types);
				if (!(i < _tmp1_)) {
					break;
				}
				_tmp2_ = vala_list_get (self->priv->base_types, i);
				_tmp3_ = (ValaDataType*) _tmp2_;
				_tmp4_ = _tmp3_ == old_type;
				_vala_code_node_unref0 (_tmp3_);
				if (_tmp4_) {
					vala_list_set (self->priv->base_types, i, new_type);
					return;
				}
			}
		}
	}
}


static void vala_class_get_all_prerequisites (ValaClass* self, ValaInterface* iface, ValaList* list) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (iface != NULL);
	g_return_if_fail (list != NULL);
	{
		ValaList* _tmp0_ = NULL;
		ValaList* _prereq_list;
		gint _tmp1_;
		gint _prereq_size;
		gint _prereq_index;
		_tmp0_ = vala_interface_get_prerequisites (iface);
		_prereq_list = _tmp0_;
		_tmp1_ = vala_collection_get_size ((ValaCollection*) _prereq_list);
		_prereq_size = _tmp1_;
		_prereq_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			ValaDataType* prereq;
			ValaTypeSymbol* _tmp3_ = NULL;
			ValaTypeSymbol* _tmp4_;
			ValaTypeSymbol* type;
			_prereq_index = _prereq_index + 1;
			if (!(_prereq_index < _prereq_size)) {
				break;
			}
			_tmp2_ = vala_list_get (_prereq_list, _prereq_index);
			prereq = (ValaDataType*) _tmp2_;
			_tmp3_ = vala_data_type_get_data_type (prereq);
			_tmp4_ = _vala_code_node_ref0 (_tmp3_);
			type = _tmp4_;
			if (type == NULL) {
				_vala_code_node_unref0 (type);
				_vala_code_node_unref0 (prereq);
				continue;
			}
			vala_collection_add ((ValaCollection*) list, type);
			if (VALA_IS_INTERFACE (type)) {
				vala_class_get_all_prerequisites (self, VALA_INTERFACE (type), list);
			}
			_vala_code_node_unref0 (type);
			_vala_code_node_unref0 (prereq);
		}
		_vala_iterable_unref0 (_prereq_list);
	}
}


static gboolean vala_class_class_is_a (ValaClass* self, ValaClass* cl, ValaTypeSymbol* t) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (cl != NULL, FALSE);
	g_return_val_if_fail (t != NULL, FALSE);
	if (VALA_TYPESYMBOL (cl) == t) {
		result = TRUE;
		return result;
	}
	{
		ValaList* _tmp0_ = NULL;
		ValaList* _base_type_list;
		gint _tmp1_;
		gint _base_type_size;
		gint _base_type_index;
		_tmp0_ = vala_class_get_base_types (cl);
		_base_type_list = _tmp0_;
		_tmp1_ = vala_collection_get_size ((ValaCollection*) _base_type_list);
		_base_type_size = _tmp1_;
		_base_type_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			ValaDataType* base_type;
			ValaTypeSymbol* _tmp3_ = NULL;
			_base_type_index = _base_type_index + 1;
			if (!(_base_type_index < _base_type_size)) {
				break;
			}
			_tmp2_ = vala_list_get (_base_type_list, _base_type_index);
			base_type = (ValaDataType*) _tmp2_;
			_tmp3_ = vala_data_type_get_data_type (base_type);
			if (VALA_IS_CLASS (_tmp3_)) {
				ValaTypeSymbol* _tmp4_ = NULL;
				gboolean _tmp5_;
				_tmp4_ = vala_data_type_get_data_type (base_type);
				_tmp5_ = vala_class_class_is_a (self, VALA_CLASS (_tmp4_), t);
				if (_tmp5_) {
					result = TRUE;
					_vala_code_node_unref0 (base_type);
					_vala_iterable_unref0 (_base_type_list);
					return result;
				}
			} else {
				ValaTypeSymbol* _tmp6_ = NULL;
				_tmp6_ = vala_data_type_get_data_type (base_type);
				if (_tmp6_ == t) {
					result = TRUE;
					_vala_code_node_unref0 (base_type);
					_vala_iterable_unref0 (_base_type_list);
					return result;
				}
			}
			_vala_code_node_unref0 (base_type);
		}
		_vala_iterable_unref0 (_base_type_list);
	}
	result = FALSE;
	return result;
}


static gpointer _vala_source_file_ref0 (gpointer self) {
	return self ? vala_source_file_ref (self) : NULL;
}


static gboolean vala_class_real_check (ValaCodeNode* base, ValaCodeContext* context) {
	ValaClass * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	ValaSemanticAnalyzer* _tmp2_ = NULL;
	ValaSourceFile* _tmp3_ = NULL;
	ValaSourceFile* _tmp4_;
	ValaSourceFile* old_source_file;
	ValaSemanticAnalyzer* _tmp5_ = NULL;
	ValaSymbol* _tmp6_ = NULL;
	ValaSymbol* _tmp7_;
	ValaSymbol* old_symbol;
	ValaSourceReference* _tmp8_ = NULL;
	ValaSemanticAnalyzer* _tmp12_ = NULL;
	ValaDestructor* _tmp68_ = NULL;
	gboolean _tmp79_;
	ValaArrayList* _tmp98_ = NULL;
	ValaList* prerequisites;
	ValaArrayList* _tmp104_ = NULL;
	ValaList* missing_prereqs;
	gint _tmp111_;
	ValaSourceFileType _tmp123_;
	ValaSemanticAnalyzer* _tmp207_ = NULL;
	ValaSemanticAnalyzer* _tmp208_ = NULL;
	gboolean _tmp209_;
	self = (ValaClass*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	if (_tmp0_) {
		gboolean _tmp1_;
		_tmp1_ = vala_code_node_get_error ((ValaCodeNode*) self);
		result = !_tmp1_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	vala_class_process_attributes (self);
	_tmp2_ = vala_code_context_get_analyzer (context);
	_tmp3_ = vala_semantic_analyzer_get_current_source_file (_tmp2_);
	_tmp4_ = _vala_source_file_ref0 (_tmp3_);
	old_source_file = _tmp4_;
	_tmp5_ = vala_code_context_get_analyzer (context);
	_tmp6_ = vala_semantic_analyzer_get_current_symbol (_tmp5_);
	_tmp7_ = _vala_code_node_ref0 (_tmp6_);
	old_symbol = _tmp7_;
	_tmp8_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	if (_tmp8_ != NULL) {
		ValaSemanticAnalyzer* _tmp9_ = NULL;
		ValaSourceReference* _tmp10_ = NULL;
		ValaSourceFile* _tmp11_ = NULL;
		_tmp9_ = vala_code_context_get_analyzer (context);
		_tmp10_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp11_ = vala_source_reference_get_file (_tmp10_);
		vala_semantic_analyzer_set_current_source_file (_tmp9_, _tmp11_);
	}
	_tmp12_ = vala_code_context_get_analyzer (context);
	vala_semantic_analyzer_set_current_symbol (_tmp12_, (ValaSymbol*) self);
	{
		ValaList* _tmp13_ = NULL;
		ValaList* _base_type_reference_list;
		gint _tmp14_;
		gint _base_type_reference_size;
		gint _base_type_reference_index;
		_tmp13_ = vala_class_get_base_types (self);
		_base_type_reference_list = _tmp13_;
		_tmp14_ = vala_collection_get_size ((ValaCollection*) _base_type_reference_list);
		_base_type_reference_size = _tmp14_;
		_base_type_reference_index = -1;
		while (TRUE) {
			gpointer _tmp15_ = NULL;
			ValaDataType* base_type_reference;
			gboolean _tmp16_;
			ValaSemanticAnalyzer* _tmp24_ = NULL;
			gboolean _tmp25_;
			ValaList* _tmp33_ = NULL;
			ValaList* _tmp34_;
			gint _tmp35_;
			gint _tmp36_;
			gint n_type_args;
			ValaTypeSymbol* _tmp37_ = NULL;
			ValaList* _tmp38_ = NULL;
			ValaList* _tmp39_;
			gint _tmp40_;
			gint _tmp41_;
			gint n_type_params;
			_base_type_reference_index = _base_type_reference_index + 1;
			if (!(_base_type_reference_index < _base_type_reference_size)) {
				break;
			}
			_tmp15_ = vala_list_get (_base_type_reference_list, _base_type_reference_index);
			base_type_reference = (ValaDataType*) _tmp15_;
			_tmp16_ = vala_code_node_check ((ValaCodeNode*) base_type_reference, context);
			if (!_tmp16_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_iterable_unref0 (_base_type_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			if (!VALA_IS_OBJECT_TYPE (base_type_reference)) {
				ValaSourceReference* _tmp17_ = NULL;
				gchar* _tmp18_ = NULL;
				gchar* _tmp19_;
				gchar* _tmp20_ = NULL;
				gchar* _tmp21_;
				gchar* _tmp22_ = NULL;
				gchar* _tmp23_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp17_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp18_ = vala_code_node_to_string ((ValaCodeNode*) base_type_reference);
				_tmp19_ = _tmp18_;
				_tmp20_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp21_ = _tmp20_;
				_tmp22_ = g_strdup_printf ("base type `%s` of class `%s` is not an object type", _tmp19_, _tmp21_);
				_tmp23_ = _tmp22_;
				vala_report_error (_tmp17_, _tmp23_);
				_g_free0 (_tmp23_);
				_g_free0 (_tmp21_);
				_g_free0 (_tmp19_);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_iterable_unref0 (_base_type_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp24_ = vala_code_context_get_analyzer (context);
			_tmp25_ = vala_semantic_analyzer_is_type_accessible (_tmp24_, (ValaSymbol*) self, base_type_reference);
			if (!_tmp25_) {
				ValaSourceReference* _tmp26_ = NULL;
				gchar* _tmp27_ = NULL;
				gchar* _tmp28_;
				gchar* _tmp29_ = NULL;
				gchar* _tmp30_;
				gchar* _tmp31_ = NULL;
				gchar* _tmp32_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp26_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp27_ = vala_code_node_to_string ((ValaCodeNode*) base_type_reference);
				_tmp28_ = _tmp27_;
				_tmp29_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp30_ = _tmp29_;
				_tmp31_ = g_strdup_printf ("base type `%s` is less accessible than class `%s`", _tmp28_, _tmp30_);
				_tmp32_ = _tmp31_;
				vala_report_error (_tmp26_, _tmp32_);
				_g_free0 (_tmp32_);
				_g_free0 (_tmp30_);
				_g_free0 (_tmp28_);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_iterable_unref0 (_base_type_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp33_ = vala_data_type_get_type_arguments (base_type_reference);
			_tmp34_ = _tmp33_;
			_tmp35_ = vala_collection_get_size ((ValaCollection*) _tmp34_);
			_tmp36_ = _tmp35_;
			_vala_iterable_unref0 (_tmp34_);
			n_type_args = _tmp36_;
			_tmp37_ = vala_data_type_get_data_type (base_type_reference);
			_tmp38_ = vala_object_type_symbol_get_type_parameters (VALA_OBJECT_TYPE_SYMBOL (_tmp37_));
			_tmp39_ = _tmp38_;
			_tmp40_ = vala_collection_get_size ((ValaCollection*) _tmp39_);
			_tmp41_ = _tmp40_;
			_vala_iterable_unref0 (_tmp39_);
			n_type_params = _tmp41_;
			if (n_type_args < n_type_params) {
				ValaSourceReference* _tmp42_ = NULL;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp42_ = vala_code_node_get_source_reference ((ValaCodeNode*) base_type_reference);
				vala_report_error (_tmp42_, "too few type arguments");
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_iterable_unref0 (_base_type_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			} else {
				if (n_type_args > n_type_params) {
					ValaSourceReference* _tmp43_ = NULL;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp43_ = vala_code_node_get_source_reference ((ValaCodeNode*) base_type_reference);
					vala_report_error (_tmp43_, "too many type arguments");
					result = FALSE;
					_vala_code_node_unref0 (base_type_reference);
					_vala_iterable_unref0 (_base_type_reference_list);
					_vala_code_node_unref0 (old_symbol);
					_vala_source_file_unref0 (old_source_file);
					return result;
				}
			}
			_vala_code_node_unref0 (base_type_reference);
		}
		_vala_iterable_unref0 (_base_type_reference_list);
	}
	{
		ValaList* _tmp44_;
		ValaList* _type_list;
		gint _tmp45_;
		gint _type_size;
		gint _type_index;
		_tmp44_ = _vala_iterable_ref0 (self->priv->base_types);
		_type_list = _tmp44_;
		_tmp45_ = vala_collection_get_size ((ValaCollection*) _type_list);
		_type_size = _tmp45_;
		_type_index = -1;
		while (TRUE) {
			gpointer _tmp46_ = NULL;
			ValaDataType* type;
			_type_index = _type_index + 1;
			if (!(_type_index < _type_size)) {
				break;
			}
			_tmp46_ = vala_list_get (_type_list, _type_index);
			type = (ValaDataType*) _tmp46_;
			vala_code_node_check ((ValaCodeNode*) type, context);
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	{
		ValaList* _tmp47_ = NULL;
		ValaList* _p_list;
		gint _tmp48_;
		gint _p_size;
		gint _p_index;
		_tmp47_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) self);
		_p_list = _tmp47_;
		_tmp48_ = vala_collection_get_size ((ValaCollection*) _p_list);
		_p_size = _tmp48_;
		_p_index = -1;
		while (TRUE) {
			gpointer _tmp49_ = NULL;
			ValaTypeParameter* p;
			_p_index = _p_index + 1;
			if (!(_p_index < _p_size)) {
				break;
			}
			_tmp49_ = vala_list_get (_p_list, _p_index);
			p = (ValaTypeParameter*) _tmp49_;
			vala_code_node_check ((ValaCodeNode*) p, context);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	{
		ValaList* _tmp50_;
		ValaList* _en_list;
		gint _tmp51_;
		gint _en_size;
		gint _en_index;
		_tmp50_ = _vala_iterable_ref0 (self->priv->enums);
		_en_list = _tmp50_;
		_tmp51_ = vala_collection_get_size ((ValaCollection*) _en_list);
		_en_size = _tmp51_;
		_en_index = -1;
		while (TRUE) {
			gpointer _tmp52_ = NULL;
			ValaEnum* en;
			_en_index = _en_index + 1;
			if (!(_en_index < _en_size)) {
				break;
			}
			_tmp52_ = vala_list_get (_en_list, _en_index);
			en = (ValaEnum*) _tmp52_;
			vala_code_node_check ((ValaCodeNode*) en, context);
			_vala_code_node_unref0 (en);
		}
		_vala_iterable_unref0 (_en_list);
	}
	{
		ValaList* _tmp53_;
		ValaList* _f_list;
		gint _tmp54_;
		gint _f_size;
		gint _f_index;
		_tmp53_ = _vala_iterable_ref0 (self->priv->fields);
		_f_list = _tmp53_;
		_tmp54_ = vala_collection_get_size ((ValaCollection*) _f_list);
		_f_size = _tmp54_;
		_f_index = -1;
		while (TRUE) {
			gpointer _tmp55_ = NULL;
			ValaField* f;
			_f_index = _f_index + 1;
			if (!(_f_index < _f_size)) {
				break;
			}
			_tmp55_ = vala_list_get (_f_list, _f_index);
			f = (ValaField*) _tmp55_;
			vala_code_node_check ((ValaCodeNode*) f, context);
			_vala_code_node_unref0 (f);
		}
		_vala_iterable_unref0 (_f_list);
	}
	{
		ValaList* _tmp56_;
		ValaList* _c_list;
		gint _tmp57_;
		gint _c_size;
		gint _c_index;
		_tmp56_ = _vala_iterable_ref0 (self->priv->constants);
		_c_list = _tmp56_;
		_tmp57_ = vala_collection_get_size ((ValaCollection*) _c_list);
		_c_size = _tmp57_;
		_c_index = -1;
		while (TRUE) {
			gpointer _tmp58_ = NULL;
			ValaConstant* c;
			_c_index = _c_index + 1;
			if (!(_c_index < _c_size)) {
				break;
			}
			_tmp58_ = vala_list_get (_c_list, _c_index);
			c = (ValaConstant*) _tmp58_;
			vala_code_node_check ((ValaCodeNode*) c, context);
			_vala_code_node_unref0 (c);
		}
		_vala_iterable_unref0 (_c_list);
	}
	{
		ValaList* _tmp59_;
		ValaList* _m_list;
		gint _tmp60_;
		gint _m_size;
		gint _m_index;
		_tmp59_ = _vala_iterable_ref0 (self->priv->methods);
		_m_list = _tmp59_;
		_tmp60_ = vala_collection_get_size ((ValaCollection*) _m_list);
		_m_size = _tmp60_;
		_m_index = -1;
		while (TRUE) {
			gpointer _tmp61_ = NULL;
			ValaMethod* m;
			_m_index = _m_index + 1;
			if (!(_m_index < _m_size)) {
				break;
			}
			_tmp61_ = vala_list_get (_m_list, _m_index);
			m = (ValaMethod*) _tmp61_;
			vala_code_node_check ((ValaCodeNode*) m, context);
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	{
		ValaList* _tmp62_;
		ValaList* _prop_list;
		gint _tmp63_;
		gint _prop_size;
		gint _prop_index;
		_tmp62_ = _vala_iterable_ref0 (self->priv->properties);
		_prop_list = _tmp62_;
		_tmp63_ = vala_collection_get_size ((ValaCollection*) _prop_list);
		_prop_size = _tmp63_;
		_prop_index = -1;
		while (TRUE) {
			gpointer _tmp64_ = NULL;
			ValaProperty* prop;
			_prop_index = _prop_index + 1;
			if (!(_prop_index < _prop_size)) {
				break;
			}
			_tmp64_ = vala_list_get (_prop_list, _prop_index);
			prop = (ValaProperty*) _tmp64_;
			vala_code_node_check ((ValaCodeNode*) prop, context);
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	{
		ValaList* _tmp65_;
		ValaList* _sig_list;
		gint _tmp66_;
		gint _sig_size;
		gint _sig_index;
		_tmp65_ = _vala_iterable_ref0 (self->priv->signals);
		_sig_list = _tmp65_;
		_tmp66_ = vala_collection_get_size ((ValaCollection*) _sig_list);
		_sig_size = _tmp66_;
		_sig_index = -1;
		while (TRUE) {
			gpointer _tmp67_ = NULL;
			ValaSignal* sig;
			_sig_index = _sig_index + 1;
			if (!(_sig_index < _sig_size)) {
				break;
			}
			_tmp67_ = vala_list_get (_sig_list, _sig_index);
			sig = (ValaSignal*) _tmp67_;
			vala_code_node_check ((ValaCodeNode*) sig, context);
			_vala_code_node_unref0 (sig);
		}
		_vala_iterable_unref0 (_sig_list);
	}
	if (self->priv->_constructor != NULL) {
		vala_code_node_check ((ValaCodeNode*) self->priv->_constructor, context);
	}
	if (self->priv->_class_constructor != NULL) {
		vala_code_node_check ((ValaCodeNode*) self->priv->_class_constructor, context);
	}
	if (self->priv->_static_constructor != NULL) {
		vala_code_node_check ((ValaCodeNode*) self->priv->_static_constructor, context);
	}
	_tmp68_ = vala_class_get_destructor (self);
	if (_tmp68_ != NULL) {
		ValaDestructor* _tmp69_ = NULL;
		_tmp69_ = vala_class_get_destructor (self);
		vala_code_node_check ((ValaCodeNode*) _tmp69_, context);
	}
	if (self->priv->_static_destructor != NULL) {
		vala_code_node_check ((ValaCodeNode*) self->priv->_static_destructor, context);
	}
	if (self->priv->_class_destructor != NULL) {
		vala_code_node_check ((ValaCodeNode*) self->priv->_class_destructor, context);
	}
	{
		ValaList* _tmp70_;
		ValaList* _cl_list;
		gint _tmp71_;
		gint _cl_size;
		gint _cl_index;
		_tmp70_ = _vala_iterable_ref0 (self->priv->classes);
		_cl_list = _tmp70_;
		_tmp71_ = vala_collection_get_size ((ValaCollection*) _cl_list);
		_cl_size = _tmp71_;
		_cl_index = -1;
		while (TRUE) {
			gpointer _tmp72_ = NULL;
			ValaClass* cl;
			_cl_index = _cl_index + 1;
			if (!(_cl_index < _cl_size)) {
				break;
			}
			_tmp72_ = vala_list_get (_cl_list, _cl_index);
			cl = (ValaClass*) _tmp72_;
			vala_code_node_check ((ValaCodeNode*) cl, context);
			_vala_code_node_unref0 (cl);
		}
		_vala_iterable_unref0 (_cl_list);
	}
	{
		ValaList* _tmp73_;
		ValaList* _st_list;
		gint _tmp74_;
		gint _st_size;
		gint _st_index;
		_tmp73_ = _vala_iterable_ref0 (self->priv->structs);
		_st_list = _tmp73_;
		_tmp74_ = vala_collection_get_size ((ValaCollection*) _st_list);
		_st_size = _tmp74_;
		_st_index = -1;
		while (TRUE) {
			gpointer _tmp75_ = NULL;
			ValaStruct* st;
			_st_index = _st_index + 1;
			if (!(_st_index < _st_size)) {
				break;
			}
			_tmp75_ = vala_list_get (_st_list, _st_index);
			st = (ValaStruct*) _tmp75_;
			vala_code_node_check ((ValaCodeNode*) st, context);
			_vala_code_node_unref0 (st);
		}
		_vala_iterable_unref0 (_st_list);
	}
	{
		ValaList* _tmp76_;
		ValaList* _d_list;
		gint _tmp77_;
		gint _d_size;
		gint _d_index;
		_tmp76_ = _vala_iterable_ref0 (self->priv->delegates);
		_d_list = _tmp76_;
		_tmp77_ = vala_collection_get_size ((ValaCollection*) _d_list);
		_d_size = _tmp77_;
		_d_index = -1;
		while (TRUE) {
			gpointer _tmp78_ = NULL;
			ValaDelegate* d;
			_d_index = _d_index + 1;
			if (!(_d_index < _d_size)) {
				break;
			}
			_tmp78_ = vala_list_get (_d_list, _d_index);
			d = (ValaDelegate*) _tmp78_;
			vala_code_node_check ((ValaCodeNode*) d, context);
			_vala_code_node_unref0 (d);
		}
		_vala_iterable_unref0 (_d_list);
	}
	_tmp79_ = vala_class_get_is_compact (self);
	if (_tmp79_) {
		gboolean _tmp89_ = FALSE;
		gboolean _tmp90_ = FALSE;
		gboolean _tmp91_;
		{
			ValaList* _tmp80_ = NULL;
			ValaList* _base_type_list;
			gint _tmp81_;
			gint _base_type_size;
			gint _base_type_index;
			_tmp80_ = vala_class_get_base_types (self);
			_base_type_list = _tmp80_;
			_tmp81_ = vala_collection_get_size ((ValaCollection*) _base_type_list);
			_base_type_size = _tmp81_;
			_base_type_index = -1;
			while (TRUE) {
				gpointer _tmp82_ = NULL;
				ValaDataType* base_type;
				ValaTypeSymbol* _tmp83_ = NULL;
				_base_type_index = _base_type_index + 1;
				if (!(_base_type_index < _base_type_size)) {
					break;
				}
				_tmp82_ = vala_list_get (_base_type_list, _base_type_index);
				base_type = (ValaDataType*) _tmp82_;
				_tmp83_ = vala_data_type_get_data_type (base_type);
				if (VALA_IS_INTERFACE (_tmp83_)) {
					ValaSourceReference* _tmp84_ = NULL;
					gchar* _tmp85_ = NULL;
					gchar* _tmp86_;
					gchar* _tmp87_ = NULL;
					gchar* _tmp88_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp84_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp85_ = vala_symbol_get_full_name ((ValaSymbol*) self);
					_tmp86_ = _tmp85_;
					_tmp87_ = g_strdup_printf ("compact classes `%s` may not implement interfaces", _tmp86_);
					_tmp88_ = _tmp87_;
					vala_report_error (_tmp84_, _tmp88_);
					_g_free0 (_tmp88_);
					_g_free0 (_tmp86_);
				}
				_vala_code_node_unref0 (base_type);
			}
			_vala_iterable_unref0 (_base_type_list);
		}
		_tmp91_ = vala_symbol_get_external ((ValaSymbol*) self);
		if (!_tmp91_) {
			gboolean _tmp92_;
			_tmp92_ = vala_symbol_get_external_package ((ValaSymbol*) self);
			_tmp90_ = !_tmp92_;
		} else {
			_tmp90_ = FALSE;
		}
		if (_tmp90_) {
			_tmp89_ = self->priv->_base_class != NULL;
		} else {
			_tmp89_ = FALSE;
		}
		if (_tmp89_) {
			{
				ValaList* _tmp93_;
				ValaList* _f_list;
				gint _tmp94_;
				gint _f_size;
				gint _f_index;
				_tmp93_ = _vala_iterable_ref0 (self->priv->fields);
				_f_list = _tmp93_;
				_tmp94_ = vala_collection_get_size ((ValaCollection*) _f_list);
				_f_size = _tmp94_;
				_f_index = -1;
				while (TRUE) {
					gpointer _tmp95_ = NULL;
					ValaField* f;
					ValaMemberBinding _tmp96_;
					_f_index = _f_index + 1;
					if (!(_f_index < _f_size)) {
						break;
					}
					_tmp95_ = vala_list_get (_f_list, _f_index);
					f = (ValaField*) _tmp95_;
					_tmp96_ = vala_field_get_binding (f);
					if (_tmp96_ == VALA_MEMBER_BINDING_INSTANCE) {
						ValaSourceReference* _tmp97_ = NULL;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp97_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						vala_report_error (_tmp97_, "derived compact classes may not have instance fields");
						_vala_code_node_unref0 (f);
						break;
					}
					_vala_code_node_unref0 (f);
				}
				_vala_iterable_unref0 (_f_list);
			}
		}
	}
	_tmp98_ = vala_array_list_new (VALA_TYPE_TYPESYMBOL, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	prerequisites = (ValaList*) _tmp98_;
	{
		ValaList* _tmp99_ = NULL;
		ValaList* _base_type_list;
		gint _tmp100_;
		gint _base_type_size;
		gint _base_type_index;
		_tmp99_ = vala_class_get_base_types (self);
		_base_type_list = _tmp99_;
		_tmp100_ = vala_collection_get_size ((ValaCollection*) _base_type_list);
		_base_type_size = _tmp100_;
		_base_type_index = -1;
		while (TRUE) {
			gpointer _tmp101_ = NULL;
			ValaDataType* base_type;
			ValaTypeSymbol* _tmp102_ = NULL;
			_base_type_index = _base_type_index + 1;
			if (!(_base_type_index < _base_type_size)) {
				break;
			}
			_tmp101_ = vala_list_get (_base_type_list, _base_type_index);
			base_type = (ValaDataType*) _tmp101_;
			_tmp102_ = vala_data_type_get_data_type (base_type);
			if (VALA_IS_INTERFACE (_tmp102_)) {
				ValaTypeSymbol* _tmp103_ = NULL;
				_tmp103_ = vala_data_type_get_data_type (base_type);
				vala_class_get_all_prerequisites (self, VALA_INTERFACE (_tmp103_), prerequisites);
			}
			_vala_code_node_unref0 (base_type);
		}
		_vala_iterable_unref0 (_base_type_list);
	}
	_tmp104_ = vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_direct_equal);
	missing_prereqs = (ValaList*) _tmp104_;
	{
		ValaList* _tmp105_;
		ValaList* _prereq_list;
		gint _tmp106_;
		gint _prereq_size;
		gint _prereq_index;
		_tmp105_ = _vala_iterable_ref0 (prerequisites);
		_prereq_list = _tmp105_;
		_tmp106_ = vala_collection_get_size ((ValaCollection*) _prereq_list);
		_prereq_size = _tmp106_;
		_prereq_index = -1;
		while (TRUE) {
			gpointer _tmp107_ = NULL;
			ValaTypeSymbol* prereq;
			gboolean _tmp108_;
			_prereq_index = _prereq_index + 1;
			if (!(_prereq_index < _prereq_size)) {
				break;
			}
			_tmp107_ = vala_list_get (_prereq_list, _prereq_index);
			prereq = (ValaTypeSymbol*) _tmp107_;
			_tmp108_ = vala_class_class_is_a (self, self, prereq);
			if (!_tmp108_) {
				gchar* _tmp109_ = NULL;
				gchar* _tmp110_;
				_tmp109_ = vala_symbol_get_full_name ((ValaSymbol*) prereq);
				_tmp110_ = _tmp109_;
				vala_list_insert (missing_prereqs, 0, _tmp110_);
				_g_free0 (_tmp110_);
			}
			_vala_code_node_unref0 (prereq);
		}
		_vala_iterable_unref0 (_prereq_list);
	}
	_tmp111_ = vala_collection_get_size ((ValaCollection*) missing_prereqs);
	if (_tmp111_ > 0) {
		gchar* _tmp112_ = NULL;
		gchar* _tmp113_;
		gchar* _tmp114_ = NULL;
		gchar* _tmp115_;
		gchar* error_string;
		gboolean first;
		gchar* _tmp121_;
		ValaSourceReference* _tmp122_ = NULL;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp112_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp113_ = _tmp112_;
		_tmp114_ = g_strdup_printf ("%s: some prerequisites (", _tmp113_);
		_tmp115_ = _tmp114_;
		_g_free0 (_tmp113_);
		error_string = _tmp115_;
		first = TRUE;
		{
			ValaList* _tmp116_;
			ValaList* _s_list;
			gint _tmp117_;
			gint _s_size;
			gint _s_index;
			_tmp116_ = _vala_iterable_ref0 (missing_prereqs);
			_s_list = _tmp116_;
			_tmp117_ = vala_collection_get_size ((ValaCollection*) _s_list);
			_s_size = _tmp117_;
			_s_index = -1;
			while (TRUE) {
				gpointer _tmp118_ = NULL;
				gchar* s;
				_s_index = _s_index + 1;
				if (!(_s_index < _s_size)) {
					break;
				}
				_tmp118_ = vala_list_get (_s_list, _s_index);
				s = (gchar*) _tmp118_;
				if (first) {
					gchar* _tmp119_ = NULL;
					_tmp119_ = g_strdup_printf ("%s`%s'", error_string, s);
					_g_free0 (error_string);
					error_string = _tmp119_;
					first = FALSE;
				} else {
					gchar* _tmp120_ = NULL;
					_tmp120_ = g_strdup_printf ("%s, `%s'", error_string, s);
					_g_free0 (error_string);
					error_string = _tmp120_;
				}
				_g_free0 (s);
			}
			_vala_iterable_unref0 (_s_list);
		}
		_tmp121_ = g_strconcat (error_string, ") are not met", NULL);
		_g_free0 (error_string);
		error_string = _tmp121_;
		_tmp122_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		vala_report_error (_tmp122_, error_string);
		_g_free0 (error_string);
	}
	_tmp123_ = vala_symbol_get_source_type ((ValaSymbol*) self);
	if (_tmp123_ == VALA_SOURCE_FILE_TYPE_SOURCE) {
		{
			ValaList* _tmp124_ = NULL;
			ValaList* _base_type_list;
			gint _tmp125_;
			gint _base_type_size;
			gint _base_type_index;
			_tmp124_ = vala_class_get_base_types (self);
			_base_type_list = _tmp124_;
			_tmp125_ = vala_collection_get_size ((ValaCollection*) _base_type_list);
			_base_type_size = _tmp125_;
			_base_type_index = -1;
			while (TRUE) {
				gpointer _tmp126_ = NULL;
				ValaDataType* base_type;
				ValaTypeSymbol* _tmp127_ = NULL;
				_base_type_index = _base_type_index + 1;
				if (!(_base_type_index < _base_type_size)) {
					break;
				}
				_tmp126_ = vala_list_get (_base_type_list, _base_type_index);
				base_type = (ValaDataType*) _tmp126_;
				_tmp127_ = vala_data_type_get_data_type (base_type);
				if (VALA_IS_INTERFACE (_tmp127_)) {
					ValaTypeSymbol* _tmp128_ = NULL;
					ValaInterface* _tmp129_;
					ValaInterface* iface;
					gboolean _tmp130_ = FALSE;
					_tmp128_ = vala_data_type_get_data_type (base_type);
					_tmp129_ = _vala_code_node_ref0 (VALA_INTERFACE (_tmp128_));
					iface = _tmp129_;
					if (self->priv->_base_class != NULL) {
						gboolean _tmp131_;
						_tmp131_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) self->priv->_base_class, (ValaTypeSymbol*) iface);
						_tmp130_ = _tmp131_;
					} else {
						_tmp130_ = FALSE;
					}
					if (_tmp130_) {
						_vala_code_node_unref0 (iface);
						_vala_code_node_unref0 (base_type);
						break;
					}
					{
						ValaList* _tmp132_ = NULL;
						ValaList* _m_list;
						gint _tmp133_;
						gint _m_size;
						gint _m_index;
						_tmp132_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) iface);
						_m_list = _tmp132_;
						_tmp133_ = vala_collection_get_size ((ValaCollection*) _m_list);
						_m_size = _tmp133_;
						_m_index = -1;
						while (TRUE) {
							gpointer _tmp134_ = NULL;
							ValaMethod* m;
							gboolean _tmp135_;
							_m_index = _m_index + 1;
							if (!(_m_index < _m_size)) {
								break;
							}
							_tmp134_ = vala_list_get (_m_list, _m_index);
							m = (ValaMethod*) _tmp134_;
							_tmp135_ = vala_method_get_is_abstract (m);
							if (_tmp135_) {
								ValaSymbol* sym;
								ValaClass* _tmp136_;
								ValaClass* base_class;
								sym = NULL;
								_tmp136_ = _vala_code_node_ref0 (self);
								base_class = _tmp136_;
								while (TRUE) {
									gboolean _tmp137_ = FALSE;
									ValaScope* _tmp138_ = NULL;
									const gchar* _tmp139_ = NULL;
									ValaSymbol* _tmp140_ = NULL;
									ValaClass* _tmp141_;
									if (base_class != NULL) {
										_tmp137_ = !VALA_IS_METHOD (sym);
									} else {
										_tmp137_ = FALSE;
									}
									if (!_tmp137_) {
										break;
									}
									_tmp138_ = vala_symbol_get_scope ((ValaSymbol*) base_class);
									_tmp139_ = vala_symbol_get_name ((ValaSymbol*) m);
									_tmp140_ = vala_scope_lookup (_tmp138_, _tmp139_);
									_vala_code_node_unref0 (sym);
									sym = _tmp140_;
									_tmp141_ = _vala_code_node_ref0 (base_class->priv->_base_class);
									_vala_code_node_unref0 (base_class);
									base_class = _tmp141_;
								}
								if (VALA_IS_METHOD (sym)) {
									ValaSourceReference* _tmp142_ = NULL;
									ValaSourceReference* _tmp143_ = NULL;
									_tmp142_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									vala_symbol_check_deprecated (sym, _tmp142_);
									_tmp143_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									vala_symbol_check_experimental (sym, _tmp143_);
									vala_symbol_set_used (sym, TRUE);
								} else {
									ValaSourceReference* _tmp144_ = NULL;
									gchar* _tmp145_ = NULL;
									gchar* _tmp146_;
									gchar* _tmp147_ = NULL;
									gchar* _tmp148_;
									gchar* _tmp149_ = NULL;
									gchar* _tmp150_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp144_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp145_ = vala_symbol_get_full_name ((ValaSymbol*) self);
									_tmp146_ = _tmp145_;
									_tmp147_ = vala_symbol_get_full_name ((ValaSymbol*) m);
									_tmp148_ = _tmp147_;
									_tmp149_ = g_strdup_printf ("`%s' does not implement interface method `%s'", _tmp146_, _tmp148_);
									_tmp150_ = _tmp149_;
									vala_report_error (_tmp144_, _tmp150_);
									_g_free0 (_tmp150_);
									_g_free0 (_tmp148_);
									_g_free0 (_tmp146_);
								}
								_vala_code_node_unref0 (base_class);
								_vala_code_node_unref0 (sym);
							}
							_vala_code_node_unref0 (m);
						}
						_vala_iterable_unref0 (_m_list);
					}
					{
						ValaList* _tmp151_ = NULL;
						ValaList* _prop_list;
						gint _tmp152_;
						gint _prop_size;
						gint _prop_index;
						_tmp151_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) iface);
						_prop_list = _tmp151_;
						_tmp152_ = vala_collection_get_size ((ValaCollection*) _prop_list);
						_prop_size = _tmp152_;
						_prop_index = -1;
						while (TRUE) {
							gpointer _tmp153_ = NULL;
							ValaProperty* prop;
							gboolean _tmp154_;
							_prop_index = _prop_index + 1;
							if (!(_prop_index < _prop_size)) {
								break;
							}
							_tmp153_ = vala_list_get (_prop_list, _prop_index);
							prop = (ValaProperty*) _tmp153_;
							_tmp154_ = vala_property_get_is_abstract (prop);
							if (_tmp154_) {
								ValaSymbol* sym;
								ValaClass* _tmp155_;
								ValaClass* base_class;
								sym = NULL;
								_tmp155_ = _vala_code_node_ref0 (self);
								base_class = _tmp155_;
								while (TRUE) {
									gboolean _tmp156_ = FALSE;
									ValaScope* _tmp157_ = NULL;
									const gchar* _tmp158_ = NULL;
									ValaSymbol* _tmp159_ = NULL;
									ValaClass* _tmp160_;
									if (base_class != NULL) {
										_tmp156_ = !VALA_IS_PROPERTY (sym);
									} else {
										_tmp156_ = FALSE;
									}
									if (!_tmp156_) {
										break;
									}
									_tmp157_ = vala_symbol_get_scope ((ValaSymbol*) base_class);
									_tmp158_ = vala_symbol_get_name ((ValaSymbol*) prop);
									_tmp159_ = vala_scope_lookup (_tmp157_, _tmp158_);
									_vala_code_node_unref0 (sym);
									sym = _tmp159_;
									_tmp160_ = _vala_code_node_ref0 (base_class->priv->_base_class);
									_vala_code_node_unref0 (base_class);
									base_class = _tmp160_;
								}
								if (VALA_IS_PROPERTY (sym)) {
									ValaSourceReference* _tmp161_ = NULL;
									ValaSourceReference* _tmp162_ = NULL;
									_tmp161_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									vala_symbol_check_deprecated (sym, _tmp161_);
									_tmp162_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									vala_symbol_check_experimental (sym, _tmp162_);
									vala_symbol_set_used (sym, TRUE);
								} else {
									ValaSourceReference* _tmp163_ = NULL;
									gchar* _tmp164_ = NULL;
									gchar* _tmp165_;
									gchar* _tmp166_ = NULL;
									gchar* _tmp167_;
									gchar* _tmp168_ = NULL;
									gchar* _tmp169_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp163_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp164_ = vala_symbol_get_full_name ((ValaSymbol*) self);
									_tmp165_ = _tmp164_;
									_tmp166_ = vala_symbol_get_full_name ((ValaSymbol*) prop);
									_tmp167_ = _tmp166_;
									_tmp168_ = g_strdup_printf ("`%s' does not implement interface property `%s'", _tmp165_, _tmp167_);
									_tmp169_ = _tmp168_;
									vala_report_error (_tmp163_, _tmp169_);
									_g_free0 (_tmp169_);
									_g_free0 (_tmp167_);
									_g_free0 (_tmp165_);
								}
								_vala_code_node_unref0 (base_class);
								_vala_code_node_unref0 (sym);
							}
							_vala_code_node_unref0 (prop);
						}
						_vala_iterable_unref0 (_prop_list);
					}
					_vala_code_node_unref0 (iface);
				}
				_vala_code_node_unref0 (base_type);
			}
			_vala_iterable_unref0 (_base_type_list);
		}
		if (!self->priv->_is_abstract) {
			ValaClass* _tmp170_;
			ValaClass* base_class;
			_tmp170_ = _vala_code_node_ref0 (self->priv->_base_class);
			base_class = _tmp170_;
			while (TRUE) {
				gboolean _tmp171_ = FALSE;
				ValaClass* _tmp206_;
				if (base_class != NULL) {
					_tmp171_ = base_class->priv->_is_abstract;
				} else {
					_tmp171_ = FALSE;
				}
				if (!_tmp171_) {
					break;
				}
				{
					ValaList* _tmp172_ = NULL;
					ValaList* _base_method_list;
					gint _tmp173_;
					gint _base_method_size;
					gint _base_method_index;
					_tmp172_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) base_class);
					_base_method_list = _tmp172_;
					_tmp173_ = vala_collection_get_size ((ValaCollection*) _base_method_list);
					_base_method_size = _tmp173_;
					_base_method_index = -1;
					while (TRUE) {
						gpointer _tmp174_ = NULL;
						ValaMethod* base_method;
						gboolean _tmp175_;
						_base_method_index = _base_method_index + 1;
						if (!(_base_method_index < _base_method_size)) {
							break;
						}
						_tmp174_ = vala_list_get (_base_method_list, _base_method_index);
						base_method = (ValaMethod*) _tmp174_;
						_tmp175_ = vala_method_get_is_abstract (base_method);
						if (_tmp175_) {
							ValaSemanticAnalyzer* _tmp176_ = NULL;
							const gchar* _tmp177_ = NULL;
							ValaSymbol* _tmp178_ = NULL;
							ValaSymbol* _tmp179_;
							ValaMethod* override_method;
							gboolean _tmp180_ = FALSE;
							_tmp176_ = vala_code_context_get_analyzer (context);
							_tmp177_ = vala_symbol_get_name ((ValaSymbol*) base_method);
							_tmp178_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) self, _tmp177_);
							_tmp179_ = _tmp178_;
							override_method = VALA_IS_METHOD (_tmp179_) ? ((ValaMethod*) _tmp179_) : NULL;
							if (override_method == NULL) {
								_tmp180_ = TRUE;
							} else {
								gboolean _tmp181_;
								_tmp181_ = vala_method_get_overrides (override_method);
								_tmp180_ = !_tmp181_;
							}
							if (_tmp180_) {
								ValaSourceReference* _tmp182_ = NULL;
								gchar* _tmp183_ = NULL;
								gchar* _tmp184_;
								gchar* _tmp185_ = NULL;
								gchar* _tmp186_;
								gchar* _tmp187_ = NULL;
								gchar* _tmp188_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp182_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp183_ = vala_symbol_get_full_name ((ValaSymbol*) self);
								_tmp184_ = _tmp183_;
								_tmp185_ = vala_symbol_get_full_name ((ValaSymbol*) base_method);
								_tmp186_ = _tmp185_;
								_tmp187_ = g_strdup_printf ("`%s' does not implement abstract method `%s'", _tmp184_, _tmp186_);
								_tmp188_ = _tmp187_;
								vala_report_error (_tmp182_, _tmp188_);
								_g_free0 (_tmp188_);
								_g_free0 (_tmp186_);
								_g_free0 (_tmp184_);
							}
							_vala_code_node_unref0 (override_method);
						}
						_vala_code_node_unref0 (base_method);
					}
					_vala_iterable_unref0 (_base_method_list);
				}
				{
					ValaList* _tmp189_ = NULL;
					ValaList* _base_property_list;
					gint _tmp190_;
					gint _base_property_size;
					gint _base_property_index;
					_tmp189_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) base_class);
					_base_property_list = _tmp189_;
					_tmp190_ = vala_collection_get_size ((ValaCollection*) _base_property_list);
					_base_property_size = _tmp190_;
					_base_property_index = -1;
					while (TRUE) {
						gpointer _tmp191_ = NULL;
						ValaProperty* base_property;
						gboolean _tmp192_;
						_base_property_index = _base_property_index + 1;
						if (!(_base_property_index < _base_property_size)) {
							break;
						}
						_tmp191_ = vala_list_get (_base_property_list, _base_property_index);
						base_property = (ValaProperty*) _tmp191_;
						_tmp192_ = vala_property_get_is_abstract (base_property);
						if (_tmp192_) {
							ValaSemanticAnalyzer* _tmp193_ = NULL;
							const gchar* _tmp194_ = NULL;
							ValaSymbol* _tmp195_ = NULL;
							ValaSymbol* _tmp196_;
							ValaProperty* override_property;
							gboolean _tmp197_ = FALSE;
							_tmp193_ = vala_code_context_get_analyzer (context);
							_tmp194_ = vala_symbol_get_name ((ValaSymbol*) base_property);
							_tmp195_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) self, _tmp194_);
							_tmp196_ = _tmp195_;
							override_property = VALA_IS_PROPERTY (_tmp196_) ? ((ValaProperty*) _tmp196_) : NULL;
							if (override_property == NULL) {
								_tmp197_ = TRUE;
							} else {
								gboolean _tmp198_;
								_tmp198_ = vala_property_get_overrides (override_property);
								_tmp197_ = !_tmp198_;
							}
							if (_tmp197_) {
								ValaSourceReference* _tmp199_ = NULL;
								gchar* _tmp200_ = NULL;
								gchar* _tmp201_;
								gchar* _tmp202_ = NULL;
								gchar* _tmp203_;
								gchar* _tmp204_ = NULL;
								gchar* _tmp205_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp199_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp200_ = vala_symbol_get_full_name ((ValaSymbol*) self);
								_tmp201_ = _tmp200_;
								_tmp202_ = vala_symbol_get_full_name ((ValaSymbol*) base_property);
								_tmp203_ = _tmp202_;
								_tmp204_ = g_strdup_printf ("`%s' does not implement abstract property `%s'", _tmp201_, _tmp203_);
								_tmp205_ = _tmp204_;
								vala_report_error (_tmp199_, _tmp205_);
								_g_free0 (_tmp205_);
								_g_free0 (_tmp203_);
								_g_free0 (_tmp201_);
							}
							_vala_code_node_unref0 (override_property);
						}
						_vala_code_node_unref0 (base_property);
					}
					_vala_iterable_unref0 (_base_property_list);
				}
				_tmp206_ = _vala_code_node_ref0 (base_class->priv->_base_class);
				_vala_code_node_unref0 (base_class);
				base_class = _tmp206_;
			}
			_vala_code_node_unref0 (base_class);
		}
	}
	_tmp207_ = vala_code_context_get_analyzer (context);
	vala_semantic_analyzer_set_current_source_file (_tmp207_, old_source_file);
	_tmp208_ = vala_code_context_get_analyzer (context);
	vala_semantic_analyzer_set_current_symbol (_tmp208_, old_symbol);
	_tmp209_ = vala_code_node_get_error ((ValaCodeNode*) self);
	result = !_tmp209_;
	_vala_iterable_unref0 (missing_prereqs);
	_vala_iterable_unref0 (prerequisites);
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}


ValaClass* vala_class_get_base_class (ValaClass* self) {
	ValaClass* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_base_class;
	return result;
}


void vala_class_set_base_class (ValaClass* self, ValaClass* value) {
	ValaClass* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_base_class);
	self->priv->_base_class = _tmp0_;
}


gboolean vala_class_get_is_abstract (ValaClass* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_abstract;
	return result;
}


void vala_class_set_is_abstract (ValaClass* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_is_abstract = value;
}


gboolean vala_class_get_is_compact (ValaClass* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->_base_class != NULL) {
		gboolean _tmp0_;
		_tmp0_ = vala_class_get_is_compact (self->priv->_base_class);
		result = _tmp0_;
		return result;
	}
	result = self->priv->_is_compact;
	return result;
}


void vala_class_set_is_compact (ValaClass* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_is_compact = value;
}


gboolean vala_class_get_is_immutable (ValaClass* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->_base_class != NULL) {
		gboolean _tmp0_;
		_tmp0_ = vala_class_get_is_immutable (self->priv->_base_class);
		result = _tmp0_;
		return result;
	}
	result = self->priv->_is_immutable;
	return result;
}


void vala_class_set_is_immutable (ValaClass* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_is_immutable = value;
}


gboolean vala_class_get_ref_function_void (ValaClass* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->_base_class != NULL) {
		gboolean _tmp0_;
		_tmp0_ = vala_class_get_ref_function_void (self->priv->_base_class);
		result = _tmp0_;
		return result;
	}
	result = self->priv->_ref_function_void;
	return result;
}


void vala_class_set_ref_function_void (ValaClass* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_ref_function_void = value;
}


const gchar* vala_class_get_type_check_function (ValaClass* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_type_check_function;
	return result;
}


void vala_class_set_type_check_function (ValaClass* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_type_check_function);
	self->priv->_type_check_function = _tmp0_;
}


gboolean vala_class_get_has_private_fields (ValaClass* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_private_fields;
	return result;
}


void vala_class_set_has_private_fields (ValaClass* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_has_private_fields = value;
}


gboolean vala_class_get_has_class_private_fields (ValaClass* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_class_private_fields;
	return result;
}


static void vala_class_set_has_class_private_fields (ValaClass* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_has_class_private_fields = value;
}


gboolean vala_class_get_free_function_address_of (ValaClass* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_free_function_address_of;
	return result;
}


static void vala_class_set_free_function_address_of (ValaClass* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_free_function_address_of = value;
}


gboolean vala_class_get_is_gboxed (ValaClass* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = g_strcmp0 (self->priv->free_function, "g_boxed_free") == 0;
	return result;
}


const gchar* vala_class_get_const_cname (ValaClass* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_const_cname;
	return result;
}


void vala_class_set_const_cname (ValaClass* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_const_cname);
	self->priv->_const_cname = _tmp0_;
}


ValaMethod* vala_class_get_default_construction_method (ValaClass* self) {
	ValaMethod* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_default_construction_method;
	return result;
}


void vala_class_set_default_construction_method (ValaClass* self, ValaMethod* value) {
	ValaMethod* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_default_construction_method);
	self->priv->_default_construction_method = _tmp0_;
}


ValaConstructor* vala_class_get_constructor (ValaClass* self) {
	ValaConstructor* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_constructor;
	return result;
}


void vala_class_set_constructor (ValaClass* self, ValaConstructor* value) {
	ValaConstructor* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_constructor);
	self->priv->_constructor = _tmp0_;
}


ValaConstructor* vala_class_get_class_constructor (ValaClass* self) {
	ValaConstructor* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_class_constructor;
	return result;
}


void vala_class_set_class_constructor (ValaClass* self, ValaConstructor* value) {
	ValaConstructor* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_class_constructor);
	self->priv->_class_constructor = _tmp0_;
}


ValaConstructor* vala_class_get_static_constructor (ValaClass* self) {
	ValaConstructor* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_static_constructor;
	return result;
}


void vala_class_set_static_constructor (ValaClass* self, ValaConstructor* value) {
	ValaConstructor* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_static_constructor);
	self->priv->_static_constructor = _tmp0_;
}


ValaDestructor* vala_class_get_destructor (ValaClass* self) {
	ValaDestructor* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_destructor;
	return result;
}


void vala_class_set_destructor (ValaClass* self, ValaDestructor* value) {
	ValaDestructor* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_destructor);
	self->priv->_destructor = _tmp0_;
	if (self->priv->_destructor != NULL) {
		ValaParameter* _tmp1_ = NULL;
		ValaObjectType* _tmp5_ = NULL;
		ValaObjectType* _tmp6_;
		ValaParameter* _tmp7_ = NULL;
		ValaParameter* _tmp8_;
		ValaScope* _tmp9_ = NULL;
		ValaParameter* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		ValaParameter* _tmp12_ = NULL;
		_tmp1_ = vala_destructor_get_this_parameter (self->priv->_destructor);
		if (_tmp1_ != NULL) {
			ValaScope* _tmp2_ = NULL;
			ValaParameter* _tmp3_ = NULL;
			const gchar* _tmp4_ = NULL;
			_tmp2_ = vala_symbol_get_scope ((ValaSymbol*) self->priv->_destructor);
			_tmp3_ = vala_destructor_get_this_parameter (self->priv->_destructor);
			_tmp4_ = vala_symbol_get_name ((ValaSymbol*) _tmp3_);
			vala_scope_remove (_tmp2_, _tmp4_);
		}
		_tmp5_ = vala_object_type_symbol_get_this_type ((ValaObjectTypeSymbol*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_parameter_new ("this", (ValaDataType*) _tmp6_, NULL);
		_tmp8_ = _tmp7_;
		vala_destructor_set_this_parameter (self->priv->_destructor, _tmp8_);
		_vala_code_node_unref0 (_tmp8_);
		_vala_code_node_unref0 (_tmp6_);
		_tmp9_ = vala_symbol_get_scope ((ValaSymbol*) self->priv->_destructor);
		_tmp10_ = vala_destructor_get_this_parameter (self->priv->_destructor);
		_tmp11_ = vala_symbol_get_name ((ValaSymbol*) _tmp10_);
		_tmp12_ = vala_destructor_get_this_parameter (self->priv->_destructor);
		vala_scope_add (_tmp9_, _tmp11_, (ValaSymbol*) _tmp12_);
	}
}


ValaDestructor* vala_class_get_static_destructor (ValaClass* self) {
	ValaDestructor* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_static_destructor;
	return result;
}


void vala_class_set_static_destructor (ValaClass* self, ValaDestructor* value) {
	ValaDestructor* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_static_destructor);
	self->priv->_static_destructor = _tmp0_;
}


ValaDestructor* vala_class_get_class_destructor (ValaClass* self) {
	ValaDestructor* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_class_destructor;
	return result;
}


void vala_class_set_class_destructor (ValaClass* self, ValaDestructor* value) {
	ValaDestructor* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_class_destructor);
	self->priv->_class_destructor = _tmp0_;
}


gboolean vala_class_get_is_error_base (ValaClass* self) {
	gboolean result;
	ValaAttribute* _tmp0_ = NULL;
	ValaAttribute* _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "ErrorBase");
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ != NULL;
	_vala_code_node_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}


static void vala_class_class_init (ValaClassClass * klass) {
	vala_class_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_class_finalize;
	g_type_class_add_private (klass, sizeof (ValaClassPrivate));
	VALA_SYMBOL_CLASS (klass)->add_constant = vala_class_real_add_constant;
	VALA_SYMBOL_CLASS (klass)->add_field = vala_class_real_add_field;
	VALA_SYMBOL_CLASS (klass)->add_method = vala_class_real_add_method;
	VALA_OBJECT_TYPE_SYMBOL_CLASS (klass)->get_methods = vala_class_real_get_methods;
	VALA_SYMBOL_CLASS (klass)->add_property = vala_class_real_add_property;
	VALA_OBJECT_TYPE_SYMBOL_CLASS (klass)->get_properties = vala_class_real_get_properties;
	VALA_SYMBOL_CLASS (klass)->add_signal = vala_class_real_add_signal;
	VALA_OBJECT_TYPE_SYMBOL_CLASS (klass)->get_signals = vala_class_real_get_signals;
	VALA_SYMBOL_CLASS (klass)->add_class = vala_class_real_add_class;
	VALA_SYMBOL_CLASS (klass)->add_struct = vala_class_real_add_struct;
	VALA_SYMBOL_CLASS (klass)->add_enum = vala_class_real_add_enum;
	VALA_SYMBOL_CLASS (klass)->add_delegate = vala_class_real_add_delegate;
	VALA_SYMBOL_CLASS (klass)->add_constructor = vala_class_real_add_constructor;
	VALA_SYMBOL_CLASS (klass)->add_destructor = vala_class_real_add_destructor;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_class_real_accept;
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_class_real_accept_children;
	VALA_SYMBOL_CLASS (klass)->get_cprefix = vala_class_real_get_cprefix;
	VALA_TYPESYMBOL_CLASS (klass)->get_cname = vala_class_real_get_cname;
	VALA_SYMBOL_CLASS (klass)->get_lower_case_cname = vala_class_real_get_lower_case_cname;
	VALA_SYMBOL_CLASS (klass)->get_lower_case_cprefix = vala_class_real_get_lower_case_cprefix;
	VALA_TYPESYMBOL_CLASS (klass)->get_upper_case_cname = vala_class_real_get_upper_case_cname;
	VALA_TYPESYMBOL_CLASS (klass)->is_reference_type = vala_class_real_is_reference_type;
	VALA_TYPESYMBOL_CLASS (klass)->get_type_id = vala_class_real_get_type_id;
	VALA_TYPESYMBOL_CLASS (klass)->get_marshaller_type_name = vala_class_real_get_marshaller_type_name;
	VALA_TYPESYMBOL_CLASS (klass)->get_param_spec_function = vala_class_real_get_param_spec_function;
	VALA_TYPESYMBOL_CLASS (klass)->get_get_value_function = vala_class_real_get_get_value_function;
	VALA_TYPESYMBOL_CLASS (klass)->get_set_value_function = vala_class_real_get_set_value_function;
	VALA_TYPESYMBOL_CLASS (klass)->get_take_value_function = vala_class_real_get_take_value_function;
	VALA_TYPESYMBOL_CLASS (klass)->is_reference_counting = vala_class_real_is_reference_counting;
	VALA_TYPESYMBOL_CLASS (klass)->get_ref_function = vala_class_real_get_ref_function;
	VALA_TYPESYMBOL_CLASS (klass)->get_unref_function = vala_class_real_get_unref_function;
	VALA_TYPESYMBOL_CLASS (klass)->get_ref_sink_function = vala_class_real_get_ref_sink_function;
	VALA_TYPESYMBOL_CLASS (klass)->get_dup_function = vala_class_real_get_dup_function;
	VALA_TYPESYMBOL_CLASS (klass)->get_free_function = vala_class_real_get_free_function;
	VALA_TYPESYMBOL_CLASS (klass)->is_subtype_of = vala_class_real_is_subtype_of;
	VALA_CODE_NODE_CLASS (klass)->replace_type = vala_class_real_replace_type;
	VALA_CODE_NODE_CLASS (klass)->check = vala_class_real_check;
}


static void vala_class_instance_init (ValaClass * self) {
	ValaArrayList* _tmp0_ = NULL;
	ValaArrayList* _tmp1_ = NULL;
	ValaArrayList* _tmp2_ = NULL;
	ValaArrayList* _tmp3_ = NULL;
	ValaArrayList* _tmp4_ = NULL;
	ValaArrayList* _tmp5_ = NULL;
	ValaArrayList* _tmp6_ = NULL;
	ValaArrayList* _tmp7_ = NULL;
	ValaArrayList* _tmp8_ = NULL;
	ValaArrayList* _tmp9_ = NULL;
	self->priv = VALA_CLASS_GET_PRIVATE (self);
	_tmp0_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->base_types = (ValaList*) _tmp0_;
	_tmp1_ = vala_array_list_new (VALA_TYPE_CONSTANT, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->constants = (ValaList*) _tmp1_;
	_tmp2_ = vala_array_list_new (VALA_TYPE_FIELD, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->fields = (ValaList*) _tmp2_;
	_tmp3_ = vala_array_list_new (VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->methods = (ValaList*) _tmp3_;
	_tmp4_ = vala_array_list_new (VALA_TYPE_PROPERTY, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->properties = (ValaList*) _tmp4_;
	_tmp5_ = vala_array_list_new (VALA_TYPE_SIGNAL, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->signals = (ValaList*) _tmp5_;
	_tmp6_ = vala_array_list_new (VALA_TYPE_CLASS, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->classes = (ValaList*) _tmp6_;
	_tmp7_ = vala_array_list_new (VALA_TYPE_STRUCT, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->structs = (ValaList*) _tmp7_;
	_tmp8_ = vala_array_list_new (VALA_TYPE_ENUM, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->enums = (ValaList*) _tmp8_;
	_tmp9_ = vala_array_list_new (VALA_TYPE_DELEGATE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->delegates = (ValaList*) _tmp9_;
}


static void vala_class_finalize (ValaCodeNode* obj) {
	ValaClass * self;
	self = VALA_CLASS (obj);
	_vala_code_node_unref0 (self->priv->_base_class);
	_g_free0 (self->priv->_type_check_function);
	_g_free0 (self->priv->cname);
	_g_free0 (self->priv->_const_cname);
	_g_free0 (self->priv->lower_case_cprefix);
	_g_free0 (self->priv->lower_case_csuffix);
	_g_free0 (self->priv->type_id);
	_g_free0 (self->priv->ref_function);
	_g_free0 (self->priv->unref_function);
	_g_free0 (self->priv->ref_sink_function);
	_g_free0 (self->priv->param_spec_function);
	_g_free0 (self->priv->copy_function);
	_g_free0 (self->priv->free_function);
	_g_free0 (self->priv->marshaller_type_name);
	_g_free0 (self->priv->get_value_function);
	_g_free0 (self->priv->set_value_function);
	_g_free0 (self->priv->take_value_function);
	_vala_iterable_unref0 (self->priv->base_types);
	_vala_iterable_unref0 (self->priv->constants);
	_vala_iterable_unref0 (self->priv->fields);
	_vala_iterable_unref0 (self->priv->methods);
	_vala_iterable_unref0 (self->priv->properties);
	_vala_iterable_unref0 (self->priv->signals);
	_vala_iterable_unref0 (self->priv->classes);
	_vala_iterable_unref0 (self->priv->structs);
	_vala_iterable_unref0 (self->priv->enums);
	_vala_iterable_unref0 (self->priv->delegates);
	_vala_code_node_unref0 (self->priv->_default_construction_method);
	_vala_code_node_unref0 (self->priv->_constructor);
	_vala_code_node_unref0 (self->priv->_class_constructor);
	_vala_code_node_unref0 (self->priv->_static_constructor);
	_vala_code_node_unref0 (self->priv->_static_destructor);
	_vala_code_node_unref0 (self->priv->_class_destructor);
	_vala_code_node_unref0 (self->priv->_destructor);
	VALA_CODE_NODE_CLASS (vala_class_parent_class)->finalize (obj);
}


/**
 * Represents a class declaration in the source code.
 */
GType vala_class_get_type (void) {
	static volatile gsize vala_class_type_id__volatile = 0;
	if (g_once_init_enter (&vala_class_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaClassClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_class_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaClass), 0, (GInstanceInitFunc) vala_class_instance_init, NULL };
		GType vala_class_type_id;
		vala_class_type_id = g_type_register_static (VALA_TYPE_OBJECT_TYPE_SYMBOL, "ValaClass", &g_define_type_info, 0);
		g_once_init_leave (&vala_class_type_id__volatile, vala_class_type_id);
	}
	return vala_class_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



