/* gio-2.0.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "G", gir_namespace = "Gio", gir_version = "2.0", lower_case_cprefix = "g_")]
namespace GLib {
	namespace Bus {
		[CCode (cheader_filename = "gio/gio.h")]
		public static async GLib.DBusConnection @get (GLib.BusType bus_type, GLib.Cancellable? cancellable = null) throws GLib.IOError;
		[CCode (cheader_filename = "gio/gio.h")]
		public static async T get_proxy<T> (GLib.BusType bus_type, string name, string object_path, GLib.DBusProxyFlags flags = 0, GLib.Cancellable? cancellable = null) throws GLib.IOError;
		[CCode (cheader_filename = "gio/gio.h")]
		public static T get_proxy_sync<T> (GLib.BusType bus_type, string name, string object_path, GLib.DBusProxyFlags flags = 0, GLib.Cancellable? cancellable = null) throws GLib.IOError;
		[CCode (cheader_filename = "gio/gio.h")]
		public static GLib.DBusConnection get_sync (GLib.BusType bus_type, GLib.Cancellable? cancellable = null) throws GLib.IOError;
		[CCode (cheader_filename = "gio/gio.h", cname = "g_bus_own_name_with_closures")]
		public static uint own_name (GLib.BusType bus_type, string name, GLib.BusNameOwnerFlags flags, [CCode (type = "GClosure*")] owned GLib.BusAcquiredCallback? bus_acquired_handler = null, [CCode (type = "GClosure*")] owned GLib.BusNameAcquiredCallback? name_acquired_handler = null, [CCode (type = "GClosure*")] owned GLib.BusNameLostCallback? name_lost_handler = null);
		[CCode (cheader_filename = "gio/gio.h", cname = "g_bus_own_name_on_connection_with_closures")]
		public static uint own_name_on_connection (GLib.DBusConnection connection, string name, GLib.BusNameOwnerFlags flags, [CCode (type = "GClosure*")] owned GLib.BusNameAcquiredCallback? name_acquired_handler = null, [CCode (type = "GClosure*")] owned GLib.BusNameLostCallback? name_lost_handler = null);
		[CCode (cheader_filename = "gio/gio.h")]
		public static void unown_name (uint owner_id);
		[CCode (cheader_filename = "gio/gio.h")]
		public static void unwatch_name (uint watcher_id);
		[CCode (cheader_filename = "gio/gio.h", cname = "g_bus_watch_name_with_closures")]
		public static uint watch_name (GLib.BusType bus_type, string name, GLib.BusNameWatcherFlags flags, [CCode (type = "GClosure*")] owned GLib.BusNameAppearedCallback? name_appeared_handler, [CCode (type = "GClosure*")] owned GLib.BusNameVanishedCallback? name_vanished_handler);
		[CCode (cheader_filename = "gio/gio.h", cname = "g_bus_watch_name_on_connection_with_closures")]
		public static uint watch_name_on_connection (GLib.DBusConnection connection, string name, GLib.BusNameWatcherFlags flags, [CCode (type = "GClosure*")] owned GLib.BusNameAppearedCallback? name_appeared_handler, [CCode (type = "GClosure*")] owned GLib.BusNameVanishedCallback? name_vanished_handler);
	}
	namespace ContentType {
		[CCode (cheader_filename = "gio/gio.h")]
		public static bool can_be_executable (string type);
		[CCode (cheader_filename = "gio/gio.h")]
		public static bool equals (string type1, string type2);
		[CCode (cheader_filename = "gio/gio.h")]
		public static string from_mime_type (string mime_type);
		[CCode (cheader_filename = "gio/gio.h")]
		public static string get_description (string type);
		[CCode (cheader_filename = "gio/gio.h")]
		public static GLib.Icon get_icon (string type);
		[CCode (cheader_filename = "gio/gio.h")]
		public static string get_mime_type (string type);
		[CCode (cheader_filename = "gio/gio.h")]
		public static string guess (string? filename, uchar[]? data, out bool result_uncertain);
		[CCode (array_length = false, array_null_terminated = true, cheader_filename = "gio/gio.h")]
		public static string[] guess_for_tree (GLib.File root);
		[CCode (cheader_filename = "gio/gio.h")]
		public static bool is_a (string type, string supertype);
		[CCode (cheader_filename = "gio/gio.h")]
		public static bool is_unknown (string type);
	}
	[CCode (cheader_filename = "gio/gio.h")]
	[Compact]
	public class ActionEntry {
		public weak GLib.Callback activate;
		public weak GLib.Callback change_state;
		public weak string name;
		[CCode (array_length = false)]
		public weak size_t[] padding;
		public weak string parameter_type;
		public weak string state;
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class AppLaunchContext : GLib.Object {
		[CCode (has_construct_function = false)]
		public AppLaunchContext ();
		public virtual string get_display (GLib.AppInfo info, GLib.List<GLib.File> files);
		public virtual string get_startup_notify_id (GLib.AppInfo info, GLib.List<GLib.File> files);
		public virtual void launch_failed (string startup_notify_id);
	}
	[CCode (cheader_filename = "gio/gio.h", cname = "GApplication")]
	public class Application : GLib.Object, GLib.ActionGroup {
		[CCode (has_construct_function = false)]
		public Application (string application_id, GLib.ApplicationFlags flags);
		[NoWrapper]
		public virtual void add_platform_data (GLib.VariantBuilder builder);
		[NoWrapper]
		public virtual void after_emit (GLib.Variant platform_data);
		[NoWrapper]
		public virtual void before_emit (GLib.Variant platform_data);
		public unowned string get_application_id ();
		public GLib.ApplicationFlags get_flags ();
		public uint get_inactivity_timeout ();
		public bool get_is_registered ();
		public bool get_is_remote ();
		public void hold ();
		public static bool id_is_valid (string application_id);
		[NoWrapper]
		public virtual bool local_command_line ([CCode (array_length = false, array_null_terminated = true)] ref unowned string[] arguments, out int exit_status);
		[CCode (cname = "g_application_quit_with_data")]
		public bool quit (GLib.Variant? platform_data = null);
		[NoWrapper]
		public virtual void quit_mainloop ();
		public bool register (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public void release ();
		public int run ([CCode (array_length_pos = 0.9)] string[]? argv = null);
		[NoWrapper]
		public virtual void run_mainloop ();
		public void set_action_group (GLib.ActionGroup action_group);
		public void set_application_id (string application_id);
		public void set_flags (GLib.ApplicationFlags flags);
		public void set_inactivity_timeout (uint inactivity_timeout);
		public GLib.ActionGroup action_group { set; }
		public string application_id { get; set construct; }
		public GLib.ApplicationFlags flags { get; set; }
		public uint inactivity_timeout { get; set; }
		public bool is_registered { get; }
		public bool is_remote { get; }
		[HasEmitter]
		public virtual signal void activate ();
		public virtual signal int command_line (GLib.ApplicationCommandLine command_line);
		[HasEmitter]
		public virtual signal void open (GLib.File[] files, string hint);
		public virtual signal void startup ();
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class ApplicationCommandLine : GLib.Object {
		[CCode (has_construct_function = false)]
		protected ApplicationCommandLine ();
		public string[] get_arguments ();
		public unowned string get_cwd ();
		public unowned string get_environ ();
		public int get_exit_status ();
		public bool get_is_remote ();
		public GLib.Variant? get_platform_data ();
		public unowned string getenv (string name);
		[PrintfFormat]
		public void print (string format, ...);
		[NoWrapper]
		public virtual void print_literal (string message);
		[PrintfFormat]
		public void printerr (string format, ...);
		[NoWrapper]
		public virtual void printerr_literal (string message);
		public void set_exit_status (int exit_status);
		public GLib.Variant arguments { construct; }
		public bool is_remote { get; }
		public GLib.Variant platform_data { construct; }
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class BufferedInputStream : GLib.FilterInputStream {
		[CCode (has_construct_function = false, type = "GInputStream*")]
		public BufferedInputStream (GLib.InputStream base_stream);
		public virtual ssize_t fill (ssize_t count, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public virtual async ssize_t fill_async (ssize_t count, int io_priority = GLib.Priority.DEFAULT, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public size_t get_available ();
		public size_t get_buffer_size ();
		public size_t peek ([CCode (array_length_pos = 2.9, array_length_type = "gsize")] uint8[] buffer, size_t offset = 0);
		[CCode (array_length_type = "gsize")]
		public unowned uint8[] peek_buffer ();
		public int read_byte (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public void set_buffer_size (size_t size);
		[CCode (has_construct_function = false, type = "GInputStream*")]
		public BufferedInputStream.sized (GLib.InputStream base_stream, size_t size);
		public uint buffer_size { get; set construct; }
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class BufferedOutputStream : GLib.FilterOutputStream {
		[CCode (has_construct_function = false, type = "GOutputStream*")]
		public BufferedOutputStream (GLib.OutputStream base_stream);
		public bool get_auto_grow ();
		public size_t get_buffer_size ();
		public void set_auto_grow (bool auto_grow);
		public void set_buffer_size (size_t size);
		[CCode (has_construct_function = false, type = "GOutputStream*")]
		public BufferedOutputStream.sized (GLib.OutputStream base_stream, size_t size);
		public bool auto_grow { get; set; }
		public uint buffer_size { get; set construct; }
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class Cancellable : GLib.Object {
		[CCode (has_construct_function = false)]
		public Cancellable ();
		public void cancel ();
		public ulong connect ([CCode (type = "GCallback*")] owned GLib.Func<GLib.Cancellable> callback);
		public void disconnect (ulong handler_id);
		public static unowned GLib.Cancellable? get_current ();
		public int get_fd ();
		public bool is_cancelled ();
		public bool make_pollfd (GLib.PollFD pollfd);
		public void pop_current ();
		public void push_current ();
		public void release_fd ();
		public void reset ();
		public bool set_error_if_cancelled () throws GLib.IOError;
		public unowned GLib.TimeoutSource source_new ();
		public virtual signal void cancelled ();
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class CharsetConverter : GLib.Object, GLib.Converter, GLib.Initable {
		[CCode (has_construct_function = false)]
		public CharsetConverter (string to_charset, string from_charset) throws GLib.Error;
		public uint get_num_fallbacks ();
		public bool get_use_fallback ();
		public void set_use_fallback (bool use_fallback);
		[NoAccessorMethod]
		public string from_charset { owned get; construct; }
		[NoAccessorMethod]
		public string to_charset { owned get; construct; }
		public bool use_fallback { get; set construct; }
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class ConverterInputStream : GLib.FilterInputStream {
		[CCode (has_construct_function = false, type = "GInputStream*")]
		public ConverterInputStream (GLib.InputStream base_stream, GLib.Converter converter);
		public unowned GLib.Converter get_converter ();
		public GLib.Converter converter { get; construct; }
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class ConverterOutputStream : GLib.FilterOutputStream {
		[CCode (has_construct_function = false, type = "GOutputStream*")]
		public ConverterOutputStream (GLib.OutputStream base_stream, GLib.Converter converter);
		public unowned GLib.Converter get_converter ();
		public GLib.Converter converter { get; construct; }
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class Credentials : GLib.Object {
		[CCode (has_construct_function = false)]
		public Credentials ();
		public void* get_native (GLib.CredentialsType native_type);
		public uint get_unix_user () throws GLib.Error;
		public bool is_same_user (GLib.Credentials other_credentials) throws GLib.Error;
		public void set_native (GLib.CredentialsType native_type, void* native);
		public bool set_unix_user (uint uid) throws GLib.Error;
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "gio/gio.h")]
	[Compact]
	public class CredentialsClass {
	}
	[CCode (cheader_filename = "gio/gio.h", ref_function = "g_dbus_annotation_info_ref", unref_function = "g_dbus_annotation_info_unref")]
	[Compact]
	public class DBusAnnotationInfo {
		[CCode (array_length = false, array_null_terminated = true)]
		public weak GLib.DBusAnnotationInfo[] annotations;
		public weak string key;
		public int ref_count;
		public weak string value;
		public unowned string lookup (string name);
	}
	[CCode (cheader_filename = "gio/gio.h", ref_function = "g_dbus_arg_info_ref", unref_function = "g_dbus_arg_info_unref")]
	[Compact]
	public class DBusArgInfo {
		[CCode (array_length = false, array_null_terminated = true)]
		public weak GLib.DBusAnnotationInfo[] annotations;
		public weak string name;
		public int ref_count;
		public weak string signature;
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class DBusAuthObserver : GLib.Object {
		[CCode (has_construct_function = false)]
		public DBusAuthObserver ();
		[HasEmitter]
		public virtual signal bool authorize_authenticated_peer (GLib.IOStream p0, GLib.Credentials p1);
	}
	[CCode (cheader_filename = "gio/gio.h", cname = "GDBusConnection")]
	public class DBusConnection : GLib.Object, GLib.Initable, GLib.AsyncInitable {
		[CCode (has_construct_function = false, type = "void")]
		public async DBusConnection (GLib.IOStream stream, string guid, GLib.DBusConnectionFlags flags, GLib.DBusAuthObserver? observer = null, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public uint add_filter (owned GLib.DBusMessageFilterFunction filter_function);
		public async GLib.Variant call (string bus_name, string object_path, string interface_name, string method_name, GLib.Variant? parameters, GLib.VariantType? reply_type, GLib.DBusCallFlags flags, int timeout_msec, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public GLib.Variant call_sync (string bus_name, string object_path, string interface_name, string method_name, GLib.Variant? parameters, GLib.VariantType reply_type, GLib.DBusCallFlags flags, int timeout_msec, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public async bool close (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public bool close_sync (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public bool emit_signal (string? destination_bus_name, string object_path, string interface_name, string signal_name, GLib.Variant parameters) throws GLib.Error;
		public async bool flush (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public bool flush_sync (GLib.Cancellable? cancellable = null) throws GLib.Error;
		[CCode (has_construct_function = false, type = "void")]
		public async DBusConnection.for_address (string address, GLib.DBusConnectionFlags flags, GLib.DBusAuthObserver? observer = null, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[CCode (has_construct_function = false)]
		public DBusConnection.for_address_sync (string address, GLib.DBusConnectionFlags flags, GLib.DBusAuthObserver? observer = null, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public GLib.DBusCapabilityFlags get_capabilities ();
		public bool get_exit_on_close ();
		public unowned string get_guid ();
		public unowned GLib.Credentials get_peer_credentials ();
		public async T get_proxy<T> (string? name, string object_path, GLib.DBusProxyFlags flags = 0, GLib.Cancellable? cancellable = null) throws GLib.IOError;
		public T get_proxy_sync<T> (string? name, string object_path, GLib.DBusProxyFlags flags = 0, GLib.Cancellable? cancellable = null) throws GLib.IOError;
		public unowned GLib.IOStream get_stream ();
		public unowned string get_unique_name ();
		public bool is_closed ();
		public uint register_object<T> (string object_path, T object) throws GLib.IOError;
		public uint register_subtree (string object_path, GLib.DBusSubtreeVTable vtable, GLib.DBusSubtreeFlags flags, GLib.DestroyNotify user_data_free_func) throws GLib.Error;
		public void remove_filter (uint filter_id);
		public bool send_message (GLib.DBusMessage message, GLib.DBusSendMessageFlags flags, out uint32 out_serial) throws GLib.Error;
		public async GLib.DBusMessage send_message_with_reply (GLib.DBusMessage message, GLib.DBusSendMessageFlags flags, int timeout_msec, out uint32 out_serial, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public GLib.DBusMessage send_message_with_reply_sync (GLib.DBusMessage message, GLib.DBusSendMessageFlags flags, int timeout_msec, out uint32 out_serial, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public void set_exit_on_close (bool exit_on_close);
		public uint signal_subscribe (string? sender, string? interface_name, string? member, string? object_path, string? arg0, GLib.DBusSignalFlags flags, owned GLib.DBusSignalCallback callback);
		public void signal_unsubscribe (uint subscription_id);
		public void start_message_processing ();
		[CCode (has_construct_function = false)]
		public DBusConnection.sync (GLib.IOStream stream, string guid, GLib.DBusConnectionFlags flags, GLib.DBusAuthObserver? observer = null, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public bool unregister_object (uint registration_id);
		public bool unregister_subtree (uint registration_id);
		public string address { construct; }
		public GLib.DBusAuthObserver authentication_observer { construct; }
		public GLib.DBusCapabilityFlags capabilities { get; }
		public bool exit_on_close { get; set; }
		public GLib.DBusConnectionFlags flags { construct; }
		public string guid { get; construct; }
		public GLib.IOStream stream { get; construct; }
		public string unique_name { get; }
		public virtual signal void closed (bool p0, GLib.Error p1);
	}
	[CCode (cheader_filename = "gio/gio.h")]
	[Compact]
	public class DBusErrorEntry {
		public weak string dbus_error_name;
		public int error_code;
	}
	[CCode (cheader_filename = "gio/gio.h", ref_function = "g_dbus_interface_info_ref", unref_function = "g_dbus_interface_info_unref")]
	[Compact]
	public class DBusInterfaceInfo {
		[CCode (array_length = false, array_null_terminated = true)]
		public weak GLib.DBusAnnotationInfo[] annotations;
		[CCode (array_length = false, array_null_terminated = true)]
		public weak GLib.DBusMethodInfo[] methods;
		public weak string name;
		[CCode (array_length = false, array_null_terminated = true)]
		public weak GLib.DBusPropertyInfo[] properties;
		public int ref_count;
		[CCode (array_length = false, array_null_terminated = true)]
		public weak GLib.DBusSignalInfo[] signals;
		public void cache_build ();
		public void cache_release ();
		public void generate_xml (uint indent, GLib.StringBuilder string_builder);
		public unowned GLib.DBusMethodInfo lookup_method (string name);
		public unowned GLib.DBusPropertyInfo lookup_property (string name);
		public unowned GLib.DBusSignalInfo lookup_signal (string name);
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class DBusInterfaceSkeleton : GLib.Object, GLib.DBusInterface {
		[CCode (has_construct_function = false)]
		protected DBusInterfaceSkeleton ();
		public bool export (GLib.DBusConnection connection, string object_path) throws GLib.Error;
		public virtual void flush ();
		public unowned GLib.DBusConnection get_connection ();
		public GLib.DBusInterfaceSkeletonFlags get_flags ();
		public virtual unowned GLib.DBusInterfaceInfo get_info ();
		public unowned string get_object_path ();
		public virtual unowned GLib.Variant get_properties ();
		public virtual unowned GLib.DBusInterfaceVTable get_vtable ();
		public void set_flags (GLib.DBusInterfaceSkeletonFlags flags);
		public void unexport ();
		[NoAccessorMethod]
		public GLib.DBusInterfaceSkeletonFlags g_flags { get; set; }
		public virtual signal bool g_authorize_method (GLib.DBusMethodInvocation invocation);
	}
	[CCode (cheader_filename = "gio/gio.h")]
	[Compact]
	public class DBusInterfaceVTable {
		public weak GLib.DBusInterfaceGetPropertyFunc get_property;
		public weak GLib.DBusInterfaceMethodCallFunc method_call;
		public void* padding;
		public weak GLib.DBusInterfaceSetPropertyFunc set_property;
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class DBusMessage : GLib.Object {
		[CCode (has_construct_function = false)]
		public DBusMessage ();
		public static ssize_t bytes_needed (uchar[] blob, size_t blob_len) throws GLib.Error;
		public unowned GLib.DBusMessage copy () throws GLib.Error;
		[CCode (has_construct_function = false)]
		public DBusMessage.from_blob (uchar[] blob, size_t blob_len, GLib.DBusCapabilityFlags capabilities) throws GLib.Error;
		public unowned string get_arg0 ();
		public unowned GLib.Variant get_body ();
		public GLib.DBusMessageByteOrder get_byte_order ();
		public unowned string get_destination ();
		public unowned string get_error_name ();
		public GLib.DBusMessageFlags get_flags ();
		public unowned GLib.Variant get_header (GLib.DBusMessageHeaderField header_field);
		public unowned uchar[] get_header_fields ();
		public unowned string get_interface ();
		public bool get_locked ();
		public unowned string get_member ();
		public GLib.DBusMessageType get_message_type ();
		public uint32 get_num_unix_fds ();
		public unowned string get_path ();
		public uint32 get_reply_serial ();
		public unowned string get_sender ();
		public uint32 get_serial ();
		public unowned string get_signature ();
		public unowned GLib.UnixFDList get_unix_fd_list ();
		public void @lock ();
		[CCode (has_construct_function = false)]
		public DBusMessage.method_call (string name, string path, string interface_, string method);
		[CCode (has_construct_function = false)]
		public DBusMessage.method_error (GLib.DBusMessage method_call_message, string error_name, string error_message_format);
		[CCode (has_construct_function = false)]
		public DBusMessage.method_error_literal (GLib.DBusMessage method_call_message, string error_name, string error_message);
		[CCode (has_construct_function = false)]
		public DBusMessage.method_error_valist (GLib.DBusMessage method_call_message, string error_name, string error_message_format, void* var_args);
		[CCode (has_construct_function = false)]
		public DBusMessage.method_reply (GLib.DBusMessage method_call_message);
		public unowned string print (uint indent = 0);
		public void set_body (GLib.Variant body);
		public void set_byte_order (GLib.DBusMessageByteOrder byte_order);
		public void set_destination (string value);
		public void set_error_name (string value);
		public void set_flags (GLib.DBusMessageFlags flags);
		public void set_header (GLib.DBusMessageHeaderField header_field, GLib.Variant value);
		public void set_interface (string value);
		public void set_member (string value);
		public void set_message_type (GLib.DBusMessageType type);
		public void set_num_unix_fds (uint32 value);
		public void set_path (string value);
		public void set_reply_serial (uint32 value);
		public void set_sender (string value);
		public void set_serial (uint32 serial);
		public void set_signature (string value);
		public void set_unix_fd_list (GLib.UnixFDList fd_list);
		[CCode (has_construct_function = false)]
		public DBusMessage.@signal (string path, string interface_, string @signal);
		public unowned uchar[] to_blob (size_t out_size, GLib.DBusCapabilityFlags capabilities) throws GLib.Error;
		public bool to_gerror () throws GLib.Error;
		public bool locked { get; }
	}
	[CCode (cheader_filename = "gio/gio.h", ref_function = "g_dbus_method_info_ref", unref_function = "g_dbus_method_info_unref")]
	[Compact]
	public class DBusMethodInfo {
		[CCode (array_length = false, array_null_terminated = true)]
		public weak GLib.DBusAnnotationInfo[] annotations;
		[CCode (array_length = false, array_null_terminated = true)]
		public weak GLib.DBusArgInfo[] in_args;
		public weak string name;
		[CCode (array_length = false, array_null_terminated = true)]
		public weak GLib.DBusArgInfo[] out_args;
		public int ref_count;
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class DBusMethodInvocation : GLib.Object {
		[CCode (has_construct_function = false)]
		protected DBusMethodInvocation ();
		public unowned GLib.DBusConnection get_connection ();
		public unowned string get_interface_name ();
		public unowned GLib.DBusMessage get_message ();
		public unowned GLib.DBusMethodInfo get_method_info ();
		public unowned string get_method_name ();
		public unowned string get_object_path ();
		public unowned GLib.Variant get_parameters ();
		public unowned string get_sender ();
		public void* get_user_data ();
		public void return_dbus_error (string error_name, string error_message);
		public void return_error (GLib.Quark domain, int code, string format);
		public void return_error_literal (GLib.Quark domain, int code, string message);
		public void return_error_valist (GLib.Quark domain, int code, string format, void* var_args);
		public void return_gerror (GLib.Error error);
		public void return_value (GLib.Variant parameters);
		public void take_error (GLib.Error error);
	}
	[CCode (cheader_filename = "gio/gio.h", ref_function = "g_dbus_node_info_ref", unref_function = "g_dbus_node_info_unref")]
	[Compact]
	public class DBusNodeInfo {
		[CCode (array_length = false, array_null_terminated = true)]
		public weak GLib.DBusAnnotationInfo[] annotations;
		[CCode (array_length = false, array_null_terminated = true)]
		public weak GLib.DBusInterfaceInfo[] interfaces;
		[CCode (array_length = false, array_null_terminated = true)]
		public weak GLib.DBusNodeInfo[] nodes;
		public weak string path;
		public int ref_count;
		[CCode (has_construct_function = false)]
		public DBusNodeInfo.for_xml (string xml_data) throws GLib.Error;
		public void generate_xml (uint indent, GLib.StringBuilder string_builder);
		public unowned GLib.DBusInterfaceInfo lookup_interface (string name);
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class DBusObjectManagerClient : GLib.Object, GLib.Initable, GLib.AsyncInitable, GLib.DBusObjectManager {
		[CCode (has_construct_function = false, type = "void")]
		public DBusObjectManagerClient (GLib.DBusConnection connection, GLib.DBusObjectManagerClientFlags flags, string name, string object_path, GLib.DBusProxyTypeFunc get_proxy_type_func, void* get_proxy_type_user_data, GLib.DestroyNotify get_proxy_type_destroy_notify, GLib.Cancellable? cancellable = null, GLib.AsyncReadyCallback callback);
		[CCode (has_construct_function = false, type = "GDBusObjectManager*")]
		public DBusObjectManagerClient.finish (GLib.AsyncResult res) throws GLib.Error;
		[CCode (has_construct_function = false, type = "void")]
		public DBusObjectManagerClient.for_bus (GLib.BusType bus_type, GLib.DBusObjectManagerClientFlags flags, string name, string object_path, GLib.DBusProxyTypeFunc get_proxy_type_func, void* get_proxy_type_user_data, GLib.DestroyNotify get_proxy_type_destroy_notify, GLib.Cancellable? cancellable = null, GLib.AsyncReadyCallback callback);
		[CCode (has_construct_function = false, type = "GDBusObjectManager*")]
		public DBusObjectManagerClient.for_bus_finish (GLib.AsyncResult res) throws GLib.Error;
		[CCode (has_construct_function = false, type = "GDBusObjectManager*")]
		public DBusObjectManagerClient.for_bus_sync (GLib.BusType bus_type, GLib.DBusObjectManagerClientFlags flags, string name, string object_path, GLib.DBusProxyTypeFunc get_proxy_type_func, void* get_proxy_type_user_data, GLib.DestroyNotify get_proxy_type_destroy_notify, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public unowned GLib.DBusConnection get_connection ();
		public GLib.DBusObjectManagerClientFlags get_flags ();
		public unowned string get_name ();
		public unowned string get_name_owner ();
		[CCode (has_construct_function = false, type = "GDBusObjectManager*")]
		public DBusObjectManagerClient.sync (GLib.DBusConnection connection, GLib.DBusObjectManagerClientFlags flags, string name, string object_path, GLib.DBusProxyTypeFunc get_proxy_type_func, void* get_proxy_type_user_data, GLib.DestroyNotify get_proxy_type_destroy_notify, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public GLib.BusType bus_type { construct; }
		public GLib.DBusConnection connection { get; construct; }
		public GLib.DBusObjectManagerClientFlags flags { get; construct; }
		[NoAccessorMethod]
		public void* get_proxy_type_destroy_notify { get; construct; }
		[NoAccessorMethod]
		public void* get_proxy_type_func { get; construct; }
		[NoAccessorMethod]
		public void* get_proxy_type_user_data { get; construct; }
		public string name { get; construct; }
		public string name_owner { get; }
		[NoAccessorMethod]
		public string object_path { owned get; construct; }
		public virtual signal void interface_proxy_properties_changed (GLib.DBusObjectProxy object_proxy, GLib.DBusProxy interface_proxy, GLib.Variant changed_properties, string[] invalidated_properties);
		public virtual signal void interface_proxy_signal (GLib.DBusObjectProxy object_proxy, GLib.DBusProxy interface_proxy, string sender_name, string signal_name, GLib.Variant parameters);
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class DBusObjectManagerServer : GLib.Object, GLib.DBusObjectManager {
		[CCode (has_construct_function = false)]
		public DBusObjectManagerServer (string object_path);
		public void export (GLib.DBusObjectSkeleton object);
		public void export_uniquely (GLib.DBusObjectSkeleton object);
		public unowned GLib.DBusConnection get_connection ();
		public void set_connection (GLib.DBusConnection connection);
		public bool unexport (string object_path);
		public GLib.DBusConnection connection { get; set; }
		[NoAccessorMethod]
		public string object_path { owned get; construct; }
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class DBusObjectProxy : GLib.Object, GLib.DBusObject {
		[CCode (has_construct_function = false)]
		public DBusObjectProxy (GLib.DBusConnection connection, string object_path);
		public unowned GLib.DBusConnection get_connection ();
		public GLib.DBusConnection connection { get; construct; }
		[NoAccessorMethod]
		public string object_path { owned get; construct; }
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class DBusObjectSkeleton : GLib.Object, GLib.DBusObject {
		[CCode (has_construct_function = false)]
		public DBusObjectSkeleton (string object_path);
		public void add_interface (GLib.DBusInterfaceSkeleton interface_);
		public void flush ();
		public void remove_interface (GLib.DBusInterfaceSkeleton interface_);
		public void remove_interface_by_name (string interface_name);
		public void set_object_path (string object_path);
		[NoAccessorMethod]
		public string object_path { owned get; set construct; }
		public virtual signal bool authorize_method (GLib.DBusInterfaceSkeleton interface_, GLib.DBusMethodInvocation invocation);
	}
	[CCode (cheader_filename = "gio/gio.h", ref_function = "g_dbus_property_info_ref", unref_function = "g_dbus_property_info_unref")]
	[Compact]
	public class DBusPropertyInfo {
		[CCode (array_length = false, array_null_terminated = true)]
		public weak GLib.DBusAnnotationInfo[] annotations;
		public GLib.DBusPropertyInfoFlags flags;
		public weak string name;
		public int ref_count;
		public weak string signature;
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class DBusProxy : GLib.Object, GLib.DBusInterface, GLib.Initable, GLib.AsyncInitable {
		[CCode (has_construct_function = false, type = "void")]
		public async DBusProxy (GLib.DBusConnection connection, GLib.DBusProxyFlags flags, GLib.DBusInterfaceInfo? info, string name, string object_path, string interface_name, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public async GLib.Variant call (string method_name, GLib.Variant? parameters, GLib.DBusCallFlags flags, int timeout_msec, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public GLib.Variant call_sync (string method_name, GLib.Variant? parameters, GLib.DBusCallFlags flags, int timeout_msec, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[CCode (has_construct_function = false, type = "void")]
		public async DBusProxy.for_bus (GLib.BusType bus_type, GLib.DBusProxyFlags flags, GLib.DBusInterfaceInfo? info, string name, string object_path, string interface_name, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[CCode (has_construct_function = false)]
		public DBusProxy.for_bus_sync (GLib.BusType bus_type, GLib.DBusProxyFlags flags, GLib.DBusInterfaceInfo? info, string name, string object_path, string interface_name, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public unowned GLib.Variant get_cached_property (string property_name);
		public unowned string get_cached_property_names ();
		public unowned GLib.DBusConnection get_connection ();
		public int get_default_timeout ();
		public GLib.DBusProxyFlags get_flags ();
		public unowned GLib.DBusInterfaceInfo get_interface_info ();
		public unowned string get_interface_name ();
		public unowned string get_name ();
		public unowned string get_name_owner ();
		public unowned string get_object_path ();
		public void set_cached_property (string property_name, GLib.Variant value);
		public void set_default_timeout (int timeout_msec);
		public void set_interface_info (GLib.DBusInterfaceInfo info);
		[CCode (has_construct_function = false)]
		public DBusProxy.sync (GLib.DBusConnection connection, GLib.DBusProxyFlags flags, GLib.DBusInterfaceInfo? info, string name, string object_path, string interface_name, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public GLib.BusType g_bus_type { construct; }
		[NoAccessorMethod]
		public GLib.DBusConnection g_connection { owned get; construct; }
		[NoAccessorMethod]
		public int g_default_timeout { get; set construct; }
		[NoAccessorMethod]
		public GLib.DBusProxyFlags g_flags { get; construct; }
		[NoAccessorMethod]
		public GLib.DBusInterfaceInfo g_interface_info { owned get; set; }
		[NoAccessorMethod]
		public string g_interface_name { owned get; construct; }
		[NoAccessorMethod]
		public string g_name { owned get; construct; }
		[NoAccessorMethod]
		public string g_name_owner { owned get; }
		[NoAccessorMethod]
		public string g_object_path { owned get; construct; }
		public virtual signal void g_properties_changed (GLib.Variant changed_properties, [CCode (array_length = false, array_null_terminated = true)] string[] invalidated_properties);
		public virtual signal void g_signal (string sender_name, string signal_name, GLib.Variant parameters);
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class DBusServer : GLib.Object, GLib.Initable {
		[CCode (has_construct_function = false)]
		protected DBusServer ();
		public unowned string get_client_address ();
		public GLib.DBusServerFlags get_flags ();
		public unowned string get_guid ();
		public bool is_active ();
		public void start ();
		public void stop ();
		[CCode (has_construct_function = false)]
		public DBusServer.sync (string address, GLib.DBusServerFlags flags, string guid, GLib.DBusAuthObserver? observer = null, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[NoAccessorMethod]
		public bool active { get; }
		[NoAccessorMethod]
		public string address { owned get; construct; }
		[NoAccessorMethod]
		public GLib.DBusAuthObserver authentication_observer { owned get; construct; }
		public string client_address { get; }
		public GLib.DBusServerFlags flags { get; construct; }
		public string guid { get; construct; }
		public virtual signal bool new_connection (GLib.DBusConnection p0);
	}
	[CCode (cheader_filename = "gio/gio.h", ref_function = "g_dbus_signal_info_ref", unref_function = "g_dbus_signal_info_unref")]
	[Compact]
	public class DBusSignalInfo {
		[CCode (array_length = false, array_null_terminated = true)]
		public weak GLib.DBusAnnotationInfo[] annotations;
		[CCode (array_length = false, array_null_terminated = true)]
		public weak GLib.DBusArgInfo[] args;
		public weak string name;
		public int ref_count;
	}
	[CCode (cheader_filename = "gio/gio.h")]
	[Compact]
	public class DBusSubtreeVTable {
		public weak GLib.DBusSubtreeDispatchFunc dispatch;
		public weak GLib.DBusSubtreeEnumerateFunc enumerate;
		public weak GLib.DBusSubtreeIntrospectFunc introspect;
		public void* padding;
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class DataInputStream : GLib.BufferedInputStream {
		[CCode (has_construct_function = false)]
		public DataInputStream (GLib.InputStream base_stream);
		public GLib.DataStreamByteOrder get_byte_order ();
		public GLib.DataStreamNewlineType get_newline_type ();
		public uchar read_byte (GLib.Cancellable? cancellable = null) throws GLib.IOError;
		public int16 read_int16 (GLib.Cancellable? cancellable = null) throws GLib.IOError;
		public int32 read_int32 (GLib.Cancellable? cancellable = null) throws GLib.IOError;
		public int64 read_int64 (GLib.Cancellable? cancellable = null) throws GLib.IOError;
		public string? read_line (out size_t length, GLib.Cancellable? cancellable = null) throws GLib.IOError;
		public async string? read_line_async (int io_priority = GLib.Priority.DEFAULT, GLib.Cancellable? cancellable = null, out size_t length = null) throws GLib.IOError;
		public unowned string read_line_finish_utf8 (GLib.AsyncResult _result, size_t length) throws GLib.Error;
		public unowned string read_line_utf8 (size_t length, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public uint16 read_uint16 (GLib.Cancellable? cancellable = null) throws GLib.IOError;
		public uint32 read_uint32 (GLib.Cancellable? cancellable = null) throws GLib.IOError;
		public uint64 read_uint64 (GLib.Cancellable? cancellable = null) throws GLib.IOError;
		public string? read_until (string stop_chars, out size_t length, GLib.Cancellable? cancellable = null) throws GLib.IOError;
		public async string? read_until_async (string stop_chars, int io_priority = GLib.Priority.DEFAULT, GLib.Cancellable? cancellable = null, out size_t? length = null) throws GLib.IOError;
		public string? read_upto (string stop_chars, ssize_t stop_chars_len, out size_t length, GLib.Cancellable? cancellable = null) throws GLib.IOError;
		public async string? read_upto_async (string stop_chars, ssize_t stop_chars_len, int io_priority = GLib.Priority.DEFAULT, GLib.Cancellable? cancellable = null, out size_t? length = null) throws GLib.IOError;
		public void set_byte_order (GLib.DataStreamByteOrder order);
		public void set_newline_type (GLib.DataStreamNewlineType type);
		public GLib.DataStreamByteOrder byte_order { get; set; }
		public GLib.DataStreamNewlineType newline_type { get; set; }
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class DataOutputStream : GLib.FilterOutputStream {
		[CCode (has_construct_function = false)]
		public DataOutputStream (GLib.OutputStream base_stream);
		public GLib.DataStreamByteOrder get_byte_order ();
		public bool put_byte (uchar data, GLib.Cancellable? cancellable = null) throws GLib.IOError;
		public bool put_int16 (int16 data, GLib.Cancellable? cancellable = null) throws GLib.IOError;
		public bool put_int32 (int32 data, GLib.Cancellable? cancellable = null) throws GLib.IOError;
		public bool put_int64 (int64 data, GLib.Cancellable? cancellable = null) throws GLib.IOError;
		public bool put_string (string str, GLib.Cancellable? cancellable = null) throws GLib.IOError;
		public bool put_uint16 (uint16 data, GLib.Cancellable? cancellable = null) throws GLib.IOError;
		public bool put_uint32 (uint32 data, GLib.Cancellable? cancellable = null) throws GLib.IOError;
		public bool put_uint64 (uint64 data, GLib.Cancellable? cancellable = null) throws GLib.IOError;
		public void set_byte_order (GLib.DataStreamByteOrder order);
		public GLib.DataStreamByteOrder byte_order { get; set; }
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class Emblem : GLib.Object, GLib.Icon {
		[CCode (has_construct_function = false)]
		public Emblem (GLib.Icon icon);
		public unowned GLib.Icon get_icon ();
		public GLib.EmblemOrigin get_origin ();
		[CCode (has_construct_function = false)]
		public Emblem.with_origin (GLib.Icon icon, GLib.EmblemOrigin origin);
		public GLib.Object icon { get; construct; }
		public GLib.EmblemOrigin origin { get; construct; }
	}
	[CCode (cheader_filename = "gio/gio.h")]
	[Compact]
	public class EmblemClass {
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class EmblemedIcon : GLib.Object, GLib.Icon {
		[CCode (has_construct_function = false, type = "GIcon*")]
		public EmblemedIcon (GLib.Icon icon, GLib.Emblem emblem);
		public void add_emblem (GLib.Emblem emblem);
		public void clear_emblems ();
		public unowned GLib.List<GLib.Emblem> get_emblems ();
		public unowned GLib.Icon get_icon ();
		[NoAccessorMethod]
		public GLib.Icon gicon { owned get; construct; }
	}
	[CCode (cheader_filename = "gio/gio.h")]
	[Compact]
	public class FileAttributeInfo {
		public GLib.FileAttributeInfoFlags flags;
		public weak string name;
		public GLib.FileAttributeType type;
	}
	[CCode (cheader_filename = "gio/gio.h", ref_function = "g_file_attribute_info_list_ref", unref_function = "g_file_attribute_info_list_unref")]
	[Compact]
	public class FileAttributeInfoList {
		public weak GLib.FileAttributeInfo infos;
		public int n_infos;
		[CCode (has_construct_function = false)]
		public FileAttributeInfoList ();
		public void add (string name, GLib.FileAttributeType type, GLib.FileAttributeInfoFlags flags);
		public unowned GLib.FileAttributeInfoList dup ();
		public unowned GLib.FileAttributeInfo lookup (string name);
	}
	[CCode (cheader_filename = "gio/gio.h", ref_function = "g_file_attribute_matcher_ref", unref_function = "g_file_attribute_matcher_unref")]
	[Compact]
	public class FileAttributeMatcher {
		[CCode (has_construct_function = false)]
		public FileAttributeMatcher (string attributes);
		public bool enumerate_namespace (string ns);
		public unowned string enumerate_next ();
		public bool matches (string attribute);
		public bool matches_only (string attribute);
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class FileEnumerator : GLib.Object {
		[CCode (has_construct_function = false)]
		protected FileEnumerator ();
		public bool close (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public virtual async bool close_async (int io_priority = GLib.Priority.DEFAULT, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[NoWrapper]
		public virtual bool close_fn (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public unowned GLib.File get_container ();
		public bool has_pending ();
		public bool is_closed ();
		public virtual GLib.FileInfo next_file (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public virtual async GLib.List<GLib.FileInfo> next_files_async (int num_files, int io_priority = GLib.Priority.DEFAULT, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public void set_pending (bool pending);
		public GLib.File container { construct; }
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class FileIOStream : GLib.IOStream, GLib.Seekable {
		[CCode (has_construct_function = false)]
		protected FileIOStream ();
		[NoWrapper]
		public virtual bool can_seek ();
		[NoWrapper]
		public virtual bool can_truncate ();
		public virtual unowned string get_etag ();
		public virtual unowned GLib.FileInfo query_info (string attributes, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public virtual async unowned GLib.FileInfo query_info_async (string attributes, int io_priority = GLib.Priority.DEFAULT, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[NoWrapper]
		public virtual bool seek (int64 offset, GLib.SeekType type, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[NoWrapper]
		public virtual int64 tell ();
		[NoWrapper]
		public virtual bool truncate_fn (int64 size, GLib.Cancellable? cancellable = null) throws GLib.Error;
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class FileIcon : GLib.Object, GLib.Icon, GLib.LoadableIcon {
		[CCode (has_construct_function = false, type = "GIcon*")]
		public FileIcon (GLib.File file);
		public unowned GLib.File get_file ();
		public GLib.File file { get; construct; }
	}
	[CCode (cheader_filename = "gio/gio.h")]
	[Compact]
	public class FileIconClass {
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class FileInfo : GLib.Object {
		[CCode (has_construct_function = false)]
		public FileInfo ();
		public void clear_status ();
		public void copy_into (GLib.FileInfo dest_info);
		public unowned GLib.FileInfo dup ();
		public unowned string get_attribute_as_string (string attribute);
		public bool get_attribute_boolean (string attribute);
		public unowned string get_attribute_byte_string (string attribute);
		public bool get_attribute_data (string attribute, GLib.FileAttributeType? type, void* value_pp, GLib.FileAttributeStatus? status);
		public int32 get_attribute_int32 (string attribute);
		public int64 get_attribute_int64 (string attribute);
		public unowned GLib.Object get_attribute_object (string attribute);
		public GLib.FileAttributeStatus get_attribute_status (string attribute);
		public unowned string get_attribute_string (string attribute);
		public unowned string get_attribute_stringv (string attribute);
		public GLib.FileAttributeType get_attribute_type (string attribute);
		public uint32 get_attribute_uint32 (string attribute);
		public uint64 get_attribute_uint64 (string attribute);
		public unowned string get_content_type ();
		public unowned string get_display_name ();
		public unowned string get_edit_name ();
		public unowned string get_etag ();
		public GLib.FileType get_file_type ();
		public unowned GLib.Icon get_icon ();
		public bool get_is_backup ();
		public bool get_is_hidden ();
		public bool get_is_symlink ();
		public void get_modification_time (out GLib.TimeVal _result);
		public unowned string get_name ();
		public int64 get_size ();
		public int32 get_sort_order ();
		public unowned string get_symlink_target ();
		public bool has_attribute (string attribute);
		public bool has_namespace (string name_space);
		public unowned string list_attributes (string name_space);
		public void remove_attribute (string attribute);
		public void set_attribute (string attribute, GLib.FileAttributeType type, void* value_p);
		public void set_attribute_boolean (string attribute, bool attr_value);
		public void set_attribute_byte_string (string attribute, string attr_value);
		public void set_attribute_int32 (string attribute, int32 attr_value);
		public void set_attribute_int64 (string attribute, int64 attr_value);
		public void set_attribute_mask (GLib.FileAttributeMatcher mask);
		public void set_attribute_object (string attribute, GLib.Object attr_value);
		public bool set_attribute_status (string attribute, GLib.FileAttributeStatus status);
		public void set_attribute_string (string attribute, string attr_value);
		public void set_attribute_stringv (string attribute, out unowned string attr_value);
		public void set_attribute_uint32 (string attribute, uint32 attr_value);
		public void set_attribute_uint64 (string attribute, uint64 attr_value);
		public void set_content_type (string content_type);
		public void set_display_name (string display_name);
		public void set_edit_name (string edit_name);
		public void set_file_type (GLib.FileType type);
		public void set_icon (GLib.Icon icon);
		public void set_is_hidden (bool is_hidden);
		public void set_is_symlink (bool is_symlink);
		public void set_modification_time (GLib.TimeVal mtime);
		public void set_name (string name);
		public void set_size (int64 size);
		public void set_sort_order (int32 sort_order);
		public void set_symlink_target (string symlink_target);
		public void unset_attribute_mask ();
	}
	[CCode (cheader_filename = "gio/gio.h")]
	[Compact]
	public class FileInfoClass {
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class FileInputStream : GLib.InputStream, GLib.Seekable {
		[CCode (has_construct_function = false)]
		protected FileInputStream ();
		[NoWrapper]
		public virtual bool can_seek ();
		public virtual unowned GLib.FileInfo query_info (string attributes, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public virtual async unowned GLib.FileInfo query_info_async (string attributes, int io_priority = GLib.Priority.DEFAULT, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[NoWrapper]
		public virtual bool seek (int64 offset, GLib.SeekType type, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[NoWrapper]
		public virtual int64 tell ();
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class FileMonitor : GLib.Object {
		[CCode (has_construct_function = false)]
		protected FileMonitor ();
		public virtual bool cancel ();
		public void emit_event (GLib.File child, GLib.File other_file, GLib.FileMonitorEvent event_type);
		public bool is_cancelled ();
		public void set_rate_limit (int limit_msecs);
		[NoAccessorMethod]
		public bool cancelled { get; }
		[NoAccessorMethod]
		public int rate_limit { get; set; }
		public virtual signal void changed (GLib.File file, GLib.File? other_file, GLib.FileMonitorEvent event_type);
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class FileOutputStream : GLib.OutputStream, GLib.Seekable {
		[CCode (has_construct_function = false)]
		protected FileOutputStream ();
		[NoWrapper]
		public virtual bool can_seek ();
		[NoWrapper]
		public virtual bool can_truncate ();
		public virtual unowned string get_etag ();
		public virtual unowned GLib.FileInfo query_info (string attributes, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public virtual async unowned GLib.FileInfo query_info_async (string attributes, int io_priority = GLib.Priority.DEFAULT, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[NoWrapper]
		public virtual bool seek (int64 offset, GLib.SeekType type, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[NoWrapper]
		public virtual int64 tell ();
		[NoWrapper]
		public virtual bool truncate_fn (int64 size, GLib.Cancellable? cancellable = null) throws GLib.Error;
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class FilenameCompleter : GLib.Object {
		[CCode (has_construct_function = false)]
		public FilenameCompleter ();
		public unowned string get_completion_suffix (string initial_text);
		public unowned string get_completions (string initial_text);
		public void set_dirs_only (bool dirs_only);
		public virtual signal void got_completion_data ();
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class FilterInputStream : GLib.InputStream {
		[CCode (has_construct_function = false)]
		protected FilterInputStream ();
		public unowned GLib.InputStream get_base_stream ();
		public bool get_close_base_stream ();
		public void set_close_base_stream (bool close_base);
		public GLib.InputStream base_stream { get; construct; }
		public bool close_base_stream { get; set construct; }
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class FilterOutputStream : GLib.OutputStream {
		[CCode (has_construct_function = false)]
		protected FilterOutputStream ();
		public unowned GLib.OutputStream get_base_stream ();
		public bool get_close_base_stream ();
		public void set_close_base_stream (bool close_base);
		public GLib.OutputStream base_stream { get; construct; }
		public bool close_base_stream { get; construct; }
	}
	[CCode (cheader_filename = "gio/gio.h", cname = "GIOExtension")]
	[Compact]
	public class IOExtension {
		public unowned string get_name ();
		public int get_priority ();
		public GLib.Type get_type ();
		public unowned GLib.TypeClass ref_class ();
	}
	[CCode (cheader_filename = "gio/gio.h")]
	[Compact]
	public class IOExtensionPoint {
		public unowned GLib.IOExtension get_extension_by_name (string name);
		public unowned GLib.List<GLib.IOExtension> get_extensions ();
		public GLib.Type get_required_type ();
		public static unowned GLib.IOExtension implement (string extension_point_name, GLib.Type type, string extension_name, int priority);
		public static unowned GLib.IOExtensionPoint lookup (string name);
		public static unowned GLib.IOExtensionPoint register (string name);
		public void set_required_type (GLib.Type type);
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class IOModule : GLib.TypeModule, GLib.TypePlugin {
		[CCode (has_construct_function = false)]
		public IOModule (string filename);
		public void load ();
		public static unowned string query ();
		public void unload ();
	}
	[CCode (cheader_filename = "gio/gio.h")]
	[Compact]
	public class IOModuleClass {
	}
	[CCode (cheader_filename = "gio/gio.h")]
	[Compact]
	public class IOSchedulerJob {
		public bool send_to_mainloop (owned GLib.SourceFunc func);
		public void send_to_mainloop_async (owned GLib.SourceFunc func);
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class IOStream : GLib.Object {
		[CCode (has_construct_function = false)]
		protected IOStream ();
		public void clear_pending ();
		public bool close (GLib.Cancellable? cancellable = null) throws GLib.IOError;
		public virtual async bool close_async (int io_priority = GLib.Priority.DEFAULT, GLib.Cancellable? cancellable = null) throws GLib.IOError;
		[NoWrapper]
		public virtual bool close_fn (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public virtual unowned GLib.InputStream get_input_stream ();
		public virtual unowned GLib.OutputStream get_output_stream ();
		public bool has_pending ();
		public bool is_closed ();
		public bool set_pending () throws GLib.Error;
		public async bool splice_async (GLib.IOStream stream2, GLib.IOStreamSpliceFlags flags, int io_priority = GLib.Priority.DEFAULT, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[NoAccessorMethod]
		public bool closed { get; set; }
		public GLib.InputStream input_stream { get; }
		public GLib.OutputStream output_stream { get; }
	}
	[CCode (cheader_filename = "gio/gio.h")]
	[Compact]
	public class IOStreamAdapter {
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class InetAddress : GLib.Object {
		[CCode (has_construct_function = false)]
		protected InetAddress ();
		[CCode (has_construct_function = false)]
		public InetAddress.any (GLib.SocketFamily family);
		public bool equal (GLib.InetAddress other_address);
		[CCode (has_construct_function = false)]
		public InetAddress.from_bytes ([CCode (array_length = false)] uint8[] bytes, GLib.SocketFamily family);
		[CCode (has_construct_function = false)]
		public InetAddress.from_string (string str);
		public GLib.SocketFamily get_family ();
		public bool get_is_any ();
		public bool get_is_link_local ();
		public bool get_is_loopback ();
		public bool get_is_mc_global ();
		public bool get_is_mc_link_local ();
		public bool get_is_mc_node_local ();
		public bool get_is_mc_org_local ();
		public bool get_is_mc_site_local ();
		public bool get_is_multicast ();
		public bool get_is_site_local ();
		public size_t get_native_size ();
		[CCode (has_construct_function = false)]
		public InetAddress.loopback (GLib.SocketFamily family);
		[CCode (array_length = false)]
		public virtual unowned uint8[] to_bytes ();
		public virtual string to_string ();
		[NoAccessorMethod]
		public void* bytes { get; construct; }
		public GLib.SocketFamily family { get; construct; }
		public bool is_any { get; }
		public bool is_link_local { get; }
		public bool is_loopback { get; }
		public bool is_mc_global { get; }
		public bool is_mc_link_local { get; }
		public bool is_mc_node_local { get; }
		public bool is_mc_org_local { get; }
		public bool is_mc_site_local { get; }
		public bool is_multicast { get; }
		public bool is_site_local { get; }
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class InetSocketAddress : GLib.SocketAddress, GLib.SocketConnectable {
		[CCode (has_construct_function = false, type = "GSocketAddress*")]
		public InetSocketAddress (GLib.InetAddress address, uint16 port);
		public unowned GLib.InetAddress get_address ();
		public uint16 get_port ();
		public GLib.InetAddress address { get; construct; }
		public uint port { get; construct; }
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class InputStream : GLib.Object {
		[CCode (has_construct_function = false)]
		protected InputStream ();
		public void clear_pending ();
		public bool close (GLib.Cancellable? cancellable = null) throws GLib.IOError;
		public virtual async bool close_async (int io_priority = GLib.Priority.DEFAULT, GLib.Cancellable? cancellable = null) throws GLib.IOError;
		[NoWrapper]
		public virtual bool close_fn (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public bool has_pending ();
		public bool is_closed ();
		[CCode (vfunc_name = "read_fn")]
		public virtual ssize_t read ([CCode (array_length_type = "gsize")] uint8[] buffer, GLib.Cancellable? cancellable = null) throws GLib.IOError;
		public bool read_all ([CCode (array_length_type = "gsize")] uint8[] buffer, out size_t bytes_read, GLib.Cancellable? cancellable = null) throws GLib.IOError;
		public virtual async ssize_t read_async ([CCode (array_length_type = "gsize")] uint8[] buffer, int io_priority = GLib.Priority.DEFAULT, GLib.Cancellable? cancellable = null) throws GLib.IOError;
		public bool set_pending () throws GLib.Error;
		public virtual ssize_t skip (size_t count, GLib.Cancellable? cancellable = null) throws GLib.IOError;
		public virtual async ssize_t skip_async (size_t count, int io_priority = GLib.Priority.DEFAULT, GLib.Cancellable? cancellable = null) throws GLib.IOError;
	}
	[CCode (cheader_filename = "gio/gio.h")]
	[Compact]
	public class InputVector {
		[CCode (array_length_cname = "size", array_length_type = "gsize")]
		public uint8[] buffer;
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class MemoryInputStream : GLib.InputStream, GLib.Seekable {
		[CCode (has_construct_function = false, type = "GInputStream*")]
		public MemoryInputStream ();
		public void add_data ([CCode (array_length_type = "gsize")] owned uint8[] data, GLib.DestroyNotify? destroy);
		[CCode (has_construct_function = false, type = "GInputStream*")]
		public MemoryInputStream.from_data ([CCode (array_length_type = "gsize")] owned uint8[] data, GLib.DestroyNotify? destroy);
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class MemoryOutputStream : GLib.OutputStream, GLib.Seekable {
		[CCode (has_construct_function = false, type = "GOutputStream*")]
		public MemoryOutputStream ([CCode (array_length_type = "gsize")] owned uint8[]? data, GLib.ReallocFunc? realloc_function, GLib.DestroyNotify? destroy_function);
		[CCode (array_length = false)]
		public unowned uint8[] get_data ();
		public size_t get_data_size ();
		public size_t get_size ();
		[CCode (array_length = false)]
		public uint8[] steal_data ();
		public void* data { get; construct; }
		public ulong data_size { get; }
		[NoAccessorMethod]
		public void* destroy_function { get; construct; }
		[NoAccessorMethod]
		public void* realloc_function { get; construct; }
		public ulong size { get; construct; }
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class MountOperation : GLib.Object {
		[CCode (has_construct_function = false)]
		public MountOperation ();
		public bool get_anonymous ();
		public int get_choice ();
		public unowned string get_domain ();
		public unowned string get_password ();
		public GLib.PasswordSave get_password_save ();
		public unowned string get_username ();
		public void set_anonymous (bool anonymous);
		public void set_choice (int choice);
		public void set_domain (string domain);
		public void set_password (string password);
		public void set_password_save (GLib.PasswordSave save);
		public void set_username (string username);
		public bool anonymous { get; set; }
		public int choice { get; set; }
		public string domain { get; set; }
		public string password { get; set; }
		public GLib.PasswordSave password_save { get; set; }
		public string username { get; set; }
		public virtual signal void aborted ();
		public virtual signal void ask_password (string message, string default_user, string default_domain, GLib.AskPasswordFlags flags);
		public virtual signal void ask_question (string message, string[] choices);
		[HasEmitter]
		public virtual signal void reply (GLib.MountOperationResult result);
		public virtual signal void show_processes (string message, GLib.Array processes, string[] choices);
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class NativeVolumeMonitor : GLib.VolumeMonitor {
		[CCode (has_construct_function = false)]
		protected NativeVolumeMonitor ();
		[NoWrapper]
		public virtual unowned GLib.Mount get_mount_for_mount_path (string mount_path, GLib.Cancellable? cancellable = null);
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class NetworkAddress : GLib.Object, GLib.SocketConnectable {
		[CCode (has_construct_function = false, type = "GSocketConnectable*")]
		public NetworkAddress (string hostname, uint16 port);
		public unowned string get_hostname ();
		public uint16 get_port ();
		public unowned string get_scheme ();
		public static unowned GLib.SocketConnectable parse (string host_and_port, uint16 default_port) throws GLib.Error;
		public static unowned GLib.SocketConnectable parse_uri (string uri, uint16 default_port) throws GLib.Error;
		public string hostname { get; construct; }
		public uint port { get; construct; }
		public string scheme { get; construct; }
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class NetworkService : GLib.Object, GLib.SocketConnectable {
		[CCode (has_construct_function = false, type = "GSocketConnectable*")]
		public NetworkService (string service, string protocol, string domain);
		public unowned string get_domain ();
		public unowned string get_protocol ();
		public unowned string get_scheme ();
		public unowned string get_service ();
		public void set_scheme (string scheme);
		public string domain { get; construct; }
		public string protocol { get; construct; }
		public string scheme { get; set; }
		public string service { get; construct; }
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class OutputStream : GLib.Object {
		[CCode (has_construct_function = false)]
		protected OutputStream ();
		public void clear_pending ();
		public bool close (GLib.Cancellable? cancellable = null) throws GLib.IOError;
		public virtual async bool close_async (int io_priority = GLib.Priority.DEFAULT, GLib.Cancellable? cancellable = null) throws GLib.IOError;
		[NoWrapper]
		public virtual bool close_fn (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public virtual bool flush (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public virtual async bool flush_async (int io_priority = GLib.Priority.DEFAULT, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public bool has_pending ();
		public bool is_closed ();
		public bool is_closing ();
		public bool set_pending () throws GLib.Error;
		public virtual ssize_t splice (GLib.InputStream source, GLib.OutputStreamSpliceFlags flags, GLib.Cancellable? cancellable = null) throws GLib.IOError;
		public virtual async ssize_t splice_async (GLib.InputStream source, GLib.OutputStreamSpliceFlags flags, int io_priority = GLib.Priority.DEFAULT, GLib.Cancellable? cancellable = null) throws GLib.IOError;
		[CCode (vfunc_name = "write_fn")]
		public virtual ssize_t write ([CCode (array_length_type = "gsize")] uint8[] buffer, GLib.Cancellable? cancellable = null) throws GLib.IOError;
		public bool write_all ([CCode (array_length_type = "gsize")] uint8[] buffer, out size_t bytes_written, GLib.Cancellable? cancellable = null) throws GLib.IOError;
		public virtual async ssize_t write_async ([CCode (array_length_type = "gsize")] uint8[] buffer, int io_priority = GLib.Priority.DEFAULT, GLib.Cancellable? cancellable = null) throws GLib.IOError;
	}
	[CCode (cheader_filename = "gio/gio.h")]
	[Compact]
	public class OutputVector {
		[CCode (array_length_cname = "size", array_length_type = "gsize")]
		public uint8[] buffer;
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class Permission : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Permission ();
		public virtual bool acquire (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public virtual async bool acquire_async (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public bool get_allowed ();
		public bool get_can_acquire ();
		public bool get_can_release ();
		public void impl_update (bool allowed, bool can_acquire, bool can_release);
		public virtual bool release (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public virtual async bool release_async (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public bool allowed { get; }
		public bool can_acquire { get; }
		public bool can_release { get; }
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class ProxyAddress : GLib.InetSocketAddress, GLib.SocketConnectable {
		[CCode (has_construct_function = false, type = "GSocketAddress*")]
		public ProxyAddress (GLib.InetAddress inetaddr, uint16 port, string protocol, string dest_hostname, uint16 dest_port, string username, string password);
		public unowned string get_destination_hostname ();
		public uint16 get_destination_port ();
		public unowned string get_password ();
		public unowned string get_protocol ();
		public unowned string get_username ();
		public string destination_hostname { get; construct; }
		public uint destination_port { get; construct; }
		public string password { get; construct; }
		public string protocol { get; construct; }
		public string username { get; construct; }
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class ProxyAddressEnumerator : GLib.SocketAddressEnumerator {
		[CCode (has_construct_function = false)]
		protected ProxyAddressEnumerator ();
		[NoAccessorMethod]
		public GLib.SocketConnectable connectable { owned get; construct; }
		[NoAccessorMethod]
		public string uri { owned get; construct; }
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class Resolver : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Resolver ();
		public static GLib.Quark error_quark ();
		public static unowned GLib.Resolver get_default ();
		public virtual unowned string lookup_by_address (GLib.InetAddress address, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public virtual async unowned string lookup_by_address_async (GLib.InetAddress address, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public virtual GLib.List<GLib.InetAddress> lookup_by_name (string hostname, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public virtual async GLib.List<GLib.InetAddress> lookup_by_name_async (string hostname, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public virtual GLib.List<GLib.SrvTarget> lookup_service (string service, string protocol, string domain, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public virtual async GLib.List<GLib.SrvTarget> lookup_service_async (string service, string protocol, string domain, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public void set_default ();
		public virtual signal void reload ();
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class Settings : GLib.Object {
		[CCode (has_construct_function = false)]
		public Settings (string schema);
		public void apply ();
		public void bind (string key, void* object, string property, GLib.SettingsBindFlags flags);
		public void bind_with_mapping (string key, void* object, string property, GLib.SettingsBindFlags flags, GLib.SettingsBindGetMapping get_mapping, GLib.SettingsBindSetMapping set_mapping, GLib.DestroyNotify destroy);
		public void bind_writable (string key, void* object, string property, bool inverted);
		public void delay ();
		[CCode (sentinel = "")]
		public void @get (string key, string format, ...);
		public bool get_boolean (string key);
		public unowned GLib.Settings get_child (string name);
		public double get_double (string key);
		public int get_enum (string key);
		public uint get_flags (string key);
		public bool get_has_unapplied ();
		public int get_int (string key);
		public void* get_mapped (string key, GLib.SettingsGetMapping mapping);
		public unowned GLib.Variant get_range (string key);
		public string get_string (string key);
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] get_strv (string key);
		public uint get_uint (string key);
		public GLib.Variant get_value (string key);
		public bool is_writable (string name);
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] list_children ();
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] list_keys ();
		public static unowned string list_relocatable_schemas ();
		[CCode (array_length = false, array_null_terminated = true)]
		public static unowned string[] list_schemas ();
		public bool range_check (string key, GLib.Variant value);
		public void reset (string key);
		public void revert ();
		[CCode (sentinel = "")]
		public bool @set (string key, string format, ...);
		public bool set_boolean (string key, bool value);
		public bool set_double (string key, double value);
		public bool set_enum (string key, int value);
		public bool set_flags (string key, uint value);
		public bool set_int (string key, int value);
		public bool set_string (string key, string value);
		public bool set_strv (string key, [CCode (array_length = false)] string[] value);
		public bool set_uint (string key, uint value);
		public bool set_value (string key, GLib.Variant value);
		public static void sync ();
		public static void unbind (void* object, string property);
		[CCode (has_construct_function = false)]
		public Settings.with_backend (string schema, GLib.SettingsBackend backend);
		[CCode (has_construct_function = false)]
		public Settings.with_backend_and_path (string schema, GLib.SettingsBackend backend, string path);
		[CCode (has_construct_function = false)]
		public Settings.with_path (string schema, string path);
		[NoAccessorMethod]
		public GLib.SettingsBackend backend { owned get; construct; }
		[NoAccessorMethod]
		public bool delay_apply { get; }
		public bool has_unapplied { get; }
		[NoAccessorMethod]
		public string path { owned get; construct; }
		[NoAccessorMethod]
		public string schema { owned get; construct; }
		public virtual signal bool change_event (void* keys, int n_keys);
		public virtual signal void changed (string key);
		public virtual signal bool writable_change_event (uint key);
		public virtual signal void writable_changed (string key);
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class SettingsBackend : GLib.Object {
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class SimpleAction : GLib.Object, GLib.Action {
		[CCode (has_construct_function = false)]
		public SimpleAction (string name, GLib.VariantType parameter_type);
		public void set_enabled (bool enabled);
		public void set_state (GLib.Variant value);
		[CCode (has_construct_function = false)]
		public SimpleAction.stateful (string name, GLib.VariantType parameter_type, GLib.Variant state);
		[NoAccessorMethod]
		public bool enabled { get; }
		[NoAccessorMethod]
		public string name { owned get; }
		[NoAccessorMethod]
		public GLib.VariantType parameter_type { owned get; }
		[NoAccessorMethod]
		public GLib.Variant state { owned get; }
		[NoAccessorMethod]
		public GLib.VariantType state_type { owned get; }
		public virtual signal void activate (GLib.Variant p0);
		public virtual signal void change_state (GLib.Variant p0);
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class SimpleActionGroup : GLib.Object, GLib.ActionGroup {
		[CCode (has_construct_function = false)]
		public SimpleActionGroup ();
		public void add_entries (GLib.ActionEntry[] entries);
		public void insert (GLib.Action action);
		public unowned GLib.Action lookup (string action_name);
		public void remove (string action_name);
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class SimpleAsyncResult : GLib.Object, GLib.AsyncResult {
		[CCode (has_construct_function = false)]
		public SimpleAsyncResult (GLib.Object? source_object, GLib.AsyncReadyCallback callback, void* source_tag);
		public void complete ();
		public void complete_in_idle ();
		[CCode (has_construct_function = false)]
		public SimpleAsyncResult.error (GLib.Object source_object, GLib.AsyncReadyCallback callback, GLib.Quark domain, int code, string format);
		[CCode (has_construct_function = false)]
		public SimpleAsyncResult.from_error (GLib.Object source_object, GLib.AsyncReadyCallback callback, GLib.Error error);
		public bool get_op_res_gboolean ();
		public void* get_op_res_gpointer ();
		public ssize_t get_op_res_gssize ();
		public void* get_source_tag ();
		public static bool is_valid (GLib.AsyncResult _result, GLib.Object source, void* source_tag);
		public bool propagate_error () throws GLib.Error;
		public void run_in_thread (GLib.SimpleAsyncThreadFunc func, int io_priority = GLib.Priority.DEFAULT, GLib.Cancellable? cancellable = null);
		public void set_error (GLib.Quark domain, int code, string format);
		public void set_error_va (GLib.Quark domain, int code, string format, void* args);
		public void set_from_error (GLib.Error error);
		public void set_handle_cancellation (bool handle_cancellation);
		public void set_op_res_gboolean (bool op_res);
		public void set_op_res_gpointer (void* op_res, GLib.DestroyNotify destroy_op_res);
		public void set_op_res_gssize (ssize_t op_res);
		public void take_error (GLib.Error error);
	}
	[CCode (cheader_filename = "gio/gio.h")]
	[Compact]
	public class SimpleAsyncResultClass {
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class SimplePermission : GLib.Permission {
		[CCode (has_construct_function = false, type = "GPermission*")]
		public SimplePermission (bool allowed);
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class Socket : GLib.Object, GLib.Initable {
		[CCode (has_construct_function = false)]
		public Socket (GLib.SocketFamily family, GLib.SocketType type, GLib.SocketProtocol protocol) throws GLib.Error;
		public GLib.Socket accept (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public bool bind (GLib.SocketAddress address, bool allow_reuse) throws GLib.Error;
		public bool check_connect_result () throws GLib.Error;
		public bool close () throws GLib.Error;
		public GLib.IOCondition condition_check (GLib.IOCondition condition);
		public bool condition_wait (GLib.IOCondition condition, GLib.Cancellable? cancellable = null) throws GLib.IOError;
		public bool connect (GLib.SocketAddress address, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public GLib.SocketSource create_source (GLib.IOCondition condition, GLib.Cancellable? cancellable = null);
		[CCode (has_construct_function = false)]
		public Socket.from_fd (int fd) throws GLib.Error;
		public bool get_blocking ();
		public unowned GLib.Credentials get_credentials () throws GLib.Error;
		public GLib.SocketFamily get_family ();
		public int get_fd ();
		public bool get_keepalive ();
		public int get_listen_backlog ();
		public unowned GLib.SocketAddress get_local_address () throws GLib.Error;
		public GLib.SocketProtocol get_protocol ();
		public unowned GLib.SocketAddress get_remote_address () throws GLib.Error;
		public GLib.SocketType get_socket_type ();
		public uint get_timeout ();
		public bool is_closed ();
		public bool is_connected ();
		public bool listen () throws GLib.Error;
		public ssize_t receive (uint8[] buffer, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public ssize_t receive_from (out unowned GLib.SocketAddress address, uint8[] buffer, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public ssize_t receive_message (out unowned GLib.SocketAddress address, GLib.InputVector vectors, int num_vectors, out unowned GLib.SocketControlMessage messages, int num_messages, int flags, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public ssize_t receive_with_blocking (uint8[] buffer, bool blocking, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public ssize_t send (uint8[] buffer, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public ssize_t send_message (GLib.SocketAddress address, GLib.OutputVector vectors, int num_vectors, out unowned GLib.SocketControlMessage messages, int num_messages, int flags, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public ssize_t send_to (GLib.SocketAddress address, uint8[] buffer, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public ssize_t send_with_blocking (uint8[] buffer, bool blocking, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public void set_blocking (bool blocking);
		public void set_keepalive (bool keepalive);
		public void set_listen_backlog (int backlog);
		public void set_timeout (uint timeout);
		public bool shutdown (bool shutdown_read, bool shutdown_write) throws GLib.Error;
		public bool speaks_ipv4 ();
		public bool blocking { get; set; }
		public GLib.SocketFamily family { get; construct; }
		public int fd { get; construct; }
		public bool keepalive { get; set; }
		public int listen_backlog { get; set; }
		public GLib.SocketAddress local_address { get; }
		public GLib.SocketProtocol protocol { get; construct; }
		public GLib.SocketAddress remote_address { get; }
		public uint timeout { get; set; }
		[NoAccessorMethod]
		public GLib.SocketType type { get; construct; }
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class SocketAddress : GLib.Object, GLib.SocketConnectable {
		[CCode (has_construct_function = false)]
		protected SocketAddress ();
		[CCode (has_construct_function = false)]
		public SocketAddress.from_native (void* native, size_t len);
		public virtual GLib.SocketFamily get_family ();
		public virtual ssize_t get_native_size ();
		public virtual bool to_native (void* dest, size_t destlen) throws GLib.Error;
		public GLib.SocketFamily family { get; }
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class SocketAddressEnumerator : GLib.Object {
		[CCode (has_construct_function = false)]
		protected SocketAddressEnumerator ();
		public virtual unowned GLib.SocketAddress next (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public virtual async unowned GLib.SocketAddress next_async (GLib.Cancellable? cancellable = null) throws GLib.Error;
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class SocketClient : GLib.Object {
		[CCode (has_construct_function = false)]
		public SocketClient ();
		public void add_application_proxy (string protocol);
		public unowned GLib.SocketConnection connect (GLib.SocketConnectable connectable, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public async unowned GLib.SocketConnection connect_async (GLib.SocketConnectable connectable, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public unowned GLib.SocketConnection connect_to_host (string host_and_port, uint16 default_port, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public async unowned GLib.SocketConnection connect_to_host_async (string host_and_port, uint16 default_port, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public unowned GLib.SocketConnection connect_to_service (string domain, string service, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public async unowned GLib.SocketConnection connect_to_service_async (string domain, string service, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public unowned GLib.SocketConnection connect_to_uri (string uri, uint16 default_port, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public async unowned GLib.SocketConnection connect_to_uri_async (string uri, uint16 default_port, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public bool get_enable_proxy ();
		public GLib.SocketFamily get_family ();
		public unowned GLib.SocketAddress get_local_address ();
		public GLib.SocketProtocol get_protocol ();
		public GLib.SocketType get_socket_type ();
		public uint get_timeout ();
		public bool get_tls ();
		public GLib.TlsCertificateFlags get_tls_validation_flags ();
		public void set_enable_proxy (bool enable);
		public void set_family (GLib.SocketFamily family);
		public void set_local_address (GLib.SocketAddress address);
		public void set_protocol (GLib.SocketProtocol protocol);
		public void set_socket_type (GLib.SocketType type);
		public void set_timeout (uint timeout);
		public void set_tls (bool tls);
		public void set_tls_validation_flags (GLib.TlsCertificateFlags flags);
		public bool enable_proxy { get; set construct; }
		public GLib.SocketFamily family { get; set construct; }
		public GLib.SocketAddress local_address { get; set construct; }
		public GLib.SocketProtocol protocol { get; set construct; }
		public uint timeout { get; set construct; }
		public bool tls { get; set construct; }
		public GLib.TlsCertificateFlags tls_validation_flags { get; set construct; }
		[NoAccessorMethod]
		public GLib.SocketType type { get; set construct; }
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class SocketConnection : GLib.IOStream {
		[CCode (has_construct_function = false)]
		protected SocketConnection ();
		public static unowned GLib.SocketConnection factory_create_connection (GLib.Socket socket);
		public static GLib.Type factory_lookup_type (GLib.SocketFamily family, GLib.SocketType type, int protocol_id);
		public static void factory_register_type (GLib.Type g_type, GLib.SocketFamily family, GLib.SocketType type, int protocol);
		public unowned GLib.SocketAddress get_local_address () throws GLib.Error;
		public unowned GLib.SocketAddress get_remote_address () throws GLib.Error;
		public unowned GLib.Socket get_socket ();
		public GLib.Socket socket { get; construct; }
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class SocketControlMessage : GLib.Object {
		[CCode (has_construct_function = false)]
		protected SocketControlMessage ();
		public virtual GLib.SocketControlMessage deserialize (int level, int type, [CCode (array_length_pos = 2.9, array_length_type = "gsize")] uint8[] data);
		public virtual int get_level ();
		public int get_msg_type ();
		public virtual size_t get_size ();
		[NoWrapper]
		public virtual int get_type ();
		public virtual void serialize ([CCode (array_length = false)] uint8[] data);
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class SocketListener : GLib.Object {
		[CCode (has_construct_function = false)]
		public SocketListener ();
		public unowned GLib.SocketConnection accept (out unowned GLib.Object source_object, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public async unowned GLib.SocketConnection accept_async (GLib.Cancellable? cancellable = null, out GLib.Object? source_object = null) throws GLib.Error;
		public unowned GLib.Socket accept_socket (out unowned GLib.Object source_object, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public async unowned GLib.Socket accept_socket_async (GLib.Cancellable? cancellable = null, out GLib.Object? source_object = null) throws GLib.Error;
		public bool add_address (GLib.SocketAddress address, GLib.SocketType type, GLib.SocketProtocol protocol, GLib.Object? source_object, out unowned GLib.SocketAddress effective_address) throws GLib.Error;
		public uint16 add_any_inet_port (GLib.Object source_object) throws GLib.Error;
		public bool add_inet_port (uint16 port, GLib.Object? source_object) throws GLib.Error;
		public bool add_socket (GLib.Socket socket, GLib.Object? source_object) throws GLib.Error;
		[NoWrapper]
		public virtual void changed ();
		public void close ();
		public void set_backlog (int listen_backlog);
		[NoAccessorMethod]
		public int listen_backlog { get; set construct; }
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class SocketService : GLib.SocketListener {
		[CCode (has_construct_function = false)]
		public SocketService ();
		public bool is_active ();
		public void start ();
		public void stop ();
		public virtual signal bool incoming (GLib.SocketConnection connection, GLib.Object? source_object);
	}
	[CCode (cheader_filename = "gio/gio.h", cname = "GSource", ref_function = "g_source_ref", unref_function = "g_source_unref")]
	[Compact]
	public class SocketSource : GLib.Source {
		[CCode (cname = "g_source_set_callback")]
		public void set_callback ([CCode (type = "GSourceFunc")] owned GLib.SocketSourceFunc func);
	}
	[CCode (cheader_filename = "gio/gio.h", copy_function = "g_srv_target_copy")]
	[Compact]
	public class SrvTarget {
		[CCode (has_construct_function = false)]
		public SrvTarget (string hostname, uint16 port, uint16 priority, uint16 weight);
		public GLib.SrvTarget copy ();
		public unowned string get_hostname ();
		public uint16 get_port ();
		public uint16 get_priority ();
		public uint16 get_weight ();
		public static GLib.List<GLib.SrvTarget> list_sort (owned GLib.List<GLib.SrvTarget> targets);
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class TcpConnection : GLib.SocketConnection {
		[CCode (has_construct_function = false)]
		protected TcpConnection ();
		public bool get_graceful_disconnect ();
		public void set_graceful_disconnect (bool graceful_disconnect);
		public bool graceful_disconnect { get; set; }
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class TcpWrapperConnection : GLib.TcpConnection {
		[CCode (has_construct_function = false, type = "GSocketConnection*")]
		public TcpWrapperConnection (GLib.IOStream base_io_stream, GLib.Socket socket);
		public unowned GLib.IOStream get_base_io_stream ();
		public GLib.IOStream base_io_stream { get; construct; }
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class ThemedIcon : GLib.Object, GLib.Icon {
		[CCode (has_construct_function = false, type = "GIcon*")]
		public ThemedIcon (string iconname);
		public void append_name (string iconname);
		[CCode (has_construct_function = false, type = "GIcon*")]
		public ThemedIcon.from_names (string[] iconnames);
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[] get_names ();
		public void prepend_name (string iconname);
		[CCode (has_construct_function = false, type = "GIcon*")]
		public ThemedIcon.with_default_fallbacks (string iconname);
		public string name { construct; }
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] names { get; construct; }
		[NoAccessorMethod]
		public bool use_default_fallbacks { get; construct; }
	}
	[CCode (cheader_filename = "gio/gio.h")]
	[Compact]
	public class ThemedIconClass {
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class ThreadedSocketService : GLib.SocketService {
		[CCode (has_construct_function = false, type = "GSocketService*")]
		public ThreadedSocketService (int max_threads);
		[NoAccessorMethod]
		public int max_threads { get; construct; }
		public virtual signal bool run (GLib.SocketConnection connection, GLib.Object source_object);
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class TimeZoneMonitor : GLib.Object {
		[CCode (has_construct_function = false)]
		protected TimeZoneMonitor ();
		public static unowned GLib.TimeZoneMonitor @get ();
		public virtual signal void changed ();
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class TlsCertificate : GLib.Object {
		[CCode (has_construct_function = false)]
		protected TlsCertificate ();
		[CCode (has_construct_function = false)]
		public TlsCertificate.from_file (string file) throws GLib.Error;
		[CCode (has_construct_function = false)]
		public TlsCertificate.from_files (string cert_file, string key_file) throws GLib.Error;
		[CCode (has_construct_function = false)]
		public TlsCertificate.from_pem (string data, ssize_t length) throws GLib.Error;
		public unowned GLib.TlsCertificate get_issuer ();
		public static unowned GLib.List list_new_from_file (string file) throws GLib.Error;
		public virtual GLib.TlsCertificateFlags verify (GLib.SocketConnectable identity, GLib.TlsCertificate trusted_ca);
		[NoAccessorMethod]
		public GLib.ByteArray certificate { owned get; construct; }
		[NoAccessorMethod]
		public string certificate_pem { owned get; construct; }
		public GLib.TlsCertificate issuer { get; construct; }
		public GLib.ByteArray private_key { construct; }
		public string private_key_pem { construct; }
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class TlsConnection : GLib.IOStream {
		[CCode (has_construct_function = false)]
		protected TlsConnection ();
		public bool emit_accept_certificate (GLib.TlsCertificate peer_cert, GLib.TlsCertificateFlags errors);
		public unowned GLib.TlsCertificate get_certificate ();
		public unowned GLib.TlsCertificate get_peer_certificate ();
		public GLib.TlsCertificateFlags get_peer_certificate_errors ();
		public GLib.TlsRehandshakeMode get_rehandshake_mode ();
		public bool get_require_close_notify ();
		public bool get_use_system_certdb ();
		public virtual bool handshake (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public virtual async bool handshake_async (int io_priority = GLib.Priority.DEFAULT, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public void set_certificate (GLib.TlsCertificate certificate);
		public void set_rehandshake_mode (GLib.TlsRehandshakeMode mode);
		public void set_require_close_notify (bool require_close_notify);
		public void set_use_system_certdb (bool use_system_certdb);
		[NoAccessorMethod]
		public GLib.IOStream base_io_stream { owned get; construct; }
		public GLib.TlsCertificate certificate { get; set; }
		public GLib.TlsCertificate peer_certificate { get; }
		public GLib.TlsCertificateFlags peer_certificate_errors { get; }
		public GLib.TlsRehandshakeMode rehandshake_mode { get; set construct; }
		public bool require_close_notify { get; set construct; }
		public bool use_system_certdb { get; set construct; }
		public virtual signal bool accept_certificate (GLib.TlsCertificate peer_cert, GLib.TlsCertificateFlags errors);
	}
	[CCode (cheader_filename = "gio/gio.h")]
	[Compact]
	public class UnixCredentialsMessage {
	}
	[CCode (cheader_filename = "gio/gio.h")]
	[Compact]
	public class UnixFDList {
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class Vfs : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Vfs ();
		[NoWrapper]
		public virtual void add_writable_namespaces (GLib.FileAttributeInfoList list);
		public static unowned GLib.Vfs get_default ();
		public virtual GLib.File get_file_for_path (string path);
		public virtual GLib.File get_file_for_uri (string uri);
		public static unowned GLib.Vfs get_local ();
		public virtual unowned string[] get_supported_uri_schemes ();
		public virtual bool is_active ();
		[NoWrapper]
		public virtual void local_file_add_info (string filename, uint64 device, GLib.FileAttributeMatcher attribute_matcher, GLib.FileInfo info, GLib.Cancellable? cancellable = null, void* extra_data = null, GLib.DestroyNotify? free_extra_data = null);
		[NoWrapper]
		public virtual void local_file_moved (string source, string dest);
		[NoWrapper]
		public virtual void local_file_removed (string filename);
		[NoWrapper]
		public virtual bool local_file_set_attributes (string filename, GLib.FileInfo info, GLib.FileQueryInfoFlags flags, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public virtual unowned GLib.File parse_name (string parse_name);
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class VolumeMonitor : GLib.Object {
		[CCode (has_construct_function = false)]
		protected VolumeMonitor ();
		public virtual unowned GLib.Volume adopt_orphan_mount (GLib.Mount mount);
		public static GLib.VolumeMonitor @get ();
		public virtual GLib.List<GLib.Drive> get_connected_drives ();
		public virtual GLib.Mount get_mount_for_uuid (string uuid);
		public virtual GLib.List<GLib.Mount> get_mounts ();
		public virtual GLib.Volume get_volume_for_uuid (string uuid);
		public virtual GLib.List<GLib.Volume> get_volumes ();
		[NoWrapper]
		public virtual bool is_supported ();
		public virtual signal void drive_changed (GLib.Drive drive);
		public virtual signal void drive_connected (GLib.Drive drive);
		public virtual signal void drive_disconnected (GLib.Drive drive);
		public virtual signal void drive_eject_button (GLib.Drive drive);
		public virtual signal void drive_stop_button (GLib.Drive drive);
		public virtual signal void mount_added (GLib.Mount mount);
		public virtual signal void mount_changed (GLib.Mount mount);
		public virtual signal void mount_pre_unmount (GLib.Mount mount);
		public virtual signal void mount_removed (GLib.Mount mount);
		public virtual signal void volume_added (GLib.Volume volume);
		public virtual signal void volume_changed (GLib.Volume volume);
		public virtual signal void volume_removed (GLib.Volume volume);
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class ZlibCompressor : GLib.Object, GLib.Converter {
		[CCode (has_construct_function = false)]
		public ZlibCompressor (GLib.ZlibCompressorFormat format, int level = -1);
		public unowned GLib.FileInfo get_file_info ();
		public void set_file_info (GLib.FileInfo file_info);
		public GLib.FileInfo file_info { get; set; }
		[NoAccessorMethod]
		public GLib.ZlibCompressorFormat format { get; construct; }
		[NoAccessorMethod]
		public int level { get; construct; }
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class ZlibDecompressor : GLib.Object, GLib.Converter {
		[CCode (has_construct_function = false)]
		public ZlibDecompressor (GLib.ZlibCompressorFormat format);
		public unowned GLib.FileInfo get_file_info ();
		public GLib.FileInfo file_info { get; }
		[NoAccessorMethod]
		public GLib.ZlibCompressorFormat format { get; construct; }
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public interface Action : GLib.Object {
		public abstract void activate (GLib.Variant parameter);
		public abstract void change_state (GLib.Variant value);
		public abstract bool get_enabled ();
		public abstract unowned string get_name ();
		public abstract unowned GLib.VariantType get_parameter_type ();
		public abstract unowned GLib.Variant get_state ();
		public abstract unowned GLib.Variant get_state_hint ();
		public abstract unowned GLib.VariantType get_state_type ();
		public bool enabled { get; }
		public string name { get; }
		public GLib.VariantType parameter_type { get; }
		public GLib.Variant state { get; }
		public GLib.VariantType state_type { get; }
	}
	[CCode (cheader_filename = "gio/gio.h", type_cname = "GActionGroupInterface")]
	public interface ActionGroup : GLib.Object {
		public abstract void activate_action (string action_name, GLib.Variant? parameter);
		public abstract void change_action_state (string action_name, GLib.Variant value);
		public abstract bool get_action_enabled (string action_name);
		public abstract unowned GLib.VariantType? get_action_parameter_type (string action_name);
		public abstract GLib.Variant? get_action_state (string action_name);
		public abstract GLib.Variant? get_action_state_hint (string action_name);
		public abstract unowned GLib.VariantType? get_action_state_type (string action_name);
		public abstract bool has_action (string action_name);
		[CCode (array_length = false, array_null_terminated = true)]
		public abstract string[] list_actions ();
		[HasEmitter]
		public signal void action_added (string action_name);
		[HasEmitter]
		public signal void action_enabled_changed (string action_name, bool enabled);
		[HasEmitter]
		public signal void action_removed (string action_name);
		[HasEmitter]
		public signal void action_state_changed (string action_name, GLib.Variant value);
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public interface AppInfo : GLib.Object {
		public abstract bool add_supports_type (string content_type) throws GLib.Error;
		public abstract bool can_delete ();
		public abstract bool can_remove_supports_type ();
		public static unowned GLib.AppInfo create_from_commandline (string commandline, string? application_name, GLib.AppInfoCreateFlags flags) throws GLib.Error;
		public bool @delete ();
		[NoWrapper]
		public abstract bool do_delete ();
		public abstract unowned GLib.AppInfo dup ();
		public abstract bool equal (GLib.AppInfo appinfo2);
		public static GLib.List<GLib.AppInfo> get_all ();
		public static GLib.List<GLib.AppInfo> get_all_for_type (string content_type);
		public abstract unowned string get_commandline ();
		public static unowned GLib.AppInfo get_default_for_type (string content_type, bool must_support_uris);
		public static unowned GLib.AppInfo get_default_for_uri_scheme (string uri_scheme);
		public abstract unowned string get_description ();
		public abstract unowned string get_display_name ();
		public abstract unowned string get_executable ();
		public static unowned GLib.List get_fallback_for_type (string content_type);
		public abstract unowned GLib.Icon get_icon ();
		public abstract unowned string get_id ();
		public abstract unowned string get_name ();
		public static unowned GLib.List get_recommended_for_type (string content_type);
		public abstract bool launch (GLib.List<GLib.File>? files, GLib.AppLaunchContext? launch_context) throws GLib.Error;
		public static bool launch_default_for_uri (string uri, GLib.AppLaunchContext? launch_context) throws GLib.Error;
		public abstract bool launch_uris (GLib.List<string>? uris, GLib.AppLaunchContext launch_context) throws GLib.Error;
		public abstract bool remove_supports_type (string content_type) throws GLib.Error;
		public static void reset_type_associations (string content_type);
		public abstract bool set_as_default_for_extension (string extension) throws GLib.Error;
		public abstract bool set_as_default_for_type (string content_type) throws GLib.Error;
		public abstract bool set_as_last_used_for_type (string content_type) throws GLib.Error;
		public abstract bool should_show ();
		public abstract bool supports_files ();
		public abstract bool supports_uris ();
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public interface AsyncInitable : GLib.Object {
		public abstract async bool init_async (int io_priority = GLib.Priority.DEFAULT, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public static async unowned GLib.Object new_async (GLib.Type object_type, int io_priority = GLib.Priority.DEFAULT, GLib.Cancellable? cancellable, ...) throws GLib.Error;
		public static async void new_valist_async (GLib.Type object_type, string first_property_name, void* var_args, int io_priority = GLib.Priority.DEFAULT, GLib.Cancellable? cancellable = null);
		public static async void newv_async (GLib.Type object_type, uint n_parameters, GLib.Parameter parameters, int io_priority = GLib.Priority.DEFAULT, GLib.Cancellable? cancellable = null);
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public interface AsyncResult : GLib.Object {
		public abstract unowned GLib.Object get_source_object ();
		public abstract void* get_user_data ();
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public interface Converter : GLib.Object {
		public abstract GLib.ConverterResult convert ([CCode (array_length_type = "gsize")] uint8[] inbuf, [CCode (array_length_type = "gsize")] uint8[] outbuf, GLib.ConverterFlags flags, out size_t bytes_read, out size_t bytes_written) throws GLib.Error;
		public abstract void reset ();
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public interface DBusInterface : GLib.Object {
		public abstract unowned GLib.DBusInterfaceInfo get_info ();
		public abstract unowned GLib.DBusObject get_object ();
		public abstract void set_object (GLib.DBusObject object);
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public interface DBusObject : GLib.Object {
		public abstract unowned GLib.DBusInterface get_interface (string interface_name);
		public abstract GLib.List<GLib.DBusInterface> get_interfaces ();
		public abstract unowned string get_object_path ();
		public signal void interface_added (GLib.DBusInterface interface_);
		public signal void interface_removed (GLib.DBusInterface interface_);
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public interface DBusObjectManager : GLib.Object {
		public abstract unowned GLib.DBusInterface get_interface (string object_path, string interface_name);
		public abstract unowned GLib.DBusObject get_object (string object_path);
		public abstract unowned string get_object_path ();
		public abstract unowned GLib.List get_objects ();
		public signal void interface_added (GLib.DBusObject object, GLib.DBusInterface interface_);
		public signal void interface_removed (GLib.DBusObject object, GLib.DBusInterface interface_);
		public signal void object_added (GLib.DBusObject object);
		public signal void object_removed (GLib.DBusObject object);
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public interface Drive : GLib.Object {
		public abstract bool can_eject ();
		public abstract bool can_poll_for_media ();
		public abstract bool can_start ();
		public abstract bool can_start_degraded ();
		public abstract bool can_stop ();
		public abstract async bool eject (GLib.MountUnmountFlags flags, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public abstract async bool eject_with_operation (GLib.MountUnmountFlags flags, GLib.MountOperation? mount_operation, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public abstract unowned string enumerate_identifiers ();
		public abstract unowned GLib.Icon get_icon ();
		public abstract unowned string get_identifier (string kind);
		public abstract unowned string get_name ();
		public abstract GLib.DriveStartStopType get_start_stop_type ();
		public abstract GLib.List<GLib.Volume> get_volumes ();
		public abstract bool has_media ();
		public abstract bool has_volumes ();
		public abstract bool is_media_check_automatic ();
		public abstract bool is_media_removable ();
		public abstract async bool poll_for_media (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public abstract async bool start (GLib.DriveStartFlags flags, GLib.MountOperation? mount_operation, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public abstract async bool stop (GLib.MountUnmountFlags flags, GLib.MountOperation? mount_operation, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public signal void changed ();
		public signal void disconnected ();
		public signal void eject_button ();
		public signal void stop_button ();
	}
	[CCode (cheader_filename = "gio/gio.h", cname = "GFile")]
	public interface File : GLib.Object {
		public abstract GLib.FileOutputStream append_to (GLib.FileCreateFlags flags, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public abstract async GLib.FileOutputStream append_to_async (GLib.FileCreateFlags flags, int io_priority = GLib.Priority.DEFAULT, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public abstract bool copy (GLib.File destination, GLib.FileCopyFlags flags, GLib.Cancellable? cancellable = null, GLib.FileProgressCallback? progress_callback = null) throws GLib.Error;
		public abstract async bool copy_async (GLib.File destination, GLib.FileCopyFlags flags, int io_priority = GLib.Priority.DEFAULT, GLib.Cancellable? cancellable = null, GLib.FileProgressCallback? progress_callback = null) throws GLib.Error;
		public bool copy_attributes (GLib.File destination, GLib.FileCopyFlags flags, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public abstract GLib.FileOutputStream create (GLib.FileCreateFlags flags, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public abstract async GLib.FileOutputStream create_async (GLib.FileCreateFlags flags, int io_priority = GLib.Priority.DEFAULT, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public abstract unowned GLib.FileIOStream create_readwrite (GLib.FileCreateFlags flags, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public abstract async unowned GLib.FileIOStream create_readwrite_async (GLib.FileCreateFlags flags, int io_priority = GLib.Priority.DEFAULT, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public bool @delete (GLib.Cancellable? cancellable = null) throws GLib.Error;
		[NoWrapper]
		public abstract bool delete_file (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public abstract unowned GLib.File dup ();
		public abstract async bool eject_mountable (GLib.MountUnmountFlags flags, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public abstract async bool eject_mountable_with_operation (GLib.MountUnmountFlags flags, GLib.MountOperation? mount_operation, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public abstract GLib.FileEnumerator enumerate_children (string attributes, GLib.FileQueryInfoFlags flags, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public abstract async GLib.FileEnumerator enumerate_children_async (string attributes, GLib.FileQueryInfoFlags flags, int io_priority = GLib.Priority.DEFAULT, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public abstract bool equal (GLib.File file2);
		public abstract GLib.Mount find_enclosing_mount (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public abstract async GLib.Mount find_enclosing_mount_async (int io_priority = GLib.Priority.DEFAULT, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public abstract string? get_basename ();
		public GLib.File get_child (string name);
		public abstract GLib.File get_child_for_display_name (string display_name) throws GLib.Error;
		public abstract GLib.File? get_parent ();
		public abstract string get_parse_name ();
		public abstract string? get_path ();
		public abstract string? get_relative_path (GLib.File descendant);
		public abstract string get_uri ();
		public abstract string get_uri_scheme ();
		public bool has_parent (GLib.File? parent);
		public bool has_prefix (GLib.File prefix);
		public abstract bool has_uri_scheme (string uri_scheme);
		public abstract uint hash ();
		public abstract bool is_native ();
		public bool load_contents (GLib.Cancellable? cancellable = null, out uint8[] contents, out string etag_out = null) throws GLib.Error;
		public async bool load_contents_async (GLib.Cancellable? cancellable = null, out uint8[] contents, out string etag_out = null) throws GLib.Error;
		public async bool load_partial_contents_async (GLib.Cancellable? cancellable, GLib.FileReadMoreCallback read_more_callback, out uint8[] contents, out string etag_out = null) throws GLib.Error;
		public abstract bool make_directory (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public bool make_directory_with_parents (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public abstract bool make_symbolic_link (string symlink_value, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public unowned GLib.FileMonitor monitor (GLib.FileMonitorFlags flags, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[CCode (vfunc_name = "monitor_dir")]
		public abstract GLib.FileMonitor monitor_directory (GLib.FileMonitorFlags flags, GLib.Cancellable? cancellable = null) throws GLib.IOError;
		public abstract GLib.FileMonitor monitor_file (GLib.FileMonitorFlags flags, GLib.Cancellable? cancellable = null) throws GLib.IOError;
		public abstract async bool mount_enclosing_volume (GLib.MountMountFlags flags, GLib.MountOperation? mount_operation, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public abstract async unowned GLib.File mount_mountable (GLib.MountMountFlags flags, GLib.MountOperation? mount_operation, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public abstract bool move (GLib.File destination, GLib.FileCopyFlags flags, GLib.Cancellable? cancellable = null, GLib.FileProgressCallback? progress_callback = null) throws GLib.Error;
		public static GLib.File new_for_commandline_arg (string arg);
		public static GLib.File new_for_path (string path);
		public static GLib.File new_for_uri (string uri);
		public abstract unowned GLib.FileIOStream open_readwrite (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public abstract async unowned GLib.FileIOStream open_readwrite_async (int io_priority = GLib.Priority.DEFAULT, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public static GLib.File parse_name (string parse_name);
		public abstract async bool poll_mountable (GLib.Cancellable? cancellable = null) throws GLib.Error;
		[NoWrapper]
		public abstract bool prefix_matches (GLib.File file);
		public GLib.AppInfo query_default_handler (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public bool query_exists (GLib.Cancellable? cancellable = null);
		public GLib.FileType query_file_type (GLib.FileQueryInfoFlags flags, GLib.Cancellable? cancellable = null);
		public abstract GLib.FileInfo query_filesystem_info (string attributes, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public abstract async unowned GLib.FileInfo query_filesystem_info_async (string attributes, int io_priority = GLib.Priority.DEFAULT, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public abstract GLib.FileInfo query_info (string attributes, GLib.FileQueryInfoFlags flags, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public abstract async GLib.FileInfo query_info_async (string attributes, GLib.FileQueryInfoFlags flags, int io_priority = GLib.Priority.DEFAULT, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public abstract unowned GLib.FileAttributeInfoList query_settable_attributes (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public abstract unowned GLib.FileAttributeInfoList query_writable_namespaces (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public GLib.FileInputStream read (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public abstract async GLib.FileInputStream read_async (int io_priority = GLib.Priority.DEFAULT, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[NoWrapper]
		public abstract unowned GLib.FileInputStream read_fn (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public abstract GLib.FileOutputStream replace (string? etag, bool make_backup, GLib.FileCreateFlags flags, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public abstract async GLib.FileOutputStream replace_async (string? etag, bool make_backup, GLib.FileCreateFlags flags, int io_priority = GLib.Priority.DEFAULT, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public bool replace_contents (string contents, size_t length, string? etag, bool make_backup, GLib.FileCreateFlags flags, out string? new_etag, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public async bool replace_contents_async (string contents, size_t length, string? etag, bool make_backup, GLib.FileCreateFlags flags, GLib.Cancellable? cancellable = null, out string? new_etag = null) throws GLib.Error;
		public abstract unowned GLib.FileIOStream replace_readwrite (string? etag, bool make_backup, GLib.FileCreateFlags flags, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public abstract async unowned GLib.FileIOStream replace_readwrite_async (string? etag, bool make_backup, GLib.FileCreateFlags flags, int io_priority = GLib.Priority.DEFAULT, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public abstract GLib.File resolve_relative_path (string relative_path);
		public abstract bool set_attribute (string attribute, GLib.FileAttributeType type, void* value_p, GLib.FileQueryInfoFlags flags, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public bool set_attribute_byte_string (string attribute, string value, GLib.FileQueryInfoFlags flags, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public bool set_attribute_int32 (string attribute, int32 value, GLib.FileQueryInfoFlags flags, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public bool set_attribute_int64 (string attribute, int64 value, GLib.FileQueryInfoFlags flags, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public bool set_attribute_string (string attribute, string value, GLib.FileQueryInfoFlags flags, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public bool set_attribute_uint32 (string attribute, uint32 value, GLib.FileQueryInfoFlags flags, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public bool set_attribute_uint64 (string attribute, uint64 value, GLib.FileQueryInfoFlags flags, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public abstract async bool set_attributes_async (GLib.FileInfo info, GLib.FileQueryInfoFlags flags, int io_priority = GLib.Priority.DEFAULT, GLib.Cancellable? cancellable, out unowned GLib.FileInfo info_out) throws GLib.Error;
		public abstract bool set_attributes_from_info (GLib.FileInfo info, GLib.FileQueryInfoFlags flags, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public abstract unowned GLib.File set_display_name (string display_name, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public abstract async unowned GLib.File set_display_name_async (string display_name, int io_priority = GLib.Priority.DEFAULT, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public abstract async bool start_mountable (GLib.DriveStartFlags flags, GLib.MountOperation start_operation, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public abstract async bool stop_mountable (GLib.MountUnmountFlags flags, GLib.MountOperation? mount_operation, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public bool supports_thread_contexts ();
		public abstract bool trash (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public abstract async bool unmount_mountable (GLib.MountUnmountFlags flags, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public abstract async bool unmount_mountable_with_operation (GLib.MountUnmountFlags flags, GLib.MountOperation? mount_operation, GLib.Cancellable? cancellable = null) throws GLib.Error;
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public interface Icon : GLib.Object {
		public abstract bool equal (GLib.Icon icon2);
		[NoWrapper]
		public virtual GLib.Icon? from_tokens (string[] tokens, int version) throws GLib.Error;
		public abstract uint hash ();
		public static GLib.Icon? new_for_string (string str) throws GLib.Error;
		public string? to_string ();
		[NoWrapper]
		public virtual bool to_tokens (GLib.PtrArray tokens, out int out_version);
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public interface Initable : GLib.Object {
		public abstract bool init (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public static void* @new (GLib.Type object_type, GLib.Cancellable? cancellable, ...) throws GLib.Error;
		public static unowned GLib.Object new_valist (GLib.Type object_type, string first_property_name, void* var_args, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public static void* newv (GLib.Type object_type, uint n_parameters, GLib.Parameter parameters, GLib.Cancellable? cancellable = null) throws GLib.Error;
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public interface LoadableIcon : GLib.Icon, GLib.Object {
		public abstract GLib.InputStream load (int size, out string? type, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public abstract async GLib.InputStream load_async (int size, GLib.Cancellable? cancellable, out string? type) throws GLib.Error;
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public interface Mount : GLib.Object {
		public abstract bool can_eject ();
		public abstract bool can_unmount ();
		public abstract async bool eject (GLib.MountUnmountFlags flags, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public abstract async bool eject_with_operation (GLib.MountUnmountFlags flags, GLib.MountOperation? mount_operation, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public abstract unowned GLib.File get_default_location ();
		public abstract unowned GLib.Drive get_drive ();
		public abstract unowned GLib.Icon get_icon ();
		public abstract unowned string get_name ();
		public abstract unowned GLib.File get_root ();
		public abstract unowned string get_uuid ();
		public abstract unowned GLib.Volume get_volume ();
		public abstract async unowned string guess_content_type (bool force_rescan, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public abstract unowned string guess_content_type_sync (bool force_rescan, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public bool is_shadowed ();
		public abstract async bool remount (GLib.MountMountFlags flags, GLib.MountOperation? mount_operation, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public void shadow ();
		public abstract async bool unmount (GLib.MountUnmountFlags flags, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public abstract async bool unmount_with_operation (GLib.MountUnmountFlags flags, GLib.MountOperation? mount_operation, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public void unshadow ();
		public signal void changed ();
		public signal void pre_unmount ();
		public signal void unmounted ();
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public interface PollableInputStream : GLib.InputStream {
		public abstract bool can_poll ();
		public abstract GLib.TimeoutSource create_source (GLib.Cancellable? cancellable = null);
		public abstract bool is_readable ();
		public abstract ssize_t read_nonblocking ([CCode (array_length_type = "gsize")] uint8[] buffer, GLib.Cancellable? cancellable = null) throws GLib.Error;
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public interface PollableOutputStream : GLib.OutputStream {
		public abstract bool can_poll ();
		public abstract GLib.TimeoutSource create_source (GLib.Cancellable? cancellable = null);
		public abstract bool is_writable ();
		public abstract ssize_t write_nonblocking ([CCode (array_length_type = "gsize")] uint8[] buffer, GLib.Cancellable? cancellable = null) throws GLib.Error;
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public interface Proxy : GLib.Object {
		public abstract unowned GLib.IOStream connect (GLib.IOStream connection, GLib.ProxyAddress proxy_address, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public abstract async unowned GLib.IOStream connect_async (GLib.IOStream connection, GLib.ProxyAddress proxy_address, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public static unowned GLib.Proxy get_default_for_protocol (string protocol);
		public abstract bool supports_hostname ();
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public interface ProxyResolver : GLib.Object {
		public static unowned GLib.ProxyResolver get_default ();
		public abstract bool is_supported ();
		public abstract unowned string lookup (string uri, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public abstract async unowned string lookup_async (string uri, GLib.Cancellable? cancellable = null) throws GLib.Error;
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public interface Seekable : GLib.Object {
		public abstract bool can_seek ();
		public abstract bool can_truncate ();
		public abstract bool seek (int64 offset, GLib.SeekType type, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public abstract int64 tell ();
		[CCode (vfunc_name = "truncate_fn")]
		public abstract bool truncate (int64 offset, GLib.Cancellable? cancellable = null) throws GLib.Error;
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public interface SocketConnectable : GLib.Object {
		public abstract unowned GLib.SocketAddressEnumerator enumerate ();
		public abstract unowned GLib.SocketAddressEnumerator proxy_enumerate ();
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public interface TlsBackend : GLib.Object {
		public abstract GLib.Type get_certificate_type ();
		public abstract GLib.Type get_client_connection_type ();
		public static unowned GLib.TlsBackend get_default ();
		public abstract GLib.Type get_server_connection_type ();
		public abstract bool supports_tls ();
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public interface TlsClientConnection : GLib.TlsConnection {
		public unowned GLib.List get_accepted_cas ();
		public unowned GLib.SocketConnectable get_server_identity ();
		public bool get_use_ssl3 ();
		public GLib.TlsCertificateFlags get_validation_flags ();
		public static unowned GLib.IOStream @new (GLib.IOStream base_io_stream, GLib.SocketConnectable server_identity) throws GLib.Error;
		public void set_server_identity (GLib.SocketConnectable identity);
		public void set_use_ssl3 (bool use_ssl3);
		public void set_validation_flags (GLib.TlsCertificateFlags flags);
		public void* accepted_cas { get; }
		public GLib.SocketConnectable server_identity { get; set construct; }
		public bool use_ssl3 { get; set construct; }
		public GLib.TlsCertificateFlags validation_flags { get; set construct; }
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public interface TlsServerConnection : GLib.TlsConnection {
		public static unowned GLib.IOStream @new (GLib.IOStream base_io_stream, GLib.TlsCertificate certificate) throws GLib.Error;
		[NoAccessorMethod]
		public GLib.TlsAuthenticationMode authentication_mode { get; set; }
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public interface Volume : GLib.Object {
		public abstract bool can_eject ();
		public abstract bool can_mount ();
		public abstract async bool eject (GLib.MountUnmountFlags flags, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public abstract async bool eject_with_operation (GLib.MountUnmountFlags flags, GLib.MountOperation? mount_operation, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public abstract unowned string enumerate_identifiers ();
		public abstract unowned GLib.File get_activation_root ();
		public abstract unowned GLib.Drive get_drive ();
		public abstract unowned GLib.Icon get_icon ();
		public abstract unowned string get_identifier (string kind);
		public abstract unowned GLib.Mount get_mount ();
		public abstract unowned string get_name ();
		public abstract unowned string get_uuid ();
		public async bool mount (GLib.MountMountFlags flags, GLib.MountOperation? mount_operation, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[NoWrapper]
		public abstract void mount_fn (GLib.MountMountFlags flags, GLib.MountOperation? mount_operation, GLib.Cancellable? cancellable, GLib.AsyncReadyCallback callback);
		public abstract bool should_automount ();
		public signal void changed ();
		public signal void removed ();
	}
	[CCode (cheader_filename = "gio/gio.h", cprefix = "G_APP_INFO_CREATE_")]
	[Flags]
	public enum AppInfoCreateFlags {
		NONE,
		NEEDS_TERMINAL,
		SUPPORTS_URIS,
		SUPPORTS_STARTUP_NOTIFICATION
	}
	[CCode (cheader_filename = "gio/gio.h", cprefix = "G_APPLICATION_")]
	[Flags]
	public enum ApplicationFlags {
		FLAGS_NONE,
		IS_SERVICE,
		IS_LAUNCHER,
		HANDLES_OPEN,
		HANDLES_COMMAND_LINE,
		SEND_ENVIRONMENT,
		NON_UNIQUE
	}
	[CCode (cheader_filename = "gio/gio.h", cprefix = "G_ASK_PASSWORD_")]
	[Flags]
	public enum AskPasswordFlags {
		NEED_PASSWORD,
		NEED_USERNAME,
		NEED_DOMAIN,
		SAVING_SUPPORTED,
		ANONYMOUS_SUPPORTED
	}
	[CCode (cheader_filename = "gio/gio.h", cprefix = "G_BUS_NAME_OWNER_FLAGS_")]
	[Flags]
	public enum BusNameOwnerFlags {
		NONE,
		ALLOW_REPLACEMENT,
		REPLACE
	}
	[CCode (cheader_filename = "gio/gio.h", cprefix = "G_BUS_NAME_WATCHER_FLAGS_")]
	[Flags]
	public enum BusNameWatcherFlags {
		NONE,
		AUTO_START
	}
	[CCode (cheader_filename = "gio/gio.h", cprefix = "G_BUS_TYPE_")]
	public enum BusType {
		STARTER,
		NONE,
		SYSTEM,
		SESSION
	}
	[CCode (cheader_filename = "gio/gio.h", cprefix = "G_CONVERTER_")]
	[Flags]
	public enum ConverterFlags {
		NO_FLAGS,
		INPUT_AT_END,
		FLUSH
	}
	[CCode (cheader_filename = "gio/gio.h", cprefix = "G_CONVERTER_")]
	public enum ConverterResult {
		ERROR,
		CONVERTED,
		FINISHED,
		FLUSHED
	}
	[CCode (cheader_filename = "gio/gio.h", cprefix = "G_CREDENTIALS_TYPE_")]
	public enum CredentialsType {
		INVALID,
		LINUX_UCRED,
		FREEBSD_CMSGCRED,
		OPENBSD_SOCKPEERCRED
	}
	[CCode (cheader_filename = "gio/gio.h", cprefix = "G_DBUS_CALL_FLAGS_")]
	[Flags]
	public enum DBusCallFlags {
		NONE,
		NO_AUTO_START
	}
	[CCode (cheader_filename = "gio/gio.h", cprefix = "G_DBUS_CAPABILITY_FLAGS_")]
	[Flags]
	public enum DBusCapabilityFlags {
		NONE,
		UNIX_FD_PASSING
	}
	[CCode (cheader_filename = "gio/gio.h", cprefix = "G_DBUS_CONNECTION_FLAGS_")]
	[Flags]
	public enum DBusConnectionFlags {
		NONE,
		AUTHENTICATION_CLIENT,
		AUTHENTICATION_SERVER,
		AUTHENTICATION_ALLOW_ANONYMOUS,
		MESSAGE_BUS_CONNECTION,
		DELAY_MESSAGE_PROCESSING
	}
	[CCode (cheader_filename = "gio/gio.h", cprefix = "G_DBUS_INTERFACE_SKELETON_FLAGS_")]
	[Flags]
	public enum DBusInterfaceSkeletonFlags {
		NONE,
		HANDLE_METHOD_INVOCATIONS_IN_THREAD
	}
	[CCode (cheader_filename = "gio/gio.h", cprefix = "G_DBUS_MESSAGE_BYTE_ORDER_")]
	public enum DBusMessageByteOrder {
		BIG_ENDIAN,
		LITTLE_ENDIAN
	}
	[CCode (cheader_filename = "gio/gio.h", cprefix = "G_DBUS_MESSAGE_FLAGS_")]
	[Flags]
	public enum DBusMessageFlags {
		NONE,
		NO_REPLY_EXPECTED,
		NO_AUTO_START
	}
	[CCode (cheader_filename = "gio/gio.h", cprefix = "G_DBUS_MESSAGE_HEADER_FIELD_")]
	public enum DBusMessageHeaderField {
		INVALID,
		PATH,
		INTERFACE,
		MEMBER,
		ERROR_NAME,
		REPLY_SERIAL,
		DESTINATION,
		SENDER,
		SIGNATURE,
		NUM_UNIX_FDS
	}
	[CCode (cheader_filename = "gio/gio.h", cprefix = "G_DBUS_MESSAGE_TYPE_")]
	public enum DBusMessageType {
		INVALID,
		METHOD_CALL,
		METHOD_RETURN,
		ERROR,
		SIGNAL
	}
	[CCode (cheader_filename = "gio/gio.h", cprefix = "G_DBUS_OBJECT_MANAGER_CLIENT_FLAGS_")]
	[Flags]
	public enum DBusObjectManagerClientFlags {
		NONE,
		DO_NOT_AUTO_START
	}
	[CCode (cheader_filename = "gio/gio.h", cprefix = "G_DBUS_PROPERTY_INFO_FLAGS_")]
	[Flags]
	public enum DBusPropertyInfoFlags {
		NONE,
		READABLE,
		WRITABLE
	}
	[CCode (cheader_filename = "gio/gio.h", cprefix = "G_DBUS_PROXY_FLAGS_")]
	[Flags]
	public enum DBusProxyFlags {
		NONE,
		DO_NOT_LOAD_PROPERTIES,
		DO_NOT_CONNECT_SIGNALS,
		DO_NOT_AUTO_START
	}
	[CCode (cheader_filename = "gio/gio.h", cprefix = "G_DBUS_SEND_MESSAGE_FLAGS_")]
	[Flags]
	public enum DBusSendMessageFlags {
		NONE,
		PRESERVE_SERIAL
	}
	[CCode (cheader_filename = "gio/gio.h", cprefix = "G_DBUS_SERVER_FLAGS_")]
	[Flags]
	public enum DBusServerFlags {
		NONE,
		RUN_IN_THREAD,
		AUTHENTICATION_ALLOW_ANONYMOUS
	}
	[CCode (cheader_filename = "gio/gio.h", cprefix = "G_DBUS_SIGNAL_FLAGS_")]
	[Flags]
	public enum DBusSignalFlags {
		NONE,
		NO_MATCH_RULE
	}
	[CCode (cheader_filename = "gio/gio.h", cprefix = "G_DBUS_SUBTREE_FLAGS_")]
	[Flags]
	public enum DBusSubtreeFlags {
		NONE,
		DISPATCH_TO_UNENUMERATED_NODES
	}
	[CCode (cheader_filename = "gio/gio.h", cprefix = "G_DATA_STREAM_BYTE_ORDER_")]
	public enum DataStreamByteOrder {
		BIG_ENDIAN,
		LITTLE_ENDIAN,
		HOST_ENDIAN
	}
	[CCode (cheader_filename = "gio/gio.h", cprefix = "G_DATA_STREAM_NEWLINE_TYPE_")]
	public enum DataStreamNewlineType {
		LF,
		CR,
		CR_LF,
		ANY
	}
	[CCode (cheader_filename = "gio/gio.h", cprefix = "G_DRIVE_START_")]
	public enum DriveStartFlags {
		NONE
	}
	[CCode (cheader_filename = "gio/gio.h", cprefix = "G_DRIVE_START_STOP_TYPE_")]
	public enum DriveStartStopType {
		UNKNOWN,
		SHUTDOWN,
		NETWORK,
		MULTIDISK,
		PASSWORD
	}
	[CCode (cheader_filename = "gio/gio.h", cprefix = "G_EMBLEM_ORIGIN_")]
	public enum EmblemOrigin {
		UNKNOWN,
		DEVICE,
		LIVEMETADATA,
		TAG
	}
	[CCode (cheader_filename = "gio/gio.h", cprefix = "G_FILE_ATTRIBUTE_INFO_")]
	[Flags]
	public enum FileAttributeInfoFlags {
		NONE,
		COPY_WITH_FILE,
		COPY_WHEN_MOVED
	}
	[CCode (cheader_filename = "gio/gio.h", cprefix = "G_FILE_ATTRIBUTE_STATUS_")]
	public enum FileAttributeStatus {
		UNSET,
		SET,
		ERROR_SETTING
	}
	[CCode (cheader_filename = "gio/gio.h", cprefix = "G_FILE_ATTRIBUTE_TYPE_")]
	public enum FileAttributeType {
		INVALID,
		STRING,
		BYTE_STRING,
		BOOLEAN,
		UINT32,
		INT32,
		UINT64,
		INT64,
		OBJECT,
		STRINGV
	}
	[CCode (cheader_filename = "gio/gio.h", cprefix = "G_FILE_COPY_")]
	[Flags]
	public enum FileCopyFlags {
		NONE,
		OVERWRITE,
		BACKUP,
		NOFOLLOW_SYMLINKS,
		ALL_METADATA,
		NO_FALLBACK_FOR_MOVE,
		TARGET_DEFAULT_PERMS
	}
	[CCode (cheader_filename = "gio/gio.h", cprefix = "G_FILE_CREATE_")]
	[Flags]
	public enum FileCreateFlags {
		NONE,
		PRIVATE,
		REPLACE_DESTINATION
	}
	[CCode (cheader_filename = "gio/gio.h", cprefix = "G_FILE_MONITOR_EVENT_")]
	public enum FileMonitorEvent {
		CHANGED,
		CHANGES_DONE_HINT,
		DELETED,
		CREATED,
		ATTRIBUTE_CHANGED,
		PRE_UNMOUNT,
		UNMOUNTED,
		MOVED
	}
	[CCode (cheader_filename = "gio/gio.h", cprefix = "G_FILE_MONITOR_")]
	[Flags]
	public enum FileMonitorFlags {
		NONE,
		WATCH_MOUNTS,
		SEND_MOVED
	}
	[CCode (cheader_filename = "gio/gio.h", cprefix = "G_FILE_QUERY_INFO_")]
	[Flags]
	public enum FileQueryInfoFlags {
		NONE,
		NOFOLLOW_SYMLINKS
	}
	[CCode (cheader_filename = "gio/gio.h", cprefix = "G_FILE_TYPE_")]
	public enum FileType {
		UNKNOWN,
		REGULAR,
		DIRECTORY,
		SYMBOLIC_LINK,
		SPECIAL,
		SHORTCUT,
		MOUNTABLE
	}
	[CCode (cheader_filename = "gio/gio.h", cprefix = "G_FILESYSTEM_PREVIEW_TYPE_")]
	public enum FilesystemPreviewType {
		IF_ALWAYS,
		IF_LOCAL,
		NEVER
	}
	[CCode (cheader_filename = "gio/gio.h", cprefix = "G_IO_STREAM_SPLICE_")]
	[Flags]
	public enum IOStreamSpliceFlags {
		NONE,
		CLOSE_STREAM1,
		CLOSE_STREAM2,
		WAIT_FOR_BOTH
	}
	[CCode (cheader_filename = "gio/gio.h", cprefix = "G_MOUNT_MOUNT_")]
	public enum MountMountFlags {
		NONE
	}
	[CCode (cheader_filename = "gio/gio.h", cprefix = "G_MOUNT_OPERATION_")]
	public enum MountOperationResult {
		HANDLED,
		ABORTED,
		UNHANDLED
	}
	[CCode (cheader_filename = "gio/gio.h", cprefix = "G_MOUNT_UNMOUNT_")]
	[Flags]
	public enum MountUnmountFlags {
		NONE,
		FORCE
	}
	[CCode (cheader_filename = "gio/gio.h", cprefix = "G_OUTPUT_STREAM_SPLICE_")]
	[Flags]
	public enum OutputStreamSpliceFlags {
		NONE,
		CLOSE_SOURCE,
		CLOSE_TARGET
	}
	[CCode (cheader_filename = "gio/gio.h", cprefix = "G_PASSWORD_SAVE_")]
	public enum PasswordSave {
		NEVER,
		FOR_SESSION,
		PERMANENTLY
	}
	[CCode (cheader_filename = "gio/gio.h", cprefix = "G_SETTINGS_BIND_")]
	[Flags]
	public enum SettingsBindFlags {
		DEFAULT,
		GET,
		SET,
		NO_SENSITIVITY,
		GET_NO_CHANGES,
		INVERT_BOOLEAN
	}
	[CCode (cheader_filename = "gio/gio.h", cprefix = "G_SOCKET_FAMILY_")]
	public enum SocketFamily {
		INVALID,
		UNIX,
		IPV4,
		IPV6
	}
	[CCode (cheader_filename = "gio/gio.h", cprefix = "G_SOCKET_MSG_")]
	public enum SocketMsgFlags {
		NONE,
		OOB,
		PEEK,
		DONTROUTE
	}
	[CCode (cheader_filename = "gio/gio.h", cprefix = "G_SOCKET_PROTOCOL_")]
	public enum SocketProtocol {
		UNKNOWN,
		DEFAULT,
		TCP,
		UDP,
		SCTP
	}
	[CCode (cheader_filename = "gio/gio.h", cprefix = "G_SOCKET_TYPE_")]
	public enum SocketType {
		INVALID,
		STREAM,
		DATAGRAM,
		SEQPACKET
	}
	[CCode (cheader_filename = "gio/gio.h", cprefix = "G_TLS_AUTHENTICATION_")]
	public enum TlsAuthenticationMode {
		NONE,
		REQUESTED,
		REQUIRED
	}
	[CCode (cheader_filename = "gio/gio.h", cprefix = "G_TLS_CERTIFICATE_")]
	[Flags]
	public enum TlsCertificateFlags {
		UNKNOWN_CA,
		BAD_IDENTITY,
		NOT_ACTIVATED,
		EXPIRED,
		REVOKED,
		INSECURE,
		GENERIC_ERROR,
		VALIDATE_ALL
	}
	[CCode (cheader_filename = "gio/gio.h", cprefix = "G_TLS_ERROR_")]
	public enum TlsError {
		UNAVAILABLE,
		MISC,
		BAD_CERTIFICATE,
		NOT_TLS,
		HANDSHAKE,
		CERTIFICATE_REQUIRED,
		EOF
	}
	[CCode (cheader_filename = "gio/gio.h", cprefix = "G_TLS_REHANDSHAKE_")]
	public enum TlsRehandshakeMode {
		NEVER,
		SAFELY,
		UNSAFELY
	}
	[CCode (cheader_filename = "gio/gio.h", cprefix = "G_UNIX_SOCKET_ADDRESS_")]
	public enum UnixSocketAddressType {
		INVALID,
		ANONYMOUS,
		PATH,
		ABSTRACT,
		ABSTRACT_PADDED
	}
	[CCode (cheader_filename = "gio/gio.h", cprefix = "G_ZLIB_COMPRESSOR_FORMAT_")]
	public enum ZlibCompressorFormat {
		ZLIB,
		GZIP,
		RAW
	}
	[CCode (cheader_filename = "gio/gio.h", cprefix = "G_DBUS_ERROR_")]
	public errordomain DBusError {
		FAILED,
		NO_MEMORY,
		SERVICE_UNKNOWN,
		NAME_HAS_NO_OWNER,
		NO_REPLY,
		IO_ERROR,
		BAD_ADDRESS,
		NOT_SUPPORTED,
		LIMITS_EXCEEDED,
		ACCESS_DENIED,
		AUTH_FAILED,
		NO_SERVER,
		TIMEOUT,
		NO_NETWORK,
		ADDRESS_IN_USE,
		DISCONNECTED,
		INVALID_ARGS,
		FILE_NOT_FOUND,
		FILE_EXISTS,
		UNKNOWN_METHOD,
		TIMED_OUT,
		MATCH_RULE_NOT_FOUND,
		MATCH_RULE_INVALID,
		SPAWN_EXEC_FAILED,
		SPAWN_FORK_FAILED,
		SPAWN_CHILD_EXITED,
		SPAWN_CHILD_SIGNALED,
		SPAWN_FAILED,
		SPAWN_SETUP_FAILED,
		SPAWN_CONFIG_INVALID,
		SPAWN_SERVICE_INVALID,
		SPAWN_SERVICE_NOT_FOUND,
		SPAWN_PERMISSIONS_INVALID,
		SPAWN_FILE_INVALID,
		SPAWN_NO_MEMORY,
		UNIX_PROCESS_ID_UNKNOWN,
		INVALID_SIGNATURE,
		INVALID_FILE_CONTENT,
		SELINUX_SECURITY_CONTEXT_UNKNOWN,
		ADT_AUDIT_DATA_UNKNOWN,
		OBJECT_PATH_IN_USE
	}
	[CCode (cheader_filename = "gio/gio.h", cprefix = "G_IO_ERROR_")]
	public errordomain IOError {
		FAILED,
		NOT_FOUND,
		EXISTS,
		IS_DIRECTORY,
		NOT_DIRECTORY,
		NOT_EMPTY,
		NOT_REGULAR_FILE,
		NOT_SYMBOLIC_LINK,
		NOT_MOUNTABLE_FILE,
		FILENAME_TOO_LONG,
		INVALID_FILENAME,
		TOO_MANY_LINKS,
		NO_SPACE,
		INVALID_ARGUMENT,
		PERMISSION_DENIED,
		NOT_SUPPORTED,
		NOT_MOUNTED,
		ALREADY_MOUNTED,
		CLOSED,
		CANCELLED,
		PENDING,
		READ_ONLY,
		CANT_CREATE_BACKUP,
		WRONG_ETAG,
		TIMED_OUT,
		WOULD_RECURSE,
		BUSY,
		WOULD_BLOCK,
		HOST_NOT_FOUND,
		WOULD_MERGE,
		FAILED_HANDLED,
		TOO_MANY_OPEN_FILES,
		NOT_INITIALIZED,
		ADDRESS_IN_USE,
		PARTIAL_INPUT,
		INVALID_DATA,
		DBUS_ERROR,
		HOST_UNREACHABLE,
		NETWORK_UNREACHABLE,
		CONNECTION_REFUSED,
		PROXY_FAILED,
		PROXY_AUTH_FAILED,
		PROXY_NEED_AUTH,
		PROXY_NOT_ALLOWED
	}
	[CCode (cheader_filename = "gio/gio.h", cprefix = "G_RESOLVER_ERROR_")]
	public errordomain ResolverError {
		NOT_FOUND,
		TEMPORARY_FAILURE,
		INTERNAL
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public delegate void AsyncReadyCallback (GLib.Object? source_object, GLib.AsyncResult res);
	[CCode (cheader_filename = "gio/gio.h")]
	public delegate void BusAcquiredCallback (GLib.DBusConnection connection, string name);
	[CCode (cheader_filename = "gio/gio.h")]
	public delegate void BusNameAcquiredCallback (GLib.DBusConnection connection, string name);
	[CCode (cheader_filename = "gio/gio.h")]
	public delegate void BusNameAppearedCallback (GLib.DBusConnection connection, string name, string name_owner);
	[CCode (cheader_filename = "gio/gio.h")]
	public delegate void BusNameLostCallback (GLib.DBusConnection connection, string name);
	[CCode (cheader_filename = "gio/gio.h")]
	public delegate void BusNameVanishedCallback (GLib.DBusConnection connection, string name);
	[CCode (cheader_filename = "gio/gio.h")]
	public delegate bool CancellableSourceFunc (GLib.Cancellable? cancellable);
	[CCode (cheader_filename = "gio/gio.h")]
	public delegate unowned GLib.Variant DBusInterfaceGetPropertyFunc (GLib.DBusConnection connection, string sender, string object_path, string interface_name, string property_name) throws GLib.Error;
	[CCode (cheader_filename = "gio/gio.h")]
	public delegate void DBusInterfaceMethodCallFunc (GLib.DBusConnection connection, string sender, string object_path, string interface_name, string method_name, GLib.Variant parameters, GLib.DBusMethodInvocation invocation);
	[CCode (cheader_filename = "gio/gio.h")]
	public delegate bool DBusInterfaceSetPropertyFunc (GLib.DBusConnection connection, string sender, string object_path, string interface_name, string property_name, GLib.Variant value) throws GLib.Error;
	[CCode (cheader_filename = "gio/gio.h")]
	public delegate unowned GLib.DBusMessage DBusMessageFilterFunction (GLib.DBusConnection connection, GLib.DBusMessage message, bool incoming);
	[CCode (cheader_filename = "gio/gio.h")]
	public delegate GLib.Type DBusProxyTypeFunc (GLib.DBusObjectManagerClient manager, string object_path, string interface_name);
	[CCode (cheader_filename = "gio/gio.h")]
	public delegate void DBusSignalCallback (GLib.DBusConnection connection, string sender_name, string object_path, string interface_name, string signal_name, GLib.Variant parameters);
	[CCode (cheader_filename = "gio/gio.h")]
	public delegate unowned GLib.DBusInterfaceVTable DBusSubtreeDispatchFunc (GLib.DBusConnection connection, string sender, string object_path, string interface_name, string node, void* out_user_data);
	[CCode (cheader_filename = "gio/gio.h")]
	public delegate unowned string DBusSubtreeEnumerateFunc (GLib.DBusConnection connection, string sender, string object_path);
	[CCode (cheader_filename = "gio/gio.h")]
	public delegate unowned GLib.DBusInterfaceInfo DBusSubtreeIntrospectFunc (GLib.DBusConnection connection, string sender, string object_path, string node);
	[CCode (cheader_filename = "gio/gio.h")]
	public delegate void FileProgressCallback (int64 current_num_bytes, int64 total_num_bytes);
	[CCode (cheader_filename = "gio/gio.h", has_target = false)]
	public delegate bool FileReadMoreCallback (string file_contents, int64 file_size, void* callback_data);
	[CCode (cheader_filename = "gio/gio.h")]
	public delegate bool IOSchedulerJobFunc (GLib.IOSchedulerJob job, GLib.Cancellable? cancellable);
	[CCode (cheader_filename = "gio/gio.h")]
	public delegate bool PollableSourceFunc (GLib.Object pollable_stream);
	[CCode (cheader_filename = "gio/gio.h", has_target = false)]
	public delegate void* ReallocFunc (void* data, size_t size);
	[CCode (cheader_filename = "gio/gio.h")]
	public delegate bool SettingsBindGetMapping (GLib.Value value, GLib.Variant variant);
	[CCode (cheader_filename = "gio/gio.h")]
	public delegate GLib.Variant SettingsBindSetMapping (GLib.Value value, GLib.VariantType expected_type);
	[CCode (cheader_filename = "gio/gio.h")]
	public delegate bool SettingsGetMapping (GLib.Variant value, void* result);
	[CCode (cheader_filename = "gio/gio.h", has_target = false)]
	public delegate void SimpleAsyncThreadFunc (GLib.SimpleAsyncResult res, GLib.Object object, GLib.Cancellable? cancellable);
	[CCode (cheader_filename = "gio/gio.h")]
	public delegate bool SocketSourceFunc (GLib.Socket socket, GLib.IOCondition condition);
	[CCode (cheader_filename = "gio/gio.h", cname = "g_file_equal")]
	public static GLib.EqualFunc file_equal;
	[CCode (cheader_filename = "gio/gio.h", cname = "g_file_hash")]
	public static GLib.HashFunc file_hash;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_ACCESS_CAN_DELETE;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_ACCESS_CAN_EXECUTE;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_ACCESS_CAN_READ;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_ACCESS_CAN_RENAME;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_ACCESS_CAN_TRASH;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_ACCESS_CAN_WRITE;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_DOS_IS_ARCHIVE;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_DOS_IS_SYSTEM;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_ETAG_VALUE;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_FILESYSTEM_FREE;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_FILESYSTEM_READONLY;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_FILESYSTEM_SIZE;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_FILESYSTEM_TYPE;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_FILESYSTEM_USE_PREVIEW;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_GVFS_BACKEND;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_ID_FILE;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_ID_FILESYSTEM;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_MOUNTABLE_CAN_EJECT;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_MOUNTABLE_CAN_MOUNT;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_MOUNTABLE_CAN_POLL;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_MOUNTABLE_CAN_START;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_MOUNTABLE_CAN_START_DEGRADED;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_MOUNTABLE_CAN_STOP;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_MOUNTABLE_CAN_UNMOUNT;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_MOUNTABLE_HAL_UDI;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_MOUNTABLE_IS_MEDIA_CHECK_AUTOMATIC;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_MOUNTABLE_START_STOP_TYPE;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_MOUNTABLE_UNIX_DEVICE;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_MOUNTABLE_UNIX_DEVICE_FILE;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_OWNER_GROUP;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_OWNER_USER;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_OWNER_USER_REAL;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_PREVIEW_ICON;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_SELINUX_CONTEXT;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_STANDARD_ALLOCATED_SIZE;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_STANDARD_COPY_NAME;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_STANDARD_DESCRIPTION;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_STANDARD_EDIT_NAME;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_STANDARD_FAST_CONTENT_TYPE;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_STANDARD_ICON;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_STANDARD_IS_BACKUP;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_STANDARD_IS_HIDDEN;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_STANDARD_IS_SYMLINK;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_STANDARD_IS_VIRTUAL;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_STANDARD_NAME;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_STANDARD_SIZE;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_STANDARD_SORT_ORDER;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_STANDARD_SYMLINK_TARGET;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_STANDARD_TARGET_URI;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_STANDARD_TYPE;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_THUMBNAILING_FAILED;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_THUMBNAIL_PATH;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_TIME_ACCESS;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_TIME_ACCESS_USEC;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_TIME_CHANGED;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_TIME_CHANGED_USEC;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_TIME_CREATED;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_TIME_CREATED_USEC;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_TIME_MODIFIED;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_TIME_MODIFIED_USEC;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_TRASH_DELETION_DATE;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_TRASH_ITEM_COUNT;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_TRASH_ORIG_PATH;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_UNIX_BLOCKS;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_UNIX_BLOCK_SIZE;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_UNIX_DEVICE;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_UNIX_GID;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_UNIX_INODE;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_UNIX_IS_MOUNTPOINT;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_UNIX_MODE;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_UNIX_NLINK;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_UNIX_RDEV;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_UNIX_UID;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string NATIVE_VOLUME_MONITOR_EXTENSION_POINT_NAME;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string PROXY_EXTENSION_POINT_NAME;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string PROXY_RESOLVER_EXTENSION_POINT_NAME;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string TLS_BACKEND_EXTENSION_POINT_NAME;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string VFS_EXTENSION_POINT_NAME;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string VOLUME_IDENTIFIER_KIND_HAL_UDI;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string VOLUME_IDENTIFIER_KIND_LABEL;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string VOLUME_IDENTIFIER_KIND_NFS_MOUNT;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string VOLUME_IDENTIFIER_KIND_UNIX_DEVICE;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string VOLUME_IDENTIFIER_KIND_UUID;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string VOLUME_MONITOR_EXTENSION_POINT_NAME;
	[CCode (cheader_filename = "gio/gio.h", cname = "g_content_type_can_be_executable")]
	[Deprecated (replacement = "GLib.ContentType.can_be_executable", since = "vala-0.12")]
	public static bool g_content_type_can_be_executable (string type);
	[CCode (cheader_filename = "gio/gio.h", cname = "g_content_type_equals")]
	[Deprecated (replacement = "GLib.ContentType.equals", since = "vala-0.12")]
	public static bool g_content_type_equals (string type1, string type2);
	[CCode (cheader_filename = "gio/gio.h", cname = "g_content_type_from_mime_type")]
	[Deprecated (replacement = "GLib.ContentType.from_mime_type", since = "vala-0.12")]
	public static string g_content_type_from_mime_type (string mime_type);
	[CCode (cheader_filename = "gio/gio.h", cname = "g_content_type_get_description")]
	[Deprecated (replacement = "GLib.ContentType.get_description", since = "vala-0.12")]
	public static string g_content_type_get_description (string type);
	[CCode (cheader_filename = "gio/gio.h", cname = "g_content_type_get_icon")]
	[Deprecated (replacement = "GLib.ContentType.get_icon", since = "vala-0.12")]
	public static GLib.Icon g_content_type_get_icon (string type);
	[CCode (cheader_filename = "gio/gio.h", cname = "g_content_type_get_mime_type")]
	[Deprecated (replacement = "GLib.ContentType.get_mime_type", since = "vala-0.12")]
	public static string g_content_type_get_mime_type (string type);
	[CCode (cheader_filename = "gio/gio.h", cname = "g_content_type_guess")]
	[Deprecated (replacement = "GLib.ContentType.guess", since = "vala-0.12")]
	public static string g_content_type_guess (string filename, uchar[] data, out bool result_uncertain);
	[CCode (cheader_filename = "gio/gio.h", cname = "g_content_type_guess_for_tree")]
	[Deprecated (replacement = "GLib.ContentType.guess_for_tree", since = "vala-0.12")]
	public static string g_content_type_guess_for_tree (GLib.File root);
	[CCode (cheader_filename = "gio/gio.h", cname = "g_content_type_is_a")]
	[Deprecated (replacement = "GLib.ContentType.is_a", since = "vala-0.12")]
	public static bool g_content_type_is_a (string type, string supertype);
	[CCode (cheader_filename = "gio/gio.h", cname = "g_content_type_is_unknown")]
	[Deprecated (replacement = "GLib.ContentType.is_unknown", since = "vala-0.12")]
	public static bool g_content_type_is_unknown (string type);
	[CCode (cheader_filename = "gio/gio.h", cname = "g_content_types_get_registered")]
	public static GLib.List<string> g_content_types_get_registered ();
	[CCode (cheader_filename = "gio/gio.h", cname = "g_dbus_address_get_for_bus_sync")]
	public static unowned string g_dbus_address_get_for_bus_sync (GLib.BusType bus_type, GLib.Cancellable? cancellable = null) throws GLib.Error;
	[CCode (cheader_filename = "gio/gio.h", cname = "g_dbus_address_get_stream")]
	public static async void g_dbus_address_get_stream (string address, GLib.Cancellable? cancellable = null);
	[CCode (cheader_filename = "gio/gio.h", cname = "g_dbus_address_get_stream_finish")]
	public static unowned GLib.IOStream g_dbus_address_get_stream_finish (GLib.AsyncResult res, string out_guid) throws GLib.Error;
	[CCode (cheader_filename = "gio/gio.h", cname = "g_dbus_address_get_stream_sync")]
	public static unowned GLib.IOStream g_dbus_address_get_stream_sync (string address, string out_guid, GLib.Cancellable? cancellable = null) throws GLib.Error;
	[CCode (cheader_filename = "gio/gio.h", cname = "g_dbus_error_encode_gerror")]
	public static unowned string g_dbus_error_encode_gerror (GLib.Error error);
	[CCode (cheader_filename = "gio/gio.h", cname = "g_dbus_error_get_remote_error")]
	public static unowned string g_dbus_error_get_remote_error (GLib.Error error);
	[CCode (cheader_filename = "gio/gio.h", cname = "g_dbus_error_is_remote_error")]
	public static bool g_dbus_error_is_remote_error (GLib.Error error);
	[CCode (cheader_filename = "gio/gio.h", cname = "g_dbus_error_new_for_dbus_error")]
	public static unowned GLib.Error g_dbus_error_new_for_dbus_error (string dbus_error_name, string dbus_error_message);
	[CCode (cheader_filename = "gio/gio.h", cname = "g_dbus_error_quark")]
	public static GLib.Quark g_dbus_error_quark ();
	[CCode (cheader_filename = "gio/gio.h", cname = "g_dbus_error_register_error")]
	public static bool g_dbus_error_register_error (GLib.Quark error_domain, int error_code, string dbus_error_name);
	[CCode (cheader_filename = "gio/gio.h", cname = "g_dbus_error_register_error_domain")]
	public static void g_dbus_error_register_error_domain (string error_domain_quark_name, size_t quark_volatile, GLib.DBusErrorEntry entries, uint num_entries);
	[CCode (cheader_filename = "gio/gio.h", cname = "g_dbus_error_set_dbus_error")]
	public static void g_dbus_error_set_dbus_error (string dbus_error_name, string dbus_error_message, string format) throws GLib.Error;
	[CCode (cheader_filename = "gio/gio.h", cname = "g_dbus_error_set_dbus_error_valist")]
	public static void g_dbus_error_set_dbus_error_valist (string dbus_error_name, string dbus_error_message, string format, void* var_args) throws GLib.Error;
	[CCode (cheader_filename = "gio/gio.h", cname = "g_dbus_error_strip_remote_error")]
	public static bool g_dbus_error_strip_remote_error (GLib.Error error);
	[CCode (cheader_filename = "gio/gio.h", cname = "g_dbus_error_unregister_error")]
	public static bool g_dbus_error_unregister_error (GLib.Quark error_domain, int error_code, string dbus_error_name);
	[CCode (cheader_filename = "gio/gio.h", cname = "g_dbus_generate_guid")]
	public static unowned string g_dbus_generate_guid ();
	[CCode (cheader_filename = "gio/gio.h", cname = "g_dbus_gvalue_to_gvariant")]
	public static unowned GLib.Variant g_dbus_gvalue_to_gvariant (GLib.Value gvalue, GLib.VariantType type);
	[CCode (cheader_filename = "gio/gio.h", cname = "g_dbus_gvariant_to_gvalue")]
	public static void g_dbus_gvariant_to_gvalue (GLib.Variant value, GLib.Value out_gvalue);
	[CCode (cheader_filename = "gio/gio.h", cname = "g_dbus_is_address")]
	public static bool g_dbus_is_address (string str);
	[CCode (cheader_filename = "gio/gio.h", cname = "g_dbus_is_guid")]
	public static bool g_dbus_is_guid (string str);
	[CCode (cheader_filename = "gio/gio.h", cname = "g_dbus_is_interface_name")]
	public static bool g_dbus_is_interface_name (string str);
	[CCode (cheader_filename = "gio/gio.h", cname = "g_dbus_is_member_name")]
	public static bool g_dbus_is_member_name (string str);
	[CCode (cheader_filename = "gio/gio.h", cname = "g_dbus_is_name")]
	public static bool g_dbus_is_name (string str);
	[CCode (cheader_filename = "gio/gio.h", cname = "g_dbus_is_supported_address")]
	public static bool g_dbus_is_supported_address (string str) throws GLib.Error;
	[CCode (cheader_filename = "gio/gio.h", cname = "g_dbus_is_unique_name")]
	public static bool g_dbus_is_unique_name (string str);
	[CCode (cheader_filename = "gio/gio.h", cname = "g_io_error_from_errno")]
	public static unowned GLib.IOError g_io_error_from_errno (int err_no);
	[CCode (cheader_filename = "gio/gio.h", cname = "g_io_error_quark")]
	public static GLib.Quark g_io_error_quark ();
	[CCode (cheader_filename = "gio/gio.h", cname = "g_io_modules_load_all_in_directory")]
	public static GLib.List<weak GLib.TypeModule> g_io_modules_load_all_in_directory (string dirname);
	[CCode (cheader_filename = "gio/gio.h", cname = "g_io_modules_scan_all_in_directory")]
	public static void g_io_modules_scan_all_in_directory (string dirname);
	[CCode (cheader_filename = "gio/gio.h", cname = "g_io_scheduler_cancel_all_jobs")]
	public static void g_io_scheduler_cancel_all_jobs ();
	[CCode (cheader_filename = "gio/gio.h", cname = "g_io_scheduler_push_job")]
	public static void g_io_scheduler_push_job (owned GLib.IOSchedulerJobFunc job_func, int io_priority = GLib.Priority.DEFAULT, GLib.Cancellable? cancellable = null);
	[CCode (cheader_filename = "gio/gio.h", cname = "g_pollable_source_new")]
	public static unowned GLib.TimeoutSource g_pollable_source_new (GLib.Object pollable_stream);
	[CCode (cheader_filename = "gio/gio.h", cname = "g_simple_async_report_error_in_idle")]
	public static void g_simple_async_report_error_in_idle (GLib.Object object, GLib.AsyncReadyCallback callback, GLib.Quark domain, int code, string format);
	[CCode (cheader_filename = "gio/gio.h", cname = "g_simple_async_report_gerror_in_idle")]
	public static void g_simple_async_report_gerror_in_idle (GLib.Object object, GLib.AsyncReadyCallback callback, GLib.Error error);
	[CCode (cheader_filename = "gio/gio.h", cname = "g_simple_async_report_take_gerror_in_idle")]
	public static void g_simple_async_report_take_gerror_in_idle (GLib.Object object, GLib.AsyncReadyCallback callback, GLib.Error error);
	[CCode (cheader_filename = "gio/gio.h", cname = "g_tls_error_quark")]
	public static GLib.Quark g_tls_error_quark ();
}
