/* valagirwriter.c generated by valac, the Vala compiler
 * generated from valagirwriter.vala, do not modify */

/* valagirwriter.vala
 *
 * Copyright (C) 2008-2011  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <valagee.h>


#define VALA_TYPE_GIR_WRITER (vala_gir_writer_get_type ())
#define VALA_GIR_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GIR_WRITER, ValaGIRWriter))
#define VALA_GIR_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GIR_WRITER, ValaGIRWriterClass))
#define VALA_IS_GIR_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GIR_WRITER))
#define VALA_IS_GIR_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GIR_WRITER))
#define VALA_GIR_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GIR_WRITER, ValaGIRWriterClass))

typedef struct _ValaGIRWriter ValaGIRWriter;
typedef struct _ValaGIRWriterClass ValaGIRWriterClass;
typedef struct _ValaGIRWriterPrivate ValaGIRWriterPrivate;

#define VALA_GIR_WRITER_TYPE_GIR_NAMESPACE (vala_gir_writer_gir_namespace_get_type ())
typedef struct _ValaGIRWriterGIRNamespace ValaGIRWriterGIRNamespace;
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_gir_writer_gir_namespace_free0(var) ((var == NULL) ? NULL : (var = (vala_gir_writer_gir_namespace_free (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _ValaGIRWriter {
	ValaCodeVisitor parent_instance;
	ValaGIRWriterPrivate * priv;
};

struct _ValaGIRWriterClass {
	ValaCodeVisitorClass parent_class;
};

struct _ValaGIRWriterGIRNamespace {
	gchar* ns;
	gchar* version;
};

struct _ValaGIRWriterPrivate {
	ValaCodeContext* context;
	gchar* directory;
	gchar* gir_namespace;
	gchar* gir_version;
	GString* buffer;
	FILE* stream;
	ValaHashSet* unannotated_namespaces;
	ValaHashSet* our_namespaces;
	ValaArrayList* hierarchy;
	ValaArrayList* deferred;
	gint indent;
	ValaTypeSymbol* gobject_type;
	ValaArrayList* externals;
	gint enum_value;
};


static gpointer vala_gir_writer_parent_class = NULL;

GType vala_gir_writer_get_type (void) G_GNUC_CONST;
static GType vala_gir_writer_gir_namespace_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static ValaGIRWriterGIRNamespace* vala_gir_writer_gir_namespace_dup (const ValaGIRWriterGIRNamespace* self);
static void vala_gir_writer_gir_namespace_free (ValaGIRWriterGIRNamespace* self);
static void vala_gir_writer_gir_namespace_copy (const ValaGIRWriterGIRNamespace* self, ValaGIRWriterGIRNamespace* dest);
static void vala_gir_writer_gir_namespace_destroy (ValaGIRWriterGIRNamespace* self);
#define VALA_GIR_WRITER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_GIR_WRITER, ValaGIRWriterPrivate))
enum  {
	VALA_GIR_WRITER_DUMMY_PROPERTY
};
static gboolean vala_gir_writer_gir_namespace_equal (ValaGIRWriterGIRNamespace *self, ValaGIRWriterGIRNamespace* g);
void vala_gir_writer_write_includes (ValaGIRWriter* self);
static void vala_gir_writer_write_indent_stream (ValaGIRWriter* self);
void vala_gir_writer_write_file (ValaGIRWriter* self, ValaCodeContext* context, const gchar* directory, const gchar* gir_namespace, const gchar* gir_version, const gchar* package);
static void vala_gir_writer_write_package (ValaGIRWriter* self, const gchar* package);
static void vala_gir_writer_write_indent (ValaGIRWriter* self);
static void vala_gir_writer_write_c_includes (ValaGIRWriter* self, ValaNamespace* ns);
gchar* vala_ccode_base_module_get_ccode_header_filenames (ValaSymbol* sym);
static void vala_gir_writer_write_c_include (ValaGIRWriter* self, const gchar* name);
static void vala_gir_writer_real_visit_namespace (ValaCodeVisitor* base, ValaNamespace* ns);
gchar* vala_ccode_base_module_get_ccode_prefix (ValaSymbol* sym);
static void vala_gir_writer_write_annotations (ValaGIRWriter* self, ValaCodeNode* node);
static void vala_gir_writer_visit_deferred (ValaGIRWriter* self);
static void vala_gir_writer_write_symbol_attributes (ValaGIRWriter* self, ValaSymbol* symbol);
static void vala_gir_writer_real_visit_class (ValaCodeVisitor* base, ValaClass* cl);
static gboolean vala_gir_writer_check_accessibility (ValaGIRWriter* self, ValaSymbol* sym);
static gchar* vala_gir_writer_get_gir_name (ValaGIRWriter* self, ValaSymbol* symbol);
static void vala_gir_writer_write_gtype_attributes (ValaGIRWriter* self, ValaTypeSymbol* symbol);
static gchar* vala_gir_writer_gi_type_name (ValaGIRWriter* self, ValaTypeSymbol* type_symbol);
gchar* vala_ccode_base_module_get_ccode_name (ValaCodeNode* node);
static void vala_gir_writer_write_ctype_attributes (ValaGIRWriter* self, ValaTypeSymbol* symbol, const gchar* suffix);
static void vala_gir_writer_do_write_signature (ValaGIRWriter* self, ValaMethod* m, const gchar* tag_name, gboolean instance, const gchar* name, const gchar* cname, ValaList* params, ValaDataType* return_type, gboolean can_fail);
gchar* vala_ccode_base_module_get_ccode_finish_name (ValaMethod* m);
static void vala_gir_writer_write_signature (ValaGIRWriter* self, ValaMethod* m, const gchar* tag_name, gboolean instance);
static void vala_gir_writer_real_visit_struct (ValaCodeVisitor* base, ValaStruct* st);
static void vala_gir_writer_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface);
static void vala_gir_writer_real_visit_enum (ValaCodeVisitor* base, ValaEnum* en);
static void vala_gir_writer_real_visit_enum_value (ValaCodeVisitor* base, ValaEnumValue* ev);
static gchar* vala_gir_writer_literal_expression_to_value_string (ValaGIRWriter* self, ValaExpression* literal);
static void vala_gir_writer_real_visit_error_domain (ValaCodeVisitor* base, ValaErrorDomain* edomain);
gchar* vala_ccode_base_module_get_ccode_lower_case_prefix (ValaSymbol* sym);
static void vala_gir_writer_real_visit_error_code (ValaCodeVisitor* base, ValaErrorCode* ecode);
static void vala_gir_writer_real_visit_constant (ValaCodeVisitor* base, ValaConstant* c);
static void vala_gir_writer_write_type (ValaGIRWriter* self, ValaDataType* type, gint index);
static void vala_gir_writer_real_visit_field (ValaCodeVisitor* base, ValaField* f);
static void vala_gir_writer_write_implicit_params (ValaGIRWriter* self, ValaDataType* type, gint* index, gboolean has_array_length, const gchar* name, ValaParameterDirection direction);
static void vala_gir_writer_write_param_or_return (ValaGIRWriter* self, ValaDataType* type, gboolean is_parameter, gint* index, gboolean has_array_length, const gchar* name, ValaParameterDirection direction, gboolean constructor, gboolean caller_allocates);
static void vala_gir_writer_write_params_and_return (ValaGIRWriter* self, ValaList* params, ValaDataType* return_type, gboolean return_array_length, gboolean constructor, ValaDataType* instance_type, gboolean user_data);
gboolean vala_ccode_base_module_get_ccode_array_length (ValaCodeNode* node);
static void vala_gir_writer_real_visit_delegate (ValaCodeVisitor* base, ValaDelegate* cb);
static void vala_gir_writer_real_visit_method (ValaCodeVisitor* base, ValaMethod* m);
static gboolean vala_gir_writer_check_signature (ValaGIRWriter* self, ValaMethod* m);
static gboolean vala_gir_writer_check_type (ValaGIRWriter* self, ValaDataType* type);
ValaDataType* vala_ccode_base_module_get_data_type_for_symbol (ValaTypeSymbol* sym);
static void vala_gir_writer_real_visit_creation_method (ValaCodeVisitor* base, ValaCreationMethod* m);
static void vala_gir_writer_real_visit_property (ValaCodeVisitor* base, ValaProperty* prop);
static void vala_gir_writer_real_visit_signal (ValaCodeVisitor* base, ValaSignal* sig);
static gchar* vala_gir_writer_camel_case_to_canonical (ValaGIRWriter* self, const gchar* name);
static gchar* vala_gir_writer_get_full_gir_name (ValaGIRWriter* self, ValaSymbol* sym);
static void vala_gir_writer_gir_namespace_init (ValaGIRWriterGIRNamespace *self, const gchar* ns, const gchar* version);
ValaGIRWriter* vala_gir_writer_new (void);
ValaGIRWriter* vala_gir_writer_construct (GType object_type);
static void vala_gir_writer_finalize (ValaCodeVisitor* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


void vala_gir_writer_write_includes (ValaGIRWriter* self) {
	g_return_if_fail (self != NULL);
	{
		ValaArrayList* _tmp0_;
		ValaArrayList* _tmp1_;
		ValaArrayList* _i_list;
		ValaArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _i_size;
		gint _i_index;
		_tmp0_ = self->priv->externals;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_i_list = _tmp1_;
		_tmp2_ = _i_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_i_size = _tmp4_;
		_i_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaArrayList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_ = NULL;
			ValaGIRWriterGIRNamespace* i;
			FILE* _tmp11_;
			ValaGIRWriterGIRNamespace* _tmp12_;
			const gchar* _tmp13_;
			ValaGIRWriterGIRNamespace* _tmp14_;
			const gchar* _tmp15_;
			_tmp5_ = _i_index;
			_i_index = _tmp5_ + 1;
			_tmp6_ = _i_index;
			_tmp7_ = _i_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _i_list;
			_tmp9_ = _i_index;
			_tmp10_ = vala_list_get ((ValaList*) _tmp8_, _tmp9_);
			i = (ValaGIRWriterGIRNamespace*) _tmp10_;
			vala_gir_writer_write_indent_stream (self);
			_tmp11_ = self->priv->stream;
			_tmp12_ = i;
			_tmp13_ = (*_tmp12_).ns;
			_tmp14_ = i;
			_tmp15_ = (*_tmp14_).version;
			fprintf (_tmp11_, "<include name=\"%s\" version=\"%s\"/>\n", _tmp13_, _tmp15_);
			_vala_gir_writer_gir_namespace_free0 (i);
		}
		_vala_iterable_unref0 (_i_list);
	}
}


/**
 * Writes the public interface of the specified code context into the
 * specified file.
 *
 * @param context  a code context
 * @param filename a relative or absolute filename
 */
static gpointer _vala_code_context_ref0 (gpointer self) {
	return self ? vala_code_context_ref (self) : NULL;
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


void vala_gir_writer_write_file (ValaGIRWriter* self, ValaCodeContext* context, const gchar* directory, const gchar* gir_namespace, const gchar* gir_version, const gchar* package) {
	ValaCodeContext* _tmp0_;
	ValaCodeContext* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	ValaCodeContext* _tmp8_;
	ValaNamespace* _tmp9_;
	ValaNamespace* _tmp10_;
	ValaNamespace* _tmp11_;
	ValaNamespace* root_symbol;
	ValaNamespace* _tmp12_;
	ValaScope* _tmp13_;
	ValaScope* _tmp14_;
	ValaSymbol* _tmp15_ = NULL;
	ValaSymbol* glib_ns;
	ValaSymbol* _tmp16_;
	ValaScope* _tmp17_;
	ValaScope* _tmp18_;
	ValaSymbol* _tmp19_ = NULL;
	const gchar* _tmp20_;
	ValaCodeContext* _tmp21_;
	gint _tmp22_;
	GString* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	gchar* _tmp27_ = NULL;
	gchar* filename;
	const gchar* _tmp28_;
	FILE* _tmp29_ = NULL;
	FILE* _tmp30_;
	FILE* _tmp34_;
	FILE* _tmp35_;
	FILE* _tmp36_;
	FILE* _tmp37_;
	FILE* _tmp38_;
	FILE* _tmp39_;
	gint _tmp40_;
	gint _tmp41_;
	FILE* _tmp42_;
	GString* _tmp43_;
	const gchar* _tmp44_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (directory != NULL);
	g_return_if_fail (gir_namespace != NULL);
	g_return_if_fail (gir_version != NULL);
	g_return_if_fail (package != NULL);
	_tmp0_ = context;
	_tmp1_ = _vala_code_context_ref0 (_tmp0_);
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = _tmp1_;
	_tmp2_ = directory;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->priv->directory);
	self->priv->directory = _tmp3_;
	_tmp4_ = gir_namespace;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 (self->priv->gir_namespace);
	self->priv->gir_namespace = _tmp5_;
	_tmp6_ = gir_version;
	_tmp7_ = g_strdup (_tmp6_);
	_g_free0 (self->priv->gir_version);
	self->priv->gir_version = _tmp7_;
	_tmp8_ = context;
	_tmp9_ = vala_code_context_get_root (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = _vala_code_node_ref0 (_tmp10_);
	root_symbol = _tmp11_;
	_tmp12_ = root_symbol;
	_tmp13_ = vala_symbol_get_scope ((ValaSymbol*) _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = vala_scope_lookup (_tmp14_, "GLib");
	glib_ns = _tmp15_;
	_tmp16_ = glib_ns;
	_tmp17_ = vala_symbol_get_scope (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = vala_scope_lookup (_tmp18_, "Object");
	_vala_code_node_unref0 (self->priv->gobject_type);
	self->priv->gobject_type = VALA_TYPESYMBOL (_tmp19_);
	_tmp20_ = package;
	vala_gir_writer_write_package (self, _tmp20_);
	_tmp21_ = context;
	vala_code_context_accept (_tmp21_, (ValaCodeVisitor*) self);
	_tmp22_ = self->priv->indent;
	self->priv->indent = _tmp22_ - 1;
	_tmp23_ = self->priv->buffer;
	g_string_append_printf (_tmp23_, "</repository>\n");
	_tmp24_ = directory;
	_tmp25_ = gir_namespace;
	_tmp26_ = gir_version;
	_tmp27_ = g_strdup_printf ("%s%c%s-%s.gir", _tmp24_, (gint) G_DIR_SEPARATOR, _tmp25_, _tmp26_);
	filename = _tmp27_;
	_tmp28_ = filename;
	_tmp29_ = fopen (_tmp28_, "w");
	_fclose0 (self->priv->stream);
	self->priv->stream = _tmp29_;
	_tmp30_ = self->priv->stream;
	if (_tmp30_ == NULL) {
		const gchar* _tmp31_;
		gchar* _tmp32_ = NULL;
		gchar* _tmp33_;
		_tmp31_ = filename;
		_tmp32_ = g_strdup_printf ("unable to open `%s' for writing", _tmp31_);
		_tmp33_ = _tmp32_;
		vala_report_error (NULL, _tmp33_);
		_g_free0 (_tmp33_);
		_g_free0 (filename);
		_vala_code_node_unref0 (glib_ns);
		_vala_code_node_unref0 (root_symbol);
		return;
	}
	_tmp34_ = self->priv->stream;
	fprintf (_tmp34_, "<?xml version=\"1.0\"?>\n");
	_tmp35_ = self->priv->stream;
	fprintf (_tmp35_, "<repository version=\"1.2\"");
	_tmp36_ = self->priv->stream;
	fprintf (_tmp36_, " xmlns=\"http://www.gtk.org/introspection/core/1.0\"");
	_tmp37_ = self->priv->stream;
	fprintf (_tmp37_, " xmlns:c=\"http://www.gtk.org/introspection/c/1.0\"");
	_tmp38_ = self->priv->stream;
	fprintf (_tmp38_, " xmlns:glib=\"http://www.gtk.org/introspection/glib/1.0\"");
	_tmp39_ = self->priv->stream;
	fprintf (_tmp39_, ">\n");
	_tmp40_ = self->priv->indent;
	self->priv->indent = _tmp40_ + 1;
	vala_gir_writer_write_includes (self);
	_tmp41_ = self->priv->indent;
	self->priv->indent = _tmp41_ - 1;
	_tmp42_ = self->priv->stream;
	_tmp43_ = self->priv->buffer;
	_tmp44_ = _tmp43_->str;
	fputs (_tmp44_, _tmp42_);
	_fclose0 (self->priv->stream);
	self->priv->stream = NULL;
	{
		ValaHashSet* _tmp45_;
		ValaIterator* _tmp46_ = NULL;
		ValaIterator* _ns_it;
		_tmp45_ = self->priv->unannotated_namespaces;
		_tmp46_ = vala_iterable_iterator ((ValaIterable*) _tmp45_);
		_ns_it = _tmp46_;
		while (TRUE) {
			ValaIterator* _tmp47_;
			gboolean _tmp48_ = FALSE;
			ValaIterator* _tmp49_;
			gpointer _tmp50_ = NULL;
			ValaNamespace* ns;
			ValaHashSet* _tmp51_;
			ValaNamespace* _tmp52_;
			gboolean _tmp53_ = FALSE;
			_tmp47_ = _ns_it;
			_tmp48_ = vala_iterator_next (_tmp47_);
			if (!_tmp48_) {
				break;
			}
			_tmp49_ = _ns_it;
			_tmp50_ = vala_iterator_get (_tmp49_);
			ns = (ValaNamespace*) _tmp50_;
			_tmp51_ = self->priv->our_namespaces;
			_tmp52_ = ns;
			_tmp53_ = vala_collection_contains ((ValaCollection*) _tmp51_, _tmp52_);
			if (!_tmp53_) {
				ValaNamespace* _tmp54_;
				ValaSourceReference* _tmp55_;
				ValaSourceReference* _tmp56_;
				ValaNamespace* _tmp57_;
				const gchar* _tmp58_;
				const gchar* _tmp59_;
				gchar* _tmp60_ = NULL;
				gchar* _tmp61_;
				_tmp54_ = ns;
				_tmp55_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp54_);
				_tmp56_ = _tmp55_;
				_tmp57_ = ns;
				_tmp58_ = vala_symbol_get_name ((ValaSymbol*) _tmp57_);
				_tmp59_ = _tmp58_;
				_tmp60_ = g_strdup_printf ("Namespace %s does not have a GIR namespace and version annotation", _tmp59_);
				_tmp61_ = _tmp60_;
				vala_report_warning (_tmp56_, _tmp61_);
				_g_free0 (_tmp61_);
			}
			_vala_code_node_unref0 (ns);
		}
		_vala_iterator_unref0 (_ns_it);
	}
	{
		ValaHashSet* _tmp62_;
		ValaIterator* _tmp63_ = NULL;
		ValaIterator* _ns_it;
		_tmp62_ = self->priv->our_namespaces;
		_tmp63_ = vala_iterable_iterator ((ValaIterable*) _tmp62_);
		_ns_it = _tmp63_;
		while (TRUE) {
			ValaIterator* _tmp64_;
			gboolean _tmp65_ = FALSE;
			ValaIterator* _tmp66_;
			gpointer _tmp67_ = NULL;
			ValaNamespace* ns;
			ValaNamespace* _tmp68_;
			ValaSourceReference* _tmp69_;
			ValaSourceReference* _tmp70_;
			ValaSourceFile* _tmp71_;
			ValaSourceFile* _tmp72_;
			const gchar* _tmp73_;
			ValaNamespace* _tmp74_;
			ValaSourceReference* _tmp75_;
			ValaSourceReference* _tmp76_;
			ValaSourceFile* _tmp77_;
			ValaSourceFile* _tmp78_;
			const gchar* _tmp79_;
			_tmp64_ = _ns_it;
			_tmp65_ = vala_iterator_next (_tmp64_);
			if (!_tmp65_) {
				break;
			}
			_tmp66_ = _ns_it;
			_tmp67_ = vala_iterator_get (_tmp66_);
			ns = (ValaNamespace*) _tmp67_;
			_tmp68_ = ns;
			_tmp69_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp68_);
			_tmp70_ = _tmp69_;
			_tmp71_ = vala_source_reference_get_file (_tmp70_);
			_tmp72_ = _tmp71_;
			_tmp73_ = gir_namespace;
			vala_source_file_set_gir_namespace (_tmp72_, _tmp73_);
			_tmp74_ = ns;
			_tmp75_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp74_);
			_tmp76_ = _tmp75_;
			_tmp77_ = vala_source_reference_get_file (_tmp76_);
			_tmp78_ = _tmp77_;
			_tmp79_ = gir_version;
			vala_source_file_set_gir_version (_tmp78_, _tmp79_);
			_vala_code_node_unref0 (ns);
		}
		_vala_iterator_unref0 (_ns_it);
	}
	_g_free0 (filename);
	_vala_code_node_unref0 (glib_ns);
	_vala_code_node_unref0 (root_symbol);
}


static void vala_gir_writer_write_package (ValaGIRWriter* self, const gchar* package) {
	GString* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (package != NULL);
	vala_gir_writer_write_indent (self);
	_tmp0_ = self->priv->buffer;
	_tmp1_ = package;
	g_string_append_printf (_tmp0_, "<package name=\"%s\"/>\n", _tmp1_);
}


static void vala_gir_writer_write_c_includes (ValaGIRWriter* self, ValaNamespace* ns) {
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	ValaHashSet* _tmp2_;
	ValaSet* header_filenames;
	ValaNamespace* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_ = NULL;
	gchar** _tmp8_;
	gint _tmp8__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ns != NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = vala_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, _tmp0_, _tmp1_);
	header_filenames = (ValaSet*) _tmp2_;
	_tmp3_ = ns;
	_tmp4_ = vala_ccode_base_module_get_ccode_header_filenames ((ValaSymbol*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp7_ = _tmp6_ = g_strsplit (_tmp5_, ",", 0);
	_tmp8_ = _tmp7_;
	_tmp8__length1 = _vala_array_length (_tmp6_);
	_g_free0 (_tmp5_);
	{
		gchar** c_header_filename_collection = NULL;
		gint c_header_filename_collection_length1 = 0;
		gint _c_header_filename_collection_size_ = 0;
		gint c_header_filename_it = 0;
		c_header_filename_collection = _tmp8_;
		c_header_filename_collection_length1 = _tmp8__length1;
		for (c_header_filename_it = 0; c_header_filename_it < _tmp8__length1; c_header_filename_it = c_header_filename_it + 1) {
			gchar* _tmp9_;
			gchar* c_header_filename = NULL;
			_tmp9_ = g_strdup (c_header_filename_collection[c_header_filename_it]);
			c_header_filename = _tmp9_;
			{
				ValaSet* _tmp10_;
				const gchar* _tmp11_;
				_tmp10_ = header_filenames;
				_tmp11_ = c_header_filename;
				vala_collection_add ((ValaCollection*) _tmp10_, _tmp11_);
				_g_free0 (c_header_filename);
			}
		}
		c_header_filename_collection = (_vala_array_free (c_header_filename_collection, c_header_filename_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	{
		ValaNamespace* _tmp12_;
		ValaScope* _tmp13_;
		ValaScope* _tmp14_;
		ValaMap* _tmp15_ = NULL;
		ValaMap* _tmp16_;
		ValaCollection* _tmp17_ = NULL;
		ValaCollection* _tmp18_;
		ValaIterator* _tmp19_ = NULL;
		ValaIterator* _tmp20_;
		ValaIterator* _symbol_it;
		_tmp12_ = ns;
		_tmp13_ = vala_symbol_get_scope ((ValaSymbol*) _tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = vala_scope_get_symbol_table (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_map_get_values (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_iterable_iterator ((ValaIterable*) _tmp18_);
		_tmp20_ = _tmp19_;
		_vala_iterable_unref0 (_tmp18_);
		_vala_map_unref0 (_tmp16_);
		_symbol_it = _tmp20_;
		while (TRUE) {
			ValaIterator* _tmp21_;
			gboolean _tmp22_ = FALSE;
			ValaIterator* _tmp23_;
			gpointer _tmp24_ = NULL;
			ValaSymbol* symbol;
			ValaSymbol* _tmp25_;
			gchar* _tmp26_ = NULL;
			gchar* _tmp27_;
			gchar** _tmp28_;
			gchar** _tmp29_ = NULL;
			gchar** _tmp30_;
			gint _tmp30__length1;
			_tmp21_ = _symbol_it;
			_tmp22_ = vala_iterator_next (_tmp21_);
			if (!_tmp22_) {
				break;
			}
			_tmp23_ = _symbol_it;
			_tmp24_ = vala_iterator_get (_tmp23_);
			symbol = (ValaSymbol*) _tmp24_;
			_tmp25_ = symbol;
			_tmp26_ = vala_ccode_base_module_get_ccode_header_filenames (_tmp25_);
			_tmp27_ = _tmp26_;
			_tmp29_ = _tmp28_ = g_strsplit (_tmp27_, ",", 0);
			_tmp30_ = _tmp29_;
			_tmp30__length1 = _vala_array_length (_tmp28_);
			_g_free0 (_tmp27_);
			{
				gchar** c_header_filename_collection = NULL;
				gint c_header_filename_collection_length1 = 0;
				gint _c_header_filename_collection_size_ = 0;
				gint c_header_filename_it = 0;
				c_header_filename_collection = _tmp30_;
				c_header_filename_collection_length1 = _tmp30__length1;
				for (c_header_filename_it = 0; c_header_filename_it < _tmp30__length1; c_header_filename_it = c_header_filename_it + 1) {
					gchar* _tmp31_;
					gchar* c_header_filename = NULL;
					_tmp31_ = g_strdup (c_header_filename_collection[c_header_filename_it]);
					c_header_filename = _tmp31_;
					{
						ValaSet* _tmp32_;
						const gchar* _tmp33_;
						_tmp32_ = header_filenames;
						_tmp33_ = c_header_filename;
						vala_collection_add ((ValaCollection*) _tmp32_, _tmp33_);
						_g_free0 (c_header_filename);
					}
				}
				c_header_filename_collection = (_vala_array_free (c_header_filename_collection, c_header_filename_collection_length1, (GDestroyNotify) g_free), NULL);
			}
			_vala_code_node_unref0 (symbol);
		}
		_vala_iterator_unref0 (_symbol_it);
	}
	{
		ValaSet* _tmp34_;
		ValaIterator* _tmp35_ = NULL;
		ValaIterator* _c_header_filename_it;
		_tmp34_ = header_filenames;
		_tmp35_ = vala_iterable_iterator ((ValaIterable*) _tmp34_);
		_c_header_filename_it = _tmp35_;
		while (TRUE) {
			ValaIterator* _tmp36_;
			gboolean _tmp37_ = FALSE;
			ValaIterator* _tmp38_;
			gpointer _tmp39_ = NULL;
			gchar* c_header_filename;
			const gchar* _tmp40_;
			_tmp36_ = _c_header_filename_it;
			_tmp37_ = vala_iterator_next (_tmp36_);
			if (!_tmp37_) {
				break;
			}
			_tmp38_ = _c_header_filename_it;
			_tmp39_ = vala_iterator_get (_tmp38_);
			c_header_filename = (gchar*) _tmp39_;
			_tmp40_ = c_header_filename;
			vala_gir_writer_write_c_include (self, _tmp40_);
			_g_free0 (c_header_filename);
		}
		_vala_iterator_unref0 (_c_header_filename_it);
	}
	_vala_iterable_unref0 (header_filenames);
}


static void vala_gir_writer_write_c_include (ValaGIRWriter* self, const gchar* name) {
	GString* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	vala_gir_writer_write_indent (self);
	_tmp0_ = self->priv->buffer;
	_tmp1_ = name;
	g_string_append_printf (_tmp0_, "<c:include name=\"%s\"/>\n", _tmp1_);
}


static void vala_gir_writer_real_visit_namespace (ValaCodeVisitor* base, ValaNamespace* ns) {
	ValaGIRWriter * self;
	ValaNamespace* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	ValaNamespace* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	ValaNamespace* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	ValaNamespace* _tmp16_;
	GString* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	ValaNamespace* _tmp20_;
	gchar* _tmp21_ = NULL;
	gchar* cprefix;
	const gchar* _tmp22_;
	GString* _tmp25_;
	gint _tmp26_;
	ValaNamespace* _tmp27_;
	ValaArrayList* _tmp28_;
	ValaNamespace* _tmp29_;
	ValaNamespace* _tmp30_;
	ValaArrayList* _tmp31_;
	gint _tmp32_;
	GString* _tmp33_;
	ValaHashSet* _tmp34_;
	ValaNamespace* _tmp35_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (ns != NULL);
	_tmp0_ = ns;
	_tmp1_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		return;
	}
	_tmp3_ = ns;
	_tmp4_ = vala_symbol_get_name ((ValaSymbol*) _tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == NULL) {
		ValaArrayList* _tmp6_;
		ValaNamespace* _tmp7_;
		ValaNamespace* _tmp8_;
		ValaArrayList* _tmp9_;
		_tmp6_ = self->priv->hierarchy;
		_tmp7_ = ns;
		vala_list_insert ((ValaList*) _tmp6_, 0, (ValaSymbol*) _tmp7_);
		_tmp8_ = ns;
		vala_code_node_accept_children ((ValaCodeNode*) _tmp8_, (ValaCodeVisitor*) self);
		_tmp9_ = self->priv->hierarchy;
		vala_list_remove_at ((ValaList*) _tmp9_, 0);
		return;
	}
	_tmp10_ = ns;
	_tmp11_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = vala_symbol_get_name (_tmp12_);
	_tmp14_ = _tmp13_;
	if (_tmp14_ != NULL) {
		ValaNamespace* _tmp15_;
		_tmp15_ = ns;
		vala_code_node_accept_children ((ValaCodeNode*) _tmp15_, (ValaCodeVisitor*) self);
		return;
	}
	_tmp16_ = ns;
	vala_gir_writer_write_c_includes (self, _tmp16_);
	vala_gir_writer_write_indent (self);
	_tmp17_ = self->priv->buffer;
	_tmp18_ = self->priv->gir_namespace;
	_tmp19_ = self->priv->gir_version;
	g_string_append_printf (_tmp17_, "<namespace name=\"%s\" version=\"%s\"", _tmp18_, _tmp19_);
	_tmp20_ = ns;
	_tmp21_ = vala_ccode_base_module_get_ccode_prefix ((ValaSymbol*) _tmp20_);
	cprefix = _tmp21_;
	_tmp22_ = cprefix;
	if (_tmp22_ != NULL) {
		GString* _tmp23_;
		const gchar* _tmp24_;
		_tmp23_ = self->priv->buffer;
		_tmp24_ = cprefix;
		g_string_append_printf (_tmp23_, " c:prefix=\"%s\"", _tmp24_);
	}
	_tmp25_ = self->priv->buffer;
	g_string_append_printf (_tmp25_, ">\n");
	_tmp26_ = self->priv->indent;
	self->priv->indent = _tmp26_ + 1;
	_tmp27_ = ns;
	vala_gir_writer_write_annotations (self, (ValaCodeNode*) _tmp27_);
	_tmp28_ = self->priv->hierarchy;
	_tmp29_ = ns;
	vala_list_insert ((ValaList*) _tmp28_, 0, (ValaSymbol*) _tmp29_);
	_tmp30_ = ns;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp30_, (ValaCodeVisitor*) self);
	_tmp31_ = self->priv->hierarchy;
	vala_list_remove_at ((ValaList*) _tmp31_, 0);
	_tmp32_ = self->priv->indent;
	self->priv->indent = _tmp32_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp33_ = self->priv->buffer;
	g_string_append_printf (_tmp33_, "</namespace>\n");
	_tmp34_ = self->priv->our_namespaces;
	_tmp35_ = ns;
	vala_collection_add ((ValaCollection*) _tmp34_, _tmp35_);
	vala_gir_writer_visit_deferred (self);
	_g_free0 (cprefix);
}


static void vala_gir_writer_write_symbol_attributes (ValaGIRWriter* self, ValaSymbol* symbol) {
	ValaSymbol* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (symbol != NULL);
	_tmp0_ = symbol;
	_tmp1_ = vala_symbol_get_deprecated (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		gchar* _tmp3_ = NULL;
		ValaSymbol* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gboolean _tmp8_;
		GString* _tmp15_;
		const gchar* _tmp16_;
		ValaSymbol* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gboolean _tmp21_;
		_tmp4_ = symbol;
		_tmp5_ = vala_symbol_get_replacement (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp6_;
		_tmp8_ = _tmp7_ == NULL;
		_g_free0 (_tmp7_);
		if (_tmp8_) {
			gchar* _tmp9_;
			_tmp9_ = g_strdup ("");
			_g_free0 (_tmp3_);
			_tmp3_ = _tmp9_;
		} else {
			ValaSymbol* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_ = NULL;
			_tmp10_ = symbol;
			_tmp11_ = vala_symbol_get_replacement (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = _tmp12_;
			_tmp14_ = g_strdup_printf ("Use %s", _tmp13_);
			_g_free0 (_tmp3_);
			_tmp3_ = _tmp14_;
			_g_free0 (_tmp13_);
		}
		_tmp15_ = self->priv->buffer;
		_tmp16_ = _tmp3_;
		g_string_append_printf (_tmp15_, " deprecated=\"%s\"", _tmp16_);
		_tmp17_ = symbol;
		_tmp18_ = vala_symbol_get_deprecated_since (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = _tmp19_;
		_tmp21_ = _tmp20_ != NULL;
		_g_free0 (_tmp20_);
		if (_tmp21_) {
			GString* _tmp22_;
			ValaSymbol* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			_tmp22_ = self->priv->buffer;
			_tmp23_ = symbol;
			_tmp24_ = vala_symbol_get_deprecated_since (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = _tmp25_;
			g_string_append_printf (_tmp22_, " deprecated-version=\"%s\"", _tmp26_);
			_g_free0 (_tmp26_);
		}
		_g_free0 (_tmp3_);
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_;
		gint _tmp8_;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_;
		glong _tmp14_;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_;
		glong _tmp17_;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


static void vala_gir_writer_real_visit_class (ValaCodeVisitor* base, ValaClass* cl) {
	ValaGIRWriter * self;
	ValaClass* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	ValaClass* _tmp3_;
	gboolean _tmp4_ = FALSE;
	ValaArrayList* _tmp5_;
	gpointer _tmp6_ = NULL;
	ValaSymbol* _tmp7_;
	gboolean _tmp8_;
	ValaClass* _tmp11_;
	ValaTypeSymbol* _tmp12_;
	gboolean _tmp13_ = FALSE;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (cl != NULL);
	_tmp0_ = cl;
	_tmp1_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		return;
	}
	_tmp3_ = cl;
	_tmp4_ = vala_gir_writer_check_accessibility (self, (ValaSymbol*) _tmp3_);
	if (!_tmp4_) {
		return;
	}
	_tmp5_ = self->priv->hierarchy;
	_tmp6_ = vala_list_get ((ValaList*) _tmp5_, 0);
	_tmp7_ = (ValaSymbol*) _tmp6_;
	_tmp8_ = !VALA_IS_NAMESPACE (_tmp7_);
	_vala_code_node_unref0 (_tmp7_);
	if (_tmp8_) {
		ValaArrayList* _tmp9_;
		ValaClass* _tmp10_;
		_tmp9_ = self->priv->deferred;
		_tmp10_ = cl;
		vala_collection_add ((ValaCollection*) _tmp9_, (ValaCodeNode*) _tmp10_);
		return;
	}
	_tmp11_ = cl;
	_tmp12_ = self->priv->gobject_type;
	_tmp13_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp11_, _tmp12_);
	if (_tmp13_) {
		ValaClass* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* gtype_struct_name;
		GString* _tmp18_;
		ValaClass* _tmp19_;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_;
		ValaClass* _tmp22_;
		GString* _tmp23_;
		const gchar* _tmp24_;
		GString* _tmp25_;
		ValaClass* _tmp26_;
		ValaClass* _tmp27_;
		ValaClass* _tmp28_;
		gchar* _tmp29_ = NULL;
		gchar* _tmp30_;
		ValaClass* _tmp31_;
		gboolean _tmp32_;
		gboolean _tmp33_;
		ValaClass* _tmp35_;
		GString* _tmp36_;
		gint _tmp37_;
		ValaClass* _tmp60_;
		GString* _tmp61_;
		gint _tmp62_;
		GString* _tmp63_;
		ValaClass* _tmp64_;
		ValaClass* _tmp65_;
		ValaClass* _tmp66_;
		gchar* _tmp67_ = NULL;
		gchar* _tmp68_;
		ValaClass* _tmp69_;
		ValaClass* _tmp70_;
		ValaClass* _tmp71_;
		gchar* _tmp72_ = NULL;
		gchar* _tmp73_;
		gint _tmp74_;
		GString* _tmp75_;
		GString* _tmp76_;
		gint _tmp77_;
		GString* _tmp78_;
		ValaClass* _tmp79_;
		const gchar* _tmp80_;
		const gchar* _tmp81_;
		ValaClass* _tmp82_;
		gchar* _tmp83_ = NULL;
		gchar* _tmp84_;
		gint _tmp85_;
		GString* _tmp86_;
		ValaArrayList* _tmp87_;
		ValaClass* _tmp88_;
		ValaClass* _tmp89_;
		ValaArrayList* _tmp90_;
		gint _tmp91_;
		GString* _tmp92_;
		GString* _tmp93_;
		const gchar* _tmp94_;
		ValaClass* _tmp95_;
		GString* _tmp96_;
		ValaClass* _tmp97_;
		const gchar* _tmp98_;
		const gchar* _tmp99_;
		GString* _tmp100_;
		gint _tmp101_;
		GString* _tmp102_;
		gint _tmp103_;
		GString* _tmp104_;
		ValaClass* _tmp105_;
		ValaClass* _tmp106_;
		ValaClass* _tmp107_;
		gchar* _tmp108_ = NULL;
		gchar* _tmp109_;
		ValaClass* _tmp110_;
		ValaClass* _tmp111_;
		ValaClass* _tmp112_;
		gchar* _tmp113_ = NULL;
		gchar* _tmp114_;
		gint _tmp115_;
		GString* _tmp116_;
		gint _tmp239_;
		GString* _tmp240_;
		GString* _tmp241_;
		ValaClass* _tmp242_;
		const gchar* _tmp243_;
		const gchar* _tmp244_;
		ValaClass* _tmp245_;
		gchar* _tmp246_ = NULL;
		gchar* _tmp247_;
		_tmp14_ = cl;
		_tmp15_ = vala_symbol_get_name ((ValaSymbol*) _tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_strconcat (_tmp16_, "Class", NULL);
		gtype_struct_name = _tmp17_;
		vala_gir_writer_write_indent (self);
		_tmp18_ = self->priv->buffer;
		_tmp19_ = cl;
		_tmp20_ = vala_gir_writer_get_gir_name (self, (ValaSymbol*) _tmp19_);
		_tmp21_ = _tmp20_;
		g_string_append_printf (_tmp18_, "<class name=\"%s\"", _tmp21_);
		_g_free0 (_tmp21_);
		_tmp22_ = cl;
		vala_gir_writer_write_gtype_attributes (self, (ValaTypeSymbol*) _tmp22_);
		_tmp23_ = self->priv->buffer;
		_tmp24_ = gtype_struct_name;
		g_string_append_printf (_tmp23_, " glib:type-struct=\"%s\"", _tmp24_);
		_tmp25_ = self->priv->buffer;
		_tmp26_ = cl;
		_tmp27_ = vala_class_get_base_class (_tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = vala_gir_writer_gi_type_name (self, (ValaTypeSymbol*) _tmp28_);
		_tmp30_ = _tmp29_;
		g_string_append_printf (_tmp25_, " parent=\"%s\"", _tmp30_);
		_g_free0 (_tmp30_);
		_tmp31_ = cl;
		_tmp32_ = vala_class_get_is_abstract (_tmp31_);
		_tmp33_ = _tmp32_;
		if (_tmp33_) {
			GString* _tmp34_;
			_tmp34_ = self->priv->buffer;
			g_string_append_printf (_tmp34_, " abstract=\"1\"");
		}
		_tmp35_ = cl;
		vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) _tmp35_);
		_tmp36_ = self->priv->buffer;
		g_string_append_printf (_tmp36_, ">\n");
		_tmp37_ = self->priv->indent;
		self->priv->indent = _tmp37_ + 1;
		{
			ValaClass* _tmp38_;
			ValaList* _tmp39_ = NULL;
			ValaList* _base_type_list;
			ValaList* _tmp40_;
			gint _tmp41_;
			gint _tmp42_;
			gint _base_type_size;
			gint _base_type_index;
			_tmp38_ = cl;
			_tmp39_ = vala_class_get_base_types (_tmp38_);
			_base_type_list = _tmp39_;
			_tmp40_ = _base_type_list;
			_tmp41_ = vala_collection_get_size ((ValaCollection*) _tmp40_);
			_tmp42_ = _tmp41_;
			_base_type_size = _tmp42_;
			_base_type_index = -1;
			while (TRUE) {
				gint _tmp43_;
				gint _tmp44_;
				gint _tmp45_;
				ValaList* _tmp46_;
				gint _tmp47_;
				gpointer _tmp48_ = NULL;
				ValaDataType* base_type;
				ValaDataType* _tmp49_;
				ValaObjectType* _tmp50_;
				ValaObjectType* object_type;
				ValaObjectType* _tmp51_;
				ValaObjectTypeSymbol* _tmp52_;
				ValaObjectTypeSymbol* _tmp53_;
				_tmp43_ = _base_type_index;
				_base_type_index = _tmp43_ + 1;
				_tmp44_ = _base_type_index;
				_tmp45_ = _base_type_size;
				if (!(_tmp44_ < _tmp45_)) {
					break;
				}
				_tmp46_ = _base_type_list;
				_tmp47_ = _base_type_index;
				_tmp48_ = vala_list_get (_tmp46_, _tmp47_);
				base_type = (ValaDataType*) _tmp48_;
				_tmp49_ = base_type;
				_tmp50_ = _vala_code_node_ref0 (VALA_OBJECT_TYPE (_tmp49_));
				object_type = _tmp50_;
				_tmp51_ = object_type;
				_tmp52_ = vala_object_type_get_type_symbol (_tmp51_);
				_tmp53_ = _tmp52_;
				if (VALA_IS_INTERFACE (_tmp53_)) {
					GString* _tmp54_;
					ValaObjectType* _tmp55_;
					ValaObjectTypeSymbol* _tmp56_;
					ValaObjectTypeSymbol* _tmp57_;
					gchar* _tmp58_ = NULL;
					gchar* _tmp59_;
					vala_gir_writer_write_indent (self);
					_tmp54_ = self->priv->buffer;
					_tmp55_ = object_type;
					_tmp56_ = vala_object_type_get_type_symbol (_tmp55_);
					_tmp57_ = _tmp56_;
					_tmp58_ = vala_gir_writer_gi_type_name (self, (ValaTypeSymbol*) _tmp57_);
					_tmp59_ = _tmp58_;
					g_string_append_printf (_tmp54_, "<implements name=\"%s\"/>\n", _tmp59_);
					_g_free0 (_tmp59_);
				}
				_vala_code_node_unref0 (object_type);
				_vala_code_node_unref0 (base_type);
			}
			_vala_iterable_unref0 (_base_type_list);
		}
		_tmp60_ = cl;
		vala_gir_writer_write_annotations (self, (ValaCodeNode*) _tmp60_);
		vala_gir_writer_write_indent (self);
		_tmp61_ = self->priv->buffer;
		g_string_append_printf (_tmp61_, "<field name=\"parent_instance\">\n");
		_tmp62_ = self->priv->indent;
		self->priv->indent = _tmp62_ + 1;
		vala_gir_writer_write_indent (self);
		_tmp63_ = self->priv->buffer;
		_tmp64_ = cl;
		_tmp65_ = vala_class_get_base_class (_tmp64_);
		_tmp66_ = _tmp65_;
		_tmp67_ = vala_gir_writer_gi_type_name (self, (ValaTypeSymbol*) _tmp66_);
		_tmp68_ = _tmp67_;
		_tmp69_ = cl;
		_tmp70_ = vala_class_get_base_class (_tmp69_);
		_tmp71_ = _tmp70_;
		_tmp72_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp71_);
		_tmp73_ = _tmp72_;
		g_string_append_printf (_tmp63_, "<type name=\"%s\" c:type=\"%s\"/>\n", _tmp68_, _tmp73_);
		_g_free0 (_tmp73_);
		_g_free0 (_tmp68_);
		_tmp74_ = self->priv->indent;
		self->priv->indent = _tmp74_ - 1;
		vala_gir_writer_write_indent (self);
		_tmp75_ = self->priv->buffer;
		g_string_append_printf (_tmp75_, "</field>\n");
		vala_gir_writer_write_indent (self);
		_tmp76_ = self->priv->buffer;
		g_string_append_printf (_tmp76_, "<field name=\"priv\">\n");
		_tmp77_ = self->priv->indent;
		self->priv->indent = _tmp77_ + 1;
		vala_gir_writer_write_indent (self);
		_tmp78_ = self->priv->buffer;
		_tmp79_ = cl;
		_tmp80_ = vala_symbol_get_name ((ValaSymbol*) _tmp79_);
		_tmp81_ = _tmp80_;
		_tmp82_ = cl;
		_tmp83_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp82_);
		_tmp84_ = _tmp83_;
		g_string_append_printf (_tmp78_, "<type name=\"%sPrivate\" c:type=\"%sPrivate*\"/>\n", _tmp81_, _tmp84_);
		_g_free0 (_tmp84_);
		_tmp85_ = self->priv->indent;
		self->priv->indent = _tmp85_ - 1;
		vala_gir_writer_write_indent (self);
		_tmp86_ = self->priv->buffer;
		g_string_append_printf (_tmp86_, "</field>\n");
		_tmp87_ = self->priv->hierarchy;
		_tmp88_ = cl;
		vala_list_insert ((ValaList*) _tmp87_, 0, (ValaSymbol*) _tmp88_);
		_tmp89_ = cl;
		vala_code_node_accept_children ((ValaCodeNode*) _tmp89_, (ValaCodeVisitor*) self);
		_tmp90_ = self->priv->hierarchy;
		vala_list_remove_at ((ValaList*) _tmp90_, 0);
		_tmp91_ = self->priv->indent;
		self->priv->indent = _tmp91_ - 1;
		vala_gir_writer_write_indent (self);
		_tmp92_ = self->priv->buffer;
		g_string_append_printf (_tmp92_, "</class>\n");
		vala_gir_writer_write_indent (self);
		_tmp93_ = self->priv->buffer;
		_tmp94_ = gtype_struct_name;
		g_string_append_printf (_tmp93_, "<record name=\"%s\"", _tmp94_);
		_tmp95_ = cl;
		vala_gir_writer_write_ctype_attributes (self, (ValaTypeSymbol*) _tmp95_, "Class");
		_tmp96_ = self->priv->buffer;
		_tmp97_ = cl;
		_tmp98_ = vala_symbol_get_name ((ValaSymbol*) _tmp97_);
		_tmp99_ = _tmp98_;
		g_string_append_printf (_tmp96_, " glib:is-gtype-struct-for=\"%s\"", _tmp99_);
		_tmp100_ = self->priv->buffer;
		g_string_append_printf (_tmp100_, ">\n");
		_tmp101_ = self->priv->indent;
		self->priv->indent = _tmp101_ + 1;
		vala_gir_writer_write_indent (self);
		_tmp102_ = self->priv->buffer;
		g_string_append_printf (_tmp102_, "<field name=\"parent_class\">\n");
		_tmp103_ = self->priv->indent;
		self->priv->indent = _tmp103_ + 1;
		vala_gir_writer_write_indent (self);
		_tmp104_ = self->priv->buffer;
		_tmp105_ = cl;
		_tmp106_ = vala_class_get_base_class (_tmp105_);
		_tmp107_ = _tmp106_;
		_tmp108_ = vala_gir_writer_gi_type_name (self, (ValaTypeSymbol*) _tmp107_);
		_tmp109_ = _tmp108_;
		_tmp110_ = cl;
		_tmp111_ = vala_class_get_base_class (_tmp110_);
		_tmp112_ = _tmp111_;
		_tmp113_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp112_);
		_tmp114_ = _tmp113_;
		g_string_append_printf (_tmp104_, "<type name=\"%sClass\" c:type=\"%sClass\"/>\n", _tmp109_, _tmp114_);
		_g_free0 (_tmp114_);
		_g_free0 (_tmp109_);
		_tmp115_ = self->priv->indent;
		self->priv->indent = _tmp115_ - 1;
		vala_gir_writer_write_indent (self);
		_tmp116_ = self->priv->buffer;
		g_string_append_printf (_tmp116_, "</field>\n");
		{
			ValaClass* _tmp117_;
			ValaList* _tmp118_ = NULL;
			ValaList* _m_list;
			ValaList* _tmp119_;
			gint _tmp120_;
			gint _tmp121_;
			gint _m_size;
			gint _m_index;
			_tmp117_ = cl;
			_tmp118_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp117_);
			_m_list = _tmp118_;
			_tmp119_ = _m_list;
			_tmp120_ = vala_collection_get_size ((ValaCollection*) _tmp119_);
			_tmp121_ = _tmp120_;
			_m_size = _tmp121_;
			_m_index = -1;
			while (TRUE) {
				gint _tmp122_;
				gint _tmp123_;
				gint _tmp124_;
				ValaList* _tmp125_;
				gint _tmp126_;
				gpointer _tmp127_ = NULL;
				ValaMethod* m;
				gboolean _tmp128_ = FALSE;
				ValaMethod* _tmp129_;
				gboolean _tmp130_;
				gboolean _tmp131_;
				gboolean _tmp135_;
				_tmp122_ = _m_index;
				_m_index = _tmp122_ + 1;
				_tmp123_ = _m_index;
				_tmp124_ = _m_size;
				if (!(_tmp123_ < _tmp124_)) {
					break;
				}
				_tmp125_ = _m_list;
				_tmp126_ = _m_index;
				_tmp127_ = vala_list_get (_tmp125_, _tmp126_);
				m = (ValaMethod*) _tmp127_;
				_tmp129_ = m;
				_tmp130_ = vala_method_get_is_abstract (_tmp129_);
				_tmp131_ = _tmp130_;
				if (_tmp131_) {
					_tmp128_ = TRUE;
				} else {
					ValaMethod* _tmp132_;
					gboolean _tmp133_;
					gboolean _tmp134_;
					_tmp132_ = m;
					_tmp133_ = vala_method_get_is_virtual (_tmp132_);
					_tmp134_ = _tmp133_;
					_tmp128_ = _tmp134_;
				}
				_tmp135_ = _tmp128_;
				if (_tmp135_) {
					ValaMethod* _tmp136_;
					gboolean _tmp137_;
					gboolean _tmp138_;
					vala_gir_writer_write_indent (self);
					_tmp136_ = m;
					_tmp137_ = vala_method_get_coroutine (_tmp136_);
					_tmp138_ = _tmp137_;
					if (_tmp138_) {
						ValaMethod* _tmp139_;
						const gchar* _tmp140_;
						const gchar* _tmp141_;
						gchar* _tmp142_;
						gchar* finish_name;
						const gchar* _tmp143_;
						gboolean _tmp144_ = FALSE;
						const gchar* _tmp152_;
						gchar* _tmp153_;
						GString* _tmp154_;
						ValaMethod* _tmp155_;
						const gchar* _tmp156_;
						const gchar* _tmp157_;
						gint _tmp158_;
						ValaMethod* _tmp159_;
						ValaMethod* _tmp160_;
						const gchar* _tmp161_;
						const gchar* _tmp162_;
						ValaMethod* _tmp163_;
						gchar* _tmp164_ = NULL;
						gchar* _tmp165_;
						ValaMethod* _tmp166_;
						ValaList* _tmp167_ = NULL;
						ValaList* _tmp168_;
						ValaVoidType* _tmp169_;
						ValaVoidType* _tmp170_;
						gint _tmp171_;
						GString* _tmp172_;
						GString* _tmp173_;
						const gchar* _tmp174_;
						gint _tmp175_;
						ValaMethod* _tmp176_;
						const gchar* _tmp177_;
						ValaMethod* _tmp178_;
						gchar* _tmp179_ = NULL;
						gchar* _tmp180_;
						ValaMethod* _tmp181_;
						ValaList* _tmp182_ = NULL;
						ValaList* _tmp183_;
						ValaMethod* _tmp184_;
						ValaDataType* _tmp185_;
						ValaDataType* _tmp186_;
						ValaMethod* _tmp187_;
						gboolean _tmp188_;
						gboolean _tmp189_;
						gint _tmp190_;
						GString* _tmp191_;
						_tmp139_ = m;
						_tmp140_ = vala_symbol_get_name ((ValaSymbol*) _tmp139_);
						_tmp141_ = _tmp140_;
						_tmp142_ = g_strdup (_tmp141_);
						finish_name = _tmp142_;
						_tmp143_ = finish_name;
						_tmp144_ = g_str_has_suffix (_tmp143_, "_async");
						if (_tmp144_) {
							const gchar* _tmp145_;
							const gchar* _tmp146_;
							gint _tmp147_;
							gint _tmp148_;
							gint _tmp149_;
							gint _tmp150_;
							gchar* _tmp151_ = NULL;
							_tmp145_ = finish_name;
							_tmp146_ = finish_name;
							_tmp147_ = strlen (_tmp146_);
							_tmp148_ = _tmp147_;
							_tmp149_ = strlen ("_async");
							_tmp150_ = _tmp149_;
							_tmp151_ = string_substring (_tmp145_, (glong) 0, (glong) (_tmp148_ - _tmp150_));
							_g_free0 (finish_name);
							finish_name = _tmp151_;
						}
						_tmp152_ = finish_name;
						_tmp153_ = g_strconcat (_tmp152_, "_finish", NULL);
						_g_free0 (finish_name);
						finish_name = _tmp153_;
						vala_gir_writer_write_indent (self);
						_tmp154_ = self->priv->buffer;
						_tmp155_ = m;
						_tmp156_ = vala_symbol_get_name ((ValaSymbol*) _tmp155_);
						_tmp157_ = _tmp156_;
						g_string_append_printf (_tmp154_, "<field name=\"%s\">\n", _tmp157_);
						_tmp158_ = self->priv->indent;
						self->priv->indent = _tmp158_ + 1;
						_tmp159_ = m;
						_tmp160_ = m;
						_tmp161_ = vala_symbol_get_name ((ValaSymbol*) _tmp160_);
						_tmp162_ = _tmp161_;
						_tmp163_ = m;
						_tmp164_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp163_);
						_tmp165_ = _tmp164_;
						_tmp166_ = m;
						_tmp167_ = vala_method_get_async_begin_parameters (_tmp166_);
						_tmp168_ = _tmp167_;
						_tmp169_ = vala_void_type_new (NULL);
						_tmp170_ = _tmp169_;
						vala_gir_writer_do_write_signature (self, _tmp159_, "callback", TRUE, _tmp162_, _tmp165_, _tmp168_, (ValaDataType*) _tmp170_, FALSE);
						_vala_code_node_unref0 (_tmp170_);
						_vala_iterable_unref0 (_tmp168_);
						_g_free0 (_tmp165_);
						_tmp171_ = self->priv->indent;
						self->priv->indent = _tmp171_ - 1;
						vala_gir_writer_write_indent (self);
						_tmp172_ = self->priv->buffer;
						g_string_append_printf (_tmp172_, "</field>\n");
						vala_gir_writer_write_indent (self);
						_tmp173_ = self->priv->buffer;
						_tmp174_ = finish_name;
						g_string_append_printf (_tmp173_, "<field name=\"%s\">\n", _tmp174_);
						_tmp175_ = self->priv->indent;
						self->priv->indent = _tmp175_ + 1;
						_tmp176_ = m;
						_tmp177_ = finish_name;
						_tmp178_ = m;
						_tmp179_ = vala_ccode_base_module_get_ccode_finish_name (_tmp178_);
						_tmp180_ = _tmp179_;
						_tmp181_ = m;
						_tmp182_ = vala_method_get_async_end_parameters (_tmp181_);
						_tmp183_ = _tmp182_;
						_tmp184_ = m;
						_tmp185_ = vala_method_get_return_type (_tmp184_);
						_tmp186_ = _tmp185_;
						_tmp187_ = m;
						_tmp188_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) _tmp187_);
						_tmp189_ = _tmp188_;
						vala_gir_writer_do_write_signature (self, _tmp176_, "callback", TRUE, _tmp177_, _tmp180_, _tmp183_, _tmp186_, _tmp189_);
						_vala_iterable_unref0 (_tmp183_);
						_g_free0 (_tmp180_);
						_tmp190_ = self->priv->indent;
						self->priv->indent = _tmp190_ - 1;
						vala_gir_writer_write_indent (self);
						_tmp191_ = self->priv->buffer;
						g_string_append_printf (_tmp191_, "</field>\n");
						_g_free0 (finish_name);
					} else {
						GString* _tmp192_;
						ValaMethod* _tmp193_;
						const gchar* _tmp194_;
						const gchar* _tmp195_;
						gint _tmp196_;
						ValaMethod* _tmp197_;
						ValaMethod* _tmp198_;
						const gchar* _tmp199_;
						const gchar* _tmp200_;
						ValaMethod* _tmp201_;
						gchar* _tmp202_ = NULL;
						gchar* _tmp203_;
						ValaMethod* _tmp204_;
						ValaList* _tmp205_ = NULL;
						ValaList* _tmp206_;
						ValaMethod* _tmp207_;
						ValaDataType* _tmp208_;
						ValaDataType* _tmp209_;
						ValaMethod* _tmp210_;
						gboolean _tmp211_;
						gboolean _tmp212_;
						gint _tmp213_;
						GString* _tmp214_;
						vala_gir_writer_write_indent (self);
						_tmp192_ = self->priv->buffer;
						_tmp193_ = m;
						_tmp194_ = vala_symbol_get_name ((ValaSymbol*) _tmp193_);
						_tmp195_ = _tmp194_;
						g_string_append_printf (_tmp192_, "<field name=\"%s\">\n", _tmp195_);
						_tmp196_ = self->priv->indent;
						self->priv->indent = _tmp196_ + 1;
						_tmp197_ = m;
						_tmp198_ = m;
						_tmp199_ = vala_symbol_get_name ((ValaSymbol*) _tmp198_);
						_tmp200_ = _tmp199_;
						_tmp201_ = m;
						_tmp202_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp201_);
						_tmp203_ = _tmp202_;
						_tmp204_ = m;
						_tmp205_ = vala_method_get_parameters (_tmp204_);
						_tmp206_ = _tmp205_;
						_tmp207_ = m;
						_tmp208_ = vala_method_get_return_type (_tmp207_);
						_tmp209_ = _tmp208_;
						_tmp210_ = m;
						_tmp211_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) _tmp210_);
						_tmp212_ = _tmp211_;
						vala_gir_writer_do_write_signature (self, _tmp197_, "callback", TRUE, _tmp200_, _tmp203_, _tmp206_, _tmp209_, _tmp212_);
						_vala_iterable_unref0 (_tmp206_);
						_g_free0 (_tmp203_);
						_tmp213_ = self->priv->indent;
						self->priv->indent = _tmp213_ - 1;
						vala_gir_writer_write_indent (self);
						_tmp214_ = self->priv->buffer;
						g_string_append_printf (_tmp214_, "</field>\n");
					}
				}
				_vala_code_node_unref0 (m);
			}
			_vala_iterable_unref0 (_m_list);
		}
		{
			ValaClass* _tmp215_;
			ValaList* _tmp216_ = NULL;
			ValaList* _sig_list;
			ValaList* _tmp217_;
			gint _tmp218_;
			gint _tmp219_;
			gint _sig_size;
			gint _sig_index;
			_tmp215_ = cl;
			_tmp216_ = vala_object_type_symbol_get_signals ((ValaObjectTypeSymbol*) _tmp215_);
			_sig_list = _tmp216_;
			_tmp217_ = _sig_list;
			_tmp218_ = vala_collection_get_size ((ValaCollection*) _tmp217_);
			_tmp219_ = _tmp218_;
			_sig_size = _tmp219_;
			_sig_index = -1;
			while (TRUE) {
				gint _tmp220_;
				gint _tmp221_;
				gint _tmp222_;
				ValaList* _tmp223_;
				gint _tmp224_;
				gpointer _tmp225_ = NULL;
				ValaSignal* sig;
				ValaSignal* _tmp226_;
				ValaMethod* _tmp227_;
				ValaMethod* _tmp228_;
				_tmp220_ = _sig_index;
				_sig_index = _tmp220_ + 1;
				_tmp221_ = _sig_index;
				_tmp222_ = _sig_size;
				if (!(_tmp221_ < _tmp222_)) {
					break;
				}
				_tmp223_ = _sig_list;
				_tmp224_ = _sig_index;
				_tmp225_ = vala_list_get (_tmp223_, _tmp224_);
				sig = (ValaSignal*) _tmp225_;
				_tmp226_ = sig;
				_tmp227_ = vala_signal_get_default_handler (_tmp226_);
				_tmp228_ = _tmp227_;
				if (_tmp228_ != NULL) {
					GString* _tmp229_;
					ValaSignal* _tmp230_;
					const gchar* _tmp231_;
					const gchar* _tmp232_;
					gint _tmp233_;
					ValaSignal* _tmp234_;
					ValaMethod* _tmp235_;
					ValaMethod* _tmp236_;
					gint _tmp237_;
					GString* _tmp238_;
					vala_gir_writer_write_indent (self);
					_tmp229_ = self->priv->buffer;
					_tmp230_ = sig;
					_tmp231_ = vala_symbol_get_name ((ValaSymbol*) _tmp230_);
					_tmp232_ = _tmp231_;
					g_string_append_printf (_tmp229_, "<field name=\"%s\">\n", _tmp232_);
					_tmp233_ = self->priv->indent;
					self->priv->indent = _tmp233_ + 1;
					_tmp234_ = sig;
					_tmp235_ = vala_signal_get_default_handler (_tmp234_);
					_tmp236_ = _tmp235_;
					vala_gir_writer_write_signature (self, _tmp236_, "callback", TRUE);
					_tmp237_ = self->priv->indent;
					self->priv->indent = _tmp237_ - 1;
					vala_gir_writer_write_indent (self);
					_tmp238_ = self->priv->buffer;
					g_string_append_printf (_tmp238_, "</field>\n");
				}
				_vala_code_node_unref0 (sig);
			}
			_vala_iterable_unref0 (_sig_list);
		}
		_tmp239_ = self->priv->indent;
		self->priv->indent = _tmp239_ - 1;
		vala_gir_writer_write_indent (self);
		_tmp240_ = self->priv->buffer;
		g_string_append_printf (_tmp240_, "</record>\n");
		vala_gir_writer_write_indent (self);
		_tmp241_ = self->priv->buffer;
		_tmp242_ = cl;
		_tmp243_ = vala_symbol_get_name ((ValaSymbol*) _tmp242_);
		_tmp244_ = _tmp243_;
		_tmp245_ = cl;
		_tmp246_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp245_);
		_tmp247_ = _tmp246_;
		g_string_append_printf (_tmp241_, "<record name=\"%sPrivate\" c:type=\"%sPrivate\" disguised=\"1\"/>\n", _tmp244_, _tmp247_);
		_g_free0 (_tmp247_);
		_g_free0 (gtype_struct_name);
	} else {
		GString* _tmp248_;
		ValaClass* _tmp249_;
		gchar* _tmp250_ = NULL;
		gchar* _tmp251_;
		ValaClass* _tmp252_;
		GString* _tmp253_;
		gint _tmp254_;
		ValaClass* _tmp255_;
		ValaArrayList* _tmp256_;
		ValaClass* _tmp257_;
		ValaClass* _tmp258_;
		ValaArrayList* _tmp259_;
		gint _tmp260_;
		GString* _tmp261_;
		vala_gir_writer_write_indent (self);
		_tmp248_ = self->priv->buffer;
		_tmp249_ = cl;
		_tmp250_ = vala_gir_writer_get_gir_name (self, (ValaSymbol*) _tmp249_);
		_tmp251_ = _tmp250_;
		g_string_append_printf (_tmp248_, "<record name=\"%s\"", _tmp251_);
		_g_free0 (_tmp251_);
		_tmp252_ = cl;
		vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) _tmp252_);
		_tmp253_ = self->priv->buffer;
		g_string_append_printf (_tmp253_, ">\n");
		_tmp254_ = self->priv->indent;
		self->priv->indent = _tmp254_ + 1;
		_tmp255_ = cl;
		vala_gir_writer_write_annotations (self, (ValaCodeNode*) _tmp255_);
		_tmp256_ = self->priv->hierarchy;
		_tmp257_ = cl;
		vala_list_insert ((ValaList*) _tmp256_, 0, (ValaSymbol*) _tmp257_);
		_tmp258_ = cl;
		vala_code_node_accept_children ((ValaCodeNode*) _tmp258_, (ValaCodeVisitor*) self);
		_tmp259_ = self->priv->hierarchy;
		vala_list_remove_at ((ValaList*) _tmp259_, 0);
		_tmp260_ = self->priv->indent;
		self->priv->indent = _tmp260_ - 1;
		vala_gir_writer_write_indent (self);
		_tmp261_ = self->priv->buffer;
		g_string_append_printf (_tmp261_, "</record>\n");
	}
	vala_gir_writer_visit_deferred (self);
}


static void vala_gir_writer_real_visit_struct (ValaCodeVisitor* base, ValaStruct* st) {
	ValaGIRWriter * self;
	ValaStruct* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	ValaStruct* _tmp3_;
	gboolean _tmp4_ = FALSE;
	ValaArrayList* _tmp5_;
	gpointer _tmp6_ = NULL;
	ValaSymbol* _tmp7_;
	gboolean _tmp8_;
	GString* _tmp11_;
	ValaStruct* _tmp12_;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_;
	ValaStruct* _tmp15_;
	GString* _tmp16_;
	gint _tmp17_;
	ValaStruct* _tmp18_;
	ValaArrayList* _tmp19_;
	ValaStruct* _tmp20_;
	ValaStruct* _tmp21_;
	ValaArrayList* _tmp22_;
	gint _tmp23_;
	GString* _tmp24_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (st != NULL);
	_tmp0_ = st;
	_tmp1_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		return;
	}
	_tmp3_ = st;
	_tmp4_ = vala_gir_writer_check_accessibility (self, (ValaSymbol*) _tmp3_);
	if (!_tmp4_) {
		return;
	}
	_tmp5_ = self->priv->hierarchy;
	_tmp6_ = vala_list_get ((ValaList*) _tmp5_, 0);
	_tmp7_ = (ValaSymbol*) _tmp6_;
	_tmp8_ = !VALA_IS_NAMESPACE (_tmp7_);
	_vala_code_node_unref0 (_tmp7_);
	if (_tmp8_) {
		ValaArrayList* _tmp9_;
		ValaStruct* _tmp10_;
		_tmp9_ = self->priv->deferred;
		_tmp10_ = st;
		vala_collection_add ((ValaCollection*) _tmp9_, (ValaCodeNode*) _tmp10_);
		return;
	}
	vala_gir_writer_write_indent (self);
	_tmp11_ = self->priv->buffer;
	_tmp12_ = st;
	_tmp13_ = vala_gir_writer_get_gir_name (self, (ValaSymbol*) _tmp12_);
	_tmp14_ = _tmp13_;
	g_string_append_printf (_tmp11_, "<record name=\"%s\"", _tmp14_);
	_g_free0 (_tmp14_);
	_tmp15_ = st;
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) _tmp15_);
	_tmp16_ = self->priv->buffer;
	g_string_append_printf (_tmp16_, ">\n");
	_tmp17_ = self->priv->indent;
	self->priv->indent = _tmp17_ + 1;
	_tmp18_ = st;
	vala_gir_writer_write_annotations (self, (ValaCodeNode*) _tmp18_);
	_tmp19_ = self->priv->hierarchy;
	_tmp20_ = st;
	vala_list_insert ((ValaList*) _tmp19_, 0, (ValaSymbol*) _tmp20_);
	_tmp21_ = st;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp21_, (ValaCodeVisitor*) self);
	_tmp22_ = self->priv->hierarchy;
	vala_list_remove_at ((ValaList*) _tmp22_, 0);
	_tmp23_ = self->priv->indent;
	self->priv->indent = _tmp23_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp24_ = self->priv->buffer;
	g_string_append_printf (_tmp24_, "</record>\n");
	vala_gir_writer_visit_deferred (self);
}


static void vala_gir_writer_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface) {
	ValaGIRWriter * self;
	ValaInterface* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	ValaInterface* _tmp3_;
	gboolean _tmp4_ = FALSE;
	ValaArrayList* _tmp5_;
	gpointer _tmp6_ = NULL;
	ValaSymbol* _tmp7_;
	gboolean _tmp8_;
	ValaInterface* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* gtype_struct_name;
	GString* _tmp15_;
	ValaInterface* _tmp16_;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_;
	ValaInterface* _tmp19_;
	GString* _tmp20_;
	const gchar* _tmp21_;
	ValaInterface* _tmp22_;
	GString* _tmp23_;
	gint _tmp24_;
	ValaInterface* _tmp25_;
	ValaList* _tmp26_ = NULL;
	ValaList* _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	gboolean _tmp30_;
	ValaInterface* _tmp48_;
	ValaArrayList* _tmp49_;
	ValaInterface* _tmp50_;
	ValaInterface* _tmp51_;
	ValaArrayList* _tmp52_;
	gint _tmp53_;
	GString* _tmp54_;
	GString* _tmp55_;
	const gchar* _tmp56_;
	ValaInterface* _tmp57_;
	GString* _tmp58_;
	ValaInterface* _tmp59_;
	const gchar* _tmp60_;
	const gchar* _tmp61_;
	GString* _tmp62_;
	gint _tmp63_;
	GString* _tmp64_;
	gint _tmp65_;
	GString* _tmp66_;
	gint _tmp67_;
	GString* _tmp68_;
	gint _tmp167_;
	GString* _tmp168_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (iface != NULL);
	_tmp0_ = iface;
	_tmp1_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		return;
	}
	_tmp3_ = iface;
	_tmp4_ = vala_gir_writer_check_accessibility (self, (ValaSymbol*) _tmp3_);
	if (!_tmp4_) {
		return;
	}
	_tmp5_ = self->priv->hierarchy;
	_tmp6_ = vala_list_get ((ValaList*) _tmp5_, 0);
	_tmp7_ = (ValaSymbol*) _tmp6_;
	_tmp8_ = !VALA_IS_NAMESPACE (_tmp7_);
	_vala_code_node_unref0 (_tmp7_);
	if (_tmp8_) {
		ValaArrayList* _tmp9_;
		ValaInterface* _tmp10_;
		_tmp9_ = self->priv->deferred;
		_tmp10_ = iface;
		vala_collection_add ((ValaCollection*) _tmp9_, (ValaCodeNode*) _tmp10_);
		return;
	}
	_tmp11_ = iface;
	_tmp12_ = vala_symbol_get_name ((ValaSymbol*) _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strconcat (_tmp13_, "Iface", NULL);
	gtype_struct_name = _tmp14_;
	vala_gir_writer_write_indent (self);
	_tmp15_ = self->priv->buffer;
	_tmp16_ = iface;
	_tmp17_ = vala_gir_writer_get_gir_name (self, (ValaSymbol*) _tmp16_);
	_tmp18_ = _tmp17_;
	g_string_append_printf (_tmp15_, "<interface name=\"%s\"", _tmp18_);
	_g_free0 (_tmp18_);
	_tmp19_ = iface;
	vala_gir_writer_write_gtype_attributes (self, (ValaTypeSymbol*) _tmp19_);
	_tmp20_ = self->priv->buffer;
	_tmp21_ = gtype_struct_name;
	g_string_append_printf (_tmp20_, " glib:type-struct=\"%s\"", _tmp21_);
	_tmp22_ = iface;
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) _tmp22_);
	_tmp23_ = self->priv->buffer;
	g_string_append_printf (_tmp23_, ">\n");
	_tmp24_ = self->priv->indent;
	self->priv->indent = _tmp24_ + 1;
	_tmp25_ = iface;
	_tmp26_ = vala_interface_get_prerequisites (_tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = vala_collection_get_size ((ValaCollection*) _tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = _tmp29_ > 0;
	_vala_iterable_unref0 (_tmp27_);
	if (_tmp30_) {
		{
			ValaInterface* _tmp31_;
			ValaList* _tmp32_ = NULL;
			ValaList* _base_type_list;
			ValaList* _tmp33_;
			gint _tmp34_;
			gint _tmp35_;
			gint _base_type_size;
			gint _base_type_index;
			_tmp31_ = iface;
			_tmp32_ = vala_interface_get_prerequisites (_tmp31_);
			_base_type_list = _tmp32_;
			_tmp33_ = _base_type_list;
			_tmp34_ = vala_collection_get_size ((ValaCollection*) _tmp33_);
			_tmp35_ = _tmp34_;
			_base_type_size = _tmp35_;
			_base_type_index = -1;
			while (TRUE) {
				gint _tmp36_;
				gint _tmp37_;
				gint _tmp38_;
				ValaList* _tmp39_;
				gint _tmp40_;
				gpointer _tmp41_ = NULL;
				ValaDataType* base_type;
				GString* _tmp42_;
				ValaDataType* _tmp43_;
				ValaObjectTypeSymbol* _tmp44_;
				ValaObjectTypeSymbol* _tmp45_;
				gchar* _tmp46_ = NULL;
				gchar* _tmp47_;
				_tmp36_ = _base_type_index;
				_base_type_index = _tmp36_ + 1;
				_tmp37_ = _base_type_index;
				_tmp38_ = _base_type_size;
				if (!(_tmp37_ < _tmp38_)) {
					break;
				}
				_tmp39_ = _base_type_list;
				_tmp40_ = _base_type_index;
				_tmp41_ = vala_list_get (_tmp39_, _tmp40_);
				base_type = (ValaDataType*) _tmp41_;
				vala_gir_writer_write_indent (self);
				_tmp42_ = self->priv->buffer;
				_tmp43_ = base_type;
				_tmp44_ = vala_object_type_get_type_symbol (VALA_OBJECT_TYPE (_tmp43_));
				_tmp45_ = _tmp44_;
				_tmp46_ = vala_gir_writer_gi_type_name (self, (ValaTypeSymbol*) _tmp45_);
				_tmp47_ = _tmp46_;
				g_string_append_printf (_tmp42_, "<prerequisite name=\"%s\"/>\n", _tmp47_);
				_g_free0 (_tmp47_);
				_vala_code_node_unref0 (base_type);
			}
			_vala_iterable_unref0 (_base_type_list);
		}
	}
	_tmp48_ = iface;
	vala_gir_writer_write_annotations (self, (ValaCodeNode*) _tmp48_);
	_tmp49_ = self->priv->hierarchy;
	_tmp50_ = iface;
	vala_list_insert ((ValaList*) _tmp49_, 0, (ValaSymbol*) _tmp50_);
	_tmp51_ = iface;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp51_, (ValaCodeVisitor*) self);
	_tmp52_ = self->priv->hierarchy;
	vala_list_remove_at ((ValaList*) _tmp52_, 0);
	_tmp53_ = self->priv->indent;
	self->priv->indent = _tmp53_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp54_ = self->priv->buffer;
	g_string_append_printf (_tmp54_, "</interface>\n");
	vala_gir_writer_write_indent (self);
	_tmp55_ = self->priv->buffer;
	_tmp56_ = gtype_struct_name;
	g_string_append_printf (_tmp55_, "<record name=\"%s\"", _tmp56_);
	_tmp57_ = iface;
	vala_gir_writer_write_ctype_attributes (self, (ValaTypeSymbol*) _tmp57_, "Iface");
	_tmp58_ = self->priv->buffer;
	_tmp59_ = iface;
	_tmp60_ = vala_symbol_get_name ((ValaSymbol*) _tmp59_);
	_tmp61_ = _tmp60_;
	g_string_append_printf (_tmp58_, " glib:is-gtype-struct-for=\"%s\"", _tmp61_);
	_tmp62_ = self->priv->buffer;
	g_string_append_printf (_tmp62_, ">\n");
	_tmp63_ = self->priv->indent;
	self->priv->indent = _tmp63_ + 1;
	vala_gir_writer_write_indent (self);
	_tmp64_ = self->priv->buffer;
	g_string_append_printf (_tmp64_, "<field name=\"parent_iface\">\n");
	_tmp65_ = self->priv->indent;
	self->priv->indent = _tmp65_ + 1;
	vala_gir_writer_write_indent (self);
	_tmp66_ = self->priv->buffer;
	g_string_append_printf (_tmp66_, "<type name=\"GObject.TypeInterface\" c:type=\"GTypeInterface\"/>\n");
	_tmp67_ = self->priv->indent;
	self->priv->indent = _tmp67_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp68_ = self->priv->buffer;
	g_string_append_printf (_tmp68_, "</field>\n");
	{
		ValaInterface* _tmp69_;
		ValaList* _tmp70_ = NULL;
		ValaList* _m_list;
		ValaList* _tmp71_;
		gint _tmp72_;
		gint _tmp73_;
		gint _m_size;
		gint _m_index;
		_tmp69_ = iface;
		_tmp70_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp69_);
		_m_list = _tmp70_;
		_tmp71_ = _m_list;
		_tmp72_ = vala_collection_get_size ((ValaCollection*) _tmp71_);
		_tmp73_ = _tmp72_;
		_m_size = _tmp73_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp74_;
			gint _tmp75_;
			gint _tmp76_;
			ValaList* _tmp77_;
			gint _tmp78_;
			gpointer _tmp79_ = NULL;
			ValaMethod* m;
			gboolean _tmp80_ = FALSE;
			ValaMethod* _tmp81_;
			gboolean _tmp82_;
			gboolean _tmp83_;
			gboolean _tmp87_;
			_tmp74_ = _m_index;
			_m_index = _tmp74_ + 1;
			_tmp75_ = _m_index;
			_tmp76_ = _m_size;
			if (!(_tmp75_ < _tmp76_)) {
				break;
			}
			_tmp77_ = _m_list;
			_tmp78_ = _m_index;
			_tmp79_ = vala_list_get (_tmp77_, _tmp78_);
			m = (ValaMethod*) _tmp79_;
			_tmp81_ = m;
			_tmp82_ = vala_method_get_is_abstract (_tmp81_);
			_tmp83_ = _tmp82_;
			if (_tmp83_) {
				_tmp80_ = TRUE;
			} else {
				ValaMethod* _tmp84_;
				gboolean _tmp85_;
				gboolean _tmp86_;
				_tmp84_ = m;
				_tmp85_ = vala_method_get_is_virtual (_tmp84_);
				_tmp86_ = _tmp85_;
				_tmp80_ = _tmp86_;
			}
			_tmp87_ = _tmp80_;
			if (_tmp87_) {
				ValaMethod* _tmp88_;
				gboolean _tmp89_;
				gboolean _tmp90_;
				_tmp88_ = m;
				_tmp89_ = vala_method_get_coroutine (_tmp88_);
				_tmp90_ = _tmp89_;
				if (_tmp90_) {
					ValaMethod* _tmp91_;
					const gchar* _tmp92_;
					const gchar* _tmp93_;
					gchar* _tmp94_;
					gchar* finish_name;
					const gchar* _tmp95_;
					gboolean _tmp96_ = FALSE;
					const gchar* _tmp104_;
					gchar* _tmp105_;
					GString* _tmp106_;
					ValaMethod* _tmp107_;
					const gchar* _tmp108_;
					const gchar* _tmp109_;
					gint _tmp110_;
					ValaMethod* _tmp111_;
					ValaMethod* _tmp112_;
					const gchar* _tmp113_;
					const gchar* _tmp114_;
					ValaMethod* _tmp115_;
					gchar* _tmp116_ = NULL;
					gchar* _tmp117_;
					ValaMethod* _tmp118_;
					ValaList* _tmp119_ = NULL;
					ValaList* _tmp120_;
					ValaVoidType* _tmp121_;
					ValaVoidType* _tmp122_;
					gint _tmp123_;
					GString* _tmp124_;
					GString* _tmp125_;
					const gchar* _tmp126_;
					gint _tmp127_;
					ValaMethod* _tmp128_;
					const gchar* _tmp129_;
					ValaMethod* _tmp130_;
					gchar* _tmp131_ = NULL;
					gchar* _tmp132_;
					ValaMethod* _tmp133_;
					ValaList* _tmp134_ = NULL;
					ValaList* _tmp135_;
					ValaMethod* _tmp136_;
					ValaDataType* _tmp137_;
					ValaDataType* _tmp138_;
					ValaMethod* _tmp139_;
					gboolean _tmp140_;
					gboolean _tmp141_;
					gint _tmp142_;
					GString* _tmp143_;
					_tmp91_ = m;
					_tmp92_ = vala_symbol_get_name ((ValaSymbol*) _tmp91_);
					_tmp93_ = _tmp92_;
					_tmp94_ = g_strdup (_tmp93_);
					finish_name = _tmp94_;
					_tmp95_ = finish_name;
					_tmp96_ = g_str_has_suffix (_tmp95_, "_async");
					if (_tmp96_) {
						const gchar* _tmp97_;
						const gchar* _tmp98_;
						gint _tmp99_;
						gint _tmp100_;
						gint _tmp101_;
						gint _tmp102_;
						gchar* _tmp103_ = NULL;
						_tmp97_ = finish_name;
						_tmp98_ = finish_name;
						_tmp99_ = strlen (_tmp98_);
						_tmp100_ = _tmp99_;
						_tmp101_ = strlen ("_async");
						_tmp102_ = _tmp101_;
						_tmp103_ = string_substring (_tmp97_, (glong) 0, (glong) (_tmp100_ - _tmp102_));
						_g_free0 (finish_name);
						finish_name = _tmp103_;
					}
					_tmp104_ = finish_name;
					_tmp105_ = g_strconcat (_tmp104_, "_finish", NULL);
					_g_free0 (finish_name);
					finish_name = _tmp105_;
					vala_gir_writer_write_indent (self);
					_tmp106_ = self->priv->buffer;
					_tmp107_ = m;
					_tmp108_ = vala_symbol_get_name ((ValaSymbol*) _tmp107_);
					_tmp109_ = _tmp108_;
					g_string_append_printf (_tmp106_, "<field name=\"%s\">\n", _tmp109_);
					_tmp110_ = self->priv->indent;
					self->priv->indent = _tmp110_ + 1;
					_tmp111_ = m;
					_tmp112_ = m;
					_tmp113_ = vala_symbol_get_name ((ValaSymbol*) _tmp112_);
					_tmp114_ = _tmp113_;
					_tmp115_ = m;
					_tmp116_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp115_);
					_tmp117_ = _tmp116_;
					_tmp118_ = m;
					_tmp119_ = vala_method_get_async_begin_parameters (_tmp118_);
					_tmp120_ = _tmp119_;
					_tmp121_ = vala_void_type_new (NULL);
					_tmp122_ = _tmp121_;
					vala_gir_writer_do_write_signature (self, _tmp111_, "callback", TRUE, _tmp114_, _tmp117_, _tmp120_, (ValaDataType*) _tmp122_, FALSE);
					_vala_code_node_unref0 (_tmp122_);
					_vala_iterable_unref0 (_tmp120_);
					_g_free0 (_tmp117_);
					_tmp123_ = self->priv->indent;
					self->priv->indent = _tmp123_ - 1;
					vala_gir_writer_write_indent (self);
					_tmp124_ = self->priv->buffer;
					g_string_append_printf (_tmp124_, "</field>\n");
					vala_gir_writer_write_indent (self);
					_tmp125_ = self->priv->buffer;
					_tmp126_ = finish_name;
					g_string_append_printf (_tmp125_, "<field name=\"%s\">\n", _tmp126_);
					_tmp127_ = self->priv->indent;
					self->priv->indent = _tmp127_ + 1;
					_tmp128_ = m;
					_tmp129_ = finish_name;
					_tmp130_ = m;
					_tmp131_ = vala_ccode_base_module_get_ccode_finish_name (_tmp130_);
					_tmp132_ = _tmp131_;
					_tmp133_ = m;
					_tmp134_ = vala_method_get_async_end_parameters (_tmp133_);
					_tmp135_ = _tmp134_;
					_tmp136_ = m;
					_tmp137_ = vala_method_get_return_type (_tmp136_);
					_tmp138_ = _tmp137_;
					_tmp139_ = m;
					_tmp140_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) _tmp139_);
					_tmp141_ = _tmp140_;
					vala_gir_writer_do_write_signature (self, _tmp128_, "callback", TRUE, _tmp129_, _tmp132_, _tmp135_, _tmp138_, _tmp141_);
					_vala_iterable_unref0 (_tmp135_);
					_g_free0 (_tmp132_);
					_tmp142_ = self->priv->indent;
					self->priv->indent = _tmp142_ - 1;
					vala_gir_writer_write_indent (self);
					_tmp143_ = self->priv->buffer;
					g_string_append_printf (_tmp143_, "</field>\n");
					_g_free0 (finish_name);
				} else {
					GString* _tmp144_;
					ValaMethod* _tmp145_;
					const gchar* _tmp146_;
					const gchar* _tmp147_;
					gint _tmp148_;
					ValaMethod* _tmp149_;
					ValaMethod* _tmp150_;
					const gchar* _tmp151_;
					const gchar* _tmp152_;
					ValaMethod* _tmp153_;
					gchar* _tmp154_ = NULL;
					gchar* _tmp155_;
					ValaMethod* _tmp156_;
					ValaList* _tmp157_ = NULL;
					ValaList* _tmp158_;
					ValaMethod* _tmp159_;
					ValaDataType* _tmp160_;
					ValaDataType* _tmp161_;
					ValaMethod* _tmp162_;
					gboolean _tmp163_;
					gboolean _tmp164_;
					gint _tmp165_;
					GString* _tmp166_;
					vala_gir_writer_write_indent (self);
					_tmp144_ = self->priv->buffer;
					_tmp145_ = m;
					_tmp146_ = vala_symbol_get_name ((ValaSymbol*) _tmp145_);
					_tmp147_ = _tmp146_;
					g_string_append_printf (_tmp144_, "<field name=\"%s\">\n", _tmp147_);
					_tmp148_ = self->priv->indent;
					self->priv->indent = _tmp148_ + 1;
					_tmp149_ = m;
					_tmp150_ = m;
					_tmp151_ = vala_symbol_get_name ((ValaSymbol*) _tmp150_);
					_tmp152_ = _tmp151_;
					_tmp153_ = m;
					_tmp154_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp153_);
					_tmp155_ = _tmp154_;
					_tmp156_ = m;
					_tmp157_ = vala_method_get_parameters (_tmp156_);
					_tmp158_ = _tmp157_;
					_tmp159_ = m;
					_tmp160_ = vala_method_get_return_type (_tmp159_);
					_tmp161_ = _tmp160_;
					_tmp162_ = m;
					_tmp163_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) _tmp162_);
					_tmp164_ = _tmp163_;
					vala_gir_writer_do_write_signature (self, _tmp149_, "callback", TRUE, _tmp152_, _tmp155_, _tmp158_, _tmp161_, _tmp164_);
					_vala_iterable_unref0 (_tmp158_);
					_g_free0 (_tmp155_);
					_tmp165_ = self->priv->indent;
					self->priv->indent = _tmp165_ - 1;
					vala_gir_writer_write_indent (self);
					_tmp166_ = self->priv->buffer;
					g_string_append_printf (_tmp166_, "</field>\n");
				}
			}
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	_tmp167_ = self->priv->indent;
	self->priv->indent = _tmp167_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp168_ = self->priv->buffer;
	g_string_append_printf (_tmp168_, "</record>\n");
	vala_gir_writer_visit_deferred (self);
	_g_free0 (gtype_struct_name);
}


static void vala_gir_writer_visit_deferred (ValaGIRWriter* self) {
	ValaArrayList* _tmp0_;
	ValaArrayList* _tmp1_;
	ValaArrayList* nodes;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->deferred;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	nodes = _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_CODE_NODE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, _tmp2_);
	_vala_iterable_unref0 (self->priv->deferred);
	self->priv->deferred = _tmp3_;
	{
		ValaArrayList* _tmp4_;
		ValaArrayList* _tmp5_;
		ValaArrayList* _node_list;
		ValaArrayList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _node_size;
		gint _node_index;
		_tmp4_ = nodes;
		_tmp5_ = _vala_iterable_ref0 (_tmp4_);
		_node_list = _tmp5_;
		_tmp6_ = _node_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_node_size = _tmp8_;
		_node_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			ValaArrayList* _tmp12_;
			gint _tmp13_;
			gpointer _tmp14_ = NULL;
			ValaCodeNode* node;
			ValaCodeNode* _tmp15_;
			_tmp9_ = _node_index;
			_node_index = _tmp9_ + 1;
			_tmp10_ = _node_index;
			_tmp11_ = _node_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _node_list;
			_tmp13_ = _node_index;
			_tmp14_ = vala_list_get ((ValaList*) _tmp12_, _tmp13_);
			node = (ValaCodeNode*) _tmp14_;
			_tmp15_ = node;
			vala_code_node_accept (_tmp15_, (ValaCodeVisitor*) self);
			_vala_code_node_unref0 (node);
		}
		_vala_iterable_unref0 (_node_list);
	}
	_vala_iterable_unref0 (nodes);
}


static gchar* vala_gir_writer_get_gir_name (ValaGIRWriter* self, ValaSymbol* symbol) {
	gchar* result = NULL;
	gchar* gir_name;
	ValaArrayList* _tmp0_;
	gpointer _tmp1_ = NULL;
	ValaSymbol* h0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (symbol != NULL, NULL);
	gir_name = NULL;
	_tmp0_ = self->priv->hierarchy;
	_tmp1_ = vala_list_get ((ValaList*) _tmp0_, 0);
	h0 = (ValaSymbol*) _tmp1_;
	{
		ValaSymbol* _tmp2_;
		ValaSymbol* _tmp3_;
		ValaSymbol* cur_sym;
		_tmp2_ = symbol;
		_tmp3_ = _vala_code_node_ref0 (_tmp2_);
		cur_sym = _tmp3_;
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp5_;
				ValaSymbol* _tmp10_;
				ValaSymbol* _tmp11_;
				ValaSymbol* _tmp12_;
				ValaSymbol* _tmp13_;
				gchar* _tmp14_ = NULL;
				gchar* cur_name;
				const gchar* _tmp15_;
				const gchar* _tmp20_;
				const gchar* _tmp21_;
				gchar* _tmp22_ = NULL;
				_tmp5_ = _tmp4_;
				if (!_tmp5_) {
					ValaSymbol* _tmp6_;
					ValaSymbol* _tmp7_;
					ValaSymbol* _tmp8_;
					ValaSymbol* _tmp9_;
					_tmp6_ = cur_sym;
					_tmp7_ = vala_symbol_get_parent_symbol (_tmp6_);
					_tmp8_ = _tmp7_;
					_tmp9_ = _vala_code_node_ref0 (_tmp8_);
					_vala_code_node_unref0 (cur_sym);
					cur_sym = _tmp9_;
				}
				_tmp4_ = FALSE;
				_tmp10_ = cur_sym;
				if (!(_tmp10_ != NULL)) {
					break;
				}
				_tmp11_ = cur_sym;
				_tmp12_ = h0;
				if (_tmp11_ == _tmp12_) {
					break;
				}
				_tmp13_ = cur_sym;
				_tmp14_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp13_, "GIR", "name");
				cur_name = _tmp14_;
				_tmp15_ = cur_name;
				if (_tmp15_ == NULL) {
					ValaSymbol* _tmp16_;
					const gchar* _tmp17_;
					const gchar* _tmp18_;
					gchar* _tmp19_;
					_tmp16_ = cur_sym;
					_tmp17_ = vala_symbol_get_name (_tmp16_);
					_tmp18_ = _tmp17_;
					_tmp19_ = g_strdup (_tmp18_);
					_g_free0 (cur_name);
					cur_name = _tmp19_;
				}
				_tmp20_ = cur_name;
				_tmp21_ = gir_name;
				_tmp22_ = g_strconcat (_tmp20_, _tmp21_, NULL);
				_g_free0 (gir_name);
				gir_name = _tmp22_;
				_g_free0 (cur_name);
			}
		}
		_vala_code_node_unref0 (cur_sym);
	}
	result = gir_name;
	_vala_code_node_unref0 (h0);
	return result;
}


static void vala_gir_writer_real_visit_enum (ValaCodeVisitor* base, ValaEnum* en) {
	ValaGIRWriter * self;
	ValaEnum* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	ValaEnum* _tmp3_;
	gboolean _tmp4_ = FALSE;
	ValaArrayList* _tmp5_;
	gpointer _tmp6_ = NULL;
	ValaSymbol* _tmp7_;
	gboolean _tmp8_;
	const gchar* _tmp11_ = NULL;
	ValaEnum* _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* element_name;
	GString* _tmp17_;
	const gchar* _tmp18_;
	ValaEnum* _tmp19_;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_;
	ValaEnum* _tmp22_;
	ValaEnum* _tmp23_;
	GString* _tmp24_;
	gint _tmp25_;
	ValaEnum* _tmp26_;
	ValaArrayList* _tmp27_;
	ValaEnum* _tmp28_;
	ValaEnum* _tmp29_;
	ValaArrayList* _tmp30_;
	gint _tmp31_;
	GString* _tmp32_;
	const gchar* _tmp33_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (en != NULL);
	_tmp0_ = en;
	_tmp1_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		return;
	}
	_tmp3_ = en;
	_tmp4_ = vala_gir_writer_check_accessibility (self, (ValaSymbol*) _tmp3_);
	if (!_tmp4_) {
		return;
	}
	_tmp5_ = self->priv->hierarchy;
	_tmp6_ = vala_list_get ((ValaList*) _tmp5_, 0);
	_tmp7_ = (ValaSymbol*) _tmp6_;
	_tmp8_ = !VALA_IS_NAMESPACE (_tmp7_);
	_vala_code_node_unref0 (_tmp7_);
	if (_tmp8_) {
		ValaArrayList* _tmp9_;
		ValaEnum* _tmp10_;
		_tmp9_ = self->priv->deferred;
		_tmp10_ = en;
		vala_collection_add ((ValaCollection*) _tmp9_, (ValaCodeNode*) _tmp10_);
		return;
	}
	_tmp12_ = en;
	_tmp13_ = vala_enum_get_is_flags (_tmp12_);
	_tmp14_ = _tmp13_;
	if (_tmp14_) {
		_tmp11_ = "bitfield";
	} else {
		_tmp11_ = "enumeration";
	}
	_tmp15_ = _tmp11_;
	_tmp16_ = g_strdup (_tmp15_);
	element_name = _tmp16_;
	vala_gir_writer_write_indent (self);
	_tmp17_ = self->priv->buffer;
	_tmp18_ = element_name;
	_tmp19_ = en;
	_tmp20_ = vala_gir_writer_get_gir_name (self, (ValaSymbol*) _tmp19_);
	_tmp21_ = _tmp20_;
	g_string_append_printf (_tmp17_, "<%s name=\"%s\"", _tmp18_, _tmp21_);
	_g_free0 (_tmp21_);
	_tmp22_ = en;
	vala_gir_writer_write_gtype_attributes (self, (ValaTypeSymbol*) _tmp22_);
	_tmp23_ = en;
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) _tmp23_);
	_tmp24_ = self->priv->buffer;
	g_string_append_printf (_tmp24_, ">\n");
	_tmp25_ = self->priv->indent;
	self->priv->indent = _tmp25_ + 1;
	_tmp26_ = en;
	vala_gir_writer_write_annotations (self, (ValaCodeNode*) _tmp26_);
	self->priv->enum_value = 0;
	_tmp27_ = self->priv->hierarchy;
	_tmp28_ = en;
	vala_list_insert ((ValaList*) _tmp27_, 0, (ValaSymbol*) _tmp28_);
	_tmp29_ = en;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp29_, (ValaCodeVisitor*) self);
	_tmp30_ = self->priv->hierarchy;
	vala_list_remove_at ((ValaList*) _tmp30_, 0);
	_tmp31_ = self->priv->indent;
	self->priv->indent = _tmp31_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp32_ = self->priv->buffer;
	_tmp33_ = element_name;
	g_string_append_printf (_tmp32_, "</%s>\n", _tmp33_);
	vala_gir_writer_visit_deferred (self);
	_g_free0 (element_name);
}


static void vala_gir_writer_real_visit_enum_value (ValaCodeVisitor* base, ValaEnumValue* ev) {
	ValaGIRWriter * self;
	ValaArrayList* _tmp0_;
	gpointer _tmp1_ = NULL;
	ValaEnum* en;
	GString* _tmp2_;
	ValaEnumValue* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	ValaEnumValue* _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	ValaEnumValue* _tmp11_;
	ValaExpression* _tmp12_;
	ValaExpression* _tmp13_;
	ValaEnumValue* _tmp27_;
	GString* _tmp28_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (ev != NULL);
	vala_gir_writer_write_indent (self);
	_tmp0_ = self->priv->hierarchy;
	_tmp1_ = vala_list_get ((ValaList*) _tmp0_, 0);
	en = VALA_ENUM ((ValaSymbol*) _tmp1_);
	_tmp2_ = self->priv->buffer;
	_tmp3_ = ev;
	_tmp4_ = vala_symbol_get_name ((ValaSymbol*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_utf8_strdown (_tmp5_, (gssize) (-1));
	_tmp7_ = _tmp6_;
	_tmp8_ = ev;
	_tmp9_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp8_);
	_tmp10_ = _tmp9_;
	g_string_append_printf (_tmp2_, "<member name=\"%s\" c:identifier=\"%s\"", _tmp7_, _tmp10_);
	_g_free0 (_tmp10_);
	_g_free0 (_tmp7_);
	_tmp11_ = ev;
	_tmp12_ = vala_constant_get_value ((ValaConstant*) _tmp11_);
	_tmp13_ = _tmp12_;
	if (_tmp13_ != NULL) {
		ValaEnumValue* _tmp14_;
		ValaExpression* _tmp15_;
		ValaExpression* _tmp16_;
		gchar* _tmp17_ = NULL;
		gchar* value;
		GString* _tmp18_;
		const gchar* _tmp19_;
		_tmp14_ = ev;
		_tmp15_ = vala_constant_get_value ((ValaConstant*) _tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_gir_writer_literal_expression_to_value_string (self, _tmp16_);
		value = _tmp17_;
		_tmp18_ = self->priv->buffer;
		_tmp19_ = value;
		g_string_append_printf (_tmp18_, " value=\"%s\"", _tmp19_);
		_g_free0 (value);
	} else {
		ValaEnum* _tmp20_;
		gboolean _tmp21_;
		gboolean _tmp22_;
		_tmp20_ = en;
		_tmp21_ = vala_enum_get_is_flags (_tmp20_);
		_tmp22_ = _tmp21_;
		if (_tmp22_) {
			GString* _tmp23_;
			gint _tmp24_;
			_tmp23_ = self->priv->buffer;
			_tmp24_ = self->priv->enum_value;
			self->priv->enum_value = _tmp24_ + 1;
			g_string_append_printf (_tmp23_, " value=\"%d\"", 1 << _tmp24_);
		} else {
			GString* _tmp25_;
			gint _tmp26_;
			_tmp25_ = self->priv->buffer;
			_tmp26_ = self->priv->enum_value;
			self->priv->enum_value = _tmp26_ + 1;
			g_string_append_printf (_tmp25_, " value=\"%d\"", _tmp26_);
		}
	}
	_tmp27_ = ev;
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) _tmp27_);
	_tmp28_ = self->priv->buffer;
	g_string_append_printf (_tmp28_, "/>\n");
	_vala_code_node_unref0 (en);
}


static void vala_gir_writer_real_visit_error_domain (ValaCodeVisitor* base, ValaErrorDomain* edomain) {
	ValaGIRWriter * self;
	ValaErrorDomain* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	ValaErrorDomain* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GString* _tmp5_;
	ValaErrorDomain* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	GString* _tmp9_;
	ValaErrorDomain* _tmp10_;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	GString* _tmp13_;
	ValaErrorDomain* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	ValaErrorDomain* _tmp17_;
	GString* _tmp18_;
	ValaErrorDomain* _tmp19_;
	GString* _tmp20_;
	GString* _tmp21_;
	ValaErrorDomain* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	ValaErrorDomain* _tmp25_;
	GString* _tmp26_;
	gint _tmp27_;
	ValaArrayList* _tmp28_;
	ValaErrorDomain* _tmp29_;
	ValaErrorDomain* _tmp30_;
	ValaArrayList* _tmp31_;
	gint _tmp32_;
	GString* _tmp33_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (edomain != NULL);
	_tmp0_ = edomain;
	_tmp1_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		return;
	}
	_tmp3_ = edomain;
	_tmp4_ = vala_gir_writer_check_accessibility (self, (ValaSymbol*) _tmp3_);
	if (!_tmp4_) {
		return;
	}
	vala_gir_writer_write_indent (self);
	_tmp5_ = self->priv->buffer;
	_tmp6_ = edomain;
	_tmp7_ = vala_symbol_get_name ((ValaSymbol*) _tmp6_);
	_tmp8_ = _tmp7_;
	g_string_append_printf (_tmp5_, "<errordomain name=\"%s\"", _tmp8_);
	_tmp9_ = self->priv->buffer;
	_tmp10_ = edomain;
	_tmp11_ = vala_ccode_base_module_get_ccode_lower_case_prefix ((ValaSymbol*) _tmp10_);
	_tmp12_ = _tmp11_;
	g_string_append_printf (_tmp9_, " get-quark=\"%squark\"", _tmp12_);
	_g_free0 (_tmp12_);
	_tmp13_ = self->priv->buffer;
	_tmp14_ = edomain;
	_tmp15_ = vala_symbol_get_name ((ValaSymbol*) _tmp14_);
	_tmp16_ = _tmp15_;
	g_string_append_printf (_tmp13_, " codes=\"%s\"", _tmp16_);
	_tmp17_ = edomain;
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) _tmp17_);
	_tmp18_ = self->priv->buffer;
	g_string_append_printf (_tmp18_, ">\n");
	_tmp19_ = edomain;
	vala_gir_writer_write_annotations (self, (ValaCodeNode*) _tmp19_);
	_tmp20_ = self->priv->buffer;
	g_string_append_printf (_tmp20_, "</errordomain>\n");
	vala_gir_writer_write_indent (self);
	_tmp21_ = self->priv->buffer;
	_tmp22_ = edomain;
	_tmp23_ = vala_symbol_get_name ((ValaSymbol*) _tmp22_);
	_tmp24_ = _tmp23_;
	g_string_append_printf (_tmp21_, "<enumeration name=\"%s\"", _tmp24_);
	_tmp25_ = edomain;
	vala_gir_writer_write_ctype_attributes (self, (ValaTypeSymbol*) _tmp25_, "");
	_tmp26_ = self->priv->buffer;
	g_string_append_printf (_tmp26_, ">\n");
	_tmp27_ = self->priv->indent;
	self->priv->indent = _tmp27_ + 1;
	self->priv->enum_value = 0;
	_tmp28_ = self->priv->hierarchy;
	_tmp29_ = edomain;
	vala_list_insert ((ValaList*) _tmp28_, 0, (ValaSymbol*) _tmp29_);
	_tmp30_ = edomain;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp30_, (ValaCodeVisitor*) self);
	_tmp31_ = self->priv->hierarchy;
	vala_list_remove_at ((ValaList*) _tmp31_, 0);
	_tmp32_ = self->priv->indent;
	self->priv->indent = _tmp32_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp33_ = self->priv->buffer;
	g_string_append_printf (_tmp33_, "</enumeration>\n");
	vala_gir_writer_visit_deferred (self);
}


static void vala_gir_writer_real_visit_error_code (ValaCodeVisitor* base, ValaErrorCode* ecode) {
	ValaGIRWriter * self;
	GString* _tmp0_;
	ValaErrorCode* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	ValaErrorCode* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	ValaErrorCode* _tmp9_;
	ValaExpression* _tmp10_;
	ValaExpression* _tmp11_;
	ValaErrorCode* _tmp20_;
	GString* _tmp21_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (ecode != NULL);
	vala_gir_writer_write_indent (self);
	_tmp0_ = self->priv->buffer;
	_tmp1_ = ecode;
	_tmp2_ = vala_symbol_get_name ((ValaSymbol*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_utf8_strdown (_tmp3_, (gssize) (-1));
	_tmp5_ = _tmp4_;
	_tmp6_ = ecode;
	_tmp7_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp6_);
	_tmp8_ = _tmp7_;
	g_string_append_printf (_tmp0_, "<member name=\"%s\" c:identifier=\"%s\"", _tmp5_, _tmp8_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp5_);
	_tmp9_ = ecode;
	_tmp10_ = vala_error_code_get_value (_tmp9_);
	_tmp11_ = _tmp10_;
	if (_tmp11_ != NULL) {
		ValaErrorCode* _tmp12_;
		ValaExpression* _tmp13_;
		ValaExpression* _tmp14_;
		gchar* _tmp15_ = NULL;
		gchar* value;
		GString* _tmp16_;
		const gchar* _tmp17_;
		_tmp12_ = ecode;
		_tmp13_ = vala_error_code_get_value (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = vala_gir_writer_literal_expression_to_value_string (self, _tmp14_);
		value = _tmp15_;
		_tmp16_ = self->priv->buffer;
		_tmp17_ = value;
		g_string_append_printf (_tmp16_, " value=\"%s\"", _tmp17_);
		_g_free0 (value);
	} else {
		GString* _tmp18_;
		gint _tmp19_;
		_tmp18_ = self->priv->buffer;
		_tmp19_ = self->priv->enum_value;
		self->priv->enum_value = _tmp19_ + 1;
		g_string_append_printf (_tmp18_, " value=\"%d\"", _tmp19_);
	}
	_tmp20_ = ecode;
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) _tmp20_);
	_tmp21_ = self->priv->buffer;
	g_string_append_printf (_tmp21_, "/>\n");
}


static void vala_gir_writer_real_visit_constant (ValaCodeVisitor* base, ValaConstant* c) {
	ValaGIRWriter * self;
	ValaConstant* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	ValaConstant* _tmp3_;
	gboolean _tmp4_ = FALSE;
	ValaConstant* _tmp5_;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaExpression* _tmp8_;
	ValaExpression* initializer;
	ValaExpression* _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* value;
	GString* _tmp11_;
	ValaConstant* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	ValaConstant* _tmp15_;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_;
	GString* _tmp18_;
	const gchar* _tmp19_;
	ValaConstant* _tmp20_;
	GString* _tmp21_;
	gint _tmp22_;
	ValaExpression* _tmp23_;
	ValaDataType* _tmp24_;
	ValaDataType* _tmp25_;
	gint _tmp26_;
	GString* _tmp27_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (c != NULL);
	_tmp0_ = c;
	_tmp1_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		return;
	}
	_tmp3_ = c;
	_tmp4_ = vala_gir_writer_check_accessibility (self, (ValaSymbol*) _tmp3_);
	if (!_tmp4_) {
		return;
	}
	_tmp5_ = c;
	_tmp6_ = vala_constant_get_value (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_code_node_ref0 (_tmp7_);
	initializer = _tmp8_;
	_tmp9_ = initializer;
	_tmp10_ = vala_gir_writer_literal_expression_to_value_string (self, _tmp9_);
	value = _tmp10_;
	vala_gir_writer_write_indent (self);
	_tmp11_ = self->priv->buffer;
	_tmp12_ = c;
	_tmp13_ = vala_symbol_get_name ((ValaSymbol*) _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = c;
	_tmp16_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp15_);
	_tmp17_ = _tmp16_;
	g_string_append_printf (_tmp11_, "<constant name=\"%s\" c:identifier=\"%s\"", _tmp14_, _tmp17_);
	_g_free0 (_tmp17_);
	_tmp18_ = self->priv->buffer;
	_tmp19_ = value;
	g_string_append_printf (_tmp18_, " value=\"%s\"", _tmp19_);
	_tmp20_ = c;
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) _tmp20_);
	_tmp21_ = self->priv->buffer;
	g_string_append_printf (_tmp21_, ">\n");
	_tmp22_ = self->priv->indent;
	self->priv->indent = _tmp22_ + 1;
	_tmp23_ = initializer;
	_tmp24_ = vala_expression_get_value_type (_tmp23_);
	_tmp25_ = _tmp24_;
	vala_gir_writer_write_type (self, _tmp25_, -1);
	_tmp26_ = self->priv->indent;
	self->priv->indent = _tmp26_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp27_ = self->priv->buffer;
	g_string_append_printf (_tmp27_, "</constant>\n");
	_g_free0 (value);
	_vala_code_node_unref0 (initializer);
}


static void vala_gir_writer_real_visit_field (ValaCodeVisitor* base, ValaField* f) {
	ValaGIRWriter * self;
	ValaField* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	ValaField* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GString* _tmp5_;
	ValaField* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	ValaField* _tmp9_;
	ValaDataType* _tmp10_;
	ValaDataType* _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	ValaField* _tmp15_;
	GString* _tmp16_;
	gint _tmp17_;
	ValaField* _tmp18_;
	ValaField* _tmp19_;
	ValaDataType* _tmp20_;
	ValaDataType* _tmp21_;
	gint _tmp22_;
	GString* _tmp23_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (f != NULL);
	_tmp0_ = f;
	_tmp1_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		return;
	}
	_tmp3_ = f;
	_tmp4_ = vala_gir_writer_check_accessibility (self, (ValaSymbol*) _tmp3_);
	if (!_tmp4_) {
		return;
	}
	vala_gir_writer_write_indent (self);
	_tmp5_ = self->priv->buffer;
	_tmp6_ = f;
	_tmp7_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp6_);
	_tmp8_ = _tmp7_;
	g_string_append_printf (_tmp5_, "<field name=\"%s\"", _tmp8_);
	_g_free0 (_tmp8_);
	_tmp9_ = f;
	_tmp10_ = vala_variable_get_variable_type ((ValaVariable*) _tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = vala_data_type_get_nullable (_tmp11_);
	_tmp13_ = _tmp12_;
	if (_tmp13_) {
		GString* _tmp14_;
		_tmp14_ = self->priv->buffer;
		g_string_append_printf (_tmp14_, " allow-none=\"1\"");
	}
	_tmp15_ = f;
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) _tmp15_);
	_tmp16_ = self->priv->buffer;
	g_string_append_printf (_tmp16_, ">\n");
	_tmp17_ = self->priv->indent;
	self->priv->indent = _tmp17_ + 1;
	_tmp18_ = f;
	vala_gir_writer_write_annotations (self, (ValaCodeNode*) _tmp18_);
	_tmp19_ = f;
	_tmp20_ = vala_variable_get_variable_type ((ValaVariable*) _tmp19_);
	_tmp21_ = _tmp20_;
	vala_gir_writer_write_type (self, _tmp21_, -1);
	_tmp22_ = self->priv->indent;
	self->priv->indent = _tmp22_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp23_ = self->priv->buffer;
	g_string_append_printf (_tmp23_, "</field>\n");
}


static void vala_gir_writer_write_implicit_params (ValaGIRWriter* self, ValaDataType* type, gint* index, gboolean has_array_length, const gchar* name, ValaParameterDirection direction) {
	gboolean _tmp0_ = FALSE;
	ValaDataType* _tmp1_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	g_return_if_fail (name != NULL);
	_tmp1_ = type;
	if (VALA_IS_ARRAY_TYPE (_tmp1_)) {
		gboolean _tmp2_;
		_tmp2_ = has_array_length;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		ValaCodeContext* _tmp4_ = NULL;
		ValaCodeContext* _tmp5_;
		ValaNamespace* _tmp6_;
		ValaNamespace* _tmp7_;
		ValaScope* _tmp8_;
		ValaScope* _tmp9_;
		ValaSymbol* _tmp10_ = NULL;
		ValaStruct* _tmp11_;
		ValaIntegerType* _tmp12_;
		ValaIntegerType* _tmp13_;
		ValaIntegerType* int_type;
		ValaIntegerType* _tmp14_;
		gboolean _tmp15_;
		const gchar* _tmp16_;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_;
		ValaParameterDirection _tmp19_;
		_tmp4_ = vala_code_context_get ();
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_code_context_get_root (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_symbol_get_scope ((ValaSymbol*) _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_scope_lookup (_tmp9_, "int");
		_tmp11_ = VALA_IS_STRUCT (_tmp10_) ? ((ValaStruct*) _tmp10_) : NULL;
		_tmp12_ = vala_integer_type_new (_tmp11_, NULL, NULL);
		_tmp13_ = _tmp12_;
		_vala_code_node_unref0 (_tmp11_);
		_vala_code_context_unref0 (_tmp5_);
		int_type = _tmp13_;
		_tmp14_ = int_type;
		_tmp15_ = has_array_length;
		_tmp16_ = name;
		_tmp17_ = g_strdup_printf ("%s_length1", _tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = direction;
		vala_gir_writer_write_param_or_return (self, (ValaDataType*) _tmp14_, TRUE, index, _tmp15_, _tmp18_, _tmp19_, FALSE, FALSE);
		_g_free0 (_tmp18_);
		_vala_code_node_unref0 (int_type);
	} else {
		ValaDataType* _tmp20_;
		_tmp20_ = type;
		if (VALA_IS_DELEGATE_TYPE (_tmp20_)) {
			ValaVoidType* _tmp21_;
			ValaVoidType* _tmp22_;
			ValaPointerType* _tmp23_;
			ValaPointerType* _tmp24_;
			ValaPointerType* data_type;
			ValaPointerType* _tmp25_;
			const gchar* _tmp26_;
			gchar* _tmp27_ = NULL;
			gchar* _tmp28_;
			ValaParameterDirection _tmp29_;
			ValaDataType* _tmp30_;
			gboolean _tmp31_;
			gboolean _tmp32_;
			_tmp21_ = vala_void_type_new (NULL);
			_tmp22_ = _tmp21_;
			_tmp23_ = vala_pointer_type_new ((ValaDataType*) _tmp22_, NULL);
			_tmp24_ = _tmp23_;
			_vala_code_node_unref0 (_tmp22_);
			data_type = _tmp24_;
			_tmp25_ = data_type;
			_tmp26_ = name;
			_tmp27_ = g_strdup_printf ("%s_target", _tmp26_);
			_tmp28_ = _tmp27_;
			_tmp29_ = direction;
			vala_gir_writer_write_param_or_return (self, (ValaDataType*) _tmp25_, TRUE, index, FALSE, _tmp28_, _tmp29_, FALSE, FALSE);
			_g_free0 (_tmp28_);
			_tmp30_ = type;
			_tmp31_ = vala_data_type_get_value_owned (_tmp30_);
			_tmp32_ = _tmp31_;
			if (_tmp32_) {
				ValaCodeContext* _tmp33_ = NULL;
				ValaCodeContext* _tmp34_;
				ValaNamespace* _tmp35_;
				ValaNamespace* _tmp36_;
				ValaScope* _tmp37_;
				ValaScope* _tmp38_;
				ValaSymbol* _tmp39_ = NULL;
				ValaSymbol* _tmp40_;
				ValaScope* _tmp41_;
				ValaScope* _tmp42_;
				ValaSymbol* _tmp43_ = NULL;
				ValaDelegate* _tmp44_;
				ValaDelegateType* _tmp45_;
				ValaDelegateType* _tmp46_;
				ValaDelegateType* notify_type;
				ValaDelegateType* _tmp47_;
				const gchar* _tmp48_;
				gchar* _tmp49_ = NULL;
				gchar* _tmp50_;
				ValaParameterDirection _tmp51_;
				_tmp33_ = vala_code_context_get ();
				_tmp34_ = _tmp33_;
				_tmp35_ = vala_code_context_get_root (_tmp34_);
				_tmp36_ = _tmp35_;
				_tmp37_ = vala_symbol_get_scope ((ValaSymbol*) _tmp36_);
				_tmp38_ = _tmp37_;
				_tmp39_ = vala_scope_lookup (_tmp38_, "GLib");
				_tmp40_ = _tmp39_;
				_tmp41_ = vala_symbol_get_scope (_tmp40_);
				_tmp42_ = _tmp41_;
				_tmp43_ = vala_scope_lookup (_tmp42_, "DestroyNotify");
				_tmp44_ = VALA_IS_DELEGATE (_tmp43_) ? ((ValaDelegate*) _tmp43_) : NULL;
				_tmp45_ = vala_delegate_type_new (_tmp44_);
				_tmp46_ = _tmp45_;
				_vala_code_node_unref0 (_tmp44_);
				_vala_code_node_unref0 (_tmp40_);
				_vala_code_context_unref0 (_tmp34_);
				notify_type = _tmp46_;
				_tmp47_ = notify_type;
				_tmp48_ = name;
				_tmp49_ = g_strdup_printf ("%s_target_destroy_notify", _tmp48_);
				_tmp50_ = _tmp49_;
				_tmp51_ = direction;
				vala_gir_writer_write_param_or_return (self, (ValaDataType*) _tmp47_, TRUE, index, FALSE, _tmp50_, _tmp51_, FALSE, FALSE);
				_g_free0 (_tmp50_);
				_vala_code_node_unref0 (notify_type);
			}
			_vala_code_node_unref0 (data_type);
		}
	}
}


static void vala_gir_writer_write_params_and_return (ValaGIRWriter* self, ValaList* params, ValaDataType* return_type, gboolean return_array_length, gboolean constructor, ValaDataType* instance_type, gboolean user_data) {
	gint last_index;
	gboolean _tmp0_ = FALSE;
	ValaDataType* _tmp1_;
	gboolean _tmp4_;
	gboolean ret_is_struct;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	ValaList* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gboolean _tmp13_;
	gboolean _tmp18_;
	gboolean _tmp20_;
	gboolean _tmp22_;
	gboolean _tmp75_ = FALSE;
	ValaDataType* _tmp76_;
	gboolean _tmp78_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (params != NULL);
	last_index = 0;
	_tmp1_ = return_type;
	if (_tmp1_ != NULL) {
		ValaDataType* _tmp2_;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = return_type;
		_tmp3_ = vala_data_type_is_real_non_null_struct_type (_tmp2_);
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp4_ = _tmp0_;
	ret_is_struct = _tmp4_;
	_tmp9_ = params;
	_tmp10_ = vala_collection_get_size ((ValaCollection*) _tmp9_);
	_tmp11_ = _tmp10_;
	if (_tmp11_ != 0) {
		_tmp8_ = TRUE;
	} else {
		ValaDataType* _tmp12_;
		_tmp12_ = instance_type;
		_tmp8_ = _tmp12_ != NULL;
	}
	_tmp13_ = _tmp8_;
	if (_tmp13_) {
		_tmp7_ = TRUE;
	} else {
		gboolean _tmp14_ = FALSE;
		ValaDataType* _tmp15_;
		gboolean _tmp17_;
		_tmp15_ = return_type;
		if (VALA_IS_ARRAY_TYPE (_tmp15_)) {
			gboolean _tmp16_;
			_tmp16_ = return_array_length;
			_tmp14_ = _tmp16_;
		} else {
			_tmp14_ = FALSE;
		}
		_tmp17_ = _tmp14_;
		_tmp7_ = _tmp17_;
	}
	_tmp18_ = _tmp7_;
	if (_tmp18_) {
		_tmp6_ = TRUE;
	} else {
		ValaDataType* _tmp19_;
		_tmp19_ = return_type;
		_tmp6_ = VALA_IS_DELEGATE_TYPE (_tmp19_);
	}
	_tmp20_ = _tmp6_;
	if (_tmp20_) {
		_tmp5_ = TRUE;
	} else {
		gboolean _tmp21_;
		_tmp21_ = ret_is_struct;
		_tmp5_ = _tmp21_;
	}
	_tmp22_ = _tmp5_;
	if (_tmp22_) {
		GString* _tmp23_;
		gint _tmp24_;
		gint index;
		ValaDataType* _tmp25_;
		gboolean _tmp60_;
		gint _tmp65_;
		gboolean _tmp66_;
		gint _tmp73_;
		GString* _tmp74_;
		vala_gir_writer_write_indent (self);
		_tmp23_ = self->priv->buffer;
		g_string_append_printf (_tmp23_, "<parameters>\n");
		_tmp24_ = self->priv->indent;
		self->priv->indent = _tmp24_ + 1;
		index = 0;
		_tmp25_ = instance_type;
		if (_tmp25_ != NULL) {
			ValaDataType* _tmp26_;
			_tmp26_ = instance_type;
			vala_gir_writer_write_param_or_return (self, _tmp26_, TRUE, &index, FALSE, "self", VALA_PARAMETER_DIRECTION_IN, FALSE, FALSE);
		}
		{
			ValaList* _tmp27_;
			ValaList* _tmp28_;
			ValaList* _param_list;
			ValaList* _tmp29_;
			gint _tmp30_;
			gint _tmp31_;
			gint _param_size;
			gint _param_index;
			_tmp27_ = params;
			_tmp28_ = _vala_iterable_ref0 (_tmp27_);
			_param_list = _tmp28_;
			_tmp29_ = _param_list;
			_tmp30_ = vala_collection_get_size ((ValaCollection*) _tmp29_);
			_tmp31_ = _tmp30_;
			_param_size = _tmp31_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp32_;
				gint _tmp33_;
				gint _tmp34_;
				ValaList* _tmp35_;
				gint _tmp36_;
				gpointer _tmp37_ = NULL;
				ValaParameter* param;
				ValaParameter* _tmp38_;
				ValaDataType* _tmp39_;
				ValaDataType* _tmp40_;
				ValaParameter* _tmp41_;
				gboolean _tmp42_ = FALSE;
				ValaParameter* _tmp43_;
				const gchar* _tmp44_;
				const gchar* _tmp45_;
				ValaParameter* _tmp46_;
				ValaParameterDirection _tmp47_;
				ValaParameterDirection _tmp48_;
				ValaParameter* _tmp49_;
				ValaDataType* _tmp50_;
				ValaDataType* _tmp51_;
				ValaParameter* _tmp52_;
				gboolean _tmp53_ = FALSE;
				ValaParameter* _tmp54_;
				const gchar* _tmp55_;
				const gchar* _tmp56_;
				ValaParameter* _tmp57_;
				ValaParameterDirection _tmp58_;
				ValaParameterDirection _tmp59_;
				_tmp32_ = _param_index;
				_param_index = _tmp32_ + 1;
				_tmp33_ = _param_index;
				_tmp34_ = _param_size;
				if (!(_tmp33_ < _tmp34_)) {
					break;
				}
				_tmp35_ = _param_list;
				_tmp36_ = _param_index;
				_tmp37_ = vala_list_get (_tmp35_, _tmp36_);
				param = (ValaParameter*) _tmp37_;
				_tmp38_ = param;
				_tmp39_ = vala_variable_get_variable_type ((ValaVariable*) _tmp38_);
				_tmp40_ = _tmp39_;
				_tmp41_ = param;
				_tmp42_ = vala_ccode_base_module_get_ccode_array_length ((ValaCodeNode*) _tmp41_);
				_tmp43_ = param;
				_tmp44_ = vala_symbol_get_name ((ValaSymbol*) _tmp43_);
				_tmp45_ = _tmp44_;
				_tmp46_ = param;
				_tmp47_ = vala_parameter_get_direction (_tmp46_);
				_tmp48_ = _tmp47_;
				vala_gir_writer_write_param_or_return (self, _tmp40_, TRUE, &index, _tmp42_, _tmp45_, _tmp48_, FALSE, FALSE);
				_tmp49_ = param;
				_tmp50_ = vala_variable_get_variable_type ((ValaVariable*) _tmp49_);
				_tmp51_ = _tmp50_;
				_tmp52_ = param;
				_tmp53_ = vala_ccode_base_module_get_ccode_array_length ((ValaCodeNode*) _tmp52_);
				_tmp54_ = param;
				_tmp55_ = vala_symbol_get_name ((ValaSymbol*) _tmp54_);
				_tmp56_ = _tmp55_;
				_tmp57_ = param;
				_tmp58_ = vala_parameter_get_direction (_tmp57_);
				_tmp59_ = _tmp58_;
				vala_gir_writer_write_implicit_params (self, _tmp51_, &index, _tmp53_, _tmp56_, _tmp59_);
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		_tmp60_ = ret_is_struct;
		if (_tmp60_) {
			ValaDataType* _tmp61_;
			gboolean _tmp62_;
			_tmp61_ = return_type;
			_tmp62_ = constructor;
			vala_gir_writer_write_param_or_return (self, _tmp61_, TRUE, &index, FALSE, "result", VALA_PARAMETER_DIRECTION_OUT, _tmp62_, TRUE);
		} else {
			ValaDataType* _tmp63_;
			gboolean _tmp64_;
			_tmp63_ = return_type;
			_tmp64_ = return_array_length;
			vala_gir_writer_write_implicit_params (self, _tmp63_, &index, _tmp64_, "result", VALA_PARAMETER_DIRECTION_OUT);
		}
		_tmp65_ = index;
		last_index = _tmp65_ - 1;
		_tmp66_ = user_data;
		if (_tmp66_) {
			GString* _tmp67_;
			gint _tmp68_;
			gint _tmp69_;
			GString* _tmp70_;
			gint _tmp71_;
			GString* _tmp72_;
			vala_gir_writer_write_indent (self);
			_tmp67_ = self->priv->buffer;
			_tmp68_ = index;
			g_string_append_printf (_tmp67_, "<parameter name=\"user_data\" transfer-ownership=\"none\" closure=\"%d" \
"\">\n", _tmp68_);
			_tmp69_ = self->priv->indent;
			self->priv->indent = _tmp69_ + 1;
			vala_gir_writer_write_indent (self);
			_tmp70_ = self->priv->buffer;
			g_string_append_printf (_tmp70_, "<type name=\"gpointer\" c:type=\"void*\"/>\n");
			_tmp71_ = self->priv->indent;
			self->priv->indent = _tmp71_ - 1;
			vala_gir_writer_write_indent (self);
			_tmp72_ = self->priv->buffer;
			g_string_append_printf (_tmp72_, "</parameter>\n");
		}
		_tmp73_ = self->priv->indent;
		self->priv->indent = _tmp73_ - 1;
		vala_gir_writer_write_indent (self);
		_tmp74_ = self->priv->buffer;
		g_string_append_printf (_tmp74_, "</parameters>\n");
	}
	_tmp76_ = return_type;
	if (_tmp76_ != NULL) {
		gboolean _tmp77_;
		_tmp77_ = ret_is_struct;
		_tmp75_ = !_tmp77_;
	} else {
		_tmp75_ = FALSE;
	}
	_tmp78_ = _tmp75_;
	if (_tmp78_) {
		ValaDataType* _tmp79_;
		gboolean _tmp80_;
		gboolean _tmp81_;
		_tmp79_ = return_type;
		_tmp80_ = return_array_length;
		_tmp81_ = constructor;
		vala_gir_writer_write_param_or_return (self, _tmp79_, FALSE, &last_index, _tmp80_, NULL, VALA_PARAMETER_DIRECTION_IN, _tmp81_, FALSE);
	} else {
		gboolean _tmp82_;
		_tmp82_ = ret_is_struct;
		if (_tmp82_) {
			ValaVoidType* _tmp83_;
			ValaVoidType* _tmp84_;
			_tmp83_ = vala_void_type_new (NULL);
			_tmp84_ = _tmp83_;
			vala_gir_writer_write_param_or_return (self, (ValaDataType*) _tmp84_, FALSE, &last_index, FALSE, NULL, VALA_PARAMETER_DIRECTION_IN, FALSE, FALSE);
			_vala_code_node_unref0 (_tmp84_);
		}
	}
}


static void vala_gir_writer_real_visit_delegate (ValaCodeVisitor* base, ValaDelegate* cb) {
	ValaGIRWriter * self;
	ValaDelegate* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	ValaDelegate* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GString* _tmp5_;
	ValaDelegate* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	GString* _tmp9_;
	ValaDelegate* _tmp10_;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	ValaDelegate* _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	ValaDelegate* _tmp17_;
	GString* _tmp18_;
	gint _tmp19_;
	ValaDelegate* _tmp20_;
	ValaDelegate* _tmp21_;
	ValaList* _tmp22_ = NULL;
	ValaList* _tmp23_;
	ValaDelegate* _tmp24_;
	ValaDataType* _tmp25_;
	ValaDataType* _tmp26_;
	ValaDelegate* _tmp27_;
	gboolean _tmp28_ = FALSE;
	ValaDelegate* _tmp29_;
	gboolean _tmp30_;
	gboolean _tmp31_;
	gint _tmp32_;
	GString* _tmp33_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (cb != NULL);
	_tmp0_ = cb;
	_tmp1_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		return;
	}
	_tmp3_ = cb;
	_tmp4_ = vala_gir_writer_check_accessibility (self, (ValaSymbol*) _tmp3_);
	if (!_tmp4_) {
		return;
	}
	vala_gir_writer_write_indent (self);
	_tmp5_ = self->priv->buffer;
	_tmp6_ = cb;
	_tmp7_ = vala_symbol_get_name ((ValaSymbol*) _tmp6_);
	_tmp8_ = _tmp7_;
	g_string_append_printf (_tmp5_, "<callback name=\"%s\"", _tmp8_);
	_tmp9_ = self->priv->buffer;
	_tmp10_ = cb;
	_tmp11_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp10_);
	_tmp12_ = _tmp11_;
	g_string_append_printf (_tmp9_, " c:type=\"%s\"", _tmp12_);
	_g_free0 (_tmp12_);
	_tmp13_ = cb;
	_tmp14_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) _tmp13_);
	_tmp15_ = _tmp14_;
	if (_tmp15_) {
		GString* _tmp16_;
		_tmp16_ = self->priv->buffer;
		g_string_append_printf (_tmp16_, " throws=\"1\"");
	}
	_tmp17_ = cb;
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) _tmp17_);
	_tmp18_ = self->priv->buffer;
	g_string_append_printf (_tmp18_, ">\n");
	_tmp19_ = self->priv->indent;
	self->priv->indent = _tmp19_ + 1;
	_tmp20_ = cb;
	vala_gir_writer_write_annotations (self, (ValaCodeNode*) _tmp20_);
	_tmp21_ = cb;
	_tmp22_ = vala_delegate_get_parameters (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = cb;
	_tmp25_ = vala_delegate_get_return_type (_tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = cb;
	_tmp28_ = vala_ccode_base_module_get_ccode_array_length ((ValaCodeNode*) _tmp27_);
	_tmp29_ = cb;
	_tmp30_ = vala_delegate_get_has_target (_tmp29_);
	_tmp31_ = _tmp30_;
	vala_gir_writer_write_params_and_return (self, _tmp23_, _tmp26_, _tmp28_, FALSE, NULL, _tmp31_);
	_vala_iterable_unref0 (_tmp23_);
	_tmp32_ = self->priv->indent;
	self->priv->indent = _tmp32_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp33_ = self->priv->buffer;
	g_string_append_printf (_tmp33_, "</callback>\n");
}


static void vala_gir_writer_real_visit_method (ValaCodeVisitor* base, ValaMethod* m) {
	ValaGIRWriter * self;
	ValaMethod* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	ValaMethod* _tmp5_;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp10_;
	gboolean _tmp24_;
	ValaMethod* _tmp25_;
	gboolean _tmp26_ = FALSE;
	gchar* _tmp27_;
	gchar* tag_name;
	ValaArrayList* _tmp28_;
	gpointer _tmp29_ = NULL;
	ValaSymbol* parent;
	ValaSymbol* _tmp30_;
	gboolean _tmp33_ = FALSE;
	gboolean _tmp34_ = FALSE;
	ValaSymbol* _tmp35_;
	gboolean _tmp39_;
	gboolean _tmp44_;
	ValaMethod* _tmp46_;
	const gchar* _tmp47_;
	gboolean _tmp48_ = FALSE;
	ValaMethod* _tmp49_;
	gboolean _tmp50_;
	gboolean _tmp51_;
	gboolean _tmp55_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (m != NULL);
	_tmp0_ = m;
	_tmp1_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		return;
	}
	_tmp5_ = m;
	_tmp6_ = vala_gir_writer_check_accessibility (self, (ValaSymbol*) _tmp5_);
	if (!_tmp6_) {
		_tmp4_ = TRUE;
	} else {
		ValaMethod* _tmp7_;
		gboolean _tmp8_;
		gboolean _tmp9_;
		_tmp7_ = m;
		_tmp8_ = vala_method_get_overrides (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp4_ = _tmp9_;
	}
	_tmp10_ = _tmp4_;
	if (_tmp10_) {
		_tmp3_ = TRUE;
	} else {
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		ValaMethod* _tmp13_;
		ValaMethod* _tmp14_;
		ValaMethod* _tmp15_;
		gboolean _tmp19_;
		gboolean _tmp23_;
		_tmp13_ = m;
		_tmp14_ = vala_method_get_base_interface_method (_tmp13_);
		_tmp15_ = _tmp14_;
		if (_tmp15_ != NULL) {
			ValaMethod* _tmp16_;
			gboolean _tmp17_;
			gboolean _tmp18_;
			_tmp16_ = m;
			_tmp17_ = vala_method_get_is_abstract (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp12_ = !_tmp18_;
		} else {
			_tmp12_ = FALSE;
		}
		_tmp19_ = _tmp12_;
		if (_tmp19_) {
			ValaMethod* _tmp20_;
			gboolean _tmp21_;
			gboolean _tmp22_;
			_tmp20_ = m;
			_tmp21_ = vala_method_get_is_virtual (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp11_ = !_tmp22_;
		} else {
			_tmp11_ = FALSE;
		}
		_tmp23_ = _tmp11_;
		_tmp3_ = _tmp23_;
	}
	_tmp24_ = _tmp3_;
	if (_tmp24_) {
		return;
	}
	_tmp25_ = m;
	_tmp26_ = vala_gir_writer_check_signature (self, _tmp25_);
	if (!_tmp26_) {
		return;
	}
	_tmp27_ = g_strdup ("method");
	tag_name = _tmp27_;
	_tmp28_ = self->priv->hierarchy;
	_tmp29_ = vala_list_get ((ValaList*) _tmp28_, 0);
	parent = (ValaSymbol*) _tmp29_;
	_tmp30_ = parent;
	if (VALA_IS_ENUM (_tmp30_)) {
		ValaArrayList* _tmp31_;
		ValaMethod* _tmp32_;
		_tmp31_ = self->priv->deferred;
		_tmp32_ = m;
		vala_collection_add ((ValaCollection*) _tmp31_, (ValaCodeNode*) _tmp32_);
		_vala_code_node_unref0 (parent);
		_g_free0 (tag_name);
		return;
	}
	_tmp35_ = parent;
	if (VALA_IS_NAMESPACE (_tmp35_)) {
		_tmp34_ = TRUE;
	} else {
		ValaMethod* _tmp36_;
		ValaMemberBinding _tmp37_;
		ValaMemberBinding _tmp38_;
		_tmp36_ = m;
		_tmp37_ = vala_method_get_binding (_tmp36_);
		_tmp38_ = _tmp37_;
		_tmp34_ = _tmp38_ == VALA_MEMBER_BINDING_STATIC;
	}
	_tmp39_ = _tmp34_;
	if (_tmp39_) {
		_tmp33_ = TRUE;
	} else {
		ValaSymbol* _tmp40_;
		ValaMethod* _tmp41_;
		ValaSymbol* _tmp42_;
		ValaSymbol* _tmp43_;
		_tmp40_ = parent;
		_tmp41_ = m;
		_tmp42_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp41_);
		_tmp43_ = _tmp42_;
		_tmp33_ = _tmp40_ != _tmp43_;
	}
	_tmp44_ = _tmp33_;
	if (_tmp44_) {
		gchar* _tmp45_;
		_tmp45_ = g_strdup ("function");
		_g_free0 (tag_name);
		tag_name = _tmp45_;
	}
	_tmp46_ = m;
	_tmp47_ = tag_name;
	vala_gir_writer_write_signature (self, _tmp46_, _tmp47_, FALSE);
	_tmp49_ = m;
	_tmp50_ = vala_method_get_is_abstract (_tmp49_);
	_tmp51_ = _tmp50_;
	if (_tmp51_) {
		_tmp48_ = TRUE;
	} else {
		ValaMethod* _tmp52_;
		gboolean _tmp53_;
		gboolean _tmp54_;
		_tmp52_ = m;
		_tmp53_ = vala_method_get_is_virtual (_tmp52_);
		_tmp54_ = _tmp53_;
		_tmp48_ = _tmp54_;
	}
	_tmp55_ = _tmp48_;
	if (_tmp55_) {
		ValaMethod* _tmp56_;
		_tmp56_ = m;
		vala_gir_writer_write_signature (self, _tmp56_, "virtual-method", FALSE);
	}
	_vala_code_node_unref0 (parent);
	_g_free0 (tag_name);
}


static gboolean vala_gir_writer_check_type (ValaGIRWriter* self, ValaDataType* type) {
	gboolean result = FALSE;
	ValaDataType* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gboolean _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	_tmp0_ = type;
	_tmp1_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strcmp0 (_tmp2_, "va_list") == 0;
	_g_free0 (_tmp2_);
	if (_tmp3_) {
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


static gboolean vala_gir_writer_check_signature (ValaGIRWriter* self, ValaMethod* m) {
	gboolean result = FALSE;
	ValaMethod* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (m != NULL, FALSE);
	_tmp0_ = m;
	_tmp1_ = vala_method_get_return_type (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_gir_writer_check_type (self, _tmp2_);
	if (!_tmp3_) {
		result = FALSE;
		return result;
	}
	{
		ValaMethod* _tmp4_;
		ValaList* _tmp5_ = NULL;
		ValaList* _param_list;
		ValaList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _param_size;
		gint _param_index;
		_tmp4_ = m;
		_tmp5_ = vala_method_get_parameters (_tmp4_);
		_param_list = _tmp5_;
		_tmp6_ = _param_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_param_size = _tmp8_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			ValaList* _tmp12_;
			gint _tmp13_;
			gpointer _tmp14_ = NULL;
			ValaParameter* param;
			gboolean _tmp15_ = FALSE;
			ValaParameter* _tmp16_;
			ValaDataType* _tmp17_;
			ValaDataType* _tmp18_;
			gboolean _tmp23_;
			_tmp9_ = _param_index;
			_param_index = _tmp9_ + 1;
			_tmp10_ = _param_index;
			_tmp11_ = _param_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _param_list;
			_tmp13_ = _param_index;
			_tmp14_ = vala_list_get (_tmp12_, _tmp13_);
			param = (ValaParameter*) _tmp14_;
			_tmp16_ = param;
			_tmp17_ = vala_variable_get_variable_type ((ValaVariable*) _tmp16_);
			_tmp18_ = _tmp17_;
			if (_tmp18_ == NULL) {
				_tmp15_ = TRUE;
			} else {
				ValaParameter* _tmp19_;
				ValaDataType* _tmp20_;
				ValaDataType* _tmp21_;
				gboolean _tmp22_ = FALSE;
				_tmp19_ = param;
				_tmp20_ = vala_variable_get_variable_type ((ValaVariable*) _tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = vala_gir_writer_check_type (self, _tmp21_);
				_tmp15_ = !_tmp22_;
			}
			_tmp23_ = _tmp15_;
			if (_tmp23_) {
				result = FALSE;
				_vala_code_node_unref0 (param);
				_vala_iterable_unref0 (_param_list);
				return result;
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	result = TRUE;
	return result;
}


static void vala_gir_writer_write_signature (ValaGIRWriter* self, ValaMethod* m, const gchar* tag_name, gboolean instance) {
	ValaArrayList* _tmp0_;
	gpointer _tmp1_ = NULL;
	ValaSymbol* parent;
	gchar* name = NULL;
	ValaMethod* _tmp2_;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaMethod* _tmp22_;
	gboolean _tmp23_;
	gboolean _tmp24_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (m != NULL);
	g_return_if_fail (tag_name != NULL);
	_tmp0_ = self->priv->hierarchy;
	_tmp1_ = vala_list_get ((ValaList*) _tmp0_, 0);
	parent = (ValaSymbol*) _tmp1_;
	_tmp2_ = m;
	_tmp3_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = parent;
	if (_tmp4_ != _tmp5_) {
		ValaMethod* _tmp6_;
		gchar* _tmp7_ = NULL;
		ValaSymbol* _tmp8_;
		gchar* _tmp9_ = NULL;
		gchar* parent_prefix;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		gboolean _tmp12_ = FALSE;
		instance = FALSE;
		_tmp6_ = m;
		_tmp7_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp6_);
		_g_free0 (name);
		name = _tmp7_;
		_tmp8_ = parent;
		_tmp9_ = vala_ccode_base_module_get_ccode_lower_case_prefix (_tmp8_);
		parent_prefix = _tmp9_;
		_tmp10_ = name;
		_tmp11_ = parent_prefix;
		_tmp12_ = g_str_has_prefix (_tmp10_, _tmp11_);
		if (_tmp12_) {
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			gchar* _tmp17_ = NULL;
			_tmp13_ = name;
			_tmp14_ = parent_prefix;
			_tmp15_ = strlen (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = string_substring (_tmp13_, (glong) _tmp16_, (glong) (-1));
			_g_free0 (name);
			name = _tmp17_;
		}
		_g_free0 (parent_prefix);
	} else {
		ValaMethod* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		_tmp18_ = m;
		_tmp19_ = vala_symbol_get_name ((ValaSymbol*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = g_strdup (_tmp20_);
		_g_free0 (name);
		name = _tmp21_;
	}
	_tmp22_ = m;
	_tmp23_ = vala_method_get_coroutine (_tmp22_);
	_tmp24_ = _tmp23_;
	if (_tmp24_) {
		const gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* finish_name;
		const gchar* _tmp27_;
		gboolean _tmp28_ = FALSE;
		const gchar* _tmp36_;
		gchar* _tmp37_;
		ValaMethod* _tmp38_;
		const gchar* _tmp39_;
		gboolean _tmp40_;
		const gchar* _tmp41_;
		ValaMethod* _tmp42_;
		gchar* _tmp43_ = NULL;
		gchar* _tmp44_;
		ValaMethod* _tmp45_;
		ValaList* _tmp46_ = NULL;
		ValaList* _tmp47_;
		ValaVoidType* _tmp48_;
		ValaVoidType* _tmp49_;
		ValaMethod* _tmp50_;
		const gchar* _tmp51_;
		gboolean _tmp52_;
		const gchar* _tmp53_;
		ValaMethod* _tmp54_;
		gchar* _tmp55_ = NULL;
		gchar* _tmp56_;
		ValaMethod* _tmp57_;
		ValaList* _tmp58_ = NULL;
		ValaList* _tmp59_;
		ValaMethod* _tmp60_;
		ValaDataType* _tmp61_;
		ValaDataType* _tmp62_;
		ValaMethod* _tmp63_;
		gboolean _tmp64_;
		gboolean _tmp65_;
		_tmp25_ = name;
		_tmp26_ = g_strdup (_tmp25_);
		finish_name = _tmp26_;
		_tmp27_ = finish_name;
		_tmp28_ = g_str_has_suffix (_tmp27_, "_async");
		if (_tmp28_) {
			const gchar* _tmp29_;
			const gchar* _tmp30_;
			gint _tmp31_;
			gint _tmp32_;
			gint _tmp33_;
			gint _tmp34_;
			gchar* _tmp35_ = NULL;
			_tmp29_ = finish_name;
			_tmp30_ = finish_name;
			_tmp31_ = strlen (_tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = strlen ("_async");
			_tmp34_ = _tmp33_;
			_tmp35_ = string_substring (_tmp29_, (glong) 0, (glong) (_tmp32_ - _tmp34_));
			_g_free0 (finish_name);
			finish_name = _tmp35_;
		}
		_tmp36_ = finish_name;
		_tmp37_ = g_strconcat (_tmp36_, "_finish", NULL);
		_g_free0 (finish_name);
		finish_name = _tmp37_;
		_tmp38_ = m;
		_tmp39_ = tag_name;
		_tmp40_ = instance;
		_tmp41_ = name;
		_tmp42_ = m;
		_tmp43_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp42_);
		_tmp44_ = _tmp43_;
		_tmp45_ = m;
		_tmp46_ = vala_method_get_async_begin_parameters (_tmp45_);
		_tmp47_ = _tmp46_;
		_tmp48_ = vala_void_type_new (NULL);
		_tmp49_ = _tmp48_;
		vala_gir_writer_do_write_signature (self, _tmp38_, _tmp39_, _tmp40_, _tmp41_, _tmp44_, _tmp47_, (ValaDataType*) _tmp49_, FALSE);
		_vala_code_node_unref0 (_tmp49_);
		_vala_iterable_unref0 (_tmp47_);
		_g_free0 (_tmp44_);
		_tmp50_ = m;
		_tmp51_ = tag_name;
		_tmp52_ = instance;
		_tmp53_ = finish_name;
		_tmp54_ = m;
		_tmp55_ = vala_ccode_base_module_get_ccode_finish_name (_tmp54_);
		_tmp56_ = _tmp55_;
		_tmp57_ = m;
		_tmp58_ = vala_method_get_async_end_parameters (_tmp57_);
		_tmp59_ = _tmp58_;
		_tmp60_ = m;
		_tmp61_ = vala_method_get_return_type (_tmp60_);
		_tmp62_ = _tmp61_;
		_tmp63_ = m;
		_tmp64_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) _tmp63_);
		_tmp65_ = _tmp64_;
		vala_gir_writer_do_write_signature (self, _tmp50_, _tmp51_, _tmp52_, _tmp53_, _tmp56_, _tmp59_, _tmp62_, _tmp65_);
		_vala_iterable_unref0 (_tmp59_);
		_g_free0 (_tmp56_);
		_g_free0 (finish_name);
	} else {
		ValaMethod* _tmp66_;
		const gchar* _tmp67_;
		gboolean _tmp68_;
		const gchar* _tmp69_;
		ValaMethod* _tmp70_;
		gchar* _tmp71_ = NULL;
		gchar* _tmp72_;
		ValaMethod* _tmp73_;
		ValaList* _tmp74_ = NULL;
		ValaList* _tmp75_;
		ValaMethod* _tmp76_;
		ValaDataType* _tmp77_;
		ValaDataType* _tmp78_;
		ValaMethod* _tmp79_;
		gboolean _tmp80_;
		gboolean _tmp81_;
		_tmp66_ = m;
		_tmp67_ = tag_name;
		_tmp68_ = instance;
		_tmp69_ = name;
		_tmp70_ = m;
		_tmp71_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp70_);
		_tmp72_ = _tmp71_;
		_tmp73_ = m;
		_tmp74_ = vala_method_get_parameters (_tmp73_);
		_tmp75_ = _tmp74_;
		_tmp76_ = m;
		_tmp77_ = vala_method_get_return_type (_tmp76_);
		_tmp78_ = _tmp77_;
		_tmp79_ = m;
		_tmp80_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) _tmp79_);
		_tmp81_ = _tmp80_;
		vala_gir_writer_do_write_signature (self, _tmp66_, _tmp67_, _tmp68_, _tmp69_, _tmp72_, _tmp75_, _tmp78_, _tmp81_);
		_vala_iterable_unref0 (_tmp75_);
		_g_free0 (_tmp72_);
	}
	_g_free0 (name);
	_vala_code_node_unref0 (parent);
}


static void vala_gir_writer_do_write_signature (ValaGIRWriter* self, ValaMethod* m, const gchar* tag_name, gboolean instance, const gchar* name, const gchar* cname, ValaList* params, ValaDataType* return_type, gboolean can_fail) {
	GString* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp11_;
	ValaMethod* _tmp13_;
	GString* _tmp14_;
	gint _tmp15_;
	ValaMethod* _tmp16_;
	ValaDataType* instance_type;
	gboolean _tmp17_;
	ValaList* _tmp22_;
	ValaDataType* _tmp23_;
	ValaMethod* _tmp24_;
	gboolean _tmp25_ = FALSE;
	ValaDataType* _tmp26_;
	gint _tmp27_;
	GString* _tmp28_;
	const gchar* _tmp29_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (m != NULL);
	g_return_if_fail (tag_name != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (cname != NULL);
	g_return_if_fail (params != NULL);
	g_return_if_fail (return_type != NULL);
	vala_gir_writer_write_indent (self);
	_tmp0_ = self->priv->buffer;
	_tmp1_ = tag_name;
	_tmp2_ = name;
	g_string_append_printf (_tmp0_, "<%s name=\"%s\"", _tmp1_, _tmp2_);
	_tmp3_ = tag_name;
	if (g_strcmp0 (_tmp3_, "virtual-method") == 0) {
		GString* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = self->priv->buffer;
		_tmp5_ = name;
		g_string_append_printf (_tmp4_, " invoker=\"%s\"", _tmp5_);
	} else {
		const gchar* _tmp6_;
		_tmp6_ = tag_name;
		if (g_strcmp0 (_tmp6_, "callback") == 0) {
			GString* _tmp7_;
			const gchar* _tmp8_;
			_tmp7_ = self->priv->buffer;
			_tmp8_ = name;
			g_string_append_printf (_tmp7_, " c:type=\"%s\"", _tmp8_);
		} else {
			GString* _tmp9_;
			const gchar* _tmp10_;
			_tmp9_ = self->priv->buffer;
			_tmp10_ = cname;
			g_string_append_printf (_tmp9_, " c:identifier=\"%s\"", _tmp10_);
		}
	}
	_tmp11_ = can_fail;
	if (_tmp11_) {
		GString* _tmp12_;
		_tmp12_ = self->priv->buffer;
		g_string_append_printf (_tmp12_, " throws=\"1\"");
	}
	_tmp13_ = m;
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) _tmp13_);
	_tmp14_ = self->priv->buffer;
	g_string_append_printf (_tmp14_, ">\n");
	_tmp15_ = self->priv->indent;
	self->priv->indent = _tmp15_ + 1;
	_tmp16_ = m;
	vala_gir_writer_write_annotations (self, (ValaCodeNode*) _tmp16_);
	instance_type = NULL;
	_tmp17_ = instance;
	if (_tmp17_) {
		ValaMethod* _tmp18_;
		ValaSymbol* _tmp19_;
		ValaSymbol* _tmp20_;
		ValaDataType* _tmp21_ = NULL;
		_tmp18_ = m;
		_tmp19_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_ccode_base_module_get_data_type_for_symbol (VALA_TYPESYMBOL (_tmp20_));
		_vala_code_node_unref0 (instance_type);
		instance_type = _tmp21_;
	}
	_tmp22_ = params;
	_tmp23_ = return_type;
	_tmp24_ = m;
	_tmp25_ = vala_ccode_base_module_get_ccode_array_length ((ValaCodeNode*) _tmp24_);
	_tmp26_ = instance_type;
	vala_gir_writer_write_params_and_return (self, _tmp22_, _tmp23_, _tmp25_, FALSE, _tmp26_, FALSE);
	_tmp27_ = self->priv->indent;
	self->priv->indent = _tmp27_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp28_ = self->priv->buffer;
	_tmp29_ = tag_name;
	g_string_append_printf (_tmp28_, "</%s>\n", _tmp29_);
	_vala_code_node_unref0 (instance_type);
}


static void vala_gir_writer_real_visit_creation_method (ValaCodeVisitor* base, ValaCreationMethod* m) {
	ValaGIRWriter * self;
	ValaCreationMethod* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	ValaCreationMethod* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	ValaCreationMethod* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaSymbol* _tmp8_;
	gboolean _tmp14_;
	ValaCreationMethod* _tmp15_;
	ValaSymbol* _tmp16_;
	ValaSymbol* _tmp17_;
	gboolean is_struct;
	const gchar* _tmp18_ = NULL;
	gboolean _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* tag_name;
	gboolean _tmp22_ = FALSE;
	gboolean _tmp23_ = FALSE;
	ValaCreationMethod* _tmp24_;
	ValaSymbol* _tmp25_;
	ValaSymbol* _tmp26_;
	gboolean _tmp33_;
	gboolean _tmp45_;
	ValaCreationMethod* _tmp64_;
	gboolean _tmp65_;
	gboolean _tmp66_;
	GString* _tmp68_;
	gint _tmp69_;
	ValaCreationMethod* _tmp70_;
	ValaCreationMethod* _tmp71_;
	ValaSymbol* _tmp72_;
	ValaSymbol* _tmp73_;
	ValaDataType* _tmp74_ = NULL;
	ValaDataType* datatype;
	ValaCreationMethod* _tmp75_;
	ValaList* _tmp76_ = NULL;
	ValaList* _tmp77_;
	ValaDataType* _tmp78_;
	gint _tmp79_;
	GString* _tmp80_;
	const gchar* _tmp81_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (m != NULL);
	_tmp0_ = m;
	_tmp1_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		return;
	}
	_tmp3_ = m;
	_tmp4_ = vala_gir_writer_check_accessibility (self, (ValaSymbol*) _tmp3_);
	if (!_tmp4_) {
		return;
	}
	_tmp6_ = m;
	_tmp7_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp6_);
	_tmp8_ = _tmp7_;
	if (VALA_IS_CLASS (_tmp8_)) {
		ValaCreationMethod* _tmp9_;
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		gboolean _tmp12_;
		gboolean _tmp13_;
		_tmp9_ = m;
		_tmp10_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_class_get_is_abstract (VALA_CLASS (_tmp11_));
		_tmp13_ = _tmp12_;
		_tmp5_ = _tmp13_;
	} else {
		_tmp5_ = FALSE;
	}
	_tmp14_ = _tmp5_;
	if (_tmp14_) {
		return;
	}
	vala_gir_writer_write_indent (self);
	_tmp15_ = m;
	_tmp16_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp15_);
	_tmp17_ = _tmp16_;
	is_struct = VALA_IS_STRUCT (_tmp17_);
	_tmp19_ = is_struct;
	if (_tmp19_) {
		_tmp18_ = "function";
	} else {
		_tmp18_ = "constructor";
	}
	_tmp20_ = _tmp18_;
	_tmp21_ = g_strdup (_tmp20_);
	tag_name = _tmp21_;
	_tmp24_ = m;
	_tmp25_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp24_);
	_tmp26_ = _tmp25_;
	if (VALA_IS_CLASS (_tmp26_)) {
		ValaCreationMethod* _tmp27_;
		ValaCreationMethod* _tmp28_;
		ValaSymbol* _tmp29_;
		ValaSymbol* _tmp30_;
		ValaMethod* _tmp31_;
		ValaMethod* _tmp32_;
		_tmp27_ = m;
		_tmp28_ = m;
		_tmp29_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = vala_class_get_default_construction_method (VALA_CLASS (_tmp30_));
		_tmp32_ = _tmp31_;
		_tmp23_ = VALA_METHOD (_tmp27_) == _tmp32_;
	} else {
		_tmp23_ = FALSE;
	}
	_tmp33_ = _tmp23_;
	if (_tmp33_) {
		_tmp22_ = TRUE;
	} else {
		gboolean _tmp34_ = FALSE;
		ValaCreationMethod* _tmp35_;
		ValaSymbol* _tmp36_;
		ValaSymbol* _tmp37_;
		gboolean _tmp44_;
		_tmp35_ = m;
		_tmp36_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp35_);
		_tmp37_ = _tmp36_;
		if (VALA_IS_STRUCT (_tmp37_)) {
			ValaCreationMethod* _tmp38_;
			ValaCreationMethod* _tmp39_;
			ValaSymbol* _tmp40_;
			ValaSymbol* _tmp41_;
			ValaMethod* _tmp42_;
			ValaMethod* _tmp43_;
			_tmp38_ = m;
			_tmp39_ = m;
			_tmp40_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = vala_struct_get_default_construction_method (VALA_STRUCT (_tmp41_));
			_tmp43_ = _tmp42_;
			_tmp34_ = VALA_METHOD (_tmp38_) == _tmp43_;
		} else {
			_tmp34_ = FALSE;
		}
		_tmp44_ = _tmp34_;
		_tmp22_ = _tmp44_;
	}
	_tmp45_ = _tmp22_;
	if (_tmp45_) {
		const gchar* _tmp46_ = NULL;
		gboolean _tmp47_;
		const gchar* _tmp48_;
		gchar* _tmp49_;
		gchar* m_name;
		GString* _tmp50_;
		const gchar* _tmp51_;
		const gchar* _tmp52_;
		ValaCreationMethod* _tmp53_;
		gchar* _tmp54_ = NULL;
		gchar* _tmp55_;
		_tmp47_ = is_struct;
		if (_tmp47_) {
			_tmp46_ = "init";
		} else {
			_tmp46_ = "new";
		}
		_tmp48_ = _tmp46_;
		_tmp49_ = g_strdup (_tmp48_);
		m_name = _tmp49_;
		_tmp50_ = self->priv->buffer;
		_tmp51_ = tag_name;
		_tmp52_ = m_name;
		_tmp53_ = m;
		_tmp54_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp53_);
		_tmp55_ = _tmp54_;
		g_string_append_printf (_tmp50_, "<%s name=\"%s\" c:identifier=\"%s\"", _tmp51_, _tmp52_, _tmp55_);
		_g_free0 (_tmp55_);
		_g_free0 (m_name);
	} else {
		GString* _tmp56_;
		const gchar* _tmp57_;
		ValaCreationMethod* _tmp58_;
		const gchar* _tmp59_;
		const gchar* _tmp60_;
		ValaCreationMethod* _tmp61_;
		gchar* _tmp62_ = NULL;
		gchar* _tmp63_;
		_tmp56_ = self->priv->buffer;
		_tmp57_ = tag_name;
		_tmp58_ = m;
		_tmp59_ = vala_symbol_get_name ((ValaSymbol*) _tmp58_);
		_tmp60_ = _tmp59_;
		_tmp61_ = m;
		_tmp62_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp61_);
		_tmp63_ = _tmp62_;
		g_string_append_printf (_tmp56_, "<%s name=\"%s\" c:identifier=\"%s\"", _tmp57_, _tmp60_, _tmp63_);
		_g_free0 (_tmp63_);
	}
	_tmp64_ = m;
	_tmp65_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) _tmp64_);
	_tmp66_ = _tmp65_;
	if (_tmp66_) {
		GString* _tmp67_;
		_tmp67_ = self->priv->buffer;
		g_string_append_printf (_tmp67_, " throws=\"1\"");
	}
	_tmp68_ = self->priv->buffer;
	g_string_append_printf (_tmp68_, ">\n");
	_tmp69_ = self->priv->indent;
	self->priv->indent = _tmp69_ + 1;
	_tmp70_ = m;
	vala_gir_writer_write_annotations (self, (ValaCodeNode*) _tmp70_);
	_tmp71_ = m;
	_tmp72_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp71_);
	_tmp73_ = _tmp72_;
	_tmp74_ = vala_ccode_base_module_get_data_type_for_symbol (VALA_TYPESYMBOL (_tmp73_));
	datatype = _tmp74_;
	_tmp75_ = m;
	_tmp76_ = vala_method_get_parameters ((ValaMethod*) _tmp75_);
	_tmp77_ = _tmp76_;
	_tmp78_ = datatype;
	vala_gir_writer_write_params_and_return (self, _tmp77_, _tmp78_, FALSE, TRUE, NULL, FALSE);
	_vala_iterable_unref0 (_tmp77_);
	_tmp79_ = self->priv->indent;
	self->priv->indent = _tmp79_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp80_ = self->priv->buffer;
	_tmp81_ = tag_name;
	g_string_append_printf (_tmp80_, "</%s>\n", _tmp81_);
	_vala_code_node_unref0 (datatype);
	_g_free0 (tag_name);
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* regex;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch4_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp5_ = regex;
		_tmp6_ = replacement;
		_tmp7_ = g_regex_replace_literal (_tmp5_, self, (gssize) (-1), 0, _tmp6_, 0, &_inner_error_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch4_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp8_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally4;
	__catch4_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally4:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static void vala_gir_writer_real_visit_property (ValaCodeVisitor* base, ValaProperty* prop) {
	ValaGIRWriter * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaProperty* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp7_;
	gboolean _tmp21_;
	GString* _tmp22_;
	ValaProperty* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_;
	ValaProperty* _tmp28_;
	ValaPropertyAccessor* _tmp29_;
	ValaPropertyAccessor* _tmp30_;
	ValaProperty* _tmp32_;
	ValaPropertyAccessor* _tmp33_;
	ValaPropertyAccessor* _tmp34_;
	ValaProperty* _tmp48_;
	GString* _tmp49_;
	gint _tmp50_;
	ValaProperty* _tmp51_;
	ValaProperty* _tmp52_;
	ValaDataType* _tmp53_;
	ValaDataType* _tmp54_;
	gint _tmp55_;
	GString* _tmp56_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (prop != NULL);
	_tmp2_ = prop;
	_tmp3_ = vala_gir_writer_check_accessibility (self, (ValaSymbol*) _tmp2_);
	if (!_tmp3_) {
		_tmp1_ = TRUE;
	} else {
		ValaProperty* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp4_ = prop;
		_tmp5_ = vala_property_get_overrides (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp1_ = _tmp6_;
	}
	_tmp7_ = _tmp1_;
	if (_tmp7_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		ValaProperty* _tmp10_;
		ValaProperty* _tmp11_;
		ValaProperty* _tmp12_;
		gboolean _tmp16_;
		gboolean _tmp20_;
		_tmp10_ = prop;
		_tmp11_ = vala_property_get_base_interface_property (_tmp10_);
		_tmp12_ = _tmp11_;
		if (_tmp12_ != NULL) {
			ValaProperty* _tmp13_;
			gboolean _tmp14_;
			gboolean _tmp15_;
			_tmp13_ = prop;
			_tmp14_ = vala_property_get_is_abstract (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp9_ = !_tmp15_;
		} else {
			_tmp9_ = FALSE;
		}
		_tmp16_ = _tmp9_;
		if (_tmp16_) {
			ValaProperty* _tmp17_;
			gboolean _tmp18_;
			gboolean _tmp19_;
			_tmp17_ = prop;
			_tmp18_ = vala_property_get_is_virtual (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp8_ = !_tmp19_;
		} else {
			_tmp8_ = FALSE;
		}
		_tmp20_ = _tmp8_;
		_tmp0_ = _tmp20_;
	}
	_tmp21_ = _tmp0_;
	if (_tmp21_) {
		return;
	}
	vala_gir_writer_write_indent (self);
	_tmp22_ = self->priv->buffer;
	_tmp23_ = prop;
	_tmp24_ = vala_symbol_get_name ((ValaSymbol*) _tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = string_replace (_tmp25_, "_", "-");
	_tmp27_ = _tmp26_;
	g_string_append_printf (_tmp22_, "<property name=\"%s\"", _tmp27_);
	_g_free0 (_tmp27_);
	_tmp28_ = prop;
	_tmp29_ = vala_property_get_get_accessor (_tmp28_);
	_tmp30_ = _tmp29_;
	if (_tmp30_ == NULL) {
		GString* _tmp31_;
		_tmp31_ = self->priv->buffer;
		g_string_append_printf (_tmp31_, " readable=\"0\"");
	}
	_tmp32_ = prop;
	_tmp33_ = vala_property_get_set_accessor (_tmp32_);
	_tmp34_ = _tmp33_;
	if (_tmp34_ != NULL) {
		GString* _tmp35_;
		ValaProperty* _tmp36_;
		ValaPropertyAccessor* _tmp37_;
		ValaPropertyAccessor* _tmp38_;
		gboolean _tmp39_;
		gboolean _tmp40_;
		_tmp35_ = self->priv->buffer;
		g_string_append_printf (_tmp35_, " writable=\"1\"");
		_tmp36_ = prop;
		_tmp37_ = vala_property_get_set_accessor (_tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = vala_property_accessor_get_construction (_tmp38_);
		_tmp40_ = _tmp39_;
		if (_tmp40_) {
			ValaProperty* _tmp41_;
			ValaPropertyAccessor* _tmp42_;
			ValaPropertyAccessor* _tmp43_;
			gboolean _tmp44_;
			gboolean _tmp45_;
			_tmp41_ = prop;
			_tmp42_ = vala_property_get_set_accessor (_tmp41_);
			_tmp43_ = _tmp42_;
			_tmp44_ = vala_property_accessor_get_writable (_tmp43_);
			_tmp45_ = _tmp44_;
			if (!_tmp45_) {
				GString* _tmp46_;
				_tmp46_ = self->priv->buffer;
				g_string_append_printf (_tmp46_, " construct-only=\"1\"");
			} else {
				GString* _tmp47_;
				_tmp47_ = self->priv->buffer;
				g_string_append_printf (_tmp47_, " construct=\"1\"");
			}
		}
	}
	_tmp48_ = prop;
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) _tmp48_);
	_tmp49_ = self->priv->buffer;
	g_string_append_printf (_tmp49_, ">\n");
	_tmp50_ = self->priv->indent;
	self->priv->indent = _tmp50_ + 1;
	_tmp51_ = prop;
	vala_gir_writer_write_annotations (self, (ValaCodeNode*) _tmp51_);
	_tmp52_ = prop;
	_tmp53_ = vala_property_get_property_type (_tmp52_);
	_tmp54_ = _tmp53_;
	vala_gir_writer_write_type (self, _tmp54_, -1);
	_tmp55_ = self->priv->indent;
	self->priv->indent = _tmp55_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp56_ = self->priv->buffer;
	g_string_append_printf (_tmp56_, "</property>\n");
}


static void vala_gir_writer_real_visit_signal (ValaCodeVisitor* base, ValaSignal* sig) {
	ValaGIRWriter * self;
	ValaSignal* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GString* _tmp2_;
	ValaSignal* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	ValaSignal* _tmp6_;
	GString* _tmp7_;
	gint _tmp8_;
	ValaSignal* _tmp9_;
	ValaSignal* _tmp10_;
	ValaList* _tmp11_ = NULL;
	ValaList* _tmp12_;
	ValaSignal* _tmp13_;
	ValaDataType* _tmp14_;
	ValaDataType* _tmp15_;
	gint _tmp16_;
	GString* _tmp17_;
	self = (ValaGIRWriter*) base;
	g_return_if_fail (sig != NULL);
	_tmp0_ = sig;
	_tmp1_ = vala_gir_writer_check_accessibility (self, (ValaSymbol*) _tmp0_);
	if (!_tmp1_) {
		return;
	}
	vala_gir_writer_write_indent (self);
	_tmp2_ = self->priv->buffer;
	_tmp3_ = sig;
	_tmp4_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp3_);
	_tmp5_ = _tmp4_;
	g_string_append_printf (_tmp2_, "<glib:signal name=\"%s\"", _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = sig;
	vala_gir_writer_write_symbol_attributes (self, (ValaSymbol*) _tmp6_);
	_tmp7_ = self->priv->buffer;
	g_string_append_printf (_tmp7_, ">\n");
	_tmp8_ = self->priv->indent;
	self->priv->indent = _tmp8_ + 1;
	_tmp9_ = sig;
	vala_gir_writer_write_annotations (self, (ValaCodeNode*) _tmp9_);
	_tmp10_ = sig;
	_tmp11_ = vala_signal_get_parameters (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = sig;
	_tmp14_ = vala_signal_get_return_type (_tmp13_);
	_tmp15_ = _tmp14_;
	vala_gir_writer_write_params_and_return (self, _tmp12_, _tmp15_, FALSE, FALSE, NULL, FALSE);
	_vala_iterable_unref0 (_tmp12_);
	_tmp16_ = self->priv->indent;
	self->priv->indent = _tmp16_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp17_ = self->priv->buffer;
	g_string_append_printf (_tmp17_, "</glib:signal>\n");
}


static void vala_gir_writer_write_indent (ValaGIRWriter* self) {
	gint i = 0;
	g_return_if_fail (self != NULL);
	{
		gboolean _tmp0_;
		i = 0;
		_tmp0_ = TRUE;
		while (TRUE) {
			gboolean _tmp1_;
			gint _tmp3_;
			gint _tmp4_;
			GString* _tmp5_;
			_tmp1_ = _tmp0_;
			if (!_tmp1_) {
				gint _tmp2_;
				_tmp2_ = i;
				i = _tmp2_ + 1;
			}
			_tmp0_ = FALSE;
			_tmp3_ = i;
			_tmp4_ = self->priv->indent;
			if (!(_tmp3_ < _tmp4_)) {
				break;
			}
			_tmp5_ = self->priv->buffer;
			g_string_append_c (_tmp5_, '\t');
		}
	}
}


static void vala_gir_writer_write_indent_stream (ValaGIRWriter* self) {
	gint i = 0;
	g_return_if_fail (self != NULL);
	{
		gboolean _tmp0_;
		i = 0;
		_tmp0_ = TRUE;
		while (TRUE) {
			gboolean _tmp1_;
			gint _tmp3_;
			gint _tmp4_;
			FILE* _tmp5_;
			_tmp1_ = _tmp0_;
			if (!_tmp1_) {
				gint _tmp2_;
				_tmp2_ = i;
				i = _tmp2_ + 1;
			}
			_tmp0_ = FALSE;
			_tmp3_ = i;
			_tmp4_ = self->priv->indent;
			if (!(_tmp3_ < _tmp4_)) {
				break;
			}
			_tmp5_ = self->priv->stream;
			fputc ('\t', _tmp5_);
		}
	}
}


static void vala_gir_writer_write_param_or_return (ValaGIRWriter* self, ValaDataType* type, gboolean is_parameter, gint* index, gboolean has_array_length, const gchar* name, ValaParameterDirection direction, gboolean constructor, gboolean caller_allocates) {
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* tag;
	GString* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	ValaParameterDirection _tmp9_;
	ValaDataType* _tmp13_;
	ValaDelegateType* _tmp14_;
	ValaDelegateType* delegate_type;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	ValaDataType* _tmp17_;
	gboolean _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp21_;
	gboolean _tmp23_;
	gboolean _tmp26_;
	ValaDataType* _tmp28_;
	gboolean _tmp29_;
	gboolean _tmp30_;
	gboolean _tmp32_ = FALSE;
	ValaDelegateType* _tmp33_;
	gboolean _tmp39_;
	GString* _tmp62_;
	gint _tmp63_;
	gint length_param_index;
	gboolean _tmp64_;
	ValaDataType* _tmp70_;
	gint _tmp71_;
	gint _tmp72_;
	GString* _tmp73_;
	const gchar* _tmp74_;
	gint _tmp75_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	vala_gir_writer_write_indent (self);
	_tmp1_ = is_parameter;
	if (_tmp1_) {
		_tmp0_ = "parameter";
	} else {
		_tmp0_ = "return-value";
	}
	_tmp2_ = _tmp0_;
	_tmp3_ = g_strdup (_tmp2_);
	tag = _tmp3_;
	_tmp4_ = self->priv->buffer;
	_tmp5_ = tag;
	g_string_append_printf (_tmp4_, "<%s", _tmp5_);
	_tmp6_ = name;
	if (_tmp6_ != NULL) {
		GString* _tmp7_;
		const gchar* _tmp8_;
		_tmp7_ = self->priv->buffer;
		_tmp8_ = name;
		g_string_append_printf (_tmp7_, " name=\"%s\"", _tmp8_);
	}
	_tmp9_ = direction;
	if (_tmp9_ == VALA_PARAMETER_DIRECTION_REF) {
		GString* _tmp10_;
		_tmp10_ = self->priv->buffer;
		g_string_append_printf (_tmp10_, " direction=\"inout\"");
	} else {
		ValaParameterDirection _tmp11_;
		_tmp11_ = direction;
		if (_tmp11_ == VALA_PARAMETER_DIRECTION_OUT) {
			GString* _tmp12_;
			_tmp12_ = self->priv->buffer;
			g_string_append_printf (_tmp12_, " direction=\"out\"");
		}
	}
	_tmp13_ = type;
	_tmp14_ = _vala_code_node_ref0 (VALA_IS_DELEGATE_TYPE (_tmp13_) ? ((ValaDelegateType*) _tmp13_) : NULL);
	delegate_type = _tmp14_;
	_tmp17_ = type;
	_tmp18_ = vala_data_type_get_value_owned (_tmp17_);
	_tmp19_ = _tmp18_;
	if (_tmp19_) {
		ValaDelegateType* _tmp20_;
		_tmp20_ = delegate_type;
		_tmp16_ = _tmp20_ == NULL;
	} else {
		_tmp16_ = FALSE;
	}
	_tmp21_ = _tmp16_;
	if (_tmp21_) {
		_tmp15_ = TRUE;
	} else {
		gboolean _tmp22_;
		_tmp22_ = constructor;
		_tmp15_ = _tmp22_;
	}
	_tmp23_ = _tmp15_;
	if (_tmp23_) {
		GString* _tmp24_;
		_tmp24_ = self->priv->buffer;
		g_string_append_printf (_tmp24_, " transfer-ownership=\"full\"");
	} else {
		GString* _tmp25_;
		_tmp25_ = self->priv->buffer;
		g_string_append_printf (_tmp25_, " transfer-ownership=\"none\"");
	}
	_tmp26_ = caller_allocates;
	if (_tmp26_) {
		GString* _tmp27_;
		_tmp27_ = self->priv->buffer;
		g_string_append_printf (_tmp27_, " caller-allocates=\"1\"");
	}
	_tmp28_ = type;
	_tmp29_ = vala_data_type_get_nullable (_tmp28_);
	_tmp30_ = _tmp29_;
	if (_tmp30_) {
		GString* _tmp31_;
		_tmp31_ = self->priv->buffer;
		g_string_append_printf (_tmp31_, " allow-none=\"1\"");
	}
	_tmp33_ = delegate_type;
	if (_tmp33_ != NULL) {
		ValaDelegateType* _tmp34_;
		ValaDelegate* _tmp35_;
		ValaDelegate* _tmp36_;
		gboolean _tmp37_;
		gboolean _tmp38_;
		_tmp34_ = delegate_type;
		_tmp35_ = vala_delegate_type_get_delegate_symbol (_tmp34_);
		_tmp36_ = _tmp35_;
		_tmp37_ = vala_delegate_get_has_target (_tmp36_);
		_tmp38_ = _tmp37_;
		_tmp32_ = _tmp38_;
	} else {
		_tmp32_ = FALSE;
	}
	_tmp39_ = _tmp32_;
	if (_tmp39_) {
		gint _tmp40_ = 0;
		gboolean _tmp41_;
		gint _tmp50_;
		gint closure_index;
		GString* _tmp51_;
		gint _tmp52_;
		ValaDataType* _tmp53_;
		gboolean _tmp54_;
		gboolean _tmp55_;
		ValaDelegateType* _tmp58_;
		gboolean _tmp59_;
		gboolean _tmp60_;
		_tmp41_ = is_parameter;
		if (_tmp41_) {
			gint _tmp42_;
			_tmp42_ = *index;
			_tmp40_ = _tmp42_ + 1;
		} else {
			gint _tmp43_ = 0;
			ValaDataType* _tmp44_;
			gboolean _tmp45_;
			gboolean _tmp46_;
			gint _tmp49_;
			_tmp44_ = type;
			_tmp45_ = vala_data_type_get_value_owned (_tmp44_);
			_tmp46_ = _tmp45_;
			if (_tmp46_) {
				gint _tmp47_;
				_tmp47_ = *index;
				_tmp43_ = _tmp47_ - 1;
			} else {
				gint _tmp48_;
				_tmp48_ = *index;
				_tmp43_ = _tmp48_;
			}
			_tmp49_ = _tmp43_;
			_tmp40_ = _tmp49_;
		}
		_tmp50_ = _tmp40_;
		closure_index = _tmp50_;
		_tmp51_ = self->priv->buffer;
		_tmp52_ = closure_index;
		g_string_append_printf (_tmp51_, " closure=\"%i\"", _tmp52_);
		_tmp53_ = type;
		_tmp54_ = vala_data_type_get_value_owned (_tmp53_);
		_tmp55_ = _tmp54_;
		if (_tmp55_) {
			GString* _tmp56_;
			gint _tmp57_;
			_tmp56_ = self->priv->buffer;
			_tmp57_ = closure_index;
			g_string_append_printf (_tmp56_, " destroy=\"%i\"", _tmp57_ + 1);
		}
		_tmp58_ = delegate_type;
		_tmp59_ = vala_delegate_type_get_is_called_once (_tmp58_);
		_tmp60_ = _tmp59_;
		if (_tmp60_) {
			GString* _tmp61_;
			_tmp61_ = self->priv->buffer;
			g_string_append (_tmp61_, " scope=\"async\"");
		}
	}
	_tmp62_ = self->priv->buffer;
	g_string_append_printf (_tmp62_, ">\n");
	_tmp63_ = self->priv->indent;
	self->priv->indent = _tmp63_ + 1;
	length_param_index = -1;
	_tmp64_ = has_array_length;
	if (_tmp64_) {
		gint _tmp65_ = 0;
		gboolean _tmp66_;
		gint _tmp69_;
		_tmp66_ = is_parameter;
		if (_tmp66_) {
			gint _tmp67_;
			_tmp67_ = *index;
			_tmp65_ = _tmp67_ + 1;
		} else {
			gint _tmp68_;
			_tmp68_ = *index;
			_tmp65_ = _tmp68_;
		}
		_tmp69_ = _tmp65_;
		length_param_index = _tmp69_;
	}
	_tmp70_ = type;
	_tmp71_ = length_param_index;
	vala_gir_writer_write_type (self, _tmp70_, _tmp71_);
	_tmp72_ = self->priv->indent;
	self->priv->indent = _tmp72_ - 1;
	vala_gir_writer_write_indent (self);
	_tmp73_ = self->priv->buffer;
	_tmp74_ = tag;
	g_string_append_printf (_tmp73_, "</%s>\n", _tmp74_);
	_tmp75_ = *index;
	*index = _tmp75_ + 1;
	_vala_code_node_unref0 (delegate_type);
	_g_free0 (tag);
}


static void vala_gir_writer_write_ctype_attributes (ValaGIRWriter* self, ValaTypeSymbol* symbol, const gchar* suffix) {
	GString* _tmp0_;
	ValaTypeSymbol* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (symbol != NULL);
	g_return_if_fail (suffix != NULL);
	_tmp0_ = self->priv->buffer;
	_tmp1_ = symbol;
	_tmp2_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = suffix;
	g_string_append_printf (_tmp0_, " c:type=\"%s%s\"", _tmp3_, _tmp4_);
	_g_free0 (_tmp3_);
}


static void vala_gir_writer_write_gtype_attributes (ValaGIRWriter* self, ValaTypeSymbol* symbol) {
	ValaTypeSymbol* _tmp0_;
	GString* _tmp1_;
	ValaTypeSymbol* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	GString* _tmp5_;
	ValaTypeSymbol* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (symbol != NULL);
	_tmp0_ = symbol;
	vala_gir_writer_write_ctype_attributes (self, _tmp0_, "");
	_tmp1_ = self->priv->buffer;
	_tmp2_ = symbol;
	_tmp3_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp2_);
	_tmp4_ = _tmp3_;
	g_string_append_printf (_tmp1_, " glib:type-name=\"%s\"", _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = self->priv->buffer;
	_tmp6_ = symbol;
	_tmp7_ = vala_ccode_base_module_get_ccode_lower_case_prefix ((ValaSymbol*) _tmp6_);
	_tmp8_ = _tmp7_;
	g_string_append_printf (_tmp5_, " glib:get-type=\"%sget_type\"", _tmp8_);
	_g_free0 (_tmp8_);
}


static void vala_gir_writer_write_type (ValaGIRWriter* self, ValaDataType* type, gint index) {
	ValaDataType* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	_tmp0_ = type;
	if (VALA_IS_ARRAY_TYPE (_tmp0_)) {
		ValaDataType* _tmp1_;
		ValaArrayType* _tmp2_;
		ValaArrayType* array_type;
		GString* _tmp3_;
		ValaArrayType* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		GString* _tmp14_;
		gint _tmp15_;
		ValaArrayType* _tmp16_;
		ValaDataType* _tmp17_;
		ValaDataType* _tmp18_;
		gint _tmp19_;
		GString* _tmp20_;
		_tmp1_ = type;
		_tmp2_ = _vala_code_node_ref0 (VALA_ARRAY_TYPE (_tmp1_));
		array_type = _tmp2_;
		vala_gir_writer_write_indent (self);
		_tmp3_ = self->priv->buffer;
		g_string_append_printf (_tmp3_, "<array");
		_tmp4_ = array_type;
		_tmp5_ = vala_array_type_get_fixed_length (_tmp4_);
		_tmp6_ = _tmp5_;
		if (_tmp6_) {
			GString* _tmp7_;
			ValaArrayType* _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			_tmp7_ = self->priv->buffer;
			_tmp8_ = array_type;
			_tmp9_ = vala_array_type_get_length (_tmp8_);
			_tmp10_ = _tmp9_;
			g_string_append_printf (_tmp7_, " fixed-size=\"%i\"", _tmp10_);
		} else {
			gint _tmp11_;
			_tmp11_ = index;
			if (_tmp11_ != (-1)) {
				GString* _tmp12_;
				gint _tmp13_;
				_tmp12_ = self->priv->buffer;
				_tmp13_ = index;
				g_string_append_printf (_tmp12_, " length=\"%i\"", _tmp13_);
			}
		}
		_tmp14_ = self->priv->buffer;
		g_string_append_printf (_tmp14_, ">\n");
		_tmp15_ = self->priv->indent;
		self->priv->indent = _tmp15_ + 1;
		_tmp16_ = array_type;
		_tmp17_ = vala_array_type_get_element_type (_tmp16_);
		_tmp18_ = _tmp17_;
		vala_gir_writer_write_type (self, _tmp18_, -1);
		_tmp19_ = self->priv->indent;
		self->priv->indent = _tmp19_ - 1;
		vala_gir_writer_write_indent (self);
		_tmp20_ = self->priv->buffer;
		g_string_append_printf (_tmp20_, "</array>\n");
		_vala_code_node_unref0 (array_type);
	} else {
		ValaDataType* _tmp21_;
		_tmp21_ = type;
		if (VALA_IS_VOID_TYPE (_tmp21_)) {
			GString* _tmp22_;
			vala_gir_writer_write_indent (self);
			_tmp22_ = self->priv->buffer;
			g_string_append_printf (_tmp22_, "<type name=\"none\"/>\n");
		} else {
			ValaDataType* _tmp23_;
			_tmp23_ = type;
			if (VALA_IS_POINTER_TYPE (_tmp23_)) {
				GString* _tmp24_;
				ValaDataType* _tmp25_;
				gchar* _tmp26_ = NULL;
				gchar* _tmp27_;
				vala_gir_writer_write_indent (self);
				_tmp24_ = self->priv->buffer;
				_tmp25_ = type;
				_tmp26_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp25_);
				_tmp27_ = _tmp26_;
				g_string_append_printf (_tmp24_, "<type name=\"gpointer\" c:type=\"%s\"/>\n", _tmp27_);
				_g_free0 (_tmp27_);
			} else {
				ValaDataType* _tmp28_;
				ValaTypeSymbol* _tmp29_;
				ValaTypeSymbol* _tmp30_;
				_tmp28_ = type;
				_tmp29_ = vala_data_type_get_data_type (_tmp28_);
				_tmp30_ = _tmp29_;
				if (_tmp30_ != NULL) {
					GString* _tmp31_;
					ValaDataType* _tmp32_;
					ValaTypeSymbol* _tmp33_;
					ValaTypeSymbol* _tmp34_;
					gchar* _tmp35_ = NULL;
					gchar* _tmp36_;
					ValaDataType* _tmp37_;
					gchar* _tmp38_ = NULL;
					gchar* _tmp39_;
					ValaDataType* _tmp40_;
					ValaList* _tmp41_ = NULL;
					ValaList* type_arguments;
					ValaList* _tmp42_;
					gint _tmp43_;
					gint _tmp44_;
					vala_gir_writer_write_indent (self);
					_tmp31_ = self->priv->buffer;
					_tmp32_ = type;
					_tmp33_ = vala_data_type_get_data_type (_tmp32_);
					_tmp34_ = _tmp33_;
					_tmp35_ = vala_gir_writer_gi_type_name (self, _tmp34_);
					_tmp36_ = _tmp35_;
					_tmp37_ = type;
					_tmp38_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp37_);
					_tmp39_ = _tmp38_;
					g_string_append_printf (_tmp31_, "<type name=\"%s\" c:type=\"%s\"", _tmp36_, _tmp39_);
					_g_free0 (_tmp39_);
					_g_free0 (_tmp36_);
					_tmp40_ = type;
					_tmp41_ = vala_data_type_get_type_arguments (_tmp40_);
					type_arguments = _tmp41_;
					_tmp42_ = type_arguments;
					_tmp43_ = vala_collection_get_size ((ValaCollection*) _tmp42_);
					_tmp44_ = _tmp43_;
					if (_tmp44_ == 0) {
						GString* _tmp45_;
						_tmp45_ = self->priv->buffer;
						g_string_append_printf (_tmp45_, "/>\n");
					} else {
						GString* _tmp46_;
						gint _tmp47_;
						gint _tmp60_;
						GString* _tmp61_;
						_tmp46_ = self->priv->buffer;
						g_string_append_printf (_tmp46_, ">\n");
						_tmp47_ = self->priv->indent;
						self->priv->indent = _tmp47_ + 1;
						{
							ValaList* _tmp48_;
							ValaList* _tmp49_;
							ValaList* _type_argument_list;
							ValaList* _tmp50_;
							gint _tmp51_;
							gint _tmp52_;
							gint _type_argument_size;
							gint _type_argument_index;
							_tmp48_ = type_arguments;
							_tmp49_ = _vala_iterable_ref0 (_tmp48_);
							_type_argument_list = _tmp49_;
							_tmp50_ = _type_argument_list;
							_tmp51_ = vala_collection_get_size ((ValaCollection*) _tmp50_);
							_tmp52_ = _tmp51_;
							_type_argument_size = _tmp52_;
							_type_argument_index = -1;
							while (TRUE) {
								gint _tmp53_;
								gint _tmp54_;
								gint _tmp55_;
								ValaList* _tmp56_;
								gint _tmp57_;
								gpointer _tmp58_ = NULL;
								ValaDataType* type_argument;
								ValaDataType* _tmp59_;
								_tmp53_ = _type_argument_index;
								_type_argument_index = _tmp53_ + 1;
								_tmp54_ = _type_argument_index;
								_tmp55_ = _type_argument_size;
								if (!(_tmp54_ < _tmp55_)) {
									break;
								}
								_tmp56_ = _type_argument_list;
								_tmp57_ = _type_argument_index;
								_tmp58_ = vala_list_get (_tmp56_, _tmp57_);
								type_argument = (ValaDataType*) _tmp58_;
								_tmp59_ = type_argument;
								vala_gir_writer_write_type (self, _tmp59_, -1);
								_vala_code_node_unref0 (type_argument);
							}
							_vala_iterable_unref0 (_type_argument_list);
						}
						_tmp60_ = self->priv->indent;
						self->priv->indent = _tmp60_ - 1;
						vala_gir_writer_write_indent (self);
						_tmp61_ = self->priv->buffer;
						g_string_append_printf (_tmp61_, "</type>\n");
					}
					_vala_iterable_unref0 (type_arguments);
				} else {
					ValaDataType* _tmp62_;
					_tmp62_ = type;
					if (VALA_IS_DELEGATE_TYPE (_tmp62_)) {
						ValaDataType* _tmp63_;
						ValaDelegateType* _tmp64_;
						ValaDelegateType* deleg_type;
						GString* _tmp65_;
						ValaDelegateType* _tmp66_;
						ValaDelegate* _tmp67_;
						ValaDelegate* _tmp68_;
						gchar* _tmp69_ = NULL;
						gchar* _tmp70_;
						ValaDataType* _tmp71_;
						gchar* _tmp72_ = NULL;
						gchar* _tmp73_;
						_tmp63_ = type;
						_tmp64_ = _vala_code_node_ref0 (VALA_DELEGATE_TYPE (_tmp63_));
						deleg_type = _tmp64_;
						vala_gir_writer_write_indent (self);
						_tmp65_ = self->priv->buffer;
						_tmp66_ = deleg_type;
						_tmp67_ = vala_delegate_type_get_delegate_symbol (_tmp66_);
						_tmp68_ = _tmp67_;
						_tmp69_ = vala_gir_writer_gi_type_name (self, (ValaTypeSymbol*) _tmp68_);
						_tmp70_ = _tmp69_;
						_tmp71_ = type;
						_tmp72_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp71_);
						_tmp73_ = _tmp72_;
						g_string_append_printf (_tmp65_, "<type name=\"%s\" c:type=\"%s\"/>\n", _tmp70_, _tmp73_);
						_g_free0 (_tmp73_);
						_g_free0 (_tmp70_);
						_vala_code_node_unref0 (deleg_type);
					} else {
						ValaDataType* _tmp74_;
						_tmp74_ = type;
						if (VALA_IS_GENERIC_TYPE (_tmp74_)) {
							GString* _tmp75_;
							vala_gir_writer_write_indent (self);
							_tmp75_ = self->priv->buffer;
							g_string_append (_tmp75_, "<type name=\"gpointer\" c:type=\"gpointer\"/>\n");
						} else {
							GString* _tmp76_;
							ValaDataType* _tmp77_;
							gchar* _tmp78_ = NULL;
							gchar* _tmp79_;
							vala_gir_writer_write_indent (self);
							_tmp76_ = self->priv->buffer;
							_tmp77_ = type;
							_tmp78_ = vala_code_node_to_string ((ValaCodeNode*) _tmp77_);
							_tmp79_ = _tmp78_;
							g_string_append_printf (_tmp76_, "<type name=\"%s\"/>\n", _tmp79_);
							_g_free0 (_tmp79_);
						}
					}
				}
			}
		}
	}
}


static void vala_gir_writer_write_annotations (ValaGIRWriter* self, ValaCodeNode* node) {
	ValaCodeNode* _tmp0_;
	GList* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node;
	_tmp1_ = _tmp0_->attributes;
	{
		GList* attr_collection = NULL;
		GList* attr_it = NULL;
		attr_collection = _tmp1_;
		for (attr_it = attr_collection; attr_it != NULL; attr_it = attr_it->next) {
			ValaAttribute* _tmp2_;
			ValaAttribute* attr = NULL;
			_tmp2_ = _vala_code_node_ref0 ((ValaAttribute*) attr_it->data);
			attr = _tmp2_;
			{
				ValaAttribute* _tmp3_;
				const gchar* _tmp4_;
				const gchar* _tmp5_;
				gchar* _tmp6_ = NULL;
				gchar* name;
				_tmp3_ = attr;
				_tmp4_ = vala_attribute_get_name (_tmp3_);
				_tmp5_ = _tmp4_;
				_tmp6_ = vala_gir_writer_camel_case_to_canonical (self, _tmp5_);
				name = _tmp6_;
				{
					ValaAttribute* _tmp7_;
					ValaMap* _tmp8_;
					ValaSet* _tmp9_ = NULL;
					ValaSet* _tmp10_;
					ValaIterator* _tmp11_ = NULL;
					ValaIterator* _tmp12_;
					ValaIterator* _arg_name_it;
					_tmp7_ = attr;
					_tmp8_ = _tmp7_->args;
					_tmp9_ = vala_map_get_keys (_tmp8_);
					_tmp10_ = _tmp9_;
					_tmp11_ = vala_iterable_iterator ((ValaIterable*) _tmp10_);
					_tmp12_ = _tmp11_;
					_vala_iterable_unref0 (_tmp10_);
					_arg_name_it = _tmp12_;
					while (TRUE) {
						ValaIterator* _tmp13_;
						gboolean _tmp14_ = FALSE;
						ValaIterator* _tmp15_;
						gpointer _tmp16_ = NULL;
						gchar* arg_name;
						ValaAttribute* _tmp17_;
						ValaMap* _tmp18_;
						const gchar* _tmp19_;
						gpointer _tmp20_ = NULL;
						gchar* value;
						const gchar* _tmp21_;
						gboolean _tmp22_ = FALSE;
						GString* _tmp26_;
						const gchar* _tmp27_;
						const gchar* _tmp28_;
						gchar* _tmp29_ = NULL;
						gchar* _tmp30_;
						const gchar* _tmp31_;
						_tmp13_ = _arg_name_it;
						_tmp14_ = vala_iterator_next (_tmp13_);
						if (!_tmp14_) {
							break;
						}
						_tmp15_ = _arg_name_it;
						_tmp16_ = vala_iterator_get (_tmp15_);
						arg_name = (gchar*) _tmp16_;
						_tmp17_ = attr;
						_tmp18_ = _tmp17_->args;
						_tmp19_ = arg_name;
						_tmp20_ = vala_map_get (_tmp18_, _tmp19_);
						value = (gchar*) _tmp20_;
						_tmp21_ = value;
						_tmp22_ = g_str_has_prefix (_tmp21_, "\"");
						if (_tmp22_) {
							ValaAttribute* _tmp23_;
							const gchar* _tmp24_;
							gchar* _tmp25_ = NULL;
							_tmp23_ = attr;
							_tmp24_ = arg_name;
							_tmp25_ = vala_attribute_get_string (_tmp23_, _tmp24_);
							_g_free0 (value);
							value = _tmp25_;
						}
						vala_gir_writer_write_indent (self);
						_tmp26_ = self->priv->buffer;
						_tmp27_ = name;
						_tmp28_ = arg_name;
						_tmp29_ = vala_gir_writer_camel_case_to_canonical (self, _tmp28_);
						_tmp30_ = _tmp29_;
						_tmp31_ = value;
						g_string_append_printf (_tmp26_, "<annotation key=\"%s.%s\" value=\"%s\"/>\n", _tmp27_, _tmp30_, _tmp31_);
						_g_free0 (_tmp30_);
						_g_free0 (value);
						_g_free0 (arg_name);
					}
					_vala_iterator_unref0 (_arg_name_it);
				}
				_g_free0 (name);
				_vala_code_node_unref0 (attr);
			}
		}
	}
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static gchar* vala_gir_writer_get_full_gir_name (ValaGIRWriter* self, ValaSymbol* sym) {
	gchar* result = NULL;
	ValaSymbol* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* gir_name;
	ValaSymbol* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaSymbol* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	ValaSymbol* _tmp20_;
	ValaSymbol* _tmp21_;
	ValaSymbol* _tmp22_;
	gchar* _tmp23_ = NULL;
	gchar* parent_gir_name;
	const gchar* _tmp24_;
	gchar* _tmp25_ = NULL;
	const gchar* _tmp26_;
	gboolean _tmp27_ = FALSE;
	const gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* self_gir_name;
	const gchar* _tmp34_;
	gboolean _tmp35_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = sym;
	_tmp1_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp0_, "GIR", "name");
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		ValaSymbol* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp4_ = sym;
		_tmp5_ = vala_symbol_get_name (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strdup (_tmp6_);
		_g_free0 (_tmp2_);
		_tmp2_ = _tmp7_;
	}
	_tmp8_ = _tmp2_;
	_tmp9_ = g_strdup (_tmp8_);
	gir_name = _tmp9_;
	_tmp10_ = sym;
	_tmp11_ = vala_symbol_get_parent_symbol (_tmp10_);
	_tmp12_ = _tmp11_;
	if (_tmp12_ == NULL) {
		result = gir_name;
		_g_free0 (_tmp2_);
		return result;
	}
	_tmp13_ = sym;
	_tmp14_ = vala_symbol_get_name (_tmp13_);
	_tmp15_ = _tmp14_;
	if (_tmp15_ == NULL) {
		ValaSymbol* _tmp16_;
		ValaSymbol* _tmp17_;
		ValaSymbol* _tmp18_;
		gchar* _tmp19_ = NULL;
		_tmp16_ = sym;
		_tmp17_ = vala_symbol_get_parent_symbol (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_gir_writer_get_full_gir_name (self, _tmp18_);
		result = _tmp19_;
		_g_free0 (gir_name);
		_g_free0 (_tmp2_);
		return result;
	}
	_tmp20_ = sym;
	_tmp21_ = vala_symbol_get_parent_symbol (_tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = vala_gir_writer_get_full_gir_name (self, _tmp22_);
	parent_gir_name = _tmp23_;
	_tmp24_ = parent_gir_name;
	if (_tmp24_ == NULL) {
		result = gir_name;
		_g_free0 (parent_gir_name);
		_g_free0 (_tmp2_);
		return result;
	}
	_tmp26_ = gir_name;
	_tmp27_ = g_str_has_prefix (_tmp26_, ".");
	if (_tmp27_) {
		const gchar* _tmp28_;
		gchar* _tmp29_ = NULL;
		_tmp28_ = gir_name;
		_tmp29_ = string_substring (_tmp28_, (glong) 1, (glong) (-1));
		_g_free0 (_tmp25_);
		_tmp25_ = _tmp29_;
	} else {
		const gchar* _tmp30_;
		gchar* _tmp31_;
		_tmp30_ = gir_name;
		_tmp31_ = g_strdup (_tmp30_);
		_g_free0 (_tmp25_);
		_tmp25_ = _tmp31_;
	}
	_tmp32_ = _tmp25_;
	_tmp33_ = g_strdup (_tmp32_);
	self_gir_name = _tmp33_;
	_tmp34_ = parent_gir_name;
	_tmp35_ = string_contains (_tmp34_, ".");
	if (_tmp35_) {
		const gchar* _tmp36_;
		const gchar* _tmp37_;
		gchar* _tmp38_ = NULL;
		_tmp36_ = parent_gir_name;
		_tmp37_ = self_gir_name;
		_tmp38_ = g_strdup_printf ("%s%s", _tmp36_, _tmp37_);
		result = _tmp38_;
		_g_free0 (self_gir_name);
		_g_free0 (_tmp25_);
		_g_free0 (parent_gir_name);
		_g_free0 (gir_name);
		_g_free0 (_tmp2_);
		return result;
	} else {
		const gchar* _tmp39_;
		const gchar* _tmp40_;
		gchar* _tmp41_ = NULL;
		_tmp39_ = parent_gir_name;
		_tmp40_ = self_gir_name;
		_tmp41_ = g_strdup_printf ("%s.%s", _tmp39_, _tmp40_);
		result = _tmp41_;
		_g_free0 (self_gir_name);
		_g_free0 (_tmp25_);
		_g_free0 (parent_gir_name);
		_g_free0 (gir_name);
		_g_free0 (_tmp2_);
		return result;
	}
	_g_free0 (self_gir_name);
	_g_free0 (_tmp25_);
	_g_free0 (parent_gir_name);
	_g_free0 (gir_name);
	_g_free0 (_tmp2_);
}


static gchar* vala_gir_writer_gi_type_name (ValaGIRWriter* self, ValaTypeSymbol* type_symbol) {
	gchar* result = NULL;
	ValaTypeSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp3_;
	ValaSymbol* parent;
	ValaSymbol* _tmp4_;
	ValaTypeSymbol* _tmp65_;
	gchar* _tmp66_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type_symbol != NULL, NULL);
	_tmp0_ = type_symbol;
	_tmp1_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _vala_code_node_ref0 (_tmp2_);
	parent = _tmp3_;
	_tmp4_ = parent;
	if (VALA_IS_NAMESPACE (_tmp4_)) {
		ValaSymbol* _tmp5_;
		ValaNamespace* _tmp6_;
		ValaNamespace* ns;
		ValaNamespace* _tmp7_;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* ns_gir_name;
		const gchar* _tmp17_;
		_tmp5_ = parent;
		_tmp6_ = _vala_code_node_ref0 (VALA_IS_NAMESPACE (_tmp5_) ? ((ValaNamespace*) _tmp5_) : NULL);
		ns = _tmp6_;
		_tmp7_ = ns;
		_tmp8_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp7_, "GIR", "name");
		_tmp9_ = _tmp8_;
		_tmp10_ = _tmp9_;
		if (_tmp10_ == NULL) {
			ValaNamespace* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			gchar* _tmp14_;
			_tmp11_ = ns;
			_tmp12_ = vala_symbol_get_name ((ValaSymbol*) _tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = g_strdup (_tmp13_);
			_g_free0 (_tmp9_);
			_tmp9_ = _tmp14_;
		}
		_tmp15_ = _tmp9_;
		_tmp16_ = g_strdup (_tmp15_);
		ns_gir_name = _tmp16_;
		_tmp17_ = ns_gir_name;
		if (_tmp17_ != NULL) {
			ValaTypeSymbol* _tmp18_;
			ValaSourceReference* _tmp19_;
			ValaSourceReference* _tmp20_;
			ValaSourceFile* _tmp21_;
			ValaSourceFile* _tmp22_;
			const gchar* _tmp23_;
			const gchar* _tmp24_;
			_tmp18_ = type_symbol;
			_tmp19_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_source_reference_get_file (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = vala_source_file_get_gir_namespace (_tmp22_);
			_tmp24_ = _tmp23_;
			if (_tmp24_ != NULL) {
				ValaTypeSymbol* _tmp25_;
				ValaSourceReference* _tmp26_;
				ValaSourceReference* _tmp27_;
				ValaSourceFile* _tmp28_;
				ValaSourceFile* _tmp29_;
				const gchar* _tmp30_;
				const gchar* _tmp31_;
				ValaTypeSymbol* _tmp32_;
				ValaSourceReference* _tmp33_;
				ValaSourceReference* _tmp34_;
				ValaSourceFile* _tmp35_;
				ValaSourceFile* _tmp36_;
				const gchar* _tmp37_;
				const gchar* _tmp38_;
				ValaGIRWriterGIRNamespace external = {0};
				ValaArrayList* _tmp39_;
				ValaGIRWriterGIRNamespace _tmp40_;
				gboolean _tmp41_ = FALSE;
				ValaTypeSymbol* _tmp44_;
				gchar* _tmp45_ = NULL;
				gchar* _tmp46_;
				const gchar* _tmp47_;
				const gchar* _tmp52_;
				gchar* _tmp53_;
				gchar* type_name;
				ValaTypeSymbol* _tmp54_;
				ValaSourceReference* _tmp55_;
				ValaSourceReference* _tmp56_;
				ValaSourceFile* _tmp57_;
				ValaSourceFile* _tmp58_;
				const gchar* _tmp59_;
				const gchar* _tmp60_;
				const gchar* _tmp61_;
				gchar* _tmp62_ = NULL;
				_tmp25_ = type_symbol;
				_tmp26_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = vala_source_reference_get_file (_tmp27_);
				_tmp29_ = _tmp28_;
				_tmp30_ = vala_source_file_get_gir_namespace (_tmp29_);
				_tmp31_ = _tmp30_;
				_tmp32_ = type_symbol;
				_tmp33_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp32_);
				_tmp34_ = _tmp33_;
				_tmp35_ = vala_source_reference_get_file (_tmp34_);
				_tmp36_ = _tmp35_;
				_tmp37_ = vala_source_file_get_gir_version (_tmp36_);
				_tmp38_ = _tmp37_;
				vala_gir_writer_gir_namespace_init (&external, _tmp31_, _tmp38_);
				_tmp39_ = self->priv->externals;
				_tmp40_ = external;
				_tmp41_ = vala_collection_contains ((ValaCollection*) _tmp39_, &_tmp40_);
				if (!_tmp41_) {
					ValaArrayList* _tmp42_;
					ValaGIRWriterGIRNamespace _tmp43_;
					_tmp42_ = self->priv->externals;
					_tmp43_ = external;
					vala_collection_add ((ValaCollection*) _tmp42_, &_tmp43_);
				}
				_tmp44_ = type_symbol;
				_tmp45_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp44_, "GIR", "name");
				_tmp46_ = _tmp45_;
				_tmp47_ = _tmp46_;
				if (_tmp47_ == NULL) {
					ValaTypeSymbol* _tmp48_;
					const gchar* _tmp49_;
					const gchar* _tmp50_;
					gchar* _tmp51_;
					_tmp48_ = type_symbol;
					_tmp49_ = vala_symbol_get_name ((ValaSymbol*) _tmp48_);
					_tmp50_ = _tmp49_;
					_tmp51_ = g_strdup (_tmp50_);
					_g_free0 (_tmp46_);
					_tmp46_ = _tmp51_;
				}
				_tmp52_ = _tmp46_;
				_tmp53_ = g_strdup (_tmp52_);
				type_name = _tmp53_;
				_tmp54_ = type_symbol;
				_tmp55_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp54_);
				_tmp56_ = _tmp55_;
				_tmp57_ = vala_source_reference_get_file (_tmp56_);
				_tmp58_ = _tmp57_;
				_tmp59_ = vala_source_file_get_gir_namespace (_tmp58_);
				_tmp60_ = _tmp59_;
				_tmp61_ = type_name;
				_tmp62_ = g_strdup_printf ("%s.%s", _tmp60_, _tmp61_);
				result = _tmp62_;
				_g_free0 (type_name);
				_g_free0 (_tmp46_);
				vala_gir_writer_gir_namespace_destroy (&external);
				_g_free0 (ns_gir_name);
				_g_free0 (_tmp9_);
				_vala_code_node_unref0 (ns);
				_vala_code_node_unref0 (parent);
				return result;
			} else {
				ValaHashSet* _tmp63_;
				ValaNamespace* _tmp64_;
				_tmp63_ = self->priv->unannotated_namespaces;
				_tmp64_ = ns;
				vala_collection_add ((ValaCollection*) _tmp63_, _tmp64_);
			}
		}
		_g_free0 (ns_gir_name);
		_g_free0 (_tmp9_);
		_vala_code_node_unref0 (ns);
	}
	_tmp65_ = type_symbol;
	_tmp66_ = vala_gir_writer_get_full_gir_name (self, (ValaSymbol*) _tmp65_);
	result = _tmp66_;
	_vala_code_node_unref0 (parent);
	return result;
}


static gchar* vala_gir_writer_literal_expression_to_value_string (ValaGIRWriter* self, ValaExpression* literal) {
	gchar* result = NULL;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (literal != NULL, NULL);
	_tmp0_ = literal;
	if (VALA_IS_STRING_LITERAL (_tmp0_)) {
		ValaExpression* _tmp1_;
		ValaStringLiteral* _tmp2_;
		ValaStringLiteral* lit;
		ValaStringLiteral* _tmp3_;
		_tmp1_ = literal;
		_tmp2_ = _vala_code_node_ref0 (VALA_IS_STRING_LITERAL (_tmp1_) ? ((ValaStringLiteral*) _tmp1_) : NULL);
		lit = _tmp2_;
		_tmp3_ = lit;
		if (_tmp3_ != NULL) {
			ValaStringLiteral* _tmp4_;
			gchar* _tmp5_ = NULL;
			gchar* _tmp6_;
			gchar* _tmp7_ = NULL;
			gchar* _tmp8_;
			_tmp4_ = lit;
			_tmp5_ = vala_string_literal_eval (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = g_markup_escape_text (_tmp6_, (gssize) (-1));
			_tmp8_ = _tmp7_;
			_g_free0 (_tmp6_);
			result = _tmp8_;
			_vala_code_node_unref0 (lit);
			return result;
		}
		_vala_code_node_unref0 (lit);
	} else {
		ValaExpression* _tmp9_;
		_tmp9_ = literal;
		if (VALA_IS_CHARACTER_LITERAL (_tmp9_)) {
			ValaExpression* _tmp10_;
			gunichar _tmp11_ = 0U;
			gchar* _tmp12_ = NULL;
			_tmp10_ = literal;
			_tmp11_ = vala_character_literal_get_char (VALA_CHARACTER_LITERAL (_tmp10_));
			_tmp12_ = g_strdup_printf ("%c", (gint) ((gchar) _tmp11_));
			result = _tmp12_;
			return result;
		} else {
			ValaExpression* _tmp13_;
			_tmp13_ = literal;
			if (VALA_IS_BOOLEAN_LITERAL (_tmp13_)) {
				const gchar* _tmp14_ = NULL;
				ValaExpression* _tmp15_;
				gboolean _tmp16_;
				gboolean _tmp17_;
				const gchar* _tmp18_;
				gchar* _tmp19_;
				_tmp15_ = literal;
				_tmp16_ = vala_boolean_literal_get_value (VALA_BOOLEAN_LITERAL (_tmp15_));
				_tmp17_ = _tmp16_;
				if (_tmp17_) {
					_tmp14_ = "true";
				} else {
					_tmp14_ = "false";
				}
				_tmp18_ = _tmp14_;
				_tmp19_ = g_strdup (_tmp18_);
				result = _tmp19_;
				return result;
			} else {
				ValaExpression* _tmp20_;
				_tmp20_ = literal;
				if (VALA_IS_REAL_LITERAL (_tmp20_)) {
					ValaExpression* _tmp21_;
					const gchar* _tmp22_;
					const gchar* _tmp23_;
					gchar* _tmp24_;
					_tmp21_ = literal;
					_tmp22_ = vala_real_literal_get_value (VALA_REAL_LITERAL (_tmp21_));
					_tmp23_ = _tmp22_;
					_tmp24_ = g_strdup (_tmp23_);
					result = _tmp24_;
					return result;
				} else {
					ValaExpression* _tmp25_;
					_tmp25_ = literal;
					if (VALA_IS_INTEGER_LITERAL (_tmp25_)) {
						ValaExpression* _tmp26_;
						const gchar* _tmp27_;
						const gchar* _tmp28_;
						gchar* _tmp29_;
						_tmp26_ = literal;
						_tmp27_ = vala_integer_literal_get_value (VALA_INTEGER_LITERAL (_tmp26_));
						_tmp28_ = _tmp27_;
						_tmp29_ = g_strdup (_tmp28_);
						result = _tmp29_;
						return result;
					} else {
						ValaExpression* _tmp30_;
						_tmp30_ = literal;
						if (VALA_IS_UNARY_EXPRESSION (_tmp30_)) {
							ValaExpression* _tmp31_;
							ValaUnaryExpression* _tmp32_;
							ValaUnaryExpression* unary;
							ValaUnaryExpression* _tmp33_;
							ValaUnaryOperator _tmp34_;
							ValaUnaryOperator _tmp35_;
							_tmp31_ = literal;
							_tmp32_ = _vala_code_node_ref0 (VALA_UNARY_EXPRESSION (_tmp31_));
							unary = _tmp32_;
							_tmp33_ = unary;
							_tmp34_ = vala_unary_expression_get_operator (_tmp33_);
							_tmp35_ = _tmp34_;
							if (_tmp35_ == VALA_UNARY_OPERATOR_MINUS) {
								ValaUnaryExpression* _tmp36_;
								ValaExpression* _tmp37_;
								ValaExpression* _tmp38_;
								_tmp36_ = unary;
								_tmp37_ = vala_unary_expression_get_inner (_tmp36_);
								_tmp38_ = _tmp37_;
								if (VALA_IS_REAL_LITERAL (_tmp38_)) {
									ValaUnaryExpression* _tmp39_;
									ValaExpression* _tmp40_;
									ValaExpression* _tmp41_;
									const gchar* _tmp42_;
									const gchar* _tmp43_;
									gchar* _tmp44_;
									_tmp39_ = unary;
									_tmp40_ = vala_unary_expression_get_inner (_tmp39_);
									_tmp41_ = _tmp40_;
									_tmp42_ = vala_real_literal_get_value (VALA_REAL_LITERAL (_tmp41_));
									_tmp43_ = _tmp42_;
									_tmp44_ = g_strconcat ("-", _tmp43_, NULL);
									result = _tmp44_;
									_vala_code_node_unref0 (unary);
									return result;
								} else {
									ValaUnaryExpression* _tmp45_;
									ValaExpression* _tmp46_;
									ValaExpression* _tmp47_;
									_tmp45_ = unary;
									_tmp46_ = vala_unary_expression_get_inner (_tmp45_);
									_tmp47_ = _tmp46_;
									if (VALA_IS_INTEGER_LITERAL (_tmp47_)) {
										ValaUnaryExpression* _tmp48_;
										ValaExpression* _tmp49_;
										ValaExpression* _tmp50_;
										const gchar* _tmp51_;
										const gchar* _tmp52_;
										gchar* _tmp53_;
										_tmp48_ = unary;
										_tmp49_ = vala_unary_expression_get_inner (_tmp48_);
										_tmp50_ = _tmp49_;
										_tmp51_ = vala_integer_literal_get_value (VALA_INTEGER_LITERAL (_tmp50_));
										_tmp52_ = _tmp51_;
										_tmp53_ = g_strconcat ("-", _tmp52_, NULL);
										result = _tmp53_;
										_vala_code_node_unref0 (unary);
										return result;
									}
								}
							}
							_vala_code_node_unref0 (unary);
						}
					}
				}
			}
		}
	}
	result = NULL;
	return result;
}


static gchar* vala_gir_writer_camel_case_to_canonical (ValaGIRWriter* self, const gchar* name) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_ = NULL;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar** parts;
	gint parts_length1;
	gint _parts_size_;
	gchar* _tmp6_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = name;
	_tmp1_ = vala_symbol_camel_case_to_lower_case (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, "_", 0);
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _vala_array_length (_tmp3_);
	_g_free0 (_tmp2_);
	parts = _tmp5_;
	parts_length1 = _tmp5__length1;
	_parts_size_ = parts_length1;
	_tmp6_ = g_strjoinv ("-", parts);
	result = _tmp6_;
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static gboolean vala_gir_writer_check_accessibility (ValaGIRWriter* self, ValaSymbol* sym) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaSymbol* _tmp1_;
	ValaSymbolAccessibility _tmp2_;
	ValaSymbolAccessibility _tmp3_;
	gboolean _tmp7_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp1_ = sym;
	_tmp2_ = vala_symbol_get_access (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
		_tmp0_ = TRUE;
	} else {
		ValaSymbol* _tmp4_;
		ValaSymbolAccessibility _tmp5_;
		ValaSymbolAccessibility _tmp6_;
		_tmp4_ = sym;
		_tmp5_ = vala_symbol_get_access (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED;
	}
	_tmp7_ = _tmp0_;
	if (_tmp7_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


ValaGIRWriter* vala_gir_writer_construct (GType object_type) {
	ValaGIRWriter* self = NULL;
	self = (ValaGIRWriter*) vala_code_visitor_construct (object_type);
	return self;
}


ValaGIRWriter* vala_gir_writer_new (void) {
	return vala_gir_writer_construct (VALA_TYPE_GIR_WRITER);
}


static void vala_gir_writer_gir_namespace_init (ValaGIRWriterGIRNamespace *self, const gchar* ns, const gchar* version) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (ns != NULL);
	g_return_if_fail (version != NULL);
	memset (self, 0, sizeof (ValaGIRWriterGIRNamespace));
	_tmp0_ = ns;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*self).ns);
	(*self).ns = _tmp1_;
	_tmp2_ = version;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*self).version);
	(*self).version = _tmp3_;
}


static gboolean vala_gir_writer_gir_namespace_equal (ValaGIRWriterGIRNamespace *self, ValaGIRWriterGIRNamespace* g) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	ValaGIRWriterGIRNamespace _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp7_;
	g_return_val_if_fail (g != NULL, FALSE);
	_tmp1_ = (*self).ns;
	_tmp2_ = *g;
	_tmp3_ = _tmp2_.ns;
	if (g_strcmp0 (_tmp1_, _tmp3_) == 0) {
		const gchar* _tmp4_;
		ValaGIRWriterGIRNamespace _tmp5_;
		const gchar* _tmp6_;
		_tmp4_ = (*self).version;
		_tmp5_ = *g;
		_tmp6_ = _tmp5_.version;
		_tmp0_ = g_strcmp0 (_tmp4_, _tmp6_) == 0;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp7_ = _tmp0_;
	result = _tmp7_;
	return result;
}


static void vala_gir_writer_gir_namespace_copy (const ValaGIRWriterGIRNamespace* self, ValaGIRWriterGIRNamespace* dest) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	_tmp0_ = (*self).ns;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).ns);
	(*dest).ns = _tmp1_;
	_tmp2_ = (*self).version;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).version);
	(*dest).version = _tmp3_;
}


static void vala_gir_writer_gir_namespace_destroy (ValaGIRWriterGIRNamespace* self) {
	_g_free0 ((*self).ns);
	_g_free0 ((*self).version);
}


static ValaGIRWriterGIRNamespace* vala_gir_writer_gir_namespace_dup (const ValaGIRWriterGIRNamespace* self) {
	ValaGIRWriterGIRNamespace* dup;
	dup = g_new0 (ValaGIRWriterGIRNamespace, 1);
	vala_gir_writer_gir_namespace_copy (self, dup);
	return dup;
}


static void vala_gir_writer_gir_namespace_free (ValaGIRWriterGIRNamespace* self) {
	vala_gir_writer_gir_namespace_destroy (self);
	g_free (self);
}


static GType vala_gir_writer_gir_namespace_get_type (void) {
	static volatile gsize vala_gir_writer_gir_namespace_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gir_writer_gir_namespace_type_id__volatile)) {
		GType vala_gir_writer_gir_namespace_type_id;
		vala_gir_writer_gir_namespace_type_id = g_boxed_type_register_static ("ValaGIRWriterGIRNamespace", (GBoxedCopyFunc) vala_gir_writer_gir_namespace_dup, (GBoxedFreeFunc) vala_gir_writer_gir_namespace_free);
		g_once_init_leave (&vala_gir_writer_gir_namespace_type_id__volatile, vala_gir_writer_gir_namespace_type_id);
	}
	return vala_gir_writer_gir_namespace_type_id__volatile;
}


static void vala_gir_writer_class_init (ValaGIRWriterClass * klass) {
	vala_gir_writer_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_VISITOR_CLASS (klass)->finalize = vala_gir_writer_finalize;
	g_type_class_add_private (klass, sizeof (ValaGIRWriterPrivate));
	VALA_CODE_VISITOR_CLASS (klass)->visit_namespace = vala_gir_writer_real_visit_namespace;
	VALA_CODE_VISITOR_CLASS (klass)->visit_class = vala_gir_writer_real_visit_class;
	VALA_CODE_VISITOR_CLASS (klass)->visit_struct = vala_gir_writer_real_visit_struct;
	VALA_CODE_VISITOR_CLASS (klass)->visit_interface = vala_gir_writer_real_visit_interface;
	VALA_CODE_VISITOR_CLASS (klass)->visit_enum = vala_gir_writer_real_visit_enum;
	VALA_CODE_VISITOR_CLASS (klass)->visit_enum_value = vala_gir_writer_real_visit_enum_value;
	VALA_CODE_VISITOR_CLASS (klass)->visit_error_domain = vala_gir_writer_real_visit_error_domain;
	VALA_CODE_VISITOR_CLASS (klass)->visit_error_code = vala_gir_writer_real_visit_error_code;
	VALA_CODE_VISITOR_CLASS (klass)->visit_constant = vala_gir_writer_real_visit_constant;
	VALA_CODE_VISITOR_CLASS (klass)->visit_field = vala_gir_writer_real_visit_field;
	VALA_CODE_VISITOR_CLASS (klass)->visit_delegate = vala_gir_writer_real_visit_delegate;
	VALA_CODE_VISITOR_CLASS (klass)->visit_method = vala_gir_writer_real_visit_method;
	VALA_CODE_VISITOR_CLASS (klass)->visit_creation_method = vala_gir_writer_real_visit_creation_method;
	VALA_CODE_VISITOR_CLASS (klass)->visit_property = vala_gir_writer_real_visit_property;
	VALA_CODE_VISITOR_CLASS (klass)->visit_signal = vala_gir_writer_real_visit_signal;
}


static void vala_gir_writer_instance_init (ValaGIRWriter * self) {
	GString* _tmp0_;
	GHashFunc _tmp1_;
	GEqualFunc _tmp2_;
	ValaHashSet* _tmp3_;
	GHashFunc _tmp4_;
	GEqualFunc _tmp5_;
	ValaHashSet* _tmp6_;
	GEqualFunc _tmp7_;
	ValaArrayList* _tmp8_;
	GEqualFunc _tmp9_;
	ValaArrayList* _tmp10_;
	ValaArrayList* _tmp11_;
	self->priv = VALA_GIR_WRITER_GET_PRIVATE (self);
	_tmp0_ = g_string_new ("");
	self->priv->buffer = _tmp0_;
	_tmp1_ = g_direct_hash;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_hash_set_new (VALA_TYPE_NAMESPACE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, _tmp1_, _tmp2_);
	self->priv->unannotated_namespaces = _tmp3_;
	_tmp4_ = g_direct_hash;
	_tmp5_ = g_direct_equal;
	_tmp6_ = vala_hash_set_new (VALA_TYPE_NAMESPACE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, _tmp4_, _tmp5_);
	self->priv->our_namespaces = _tmp6_;
	_tmp7_ = g_direct_equal;
	_tmp8_ = vala_array_list_new (VALA_TYPE_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, _tmp7_);
	self->priv->hierarchy = _tmp8_;
	_tmp9_ = g_direct_equal;
	_tmp10_ = vala_array_list_new (VALA_TYPE_CODE_NODE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, _tmp9_);
	self->priv->deferred = _tmp10_;
	_tmp11_ = vala_array_list_new (VALA_GIR_WRITER_TYPE_GIR_NAMESPACE, (GBoxedCopyFunc) vala_gir_writer_gir_namespace_dup, vala_gir_writer_gir_namespace_free, (GEqualFunc) vala_gir_writer_gir_namespace_equal);
	self->priv->externals = _tmp11_;
}


static void vala_gir_writer_finalize (ValaCodeVisitor* obj) {
	ValaGIRWriter * self;
	self = VALA_GIR_WRITER (obj);
	_vala_code_context_unref0 (self->priv->context);
	_g_free0 (self->priv->directory);
	_g_free0 (self->priv->gir_namespace);
	_g_free0 (self->priv->gir_version);
	_g_string_free0 (self->priv->buffer);
	_fclose0 (self->priv->stream);
	_vala_iterable_unref0 (self->priv->unannotated_namespaces);
	_vala_iterable_unref0 (self->priv->our_namespaces);
	_vala_iterable_unref0 (self->priv->hierarchy);
	_vala_iterable_unref0 (self->priv->deferred);
	_vala_code_node_unref0 (self->priv->gobject_type);
	_vala_iterable_unref0 (self->priv->externals);
	VALA_CODE_VISITOR_CLASS (vala_gir_writer_parent_class)->finalize (obj);
}


/**
 * Code visitor generating .gir file for the public interface.
 */
GType vala_gir_writer_get_type (void) {
	static volatile gsize vala_gir_writer_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gir_writer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaGIRWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gir_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGIRWriter), 0, (GInstanceInitFunc) vala_gir_writer_instance_init, NULL };
		GType vala_gir_writer_type_id;
		vala_gir_writer_type_id = g_type_register_static (VALA_TYPE_CODE_VISITOR, "ValaGIRWriter", &g_define_type_info, 0);
		g_once_init_leave (&vala_gir_writer_type_id__volatile, vala_gir_writer_type_id);
	}
	return vala_gir_writer_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



