/* valareturnstatement.c generated by valac, the Vala compiler
 * generated from valareturnstatement.vala, do not modify */

/* valareturnstatement.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>


#define VALA_TYPE_CODE_NODE (vala_code_node_get_type ())
#define VALA_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_NODE, ValaCodeNode))
#define VALA_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))
#define VALA_IS_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_NODE))
#define VALA_IS_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_NODE))
#define VALA_CODE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))

typedef struct _ValaCodeNode ValaCodeNode;
typedef struct _ValaCodeNodeClass ValaCodeNodeClass;
typedef struct _ValaCodeNodePrivate ValaCodeNodePrivate;

#define VALA_TYPE_CODE_VISITOR (vala_code_visitor_get_type ())
#define VALA_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitor))
#define VALA_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))
#define VALA_IS_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_VISITOR))
#define VALA_IS_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_VISITOR))
#define VALA_CODE_VISITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))

typedef struct _ValaCodeVisitor ValaCodeVisitor;
typedef struct _ValaCodeVisitorClass ValaCodeVisitorClass;

#define VALA_TYPE_CODE_CONTEXT (vala_code_context_get_type ())
#define VALA_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContext))
#define VALA_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))
#define VALA_IS_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_CONTEXT))
#define VALA_IS_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_CONTEXT))
#define VALA_CODE_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))

typedef struct _ValaCodeContext ValaCodeContext;
typedef struct _ValaCodeContextClass ValaCodeContextClass;

#define VALA_TYPE_CODE_GENERATOR (vala_code_generator_get_type ())
#define VALA_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGenerator))
#define VALA_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))
#define VALA_IS_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_GENERATOR))
#define VALA_IS_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_GENERATOR))
#define VALA_CODE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))

typedef struct _ValaCodeGenerator ValaCodeGenerator;
typedef struct _ValaCodeGeneratorClass ValaCodeGeneratorClass;

#define VALA_TYPE_DATA_TYPE (vala_data_type_get_type ())
#define VALA_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DATA_TYPE, ValaDataType))
#define VALA_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))
#define VALA_IS_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DATA_TYPE))
#define VALA_IS_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DATA_TYPE))
#define VALA_DATA_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))

typedef struct _ValaDataType ValaDataType;
typedef struct _ValaDataTypeClass ValaDataTypeClass;

#define VALA_TYPE_EXPRESSION (vala_expression_get_type ())
#define VALA_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_EXPRESSION, ValaExpression))
#define VALA_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_EXPRESSION, ValaExpressionClass))
#define VALA_IS_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_EXPRESSION))
#define VALA_IS_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_EXPRESSION))
#define VALA_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_EXPRESSION, ValaExpressionClass))

typedef struct _ValaExpression ValaExpression;
typedef struct _ValaExpressionClass ValaExpressionClass;

#define VALA_TYPE_SYMBOL (vala_symbol_get_type ())
#define VALA_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SYMBOL, ValaSymbol))
#define VALA_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SYMBOL, ValaSymbolClass))
#define VALA_IS_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SYMBOL))
#define VALA_IS_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SYMBOL))
#define VALA_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SYMBOL, ValaSymbolClass))

typedef struct _ValaSymbol ValaSymbol;
typedef struct _ValaSymbolClass ValaSymbolClass;

#define VALA_TYPE_VARIABLE (vala_variable_get_type ())
#define VALA_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VARIABLE, ValaVariable))
#define VALA_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VARIABLE, ValaVariableClass))
#define VALA_IS_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VARIABLE))
#define VALA_IS_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VARIABLE))
#define VALA_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VARIABLE, ValaVariableClass))

typedef struct _ValaVariable ValaVariable;
typedef struct _ValaVariableClass ValaVariableClass;

#define VALA_TYPE_ATTRIBUTE (vala_attribute_get_type ())
#define VALA_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ATTRIBUTE, ValaAttribute))
#define VALA_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))
#define VALA_IS_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ATTRIBUTE))
#define VALA_IS_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ATTRIBUTE))
#define VALA_ATTRIBUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))

typedef struct _ValaAttribute ValaAttribute;
typedef struct _ValaAttributeClass ValaAttributeClass;

#define VALA_TYPE_STATEMENT (vala_statement_get_type ())
#define VALA_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_STATEMENT, ValaStatement))
#define VALA_IS_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_STATEMENT))
#define VALA_STATEMENT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), VALA_TYPE_STATEMENT, ValaStatementIface))

typedef struct _ValaStatement ValaStatement;
typedef struct _ValaStatementIface ValaStatementIface;

#define VALA_TYPE_RETURN_STATEMENT (vala_return_statement_get_type ())
#define VALA_RETURN_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_RETURN_STATEMENT, ValaReturnStatement))
#define VALA_RETURN_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_RETURN_STATEMENT, ValaReturnStatementClass))
#define VALA_IS_RETURN_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_RETURN_STATEMENT))
#define VALA_IS_RETURN_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_RETURN_STATEMENT))
#define VALA_RETURN_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_RETURN_STATEMENT, ValaReturnStatementClass))

typedef struct _ValaReturnStatement ValaReturnStatement;
typedef struct _ValaReturnStatementClass ValaReturnStatementClass;
typedef struct _ValaReturnStatementPrivate ValaReturnStatementPrivate;
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))

#define VALA_TYPE_SOURCE_REFERENCE (vala_source_reference_get_type ())
#define VALA_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReference))
#define VALA_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))
#define VALA_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))

typedef struct _ValaSourceReference ValaSourceReference;
typedef struct _ValaSourceReferenceClass ValaSourceReferenceClass;

#define VALA_TYPE_SEMANTIC_ANALYZER (vala_semantic_analyzer_get_type ())
#define VALA_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzer))
#define VALA_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))
#define VALA_IS_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_IS_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_SEMANTIC_ANALYZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))

typedef struct _ValaSemanticAnalyzer ValaSemanticAnalyzer;
typedef struct _ValaSemanticAnalyzerClass ValaSemanticAnalyzerClass;

#define VALA_TYPE_PROFILE (vala_profile_get_type ())

#define VALA_TYPE_VOID_TYPE (vala_void_type_get_type ())
#define VALA_VOID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VOID_TYPE, ValaVoidType))
#define VALA_VOID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VOID_TYPE, ValaVoidTypeClass))
#define VALA_IS_VOID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VOID_TYPE))
#define VALA_IS_VOID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VOID_TYPE))
#define VALA_VOID_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VOID_TYPE, ValaVoidTypeClass))

typedef struct _ValaVoidType ValaVoidType;
typedef struct _ValaVoidTypeClass ValaVoidTypeClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define VALA_TYPE_LOCAL_VARIABLE (vala_local_variable_get_type ())
#define VALA_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable))
#define VALA_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))
#define VALA_IS_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_IS_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_LOCAL_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))

typedef struct _ValaLocalVariable ValaLocalVariable;
typedef struct _ValaLocalVariableClass ValaLocalVariableClass;

#define VALA_TYPE_LITERAL (vala_literal_get_type ())
#define VALA_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LITERAL, ValaLiteral))
#define VALA_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LITERAL, ValaLiteralClass))
#define VALA_IS_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LITERAL))
#define VALA_IS_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LITERAL))
#define VALA_LITERAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LITERAL, ValaLiteralClass))

typedef struct _ValaLiteral ValaLiteral;
typedef struct _ValaLiteralClass ValaLiteralClass;

#define VALA_TYPE_NULL_LITERAL (vala_null_literal_get_type ())
#define VALA_NULL_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_NULL_LITERAL, ValaNullLiteral))
#define VALA_NULL_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_NULL_LITERAL, ValaNullLiteralClass))
#define VALA_IS_NULL_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_NULL_LITERAL))
#define VALA_IS_NULL_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_NULL_LITERAL))
#define VALA_NULL_LITERAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_NULL_LITERAL, ValaNullLiteralClass))

typedef struct _ValaNullLiteral ValaNullLiteral;
typedef struct _ValaNullLiteralClass ValaNullLiteralClass;
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

struct _ValaCodeNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCodeNodePrivate * priv;
	GList* attributes;
};

struct _ValaCodeNodeClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCodeNode *self);
	void (*accept) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	void (*accept_children) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	gboolean (*check) (ValaCodeNode* self, ValaCodeContext* context);
	void (*emit) (ValaCodeNode* self, ValaCodeGenerator* codegen);
	void (*replace_type) (ValaCodeNode* self, ValaDataType* old_type, ValaDataType* new_type);
	void (*replace_expression) (ValaCodeNode* self, ValaExpression* old_node, ValaExpression* new_node);
	gchar* (*to_string) (ValaCodeNode* self);
	void (*get_defined_variables) (ValaCodeNode* self, ValaCollection* collection);
	void (*get_used_variables) (ValaCodeNode* self, ValaCollection* collection);
};

struct _ValaStatementIface {
	GTypeInterface parent_iface;
};

struct _ValaReturnStatement {
	ValaCodeNode parent_instance;
	ValaReturnStatementPrivate * priv;
};

struct _ValaReturnStatementClass {
	ValaCodeNodeClass parent_class;
};

struct _ValaReturnStatementPrivate {
	ValaExpression* _return_expression;
};

typedef enum  {
	VALA_PROFILE_POSIX,
	VALA_PROFILE_GOBJECT,
	VALA_PROFILE_DOVA
} ValaProfile;


static gpointer vala_return_statement_parent_class = NULL;
static ValaStatementIface* vala_return_statement_vala_statement_parent_iface = NULL;

gpointer vala_code_node_ref (gpointer instance);
void vala_code_node_unref (gpointer instance);
GParamSpec* vala_param_spec_code_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_node (GValue* value, gpointer v_object);
void vala_value_take_code_node (GValue* value, gpointer v_object);
gpointer vala_value_get_code_node (const GValue* value);
GType vala_code_node_get_type (void) G_GNUC_CONST;
gpointer vala_code_visitor_ref (gpointer instance);
void vala_code_visitor_unref (gpointer instance);
GParamSpec* vala_param_spec_code_visitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_visitor (GValue* value, gpointer v_object);
void vala_value_take_code_visitor (GValue* value, gpointer v_object);
gpointer vala_value_get_code_visitor (const GValue* value);
GType vala_code_visitor_get_type (void) G_GNUC_CONST;
gpointer vala_code_context_ref (gpointer instance);
void vala_code_context_unref (gpointer instance);
GParamSpec* vala_param_spec_code_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_context (GValue* value, gpointer v_object);
void vala_value_take_code_context (GValue* value, gpointer v_object);
gpointer vala_value_get_code_context (const GValue* value);
GType vala_code_context_get_type (void) G_GNUC_CONST;
GType vala_code_generator_get_type (void) G_GNUC_CONST;
GType vala_data_type_get_type (void) G_GNUC_CONST;
GType vala_expression_get_type (void) G_GNUC_CONST;
GType vala_symbol_get_type (void) G_GNUC_CONST;
GType vala_variable_get_type (void) G_GNUC_CONST;
GType vala_attribute_get_type (void) G_GNUC_CONST;
GType vala_statement_get_type (void) G_GNUC_CONST;
GType vala_return_statement_get_type (void) G_GNUC_CONST;
#define VALA_RETURN_STATEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_RETURN_STATEMENT, ValaReturnStatementPrivate))
enum  {
	VALA_RETURN_STATEMENT_DUMMY_PROPERTY
};
gpointer vala_source_reference_ref (gpointer instance);
void vala_source_reference_unref (gpointer instance);
GParamSpec* vala_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_reference (GValue* value, gpointer v_object);
void vala_value_take_source_reference (GValue* value, gpointer v_object);
gpointer vala_value_get_source_reference (const GValue* value);
GType vala_source_reference_get_type (void) G_GNUC_CONST;
ValaReturnStatement* vala_return_statement_new (ValaExpression* return_expression, ValaSourceReference* source_reference);
ValaReturnStatement* vala_return_statement_construct (GType object_type, ValaExpression* return_expression, ValaSourceReference* source_reference);
ValaCodeNode* vala_code_node_construct (GType object_type);
void vala_code_node_set_source_reference (ValaCodeNode* self, ValaSourceReference* value);
void vala_return_statement_set_return_expression (ValaReturnStatement* self, ValaExpression* value);
static void vala_return_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
void vala_code_visitor_visit_return_statement (ValaCodeVisitor* self, ValaReturnStatement* stmt);
static void vala_return_statement_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
ValaExpression* vala_return_statement_get_return_expression (ValaReturnStatement* self);
void vala_code_node_accept (ValaCodeNode* self, ValaCodeVisitor* visitor);
void vala_code_visitor_visit_end_full_expression (ValaCodeVisitor* self, ValaExpression* expr);
static void vala_return_statement_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node);
static gboolean vala_return_statement_real_check (ValaCodeNode* base, ValaCodeContext* context);
gboolean vala_code_node_get_checked (ValaCodeNode* self);
gboolean vala_code_node_get_error (ValaCodeNode* self);
void vala_code_node_set_checked (ValaCodeNode* self, gboolean value);
GType vala_semantic_analyzer_get_type (void) G_GNUC_CONST;
ValaSemanticAnalyzer* vala_code_context_get_analyzer (ValaCodeContext* self);
ValaDataType* vala_semantic_analyzer_get_current_return_type (ValaSemanticAnalyzer* self);
void vala_expression_set_target_type (ValaExpression* self, ValaDataType* value);
gboolean vala_code_node_check (ValaCodeNode* self, ValaCodeContext* context);
void vala_code_node_set_error (ValaCodeNode* self, gboolean value);
void vala_report_error (ValaSourceReference* source, const gchar* message);
ValaSourceReference* vala_code_node_get_source_reference (ValaCodeNode* self);
GType vala_profile_get_type (void) G_GNUC_CONST;
ValaProfile vala_code_context_get_profile (ValaCodeContext* self);
GType vala_void_type_get_type (void) G_GNUC_CONST;
ValaDataType* vala_expression_get_value_type (ValaExpression* self);
gboolean vala_data_type_compatible (ValaDataType* self, ValaDataType* target_type);
gchar* vala_code_node_to_string (ValaCodeNode* self);
gboolean vala_data_type_is_disposable (ValaDataType* self);
gboolean vala_data_type_get_value_owned (ValaDataType* self);
ValaSymbol* vala_expression_get_symbol_reference (ValaExpression* self);
GType vala_local_variable_get_type (void) G_GNUC_CONST;
ValaDataType* vala_variable_get_variable_type (ValaVariable* self);
GType vala_literal_get_type (void) G_GNUC_CONST;
GType vala_null_literal_get_type (void) G_GNUC_CONST;
gboolean vala_data_type_get_nullable (ValaDataType* self);
void vala_report_warning (ValaSourceReference* source, const gchar* message);
void vala_code_node_add_error_types (ValaCodeNode* self, ValaList* error_types);
ValaList* vala_code_node_get_error_types (ValaCodeNode* self);
static void vala_return_statement_real_emit (ValaCodeNode* base, ValaCodeGenerator* codegen);
void vala_code_node_emit (ValaCodeNode* self, ValaCodeGenerator* codegen);
static void vala_return_statement_real_get_defined_variables (ValaCodeNode* base, ValaCollection* collection);
void vala_code_node_get_defined_variables (ValaCodeNode* self, ValaCollection* collection);
static void vala_return_statement_real_get_used_variables (ValaCodeNode* base, ValaCollection* collection);
void vala_code_node_get_used_variables (ValaCodeNode* self, ValaCollection* collection);
void vala_code_node_set_parent_node (ValaCodeNode* self, ValaCodeNode* value);
static void vala_return_statement_finalize (ValaCodeNode* obj);


/**
 * Creates a new return statement.
 *
 * @param return_expression the return expression
 * @param source_reference  reference to source code
 * @return                  newly created return statement
 */
ValaReturnStatement* vala_return_statement_construct (GType object_type, ValaExpression* return_expression, ValaSourceReference* source_reference) {
	ValaReturnStatement* self = NULL;
	ValaSourceReference* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaReturnStatement*) vala_code_node_construct (object_type);
	_tmp0_ = source_reference;
	vala_code_node_set_source_reference ((ValaCodeNode*) self, _tmp0_);
	_tmp1_ = return_expression;
	vala_return_statement_set_return_expression (self, _tmp1_);
	return self;
}


ValaReturnStatement* vala_return_statement_new (ValaExpression* return_expression, ValaSourceReference* source_reference) {
	return vala_return_statement_construct (VALA_TYPE_RETURN_STATEMENT, return_expression, source_reference);
}


static void vala_return_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaReturnStatement * self;
	ValaCodeVisitor* _tmp0_;
	self = (ValaReturnStatement*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = visitor;
	vala_code_visitor_visit_return_statement (_tmp0_, self);
}


static void vala_return_statement_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaReturnStatement * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaReturnStatement*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_return_statement_get_return_expression (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		ValaCodeVisitor* _tmp4_;
		ValaCodeVisitor* _tmp5_;
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		_tmp2_ = vala_return_statement_get_return_expression (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = visitor;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, _tmp4_);
		_tmp5_ = visitor;
		_tmp6_ = vala_return_statement_get_return_expression (self);
		_tmp7_ = _tmp6_;
		vala_code_visitor_visit_end_full_expression (_tmp5_, _tmp7_);
	}
}


static void vala_return_statement_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node) {
	ValaReturnStatement * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	self = (ValaReturnStatement*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_return_statement_get_return_expression (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = old_node;
	if (_tmp1_ == _tmp2_) {
		ValaExpression* _tmp3_;
		_tmp3_ = new_node;
		vala_return_statement_set_return_expression (self, _tmp3_);
	}
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean vala_return_statement_real_check (ValaCodeNode* base, ValaCodeContext* context) {
	ValaReturnStatement * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	gboolean _tmp13_ = FALSE;
	ValaExpression* _tmp14_;
	ValaExpression* _tmp15_;
	gboolean _tmp20_;
	ValaCodeContext* _tmp21_;
	ValaSemanticAnalyzer* _tmp22_;
	ValaSemanticAnalyzer* _tmp23_;
	ValaDataType* _tmp24_;
	ValaDataType* _tmp25_;
	ValaCodeContext* _tmp28_;
	ValaProfile _tmp29_;
	ValaProfile _tmp30_;
	ValaExpression* _tmp33_;
	ValaExpression* _tmp34_;
	ValaCodeContext* _tmp44_;
	ValaSemanticAnalyzer* _tmp45_;
	ValaSemanticAnalyzer* _tmp46_;
	ValaDataType* _tmp47_;
	ValaDataType* _tmp48_;
	ValaExpression* _tmp51_;
	ValaExpression* _tmp52_;
	ValaDataType* _tmp53_;
	ValaDataType* _tmp54_;
	ValaExpression* _tmp57_;
	ValaExpression* _tmp58_;
	ValaDataType* _tmp59_;
	ValaDataType* _tmp60_;
	ValaCodeContext* _tmp61_;
	ValaSemanticAnalyzer* _tmp62_;
	ValaSemanticAnalyzer* _tmp63_;
	ValaDataType* _tmp64_;
	ValaDataType* _tmp65_;
	gboolean _tmp66_ = FALSE;
	gboolean _tmp84_ = FALSE;
	ValaExpression* _tmp85_;
	ValaExpression* _tmp86_;
	ValaDataType* _tmp87_;
	ValaDataType* _tmp88_;
	gboolean _tmp89_ = FALSE;
	gboolean _tmp97_;
	ValaExpression* _tmp100_;
	ValaExpression* _tmp101_;
	ValaSymbol* _tmp102_;
	ValaSymbol* _tmp103_;
	ValaLocalVariable* _tmp104_;
	ValaLocalVariable* local;
	gboolean _tmp105_ = FALSE;
	gboolean _tmp106_ = FALSE;
	ValaLocalVariable* _tmp107_;
	gboolean _tmp112_;
	gboolean _tmp120_;
	gboolean _tmp123_ = FALSE;
	ValaExpression* _tmp124_;
	ValaExpression* _tmp125_;
	gboolean _tmp133_;
	ValaExpression* _tmp145_;
	ValaExpression* _tmp146_;
	ValaList* _tmp147_ = NULL;
	ValaList* _tmp148_;
	gboolean _tmp149_;
	gboolean _tmp150_;
	self = (ValaReturnStatement*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_return_statement_get_return_expression (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		ValaCodeContext* _tmp8_;
		ValaSemanticAnalyzer* _tmp9_;
		ValaSemanticAnalyzer* _tmp10_;
		ValaDataType* _tmp11_;
		ValaDataType* _tmp12_;
		_tmp6_ = vala_return_statement_get_return_expression (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = context;
		_tmp9_ = vala_code_context_get_analyzer (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_semantic_analyzer_get_current_return_type (_tmp10_);
		_tmp12_ = _tmp11_;
		vala_expression_set_target_type (_tmp7_, _tmp12_);
	}
	_tmp14_ = vala_return_statement_get_return_expression (self);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		ValaExpression* _tmp16_;
		ValaExpression* _tmp17_;
		ValaCodeContext* _tmp18_;
		gboolean _tmp19_ = FALSE;
		_tmp16_ = vala_return_statement_get_return_expression (self);
		_tmp17_ = _tmp16_;
		_tmp18_ = context;
		_tmp19_ = vala_code_node_check ((ValaCodeNode*) _tmp17_, _tmp18_);
		_tmp13_ = !_tmp19_;
	} else {
		_tmp13_ = FALSE;
	}
	_tmp20_ = _tmp13_;
	if (_tmp20_) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp21_ = context;
	_tmp22_ = vala_code_context_get_analyzer (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = vala_semantic_analyzer_get_current_return_type (_tmp23_);
	_tmp25_ = _tmp24_;
	if (_tmp25_ == NULL) {
		ValaSourceReference* _tmp26_;
		ValaSourceReference* _tmp27_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp26_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp27_ = _tmp26_;
		vala_report_error (_tmp27_, "Return not allowed in this context");
		result = FALSE;
		return result;
	}
	_tmp28_ = context;
	_tmp29_ = vala_code_context_get_profile (_tmp28_);
	_tmp30_ = _tmp29_;
	if (_tmp30_ == VALA_PROFILE_DOVA) {
		gboolean _tmp31_;
		gboolean _tmp32_;
		_tmp31_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp32_ = _tmp31_;
		result = !_tmp32_;
		return result;
	}
	_tmp33_ = vala_return_statement_get_return_expression (self);
	_tmp34_ = _tmp33_;
	if (_tmp34_ == NULL) {
		ValaCodeContext* _tmp35_;
		ValaSemanticAnalyzer* _tmp36_;
		ValaSemanticAnalyzer* _tmp37_;
		ValaDataType* _tmp38_;
		ValaDataType* _tmp39_;
		gboolean _tmp42_;
		gboolean _tmp43_;
		_tmp35_ = context;
		_tmp36_ = vala_code_context_get_analyzer (_tmp35_);
		_tmp37_ = _tmp36_;
		_tmp38_ = vala_semantic_analyzer_get_current_return_type (_tmp37_);
		_tmp39_ = _tmp38_;
		if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp39_, VALA_TYPE_VOID_TYPE)) {
			ValaSourceReference* _tmp40_;
			ValaSourceReference* _tmp41_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp40_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp41_ = _tmp40_;
			vala_report_error (_tmp41_, "Return without value in non-void function");
		}
		_tmp42_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp43_ = _tmp42_;
		result = !_tmp43_;
		return result;
	}
	_tmp44_ = context;
	_tmp45_ = vala_code_context_get_analyzer (_tmp44_);
	_tmp46_ = _tmp45_;
	_tmp47_ = vala_semantic_analyzer_get_current_return_type (_tmp46_);
	_tmp48_ = _tmp47_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp48_, VALA_TYPE_VOID_TYPE)) {
		ValaSourceReference* _tmp49_;
		ValaSourceReference* _tmp50_;
		_tmp49_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp50_ = _tmp49_;
		vala_report_error (_tmp50_, "Return with value in void function");
		result = FALSE;
		return result;
	}
	_tmp51_ = vala_return_statement_get_return_expression (self);
	_tmp52_ = _tmp51_;
	_tmp53_ = vala_expression_get_value_type (_tmp52_);
	_tmp54_ = _tmp53_;
	if (_tmp54_ == NULL) {
		ValaSourceReference* _tmp55_;
		ValaSourceReference* _tmp56_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp55_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp56_ = _tmp55_;
		vala_report_error (_tmp56_, "Invalid expression in return value");
		result = FALSE;
		return result;
	}
	_tmp57_ = vala_return_statement_get_return_expression (self);
	_tmp58_ = _tmp57_;
	_tmp59_ = vala_expression_get_value_type (_tmp58_);
	_tmp60_ = _tmp59_;
	_tmp61_ = context;
	_tmp62_ = vala_code_context_get_analyzer (_tmp61_);
	_tmp63_ = _tmp62_;
	_tmp64_ = vala_semantic_analyzer_get_current_return_type (_tmp63_);
	_tmp65_ = _tmp64_;
	_tmp66_ = vala_data_type_compatible (_tmp60_, _tmp65_);
	if (!_tmp66_) {
		ValaSourceReference* _tmp67_;
		ValaSourceReference* _tmp68_;
		ValaExpression* _tmp69_;
		ValaExpression* _tmp70_;
		ValaDataType* _tmp71_;
		ValaDataType* _tmp72_;
		gchar* _tmp73_ = NULL;
		gchar* _tmp74_;
		ValaCodeContext* _tmp75_;
		ValaSemanticAnalyzer* _tmp76_;
		ValaSemanticAnalyzer* _tmp77_;
		ValaDataType* _tmp78_;
		ValaDataType* _tmp79_;
		gchar* _tmp80_ = NULL;
		gchar* _tmp81_;
		gchar* _tmp82_ = NULL;
		gchar* _tmp83_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp67_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp68_ = _tmp67_;
		_tmp69_ = vala_return_statement_get_return_expression (self);
		_tmp70_ = _tmp69_;
		_tmp71_ = vala_expression_get_value_type (_tmp70_);
		_tmp72_ = _tmp71_;
		_tmp73_ = vala_code_node_to_string ((ValaCodeNode*) _tmp72_);
		_tmp74_ = _tmp73_;
		_tmp75_ = context;
		_tmp76_ = vala_code_context_get_analyzer (_tmp75_);
		_tmp77_ = _tmp76_;
		_tmp78_ = vala_semantic_analyzer_get_current_return_type (_tmp77_);
		_tmp79_ = _tmp78_;
		_tmp80_ = vala_code_node_to_string ((ValaCodeNode*) _tmp79_);
		_tmp81_ = _tmp80_;
		_tmp82_ = g_strdup_printf ("Return: Cannot convert from `%s' to `%s'", _tmp74_, _tmp81_);
		_tmp83_ = _tmp82_;
		vala_report_error (_tmp68_, _tmp83_);
		_g_free0 (_tmp83_);
		_g_free0 (_tmp81_);
		_g_free0 (_tmp74_);
		result = FALSE;
		return result;
	}
	_tmp85_ = vala_return_statement_get_return_expression (self);
	_tmp86_ = _tmp85_;
	_tmp87_ = vala_expression_get_value_type (_tmp86_);
	_tmp88_ = _tmp87_;
	_tmp89_ = vala_data_type_is_disposable (_tmp88_);
	if (_tmp89_) {
		ValaCodeContext* _tmp90_;
		ValaSemanticAnalyzer* _tmp91_;
		ValaSemanticAnalyzer* _tmp92_;
		ValaDataType* _tmp93_;
		ValaDataType* _tmp94_;
		gboolean _tmp95_;
		gboolean _tmp96_;
		_tmp90_ = context;
		_tmp91_ = vala_code_context_get_analyzer (_tmp90_);
		_tmp92_ = _tmp91_;
		_tmp93_ = vala_semantic_analyzer_get_current_return_type (_tmp92_);
		_tmp94_ = _tmp93_;
		_tmp95_ = vala_data_type_get_value_owned (_tmp94_);
		_tmp96_ = _tmp95_;
		_tmp84_ = !_tmp96_;
	} else {
		_tmp84_ = FALSE;
	}
	_tmp97_ = _tmp84_;
	if (_tmp97_) {
		ValaSourceReference* _tmp98_;
		ValaSourceReference* _tmp99_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp98_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp99_ = _tmp98_;
		vala_report_error (_tmp99_, "Return value transfers ownership but method return type hasn't been de" \
"clared to transfer ownership");
		result = FALSE;
		return result;
	}
	_tmp100_ = vala_return_statement_get_return_expression (self);
	_tmp101_ = _tmp100_;
	_tmp102_ = vala_expression_get_symbol_reference (_tmp101_);
	_tmp103_ = _tmp102_;
	_tmp104_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp103_, VALA_TYPE_LOCAL_VARIABLE) ? ((ValaLocalVariable*) _tmp103_) : NULL);
	local = _tmp104_;
	_tmp107_ = local;
	if (_tmp107_ != NULL) {
		ValaLocalVariable* _tmp108_;
		ValaDataType* _tmp109_;
		ValaDataType* _tmp110_;
		gboolean _tmp111_ = FALSE;
		_tmp108_ = local;
		_tmp109_ = vala_variable_get_variable_type ((ValaVariable*) _tmp108_);
		_tmp110_ = _tmp109_;
		_tmp111_ = vala_data_type_is_disposable (_tmp110_);
		_tmp106_ = _tmp111_;
	} else {
		_tmp106_ = FALSE;
	}
	_tmp112_ = _tmp106_;
	if (_tmp112_) {
		ValaCodeContext* _tmp113_;
		ValaSemanticAnalyzer* _tmp114_;
		ValaSemanticAnalyzer* _tmp115_;
		ValaDataType* _tmp116_;
		ValaDataType* _tmp117_;
		gboolean _tmp118_;
		gboolean _tmp119_;
		_tmp113_ = context;
		_tmp114_ = vala_code_context_get_analyzer (_tmp113_);
		_tmp115_ = _tmp114_;
		_tmp116_ = vala_semantic_analyzer_get_current_return_type (_tmp115_);
		_tmp117_ = _tmp116_;
		_tmp118_ = vala_data_type_get_value_owned (_tmp117_);
		_tmp119_ = _tmp118_;
		_tmp105_ = !_tmp119_;
	} else {
		_tmp105_ = FALSE;
	}
	_tmp120_ = _tmp105_;
	if (_tmp120_) {
		ValaSourceReference* _tmp121_;
		ValaSourceReference* _tmp122_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp121_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp122_ = _tmp121_;
		vala_report_error (_tmp122_, "Local variable with strong reference used as return value and method r" \
"eturn type has not been declared to transfer ownership");
		result = FALSE;
		_vala_code_node_unref0 (local);
		return result;
	}
	_tmp124_ = vala_return_statement_get_return_expression (self);
	_tmp125_ = _tmp124_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp125_, VALA_TYPE_NULL_LITERAL)) {
		ValaCodeContext* _tmp126_;
		ValaSemanticAnalyzer* _tmp127_;
		ValaSemanticAnalyzer* _tmp128_;
		ValaDataType* _tmp129_;
		ValaDataType* _tmp130_;
		gboolean _tmp131_;
		gboolean _tmp132_;
		_tmp126_ = context;
		_tmp127_ = vala_code_context_get_analyzer (_tmp126_);
		_tmp128_ = _tmp127_;
		_tmp129_ = vala_semantic_analyzer_get_current_return_type (_tmp128_);
		_tmp130_ = _tmp129_;
		_tmp131_ = vala_data_type_get_nullable (_tmp130_);
		_tmp132_ = _tmp131_;
		_tmp123_ = !_tmp132_;
	} else {
		_tmp123_ = FALSE;
	}
	_tmp133_ = _tmp123_;
	if (_tmp133_) {
		ValaSourceReference* _tmp134_;
		ValaSourceReference* _tmp135_;
		ValaCodeContext* _tmp136_;
		ValaSemanticAnalyzer* _tmp137_;
		ValaSemanticAnalyzer* _tmp138_;
		ValaDataType* _tmp139_;
		ValaDataType* _tmp140_;
		gchar* _tmp141_ = NULL;
		gchar* _tmp142_;
		gchar* _tmp143_ = NULL;
		gchar* _tmp144_;
		_tmp134_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp135_ = _tmp134_;
		_tmp136_ = context;
		_tmp137_ = vala_code_context_get_analyzer (_tmp136_);
		_tmp138_ = _tmp137_;
		_tmp139_ = vala_semantic_analyzer_get_current_return_type (_tmp138_);
		_tmp140_ = _tmp139_;
		_tmp141_ = vala_code_node_to_string ((ValaCodeNode*) _tmp140_);
		_tmp142_ = _tmp141_;
		_tmp143_ = g_strdup_printf ("`null' incompatible with return type `%s`", _tmp142_);
		_tmp144_ = _tmp143_;
		vala_report_warning (_tmp135_, _tmp144_);
		_g_free0 (_tmp144_);
		_g_free0 (_tmp142_);
	}
	_tmp145_ = vala_return_statement_get_return_expression (self);
	_tmp146_ = _tmp145_;
	_tmp147_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp146_);
	_tmp148_ = _tmp147_;
	vala_code_node_add_error_types ((ValaCodeNode*) self, _tmp148_);
	_vala_iterable_unref0 (_tmp148_);
	_tmp149_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp150_ = _tmp149_;
	result = !_tmp150_;
	_vala_code_node_unref0 (local);
	return result;
}


static void vala_return_statement_real_emit (ValaCodeNode* base, ValaCodeGenerator* codegen) {
	ValaReturnStatement * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaCodeGenerator* _tmp8_;
	self = (ValaReturnStatement*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_return_statement_get_return_expression (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		ValaCodeGenerator* _tmp4_;
		ValaCodeGenerator* _tmp5_;
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		_tmp2_ = vala_return_statement_get_return_expression (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = codegen;
		vala_code_node_emit ((ValaCodeNode*) _tmp3_, _tmp4_);
		_tmp5_ = codegen;
		_tmp6_ = vala_return_statement_get_return_expression (self);
		_tmp7_ = _tmp6_;
		vala_code_visitor_visit_end_full_expression ((ValaCodeVisitor*) _tmp5_, _tmp7_);
	}
	_tmp8_ = codegen;
	vala_code_visitor_visit_return_statement ((ValaCodeVisitor*) _tmp8_, self);
}


static void vala_return_statement_real_get_defined_variables (ValaCodeNode* base, ValaCollection* collection) {
	ValaReturnStatement * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaReturnStatement*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_return_statement_get_return_expression (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		ValaCollection* _tmp4_;
		_tmp2_ = vala_return_statement_get_return_expression (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = collection;
		vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, _tmp4_);
	}
}


static void vala_return_statement_real_get_used_variables (ValaCodeNode* base, ValaCollection* collection) {
	ValaReturnStatement * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaReturnStatement*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_return_statement_get_return_expression (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		ValaCollection* _tmp4_;
		_tmp2_ = vala_return_statement_get_return_expression (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = collection;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp3_, _tmp4_);
	}
}


ValaExpression* vala_return_statement_get_return_expression (ValaReturnStatement* self) {
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_return_expression;
	result = _tmp0_;
	return result;
}


void vala_return_statement_set_return_expression (ValaReturnStatement* self, ValaExpression* value) {
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_return_expression);
	self->priv->_return_expression = _tmp1_;
	_tmp2_ = self->priv->_return_expression;
	if (_tmp2_ != NULL) {
		ValaExpression* _tmp3_;
		_tmp3_ = self->priv->_return_expression;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp3_, (ValaCodeNode*) self);
	}
}


static void vala_return_statement_class_init (ValaReturnStatementClass * klass) {
	vala_return_statement_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_return_statement_finalize;
	g_type_class_add_private (klass, sizeof (ValaReturnStatementPrivate));
	VALA_CODE_NODE_CLASS (klass)->accept = vala_return_statement_real_accept;
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_return_statement_real_accept_children;
	VALA_CODE_NODE_CLASS (klass)->replace_expression = vala_return_statement_real_replace_expression;
	VALA_CODE_NODE_CLASS (klass)->check = vala_return_statement_real_check;
	VALA_CODE_NODE_CLASS (klass)->emit = vala_return_statement_real_emit;
	VALA_CODE_NODE_CLASS (klass)->get_defined_variables = vala_return_statement_real_get_defined_variables;
	VALA_CODE_NODE_CLASS (klass)->get_used_variables = vala_return_statement_real_get_used_variables;
}


static void vala_return_statement_vala_statement_interface_init (ValaStatementIface * iface) {
	vala_return_statement_vala_statement_parent_iface = g_type_interface_peek_parent (iface);
}


static void vala_return_statement_instance_init (ValaReturnStatement * self) {
	self->priv = VALA_RETURN_STATEMENT_GET_PRIVATE (self);
}


static void vala_return_statement_finalize (ValaCodeNode* obj) {
	ValaReturnStatement * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_RETURN_STATEMENT, ValaReturnStatement);
	_vala_code_node_unref0 (self->priv->_return_expression);
	VALA_CODE_NODE_CLASS (vala_return_statement_parent_class)->finalize (obj);
}


/**
 * Represents a return statement in the source code.
 */
GType vala_return_statement_get_type (void) {
	static volatile gsize vala_return_statement_type_id__volatile = 0;
	if (g_once_init_enter (&vala_return_statement_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaReturnStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_return_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaReturnStatement), 0, (GInstanceInitFunc) vala_return_statement_instance_init, NULL };
		static const GInterfaceInfo vala_statement_info = { (GInterfaceInitFunc) vala_return_statement_vala_statement_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType vala_return_statement_type_id;
		vala_return_statement_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaReturnStatement", &g_define_type_info, 0);
		g_type_add_interface_static (vala_return_statement_type_id, VALA_TYPE_STATEMENT, &vala_statement_info);
		g_once_init_leave (&vala_return_statement_type_id__volatile, vala_return_statement_type_id);
	}
	return vala_return_statement_type_id__volatile;
}



