/* valasignal.c generated by valac, the Vala compiler
 * generated from valasignal.vala, do not modify */

/* valasignal.vala
 *
 * Copyright (C) 2006-2011  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>


#define VALA_TYPE_CODE_NODE (vala_code_node_get_type ())
#define VALA_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_NODE, ValaCodeNode))
#define VALA_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))
#define VALA_IS_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_NODE))
#define VALA_IS_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_NODE))
#define VALA_CODE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))

typedef struct _ValaCodeNode ValaCodeNode;
typedef struct _ValaCodeNodeClass ValaCodeNodeClass;
typedef struct _ValaCodeNodePrivate ValaCodeNodePrivate;

#define VALA_TYPE_CODE_VISITOR (vala_code_visitor_get_type ())
#define VALA_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitor))
#define VALA_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))
#define VALA_IS_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_VISITOR))
#define VALA_IS_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_VISITOR))
#define VALA_CODE_VISITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))

typedef struct _ValaCodeVisitor ValaCodeVisitor;
typedef struct _ValaCodeVisitorClass ValaCodeVisitorClass;

#define VALA_TYPE_CODE_CONTEXT (vala_code_context_get_type ())
#define VALA_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContext))
#define VALA_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))
#define VALA_IS_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_CONTEXT))
#define VALA_IS_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_CONTEXT))
#define VALA_CODE_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))

typedef struct _ValaCodeContext ValaCodeContext;
typedef struct _ValaCodeContextClass ValaCodeContextClass;

#define VALA_TYPE_CODE_GENERATOR (vala_code_generator_get_type ())
#define VALA_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGenerator))
#define VALA_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))
#define VALA_IS_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_GENERATOR))
#define VALA_IS_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_GENERATOR))
#define VALA_CODE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))

typedef struct _ValaCodeGenerator ValaCodeGenerator;
typedef struct _ValaCodeGeneratorClass ValaCodeGeneratorClass;

#define VALA_TYPE_DATA_TYPE (vala_data_type_get_type ())
#define VALA_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DATA_TYPE, ValaDataType))
#define VALA_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))
#define VALA_IS_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DATA_TYPE))
#define VALA_IS_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DATA_TYPE))
#define VALA_DATA_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))

typedef struct _ValaDataType ValaDataType;
typedef struct _ValaDataTypeClass ValaDataTypeClass;

#define VALA_TYPE_EXPRESSION (vala_expression_get_type ())
#define VALA_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_EXPRESSION, ValaExpression))
#define VALA_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_EXPRESSION, ValaExpressionClass))
#define VALA_IS_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_EXPRESSION))
#define VALA_IS_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_EXPRESSION))
#define VALA_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_EXPRESSION, ValaExpressionClass))

typedef struct _ValaExpression ValaExpression;
typedef struct _ValaExpressionClass ValaExpressionClass;

#define VALA_TYPE_SYMBOL (vala_symbol_get_type ())
#define VALA_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SYMBOL, ValaSymbol))
#define VALA_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SYMBOL, ValaSymbolClass))
#define VALA_IS_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SYMBOL))
#define VALA_IS_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SYMBOL))
#define VALA_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SYMBOL, ValaSymbolClass))

typedef struct _ValaSymbol ValaSymbol;
typedef struct _ValaSymbolClass ValaSymbolClass;

#define VALA_TYPE_VARIABLE (vala_variable_get_type ())
#define VALA_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VARIABLE, ValaVariable))
#define VALA_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VARIABLE, ValaVariableClass))
#define VALA_IS_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VARIABLE))
#define VALA_IS_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VARIABLE))
#define VALA_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VARIABLE, ValaVariableClass))

typedef struct _ValaVariable ValaVariable;
typedef struct _ValaVariableClass ValaVariableClass;

#define VALA_TYPE_ATTRIBUTE (vala_attribute_get_type ())
#define VALA_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ATTRIBUTE, ValaAttribute))
#define VALA_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))
#define VALA_IS_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ATTRIBUTE))
#define VALA_IS_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ATTRIBUTE))
#define VALA_ATTRIBUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))

typedef struct _ValaAttribute ValaAttribute;
typedef struct _ValaAttributeClass ValaAttributeClass;
typedef struct _ValaSymbolPrivate ValaSymbolPrivate;

#define VALA_TYPE_NAMESPACE (vala_namespace_get_type ())
#define VALA_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_NAMESPACE, ValaNamespace))
#define VALA_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_NAMESPACE, ValaNamespaceClass))
#define VALA_IS_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_NAMESPACE))
#define VALA_IS_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_NAMESPACE))
#define VALA_NAMESPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_NAMESPACE, ValaNamespaceClass))

typedef struct _ValaNamespace ValaNamespace;
typedef struct _ValaNamespaceClass ValaNamespaceClass;

#define VALA_TYPE_TYPESYMBOL (vala_typesymbol_get_type ())
#define VALA_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbol))
#define VALA_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))
#define VALA_IS_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPESYMBOL))
#define VALA_IS_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPESYMBOL))
#define VALA_TYPESYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))

typedef struct _ValaTypeSymbol ValaTypeSymbol;
typedef struct _ValaTypeSymbolClass ValaTypeSymbolClass;

#define VALA_TYPE_OBJECT_TYPE_SYMBOL (vala_object_type_symbol_get_type ())
#define VALA_OBJECT_TYPE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol))
#define VALA_OBJECT_TYPE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbolClass))
#define VALA_IS_OBJECT_TYPE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL))
#define VALA_IS_OBJECT_TYPE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_OBJECT_TYPE_SYMBOL))
#define VALA_OBJECT_TYPE_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbolClass))

typedef struct _ValaObjectTypeSymbol ValaObjectTypeSymbol;
typedef struct _ValaObjectTypeSymbolClass ValaObjectTypeSymbolClass;

#define VALA_TYPE_CLASS (vala_class_get_type ())
#define VALA_CLASS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CLASS, ValaClass))
#define VALA_CLASS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CLASS, ValaClassClass))
#define VALA_IS_CLASS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CLASS))
#define VALA_IS_CLASS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CLASS))
#define VALA_CLASS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CLASS, ValaClassClass))

typedef struct _ValaClass ValaClass;
typedef struct _ValaClassClass ValaClassClass;

#define VALA_TYPE_INTERFACE (vala_interface_get_type ())
#define VALA_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INTERFACE, ValaInterface))
#define VALA_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INTERFACE, ValaInterfaceClass))
#define VALA_IS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INTERFACE))
#define VALA_IS_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INTERFACE))
#define VALA_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INTERFACE, ValaInterfaceClass))

typedef struct _ValaInterface ValaInterface;
typedef struct _ValaInterfaceClass ValaInterfaceClass;

#define VALA_TYPE_STRUCT (vala_struct_get_type ())
#define VALA_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_STRUCT, ValaStruct))
#define VALA_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_STRUCT, ValaStructClass))
#define VALA_IS_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_STRUCT))
#define VALA_IS_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_STRUCT))
#define VALA_STRUCT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_STRUCT, ValaStructClass))

typedef struct _ValaStruct ValaStruct;
typedef struct _ValaStructClass ValaStructClass;

#define VALA_TYPE_ENUM (vala_enum_get_type ())
#define VALA_ENUM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ENUM, ValaEnum))
#define VALA_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ENUM, ValaEnumClass))
#define VALA_IS_ENUM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ENUM))
#define VALA_IS_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ENUM))
#define VALA_ENUM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ENUM, ValaEnumClass))

typedef struct _ValaEnum ValaEnum;
typedef struct _ValaEnumClass ValaEnumClass;

#define VALA_TYPE_ERROR_DOMAIN (vala_error_domain_get_type ())
#define VALA_ERROR_DOMAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain))
#define VALA_ERROR_DOMAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomainClass))
#define VALA_IS_ERROR_DOMAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ERROR_DOMAIN))
#define VALA_IS_ERROR_DOMAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ERROR_DOMAIN))
#define VALA_ERROR_DOMAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomainClass))

typedef struct _ValaErrorDomain ValaErrorDomain;
typedef struct _ValaErrorDomainClass ValaErrorDomainClass;

#define VALA_TYPE_DELEGATE (vala_delegate_get_type ())
#define VALA_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DELEGATE, ValaDelegate))
#define VALA_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DELEGATE, ValaDelegateClass))
#define VALA_IS_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DELEGATE))
#define VALA_IS_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DELEGATE))
#define VALA_DELEGATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DELEGATE, ValaDelegateClass))

typedef struct _ValaDelegate ValaDelegate;
typedef struct _ValaDelegateClass ValaDelegateClass;

#define VALA_TYPE_CONSTANT (vala_constant_get_type ())
#define VALA_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONSTANT, ValaConstant))
#define VALA_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONSTANT, ValaConstantClass))
#define VALA_IS_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONSTANT))
#define VALA_IS_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONSTANT))
#define VALA_CONSTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONSTANT, ValaConstantClass))

typedef struct _ValaConstant ValaConstant;
typedef struct _ValaConstantClass ValaConstantClass;

#define VALA_TYPE_FIELD (vala_field_get_type ())
#define VALA_FIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FIELD, ValaField))
#define VALA_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FIELD, ValaFieldClass))
#define VALA_IS_FIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FIELD))
#define VALA_IS_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FIELD))
#define VALA_FIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FIELD, ValaFieldClass))

typedef struct _ValaField ValaField;
typedef struct _ValaFieldClass ValaFieldClass;

#define VALA_TYPE_SUBROUTINE (vala_subroutine_get_type ())
#define VALA_SUBROUTINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SUBROUTINE, ValaSubroutine))
#define VALA_SUBROUTINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SUBROUTINE, ValaSubroutineClass))
#define VALA_IS_SUBROUTINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SUBROUTINE))
#define VALA_IS_SUBROUTINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SUBROUTINE))
#define VALA_SUBROUTINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SUBROUTINE, ValaSubroutineClass))

typedef struct _ValaSubroutine ValaSubroutine;
typedef struct _ValaSubroutineClass ValaSubroutineClass;

#define VALA_TYPE_METHOD (vala_method_get_type ())
#define VALA_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_METHOD, ValaMethod))
#define VALA_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_METHOD, ValaMethodClass))
#define VALA_IS_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_METHOD))
#define VALA_IS_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_METHOD))
#define VALA_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_METHOD, ValaMethodClass))

typedef struct _ValaMethod ValaMethod;
typedef struct _ValaMethodClass ValaMethodClass;

#define VALA_TYPE_PROPERTY (vala_property_get_type ())
#define VALA_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_PROPERTY, ValaProperty))
#define VALA_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_PROPERTY, ValaPropertyClass))
#define VALA_IS_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_PROPERTY))
#define VALA_IS_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_PROPERTY))
#define VALA_PROPERTY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_PROPERTY, ValaPropertyClass))

typedef struct _ValaProperty ValaProperty;
typedef struct _ValaPropertyClass ValaPropertyClass;

#define VALA_TYPE_SIGNAL (vala_signal_get_type ())
#define VALA_SIGNAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SIGNAL, ValaSignal))
#define VALA_SIGNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SIGNAL, ValaSignalClass))
#define VALA_IS_SIGNAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SIGNAL))
#define VALA_IS_SIGNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SIGNAL))
#define VALA_SIGNAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SIGNAL, ValaSignalClass))

typedef struct _ValaSignal ValaSignal;
typedef struct _ValaSignalClass ValaSignalClass;

#define VALA_TYPE_CONSTRUCTOR (vala_constructor_get_type ())
#define VALA_CONSTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONSTRUCTOR, ValaConstructor))
#define VALA_CONSTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONSTRUCTOR, ValaConstructorClass))
#define VALA_IS_CONSTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONSTRUCTOR))
#define VALA_IS_CONSTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONSTRUCTOR))
#define VALA_CONSTRUCTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONSTRUCTOR, ValaConstructorClass))

typedef struct _ValaConstructor ValaConstructor;
typedef struct _ValaConstructorClass ValaConstructorClass;

#define VALA_TYPE_DESTRUCTOR (vala_destructor_get_type ())
#define VALA_DESTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DESTRUCTOR, ValaDestructor))
#define VALA_DESTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DESTRUCTOR, ValaDestructorClass))
#define VALA_IS_DESTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DESTRUCTOR))
#define VALA_IS_DESTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DESTRUCTOR))
#define VALA_DESTRUCTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DESTRUCTOR, ValaDestructorClass))

typedef struct _ValaDestructor ValaDestructor;
typedef struct _ValaDestructorClass ValaDestructorClass;

#define VALA_TYPE_LOCKABLE (vala_lockable_get_type ())
#define VALA_LOCKABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LOCKABLE, ValaLockable))
#define VALA_IS_LOCKABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LOCKABLE))
#define VALA_LOCKABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), VALA_TYPE_LOCKABLE, ValaLockableIface))

typedef struct _ValaLockable ValaLockable;
typedef struct _ValaLockableIface ValaLockableIface;
typedef struct _ValaSignalPrivate ValaSignalPrivate;

#define VALA_TYPE_PARAMETER (vala_parameter_get_type ())
#define VALA_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_PARAMETER, ValaParameter))
#define VALA_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_PARAMETER, ValaParameterClass))
#define VALA_IS_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_PARAMETER))
#define VALA_IS_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_PARAMETER))
#define VALA_PARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_PARAMETER, ValaParameterClass))

typedef struct _ValaParameter ValaParameter;
typedef struct _ValaParameterClass ValaParameterClass;

#define VALA_TYPE_BLOCK (vala_block_get_type ())
#define VALA_BLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_BLOCK, ValaBlock))
#define VALA_BLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_BLOCK, ValaBlockClass))
#define VALA_IS_BLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_BLOCK))
#define VALA_IS_BLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_BLOCK))
#define VALA_BLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_BLOCK, ValaBlockClass))

typedef struct _ValaBlock ValaBlock;
typedef struct _ValaBlockClass ValaBlockClass;
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))

#define VALA_TYPE_SOURCE_REFERENCE (vala_source_reference_get_type ())
#define VALA_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReference))
#define VALA_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))
#define VALA_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))

typedef struct _ValaSourceReference ValaSourceReference;
typedef struct _ValaSourceReferenceClass ValaSourceReferenceClass;

#define VALA_TYPE_COMMENT (vala_comment_get_type ())
#define VALA_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_COMMENT, ValaComment))
#define VALA_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_COMMENT, ValaCommentClass))
#define VALA_IS_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_COMMENT))
#define VALA_IS_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_COMMENT))
#define VALA_COMMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_COMMENT, ValaCommentClass))

typedef struct _ValaComment ValaComment;
typedef struct _ValaCommentClass ValaCommentClass;

#define VALA_TYPE_SCOPE (vala_scope_get_type ())
#define VALA_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SCOPE, ValaScope))
#define VALA_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SCOPE, ValaScopeClass))
#define VALA_IS_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SCOPE))
#define VALA_IS_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SCOPE))
#define VALA_SCOPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SCOPE, ValaScopeClass))

typedef struct _ValaScope ValaScope;
typedef struct _ValaScopeClass ValaScopeClass;

#define VALA_TYPE_MEMBER_ACCESS (vala_member_access_get_type ())
#define VALA_MEMBER_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess))
#define VALA_MEMBER_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_MEMBER_ACCESS, ValaMemberAccessClass))
#define VALA_IS_MEMBER_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_MEMBER_ACCESS))
#define VALA_IS_MEMBER_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_MEMBER_ACCESS))
#define VALA_MEMBER_ACCESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_MEMBER_ACCESS, ValaMemberAccessClass))

typedef struct _ValaMemberAccess ValaMemberAccess;
typedef struct _ValaMemberAccessClass ValaMemberAccessClass;

#define VALA_TYPE_SYMBOL_ACCESSIBILITY (vala_symbol_accessibility_get_type ())

#define VALA_TYPE_GENERIC_TYPE (vala_generic_type_get_type ())
#define VALA_GENERIC_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GENERIC_TYPE, ValaGenericType))
#define VALA_GENERIC_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GENERIC_TYPE, ValaGenericTypeClass))
#define VALA_IS_GENERIC_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GENERIC_TYPE))
#define VALA_IS_GENERIC_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GENERIC_TYPE))
#define VALA_GENERIC_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GENERIC_TYPE, ValaGenericTypeClass))

typedef struct _ValaGenericType ValaGenericType;
typedef struct _ValaGenericTypeClass ValaGenericTypeClass;

#define VALA_TYPE_TYPEPARAMETER (vala_typeparameter_get_type ())
#define VALA_TYPEPARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPEPARAMETER, ValaTypeParameter))
#define VALA_TYPEPARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPEPARAMETER, ValaTypeParameterClass))
#define VALA_IS_TYPEPARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPEPARAMETER))
#define VALA_IS_TYPEPARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPEPARAMETER))
#define VALA_TYPEPARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPEPARAMETER, ValaTypeParameterClass))

typedef struct _ValaTypeParameter ValaTypeParameter;
typedef struct _ValaTypeParameterClass ValaTypeParameterClass;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaCodeNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCodeNodePrivate * priv;
	GList* attributes;
};

struct _ValaCodeNodeClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCodeNode *self);
	void (*accept) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	void (*accept_children) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	gboolean (*check) (ValaCodeNode* self, ValaCodeContext* context);
	void (*emit) (ValaCodeNode* self, ValaCodeGenerator* codegen);
	void (*replace_type) (ValaCodeNode* self, ValaDataType* old_type, ValaDataType* new_type);
	void (*replace_expression) (ValaCodeNode* self, ValaExpression* old_node, ValaExpression* new_node);
	gchar* (*to_string) (ValaCodeNode* self);
	void (*get_defined_variables) (ValaCodeNode* self, ValaCollection* collection);
	void (*get_used_variables) (ValaCodeNode* self, ValaCollection* collection);
};

struct _ValaSymbol {
	ValaCodeNode parent_instance;
	ValaSymbolPrivate * priv;
};

struct _ValaSymbolClass {
	ValaCodeNodeClass parent_class;
	gboolean (*is_instance_member) (ValaSymbol* self);
	gboolean (*is_class_member) (ValaSymbol* self);
	void (*add_namespace) (ValaSymbol* self, ValaNamespace* ns);
	void (*add_class) (ValaSymbol* self, ValaClass* cl);
	void (*add_interface) (ValaSymbol* self, ValaInterface* iface);
	void (*add_struct) (ValaSymbol* self, ValaStruct* st);
	void (*add_enum) (ValaSymbol* self, ValaEnum* en);
	void (*add_error_domain) (ValaSymbol* self, ValaErrorDomain* edomain);
	void (*add_delegate) (ValaSymbol* self, ValaDelegate* d);
	void (*add_constant) (ValaSymbol* self, ValaConstant* constant);
	void (*add_field) (ValaSymbol* self, ValaField* f);
	void (*add_method) (ValaSymbol* self, ValaMethod* m);
	void (*add_property) (ValaSymbol* self, ValaProperty* prop);
	void (*add_signal) (ValaSymbol* self, ValaSignal* sig);
	void (*add_constructor) (ValaSymbol* self, ValaConstructor* c);
	void (*add_destructor) (ValaSymbol* self, ValaDestructor* d);
};

struct _ValaLockableIface {
	GTypeInterface parent_iface;
	gboolean (*get_lock_used) (ValaLockable* self);
	void (*set_lock_used) (ValaLockable* self, gboolean used);
};

struct _ValaSignal {
	ValaSymbol parent_instance;
	ValaSignalPrivate * priv;
};

struct _ValaSignalClass {
	ValaSymbolClass parent_class;
};

struct _ValaSignalPrivate {
	gboolean _is_virtual;
	ValaList* parameters;
	ValaMethod* _default_handler;
	gboolean lock_used;
	ValaDataType* _return_type;
	ValaBlock* _body;
};

typedef enum  {
	VALA_SYMBOL_ACCESSIBILITY_PRIVATE,
	VALA_SYMBOL_ACCESSIBILITY_INTERNAL,
	VALA_SYMBOL_ACCESSIBILITY_PROTECTED,
	VALA_SYMBOL_ACCESSIBILITY_PUBLIC
} ValaSymbolAccessibility;


static gpointer vala_signal_parent_class = NULL;
static ValaLockableIface* vala_signal_vala_lockable_parent_iface = NULL;

gpointer vala_code_node_ref (gpointer instance);
void vala_code_node_unref (gpointer instance);
GParamSpec* vala_param_spec_code_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_node (GValue* value, gpointer v_object);
void vala_value_take_code_node (GValue* value, gpointer v_object);
gpointer vala_value_get_code_node (const GValue* value);
GType vala_code_node_get_type (void) G_GNUC_CONST;
gpointer vala_code_visitor_ref (gpointer instance);
void vala_code_visitor_unref (gpointer instance);
GParamSpec* vala_param_spec_code_visitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_visitor (GValue* value, gpointer v_object);
void vala_value_take_code_visitor (GValue* value, gpointer v_object);
gpointer vala_value_get_code_visitor (const GValue* value);
GType vala_code_visitor_get_type (void) G_GNUC_CONST;
gpointer vala_code_context_ref (gpointer instance);
void vala_code_context_unref (gpointer instance);
GParamSpec* vala_param_spec_code_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_context (GValue* value, gpointer v_object);
void vala_value_take_code_context (GValue* value, gpointer v_object);
gpointer vala_value_get_code_context (const GValue* value);
GType vala_code_context_get_type (void) G_GNUC_CONST;
GType vala_code_generator_get_type (void) G_GNUC_CONST;
GType vala_data_type_get_type (void) G_GNUC_CONST;
GType vala_expression_get_type (void) G_GNUC_CONST;
GType vala_symbol_get_type (void) G_GNUC_CONST;
GType vala_variable_get_type (void) G_GNUC_CONST;
GType vala_attribute_get_type (void) G_GNUC_CONST;
GType vala_namespace_get_type (void) G_GNUC_CONST;
GType vala_typesymbol_get_type (void) G_GNUC_CONST;
GType vala_object_type_symbol_get_type (void) G_GNUC_CONST;
GType vala_class_get_type (void) G_GNUC_CONST;
GType vala_interface_get_type (void) G_GNUC_CONST;
GType vala_struct_get_type (void) G_GNUC_CONST;
GType vala_enum_get_type (void) G_GNUC_CONST;
GType vala_error_domain_get_type (void) G_GNUC_CONST;
GType vala_delegate_get_type (void) G_GNUC_CONST;
GType vala_constant_get_type (void) G_GNUC_CONST;
GType vala_field_get_type (void) G_GNUC_CONST;
GType vala_subroutine_get_type (void) G_GNUC_CONST;
GType vala_method_get_type (void) G_GNUC_CONST;
GType vala_property_get_type (void) G_GNUC_CONST;
GType vala_signal_get_type (void) G_GNUC_CONST;
GType vala_constructor_get_type (void) G_GNUC_CONST;
GType vala_destructor_get_type (void) G_GNUC_CONST;
GType vala_lockable_get_type (void) G_GNUC_CONST;
GType vala_parameter_get_type (void) G_GNUC_CONST;
GType vala_block_get_type (void) G_GNUC_CONST;
#define VALA_SIGNAL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_SIGNAL, ValaSignalPrivate))
enum  {
	VALA_SIGNAL_DUMMY_PROPERTY
};
gpointer vala_source_reference_ref (gpointer instance);
void vala_source_reference_unref (gpointer instance);
GParamSpec* vala_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_reference (GValue* value, gpointer v_object);
void vala_value_take_source_reference (GValue* value, gpointer v_object);
gpointer vala_value_get_source_reference (const GValue* value);
GType vala_source_reference_get_type (void) G_GNUC_CONST;
gpointer vala_comment_ref (gpointer instance);
void vala_comment_unref (gpointer instance);
GParamSpec* vala_param_spec_comment (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_comment (GValue* value, gpointer v_object);
void vala_value_take_comment (GValue* value, gpointer v_object);
gpointer vala_value_get_comment (const GValue* value);
GType vala_comment_get_type (void) G_GNUC_CONST;
ValaSignal* vala_signal_new (const gchar* name, ValaDataType* return_type, ValaSourceReference* source_reference, ValaComment* comment);
ValaSignal* vala_signal_construct (GType object_type, const gchar* name, ValaDataType* return_type, ValaSourceReference* source_reference, ValaComment* comment);
ValaSymbol* vala_symbol_construct (GType object_type, const gchar* name, ValaSourceReference* source_reference, ValaComment* comment);
void vala_signal_set_return_type (ValaSignal* self, ValaDataType* value);
void vala_signal_add_parameter (ValaSignal* self, ValaParameter* param);
gpointer vala_scope_ref (gpointer instance);
void vala_scope_unref (gpointer instance);
GParamSpec* vala_param_spec_scope (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_scope (GValue* value, gpointer v_object);
void vala_value_take_scope (GValue* value, gpointer v_object);
gpointer vala_value_get_scope (const GValue* value);
GType vala_scope_get_type (void) G_GNUC_CONST;
ValaScope* vala_symbol_get_scope (ValaSymbol* self);
void vala_scope_add (ValaScope* self, const gchar* name, ValaSymbol* sym);
const gchar* vala_symbol_get_name (ValaSymbol* self);
ValaList* vala_signal_get_parameters (ValaSignal* self);
ValaDelegate* vala_signal_get_delegate (ValaSignal* self, ValaDataType* sender_type, ValaCodeNode* node_reference);
ValaDataType* vala_signal_get_return_type (ValaSignal* self);
GType vala_member_access_get_type (void) G_GNUC_CONST;
ValaDataType* vala_data_type_get_actual_type (ValaDataType* self, ValaDataType* derived_instance_type, ValaMemberAccess* method_access, ValaCodeNode* node_reference);
ValaDelegate* vala_delegate_new (const gchar* name, ValaDataType* return_type, ValaSourceReference* source_reference, ValaComment* comment);
ValaDelegate* vala_delegate_construct (GType object_type, const gchar* name, ValaDataType* return_type, ValaSourceReference* source_reference, ValaComment* comment);
GType vala_symbol_accessibility_get_type (void) G_GNUC_CONST;
void vala_symbol_set_access (ValaSymbol* self, ValaSymbolAccessibility value);
void vala_symbol_set_owner (ValaSymbol* self, ValaScope* value);
ValaDataType* vala_data_type_copy (ValaDataType* self);
void vala_data_type_set_value_owned (ValaDataType* self, gboolean value);
void vala_data_type_set_nullable (ValaDataType* self, gboolean value);
void vala_delegate_set_sender_type (ValaDelegate* self, ValaDataType* value);
ValaParameter* vala_parameter_copy (ValaParameter* self);
ValaDataType* vala_variable_get_variable_type (ValaVariable* self);
void vala_variable_set_variable_type (ValaVariable* self, ValaDataType* value);
void vala_delegate_add_parameter (ValaDelegate* self, ValaParameter* param);
GType vala_generic_type_get_type (void) G_GNUC_CONST;
ValaSymbol* vala_symbol_get_parent_symbol (ValaSymbol* self);
GType vala_typeparameter_get_type (void) G_GNUC_CONST;
ValaList* vala_object_type_symbol_get_type_parameters (ValaObjectTypeSymbol* self);
void vala_delegate_add_type_parameter (ValaDelegate* self, ValaTypeParameter* p);
ValaSourceReference* vala_code_node_get_source_reference (ValaCodeNode* self);
ValaTypeParameter* vala_typeparameter_new (const gchar* name, ValaSourceReference* source_reference);
ValaTypeParameter* vala_typeparameter_construct (GType object_type, const gchar* name, ValaSourceReference* source_reference);
ValaList* vala_delegate_get_parameters (ValaDelegate* self);
ValaList* vala_delegate_get_type_parameters (ValaDelegate* self);
gint vala_typesymbol_get_type_parameter_index (ValaTypeSymbol* self, const gchar* name);
ValaTypeParameter* vala_data_type_get_type_parameter (ValaDataType* self);
void vala_data_type_set_type_parameter (ValaDataType* self, ValaTypeParameter* value);
static void vala_signal_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
void vala_code_visitor_visit_signal (ValaCodeVisitor* self, ValaSignal* sig);
static void vala_signal_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
void vala_code_node_accept (ValaCodeNode* self, ValaCodeVisitor* visitor);
ValaMethod* vala_signal_get_default_handler (ValaSignal* self);
ValaBlock* vala_signal_get_body (ValaSignal* self);
static gboolean vala_signal_real_get_lock_used (ValaLockable* base);
static void vala_signal_real_set_lock_used (ValaLockable* base, gboolean used);
static void vala_signal_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type);
static gboolean vala_signal_real_check (ValaCodeNode* base, ValaCodeContext* context);
gboolean vala_code_node_get_checked (ValaCodeNode* self);
gboolean vala_code_node_get_error (ValaCodeNode* self);
void vala_code_node_set_checked (ValaCodeNode* self, gboolean value);
gboolean vala_code_node_check (ValaCodeNode* self, ValaCodeContext* context);
gboolean vala_signal_get_is_virtual (ValaSignal* self);
void vala_report_error (ValaSourceReference* source, const gchar* message);
ValaMethod* vala_method_new (const gchar* name, ValaDataType* return_type, ValaSourceReference* source_reference, ValaComment* comment);
ValaMethod* vala_method_construct (GType object_type, const gchar* name, ValaDataType* return_type, ValaSourceReference* source_reference, ValaComment* comment);
static void vala_signal_set_default_handler (ValaSignal* self, ValaMethod* value);
ValaScope* vala_symbol_get_owner (ValaSymbol* self);
ValaSymbolAccessibility vala_symbol_get_access (ValaSymbol* self);
gboolean vala_symbol_get_external (ValaSymbol* self);
void vala_symbol_set_external (ValaSymbol* self, gboolean value);
gboolean vala_symbol_get_hides (ValaSymbol* self);
void vala_symbol_set_hides (ValaSymbol* self, gboolean value);
void vala_method_set_is_virtual (ValaMethod* self, gboolean value);
void vala_method_set_signal_reference (ValaMethod* self, ValaSignal* value);
void vala_subroutine_set_body (ValaSubroutine* self, ValaBlock* value);
void vala_method_add_parameter (ValaMethod* self, ValaParameter* param);
void vala_object_type_symbol_add_hidden_method (ValaObjectTypeSymbol* self, ValaMethod* m);
gboolean vala_symbol_get_external_package (ValaSymbol* self);
ValaSymbol* vala_symbol_get_hidden_member (ValaSymbol* self);
void vala_report_warning (ValaSourceReference* source, const gchar* message);
gchar* vala_symbol_get_full_name (ValaSymbol* self);
void vala_code_node_set_parent_node (ValaCodeNode* self, ValaCodeNode* value);
void vala_signal_set_body (ValaSignal* self, ValaBlock* value);
void vala_signal_set_is_virtual (ValaSignal* self, gboolean value);
static void vala_signal_finalize (ValaCodeNode* obj);


/**
 * Creates a new signal.
 *
 * @param name        signal name
 * @param return_type signal return type
 * @param source      reference to source code
 * @return            newly created signal
 */
ValaSignal* vala_signal_construct (GType object_type, const gchar* name, ValaDataType* return_type, ValaSourceReference* source_reference, ValaComment* comment) {
	ValaSignal* self = NULL;
	const gchar* _tmp0_;
	ValaSourceReference* _tmp1_;
	ValaComment* _tmp2_;
	ValaDataType* _tmp3_;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (return_type != NULL, NULL);
	_tmp0_ = name;
	_tmp1_ = source_reference;
	_tmp2_ = comment;
	self = (ValaSignal*) vala_symbol_construct (object_type, _tmp0_, _tmp1_, _tmp2_);
	_tmp3_ = return_type;
	vala_signal_set_return_type (self, _tmp3_);
	return self;
}


ValaSignal* vala_signal_new (const gchar* name, ValaDataType* return_type, ValaSourceReference* source_reference, ValaComment* comment) {
	return vala_signal_construct (VALA_TYPE_SIGNAL, name, return_type, source_reference, comment);
}


/**
 * Appends parameter to signal handler.
 *
 * @param param a formal parameter
 */
void vala_signal_add_parameter (ValaSignal* self, ValaParameter* param) {
	ValaList* _tmp0_;
	ValaParameter* _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaParameter* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	ValaParameter* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (param != NULL);
	_tmp0_ = self->priv->parameters;
	_tmp1_ = param;
	vala_collection_add ((ValaCollection*) _tmp0_, _tmp1_);
	_tmp2_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = param;
	_tmp5_ = vala_symbol_get_name ((ValaSymbol*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = param;
	vala_scope_add (_tmp3_, _tmp6_, (ValaSymbol*) _tmp7_);
}


static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList* vala_signal_get_parameters (ValaSignal* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->parameters;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Returns generated delegate to be used for signal handlers.
 *
 * @return delegate
 */
static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


ValaDelegate* vala_signal_get_delegate (ValaSignal* self, ValaDataType* sender_type, ValaCodeNode* node_reference) {
	ValaDelegate* result = NULL;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaCodeNode* _tmp3_;
	ValaDataType* _tmp4_ = NULL;
	ValaDataType* actual_return_type;
	ValaDataType* _tmp5_;
	ValaDelegate* _tmp6_;
	ValaDelegate* generated_delegate;
	ValaDelegate* _tmp7_;
	ValaDelegate* _tmp8_;
	ValaScope* _tmp9_;
	ValaScope* _tmp10_;
	ValaDataType* _tmp11_;
	ValaDataType* _tmp12_ = NULL;
	ValaDataType* sender_param_type;
	ValaDataType* _tmp13_;
	ValaDataType* _tmp14_;
	ValaDelegate* _tmp15_;
	ValaDataType* _tmp16_;
	gboolean is_generic;
	gboolean _tmp43_;
	ValaScope* _tmp98_;
	ValaScope* _tmp99_;
	ValaDelegate* _tmp100_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sender_type != NULL, NULL);
	g_return_val_if_fail (node_reference != NULL, NULL);
	_tmp0_ = vala_signal_get_return_type (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = sender_type;
	_tmp3_ = node_reference;
	_tmp4_ = vala_data_type_get_actual_type (_tmp1_, _tmp2_, NULL, _tmp3_);
	actual_return_type = _tmp4_;
	_tmp5_ = actual_return_type;
	_tmp6_ = vala_delegate_new (NULL, _tmp5_, NULL, NULL);
	generated_delegate = _tmp6_;
	_tmp7_ = generated_delegate;
	vala_symbol_set_access ((ValaSymbol*) _tmp7_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp8_ = generated_delegate;
	_tmp9_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp10_ = _tmp9_;
	vala_symbol_set_owner ((ValaSymbol*) _tmp8_, _tmp10_);
	_tmp11_ = sender_type;
	_tmp12_ = vala_data_type_copy (_tmp11_);
	sender_param_type = _tmp12_;
	_tmp13_ = sender_param_type;
	vala_data_type_set_value_owned (_tmp13_, FALSE);
	_tmp14_ = sender_param_type;
	vala_data_type_set_nullable (_tmp14_, FALSE);
	_tmp15_ = generated_delegate;
	_tmp16_ = sender_param_type;
	vala_delegate_set_sender_type (_tmp15_, _tmp16_);
	is_generic = FALSE;
	{
		ValaList* _tmp17_;
		ValaList* _tmp18_;
		ValaList* _param_list;
		ValaList* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		gint _param_size;
		gint _param_index;
		_tmp17_ = self->priv->parameters;
		_tmp18_ = _vala_iterable_ref0 (_tmp17_);
		_param_list = _tmp18_;
		_tmp19_ = _param_list;
		_tmp20_ = vala_collection_get_size ((ValaCollection*) _tmp19_);
		_tmp21_ = _tmp20_;
		_param_size = _tmp21_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp22_;
			gint _tmp23_;
			gint _tmp24_;
			ValaList* _tmp25_;
			gint _tmp26_;
			gpointer _tmp27_ = NULL;
			ValaParameter* param;
			ValaParameter* _tmp28_;
			ValaParameter* _tmp29_ = NULL;
			ValaParameter* actual_param;
			ValaParameter* _tmp30_;
			ValaParameter* _tmp31_;
			ValaDataType* _tmp32_;
			ValaDataType* _tmp33_;
			ValaDataType* _tmp34_;
			ValaCodeNode* _tmp35_;
			ValaDataType* _tmp36_ = NULL;
			ValaDataType* _tmp37_;
			ValaDelegate* _tmp38_;
			ValaParameter* _tmp39_;
			ValaParameter* _tmp40_;
			ValaDataType* _tmp41_;
			ValaDataType* _tmp42_;
			_tmp22_ = _param_index;
			_param_index = _tmp22_ + 1;
			_tmp23_ = _param_index;
			_tmp24_ = _param_size;
			if (!(_tmp23_ < _tmp24_)) {
				break;
			}
			_tmp25_ = _param_list;
			_tmp26_ = _param_index;
			_tmp27_ = vala_list_get (_tmp25_, _tmp26_);
			param = (ValaParameter*) _tmp27_;
			_tmp28_ = param;
			_tmp29_ = vala_parameter_copy (_tmp28_);
			actual_param = _tmp29_;
			_tmp30_ = actual_param;
			_tmp31_ = actual_param;
			_tmp32_ = vala_variable_get_variable_type ((ValaVariable*) _tmp31_);
			_tmp33_ = _tmp32_;
			_tmp34_ = sender_type;
			_tmp35_ = node_reference;
			_tmp36_ = vala_data_type_get_actual_type (_tmp33_, _tmp34_, NULL, _tmp35_);
			_tmp37_ = _tmp36_;
			vala_variable_set_variable_type ((ValaVariable*) _tmp30_, _tmp37_);
			_vala_code_node_unref0 (_tmp37_);
			_tmp38_ = generated_delegate;
			_tmp39_ = actual_param;
			vala_delegate_add_parameter (_tmp38_, _tmp39_);
			_tmp40_ = actual_param;
			_tmp41_ = vala_variable_get_variable_type ((ValaVariable*) _tmp40_);
			_tmp42_ = _tmp41_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp42_, VALA_TYPE_GENERIC_TYPE)) {
				is_generic = TRUE;
			}
			_vala_code_node_unref0 (actual_param);
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp43_ = is_generic;
	if (_tmp43_) {
		ValaSymbol* _tmp44_;
		ValaSymbol* _tmp45_;
		ValaObjectTypeSymbol* _tmp46_;
		ValaObjectTypeSymbol* cl;
		_tmp44_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp45_ = _tmp44_;
		_tmp46_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
		cl = _tmp46_;
		{
			ValaObjectTypeSymbol* _tmp47_;
			ValaList* _tmp48_ = NULL;
			ValaList* _type_param_list;
			ValaList* _tmp49_;
			gint _tmp50_;
			gint _tmp51_;
			gint _type_param_size;
			gint _type_param_index;
			_tmp47_ = cl;
			_tmp48_ = vala_object_type_symbol_get_type_parameters (_tmp47_);
			_type_param_list = _tmp48_;
			_tmp49_ = _type_param_list;
			_tmp50_ = vala_collection_get_size ((ValaCollection*) _tmp49_);
			_tmp51_ = _tmp50_;
			_type_param_size = _tmp51_;
			_type_param_index = -1;
			while (TRUE) {
				gint _tmp52_;
				gint _tmp53_;
				gint _tmp54_;
				ValaList* _tmp55_;
				gint _tmp56_;
				gpointer _tmp57_ = NULL;
				ValaTypeParameter* type_param;
				ValaDelegate* _tmp58_;
				ValaTypeParameter* _tmp59_;
				const gchar* _tmp60_;
				const gchar* _tmp61_;
				ValaTypeParameter* _tmp62_;
				ValaSourceReference* _tmp63_;
				ValaSourceReference* _tmp64_;
				ValaTypeParameter* _tmp65_;
				ValaTypeParameter* _tmp66_;
				_tmp52_ = _type_param_index;
				_type_param_index = _tmp52_ + 1;
				_tmp53_ = _type_param_index;
				_tmp54_ = _type_param_size;
				if (!(_tmp53_ < _tmp54_)) {
					break;
				}
				_tmp55_ = _type_param_list;
				_tmp56_ = _type_param_index;
				_tmp57_ = vala_list_get (_tmp55_, _tmp56_);
				type_param = (ValaTypeParameter*) _tmp57_;
				_tmp58_ = generated_delegate;
				_tmp59_ = type_param;
				_tmp60_ = vala_symbol_get_name ((ValaSymbol*) _tmp59_);
				_tmp61_ = _tmp60_;
				_tmp62_ = type_param;
				_tmp63_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp62_);
				_tmp64_ = _tmp63_;
				_tmp65_ = vala_typeparameter_new (_tmp61_, _tmp64_);
				_tmp66_ = _tmp65_;
				vala_delegate_add_type_parameter (_tmp58_, _tmp66_);
				_vala_code_node_unref0 (_tmp66_);
				_vala_code_node_unref0 (type_param);
			}
			_vala_iterable_unref0 (_type_param_list);
		}
		{
			ValaDelegate* _tmp67_;
			ValaList* _tmp68_ = NULL;
			ValaList* _param_list;
			ValaList* _tmp69_;
			gint _tmp70_;
			gint _tmp71_;
			gint _param_size;
			gint _param_index;
			_tmp67_ = generated_delegate;
			_tmp68_ = vala_delegate_get_parameters (_tmp67_);
			_param_list = _tmp68_;
			_tmp69_ = _param_list;
			_tmp70_ = vala_collection_get_size ((ValaCollection*) _tmp69_);
			_tmp71_ = _tmp70_;
			_param_size = _tmp71_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp72_;
				gint _tmp73_;
				gint _tmp74_;
				ValaList* _tmp75_;
				gint _tmp76_;
				gpointer _tmp77_ = NULL;
				ValaParameter* param;
				ValaParameter* _tmp78_;
				ValaDataType* _tmp79_;
				ValaDataType* _tmp80_;
				_tmp72_ = _param_index;
				_param_index = _tmp72_ + 1;
				_tmp73_ = _param_index;
				_tmp74_ = _param_size;
				if (!(_tmp73_ < _tmp74_)) {
					break;
				}
				_tmp75_ = _param_list;
				_tmp76_ = _param_index;
				_tmp77_ = vala_list_get (_tmp75_, _tmp76_);
				param = (ValaParameter*) _tmp77_;
				_tmp78_ = param;
				_tmp79_ = vala_variable_get_variable_type ((ValaVariable*) _tmp78_);
				_tmp80_ = _tmp79_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp80_, VALA_TYPE_GENERIC_TYPE)) {
					ValaParameter* _tmp81_;
					ValaDataType* _tmp82_;
					ValaDataType* _tmp83_;
					ValaDelegate* _tmp84_;
					ValaList* _tmp85_ = NULL;
					ValaList* _tmp86_;
					ValaDelegate* _tmp87_;
					ValaParameter* _tmp88_;
					ValaDataType* _tmp89_;
					ValaDataType* _tmp90_;
					ValaTypeParameter* _tmp91_;
					ValaTypeParameter* _tmp92_;
					const gchar* _tmp93_;
					const gchar* _tmp94_;
					gint _tmp95_ = 0;
					gpointer _tmp96_ = NULL;
					ValaTypeParameter* _tmp97_;
					_tmp81_ = param;
					_tmp82_ = vala_variable_get_variable_type ((ValaVariable*) _tmp81_);
					_tmp83_ = _tmp82_;
					_tmp84_ = generated_delegate;
					_tmp85_ = vala_delegate_get_type_parameters (_tmp84_);
					_tmp86_ = _tmp85_;
					_tmp87_ = generated_delegate;
					_tmp88_ = param;
					_tmp89_ = vala_variable_get_variable_type ((ValaVariable*) _tmp88_);
					_tmp90_ = _tmp89_;
					_tmp91_ = vala_data_type_get_type_parameter (_tmp90_);
					_tmp92_ = _tmp91_;
					_tmp93_ = vala_symbol_get_name ((ValaSymbol*) _tmp92_);
					_tmp94_ = _tmp93_;
					_tmp95_ = vala_typesymbol_get_type_parameter_index ((ValaTypeSymbol*) _tmp87_, _tmp94_);
					_tmp96_ = vala_list_get (_tmp86_, _tmp95_);
					_tmp97_ = (ValaTypeParameter*) _tmp96_;
					vala_data_type_set_type_parameter (_tmp83_, _tmp97_);
					_vala_code_node_unref0 (_tmp97_);
					_vala_iterable_unref0 (_tmp86_);
				}
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		_vala_code_node_unref0 (cl);
	}
	_tmp98_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp99_ = _tmp98_;
	_tmp100_ = generated_delegate;
	vala_scope_add (_tmp99_, NULL, (ValaSymbol*) _tmp100_);
	result = generated_delegate;
	_vala_code_node_unref0 (sender_param_type);
	_vala_code_node_unref0 (actual_return_type);
	return result;
}


static void vala_signal_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaSignal * self;
	ValaCodeVisitor* _tmp0_;
	self = (ValaSignal*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = visitor;
	vala_code_visitor_visit_signal (_tmp0_, self);
}


static void vala_signal_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaSignal * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaCodeVisitor* _tmp2_;
	gboolean _tmp16_ = FALSE;
	ValaMethod* _tmp17_;
	gboolean _tmp20_;
	self = (ValaSignal*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_signal_get_return_type (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = visitor;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, _tmp2_);
	{
		ValaList* _tmp3_;
		ValaList* _tmp4_;
		ValaList* _param_list;
		ValaList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _param_size;
		gint _param_index;
		_tmp3_ = self->priv->parameters;
		_tmp4_ = _vala_iterable_ref0 (_tmp3_);
		_param_list = _tmp4_;
		_tmp5_ = _param_list;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_param_size = _tmp7_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			ValaList* _tmp11_;
			gint _tmp12_;
			gpointer _tmp13_ = NULL;
			ValaParameter* param;
			ValaParameter* _tmp14_;
			ValaCodeVisitor* _tmp15_;
			_tmp8_ = _param_index;
			_param_index = _tmp8_ + 1;
			_tmp9_ = _param_index;
			_tmp10_ = _param_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _param_list;
			_tmp12_ = _param_index;
			_tmp13_ = vala_list_get (_tmp11_, _tmp12_);
			param = (ValaParameter*) _tmp13_;
			_tmp14_ = param;
			_tmp15_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp14_, _tmp15_);
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp17_ = self->priv->_default_handler;
	if (_tmp17_ == NULL) {
		ValaBlock* _tmp18_;
		ValaBlock* _tmp19_;
		_tmp18_ = vala_signal_get_body (self);
		_tmp19_ = _tmp18_;
		_tmp16_ = _tmp19_ != NULL;
	} else {
		_tmp16_ = FALSE;
	}
	_tmp20_ = _tmp16_;
	if (_tmp20_) {
		ValaBlock* _tmp21_;
		ValaBlock* _tmp22_;
		ValaCodeVisitor* _tmp23_;
		_tmp21_ = vala_signal_get_body (self);
		_tmp22_ = _tmp21_;
		_tmp23_ = visitor;
		vala_code_node_accept ((ValaCodeNode*) _tmp22_, _tmp23_);
	} else {
		ValaMethod* _tmp24_;
		_tmp24_ = self->priv->_default_handler;
		if (_tmp24_ != NULL) {
			ValaMethod* _tmp25_;
			ValaCodeVisitor* _tmp26_;
			_tmp25_ = self->priv->_default_handler;
			_tmp26_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp25_, _tmp26_);
		}
	}
}


static gboolean vala_signal_real_get_lock_used (ValaLockable* base) {
	ValaSignal * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	self = (ValaSignal*) base;
	_tmp0_ = self->priv->lock_used;
	result = _tmp0_;
	return result;
}


static void vala_signal_real_set_lock_used (ValaLockable* base, gboolean used) {
	ValaSignal * self;
	gboolean _tmp0_;
	self = (ValaSignal*) base;
	_tmp0_ = used;
	self->priv->lock_used = _tmp0_;
}


static void vala_signal_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type) {
	ValaSignal * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	self = (ValaSignal*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_signal_get_return_type (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = old_type;
	if (_tmp1_ == _tmp2_) {
		ValaDataType* _tmp3_;
		_tmp3_ = new_type;
		vala_signal_set_return_type (self, _tmp3_);
	}
}


static gboolean vala_signal_real_check (ValaCodeNode* base, ValaCodeContext* context) {
	ValaSignal * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	ValaCodeContext* _tmp6_;
	gboolean _tmp20_ = FALSE;
	gboolean _tmp21_;
	gboolean _tmp24_;
	gboolean _tmp27_;
	gboolean _tmp73_ = FALSE;
	gboolean _tmp74_ = FALSE;
	gboolean _tmp75_;
	gboolean _tmp76_;
	gboolean _tmp79_;
	gboolean _tmp82_;
	gboolean _tmp93_;
	gboolean _tmp94_;
	self = (ValaSignal*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_signal_get_return_type (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = context;
	vala_code_node_check ((ValaCodeNode*) _tmp5_, _tmp6_);
	{
		ValaList* _tmp7_;
		ValaList* _tmp8_;
		ValaList* _param_list;
		ValaList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _param_size;
		gint _param_index;
		_tmp7_ = self->priv->parameters;
		_tmp8_ = _vala_iterable_ref0 (_tmp7_);
		_param_list = _tmp8_;
		_tmp9_ = _param_list;
		_tmp10_ = vala_collection_get_size ((ValaCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		_param_size = _tmp11_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			ValaList* _tmp15_;
			gint _tmp16_;
			gpointer _tmp17_ = NULL;
			ValaParameter* param;
			ValaParameter* _tmp18_;
			ValaCodeContext* _tmp19_;
			_tmp12_ = _param_index;
			_param_index = _tmp12_ + 1;
			_tmp13_ = _param_index;
			_tmp14_ = _param_size;
			if (!(_tmp13_ < _tmp14_)) {
				break;
			}
			_tmp15_ = _param_list;
			_tmp16_ = _param_index;
			_tmp17_ = vala_list_get (_tmp15_, _tmp16_);
			param = (ValaParameter*) _tmp17_;
			_tmp18_ = param;
			_tmp19_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp18_, _tmp19_);
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp21_ = self->priv->_is_virtual;
	if (!_tmp21_) {
		ValaBlock* _tmp22_;
		ValaBlock* _tmp23_;
		_tmp22_ = vala_signal_get_body (self);
		_tmp23_ = _tmp22_;
		_tmp20_ = _tmp23_ != NULL;
	} else {
		_tmp20_ = FALSE;
	}
	_tmp24_ = _tmp20_;
	if (_tmp24_) {
		ValaSourceReference* _tmp25_;
		ValaSourceReference* _tmp26_;
		_tmp25_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp26_ = _tmp25_;
		vala_report_error (_tmp26_, "Only virtual signals can have a default signal handler body");
	}
	_tmp27_ = self->priv->_is_virtual;
	if (_tmp27_) {
		const gchar* _tmp28_;
		const gchar* _tmp29_;
		ValaDataType* _tmp30_;
		ValaDataType* _tmp31_;
		ValaSourceReference* _tmp32_;
		ValaSourceReference* _tmp33_;
		ValaMethod* _tmp34_;
		ValaMethod* _tmp35_;
		ValaMethod* _tmp36_;
		ValaScope* _tmp37_;
		ValaScope* _tmp38_;
		ValaMethod* _tmp39_;
		ValaSymbolAccessibility _tmp40_;
		ValaSymbolAccessibility _tmp41_;
		ValaMethod* _tmp42_;
		gboolean _tmp43_;
		gboolean _tmp44_;
		ValaMethod* _tmp45_;
		gboolean _tmp46_;
		gboolean _tmp47_;
		ValaMethod* _tmp48_;
		ValaMethod* _tmp49_;
		ValaMethod* _tmp50_;
		ValaBlock* _tmp51_;
		ValaBlock* _tmp52_;
		ValaSymbol* _tmp66_;
		ValaSymbol* _tmp67_;
		ValaObjectTypeSymbol* _tmp68_;
		ValaObjectTypeSymbol* cl;
		ValaObjectTypeSymbol* _tmp69_;
		ValaMethod* _tmp70_;
		ValaMethod* _tmp71_;
		ValaCodeContext* _tmp72_;
		_tmp28_ = vala_symbol_get_name ((ValaSymbol*) self);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_signal_get_return_type (self);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_method_new (_tmp29_, _tmp31_, _tmp33_, NULL);
		_tmp35_ = _tmp34_;
		vala_signal_set_default_handler (self, _tmp35_);
		_vala_code_node_unref0 (_tmp35_);
		_tmp36_ = self->priv->_default_handler;
		_tmp37_ = vala_symbol_get_owner ((ValaSymbol*) self);
		_tmp38_ = _tmp37_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp36_, _tmp38_);
		_tmp39_ = self->priv->_default_handler;
		_tmp40_ = vala_symbol_get_access ((ValaSymbol*) self);
		_tmp41_ = _tmp40_;
		vala_symbol_set_access ((ValaSymbol*) _tmp39_, _tmp41_);
		_tmp42_ = self->priv->_default_handler;
		_tmp43_ = vala_symbol_get_external ((ValaSymbol*) self);
		_tmp44_ = _tmp43_;
		vala_symbol_set_external ((ValaSymbol*) _tmp42_, _tmp44_);
		_tmp45_ = self->priv->_default_handler;
		_tmp46_ = vala_symbol_get_hides ((ValaSymbol*) self);
		_tmp47_ = _tmp46_;
		vala_symbol_set_hides ((ValaSymbol*) _tmp45_, _tmp47_);
		_tmp48_ = self->priv->_default_handler;
		vala_method_set_is_virtual (_tmp48_, TRUE);
		_tmp49_ = self->priv->_default_handler;
		vala_method_set_signal_reference (_tmp49_, self);
		_tmp50_ = self->priv->_default_handler;
		_tmp51_ = vala_signal_get_body (self);
		_tmp52_ = _tmp51_;
		vala_subroutine_set_body ((ValaSubroutine*) _tmp50_, _tmp52_);
		{
			ValaList* _tmp53_;
			ValaList* _tmp54_;
			ValaList* _param_list;
			ValaList* _tmp55_;
			gint _tmp56_;
			gint _tmp57_;
			gint _param_size;
			gint _param_index;
			_tmp53_ = self->priv->parameters;
			_tmp54_ = _vala_iterable_ref0 (_tmp53_);
			_param_list = _tmp54_;
			_tmp55_ = _param_list;
			_tmp56_ = vala_collection_get_size ((ValaCollection*) _tmp55_);
			_tmp57_ = _tmp56_;
			_param_size = _tmp57_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp58_;
				gint _tmp59_;
				gint _tmp60_;
				ValaList* _tmp61_;
				gint _tmp62_;
				gpointer _tmp63_ = NULL;
				ValaParameter* param;
				ValaMethod* _tmp64_;
				ValaParameter* _tmp65_;
				_tmp58_ = _param_index;
				_param_index = _tmp58_ + 1;
				_tmp59_ = _param_index;
				_tmp60_ = _param_size;
				if (!(_tmp59_ < _tmp60_)) {
					break;
				}
				_tmp61_ = _param_list;
				_tmp62_ = _param_index;
				_tmp63_ = vala_list_get (_tmp61_, _tmp62_);
				param = (ValaParameter*) _tmp63_;
				_tmp64_ = self->priv->_default_handler;
				_tmp65_ = param;
				vala_method_add_parameter (_tmp64_, _tmp65_);
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		_tmp66_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp67_ = _tmp66_;
		_tmp68_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp67_, VALA_TYPE_OBJECT_TYPE_SYMBOL) ? ((ValaObjectTypeSymbol*) _tmp67_) : NULL);
		cl = _tmp68_;
		_tmp69_ = cl;
		_tmp70_ = self->priv->_default_handler;
		vala_object_type_symbol_add_hidden_method (_tmp69_, _tmp70_);
		_tmp71_ = self->priv->_default_handler;
		_tmp72_ = context;
		vala_code_node_check ((ValaCodeNode*) _tmp71_, _tmp72_);
		_vala_code_node_unref0 (cl);
	}
	_tmp75_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp76_ = _tmp75_;
	if (!_tmp76_) {
		gboolean _tmp77_;
		gboolean _tmp78_;
		_tmp77_ = vala_symbol_get_hides ((ValaSymbol*) self);
		_tmp78_ = _tmp77_;
		_tmp74_ = !_tmp78_;
	} else {
		_tmp74_ = FALSE;
	}
	_tmp79_ = _tmp74_;
	if (_tmp79_) {
		ValaSymbol* _tmp80_ = NULL;
		ValaSymbol* _tmp81_;
		_tmp80_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp81_ = _tmp80_;
		_tmp73_ = _tmp81_ != NULL;
		_vala_code_node_unref0 (_tmp81_);
	} else {
		_tmp73_ = FALSE;
	}
	_tmp82_ = _tmp73_;
	if (_tmp82_) {
		ValaSourceReference* _tmp83_;
		ValaSourceReference* _tmp84_;
		gchar* _tmp85_ = NULL;
		gchar* _tmp86_;
		ValaSymbol* _tmp87_ = NULL;
		ValaSymbol* _tmp88_;
		gchar* _tmp89_ = NULL;
		gchar* _tmp90_;
		gchar* _tmp91_ = NULL;
		gchar* _tmp92_;
		_tmp83_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp84_ = _tmp83_;
		_tmp85_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp86_ = _tmp85_;
		_tmp87_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp88_ = _tmp87_;
		_tmp89_ = vala_symbol_get_full_name (_tmp88_);
		_tmp90_ = _tmp89_;
		_tmp91_ = g_strdup_printf ("%s hides inherited signal `%s'. Use the `new' keyword if hiding was in" \
"tentional", _tmp86_, _tmp90_);
		_tmp92_ = _tmp91_;
		vala_report_warning (_tmp84_, _tmp92_);
		_g_free0 (_tmp92_);
		_g_free0 (_tmp90_);
		_vala_code_node_unref0 (_tmp88_);
		_g_free0 (_tmp86_);
	}
	_tmp93_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp94_ = _tmp93_;
	result = !_tmp94_;
	return result;
}


ValaDataType* vala_signal_get_return_type (ValaSignal* self) {
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_return_type;
	result = _tmp0_;
	return result;
}


void vala_signal_set_return_type (ValaSignal* self, ValaDataType* value) {
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_return_type);
	self->priv->_return_type = _tmp1_;
	_tmp2_ = self->priv->_return_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
}


ValaBlock* vala_signal_get_body (ValaSignal* self) {
	ValaBlock* result;
	ValaBlock* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_body;
	result = _tmp0_;
	return result;
}


void vala_signal_set_body (ValaSignal* self, ValaBlock* value) {
	ValaBlock* _tmp0_;
	ValaBlock* _tmp1_;
	ValaBlock* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_body);
	self->priv->_body = _tmp1_;
	_tmp2_ = self->priv->_body;
	if (_tmp2_ != NULL) {
		ValaBlock* _tmp3_;
		ValaScope* _tmp4_;
		ValaScope* _tmp5_;
		_tmp3_ = self->priv->_body;
		_tmp4_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp5_ = _tmp4_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp3_, _tmp5_);
	}
}


gboolean vala_signal_get_is_virtual (ValaSignal* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_virtual;
	result = _tmp0_;
	return result;
}


void vala_signal_set_is_virtual (ValaSignal* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_is_virtual = _tmp0_;
}


ValaMethod* vala_signal_get_default_handler (ValaSignal* self) {
	ValaMethod* result;
	ValaMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_default_handler;
	result = _tmp0_;
	return result;
}


static void vala_signal_set_default_handler (ValaSignal* self, ValaMethod* value) {
	ValaMethod* _tmp0_;
	ValaMethod* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_default_handler);
	self->priv->_default_handler = _tmp1_;
}


static void vala_signal_class_init (ValaSignalClass * klass) {
	vala_signal_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_signal_finalize;
	g_type_class_add_private (klass, sizeof (ValaSignalPrivate));
	VALA_CODE_NODE_CLASS (klass)->accept = vala_signal_real_accept;
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_signal_real_accept_children;
	VALA_CODE_NODE_CLASS (klass)->replace_type = vala_signal_real_replace_type;
	VALA_CODE_NODE_CLASS (klass)->check = vala_signal_real_check;
}


static void vala_signal_vala_lockable_interface_init (ValaLockableIface * iface) {
	vala_signal_vala_lockable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_lock_used = (gboolean (*)(ValaLockable*)) vala_signal_real_get_lock_used;
	iface->set_lock_used = (void (*)(ValaLockable*, gboolean)) vala_signal_real_set_lock_used;
}


static void vala_signal_instance_init (ValaSignal * self) {
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = VALA_SIGNAL_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, _tmp0_);
	self->priv->parameters = (ValaList*) _tmp1_;
	self->priv->lock_used = FALSE;
}


static void vala_signal_finalize (ValaCodeNode* obj) {
	ValaSignal * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_SIGNAL, ValaSignal);
	_vala_iterable_unref0 (self->priv->parameters);
	_vala_code_node_unref0 (self->priv->_default_handler);
	_vala_code_node_unref0 (self->priv->_return_type);
	_vala_code_node_unref0 (self->priv->_body);
	VALA_CODE_NODE_CLASS (vala_signal_parent_class)->finalize (obj);
}


/**
 * Represents an object signal. Signals enable objects to provide notifications.
 */
GType vala_signal_get_type (void) {
	static volatile gsize vala_signal_type_id__volatile = 0;
	if (g_once_init_enter (&vala_signal_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaSignalClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_signal_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaSignal), 0, (GInstanceInitFunc) vala_signal_instance_init, NULL };
		static const GInterfaceInfo vala_lockable_info = { (GInterfaceInitFunc) vala_signal_vala_lockable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType vala_signal_type_id;
		vala_signal_type_id = g_type_register_static (VALA_TYPE_SYMBOL, "ValaSignal", &g_define_type_info, 0);
		g_type_add_interface_static (vala_signal_type_id, VALA_TYPE_LOCKABLE, &vala_lockable_info);
		g_once_init_leave (&vala_signal_type_id__volatile, vala_signal_type_id);
	}
	return vala_signal_type_id__volatile;
}



