/* valaattributeprocessor.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <vala/valaattributeprocessor.h>




enum  {
	VALA_ATTRIBUTE_PROCESSOR_DUMMY_PROPERTY
};
static void vala_attribute_processor_real_visit_source_file (ValaCodeVisitor* base, ValaSourceFile* source_file);
static void vala_attribute_processor_real_visit_namespace (ValaCodeVisitor* base, ValaNamespace* ns);
static void vala_attribute_processor_real_visit_class (ValaCodeVisitor* base, ValaClass* cl);
static void vala_attribute_processor_real_visit_struct (ValaCodeVisitor* base, ValaStruct* st);
static void vala_attribute_processor_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface);
static void vala_attribute_processor_real_visit_enum (ValaCodeVisitor* base, ValaEnum* en);
static void vala_attribute_processor_real_visit_method (ValaCodeVisitor* base, ValaMethod* m);
static void vala_attribute_processor_real_visit_creation_method (ValaCodeVisitor* base, ValaCreationMethod* m);
static void vala_attribute_processor_real_visit_formal_parameter (ValaCodeVisitor* base, ValaFormalParameter* p);
static void vala_attribute_processor_real_visit_property (ValaCodeVisitor* base, ValaProperty* prop);
static void vala_attribute_processor_real_visit_delegate (ValaCodeVisitor* base, ValaDelegate* d);
static void vala_attribute_processor_real_visit_constant (ValaCodeVisitor* base, ValaConstant* c);
static void vala_attribute_processor_real_visit_field (ValaCodeVisitor* base, ValaField* f);
static void vala_attribute_processor_real_visit_signal (ValaCodeVisitor* base, ValaSignal* sig);
static gpointer vala_attribute_processor_parent_class = NULL;



/**
 * Process all attributes found in specified code context.
 *
 * @param context a code context
 */
void vala_attribute_processor_process (ValaAttributeProcessor* self, ValaCodeContext* context) {
	g_return_if_fail (VALA_IS_ATTRIBUTE_PROCESSOR (self));
	g_return_if_fail (context == NULL || VALA_IS_CODE_CONTEXT (context));
	vala_code_context_accept (context, VALA_CODE_VISITOR (self));
}


static void vala_attribute_processor_real_visit_source_file (ValaCodeVisitor* base, ValaSourceFile* source_file) {
	ValaAttributeProcessor * self;
	self = VALA_ATTRIBUTE_PROCESSOR (base);
	g_return_if_fail (source_file == NULL || VALA_IS_SOURCE_FILE (source_file));
	vala_source_file_accept_children (source_file, VALA_CODE_VISITOR (self));
}


static void vala_attribute_processor_real_visit_namespace (ValaCodeVisitor* base, ValaNamespace* ns) {
	ValaAttributeProcessor * self;
	self = VALA_ATTRIBUTE_PROCESSOR (base);
	g_return_if_fail (ns == NULL || VALA_IS_NAMESPACE (ns));
	vala_namespace_process_attributes (ns);
	{
		GeeCollection* ns_collection;
		GeeIterator* ns_it;
		ns_collection = vala_namespace_get_namespaces (ns);
		ns_it = gee_iterable_iterator (GEE_ITERABLE (ns_collection));
		while (gee_iterator_next (ns_it)) {
			ValaNamespace* ns;
			ns = ((ValaNamespace*) gee_iterator_get (ns_it));
			{
				vala_code_node_accept (VALA_CODE_NODE (ns), VALA_CODE_VISITOR (self));
				(ns == NULL ? NULL : (ns = (g_object_unref (ns), NULL)));
			}
		}
		(ns_collection == NULL ? NULL : (ns_collection = (g_object_unref (ns_collection), NULL)));
		(ns_it == NULL ? NULL : (ns_it = (g_object_unref (ns_it), NULL)));
	}
}


static void vala_attribute_processor_real_visit_class (ValaCodeVisitor* base, ValaClass* cl) {
	ValaAttributeProcessor * self;
	self = VALA_ATTRIBUTE_PROCESSOR (base);
	g_return_if_fail (cl == NULL || VALA_IS_CLASS (cl));
	vala_class_process_attributes (cl);
	vala_code_node_accept_children (VALA_CODE_NODE (cl), VALA_CODE_VISITOR (self));
}


static void vala_attribute_processor_real_visit_struct (ValaCodeVisitor* base, ValaStruct* st) {
	ValaAttributeProcessor * self;
	self = VALA_ATTRIBUTE_PROCESSOR (base);
	g_return_if_fail (st == NULL || VALA_IS_STRUCT (st));
	vala_struct_process_attributes (st);
	vala_code_node_accept_children (VALA_CODE_NODE (st), VALA_CODE_VISITOR (self));
}


static void vala_attribute_processor_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface) {
	ValaAttributeProcessor * self;
	self = VALA_ATTRIBUTE_PROCESSOR (base);
	g_return_if_fail (iface == NULL || VALA_IS_INTERFACE (iface));
	vala_interface_process_attributes (iface);
	vala_code_node_accept_children (VALA_CODE_NODE (iface), VALA_CODE_VISITOR (self));
}


static void vala_attribute_processor_real_visit_enum (ValaCodeVisitor* base, ValaEnum* en) {
	ValaAttributeProcessor * self;
	self = VALA_ATTRIBUTE_PROCESSOR (base);
	g_return_if_fail (en == NULL || VALA_IS_ENUM (en));
	vala_enum_process_attributes (en);
}


static void vala_attribute_processor_real_visit_method (ValaCodeVisitor* base, ValaMethod* m) {
	ValaAttributeProcessor * self;
	self = VALA_ATTRIBUTE_PROCESSOR (base);
	g_return_if_fail (m == NULL || VALA_IS_METHOD (m));
	vala_method_process_attributes (m);
	vala_code_node_accept_children (VALA_CODE_NODE (m), VALA_CODE_VISITOR (self));
}


static void vala_attribute_processor_real_visit_creation_method (ValaCodeVisitor* base, ValaCreationMethod* m) {
	ValaAttributeProcessor * self;
	self = VALA_ATTRIBUTE_PROCESSOR (base);
	g_return_if_fail (m == NULL || VALA_IS_CREATION_METHOD (m));
	vala_method_process_attributes (VALA_METHOD (m));
	vala_code_node_accept_children (VALA_CODE_NODE (m), VALA_CODE_VISITOR (self));
}


static void vala_attribute_processor_real_visit_formal_parameter (ValaCodeVisitor* base, ValaFormalParameter* p) {
	ValaAttributeProcessor * self;
	self = VALA_ATTRIBUTE_PROCESSOR (base);
	g_return_if_fail (p == NULL || VALA_IS_FORMAL_PARAMETER (p));
	vala_formal_parameter_process_attributes (p);
}


static void vala_attribute_processor_real_visit_property (ValaCodeVisitor* base, ValaProperty* prop) {
	ValaAttributeProcessor * self;
	self = VALA_ATTRIBUTE_PROCESSOR (base);
	g_return_if_fail (prop == NULL || VALA_IS_PROPERTY (prop));
	vala_property_process_attributes (prop);
}


static void vala_attribute_processor_real_visit_delegate (ValaCodeVisitor* base, ValaDelegate* d) {
	ValaAttributeProcessor * self;
	self = VALA_ATTRIBUTE_PROCESSOR (base);
	g_return_if_fail (d == NULL || VALA_IS_DELEGATE (d));
	vala_delegate_process_attributes (d);
	vala_code_node_accept_children (VALA_CODE_NODE (d), VALA_CODE_VISITOR (self));
}


static void vala_attribute_processor_real_visit_constant (ValaCodeVisitor* base, ValaConstant* c) {
	ValaAttributeProcessor * self;
	self = VALA_ATTRIBUTE_PROCESSOR (base);
	g_return_if_fail (c == NULL || VALA_IS_CONSTANT (c));
	vala_constant_process_attributes (c);
}


static void vala_attribute_processor_real_visit_field (ValaCodeVisitor* base, ValaField* f) {
	ValaAttributeProcessor * self;
	self = VALA_ATTRIBUTE_PROCESSOR (base);
	g_return_if_fail (f == NULL || VALA_IS_FIELD (f));
	vala_field_process_attributes (f);
}


static void vala_attribute_processor_real_visit_signal (ValaCodeVisitor* base, ValaSignal* sig) {
	ValaAttributeProcessor * self;
	self = VALA_ATTRIBUTE_PROCESSOR (base);
	g_return_if_fail (sig == NULL || VALA_IS_SIGNAL (sig));
	vala_signal_process_attributes (sig);
	vala_code_node_accept_children (VALA_CODE_NODE (sig), VALA_CODE_VISITOR (self));
}


/**
 * Code visitor processing attributes associated with code nodes.
 */
ValaAttributeProcessor* vala_attribute_processor_new (void) {
	ValaAttributeProcessor * self;
	self = g_object_newv (VALA_TYPE_ATTRIBUTE_PROCESSOR, 0, NULL);
	return self;
}


static void vala_attribute_processor_class_init (ValaAttributeProcessorClass * klass) {
	vala_attribute_processor_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_VISITOR_CLASS (klass)->visit_source_file = vala_attribute_processor_real_visit_source_file;
	VALA_CODE_VISITOR_CLASS (klass)->visit_namespace = vala_attribute_processor_real_visit_namespace;
	VALA_CODE_VISITOR_CLASS (klass)->visit_class = vala_attribute_processor_real_visit_class;
	VALA_CODE_VISITOR_CLASS (klass)->visit_struct = vala_attribute_processor_real_visit_struct;
	VALA_CODE_VISITOR_CLASS (klass)->visit_interface = vala_attribute_processor_real_visit_interface;
	VALA_CODE_VISITOR_CLASS (klass)->visit_enum = vala_attribute_processor_real_visit_enum;
	VALA_CODE_VISITOR_CLASS (klass)->visit_method = vala_attribute_processor_real_visit_method;
	VALA_CODE_VISITOR_CLASS (klass)->visit_creation_method = vala_attribute_processor_real_visit_creation_method;
	VALA_CODE_VISITOR_CLASS (klass)->visit_formal_parameter = vala_attribute_processor_real_visit_formal_parameter;
	VALA_CODE_VISITOR_CLASS (klass)->visit_property = vala_attribute_processor_real_visit_property;
	VALA_CODE_VISITOR_CLASS (klass)->visit_delegate = vala_attribute_processor_real_visit_delegate;
	VALA_CODE_VISITOR_CLASS (klass)->visit_constant = vala_attribute_processor_real_visit_constant;
	VALA_CODE_VISITOR_CLASS (klass)->visit_field = vala_attribute_processor_real_visit_field;
	VALA_CODE_VISITOR_CLASS (klass)->visit_signal = vala_attribute_processor_real_visit_signal;
}


static void vala_attribute_processor_init (ValaAttributeProcessor * self) {
}


GType vala_attribute_processor_get_type (void) {
	static GType vala_attribute_processor_type_id = 0;
	if (G_UNLIKELY (vala_attribute_processor_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaAttributeProcessorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_attribute_processor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaAttributeProcessor), 0, (GInstanceInitFunc) vala_attribute_processor_init };
		vala_attribute_processor_type_id = g_type_register_static (VALA_TYPE_CODE_VISITOR, "ValaAttributeProcessor", &g_define_type_info, 0);
	}
	return vala_attribute_processor_type_id;
}




