/* valaexpression.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALA_VALAEXPRESSION_H__
#define __VALA_VALAEXPRESSION_H__

#include <glib.h>
#include <glib-object.h>
#include <gee/arraylist.h>
#include <vala/valacodenode.h>

G_BEGIN_DECLS


#define VALA_TYPE_EXPRESSION (vala_expression_get_type ())
#define VALA_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_EXPRESSION, ValaExpression))
#define VALA_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_EXPRESSION, ValaExpressionClass))
#define VALA_IS_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_EXPRESSION))
#define VALA_IS_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_EXPRESSION))
#define VALA_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_EXPRESSION, ValaExpressionClass))

typedef struct _ValaExpressionPrivate ValaExpressionPrivate;

/**
 * Base class for all code nodes that might be used as an expression.
 */
struct _ValaExpression {
	ValaCodeNode parent_instance;
	ValaExpressionPrivate * priv;
	GeeArrayList* temp_vars;
};
struct _ValaExpressionClass {
	ValaCodeNodeClass parent_class;
	gboolean (*is_pure) (ValaExpression* self);
};

gboolean vala_expression_is_pure (ValaExpression* self);
ValaDataType* vala_expression_get_static_type (ValaExpression* self);
void vala_expression_set_static_type (ValaExpression* self, ValaDataType* value);
ValaDataType* vala_expression_get_expected_type (ValaExpression* self);
void vala_expression_set_expected_type (ValaExpression* self, ValaDataType* value);
ValaSymbol* vala_expression_get_symbol_reference (ValaExpression* self);
void vala_expression_set_symbol_reference (ValaExpression* self, ValaSymbol* value);
gboolean vala_expression_get_ref_leaked (ValaExpression* self);
void vala_expression_set_ref_leaked (ValaExpression* self, gboolean value);
gboolean vala_expression_get_ref_missing (ValaExpression* self);
void vala_expression_set_ref_missing (ValaExpression* self, gboolean value);
gboolean vala_expression_get_ref_sink (ValaExpression* self);
void vala_expression_set_ref_sink (ValaExpression* self, gboolean value);
gboolean vala_expression_get_can_fail (ValaExpression* self);
void vala_expression_set_can_fail (ValaExpression* self, gboolean value);
gboolean vala_expression_get_lvalue (ValaExpression* self);
void vala_expression_set_lvalue (ValaExpression* self, gboolean value);
GType vala_expression_get_type (void);


G_END_DECLS

#endif
