/* gnome-vfs-2.0.vapi generated by lt-vapigen, do not modify. */

[CCode (cprefix = "GnomeVFS", lower_case_cprefix = "gnome_vfs_")]
namespace GnomeVFS {
	[CCode (cprefix = "GNOME_VFS_DNS_SD_SERVICE_", cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public enum DNSSDServiceStatus {
		ADDED,
		REMOVED,
	}
	[CCode (cprefix = "GNOME_VFS_DEVICE_TYPE_", cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public enum DeviceType {
		UNKNOWN,
		AUDIO_CD,
		VIDEO_DVD,
		HARDDRIVE,
		CDROM,
		FLOPPY,
		ZIP,
		JAZ,
		NFS,
		AUTOFS,
		CAMERA,
		MEMORY_STICK,
		SMB,
		APPLE,
		MUSIC_PLAYER,
		WINDOWS,
		LOOPBACK,
		NETWORK,
	}
	[CCode (cprefix = "GNOME_VFS_FILE_TYPE_", cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public enum FileType {
		UNKNOWN,
		REGULAR,
		DIRECTORY,
		FIFO,
		SOCKET,
		CHARACTER_DEVICE,
		BLOCK_DEVICE,
		SYMBOLIC_LINK,
	}
	[CCode (cprefix = "GNOME_VFS_DIRECTORY_KIND_", cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public enum FindDirectoryKind {
		DESKTOP,
		TRASH,
	}
	[CCode (cprefix = "GNOME_VFS_MIME_ACTION_TYPE_", cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public enum MimeActionType {
		NONE,
		APPLICATION,
		COMPONENT,
	}
	[CCode (cprefix = "GNOME_VFS_MIME_APPLICATION_ARGUMENT_TYPE_", cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public enum MimeApplicationArgumentType {
		URIS,
		PATHS,
		URIS_FOR_NON_FILES,
	}
	[CCode (cprefix = "GNOME_VFS_MIME_", cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public enum MimeEquivalence {
		UNRELATED,
		IDENTICAL,
		PARENT,
	}
	[CCode (cprefix = "", cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public enum ModuleCallbackAuthenticationAuthType {
		AuthTypeBasic,
		AuthTypeDigest,
	}
	[CCode (cprefix = "GNOME_VFS_MONITOR_EVENT_", cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public enum MonitorEventType {
		CHANGED,
		DELETED,
		STARTEXECUTING,
		STOPEXECUTING,
		CREATED,
		METADATA_CHANGED,
	}
	[CCode (cprefix = "GNOME_VFS_MONITOR_", cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public enum MonitorType {
		FILE,
		DIRECTORY,
	}
	[CCode (cprefix = "GNOME_VFS_", cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public enum Result {
		OK,
		ERROR_NOT_FOUND,
		ERROR_GENERIC,
		ERROR_INTERNAL,
		ERROR_BAD_PARAMETERS,
		ERROR_NOT_SUPPORTED,
		ERROR_IO,
		ERROR_CORRUPTED_DATA,
		ERROR_WRONG_FORMAT,
		ERROR_BAD_FILE,
		ERROR_TOO_BIG,
		ERROR_NO_SPACE,
		ERROR_READ_ONLY,
		ERROR_INVALID_URI,
		ERROR_NOT_OPEN,
		ERROR_INVALID_OPEN_MODE,
		ERROR_ACCESS_DENIED,
		ERROR_TOO_MANY_OPEN_FILES,
		ERROR_EOF,
		ERROR_NOT_A_DIRECTORY,
		ERROR_IN_PROGRESS,
		ERROR_INTERRUPTED,
		ERROR_FILE_EXISTS,
		ERROR_LOOP,
		ERROR_NOT_PERMITTED,
		ERROR_IS_DIRECTORY,
		ERROR_NO_MEMORY,
		ERROR_HOST_NOT_FOUND,
		ERROR_INVALID_HOST_NAME,
		ERROR_HOST_HAS_NO_ADDRESS,
		ERROR_LOGIN_FAILED,
		ERROR_CANCELLED,
		ERROR_DIRECTORY_BUSY,
		ERROR_DIRECTORY_NOT_EMPTY,
		ERROR_TOO_MANY_LINKS,
		ERROR_READ_ONLY_FILE_SYSTEM,
		ERROR_NOT_SAME_FILE_SYSTEM,
		ERROR_NAME_TOO_LONG,
		ERROR_SERVICE_NOT_AVAILABLE,
		ERROR_SERVICE_OBSOLETE,
		ERROR_PROTOCOL_ERROR,
		ERROR_NO_MASTER_BROWSER,
		ERROR_NO_DEFAULT,
		ERROR_NO_HANDLER,
		ERROR_PARSE,
		ERROR_LAUNCH,
		ERROR_TIMEOUT,
		ERROR_NAMESERVER,
		ERROR_LOCKED,
		ERROR_DEPRECATED_FUNCTION,
		ERROR_INVALID_FILENAME,
		ERROR_NOT_A_SYMBOLIC_LINK,
		NUM_ERRORS,
	}
	[CCode (cprefix = "GNOME_VFS_SEEK_", cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public enum SeekPosition {
		START,
		CURRENT,
		END,
	}
	[CCode (cprefix = "GNOME_VFS_VOLUME_TYPE_", cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public enum VolumeType {
		MOUNTPOINT,
		VFS_MOUNT,
		CONNECTED_SERVER,
	}
	[CCode (cprefix = "GNOME_VFS_XFER_ERROR_ACTION_", cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public enum XferErrorAction {
		ABORT,
		RETRY,
		SKIP,
	}
	[CCode (cprefix = "GNOME_VFS_XFER_ERROR_MODE_", cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public enum XferErrorMode {
		ABORT,
		QUERY,
	}
	[CCode (cprefix = "GNOME_VFS_XFER_OVERWRITE_ACTION_", cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public enum XferOverwriteAction {
		ABORT,
		REPLACE,
		REPLACE_ALL,
		SKIP,
		SKIP_ALL,
	}
	[CCode (cprefix = "GNOME_VFS_XFER_OVERWRITE_MODE_", cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public enum XferOverwriteMode {
		ABORT,
		QUERY,
		REPLACE,
		SKIP,
	}
	[CCode (cprefix = "GNOME_VFS_XFER_", cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public enum XferPhase {
		PHASE_INITIAL,
		CHECKING_DESTINATION,
		PHASE_COLLECTING,
		PHASE_READYTOGO,
		PHASE_OPENSOURCE,
		PHASE_OPENTARGET,
		PHASE_COPYING,
		PHASE_MOVING,
		PHASE_READSOURCE,
		PHASE_WRITETARGET,
		PHASE_CLOSESOURCE,
		PHASE_CLOSETARGET,
		PHASE_DELETESOURCE,
		PHASE_SETATTRIBUTES,
		PHASE_FILECOMPLETED,
		PHASE_CLEANUP,
		PHASE_COMPLETED,
		NUM_PHASES,
	}
	[CCode (cprefix = "GNOME_VFS_XFER_PROGRESS_STATUS_", cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public enum XferProgressStatus {
		OK,
		VFSERROR,
		OVERWRITE,
		DUPLICATE,
	}
	[CCode (cprefix = "GNOME_VFS_DIRECTORY_VISIT_", cheader_filename = "libgnomevfs/gnome-vfs.h")]
	[Flags]
	public enum DirectoryVisitOptions {
		DEFAULT,
		SAMEFS,
		LOOPCHECK,
		IGNORE_RECURSE_ERROR,
	}
	[CCode (cprefix = "GNOME_VFS_FILE_FLAGS_", cheader_filename = "libgnomevfs/gnome-vfs.h")]
	[Flags]
	public enum FileFlags {
		NONE,
		SYMLINK,
		LOCAL,
	}
	[CCode (cprefix = "GNOME_VFS_FILE_INFO_FIELDS_", cheader_filename = "libgnomevfs/gnome-vfs.h")]
	[Flags]
	public enum FileInfoFields {
		NONE,
		TYPE,
		PERMISSIONS,
		FLAGS,
		DEVICE,
		INODE,
		LINK_COUNT,
		SIZE,
		BLOCK_COUNT,
		IO_BLOCK_SIZE,
		ATIME,
		MTIME,
		CTIME,
		SYMLINK_NAME,
		MIME_TYPE,
		ACCESS,
		IDS,
		ACL,
		SELINUX_CONTEXT,
	}
	[CCode (cprefix = "GNOME_VFS_FILE_INFO_", cheader_filename = "libgnomevfs/gnome-vfs.h")]
	[Flags]
	public enum FileInfoOptions {
		DEFAULT,
		GET_MIME_TYPE,
		FORCE_FAST_MIME_TYPE,
		FORCE_SLOW_MIME_TYPE,
		FOLLOW_LINKS,
		GET_ACCESS_RIGHTS,
		NAME_ONLY,
		GET_ACL,
		GET_SELINUX_CONTEXT,
	}
	[CCode (cprefix = "GNOME_VFS_PERM_", cheader_filename = "libgnomevfs/gnome-vfs.h")]
	[Flags]
	public enum FilePermissions {
		SUID,
		SGID,
		STICKY,
		USER_READ,
		USER_WRITE,
		USER_EXEC,
		USER_ALL,
		GROUP_READ,
		GROUP_WRITE,
		GROUP_EXEC,
		GROUP_ALL,
		OTHER_READ,
		OTHER_WRITE,
		OTHER_EXEC,
		OTHER_ALL,
		ACCESS_READABLE,
		ACCESS_WRITABLE,
		ACCESS_EXECUTABLE,
	}
	[CCode (cprefix = "GNOME_VFS_MAKE_URI_DIR_", cheader_filename = "libgnomevfs/gnome-vfs.h")]
	[Flags]
	public enum MakeURIDirs {
		NONE,
		HOMEDIR,
		CURRENT,
	}
	[CCode (cprefix = "GNOME_VFS_MODULE_CALLBACK_FULL_AUTHENTICATION_", cheader_filename = "libgnomevfs/gnome-vfs.h")]
	[Flags]
	public enum ModuleCallbackFullAuthenticationFlags {
		PREVIOUS_ATTEMPT_FAILED,
		NEED_PASSWORD,
		NEED_USERNAME,
		NEED_DOMAIN,
		SAVING_SUPPORTED,
		ANON_SUPPORTED,
	}
	[CCode (cprefix = "GNOME_VFS_MODULE_CALLBACK_FULL_AUTHENTICATION_OUT_ANON_", cheader_filename = "libgnomevfs/gnome-vfs.h")]
	[Flags]
	public enum ModuleCallbackFullAuthenticationOutFlags {
		SELECTED,
	}
	[CCode (cprefix = "GNOME_VFS_OPEN_", cheader_filename = "libgnomevfs/gnome-vfs.h")]
	[Flags]
	public enum OpenMode {
		NONE,
		READ,
		WRITE,
		RANDOM,
		TRUNCATE,
	}
	[CCode (cprefix = "GNOME_VFS_SET_FILE_INFO_", cheader_filename = "libgnomevfs/gnome-vfs.h")]
	[Flags]
	public enum SetFileInfoMask {
		NONE,
		NAME,
		PERMISSIONS,
		OWNER,
		TIME,
		ACL,
		SELINUX_CONTEXT,
		SYMLINK_NAME,
	}
	[CCode (cprefix = "GNOME_VFS_URI_HIDE_", cheader_filename = "libgnomevfs/gnome-vfs.h")]
	[Flags]
	public enum URIHideOptions {
		NONE,
		USER_NAME,
		PASSWORD,
		HOST_NAME,
		HOST_PORT,
		TOPLEVEL_METHOD,
		FRAGMENT_IDENTIFIER,
	}
	[CCode (cprefix = "GNOME_VFS_XFER_", cheader_filename = "libgnomevfs/gnome-vfs.h")]
	[Flags]
	public enum XferOptions {
		DEFAULT,
		UNUSED_1,
		FOLLOW_LINKS,
		UNUSED_2,
		RECURSIVE,
		SAMEFS,
		DELETE_ITEMS,
		EMPTY_DIRECTORIES,
		NEW_UNIQUE_DIRECTORY,
		REMOVESOURCE,
		USE_UNIQUE_NAMES,
		LINK_ITEMS,
		FOLLOW_LINKS_RECURSIVE,
		TARGET_DEFAULT_PERMS,
	}
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class ACLKind {
		public weak string to_string ();
	}
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class ACLPerm {
		public weak string to_string ();
	}
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class AsyncHandle {
	}
	[CCode (free_function = "gnome_vfs_cancellation_destroy", cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class Cancellation {
		public void ack ();
		public void cancel ();
		public bool check ();
		public int get_fd ();
		public Cancellation ();
	}
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class Context {
		public static bool check_cancellation_current ();
		public weak GnomeVFS.Cancellation get_cancellation ();
		public Context ();
		public static weak GnomeVFS.Context peek_current ();
	}
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class DNSSDBrowseHandle {
	}
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class DNSSDResolveHandle {
	}
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class DNSSDService {
		public weak string name;
		public weak string type;
		public weak string domain;
		[CCode (cname = "gnome_vfs_dns_sd_service_list_free")]
		public void list_free (int n_services);
	}
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class DirectoryHandle {
	}
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class FileOffset {
	}
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class FileSize {
	}
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class FindDirectoryResult {
		public weak GnomeVFS.URI uri;
		public GnomeVFS.Result result;
		public pointer reserved1;
		public pointer reserved2;
		public weak GnomeVFS.FindDirectoryResult dup ();
	}
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class GetFileInfoResult {
		public weak GnomeVFS.URI uri;
		public GnomeVFS.Result result;
		public weak GnomeVFS.FileInfo file_info;
		public weak GnomeVFS.GetFileInfoResult dup ();
	}
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class Handle {
	}
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class InodeNumber {
	}
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class MethodHandle {
	}
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class MimeAction {
		public GnomeVFS.MimeActionType action_type;
		public pointer action;
		public pointer reserved1;
		public GnomeVFS.Result launch (GLib.List uris);
		public GnomeVFS.Result launch_with_env (GLib.List uris, out weak string envp);
	}
	[CCode (copy_function = "gnome_vfs_mime_application_copy", cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class MimeApplication {
		public weak string id;
		public weak string name;
		public weak string command;
		public bool can_open_multiple_files;
		public GnomeVFS.MimeApplicationArgumentType expects_uris;
		public weak GLib.List supported_uri_schemes;
		public pointer reserved1;
		public weak GnomeVFS.MimeApplication copy ();
		public bool equal (GnomeVFS.MimeApplication app_b);
		public weak string get_binary_name ();
		public weak string get_desktop_file_path ();
		public weak string get_desktop_id ();
		public weak string get_exec ();
		public weak string get_generic_name ();
		public weak string get_icon ();
		public weak string get_name ();
		public weak string get_startup_wm_class ();
		public GnomeVFS.Result launch (GLib.List uris);
		public GnomeVFS.Result launch_with_env (GLib.List uris, out weak string envp);
		public static void list_free (GLib.List list);
		public MimeApplication.from_desktop_id (string id);
		public MimeApplication.from_id (string id);
		public bool requires_terminal ();
		public bool supports_startup_notification ();
		public bool supports_uris ();
	}
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class ModuleCallbackAdditionalHeadersIn {
		public weak GnomeVFS.URI uri;
		public pointer reserved1;
		public pointer reserved2;
	}
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class ModuleCallbackAdditionalHeadersOut {
		public weak GLib.List headers;
		public pointer reserved1;
		public pointer reserved2;
	}
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class ModuleCallbackAuthenticationIn {
		public weak string uri;
		public weak string realm;
		public bool previous_attempt_failed;
		public GnomeVFS.ModuleCallbackAuthenticationAuthType auth_type;
		public pointer reserved1;
		public pointer reserved2;
	}
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class ModuleCallbackAuthenticationOut {
		public weak string username;
		public weak string password;
		public pointer reserved1;
		public pointer reserved2;
	}
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class ModuleCallbackFillAuthenticationIn {
		public weak string uri;
		public weak string protocol;
		public weak string server;
		public weak string object;
		public int port;
		public weak string authtype;
		public weak string username;
		public weak string domain;
		public pointer reserved1;
		public pointer reserved2;
	}
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class ModuleCallbackFillAuthenticationOut {
		public bool valid;
		public weak string username;
		public weak string domain;
		public weak string password;
		public pointer reserved1;
		public pointer reserved2;
	}
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class ModuleCallbackFullAuthenticationIn {
		public GnomeVFS.ModuleCallbackFullAuthenticationFlags flags;
		public weak string uri;
		public weak string protocol;
		public weak string server;
		public weak string object;
		public int port;
		public weak string authtype;
		public weak string username;
		public weak string domain;
		public weak string default_user;
		public weak string default_domain;
		public pointer reserved1;
		public pointer reserved2;
	}
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class ModuleCallbackFullAuthenticationOut {
		public bool abort_auth;
		public weak string username;
		public weak string domain;
		public weak string password;
		public bool save_password;
		public weak string keyring;
		public ulong out_flags;
		public pointer reserved2;
	}
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class ModuleCallbackQuestionIn {
		public weak string primary_message;
		public weak string secondary_message;
		public weak string choices;
		public pointer reserved1;
		public pointer reserved2;
	}
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class ModuleCallbackQuestionOut {
		public int answer;
		public pointer reserved1;
		public pointer reserved2;
	}
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class ModuleCallbackReceivedHeadersIn {
		public weak GnomeVFS.URI uri;
		public weak GLib.List headers;
		public pointer reserved1;
		public pointer reserved2;
	}
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class ModuleCallbackReceivedHeadersOut {
		public int dummy;
		public pointer reserved1;
		public pointer reserved2;
	}
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class ModuleCallbackSaveAuthenticationIn {
		public weak string keyring;
		public weak string uri;
		public weak string protocol;
		public weak string server;
		public weak string object;
		public int port;
		public weak string authtype;
		public weak string username;
		public weak string domain;
		public weak string password;
		public pointer reserved1;
		public pointer reserved2;
	}
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class ModuleCallbackSaveAuthenticationOut {
		public pointer reserved1;
		public pointer reserved2;
	}
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class ModuleCallbackStatusMessageIn {
		public weak string uri;
		public weak string message;
		public int percentage;
		public pointer reserved1;
		public pointer reserved2;
	}
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class ModuleCallbackStatusMessageOut {
		public int dummy;
		public pointer reserved1;
		public pointer reserved2;
	}
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class MonitorHandle {
	}
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class ProgressCallbackState {
		public weak GnomeVFS.XferProgressInfo progress_info;
		public GnomeVFS.XferProgressCallback sync_callback;
		public GnomeVFS.XferProgressCallback update_callback;
		public pointer user_data;
		public pointer async_job_data;
		public int64 next_update_callback_time;
		public int64 next_text_update_callback_time;
		public int64 update_callback_period;
		public pointer reserved1;
		public pointer reserved2;
	}
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class ResolveHandle {
	}
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class ToplevelURI {
		public weak GnomeVFS.URI uri;
		public weak string host_name;
		public uint host_port;
		public weak string user_name;
		public weak string password;
		public weak string urn;
		public pointer reserved1;
		public pointer reserved2;
	}
	[CCode (ref_function = "gnome_vfs_uri_ref", unref_function = "gnome_vfs_uri_unref", cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class URI {
		public uint ref_count;
		public weak string text;
		public weak string fragment_id;
		public weak string method_string;
		public pointer method;
		public pointer parent;
		public pointer reserved1;
		public pointer reserved2;
		public weak GnomeVFS.URI append_file_name (string filename);
		public weak GnomeVFS.URI append_path (string path);
		public weak GnomeVFS.URI append_string (string uri_fragment);
		public weak GnomeVFS.URI dup ();
		public bool equal (GnomeVFS.URI b);
		public bool exists ();
		public weak string extract_dirname ();
		public weak string extract_short_name ();
		public weak string extract_short_path_name ();
		public weak string get_fragment_identifier ();
		public weak string get_host_name ();
		public uint get_host_port ();
		public weak GnomeVFS.URI get_parent ();
		public weak string get_password ();
		public weak string get_path ();
		public weak string get_scheme ();
		public weak GnomeVFS.ToplevelURI get_toplevel ();
		public weak string get_user_name ();
		public bool has_parent ();
		public static uint hash (pointer p);
		public static int hequal (pointer a, pointer b);
		public bool is_local ();
		public bool is_parent (GnomeVFS.URI possible_child, bool recursive);
		public static weak GLib.List list_copy (GLib.List list);
		public static void list_free (GLib.List list);
		public static weak GLib.List list_parse (string uri_list);
		public static weak GLib.List list_ref (GLib.List list);
		public static weak GLib.List list_unref (GLib.List list);
		public static weak string make_full_from_relative (string base_uri, string relative_uri);
		public URI (string text_uri);
		public weak GnomeVFS.URI resolve_relative (string relative_reference);
		public weak GnomeVFS.URI resolve_symbolic_link (string relative_reference);
		public void set_host_name (string host_name);
		public void set_host_port (uint host_port);
		public void set_password (string password);
		public void set_user_name (string user_name);
		public weak string to_string (GnomeVFS.URIHideOptions hide_options);
	}
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class XferProgressInfo {
		public GnomeVFS.XferProgressStatus status;
		public GnomeVFS.Result vfs_status;
		public GnomeVFS.XferPhase phase;
		public weak string source_name;
		public weak string target_name;
		public ulong file_index;
		public ulong files_total;
		public weak GnomeVFS.FileSize bytes_total;
		public weak GnomeVFS.FileSize file_size;
		public weak GnomeVFS.FileSize bytes_copied;
		public weak GnomeVFS.FileSize total_bytes_copied;
		public weak string duplicate_name;
		public int duplicate_count;
		public bool top_level_item;
		public pointer reserved1;
		public pointer reserved2;
	}
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class Address : GLib.Boxed {
		public weak GnomeVFS.Address dup ();
		public bool equal (GnomeVFS.Address b);
		public int get_family_type ();
		public uint get_ipv4 ();
		public pointer get_sockaddr (ushort port, int len);
		public bool match (GnomeVFS.Address b, uint prefix);
		public Address.from_ipv4 (uint ipv4_address);
		public Address.from_string (string address);
		public weak string to_string ();
	}
	[CCode (ref_function = "gnome_vfs_file_info_ref", unref_function = "gnome_vfs_file_info_unref", cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class FileInfo : GLib.Boxed {
		public weak string name;
		public GnomeVFS.FileInfoFields valid_fields;
		public GnomeVFS.FileType type;
		public GnomeVFS.FilePermissions permissions;
		public GnomeVFS.FileFlags flags;
		public weak GnomeVFS.InodeNumber inode;
		public uint link_count;
		public uint uid;
		public uint gid;
		public weak GnomeVFS.FileSize size;
		public weak GnomeVFS.FileSize block_count;
		public uint io_block_size;
		public ulong atime;
		public ulong mtime;
		public ulong ctime;
		public weak string symlink_name;
		public weak string mime_type;
		public uint refcount;
		public weak GnomeVFS.ACL acl;
		public weak string selinux_context;
		public pointer reserved1;
		public pointer reserved2;
		public pointer reserved3;
		public void clear ();
		public void copy (GnomeVFS.FileInfo src);
		public weak GnomeVFS.FileInfo dup ();
		public weak string get_mime_type ();
		public static weak GLib.List list_copy (GLib.List list);
		public static void list_free (GLib.List list);
		public static weak GLib.List list_ref (GLib.List list);
		public static weak GLib.List list_unref (GLib.List list);
		public bool matches (GnomeVFS.FileInfo b);
		public FileInfo ();
	}
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class GnomeVfsFindDirectoryResult : GLib.Boxed {
	}
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class GnomeVfsGetFileInfoResult : GLib.Boxed {
	}
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class ACE : GLib.Object {
		public void add_perm (GnomeVFS.ACLPerm perm);
		public bool check_perm (GnomeVFS.ACLPerm perm);
		public void copy_perms (GnomeVFS.ACE dest);
		public void del_perm (GnomeVFS.ACLPerm perm);
		public bool equal (GnomeVFS.ACE entry_b);
		public weak string get_id ();
		public bool get_inherit ();
		public weak GnomeVFS.ACLKind get_kind ();
		public bool get_negative ();
		public weak GnomeVFS.ACLPerm get_perms ();
		public ACE (GnomeVFS.ACLKind kind, string id, GnomeVFS.ACLPerm perms);
		public void set_id (string id);
		public void set_inherit (bool inherit);
		public void set_kind (GnomeVFS.ACLKind kind);
		public void set_negative (bool negative);
		public void set_perms (GnomeVFS.ACLPerm perms);
		[NoWrapper]
		public virtual void reserved1 ();
		[NoWrapper]
		public virtual void reserved2 ();
		[NoWrapper]
		public virtual void reserved3 ();
		[NoWrapper]
		public virtual void reserved4 ();
		public weak string id { get; set construct; }
		public weak bool inherit { get; set; }
		public weak uint kind { get; set construct; }
		public weak bool negative { get; set; }
		[NoAccessorMethod]
		public weak pointer permissions { get; set construct; }
	}
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class ACL : GLib.Object {
		public void clear ();
		public static void free_ace_list (GLib.List ace_list);
		public weak GLib.List get_ace_list ();
		public ACL ();
		public void set (GnomeVFS.ACE ace);
		public void unset (GnomeVFS.ACE ace);
	}
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class Drive : GLib.Object {
		public int compare (GnomeVFS.Drive b);
		public void eject (GnomeVFS.VolumeOpCallback callback);
		public weak string get_activation_uri ();
		public weak string get_device_path ();
		public GnomeVFS.DeviceType get_device_type ();
		public weak string get_display_name ();
		public weak string get_hal_udi ();
		public weak string get_icon ();
		public ulong get_id ();
		public weak GnomeVFS.Volume get_mounted_volume ();
		public weak GLib.List get_mounted_volumes ();
		public bool is_connected ();
		public bool is_mounted ();
		public bool is_user_visible ();
		public void mount (GnomeVFS.VolumeOpCallback callback);
		public bool needs_eject ();
		public weak GnomeVFS.Drive @ref ();
		public void unmount (GnomeVFS.VolumeOpCallback callback);
		public void unref ();
		public static void volume_list_free (GLib.List volumes);
		public signal void volume_mounted (GnomeVFS.Volume volume);
		public signal void volume_pre_unmount (GnomeVFS.Volume volume);
		public signal void volume_unmounted (GnomeVFS.Volume volume);
	}
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class MIMEMonitor : GLib.Object {
		public static weak GnomeVFS.MIMEMonitor get ();
		public signal void data_changed ();
	}
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class Volume : GLib.Object {
		public int compare (GnomeVFS.Volume b);
		public void eject (GnomeVFS.VolumeOpCallback callback);
		public weak string get_activation_uri ();
		public weak string get_device_path ();
		public GnomeVFS.DeviceType get_device_type ();
		public weak string get_display_name ();
		public weak GnomeVFS.Drive get_drive ();
		public weak string get_filesystem_type ();
		public weak string get_hal_udi ();
		public weak string get_icon ();
		public ulong get_id ();
		public GnomeVFS.VolumeType get_volume_type ();
		public bool handles_trash ();
		public bool is_mounted ();
		public bool is_read_only ();
		public bool is_user_visible ();
		public weak GnomeVFS.Volume @ref ();
		public void unmount (GnomeVFS.VolumeOpCallback callback);
		public void unref ();
	}
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class VolumeMonitor : GLib.Object {
		public weak GLib.List get_connected_drives ();
		public weak GnomeVFS.Drive get_drive_by_id (ulong id);
		public weak GLib.List get_mounted_volumes ();
		public weak GnomeVFS.Volume get_volume_by_id (ulong id);
		public weak GnomeVFS.Volume get_volume_for_path (string path);
		public weak GnomeVFS.VolumeMonitor @ref ();
		public void unref ();
		public signal void drive_connected (GnomeVFS.Drive drive);
		public signal void drive_disconnected (GnomeVFS.Drive drive);
		public signal void volume_mounted (GnomeVFS.Volume volume);
		public signal void volume_pre_unmount (GnomeVFS.Volume volume);
		public signal void volume_unmounted (GnomeVFS.Volume volume);
	}
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static delegate void AsyncCallback (GnomeVFS.AsyncHandle handle, GnomeVFS.Result result, pointer callback_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static delegate void AsyncCloseCallback (GnomeVFS.AsyncHandle handle, GnomeVFS.Result result, pointer callback_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static delegate void AsyncCreateAsChannelCallback (GnomeVFS.AsyncHandle handle, GLib.IOChannel channel, GnomeVFS.Result result, pointer callback_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static delegate void AsyncCreateCallback (GnomeVFS.AsyncHandle handle, GnomeVFS.Result result, pointer callback_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static delegate void AsyncDirectoryLoadCallback (GnomeVFS.AsyncHandle handle, GnomeVFS.Result result, GLib.List list, uint entries_read, pointer callback_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static delegate void AsyncFileControlCallback (GnomeVFS.AsyncHandle handle, GnomeVFS.Result result, pointer operation_data, pointer callback_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public delegate void AsyncFindDirectoryCallback (GnomeVFS.AsyncHandle handle, GLib.List results);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static delegate void AsyncGetFileInfoCallback (GnomeVFS.AsyncHandle handle, GLib.List results, pointer callback_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static delegate void AsyncModuleCallback (pointer @in, ulong in_size, pointer @out, ulong out_size, pointer callback_data, GnomeVFS.ModuleCallbackResponse response, pointer response_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static delegate void AsyncOpenAsChannelCallback (GnomeVFS.AsyncHandle handle, GLib.IOChannel channel, GnomeVFS.Result result, pointer callback_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static delegate void AsyncOpenCallback (GnomeVFS.AsyncHandle handle, GnomeVFS.Result result, pointer callback_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static delegate void AsyncReadCallback (GnomeVFS.AsyncHandle handle, GnomeVFS.Result result, pointer buffer, GnomeVFS.FileSize bytes_requested, GnomeVFS.FileSize bytes_read, pointer callback_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static delegate void AsyncSeekCallback (GnomeVFS.AsyncHandle handle, GnomeVFS.Result result, pointer callback_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static delegate void AsyncSetFileInfoCallback (GnomeVFS.AsyncHandle handle, GnomeVFS.Result result, GnomeVFS.FileInfo file_info, pointer callback_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static delegate void AsyncWriteCallback (GnomeVFS.AsyncHandle handle, GnomeVFS.Result result, pointer buffer, GnomeVFS.FileSize bytes_requested, GnomeVFS.FileSize bytes_written, pointer callback_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public delegate int AsyncXferProgressCallback (GnomeVFS.AsyncHandle handle, GnomeVFS.XferProgressInfo info);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static delegate void DNSSDBrowseCallback (GnomeVFS.DNSSDBrowseHandle handle, GnomeVFS.DNSSDServiceStatus status, GnomeVFS.DNSSDService service, pointer callback_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static delegate void DNSSDResolveCallback (GnomeVFS.DNSSDResolveHandle handle, GnomeVFS.Result result, GnomeVFS.DNSSDService service, string host, int port, GLib.HashTable text, int text_raw_len, string text_raw, pointer callback_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static delegate bool DirectoryVisitFunc (string rel_path, GnomeVFS.FileInfo info, bool recursing_will_loop, pointer user_data, bool recurse);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static delegate void ModuleCallback (pointer @in, ulong in_size, pointer @out, ulong out_size, pointer callback_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static delegate void ModuleCallbackResponse (pointer response_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public delegate void MonitorCallback (GnomeVFS.MonitorHandle handle, string monitor_uri, string info_uri, GnomeVFS.MonitorEventType event_type);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public delegate void VolumeOpCallback (bool succeeded, string error, string detailed_error);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public delegate int XferProgressCallback (GnomeVFS.XferProgressInfo info);
	public const string DESKTOP_ENTRY_GROUP;
	public const string GNOME_VFS_APPLICATION_REGISTRY_CAN_OPEN_MULTIPLE_FILES;
	public const string GNOME_VFS_APPLICATION_REGISTRY_COMMAND;
	public const string GNOME_VFS_APPLICATION_REGISTRY_NAME;
	public const string GNOME_VFS_APPLICATION_REGISTRY_REQUIRES_TERMINAL;
	public const string GNOME_VFS_APPLICATION_REGISTRY_STARTUP_NOTIFY;
	public const string GNOME_VFS_APPLICATION_REGISTRY_USES_GNOMEVFS;
	public const int GNOME_VFS_MAJOR_VERSION;
	public const int GNOME_VFS_MICRO_VERSION;
	public const string GNOME_VFS_MIME_TYPE_UNKNOWN;
	public const int GNOME_VFS_MINOR_VERSION;
	public const string GNOME_VFS_MODULE_CALLBACK_AUTHENTICATION;
	public const string GNOME_VFS_MODULE_CALLBACK_FILL_AUTHENTICATION;
	public const string GNOME_VFS_MODULE_CALLBACK_FULL_AUTHENTICATION;
	public const string GNOME_VFS_MODULE_CALLBACK_HTTP_PROXY_AUTHENTICATION;
	public const string GNOME_VFS_MODULE_CALLBACK_HTTP_RECEIVED_HEADERS;
	public const string GNOME_VFS_MODULE_CALLBACK_HTTP_SEND_ADDITIONAL_HEADERS;
	public const string GNOME_VFS_MODULE_CALLBACK_QUESTION;
	public const string GNOME_VFS_MODULE_CALLBACK_SAVE_AUTHENTICATION;
	public const string GNOME_VFS_MODULE_CALLBACK_STATUS_MESSAGE;
	public const int GNOME_VFS_PRIORITY_DEFAULT;
	public const int GNOME_VFS_PRIORITY_MAX;
	public const int GNOME_VFS_PRIORITY_MIN;
	public const string GNOME_VFS_URI_MAGIC_STR;
	public const string GNOME_VFS_URI_PATH_STR;
	public const int S_IRGRP;
	public const int S_IROTH;
	public const int S_ISGID;
	public const int S_ISUID;
	public const int S_IWGRP;
	public const int S_IWOTH;
	public const int S_IXGRP;
	public const int S_IXOTH;
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static bool application_is_user_owned_application (GnomeVFS.MimeApplication application);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void application_registry_add_mime_type (string app_id, string mime_type);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void application_registry_clear_mime_types (string app_id);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static bool application_registry_exists (string app_id);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static weak GLib.List application_registry_get_applications (string mime_type);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static bool application_registry_get_bool_value (string app_id, string key, bool got_key);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static weak GLib.List application_registry_get_keys (string app_id);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static weak GnomeVFS.MimeApplication application_registry_get_mime_application (string app_id);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static weak GLib.List application_registry_get_mime_types (string app_id);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static weak string application_registry_peek_value (string app_id, string key);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void application_registry_reload ();
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void application_registry_remove_application (string app_id);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void application_registry_remove_mime_type (string app_id, string mime_type);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void application_registry_save_mime_application (GnomeVFS.MimeApplication application);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void application_registry_set_bool_value (string app_id, string key, bool value);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void application_registry_set_value (string app_id, string key, string value);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void application_registry_shutdown ();
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static bool application_registry_supports_mime_type (string app_id, string mime_type);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static bool application_registry_supports_uri_scheme (string app_id, string uri_scheme);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result application_registry_sync ();
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void application_registry_unset_key (string app_id, string key);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void async_cancel (GnomeVFS.AsyncHandle handle);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void async_close (GnomeVFS.AsyncHandle handle, GnomeVFS.AsyncCloseCallback callback, pointer callback_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void async_create (out weak GnomeVFS.AsyncHandle handle_return, string text_uri, GnomeVFS.OpenMode open_mode, bool exclusive, uint perm, int priority, GnomeVFS.AsyncOpenCallback callback, pointer callback_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void async_create_as_channel (out weak GnomeVFS.AsyncHandle handle_return, string text_uri, GnomeVFS.OpenMode open_mode, bool exclusive, uint perm, int priority, GnomeVFS.AsyncCreateAsChannelCallback callback, pointer callback_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void async_create_symbolic_link (out weak GnomeVFS.AsyncHandle handle_return, GnomeVFS.URI uri, string uri_reference, int priority, GnomeVFS.AsyncOpenCallback callback, pointer callback_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void async_create_uri (out weak GnomeVFS.AsyncHandle handle_return, GnomeVFS.URI uri, GnomeVFS.OpenMode open_mode, bool exclusive, uint perm, int priority, GnomeVFS.AsyncOpenCallback callback, pointer callback_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void async_create_uri_as_channel (out weak GnomeVFS.AsyncHandle handle_return, GnomeVFS.URI uri, GnomeVFS.OpenMode open_mode, bool exclusive, uint perm, int priority, GnomeVFS.AsyncCreateAsChannelCallback callback, pointer callback_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void async_file_control (GnomeVFS.AsyncHandle handle, string operation, pointer operation_data, GLib.DestroyNotify operation_data_destroy_func, GnomeVFS.AsyncFileControlCallback callback, pointer callback_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void async_find_directory (out weak GnomeVFS.AsyncHandle handle_return, GLib.List near_uri_list, GnomeVFS.FindDirectoryKind kind, bool create_if_needed, bool find_if_needed, uint permissions, int priority, GnomeVFS.AsyncFindDirectoryCallback callback);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void async_get_file_info (out weak GnomeVFS.AsyncHandle handle_return, GLib.List uri_list, GnomeVFS.FileInfoOptions options, int priority, GnomeVFS.AsyncGetFileInfoCallback callback, pointer callback_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static int async_get_job_limit ();
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void async_load_directory (out weak GnomeVFS.AsyncHandle handle_return, string text_uri, GnomeVFS.FileInfoOptions options, uint items_per_notification, int priority, GnomeVFS.AsyncDirectoryLoadCallback callback, pointer callback_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void async_load_directory_uri (out weak GnomeVFS.AsyncHandle handle_return, GnomeVFS.URI uri, GnomeVFS.FileInfoOptions options, uint items_per_notification, int priority, GnomeVFS.AsyncDirectoryLoadCallback callback, pointer callback_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void async_module_callback_pop (string callback_name);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void async_module_callback_push (string callback_name, GnomeVFS.AsyncModuleCallback callback, pointer callback_data, GLib.DestroyNotify destroy_notify);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void async_module_callback_set_default (string callback_name, GnomeVFS.AsyncModuleCallback callback, pointer callback_data, GLib.DestroyNotify destroy_notify);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void async_open (out weak GnomeVFS.AsyncHandle handle_return, string text_uri, GnomeVFS.OpenMode open_mode, int priority, GnomeVFS.AsyncOpenCallback callback, pointer callback_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void async_open_as_channel (out weak GnomeVFS.AsyncHandle handle_return, string text_uri, GnomeVFS.OpenMode open_mode, uint advised_block_size, int priority, GnomeVFS.AsyncOpenAsChannelCallback callback, pointer callback_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void async_open_uri (out weak GnomeVFS.AsyncHandle handle_return, GnomeVFS.URI uri, GnomeVFS.OpenMode open_mode, int priority, GnomeVFS.AsyncOpenCallback callback, pointer callback_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void async_open_uri_as_channel (out weak GnomeVFS.AsyncHandle handle_return, GnomeVFS.URI uri, GnomeVFS.OpenMode open_mode, uint advised_block_size, int priority, GnomeVFS.AsyncOpenAsChannelCallback callback, pointer callback_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void async_read (GnomeVFS.AsyncHandle handle, pointer buffer, uint bytes, GnomeVFS.AsyncReadCallback callback, pointer callback_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void async_seek (GnomeVFS.AsyncHandle handle, GnomeVFS.SeekPosition whence, GnomeVFS.FileOffset offset, GnomeVFS.AsyncSeekCallback callback, pointer callback_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void async_set_file_info (out weak GnomeVFS.AsyncHandle handle_return, GnomeVFS.URI uri, GnomeVFS.FileInfo info, GnomeVFS.SetFileInfoMask mask, GnomeVFS.FileInfoOptions options, int priority, GnomeVFS.AsyncSetFileInfoCallback callback, pointer callback_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void async_set_job_limit (int limit);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void async_write (GnomeVFS.AsyncHandle handle, pointer buffer, uint bytes, GnomeVFS.AsyncWriteCallback callback, pointer callback_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result async_xfer (out weak GnomeVFS.AsyncHandle handle_return, GLib.List source_uri_list, GLib.List target_uri_list, GnomeVFS.XferOptions xfer_options, GnomeVFS.XferErrorMode error_mode, GnomeVFS.XferOverwriteMode overwrite_mode, int priority, GnomeVFS.AsyncXferProgressCallback progress_update_callback, pointer update_callback_data, GnomeVFS.XferProgressCallback progress_sync_callback, pointer sync_callback_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result check_same_fs (string source, string target, bool same_fs_return);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result check_same_fs_uris (GnomeVFS.URI source_uri, GnomeVFS.URI target_uri, bool same_fs_return);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result close (GnomeVFS.Handle handle);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void connect_to_server (string uri, string display_name, string icon);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result create (out weak GnomeVFS.Handle handle, string text_uri, GnomeVFS.OpenMode open_mode, bool exclusive, uint perm);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result create_symbolic_link (GnomeVFS.URI uri, string target_reference);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result create_uri (out weak GnomeVFS.Handle handle, GnomeVFS.URI uri, GnomeVFS.OpenMode open_mode, bool exclusive, uint perm);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result directory_close (GnomeVFS.DirectoryHandle handle);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result directory_list_load (GLib.List list, string text_uri, GnomeVFS.FileInfoOptions options);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result directory_open (out weak GnomeVFS.DirectoryHandle handle, string text_uri, GnomeVFS.FileInfoOptions options);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result directory_open_from_uri (out weak GnomeVFS.DirectoryHandle handle, GnomeVFS.URI uri, GnomeVFS.FileInfoOptions options);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result directory_read_next (GnomeVFS.DirectoryHandle handle, GnomeVFS.FileInfo file_info);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result directory_visit (string text_uri, GnomeVFS.FileInfoOptions info_options, GnomeVFS.DirectoryVisitOptions visit_options, GnomeVFS.DirectoryVisitFunc callback, pointer data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result directory_visit_files (string text_uri, GLib.List file_list, GnomeVFS.FileInfoOptions info_options, GnomeVFS.DirectoryVisitOptions visit_options, GnomeVFS.DirectoryVisitFunc callback, pointer data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result directory_visit_files_at_uri (GnomeVFS.URI uri, GLib.List file_list, GnomeVFS.FileInfoOptions info_options, GnomeVFS.DirectoryVisitOptions visit_options, GnomeVFS.DirectoryVisitFunc callback, pointer data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result directory_visit_uri (GnomeVFS.URI uri, GnomeVFS.FileInfoOptions info_options, GnomeVFS.DirectoryVisitOptions visit_options, GnomeVFS.DirectoryVisitFunc callback, pointer data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result dns_sd_browse (out weak GnomeVFS.DNSSDBrowseHandle handle, string domain, string type, GnomeVFS.DNSSDBrowseCallback callback, pointer callback_data, GLib.DestroyNotify callback_data_destroy_func);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result dns_sd_browse_sync (string domain, string type, int timeout_msec, int n_services, out weak GnomeVFS.DNSSDService services);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result dns_sd_cancel_resolve (GnomeVFS.DNSSDResolveHandle handle);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result dns_sd_list_browse_domains_sync (string domain, int timeout_msec, GLib.List domains);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result dns_sd_resolve (out weak GnomeVFS.DNSSDResolveHandle handle, string name, string type, string domain, int timeout, GnomeVFS.DNSSDResolveCallback callback, pointer callback_data, GLib.DestroyNotify callback_data_destroy_func);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result dns_sd_resolve_sync (string name, string type, string domain, int timeout_msec, out weak string host, int port, GLib.HashTable text, int text_raw_len_out, out weak string text_raw_out);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result dns_sd_stop_browse (GnomeVFS.DNSSDBrowseHandle handle);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static weak string escape_host_and_path_string (string path);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static weak string escape_path_string (string path);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static weak string escape_set (string str, string match_set);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static weak string escape_slashes (string str);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static weak string escape_string (string str);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static weak string expand_initial_tilde (string path);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result file_control (GnomeVFS.Handle handle, string operation, pointer operation_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result find_directory (GnomeVFS.URI near_uri, GnomeVFS.FindDirectoryKind kind, out weak GnomeVFS.URI _result, bool create_if_needed, bool find_if_needed, uint permissions);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result forget_cache (GnomeVFS.Handle handle, GnomeVFS.FileOffset offset, GnomeVFS.FileSize size);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static weak string format_file_size_for_display (GnomeVFS.FileSize size);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static weak string format_uri_for_display (string uri);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static weak GLib.List get_default_browse_domains ();
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result get_file_info (string text_uri, GnomeVFS.FileInfo info, GnomeVFS.FileInfoOptions options);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result get_file_info_from_handle (GnomeVFS.Handle handle, GnomeVFS.FileInfo info, GnomeVFS.FileInfoOptions options);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result get_file_info_uri (GnomeVFS.URI uri, GnomeVFS.FileInfo info, GnomeVFS.FileInfoOptions options);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static weak string get_file_mime_type (string path, pointer optional_stat_info, bool suffix_only);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static weak string get_file_mime_type_fast (string path, pointer optional_stat_info);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static weak string get_local_path_from_uri (string uri);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static weak string get_mime_type (string text_uri);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static weak string get_mime_type_common (GnomeVFS.URI uri);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static weak string get_mime_type_for_data (pointer data, int data_size);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static weak string get_mime_type_for_name (string filename);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static weak string get_mime_type_for_name_and_data (string filename, pointer data, long data_size);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static weak string get_mime_type_from_file_data (GnomeVFS.URI uri);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static weak string get_mime_type_from_uri (GnomeVFS.URI uri);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static weak string get_slow_mime_type (string text_uri);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static weak string get_supertype_from_mime_type (string mime_type);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static weak string get_uri_from_local_path (string local_full_path);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static weak string get_uri_scheme (string uri);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result get_volume_free_space (GnomeVFS.URI vfs_uri, GnomeVFS.FileSize size);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static weak GnomeVFS.VolumeMonitor get_volume_monitor ();
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static weak string icon_path_from_filename (string filename);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static bool init ();
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static bool initialized ();
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static bool is_executable_command_string (string command_string);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static bool is_primary_thread ();
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void list_deep_free (GLib.List list);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void loadinit (pointer app, pointer modinfo);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result make_directory (string text_uri, uint perm);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result make_directory_for_uri (GnomeVFS.URI uri, uint perm);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static weak string make_path_name_canonical (string path);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static weak string make_uri_canonical (string uri);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static weak string make_uri_canonical_strip_fragment (string uri);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static weak string make_uri_from_input (string location);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static weak string make_uri_from_input_with_dirs (string location, GnomeVFS.MakeURIDirs dirs);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static weak string make_uri_from_input_with_trailing_ws (string location);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static weak string make_uri_from_shell_arg (string uri);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static weak string make_uri_full_from_relative (string base_uri, string relative_uri);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result mime_add_application_to_short_list (string mime_type, string application_id);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result mime_add_component_to_short_list (string mime_type, string iid);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result mime_add_extension (string mime_type, string extension);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static bool mime_can_be_executable (string mime_type);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void mime_component_list_free (GLib.List list);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result mime_extend_all_applications (string mime_type, GLib.List application_ids);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static weak GLib.List mime_get_all_applications (string mime_type);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static weak GLib.List mime_get_all_applications_for_uri (string uri, string mime_type);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static weak GLib.List mime_get_all_components (string mime_type);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static weak GLib.List mime_get_all_desktop_entries (string mime_type);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static weak GnomeVFS.MimeAction mime_get_default_action (string mime_type);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.MimeActionType mime_get_default_action_type (string mime_type);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static weak GnomeVFS.MimeApplication mime_get_default_application (string mime_type);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static weak GnomeVFS.MimeApplication mime_get_default_application_for_uri (string uri, string mime_type);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static pointer mime_get_default_component (string mime_type);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static weak string mime_get_default_desktop_entry (string mime_type);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static weak string mime_get_description (string mime_type);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static weak string mime_get_icon (string mime_type);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static weak GLib.List mime_get_short_list_applications (string mime_type);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static weak GLib.List mime_get_short_list_components (string mime_type);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static bool mime_id_in_application_list (string id, GLib.List applications);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static bool mime_id_in_component_list (string iid, GLib.List components);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static weak GLib.List mime_id_list_from_application_list (GLib.List applications);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static weak GLib.List mime_id_list_from_component_list (GLib.List components);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void mime_info_cache_reload (string dir);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void mime_reload ();
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static weak GLib.List mime_remove_application_from_list (GLib.List applications, string application_id, bool did_remove);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result mime_remove_application_from_short_list (string mime_type, string application_id);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static weak GLib.List mime_remove_component_from_list (GLib.List components, string iid, bool did_remove);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result mime_remove_component_from_short_list (string mime_type, string iid);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result mime_remove_extension (string mime_type, string extension);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result mime_remove_from_all_applications (string mime_type, GLib.List application_ids);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result mime_set_can_be_executable (string mime_type, bool new_value);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result mime_set_default_action_type (string mime_type, GnomeVFS.MimeActionType action_type);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result mime_set_default_application (string mime_type, string application_id);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result mime_set_default_component (string mime_type, string component_iid);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result mime_set_description (string mime_type, string description);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result mime_set_icon (string mime_type, string filename);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result mime_set_short_list_applications (string mime_type, GLib.List application_ids);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result mime_set_short_list_components (string mime_type, GLib.List component_iids);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void mime_shutdown ();
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static weak string mime_type_from_name (string filename);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static weak string mime_type_from_name_or_default (string filename, string defaultv);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.MimeEquivalence mime_type_get_equivalence (string mime_type, string base_mime_type);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static bool mime_type_is_equal (string a, string b);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static bool mime_type_is_supertype (string mime_type);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void module_callback_pop (string callback_name);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void module_callback_push (string callback_name, GnomeVFS.ModuleCallback callback, pointer callback_data, GLib.DestroyNotify destroy_notify);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void module_callback_set_default (string callback_name, GnomeVFS.ModuleCallback callback, pointer callback_data, GLib.DestroyNotify destroy_notify);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result monitor_add (out weak GnomeVFS.MonitorHandle handle, string text_uri, GnomeVFS.MonitorType monitor_type, GnomeVFS.MonitorCallback callback);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result monitor_cancel (GnomeVFS.MonitorHandle handle);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result move (string old_text_uri, string new_text_uri, bool force_replace);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result move_uri (GnomeVFS.URI old_uri, GnomeVFS.URI new_uri, bool force_replace);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result open (out weak GnomeVFS.Handle handle, string text_uri, GnomeVFS.OpenMode open_mode);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result open_fd (out weak GnomeVFS.Handle handle, int filedes);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result open_uri (out weak GnomeVFS.Handle handle, GnomeVFS.URI uri, GnomeVFS.OpenMode open_mode);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void postinit (pointer app, pointer modinfo);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void preinit (pointer app, pointer modinfo);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result read (GnomeVFS.Handle handle, pointer buffer, GnomeVFS.FileSize bytes, GnomeVFS.FileSize bytes_read);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result read_entire_file (string uri, int file_size, out weak string file_contents);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result remove_directory (string text_uri);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result remove_directory_from_uri (GnomeVFS.URI uri);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result resolve (string hostname, out weak GnomeVFS.ResolveHandle handle);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void resolve_free (GnomeVFS.ResolveHandle handle);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static bool resolve_next_address (GnomeVFS.ResolveHandle handle, out weak GnomeVFS.Address address);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void resolve_reset_to_beginning (GnomeVFS.ResolveHandle handle);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result result_from_errno ();
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result result_from_errno_code (int errno_code);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result result_from_h_errno ();
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result result_from_h_errno_val (int h_errno_code);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static weak string result_to_string (GnomeVFS.Result _result);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result seek (GnomeVFS.Handle handle, GnomeVFS.SeekPosition whence, GnomeVFS.FileOffset offset);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result set_file_info (string text_uri, GnomeVFS.FileInfo info, GnomeVFS.SetFileInfoMask mask);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result set_file_info_uri (GnomeVFS.URI uri, GnomeVFS.FileInfo info, GnomeVFS.SetFileInfoMask mask);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void shutdown ();
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result tell (GnomeVFS.Handle handle, GnomeVFS.FileSize offset_return);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result truncate (string text_uri, GnomeVFS.FileSize length);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result truncate_handle (GnomeVFS.Handle handle, GnomeVFS.FileSize length);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result truncate_uri (GnomeVFS.URI uri, GnomeVFS.FileSize length);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static weak string unescape_string (string escaped_string, string illegal_characters);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static weak string unescape_string_for_display (string escaped);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result unlink (string text_uri);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result unlink_from_uri (GnomeVFS.URI uri);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static bool uris_match (string uri_1, string uri_2);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result url_show (string url);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result url_show_with_env (string url, out weak string envp);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result write (GnomeVFS.Handle handle, pointer buffer, GnomeVFS.FileSize bytes, GnomeVFS.FileSize bytes_written);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result xfer_delete_list (GLib.List source_uri_list, GnomeVFS.XferErrorMode error_mode, GnomeVFS.XferOptions xfer_options, GnomeVFS.XferProgressCallback progress_callback, pointer data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result xfer_uri (GnomeVFS.URI source_uri, GnomeVFS.URI target_uri, GnomeVFS.XferOptions xfer_options, GnomeVFS.XferErrorMode error_mode, GnomeVFS.XferOverwriteMode overwrite_mode, GnomeVFS.XferProgressCallback progress_callback, pointer data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result xfer_uri_list (GLib.List source_uri_list, GLib.List target_uri_list, GnomeVFS.XferOptions xfer_options, GnomeVFS.XferErrorMode error_mode, GnomeVFS.XferOverwriteMode overwrite_mode, GnomeVFS.XferProgressCallback progress_callback, pointer data);
}
