/* valaclasstype.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valaclasstype.h>
#include <vala/valacodenode.h>




struct _ValaClassTypePrivate {
	ValaClass* _class_symbol;
};
#define VALA_CLASS_TYPE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CLASS_TYPE, ValaClassTypePrivate))
enum  {
	VALA_CLASS_TYPE_DUMMY_PROPERTY,
	VALA_CLASS_TYPE_CLASS_SYMBOL
};
static ValaDataType* vala_class_type_real_copy (ValaDataType* base);
static gpointer vala_class_type_parent_class = NULL;
static void vala_class_type_dispose (GObject * obj);



ValaClassType* vala_class_type_new (ValaClass* class_symbol) {
	ValaClassType * self;
	g_return_val_if_fail (VALA_IS_CLASS (class_symbol), NULL);
	self = g_object_newv (VALA_TYPE_CLASS_TYPE, 0, NULL);
	vala_class_type_set_class_symbol (self, class_symbol);
	vala_data_type_set_data_type (VALA_DATA_TYPE (self), VALA_TYPESYMBOL (class_symbol));
	return self;
}


static ValaDataType* vala_class_type_real_copy (ValaDataType* base) {
	ValaClassType * self;
	ValaClassType* result;
	self = VALA_CLASS_TYPE (base);
	result = vala_class_type_new (self->priv->_class_symbol);
	vala_code_node_set_source_reference (VALA_CODE_NODE (result), vala_code_node_get_source_reference (VALA_CODE_NODE (self)));
	vala_data_type_set_transfers_ownership (VALA_DATA_TYPE (result), vala_data_type_get_transfers_ownership (VALA_DATA_TYPE (self)));
	vala_data_type_set_takes_ownership (VALA_DATA_TYPE (result), vala_data_type_get_takes_ownership (VALA_DATA_TYPE (self)));
	vala_data_type_set_nullable (VALA_DATA_TYPE (result), vala_data_type_get_nullable (VALA_DATA_TYPE (self)));
	vala_data_type_set_is_dynamic (VALA_DATA_TYPE (result), vala_data_type_get_is_dynamic (VALA_DATA_TYPE (self)));
	vala_data_type_set_floating_reference (VALA_DATA_TYPE (result), vala_data_type_get_floating_reference (VALA_DATA_TYPE (self)));
	{
		GeeList* arg_collection;
		GeeIterator* arg_it;
		arg_collection = vala_data_type_get_type_arguments (VALA_DATA_TYPE (self));
		arg_it = gee_iterable_iterator (GEE_ITERABLE (arg_collection));
		while (gee_iterator_next (arg_it)) {
			ValaDataType* arg;
			arg = ((ValaDataType*) gee_iterator_get (arg_it));
			{
				ValaDataType* _tmp0;
				_tmp0 = NULL;
				vala_data_type_add_type_argument (VALA_DATA_TYPE (result), (_tmp0 = vala_data_type_copy (arg)));
				(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
				(arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL)));
			}
		}
		(arg_collection == NULL ? NULL : (arg_collection = (g_object_unref (arg_collection), NULL)));
		(arg_it == NULL ? NULL : (arg_it = (g_object_unref (arg_it), NULL)));
	}
	return VALA_DATA_TYPE (result);
}


ValaClass* vala_class_type_get_class_symbol (ValaClassType* self) {
	g_return_val_if_fail (VALA_IS_CLASS_TYPE (self), NULL);
	return self->priv->_class_symbol;
}


void vala_class_type_set_class_symbol (ValaClassType* self, ValaClass* value) {
	g_return_if_fail (VALA_IS_CLASS_TYPE (self));
	self->priv->_class_symbol = value;
}


static void vala_class_type_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaClassType * self;
	self = VALA_CLASS_TYPE (object);
	switch (property_id) {
		case VALA_CLASS_TYPE_CLASS_SYMBOL:
		g_value_set_object (value, vala_class_type_get_class_symbol (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_class_type_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaClassType * self;
	self = VALA_CLASS_TYPE (object);
	switch (property_id) {
		case VALA_CLASS_TYPE_CLASS_SYMBOL:
		vala_class_type_set_class_symbol (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_class_type_class_init (ValaClassTypeClass * klass) {
	vala_class_type_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaClassTypePrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_class_type_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_class_type_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_class_type_dispose;
	VALA_DATA_TYPE_CLASS (klass)->copy = vala_class_type_real_copy;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CLASS_TYPE_CLASS_SYMBOL, g_param_spec_object ("class-symbol", "class-symbol", "class-symbol", VALA_TYPE_CLASS, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_class_type_init (ValaClassType * self) {
	self->priv = VALA_CLASS_TYPE_GET_PRIVATE (self);
}


static void vala_class_type_dispose (GObject * obj) {
	ValaClassType * self;
	self = VALA_CLASS_TYPE (obj);
	G_OBJECT_CLASS (vala_class_type_parent_class)->dispose (obj);
}


GType vala_class_type_get_type (void) {
	static GType vala_class_type_type_id = 0;
	if (G_UNLIKELY (vala_class_type_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaClassTypeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_class_type_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaClassType), 0, (GInstanceInitFunc) vala_class_type_init };
		vala_class_type_type_id = g_type_register_static (VALA_TYPE_REFERENCE_TYPE, "ValaClassType", &g_define_type_info, 0);
	}
	return vala_class_type_type_id;
}




