/* valaerrorcode.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valaerrorcode.h>
#include <vala/valaexpression.h>
#include <vala/valacodevisitor.h>
#include <vala/valaerrordomain.h>




struct _ValaErrorCodePrivate {
	ValaExpression* _value;
	char* cname;
};
#define VALA_ERROR_CODE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_ERROR_CODE, ValaErrorCodePrivate))
enum  {
	VALA_ERROR_CODE_DUMMY_PROPERTY,
	VALA_ERROR_CODE_VALUE
};
static void vala_error_code_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_error_code_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gpointer vala_error_code_parent_class = NULL;
static void vala_error_code_dispose (GObject * obj);



/**
 * Creates a new enum value.
 *
 * @param name enum value name
 * @return     newly created enum value
 */
ValaErrorCode* vala_error_code_new (const char* name) {
	ValaErrorCode * self;
	g_return_val_if_fail (name != NULL, NULL);
	self = g_object_newv (VALA_TYPE_ERROR_CODE, 0, NULL);
	vala_symbol_set_name (VALA_SYMBOL (self), name);
	return self;
}


/**
 * Creates a new enum value with the specified numerical representation.
 *
 * @param name  enum value name
 * @param value numerical representation
 * @return      newly created enum value
 */
ValaErrorCode* vala_error_code_new_with_value (const char* name, ValaExpression* value) {
	ValaErrorCode * self;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (VALA_IS_EXPRESSION (value), NULL);
	self = g_object_newv (VALA_TYPE_ERROR_CODE, 0, NULL);
	vala_symbol_set_name (VALA_SYMBOL (self), name);
	vala_error_code_set_value (self, value);
	return self;
}


static void vala_error_code_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaErrorCode * self;
	self = VALA_ERROR_CODE (base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	vala_code_visitor_visit_error_code (visitor, self);
}


static void vala_error_code_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaErrorCode * self;
	self = VALA_ERROR_CODE (base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	if (self->priv->_value != NULL) {
		vala_code_node_accept (VALA_CODE_NODE (self->priv->_value), visitor);
	}
}


/**
 * Returns the name of this error code as it is used in C code.
 *
 * @return the name to be used in C code
 */
char* vala_error_code_get_cname (ValaErrorCode* self) {
	const char* _tmp3;
	g_return_val_if_fail (VALA_IS_ERROR_CODE (self), NULL);
	if (self->priv->cname == NULL) {
		ValaErrorDomain* _tmp0;
		ValaErrorDomain* edomain;
		char* _tmp2;
		char* _tmp1;
		_tmp0 = NULL;
		edomain = (_tmp0 = VALA_ERROR_DOMAIN (vala_symbol_get_parent_symbol (VALA_SYMBOL (self))), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
		_tmp2 = NULL;
		_tmp1 = NULL;
		self->priv->cname = (_tmp2 = g_strdup_printf ("%s%s", (_tmp1 = vala_error_domain_get_cprefix (edomain)), vala_symbol_get_name (VALA_SYMBOL (self))), (self->priv->cname = (g_free (self->priv->cname), NULL)), _tmp2);
		_tmp1 = (g_free (_tmp1), NULL);
		(edomain == NULL ? NULL : (edomain = (g_object_unref (edomain), NULL)));
	}
	_tmp3 = NULL;
	return (_tmp3 = self->priv->cname, (_tmp3 == NULL ? NULL : g_strdup (_tmp3)));
}


ValaExpression* vala_error_code_get_value (ValaErrorCode* self) {
	g_return_val_if_fail (VALA_IS_ERROR_CODE (self), NULL);
	return self->priv->_value;
}


void vala_error_code_set_value (ValaErrorCode* self, ValaExpression* value) {
	ValaExpression* _tmp2;
	ValaExpression* _tmp1;
	g_return_if_fail (VALA_IS_ERROR_CODE (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_value = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_value == NULL ? NULL : (self->priv->_value = (g_object_unref (self->priv->_value), NULL))), _tmp2);
}


static void vala_error_code_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaErrorCode * self;
	self = VALA_ERROR_CODE (object);
	switch (property_id) {
		case VALA_ERROR_CODE_VALUE:
		g_value_set_object (value, vala_error_code_get_value (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_error_code_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaErrorCode * self;
	self = VALA_ERROR_CODE (object);
	switch (property_id) {
		case VALA_ERROR_CODE_VALUE:
		vala_error_code_set_value (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_error_code_class_init (ValaErrorCodeClass * klass) {
	vala_error_code_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaErrorCodePrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_error_code_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_error_code_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_error_code_dispose;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_error_code_real_accept;
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_error_code_real_accept_children;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_ERROR_CODE_VALUE, g_param_spec_object ("value", "value", "value", VALA_TYPE_EXPRESSION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_error_code_init (ValaErrorCode * self) {
	self->priv = VALA_ERROR_CODE_GET_PRIVATE (self);
}


static void vala_error_code_dispose (GObject * obj) {
	ValaErrorCode * self;
	self = VALA_ERROR_CODE (obj);
	(self->priv->_value == NULL ? NULL : (self->priv->_value = (g_object_unref (self->priv->_value), NULL)));
	self->priv->cname = (g_free (self->priv->cname), NULL);
	G_OBJECT_CLASS (vala_error_code_parent_class)->dispose (obj);
}


GType vala_error_code_get_type (void) {
	static GType vala_error_code_type_id = 0;
	if (G_UNLIKELY (vala_error_code_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaErrorCodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_error_code_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaErrorCode), 0, (GInstanceInitFunc) vala_error_code_init };
		vala_error_code_type_id = g_type_register_static (VALA_TYPE_SYMBOL, "ValaErrorCode", &g_define_type_info, 0);
	}
	return vala_error_code_type_id;
}




