/* valanulltype.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valanulltype.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valacodenode.h>
#include <vala/valapointertype.h>
#include <vala/valatypesymbol.h>
#include <vala/valaarraytype.h>
#include <vala/valadelegatetype.h>




enum  {
	VALA_NULL_TYPE_DUMMY_PROPERTY
};
static gboolean vala_null_type_real_compatible (ValaDataType* base, ValaDataType* target_type);
static ValaDataType* vala_null_type_real_copy (ValaDataType* base);
static gpointer vala_null_type_parent_class = NULL;



ValaNullType* vala_null_type_new (ValaSourceReference* source_reference) {
	ValaNullType * self;
	g_return_val_if_fail (VALA_IS_SOURCE_REFERENCE (source_reference), NULL);
	self = g_object_newv (VALA_TYPE_NULL_TYPE, 0, NULL);
	vala_code_node_set_source_reference (VALA_CODE_NODE (self), source_reference);
	return self;
}


static gboolean vala_null_type_real_compatible (ValaDataType* base, ValaDataType* target_type) {
	ValaNullType * self;
	ValaAttribute* _tmp1;
	gboolean _tmp2;
	self = VALA_NULL_TYPE (base);
	g_return_val_if_fail (VALA_IS_DATA_TYPE (target_type), FALSE);
	if (!(VALA_IS_POINTER_TYPE (target_type)) && (VALA_IS_NULL_TYPE (target_type) || (vala_data_type_get_data_type (target_type) == NULL && vala_data_type_get_type_parameter (target_type) == NULL))) {
		return TRUE;
	}
	/* null can be cast to any reference or array type or pointer type */
	_tmp1 = NULL;
	if ((_tmp2 = vala_data_type_get_type_parameter (target_type) != NULL || VALA_IS_POINTER_TYPE (target_type) || vala_data_type_get_nullable (target_type) || (_tmp1 = vala_code_node_get_attribute (VALA_CODE_NODE (vala_data_type_get_data_type (target_type)), "PointerType")) != NULL, (_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL))), _tmp2)) {
		return TRUE;
	}
	if (vala_typesymbol_is_reference_type (vala_data_type_get_data_type (target_type)) || VALA_IS_ARRAY_TYPE (target_type) || VALA_IS_DELEGATE_TYPE (target_type)) {
		return TRUE;
	}
	/* null is not compatible with any other type (i.e. value types) */
	return FALSE;
}


static ValaDataType* vala_null_type_real_copy (ValaDataType* base) {
	ValaNullType * self;
	self = VALA_NULL_TYPE (base);
	return VALA_DATA_TYPE (vala_null_type_new (vala_code_node_get_source_reference (VALA_CODE_NODE (self))));
}


static void vala_null_type_class_init (ValaNullTypeClass * klass) {
	vala_null_type_parent_class = g_type_class_peek_parent (klass);
	VALA_DATA_TYPE_CLASS (klass)->compatible = vala_null_type_real_compatible;
	VALA_DATA_TYPE_CLASS (klass)->copy = vala_null_type_real_copy;
}


static void vala_null_type_init (ValaNullType * self) {
}


GType vala_null_type_get_type (void) {
	static GType vala_null_type_type_id = 0;
	if (G_UNLIKELY (vala_null_type_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaNullTypeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_null_type_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaNullType), 0, (GInstanceInitFunc) vala_null_type_init };
		vala_null_type_type_id = g_type_register_static (VALA_TYPE_REFERENCE_TYPE, "ValaNullType", &g_define_type_info, 0);
	}
	return vala_null_type_type_id;
}




