/* valaccodeoncesection.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <ccode/valaccodeoncesection.h>
#include <ccode/valaccodelinedirective.h>
#include <ccode/valaccodenode.h>




struct _ValaCCodeOnceSectionPrivate {
	char* _define;
};
#define VALA_CCODE_ONCE_SECTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_ONCE_SECTION, ValaCCodeOnceSectionPrivate))
enum  {
	VALA_CCODE_ONCE_SECTION_DUMMY_PROPERTY,
	VALA_CCODE_ONCE_SECTION_DEFINE
};
static void vala_ccode_once_section_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static void vala_ccode_once_section_real_write_declaration (ValaCCodeNode* base, ValaCCodeWriter* writer);
static gpointer vala_ccode_once_section_parent_class = NULL;
static void vala_ccode_once_section_dispose (GObject * obj);



ValaCCodeOnceSection* vala_ccode_once_section_new (const char* def) {
	GParameter * __params;
	GParameter * __params_it;
	ValaCCodeOnceSection * self;
	g_return_val_if_fail (def != NULL, NULL);
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	__params_it->name = "define";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, def);
	__params_it++;
	self = g_object_newv (VALA_TYPE_CCODE_ONCE_SECTION, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


static void vala_ccode_once_section_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer) {
	ValaCCodeOnceSection * self;
	self = VALA_CCODE_ONCE_SECTION (base);
	g_return_if_fail (VALA_IS_CCODE_WRITER (writer));
	vala_ccode_writer_write_indent (writer, NULL);
	vala_ccode_writer_write_string (writer, "#ifndef ");
	vala_ccode_writer_write_string (writer, self->priv->_define);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_writer_write_string (writer, "#define ");
	vala_ccode_writer_write_string (writer, self->priv->_define);
	vala_ccode_writer_write_newline (writer);
	{
		GeeCollection* node_collection;
		GeeIterator* node_it;
		node_collection = vala_ccode_fragment_get_children (VALA_CCODE_FRAGMENT (self));
		node_it = gee_iterable_iterator (GEE_ITERABLE (node_collection));
		while (gee_iterator_next (node_it)) {
			ValaCCodeNode* node;
			node = ((ValaCCodeNode*) gee_iterator_get (node_it));
			{
				vala_ccode_node_write_combined (node, writer);
				(node == NULL ? NULL : (node = (g_object_unref (node), NULL)));
			}
		}
		(node_collection == NULL ? NULL : (node_collection = (g_object_unref (node_collection), NULL)));
		(node_it == NULL ? NULL : (node_it = (g_object_unref (node_it), NULL)));
	}
	vala_ccode_writer_write_indent (writer, NULL);
	vala_ccode_writer_write_string (writer, "#endif");
	vala_ccode_writer_write_newline (writer);
}


static void vala_ccode_once_section_real_write_declaration (ValaCCodeNode* base, ValaCCodeWriter* writer) {
	ValaCCodeOnceSection * self;
	self = VALA_CCODE_ONCE_SECTION (base);
	g_return_if_fail (VALA_IS_CCODE_WRITER (writer));
}


char* vala_ccode_once_section_get_define (ValaCCodeOnceSection* self) {
	g_return_val_if_fail (VALA_IS_CCODE_ONCE_SECTION (self), NULL);
	return self->priv->_define;
}


void vala_ccode_once_section_set_define (ValaCCodeOnceSection* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (VALA_IS_CCODE_ONCE_SECTION (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_define = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_strdup (_tmp1))), (self->priv->_define = (g_free (self->priv->_define), NULL)), _tmp2);
}


static void vala_ccode_once_section_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaCCodeOnceSection * self;
	self = VALA_CCODE_ONCE_SECTION (object);
	switch (property_id) {
		case VALA_CCODE_ONCE_SECTION_DEFINE:
		g_value_set_string (value, vala_ccode_once_section_get_define (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_once_section_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaCCodeOnceSection * self;
	self = VALA_CCODE_ONCE_SECTION (object);
	switch (property_id) {
		case VALA_CCODE_ONCE_SECTION_DEFINE:
		vala_ccode_once_section_set_define (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_once_section_class_init (ValaCCodeOnceSectionClass * klass) {
	vala_ccode_once_section_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCCodeOnceSectionPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_ccode_once_section_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_ccode_once_section_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_ccode_once_section_dispose;
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_once_section_real_write;
	VALA_CCODE_NODE_CLASS (klass)->write_declaration = vala_ccode_once_section_real_write_declaration;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_ONCE_SECTION_DEFINE, g_param_spec_string ("define", "define", "define", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void vala_ccode_once_section_init (ValaCCodeOnceSection * self) {
	self->priv = VALA_CCODE_ONCE_SECTION_GET_PRIVATE (self);
}


static void vala_ccode_once_section_dispose (GObject * obj) {
	ValaCCodeOnceSection * self;
	self = VALA_CCODE_ONCE_SECTION (obj);
	self->priv->_define = (g_free (self->priv->_define), NULL);
	G_OBJECT_CLASS (vala_ccode_once_section_parent_class)->dispose (obj);
}


GType vala_ccode_once_section_get_type (void) {
	static GType vala_ccode_once_section_type_id = 0;
	if (G_UNLIKELY (vala_ccode_once_section_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeOnceSectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_once_section_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeOnceSection), 0, (GInstanceInitFunc) vala_ccode_once_section_init };
		vala_ccode_once_section_type_id = g_type_register_static (VALA_TYPE_CCODE_FRAGMENT, "ValaCCodeOnceSection", &g_define_type_info, 0);
	}
	return vala_ccode_once_section_type_id;
}




