/* gstreamer-rtsp-0.10.vapi generated by lt-vapigen, do not modify. */

[CCode (cprefix = "Gst", lower_case_cprefix = "gst_")]
namespace Gst {
	[CCode (cprefix = "GST_RTSP_AUTH_", has_type_id = "0", cheader_filename = "gst/rtsp/gstrtspconnection.h")]
	public enum RTSPAuthMethod {
		NONE,
		BASIC,
		DIGEST
	}
	[CCode (cprefix = "GST_RTSP_FAM_", has_type_id = "0", cheader_filename = "gst/rtsp/gstrtspdefs.h")]
	public enum RTSPFamily {
		NONE,
		INET,
		INET6
	}
	[CCode (cprefix = "GST_RTSP_HDR_", has_type_id = "0", cheader_filename = "gst/rtsp/gstrtspdefs.h")]
	public enum RTSPHeaderField {
		INVALID,
		ACCEPT,
		ACCEPT_ENCODING,
		ACCEPT_LANGUAGE,
		ALLOW,
		AUTHORIZATION,
		BANDWIDTH,
		BLOCKSIZE,
		CACHE_CONTROL,
		CONFERENCE,
		CONNECTION,
		CONTENT_BASE,
		CONTENT_ENCODING,
		CONTENT_LANGUAGE,
		CONTENT_LENGTH,
		CONTENT_LOCATION,
		CONTENT_TYPE,
		CSEQ,
		DATE,
		EXPIRES,
		FROM,
		IF_MODIFIED_SINCE,
		LAST_MODIFIED,
		PROXY_AUTHENTICATE,
		PROXY_REQUIRE,
		PUBLIC,
		RANGE,
		REFERER,
		REQUIRE,
		RETRY_AFTER,
		RTP_INFO,
		SCALE,
		SESSION,
		SERVER,
		SPEED,
		TRANSPORT,
		UNSUPPORTED,
		USER_AGENT,
		VIA,
		WWW_AUTHENTICATE,
		CLIENT_CHALLENGE,
		REAL_CHALLENGE1,
		REAL_CHALLENGE2,
		REAL_CHALLENGE3,
		SUBSCRIBE,
		ALERT,
		CLIENT_ID,
		COMPANY_ID,
		GUID,
		REGION_DATA,
		MAX_ASM_WIDTH,
		LANGUAGE,
		PLAYER_START_TIME,
		LOCATION
	}
	[CCode (cprefix = "GST_RTSP_LOWER_TRANS_", has_type_id = "0", cheader_filename = "gst/rtsp/gstrtspextension.h")]
	public enum RTSPLowerTrans {
		UNKNOWN,
		UDP,
		UDP_MCAST,
		TCP
	}
	[CCode (cprefix = "GST_RTSP_MESSAGE_", has_type_id = "0", cheader_filename = "gst/rtsp/gstrtspmessage.h")]
	public enum RTSPMsgType {
		INVALID,
		REQUEST,
		RESPONSE,
		DATA
	}
	[CCode (cprefix = "GST_RTSP_PROFILE_", has_type_id = "0", cheader_filename = "gst/rtsp/gstrtsptransport.h")]
	public enum RTSPProfile {
		UNKNOWN,
		AVP,
		SAVP
	}
	[CCode (cprefix = "GST_RTSP_RANGE_", has_type_id = "0", cheader_filename = "gst/rtsp/gstrtsprange.h")]
	public enum RTSPRangeUnit {
		SMPTE,
		SMPTE_30_DROP,
		SMPTE_25,
		NPT,
		CLOCK
	}
	[CCode (cprefix = "GST_RTSP_", has_type_id = "0", cheader_filename = "gst/rtsp/gstrtspconnection.h")]
	public enum RTSPResult {
		OK,
		ERROR,
		EINVAL,
		EINTR,
		ENOMEM,
		ERESOLV,
		ENOTIMPL,
		ESYS,
		EPARSE,
		EWSASTART,
		EWSAVERSION,
		EEOF,
		ENET,
		ENOTIP,
		ETIMEOUT,
		ELAST
	}
	[CCode (cprefix = "GST_RTSP_STATE_", has_type_id = "0", cheader_filename = "gst/rtsp/gstrtspdefs.h")]
	public enum RTSPState {
		INVALID,
		INIT,
		READY,
		SEEKING,
		PLAYING,
		RECORDING
	}
	[CCode (cprefix = "GST_RTSP_STS_", has_type_id = "0", cheader_filename = "gst/rtsp/gstrtspdefs.h")]
	public enum RTSPStatusCode {
		INVALID,
		CONTINUE,
		OK,
		CREATED,
		LOW_ON_STORAGE,
		MULTIPLE_CHOICES,
		MOVED_PERMANENTLY,
		MOVE_TEMPORARILY,
		SEE_OTHER,
		NOT_MODIFIED,
		USE_PROXY,
		BAD_REQUEST,
		UNAUTHORIZED,
		PAYMENT_REQUIRED,
		FORBIDDEN,
		NOT_FOUND,
		METHOD_NOT_ALLOWED,
		NOT_ACCEPTABLE,
		PROXY_AUTH_REQUIRED,
		REQUEST_TIMEOUT,
		GONE,
		LENGTH_REQUIRED,
		PRECONDITION_FAILED,
		REQUEST_ENTITY_TOO_LARGE,
		REQUEST_URI_TOO_LARGE,
		UNSUPPORTED_MEDIA_TYPE,
		PARAMETER_NOT_UNDERSTOOD,
		CONFERENCE_NOT_FOUND,
		NOT_ENOUGH_BANDWIDTH,
		SESSION_NOT_FOUND,
		METHOD_NOT_VALID_IN_THIS_STATE,
		HEADER_FIELD_NOT_VALID_FOR_RESOURCE,
		INVALID_RANGE,
		PARAMETER_IS_READONLY,
		AGGREGATE_OPERATION_NOT_ALLOWED,
		ONLY_AGGREGATE_OPERATION_ALLOWED,
		UNSUPPORTED_TRANSPORT,
		DESTINATION_UNREACHABLE,
		INTERNAL_SERVER_ERROR,
		NOT_IMPLEMENTED,
		BAD_GATEWAY,
		SERVICE_UNAVAILABLE,
		GATEWAY_TIMEOUT,
		RTSP_VERSION_NOT_SUPPORTED,
		OPTION_NOT_SUPPORTED
	}
	[CCode (cprefix = "GST_RTSP_TIME_", has_type_id = "0", cheader_filename = "gst/rtsp/gstrtsprange.h")]
	public enum RTSPTimeType {
		SECONDS,
		NOW,
		END
	}
	[CCode (cprefix = "GST_RTSP_TRANS_", has_type_id = "0", cheader_filename = "gst/rtsp/gstrtsptransport.h")]
	public enum RTSPTransMode {
		UNKNOWN,
		RTP,
		RDT
	}
	[CCode (cprefix = "GST_RTSP_VERSION_", has_type_id = "0", cheader_filename = "gst/rtsp/gstrtspdefs.h")]
	public enum RTSPVersion {
		INVALID,
		1_0
	}
	[CCode (cprefix = "GST_RTSP_EV_", has_type_id = "0", cheader_filename = "gst/rtsp/gstrtspconnection.h")]
	[Flags]
	public enum RTSPEvent {
		READ,
		WRITE
	}
	[CCode (cprefix = "GST_RTSP_", has_type_id = "0", cheader_filename = "gst/rtsp/gstrtspdefs.h")]
	[Flags]
	public enum RTSPMethod {
		INVALID,
		DESCRIBE,
		ANNOUNCE,
		GET_PARAMETER,
		OPTIONS,
		PAUSE,
		PLAY,
		RECORD,
		REDIRECT,
		SETUP,
		SET_PARAMETER,
		TEARDOWN
	}
	[CCode (cheader_filename = "gst/rtsp/gstrtspconnection.h")]
	public class RTSPConnection {
		public weak Gst.RTSPUrl url;
		public int fd;
		[NoArrayLength]
		public int[] control_sock;
		public weak string ip;
		public int cseq;
		[NoArrayLength]
		public char[] session_id;
		public int timeout;
		public weak GLib.Timer timer;
		public Gst.RTSPAuthMethod auth_method;
		public weak string username;
		public weak string passwd;
		public Gst.RTSPResult close ();
		public Gst.RTSPResult connect (GLib.TimeVal timeout);
		public static Gst.RTSPResult create (Gst.RTSPUrl url, out weak Gst.RTSPConnection conn);
		public Gst.RTSPResult flush (bool flush);
		public Gst.RTSPResult next_timeout (GLib.TimeVal timeout);
		public Gst.RTSPResult poll (Gst.RTSPEvent events, Gst.RTSPEvent revents, GLib.TimeVal timeout);
		public Gst.RTSPResult read (uchar data, uint size, GLib.TimeVal timeout);
		public Gst.RTSPResult receive (Gst.RTSPMessage message, GLib.TimeVal timeout);
		public Gst.RTSPResult reset_timeout ();
		public Gst.RTSPResult send (Gst.RTSPMessage message, GLib.TimeVal timeout);
		public Gst.RTSPResult set_auth (Gst.RTSPAuthMethod method, string user, string pass);
		public Gst.RTSPResult write (uchar data, uint size, GLib.TimeVal timeout);
	}
	[CCode (cheader_filename = "gst/rtsp/gstrtspconnection.h")]
	public class RTSPMessage {
		public Gst.RTSPMsgType type;
		public void* type_data;
		public weak GLib.Array hdr_fields;
		public uchar body;
		public uint body_size;
		public Gst.RTSPResult add_header (Gst.RTSPHeaderField field, string value);
		public Gst.RTSPResult append_headers (GLib.StringBuilder str);
		public Gst.RTSPResult dump ();
		public Gst.RTSPResult get_body (uchar data, uint size);
		public Gst.RTSPResult get_header (Gst.RTSPHeaderField field, string value, int indx);
		public Gst.RTSPResult init ();
		public Gst.RTSPResult init_data (uchar channel);
		public Gst.RTSPResult init_request (Gst.RTSPMethod method, string uri);
		public Gst.RTSPResult init_response (Gst.RTSPStatusCode code, string reason, Gst.RTSPMessage request);
		public RTSPMessage (out weak Gst.RTSPMessage msg);
		public RTSPMessage.data (out weak Gst.RTSPMessage msg, uchar channel);
		public RTSPMessage.request (out weak Gst.RTSPMessage msg, Gst.RTSPMethod method, string uri);
		public RTSPMessage.response (out weak Gst.RTSPMessage msg, Gst.RTSPStatusCode code, string reason, Gst.RTSPMessage request);
		public Gst.RTSPResult parse_data (uchar channel);
		public Gst.RTSPResult parse_request (Gst.RTSPMethod method, string uri, Gst.RTSPVersion version);
		public Gst.RTSPResult parse_response (Gst.RTSPStatusCode code, string reason, Gst.RTSPVersion version);
		public Gst.RTSPResult remove_header (Gst.RTSPHeaderField field, int indx);
		public Gst.RTSPResult set_body (uchar data, uint size);
		public Gst.RTSPResult steal_body (uchar data, uint size);
		public Gst.RTSPResult take_body (uchar data, uint size);
		public Gst.RTSPResult unset ();
	}
	[CCode (cheader_filename = "gst/rtsp/gstrtsprange.h")]
	public class RTSPRange {
		public int min;
		public int max;
		public static Gst.RTSPResult parse (string rangestr, out weak Gst.RTSPTimeRange range);
	}
	[CCode (cheader_filename = "gst/rtsp/gstrtsprange.h")]
	public class RTSPTime {
		public Gst.RTSPTimeType type;
		public double seconds;
	}
	[CCode (cheader_filename = "gst/rtsp/gstrtsprange.h")]
	public class RTSPTimeRange {
		public Gst.RTSPRangeUnit unit;
		public weak Gst.RTSPTime min;
		public weak Gst.RTSPTime max;
	}
	[CCode (cheader_filename = "gst/rtsp/gstrtsptransport.h")]
	public class RTSPTransport {
		public Gst.RTSPTransMode trans;
		public Gst.RTSPProfile profile;
		public Gst.RTSPLowerTrans lower_transport;
		public weak string destination;
		public weak string source;
		public uint layers;
		public bool mode_play;
		public bool mode_record;
		public bool append;
		public weak Gst.RTSPRange interleaved;
		public uint ttl;
		public weak Gst.RTSPRange port;
		public weak Gst.RTSPRange client_port;
		public weak Gst.RTSPRange server_port;
		public uint ssrc;
		public weak string as_text ();
		public static Gst.RTSPResult get_manager (Gst.RTSPTransMode trans, string manager, uint option);
		public static Gst.RTSPResult get_mime (Gst.RTSPTransMode trans, string mime);
		public Gst.RTSPResult init ();
		public RTSPTransport (out weak Gst.RTSPTransport transport);
		public static Gst.RTSPResult parse (string str, Gst.RTSPTransport transport);
	}
	[CCode (cheader_filename = "gst/rtsp/gstrtspconnection.h")]
	public class RTSPUrl {
		public Gst.RTSPLowerTrans transports;
		public Gst.RTSPFamily family;
		public weak string user;
		public weak string passwd;
		public weak string host;
		public ushort port;
		public weak string abspath;
		public weak string query;
		public Gst.RTSPResult get_port (ushort port);
		public weak string get_request_uri ();
		public static Gst.RTSPResult parse (string urlstr, out weak Gst.RTSPUrl url);
		public Gst.RTSPResult set_port (ushort port);
	}
	[CCode (cheader_filename = "gst/rtsp/gstrtspextension.h")]
	public interface RTSPExtension {
		public abstract Gst.RTSPResult after_send (Gst.RTSPMessage req, Gst.RTSPMessage resp);
		public abstract Gst.RTSPResult before_send (Gst.RTSPMessage req);
		public abstract bool configure_stream (Gst.Caps caps);
		public abstract bool detect_server (Gst.RTSPMessage resp);
		public abstract Gst.RTSPResult get_transports (Gst.RTSPLowerTrans protocols, string transport);
		public abstract Gst.RTSPResult parse_sdp (Gst.SDPMessage sdp, Gst.Structure s);
		public abstract Gst.RTSPResult setup_media (Gst.SDPMedia media);
		public abstract Gst.RTSPResult stream_select (Gst.RTSPUrl url);
		[HasEmitter]
		public signal Gst.RTSPResult send (void* req, void* resp);
	}
	public const int RTSP_DEFAULT_PORT;
	[CCode (cheader_filename = "gst/gst.h")]
	public static void rtsp_base64_decode_ip (string data, ulong len);
	[CCode (cheader_filename = "gst/gst.h")]
	public static weak string rtsp_base64_encode (string data, ulong len);
	[CCode (cheader_filename = "gst/gst.h")]
	public static Gst.RTSPHeaderField rtsp_find_header_field (string header);
	[CCode (cheader_filename = "gst/gst.h")]
	public static Gst.RTSPMethod rtsp_find_method (string method);
	[CCode (cheader_filename = "gst/gst.h")]
	public static weak string rtsp_header_as_text (Gst.RTSPHeaderField field);
	[CCode (cheader_filename = "gst/gst.h")]
	public static weak string rtsp_method_as_text (Gst.RTSPMethod method);
	[CCode (cheader_filename = "gst/gst.h")]
	public static weak string rtsp_status_as_text (Gst.RTSPStatusCode code);
	[CCode (cheader_filename = "gst/gst.h")]
	public static weak string rtsp_strresult (Gst.RTSPResult _result);
	[CCode (cheader_filename = "gst/gst.h")]
	public static weak string rtsp_version_as_text (Gst.RTSPVersion version);
}
