/* valaccodeoncesection.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __CCODE_VALACCODEONCESECTION_H__
#define __CCODE_VALACCODEONCESECTION_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <ccode/valaccodefragment.h>
#include <ccode/valaccodewriter.h>

G_BEGIN_DECLS


#define VALA_TYPE_CCODE_ONCE_SECTION (vala_ccode_once_section_get_type ())
#define VALA_CCODE_ONCE_SECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_ONCE_SECTION, ValaCCodeOnceSection))
#define VALA_CCODE_ONCE_SECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_ONCE_SECTION, ValaCCodeOnceSectionClass))
#define VALA_IS_CCODE_ONCE_SECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_ONCE_SECTION))
#define VALA_IS_CCODE_ONCE_SECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_ONCE_SECTION))
#define VALA_CCODE_ONCE_SECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_ONCE_SECTION, ValaCCodeOnceSectionClass))

typedef struct _ValaCCodeOnceSection ValaCCodeOnceSection;
typedef struct _ValaCCodeOnceSectionClass ValaCCodeOnceSectionClass;
typedef struct _ValaCCodeOnceSectionPrivate ValaCCodeOnceSectionPrivate;

/**
 * Represents a section that should only to processed once.
 */
struct _ValaCCodeOnceSection {
	ValaCCodeFragment parent_instance;
	ValaCCodeOnceSectionPrivate * priv;
};

struct _ValaCCodeOnceSectionClass {
	ValaCCodeFragmentClass parent_class;
};


ValaCCodeOnceSection* vala_ccode_once_section_new (const char* def);
char* vala_ccode_once_section_get_define (ValaCCodeOnceSection* self);
void vala_ccode_once_section_set_define (ValaCCodeOnceSection* self, const char* value);
GType vala_ccode_once_section_get_type (void);


G_END_DECLS

#endif
