/* valadelegatetype.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valadelegatetype.h>
#include <gee/arraylist.h>
#include <vala/valasymbol.h>




struct _ValaDelegateTypePrivate {
	ValaDelegate* _delegate_symbol;
};

#define VALA_DELEGATE_TYPE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_DELEGATE_TYPE, ValaDelegateTypePrivate))
enum  {
	VALA_DELEGATE_TYPE_DUMMY_PROPERTY,
	VALA_DELEGATE_TYPE_DELEGATE_SYMBOL
};
static gboolean vala_delegate_type_real_is_invokable (ValaDataType* base);
static ValaDataType* vala_delegate_type_real_get_return_type (ValaDataType* base);
static GeeCollection* vala_delegate_type_real_get_parameters (ValaDataType* base);
static char* vala_delegate_type_real_to_string (ValaCodeNode* base);
static ValaDataType* vala_delegate_type_real_copy (ValaDataType* base);
static char* vala_delegate_type_real_get_cname (ValaDataType* base);
static GeeCollection* vala_delegate_type_real_get_symbols (ValaDataType* base);
static char* vala_delegate_type_real_get_type_id (ValaDataType* base);
static gpointer vala_delegate_type_parent_class = NULL;
static void vala_delegate_type_dispose (GObject * obj);



ValaDelegateType* vala_delegate_type_new (ValaDelegate* delegate_symbol) {
	ValaDelegateType * self;
	g_return_val_if_fail (VALA_IS_DELEGATE (delegate_symbol), NULL);
	self = g_object_newv (VALA_TYPE_DELEGATE_TYPE, 0, NULL);
	vala_delegate_type_set_delegate_symbol (self, delegate_symbol);
	return self;
}


static gboolean vala_delegate_type_real_is_invokable (ValaDataType* base) {
	ValaDelegateType * self;
	self = VALA_DELEGATE_TYPE (base);
	return TRUE;
}


static ValaDataType* vala_delegate_type_real_get_return_type (ValaDataType* base) {
	ValaDelegateType * self;
	ValaDataType* _tmp0;
	self = VALA_DELEGATE_TYPE (base);
	_tmp0 = NULL;
	return (_tmp0 = vala_delegate_get_return_type (self->priv->_delegate_symbol), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
}


static GeeCollection* vala_delegate_type_real_get_parameters (ValaDataType* base) {
	ValaDelegateType * self;
	self = VALA_DELEGATE_TYPE (base);
	return GEE_COLLECTION (vala_delegate_get_parameters (self->priv->_delegate_symbol));
}


static char* vala_delegate_type_real_to_string (ValaCodeNode* base) {
	ValaDelegateType * self;
	char* s;
	self = VALA_DELEGATE_TYPE (base);
	s = vala_symbol_get_full_name (VALA_SYMBOL (self->priv->_delegate_symbol));
	if (vala_data_type_get_nullable (VALA_DATA_TYPE (self))) {
		char* _tmp0;
		_tmp0 = NULL;
		s = (_tmp0 = g_strconcat (s, ("?"), NULL), (s = (g_free (s), NULL)), _tmp0);
	}
	return s;
}


static ValaDataType* vala_delegate_type_real_copy (ValaDataType* base) {
	ValaDelegateType * self;
	self = VALA_DELEGATE_TYPE (base);
	return VALA_DATA_TYPE (vala_delegate_type_new (self->priv->_delegate_symbol));
}


static char* vala_delegate_type_real_get_cname (ValaDataType* base) {
	ValaDelegateType * self;
	self = VALA_DELEGATE_TYPE (base);
	return vala_typesymbol_get_cname (VALA_TYPESYMBOL (self->priv->_delegate_symbol), FALSE);
}


static GeeCollection* vala_delegate_type_real_get_symbols (ValaDataType* base) {
	ValaDelegateType * self;
	GeeArrayList* symbols;
	self = VALA_DELEGATE_TYPE (base);
	symbols = gee_array_list_new (VALA_TYPE_SYMBOL, ((GBoxedCopyFunc) g_object_ref), g_object_unref, g_direct_equal);
	gee_collection_add (GEE_COLLECTION (symbols), self->priv->_delegate_symbol);
	return GEE_COLLECTION (symbols);
}


static char* vala_delegate_type_real_get_type_id (ValaDataType* base) {
	ValaDelegateType * self;
	self = VALA_DELEGATE_TYPE (base);
	return g_strdup ("G_TYPE_POINTER");
}


ValaDelegate* vala_delegate_type_get_delegate_symbol (ValaDelegateType* self) {
	g_return_val_if_fail (VALA_IS_DELEGATE_TYPE (self), NULL);
	return self->priv->_delegate_symbol;
}


void vala_delegate_type_set_delegate_symbol (ValaDelegateType* self, ValaDelegate* value) {
	ValaDelegate* _tmp2;
	ValaDelegate* _tmp1;
	g_return_if_fail (VALA_IS_DELEGATE_TYPE (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_delegate_symbol = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_delegate_symbol == NULL ? NULL : (self->priv->_delegate_symbol = (g_object_unref (self->priv->_delegate_symbol), NULL))), _tmp2);
}


static void vala_delegate_type_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaDelegateType * self;
	self = VALA_DELEGATE_TYPE (object);
	switch (property_id) {
		case VALA_DELEGATE_TYPE_DELEGATE_SYMBOL:
		g_value_set_object (value, vala_delegate_type_get_delegate_symbol (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_delegate_type_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaDelegateType * self;
	self = VALA_DELEGATE_TYPE (object);
	switch (property_id) {
		case VALA_DELEGATE_TYPE_DELEGATE_SYMBOL:
		vala_delegate_type_set_delegate_symbol (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_delegate_type_class_init (ValaDelegateTypeClass * klass) {
	vala_delegate_type_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaDelegateTypePrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_delegate_type_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_delegate_type_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_delegate_type_dispose;
	VALA_DATA_TYPE_CLASS (klass)->is_invokable = vala_delegate_type_real_is_invokable;
	VALA_DATA_TYPE_CLASS (klass)->get_return_type = vala_delegate_type_real_get_return_type;
	VALA_DATA_TYPE_CLASS (klass)->get_parameters = vala_delegate_type_real_get_parameters;
	VALA_CODE_NODE_CLASS (klass)->to_string = vala_delegate_type_real_to_string;
	VALA_DATA_TYPE_CLASS (klass)->copy = vala_delegate_type_real_copy;
	VALA_DATA_TYPE_CLASS (klass)->get_cname = vala_delegate_type_real_get_cname;
	VALA_DATA_TYPE_CLASS (klass)->get_symbols = vala_delegate_type_real_get_symbols;
	VALA_DATA_TYPE_CLASS (klass)->get_type_id = vala_delegate_type_real_get_type_id;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_DELEGATE_TYPE_DELEGATE_SYMBOL, g_param_spec_object ("delegate-symbol", "delegate-symbol", "delegate-symbol", VALA_TYPE_DELEGATE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_delegate_type_init (ValaDelegateType * self) {
	self->priv = VALA_DELEGATE_TYPE_GET_PRIVATE (self);
}


static void vala_delegate_type_dispose (GObject * obj) {
	ValaDelegateType * self;
	self = VALA_DELEGATE_TYPE (obj);
	(self->priv->_delegate_symbol == NULL ? NULL : (self->priv->_delegate_symbol = (g_object_unref (self->priv->_delegate_symbol), NULL)));
	G_OBJECT_CLASS (vala_delegate_type_parent_class)->dispose (obj);
}


GType vala_delegate_type_get_type (void) {
	static GType vala_delegate_type_type_id = 0;
	if (G_UNLIKELY (vala_delegate_type_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaDelegateTypeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_delegate_type_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaDelegateType), 0, (GInstanceInitFunc) vala_delegate_type_init };
		vala_delegate_type_type_id = g_type_register_static (VALA_TYPE_DATA_TYPE, "ValaDelegateType", &g_define_type_info, 0);
	}
	return vala_delegate_type_type_id;
}




